import{s as lt,o as it,n as rt}from"../chunks/scheduler.01eeda35.js";import{S as ct,i as dt,g as r,s as o,r as f,A as pt,h as l,f as n,c as s,j as re,u as T,x as p,k as oe,y as m,a,v as b,d as y,t as w,w as _}from"../chunks/index.6dd51b66.js";import{T as st}from"../chunks/Tip.de9bae2b.js";import{D as We}from"../chunks/Docstring.cb556860.js";import{C as Ee}from"../chunks/CodeBlock.19ec9b8c.js";import{H as le,E as mt}from"../chunks/index.58fe8f9d.js";function ut(Y){let i,v="This model is in maintenance mode only, we don’t accept any new PRs changing its code.",u,h,M=`If you run into any issues running this model, please reinstall the last version that supported this model: v4.30.0.
You can do so by running the following command: <code>pip install -U transformers==4.30.0</code>.`;return{c(){i=r("p"),i.textContent=v,u=o(),h=r("p"),h.innerHTML=M},l(g){i=l(g,"P",{"data-svelte-h":!0}),p(i)!=="svelte-1dwyvn5"&&(i.textContent=v),u=s(g),h=l(g,"P",{"data-svelte-h":!0}),p(h)!=="svelte-4042uy"&&(h.innerHTML=M)},m(g,k){a(g,i,k),a(g,u,k),a(g,h,k)},p:rt,d(g){g&&(n(i),n(u),n(h))}}}function ht(Y){let i,v=`TAPEX architecture is the same as BART, except for tokenization. Refer to <a href="bart">BART documentation</a> for information on
configuration classes and their parameters. TAPEX-specific tokenizer is documented below.`;return{c(){i=r("p"),i.innerHTML=v},l(u){i=l(u,"P",{"data-svelte-h":!0}),p(i)!=="svelte-uw6xt6"&&(i.innerHTML=v)},m(u,h){a(u,i,h)},p:rt,d(u){u&&n(i)}}}function gt(Y){let i,v,u,h,M,g,k,Ne=`<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="TensorFlow" src="https://img.shields.io/badge/TensorFlow-FF6F00?style=flat&amp;logo=tensorflow&amp;logoColor=white"/> <img alt="Flax" src="https://img.shields.io/badge/Flax-29a79b.svg?style=flat&amp;logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAC0AAAAtCAMAAAANxBKoAAAC7lBMVEUAAADg5vYHPVgAoJH+/v76+v39/f9JbLP///9+AIgAnY3///+mcqzt8fXy9fgkXa3Ax9709fr+///9/f8qXq49qp5AaLGMwrv8/P0eW60VWawxYq8yqJzG2dytt9Wyu9elzci519Lf3O3S2efY3OrY0+Xp7PT///////+dqNCexMc6Z7AGpJeGvbenstPZ5ejQ1OfJzOLa7ejh4+/r8fT29vpccbklWK8PVa0AS6ghW63O498vYa+lsdKz1NDRt9Kw1c672tbD3tnAxt7R6OHp5vDe7OrDyuDn6vLl6/EAQKak0MgATakkppo3ZK/Bz9y8w9yzu9jey97axdvHzeG21NHH4trTwthKZrVGZLSUSpuPQJiGAI+GAI8SWKydycLL4d7f2OTi1+S9xNzL0ePT6OLGzeEAo5U0qJw/aLEAo5JFa7JBabEAp5Y4qZ2QxLyKmsm3kL2xoMOehrRNb7RIbbOZgrGre68AUqwAqZqNN5aKJ5N/lMq+qsd8kMa4pcWzh7muhLMEV69juq2kbKqgUaOTR5uMMZWLLZSGAI5VAIdEAH+ovNDHuNCnxcy3qcaYx8K8msGplrx+wLahjbYdXrV6vbMvYK9DrZ8QrZ8tqJuFms+Sos6sw8ecy8RffsNVeMCvmb43aLltv7Q4Y7EZWK4QWa1gt6meZKUdr6GOAZVeA4xPAISyveLUwtivxtKTpNJ2jcqfvcltiMiwwcfAoMVxhL+Kx7xjdrqTe60tsaNQs6KaRKACrJ6UTZwkqpqTL5pkHY4AloSgsd2ptNXPvNOOncuxxsqFl8lmg8apt8FJcr9EbryGxLqlkrkrY7dRa7ZGZLQ5t6iXUZ6PPpgVpZeJCJFKAIGareTa0+KJod3H0deY2M+esM25usmYu8d2zsJOdcBVvrCLbqcAOaaHaKQAMaScWqKBXqCXMJ2RHpiLF5NmJZAdAHN2kta11dKu1M+DkcZLdb+Mcql3TppyRJdzQ5ZtNZNlIY+DF4+voCOQAAAAZ3RSTlMABAT+MEEJ/RH+/TP+Zlv+pUo6Ifz8+fco/fz6+evr39S9nJmOilQaF/7+/f38+smmoYp6b1T+/v7++vj189zU0tDJxsGzsrKSfv34+Pf27dDOysG9t6+n/vv6+vr59uzr1tG+tZ6Qg9Ym3QAABR5JREFUSMeNlVVUG1EQhpcuxEspXqS0SKEtxQp1d3d332STTRpIQhIISQgJhODu7lAoDoUCpe7u7u7+1puGpqnCPOyZvffbOXPm/PsP9JfQgyCC+tmTABTOcbxDz/heENS7/1F+9nhvkHePG0wNDLbGWwdXL+rbLWvpmZHXD8+gMfBjTh+aSe6Gnn7lwQIOTR0c8wfX3PWgv7avbdKwf/ZoBp1Gp/PvuvXW3vw5ib7emnTW4OR+3D4jB9vjNJ/7gNvfWWeH/TO/JyYrsiKCRjVEZA3UB+96kON+DxOQ/NLE8PE5iUYgIXjFnCOlxEQMaSGVxjg4gxOnEycGz8bptuNjVx08LscIgrzH3umcn+KKtiBIyvzOO2O99aAdR8cF19oZalnCtvREUw79tCd5sow1g1UKM6kXqUx4T8wsi3sTjJ3yzDmmhenLXLpo8u45eG5y4Vvbk6kkC4LLtJMowkSQxmk4ggVJEG+7c6QpHT8vvW9X7/o7+3ELmiJi2mEzZJiz8cT6TBlanBk70cB5GGIGC1gRDdZ00yADLW1FL6gqhtvNXNG5S9gdSrk4M1qu7JAsmYshzDS4peoMrU/gT7qQdqYGZaYhxZmVbGJAm/CS/HloWyhRUlknQ9KYcExTwS80d3VNOxUZJpITYyspl0LbhArhpZCD9cRWEQuhYkNGMHToQ/2Cs6swJlb39CsllxdXX6IUKh/H5jbnSsPKjgmoaFQ1f8wRLR0UnGE/RcDEjj2jXG1WVTwUs8+zxfcrVO+vSsuOpVKxCfYZiQ0/aPKuxQbQ8lIz+DClxC8u+snlcJ7Yr1z1JPqUH0V+GDXbOwAib931Y4Imaq0NTIXPXY+N5L18GJ37SVWu+hwXff8l72Ds9XuwYIBaXPq6Shm4l+Vl/5QiOlV+uTk6YR9PxKsI9xNJny31ygK1e+nIRC1N97EGkFPI+jCpiHe5PCEy7oWqWSwRrpOvhFzcbTWMbm3ZJAOn1rUKpYIt/lDhW/5RHHteeWFN60qo98YJuoq1nK3uW5AabyspC1BcIEpOhft+SZAShYoLSvnmSfnYADUERP5jJn2h5XtsgCRuhYQqAvwTwn33+YWEKUI72HX5AtfSAZDe8F2DtPPm77afhl0EkthzuCQU0BWApgQIH9+KB0JhopMM7bJrdTRoleM2JAVNMyPF+wdoaz+XJpGoVAQ7WXUkcV7gT3oUZyi/ISIJAVKhgNp+4b4veCFhYVJw4locdSjZCp9cPUhLF9EZ3KKzURepMEtCDPP3VcWFx4UIiZIklIpFNfHpdEafIF2aRmOcrUmjohbT2WUllbmRvgfbythbQO3222fpDJoufaQPncYYuqoGtUEsCJZL6/3PR5b4syeSjZMQG/T2maGANlXT2v8S4AULWaUkCxfLyW8iW4kdka+nEMjxpL2NCwsYNBp+Q61PF43zyDg9Bm9+3NNySn78jMZUUkumqE4Gp7JmFOdP1vc8PpRrzj9+wPinCy8K1PiJ4aYbnTYpCCbDkBSbzhu2QJ1Gd82t8jI8TH51+OzvXoWbnXUOBkNW+0mWFwGcGOUVpU81/n3TOHb5oMt2FgYGjzau0Nif0Ss7Q3XB33hjjQHjHA5E5aOyIQc8CBrLdQSs3j92VG+3nNEjbkbdbBr9zm04ruvw37vh0QKOdeGIkckc80fX3KH/h7PT4BOjgCty8VZ5ux1MoO5Cf5naca2LAsEgehI+drX8o/0Nu+W0m6K/I9gGPd/dfx/EN/wN62AhsBWuAAAAAElFTkSuQmCC
"/>`,ie,x,ce,U,de,q,Fe=`The TAPEX model was proposed in <a href="https://arxiv.org/abs/2107.07653" rel="nofollow">TAPEX: Table Pre-training via Learning a Neural SQL Executor</a> by Qian Liu,
Bei Chen, Jiaqi Guo, Morteza Ziyadi, Zeqi Lin, Weizhu Chen, Jian-Guang Lou. TAPEX pre-trains a BART model to solve synthetic SQL queries, after
which it can be fine-tuned to answer natural language questions related to tabular data, as well as performing table fact checking.`,pe,Z,Se="TAPEX has been fine-tuned on several datasets:",me,I,$e='<li><a href="https://www.microsoft.com/en-us/download/details.aspx?id=54253" rel="nofollow">SQA</a> (Sequential Question Answering by Microsoft)</li> <li><a href="https://github.com/ppasupat/WikiTableQuestions" rel="nofollow">WTQ</a> (Wiki Table Questions by Stanford University)</li> <li><a href="https://github.com/salesforce/WikiSQL" rel="nofollow">WikiSQL</a> (by Salesforce)</li> <li><a href="https://tabfact.github.io/" rel="nofollow">TabFact</a> (by USCB NLP Lab).</li>',ue,z,Qe="The abstract from the paper is the following:",he,C,Pe=`<em>Recent progress in language model pre-training has achieved a great success via leveraging large-scale unstructured textual data. However, it is
still a challenge to apply pre-training on structured tabular data due to the absence of large-scale high-quality tabular data. In this paper, we
propose TAPEX to show that table pre-training can be achieved by learning a neural SQL executor over a synthetic corpus, which is obtained by automatically
synthesizing executable SQL queries and their execution outputs. TAPEX addresses the data scarcity challenge via guiding the language model to mimic a SQL
executor on the diverse, large-scale and high-quality synthetic corpus. We evaluate TAPEX on four benchmark datasets. Experimental results demonstrate that
TAPEX outperforms previous table pre-training approaches by a large margin and achieves new state-of-the-art results on all of them. This includes improvements
on the weakly-supervised WikiSQL denotation accuracy to 89.5% (+2.3%), the WikiTableQuestions denotation accuracy to 57.5% (+4.8%), the SQA denotation accuracy
to 74.5% (+3.5%), and the TabFact accuracy to 84.2% (+3.2%). To our knowledge, this is the first work to exploit table pre-training via synthetic executable programs
and to achieve new state-of-the-art results on various downstream tasks.</em>`,ge,A,fe,G,Ve=`<li>TAPEX is a generative (seq2seq) model. One can directly plug in the weights of TAPEX into a BART model.</li> <li>TAPEX has checkpoints on the hub that are either pre-trained only, or fine-tuned on WTQ, SQA, WikiSQL and TabFact.</li> <li>Sentences + tables are presented to the model as <code>sentence + &quot; &quot; + linearized table</code>. The linearized table has the following format:
<code>col: col1 | col2 | col 3 row 1 : val1 | val2 | val3 row 2 : ...</code>.</li> <li>TAPEX has its own tokenizer, that allows to prepare all data for the model easily. One can pass Pandas DataFrames and strings to the tokenizer,
and it will automatically create the <code>input_ids</code> and <code>attention_mask</code> (as shown in the usage examples below).</li>`,Te,X,be,B,Le=`Below, we illustrate how to use TAPEX for table question answering. As one can see, one can directly plug in the weights of TAPEX into a BART model.
We use the <a href="auto">Auto API</a>, which will automatically instantiate the appropriate tokenizer (<a href="/docs/transformers/main/en/model_doc/tapex#transformers.TapexTokenizer">TapexTokenizer</a>) and model (<a href="/docs/transformers/main/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a>) for us,
based on the configuration file of the checkpoint on the hub.`,ye,R,we,W,Ye=`Note that <a href="/docs/transformers/main/en/model_doc/tapex#transformers.TapexTokenizer">TapexTokenizer</a> also supports batched inference. Hence, one can provide a batch of different tables/questions, or a batch of a single table
and multiple questions, or a batch of a single query and multiple tables. Let’s illustrate this:`,_e,E,ke,N,He=`In case one wants to do table verification (i.e. the task of determining whether a given sentence is supported or refuted by the contents
of a table), one can instantiate a <a href="/docs/transformers/main/en/model_doc/bart#transformers.BartForSequenceClassification">BartForSequenceClassification</a> model. TAPEX has checkpoints on the hub fine-tuned on TabFact, an important
benchmark for table fact checking (it achieves 84% accuracy). The code example below again leverages the <a href="auto">Auto API</a>.`,ve,F,Me,j,xe,S,je,c,$,Ze,H,De="Construct a TAPEX tokenizer. Based on byte-level Byte-Pair-Encoding (BPE).",Ie,D,Oe=`This tokenizer can be used to flatten one or more table(s) and concatenate them with one or more related sentences
to be used by TAPEX models. The format that the TAPEX tokenizer creates is the following:`,ze,O,Ke="sentence col: col1 | col2 | col 3 row 1 : val1 | val2 | val3 row 2 : …",Ce,K,et=`The tokenizer supports a single table + single query, a single table and multiple queries (in which case the table
will be duplicated for every query), a single query and multiple tables (in which case the query will be duplicated
for every table), and multiple tables and queries. In other words, you can provide a batch of tables + questions to
the tokenizer for instance to prepare them for the model.`,Ae,ee,tt="Tokenization itself is based on the BPE algorithm. It is identical to the one used by BART, RoBERTa and GPT-2.",Ge,te,nt=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Xe,J,Q,Be,ne,at="Main method to tokenize and prepare for the model one or several table-sequence pair(s).",Re,ae,P,Je,V,Ue,se,qe;return M=new le({props:{title:"TAPEX",local:"tapex",headingTag:"h1"}}),x=new st({props:{warning:!0,$$slots:{default:[ut]},$$scope:{ctx:Y}}}),U=new le({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new le({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),X=new le({props:{title:"Usage: inference",local:"usage-inference",headingTag:"h3"}}),R=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGdGFwZXgtbGFyZ2UtZmluZXR1bmVkLXd0cSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGdGFwZXgtbGFyZ2UtZmluZXR1bmVkLXd0cSUyMiklMEElMEElMjMlMjBwcmVwYXJlJTIwdGFibGUlMjAlMkIlMjBxdWVzdGlvbiUwQWRhdGElMjAlM0QlMjAlN0IlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEFxdWVzdGlvbiUyMCUzRCUyMCUyMmhvdyUyMG1hbnklMjBtb3ZpZXMlMjBkb2VzJTIwTGVvbmFyZG8lMjBEaSUyMENhcHJpbyUyMGhhdmUlM0YlMjIlMEElMEFlbmNvZGluZyUyMCUzRCUyMHRva2VuaXplcih0YWJsZSUyQyUyMHF1ZXN0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBsZXQlMjB0aGUlMjBtb2RlbCUyMGdlbmVyYXRlJTIwYW4lMjBhbnN3ZXIlMjBhdXRvcmVncmVzc2l2ZWx5JTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RpbmcpJTBBJTBBJTIzJTIwZGVjb2RlJTIwYmFjayUyMHRvJTIwdGV4dCUwQXByZWRpY3RlZF9hbnN3ZXIlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBcHJpbnQocHJlZGljdGVkX2Fuc3dlcik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/tapex-large-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;microsoft/tapex-large-finetuned-wtq&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare table + question</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>], <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;how many movies does Leonardo Di Caprio have?&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(table, question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let the model generate an answer autoregressively</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**encoding)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># decode back to text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_answer = tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(predicted_answer)
<span class="hljs-number">53</span>`,wrap:!1}}),E=new Ee({props:{code:"JTIzJTIwcHJlcGFyZSUyMHRhYmxlJTIwJTJCJTIwcXVlc3Rpb24lMEFkYXRhJTIwJTNEJTIwJTdCJTIyQWN0b3JzJTIyJTNBJTIwJTVCJTIyQnJhZCUyMFBpdHQlMjIlMkMlMjAlMjJMZW9uYXJkbyUyMERpJTIwQ2FwcmlvJTIyJTJDJTIwJTIyR2VvcmdlJTIwQ2xvb25leSUyMiU1RCUyQyUyMCUyMk51bWJlciUyMG9mJTIwbW92aWVzJTIyJTNBJTIwJTVCJTIyODclMjIlMkMlMjAlMjI1MyUyMiUyQyUyMCUyMjY5JTIyJTVEJTdEJTBBdGFibGUlMjAlM0QlMjBwZC5EYXRhRnJhbWUuZnJvbV9kaWN0KGRhdGEpJTBBcXVlc3Rpb25zJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyaG93JTIwbWFueSUyMG1vdmllcyUyMGRvZXMlMjBMZW9uYXJkbyUyMERpJTIwQ2FwcmlvJTIwaGF2ZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMndoaWNoJTIwYWN0b3IlMjBoYXMlMjA2OSUyMG1vdmllcyUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMndoYXQncyUyMHRoZSUyMGZpcnN0JTIwbmFtZSUyMG9mJTIwdGhlJTIwYWN0b3IlMjB3aG8lMjBoYXMlMjA4NyUyMG1vdmllcyUzRiUyMiUyQyUwQSU1RCUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyKHRhYmxlJTJDJTIwcXVlc3Rpb25zJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMGxldCUyMHRoZSUyMG1vZGVsJTIwZ2VuZXJhdGUlMjBhbiUyMGFuc3dlciUyMGF1dG9yZWdyZXNzaXZlbHklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiplbmNvZGluZyklMEElMEElMjMlMjBkZWNvZGUlMjBiYWNrJTIwdG8lMjB0ZXh0JTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare table + question</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>], <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>questions = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;how many movies does Leonardo Di Caprio have?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;which actor has 69 movies?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;what&#x27;s the first name of the actor who has 87 movies?&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(table, questions, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let the model generate an answer autoregressively</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**encoding)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># decode back to text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27; 53&#x27;</span>, <span class="hljs-string">&#x27; george clooney&#x27;</span>, <span class="hljs-string">&#x27; brad pitt&#x27;</span>]`,wrap:!1}}),F=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGdGFwZXgtbGFyZ2UtZmluZXR1bmVkLXRhYmZhY3QlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZ0YXBleC1sYXJnZS1maW5ldHVuZWQtdGFiZmFjdCUyMiklMEElMEElMjMlMjBwcmVwYXJlJTIwdGFibGUlMjAlMkIlMjBzZW50ZW5jZSUwQWRhdGElMjAlM0QlMjAlN0IlMjJBY3RvcnMlMjIlM0ElMjAlNUIlMjJCcmFkJTIwUGl0dCUyMiUyQyUyMCUyMkxlb25hcmRvJTIwRGklMjBDYXByaW8lMjIlMkMlMjAlMjJHZW9yZ2UlMjBDbG9vbmV5JTIyJTVEJTJDJTIwJTIyTnVtYmVyJTIwb2YlMjBtb3ZpZXMlMjIlM0ElMjAlNUIlMjI4NyUyMiUyQyUyMCUyMjUzJTIyJTJDJTIwJTIyNjklMjIlNUQlN0QlMEF0YWJsZSUyMCUzRCUyMHBkLkRhdGFGcmFtZS5mcm9tX2RpY3QoZGF0YSklMEFzZW50ZW5jZSUyMCUzRCUyMCUyMkdlb3JnZSUyMENsb29uZXklMjBoYXMlMjAzMCUyMG1vdmllcyUyMiUwQSUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyKHRhYmxlJTJDJTIwc2VudGVuY2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqZW5jb2RpbmcpJTBBJTBBJTIzJTIwcHJpbnQlMjBwcmVkaWN0aW9uJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMG91dHB1dHMubG9naXRzJTVCMCU1RC5hcmdtYXgoZGltJTNEMCkuaXRlbSgpJTBBcHJpbnQobW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/tapex-large-finetuned-tabfact&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/tapex-large-finetuned-tabfact&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare table + sentence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;Actors&quot;</span>: [<span class="hljs-string">&quot;Brad Pitt&quot;</span>, <span class="hljs-string">&quot;Leonardo Di Caprio&quot;</span>, <span class="hljs-string">&quot;George Clooney&quot;</span>], <span class="hljs-string">&quot;Number of movies&quot;</span>: [<span class="hljs-string">&quot;87&quot;</span>, <span class="hljs-string">&quot;53&quot;</span>, <span class="hljs-string">&quot;69&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pd.DataFrame.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>sentence = <span class="hljs-string">&quot;George Clooney has 30 movies&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(table, sentence, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**encoding)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># print prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = outputs.logits[<span class="hljs-number">0</span>].argmax(dim=<span class="hljs-number">0</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_class_idx])
Refused`,wrap:!1}}),j=new st({props:{$$slots:{default:[ht]},$$scope:{ctx:Y}}}),S=new le({props:{title:"TapexTokenizer",local:"transformers.TapexTokenizer",headingTag:"h2"}}),$=new We({props:{name:"class transformers.TapexTokenizer",anchor:"transformers.TapexTokenizer",parameters:[{name:"vocab_file",val:""},{name:"merges_file",val:""},{name:"do_lower_case",val:" = True"},{name:"errors",val:" = 'replace'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"cls_token",val:" = '<s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"mask_token",val:" = '<mask>'"},{name:"add_prefix_space",val:" = False"},{name:"max_cell_length",val:" = 15"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TapexTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.TapexTokenizer.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.TapexTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.TapexTokenizer.errors",description:`<strong>errors</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;replace&quot;</code>) &#x2014;
Paradigm to follow when decoding bytes to UTF-8. See
<a href="https://docs.python.org/3/library/stdtypes.html#bytes.decode" rel="nofollow">bytes.decode</a> for more information.`,name:"errors"},{anchor:"transformers.TapexTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.TapexTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.TapexTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.TapexTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.TapexTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.TapexTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.TapexTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;mask&gt;&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.TapexTokenizer.add_prefix_space",description:`<strong>add_prefix_space</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an initial space to the input. This allows to treat the leading word just as any
other word. (BART tokenizer detect beginning of words by the preceding space).`,name:"add_prefix_space"},{anchor:"transformers.TapexTokenizer.max_cell_length",description:`<strong>max_cell_length</strong> (<code>int</code>, <em>optional</em>, defaults to 15) &#x2014;
Maximum number of characters per cell when linearizing a table. If this number is exceeded, truncation
takes place.`,name:"max_cell_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/tapex/tokenization_tapex.py#L177"}}),Q=new We({props:{name:"__call__",anchor:"transformers.TapexTokenizer.__call__",parameters:[{name:"table",val:": typing.Union[ForwardRef('pd.DataFrame'), typing.List[ForwardRef('pd.DataFrame')]] = None"},{name:"query",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"answer",val:": typing.Union[str, typing.List[str]] = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": typing.Union[bool, str, transformers.utils.generic.PaddingStrategy] = False"},{name:"truncation",val:": typing.Union[bool, str, transformers.tokenization_utils_base.TruncationStrategy] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"stride",val:": int = 0"},{name:"pad_to_multiple_of",val:": typing.Optional[int] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"return_token_type_ids",val:": typing.Optional[bool] = None"},{name:"return_attention_mask",val:": typing.Optional[bool] = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TapexTokenizer.__call__.table",description:`<strong>table</strong> (<code>pd.DataFrame</code>, <code>List[pd.DataFrame]</code>) &#x2014;
Table(s) containing tabular data.`,name:"table"},{anchor:"transformers.TapexTokenizer.__call__.query",description:`<strong>query</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Sentence or batch of sentences related to one or more table(s) to be encoded. Note that the number of
sentences must match the number of tables.`,name:"query"},{anchor:"transformers.TapexTokenizer.__call__.answer",description:`<strong>answer</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Optionally, the corresponding answer to the questions as supervision.`,name:"answer"},{anchor:"transformers.TapexTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add special tokens when encoding the sequences. This will use the underlying
<code>PretrainedTokenizerBase.build_inputs_with_special_tokens</code> function, which defines which tokens are
automatically added to the input ids. This is useful if you want to add <code>bos</code> or <code>eos</code> tokens
automatically.`,name:"add_special_tokens"},{anchor:"transformers.TapexTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.TapexTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.TapexTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.TapexTokenizer.__call__.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.TapexTokenizer.__call__.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.TapexTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. Requires <code>padding</code> to be activated.
This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.TapexTokenizer.__call__.padding_side",description:`<strong>padding_side</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The side on which the model should have padding applied. Should be selected between [&#x2018;right&#x2019;, &#x2018;left&#x2019;].
Default value is picked from the class attribute of the same name.`,name:"padding_side"},{anchor:"transformers.TapexTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.TapexTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to encode the sequences with the special tokens relative to their model.`,name:"add_special_tokens"},{anchor:"transformers.TapexTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.TapexTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code>, <code>TapexTruncationStrategy</code> or <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, &#x2014;
<em>optional</em>, defaults to <code>False</code>):</p>
<p>Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>&apos;drop_rows_to_fit&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will truncate
row by row, removing rows from the table.</li>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.TapexTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters. If left unset or set to
<code>None</code>, this will use the predefined model maximum length if a maximum length is required by one of the
truncation/padding parameters. If the model has no specific maximum input length (like XLNet)
truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.TapexTokenizer.__call__.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.TapexTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. This is especially useful to enable
the use of Tensor Cores on NVIDIA hardware with compute capability <code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.TapexTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/tapex/tokenization_tapex.py#L495"}}),P=new We({props:{name:"save_vocabulary",anchor:"transformers.TapexTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/tapex/tokenization_tapex.py#L466"}}),V=new mt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/tapex.md"}}),{c(){i=r("meta"),v=o(),u=r("p"),h=o(),f(M.$$.fragment),g=o(),k=r("div"),k.innerHTML=Ne,ie=o(),f(x.$$.fragment),ce=o(),f(U.$$.fragment),de=o(),q=r("p"),q.innerHTML=Fe,pe=o(),Z=r("p"),Z.textContent=Se,me=o(),I=r("ul"),I.innerHTML=$e,ue=o(),z=r("p"),z.textContent=Qe,he=o(),C=r("p"),C.innerHTML=Pe,ge=o(),f(A.$$.fragment),fe=o(),G=r("ul"),G.innerHTML=Ve,Te=o(),f(X.$$.fragment),be=o(),B=r("p"),B.innerHTML=Le,ye=o(),f(R.$$.fragment),we=o(),W=r("p"),W.innerHTML=Ye,_e=o(),f(E.$$.fragment),ke=o(),N=r("p"),N.innerHTML=He,ve=o(),f(F.$$.fragment),Me=o(),f(j.$$.fragment),xe=o(),f(S.$$.fragment),je=o(),c=r("div"),f($.$$.fragment),Ze=o(),H=r("p"),H.textContent=De,Ie=o(),D=r("p"),D.textContent=Oe,ze=o(),O=r("p"),O.textContent=Ke,Ce=o(),K=r("p"),K.textContent=et,Ae=o(),ee=r("p"),ee.textContent=tt,Ge=o(),te=r("p"),te.innerHTML=nt,Xe=o(),J=r("div"),f(Q.$$.fragment),Be=o(),ne=r("p"),ne.textContent=at,Re=o(),ae=r("div"),f(P.$$.fragment),Je=o(),f(V.$$.fragment),Ue=o(),se=r("p"),this.h()},l(e){const t=pt("svelte-u9bgzb",document.head);i=l(t,"META",{name:!0,content:!0}),t.forEach(n),v=s(e),u=l(e,"P",{}),re(u).forEach(n),h=s(e),T(M.$$.fragment,e),g=s(e),k=l(e,"DIV",{class:!0,"data-svelte-h":!0}),p(k)!=="svelte-1px1zvi"&&(k.innerHTML=Ne),ie=s(e),T(x.$$.fragment,e),ce=s(e),T(U.$$.fragment,e),de=s(e),q=l(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-kx8uvg"&&(q.innerHTML=Fe),pe=s(e),Z=l(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-2m0hm9"&&(Z.textContent=Se),me=s(e),I=l(e,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-1d618io"&&(I.innerHTML=$e),ue=s(e),z=l(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-vfdo9a"&&(z.textContent=Qe),he=s(e),C=l(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-xg0jss"&&(C.innerHTML=Pe),ge=s(e),T(A.$$.fragment,e),fe=s(e),G=l(e,"UL",{"data-svelte-h":!0}),p(G)!=="svelte-15dagua"&&(G.innerHTML=Ve),Te=s(e),T(X.$$.fragment,e),be=s(e),B=l(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-sqvqp5"&&(B.innerHTML=Le),ye=s(e),T(R.$$.fragment,e),we=s(e),W=l(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-sbmzdn"&&(W.innerHTML=Ye),_e=s(e),T(E.$$.fragment,e),ke=s(e),N=l(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1lf70oi"&&(N.innerHTML=He),ve=s(e),T(F.$$.fragment,e),Me=s(e),T(j.$$.fragment,e),xe=s(e),T(S.$$.fragment,e),je=s(e),c=l(e,"DIV",{class:!0});var d=re(c);T($.$$.fragment,d),Ze=s(d),H=l(d,"P",{"data-svelte-h":!0}),p(H)!=="svelte-gkb1rl"&&(H.textContent=De),Ie=s(d),D=l(d,"P",{"data-svelte-h":!0}),p(D)!=="svelte-ic5ztl"&&(D.textContent=Oe),ze=s(d),O=l(d,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1bmyk1l"&&(O.textContent=Ke),Ce=s(d),K=l(d,"P",{"data-svelte-h":!0}),p(K)!=="svelte-6e19qv"&&(K.textContent=et),Ae=s(d),ee=l(d,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1bf8sfk"&&(ee.textContent=tt),Ge=s(d),te=l(d,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1c3t5ty"&&(te.innerHTML=nt),Xe=s(d),J=l(d,"DIV",{class:!0});var L=re(J);T(Q.$$.fragment,L),Be=s(L),ne=l(L,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-olz8ao"&&(ne.textContent=at),L.forEach(n),Re=s(d),ae=l(d,"DIV",{class:!0});var ot=re(ae);T(P.$$.fragment,ot),ot.forEach(n),d.forEach(n),Je=s(e),T(V.$$.fragment,e),Ue=s(e),se=l(e,"P",{}),re(se).forEach(n),this.h()},h(){oe(i,"name","hf:doc:metadata"),oe(i,"content",ft),oe(k,"class","flex flex-wrap space-x-1"),oe(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),oe(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),oe(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){m(document.head,i),a(e,v,t),a(e,u,t),a(e,h,t),b(M,e,t),a(e,g,t),a(e,k,t),a(e,ie,t),b(x,e,t),a(e,ce,t),b(U,e,t),a(e,de,t),a(e,q,t),a(e,pe,t),a(e,Z,t),a(e,me,t),a(e,I,t),a(e,ue,t),a(e,z,t),a(e,he,t),a(e,C,t),a(e,ge,t),b(A,e,t),a(e,fe,t),a(e,G,t),a(e,Te,t),b(X,e,t),a(e,be,t),a(e,B,t),a(e,ye,t),b(R,e,t),a(e,we,t),a(e,W,t),a(e,_e,t),b(E,e,t),a(e,ke,t),a(e,N,t),a(e,ve,t),b(F,e,t),a(e,Me,t),b(j,e,t),a(e,xe,t),b(S,e,t),a(e,je,t),a(e,c,t),b($,c,null),m(c,Ze),m(c,H),m(c,Ie),m(c,D),m(c,ze),m(c,O),m(c,Ce),m(c,K),m(c,Ae),m(c,ee),m(c,Ge),m(c,te),m(c,Xe),m(c,J),b(Q,J,null),m(J,Be),m(J,ne),m(c,Re),m(c,ae),b(P,ae,null),a(e,Je,t),b(V,e,t),a(e,Ue,t),a(e,se,t),qe=!0},p(e,[t]){const d={};t&2&&(d.$$scope={dirty:t,ctx:e}),x.$set(d);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),j.$set(L)},i(e){qe||(y(M.$$.fragment,e),y(x.$$.fragment,e),y(U.$$.fragment,e),y(A.$$.fragment,e),y(X.$$.fragment,e),y(R.$$.fragment,e),y(E.$$.fragment,e),y(F.$$.fragment,e),y(j.$$.fragment,e),y(S.$$.fragment,e),y($.$$.fragment,e),y(Q.$$.fragment,e),y(P.$$.fragment,e),y(V.$$.fragment,e),qe=!0)},o(e){w(M.$$.fragment,e),w(x.$$.fragment,e),w(U.$$.fragment,e),w(A.$$.fragment,e),w(X.$$.fragment,e),w(R.$$.fragment,e),w(E.$$.fragment,e),w(F.$$.fragment,e),w(j.$$.fragment,e),w(S.$$.fragment,e),w($.$$.fragment,e),w(Q.$$.fragment,e),w(P.$$.fragment,e),w(V.$$.fragment,e),qe=!1},d(e){e&&(n(v),n(u),n(h),n(g),n(k),n(ie),n(ce),n(de),n(q),n(pe),n(Z),n(me),n(I),n(ue),n(z),n(he),n(C),n(ge),n(fe),n(G),n(Te),n(be),n(B),n(ye),n(we),n(W),n(_e),n(ke),n(N),n(ve),n(Me),n(xe),n(je),n(c),n(Je),n(Ue),n(se)),n(i),_(M,e),_(x,e),_(U,e),_(A,e),_(X,e),_(R,e),_(E,e),_(F,e),_(j,e),_(S,e),_($),_(Q),_(P),_(V,e)}}}const ft='{"title":"TAPEX","local":"tapex","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Usage: inference","local":"usage-inference","sections":[],"depth":3}],"depth":2},{"title":"TapexTokenizer","local":"transformers.TapexTokenizer","sections":[],"depth":2}],"depth":1}';function Tt(Y){return it(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mt extends ct{constructor(i){super(),dt(this,i,Tt,gt,lt,{})}}export{Mt as component};
