import{s as ss,n as ts,o as ls}from"../chunks/scheduler.01eeda35.js";import{S as ns,i as as,g as i,s as n,r as o,A as is,h as r,f as t,c as a,j as Oe,u as c,x as p,k as es,y as rs,a as l,v as y,d as M,t as u,w as m}from"../chunks/index.6dd51b66.js";import{C as D}from"../chunks/CodeBlock.19ec9b8c.js";import{H as P,E as ps}from"../chunks/index.58fe8f9d.js";function os(Ee){let h,K,F,O,w,ee,d,Ze='A web server is a system that waits for requests and serves them as they come in. This means you can use <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> as an inference engine on a web server, since you can use an iterator (similar to how you would <a href="./pipeline_tutorial#large-datasets">iterate over a dataset</a>) to handle each incoming request.',se,T,Qe='Designing a web server with <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> is unique though because they’re fundamentally different. Web servers are multiplexed (multithreaded, async, etc.) to handle multiple requests concurrently. <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> and its underlying model on the other hand are not designed for parallelism because they take a lot of memory. It’s best to give a <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> all the available resources when they’re running or for a compute intensive job.',te,J,Se='This guide shows how to work around this difference by using a web server to handle the lighter load of receiving and sending requests, and having a single thread to handle the heavier load of running <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a>.',le,f,ne,j,Ge='<a href="https://www.starlette.io/" rel="nofollow">Starlette</a> is a lightweight framework for building web servers. You can use any other framework you’d like, but you may have to make some changes to the code below.',ae,U,Ae='Before you begin, make sure Starlette and <a href="http://www.uvicorn.org/" rel="nofollow">uvicorn</a> are installed.',ie,g,re,b,Xe="Now you can create a simple web server in a <code>server.py</code> file. The key is to only load the model <strong>once</strong> to prevent unnecessary copies of it from consuming memory.",pe,C,qe="Create a pipeline to fill in the masked token, <code>[MASK]</code>.",oe,v,ce,x,_e="Start the server with the following command.",ye,I,Me,k,He="Query the server with a POST request.",ue,B,me,$,he,N,ze='The server’s queuing mechanism can be used for some interesting applications such as dynamic batching. Dynamic batching accumulates several requests first before processing them with <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a>.',we,E,Ve="The example below is written in pseudocode for readability rather than performance, in particular, you’ll notice that:",de,Z,We="<li><p>There is no batch size limit.</p></li> <li><p>The timeout is reset on every queue fetch, so you could end up waiting much longer than the <code>timeout</code> value before processing a request. This would also delay the first inference request by that amount of time. The web server always waits 1ms even if the queue is empty, which is inefficient, because that time can be used to start inference. It could make sense though if batching is essential to your use case.</p> <p>It would be better to have a single 1ms deadline, instead of resetting it on every fetch.</p></li>",Te,Q,Je,S,fe,G,Re="There are many things that can go wrong in production. You could run out-of-memory, out of space, fail to load a model, have an incorrect model configuration, have an incorrect query, and so much more.",je,A,Ye="Adding <code>try...except</code> statements is helpful for returning these errors to the user for debugging. Keep in mind this could be a security risk if you shouldn’t be revealing certain information.",Ue,X,ge,q,Pe="Try to return a 503 or 504 error when the server is overloaded instead of forcing a user to wait indefinitely.",be,_,Fe="It is relatively simple to implement these error types since it’s only a single queue. Take a look at the queue size to determine when to start returning errors before your server fails under load.",Ce,H,ve,z,Le="PyTorch is not async aware, so computation will block the main thread from running.",xe,V,De="For this reason, it’s better to run PyTorch on its own separate thread or process. When inference of a single request is especially long (more than 1s), it’s even more important because it means every query during inference must wait 1s before even receiving an error.",Ie,W,ke,R,Ke='Dynamic batching can be very effective when used in the correct setting, but it’s not necessary when you’re only passing 1 request at a time (see <a href="./pipeline_tutorial#batch-inference">batch inference</a> for more details).',Be,Y,$e,L,Ne;return w=new P({props:{title:"Web server inference",local:"web-server-inference",headingTag:"h1"}}),f=new P({props:{title:"Create a server",local:"create-a-server",headingTag:"h2"}}),g=new D({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzdGFybGV0dGUlMjB1dmljb3Ju",highlighted:"!pip install starlette uvicorn",wrap:!1}}),v=new D({props:{code:"ZnJvbSUyMHN0YXJsZXR0ZS5hcHBsaWNhdGlvbnMlMjBpbXBvcnQlMjBTdGFybGV0dGUlMEFmcm9tJTIwc3RhcmxldHRlLnJlc3BvbnNlcyUyMGltcG9ydCUyMEpTT05SZXNwb25zZSUwQWZyb20lMjBzdGFybGV0dGUucm91dGluZyUyMGltcG9ydCUyMFJvdXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwYXN5bmNpbyUwQSUwQWFzeW5jJTIwZGVmJTIwaG9tZXBhZ2UocmVxdWVzdCklM0ElMEElMjAlMjAlMjAlMjBwYXlsb2FkJTIwJTNEJTIwYXdhaXQlMjByZXF1ZXN0LmJvZHkoKSUwQSUyMCUyMCUyMCUyMHN0cmluZyUyMCUzRCUyMHBheWxvYWQuZGVjb2RlKCUyMnV0Zi04JTIyKSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlX3ElMjAlM0QlMjBhc3luY2lvLlF1ZXVlKCklMEElMjAlMjAlMjAlMjBhd2FpdCUyMHJlcXVlc3QuYXBwLm1vZGVsX3F1ZXVlLnB1dCgoc3RyaW5nJTJDJTIwcmVzcG9uc2VfcSkpJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjByZXNwb25zZV9xLmdldCgpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwSlNPTlJlc3BvbnNlKG91dHB1dCklMEElMEFhc3luYyUyMGRlZiUyMHNlcnZlcl9sb29wKHEpJTNBJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyZmlsbC1tYXNrJTIyJTJDbW9kZWwlM0QlMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUyMCUyMCUyMCUyMHdoaWxlJTIwVHJ1ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMChzdHJpbmclMkMlMjByZXNwb25zZV9xKSUyMCUzRCUyMGF3YWl0JTIwcS5nZXQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMHBpcGVsaW5lKHN0cmluZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhd2FpdCUyMHJlc3BvbnNlX3EucHV0KG91dCklMEElMEFhcHAlMjAlM0QlMjBTdGFybGV0dGUoJTBBJTIwJTIwJTIwJTIwcm91dGVzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUm91dGUoJTIyJTJGJTIyJTJDJTIwaG9tZXBhZ2UlMkMlMjBtZXRob2RzJTNEJTVCJTIyUE9TVCUyMiU1RCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEEpJTBBJTBBJTQwYXBwLm9uX2V2ZW50KCUyMnN0YXJ0dXAlMjIpJTBBYXN5bmMlMjBkZWYlMjBzdGFydHVwX2V2ZW50KCklM0ElMEElMjAlMjAlMjAlMjBxJTIwJTNEJTIwYXN5bmNpby5RdWV1ZSgpJTBBJTIwJTIwJTIwJTIwYXBwLm1vZGVsX3F1ZXVlJTIwJTNEJTIwcSUwQSUyMCUyMCUyMCUyMGFzeW5jaW8uY3JlYXRlX3Rhc2soc2VydmVyX2xvb3AocSkp",highlighted:`<span class="hljs-keyword">from</span> starlette.applications <span class="hljs-keyword">import</span> Starlette
<span class="hljs-keyword">from</span> starlette.responses <span class="hljs-keyword">import</span> JSONResponse
<span class="hljs-keyword">from</span> starlette.routing <span class="hljs-keyword">import</span> Route
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> asyncio

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">homepage</span>(<span class="hljs-params">request</span>):
    payload = <span class="hljs-keyword">await</span> request.body()
    string = payload.decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
    response_q = asyncio.Queue()
    <span class="hljs-keyword">await</span> request.app.model_queue.put((string, response_q))
    output = <span class="hljs-keyword">await</span> response_q.get()
    <span class="hljs-keyword">return</span> JSONResponse(output)

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">server_loop</span>(<span class="hljs-params">q</span>):
    pipeline = pipeline(task=<span class="hljs-string">&quot;fill-mask&quot;</span>,model=<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
        (string, response_q) = <span class="hljs-keyword">await</span> q.get()
        out = pipeline(string)
        <span class="hljs-keyword">await</span> response_q.put(out)

app = Starlette(
    routes=[
        Route(<span class="hljs-string">&quot;/&quot;</span>, homepage, methods=[<span class="hljs-string">&quot;POST&quot;</span>]),
    ],
)

<span class="hljs-meta">@app.on_event(<span class="hljs-params"><span class="hljs-string">&quot;startup&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">startup_event</span>():
    q = asyncio.Queue()
    app.model_queue = q
    asyncio.create_task(server_loop(q))`,wrap:!1}}),I=new D({props:{code:"dXZpY29ybiUyMHNlcnZlciUzQWFwcA==",highlighted:"uvicorn server:app",wrap:!1}}),B=new D({props:{code:"Y3VybCUyMC1YJTIwUE9TVCUyMC1kJTIwJTIyUGFyaXMlMjBpcyUyMHRoZSUyMCU1Qk1BU0slNUQlMjBvZiUyMEZyYW5jZS4lMjIlMjBodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBODAwMCUyRiUwQSU1QiU3QidzY29yZSclM0ElMjAwLjk5NjkzMzIyMTgxNzAxNjYlMkMlMEElMjAlMjAndG9rZW4nJTNBJTIwMzAwNyUyQyUwQSUyMCUyMCd0b2tlbl9zdHInJTNBJTIwJ2NhcGl0YWwnJTJDJTBBJTIwJTIwJ3NlcXVlbmNlJyUzQSUyMCdwYXJpcyUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwZnJhbmNlLiclN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwMC4wMDA1OTE0ODQ5NDYxOTg3NjE1JTJDJTBBJTIwJTIwJ3Rva2VuJyUzQSUyMDI1NDAlMkMlMEElMjAlMjAndG9rZW5fc3RyJyUzQSUyMCdoZWFydCclMkMlMEElMjAlMjAnc2VxdWVuY2UnJTNBJTIwJ3BhcmlzJTIwaXMlMjB0aGUlMjBoZWFydCUyMG9mJTIwZnJhbmNlLiclN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwMC4wMDA0Mzc4NzMxODI4MTgyOTM1NyUyQyUwQSUyMCUyMCd0b2tlbiclM0ElMjAyNDE1JTJDJTBBJTIwJTIwJ3Rva2VuX3N0ciclM0ElMjAnY2VudGVyJyUyQyUwQSUyMCUyMCdzZXF1ZW5jZSclM0ElMjAncGFyaXMlMjBpcyUyMHRoZSUyMGNlbnRlciUyMG9mJTIwZnJhbmNlLiclN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwMC4wMDAzMzc4MzQwMDQzMTI3NTM3JTJDJTBBJTIwJTIwJ3Rva2VuJyUzQSUyMDI4MDMlMkMlMEElMjAlMjAndG9rZW5fc3RyJyUzQSUyMCdjZW50cmUnJTJDJTBBJTIwJTIwJ3NlcXVlbmNlJyUzQSUyMCdwYXJpcyUyMGlzJTIwdGhlJTIwY2VudHJlJTIwb2YlMjBmcmFuY2UuJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjAwLjAwMDI2OTk1OTEyNzc2MzI4NjIzJTJDJTBBJTIwJTIwJ3Rva2VuJyUzQSUyMDIxMDMlMkMlMEElMjAlMjAndG9rZW5fc3RyJyUzQSUyMCdjaXR5JyUyQyUwQSUyMCUyMCdzZXF1ZW5jZSclM0ElMjAncGFyaXMlMjBpcyUyMHRoZSUyMGNpdHklMjBvZiUyMGZyYW5jZS4nJTdEJTVE",highlighted:`curl -X POST -d <span class="hljs-string">&quot;Paris is the [MASK] of France.&quot;</span> http://localhost:8000/
[{<span class="hljs-string">&#x27;score&#x27;</span>: 0.9969332218170166,
  <span class="hljs-string">&#x27;token&#x27;</span>: 3007,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;capital&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;paris is the capital of france.&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.0005914849461987615,
  <span class="hljs-string">&#x27;token&#x27;</span>: 2540,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;heart&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;paris is the heart of france.&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.00043787318281829357,
  <span class="hljs-string">&#x27;token&#x27;</span>: 2415,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;center&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;paris is the center of france.&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.0003378340043127537,
  <span class="hljs-string">&#x27;token&#x27;</span>: 2803,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;centre&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;paris is the centre of france.&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.00026995912776328623,
  <span class="hljs-string">&#x27;token&#x27;</span>: 2103,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;city&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;paris is the city of france.&#x27;</span>}]`,wrap:!1}}),$=new P({props:{title:"Queuing requests",local:"queuing-requests",headingTag:"h2"}}),Q=new D({props:{code:"KHN0cmluZyUyQyUyMHJxKSUyMCUzRCUyMGF3YWl0JTIwcS5nZXQoKSUwQXN0cmluZ3MlMjAlM0QlMjAlNUIlNUQlMEFxdWV1ZXMlMjAlM0QlMjAlNUIlNUQlMEF3aGlsZSUyMFRydWUlM0ElMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoc3RyaW5nJTJDJTIwcnEpJTIwJTNEJTIwYXdhaXQlMjBhc3luY2lvLndhaXRfZm9yKHEuZ2V0KCklMkMlMjB0aW1lb3V0JTNEMC4wMDEpJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwYXN5bmNpby5leGNlcHRpb25zLlRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTIwJTIwJTIwJTIwc3RyaW5ncy5hcHBlbmQoc3RyaW5nKSUwQSUyMCUyMCUyMCUyMHF1ZXVlcy5hcHBlbmQocnEpJTBBc3RyaW5ncyUwQW91dHMlMjAlM0QlMjBwaXBlbGluZShzdHJpbmdzJTJDJTIwYmF0Y2hfc2l6ZSUzRGxlbihzdHJpbmdzKSklMEFmb3IlMjBycSUyQyUyMG91dCUyMGluJTIwemlwKHF1ZXVlcyUyQyUyMG91dHMpJTNBJTBBJTIwJTIwJTIwJTIwYXdhaXQlMjBycS5wdXQob3V0KQ==",highlighted:`(string, rq) = <span class="hljs-keyword">await</span> q.get()
strings = []
queues = []
<span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
    <span class="hljs-keyword">try</span>:
        (string, rq) = <span class="hljs-keyword">await</span> asyncio.wait_for(q.get(), timeout=<span class="hljs-number">0.001</span>)
    <span class="hljs-keyword">except</span> asyncio.exceptions.TimeoutError:
        <span class="hljs-keyword">break</span>
    strings.append(string)
    queues.append(rq)
strings
outs = pipeline(strings, batch_size=<span class="hljs-built_in">len</span>(strings))
<span class="hljs-keyword">for</span> rq, out <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(queues, outs):
    <span class="hljs-keyword">await</span> rq.put(out)`,wrap:!1}}),S=new P({props:{title:"Error checking",local:"error-checking",headingTag:"h2"}}),X=new P({props:{title:"Circuit breaking",local:"circuit-breaking",headingTag:"h2"}}),H=new P({props:{title:"Block the main thread",local:"block-the-main-thread",headingTag:"h2"}}),W=new P({props:{title:"Dynamic batching",local:"dynamic-batching",headingTag:"h2"}}),Y=new ps({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/pipeline_webserver.md"}}),{c(){h=i("meta"),K=n(),F=i("p"),O=n(),o(w.$$.fragment),ee=n(),d=i("p"),d.innerHTML=Ze,se=n(),T=i("p"),T.innerHTML=Qe,te=n(),J=i("p"),J.innerHTML=Se,le=n(),o(f.$$.fragment),ne=n(),j=i("p"),j.innerHTML=Ge,ae=n(),U=i("p"),U.innerHTML=Ae,ie=n(),o(g.$$.fragment),re=n(),b=i("p"),b.innerHTML=Xe,pe=n(),C=i("p"),C.innerHTML=qe,oe=n(),o(v.$$.fragment),ce=n(),x=i("p"),x.textContent=_e,ye=n(),o(I.$$.fragment),Me=n(),k=i("p"),k.textContent=He,ue=n(),o(B.$$.fragment),me=n(),o($.$$.fragment),he=n(),N=i("p"),N.innerHTML=ze,we=n(),E=i("p"),E.textContent=Ve,de=n(),Z=i("ol"),Z.innerHTML=We,Te=n(),o(Q.$$.fragment),Je=n(),o(S.$$.fragment),fe=n(),G=i("p"),G.textContent=Re,je=n(),A=i("p"),A.innerHTML=Ye,Ue=n(),o(X.$$.fragment),ge=n(),q=i("p"),q.textContent=Pe,be=n(),_=i("p"),_.textContent=Fe,Ce=n(),o(H.$$.fragment),ve=n(),z=i("p"),z.textContent=Le,xe=n(),V=i("p"),V.textContent=De,Ie=n(),o(W.$$.fragment),ke=n(),R=i("p"),R.innerHTML=Ke,Be=n(),o(Y.$$.fragment),$e=n(),L=i("p"),this.h()},l(e){const s=is("svelte-u9bgzb",document.head);h=r(s,"META",{name:!0,content:!0}),s.forEach(t),K=a(e),F=r(e,"P",{}),Oe(F).forEach(t),O=a(e),c(w.$$.fragment,e),ee=a(e),d=r(e,"P",{"data-svelte-h":!0}),p(d)!=="svelte-1q9kufa"&&(d.innerHTML=Ze),se=a(e),T=r(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1bi3g9p"&&(T.innerHTML=Qe),te=a(e),J=r(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-11ey1v3"&&(J.innerHTML=Se),le=a(e),c(f.$$.fragment,e),ne=a(e),j=r(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-75xf7k"&&(j.innerHTML=Ge),ae=a(e),U=r(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-vc63tw"&&(U.innerHTML=Ae),ie=a(e),c(g.$$.fragment,e),re=a(e),b=r(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-hg1gr3"&&(b.innerHTML=Xe),pe=a(e),C=r(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1rmfx7s"&&(C.innerHTML=qe),oe=a(e),c(v.$$.fragment,e),ce=a(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-khywk9"&&(x.textContent=_e),ye=a(e),c(I.$$.fragment,e),Me=a(e),k=r(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-wy3f7i"&&(k.textContent=He),ue=a(e),c(B.$$.fragment,e),me=a(e),c($.$$.fragment,e),he=a(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-i2rj31"&&(N.innerHTML=ze),we=a(e),E=r(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-o8k0wa"&&(E.textContent=Ve),de=a(e),Z=r(e,"OL",{"data-svelte-h":!0}),p(Z)!=="svelte-12z6vc1"&&(Z.innerHTML=We),Te=a(e),c(Q.$$.fragment,e),Je=a(e),c(S.$$.fragment,e),fe=a(e),G=r(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-np02fr"&&(G.textContent=Re),je=a(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-18bu5an"&&(A.innerHTML=Ye),Ue=a(e),c(X.$$.fragment,e),ge=a(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-q5t78j"&&(q.textContent=Pe),be=a(e),_=r(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-b9g89k"&&(_.textContent=Fe),Ce=a(e),c(H.$$.fragment,e),ve=a(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-vk268r"&&(z.textContent=Le),xe=a(e),V=r(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1am6qf5"&&(V.textContent=De),Ie=a(e),c(W.$$.fragment,e),ke=a(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-19c4yu0"&&(R.innerHTML=Ke),Be=a(e),c(Y.$$.fragment,e),$e=a(e),L=r(e,"P",{}),Oe(L).forEach(t),this.h()},h(){es(h,"name","hf:doc:metadata"),es(h,"content",cs)},m(e,s){rs(document.head,h),l(e,K,s),l(e,F,s),l(e,O,s),y(w,e,s),l(e,ee,s),l(e,d,s),l(e,se,s),l(e,T,s),l(e,te,s),l(e,J,s),l(e,le,s),y(f,e,s),l(e,ne,s),l(e,j,s),l(e,ae,s),l(e,U,s),l(e,ie,s),y(g,e,s),l(e,re,s),l(e,b,s),l(e,pe,s),l(e,C,s),l(e,oe,s),y(v,e,s),l(e,ce,s),l(e,x,s),l(e,ye,s),y(I,e,s),l(e,Me,s),l(e,k,s),l(e,ue,s),y(B,e,s),l(e,me,s),y($,e,s),l(e,he,s),l(e,N,s),l(e,we,s),l(e,E,s),l(e,de,s),l(e,Z,s),l(e,Te,s),y(Q,e,s),l(e,Je,s),y(S,e,s),l(e,fe,s),l(e,G,s),l(e,je,s),l(e,A,s),l(e,Ue,s),y(X,e,s),l(e,ge,s),l(e,q,s),l(e,be,s),l(e,_,s),l(e,Ce,s),y(H,e,s),l(e,ve,s),l(e,z,s),l(e,xe,s),l(e,V,s),l(e,Ie,s),y(W,e,s),l(e,ke,s),l(e,R,s),l(e,Be,s),y(Y,e,s),l(e,$e,s),l(e,L,s),Ne=!0},p:ts,i(e){Ne||(M(w.$$.fragment,e),M(f.$$.fragment,e),M(g.$$.fragment,e),M(v.$$.fragment,e),M(I.$$.fragment,e),M(B.$$.fragment,e),M($.$$.fragment,e),M(Q.$$.fragment,e),M(S.$$.fragment,e),M(X.$$.fragment,e),M(H.$$.fragment,e),M(W.$$.fragment,e),M(Y.$$.fragment,e),Ne=!0)},o(e){u(w.$$.fragment,e),u(f.$$.fragment,e),u(g.$$.fragment,e),u(v.$$.fragment,e),u(I.$$.fragment,e),u(B.$$.fragment,e),u($.$$.fragment,e),u(Q.$$.fragment,e),u(S.$$.fragment,e),u(X.$$.fragment,e),u(H.$$.fragment,e),u(W.$$.fragment,e),u(Y.$$.fragment,e),Ne=!1},d(e){e&&(t(K),t(F),t(O),t(ee),t(d),t(se),t(T),t(te),t(J),t(le),t(ne),t(j),t(ae),t(U),t(ie),t(re),t(b),t(pe),t(C),t(oe),t(ce),t(x),t(ye),t(Me),t(k),t(ue),t(me),t(he),t(N),t(we),t(E),t(de),t(Z),t(Te),t(Je),t(fe),t(G),t(je),t(A),t(Ue),t(ge),t(q),t(be),t(_),t(Ce),t(ve),t(z),t(xe),t(V),t(Ie),t(ke),t(R),t(Be),t($e),t(L)),t(h),m(w,e),m(f,e),m(g,e),m(v,e),m(I,e),m(B,e),m($,e),m(Q,e),m(S,e),m(X,e),m(H,e),m(W,e),m(Y,e)}}}const cs='{"title":"Web server inference","local":"web-server-inference","sections":[{"title":"Create a server","local":"create-a-server","sections":[],"depth":2},{"title":"Queuing requests","local":"queuing-requests","sections":[],"depth":2},{"title":"Error checking","local":"error-checking","sections":[],"depth":2},{"title":"Circuit breaking","local":"circuit-breaking","sections":[],"depth":2},{"title":"Block the main thread","local":"block-the-main-thread","sections":[],"depth":2},{"title":"Dynamic batching","local":"dynamic-batching","sections":[],"depth":2}],"depth":1}';function ys(Ee){return ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ws extends ns{constructor(h){super(),as(this,h,ys,os,ss,{})}}export{ws as component};
