import{s as ql,o as zl,n as kl}from"../chunks/scheduler.36a0863c.js";import{S as Sl,i as Wl,g as o,s as t,r,A as Vl,h as p,f as s,c as n,j as Ql,u as c,x as i,k as Bl,y as Rl,a as l,v as m,d as M,t as d,w as u}from"../chunks/index.f891bdb2.js";import{T as Al}from"../chunks/Tip.a8272f7f.js";import{C as y}from"../chunks/CodeBlock.b05e74dc.js";import{H as j,E as El}from"../chunks/index.c6b8cc89.js";function _l(la){let J,h="Si estás ajustando finamente un modelo para chat, además de establecer una plantilla de chat, probablemente deberías agregar cualquier nuevo token de control de chat como los tokens especiales en el tokenizador. Los tokens especiales nunca se dividen, asegurando que tus tokens de control siempre se manejen como tokens únicos en lugar de ser tokenizados en piezas. También deberías establecer el atributo <code>eos_token</code> del tokenizador con el token que marca el final de las generaciones del asistente en tu plantilla. Esto asegurará que las herramientas de generación de texto puedan determinar correctamente cuándo detener la generación de texto.";return{c(){J=o("p"),J.innerHTML=h},l(T){J=p(T,"P",{"data-svelte-h":!0}),i(J)!=="svelte-jr3rxt"&&(J.innerHTML=h)},m(T,aa){l(T,J,aa)},p:kl,d(T){T&&s(J)}}}function Xl(la){let J,h,T,aa,g,ta,b,na,I,Vs=`Un caso de uso cada vez más común para LLMs es <strong>el chat</strong>. En un contexto de chat, en lugar de continuar una única cadena de texto (como es el caso con un modelo de lenguaje estándar), el modelo continúa una conversación que consta de uno o más <strong>mensajes</strong>, cada uno de los cuales incluye un <strong>rol</strong>, como “usuario” o “asistente”, así como el texto del mensaje.
Al igual que con la tokenización, diferentes modelos esperan formatos de entrada muy diferentes para el chat. Esta es la razón por la que agregamos las plantillas de chat como una característica. Las plantillas de chat son parte del tokenizador. Especifican cómo convertir conversaciones, representadas como listas de mensajes, en una única cadena tokenizable en el formato que el modelo espera.
Vamos a hacer esto con un ejemplo concreto utilizando el modelo <code>BlenderBot</code>. BlenderBot tiene una plantilla predeterminada extremadamente simple, que principalmente solo agrega espacios en blanco entre rondas de diálogo:`,oa,w,pa,f,Rs="Observa cómo todo el chat se condensa en una sola cadena. Si usamos <code>tokenize=True</code>, que es la configuración predeterminada, esa cadena también será tokenizada para nosotros. Sin embargo, para ver una plantilla más compleja en acción, usemos el modelo <code>mistralai/Mistral-7B-Instruct-v0.1</code>",ia,C,ra,x,As="Ten en cuenta que esta vez, el tokenizador ha añadido los tokens de control [INST] y [/INST] para indicar el inicio y el final de los mensajes de usuario (¡pero no de los mensajes del asistente!). Mistral-instruct fue entrenado con estos tokens, pero BlenderBot no lo fue.",ca,N,ma,Z,Es='Como puedes ver en el ejemplo anterior, las plantillas de chat son fáciles de usar. Simplemente construye una lista de mensajes, con claves de <code>rol</code> y <code>contenido</code>, y luego pásala al método <code>apply_chat_template()</code>. Una vez que hagas eso, ¡obtendrás una salida lista para usar! Al utilizar plantillas de chat como entrada para la generación de modelos, también es una buena idea usar <code>add_generation_prompt=True</code> para agregar una <a href="#%C2%BFQu%C3%A9-son-los-%22generation-prompts%22?">indicación de generación</a>.',Ma,G,_s="Aquí tienes un ejemplo de cómo preparar la entrada para <code>model.generate()</code> utilizando el modelo de asistente <code>Zephyr</code>:",da,$,ua,v,Xs="Esto generará una cadena en el formato de entrada que Zephyr espera.",ya,Q,Ja,B,Fs="Ahora que nuestra entrada está formateada correctamente para Zephyr, podemos usar el modelo para generar una respuesta a la pregunta del usuario:",ja,q,Ta,z,Hs="Esto producirá:",Ua,k,ha,S,Ys="¡Arr, al final resultó ser fácil!",ga,W,ba,V,Ls="Sí, lo hay! Nuestros canales de generación de texto admiten entradas de chat, cual facilita más facíl utilizar los modelos de chat. En el pasado, solíamos utilizar una clase dedicada “ConversationalPipeline”, pero ahora ha quedado obsoleta y su funcionalidad se ha fusionado en <code>TextGenerationPipeline</code>. Este pipeline está diseñado para facilitar el uso de modelos de chat. Intentemos el ejemplo de <code>Zephyr</code> de nuevo, pero esta vez utilizando el pipeline:",Ia,R,wa,A,fa,E,Ds="La canalización se encargará de todos los detalles de la tokenización y de llamar a <code>apply_chat_template</code> por ti. Una vez que el modelo tenga una plantilla de chat, ¡todo lo que necesitas hacer es inicializar el pipeline y pasarle la lista de mensajes!",Ca,_,xa,X,Ps="Puede que hayas notado que el método <code>apply_chat_template</code> tiene un argumento <code>add_generation_prompt</code>. Este argumento indica a la plantilla que agregue tokens que indiquen el inicio de una respuesta del bot. Por ejemplo, considera el siguiente chat:",Na,F,Za,H,Ks="Así es cómo se verá esto sin un “generation prompt”, usando la plantilla ChatML que vimos en el ejemplo de Zephyr:",Ga,Y,$a,L,Os="Y así es como se ve <strong>con</strong> un “generation prompt”:",va,D,Qa,P,el="Ten en cuenta que esta vez, hemos agregado los tokens que indican el inicio de una respuesta del bot. Esto asegura que cuando el modelo genere texto, escribirá una respuesta del bot en lugar de hacer algo inesperado, como continuar el mensaje del usuario. Recuerda, los modelos de chat siguen siendo solo modelos de lenguaje: están entrenados para continuar texto, ¡y el chat es solo un tipo especial de texto para ellos! Necesitas guiarlos con los tokens de control apropiados para que sepan lo que se supone que deben estar haciendo.",Ba,K,al="No todos los modelos requieren “generation prompts”. Algunos modelos, como BlenderBot y LLaMA, no tienen ningún token especial antes de las respuestas del bot. En estos casos, el argumento <code>add_generation_prompt</code> no tendrá ningún efecto. El efecto exacto que tiene <code>add_generation_prompt</code> dependerá de la plantilla que se esté utilizando.",qa,O,za,ee,sl="¡Sí! Recomendamos que apliques la plantilla de chat como un paso de preprocesamiento para tu conjunto de datos. Después de esto, simplemente puedes continuar como cualquier otra tarea de entrenamiento de modelos de lenguaje. Durante el entrenamiento, generalmente deberías establecer <code>add_generation_prompt=False</code>, porque los tokens añadidos para solicitar una respuesta del asistente no serán útiles durante el entrenamiento. Veamos un ejemplo:",ka,ae,Sa,se,ll="Y obtenemos:",Wa,le,Va,te,tl="Desde aquí, simplemente continúa el entrenamiento como lo harías con una tarea estándar de modelado de lenguaje, utilizando la columna <code>formatted_chat</code>.",Ra,ne,Aa,oe,nl="La plantilla de chat para un modelo se almacena en el atributo <code>tokenizer.chat_template</code>. Si no se establece ninguna plantilla de chat, se utiliza en su lugar la plantilla predeterminada para esa clase de modelo. Echemos un vistazo a la plantilla para <code>BlenderBot</code>:",Ea,pe,_a,ie,ol="¡Es un poco intimidante! Vamos a agregar algunas líneas nuevas y sangria para que sea más legible. Ten en cuenta que la primera línea nueva después de cada bloque, así como cualquier espacio en blanco anterior a un bloque, se ignoran de forma predeterminada, utilizando las banderas <code>trim_blocks</code> y <code>lstrip_blocks</code> de Jinja. Sin embargo, ¡ten cuidado! Aunque el espacio en blanco inicial en cada línea se elimina, los espacios entre bloques en la misma línea no. ¡Te recomendamos encarecidamente que verifiques que tu plantilla no esté imprimiendo espacios adicionales donde no debería estarlo!",Xa,re,Fa,ce,pl='Si nunca has visto uno de estos antes, esto es una <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">plantilla de Jinja</a>. Jinja es un lenguaje de plantillas que te permite escribir código simple que genera texto. En muchos aspectos, el código y la sintaxis se asemejan a Python. En Python puro, esta plantilla se vería algo así:',Ha,me,Ya,Me,il="Efectivamente, la plantilla hace tres cosas:",La,de,rl="<li>Para cada mensaje, si el mensaje es un mensaje de usuario, añade un espacio en blanco antes de él, de lo contrario no imprime nada.</li> <li>Añade el contenido del mensaje.</li> <li>Si el mensaje no es el último mensaje, añade dos espacios después de él. Después del último mensaje, imprime el token EOS.</li>",Da,ue,cl="Esta es una plantilla bastante simple: no añade ningún token de control y no admite mensajes “del sistema”, que son una forma común de dar al modelo directivas sobre cómo debe comportarse en la conversación posterior. ¡Pero Jinja te brinda mucha flexibilidad para hacer esas cosas! Veamos una plantilla de Jinja que pueda formatear las entradas de manera similar a la forma en que LLaMA las formatea (nota que la plantilla real de LLaMA incluye el manejo de mensajes del sistema predeterminados y el manejo de mensajes del sistema ligeramente diferentes en general; ¡no uses esta en tu código real!)",Pa,ye,Ka,Je,ml="Si observas esto por un momento, puedas ver lo que esta plantilla está haciendo: añade tokens específicos basados en el “rol” de cada mensaje, que representa quién lo envió. Los mensajes de usuario, asistente y sistema son claramente distinguibles para el modelo debido a los tokens en los que están envueltos.",Oa,je,es,Te,as,Ue,Ml="Simple, solo escribe una plantilla de Jinja y establece <code>tokenizer.chat_template</code>. ¡Puede resultarte más fácil comenzar con una plantilla existente de otro modelo y simplemente editarla según tus necesidades! Por ejemplo, podríamos tomar la plantilla de LLaMA de arriba y añadir ”[ASST]” y ”[/ASST]” a los mensajes del asistente:",ss,he,ls,ge,dl="Ahora, simplemente establece el atributo <code>tokenizer.chat_template</code>. ¡La próxima vez que uses <code>apply_chat_template()</code>, se utilizará tu nueva plantilla! Este atributo se guardará en el archivo tokenizer_config.json, por lo que puedes usar <code>push_to_hub()</code> para cargar tu nueva plantilla en el Hub y asegurarte de que todos estén utilizando la plantilla correcta para tu modelo.",ts,be,ns,Ie,ul="El método <code>apply_chat_template()</code>, que utiliza tu plantilla de chat, es llamado por la clase <code>TextGenerationPipeline</code>, así que una vez que configures la plantilla de chat correcta, tu modelo se volverá automáticamente compatible con <code>TextGenerationPipeline</code>.",os,U,ps,we,is,fe,yl="Cuando establezcas la plantilla para un modelo que ya ha sido entrenado para chat, debes asegurarte de que la plantilla coincida exactamente con el formato de mensajes que el modelo vio durante el entrenamiento, o de lo contrario es probable que experimentes degradación del rendimiento. Esto es cierto incluso si estás entrenando aún más el modelo; probablemente obtendrás el mejor rendimiento si mantienes constantes los tokens de chat. Esto es muy análogo a la tokenización: generalmente obtienes el mejor rendimiento para la inferencia o el ajuste fino cuando coincides precisamente con la tokenización utilizada durante el entrenamiento.",rs,Ce,Jl="Si estás entrenando un modelo desde cero o ajustando finamente un modelo de lenguaje base para chat, por otro lado, ¡tienes mucha libertad para elegir una plantilla apropiada! Los LLM son lo suficientemente inteligentes como para aprender a manejar muchos formatos de entrada diferentes. Nuestra plantilla predeterminada para modelos que no tienen una plantilla específica de clase sigue el formato ChatML, y esta es una buena elección flexible para muchos casos de uso. Se ve así:",cs,xe,ms,Ne,jl='Si te gusta esta plantilla, aquí está en forma de una sola línea, lista para copiar en tu código. La versión de una sola línea también incluye un práctico soporte para <a href="#%C2%BFQu%C3%A9-son-los-%22generation-prompts%22?">prompts de generación</a>, ¡pero ten en cuenta que no añade tokens de BOS o EOS! Si tu modelo espera esos tokens, no se agregarán automáticamente por <code>apply_chat_template</code>, en otras palabras, el texto será tokenizado con <code>add_special_tokens=False</code>. Esto es para evitar posibles conflictos entre la plantilla y la lógica de <code>add_special_tokens</code>. ¡Si tu modelo espera tokens especiales, asegúrate de añadirlos a la plantilla!',Ms,Ze,ds,Ge,Tl="Esta plantilla envuelve cada mensaje en tokens <code>&lt;|im_start|&gt;</code> y <code>&lt;|im_end|&gt;</code>, y simplemente escribe el rol como una cadena, lo que permite flexibilidad en los roles con los que entrenas. La salida se ve así:",us,$e,ys,ve,Ul="Los roles “usuario”, “sistema” y “asistente” son los estándar para chat, y recomendamos usarlos cuando tenga sentido, particularmente si deseas que tu modelo funcione bien con <code>TextGenerationPipeline</code>. Sin embargo, no estás limitado a estos roles: la plantilla es extremadamente flexible y cualquier cadena puede ser un rol.",Js,Qe,js,Be,hl='Si tienes algún modelo de chat, debes establecer su atributo <code>tokenizer.chat_template</code> y probarlo usando <code>apply_chat_template()</code>, luego subir el tokenizador actualizado al Hub. Esto se aplica incluso si no eres el propietario del modelo: si estás usando un modelo con una plantilla de chat vacía o que todavía está utilizando la plantilla predeterminada de clase, por favor abre una solicitud de extracción <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> al repositorio del modelo para que este atributo se pueda establecer correctamente.',Ts,qe,gl="Una vez que se establece el atributo, ¡eso es todo, has terminado! <code>tokenizer.apply_chat_template</code> ahora funcionará correctamente para ese modelo, ¡lo que significa que también es compatible automáticamente en lugares como <code>TextGenerationPipeline</code>!",Us,ze,bl="Al asegurarnos de que los modelos tengan este atributo, podemos garantizar que toda la comunidad pueda utilizar todo el poder de los modelos de código abierto. Los desajustes de formato han estado acechando el campo y dañando silenciosamente el rendimiento durante demasiado tiempo: ¡es hora de ponerles fin!",hs,ke,gs,Se,Il="Si no estás familiarizado con Jinja, generalmente encontramos que la forma más fácil de escribir una plantilla de chat es primero escribir un script de Python corto que formatee los mensajes como desees, y luego convertir ese script en una plantilla.",bs,We,wl="Recuerda que el manejador de plantillas recibirá el historial de conversación como una variable llamada mensajes. Cada mensaje es un diccionario con dos claves, <code>role</code> y <code>content</code>. Podrás acceder a los <code>mensajes</code> en tu plantilla tal como lo harías en Python, lo que significa que puedes recorrerlo con <code>{% for message in messages %}</code> o acceder a mensajes individuales con, por ejemplo, <code>{{ messages[0] }}</code>.",Is,Ve,fl="También puedes usar los siguientes consejos para convertir tu código a Jinja:",ws,Re,fs,Ae,Cl="Los bucles For en Jinja se ven así:",Cs,Ee,xs,_e,xl="Ten en cuenta que todo lo que esté dentro del {{bloque de expresión}} se imprimirá en la salida. Puedes usar operadores como <code>+</code> para combinar cadenas dentro de bloques de expresión.",Ns,Xe,Zs,Fe,Nl="Las declaraciones if en Jinja se ven así:",Gs,He,$s,Ye,Zl="Observa cómo donde Python utiliza espacios en blanco para marcar el inicio y el final de los bloques <code>for</code> e <code>if</code>, Jinja requiere que los termines explícitamente con <code>{% endfor %}</code> y <code>{% endif %}</code>.",vs,Le,Qs,De,Gl="Dentro de tu plantilla, tendrás acceso a la lista de <code>mensajes</code>, pero también puedes acceder a varias otras variables especiales. Estas incluyen tokens especiales como <code>bos_token</code> y <code>eos_token</code>, así como la variable <code>add_generation_prompt</code> que discutimos anteriormente. También puedes usar la variable <code>loop</code> para acceder a información sobre la iteración actual del bucle, por ejemplo, usando <code>{% if loop.last %}</code> para verificar si el mensaje actual es el último mensaje en la conversación. Aquí tienes un ejemplo que combina estas ideas para agregar un prompt de generación al final de la conversación si add_generation_prompt es <code>True</code>:",Bs,Pe,qs,Ke,zs,Oe,$l="Hemos intentado que Jinja ignore los espacios en blanco fuera de las {{expresiones}} tanto como sea posible. Sin embargo, ten en cuenta que Jinja es un motor de plantillas de propósito general y puede tratar el espacio en blanco entre bloques en la misma línea como significativo e imprimirlo en la salida. ¡Te recomendamos <strong>encarecidamente</strong> que verifiques que tu plantilla no esté imprimiendo espacios adicionales donde no debería antes de subirla!",ks,ea,Ss,sa,Ws;return g=new j({props:{title:"Plantillas para Modelos de Chat",local:"plantillas-para-modelos-de-chat",headingTag:"h1"}}),b=new j({props:{title:"Introducción",local:"introducción",headingTag:"h2"}}),w=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQWNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVEJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2UpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot; Hello, how are you?  I&#x27;m doing great. How can I help you today?   I&#x27;d like to show off how chat templating works!&lt;/s&gt;&quot;</span>
`,wrap:!1}}),C=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ20lMjBkb2luZyUyMGdyZWF0LiUyMEhvdyUyMGNhbiUyMEklMjBoZWxwJTIweW91JTIwdG9kYXklM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ2QlMjBsaWtlJTIwdG8lMjBzaG93JTIwb2ZmJTIwaG93JTIwY2hhdCUyMHRlbXBsYXRpbmclMjB3b3JrcyElMjIlN0QlMkMlMEElNUQlMEElMEF0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST]I&#x27;m doing great. How can I help you today?&lt;/s&gt; [INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),N=new j({props:{title:"¿Cómo uso las plantillas de chat?",local:"cómo-uso-las-plantillas-de-chat",headingTag:"h2"}}),$=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTIwJTIwJTIzJTIwWW91JTIwbWF5JTIwd2FudCUyMHRvJTIwdXNlJTIwYmZsb2F0MTYlMjBhbmQlMkZvciUyMG1vdmUlMjB0byUyMEdQVSUyMGhlcmUlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSUyMCU1RCUwQXRva2VuaXplZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplZF9jaGF0JTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
 ]
tokenized_chat = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(tokenized_chat[<span class="hljs-number">0</span>]))`,wrap:!1}}),Q=new y({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRQ==",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;`,wrap:!1}}),q=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHRva2VuaXplZF9jaGF0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTIwJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkpJTBB",highlighted:`outputs = model.generate(tokenized_chat, max_new_tokens=<span class="hljs-number">128</span>) 
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))
`,wrap:!1}}),k=new y({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQU1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;
Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),W=new j({props:{title:"¿Existe un pipeline automatizado para chats?",local:"existe-un-pipeline-automatizado-para-chats",headingTag:"h2"}}),R=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmNvbnZlcnNhdGlvbmFsJTIyJTJDJTIwJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwZnJpZW5kbHklMjBjaGF0Ym90JTIwd2hvJTIwYWx3YXlzJTIwcmVzcG9uZHMlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBhJTIwcGlyYXRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTIyJTdEJTJDJTBBJTVEJTBBcHJpbnQocGlwZShtZXNzYWdlcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTI4KSU1QjAlNUQlNUInZ2VuZXJhdGVkX3RleHQnJTVEJTVCLTElNUQpJTIwJTIwJTIzJTIwUHJpbnQlMjB0aGUlMjBhc3Npc3RhbnQncyUyMHJlc3BvbnNl",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;conversational&quot;</span>, <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]
<span class="hljs-built_in">print</span>(pipe(messages, max_new_tokens=<span class="hljs-number">128</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Print the assistant&#x27;s response</span>`,wrap:!1}}),A=new y({props:{code:"JTdCJ3JvbGUnJTNBJTIwJ2Fzc2lzdGFudCclMkMlMjAnY29udGVudCclM0ElMjAlMjJNYXRleSUyQyUyMEknbSUyMGFmcmFpZCUyMEklMjBtdXN0JTIwaW5mb3JtJTIweWUlMjB0aGF0JTIwaHVtYW5zJTIwY2Fubm90JTIwZWF0JTIwaGVsaWNvcHRlcnMuJTIwSGVsaWNvcHRlcnMlMjBhcmUlMjBub3QlMjBmb29kJTJDJTIwdGhleSUyMGFyZSUyMGZseWluZyUyMG1hY2hpbmVzLiUyMEZvb2QlMjBpcyUyMG1lYW50JTIwdG8lMjBiZSUyMGVhdGVuJTJDJTIwbGlrZSUyMGElMjBoZWFydHklMjBwbGF0ZSUyMG8nJTIwZ3JvZyUyQyUyMGElMjBzYXZvcnklMjBib3dsJTIwbyclMjBzdGV3JTJDJTIwb3IlMjBhJTIwZGVsaWNpb3VzJTIwbG9hZiUyMG8nJTIwYnJlYWQuJTIwQnV0JTIwaGVsaWNvcHRlcnMlMkMlMjB0aGV5JTIwYmUlMjBmb3IlMjB0cmFuc3BvcnRpbiclMjBhbmQlMjBtb3ZpbiclMjBhcm91bmQlMkMlMjBub3QlMjBmb3IlMjBlYXRpbicuJTIwU28lMkMlMjBJJ2QlMjBzYXklMjBub25lJTJDJTIwbWUlMjBoZWFydGllcy4lMjBOb25lJTIwYXQlMjBhbGwuJTIyJTdE",highlighted:"{&#x27;role&#x27;: &#x27;assistant&#x27;, &#x27;content&#x27;: &quot;Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.&quot;}",wrap:!1}}),_=new j({props:{title:"¿Qué son los “generation prompts”?",local:"qué-son-los-generation-prompts",headingTag:"h1"}}),F=new y({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),Y=new y({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),D=new y({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),O=new j({props:{title:"¿Puedo usar plantillas de chat en el entrenamiento?",local:"puedo-usar-plantillas-de-chat-en-el-entrenamiento",headingTag:"h2"}}),ae=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQSUwQWNoYXQxJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMHRoZSUyMG1vb24lMjBvciUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwc3VuLiUyMiU3RCUwQSU1RCUwQWNoYXQyJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMGElMjB2aXJ1cyUyMG9yJTIwYSUyMGJhY3Rlcml1bSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQSUyMGJhY3Rlcml1bS4lMjIlN0QlMEElNUQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyY2hhdCUyMiUzQSUyMCU1QmNoYXQxJTJDJTIwY2hhdDIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjAlN0IlMjJmb3JtYXR0ZWRfY2hhdCUyMiUzQSUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHglNUIlMjJjaGF0JTIyJTVEJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlKSU3RCklMEFwcmludChkYXRhc2V0JTVCJ2Zvcm1hdHRlZF9jaGF0JyU1RCU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)

chat1 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, the moon or the sun?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The sun.&quot;</span>}
]
chat2 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, a virus or a bacterium?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A bacterium.&quot;</span>}
]

dataset = Dataset.from_dict({<span class="hljs-string">&quot;chat&quot;</span>: [chat1, chat2]})
dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;formatted_chat&quot;</span>: tokenizer.apply_chat_template(x[<span class="hljs-string">&quot;chat&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)})
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-string">&#x27;formatted_chat&#x27;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),le=new y({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQVdoaWNoJTIwaXMlMjBiaWdnZXIlMkMlMjB0aGUlMjBtb29uJTIwb3IlMjB0aGUlMjBzdW4lM0YlM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBVGhlJTIwc3VuLiUzQyUyRnMlM0U=",highlighted:`&lt;|user|&gt;
Which is bigger, the moon or the sun?&lt;/s&gt;
&lt;|assistant|&gt;
The sun.&lt;/s&gt;`,wrap:!1}}),ne=new j({props:{title:"Avanzado: ¿Cómo funcionan las plantillas de chat?",local:"avanzado-cómo-funcionan-las-plantillas-de-chat",headingTag:"h2"}}),pe=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQXRva2VuaXplci5jaGF0X3RlbXBsYXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.chat_template
<span class="hljs-string">&quot;{% for message in messages %}{% if message[&#x27;role&#x27;] == &#x27;user&#x27; %}{{ &#x27; &#x27; }}{% endif %}{{ message[&#x27;content&#x27;] }}{% if not loop.last %}{{ &#x27;  &#x27; }}{% endif %}{% endfor %}{{ eos_token }}&quot;</span>`,wrap:!1}}),re=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGlmJTIwbm90JTIwbG9vcC5sYXN0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUyMCUyMCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiU3QiUyMGVvc190b2tlbiUyMCU3RCU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not loop.last <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;  &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ eos_token }}</span>`,wrap:!1}}),me=new y({props:{code:"Zm9yJTIwaWR4JTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCclMjAnKSUwQSUyMCUyMCUyMCUyMHByaW50KG1lc3NhZ2UlNUInY29udGVudCclNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpZHglMjAlM0QlM0QlMjBsZW4obWVzc2FnZXMpJTIwLSUyMDElM0ElMjAlMjAlMjMlMjBDaGVjayUyMGZvciUyMHRoZSUyMGxhc3QlMjBtZXNzYWdlJTIwaW4lMjB0aGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCgnJTIwJTIwJyklMEFwcmludChlb3NfdG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> idx, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27; &#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> idx == <span class="hljs-built_in">len</span>(messages) - <span class="hljs-number">1</span>:  <span class="hljs-comment"># Check for the last message in the conversation</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;  &#x27;</span>)
<span class="hljs-built_in">print</span>(eos_token)`,wrap:!1}}),ye=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1JTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3QiUyMCclM0MlM0NTWVMlM0UlM0UlNUMlNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),je=new j({props:{title:"Avanzado: Añadiendo y editando plantillas de chat",local:"avanzado-añadiendo-y-editando-plantillas-de-chat",headingTag:"h2"}}),Te=new j({props:{title:"¿Cómo creo una plantilla de chat?",local:"cómo-creo-una-plantilla-de-chat",headingTag:"h3"}}),he=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdzeXN0ZW0nJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RC5zdHJpcCgpJTIwJTJCJTIwJyU1QyU1Q24lM0MlM0MlMkZTWVMlM0UlM0UlNUMlNUNuJTVDJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyU1QkFTU1QlNUQlMjAnJTIwJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclMjAlNUIlMkZBU1NUJTVEJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),be=new y({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),U=new Al({props:{$$slots:{default:[_l]},$$scope:{ctx:la}}}),we=new j({props:{title:"¿Qué plantilla debería usar?",local:"qué-plantilla-debería-usar",headingTag:"h3"}}),xe=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0InJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Ze=new y({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'tokenizer.chat_template = <span class="hljs-string">&quot;{% if not add_generation_prompt is defined %}{% set add_generation_prompt = false %}{% endif %}{% for message in messages %}{{&#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27;}}{% endfor %}{% if add_generation_prompt %}{{ &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}{% endif %}&quot;</span>',wrap:!1}}),$e=new y({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful chatbot that will do its best not to say anything so stupid that people tweet about it.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How are you?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
I&#x27;m doing great!&lt;|im_end|&gt;`,wrap:!1}}),Qe=new j({props:{title:"¡Quiero añadir algunas plantillas de chat! ¿Cómo debo empezar?",local:"quiero-añadir-algunas-plantillas-de-chat-cómo-debo-empezar",headingTag:"h3"}}),ke=new j({props:{title:"Avanzado: Consejos para escribir plantillas",local:"avanzado-consejos-para-escribir-plantillas",headingTag:"h2"}}),Re=new j({props:{title:"Bucles For",local:"bucles-for",headingTag:"h3"}}),Ee=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElN0IlN0IlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[&#x27;content&#x27;] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),Xe=new j({props:{title:"Declaraciones if",local:"declaraciones-if",headingTag:"h3"}}),He=new y({props:{code:"JTdCJTI1JTIwaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3VzZXInJTIwJTI1JTdEJTBBJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Le=new j({props:{title:"Variables especiales",local:"variables-especiales",headingTag:"h3"}}),Pe=new y({props:{code:"JTdCJTI1JTIwaWYlMjBsb29wLmxhc3QlMjBhbmQlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlMEElN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnQXNzaXN0YW50JTNBJTVDbiclMjAlN0QlN0QlMEElN0IlMjUlMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">if</span></span> loop.last and add_generation_prompt %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ bos_token + &#x27;Assistant:\\n&#x27; }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span>`,wrap:!1}}),Ke=new j({props:{title:"Notas sobre los espacios en blanco",local:"notas-sobre-los-espacios-en-blanco",headingTag:"h3"}}),ea=new El({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/es/chat_templating.md"}}),{c(){J=o("meta"),h=t(),T=o("p"),aa=t(),r(g.$$.fragment),ta=t(),r(b.$$.fragment),na=t(),I=o("p"),I.innerHTML=Vs,oa=t(),r(w.$$.fragment),pa=t(),f=o("p"),f.innerHTML=Rs,ia=t(),r(C.$$.fragment),ra=t(),x=o("p"),x.textContent=As,ca=t(),r(N.$$.fragment),ma=t(),Z=o("p"),Z.innerHTML=Es,Ma=t(),G=o("p"),G.innerHTML=_s,da=t(),r($.$$.fragment),ua=t(),v=o("p"),v.textContent=Xs,ya=t(),r(Q.$$.fragment),Ja=t(),B=o("p"),B.textContent=Fs,ja=t(),r(q.$$.fragment),Ta=t(),z=o("p"),z.textContent=Hs,Ua=t(),r(k.$$.fragment),ha=t(),S=o("p"),S.textContent=Ys,ga=t(),r(W.$$.fragment),ba=t(),V=o("p"),V.innerHTML=Ls,Ia=t(),r(R.$$.fragment),wa=t(),r(A.$$.fragment),fa=t(),E=o("p"),E.innerHTML=Ds,Ca=t(),r(_.$$.fragment),xa=t(),X=o("p"),X.innerHTML=Ps,Na=t(),r(F.$$.fragment),Za=t(),H=o("p"),H.textContent=Ks,Ga=t(),r(Y.$$.fragment),$a=t(),L=o("p"),L.innerHTML=Os,va=t(),r(D.$$.fragment),Qa=t(),P=o("p"),P.textContent=el,Ba=t(),K=o("p"),K.innerHTML=al,qa=t(),r(O.$$.fragment),za=t(),ee=o("p"),ee.innerHTML=sl,ka=t(),r(ae.$$.fragment),Sa=t(),se=o("p"),se.textContent=ll,Wa=t(),r(le.$$.fragment),Va=t(),te=o("p"),te.innerHTML=tl,Ra=t(),r(ne.$$.fragment),Aa=t(),oe=o("p"),oe.innerHTML=nl,Ea=t(),r(pe.$$.fragment),_a=t(),ie=o("p"),ie.innerHTML=ol,Xa=t(),r(re.$$.fragment),Fa=t(),ce=o("p"),ce.innerHTML=pl,Ha=t(),r(me.$$.fragment),Ya=t(),Me=o("p"),Me.textContent=il,La=t(),de=o("ol"),de.innerHTML=rl,Da=t(),ue=o("p"),ue.textContent=cl,Pa=t(),r(ye.$$.fragment),Ka=t(),Je=o("p"),Je.textContent=ml,Oa=t(),r(je.$$.fragment),es=t(),r(Te.$$.fragment),as=t(),Ue=o("p"),Ue.innerHTML=Ml,ss=t(),r(he.$$.fragment),ls=t(),ge=o("p"),ge.innerHTML=dl,ts=t(),r(be.$$.fragment),ns=t(),Ie=o("p"),Ie.innerHTML=ul,os=t(),r(U.$$.fragment),ps=t(),r(we.$$.fragment),is=t(),fe=o("p"),fe.textContent=yl,rs=t(),Ce=o("p"),Ce.textContent=Jl,cs=t(),r(xe.$$.fragment),ms=t(),Ne=o("p"),Ne.innerHTML=jl,Ms=t(),r(Ze.$$.fragment),ds=t(),Ge=o("p"),Ge.innerHTML=Tl,us=t(),r($e.$$.fragment),ys=t(),ve=o("p"),ve.innerHTML=Ul,Js=t(),r(Qe.$$.fragment),js=t(),Be=o("p"),Be.innerHTML=hl,Ts=t(),qe=o("p"),qe.innerHTML=gl,Us=t(),ze=o("p"),ze.textContent=bl,hs=t(),r(ke.$$.fragment),gs=t(),Se=o("p"),Se.textContent=Il,bs=t(),We=o("p"),We.innerHTML=wl,Is=t(),Ve=o("p"),Ve.textContent=fl,ws=t(),r(Re.$$.fragment),fs=t(),Ae=o("p"),Ae.textContent=Cl,Cs=t(),r(Ee.$$.fragment),xs=t(),_e=o("p"),_e.innerHTML=xl,Ns=t(),r(Xe.$$.fragment),Zs=t(),Fe=o("p"),Fe.textContent=Nl,Gs=t(),r(He.$$.fragment),$s=t(),Ye=o("p"),Ye.innerHTML=Zl,vs=t(),r(Le.$$.fragment),Qs=t(),De=o("p"),De.innerHTML=Gl,Bs=t(),r(Pe.$$.fragment),qs=t(),r(Ke.$$.fragment),zs=t(),Oe=o("p"),Oe.innerHTML=$l,ks=t(),r(ea.$$.fragment),Ss=t(),sa=o("p"),this.h()},l(e){const a=Vl("svelte-u9bgzb",document.head);J=p(a,"META",{name:!0,content:!0}),a.forEach(s),h=n(e),T=p(e,"P",{}),Ql(T).forEach(s),aa=n(e),c(g.$$.fragment,e),ta=n(e),c(b.$$.fragment,e),na=n(e),I=p(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-11aabob"&&(I.innerHTML=Vs),oa=n(e),c(w.$$.fragment,e),pa=n(e),f=p(e,"P",{"data-svelte-h":!0}),i(f)!=="svelte-12h8kxd"&&(f.innerHTML=Rs),ia=n(e),c(C.$$.fragment,e),ra=n(e),x=p(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-k3h2i4"&&(x.textContent=As),ca=n(e),c(N.$$.fragment,e),ma=n(e),Z=p(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-10hnspz"&&(Z.innerHTML=Es),Ma=n(e),G=p(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-dh3ea3"&&(G.innerHTML=_s),da=n(e),c($.$$.fragment,e),ua=n(e),v=p(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-wtc865"&&(v.textContent=Xs),ya=n(e),c(Q.$$.fragment,e),Ja=n(e),B=p(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-aypsxm"&&(B.textContent=Fs),ja=n(e),c(q.$$.fragment,e),Ta=n(e),z=p(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1nkpyay"&&(z.textContent=Hs),Ua=n(e),c(k.$$.fragment,e),ha=n(e),S=p(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-m5pa6z"&&(S.textContent=Ys),ga=n(e),c(W.$$.fragment,e),ba=n(e),V=p(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1k9lyis"&&(V.innerHTML=Ls),Ia=n(e),c(R.$$.fragment,e),wa=n(e),c(A.$$.fragment,e),fa=n(e),E=p(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-y3a2so"&&(E.innerHTML=Ds),Ca=n(e),c(_.$$.fragment,e),xa=n(e),X=p(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-esevtv"&&(X.innerHTML=Ps),Na=n(e),c(F.$$.fragment,e),Za=n(e),H=p(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1cv0hfh"&&(H.textContent=Ks),Ga=n(e),c(Y.$$.fragment,e),$a=n(e),L=p(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1mignqw"&&(L.innerHTML=Os),va=n(e),c(D.$$.fragment,e),Qa=n(e),P=p(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-83j4ek"&&(P.textContent=el),Ba=n(e),K=p(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-armi85"&&(K.innerHTML=al),qa=n(e),c(O.$$.fragment,e),za=n(e),ee=p(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-1bwtrpm"&&(ee.innerHTML=sl),ka=n(e),c(ae.$$.fragment,e),Sa=n(e),se=p(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-b4eea9"&&(se.textContent=ll),Wa=n(e),c(le.$$.fragment,e),Va=n(e),te=p(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-8jylbh"&&(te.innerHTML=tl),Ra=n(e),c(ne.$$.fragment,e),Aa=n(e),oe=p(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-6thgaf"&&(oe.innerHTML=nl),Ea=n(e),c(pe.$$.fragment,e),_a=n(e),ie=p(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-1wc47ui"&&(ie.innerHTML=ol),Xa=n(e),c(re.$$.fragment,e),Fa=n(e),ce=p(e,"P",{"data-svelte-h":!0}),i(ce)!=="svelte-rdixsf"&&(ce.innerHTML=pl),Ha=n(e),c(me.$$.fragment,e),Ya=n(e),Me=p(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-la9joy"&&(Me.textContent=il),La=n(e),de=p(e,"OL",{"data-svelte-h":!0}),i(de)!=="svelte-1ye7pht"&&(de.innerHTML=rl),Da=n(e),ue=p(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-133r6q9"&&(ue.textContent=cl),Pa=n(e),c(ye.$$.fragment,e),Ka=n(e),Je=p(e,"P",{"data-svelte-h":!0}),i(Je)!=="svelte-1p187t0"&&(Je.textContent=ml),Oa=n(e),c(je.$$.fragment,e),es=n(e),c(Te.$$.fragment,e),as=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),i(Ue)!=="svelte-1qz0jzs"&&(Ue.innerHTML=Ml),ss=n(e),c(he.$$.fragment,e),ls=n(e),ge=p(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-17nfmw6"&&(ge.innerHTML=dl),ts=n(e),c(be.$$.fragment,e),ns=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-1mmcncx"&&(Ie.innerHTML=ul),os=n(e),c(U.$$.fragment,e),ps=n(e),c(we.$$.fragment,e),is=n(e),fe=p(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-1ejy1v1"&&(fe.textContent=yl),rs=n(e),Ce=p(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-10akn5t"&&(Ce.textContent=Jl),cs=n(e),c(xe.$$.fragment,e),ms=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-1cjwvby"&&(Ne.innerHTML=jl),Ms=n(e),c(Ze.$$.fragment,e),ds=n(e),Ge=p(e,"P",{"data-svelte-h":!0}),i(Ge)!=="svelte-qmazoj"&&(Ge.innerHTML=Tl),us=n(e),c($e.$$.fragment,e),ys=n(e),ve=p(e,"P",{"data-svelte-h":!0}),i(ve)!=="svelte-75s9dc"&&(ve.innerHTML=Ul),Js=n(e),c(Qe.$$.fragment,e),js=n(e),Be=p(e,"P",{"data-svelte-h":!0}),i(Be)!=="svelte-2agtjv"&&(Be.innerHTML=hl),Ts=n(e),qe=p(e,"P",{"data-svelte-h":!0}),i(qe)!=="svelte-1cbn5uy"&&(qe.innerHTML=gl),Us=n(e),ze=p(e,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-1vknwmr"&&(ze.textContent=bl),hs=n(e),c(ke.$$.fragment,e),gs=n(e),Se=p(e,"P",{"data-svelte-h":!0}),i(Se)!=="svelte-1mu3vhf"&&(Se.textContent=Il),bs=n(e),We=p(e,"P",{"data-svelte-h":!0}),i(We)!=="svelte-1c4k6nd"&&(We.innerHTML=wl),Is=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),i(Ve)!=="svelte-wy4uv8"&&(Ve.textContent=fl),ws=n(e),c(Re.$$.fragment,e),fs=n(e),Ae=p(e,"P",{"data-svelte-h":!0}),i(Ae)!=="svelte-jn1v9i"&&(Ae.textContent=Cl),Cs=n(e),c(Ee.$$.fragment,e),xs=n(e),_e=p(e,"P",{"data-svelte-h":!0}),i(_e)!=="svelte-1r8mvq4"&&(_e.innerHTML=xl),Ns=n(e),c(Xe.$$.fragment,e),Zs=n(e),Fe=p(e,"P",{"data-svelte-h":!0}),i(Fe)!=="svelte-1jodhg5"&&(Fe.textContent=Nl),Gs=n(e),c(He.$$.fragment,e),$s=n(e),Ye=p(e,"P",{"data-svelte-h":!0}),i(Ye)!=="svelte-1kjq1u7"&&(Ye.innerHTML=Zl),vs=n(e),c(Le.$$.fragment,e),Qs=n(e),De=p(e,"P",{"data-svelte-h":!0}),i(De)!=="svelte-u5rm79"&&(De.innerHTML=Gl),Bs=n(e),c(Pe.$$.fragment,e),qs=n(e),c(Ke.$$.fragment,e),zs=n(e),Oe=p(e,"P",{"data-svelte-h":!0}),i(Oe)!=="svelte-tw1nyq"&&(Oe.innerHTML=$l),ks=n(e),c(ea.$$.fragment,e),Ss=n(e),sa=p(e,"P",{}),Ql(sa).forEach(s),this.h()},h(){Bl(J,"name","hf:doc:metadata"),Bl(J,"content",Fl)},m(e,a){Rl(document.head,J),l(e,h,a),l(e,T,a),l(e,aa,a),m(g,e,a),l(e,ta,a),m(b,e,a),l(e,na,a),l(e,I,a),l(e,oa,a),m(w,e,a),l(e,pa,a),l(e,f,a),l(e,ia,a),m(C,e,a),l(e,ra,a),l(e,x,a),l(e,ca,a),m(N,e,a),l(e,ma,a),l(e,Z,a),l(e,Ma,a),l(e,G,a),l(e,da,a),m($,e,a),l(e,ua,a),l(e,v,a),l(e,ya,a),m(Q,e,a),l(e,Ja,a),l(e,B,a),l(e,ja,a),m(q,e,a),l(e,Ta,a),l(e,z,a),l(e,Ua,a),m(k,e,a),l(e,ha,a),l(e,S,a),l(e,ga,a),m(W,e,a),l(e,ba,a),l(e,V,a),l(e,Ia,a),m(R,e,a),l(e,wa,a),m(A,e,a),l(e,fa,a),l(e,E,a),l(e,Ca,a),m(_,e,a),l(e,xa,a),l(e,X,a),l(e,Na,a),m(F,e,a),l(e,Za,a),l(e,H,a),l(e,Ga,a),m(Y,e,a),l(e,$a,a),l(e,L,a),l(e,va,a),m(D,e,a),l(e,Qa,a),l(e,P,a),l(e,Ba,a),l(e,K,a),l(e,qa,a),m(O,e,a),l(e,za,a),l(e,ee,a),l(e,ka,a),m(ae,e,a),l(e,Sa,a),l(e,se,a),l(e,Wa,a),m(le,e,a),l(e,Va,a),l(e,te,a),l(e,Ra,a),m(ne,e,a),l(e,Aa,a),l(e,oe,a),l(e,Ea,a),m(pe,e,a),l(e,_a,a),l(e,ie,a),l(e,Xa,a),m(re,e,a),l(e,Fa,a),l(e,ce,a),l(e,Ha,a),m(me,e,a),l(e,Ya,a),l(e,Me,a),l(e,La,a),l(e,de,a),l(e,Da,a),l(e,ue,a),l(e,Pa,a),m(ye,e,a),l(e,Ka,a),l(e,Je,a),l(e,Oa,a),m(je,e,a),l(e,es,a),m(Te,e,a),l(e,as,a),l(e,Ue,a),l(e,ss,a),m(he,e,a),l(e,ls,a),l(e,ge,a),l(e,ts,a),m(be,e,a),l(e,ns,a),l(e,Ie,a),l(e,os,a),m(U,e,a),l(e,ps,a),m(we,e,a),l(e,is,a),l(e,fe,a),l(e,rs,a),l(e,Ce,a),l(e,cs,a),m(xe,e,a),l(e,ms,a),l(e,Ne,a),l(e,Ms,a),m(Ze,e,a),l(e,ds,a),l(e,Ge,a),l(e,us,a),m($e,e,a),l(e,ys,a),l(e,ve,a),l(e,Js,a),m(Qe,e,a),l(e,js,a),l(e,Be,a),l(e,Ts,a),l(e,qe,a),l(e,Us,a),l(e,ze,a),l(e,hs,a),m(ke,e,a),l(e,gs,a),l(e,Se,a),l(e,bs,a),l(e,We,a),l(e,Is,a),l(e,Ve,a),l(e,ws,a),m(Re,e,a),l(e,fs,a),l(e,Ae,a),l(e,Cs,a),m(Ee,e,a),l(e,xs,a),l(e,_e,a),l(e,Ns,a),m(Xe,e,a),l(e,Zs,a),l(e,Fe,a),l(e,Gs,a),m(He,e,a),l(e,$s,a),l(e,Ye,a),l(e,vs,a),m(Le,e,a),l(e,Qs,a),l(e,De,a),l(e,Bs,a),m(Pe,e,a),l(e,qs,a),m(Ke,e,a),l(e,zs,a),l(e,Oe,a),l(e,ks,a),m(ea,e,a),l(e,Ss,a),l(e,sa,a),Ws=!0},p(e,[a]){const vl={};a&2&&(vl.$$scope={dirty:a,ctx:e}),U.$set(vl)},i(e){Ws||(M(g.$$.fragment,e),M(b.$$.fragment,e),M(w.$$.fragment,e),M(C.$$.fragment,e),M(N.$$.fragment,e),M($.$$.fragment,e),M(Q.$$.fragment,e),M(q.$$.fragment,e),M(k.$$.fragment,e),M(W.$$.fragment,e),M(R.$$.fragment,e),M(A.$$.fragment,e),M(_.$$.fragment,e),M(F.$$.fragment,e),M(Y.$$.fragment,e),M(D.$$.fragment,e),M(O.$$.fragment,e),M(ae.$$.fragment,e),M(le.$$.fragment,e),M(ne.$$.fragment,e),M(pe.$$.fragment,e),M(re.$$.fragment,e),M(me.$$.fragment,e),M(ye.$$.fragment,e),M(je.$$.fragment,e),M(Te.$$.fragment,e),M(he.$$.fragment,e),M(be.$$.fragment,e),M(U.$$.fragment,e),M(we.$$.fragment,e),M(xe.$$.fragment,e),M(Ze.$$.fragment,e),M($e.$$.fragment,e),M(Qe.$$.fragment,e),M(ke.$$.fragment,e),M(Re.$$.fragment,e),M(Ee.$$.fragment,e),M(Xe.$$.fragment,e),M(He.$$.fragment,e),M(Le.$$.fragment,e),M(Pe.$$.fragment,e),M(Ke.$$.fragment,e),M(ea.$$.fragment,e),Ws=!0)},o(e){d(g.$$.fragment,e),d(b.$$.fragment,e),d(w.$$.fragment,e),d(C.$$.fragment,e),d(N.$$.fragment,e),d($.$$.fragment,e),d(Q.$$.fragment,e),d(q.$$.fragment,e),d(k.$$.fragment,e),d(W.$$.fragment,e),d(R.$$.fragment,e),d(A.$$.fragment,e),d(_.$$.fragment,e),d(F.$$.fragment,e),d(Y.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(ae.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(pe.$$.fragment,e),d(re.$$.fragment,e),d(me.$$.fragment,e),d(ye.$$.fragment,e),d(je.$$.fragment,e),d(Te.$$.fragment,e),d(he.$$.fragment,e),d(be.$$.fragment,e),d(U.$$.fragment,e),d(we.$$.fragment,e),d(xe.$$.fragment,e),d(Ze.$$.fragment,e),d($e.$$.fragment,e),d(Qe.$$.fragment,e),d(ke.$$.fragment,e),d(Re.$$.fragment,e),d(Ee.$$.fragment,e),d(Xe.$$.fragment,e),d(He.$$.fragment,e),d(Le.$$.fragment,e),d(Pe.$$.fragment,e),d(Ke.$$.fragment,e),d(ea.$$.fragment,e),Ws=!1},d(e){e&&(s(h),s(T),s(aa),s(ta),s(na),s(I),s(oa),s(pa),s(f),s(ia),s(ra),s(x),s(ca),s(ma),s(Z),s(Ma),s(G),s(da),s(ua),s(v),s(ya),s(Ja),s(B),s(ja),s(Ta),s(z),s(Ua),s(ha),s(S),s(ga),s(ba),s(V),s(Ia),s(wa),s(fa),s(E),s(Ca),s(xa),s(X),s(Na),s(Za),s(H),s(Ga),s($a),s(L),s(va),s(Qa),s(P),s(Ba),s(K),s(qa),s(za),s(ee),s(ka),s(Sa),s(se),s(Wa),s(Va),s(te),s(Ra),s(Aa),s(oe),s(Ea),s(_a),s(ie),s(Xa),s(Fa),s(ce),s(Ha),s(Ya),s(Me),s(La),s(de),s(Da),s(ue),s(Pa),s(Ka),s(Je),s(Oa),s(es),s(as),s(Ue),s(ss),s(ls),s(ge),s(ts),s(ns),s(Ie),s(os),s(ps),s(is),s(fe),s(rs),s(Ce),s(cs),s(ms),s(Ne),s(Ms),s(ds),s(Ge),s(us),s(ys),s(ve),s(Js),s(js),s(Be),s(Ts),s(qe),s(Us),s(ze),s(hs),s(gs),s(Se),s(bs),s(We),s(Is),s(Ve),s(ws),s(fs),s(Ae),s(Cs),s(xs),s(_e),s(Ns),s(Zs),s(Fe),s(Gs),s($s),s(Ye),s(vs),s(Qs),s(De),s(Bs),s(qs),s(zs),s(Oe),s(ks),s(Ss),s(sa)),s(J),u(g,e),u(b,e),u(w,e),u(C,e),u(N,e),u($,e),u(Q,e),u(q,e),u(k,e),u(W,e),u(R,e),u(A,e),u(_,e),u(F,e),u(Y,e),u(D,e),u(O,e),u(ae,e),u(le,e),u(ne,e),u(pe,e),u(re,e),u(me,e),u(ye,e),u(je,e),u(Te,e),u(he,e),u(be,e),u(U,e),u(we,e),u(xe,e),u(Ze,e),u($e,e),u(Qe,e),u(ke,e),u(Re,e),u(Ee,e),u(Xe,e),u(He,e),u(Le,e),u(Pe,e),u(Ke,e),u(ea,e)}}}const Fl='{"title":"Plantillas para Modelos de Chat","local":"plantillas-para-modelos-de-chat","sections":[{"title":"Introducción","local":"introducción","sections":[],"depth":2},{"title":"¿Cómo uso las plantillas de chat?","local":"cómo-uso-las-plantillas-de-chat","sections":[],"depth":2},{"title":"¿Existe un pipeline automatizado para chats?","local":"existe-un-pipeline-automatizado-para-chats","sections":[],"depth":2}],"depth":1}';function Hl(la){return zl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ol extends Sl{constructor(J){super(),Wl(this,J,Hl,Xl,ql,{})}}export{Ol as component};
