import{s as Ot,n as el,o as tl}from"../chunks/scheduler.36a0863c.js";import{S as ll,i as nl,g as s,s as a,r as p,A as al,h as o,f as l,c as i,j as Dt,u as r,x as m,k as Kt,y as il,a as n,v as u,d as g,t as d,w as c}from"../chunks/index.9c13489a.js";import{C as M}from"../chunks/CodeBlock.a6a4e7b6.js";import{D as sl}from"../chunks/DocNotebookDropdown.611fec79.js";import{H as f,E as ol}from"../chunks/index.fab8c5af.js";function ml(Tt){let b,Je,be,Te,J,he,T,ye,h,ht='Ci sono diversi modelli multilingue in 🤗 Transformers, e il loro utilizzo per l’inferenza differisce da quello dei modelli monolingua. Non <em>tutti</em> gli utilizzi dei modelli multilingue sono però diversi. Alcuni modelli, come <a href="https://huggingface.co/google-bert/bert-base-multilingual-uncased" rel="nofollow">google-bert/bert-base-multilingual-uncased</a>, possono essere usati come un modello monolingua. Questa guida ti mostrerà come utilizzare modelli multilingue che utilizzano un modo diverso per fare l’inferenza.',Ue,y,$e,U,yt="XLM ha dieci diversi checkpoint, di cui solo uno è monolingua. I nove checkpoint rimanenti possono essere suddivisi in due categorie: i checkpoint che utilizzano i language embeddings e quelli che non li utilizzano.",ke,$,je,k,Ut="I seguenti modelli XLM utilizzano gli embeddings linguistici per specificare la lingua utilizzata per l’inferenza:",we,j,$t="<li><code>FacebookAI/xlm-mlm-ende-1024</code> (Modellazione mascherata del linguaggio (Masked language modeling, in inglese), Inglese-Tedesco)</li> <li><code>FacebookAI/xlm-mlm-enfr-1024</code> (Modellazione mascherata del linguaggio, Inglese-Francese)</li> <li><code>FacebookAI/xlm-mlm-enro-1024</code> (Modellazione mascherata del linguaggio, Inglese-Rumeno)</li> <li><code>FacebookAI/xlm-mlm-xnli15-1024</code> (Modellazione mascherata del linguaggio, lingue XNLI)</li> <li><code>FacebookAI/xlm-mlm-tlm-xnli15-1024</code> (Modellazione mascherata del linguaggio + traduzione, lingue XNLI)</li> <li><code>FacebookAI/xlm-clm-enfr-1024</code> (Modellazione causale del linguaggio, Inglese-Francese)</li> <li><code>FacebookAI/xlm-clm-ende-1024</code> (Modellazione causale del linguaggio, Inglese-Tedesco)</li>",ve,w,kt="Gli embeddings linguistici sono rappresentati come un tensore delle stesse dimensioni dell’ <code>input_ids</code> passato al modello. I valori in questi tensori dipendono dal linguaggio usato e sono identificati dagli attributi <code>lang2id</code> e <code>id2lang</code> del tokenizer.",ze,v,jt="In questo esempio, carica il checkpoint <code>FacebookAI/xlm-clm-enfr-1024</code> (Modellazione causale del linguaggio, Inglese-Francese):",xe,z,Ie,x,wt="L’attributo <code>lang2id</code> del tokenizer mostra il linguaggio del modello e il suo ids:",Ze,I,_e,Z,vt="Poi, crea un esempio di input:",Ce,_,Xe,C,zt="Imposta l’id del linguaggio a <code>&quot;en&quot;</code> e usalo per definire il language embedding. Il language embedding è un tensore riempito con <code>0</code> perché questo è il language id per l’inglese. Questo tensore dovrebbe avere la stessa dimensione di <code>input_ids</code>.",Ge,X,We,G,xt="Adesso puoi inserire <code>input_ids</code> e language embedding nel modello:",Ve,W,Le,V,It='Lo script <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> può generare testo tramite i language embeddings usando i checkpoints <code>xlm-clm</code>.',Re,L,Be,R,Zt="I seguenti modelli XLM non richiedono l’utilizzo dei language embeddings per fare inferenza:",Fe,B,_t="<li><code>FacebookAI/xlm-mlm-17-1280</code> (Modellazione mascherata del linguaggio, 17 lingue)</li> <li><code>FacebookAI/xlm-mlm-100-1280</code> (Modellazione mascherata del linguaggio, 100 lingue)</li>",Ee,F,Ct="Questi modelli sono utilizzati per rappresentazioni generiche di frasi, a differenza dei precedenti checkpoints XML.",He,E,qe,H,Xt="Il seguente modello BERT può essere usato per compiti multilingue:",Qe,q,Gt="<li><code>google-bert/bert-base-multilingual-uncased</code> (Modellazione mascherata del linguaggio + Previsione della prossima frase, 102 lingue)</li> <li><code>google-bert/bert-base-multilingual-cased</code> (Modellazione mascherata del linguaggio + Previsione della prossima frase, 104 lingue)</li>",Ye,Q,Wt="Questi modelli non richiedono language embeddings per fare inferenza. Riescono ad identificare il linguaggio dal contesto e inferire di conseguenza.",Ne,Y,Ae,N,Vt="Il seguente modello XLM-RoBERTa può essere usato per compiti multilingue:",Pe,A,Lt="<li><code>FacebookAI/xlm-roberta-base</code> (Modellazione mascherata del linguaggio, 100 lingue)</li> <li><code>FacebookAI/xlm-roberta-large</code> (Modellazione mascherata del linguaggio, 100 lingue)</li>",Se,P,Rt="XLM-RoBERTa è stato addestrato su 2.5TB di dati CommonCrawl appena creati e puliti in 100 lingue. Offre notevoli vantaggi rispetto ai modelli multilingue rilasciati in precedenza, come mBERT o XLM, in compiti come la classificazione, l’etichettatura delle sequenze e la risposta alle domande.",De,S,Ke,D,Bt="Il seguente modello M2M100 può essere usato per compiti multilingue:",Oe,K,Ft="<li><code>facebook/m2m100_418M</code> (Traduzione)</li> <li><code>facebook/m2m100_1.2B</code> (Traduzione)</li>",et,O,Et="In questo esempio, carica il checkpoint <code>facebook/m2m100_418M</code>  per tradurre dal cinese all’inglese. Puoi impostare la lingua di partenza nel tokenizer:",tt,ee,lt,te,Ht="Applica il tokenizer al testo:",nt,le,at,ne,qt="M2M100 forza l’id della lingua obiettivo come primo token generato per tradurre nella lingua obiettivo. Imposta il parametro <code>forced_bos_token_id</code> a <code>en</code> nel metodo <code>generate</code> per tradurre in inglese:",it,ae,st,ie,ot,se,Qt="Il seguente modello MBart può essere usato per compiti multilingue:",mt,oe,Yt="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> (Traduzione automatica multilingue uno-a-molti, 50 lingue)</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> (Traduzione automatica multilingue molti-a-molti, 50 lingue)</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> (Traduzione automatica multilingue molti-a-uno, 50 lingue)</li> <li><code>facebook/mbart-large-50</code> (Traduzione multilingue, 50 lingue)</li> <li><code>facebook/mbart-large-cc25</code></li>",pt,me,Nt="In questo esempio, carica il checkpoint <code>facebook/mbart-large-50-many-to-many-mmt</code> per tradurre dal finlandese all’inglese. Puoi impostare la lingua di partenza nel tokenizer:",rt,pe,ut,re,At="Applica il tokenizer sul testo:",gt,ue,dt,ge,Pt="MBart forza l’id della lingua obiettivo come primo token generato per tradurre nella lingua obiettivo. Imposta il parametro <code>forced_bos_token_id</code> a <code>en</code> nel metodo <code>generate</code> per tradurre in inglese:",ct,de,Mt,ce,St="Se stai usando il checkpoint <code>facebook/mbart-large-50-many-to-one-mmt</code>, non hai bisogno di forzare l’id della lingua obiettivo come primo token generato altrimenti l’uso è lo stesso.",bt,Me,ft,fe,Jt;return J=new f({props:{title:"Modelli multilingue per l’inferenza",local:"modelli-multilingue-per-linferenza",headingTag:"h1"}}),T=new sl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/tensorflow/multilingual.ipynb"}]}}),y=new f({props:{title:"XLM",local:"xlm",headingTag:"h2"}}),$=new f({props:{title:"XLM con language embeddings",local:"xlm-con-language-embeddings",headingTag:"h3"}}),z=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJGYWNlYm9va0FJJTJGeGxtLWNsbS1lbmZyLTEwMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBYTE1XaXRoTE1IZWFkTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkZhY2Vib29rQUklMkZ4bG0tY2xtLWVuZnItMTAyNCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;FacebookAI/xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;FacebookAI/xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),I=new M({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),_=new M({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjBvZiUyMDE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size of 1</span>',wrap:!1}}),X=new M({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwV2UlMjByZXNoYXBlJTIwaXQlMjB0byUyMGJlJTIwb2YlMjBzaXplJTIwKGJhdGNoX3NpemUlMkMlMjBzZXF1ZW5jZV9sZW5ndGgpJTBBbGFuZ3MlMjAlM0QlMjBsYW5ncy52aWV3KDElMkMlMjAtMSklMjAlMjAlMjMlMjBpcyUyMG5vdyUyMG9mJTIwc2hhcGUlMjAlNUIxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTVEJTIwKHdlJTIwaGF2ZSUyMGElMjBiYXRjaCUyMHNpemUlMjBvZiUyMDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We reshape it to be of size (batch_size, sequence_length)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># is now of shape [1, sequence_length] (we have a batch size of 1)</span>`,wrap:!1}}),W=new M({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),L=new f({props:{title:"XLM senza language embeddings",local:"xlm-senza-language-embeddings",headingTag:"h3"}}),E=new f({props:{title:"BERT",local:"bert",headingTag:"h2"}}),Y=new f({props:{title:"XLM-RoBERTa",local:"xlm-roberta",headingTag:"h2"}}),S=new f({props:{title:"M2M100",local:"m2m100",headingTag:"h2"}}),ee=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),le=new M({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ae=new M({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),ie=new f({props:{title:"MBart",local:"mbart",headingTag:"h2"}}),pe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),ue=new M({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),de=new M({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkKCUyMmVuX1hYJTIyKSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id(<span class="hljs-string">&quot;en_XX&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),Me=new ol({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/it/multilingual.md"}}),{c(){b=s("meta"),Je=a(),be=s("p"),Te=a(),p(J.$$.fragment),he=a(),p(T.$$.fragment),ye=a(),h=s("p"),h.innerHTML=ht,Ue=a(),p(y.$$.fragment),$e=a(),U=s("p"),U.textContent=yt,ke=a(),p($.$$.fragment),je=a(),k=s("p"),k.textContent=Ut,we=a(),j=s("ul"),j.innerHTML=$t,ve=a(),w=s("p"),w.innerHTML=kt,ze=a(),v=s("p"),v.innerHTML=jt,xe=a(),p(z.$$.fragment),Ie=a(),x=s("p"),x.innerHTML=wt,Ze=a(),p(I.$$.fragment),_e=a(),Z=s("p"),Z.textContent=vt,Ce=a(),p(_.$$.fragment),Xe=a(),C=s("p"),C.innerHTML=zt,Ge=a(),p(X.$$.fragment),We=a(),G=s("p"),G.innerHTML=xt,Ve=a(),p(W.$$.fragment),Le=a(),V=s("p"),V.innerHTML=It,Re=a(),p(L.$$.fragment),Be=a(),R=s("p"),R.textContent=Zt,Fe=a(),B=s("ul"),B.innerHTML=_t,Ee=a(),F=s("p"),F.textContent=Ct,He=a(),p(E.$$.fragment),qe=a(),H=s("p"),H.textContent=Xt,Qe=a(),q=s("ul"),q.innerHTML=Gt,Ye=a(),Q=s("p"),Q.textContent=Wt,Ne=a(),p(Y.$$.fragment),Ae=a(),N=s("p"),N.textContent=Vt,Pe=a(),A=s("ul"),A.innerHTML=Lt,Se=a(),P=s("p"),P.textContent=Rt,De=a(),p(S.$$.fragment),Ke=a(),D=s("p"),D.textContent=Bt,Oe=a(),K=s("ul"),K.innerHTML=Ft,et=a(),O=s("p"),O.innerHTML=Et,tt=a(),p(ee.$$.fragment),lt=a(),te=s("p"),te.textContent=Ht,nt=a(),p(le.$$.fragment),at=a(),ne=s("p"),ne.innerHTML=qt,it=a(),p(ae.$$.fragment),st=a(),p(ie.$$.fragment),ot=a(),se=s("p"),se.textContent=Qt,mt=a(),oe=s("ul"),oe.innerHTML=Yt,pt=a(),me=s("p"),me.innerHTML=Nt,rt=a(),p(pe.$$.fragment),ut=a(),re=s("p"),re.textContent=At,gt=a(),p(ue.$$.fragment),dt=a(),ge=s("p"),ge.innerHTML=Pt,ct=a(),p(de.$$.fragment),Mt=a(),ce=s("p"),ce.innerHTML=St,bt=a(),p(Me.$$.fragment),ft=a(),fe=s("p"),this.h()},l(e){const t=al("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),Je=i(e),be=o(e,"P",{}),Dt(be).forEach(l),Te=i(e),r(J.$$.fragment,e),he=i(e),r(T.$$.fragment,e),ye=i(e),h=o(e,"P",{"data-svelte-h":!0}),m(h)!=="svelte-1y2uj2f"&&(h.innerHTML=ht),Ue=i(e),r(y.$$.fragment,e),$e=i(e),U=o(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-b0zdcx"&&(U.textContent=yt),ke=i(e),r($.$$.fragment,e),je=i(e),k=o(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-6flhpc"&&(k.textContent=Ut),we=i(e),j=o(e,"UL",{"data-svelte-h":!0}),m(j)!=="svelte-hwtd9h"&&(j.innerHTML=$t),ve=i(e),w=o(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1o9s8ae"&&(w.innerHTML=kt),ze=i(e),v=o(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-tnbb9o"&&(v.innerHTML=jt),xe=i(e),r(z.$$.fragment,e),Ie=i(e),x=o(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1lvsgdy"&&(x.innerHTML=wt),Ze=i(e),r(I.$$.fragment,e),_e=i(e),Z=o(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1gs48v1"&&(Z.textContent=vt),Ce=i(e),r(_.$$.fragment,e),Xe=i(e),C=o(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1lqmqx6"&&(C.innerHTML=zt),Ge=i(e),r(X.$$.fragment,e),We=i(e),G=o(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1257czm"&&(G.innerHTML=xt),Ve=i(e),r(W.$$.fragment,e),Le=i(e),V=o(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-docsh6"&&(V.innerHTML=It),Re=i(e),r(L.$$.fragment,e),Be=i(e),R=o(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1fsmnuh"&&(R.textContent=Zt),Fe=i(e),B=o(e,"UL",{"data-svelte-h":!0}),m(B)!=="svelte-1r1fxak"&&(B.innerHTML=_t),Ee=i(e),F=o(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-18famm0"&&(F.textContent=Ct),He=i(e),r(E.$$.fragment,e),qe=i(e),H=o(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-16x26sb"&&(H.textContent=Xt),Qe=i(e),q=o(e,"UL",{"data-svelte-h":!0}),m(q)!=="svelte-1ufkrdp"&&(q.innerHTML=Gt),Ye=i(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-nozyay"&&(Q.textContent=Wt),Ne=i(e),r(Y.$$.fragment,e),Ae=i(e),N=o(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-6sllth"&&(N.textContent=Vt),Pe=i(e),A=o(e,"UL",{"data-svelte-h":!0}),m(A)!=="svelte-1h2reme"&&(A.innerHTML=Lt),Se=i(e),P=o(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1t17k0a"&&(P.textContent=Rt),De=i(e),r(S.$$.fragment,e),Ke=i(e),D=o(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-sftpup"&&(D.textContent=Bt),Oe=i(e),K=o(e,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-13d4mst"&&(K.innerHTML=Ft),et=i(e),O=o(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-13sr045"&&(O.innerHTML=Et),tt=i(e),r(ee.$$.fragment,e),lt=i(e),te=o(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1ysq4ea"&&(te.textContent=Ht),nt=i(e),r(le.$$.fragment,e),at=i(e),ne=o(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1hcjl5u"&&(ne.innerHTML=qt),it=i(e),r(ae.$$.fragment,e),st=i(e),r(ie.$$.fragment,e),ot=i(e),se=o(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-hqe28c"&&(se.textContent=Qt),mt=i(e),oe=o(e,"UL",{"data-svelte-h":!0}),m(oe)!=="svelte-15l5ps7"&&(oe.innerHTML=Yt),pt=i(e),me=o(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-niv51s"&&(me.innerHTML=Nt),rt=i(e),r(pe.$$.fragment,e),ut=i(e),re=o(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-5lihjd"&&(re.textContent=At),gt=i(e),r(ue.$$.fragment,e),dt=i(e),ge=o(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-21vlhj"&&(ge.innerHTML=Pt),ct=i(e),r(de.$$.fragment,e),Mt=i(e),ce=o(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-m0bu83"&&(ce.innerHTML=St),bt=i(e),r(Me.$$.fragment,e),ft=i(e),fe=o(e,"P",{}),Dt(fe).forEach(l),this.h()},h(){Kt(b,"name","hf:doc:metadata"),Kt(b,"content",pl)},m(e,t){il(document.head,b),n(e,Je,t),n(e,be,t),n(e,Te,t),u(J,e,t),n(e,he,t),u(T,e,t),n(e,ye,t),n(e,h,t),n(e,Ue,t),u(y,e,t),n(e,$e,t),n(e,U,t),n(e,ke,t),u($,e,t),n(e,je,t),n(e,k,t),n(e,we,t),n(e,j,t),n(e,ve,t),n(e,w,t),n(e,ze,t),n(e,v,t),n(e,xe,t),u(z,e,t),n(e,Ie,t),n(e,x,t),n(e,Ze,t),u(I,e,t),n(e,_e,t),n(e,Z,t),n(e,Ce,t),u(_,e,t),n(e,Xe,t),n(e,C,t),n(e,Ge,t),u(X,e,t),n(e,We,t),n(e,G,t),n(e,Ve,t),u(W,e,t),n(e,Le,t),n(e,V,t),n(e,Re,t),u(L,e,t),n(e,Be,t),n(e,R,t),n(e,Fe,t),n(e,B,t),n(e,Ee,t),n(e,F,t),n(e,He,t),u(E,e,t),n(e,qe,t),n(e,H,t),n(e,Qe,t),n(e,q,t),n(e,Ye,t),n(e,Q,t),n(e,Ne,t),u(Y,e,t),n(e,Ae,t),n(e,N,t),n(e,Pe,t),n(e,A,t),n(e,Se,t),n(e,P,t),n(e,De,t),u(S,e,t),n(e,Ke,t),n(e,D,t),n(e,Oe,t),n(e,K,t),n(e,et,t),n(e,O,t),n(e,tt,t),u(ee,e,t),n(e,lt,t),n(e,te,t),n(e,nt,t),u(le,e,t),n(e,at,t),n(e,ne,t),n(e,it,t),u(ae,e,t),n(e,st,t),u(ie,e,t),n(e,ot,t),n(e,se,t),n(e,mt,t),n(e,oe,t),n(e,pt,t),n(e,me,t),n(e,rt,t),u(pe,e,t),n(e,ut,t),n(e,re,t),n(e,gt,t),u(ue,e,t),n(e,dt,t),n(e,ge,t),n(e,ct,t),u(de,e,t),n(e,Mt,t),n(e,ce,t),n(e,bt,t),u(Me,e,t),n(e,ft,t),n(e,fe,t),Jt=!0},p:el,i(e){Jt||(g(J.$$.fragment,e),g(T.$$.fragment,e),g(y.$$.fragment,e),g($.$$.fragment,e),g(z.$$.fragment,e),g(I.$$.fragment,e),g(_.$$.fragment,e),g(X.$$.fragment,e),g(W.$$.fragment,e),g(L.$$.fragment,e),g(E.$$.fragment,e),g(Y.$$.fragment,e),g(S.$$.fragment,e),g(ee.$$.fragment,e),g(le.$$.fragment,e),g(ae.$$.fragment,e),g(ie.$$.fragment,e),g(pe.$$.fragment,e),g(ue.$$.fragment,e),g(de.$$.fragment,e),g(Me.$$.fragment,e),Jt=!0)},o(e){d(J.$$.fragment,e),d(T.$$.fragment,e),d(y.$$.fragment,e),d($.$$.fragment,e),d(z.$$.fragment,e),d(I.$$.fragment,e),d(_.$$.fragment,e),d(X.$$.fragment,e),d(W.$$.fragment,e),d(L.$$.fragment,e),d(E.$$.fragment,e),d(Y.$$.fragment,e),d(S.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(ue.$$.fragment,e),d(de.$$.fragment,e),d(Me.$$.fragment,e),Jt=!1},d(e){e&&(l(Je),l(be),l(Te),l(he),l(ye),l(h),l(Ue),l($e),l(U),l(ke),l(je),l(k),l(we),l(j),l(ve),l(w),l(ze),l(v),l(xe),l(Ie),l(x),l(Ze),l(_e),l(Z),l(Ce),l(Xe),l(C),l(Ge),l(We),l(G),l(Ve),l(Le),l(V),l(Re),l(Be),l(R),l(Fe),l(B),l(Ee),l(F),l(He),l(qe),l(H),l(Qe),l(q),l(Ye),l(Q),l(Ne),l(Ae),l(N),l(Pe),l(A),l(Se),l(P),l(De),l(Ke),l(D),l(Oe),l(K),l(et),l(O),l(tt),l(lt),l(te),l(nt),l(at),l(ne),l(it),l(st),l(ot),l(se),l(mt),l(oe),l(pt),l(me),l(rt),l(ut),l(re),l(gt),l(dt),l(ge),l(ct),l(Mt),l(ce),l(bt),l(ft),l(fe)),l(b),c(J,e),c(T,e),c(y,e),c($,e),c(z,e),c(I,e),c(_,e),c(X,e),c(W,e),c(L,e),c(E,e),c(Y,e),c(S,e),c(ee,e),c(le,e),c(ae,e),c(ie,e),c(pe,e),c(ue,e),c(de,e),c(Me,e)}}}const pl='{"title":"Modelli multilingue per l’inferenza","local":"modelli-multilingue-per-linferenza","sections":[{"title":"XLM","local":"xlm","sections":[{"title":"XLM con language embeddings","local":"xlm-con-language-embeddings","sections":[],"depth":3},{"title":"XLM senza language embeddings","local":"xlm-senza-language-embeddings","sections":[],"depth":3}],"depth":2},{"title":"BERT","local":"bert","sections":[],"depth":2},{"title":"XLM-RoBERTa","local":"xlm-roberta","sections":[],"depth":2},{"title":"M2M100","local":"m2m100","sections":[],"depth":2},{"title":"MBart","local":"mbart","sections":[],"depth":2}],"depth":1}';function rl(Tt){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bl extends ll{constructor(b){super(),nl(this,b,rl,ml,Ot,{})}}export{bl as component};
