import{s as Or,o as Kr,n as eo}from"../chunks/scheduler.9bc65507.js";import{S as to,i as no,g as i,s as a,r as p,A as so,h as r,f as n,c as l,j as Dr,u as m,x as o,k as Qr,y as ao,a as s,v as d,d as f,t as h,w as u}from"../chunks/index.707bf1b6.js";import{T as lo}from"../chunks/Tip.c2ecdbf4.js";import{Y as Nn}from"../chunks/Youtube.e1129c6f.js";import{C as $}from"../chunks/CodeBlock.54a9f38d.js";import{H as g}from"../chunks/Heading.342b1fa6.js";function io(Sn){let c,w=`Each model’s labels may be different, so be sure to always check the documentation of each model for more information
about their specific labels!`;return{c(){c=i("p"),c.textContent=w},l(b){c=r(b,"P",{"data-svelte-h":!0}),o(c)!=="svelte-1nifkrh"&&(c.textContent=w)},m(b,Gn){s(b,c,Gn)},p:eo,d(b){b&&n(c)}}}function ro(Sn){let c,w,b,Gn,T,Xn,x,fi=`This glossary defines general machine learning and 🤗 Transformers terms to help you better understand the
documentation.`,En,y,Bn,C,An,k,hi="The attention mask is an optional argument used when batching sequences together.",Yn,j,Dn,_,ui="This argument indicates to the model which tokens should be attended to, and which should not.",Qn,M,gi="For example, consider these two sequences:",On,P,Kn,q,ci="The encoded versions have different lengths:",es,z,ts,U,$i=`Therefore, we can’t put them together in the same tensor as-is. The first sequence needs to be padded up to the length
of the second one, or the second one needs to be truncated down to the length of the first one.`,ns,H,bi=`In the first case, the list of IDs will be extended by the padding indices. We can pass a list to the tokenizer and ask
it to pad like this:`,ss,V,as,Z,vi="We can see that 0s have been added on the right of the first sentence to make it the same length as the second one:",ls,L,is,F,wi=`This can then be converted into a tensor in PyTorch or TensorFlow. The attention mask is a binary tensor indicating the
position of the padded indices so that the model does not attend to them. For the <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a>, <code>1</code> indicates a
value that should be attended to, while <code>0</code> indicates a padded value. This attention mask is in the dictionary returned
by the tokenizer under the key “attention_mask”:`,rs,I,os,R,ps,W,Ti='See <a href="#encoder-models">encoder models</a> and <a href="#masked-language-modeling-mlm">masked language modeling</a>',ms,G,ds,J,xi='See <a href="#causal-language-modeling">causal language modeling</a> and <a href="#decoder-models">decoder models</a>',fs,N,hs,S,us,X,yi='The backbone is the network (embeddings and layers) that outputs the raw hidden states or features. It is usually connected to a <a href="#head">head</a> which accepts the features as its input to make a prediction. For example, <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTModel">ViTModel</a> is a backbone without a specific head on top. Other models can also use <code>VitModel</code> as a backbone such as <a href="model_doc/dpt">DPT</a>.',gs,E,cs,B,$s,A,Ci=`A pretraining task where the model reads the texts in order and has to predict the next word. It’s usually done by
reading the whole sentence but using a mask inside the model to hide the future tokens at a certain timestep.`,bs,Y,vs,D,ki="Color images are made up of some combination of values in three channels: red, green, and blue (RGB) and grayscale images only have one channel. In 🤗 Transformers, the channel can be the first or last dimension of an image’s tensor: [<code>n_channels</code>, <code>height</code>, <code>width</code>] or [<code>height</code>, <code>width</code>, <code>n_channels</code>].",ws,Q,Ts,O,ji="An algorithm which allows a model to learn without knowing exactly how the input and output are aligned; CTC calculates the distribution of all possible outputs for a given input and chooses the most likely output from it. CTC is commonly used in speech recognition tasks because speech doesn’t always cleanly align with the transcript for a variety of reasons such as a speaker’s different speech rates.",xs,K,ys,ee,_i="A type of layer in a neural network where the input matrix is multiplied element-wise by a smaller matrix (kernel or filter) and the values are summed up in a new matrix. This is known as a convolutional operation which is repeated over the entire input matrix. Each operation is applied to a different segment of the input matrix. Convolutional neural networks (CNNs) are commonly used in computer vision.",Cs,te,ks,ne,js,se,Mi=`Parallelism technique for training on multiple GPUs where the same setup is replicated multiple times, with each instance
receiving a distinct data slice. The processing is done in parallel and all setups are synchronized at the end of each training step.`,_s,ae,Pi='Learn more about how DataParallel works <a href="perf_train_gpu_many#dataparallel-vs-distributeddataparallel">here</a>.',Ms,le,Ps,ie,qi=`This input is specific to encoder-decoder models, and contains the input IDs that will be fed to the decoder. These
inputs should be used for sequence to sequence tasks, such as translation or summarization, and are usually built in a
way specific to each model.`,qs,re,zi=`Most encoder-decoder models (BART, T5) create their <code>decoder_input_ids</code> on their own from the <code>labels</code>. In such models,
passing the <code>labels</code> is the preferred way to handle training.`,zs,oe,Ui="Please check each model’s docs to see how they handle these input IDs for sequence to sequence training.",Us,pe,Hs,me,Hi=`Also referred to as autoregressive models, decoder models involve a pretraining task (called causal language modeling) where the model reads the texts in order and has to predict the next word. It’s usually done by
reading the whole sentence with a mask to hide future tokens at a certain timestep.`,Vs,de,Zs,fe,Ls,he,Vi="Machine learning algorithms which uses neural networks with several layers.",Fs,ue,Is,ge,Rs,ce,Zi='Also known as autoencoding models, encoder models take an input (such as text or images) and transform them into a condensed numerical representation called an embedding. Oftentimes, encoder models are pretrained using techniques like <a href="#masked-language-modeling-mlm">masked language modeling</a>, which masks parts of the input sequence and forces the model to create more meaningful representations.',Ws,$e,Gs,be,Js,ve,Ns,we,Li="The process of selecting and transforming raw data into a set of features that are more informative and useful for machine learning algorithms. Some examples of feature extraction include transforming raw text into word embeddings and extracting important features such as edges or shapes from image/video data.",Ss,Te,Xs,xe,Fi=`In each residual attention block in transformers the self-attention layer is usually followed by 2 feed forward layers.
The intermediate embedding size of the feed forward layers is often bigger than the hidden size of the model (e.g., for
<code>google-bert/bert-base-uncased</code>).`,Es,ye,Ii=`For an input of size <code>[batch_size, sequence_length]</code>, the memory required to store the intermediate feed forward
embeddings <code>[batch_size, sequence_length, config.intermediate_size]</code> can account for a large fraction of the memory
use. The authors of <a href="https://arxiv.org/abs/2001.04451" rel="nofollow">Reformer: The Efficient Transformer</a> noticed that since the
computation is independent of the <code>sequence_length</code> dimension, it is mathematically equivalent to compute the output
embeddings of both feed forward layers <code>[batch_size, config.hidden_size]_0, ..., [batch_size, config.hidden_size]_n</code>
individually and concat them afterward to <code>[batch_size, sequence_length, config.hidden_size]</code> with <code>n = sequence_length</code>, which trades increased computation time against reduced memory use, but yields a mathematically
<strong>equivalent</strong> result.`,Bs,Ce,Ri=`For models employing the function <a href="/docs/transformers/v4.38.1/en/internal/modeling_utils#transformers.apply_chunking_to_forward">apply_chunking_to_forward()</a>, the <code>chunk_size</code> defines the number of output
embeddings that are computed in parallel and thus defines the trade-off between memory and time complexity. If
<code>chunk_size</code> is set to 0, no feed forward chunking is done.`,As,ke,Ys,je,Wi='Finetuning is a form of transfer learning which involves taking a pretrained model, freezing its weights, and replacing the output layer with a newly added <a href="#head">model head</a>. The model head is trained on your target dataset.',Ds,_e,Gi='See the <a href="https://huggingface.co/docs/transformers/training" rel="nofollow">Fine-tune a pretrained model</a> tutorial for more details, and learn how to fine-tune models with 🤗 Transformers.',Qs,Me,Os,Pe,Ks,qe,Ji="The model head refers to the last layer of a neural network that accepts the raw hidden states and projects them onto a different dimension. There is a different model head for each task. For example:",ea,ze,Ni='<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2ForSequenceClassification">GPT2ForSequenceClassification</a> is a sequence classification head - a linear layer - on top of the base <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Model">GPT2Model</a>.</li> <li><a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTForImageClassification">ViTForImageClassification</a> is an image classification head - a linear layer on top of the final hidden state of the <code>CLS</code> token - on top of the base <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTModel">ViTModel</a>.</li> <li><a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a> is a language modeling head with <a href="#connectionist-temporal-classification-ctc">CTC</a> on top of the base <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a>.</li>',ta,Ue,na,He,sa,Ve,Si="Vision-based Transformers models split an image into smaller patches which are linearly embedded, and then passed as a sequence to the model. You can find the <code>patch_size</code> - or resolution - of the model in its configuration.",aa,Ze,la,Le,Xi='Inference is the process of evaluating a model on new data after training is complete. See the <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">Pipeline for inference</a> tutorial to learn how to perform inference with 🤗 Transformers.',ia,Fe,ra,Ie,Ei=`The input ids are often the only required parameters to be passed to the model as input. They are token indices,
numerical representations of tokens building the sequences that will be used as input by the model.`,oa,Re,pa,We,Bi=`Each tokenizer works differently but the underlying mechanism remains the same. Here’s an example using the BERT
tokenizer, which is a <a href="https://arxiv.org/pdf/1609.08144.pdf" rel="nofollow">WordPiece</a> tokenizer:`,ma,Ge,da,Je,Ai="The tokenizer takes care of splitting the sequence into tokens available in the tokenizer vocabulary.",fa,Ne,ha,Se,Yi=`The tokens are either words or subwords. Here for instance, “VRAM” wasn’t in the model vocabulary, so it’s been split
in “V”, “RA” and “M”. To indicate those tokens are not separate words but parts of the same word, a double-hash prefix
is added for “RA” and “M”:`,ua,Xe,ga,Ee,Di='These tokens can then be converted into IDs which are understandable by the model. This can be done by directly feeding the sentence to the tokenizer, which leverages the Rust implementation of <a href="https://github.com/huggingface/tokenizers" rel="nofollow">🤗 Tokenizers</a> for peak performance.',ca,Be,$a,Ae,Qi=`The tokenizer returns a dictionary with all the arguments necessary for its corresponding model to work properly. The
token indices are under the key <code>input_ids</code>:`,ba,Ye,va,De,Oi=`Note that the tokenizer automatically adds “special tokens” (if the associated model relies on them) which are special
IDs the model sometimes uses.`,wa,Qe,Ki="If we decode the previous sequence of ids,",Ta,Oe,xa,Ke,er="we will see",ya,et,Ca,tt,tr='because this is the way a <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertModel">BertModel</a> is going to expect its inputs.',ka,nt,ja,st,_a,at,nr=`The labels are an optional argument which can be passed in order for the model to compute the loss itself. These labels
should be the expected prediction of the model: it will use the standard loss in order to compute the loss between its
predictions and the expected value (the label).`,Ma,lt,sr="These labels are different according to the model head, for example:",Pa,it,ar=`<li>For sequence classification models, (<a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertForSequenceClassification">BertForSequenceClassification</a>), the model expects a tensor of dimension
<code>(batch_size)</code> with each value of the batch corresponding to the expected label of the entire sequence.</li> <li>For token classification models, (<a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertForTokenClassification">BertForTokenClassification</a>), the model expects a tensor of dimension
<code>(batch_size, seq_length)</code> with each value corresponding to the expected label of each individual token.</li> <li>For masked language modeling, (<a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertForMaskedLM">BertForMaskedLM</a>), the model expects a tensor of dimension <code>(batch_size, seq_length)</code> with each value corresponding to the expected label of each individual token: the labels being the token
ID for the masked token, and values to be ignored for the rest (usually -100).</li> <li>For sequence to sequence tasks, (<a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a>, <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartForConditionalGeneration">MBartForConditionalGeneration</a>), the model
expects a tensor of dimension <code>(batch_size, tgt_seq_length)</code> with each value corresponding to the target sequences
associated with each input sequence. During training, both BART and T5 will make the appropriate
<code>decoder_input_ids</code> and decoder attention masks internally. They usually do not need to be supplied. This does not
apply to models leveraging the Encoder-Decoder framework.</li> <li>For image classification models, (<a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTForImageClassification">ViTForImageClassification</a>), the model expects a tensor of dimension
<code>(batch_size)</code> with each value of the batch corresponding to the expected label of each individual image.</li> <li>For semantic segmentation models, (<a href="/docs/transformers/v4.38.1/en/model_doc/segformer#transformers.SegformerForSemanticSegmentation">SegformerForSemanticSegmentation</a>), the model expects a tensor of dimension
<code>(batch_size, height, width)</code> with each value of the batch corresponding to the expected label of each individual pixel.</li> <li>For object detection models, (<a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a>), the model expects a list of dictionaries with a
<code>class_labels</code> and <code>boxes</code> key where each value of the batch corresponds to the expected label and number of bounding boxes of each individual image.</li> <li>For automatic speech recognition models, (<a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a>), the model expects a tensor of dimension <code>(batch_size, target_length)</code> with each value corresponding to the expected label of each individual token.</li>`,qa,v,za,rt,lr=`The base models (<a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertModel">BertModel</a>) do not accept labels, as these are the base transformer models, simply outputting
features.`,Ua,ot,Ha,pt,ir="A generic term that refers to transformer language models (GPT-3, BLOOM, OPT) that were trained on a large quantity of data. These models also tend to have a large number of learnable parameters (e.g. 175 billion for GPT-3).",Va,mt,Za,dt,La,ft,rr=`A pretraining task where the model sees a corrupted version of the texts, usually done by
masking some tokens randomly, and has to predict the original text.`,Fa,ht,Ia,ut,or="A task that combines texts with another kind of inputs (for instance images).",Ra,gt,Wa,ct,Ga,$t,pr='All tasks related to generating text (for instance, <a href="https://transformer.huggingface.co/" rel="nofollow">Write With Transformers</a>, translation).',Ja,bt,Na,vt,mr="A generic way to say “deal with texts”.",Sa,wt,Xa,Tt,dr=`All tasks related to understanding what is in a text (for instance classifying the
whole text, individual words).`,Ea,xt,Ba,yt,Aa,Ct,fr="A pipeline in 🤗 Transformers is an abstraction referring to a series of steps that are executed in a specific order to preprocess and transform data and return a prediction from a model. Some example stages found in a pipeline might be data preprocessing, feature extraction, and normalization.",Ya,kt,hr='For more details, see <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">Pipelines for inference</a>.',Da,jt,Qa,_t,ur=`Parallelism technique in which the model is split up vertically (layer-level) across multiple GPUs, so that only one or
several layers of the model are placed on a single GPU. Each GPU processes in parallel different stages of the pipeline
and working on a small chunk of the batch. Learn more about how PipelineParallel works <a href="perf_train_gpu_many#from-naive-model-parallelism-to-pipeline-parallelism">here</a>.`,Oa,Mt,Ka,Pt,gr="A tensor of the numerical representations of an image that is passed to a model. The pixel values have a shape of [<code>batch_size</code>, <code>num_channels</code>, <code>height</code>, <code>width</code>], and are generated from an image processor.",el,qt,tl,zt,cr="An operation that reduces a matrix into a smaller matrix, either by taking the maximum or average of the pooled dimension(s). Pooling layers are commonly found between convolutional layers to downsample the feature representation.",nl,Ut,sl,Ht,$r=`Contrary to RNNs that have the position of each token embedded within them, transformers are unaware of the position of
each token. Therefore, the position IDs (<code>position_ids</code>) are used by the model to identify each token’s position in the
list of tokens.`,al,Vt,br=`They are an optional parameter. If no <code>position_ids</code> are passed to the model, the IDs are automatically created as
absolute positional embeddings.`,ll,Zt,vr=`Absolute positional embeddings are selected in the range <code>[0, config.max_position_embeddings - 1]</code>. Some models use
other types of positional embeddings, such as sinusoidal position embeddings or relative position embeddings.`,il,Lt,rl,Ft,wr='The task of preparing raw data into a format that can be easily consumed by machine learning models. For example, text is typically preprocessed by tokenization. To gain a better idea of what preprocessing looks like for other input types, check out the <a href="https://huggingface.co/docs/transformers/preprocessing" rel="nofollow">Preprocess</a> tutorial.',ol,It,pl,Rt,Tr=`A model that has been pretrained on some data (for instance all of Wikipedia). Pretraining methods involve a
self-supervised objective, which can be reading the text and trying to predict the next word (see <a href="#causal-language-modeling">causal language
modeling</a>) or masking some words and trying to predict them (see <a href="#masked-language-modeling-mlm">masked language
modeling</a>).`,ml,Wt,xr="Speech and vision models have their own pretraining objectives. For example, Wav2Vec2 is a speech model pretrained on a contrastive task which requires the model to identify the “true” speech representation from a set of “false” speech representations. On the other hand, BEiT is a vision model pretrained on a masked image modeling task which masks some of the image patches and requires the model to predict the masked patches (similar to the masked language modeling objective).",dl,Gt,fl,Jt,hl,Nt,yr="A type of model that uses a loop over a layer to process texts.",ul,St,gl,Xt,Cr="A subfield of machine learning which focuses on learning meaningful representations of raw data. Some examples of representation learning techniques include word embeddings, autoencoders, and Generative Adversarial Networks (GANs).",cl,Et,$l,Bt,bl,At,kr="A measurement in hertz of the number of samples (the audio signal) taken per second. The sampling rate is a result of discretizing a continuous signal such as speech.",vl,Yt,wl,Dt,jr="Each element of the input finds out which other elements of the input they should attend to.",Tl,Qt,xl,Ot,_r='A category of machine learning techniques in which a model creates its own learning objective from unlabeled data. It differs from <a href="#unsupervised-learning">unsupervised learning</a> and <a href="#supervised-learning">supervised learning</a> in that the learning process is supervised, but not explicitly from the user.',yl,Kt,Mr='One example of self-supervised learning is <a href="#masked-language-modeling-mlm">masked language modeling</a>, where a model is passed sentences with a proportion of its tokens removed and learns to predict the missing tokens.',Cl,en,kl,tn,Pr='A broad category of machine learning training techniques that leverages a small amount of labeled data with a larger quantity of unlabeled data to improve the accuracy of a model, unlike <a href="#supervised-learning">supervised learning</a> and <a href="#unsupervised-learning">unsupervised learning</a>.',jl,nn,qr="An example of a semi-supervised learning approach is “self-training”, in which a model is trained on labeled data, and then used to make predictions on the unlabeled data. The portion of the unlabeled data that the model predicts with the most confidence gets added to the labeled dataset and used to retrain the model.",_l,sn,Ml,an,zr=`Models that generate a new sequence from an input, like translation models, or summarization models (such as
<a href="model_doc/bart">Bart</a> or <a href="model_doc/t5">T5</a>).`,Pl,ln,ql,rn,Ur='Another name for the foundational <a href="#zero-redundancy-optimizer-zero">ZeRO</a> concept as used by various other implementations of ZeRO.',zl,on,Ul,pn,Hr='In <a href="#convolution">convolution</a> or <a href="#pooling">pooling</a>, the stride refers to the distance the kernel is moved over a matrix. A stride of 1 means the kernel is moved one pixel over at a time, and a stride of 2 means the kernel is moved two pixels over at a time.',Hl,mn,Vl,dn,Vr="A form of model training that directly uses labeled data to correct and instruct model performance. Data is fed into the model being trained, and its predictions are compared to the known labels. The model updates its weights based on how incorrect its predictions were, and the process is repeated to optimize model performance.",Zl,fn,Ll,hn,Fl,un,Zr=`Parallelism technique for training on multiple GPUs in which each tensor is split up into multiple chunks, so instead of
having the whole tensor reside on a single GPU, each shard of the tensor resides on its designated GPU. Shards gets
processed separately and in parallel on different GPUs and the results are synced at the end of the processing step.
This is what is sometimes called horizontal parallelism, as the splitting happens on horizontal level.
Learn more about Tensor Parallelism <a href="perf_train_gpu_many#tensor-parallelism">here</a>.`,Il,gn,Rl,cn,Lr=`A part of a sentence, usually a word, but can also be a subword (non-common words are often split in subwords) or a
punctuation symbol.`,Wl,$n,Gl,bn,Fr="Some models’ purpose is to do classification on pairs of sentences or question answering.",Jl,vn,Nl,wn,Ir=`These require two different sequences to be joined in a single “input_ids” entry, which usually is performed with the
help of special tokens, such as the classifier (<code>[CLS]</code>) and separator (<code>[SEP]</code>) tokens. For example, the BERT model
builds its two sequence input as such:`,Sl,Tn,Xl,xn,Rr=`We can use our tokenizer to automatically generate such a sentence by passing the two sequences to <code>tokenizer</code> as two
arguments (and not a list, like before) like this:`,El,yn,Bl,Cn,Wr="which will return:",Al,kn,Yl,jn,Gr=`This is enough for some models to understand where one sequence ends and where another begins. However, other models,
such as BERT, also deploy token type IDs (also called segment IDs). They are represented as a binary mask identifying
the two types of sequence in the model.`,Dl,_n,Jr="The tokenizer returns this mask as the “token_type_ids” entry:",Ql,Mn,Ol,Pn,Nr=`The first sequence, the “context” used for the question, has all its tokens represented by a <code>0</code>, whereas the second
sequence, corresponding to the “question”, has all its tokens represented by a <code>1</code>.`,Kl,qn,Sr='Some models, like <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetModel">XLNetModel</a> use an additional token represented by a <code>2</code>.',ei,zn,ti,Un,Xr="A technique that involves taking a pretrained model and adapting it to a dataset specific to your task. Instead of training a model from scratch, you can leverage knowledge obtained from an existing model as a starting point. This speeds up the learning process and reduces the amount of training data needed.",ni,Hn,si,Vn,Er="Self-attention based deep learning model architecture.",ai,Zn,li,Ln,ii,Fn,Br="A form of model training in which data provided to the model is not labeled. Unsupervised learning techniques leverage statistical information of the data distribution to find patterns useful for the task at hand.",ri,In,oi,Rn,pi,Wn,Ar=`Parallelism technique which performs sharding of the tensors somewhat similar to <a href="#tensor-parallelism-tp">TensorParallel</a>,
except the whole tensor gets reconstructed in time for a forward or backward computation, therefore the model doesn’t need
to be modified. This method also supports various offloading techniques to compensate for limited GPU memory.
Learn more about ZeRO <a href="perf_train_gpu_many#zero-data-parallelism">here</a>.`,mi,Jn,di;return T=new g({props:{title:"Glossary",local:"glossary",headingTag:"h1"}}),y=new g({props:{title:"A",local:"a",headingTag:"h2"}}),C=new g({props:{title:"attention mask",local:"attention-mask",headingTag:"h3"}}),j=new Nn({props:{id:"M6adb1j2jPI"}}),P=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEFzZXF1ZW5jZV9hJTIwJTNEJTIwJTIyVGhpcyUyMGlzJTIwYSUyMHNob3J0JTIwc2VxdWVuY2UuJTIyJTBBc2VxdWVuY2VfYiUyMCUzRCUyMCUyMlRoaXMlMjBpcyUyMGElMjByYXRoZXIlMjBsb25nJTIwc2VxdWVuY2UuJTIwSXQlMjBpcyUyMGF0JTIwbGVhc3QlMjBsb25nZXIlMjB0aGFuJTIwdGhlJTIwc2VxdWVuY2UlMjBBLiUyMiUwQSUwQWVuY29kZWRfc2VxdWVuY2VfYSUyMCUzRCUyMHRva2VuaXplcihzZXF1ZW5jZV9hKSU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQWVuY29kZWRfc2VxdWVuY2VfYiUyMCUzRCUyMHRva2VuaXplcihzZXF1ZW5jZV9iKSU1QiUyMmlucHV0X2lkcyUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_a = <span class="hljs-string">&quot;This is a short sequence.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_b = <span class="hljs-string">&quot;This is a rather long sequence. It is at least longer than the sequence A.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_sequence_a = tokenizer(sequence_a)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_sequence_b = tokenizer(sequence_b)[<span class="hljs-string">&quot;input_ids&quot;</span>]`,wrap:!1}}),z=new $({props:{code:"bGVuKGVuY29kZWRfc2VxdWVuY2VfYSklMkMlMjBsZW4oZW5jb2RlZF9zZXF1ZW5jZV9iKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(encoded_sequence_a), <span class="hljs-built_in">len</span>(encoded_sequence_b)
(<span class="hljs-number">8</span>, <span class="hljs-number">19</span>)`,wrap:!1}}),V=new $({props:{code:"cGFkZGVkX3NlcXVlbmNlcyUyMCUzRCUyMHRva2VuaXplciglNUJzZXF1ZW5jZV9hJTJDJTIwc2VxdWVuY2VfYiU1RCUyQyUyMHBhZGRpbmclM0RUcnVlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>padded_sequences = tokenizer([sequence_a, sequence_b], padding=<span class="hljs-literal">True</span>)',wrap:!1}}),L=new $({props:{code:"cGFkZGVkX3NlcXVlbmNlcyU1QiUyMmlucHV0X2lkcyUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>padded_sequences[<span class="hljs-string">&quot;input_ids&quot;</span>]
[[<span class="hljs-number">101</span>, <span class="hljs-number">1188</span>, <span class="hljs-number">1110</span>, <span class="hljs-number">170</span>, <span class="hljs-number">1603</span>, <span class="hljs-number">4954</span>, <span class="hljs-number">119</span>, <span class="hljs-number">102</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], [<span class="hljs-number">101</span>, <span class="hljs-number">1188</span>, <span class="hljs-number">1110</span>, <span class="hljs-number">170</span>, <span class="hljs-number">1897</span>, <span class="hljs-number">1263</span>, <span class="hljs-number">4954</span>, <span class="hljs-number">119</span>, <span class="hljs-number">1135</span>, <span class="hljs-number">1110</span>, <span class="hljs-number">1120</span>, <span class="hljs-number">1655</span>, <span class="hljs-number">2039</span>, <span class="hljs-number">1190</span>, <span class="hljs-number">1103</span>, <span class="hljs-number">4954</span>, <span class="hljs-number">138</span>, <span class="hljs-number">119</span>, <span class="hljs-number">102</span>]]`,wrap:!1}}),I=new $({props:{code:"cGFkZGVkX3NlcXVlbmNlcyU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>padded_sequences[<span class="hljs-string">&quot;attention_mask&quot;</span>]
[[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]`,wrap:!1}}),R=new g({props:{title:"autoencoding models",local:"autoencoding-models",headingTag:"h3"}}),G=new g({props:{title:"autoregressive models",local:"autoregressive-models",headingTag:"h3"}}),N=new g({props:{title:"B",local:"b",headingTag:"h2"}}),S=new g({props:{title:"backbone",local:"backbone",headingTag:"h3"}}),E=new g({props:{title:"C",local:"c",headingTag:"h2"}}),B=new g({props:{title:"causal language modeling",local:"causal-language-modeling",headingTag:"h3"}}),Y=new g({props:{title:"channel",local:"channel",headingTag:"h3"}}),Q=new g({props:{title:"connectionist temporal classification (CTC)",local:"connectionist-temporal-classification-ctc",headingTag:"h3"}}),K=new g({props:{title:"convolution",local:"convolution",headingTag:"h3"}}),te=new g({props:{title:"D",local:"d",headingTag:"h2"}}),ne=new g({props:{title:"DataParallel (DP)",local:"dataparallel-dp",headingTag:"h3"}}),le=new g({props:{title:"decoder input IDs",local:"decoder-input-ids",headingTag:"h3"}}),pe=new g({props:{title:"decoder models",local:"decoder-models",headingTag:"h3"}}),de=new Nn({props:{id:"d_ixlCubqQw"}}),fe=new g({props:{title:"deep learning (DL)",local:"deep-learning-dl",headingTag:"h3"}}),ue=new g({props:{title:"E",local:"e",headingTag:"h2"}}),ge=new g({props:{title:"encoder models",local:"encoder-models",headingTag:"h3"}}),$e=new Nn({props:{id:"H39Z_720T5s"}}),be=new g({props:{title:"F",local:"f",headingTag:"h2"}}),ve=new g({props:{title:"feature extraction",local:"feature-extraction",headingTag:"h3"}}),Te=new g({props:{title:"feed forward chunking",local:"feed-forward-chunking",headingTag:"h3"}}),ke=new g({props:{title:"finetuned models",local:"finetuned-models",headingTag:"h3"}}),Me=new g({props:{title:"H",local:"h",headingTag:"h2"}}),Pe=new g({props:{title:"head",local:"head",headingTag:"h3"}}),Ue=new g({props:{title:"I",local:"i",headingTag:"h2"}}),He=new g({props:{title:"image patch",local:"image-patch",headingTag:"h3"}}),Ze=new g({props:{title:"inference",local:"inference",headingTag:"h3"}}),Fe=new g({props:{title:"input IDs",local:"input-ids",headingTag:"h3"}}),Re=new Nn({props:{id:"VFp38yj8h3A"}}),Ge=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEFzZXF1ZW5jZSUyMCUzRCUyMCUyMkElMjBUaXRhbiUyMFJUWCUyMGhhcyUyMDI0R0IlMjBvZiUyMFZSQU0lMjI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence = <span class="hljs-string">&quot;A Titan RTX has 24GB of VRAM&quot;</span>`,wrap:!1}}),Ne=new $({props:{code:"dG9rZW5pemVkX3NlcXVlbmNlJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuaXplKHNlcXVlbmNlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_sequence = tokenizer.tokenize(sequence)',wrap:!1}}),Xe=new $({props:{code:"cHJpbnQodG9rZW5pemVkX3NlcXVlbmNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenized_sequence)
[<span class="hljs-string">&#x27;A&#x27;</span>, <span class="hljs-string">&#x27;Titan&#x27;</span>, <span class="hljs-string">&#x27;R&#x27;</span>, <span class="hljs-string">&#x27;##T&#x27;</span>, <span class="hljs-string">&#x27;##X&#x27;</span>, <span class="hljs-string">&#x27;has&#x27;</span>, <span class="hljs-string">&#x27;24&#x27;</span>, <span class="hljs-string">&#x27;##GB&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;V&#x27;</span>, <span class="hljs-string">&#x27;##RA&#x27;</span>, <span class="hljs-string">&#x27;##M&#x27;</span>]`,wrap:!1}}),Be=new $({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHNlcXVlbmNlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(sequence)',wrap:!1}}),Ye=new $({props:{code:"ZW5jb2RlZF9zZXF1ZW5jZSUyMCUzRCUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQXByaW50KGVuY29kZWRfc2VxdWVuY2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_sequence = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoded_sequence)
[<span class="hljs-number">101</span>, <span class="hljs-number">138</span>, <span class="hljs-number">18696</span>, <span class="hljs-number">155</span>, <span class="hljs-number">1942</span>, <span class="hljs-number">3190</span>, <span class="hljs-number">1144</span>, <span class="hljs-number">1572</span>, <span class="hljs-number">13745</span>, <span class="hljs-number">1104</span>, <span class="hljs-number">159</span>, <span class="hljs-number">9664</span>, <span class="hljs-number">2107</span>, <span class="hljs-number">102</span>]`,wrap:!1}}),Oe=new $({props:{code:"ZGVjb2RlZF9zZXF1ZW5jZSUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZW5jb2RlZF9zZXF1ZW5jZSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>decoded_sequence = tokenizer.decode(encoded_sequence)',wrap:!1}}),et=new $({props:{code:"cHJpbnQoZGVjb2RlZF9zZXF1ZW5jZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(decoded_sequence)
[CLS] A Titan RTX has 24GB of VRAM [SEP]`,wrap:!1}}),nt=new g({props:{title:"L",local:"l",headingTag:"h2"}}),st=new g({props:{title:"labels",local:"labels",headingTag:"h3"}}),v=new lo({props:{$$slots:{default:[io]},$$scope:{ctx:Sn}}}),ot=new g({props:{title:"large language models (LLM)",local:"large-language-models-llm",headingTag:"h3"}}),mt=new g({props:{title:"M",local:"m",headingTag:"h2"}}),dt=new g({props:{title:"masked language modeling (MLM)",local:"masked-language-modeling-mlm",headingTag:"h3"}}),ht=new g({props:{title:"multimodal",local:"multimodal",headingTag:"h3"}}),gt=new g({props:{title:"N",local:"n",headingTag:"h2"}}),ct=new g({props:{title:"Natural language generation (NLG)",local:"natural-language-generation-nlg",headingTag:"h3"}}),bt=new g({props:{title:"Natural language processing (NLP)",local:"natural-language-processing-nlp",headingTag:"h3"}}),wt=new g({props:{title:"Natural language understanding (NLU)",local:"natural-language-understanding-nlu",headingTag:"h3"}}),xt=new g({props:{title:"P",local:"p",headingTag:"h2"}}),yt=new g({props:{title:"pipeline",local:"pipeline",headingTag:"h3"}}),jt=new g({props:{title:"PipelineParallel (PP)",local:"pipelineparallel-pp",headingTag:"h3"}}),Mt=new g({props:{title:"pixel values",local:"pixel-values",headingTag:"h3"}}),qt=new g({props:{title:"pooling",local:"pooling",headingTag:"h3"}}),Ut=new g({props:{title:"position IDs",local:"position-ids",headingTag:"h3"}}),Lt=new g({props:{title:"preprocessing",local:"preprocessing",headingTag:"h3"}}),It=new g({props:{title:"pretrained model",local:"pretrained-model",headingTag:"h3"}}),Gt=new g({props:{title:"R",local:"r",headingTag:"h2"}}),Jt=new g({props:{title:"recurrent neural network (RNN)",local:"recurrent-neural-network-rnn",headingTag:"h3"}}),St=new g({props:{title:"representation learning",local:"representation-learning",headingTag:"h3"}}),Et=new g({props:{title:"S",local:"s",headingTag:"h2"}}),Bt=new g({props:{title:"sampling rate",local:"sampling-rate",headingTag:"h3"}}),Yt=new g({props:{title:"self-attention",local:"self-attention",headingTag:"h3"}}),Qt=new g({props:{title:"self-supervised learning",local:"self-supervised-learning",headingTag:"h3"}}),en=new g({props:{title:"semi-supervised learning",local:"semi-supervised-learning",headingTag:"h3"}}),sn=new g({props:{title:"sequence-to-sequence (seq2seq)",local:"sequence-to-sequence-seq2seq",headingTag:"h3"}}),ln=new g({props:{title:"Sharded DDP",local:"sharded-ddp",headingTag:"h3"}}),on=new g({props:{title:"stride",local:"stride",headingTag:"h3"}}),mn=new g({props:{title:"supervised learning",local:"supervised-learning",headingTag:"h3"}}),fn=new g({props:{title:"T",local:"t",headingTag:"h2"}}),hn=new g({props:{title:"Tensor Parallelism (TP)",local:"tensor-parallelism-tp",headingTag:"h3"}}),gn=new g({props:{title:"token",local:"token",headingTag:"h3"}}),$n=new g({props:{title:"token Type IDs",local:"token-type-ids",headingTag:"h3"}}),vn=new Nn({props:{id:"0u3ioSwev3s"}}),Tn=new $({props:{code:"JTIzJTIwJTVCQ0xTJTVEJTIwU0VRVUVOQ0VfQSUyMCU1QlNFUCU1RCUyMFNFUVVFTkNFX0IlMjAlNUJTRVAlNUQ=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [CLS] SEQUENCE_A [SEP] SEQUENCE_B [SEP]</span>',wrap:!1}}),yn=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFzZXF1ZW5jZV9hJTIwJTNEJTIwJTIySHVnZ2luZ0ZhY2UlMjBpcyUyMGJhc2VkJTIwaW4lMjBOWUMlMjIlMEFzZXF1ZW5jZV9iJTIwJTNEJTIwJTIyV2hlcmUlMjBpcyUyMEh1Z2dpbmdGYWNlJTIwYmFzZWQlM0YlMjIlMEElMEFlbmNvZGVkX2RpY3QlMjAlM0QlMjB0b2tlbml6ZXIoc2VxdWVuY2VfYSUyQyUyMHNlcXVlbmNlX2IpJTBBZGVjb2RlZCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZW5jb2RlZF9kaWN0JTVCJTIyaW5wdXRfaWRzJTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_a = <span class="hljs-string">&quot;HuggingFace is based in NYC&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_b = <span class="hljs-string">&quot;Where is HuggingFace based?&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dict = tokenizer(sequence_a, sequence_b)
<span class="hljs-meta">&gt;&gt;&gt; </span>decoded = tokenizer.decode(encoded_dict[<span class="hljs-string">&quot;input_ids&quot;</span>])`,wrap:!1}}),kn=new $({props:{code:"cHJpbnQoZGVjb2RlZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(decoded)
[CLS] HuggingFace <span class="hljs-keyword">is</span> based <span class="hljs-keyword">in</span> NYC [SEP] Where <span class="hljs-keyword">is</span> HuggingFace based? [SEP]`,wrap:!1}}),Mn=new $({props:{code:"ZW5jb2RlZF9kaWN0JTVCJTIydG9rZW5fdHlwZV9pZHMlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dict[<span class="hljs-string">&quot;token_type_ids&quot;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),zn=new g({props:{title:"transfer learning",local:"transfer-learning",headingTag:"h3"}}),Hn=new g({props:{title:"transformer",local:"transformer",headingTag:"h3"}}),Zn=new g({props:{title:"U",local:"u",headingTag:"h2"}}),Ln=new g({props:{title:"unsupervised learning",local:"unsupervised-learning",headingTag:"h3"}}),In=new g({props:{title:"Z",local:"z",headingTag:"h2"}}),Rn=new g({props:{title:"Zero Redundancy Optimizer (ZeRO)",local:"zero-redundancy-optimizer-zero",headingTag:"h3"}}),{c(){c=i("meta"),w=a(),b=i("p"),Gn=a(),p(T.$$.fragment),Xn=a(),x=i("p"),x.textContent=fi,En=a(),p(y.$$.fragment),Bn=a(),p(C.$$.fragment),An=a(),k=i("p"),k.textContent=hi,Yn=a(),p(j.$$.fragment),Dn=a(),_=i("p"),_.textContent=ui,Qn=a(),M=i("p"),M.textContent=gi,On=a(),p(P.$$.fragment),Kn=a(),q=i("p"),q.textContent=ci,es=a(),p(z.$$.fragment),ts=a(),U=i("p"),U.textContent=$i,ns=a(),H=i("p"),H.textContent=bi,ss=a(),p(V.$$.fragment),as=a(),Z=i("p"),Z.textContent=vi,ls=a(),p(L.$$.fragment),is=a(),F=i("p"),F.innerHTML=wi,rs=a(),p(I.$$.fragment),os=a(),p(R.$$.fragment),ps=a(),W=i("p"),W.innerHTML=Ti,ms=a(),p(G.$$.fragment),ds=a(),J=i("p"),J.innerHTML=xi,fs=a(),p(N.$$.fragment),hs=a(),p(S.$$.fragment),us=a(),X=i("p"),X.innerHTML=yi,gs=a(),p(E.$$.fragment),cs=a(),p(B.$$.fragment),$s=a(),A=i("p"),A.textContent=Ci,bs=a(),p(Y.$$.fragment),vs=a(),D=i("p"),D.innerHTML=ki,ws=a(),p(Q.$$.fragment),Ts=a(),O=i("p"),O.textContent=ji,xs=a(),p(K.$$.fragment),ys=a(),ee=i("p"),ee.textContent=_i,Cs=a(),p(te.$$.fragment),ks=a(),p(ne.$$.fragment),js=a(),se=i("p"),se.textContent=Mi,_s=a(),ae=i("p"),ae.innerHTML=Pi,Ms=a(),p(le.$$.fragment),Ps=a(),ie=i("p"),ie.textContent=qi,qs=a(),re=i("p"),re.innerHTML=zi,zs=a(),oe=i("p"),oe.textContent=Ui,Us=a(),p(pe.$$.fragment),Hs=a(),me=i("p"),me.textContent=Hi,Vs=a(),p(de.$$.fragment),Zs=a(),p(fe.$$.fragment),Ls=a(),he=i("p"),he.textContent=Vi,Fs=a(),p(ue.$$.fragment),Is=a(),p(ge.$$.fragment),Rs=a(),ce=i("p"),ce.innerHTML=Zi,Ws=a(),p($e.$$.fragment),Gs=a(),p(be.$$.fragment),Js=a(),p(ve.$$.fragment),Ns=a(),we=i("p"),we.textContent=Li,Ss=a(),p(Te.$$.fragment),Xs=a(),xe=i("p"),xe.innerHTML=Fi,Es=a(),ye=i("p"),ye.innerHTML=Ii,Bs=a(),Ce=i("p"),Ce.innerHTML=Ri,As=a(),p(ke.$$.fragment),Ys=a(),je=i("p"),je.innerHTML=Wi,Ds=a(),_e=i("p"),_e.innerHTML=Gi,Qs=a(),p(Me.$$.fragment),Os=a(),p(Pe.$$.fragment),Ks=a(),qe=i("p"),qe.textContent=Ji,ea=a(),ze=i("ul"),ze.innerHTML=Ni,ta=a(),p(Ue.$$.fragment),na=a(),p(He.$$.fragment),sa=a(),Ve=i("p"),Ve.innerHTML=Si,aa=a(),p(Ze.$$.fragment),la=a(),Le=i("p"),Le.innerHTML=Xi,ia=a(),p(Fe.$$.fragment),ra=a(),Ie=i("p"),Ie.textContent=Ei,oa=a(),p(Re.$$.fragment),pa=a(),We=i("p"),We.innerHTML=Bi,ma=a(),p(Ge.$$.fragment),da=a(),Je=i("p"),Je.textContent=Ai,fa=a(),p(Ne.$$.fragment),ha=a(),Se=i("p"),Se.textContent=Yi,ua=a(),p(Xe.$$.fragment),ga=a(),Ee=i("p"),Ee.innerHTML=Di,ca=a(),p(Be.$$.fragment),$a=a(),Ae=i("p"),Ae.innerHTML=Qi,ba=a(),p(Ye.$$.fragment),va=a(),De=i("p"),De.textContent=Oi,wa=a(),Qe=i("p"),Qe.textContent=Ki,Ta=a(),p(Oe.$$.fragment),xa=a(),Ke=i("p"),Ke.textContent=er,ya=a(),p(et.$$.fragment),Ca=a(),tt=i("p"),tt.innerHTML=tr,ka=a(),p(nt.$$.fragment),ja=a(),p(st.$$.fragment),_a=a(),at=i("p"),at.textContent=nr,Ma=a(),lt=i("p"),lt.textContent=sr,Pa=a(),it=i("ul"),it.innerHTML=ar,qa=a(),p(v.$$.fragment),za=a(),rt=i("p"),rt.innerHTML=lr,Ua=a(),p(ot.$$.fragment),Ha=a(),pt=i("p"),pt.textContent=ir,Va=a(),p(mt.$$.fragment),Za=a(),p(dt.$$.fragment),La=a(),ft=i("p"),ft.textContent=rr,Fa=a(),p(ht.$$.fragment),Ia=a(),ut=i("p"),ut.textContent=or,Ra=a(),p(gt.$$.fragment),Wa=a(),p(ct.$$.fragment),Ga=a(),$t=i("p"),$t.innerHTML=pr,Ja=a(),p(bt.$$.fragment),Na=a(),vt=i("p"),vt.textContent=mr,Sa=a(),p(wt.$$.fragment),Xa=a(),Tt=i("p"),Tt.textContent=dr,Ea=a(),p(xt.$$.fragment),Ba=a(),p(yt.$$.fragment),Aa=a(),Ct=i("p"),Ct.textContent=fr,Ya=a(),kt=i("p"),kt.innerHTML=hr,Da=a(),p(jt.$$.fragment),Qa=a(),_t=i("p"),_t.innerHTML=ur,Oa=a(),p(Mt.$$.fragment),Ka=a(),Pt=i("p"),Pt.innerHTML=gr,el=a(),p(qt.$$.fragment),tl=a(),zt=i("p"),zt.textContent=cr,nl=a(),p(Ut.$$.fragment),sl=a(),Ht=i("p"),Ht.innerHTML=$r,al=a(),Vt=i("p"),Vt.innerHTML=br,ll=a(),Zt=i("p"),Zt.innerHTML=vr,il=a(),p(Lt.$$.fragment),rl=a(),Ft=i("p"),Ft.innerHTML=wr,ol=a(),p(It.$$.fragment),pl=a(),Rt=i("p"),Rt.innerHTML=Tr,ml=a(),Wt=i("p"),Wt.textContent=xr,dl=a(),p(Gt.$$.fragment),fl=a(),p(Jt.$$.fragment),hl=a(),Nt=i("p"),Nt.textContent=yr,ul=a(),p(St.$$.fragment),gl=a(),Xt=i("p"),Xt.textContent=Cr,cl=a(),p(Et.$$.fragment),$l=a(),p(Bt.$$.fragment),bl=a(),At=i("p"),At.textContent=kr,vl=a(),p(Yt.$$.fragment),wl=a(),Dt=i("p"),Dt.textContent=jr,Tl=a(),p(Qt.$$.fragment),xl=a(),Ot=i("p"),Ot.innerHTML=_r,yl=a(),Kt=i("p"),Kt.innerHTML=Mr,Cl=a(),p(en.$$.fragment),kl=a(),tn=i("p"),tn.innerHTML=Pr,jl=a(),nn=i("p"),nn.textContent=qr,_l=a(),p(sn.$$.fragment),Ml=a(),an=i("p"),an.innerHTML=zr,Pl=a(),p(ln.$$.fragment),ql=a(),rn=i("p"),rn.innerHTML=Ur,zl=a(),p(on.$$.fragment),Ul=a(),pn=i("p"),pn.innerHTML=Hr,Hl=a(),p(mn.$$.fragment),Vl=a(),dn=i("p"),dn.textContent=Vr,Zl=a(),p(fn.$$.fragment),Ll=a(),p(hn.$$.fragment),Fl=a(),un=i("p"),un.innerHTML=Zr,Il=a(),p(gn.$$.fragment),Rl=a(),cn=i("p"),cn.textContent=Lr,Wl=a(),p($n.$$.fragment),Gl=a(),bn=i("p"),bn.textContent=Fr,Jl=a(),p(vn.$$.fragment),Nl=a(),wn=i("p"),wn.innerHTML=Ir,Sl=a(),p(Tn.$$.fragment),Xl=a(),xn=i("p"),xn.innerHTML=Rr,El=a(),p(yn.$$.fragment),Bl=a(),Cn=i("p"),Cn.textContent=Wr,Al=a(),p(kn.$$.fragment),Yl=a(),jn=i("p"),jn.textContent=Gr,Dl=a(),_n=i("p"),_n.textContent=Jr,Ql=a(),p(Mn.$$.fragment),Ol=a(),Pn=i("p"),Pn.innerHTML=Nr,Kl=a(),qn=i("p"),qn.innerHTML=Sr,ei=a(),p(zn.$$.fragment),ti=a(),Un=i("p"),Un.textContent=Xr,ni=a(),p(Hn.$$.fragment),si=a(),Vn=i("p"),Vn.textContent=Er,ai=a(),p(Zn.$$.fragment),li=a(),p(Ln.$$.fragment),ii=a(),Fn=i("p"),Fn.textContent=Br,ri=a(),p(In.$$.fragment),oi=a(),p(Rn.$$.fragment),pi=a(),Wn=i("p"),Wn.innerHTML=Ar,mi=a(),Jn=i("p"),this.h()},l(e){const t=so("svelte-u9bgzb",document.head);c=r(t,"META",{name:!0,content:!0}),t.forEach(n),w=l(e),b=r(e,"P",{}),Dr(b).forEach(n),Gn=l(e),m(T.$$.fragment,e),Xn=l(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1dvjafk"&&(x.textContent=fi),En=l(e),m(y.$$.fragment,e),Bn=l(e),m(C.$$.fragment,e),An=l(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-zageh2"&&(k.textContent=hi),Yn=l(e),m(j.$$.fragment,e),Dn=l(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-16bi7cp"&&(_.textContent=ui),Qn=l(e),M=r(e,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1s3smvj"&&(M.textContent=gi),On=l(e),m(P.$$.fragment,e),Kn=l(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-xx5dsm"&&(q.textContent=ci),es=l(e),m(z.$$.fragment,e),ts=l(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-mhr0gb"&&(U.textContent=$i),ns=l(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-zbn0tl"&&(H.textContent=bi),ss=l(e),m(V.$$.fragment,e),as=l(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1lmyquq"&&(Z.textContent=vi),ls=l(e),m(L.$$.fragment,e),is=l(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-q931x9"&&(F.innerHTML=wi),rs=l(e),m(I.$$.fragment,e),os=l(e),m(R.$$.fragment,e),ps=l(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1oazoau"&&(W.innerHTML=Ti),ms=l(e),m(G.$$.fragment,e),ds=l(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-rond5"&&(J.innerHTML=xi),fs=l(e),m(N.$$.fragment,e),hs=l(e),m(S.$$.fragment,e),us=l(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-5158zs"&&(X.innerHTML=yi),gs=l(e),m(E.$$.fragment,e),cs=l(e),m(B.$$.fragment,e),$s=l(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1l74vbi"&&(A.textContent=Ci),bs=l(e),m(Y.$$.fragment,e),vs=l(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-17mz02t"&&(D.innerHTML=ki),ws=l(e),m(Q.$$.fragment,e),Ts=l(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1fbuf3j"&&(O.textContent=ji),xs=l(e),m(K.$$.fragment,e),ys=l(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1ld4khv"&&(ee.textContent=_i),Cs=l(e),m(te.$$.fragment,e),ks=l(e),m(ne.$$.fragment,e),js=l(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-qq7mzd"&&(se.textContent=Mi),_s=l(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1380bi6"&&(ae.innerHTML=Pi),Ms=l(e),m(le.$$.fragment,e),Ps=l(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-10vz57"&&(ie.textContent=qi),qs=l(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1v396xu"&&(re.innerHTML=zi),zs=l(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-ssnlyg"&&(oe.textContent=Ui),Us=l(e),m(pe.$$.fragment,e),Hs=l(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1ur5avw"&&(me.textContent=Hi),Vs=l(e),m(de.$$.fragment,e),Zs=l(e),m(fe.$$.fragment,e),Ls=l(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1fczmsm"&&(he.textContent=Vi),Fs=l(e),m(ue.$$.fragment,e),Is=l(e),m(ge.$$.fragment,e),Rs=l(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-jzdlbw"&&(ce.innerHTML=Zi),Ws=l(e),m($e.$$.fragment,e),Gs=l(e),m(be.$$.fragment,e),Js=l(e),m(ve.$$.fragment,e),Ns=l(e),we=r(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-14m2s4w"&&(we.textContent=Li),Ss=l(e),m(Te.$$.fragment,e),Xs=l(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-vxjwty"&&(xe.innerHTML=Fi),Es=l(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1xp8jp0"&&(ye.innerHTML=Ii),Bs=l(e),Ce=r(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1vgvw8w"&&(Ce.innerHTML=Ri),As=l(e),m(ke.$$.fragment,e),Ys=l(e),je=r(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-192shka"&&(je.innerHTML=Wi),Ds=l(e),_e=r(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-1gtjz9f"&&(_e.innerHTML=Gi),Qs=l(e),m(Me.$$.fragment,e),Os=l(e),m(Pe.$$.fragment,e),Ks=l(e),qe=r(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1espo04"&&(qe.textContent=Ji),ea=l(e),ze=r(e,"UL",{"data-svelte-h":!0}),o(ze)!=="svelte-f7vbio"&&(ze.innerHTML=Ni),ta=l(e),m(Ue.$$.fragment,e),na=l(e),m(He.$$.fragment,e),sa=l(e),Ve=r(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1mw8vlz"&&(Ve.innerHTML=Si),aa=l(e),m(Ze.$$.fragment,e),la=l(e),Le=r(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-17c2u3c"&&(Le.innerHTML=Xi),ia=l(e),m(Fe.$$.fragment,e),ra=l(e),Ie=r(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1jkg17q"&&(Ie.textContent=Ei),oa=l(e),m(Re.$$.fragment,e),pa=l(e),We=r(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-f3pbty"&&(We.innerHTML=Bi),ma=l(e),m(Ge.$$.fragment,e),da=l(e),Je=r(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1k2pdza"&&(Je.textContent=Ai),fa=l(e),m(Ne.$$.fragment,e),ha=l(e),Se=r(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-1439yqx"&&(Se.textContent=Yi),ua=l(e),m(Xe.$$.fragment,e),ga=l(e),Ee=r(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-z90sko"&&(Ee.innerHTML=Di),ca=l(e),m(Be.$$.fragment,e),$a=l(e),Ae=r(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1dyjpha"&&(Ae.innerHTML=Qi),ba=l(e),m(Ye.$$.fragment,e),va=l(e),De=r(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-we66x9"&&(De.textContent=Oi),wa=l(e),Qe=r(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-by6kqv"&&(Qe.textContent=Ki),Ta=l(e),m(Oe.$$.fragment,e),xa=l(e),Ke=r(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-1ojjtj3"&&(Ke.textContent=er),ya=l(e),m(et.$$.fragment,e),Ca=l(e),tt=r(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1rr608v"&&(tt.innerHTML=tr),ka=l(e),m(nt.$$.fragment,e),ja=l(e),m(st.$$.fragment,e),_a=l(e),at=r(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-7ywmff"&&(at.textContent=nr),Ma=l(e),lt=r(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-psjost"&&(lt.textContent=sr),Pa=l(e),it=r(e,"UL",{"data-svelte-h":!0}),o(it)!=="svelte-giuup1"&&(it.innerHTML=ar),qa=l(e),m(v.$$.fragment,e),za=l(e),rt=r(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-1lexyzh"&&(rt.innerHTML=lr),Ua=l(e),m(ot.$$.fragment,e),Ha=l(e),pt=r(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-1vm9qc5"&&(pt.textContent=ir),Va=l(e),m(mt.$$.fragment,e),Za=l(e),m(dt.$$.fragment,e),La=l(e),ft=r(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1kgpofh"&&(ft.textContent=rr),Fa=l(e),m(ht.$$.fragment,e),Ia=l(e),ut=r(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-me9jqn"&&(ut.textContent=or),Ra=l(e),m(gt.$$.fragment,e),Wa=l(e),m(ct.$$.fragment,e),Ga=l(e),$t=r(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-1lci4tz"&&($t.innerHTML=pr),Ja=l(e),m(bt.$$.fragment,e),Na=l(e),vt=r(e,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-1xw03f6"&&(vt.textContent=mr),Sa=l(e),m(wt.$$.fragment,e),Xa=l(e),Tt=r(e,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-jloa1o"&&(Tt.textContent=dr),Ea=l(e),m(xt.$$.fragment,e),Ba=l(e),m(yt.$$.fragment,e),Aa=l(e),Ct=r(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-11425z2"&&(Ct.textContent=fr),Ya=l(e),kt=r(e,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-d7g64p"&&(kt.innerHTML=hr),Da=l(e),m(jt.$$.fragment,e),Qa=l(e),_t=r(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-1atuy26"&&(_t.innerHTML=ur),Oa=l(e),m(Mt.$$.fragment,e),Ka=l(e),Pt=r(e,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-1kebnp7"&&(Pt.innerHTML=gr),el=l(e),m(qt.$$.fragment,e),tl=l(e),zt=r(e,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-1r6n0wg"&&(zt.textContent=cr),nl=l(e),m(Ut.$$.fragment,e),sl=l(e),Ht=r(e,"P",{"data-svelte-h":!0}),o(Ht)!=="svelte-igup9t"&&(Ht.innerHTML=$r),al=l(e),Vt=r(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-11pr6r1"&&(Vt.innerHTML=br),ll=l(e),Zt=r(e,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-1ytbypv"&&(Zt.innerHTML=vr),il=l(e),m(Lt.$$.fragment,e),rl=l(e),Ft=r(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-f3comh"&&(Ft.innerHTML=wr),ol=l(e),m(It.$$.fragment,e),pl=l(e),Rt=r(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-k4gwb8"&&(Rt.innerHTML=Tr),ml=l(e),Wt=r(e,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-ufotjt"&&(Wt.textContent=xr),dl=l(e),m(Gt.$$.fragment,e),fl=l(e),m(Jt.$$.fragment,e),hl=l(e),Nt=r(e,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-1mx2xgz"&&(Nt.textContent=yr),ul=l(e),m(St.$$.fragment,e),gl=l(e),Xt=r(e,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-161935m"&&(Xt.textContent=Cr),cl=l(e),m(Et.$$.fragment,e),$l=l(e),m(Bt.$$.fragment,e),bl=l(e),At=r(e,"P",{"data-svelte-h":!0}),o(At)!=="svelte-1lulygn"&&(At.textContent=kr),vl=l(e),m(Yt.$$.fragment,e),wl=l(e),Dt=r(e,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-7tevil"&&(Dt.textContent=jr),Tl=l(e),m(Qt.$$.fragment,e),xl=l(e),Ot=r(e,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-q5srtm"&&(Ot.innerHTML=_r),yl=l(e),Kt=r(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-1gi4tsf"&&(Kt.innerHTML=Mr),Cl=l(e),m(en.$$.fragment,e),kl=l(e),tn=r(e,"P",{"data-svelte-h":!0}),o(tn)!=="svelte-pmee3i"&&(tn.innerHTML=Pr),jl=l(e),nn=r(e,"P",{"data-svelte-h":!0}),o(nn)!=="svelte-1s8tag4"&&(nn.textContent=qr),_l=l(e),m(sn.$$.fragment,e),Ml=l(e),an=r(e,"P",{"data-svelte-h":!0}),o(an)!=="svelte-1js9xy4"&&(an.innerHTML=zr),Pl=l(e),m(ln.$$.fragment,e),ql=l(e),rn=r(e,"P",{"data-svelte-h":!0}),o(rn)!=="svelte-t41slg"&&(rn.innerHTML=Ur),zl=l(e),m(on.$$.fragment,e),Ul=l(e),pn=r(e,"P",{"data-svelte-h":!0}),o(pn)!=="svelte-1uq3sec"&&(pn.innerHTML=Hr),Hl=l(e),m(mn.$$.fragment,e),Vl=l(e),dn=r(e,"P",{"data-svelte-h":!0}),o(dn)!=="svelte-14ftbmc"&&(dn.textContent=Vr),Zl=l(e),m(fn.$$.fragment,e),Ll=l(e),m(hn.$$.fragment,e),Fl=l(e),un=r(e,"P",{"data-svelte-h":!0}),o(un)!=="svelte-1e72nph"&&(un.innerHTML=Zr),Il=l(e),m(gn.$$.fragment,e),Rl=l(e),cn=r(e,"P",{"data-svelte-h":!0}),o(cn)!=="svelte-16cfsju"&&(cn.textContent=Lr),Wl=l(e),m($n.$$.fragment,e),Gl=l(e),bn=r(e,"P",{"data-svelte-h":!0}),o(bn)!=="svelte-1lo37lj"&&(bn.textContent=Fr),Jl=l(e),m(vn.$$.fragment,e),Nl=l(e),wn=r(e,"P",{"data-svelte-h":!0}),o(wn)!=="svelte-10jv2li"&&(wn.innerHTML=Ir),Sl=l(e),m(Tn.$$.fragment,e),Xl=l(e),xn=r(e,"P",{"data-svelte-h":!0}),o(xn)!=="svelte-10hgp93"&&(xn.innerHTML=Rr),El=l(e),m(yn.$$.fragment,e),Bl=l(e),Cn=r(e,"P",{"data-svelte-h":!0}),o(Cn)!=="svelte-19vzvwp"&&(Cn.textContent=Wr),Al=l(e),m(kn.$$.fragment,e),Yl=l(e),jn=r(e,"P",{"data-svelte-h":!0}),o(jn)!=="svelte-fygh0e"&&(jn.textContent=Gr),Dl=l(e),_n=r(e,"P",{"data-svelte-h":!0}),o(_n)!=="svelte-u6fatw"&&(_n.textContent=Jr),Ql=l(e),m(Mn.$$.fragment,e),Ol=l(e),Pn=r(e,"P",{"data-svelte-h":!0}),o(Pn)!=="svelte-13hm16g"&&(Pn.innerHTML=Nr),Kl=l(e),qn=r(e,"P",{"data-svelte-h":!0}),o(qn)!=="svelte-1esk3y8"&&(qn.innerHTML=Sr),ei=l(e),m(zn.$$.fragment,e),ti=l(e),Un=r(e,"P",{"data-svelte-h":!0}),o(Un)!=="svelte-nsuab6"&&(Un.textContent=Xr),ni=l(e),m(Hn.$$.fragment,e),si=l(e),Vn=r(e,"P",{"data-svelte-h":!0}),o(Vn)!=="svelte-cpkjuk"&&(Vn.textContent=Er),ai=l(e),m(Zn.$$.fragment,e),li=l(e),m(Ln.$$.fragment,e),ii=l(e),Fn=r(e,"P",{"data-svelte-h":!0}),o(Fn)!=="svelte-1pfu149"&&(Fn.textContent=Br),ri=l(e),m(In.$$.fragment,e),oi=l(e),m(Rn.$$.fragment,e),pi=l(e),Wn=r(e,"P",{"data-svelte-h":!0}),o(Wn)!=="svelte-f1o49"&&(Wn.innerHTML=Ar),mi=l(e),Jn=r(e,"P",{}),Dr(Jn).forEach(n),this.h()},h(){Qr(c,"name","hf:doc:metadata"),Qr(c,"content",oo)},m(e,t){ao(document.head,c),s(e,w,t),s(e,b,t),s(e,Gn,t),d(T,e,t),s(e,Xn,t),s(e,x,t),s(e,En,t),d(y,e,t),s(e,Bn,t),d(C,e,t),s(e,An,t),s(e,k,t),s(e,Yn,t),d(j,e,t),s(e,Dn,t),s(e,_,t),s(e,Qn,t),s(e,M,t),s(e,On,t),d(P,e,t),s(e,Kn,t),s(e,q,t),s(e,es,t),d(z,e,t),s(e,ts,t),s(e,U,t),s(e,ns,t),s(e,H,t),s(e,ss,t),d(V,e,t),s(e,as,t),s(e,Z,t),s(e,ls,t),d(L,e,t),s(e,is,t),s(e,F,t),s(e,rs,t),d(I,e,t),s(e,os,t),d(R,e,t),s(e,ps,t),s(e,W,t),s(e,ms,t),d(G,e,t),s(e,ds,t),s(e,J,t),s(e,fs,t),d(N,e,t),s(e,hs,t),d(S,e,t),s(e,us,t),s(e,X,t),s(e,gs,t),d(E,e,t),s(e,cs,t),d(B,e,t),s(e,$s,t),s(e,A,t),s(e,bs,t),d(Y,e,t),s(e,vs,t),s(e,D,t),s(e,ws,t),d(Q,e,t),s(e,Ts,t),s(e,O,t),s(e,xs,t),d(K,e,t),s(e,ys,t),s(e,ee,t),s(e,Cs,t),d(te,e,t),s(e,ks,t),d(ne,e,t),s(e,js,t),s(e,se,t),s(e,_s,t),s(e,ae,t),s(e,Ms,t),d(le,e,t),s(e,Ps,t),s(e,ie,t),s(e,qs,t),s(e,re,t),s(e,zs,t),s(e,oe,t),s(e,Us,t),d(pe,e,t),s(e,Hs,t),s(e,me,t),s(e,Vs,t),d(de,e,t),s(e,Zs,t),d(fe,e,t),s(e,Ls,t),s(e,he,t),s(e,Fs,t),d(ue,e,t),s(e,Is,t),d(ge,e,t),s(e,Rs,t),s(e,ce,t),s(e,Ws,t),d($e,e,t),s(e,Gs,t),d(be,e,t),s(e,Js,t),d(ve,e,t),s(e,Ns,t),s(e,we,t),s(e,Ss,t),d(Te,e,t),s(e,Xs,t),s(e,xe,t),s(e,Es,t),s(e,ye,t),s(e,Bs,t),s(e,Ce,t),s(e,As,t),d(ke,e,t),s(e,Ys,t),s(e,je,t),s(e,Ds,t),s(e,_e,t),s(e,Qs,t),d(Me,e,t),s(e,Os,t),d(Pe,e,t),s(e,Ks,t),s(e,qe,t),s(e,ea,t),s(e,ze,t),s(e,ta,t),d(Ue,e,t),s(e,na,t),d(He,e,t),s(e,sa,t),s(e,Ve,t),s(e,aa,t),d(Ze,e,t),s(e,la,t),s(e,Le,t),s(e,ia,t),d(Fe,e,t),s(e,ra,t),s(e,Ie,t),s(e,oa,t),d(Re,e,t),s(e,pa,t),s(e,We,t),s(e,ma,t),d(Ge,e,t),s(e,da,t),s(e,Je,t),s(e,fa,t),d(Ne,e,t),s(e,ha,t),s(e,Se,t),s(e,ua,t),d(Xe,e,t),s(e,ga,t),s(e,Ee,t),s(e,ca,t),d(Be,e,t),s(e,$a,t),s(e,Ae,t),s(e,ba,t),d(Ye,e,t),s(e,va,t),s(e,De,t),s(e,wa,t),s(e,Qe,t),s(e,Ta,t),d(Oe,e,t),s(e,xa,t),s(e,Ke,t),s(e,ya,t),d(et,e,t),s(e,Ca,t),s(e,tt,t),s(e,ka,t),d(nt,e,t),s(e,ja,t),d(st,e,t),s(e,_a,t),s(e,at,t),s(e,Ma,t),s(e,lt,t),s(e,Pa,t),s(e,it,t),s(e,qa,t),d(v,e,t),s(e,za,t),s(e,rt,t),s(e,Ua,t),d(ot,e,t),s(e,Ha,t),s(e,pt,t),s(e,Va,t),d(mt,e,t),s(e,Za,t),d(dt,e,t),s(e,La,t),s(e,ft,t),s(e,Fa,t),d(ht,e,t),s(e,Ia,t),s(e,ut,t),s(e,Ra,t),d(gt,e,t),s(e,Wa,t),d(ct,e,t),s(e,Ga,t),s(e,$t,t),s(e,Ja,t),d(bt,e,t),s(e,Na,t),s(e,vt,t),s(e,Sa,t),d(wt,e,t),s(e,Xa,t),s(e,Tt,t),s(e,Ea,t),d(xt,e,t),s(e,Ba,t),d(yt,e,t),s(e,Aa,t),s(e,Ct,t),s(e,Ya,t),s(e,kt,t),s(e,Da,t),d(jt,e,t),s(e,Qa,t),s(e,_t,t),s(e,Oa,t),d(Mt,e,t),s(e,Ka,t),s(e,Pt,t),s(e,el,t),d(qt,e,t),s(e,tl,t),s(e,zt,t),s(e,nl,t),d(Ut,e,t),s(e,sl,t),s(e,Ht,t),s(e,al,t),s(e,Vt,t),s(e,ll,t),s(e,Zt,t),s(e,il,t),d(Lt,e,t),s(e,rl,t),s(e,Ft,t),s(e,ol,t),d(It,e,t),s(e,pl,t),s(e,Rt,t),s(e,ml,t),s(e,Wt,t),s(e,dl,t),d(Gt,e,t),s(e,fl,t),d(Jt,e,t),s(e,hl,t),s(e,Nt,t),s(e,ul,t),d(St,e,t),s(e,gl,t),s(e,Xt,t),s(e,cl,t),d(Et,e,t),s(e,$l,t),d(Bt,e,t),s(e,bl,t),s(e,At,t),s(e,vl,t),d(Yt,e,t),s(e,wl,t),s(e,Dt,t),s(e,Tl,t),d(Qt,e,t),s(e,xl,t),s(e,Ot,t),s(e,yl,t),s(e,Kt,t),s(e,Cl,t),d(en,e,t),s(e,kl,t),s(e,tn,t),s(e,jl,t),s(e,nn,t),s(e,_l,t),d(sn,e,t),s(e,Ml,t),s(e,an,t),s(e,Pl,t),d(ln,e,t),s(e,ql,t),s(e,rn,t),s(e,zl,t),d(on,e,t),s(e,Ul,t),s(e,pn,t),s(e,Hl,t),d(mn,e,t),s(e,Vl,t),s(e,dn,t),s(e,Zl,t),d(fn,e,t),s(e,Ll,t),d(hn,e,t),s(e,Fl,t),s(e,un,t),s(e,Il,t),d(gn,e,t),s(e,Rl,t),s(e,cn,t),s(e,Wl,t),d($n,e,t),s(e,Gl,t),s(e,bn,t),s(e,Jl,t),d(vn,e,t),s(e,Nl,t),s(e,wn,t),s(e,Sl,t),d(Tn,e,t),s(e,Xl,t),s(e,xn,t),s(e,El,t),d(yn,e,t),s(e,Bl,t),s(e,Cn,t),s(e,Al,t),d(kn,e,t),s(e,Yl,t),s(e,jn,t),s(e,Dl,t),s(e,_n,t),s(e,Ql,t),d(Mn,e,t),s(e,Ol,t),s(e,Pn,t),s(e,Kl,t),s(e,qn,t),s(e,ei,t),d(zn,e,t),s(e,ti,t),s(e,Un,t),s(e,ni,t),d(Hn,e,t),s(e,si,t),s(e,Vn,t),s(e,ai,t),d(Zn,e,t),s(e,li,t),d(Ln,e,t),s(e,ii,t),s(e,Fn,t),s(e,ri,t),d(In,e,t),s(e,oi,t),d(Rn,e,t),s(e,pi,t),s(e,Wn,t),s(e,mi,t),s(e,Jn,t),di=!0},p(e,[t]){const Yr={};t&2&&(Yr.$$scope={dirty:t,ctx:e}),v.$set(Yr)},i(e){di||(f(T.$$.fragment,e),f(y.$$.fragment,e),f(C.$$.fragment,e),f(j.$$.fragment,e),f(P.$$.fragment,e),f(z.$$.fragment,e),f(V.$$.fragment,e),f(L.$$.fragment,e),f(I.$$.fragment,e),f(R.$$.fragment,e),f(G.$$.fragment,e),f(N.$$.fragment,e),f(S.$$.fragment,e),f(E.$$.fragment,e),f(B.$$.fragment,e),f(Y.$$.fragment,e),f(Q.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(le.$$.fragment,e),f(pe.$$.fragment,e),f(de.$$.fragment,e),f(fe.$$.fragment,e),f(ue.$$.fragment,e),f(ge.$$.fragment,e),f($e.$$.fragment,e),f(be.$$.fragment,e),f(ve.$$.fragment,e),f(Te.$$.fragment,e),f(ke.$$.fragment,e),f(Me.$$.fragment,e),f(Pe.$$.fragment,e),f(Ue.$$.fragment,e),f(He.$$.fragment,e),f(Ze.$$.fragment,e),f(Fe.$$.fragment,e),f(Re.$$.fragment,e),f(Ge.$$.fragment,e),f(Ne.$$.fragment,e),f(Xe.$$.fragment,e),f(Be.$$.fragment,e),f(Ye.$$.fragment,e),f(Oe.$$.fragment,e),f(et.$$.fragment,e),f(nt.$$.fragment,e),f(st.$$.fragment,e),f(v.$$.fragment,e),f(ot.$$.fragment,e),f(mt.$$.fragment,e),f(dt.$$.fragment,e),f(ht.$$.fragment,e),f(gt.$$.fragment,e),f(ct.$$.fragment,e),f(bt.$$.fragment,e),f(wt.$$.fragment,e),f(xt.$$.fragment,e),f(yt.$$.fragment,e),f(jt.$$.fragment,e),f(Mt.$$.fragment,e),f(qt.$$.fragment,e),f(Ut.$$.fragment,e),f(Lt.$$.fragment,e),f(It.$$.fragment,e),f(Gt.$$.fragment,e),f(Jt.$$.fragment,e),f(St.$$.fragment,e),f(Et.$$.fragment,e),f(Bt.$$.fragment,e),f(Yt.$$.fragment,e),f(Qt.$$.fragment,e),f(en.$$.fragment,e),f(sn.$$.fragment,e),f(ln.$$.fragment,e),f(on.$$.fragment,e),f(mn.$$.fragment,e),f(fn.$$.fragment,e),f(hn.$$.fragment,e),f(gn.$$.fragment,e),f($n.$$.fragment,e),f(vn.$$.fragment,e),f(Tn.$$.fragment,e),f(yn.$$.fragment,e),f(kn.$$.fragment,e),f(Mn.$$.fragment,e),f(zn.$$.fragment,e),f(Hn.$$.fragment,e),f(Zn.$$.fragment,e),f(Ln.$$.fragment,e),f(In.$$.fragment,e),f(Rn.$$.fragment,e),di=!0)},o(e){h(T.$$.fragment,e),h(y.$$.fragment,e),h(C.$$.fragment,e),h(j.$$.fragment,e),h(P.$$.fragment,e),h(z.$$.fragment,e),h(V.$$.fragment,e),h(L.$$.fragment,e),h(I.$$.fragment,e),h(R.$$.fragment,e),h(G.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(E.$$.fragment,e),h(B.$$.fragment,e),h(Y.$$.fragment,e),h(Q.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(le.$$.fragment,e),h(pe.$$.fragment,e),h(de.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(ge.$$.fragment,e),h($e.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(Te.$$.fragment,e),h(ke.$$.fragment,e),h(Me.$$.fragment,e),h(Pe.$$.fragment,e),h(Ue.$$.fragment,e),h(He.$$.fragment,e),h(Ze.$$.fragment,e),h(Fe.$$.fragment,e),h(Re.$$.fragment,e),h(Ge.$$.fragment,e),h(Ne.$$.fragment,e),h(Xe.$$.fragment,e),h(Be.$$.fragment,e),h(Ye.$$.fragment,e),h(Oe.$$.fragment,e),h(et.$$.fragment,e),h(nt.$$.fragment,e),h(st.$$.fragment,e),h(v.$$.fragment,e),h(ot.$$.fragment,e),h(mt.$$.fragment,e),h(dt.$$.fragment,e),h(ht.$$.fragment,e),h(gt.$$.fragment,e),h(ct.$$.fragment,e),h(bt.$$.fragment,e),h(wt.$$.fragment,e),h(xt.$$.fragment,e),h(yt.$$.fragment,e),h(jt.$$.fragment,e),h(Mt.$$.fragment,e),h(qt.$$.fragment,e),h(Ut.$$.fragment,e),h(Lt.$$.fragment,e),h(It.$$.fragment,e),h(Gt.$$.fragment,e),h(Jt.$$.fragment,e),h(St.$$.fragment,e),h(Et.$$.fragment,e),h(Bt.$$.fragment,e),h(Yt.$$.fragment,e),h(Qt.$$.fragment,e),h(en.$$.fragment,e),h(sn.$$.fragment,e),h(ln.$$.fragment,e),h(on.$$.fragment,e),h(mn.$$.fragment,e),h(fn.$$.fragment,e),h(hn.$$.fragment,e),h(gn.$$.fragment,e),h($n.$$.fragment,e),h(vn.$$.fragment,e),h(Tn.$$.fragment,e),h(yn.$$.fragment,e),h(kn.$$.fragment,e),h(Mn.$$.fragment,e),h(zn.$$.fragment,e),h(Hn.$$.fragment,e),h(Zn.$$.fragment,e),h(Ln.$$.fragment,e),h(In.$$.fragment,e),h(Rn.$$.fragment,e),di=!1},d(e){e&&(n(w),n(b),n(Gn),n(Xn),n(x),n(En),n(Bn),n(An),n(k),n(Yn),n(Dn),n(_),n(Qn),n(M),n(On),n(Kn),n(q),n(es),n(ts),n(U),n(ns),n(H),n(ss),n(as),n(Z),n(ls),n(is),n(F),n(rs),n(os),n(ps),n(W),n(ms),n(ds),n(J),n(fs),n(hs),n(us),n(X),n(gs),n(cs),n($s),n(A),n(bs),n(vs),n(D),n(ws),n(Ts),n(O),n(xs),n(ys),n(ee),n(Cs),n(ks),n(js),n(se),n(_s),n(ae),n(Ms),n(Ps),n(ie),n(qs),n(re),n(zs),n(oe),n(Us),n(Hs),n(me),n(Vs),n(Zs),n(Ls),n(he),n(Fs),n(Is),n(Rs),n(ce),n(Ws),n(Gs),n(Js),n(Ns),n(we),n(Ss),n(Xs),n(xe),n(Es),n(ye),n(Bs),n(Ce),n(As),n(Ys),n(je),n(Ds),n(_e),n(Qs),n(Os),n(Ks),n(qe),n(ea),n(ze),n(ta),n(na),n(sa),n(Ve),n(aa),n(la),n(Le),n(ia),n(ra),n(Ie),n(oa),n(pa),n(We),n(ma),n(da),n(Je),n(fa),n(ha),n(Se),n(ua),n(ga),n(Ee),n(ca),n($a),n(Ae),n(ba),n(va),n(De),n(wa),n(Qe),n(Ta),n(xa),n(Ke),n(ya),n(Ca),n(tt),n(ka),n(ja),n(_a),n(at),n(Ma),n(lt),n(Pa),n(it),n(qa),n(za),n(rt),n(Ua),n(Ha),n(pt),n(Va),n(Za),n(La),n(ft),n(Fa),n(Ia),n(ut),n(Ra),n(Wa),n(Ga),n($t),n(Ja),n(Na),n(vt),n(Sa),n(Xa),n(Tt),n(Ea),n(Ba),n(Aa),n(Ct),n(Ya),n(kt),n(Da),n(Qa),n(_t),n(Oa),n(Ka),n(Pt),n(el),n(tl),n(zt),n(nl),n(sl),n(Ht),n(al),n(Vt),n(ll),n(Zt),n(il),n(rl),n(Ft),n(ol),n(pl),n(Rt),n(ml),n(Wt),n(dl),n(fl),n(hl),n(Nt),n(ul),n(gl),n(Xt),n(cl),n($l),n(bl),n(At),n(vl),n(wl),n(Dt),n(Tl),n(xl),n(Ot),n(yl),n(Kt),n(Cl),n(kl),n(tn),n(jl),n(nn),n(_l),n(Ml),n(an),n(Pl),n(ql),n(rn),n(zl),n(Ul),n(pn),n(Hl),n(Vl),n(dn),n(Zl),n(Ll),n(Fl),n(un),n(Il),n(Rl),n(cn),n(Wl),n(Gl),n(bn),n(Jl),n(Nl),n(wn),n(Sl),n(Xl),n(xn),n(El),n(Bl),n(Cn),n(Al),n(Yl),n(jn),n(Dl),n(_n),n(Ql),n(Ol),n(Pn),n(Kl),n(qn),n(ei),n(ti),n(Un),n(ni),n(si),n(Vn),n(ai),n(li),n(ii),n(Fn),n(ri),n(oi),n(pi),n(Wn),n(mi),n(Jn)),n(c),u(T,e),u(y,e),u(C,e),u(j,e),u(P,e),u(z,e),u(V,e),u(L,e),u(I,e),u(R,e),u(G,e),u(N,e),u(S,e),u(E,e),u(B,e),u(Y,e),u(Q,e),u(K,e),u(te,e),u(ne,e),u(le,e),u(pe,e),u(de,e),u(fe,e),u(ue,e),u(ge,e),u($e,e),u(be,e),u(ve,e),u(Te,e),u(ke,e),u(Me,e),u(Pe,e),u(Ue,e),u(He,e),u(Ze,e),u(Fe,e),u(Re,e),u(Ge,e),u(Ne,e),u(Xe,e),u(Be,e),u(Ye,e),u(Oe,e),u(et,e),u(nt,e),u(st,e),u(v,e),u(ot,e),u(mt,e),u(dt,e),u(ht,e),u(gt,e),u(ct,e),u(bt,e),u(wt,e),u(xt,e),u(yt,e),u(jt,e),u(Mt,e),u(qt,e),u(Ut,e),u(Lt,e),u(It,e),u(Gt,e),u(Jt,e),u(St,e),u(Et,e),u(Bt,e),u(Yt,e),u(Qt,e),u(en,e),u(sn,e),u(ln,e),u(on,e),u(mn,e),u(fn,e),u(hn,e),u(gn,e),u($n,e),u(vn,e),u(Tn,e),u(yn,e),u(kn,e),u(Mn,e),u(zn,e),u(Hn,e),u(Zn,e),u(Ln,e),u(In,e),u(Rn,e)}}}const oo='{"title":"Glossary","local":"glossary","sections":[{"title":"A","local":"a","sections":[{"title":"attention mask","local":"attention-mask","sections":[],"depth":3},{"title":"autoencoding models","local":"autoencoding-models","sections":[],"depth":3},{"title":"autoregressive models","local":"autoregressive-models","sections":[],"depth":3}],"depth":2},{"title":"B","local":"b","sections":[{"title":"backbone","local":"backbone","sections":[],"depth":3}],"depth":2},{"title":"C","local":"c","sections":[{"title":"causal language modeling","local":"causal-language-modeling","sections":[],"depth":3},{"title":"channel","local":"channel","sections":[],"depth":3},{"title":"connectionist temporal classification (CTC)","local":"connectionist-temporal-classification-ctc","sections":[],"depth":3},{"title":"convolution","local":"convolution","sections":[],"depth":3}],"depth":2},{"title":"D","local":"d","sections":[{"title":"DataParallel (DP)","local":"dataparallel-dp","sections":[],"depth":3},{"title":"decoder input IDs","local":"decoder-input-ids","sections":[],"depth":3},{"title":"decoder models","local":"decoder-models","sections":[],"depth":3},{"title":"deep learning (DL)","local":"deep-learning-dl","sections":[],"depth":3}],"depth":2},{"title":"E","local":"e","sections":[{"title":"encoder models","local":"encoder-models","sections":[],"depth":3}],"depth":2},{"title":"F","local":"f","sections":[{"title":"feature extraction","local":"feature-extraction","sections":[],"depth":3},{"title":"feed forward chunking","local":"feed-forward-chunking","sections":[],"depth":3},{"title":"finetuned models","local":"finetuned-models","sections":[],"depth":3}],"depth":2},{"title":"H","local":"h","sections":[{"title":"head","local":"head","sections":[],"depth":3}],"depth":2},{"title":"I","local":"i","sections":[{"title":"image patch","local":"image-patch","sections":[],"depth":3},{"title":"inference","local":"inference","sections":[],"depth":3},{"title":"input IDs","local":"input-ids","sections":[],"depth":3}],"depth":2},{"title":"L","local":"l","sections":[{"title":"labels","local":"labels","sections":[],"depth":3},{"title":"large language models (LLM)","local":"large-language-models-llm","sections":[],"depth":3}],"depth":2},{"title":"M","local":"m","sections":[{"title":"masked language modeling (MLM)","local":"masked-language-modeling-mlm","sections":[],"depth":3},{"title":"multimodal","local":"multimodal","sections":[],"depth":3}],"depth":2},{"title":"N","local":"n","sections":[{"title":"Natural language generation (NLG)","local":"natural-language-generation-nlg","sections":[],"depth":3},{"title":"Natural language processing (NLP)","local":"natural-language-processing-nlp","sections":[],"depth":3},{"title":"Natural language understanding (NLU)","local":"natural-language-understanding-nlu","sections":[],"depth":3}],"depth":2},{"title":"P","local":"p","sections":[{"title":"pipeline","local":"pipeline","sections":[],"depth":3},{"title":"PipelineParallel (PP)","local":"pipelineparallel-pp","sections":[],"depth":3},{"title":"pixel values","local":"pixel-values","sections":[],"depth":3},{"title":"pooling","local":"pooling","sections":[],"depth":3},{"title":"position IDs","local":"position-ids","sections":[],"depth":3},{"title":"preprocessing","local":"preprocessing","sections":[],"depth":3},{"title":"pretrained model","local":"pretrained-model","sections":[],"depth":3}],"depth":2},{"title":"R","local":"r","sections":[{"title":"recurrent neural network (RNN)","local":"recurrent-neural-network-rnn","sections":[],"depth":3},{"title":"representation learning","local":"representation-learning","sections":[],"depth":3}],"depth":2},{"title":"S","local":"s","sections":[{"title":"sampling rate","local":"sampling-rate","sections":[],"depth":3},{"title":"self-attention","local":"self-attention","sections":[],"depth":3},{"title":"self-supervised learning","local":"self-supervised-learning","sections":[],"depth":3},{"title":"semi-supervised learning","local":"semi-supervised-learning","sections":[],"depth":3},{"title":"sequence-to-sequence (seq2seq)","local":"sequence-to-sequence-seq2seq","sections":[],"depth":3},{"title":"Sharded DDP","local":"sharded-ddp","sections":[],"depth":3},{"title":"stride","local":"stride","sections":[],"depth":3},{"title":"supervised learning","local":"supervised-learning","sections":[],"depth":3}],"depth":2},{"title":"T","local":"t","sections":[{"title":"Tensor Parallelism (TP)","local":"tensor-parallelism-tp","sections":[],"depth":3},{"title":"token","local":"token","sections":[],"depth":3},{"title":"token Type IDs","local":"token-type-ids","sections":[],"depth":3},{"title":"transfer learning","local":"transfer-learning","sections":[],"depth":3},{"title":"transformer","local":"transformer","sections":[],"depth":3}],"depth":2},{"title":"U","local":"u","sections":[{"title":"unsupervised learning","local":"unsupervised-learning","sections":[],"depth":3}],"depth":2},{"title":"Z","local":"z","sections":[{"title":"Zero Redundancy Optimizer (ZeRO)","local":"zero-redundancy-optimizer-zero","sections":[],"depth":3}],"depth":2}],"depth":1}';function po(Sn){return Kr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $o extends to{constructor(c){super(),no(this,c,po,ro,Or,{})}}export{$o as component};
