import{s as on,o as rn,n as mt}from"../chunks/scheduler.25b97de1.js";import{S as pn,i as cn,g as o,s as n,r as c,A as dn,h as i,f as s,c as l,j as ln,u as d,x as r,k as ea,y as mn,a,v as m,d as h,t as g,w as u}from"../chunks/index.d9030fc9.js";import{T as dt}from"../chunks/Tip.baa67368.js";import{C as T}from"../chunks/CodeBlock.e6cd0d95.js";import{H as w,E as hn}from"../chunks/EditOnGithub.91d95064.js";function gn(j){let p,b=`<code>generate()</code> is a critical component of our <a href="quicktour#chat-with-text-generation-models">chat CLI</a>.
You can apply the learnings of this guide there as well.`;return{c(){p=o("p"),p.innerHTML=b},l(y){p=i(y,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1n2d9nv"&&(p.innerHTML=b)},m(y,M){a(y,p,M)},p:mt,d(y){y&&s(p)}}}function un(j){let p,b="The API for the streamer classes is still under development and may change in the future.";return{c(){p=o("p"),p.textContent=b},l(y){p=i(y,"P",{"data-svelte-h":!0}),r(p)!=="svelte-gv2g1g"&&(p.textContent=b)},m(y,M){a(y,p,M)},p:mt,d(y){y&&s(p)}}}function yn(j){let p,b=`The WatermarkDetector internally relies on the proportion of “green” tokens, and whether generated text follows the coloring pattern.
That is why it is recommended to strip off the prompt text, if it is much longer than the generated text.
This also can have an effect when one sequence in the batch is a lot longer causing other rows to be padded.
Additionally, the detector <strong>must</strong> be initiated with identical watermark configuration arguments used when generating.`;return{c(){p=o("p"),p.innerHTML=b},l(y){p=i(y,"P",{"data-svelte-h":!0}),r(p)!=="svelte-ge8sma"&&(p.innerHTML=b)},m(y,M){a(y,p,M)},p:mt,d(y){y&&s(p)}}}function Mn(j){let p,b=`Selecting a given decoding strategy is not the only way you can influence the outcome of <code>generate()</code> with your model.
The decoding strategies act based (mostly) on the logits, the distribution of probabilities for the next token, and
thus selecting a good logits manipulation strategy can go a long way! In other words, manipulating the logits is another
dimension you can act upon, in addition to selecting a decoding strategy. Popular logits manipulation strategies include
<code>top_p</code>, <code>min_p</code>, and <code>repetition_penalty</code> — you can check the full list in the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> class.`;return{c(){p=o("p"),p.innerHTML=b},l(y){p=i(y,"P",{"data-svelte-h":!0}),r(p)!=="svelte-16lh8dy"&&(p.innerHTML=b)},m(y,M){a(y,p,M)},p:mt,d(y){y&&s(p)}}}function bn(j){let p,b="If you’re using a <code>pipeline</code> object, all you need to do is to pass the assistant checkpoint under <code>assistant_model</code>",y,M,J;return M=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXNzaXN0YW50X21vZGVsJTNEJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMi0xQiUyMiUyQyUyMCUyMCUyMyUyMFRoaXMlMjBleHRyYSUyMGxpbmUlMjBpcyUyMGFsbCUyMHRoYXQncyUyMG5lZWRlZCUyQyUyMGFsc28lMjB3b3JrcyUyMHdpdGglMjBVQUQlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQXBpcGVfb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwJTIyJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXBpcGVfb3V0cHV0JTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span>,
<span class="hljs-meta">... </span>    assistant_model=<span class="hljs-string">&quot;meta-llama/Llama-3.2-1B&quot;</span>,  <span class="hljs-comment"># This extra line is all that&#x27;s needed, also works with UAD</span>
<span class="hljs-meta">... </span>    torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_output = pipe(<span class="hljs-string">&quot;Once upon a time, &quot;</span>, max_new_tokens=<span class="hljs-number">50</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]
<span class="hljs-string">&#x27;Once upon a time, 3D printing was a niche technology that was only&#x27;</span>`,wrap:!1}}),{c(){p=o("p"),p.innerHTML=b,y=n(),c(M.$$.fragment)},l(f){p=i(f,"P",{"data-svelte-h":!0}),r(p)!=="svelte-gga9f9"&&(p.innerHTML=b),y=l(f),d(M.$$.fragment,f)},m(f,U){a(f,p,U),a(f,y,U),m(M,f,U),J=!0},p:mt,i(f){J||(h(M.$$.fragment,f),J=!0)},o(f){g(M.$$.fragment,f),J=!1},d(f){f&&(s(p),s(y)),u(M,f)}}}function fn(j){let p,b,y,M,J,f,U,ta=`Text generation is essential to many NLP tasks, such as open-ended text generation, summarization, translation, and
more. It also plays a role in a variety of mixed-modality applications that have text as an output like speech-to-text
and vision-to-text. Some of the models that can generate text include
GPT2, XLNet, OpenAI GPT, CTRL, TransformerXL, XLM, Bart, T5, GIT, Whisper.`,ht,B,sa=`Check out a few examples that use <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method to produce
text outputs for different tasks:`,gt,C,aa='<li><a href="./tasks/summarization#inference">Text summarization</a></li> <li><a href="./model_doc/git#transformers.GitForCausalLM.forward.example">Image captioning</a></li> <li><a href="./model_doc/whisper#transformers.WhisperForConditionalGeneration.forward.example">Audio transcription</a></li>',ut,V,na=`Note that the inputs to the generate method depend on the model’s modality. They are returned by the model’s preprocessor
class, such as AutoTokenizer or AutoProcessor. If a model’s preprocessor creates more than one kind of input, pass all
the inputs to generate(). You can learn more about the individual model’s preprocessor in the corresponding model’s documentation.`,yt,R,la=`The process of selecting output tokens to generate text is known as decoding, and you can customize the decoding strategy
that the <code>generate()</code> method will use. Modifying a decoding strategy does not change the values of any trainable parameters.
However, it can have a noticeable impact on the quality of the generated output. It can help reduce repetition in the text
and make it more coherent.`,Mt,_,oa="This guide describes:",bt,I,ia="<li>default generation configuration</li> <li>common decoding strategies and their main parameters</li> <li>saving and sharing custom generation configurations with your fine-tuned model on 🤗 Hub</li>",ft,Z,wt,$,Tt,H,ra=`A decoding strategy for a model is defined in its generation configuration. When using pre-trained models for inference
within a <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>, the models call the <code>PreTrainedModel.generate()</code> method that applies a default generation
configuration under the hood. The default configuration is also used when no custom configuration has been saved with
the model.`,jt,x,pa=`When you load a model explicitly, you can inspect the generation configuration that comes with it through
<code>model.generation_config</code>:`,Jt,N,Ut,z,ca=`Printing out the <code>model.generation_config</code> reveals only the values that are different from the default generation
configuration, and does not list any of the default values.`,kt,F,da=`The default generation configuration limits the size of the output combined with the input prompt to a maximum of 20
tokens to avoid running into resource limitations. The default decoding strategy is greedy search, which is the simplest decoding strategy that picks a token with the highest probability as the next token. For many tasks
and small output sizes this works well. However, when used to generate longer outputs, greedy search can start
producing highly repetitive results.`,Zt,Q,vt,Y,ma="You can override any <code>generation_config</code> by passing the parameters and their values directly to the <code>generate</code> method:",Wt,E,Gt,S,ha=`Even if the default decoding strategy mostly works for your task, you can still tweak a few things. Some of the
commonly adjusted parameters include:`,Xt,L,ga=`<li><code>max_new_tokens</code>: the maximum number of tokens to generate. In other words, the size of the output sequence, not
including the tokens in the prompt. As an alternative to using the output’s length as a stopping criteria, you can choose
to stop generation whenever the full generation exceeds some amount of time. To learn more, check <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>.</li> <li><code>num_beams</code>: by specifying a number of beams higher than 1, you are effectively switching from greedy search to
beam search. This strategy evaluates several hypotheses at each time step and eventually chooses the hypothesis that
has the overall highest probability for the entire sequence. This has the advantage of identifying high-probability
sequences that start with a lower probability initial tokens and would’ve been ignored by the greedy search. Visualize how it works <a href="https://huggingface.co/spaces/m-ric/beam_search_visualizer" rel="nofollow">here</a>.</li> <li><code>do_sample</code>: if set to <code>True</code>, this parameter enables decoding strategies such as multinomial sampling, beam-search
multinomial sampling, Top-K sampling and Top-p sampling. All these strategies select the next token from the probability
distribution over the entire vocabulary with various strategy-specific adjustments.</li> <li><code>num_return_sequences</code>: the number of sequence candidates to return for each input. This option is only available for
the decoding strategies that support multiple sequence candidates, e.g. variations of beam search and sampling. Decoding
strategies like greedy search and contrastive search return a single output sequence.</li>`,Bt,q,ua=`It is also possible to extend <code>generate()</code> with external libraries or handcrafted code. The <code>logits_processor</code> argument
allows you to pass custom <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> instances, allowing you to manipulate the next token probability
distributions. Likewise, the <code>stopping_criteria</code> argument lets you set custom <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> to stop text generation.
The <a href="https://github.com/NVIDIA/logits-processor-zoo" rel="nofollow"><code>logits-processor-zoo</code></a> library contains examples of external
<code>generate()</code>-compatible extensions.`,Ct,A,Vt,D,ya="If you would like to share your fine-tuned model with a specific generation configuration, you can:",Rt,K,Ma='<li>Create a <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> class instance</li> <li>Specify the decoding strategy parameters</li> <li>Save your generation configuration with <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">GenerationConfig.save_pretrained()</a>, making sure to leave its <code>config_file_name</code> argument empty</li> <li>Set <code>push_to_hub</code> to <code>True</code> to upload your config to the model’s repo</li>',_t,P,It,O,ba=`You can also store several generation configurations in a single directory, making use of the <code>config_file_name</code>
argument in <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">GenerationConfig.save_pretrained()</a>. You can later instantiate them with <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig.from_pretrained">GenerationConfig.from_pretrained()</a>. This is useful if you want to
store several generation configurations for a single model (e.g. one for creative text generation with sampling, and
one for summarization with beam search). You must have the right Hub permissions to add configuration files to a model.`,$t,ee,Ht,te,xt,se,fa=`The <code>generate()</code> supports streaming, through its <code>streamer</code> input. The <code>streamer</code> input is compatible with any instance
from a class that has the following methods: <code>put()</code> and <code>end()</code>. Internally, <code>put()</code> is used to push new tokens and
<code>end()</code> is used to flag the end of text generation.`,Nt,v,zt,ae,wa=`In practice, you can craft your own streaming class for all sorts of purposes! We also have basic streaming classes
ready for you to use. For example, you can use the <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TextStreamer">TextStreamer</a> class to stream the output of <code>generate()</code> into
your screen, one word at a time:`,Ft,ne,Qt,le,Yt,oe,Ta=`The <code>generate()</code> supports watermarking the generated text by randomly marking a portion of tokens as “green”.
When generating the “green” will have a small ‘bias’ value added to their logits, thus having a higher chance to be generated.
The watermarked text can be detected by calculating the proportion of “green” tokens in the text and estimating how likely it is
statistically to obtain that amount of “green” tokens for human-generated text. This watermarking strategy was proposed in the paper
<a href="https://arxiv.org/abs/2306.04634" rel="nofollow">“On the Reliability of Watermarks for Large Language Models”</a>. For more information on
the inner functioning of watermarking, it is recommended to refer to the paper.`,Et,ie,ja=`The watermarking can be used with any generative model in <code>tranformers</code> and does not require an extra classification model
to detect watermarked text. To trigger watermarking, pass in a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.WatermarkingConfig">WatermarkingConfig</a> with needed arguments directly to the
<code>.generate()</code> method or add it to the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>. Watermarked text can be later detected with a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.WatermarkDetector">WatermarkDetector</a>.`,St,W,Lt,re,Ja=`Let’s generate some text with watermarking. In the below code snippet, we set the bias to 2.5 which is a value that
will be added to “green” tokens’ logits. After generating watermarked text, we can pass it directly to the <code>WatermarkDetector</code>
to check if the text is machine-generated (outputs <code>True</code> for machine-generated and <code>False</code> otherwise).`,qt,pe,At,ce,Dt,de,Ua=`Certain combinations of the <code>generate()</code> parameters, and ultimately <code>generation_config</code>, can be used to enable specific
decoding strategies. If you are new to this concept, we recommend reading
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">this blog post that illustrates how common decoding strategies work</a>.`,Kt,me,ka="Here, we’ll show some of the parameters that control the decoding strategies and illustrate how you can use them.",Pt,G,Ot,he,es,ge,Za="<code>generate</code> uses greedy search decoding by default so you don’t have to pass any parameters to enable it. This means the parameters <code>num_beams</code> is set to 1 and <code>do_sample=False</code>.",ts,ue,ss,ye,as,Me,va=`The contrastive search decoding strategy was proposed in the 2022 paper <a href="https://arxiv.org/abs/2202.06417" rel="nofollow">A Contrastive Framework for Neural Text Generation</a>.
It demonstrates superior results for generating non-repetitive yet coherent long outputs. To learn how contrastive search
works, check out <a href="https://huggingface.co/blog/introducing-csearch" rel="nofollow">this blog post</a>.
The two main parameters that enable and control the behavior of contrastive search are <code>penalty_alpha</code> and <code>top_k</code>:`,ns,be,ls,fe,os,we,Wa=`As opposed to greedy search that always chooses a token with the highest probability as the
next token, multinomial sampling (also called ancestral sampling) randomly selects the next token based on the probability distribution over the entire
vocabulary given by the model. Every token with a non-zero probability has a chance of being selected, thus reducing the
risk of repetition.`,is,Te,Ga="To enable multinomial sampling set <code>do_sample=True</code> and <code>num_beams=1</code>.",rs,je,ps,Je,cs,Ue,Xa=`Unlike greedy search, beam-search decoding keeps several hypotheses at each time step and eventually chooses
the hypothesis that has the overall highest probability for the entire sequence. This has the advantage of identifying high-probability
sequences that start with lower probability initial tokens and would’ve been ignored by the greedy search.`,ds,k,Ba='<img style="max-width: 90%; margin: auto;" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/beam_search.png"/>',ms,ke,Ca='You can visualize how beam-search decoding works in <a href="https://huggingface.co/spaces/m-ric/beam_search_visualizer" rel="nofollow">this interactive demo</a>: type your input sentence, and play with the parameters to see how the decoding beams change.',hs,Ze,Va="To enable this decoding strategy, specify the <code>num_beams</code> (aka number of hypotheses to keep track of) that is greater than 1.",gs,ve,us,We,ys,Ge,Ra=`As the name implies, this decoding strategy combines beam search with multinomial sampling. You need to specify
the <code>num_beams</code> greater than 1, and set <code>do_sample=True</code> to use this decoding strategy.`,Ms,Xe,bs,Be,fs,Ce,_a=`The diverse beam search decoding strategy is an extension of the beam search strategy that allows for generating a more diverse
set of beam sequences to choose from. To learn how it works, refer to <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam Search: Decoding Diverse Solutions from Neural Sequence Models</a>.
This approach has three main parameters: <code>num_beams</code>, <code>num_beam_groups</code>, and <code>diversity_penalty</code>.
The diversity penalty ensures the outputs are distinct across groups, and beam search is used within each group.`,ws,Ve,Ts,Re,Ia=`This guide illustrates the main parameters that enable various decoding strategies. More advanced parameters exist for the
<code>generate</code> method, which gives you even further control over the <code>generate</code> method’s behavior.
For the complete list of the available parameters, refer to the <a href="./main_classes/text_generation">API documentation</a>.`,js,_e,Js,Ie,$a=`Speculative decoding (also known as assisted decoding) is a modification of the decoding strategies above, that uses an
assistant model (ideally a much smaller one), to generate a few candidate tokens. The main model then validates the candidate
tokens in a single forward pass, which speeds up the decoding process. If <code>do_sample=True</code>, then the token validation with
resampling introduced in the <a href="https://arxiv.org/pdf/2211.17192.pdf" rel="nofollow">speculative decoding paper</a> is used.
Assisted decoding assumes the main and assistant models have the same tokenizer, otherwise, see Universal Assisted Decoding below.`,Us,$e,Ha=`Currently, only greedy search and sampling are supported with assisted decoding, and assisted decoding doesn’t support batched inputs.
To learn more about assisted decoding, check <a href="https://huggingface.co/blog/assisted-generation" rel="nofollow">this blog post</a>.`,ks,He,xa="To enable assisted decoding, set the <code>assistant_model</code> argument with a model.",Zs,xe,vs,X,Ws,Ne,Na=`When using assisted decoding with sampling methods, you can use the <code>temperature</code> argument to control the randomness,
just like in multinomial sampling. However, in assisted decoding, reducing the temperature may help improve the latency.`,Gs,ze,Xs,Fe,za="We recommend to install <code>scikit-learn</code> library to enhance the candidate generation strategy and achieve additional speedup.",Bs,Qe,Cs,Ye,Fa=`Universal Assisted Decoding (UAD) adds support for main and assistant models with different tokenizers.
To use it, simply pass the tokenizers using the <code>tokenizer</code> and <code>assistant_tokenizer</code> arguments (see below).
Internally, the main model input tokens are re-encoded into assistant model tokens, then candidate tokens are generated in the assistant encoding, which are
in turn re-encoded into main model candidate tokens. Validation then proceeds as explained above.
The re-encoding steps involve decoding token ids into text and then encoding the text using a different tokenizer.
Since re-encoding the tokens may result in tokenization discrepancies, UAD finds the longest common subsequence between the source and target encodings,
to ensure the new tokens include the correct prompt suffix.`,Vs,Ee,Rs,Se,_s,Le,Qa=`Alternatively, you can also set the <code>prompt_lookup_num_tokens</code> to trigger n-gram based assisted decoding, as opposed
to model based assisted decoding. You can read more about it <a href="https://twitter.com/joao_gante/status/1747322413006643259" rel="nofollow">here</a>.`,Is,qe,$s,Ae,Ya=`An LLM can be trained to also use its language modeling head with earlier hidden states as input, effectively
skipping layers to yield a lower-quality output — a technique called early exiting.
We use the lower-quality early exit output as an assistant output, and apply self-speculation to fix the output using the remaining layers. The final generation of that self-speculative solution is the same (or has the same distribution) as the original model’s generation.
If the model you’re using was trained to do early exit, you can pass
<code>assistant_early_exit</code> (integer). In this case, the assistant model will be the same model but exiting early, hence the
“self-speculative” name. Because the assistant model is a portion of the target model, caches and weights can be shared, which results in lower memory requirements. As in other assisted generation methods, the final generated result has the same quality as if no assistant had been used.`,Hs,De,xs,Ke,Ns,Pe,Ea=`<strong>D</strong>ecoding by C<strong>o</strong>ntrasting <strong>La</strong>yers (DoLa) is a contrastive decoding strategy to improve the factuality and reduce the
hallucinations of LLMs, as described in this paper of ICLR 2024 <a href="https://arxiv.org/abs/2309.03883" rel="nofollow">DoLa: Decoding by Contrasting Layers Improves Factuality in Large Language Models</a>.`,zs,Oe,Sa=`DoLa is achieved by contrasting the differences in logits obtained from final
layers versus earlier layers, thus amplify the factual knowledge localized to particular part of transformer layers.`,Fs,et,La="Do the following two steps to activate DoLa decoding when calling the <code>model.generate</code> function:",Qs,tt,qa="<li>Set the <code>dola_layers</code> argument, which can be either a string or a list of integers.<ul><li>If set to a string, it can be one of <code>low</code>, <code>high</code>.</li> <li>If set to a list of integers, it should be a list of layer indices between 0 and the total number of layers in the model. The 0-th layer is word embedding, and the 1st layer is the first transformer layer, and so on.</li></ul></li> <li>Set <code>repetition_penalty = 1.2</code> is suggested to reduce repetition in DoLa decoding.</li>",Ys,st,Aa="See the following examples for DoLa decoding with the 32-layer LLaMA-7B model.",Es,at,Ss,nt,Ls,lt,Da="<code>dola_layers</code> stands for the candidate layers in premature layer selection, as described in the DoLa paper. The selected premature layer will be contrasted with the final layer.",qs,ot,Ka="Setting <code>dola_layers</code> to <code>&#39;low&#39;</code> or <code>&#39;high&#39;</code> will select the lower or higher part of the layers to contrast, respectively.",As,it,Pa="<li>For <code>N</code>-layer models with <code>N &lt;= 40</code> layers, the layers of <code>range(0, N // 2, 2)</code> and <code>range(N // 2, N, 2)</code> are used for <code>&#39;low&#39;</code> and <code>&#39;high&#39;</code> layers, respectively.</li> <li>For models with <code>N &gt; 40</code> layers, the layers of <code>range(0, 20, 2)</code> and <code>range(N - 20, N, 2)</code> are used for <code>&#39;low&#39;</code> and <code>&#39;high&#39;</code> layers, respectively.</li> <li>If the model has tied word embeddings, we skip the word embeddings (0-th) layer and start from the 2nd layer, as the early exit from word embeddings will become identity function.</li> <li>Set the <code>dola_layers</code> to a list of integers for layer indices to contrast manually specified layers. For example, setting <code>dola_layers=[28,30]</code> will contrast the final layer (32-th layer) with the 28-th and 30-th layers.</li>",Ds,rt,Oa="The paper suggested that contrasting <code>&#39;high&#39;</code> layers to improve short-answer tasks like TruthfulQA, and contrasting <code>&#39;low&#39;</code> layers to improve all the other long-answer reasoning tasks, such as GSM8K, StrategyQA, FACTOR, and VicunaQA. Applying DoLa to smaller models like GPT-2 is not recommended, as the results shown in the Appendix N of the paper.",Ks,pt,Ps,ct,Os;return J=new w({props:{title:"Text generation strategies",local:"text-generation-strategies",headingTag:"h1"}}),Z=new dt({props:{$$slots:{default:[gn]},$$scope:{ctx:j}}}),$=new w({props:{title:"Default text generation configuration",local:"default-text-generation-configuration",headingTag:"h2"}}),N=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config
GenerationConfig {
  <span class="hljs-string">&quot;bos_token_id&quot;</span>: <span class="hljs-number">50256</span>,
  <span class="hljs-string">&quot;eos_token_id&quot;</span>: <span class="hljs-number">50256</span>
}
&lt;BLANKLINE&gt;`,wrap:!1}}),Q=new w({props:{title:"Customize text generation",local:"customize-text-generation",headingTag:"h2"}}),E=new T({props:{code:"bXlfbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBudW1fYmVhbXMlM0Q0JTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>my_model.generate(**inputs, num_beams=<span class="hljs-number">4</span>, do_sample=<span class="hljs-literal">True</span>)',wrap:!1}}),A=new w({props:{title:"Save a custom decoding strategy with your model",local:"save-a-custom-decoding-strategy-with-your-model",headingTag:"h2"}}),P=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwR2VuZXJhdGlvbkNvbmZpZyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm15X2FjY291bnQlMkZteV9tb2RlbCUyMiklMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q1MCUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfayUzRDUwJTJDJTIwZW9zX3Rva2VuX2lkJTNEbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUwQSklMEFnZW5lcmF0aW9uX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIybXlfYWNjb3VudCUyRm15X21vZGVsJTIyJTJDJTIwcHVzaF90b19odWIlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;my_account/my_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig(
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">50</span>, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">50</span>, eos_token_id=model.config.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;my_account/my_model&quot;</span>, push_to_hub=<span class="hljs-literal">True</span>)`,wrap:!1}}),ee=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLXQ1JTJGdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LXNtYWxsJTIyKSUwQSUwQXRyYW5zbGF0aW9uX2dlbmVyYXRpb25fY29uZmlnJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZyglMEElMjAlMjAlMjAlMjBudW1fYmVhbXMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZWFybHlfc3RvcHBpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZGVjb2Rlcl9zdGFydF90b2tlbl9pZCUzRDAlMkMlMEElMjAlMjAlMjAlMjBlb3NfdG9rZW5faWQlM0Rtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTJDJTBBJTIwJTIwJTIwJTIwcGFkX3Rva2VuJTNEbW9kZWwuY29uZmlnLnBhZF90b2tlbl9pZCUyQyUwQSklMEElMEElMjMlMjBUaXAlM0ElMjBhZGQlMjAlNjBwdXNoX3RvX2h1YiUzRFRydWUlNjAlMjB0byUyMHB1c2glMjB0byUyMHRoZSUyMEh1YiUwQXRyYW5zbGF0aW9uX2dlbmVyYXRpb25fY29uZmlnLnNhdmVfcHJldHJhaW5lZCglMjIlMkZ0bXAlMjIlMkMlMjAlMjJ0cmFuc2xhdGlvbl9nZW5lcmF0aW9uX2NvbmZpZy5qc29uJTIyKSUwQSUwQSUyMyUyMFlvdSUyMGNvdWxkJTIwdGhlbiUyMHVzZSUyMHRoZSUyMG5hbWVkJTIwZ2VuZXJhdGlvbiUyMGNvbmZpZyUyMGZpbGUlMjB0byUyMHBhcmFtZXRlcml6ZSUyMGdlbmVyYXRpb24lMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMiUyRnRtcCUyMiUyQyUyMCUyMnRyYW5zbGF0aW9uX2dlbmVyYXRpb25fY29uZmlnLmpzb24lMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMEZyZW5jaCUzQSUyMENvbmZpZ3VyYXRpb24lMjBmaWxlcyUyMGFyZSUyMGVhc3klMjB0byUyMHVzZSElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGdlbmVyYXRpb25fY29uZmlnJTNEZ2VuZXJhdGlvbl9jb25maWcpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, AutoTokenizer, GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>translation_generation_config = GenerationConfig(
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    early_stopping=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    decoder_start_token_id=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>    eos_token_id=model.config.eos_token_id,
<span class="hljs-meta">... </span>    pad_token=model.config.pad_token_id,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: add \`push_to_hub=True\` to push to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>translation_generation_config.save_pretrained(<span class="hljs-string">&quot;/tmp&quot;</span>, <span class="hljs-string">&quot;translation_generation_config.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You could then use the named generation config file to parameterize generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;/tmp&quot;</span>, <span class="hljs-string">&quot;translation_generation_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;translate English to French: Configuration files are easy to use!&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, generation_config=generation_config)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Les fichiers de configuration sont faciles à utiliser!&#x27;</span>]`,wrap:!1}}),te=new w({props:{title:"Streaming",local:"streaming",headingTag:"h2"}}),v=new dt({props:{warning:!0,$$slots:{default:[un]},$$scope:{ctx:j}}}),ne=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0U3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMERlc3BpdGUlMjByZXR1cm5pbmclMjB0aGUlMjB1c3VhbCUyMG91dHB1dCUyQyUyMHRoZSUyMHN0cmVhbWVyJTIwd2lsbCUyMGFsc28lMjBwcmludCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjB0byUyMHN0ZG91dC4lMEFfJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),le=new w({props:{title:"Watermarking",local:"watermarking",headingTag:"h2"}}),W=new dt({props:{warning:!0,$$slots:{default:[yn]},$$scope:{ctx:j}}}),pe=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya0RldGVjdG9yJTJDJTIwV2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBdG9rJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBdG9rLnBhZF90b2tlbl9pZCUyMCUzRCUyMHRvay5lb3NfdG9rZW5faWQlMEF0b2sucGFkZGluZ19zaWRlJTIwJTNEJTIwJTIybGVmdCUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJUaGlzJTIwaXMlMjB0aGUlMjBiZWdpbm5pbmclMjBvZiUyMGElMjBsb25nJTIwc3RvcnklMjIlMkMlMjAlMjJBbGljZSUyMGFuZCUyMEJvYiUyMGFyZSUyMiU1RCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFpbnB1dF9sZW4lMjAlM0QlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQuc2hhcGUlNUItMSU1RCUwQSUwQXdhdGVybWFya2luZ19jb25maWclMjAlM0QlMjBXYXRlcm1hcmtpbmdDb25maWcoYmlhcyUzRDIuNSUyQyUyMHNlZWRpbmdfc2NoZW1lJTNEJTIyc2VsZmhhc2glMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjB3YXRlcm1hcmtpbmdfY29uZmlnJTNEd2F0ZXJtYXJraW5nX2NvbmZpZyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X2xlbmd0aCUzRDIwKSUwQSUwQWRldGVjdG9yJTIwJTNEJTIwV2F0ZXJtYXJrRGV0ZWN0b3IobW9kZWxfY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwZGV2aWNlJTNEJTIyY3B1JTIyJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRHdhdGVybWFya2luZ19jb25maWcpJTBBZGV0ZWN0aW9uX291dCUyMCUzRCUyMGRldGVjdG9yKG91dCUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSklMEFkZXRlY3Rpb25fb3V0LnByZWRpY3Rpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkDetector, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.pad_token_id = tok.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.padding_side = <span class="hljs-string">&quot;left&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;This is the beginning of a long story&quot;</span>, <span class="hljs-string">&quot;Alice and Bob are&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_len = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config=watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out = detector(out, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out.prediction
array([ <span class="hljs-literal">True</span>,  <span class="hljs-literal">True</span>])`,wrap:!1}}),ce=new w({props:{title:"Decoding strategies",local:"decoding-strategies",headingTag:"h2"}}),G=new dt({props:{$$slots:{default:[Mn]},$$scope:{ctx:j}}}),he=new w({props:{title:"Greedy Search",local:"greedy-search",headingTag:"h3"}}),ue=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkklMjBsb29rJTIwZm9yd2FyZCUyMHRvJTIyJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;I look forward to&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;I look forward to seeing you all again!\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n&#x27;</span>]`,wrap:!1}}),ye=new w({props:{title:"Contrastive search",local:"contrastive-search",headingTag:"h3"}}),be=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0Mi1sYXJnZSUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIdWdnaW5nJTIwRmFjZSUyMENvbXBhbnklMjBpcyUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHBlbmFsdHlfYWxwaGElM0QwLjYlMkMlMjB0b3BfayUzRDQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai-community/gpt2-large&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hugging Face Company is&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, penalty_alpha=<span class="hljs-number">0.6</span>, top_k=<span class="hljs-number">4</span>, max_new_tokens=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Hugging Face Company is a family owned and operated business. We pride ourselves on being the best
in the business and our customer service is second to none.\\n\\nIf you have any questions about our
products or services, feel free to contact us at any time. We look forward to hearing from you!&#x27;</span>]`,wrap:!1}}),fe=new w({props:{title:"Multinomial sampling",local:"multinomial-sampling",headingTag:"h3"}}),je=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBc2V0X3NlZWQoMCklMjAlMjAlMjMlMjBGb3IlMjByZXByb2R1Y2liaWxpdHklMEElMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDItbGFyZ2UlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyVG9kYXklMjB3YXMlMjBhbiUyMGFtYXppbmclMjBkYXklMjBiZWNhdXNlJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMG51bV9iZWFtcyUzRDElMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># For reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai-community/gpt2-large&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Today was an amazing day because&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, num_beams=<span class="hljs-number">1</span>, max_new_tokens=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;Today was an amazing day because we received these wonderful items by the way of a gift shop. The box arrived on a Thursday and I opened it on Monday afternoon to receive the gifts. Both bags featured pieces from all the previous years!\\n\\nThe box had lots of surprises in it, including some sweet little mini chocolate chips! I don&#x27;t think I&#x27;d eat all of these. This was definitely one of the most expensive presents I have ever got, I actually got most of them for free!\\n\\nThe first package came&quot;</span>]`,wrap:!1}}),Je=new w({props:{title:"Beam-search decoding",local:"beam-search-decoding",headingTag:"h3"}}),ve=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkl0JTIwaXMlMjBhc3RvbmlzaGluZyUyMGhvdyUyMG9uZSUyMGNhbiUyMiUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0Mi1tZWRpdW0lMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbnVtX2JlYW1zJTNENSUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;It is astonishing how one can&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai-community/gpt2-medium&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, num_beams=<span class="hljs-number">5</span>, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;It is astonishing how one can have such a profound impact on the lives of so many people in such a short period of
time.&quot;\\n\\nHe added: &quot;I am very proud of the work I have been able to do in the last few years.\\n\\n&quot;I have&#x27;</span>]`,wrap:!1}}),We=new w({props:{title:"Beam-search multinomial sampling",local:"beam-search-multinomial-sampling",headingTag:"h3"}}),Xe=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMkMlMjBzZXRfc2VlZCUwQXNldF9zZWVkKDApJTIwJTIwJTIzJTIwRm9yJTIwcmVwcm9kdWNpYmlsaXR5JTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIydHJhbnNsYXRlJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwVGhlJTIwaG91c2UlMjBpcyUyMHdvbmRlcmZ1bC4lMjIlMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyZ29vZ2xlLXQ1JTJGdDUtc21hbGwlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG51bV9iZWFtcyUzRDUlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># For reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;translate English to German: The house is wonderful.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google-t5/t5-small&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, num_beams=<span class="hljs-number">5</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Das Haus ist wunderbar.&#x27;</span>`,wrap:!1}}),Be=new w({props:{title:"Diverse beam search decoding",local:"diverse-beam-search-decoding",headingTag:"h3"}}),Ve=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyZ29vZ2xlJTJGcGVnYXN1cy14c3VtJTIyJTBBcHJvbXB0JTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMlRoZSUyMFBlcm1hY3VsdHVyZSUyMERlc2lnbiUyMFByaW5jaXBsZXMlMjBhcmUlMjBhJTIwc2V0JTIwb2YlMjB1bml2ZXJzYWwlMjBkZXNpZ24lMjBwcmluY2lwbGVzJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIydGhhdCUyMGNhbiUyMGJlJTIwYXBwbGllZCUyMHRvJTIwYW55JTIwbG9jYXRpb24lMkMlMjBjbGltYXRlJTIwYW5kJTIwY3VsdHVyZSUyQyUyMGFuZCUyMHRoZXklMjBhbGxvdyUyMHVzJTIwdG8lMjBkZXNpZ24lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJ0aGUlMjBtb3N0JTIwZWZmaWNpZW50JTIwYW5kJTIwc3VzdGFpbmFibGUlMjBodW1hbiUyMGhhYml0YXRpb24lMjBhbmQlMjBmb29kJTIwcHJvZHVjdGlvbiUyMHN5c3RlbXMuJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIyUGVybWFjdWx0dXJlJTIwaXMlMjBhJTIwZGVzaWduJTIwc3lzdGVtJTIwdGhhdCUyMGVuY29tcGFzc2VzJTIwYSUyMHdpZGUlMjB2YXJpZXR5JTIwb2YlMjBkaXNjaXBsaW5lcyUyQyUyMHN1Y2glMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJhcyUyMGVjb2xvZ3klMkMlMjBsYW5kc2NhcGUlMjBkZXNpZ24lMkMlMjBlbnZpcm9ubWVudGFsJTIwc2NpZW5jZSUyMGFuZCUyMGVuZXJneSUyMGNvbnNlcnZhdGlvbiUyQyUyMGFuZCUyMHRoZSUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMlBlcm1hY3VsdHVyZSUyMGRlc2lnbiUyMHByaW5jaXBsZXMlMjBhcmUlMjBkcmF3biUyMGZyb20lMjB0aGVzZSUyMHZhcmlvdXMlMjBkaXNjaXBsaW5lcy4lMjBFYWNoJTIwaW5kaXZpZHVhbCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmRlc2lnbiUyMHByaW5jaXBsZSUyMGl0c2VsZiUyMGVtYm9kaWVzJTIwYSUyMGNvbXBsZXRlJTIwY29uY2VwdHVhbCUyMGZyYW1ld29yayUyMGJhc2VkJTIwb24lMjBzb3VuZCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMnNjaWVudGlmaWMlMjBwcmluY2lwbGVzLiUyMFdoZW4lMjB3ZSUyMGJyaW5nJTIwYWxsJTIwdGhlc2UlMjBzZXBhcmF0ZSUyMCUyMHByaW5jaXBsZXMlMjB0b2dldGhlciUyQyUyMHdlJTIwY2FuJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIyY3JlYXRlJTIwYSUyMGRlc2lnbiUyMHN5c3RlbSUyMHRoYXQlMjBib3RoJTIwbG9va3MlMjBhdCUyMHdob2xlJTIwc3lzdGVtcyUyQyUyMHRoZSUyMHBhcnRzJTIwdGhhdCUyMHRoZXNlJTIwc3lzdGVtcyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmNvbnNpc3QlMjBvZiUyQyUyMGFuZCUyMGhvdyUyMHRob3NlJTIwcGFydHMlMjBpbnRlcmFjdCUyMHdpdGglMjBlYWNoJTIwb3RoZXIlMjB0byUyMGNyZWF0ZSUyMGElMjBjb21wbGV4JTJDJTIwZHluYW1pYyUyQyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmxpdmluZyUyMHN5c3RlbS4lMjBFYWNoJTIwZGVzaWduJTIwcHJpbmNpcGxlJTIwc2VydmVzJTIwYXMlMjBhJTIwdG9vbCUyMHRoYXQlMjBhbGxvd3MlMjB1cyUyMHRvJTIwaW50ZWdyYXRlJTIwYWxsJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIydGhlJTIwc2VwYXJhdGUlMjBwYXJ0cyUyMG9mJTIwYSUyMGRlc2lnbiUyQyUyMHJlZmVycmVkJTIwdG8lMjBhcyUyMGVsZW1lbnRzJTJDJTIwaW50byUyMGElMjBmdW5jdGlvbmFsJTJDJTIwc3luZXJnaXN0aWMlMkMlMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJ3aG9sZSUyMHN5c3RlbSUyQyUyMHdoZXJlJTIwdGhlJTIwZWxlbWVudHMlMjBoYXJtb25pb3VzbHklMjBpbnRlcmFjdCUyMGFuZCUyMHdvcmslMjB0b2dldGhlciUyMGluJTIwdGhlJTIwbW9zdCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmVmZmljaWVudCUyMHdheSUyMHBvc3NpYmxlLiUyMiUwQSklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG51bV9iZWFtcyUzRDUlMkMlMjBudW1fYmVhbV9ncm91cHMlM0Q1JTJDJTIwbWF4X25ld190b2tlbnMlM0QzMCUyQyUyMGRpdmVyc2l0eV9wZW5hbHR5JTNEMS4wKSUwQXRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google/pegasus-xsum&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Permaculture Design Principles are a set of universal design principles &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;that can be applied to any location, climate and culture, and they allow us to design &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the most efficient and sustainable human habitation and food production systems. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Permaculture is a design system that encompasses a wide variety of disciplines, such &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;as ecology, landscape design, environmental science and energy conservation, and the &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Permaculture design principles are drawn from these various disciplines. Each individual &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;design principle itself embodies a complete conceptual framework based on sound &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;scientific principles. When we bring all these separate  principles together, we can &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;create a design system that both looks at whole systems, the parts that these systems &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;consist of, and how those parts interact with each other to create a complex, dynamic, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;living system. Each design principle serves as a tool that allows us to integrate all &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the separate parts of a design, referred to as elements, into a functional, synergistic, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;whole system, where the elements harmoniously interact and work together in the most &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;efficient way possible.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, num_beams=<span class="hljs-number">5</span>, num_beam_groups=<span class="hljs-number">5</span>, max_new_tokens=<span class="hljs-number">30</span>, diversity_penalty=<span class="hljs-number">1.0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;The Design Principles are a set of universal design principles that can be applied to any location, climate and
culture, and they allow us to design the&#x27;</span>`,wrap:!1}}),_e=new w({props:{title:"Speculative Decoding",local:"speculative-decoding",headingTag:"h3"}}),xe=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFsaWNlJTIwYW5kJTIwQm9iJTIyJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMkVsZXV0aGVyQUklMkZweXRoaWEtMS40Yi1kZWR1cGVkJTIyJTBBYXNzaXN0YW50X2NoZWNrcG9pbnQlMjAlM0QlMjAlMjJFbGV1dGhlckFJJTJGcHl0aGlhLTE2MG0tZGVkdXBlZCUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoYXNzaXN0YW50X2NoZWNrcG9pbnQpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYXNzaXN0YW50X21vZGVsJTNEYXNzaXN0YW50X21vZGVsKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Alice and Bob&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-1.4b-deduped&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-160m-deduped&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_model = AutoModelForCausalLM.from_pretrained(assistant_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, assistant_model=assistant_model)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Alice and Bob are sitting in a bar. Alice is drinking a beer and Bob is drinking a glass of wine.&#x27;</span>]`,wrap:!1}}),X=new dt({props:{$$slots:{default:[bn]},$$scope:{ctx:j}}}),ze=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMHNldF9zZWVkJTBBc2V0X3NlZWQoNDIpJTIwJTIwJTIzJTIwRm9yJTIwcmVwcm9kdWNpYmlsaXR5JTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQWxpY2UlMjBhbmQlMjBCb2IlMjIlMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyRWxldXRoZXJBSSUyRnB5dGhpYS0xLjRiLWRlZHVwZWQlMjIlMEFhc3Npc3RhbnRfY2hlY2twb2ludCUyMCUzRCUyMCUyMkVsZXV0aGVyQUklMkZweXRoaWEtMTYwbS1kZWR1cGVkJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWFzc2lzdGFudF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChhc3Npc3RhbnRfY2hlY2twb2ludCklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBhc3Npc3RhbnRfbW9kZWwlM0Rhc3Npc3RhbnRfbW9kZWwlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdGVtcGVyYXR1cmUlM0QwLjUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">42</span>)  <span class="hljs-comment"># For reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Alice and Bob&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-1.4b-deduped&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-160m-deduped&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_model = AutoModelForCausalLM.from_pretrained(assistant_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, assistant_model=assistant_model, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Alice and Bob are two people who are very different, but they are both very good at what they do. Alice&#x27;</span>]`,wrap:!1}}),Qe=new w({props:{title:"Universal Assisted Decoding",local:"universal-assisted-decoding",headingTag:"h4"}}),Ee=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFsaWNlJTIwYW5kJTIwQm9iJTIyJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmdvb2dsZSUyRmdlbW1hLTItOWIlMjIlMEFhc3Npc3RhbnRfY2hlY2twb2ludCUyMCUzRCUyMCUyMmRvdWJsZTclMkZ2aWN1bmEtNjhtJTIyJTBBJTBBYXNzaXN0YW50X3Rva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGFzc2lzdGFudF9jaGVja3BvaW50KSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoYXNzaXN0YW50X2NoZWNrcG9pbnQpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYXNzaXN0YW50X21vZGVsJTNEYXNzaXN0YW50X21vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTIwYXNzaXN0YW50X3Rva2VuaXplciUzRGFzc2lzdGFudF90b2tlbml6ZXIpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Alice and Bob&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google/gemma-2-9b&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_checkpoint = <span class="hljs-string">&quot;double7/vicuna-68m&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_tokenizer = AutoTokenizer.from_pretrained(assistant_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_model = AutoModelForCausalLM.from_pretrained(assistant_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, assistant_model=assistant_model, tokenizer=tokenizer, assistant_tokenizer=assistant_tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Alice and Bob are playing a game. Alice has a set of $n$ integers $a_1, a&#x27;</span>]`,wrap:!1}}),Se=new w({props:{title:"Prompt Lookup",local:"prompt-lookup",headingTag:"h4"}}),qe=new w({props:{title:"Self-Speculative Decoding",local:"self-speculative-decoding",headingTag:"h4"}}),De=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFsaWNlJTIwYW5kJTIwQm9iJTIyJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmZhY2Vib29rJTJGbGF5ZXJza2lwLWxsYW1hMy4yLTFCJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGFzc2lzdGFudF9lYXJseV9leGl0JTNENCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Alice and Bob&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;facebook/layerskip-llama3.2-1B&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, assistant_early_exit=<span class="hljs-number">4</span>, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Alice and Bob are playing a game. Alice has a set of $n$ integers $a_1, a&#x27;</span>]`,wrap:!1}}),Ke=new w({props:{title:"DoLa Decoding",local:"dola-decoding",headingTag:"h3"}}),at=new T({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

<span class="hljs-meta">&gt;&gt;&gt; </span>device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;huggyllama/llama-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;huggyllama/llama-7b&quot;</span>, torch_dtype=torch.float16).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">42</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;On what date was the Declaration of Independence officially signed?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># Vanilla greddy decoding</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vanilla_output = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(vanilla_output[:, inputs.input_ids.shape[-<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;\\nThe Declaration of Independence was signed on July 4, 1776.\\nWhat was the date of the signing of the Declaration of Independence?\\nThe Declaration of Independence was signed on July 4,&#x27;</span>]

<span class="hljs-comment"># DoLa decoding with contrasting higher part of layers (layers 16,18,...,30)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dola_high_output = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">50</span>, dola_layers=<span class="hljs-string">&#x27;high&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(dola_high_output[:, inputs.input_ids.shape[-<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;\\nJuly 4, 1776, when the Continental Congress voted to separate from Great Britain. The 56 delegates to the Continental Congress signed the Declaration on August 2, 1776.&#x27;</span>]

<span class="hljs-comment"># DoLa decoding with contrasting specific layers (layers 28 and 30)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dola_custom_output = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">50</span>, dola_layers=[<span class="hljs-number">28</span>,<span class="hljs-number">30</span>], repetition_penalty=<span class="hljs-number">1.2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(dola_custom_output[:, inputs.input_ids.shape[-<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;\\nIn 1891, when he was 54 years old, John Jacob Astor founded his empire. He opened a one-man business and spent the next 27 years working 10-hour days. When&#x27;</span>]`,wrap:!1}}),nt=new w({props:{title:"Understanding the dola_layers argument",local:"understanding-the-dolalayers-argument",headingTag:"h4"}}),pt=new hn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/generation_strategies.md"}}),{c(){p=o("meta"),b=n(),y=o("p"),M=n(),c(J.$$.fragment),f=n(),U=o("p"),U.textContent=ta,ht=n(),B=o("p"),B.innerHTML=sa,gt=n(),C=o("ul"),C.innerHTML=aa,ut=n(),V=o("p"),V.textContent=na,yt=n(),R=o("p"),R.innerHTML=la,Mt=n(),_=o("p"),_.textContent=oa,bt=n(),I=o("ul"),I.innerHTML=ia,ft=n(),c(Z.$$.fragment),wt=n(),c($.$$.fragment),Tt=n(),H=o("p"),H.innerHTML=ra,jt=n(),x=o("p"),x.innerHTML=pa,Jt=n(),c(N.$$.fragment),Ut=n(),z=o("p"),z.innerHTML=ca,kt=n(),F=o("p"),F.textContent=da,Zt=n(),c(Q.$$.fragment),vt=n(),Y=o("p"),Y.innerHTML=ma,Wt=n(),c(E.$$.fragment),Gt=n(),S=o("p"),S.textContent=ha,Xt=n(),L=o("ul"),L.innerHTML=ga,Bt=n(),q=o("p"),q.innerHTML=ua,Ct=n(),c(A.$$.fragment),Vt=n(),D=o("p"),D.textContent=ya,Rt=n(),K=o("ul"),K.innerHTML=Ma,_t=n(),c(P.$$.fragment),It=n(),O=o("p"),O.innerHTML=ba,$t=n(),c(ee.$$.fragment),Ht=n(),c(te.$$.fragment),xt=n(),se=o("p"),se.innerHTML=fa,Nt=n(),c(v.$$.fragment),zt=n(),ae=o("p"),ae.innerHTML=wa,Ft=n(),c(ne.$$.fragment),Qt=n(),c(le.$$.fragment),Yt=n(),oe=o("p"),oe.innerHTML=Ta,Et=n(),ie=o("p"),ie.innerHTML=ja,St=n(),c(W.$$.fragment),Lt=n(),re=o("p"),re.innerHTML=Ja,qt=n(),c(pe.$$.fragment),At=n(),c(ce.$$.fragment),Dt=n(),de=o("p"),de.innerHTML=Ua,Kt=n(),me=o("p"),me.textContent=ka,Pt=n(),c(G.$$.fragment),Ot=n(),c(he.$$.fragment),es=n(),ge=o("p"),ge.innerHTML=Za,ts=n(),c(ue.$$.fragment),ss=n(),c(ye.$$.fragment),as=n(),Me=o("p"),Me.innerHTML=va,ns=n(),c(be.$$.fragment),ls=n(),c(fe.$$.fragment),os=n(),we=o("p"),we.textContent=Wa,is=n(),Te=o("p"),Te.innerHTML=Ga,rs=n(),c(je.$$.fragment),ps=n(),c(Je.$$.fragment),cs=n(),Ue=o("p"),Ue.textContent=Xa,ds=n(),k=o("a"),k.innerHTML=Ba,ms=n(),ke=o("p"),ke.innerHTML=Ca,hs=n(),Ze=o("p"),Ze.innerHTML=Va,gs=n(),c(ve.$$.fragment),us=n(),c(We.$$.fragment),ys=n(),Ge=o("p"),Ge.innerHTML=Ra,Ms=n(),c(Xe.$$.fragment),bs=n(),c(Be.$$.fragment),fs=n(),Ce=o("p"),Ce.innerHTML=_a,ws=n(),c(Ve.$$.fragment),Ts=n(),Re=o("p"),Re.innerHTML=Ia,js=n(),c(_e.$$.fragment),Js=n(),Ie=o("p"),Ie.innerHTML=$a,Us=n(),$e=o("p"),$e.innerHTML=Ha,ks=n(),He=o("p"),He.innerHTML=xa,Zs=n(),c(xe.$$.fragment),vs=n(),c(X.$$.fragment),Ws=n(),Ne=o("p"),Ne.innerHTML=Na,Gs=n(),c(ze.$$.fragment),Xs=n(),Fe=o("p"),Fe.innerHTML=za,Bs=n(),c(Qe.$$.fragment),Cs=n(),Ye=o("p"),Ye.innerHTML=Fa,Vs=n(),c(Ee.$$.fragment),Rs=n(),c(Se.$$.fragment),_s=n(),Le=o("p"),Le.innerHTML=Qa,Is=n(),c(qe.$$.fragment),$s=n(),Ae=o("p"),Ae.innerHTML=Ya,Hs=n(),c(De.$$.fragment),xs=n(),c(Ke.$$.fragment),Ns=n(),Pe=o("p"),Pe.innerHTML=Ea,zs=n(),Oe=o("p"),Oe.textContent=Sa,Fs=n(),et=o("p"),et.innerHTML=La,Qs=n(),tt=o("ol"),tt.innerHTML=qa,Ys=n(),st=o("p"),st.textContent=Aa,Es=n(),c(at.$$.fragment),Ss=n(),c(nt.$$.fragment),Ls=n(),lt=o("p"),lt.innerHTML=Da,qs=n(),ot=o("p"),ot.innerHTML=Ka,As=n(),it=o("ul"),it.innerHTML=Pa,Ds=n(),rt=o("p"),rt.innerHTML=Oa,Ks=n(),c(pt.$$.fragment),Ps=n(),ct=o("p"),this.h()},l(e){const t=dn("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(s),b=l(e),y=i(e,"P",{}),ln(y).forEach(s),M=l(e),d(J.$$.fragment,e),f=l(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1pq6r4w"&&(U.textContent=ta),ht=l(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-4vex4m"&&(B.innerHTML=sa),gt=l(e),C=i(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-18jzu0"&&(C.innerHTML=aa),ut=l(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-5iqkcx"&&(V.textContent=na),yt=l(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-agd87v"&&(R.innerHTML=la),Mt=l(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1gun7m8"&&(_.textContent=oa),bt=l(e),I=i(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-l1azua"&&(I.innerHTML=ia),ft=l(e),d(Z.$$.fragment,e),wt=l(e),d($.$$.fragment,e),Tt=l(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1pysfh4"&&(H.innerHTML=ra),jt=l(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-2o7gdz"&&(x.innerHTML=pa),Jt=l(e),d(N.$$.fragment,e),Ut=l(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-18srzjs"&&(z.innerHTML=ca),kt=l(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-32rftl"&&(F.textContent=da),Zt=l(e),d(Q.$$.fragment,e),vt=l(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-qprijs"&&(Y.innerHTML=ma),Wt=l(e),d(E.$$.fragment,e),Gt=l(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-t9z639"&&(S.textContent=ha),Xt=l(e),L=i(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-7xime6"&&(L.innerHTML=ga),Bt=l(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-ua8dvd"&&(q.innerHTML=ua),Ct=l(e),d(A.$$.fragment,e),Vt=l(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1l1ri2h"&&(D.textContent=ya),Rt=l(e),K=i(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-nmlfgm"&&(K.innerHTML=Ma),_t=l(e),d(P.$$.fragment,e),It=l(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1xdh3pt"&&(O.innerHTML=ba),$t=l(e),d(ee.$$.fragment,e),Ht=l(e),d(te.$$.fragment,e),xt=l(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-12rh7l9"&&(se.innerHTML=fa),Nt=l(e),d(v.$$.fragment,e),zt=l(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-9nc7v7"&&(ae.innerHTML=wa),Ft=l(e),d(ne.$$.fragment,e),Qt=l(e),d(le.$$.fragment,e),Yt=l(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-10ws557"&&(oe.innerHTML=Ta),Et=l(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-184ni1c"&&(ie.innerHTML=ja),St=l(e),d(W.$$.fragment,e),Lt=l(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-ba6d9u"&&(re.innerHTML=Ja),qt=l(e),d(pe.$$.fragment,e),At=l(e),d(ce.$$.fragment,e),Dt=l(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-dhwbam"&&(de.innerHTML=Ua),Kt=l(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-nugt5b"&&(me.textContent=ka),Pt=l(e),d(G.$$.fragment,e),Ot=l(e),d(he.$$.fragment,e),es=l(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1m7rj88"&&(ge.innerHTML=Za),ts=l(e),d(ue.$$.fragment,e),ss=l(e),d(ye.$$.fragment,e),as=l(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-m0y9j6"&&(Me.innerHTML=va),ns=l(e),d(be.$$.fragment,e),ls=l(e),d(fe.$$.fragment,e),os=l(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-vsvvis"&&(we.textContent=Wa),is=l(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-ldtxsn"&&(Te.innerHTML=Ga),rs=l(e),d(je.$$.fragment,e),ps=l(e),d(Je.$$.fragment,e),cs=l(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-149ek3p"&&(Ue.textContent=Xa),ds=l(e),k=i(e,"A",{href:!0,class:!0,"data-svelte-h":!0}),r(k)!=="svelte-1ck2qcm"&&(k.innerHTML=Ba),ms=l(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1ymxnsd"&&(ke.innerHTML=Ca),hs=l(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-krswod"&&(Ze.innerHTML=Va),gs=l(e),d(ve.$$.fragment,e),us=l(e),d(We.$$.fragment,e),ys=l(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-zgjlvh"&&(Ge.innerHTML=Ra),Ms=l(e),d(Xe.$$.fragment,e),bs=l(e),d(Be.$$.fragment,e),fs=l(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-zdhf65"&&(Ce.innerHTML=_a),ws=l(e),d(Ve.$$.fragment,e),Ts=l(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-pzkqt4"&&(Re.innerHTML=Ia),js=l(e),d(_e.$$.fragment,e),Js=l(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1ddqaeo"&&(Ie.innerHTML=$a),Us=l(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-xy91hv"&&($e.innerHTML=Ha),ks=l(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-ebd3ly"&&(He.innerHTML=xa),Zs=l(e),d(xe.$$.fragment,e),vs=l(e),d(X.$$.fragment,e),Ws=l(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-nm0fxt"&&(Ne.innerHTML=Na),Gs=l(e),d(ze.$$.fragment,e),Xs=l(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-rg374v"&&(Fe.innerHTML=za),Bs=l(e),d(Qe.$$.fragment,e),Cs=l(e),Ye=i(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-zp0z7a"&&(Ye.innerHTML=Fa),Vs=l(e),d(Ee.$$.fragment,e),Rs=l(e),d(Se.$$.fragment,e),_s=l(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-n7i3t9"&&(Le.innerHTML=Qa),Is=l(e),d(qe.$$.fragment,e),$s=l(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1cb4g6u"&&(Ae.innerHTML=Ya),Hs=l(e),d(De.$$.fragment,e),xs=l(e),d(Ke.$$.fragment,e),Ns=l(e),Pe=i(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-c1qhny"&&(Pe.innerHTML=Ea),zs=l(e),Oe=i(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1fok5rt"&&(Oe.textContent=Sa),Fs=l(e),et=i(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1xb5ka9"&&(et.innerHTML=La),Qs=l(e),tt=i(e,"OL",{"data-svelte-h":!0}),r(tt)!=="svelte-1rdm431"&&(tt.innerHTML=qa),Ys=l(e),st=i(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-17tp6io"&&(st.textContent=Aa),Es=l(e),d(at.$$.fragment,e),Ss=l(e),d(nt.$$.fragment,e),Ls=l(e),lt=i(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-qgkuwa"&&(lt.innerHTML=Da),qs=l(e),ot=i(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-13a3h6h"&&(ot.innerHTML=Ka),As=l(e),it=i(e,"UL",{"data-svelte-h":!0}),r(it)!=="svelte-bhw0w6"&&(it.innerHTML=Pa),Ds=l(e),rt=i(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1v5aa4g"&&(rt.innerHTML=Oa),Ks=l(e),d(pt.$$.fragment,e),Ps=l(e),ct=i(e,"P",{}),ln(ct).forEach(s),this.h()},h(){ea(p,"name","hf:doc:metadata"),ea(p,"content",wn),ea(k,"href","https://huggingface.co/spaces/m-ric/beam_search_visualizer"),ea(k,"class","flex flex-col justify-center")},m(e,t){mn(document.head,p),a(e,b,t),a(e,y,t),a(e,M,t),m(J,e,t),a(e,f,t),a(e,U,t),a(e,ht,t),a(e,B,t),a(e,gt,t),a(e,C,t),a(e,ut,t),a(e,V,t),a(e,yt,t),a(e,R,t),a(e,Mt,t),a(e,_,t),a(e,bt,t),a(e,I,t),a(e,ft,t),m(Z,e,t),a(e,wt,t),m($,e,t),a(e,Tt,t),a(e,H,t),a(e,jt,t),a(e,x,t),a(e,Jt,t),m(N,e,t),a(e,Ut,t),a(e,z,t),a(e,kt,t),a(e,F,t),a(e,Zt,t),m(Q,e,t),a(e,vt,t),a(e,Y,t),a(e,Wt,t),m(E,e,t),a(e,Gt,t),a(e,S,t),a(e,Xt,t),a(e,L,t),a(e,Bt,t),a(e,q,t),a(e,Ct,t),m(A,e,t),a(e,Vt,t),a(e,D,t),a(e,Rt,t),a(e,K,t),a(e,_t,t),m(P,e,t),a(e,It,t),a(e,O,t),a(e,$t,t),m(ee,e,t),a(e,Ht,t),m(te,e,t),a(e,xt,t),a(e,se,t),a(e,Nt,t),m(v,e,t),a(e,zt,t),a(e,ae,t),a(e,Ft,t),m(ne,e,t),a(e,Qt,t),m(le,e,t),a(e,Yt,t),a(e,oe,t),a(e,Et,t),a(e,ie,t),a(e,St,t),m(W,e,t),a(e,Lt,t),a(e,re,t),a(e,qt,t),m(pe,e,t),a(e,At,t),m(ce,e,t),a(e,Dt,t),a(e,de,t),a(e,Kt,t),a(e,me,t),a(e,Pt,t),m(G,e,t),a(e,Ot,t),m(he,e,t),a(e,es,t),a(e,ge,t),a(e,ts,t),m(ue,e,t),a(e,ss,t),m(ye,e,t),a(e,as,t),a(e,Me,t),a(e,ns,t),m(be,e,t),a(e,ls,t),m(fe,e,t),a(e,os,t),a(e,we,t),a(e,is,t),a(e,Te,t),a(e,rs,t),m(je,e,t),a(e,ps,t),m(Je,e,t),a(e,cs,t),a(e,Ue,t),a(e,ds,t),a(e,k,t),a(e,ms,t),a(e,ke,t),a(e,hs,t),a(e,Ze,t),a(e,gs,t),m(ve,e,t),a(e,us,t),m(We,e,t),a(e,ys,t),a(e,Ge,t),a(e,Ms,t),m(Xe,e,t),a(e,bs,t),m(Be,e,t),a(e,fs,t),a(e,Ce,t),a(e,ws,t),m(Ve,e,t),a(e,Ts,t),a(e,Re,t),a(e,js,t),m(_e,e,t),a(e,Js,t),a(e,Ie,t),a(e,Us,t),a(e,$e,t),a(e,ks,t),a(e,He,t),a(e,Zs,t),m(xe,e,t),a(e,vs,t),m(X,e,t),a(e,Ws,t),a(e,Ne,t),a(e,Gs,t),m(ze,e,t),a(e,Xs,t),a(e,Fe,t),a(e,Bs,t),m(Qe,e,t),a(e,Cs,t),a(e,Ye,t),a(e,Vs,t),m(Ee,e,t),a(e,Rs,t),m(Se,e,t),a(e,_s,t),a(e,Le,t),a(e,Is,t),m(qe,e,t),a(e,$s,t),a(e,Ae,t),a(e,Hs,t),m(De,e,t),a(e,xs,t),m(Ke,e,t),a(e,Ns,t),a(e,Pe,t),a(e,zs,t),a(e,Oe,t),a(e,Fs,t),a(e,et,t),a(e,Qs,t),a(e,tt,t),a(e,Ys,t),a(e,st,t),a(e,Es,t),m(at,e,t),a(e,Ss,t),m(nt,e,t),a(e,Ls,t),a(e,lt,t),a(e,qs,t),a(e,ot,t),a(e,As,t),a(e,it,t),a(e,Ds,t),a(e,rt,t),a(e,Ks,t),m(pt,e,t),a(e,Ps,t),a(e,ct,t),Os=!0},p(e,[t]){const en={};t&2&&(en.$$scope={dirty:t,ctx:e}),Z.$set(en);const tn={};t&2&&(tn.$$scope={dirty:t,ctx:e}),v.$set(tn);const sn={};t&2&&(sn.$$scope={dirty:t,ctx:e}),W.$set(sn);const an={};t&2&&(an.$$scope={dirty:t,ctx:e}),G.$set(an);const nn={};t&2&&(nn.$$scope={dirty:t,ctx:e}),X.$set(nn)},i(e){Os||(h(J.$$.fragment,e),h(Z.$$.fragment,e),h($.$$.fragment,e),h(N.$$.fragment,e),h(Q.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(P.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(v.$$.fragment,e),h(ne.$$.fragment,e),h(le.$$.fragment,e),h(W.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(G.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(ye.$$.fragment,e),h(be.$$.fragment,e),h(fe.$$.fragment,e),h(je.$$.fragment,e),h(Je.$$.fragment,e),h(ve.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(Be.$$.fragment,e),h(Ve.$$.fragment,e),h(_e.$$.fragment,e),h(xe.$$.fragment,e),h(X.$$.fragment,e),h(ze.$$.fragment,e),h(Qe.$$.fragment,e),h(Ee.$$.fragment,e),h(Se.$$.fragment,e),h(qe.$$.fragment,e),h(De.$$.fragment,e),h(Ke.$$.fragment,e),h(at.$$.fragment,e),h(nt.$$.fragment,e),h(pt.$$.fragment,e),Os=!0)},o(e){g(J.$$.fragment,e),g(Z.$$.fragment,e),g($.$$.fragment,e),g(N.$$.fragment,e),g(Q.$$.fragment,e),g(E.$$.fragment,e),g(A.$$.fragment,e),g(P.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(v.$$.fragment,e),g(ne.$$.fragment,e),g(le.$$.fragment,e),g(W.$$.fragment,e),g(pe.$$.fragment,e),g(ce.$$.fragment,e),g(G.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(fe.$$.fragment,e),g(je.$$.fragment,e),g(Je.$$.fragment,e),g(ve.$$.fragment,e),g(We.$$.fragment,e),g(Xe.$$.fragment,e),g(Be.$$.fragment,e),g(Ve.$$.fragment,e),g(_e.$$.fragment,e),g(xe.$$.fragment,e),g(X.$$.fragment,e),g(ze.$$.fragment,e),g(Qe.$$.fragment,e),g(Ee.$$.fragment,e),g(Se.$$.fragment,e),g(qe.$$.fragment,e),g(De.$$.fragment,e),g(Ke.$$.fragment,e),g(at.$$.fragment,e),g(nt.$$.fragment,e),g(pt.$$.fragment,e),Os=!1},d(e){e&&(s(b),s(y),s(M),s(f),s(U),s(ht),s(B),s(gt),s(C),s(ut),s(V),s(yt),s(R),s(Mt),s(_),s(bt),s(I),s(ft),s(wt),s(Tt),s(H),s(jt),s(x),s(Jt),s(Ut),s(z),s(kt),s(F),s(Zt),s(vt),s(Y),s(Wt),s(Gt),s(S),s(Xt),s(L),s(Bt),s(q),s(Ct),s(Vt),s(D),s(Rt),s(K),s(_t),s(It),s(O),s($t),s(Ht),s(xt),s(se),s(Nt),s(zt),s(ae),s(Ft),s(Qt),s(Yt),s(oe),s(Et),s(ie),s(St),s(Lt),s(re),s(qt),s(At),s(Dt),s(de),s(Kt),s(me),s(Pt),s(Ot),s(es),s(ge),s(ts),s(ss),s(as),s(Me),s(ns),s(ls),s(os),s(we),s(is),s(Te),s(rs),s(ps),s(cs),s(Ue),s(ds),s(k),s(ms),s(ke),s(hs),s(Ze),s(gs),s(us),s(ys),s(Ge),s(Ms),s(bs),s(fs),s(Ce),s(ws),s(Ts),s(Re),s(js),s(Js),s(Ie),s(Us),s($e),s(ks),s(He),s(Zs),s(vs),s(Ws),s(Ne),s(Gs),s(Xs),s(Fe),s(Bs),s(Cs),s(Ye),s(Vs),s(Rs),s(_s),s(Le),s(Is),s($s),s(Ae),s(Hs),s(xs),s(Ns),s(Pe),s(zs),s(Oe),s(Fs),s(et),s(Qs),s(tt),s(Ys),s(st),s(Es),s(Ss),s(Ls),s(lt),s(qs),s(ot),s(As),s(it),s(Ds),s(rt),s(Ks),s(Ps),s(ct)),s(p),u(J,e),u(Z,e),u($,e),u(N,e),u(Q,e),u(E,e),u(A,e),u(P,e),u(ee,e),u(te,e),u(v,e),u(ne,e),u(le,e),u(W,e),u(pe,e),u(ce,e),u(G,e),u(he,e),u(ue,e),u(ye,e),u(be,e),u(fe,e),u(je,e),u(Je,e),u(ve,e),u(We,e),u(Xe,e),u(Be,e),u(Ve,e),u(_e,e),u(xe,e),u(X,e),u(ze,e),u(Qe,e),u(Ee,e),u(Se,e),u(qe,e),u(De,e),u(Ke,e),u(at,e),u(nt,e),u(pt,e)}}}const wn='{"title":"Text generation strategies","local":"text-generation-strategies","sections":[{"title":"Default text generation configuration","local":"default-text-generation-configuration","sections":[],"depth":2},{"title":"Customize text generation","local":"customize-text-generation","sections":[],"depth":2},{"title":"Save a custom decoding strategy with your model","local":"save-a-custom-decoding-strategy-with-your-model","sections":[],"depth":2},{"title":"Streaming","local":"streaming","sections":[],"depth":2},{"title":"Watermarking","local":"watermarking","sections":[],"depth":2},{"title":"Decoding strategies","local":"decoding-strategies","sections":[{"title":"Greedy Search","local":"greedy-search","sections":[],"depth":3},{"title":"Contrastive search","local":"contrastive-search","sections":[],"depth":3},{"title":"Multinomial sampling","local":"multinomial-sampling","sections":[],"depth":3},{"title":"Beam-search decoding","local":"beam-search-decoding","sections":[],"depth":3},{"title":"Beam-search multinomial sampling","local":"beam-search-multinomial-sampling","sections":[],"depth":3},{"title":"Diverse beam search decoding","local":"diverse-beam-search-decoding","sections":[],"depth":3},{"title":"Speculative Decoding","local":"speculative-decoding","sections":[{"title":"Universal Assisted Decoding","local":"universal-assisted-decoding","sections":[],"depth":4},{"title":"Prompt Lookup","local":"prompt-lookup","sections":[],"depth":4},{"title":"Self-Speculative Decoding","local":"self-speculative-decoding","sections":[],"depth":4}],"depth":3},{"title":"DoLa Decoding","local":"dola-decoding","sections":[{"title":"Understanding the dola_layers argument","local":"understanding-the-dolalayers-argument","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function Tn(j){return rn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vn extends pn{constructor(p){super(),cn(this,p,Tn,fn,on,{})}}export{vn as component};
