import{s as fa,n as Ia,o as Aa}from"../chunks/scheduler.25b97de1.js";import{S as ba,i as _a,g as n,s as M,r as y,m as Za,A as Ga,h as i,f as s,c as a,j as eM,u as p,x as o,n as ga,k as sM,y as Ba,a as t,v as U,d,t as w,w as c}from"../chunks/index.d9030fc9.js";import{C as r}from"../chunks/CodeBlock.e6cd0d95.js";import{H as j,E as va}from"../chunks/EditOnGithub.91d95064.js";function ka(tM){let T,Ne,Re,Ee,m,Xe,J,MM='<code>transformers</code> is an opinionated framework; our philosophy is defined in the following <a href="./philosophy">conceptual guide</a>.',Ve,C,aM=`The core of that philosophy is exemplified by the <a href="https://huggingface.co/blog/transformers-design-philosophy" rel="nofollow">single model, single file</a>
aspect of the library. This component’s downside is that it limits the inheritance and importability of components from
files to others in the toolkit.`,$e,h,nM=`As a result, model components tend to be repeated across many files. There are as many attention layers defined
in <code>transformers</code> as there are models, and a significant number of those are identical to each other.
The unfortunate consequence is that independent implementations tend to diverge as fixes and changes get applied
to specific parts of the code.`,xe,u,iM=`In order to balance this issue, we introduced the concept of “copies” across the library. By adding a comment indicating
that code is a copy of another, we can enforce through CI and local commands that copies do not diverge. However,
while the complexity is low, this is often quite tedious to do.`,Qe,f,oM=`And, finally, this contributes to adding a significant overhead to contributing models which we would like to remove.
This approach often requires model contributions to add modeling code (~1k lines), processor (~500 lines), tests, docs,
etc. Model contribution PRs rarely add less than 3-5k lines of code, with much of this code being boilerplate.`,Ye,I,yM=`This raises the bar for contributions, and with Modular Transformers, we’re aiming to lower the bar to a much more
acceptable point.`,ze,A,pM=`If you plan to add a model to <code>transformers</code> make sure you read <a href="https://huggingface.co/docs/transformers/add_new_model" rel="nofollow">How to add a model to 🤗 Transformers?</a>.
For any kind of contributions, see <a href="https://github.com/huggingface/transformers/blob/main/CONTRIBUTING.md" rel="nofollow">CONTRIBUTING.md</a>.`,Se,b,He,_,UM=`Modular Transformers introduces the concept of a “modular” file to a model folder. This modular file accepts code
that isn’t typically accepted in modeling/processing files, as it allows importing from neighbouring models as well
as inheritance from classes to others.`,Fe,Z,dM=`This modular file defines models, processors, and the configuration class that would otherwise be defined in their
respective modules.`,Le,G,wM=`Finally, this feature introduces a new <code>linter</code> which will “unravel” the modular file into the “single model, single
file” directory structure. These files will get auto-generated every time the script is run; reducing the required
contributions to the modular file, and therefore only to the changes between the contributed model and others.`,Oe,g,cM=`Model users will end up importing and using the single-file interface, so no change is expected here. Doing this, we
hope to combine the best of both worlds: enabling simple contributions while sticking to our philosophy.`,De,B,rM=`This is therefore a replacement for the <code># Copied from</code> markers, and previously contributed models can be expected to
be moved to the new Modular Transformers format in the coming months.`,Pe,v,Ke,k,jM="To generate a single file from the modular file, run the following command.",qe,R,ls,W,TM=`The “linter”, which unravels the inheritance and creates all single-files from the modular file, will flatten the
inheritance while trying to be invisible to Python users. At this time, the linter flattens a <strong>single</strong> level of
inheritance.`,es,N,mM="For example:",ss,E,JM=`<li>If a configuration class inherits from another and adds/deletes an argument, the generated file will either directly
reference it (in case of addition) or completely remove it (in case of deletion).</li> <li>If a class inherits from another, for example: <code>class GemmaModel(LlamaModel):</code>, dependencies are automatically
inferred. All submodules will be automatically added from the superclass.</li> <li>If you define new functions in the <code>modular</code> and use them inside classes, the linter will automatically infer the</li>`,ts,X,CM=`You should be able to write everything (the tokenizer, the image processor, the model, the config) in this <code>modular</code>
file, and the corresponding files will be created for you.`,Ms,V,as,$,hM="Run the command below to ensure the generated content matches <code>modular_&lt;your_model&gt;.py</code>",ns,x,is,Q,os,Y,uM=`Here is a quick example with BERT and RoBERTa. The two models are intimately related: their modeling implementation
differs solely by a change in the embedding layer.`,ys,z,fM=`Instead of redefining the model entirely, here is what the <code>modular_roberta.py</code> file looks like for the modeling &amp;
configuration classes (for the sake of the example, the tokenizer is ignored at this time as very different).`,ps,S,Us,H,ds,F,IM="It is not a replacement for the modeling code (yet?), and if your model is not based on anything else that ever existed, then you can add a <code>modeling</code> file as usual. Similarly, if you cannot easily inherit your <code>configuration</code> (or <code>tokenization</code> or <code>processing</code>) file from another model’s similar file, you can add that filetype directly (even though defining it in the modular file would work, it would clutter it).",ws,L,cs,O,AM="As explained, modular allows you to use regular Python inheritance from any other model’s code in the library, in order to define your own. For this reason, it will work better/be easier if you first browse the library a bit to find models close to yours, in order to inherit from them. For example, are you using a sliding window in the <code>Attention</code> class? Then start by checking models that are well known to use it, e.g. <code>Mistral</code>, or <code>Qwen2</code>! Are you using interleaved <code>RotaryEmbedding</code> modules? Check out <code>Cohere</code>, <code>Cohere2</code> and <code>Glm</code> models! Otherwise a very strong starting point is to check out <code>Llama</code>. And if you are doing a bit of all of that at once, then you can mix and match!",rs,D,bM="Here are some common properties that your model might be using, and corresponding modeling files to check as an example:",js,P,_M="<li>Mixture of expert: <code>SwitchTransformers</code> or <code>Mixtral</code></li> <li>Interleaved (and/or partial) rotary embedding: <code>Glm</code>, <code>Phi</code></li> <li>State space models: <ul><li>Hybrid with attention: <code>Jamba</code> , <code>Bamba</code>, <code>Zamba</code></li> <li>Mamba2: <code>Mamba2</code></li></ul></li> <li>Recurrent hidden states: <code>Gemma2</code></li> <li>Different sliding window attention/full attention patterns per layer: <code>Gemma2</code>, <code>Cohere2</code></li> <li>Clipping of QKV: <code>Olmo</code></li> <li>Normalization of QK: <code>Olmo2</code>, <code>Cohere</code></li> <li>Fused QKV (not recommended): <code>Phi3</code></li>",Ts,K,ZM='At Hugging Face, we feel that learning by example is usually (one of) the best way, so we will now go over a typical modular file, and the different features our linter provides (and its limitations)! 🤗 Let’s use a real world example with Olmo2 model, which I feel provides a very good illustration of the modular mechanisms. The original file can be found <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/olmo2/modular_olmo2.py" rel="nofollow">here</a>. For simplicity, we will go over it class by class, and repeat the modular’s definition of ech class. For reference, the modeling and configuration of Olmo (v1) on which we will inherit a lot can be found <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/olmo/modeling_olmo.py" rel="nofollow">here</a> and <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/olmo/configuration_olmo.py" rel="nofollow">here</a> respectively. The final modeling of Olmo2 (generated by running our linter on the modular we will describe below) can be found <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/olmo2/modeling_olmo2.py" rel="nofollow">here</a>',ms,q,GM="Let’s break it down!",Js,ll,Cs,el,gM="Here is the <code>Config</code> definition in modular:",hs,sl,us,tl,BM="Here, we correctly identified that the <code>Config</code> in Olmo2 is similar to Olmo’s, up to a few details:",fs,Ml,vM="<li>The default value of most arguments has changed</li> <li>we have a new argument, <code>rms_norm_eps</code></li> <li>the argument <code>clip_qkv</code> is not used anymore</li>",Is,al,kM=`To solve points 1. and 2., simply overwriting the <code>__init__</code> function with the new default arguments and adding the new one is enough, as you would expect when you want to overwrite a method in Python! Of course you also need to assign the new attribute <code>rms_norm_eps</code> to <code>self</code> in the <code>__init__</code>’s body.<br/>
For point 3., we use the special syntax <code>del self.clip_qkv</code>, which, has you can expect, removed the assignment of this attribute in the unravelled code (after the conversion with the linter).`,As,nl,RM="Now, there is a subtility here: as you can see, we used <code>super().__init__(...)</code>. Usually, in Python, it is simply used to call the parent’s <code>__init__</code>. In modular terms, however, it has a <em>slightly</em> different meaning. When we find a call such as <code>super().my_function(...)</code> in the modular file, the linter will take the body of the <code>my_function</code> function in the parent, and unravel it where the call to <code>super().my_function(...)</code> occured. Then, the <code>del self.clip_qkv</code> statement will remove the reference to <code>self.clip_qkv</code> from the unravelled body. Thus <code>del self.xxx</code> can only work in pair with <code>super().my_function(...)</code>, and should always be placed after it (but you can add whatever you want <em>before</em> calling <code>super()</code>, and it will be placed, as you can expect, before the parent’s body).",bs,il,_s,ol,WM="Here is the <code>Norm</code> class:",Zs,yl,Gs,pl,NM="What to say here, it is pretty explicit isn’t it? We do not modify anything from the <code>LlamaRMSNorm</code> definition. Thus the linter will unravel exactly the content of the parent (<code>LlamaRMSNorm</code>). Only change will be that every reference to “llama” on the docstrings, type hints, and comments (basically everywhere) will be changed to references to “olmo2” for consistency!",gs,Ul,Bs,dl,EM="Here is the <code>Attention</code> class:",vs,wl,ks,cl,XM=`Now, what’s happening here? In the <code>__init__</code>, we call <code>super().__init__(...)</code>, thus copying the parent’s definition, then add 2 new layers of the <code>Olmo2RMSNorm</code> we just added previously. Indeed, those were not present in the original <code>Olmo</code> (v1) model. So, now, we also have to overwrite the <code>forward</code> method to use these 2 new layers right? Indeed, if you check carefully, the definition of <code>forward</code> is identical to <code>Olmo</code>’s, but we added a pass with the norm layers just before projecting with <code>q_proj</code> and <code>k_proj</code>. However, to help us, we directly imported the functions <code>eager_attention_forward</code> from llama, and <code>apply_rotary_pos_emb</code> from olmo. The linter will then automatically add these imported functions in the final <code>modeling_olmo2.py</code> file, by copying their definitions from the source (imported) files. And it will even add the <code>rotate_half</code> and <code>repeat_kv</code> functions (which are used inside <code>apply_rotary_pos_embed</code> and <code>eager_attention_forward</code> respectively) by figuring out the dependency automatically. Neat, right?<br/>
Note that we had to redefine this class, because we did not find any model defining the <code>Attention</code> layer with the added <code>RMSNorm</code> layer anywhere else in the library! Otherwise, we would have simply inherited from this model instead as we did for the <code>RMSNorm</code>!`,Rs,rl,Ws,jl,VM="Here is the <code>DecoderLayer</code> class:",Ns,Tl,Es,ml,$M="At this point, you should start to pick up what is happening for this class. We switched the type of norm in the <code>__init__</code> by overwriting <code>self.post_attention_layernorm</code> after the call to <code>super().__init__(...)</code>, thus going from a <code>LayerNorm</code> in the parent class, to our <code>RMSNorm</code> in this class. Then we simply deleted the <code>self.input_layernorm</code> attribute, and replaced it by <code>self.post_feedforward_layernorm</code>, because the name was not making sense anymore as we apply it after in <code>Olmo2</code> instead of before in <code>Olmo</code>. For this reason, we also need to overwrite the <code>forward</code> method, to reflect the logic change.",Xs,Jl,xM="Note however that if we had only switched <code>self.post_attention_layernorm</code> and <code>self.input_layernorm</code> from <code>LayerNorm</code>s to <code>RMSNorm</code>s (without the name and logic change of <code>elf.input_layernorm</code>), we would not have had to redefine the <code>forward</code> method!",Vs,Cl,$s,hl,xs,ul,QM="Here, this is exactly what I was pointing out before: we simply change the <em>type</em> of the <code>self.norm</code> attribute (going from <code>LayerNorn</code> in <code>Olmo</code> to <code>RMSNorm</code> in <code>Olmo2</code>). Since this change does not reflect the logic of the <code>forward</code> method (the name of the layer and where it is used is identical to the parent’s), then we do not even need to overwrite it! It will be unravelled automatically! Note that we redefined <code>self.layers</code> for the sake of being explicit, but this is not even strictly required here as the definition is similar to what is found in <code>Olmo</code> (v1).",Qs,fl,Ys,Il,YM="Finally, here is the definition of the <code>ForCausalLM</code>:",zs,Al,Ss,bl,zM="As for the <code>RMSNorm</code>, it is exactly similar to the parent’s in logic, so we do not have anything to do, the linter will all figure it out by itself. Almost disappointing, no?",Hs,ke,Fs,_l,SM='Indeed, if you inspect the file <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/olmo2/modeling_olmo2.py" rel="nofollow">modeling_olmo2.py</a> which is created by running the linter on <code>modular_olmo2.py</code>, you will notice that it also creates <code>Olmo2MLP</code>, <code>Olmo2RotaryEmbedding</code>, and <code>Olmo2PreTrainedModel</code> classes, that we did not define explicitly in <code>modular_olmo2.py</code>.',Ls,Zl,HM="Well, it is one of the main feature of our modular linter. Similarly to how some functions were added automatically with the <code>Attention</code> class (without directly importing them), classes that are a dependency of one of the class inherited class and which are not explicitly defined in the modular file, will be added automatically as part of the dependeny tracing. For example, in <code>OlmoDecoderLayer</code>, there is an attribute defined as <code>self.mlp = OlmoMLP(config)</code>. Because we never explicitly redefined a class named <code>Olmo2MLP</code> in <code>modular_olmo2.py</code>, the linter automatically created a class <code>Olmo2MLP</code>, similar to <code>OlmoMLP</code>. This is exactly the same as if we had done:",Os,Gl,Ds,gl,FM="but we did not even bother, because we <em>know</em> this class is supposed to be exactly similar, and we never needed it anywhere else in the <code>modular_olmo2.py</code> file. In contrast, the class <code>Olmo2RMSNorm</code> was needed to (re)define the norms both in the <code>Attention</code> and <code>DecoderLayer</code> classes. The same logic is true for the <code>Olmo2PreTrainedModel</code> and <code>Olmo2RotaryEmbedding</code> classes.",Ps,Bl,LM="Note however that if not redefined, classes will be copied from the file in which an inherited module uses them first. So if you wanted e.g. <code>Olmo2MLP</code> to inherit from, say, <code>MistralMLP</code> instead of <code>OlmoMLP</code> (here it was <code>OlmoMLP</code> because it was first implicitly used in <code>Olmo2DecoderLayer</code>, which inherited from <code>OlmoDecoderLayer</code>), you would need to be explicit and do:",Ks,vl,qs,kl,lt,Rl,OM="Now that you should have a good grasp of how modular works, let’s see some more advanced use cases and features you can use.",et,Wl,st,Nl,DM="As we have seen before, after using <code>super().__init__()</code>, we can use <code>del self.attribute</code> to remove a specific attribute which was defined in the parent. What if this attribute was used elsewhere though? Meaning it was not just “defined to be stored” as in the config for example. For example, consider the following case:",tt,El,Mt,Xl,PM="Then inheriting from this <code>DummyModel</code> and doing",at,Vl,nt,$l,KM="is not supported, because it will only suppress the assignment, i.e. the line <code>self.attribute = config.attribute</code> will disappear, but the <code>if</code> statement will stay and reference the attribute. We tried to make it work by suppressing every mentions of the attribute, however it it not a sound solution in the general case (it can lead to very surprising effects and remove other important parts) and is therefore not possible.",it,xl,qM="But what if I still want to inherit from <code>DummyModel</code>? How to properly do it? How to use <code>super().__init__()</code> without copy/pasting the parent then? This brings us to the next point:",ot,Ql,yt,Yl,la="Say you still want to inherit from <code>DummyModel</code> (because it is convenient for some other methods) but you do want to remove the <code>self.attribute</code>. How to properly override the <code>__init__</code> method, while calling <code>super()</code> but without unravelling the parent’s code? Well, then be explicit about which class <code>super()</code>’s you are calling! If we want to call the <code>nn.Module</code>’s <code>super()</code> for example, we can do the following (unravelled code on the right):",pt,zl,Ut,Sl,dt,Hl,ea="Removing a class method is pretty similar to remove an attribute, you just need to overwrite it with a <code>raise AttributeError(&quot;&quot;)</code> to mimick the behaviour you actually want when you remove a parent function in python. For example, the following will remove the methods in the unravelled code:",wt,Fl,ct,Ll,rt,Ol,sa="Of course, if you define a new function in the <code>modular</code> file, and use it inside an inherited class, say",jt,Dl,Tt,Pl,ta="the <code>my_new_function</code> function (and, recursively, any other functions called in its body) will be automatically added to the unravelled code even if it is not present in the parent’s file (here Llama).",mt,Kl,Jt,ql,Ma="By default, if you inherit from a class and override a method which has 1 (or more) decorators in the parent’s method, the decorators will be added as well in the unravelled code, <em>but only if you do not add any yourself</em>. Otherwise, it will of course use whatever decorator your redefined.",Ct,le,aa="That, is, imagine the following parent class",ht,ee,ut,se,na="Then, if you simply override the method it will produce (modular on the left, unravelled code on the right):",ft,te,It,Me,ia="That is, it keeps the parent’s decorators by default. However, if you do:",At,ae,bt,ne,oa="Then it keeps you own new decorator.",_t,ie,Zt,oe,ya="In the above case about decorators, what if the <code>forward</code> method is really long, and I just want to switch the decorators? Do I really have to redefine it all and copy/paste the body just for the decorator? Fortunately, no. If you followed until this point, you now that you can use <code>super().forward(...)</code>, and it will unravel the parent’s body automatically. But what if there are plenty of arguments in the function’s signature, and we are very lazy? For that use-case, we introduced the special syntax <code>**super_kwargs</code> in the overriden method signature. It basically mean: “unravel all the parent’s signature arguments here”. For example, a common signature in the <code>ForCausalLM</code> model is the following (copied from llama’s modeling):",Gt,ye,gt,pe,pa="As you can see, this is a rather long and complicated signature. But if you do the following (as usual, modular on the left, unravelled code by the linter on the right):",Bt,Ue,vt,de,Ua="and the <code>**super_kwargs</code> syntax unravelled all the arguments, while the <code>super().forward()</code> syntax unravelled the whole body! As you can see, this is  great combo when you just want to switch the decorators, as it is very easy to use, and make it explicit that the only change you want to apply is the decorator.",kt,we,da="However, we want to make it clear that the <code>**super_kwargs</code> syntax is not a replacement to being explicit when you redefine your methods: if you actually overwrite the method (i.e. you do not call <code>super().method()</code>), then we want you to explicitly write the signature as you would usually. This is only a short-cut when switching decorators, and a few other niche cases.",Rt,ce,Wt,re,wa='Usually, if whatever object is defned both in the modular file and the modeling file from which we inherit, then the definition of the modular takes precedence. However, this is not the case for assignments containing the pattern <code>DOCSTRING</code>. Indeed, we usually have variables defined as <code>MODEL_START_DOCSTRING</code> and <code>MODEL_INPUT_DOCSTRING</code> in the modeling files. These are just very big blocks of, well, docstrings… But they are (almost) always exactly the same up to the model name! And modular automatically rewrite the names everywhere! For this reason, assignments containing the pattern will <em>always</em> use the definition found in the source file instead of the modular file. This is extremely handy if we need the variable reference somewhere (e.g. to redefine a decorator) but we do not want to clutter the modular file with 100 lines of docstrings which are always the same. It allows to do the following (taken from <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/starcoder2/modular_starcoder2.py#L146" rel="nofollow">modular_starcoder2.py</a>)',Nt,je,Et,Te,ca="and here, the linter will correctly take the same definition of the docstring as in <code>Mistral</code>, without having to clutter the modular file!",Xt,me,Vt,Je,ra="Now, let’s go over some of the limitations of modular.",$t,Ce,xt,he,ja="Because our linter automatically renames everything when inheriting from a class (defining <code>class NewModelMLP(LlamaMLP)</code> will rename every mention of <code>Llama</code> to <code>NewModel</code>, and recursively for all dependencies grabbed), it has somewhat strict rules when it comes to naming. For consistency reasons, we require that you always use the same class name prefix when inheriting different classes from the same file. For example, doing:",Qt,ue,Yt,fe,Ta="is not recommended, first because it breaks standards in the library and we do not like it, and second because the linter will not know how to rename potential high-order dependencies (should we use <code>MyModelIncredible</code>, or <code>MyModel</code>?).",zt,Ie,ma='If there are no dependencies to grab implicitly however (see <a href="#dependencies">this section</a> to understand implicit dependencies), local renaming (for a single class) will not be an issue and the linter will not complain. But make sure to explicitly redefine every other mentions of the class with the new name pattern! For example in the example above, all mentions of <code>LlamaMLP</code> in other modules inherited should be explicitly replaced by mentions to <code>MyModelIncredibleMLP</code>, otherwise the linter may add a new and unwanted <code>MyModelMLP</code> class!',St,Ae,Ja="In any way, if there is an ambiguous case detected, the linter will raise a warning such as",Ht,be,Ft,_e,Ca="explaining what is happening, and which prefix is used by default for grabbing dependencies. As explained, if you see automatic dependencies appear with a prefix but you want another one, then explicitly rename these classes locally with a simple <code>pass</code> class, such as",Lt,Ze,Ot,Ge,ha="Such warnings and renaming patterns complications usually only arise when defining multimodel models, when you want to define e.g. the text part of your model from an existing model, but want to add the part <code>Text</code> to the class names to make it clear what they refer to in the multimodal setup.",Dt,ge,Pt,Be,ua="When inheriting a Config class and adding or deleting some attributes, it may be tempting to only redefine the new attributes in the docstring, and hoping that modular will do the rest. And similarly when deleting an argument, do nothing and hope that modular will remove itself from the docstring. However, due to current limitations of our linter, this is not yet supported. Thus, if you are in this case, you need to directly put the whole docstring (as it should appear in the end, with the correct arguments and default values) directly in the modular file under the class definition.",Kt,ve,qt,We,lM;return m=new j({props:{title:"Modular transformers",local:"modular-transformers",headingTag:"h1"}}),b=new j({props:{title:"What is it?",local:"what-is-it",headingTag:"h2"}}),v=new j({props:{title:"Details",local:"details",headingTag:"h3"}}),R=new r({props:{code:"cHl0aG9uJTIwdXRpbHMlMkZtb2R1bGFyX21vZGVsX2NvbnZlcnRlci5weSUyMC0tZmlsZXMtdG8tcGFyc2UlMjBzcmMlMkZ0cmFuc2Zvcm1lcnMlMkZtb2RlbHMlMkYlM0N5b3VyX21vZGVsJTNFJTJGbW9kdWxhcl8lM0N5b3VyX21vZGVsJTNFLnB5",highlighted:"python utils/modular_model_converter.py --files-to-parse src/transformers/models/&lt;your_model&gt;/modular_&lt;your_model&gt;.py",wrap:!1}}),V=new j({props:{title:"Enforcement",local:"enforcement",headingTag:"h3"}}),x=new r({props:{code:"cHl0aG9uJTIwdXRpbHMlMkZjaGVja19tb2R1bGFyX2NvbnZlcnNpb24ucHklMjAtLWZpbGVzJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGJTNDeW91cl9tb2RlbCUzRSUyRm1vZHVsYXJfJTNDeW91cl9tb2RlbCUzRS5weQ==",highlighted:"python utils/check_modular_conversion.py --files src/transformers/models/&lt;your_model&gt;/modular_&lt;your_model&gt;.py",wrap:!1}}),Q=new j({props:{title:"Examples",local:"examples",headingTag:"h3"}}),S=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> ..bert.configuration_bert <span class="hljs-keyword">import</span> BertConfig
<span class="hljs-keyword">from</span> ..bert.modeling_bert <span class="hljs-keyword">import</span> (
    BertModel,
    BertEmbeddings,
    BertForMaskedLM
)

<span class="hljs-comment"># The RoBERTa config is identical to BERT&#x27;s config</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaConfig</span>(<span class="hljs-title class_ inherited__">BertConfig</span>):
  model_type = <span class="hljs-string">&#x27;roberta&#x27;</span>

<span class="hljs-comment"># We redefine the embeddings here to highlight the padding ID difference, and we redefine the position embeddings</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaEmbeddings</span>(<span class="hljs-title class_ inherited__">BertEmbeddings</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config())

        self.padding_idx = config.pad_token_id
        self.position_embeddings = nn.Embedding(
            config.max_position_embeddings, config.hidden_size, padding_idx=self.padding_idx
        )

<span class="hljs-comment"># The RoBERTa model is identical to the BERT model, except for the embedding layer. </span>
<span class="hljs-comment"># We redefine the embeddings above, so here there is no need to do additional work</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaModel</span>(<span class="hljs-title class_ inherited__">BertModel</span>):
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    self.embeddings = RobertaEmbeddings(config)

      
<span class="hljs-comment"># The heads now only need to redefine the model inside to the correct \`RobertaModel\`</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaForMaskedLM</span>(<span class="hljs-title class_ inherited__">BertForMaskedLM</span>):
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    self.model = RobertaModel(config)`,wrap:!1}}),H=new j({props:{title:"What it is not",local:"what-it-is-not",headingTag:"h2"}}),L=new j({props:{title:"Real world example breakdown",local:"real-world-example-breakdown",headingTag:"h2"}}),ll=new j({props:{title:"Config class",local:"config-class",headingTag:"h3"}}),sl=new r({props:{code:"ZnJvbSUyMC4ub2xtby5jb25maWd1cmF0aW9uX29sbW8lMjBpbXBvcnQlMjBPbG1vQ29uZmlnJTBBJTBBY2xhc3MlMjBPbG1vMkNvbmZpZyhPbG1vQ29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMHIlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjB0aGUlMjBjb25maWd1cmF0aW9uJTIwY2xhc3MlMjB0byUyMHN0b3JlJTIwdGhlJTIwY29uZmlndXJhdGlvbiUyMG9mJTIwYSUyMCU1Qk9sbW8yTW9kZWwlNUQoJTJGZG9jcyUyRnRyYW5zZm9ybWVycyUyRm1haW4lMkZlbiUyRm1vZGVsX2RvYyUyRm9sbW8yJTIzdHJhbnNmb3JtZXJzLk9sbW8yTW9kZWwpLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2b2NhYl9zaXplJTNENTAzMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoaWRkZW5fc2l6ZSUzRDQwOTYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnRlcm1lZGlhdGVfc2l6ZSUzRDExMDA4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2hpZGRlbl9sYXllcnMlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9hdHRlbnRpb25faGVhZHMlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9rZXlfdmFsdWVfaGVhZHMlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGlkZGVuX2FjdCUzRCUyMnNpbHUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfcG9zaXRpb25fZW1iZWRkaW5ncyUzRDIwNDglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbml0aWFsaXplcl9yYW5nZSUzRDAuMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2VfY2FjaGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFkX3Rva2VuX2lkJTNEMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJvc190b2tlbl9pZCUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlb3NfdG9rZW5faWQlM0Q1MDI3OSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRpZV93b3JkX2VtYmVkZGluZ3MlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJvcGVfdGhldGElM0QxMDAwMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm9wZV9zY2FsaW5nJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF0dGVudGlvbl9iaWFzJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdHRlbnRpb25fZHJvcG91dCUzRDAuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJtc19ub3JtX2VwcyUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAqKmt3YXJncyUyQyUwQSUyMCUyMCUyMCUyMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZvY2FiX3NpemUlM0R2b2NhYl9zaXplJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGlkZGVuX3NpemUlM0RoaWRkZW5fc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9zaXplJTNEaW50ZXJtZWRpYXRlX3NpemUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1faGlkZGVuX2xheWVycyUzRG51bV9oaWRkZW5fbGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2F0dGVudGlvbl9oZWFkcyUzRG51bV9hdHRlbnRpb25faGVhZHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fa2V5X3ZhbHVlX2hlYWRzJTNEbnVtX2tleV92YWx1ZV9oZWFkcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9hY3QlM0RoaWRkZW5fYWN0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X3Bvc2l0aW9uX2VtYmVkZGluZ3MlM0RtYXhfcG9zaXRpb25fZW1iZWRkaW5ncyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluaXRpYWxpemVyX3JhbmdlJTNEaW5pdGlhbGl6ZXJfcmFuZ2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2VfY2FjaGUlM0R1c2VfY2FjaGUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYWRfdG9rZW5faWQlM0RwYWRfdG9rZW5faWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBib3NfdG9rZW5faWQlM0Rib3NfdG9rZW5faWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlb3NfdG9rZW5faWQlM0Rlb3NfdG9rZW5faWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0aWVfd29yZF9lbWJlZGRpbmdzJTNEdGllX3dvcmRfZW1iZWRkaW5ncyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJvcGVfdGhldGElM0Ryb3BlX3RoZXRhJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm9wZV9zY2FsaW5nJTNEcm9wZV9zY2FsaW5nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXR0ZW50aW9uX2JpYXMlM0RhdHRlbnRpb25fYmlhcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF0dGVudGlvbl9kcm9wb3V0JTNEYXR0ZW50aW9uX2Ryb3BvdXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAqKmt3YXJncyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnJtc19ub3JtX2VwcyUyMCUzRCUyMHJtc19ub3JtX2VwcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlbCUyMHNlbGYuY2xpcF9xa3Y=",highlighted:`<span class="hljs-keyword">from</span> ..olmo.configuration_olmo <span class="hljs-keyword">import</span> OlmoConfig

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2Config</span>(<span class="hljs-title class_ inherited__">OlmoConfig</span>):
    <span class="hljs-string">r&quot;&quot;&quot;
    This is the configuration class to store the configuration of a [Olmo2Model](/docs/transformers/main/en/model_doc/olmo2#transformers.Olmo2Model).
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        vocab_size=<span class="hljs-number">50304</span>,
        hidden_size=<span class="hljs-number">4096</span>,
        intermediate_size=<span class="hljs-number">11008</span>,
        num_hidden_layers=<span class="hljs-number">32</span>,
        num_attention_heads=<span class="hljs-number">32</span>,
        num_key_value_heads=<span class="hljs-literal">None</span>,
        hidden_act=<span class="hljs-string">&quot;silu&quot;</span>,
        max_position_embeddings=<span class="hljs-number">2048</span>,
        initializer_range=<span class="hljs-number">0.02</span>,
        use_cache=<span class="hljs-literal">True</span>,
        pad_token_id=<span class="hljs-number">1</span>,
        bos_token_id=<span class="hljs-literal">None</span>,
        eos_token_id=<span class="hljs-number">50279</span>,
        tie_word_embeddings=<span class="hljs-literal">False</span>,
        rope_theta=<span class="hljs-number">10000.0</span>,
        rope_scaling=<span class="hljs-literal">None</span>,
        attention_bias=<span class="hljs-literal">False</span>,
        attention_dropout=<span class="hljs-number">0.0</span>,
        rms_norm_eps=<span class="hljs-number">1e-5</span>,
        **kwargs,
    </span>):
        <span class="hljs-built_in">super</span>().__init__(
            vocab_size=vocab_size,
            hidden_size=hidden_size,
            intermediate_size=intermediate_size,
            num_hidden_layers=num_hidden_layers,
            num_attention_heads=num_attention_heads,
            num_key_value_heads=num_key_value_heads,
            hidden_act=hidden_act,
            max_position_embeddings=max_position_embeddings,
            initializer_range=initializer_range,
            use_cache=use_cache,
            pad_token_id=pad_token_id,
            bos_token_id=bos_token_id,
            eos_token_id=eos_token_id,
            tie_word_embeddings=tie_word_embeddings,
            rope_theta=rope_theta,
            rope_scaling=rope_scaling,
            attention_bias=attention_bias,
            attention_dropout=attention_dropout,
            **kwargs,
        )

        self.rms_norm_eps = rms_norm_eps
        <span class="hljs-keyword">del</span> self.clip_qkv`,wrap:!1}}),il=new j({props:{title:"Norm class",local:"norm-class",headingTag:"h3"}}),yl=new r({props:{code:"ZnJvbSUyMC4ubGxhbWEubW9kZWxpbmdfbGxhbWElMjBpbXBvcnQlMjBMbGFtYVJNU05vcm0lMEElMEFjbGFzcyUyME9sbW8yUk1TTm9ybShMbGFtYVJNU05vcm0pJTNBJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-keyword">from</span> ..llama.modeling_llama <span class="hljs-keyword">import</span> LlamaRMSNorm

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2RMSNorm</span>(<span class="hljs-title class_ inherited__">LlamaRMSNorm</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),Ul=new j({props:{title:"Attention class",local:"attention-class",headingTag:"h3"}}),wl=new r({props:{code:"ZnJvbSUyMC4ubGxhbWEubW9kZWxpbmdfbGxhbWElMjBpbXBvcnQlMjBlYWdlcl9hdHRlbnRpb25fZm9yd2FyZCUwQWZyb20lMjAuLm9sbW8ubW9kZWxpbmdfb2xtbyUyMGltcG9ydCUyME9sbW9BdHRlbnRpb24lMkMlMjBhcHBseV9yb3RhcnlfcG9zX2VtYiUwQSUwQSUwQSUyMyUyME9sbW8yJTIwYXR0ZW50aW9uJTIwaXMlMjBpZGVudGljYWwlMjB0byUyME9MTW8lMjBhdHRlbnRpb24lMjBleGNlcHQlM0ElMEElMjMlMjAtJTIwTm9ybSUyMGlzJTIwYXBwbGllZCUyMHRvJTIwYXR0ZW50aW9uJTIwcXVlcmllcyUyMGFuZCUyMGtleXMuJTBBJTIzJTIwLSUyME5vJTIwcWt2JTIwY2xpcHBpbmcuJTBBY2xhc3MlMjBPbG1vMkF0dGVudGlvbihPbG1vQXR0ZW50aW9uKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBjb25maWclM0ElMjBPbG1vMkNvbmZpZyUyQyUyMGxheWVyX2lkeCUzQSUyME9wdGlvbmFsJTVCaW50JTVEJTIwJTNEJTIwTm9uZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyUyQyUyMGxheWVyX2lkeCUzRGxheWVyX2lkeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnFfbm9ybSUyMCUzRCUyME9sbW8yUk1TTm9ybShjb25maWcubnVtX2F0dGVudGlvbl9oZWFkcyUyMColMjBzZWxmLmhlYWRfZGltJTJDJTIwY29uZmlnLnJtc19ub3JtX2VwcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmtfbm9ybSUyMCUzRCUyME9sbW8yUk1TTm9ybShjb25maWcubnVtX2tleV92YWx1ZV9oZWFkcyUyMColMjBzZWxmLmhlYWRfZGltJTJDJTIwY29uZmlnLnJtc19ub3JtX2VwcyklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoaWRkZW5fc3RhdGVzJTNBJTIwdG9yY2guVGVuc29yJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zaXRpb25fZW1iZWRkaW5ncyUzQSUyMFR1cGxlJTVCdG9yY2guVGVuc29yJTJDJTIwdG9yY2guVGVuc29yJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0ElMjBPcHRpb25hbCU1QnRvcmNoLlRlbnNvciU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhc3Rfa2V5X3ZhbHVlJTNBJTIwT3B0aW9uYWwlNUJDYWNoZSU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYWNoZV9wb3NpdGlvbiUzQSUyME9wdGlvbmFsJTVCdG9yY2guTG9uZ1RlbnNvciU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAqKmt3YXJncyUyQyUwQSUyMCUyMCUyMCUyMCklMjAtJTNFJTIwVHVwbGUlNUJ0b3JjaC5UZW5zb3IlMkMlMjBPcHRpb25hbCU1QnRvcmNoLlRlbnNvciU1RCUyQyUyME9wdGlvbmFsJTVCVHVwbGUlNUJ0b3JjaC5UZW5zb3IlNUQlNUQlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9zaGFwZSUyMCUzRCUyMGhpZGRlbl9zdGF0ZXMuc2hhcGUlNUIlM0EtMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9zaGFwZSUyMCUzRCUyMCgqaW5wdXRfc2hhcGUlMkMlMjAtMSUyQyUyMHNlbGYuaGVhZF9kaW0pJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcnlfc3RhdGVzJTIwJTNEJTIwc2VsZi5xX25vcm0oc2VsZi5xX3Byb2ooaGlkZGVuX3N0YXRlcykpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa2V5X3N0YXRlcyUyMCUzRCUyMHNlbGYua19ub3JtKHNlbGYua19wcm9qKGhpZGRlbl9zdGF0ZXMpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlX3N0YXRlcyUyMCUzRCUyMHNlbGYudl9wcm9qKGhpZGRlbl9zdGF0ZXMpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcnlfc3RhdGVzJTIwJTNEJTIwcXVlcnlfc3RhdGVzLnZpZXcoaGlkZGVuX3NoYXBlKS50cmFuc3Bvc2UoMSUyQyUyMDIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa2V5X3N0YXRlcyUyMCUzRCUyMGtleV9zdGF0ZXMudmlldyhoaWRkZW5fc2hhcGUpLnRyYW5zcG9zZSgxJTJDJTIwMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2YWx1ZV9zdGF0ZXMlMjAlM0QlMjB2YWx1ZV9zdGF0ZXMudmlldyhoaWRkZW5fc2hhcGUpLnRyYW5zcG9zZSgxJTJDJTIwMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb3MlMkMlMjBzaW4lMjAlM0QlMjBwb3NpdGlvbl9lbWJlZGRpbmdzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcnlfc3RhdGVzJTJDJTIwa2V5X3N0YXRlcyUyMCUzRCUyMGFwcGx5X3JvdGFyeV9wb3NfZW1iKHF1ZXJ5X3N0YXRlcyUyQyUyMGtleV9zdGF0ZXMlMkMlMjBjb3MlMkMlMjBzaW4pJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBwYXN0X2tleV92YWx1ZSUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHNpbiUyMGFuZCUyMGNvcyUyMGFyZSUyMHNwZWNpZmljJTIwdG8lMjBSb1BFJTIwbW9kZWxzJTNCJTIwY2FjaGVfcG9zaXRpb24lMjBuZWVkZWQlMjBmb3IlMjB0aGUlMjBzdGF0aWMlMjBjYWNoZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhY2hlX2t3YXJncyUyMCUzRCUyMCU3QiUyMnNpbiUyMiUzQSUyMHNpbiUyQyUyMCUyMmNvcyUyMiUzQSUyMGNvcyUyQyUyMCUyMmNhY2hlX3Bvc2l0aW9uJTIyJTNBJTIwY2FjaGVfcG9zaXRpb24lN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBrZXlfc3RhdGVzJTJDJTIwdmFsdWVfc3RhdGVzJTIwJTNEJTIwcGFzdF9rZXlfdmFsdWUudXBkYXRlKGtleV9zdGF0ZXMlMkMlMjB2YWx1ZV9zdGF0ZXMlMkMlMjBzZWxmLmxheWVyX2lkeCUyQyUyMGNhY2hlX2t3YXJncyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdHRlbnRpb25faW50ZXJmYWNlJTNBJTIwQ2FsbGFibGUlMjAlM0QlMjBlYWdlcl9hdHRlbnRpb25fZm9yd2FyZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc2VsZi5jb25maWcuX2F0dG5faW1wbGVtZW50YXRpb24lMjAhJTNEJTIwJTIyZWFnZXIlMjIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNlbGYuY29uZmlnLl9hdHRuX2ltcGxlbWVudGF0aW9uJTIwJTNEJTNEJTIwJTIyc2RwYSUyMiUyMGFuZCUyMGt3YXJncy5nZXQoJTIyb3V0cHV0X2F0dGVudGlvbnMlMjIlMkMlMjBGYWxzZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2dnZXIud2FybmluZ19vbmNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiU2MHRvcmNoLm5uLmZ1bmN0aW9uYWwuc2NhbGVkX2RvdF9wcm9kdWN0X2F0dGVudGlvbiU2MCUyMGRvZXMlMjBub3QlMjBzdXBwb3J0JTIwJTYwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlJTYwLiUyMEZhbGxpbmclMjBiYWNrJTIwdG8lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnZWFnZXIlMjBhdHRlbnRpb24uJTIwVGhpcyUyMHdhcm5pbmclMjBjYW4lMjBiZSUyMHJlbW92ZWQlMjB1c2luZyUyMHRoZSUyMGFyZ3VtZW50JTIwJTYwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmVhZ2VyJTIyJTYwJTIwd2hlbiUyMGxvYWRpbmclMjB0aGUlMjBtb2RlbC4nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdHRlbnRpb25faW50ZXJmYWNlJTIwJTNEJTIwQUxMX0FUVEVOVElPTl9GVU5DVElPTlMlNUJzZWxmLmNvbmZpZy5fYXR0bl9pbXBsZW1lbnRhdGlvbiU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF0dG5fb3V0cHV0JTJDJTIwYXR0bl93ZWlnaHRzJTIwJTNEJTIwYXR0ZW50aW9uX2ludGVyZmFjZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcnlfc3RhdGVzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa2V5X3N0YXRlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlX3N0YXRlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF0dGVudGlvbl9tYXNrJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHJvcG91dCUzRDAuMCUyMGlmJTIwbm90JTIwc2VsZi50cmFpbmluZyUyMGVsc2UlMjBzZWxmLmF0dGVudGlvbl9kcm9wb3V0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NhbGluZyUzRHNlbGYuc2NhbGluZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCoqa3dhcmdzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF0dG5fb3V0cHV0JTIwJTNEJTIwYXR0bl9vdXRwdXQucmVzaGFwZSgqaW5wdXRfc2hhcGUlMkMlMjAtMSkuY29udGlndW91cygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXR0bl9vdXRwdXQlMjAlM0QlMjBzZWxmLm9fcHJvaihhdHRuX291dHB1dCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBhdHRuX291dHB1dCUyQyUyMGF0dG5fd2VpZ2h0cw==",highlighted:`<span class="hljs-keyword">from</span> ..llama.modeling_llama <span class="hljs-keyword">import</span> eager_attention_forward
<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoAttention, apply_rotary_pos_emb


<span class="hljs-comment"># Olmo2 attention is identical to OLMo attention except:</span>
<span class="hljs-comment"># - Norm is applied to attention queries and keys.</span>
<span class="hljs-comment"># - No qkv clipping.</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2Attention</span>(<span class="hljs-title class_ inherited__">OlmoAttention</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: Olmo2Config, layer_idx: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">int</span>] = <span class="hljs-literal">None</span></span>):
        <span class="hljs-built_in">super</span>().__init__(config, layer_idx=layer_idx)
        self.q_norm = Olmo2RMSNorm(config.num_attention_heads * self.head_dim, config.rms_norm_eps)
        self.k_norm = Olmo2RMSNorm(config.num_key_value_heads * self.head_dim, config.rms_norm_eps)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
        self,
        hidden_states: torch.Tensor,
        position_embeddings: <span class="hljs-type">Tuple</span>[torch.Tensor, torch.Tensor],
        attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor],
        past_key_value: <span class="hljs-type">Optional</span>[Cache] = <span class="hljs-literal">None</span>,
        cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
        **kwargs,
    </span>) -&gt; <span class="hljs-type">Tuple</span>[torch.Tensor, <span class="hljs-type">Optional</span>[torch.Tensor], <span class="hljs-type">Optional</span>[<span class="hljs-type">Tuple</span>[torch.Tensor]]]:
        input_shape = hidden_states.shape[:-<span class="hljs-number">1</span>]
        hidden_shape = (*input_shape, -<span class="hljs-number">1</span>, self.head_dim)

        query_states = self.q_norm(self.q_proj(hidden_states))
        key_states = self.k_norm(self.k_proj(hidden_states))
        value_states = self.v_proj(hidden_states)

        query_states = query_states.view(hidden_shape).transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
        key_states = key_states.view(hidden_shape).transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
        value_states = value_states.view(hidden_shape).transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)

        cos, sin = position_embeddings
        query_states, key_states = apply_rotary_pos_emb(query_states, key_states, cos, sin)

        <span class="hljs-keyword">if</span> past_key_value <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            <span class="hljs-comment"># sin and cos are specific to RoPE models; cache_position needed for the static cache</span>
            cache_kwargs = {<span class="hljs-string">&quot;sin&quot;</span>: sin, <span class="hljs-string">&quot;cos&quot;</span>: cos, <span class="hljs-string">&quot;cache_position&quot;</span>: cache_position}
            key_states, value_states = past_key_value.update(key_states, value_states, self.layer_idx, cache_kwargs)

        attention_interface: <span class="hljs-type">Callable</span> = eager_attention_forward
        <span class="hljs-keyword">if</span> self.config._attn_implementation != <span class="hljs-string">&quot;eager&quot;</span>:
            <span class="hljs-keyword">if</span> self.config._attn_implementation == <span class="hljs-string">&quot;sdpa&quot;</span> <span class="hljs-keyword">and</span> kwargs.get(<span class="hljs-string">&quot;output_attentions&quot;</span>, <span class="hljs-literal">False</span>):
                logger.warning_once(
                    <span class="hljs-string">&quot;\`torch.nn.functional.scaled_dot_product_attention\` does not support \`output_attentions=True\`. Falling back to &quot;</span>
                    <span class="hljs-string">&#x27;eager attention. This warning can be removed using the argument \`attn_implementation=&quot;eager&quot;\` when loading the model.&#x27;</span>
                )
            <span class="hljs-keyword">else</span>:
                attention_interface = ALL_ATTENTION_FUNCTIONS[self.config._attn_implementation]

        attn_output, attn_weights = attention_interface(
            self,
            query_states,
            key_states,
            value_states,
            attention_mask,
            dropout=<span class="hljs-number">0.0</span> <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.training <span class="hljs-keyword">else</span> self.attention_dropout,
            scaling=self.scaling,
            **kwargs,
        )

        attn_output = attn_output.reshape(*input_shape, -<span class="hljs-number">1</span>).contiguous()
        attn_output = self.o_proj(attn_output)
        <span class="hljs-keyword">return</span> attn_output, attn_weights`,wrap:!1}}),rl=new j({props:{title:"The DecoderLayer class",local:"the-decoderlayer-class",headingTag:"h3"}}),Tl=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoDecoderLayer

<span class="hljs-comment"># The OLMo2 layers are identical to those of the OLMo model except:</span>
<span class="hljs-comment"># - RMSNorm is used instead of standard layer norm.</span>
<span class="hljs-comment"># - Norm is applied after attention/feedforward rather than before.</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2DecoderLayer</span>(<span class="hljs-title class_ inherited__">OlmoDecoderLayer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: Olmo2Config, layer_idx: <span class="hljs-built_in">int</span></span>):
        <span class="hljs-built_in">super</span>().__init__(config, layer_idx=layer_idx)
        self.post_attention_layernorm = Olmo2RMSNorm(config.hidden_size, eps=config.rms_norm_eps)
        self.post_feedforward_layernorm = Olmo2RMSNorm(config.hidden_size, eps=config.rms_norm_eps)
        self.self_attn = Olmo2Attention(config=config, layer_idx=layer_idx)
        <span class="hljs-keyword">del</span> self.input_layernorm

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
        self,
        hidden_states: torch.Tensor,
        attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
        position_ids: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
        past_key_value: <span class="hljs-type">Optional</span>[Cache] = <span class="hljs-literal">None</span>,
        output_attentions: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">False</span>,
        use_cache: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">False</span>,
        cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
        position_embeddings: <span class="hljs-type">Optional</span>[<span class="hljs-type">Tuple</span>[torch.Tensor, torch.Tensor]] = <span class="hljs-literal">None</span>,  <span class="hljs-comment"># necessary, but kept here for BC</span>
        **kwargs,
    </span>) -&gt; <span class="hljs-type">Tuple</span>[torch.FloatTensor, <span class="hljs-type">Optional</span>[<span class="hljs-type">Tuple</span>[torch.FloatTensor, torch.FloatTensor]]]:
        residual = hidden_states

        <span class="hljs-comment"># Self Attention</span>
        hidden_states, self_attn_weights = self.self_attn(
            hidden_states=hidden_states,
            attention_mask=attention_mask,
            position_ids=position_ids,
            past_key_value=past_key_value,
            output_attentions=output_attentions,
            use_cache=use_cache,
            cache_position=cache_position,
            position_embeddings=position_embeddings,
            **kwargs,
        )
        hidden_states = self.post_attention_layernorm(hidden_states)
        hidden_states = residual + hidden_states

        <span class="hljs-comment"># Fully Connected</span>
        residual = hidden_states
        hidden_states = self.mlp(hidden_states)
        hidden_states = self.post_feedforward_layernorm(hidden_states)
        hidden_states = residual + hidden_states

        outputs = (hidden_states,)
        <span class="hljs-keyword">if</span> output_attentions:
            outputs += (self_attn_weights,)

        <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),Cl=new j({props:{title:"The Model class",local:"the-model-class",headingTag:"h3"}}),hl=new r({props:{code:"ZnJvbSUyMC4ub2xtby5tb2RlbGluZ19vbG1vJTIwaW1wb3J0JTIwT2xtb01vZGVsJTBBJTBBJTIzJTIwVGhlJTIwT0xNbzIlMjBtb2RlbCUyMGlzJTIwaWRlbnRpY2FsJTIwdG8lMjB0aGUlMjBPTE1vJTIwbW9kZWwlMkMlMjBleGNlcHQlMjBSTVNOb3JtJTIwaXMlMjB1c2VkJTIwaW5zdGVhZCUyMG9mJTBBJTIzJTIwc3RhbmRhcmQlMjBsYXllciUyMG5vcm0lMjBmb3IlMjB0aGUlMjBvdXRwdXQlMjBub3JtLiUwQWNsYXNzJTIwT2xtbzJNb2RlbChPbG1vTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUzQSUyME9sbW8yQ29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubm9ybSUyMCUzRCUyME9sbW8yUk1TTm9ybShjb25maWcuaGlkZGVuX3NpemUlMkMlMjBlcHMlM0Rjb25maWcucm1zX25vcm1fZXBzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGF5ZXJzJTIwJTNEJTIwbm4uTW9kdWxlTGlzdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJPbG1vMkRlY29kZXJMYXllcihjb25maWclMkMlMjBsYXllcl9pZHgpJTIwZm9yJTIwbGF5ZXJfaWR4JTIwaW4lMjByYW5nZShjb25maWcubnVtX2hpZGRlbl9sYXllcnMpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoModel

<span class="hljs-comment"># The OLMo2 model is identical to the OLMo model, except RMSNorm is used instead of</span>
<span class="hljs-comment"># standard layer norm for the output norm.</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2Model</span>(<span class="hljs-title class_ inherited__">OlmoModel</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: Olmo2Config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        self.norm = Olmo2RMSNorm(config.hidden_size, eps=config.rms_norm_eps)
        self.layers = nn.ModuleList(
            [Olmo2DecoderLayer(config, layer_idx) <span class="hljs-keyword">for</span> layer_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(config.num_hidden_layers)]
        )`,wrap:!1}}),fl=new j({props:{title:"Finally… The ForCausalLM class",local:"finally-the-forcausallm-class",headingTag:"h3"}}),Al=new r({props:{code:"ZnJvbSUyMC4ub2xtby5tb2RlbGluZ19vbG1vJTIwaW1wb3J0JTIwT2xtb0ZvckNhdXNhbExNJTBBJTBBY2xhc3MlMjBPbG1vMkZvckNhdXNhbExNKE9sbW9Gb3JDYXVzYWxMTSklM0ElMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoForCausalLM

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2ForCausalLM</span>(<span class="hljs-title class_ inherited__">OlmoForCausalLM</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),Gl=new r({props:{code:"ZnJvbSUyMC4ub2xtby5tb2RlbGluZ19vbG1vJTIwaW1wb3J0JTIwT2xtb01MUCUwQSUwQWNsYXNzJTIwT2xtbzJNTFAoT2xtb01MUCklM0ElMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">from</span> ..olmo.modeling_olmo <span class="hljs-keyword">import</span> OlmoMLP

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2MLP</span>(<span class="hljs-title class_ inherited__">OlmoMLP</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),vl=new r({props:{code:"JTIzJTIwc3dpdGNoJTIwdG8lMjBtaXN0cmFsJTIwZGVmaW5pdGlvbiUwQWZyb20lMjAuLm1pc3RyYWwubW9kZWxpbmdfbWlzdHJhbCUyMGltcG9ydCUyME1pc3RyYWxNTFAlMEElMEFjbGFzcyUyME9sbW8yTUxQKE1pc3RyYWxNTFApJTNBJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-comment"># switch to mistral definition</span>
<span class="hljs-keyword">from</span> ..mistral.modeling_mistral <span class="hljs-keyword">import</span> MistralMLP

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Olmo2MLP</span>(<span class="hljs-title class_ inherited__">MistralMLP</span>):
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),kl=new j({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),Wl=new j({props:{title:"Removing attributes which are not just assignments",local:"removing-attributes-which-are-not-just-assignments",headingTag:"h3"}}),El=new r({props:{code:"Y2xhc3MlMjBEdW1teU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMEElMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnJTNBJTIwRHVtbXlDb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwc2VsZi5hdHRyaWJ1dGUlMjAlM0QlMjBjb25maWcuYXR0cmlidXRlJTBBJTIwJTIwJTIwJTIwaWYlMjBzZWxmLmF0dHJpYnV0ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGRvJTIwbW9yZSUyMHN0dWZmJTIwd2l0aCUyMCU2MHNlbGYuYXR0cmlidXRlJTYwJTIwaGVyZSUwQSUyMCUyMCUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(nn.Module):

  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: DummyConfig</span>):
    <span class="hljs-built_in">super</span>().__init__()
    self.attribute = config.attribute
    <span class="hljs-keyword">if</span> self.attribute:
      <span class="hljs-comment"># do more stuff with \`self.attribute\` here</span>
      ...`,wrap:!1}}),Vl=new r({props:{code:"Y2xhc3MlMjBNeU5ld0R1bW15TW9kZWwoRHVtbXlNb2RlbCklM0ElMEElMEElMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnJTNBJTIwTXlOZXdEdW1teUNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjBkZWwlMjBzZWxmLmF0dHJpYnV0ZQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewDummyModel</span>(<span class="hljs-title class_ inherited__">DummyModel</span>):

  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyNewDummyConfig</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    <span class="hljs-keyword">del</span> self.attribute`,wrap:!1}}),Ql=new j({props:{title:"Avoiding super() special meaning",local:"avoiding-super-special-meaning",headingTag:"h3"}}),zl=new r({props:{code:"Y2xhc3MlMjBNeU5ld0R1bW15TW9kZWwoRHVtbXlNb2RlbCUyQyUyMG5uLk1vZHVsZSklM0ElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjBjbGFzcyUyME15TmV3RHVtbXlNb2RlbChubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUzQSUyME15TmV3RHVtbXlDb25maWcpJTNBJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUzQSUyME15TmV3RHVtbXlDb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwbm4uTW9kdWxlLl9faW5pdF9fKGNvbmZpZyklMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjBzZWxmLmZvbyUyMCUzRCUyMGNvbmZpZy5mb28lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZvbyUyMCUzRCUyMGNvbmZpZy5mb28lMEElMjAlMjAlMjAlMjAuLi4lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewDummyModel</span>(DummyModel, nn.Module):        |     <span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewDummyModel</span>(nn.Module):
                                                     |
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyNewDummyConfig</span>):      |       <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyNewDummyConfig</span>):
    nn.Module.__init__(config)                       |         <span class="hljs-built_in">super</span>().__init__()
    self.foo = config.foo                            |         self.foo = config.foo
    ...                                              |         ...`,wrap:!1}}),Sl=new j({props:{title:"Deleting unused methods",local:"deleting-unused-methods",headingTag:"h3"}}),Fl=new r({props:{code:"Y2xhc3MlMjBHZW1tYVRva2VuaXplcihMbGFtYVRva2VuaXplciklM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEElMjAlMjAlMjAlMjBkZWYlMjBnZXRfc3BtX3Byb2Nlc3NvcihzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwQXR0cmlidXRlRXJyb3IoJTIyTm90JTIwbmVlZGVkJTIwZm9yJTIwR2VtbWElMjIpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwdW5rX3Rva2VuX2xlbmd0aChzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwQXR0cmlidXRlRXJyb3IoJTIyTm90JTIwbmVlZGVkJTIwZm9yJTIwR2VtbWElMjIp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">GemmaTokenizer</span>(<span class="hljs-title class_ inherited__">LlamaTokenizer</span>):
    ...

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_spm_processor</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">raise</span> AttributeError(<span class="hljs-string">&quot;Not needed for Gemma&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">unk_token_length</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">raise</span> AttributeError(<span class="hljs-string">&quot;Not needed for Gemma&quot;</span>)`,wrap:!1}}),Ll=new j({props:{title:"Define new functions",local:"define-new-functions",headingTag:"h3"}}),Dl=new r({props:{code:"ZGVmJTIwbXlfbmV3X2Z1bmN0aW9uKCphcmdzJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIzJTIwRG8lMjBzb21ldGhpbmclMjBoZXJlJTBBJTIwJTIwcGFzcyUwQSUwQWNsYXNzJTIwRHVtbXlNb2RlbChMbGFtYU1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoKmFyZ3MlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDYWxsJTIwdGhlJTIwZnVuY3Rpb24lMEElMjAlMjAlMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbXlfbmV3X2Z1bmN0aW9uKCphcmdzJTJDJTIwKiprd2FyZ3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwY29udGludWUlMjBoZXJl",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_new_function</span>(<span class="hljs-params">*args, **kwargs</span>):
  <span class="hljs-comment"># Do something here</span>
  <span class="hljs-keyword">pass</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(<span class="hljs-title class_ inherited__">LlamaModel</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">*args, **kwargs</span>):
      <span class="hljs-comment"># Call the function</span>
      example = my_new_function(*args, **kwargs)
      <span class="hljs-comment"># continue here</span>`,wrap:!1}}),Kl=new j({props:{title:"Decorators",local:"decorators",headingTag:"h3"}}),ee=new r({props:{code:"Y2xhc3MlMjBEdW1teU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAuLi4lMEElMEElMjAlMjAlNDBkZWNvcmF0b3IoLi4uKSUwQSUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRvJTIwc3R1ZmYlMjBoZXJl",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(nn.Module):
  ...

<span class="hljs-meta">  @decorator(<span class="hljs-params">...</span>)</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>)
    <span class="hljs-comment"># do stuff here</span>`,wrap:!1}}),te=new r({props:{code:"Y2xhc3MlMjBOZXdNb2RlbChEdW1teU1vZGVsKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMGNsYXNzJTIwTmV3TW9kZWwobm4uTW9kdWxlKSUzQSUwQSUyMCUyMC4uLiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCU0MGRlY29yYXRvciguLi4pJTBBJTIwJTIwJTIwJTIwLi4uJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZCguLi4pJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(<span class="hljs-title class_ inherited__">DummyModel</span>):       |   <span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(nn.Module):
  ...                             |     ...
                                  |
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):               |     @decorator(...)
    ...                           |     <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):
                                  |       ...`,wrap:!1}}),ae=new r({props:{code:"Y2xhc3MlMjBOZXdNb2RlbChEdW1teU1vZGVsKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMGNsYXNzJTIwTmV3TW9kZWwobm4uTW9kdWxlKSUzQSUwQSUyMCUyMC4uLiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMCU0MG15X25ld19kZWNvcmF0b3IoLi4uKSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCU0MG15X25ld19kZWNvcmF0b3IoLi4uKSUwQSUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoLi4uKSUzQSUwQSUyMCUyMCUyMCUyMC4uLiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(<span class="hljs-title class_ inherited__">DummyModel</span>):       |   <span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModel</span>(nn.Module):
  ...                             |     ...
                                  |
<span class="hljs-meta">  @my_new_decorator(<span class="hljs-params">...</span>)          |     @my_new_decorator(<span class="hljs-params">...</span>)</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):               |     <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>):
    ...                           |       ...`,wrap:!1}}),ie=new j({props:{title:"The super_kwargs special case",local:"the-superkwargs-special-case",headingTag:"h3"}}),ye=new r({props:{code:"Y2xhc3MlMjBMbGFtYUZvckNhdXNhbExNKG5uLk1vZHVsZSklM0ElMEElMjAlMjAuLi4lMEElMEElMjAlMjAlNDBhZGRfc3RhcnRfZG9jc3RyaW5nc190b19tb2RlbF9mb3J3YXJkKExMQU1BX0lOUFVUU19ET0NTVFJJTkcpJTBBJTIwJTIwJTQwcmVwbGFjZV9yZXR1cm5fZG9jc3RyaW5ncyhvdXRwdXRfdHlwZSUzRENhdXNhbExNT3V0cHV0V2l0aFBhc3QlMkMlMjBjb25maWdfY2xhc3MlM0RfQ09ORklHX0ZPUl9ET0MpJTBBJTIwJTIwZGVmJTIwZm9yd2FyZCglMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTNBJTIwdG9yY2guTG9uZ1RlbnNvciUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUzQSUyME9wdGlvbmFsJTVCdG9yY2guVGVuc29yJTVEJTIwJTNEJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHBvc2l0aW9uX2lkcyUzQSUyME9wdGlvbmFsJTVCdG9yY2guTG9uZ1RlbnNvciU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwYXN0X2tleV92YWx1ZXMlM0ElMjBPcHRpb25hbCU1QlVuaW9uJTVCQ2FjaGUlMkMlMjBMaXN0JTVCdG9yY2guRmxvYXRUZW5zb3IlNUQlNUQlNUQlMjAlM0QlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzX2VtYmVkcyUzQSUyME9wdGlvbmFsJTVCdG9yY2guRmxvYXRUZW5zb3IlNUQlMjAlM0QlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTNBJTIwT3B0aW9uYWwlNUJ0b3JjaC5Mb25nVGVuc29yJTVEJTIwJTNEJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfYXR0ZW50aW9ucyUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfaGlkZGVuX3N0YXRlcyUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fZGljdCUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBjYWNoZV9wb3NpdGlvbiUzQSUyME9wdGlvbmFsJTVCdG9yY2guTG9uZ1RlbnNvciU1RCUyMCUzRCUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBudW1fbG9naXRzX3RvX2tlZXAlM0ElMjBpbnQlMjAlM0QlMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwKiprd2FyZ3MlM0ElMjBVbnBhY2slNUJLd2FyZ3NGb3JDYXVzYWxMTSU1RCUyQyUwQSUyMCUyMCklMjAtJTNFJTIwVW5pb24lNUJUdXBsZSUyQyUyMENhdXNhbExNT3V0cHV0V2l0aFBhc3QlNUQlM0ElMEElMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">LlamaForCausalLM</span>(nn.Module):
  ...

<span class="hljs-meta">  @add_start_docstrings_to_model_forward(<span class="hljs-params">LLAMA_INPUTS_DOCSTRING</span>)</span>
<span class="hljs-meta">  @replace_return_docstrings(<span class="hljs-params">output_type=CausalLMOutputWithPast, config_class=_CONFIG_FOR_DOC</span>)</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
      self,
      input_ids: torch.LongTensor = <span class="hljs-literal">None</span>,
      attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
      position_ids: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
      past_key_values: <span class="hljs-type">Optional</span>[<span class="hljs-type">Union</span>[Cache, <span class="hljs-type">List</span>[torch.FloatTensor]]] = <span class="hljs-literal">None</span>,
      inputs_embeds: <span class="hljs-type">Optional</span>[torch.FloatTensor] = <span class="hljs-literal">None</span>,
      labels: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
      use_cache: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      output_attentions: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      output_hidden_states: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      return_dict: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
      cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
      num_logits_to_keep: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span>,
      **kwargs: Unpack[KwargsForCausalLM],
  </span>) -&gt; <span class="hljs-type">Union</span>[<span class="hljs-type">Tuple</span>, CausalLMOutputWithPast]:
    ...`,wrap:!1}}),Ue=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">NewModelForCausalLM</span>(<span class="hljs-title class_ inherited__">LlamaForCausalLM</span>):    |    <span class="hljs-keyword">class</span> <span class="hljs-title class_">LlamaForCausalLM</span>(nn.Module):
  ...                                           |      ...
                                                |
<span class="hljs-meta">  @my_new_decorator                             |     @my_new_decorator</span>
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, **super_kwargs</span>):            |     <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">
    <span class="hljs-built_in">super</span>(<span class="hljs-params"></span>).forward(<span class="hljs-params">**super_kwargs</span>)             |         self,
                                                |         input_ids: torch.LongTensor = <span class="hljs-literal">None</span>,
                                                |         attention_mask: <span class="hljs-type">Optional</span>[torch.Tensor] = <span class="hljs-literal">None</span>,
                                                |         position_ids: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
                                                |         past_key_values: <span class="hljs-type">Optional</span>[<span class="hljs-type">Union</span>[Cache, <span class="hljs-type">List</span>[torch.FloatTensor]]] = |<span class="hljs-literal">None</span>,
                                                |         inputs_embeds: <span class="hljs-type">Optional</span>[torch.FloatTensor] = <span class="hljs-literal">None</span>,
                                                |         labels: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
                                                |         use_cache: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         output_attentions: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         output_hidden_states: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         return_dict: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>] = <span class="hljs-literal">None</span>,
                                                |         cache_position: <span class="hljs-type">Optional</span>[torch.LongTensor] = <span class="hljs-literal">None</span>,
                                                |         num_logits_to_keep: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span>,
                                                |         **kwargs: Unpack[KwargsForCausalLM],
                                                |     </span>) -&gt; <span class="hljs-type">Union</span>[<span class="hljs-type">Tuple</span>, CausalLMOutputWithPast]:
                                                |       ...`,wrap:!1}}),ce=new j({props:{title:"The DOCSTRING variables",local:"the-docstring-variables",headingTag:"h3"}}),je=new r({props:{code:"U1RBUkNPREVSMl9JTlBVVFNfRE9DU1RSSU5HJTIwJTNEJTIwTm9uZSUyMCUyMCUyMyUyMHdpbGwlMjBiZSUyMGF1dG9tYXRpY2FsbHklMjByZWRlZmluZWQlMEElMEFjbGFzcyUyMFN0YXJjb2RlcjJNb2RlbChNaXN0cmFsTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTQwYWRkX3N0YXJ0X2RvY3N0cmluZ3NfdG9fbW9kZWxfZm9yd2FyZChTVEFSQ09ERVIyX0lOUFVUU19ET0NTVFJJTkcpJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZCguLi4pJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`STARCODER2_INPUTS_DOCSTRING = <span class="hljs-literal">None</span>  <span class="hljs-comment"># will be automatically redefined</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Starcoder2Model</span>(<span class="hljs-title class_ inherited__">MistralModel</span>):
    ...

<span class="hljs-meta">    @add_start_docstrings_to_model_forward(<span class="hljs-params">STARCODER2_INPUTS_DOCSTRING</span>)</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">...</span>)
        ...`,wrap:!1}}),me=new j({props:{title:"Limitations",local:"limitations",headingTag:"h2"}}),Ce=new j({props:{title:"Special naming (essentially for multimodal models)",local:"special-naming-essentially-for-multimodal-models",headingTag:"h3"}}),ue=new r({props:{code:"Y2xhc3MlMjBNeU1vZGVsSW5jcmVkaWJsZU1MUChMbGFtYU1MUCklM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEFjbGFzcyUyME15TW9kZWxEZWNvZGVyTGF5ZXIoTGxhbWFEZWNvZGVyTGF5ZXIpJTNBJTBBJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModelIncredibleMLP</span>(<span class="hljs-title class_ inherited__">LlamaMLP</span>):
    ...

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModelDecoderLayer</span>(<span class="hljs-title class_ inherited__">LlamaDecoderLayer</span>):
    ...`,wrap:!1}}),be=new r({props:{code:"V2UlMjBkZXRlY3RlZCUyMG11bHRpcGxlJTIwcHJlZml4JTIwbmFtZXMlMjB3aGVuJTIwaW5oZXJpdGluZyUyMGZyb20lMjB0cmFuc2Zvcm1lcnMubW9kZWxzLmxsYW1hLm1vZGVsaW5nX2xsYW1hJTNBJTIwKCdFbXUzVGV4dCclMkMlMjAnRW11MycpLiUyMFdlJTIwd2lsbCUyMG9ubHklMjB1c2UlMjB0aGUlMjBtb3N0JTIwdXNlZCUyMCdFbXUzJyUyMHByZWZpeCUyMHdoZW4lMjBncmFiYmluZyUyMGFyZ3MlMjBhbmQlMjBkZXBlbmRlbmNpZXMuJTIwTWFrZSUyMHN1cmUlMjB0byUyMHN1YmNsYXNzJTIwdGhlJTIwaW50ZXJtZWRpYXRlJTIwY2xhc3NlcyUyMHdpdGglMjB0aGUlMjBwcmVmaXglMjB5b3UlMjB3YW50JTIwKGlmJTIwZGlmZmVyZW50JTIwZnJvbSUyMCdFbXUzJyklMjBvciUyMHVzZSUyMGElMjBzaW5nbGUlMjBwcmVmaXglMjBpbiUyMGFsbCUyMHRoZSUyMG1vZHVsYXIlMjAoYmVzdCku",highlighted:'We detected multiple prefix names when inheriting <span class="hljs-built_in">from</span> transformers.models.llama.modeling_llama: (<span class="hljs-string">&#x27;Emu3Text&#x27;</span>, <span class="hljs-string">&#x27;Emu3&#x27;</span>). We will only use <span class="hljs-keyword">the</span> most used <span class="hljs-string">&#x27;Emu3&#x27;</span> prefix when grabbing args <span class="hljs-keyword">and</span> dependencies. Make sure <span class="hljs-built_in">to</span> subclass <span class="hljs-keyword">the</span> intermediate classes <span class="hljs-keyword">with</span> <span class="hljs-keyword">the</span> prefix you want (<span class="hljs-keyword">if</span> different <span class="hljs-built_in">from</span> <span class="hljs-string">&#x27;Emu3&#x27;</span>) <span class="hljs-keyword">or</span> use <span class="hljs-keyword">a</span> single prefix <span class="hljs-keyword">in</span> all <span class="hljs-keyword">the</span> modular (best).',wrap:!1}}),Ze=new r({props:{code:"Y2xhc3MlMjBFbXUzVGV4dE1MUChMbGFtYU1MUCklM0ElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Emu3TextMLP</span>(<span class="hljs-title class_ inherited__">LlamaMLP</span>):                                 
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),ge=new j({props:{title:"Automatic docstrings issue (mostly for Configs)",local:"automatic-docstrings-issue-mostly-for-configs",headingTag:"h3"}}),ve=new va({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/modular_transformers.md"}}),{c(){T=n("meta"),Ne=M(),Re=n("p"),Ee=M(),y(m.$$.fragment),Xe=M(),J=n("p"),J.innerHTML=MM,Ve=M(),C=n("p"),C.innerHTML=aM,$e=M(),h=n("p"),h.innerHTML=nM,xe=M(),u=n("p"),u.textContent=iM,Qe=M(),f=n("p"),f.textContent=oM,Ye=M(),I=n("p"),I.textContent=yM,ze=M(),A=n("p"),A.innerHTML=pM,Se=M(),y(b.$$.fragment),He=M(),_=n("p"),_.textContent=UM,Fe=M(),Z=n("p"),Z.textContent=dM,Le=M(),G=n("p"),G.innerHTML=wM,Oe=M(),g=n("p"),g.textContent=cM,De=M(),B=n("p"),B.innerHTML=rM,Pe=M(),y(v.$$.fragment),Ke=M(),k=n("p"),k.textContent=jM,qe=M(),y(R.$$.fragment),ls=M(),W=n("p"),W.innerHTML=TM,es=M(),N=n("p"),N.textContent=mM,ss=M(),E=n("ul"),E.innerHTML=JM,ts=M(),X=n("p"),X.innerHTML=CM,Ms=M(),y(V.$$.fragment),as=M(),$=n("p"),$.innerHTML=hM,ns=M(),y(x.$$.fragment),is=M(),y(Q.$$.fragment),os=M(),Y=n("p"),Y.textContent=uM,ys=M(),z=n("p"),z.innerHTML=fM,ps=M(),y(S.$$.fragment),Us=M(),y(H.$$.fragment),ds=M(),F=n("p"),F.innerHTML=IM,ws=M(),y(L.$$.fragment),cs=M(),O=n("p"),O.innerHTML=AM,rs=M(),D=n("p"),D.textContent=bM,js=M(),P=n("ul"),P.innerHTML=_M,Ts=M(),K=n("p"),K.innerHTML=ZM,ms=M(),q=n("p"),q.textContent=GM,Js=M(),y(ll.$$.fragment),Cs=M(),el=n("p"),el.innerHTML=gM,hs=M(),y(sl.$$.fragment),us=M(),tl=n("p"),tl.innerHTML=BM,fs=M(),Ml=n("ol"),Ml.innerHTML=vM,Is=M(),al=n("p"),al.innerHTML=kM,As=M(),nl=n("p"),nl.innerHTML=RM,bs=M(),y(il.$$.fragment),_s=M(),ol=n("p"),ol.innerHTML=WM,Zs=M(),y(yl.$$.fragment),Gs=M(),pl=n("p"),pl.innerHTML=NM,gs=M(),y(Ul.$$.fragment),Bs=M(),dl=n("p"),dl.innerHTML=EM,vs=M(),y(wl.$$.fragment),ks=M(),cl=n("p"),cl.innerHTML=XM,Rs=M(),y(rl.$$.fragment),Ws=M(),jl=n("p"),jl.innerHTML=VM,Ns=M(),y(Tl.$$.fragment),Es=M(),ml=n("p"),ml.innerHTML=$M,Xs=M(),Jl=n("p"),Jl.innerHTML=xM,Vs=M(),y(Cl.$$.fragment),$s=M(),y(hl.$$.fragment),xs=M(),ul=n("p"),ul.innerHTML=QM,Qs=M(),y(fl.$$.fragment),Ys=M(),Il=n("p"),Il.innerHTML=YM,zs=M(),y(Al.$$.fragment),Ss=M(),bl=n("p"),bl.innerHTML=zM,Hs=M(),ke=n("a"),Fs=Za(`
### But... What about the MLP, RotaryEmbedding and PreTrainedModel classes?
`),_l=n("p"),_l.innerHTML=SM,Ls=M(),Zl=n("p"),Zl.innerHTML=HM,Os=M(),y(Gl.$$.fragment),Ds=M(),gl=n("p"),gl.innerHTML=FM,Ps=M(),Bl=n("p"),Bl.innerHTML=LM,Ks=M(),y(vl.$$.fragment),qs=M(),y(kl.$$.fragment),lt=M(),Rl=n("p"),Rl.textContent=OM,et=M(),y(Wl.$$.fragment),st=M(),Nl=n("p"),Nl.innerHTML=DM,tt=M(),y(El.$$.fragment),Mt=M(),Xl=n("p"),Xl.innerHTML=PM,at=M(),y(Vl.$$.fragment),nt=M(),$l=n("p"),$l.innerHTML=KM,it=M(),xl=n("p"),xl.innerHTML=qM,ot=M(),y(Ql.$$.fragment),yt=M(),Yl=n("p"),Yl.innerHTML=la,pt=M(),y(zl.$$.fragment),Ut=M(),y(Sl.$$.fragment),dt=M(),Hl=n("p"),Hl.innerHTML=ea,wt=M(),y(Fl.$$.fragment),ct=M(),y(Ll.$$.fragment),rt=M(),Ol=n("p"),Ol.innerHTML=sa,jt=M(),y(Dl.$$.fragment),Tt=M(),Pl=n("p"),Pl.innerHTML=ta,mt=M(),y(Kl.$$.fragment),Jt=M(),ql=n("p"),ql.innerHTML=Ma,Ct=M(),le=n("p"),le.textContent=aa,ht=M(),y(ee.$$.fragment),ut=M(),se=n("p"),se.textContent=na,ft=M(),y(te.$$.fragment),It=M(),Me=n("p"),Me.textContent=ia,At=M(),y(ae.$$.fragment),bt=M(),ne=n("p"),ne.textContent=oa,_t=M(),y(ie.$$.fragment),Zt=M(),oe=n("p"),oe.innerHTML=ya,Gt=M(),y(ye.$$.fragment),gt=M(),pe=n("p"),pe.textContent=pa,Bt=M(),y(Ue.$$.fragment),vt=M(),de=n("p"),de.innerHTML=Ua,kt=M(),we=n("p"),we.innerHTML=da,Rt=M(),y(ce.$$.fragment),Wt=M(),re=n("p"),re.innerHTML=wa,Nt=M(),y(je.$$.fragment),Et=M(),Te=n("p"),Te.innerHTML=ca,Xt=M(),y(me.$$.fragment),Vt=M(),Je=n("p"),Je.textContent=ra,$t=M(),y(Ce.$$.fragment),xt=M(),he=n("p"),he.innerHTML=ja,Qt=M(),y(ue.$$.fragment),Yt=M(),fe=n("p"),fe.innerHTML=Ta,zt=M(),Ie=n("p"),Ie.innerHTML=ma,St=M(),Ae=n("p"),Ae.textContent=Ja,Ht=M(),y(be.$$.fragment),Ft=M(),_e=n("p"),_e.innerHTML=Ca,Lt=M(),y(Ze.$$.fragment),Ot=M(),Ge=n("p"),Ge.innerHTML=ha,Dt=M(),y(ge.$$.fragment),Pt=M(),Be=n("p"),Be.textContent=ua,Kt=M(),y(ve.$$.fragment),qt=M(),We=n("p"),this.h()},l(l){const e=Ga("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(s),Ne=a(l),Re=i(l,"P",{}),eM(Re).forEach(s),Ee=a(l),p(m.$$.fragment,l),Xe=a(l),J=i(l,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1qsl2az"&&(J.innerHTML=MM),Ve=a(l),C=i(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1qcwnc7"&&(C.innerHTML=aM),$e=a(l),h=i(l,"P",{"data-svelte-h":!0}),o(h)!=="svelte-hcbv0p"&&(h.innerHTML=nM),xe=a(l),u=i(l,"P",{"data-svelte-h":!0}),o(u)!=="svelte-14lpvvv"&&(u.textContent=iM),Qe=a(l),f=i(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1tehds2"&&(f.textContent=oM),Ye=a(l),I=i(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-5u9x31"&&(I.textContent=yM),ze=a(l),A=i(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-c0230n"&&(A.innerHTML=pM),Se=a(l),p(b.$$.fragment,l),He=a(l),_=i(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1qqnnub"&&(_.textContent=UM),Fe=a(l),Z=i(l,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-huwsbv"&&(Z.textContent=dM),Le=a(l),G=i(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-dk7wye"&&(G.innerHTML=wM),Oe=a(l),g=i(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-12pm85e"&&(g.textContent=cM),De=a(l),B=i(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-ah1dr9"&&(B.innerHTML=rM),Pe=a(l),p(v.$$.fragment,l),Ke=a(l),k=i(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-11y95xa"&&(k.textContent=jM),qe=a(l),p(R.$$.fragment,l),ls=a(l),W=i(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-xkvkhs"&&(W.innerHTML=TM),es=a(l),N=i(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1gkqha7"&&(N.textContent=mM),ss=a(l),E=i(l,"UL",{"data-svelte-h":!0}),o(E)!=="svelte-1np4rww"&&(E.innerHTML=JM),ts=a(l),X=i(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-12b6859"&&(X.innerHTML=CM),Ms=a(l),p(V.$$.fragment,l),as=a(l),$=i(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-1jju20g"&&($.innerHTML=hM),ns=a(l),p(x.$$.fragment,l),is=a(l),p(Q.$$.fragment,l),os=a(l),Y=i(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1o8u693"&&(Y.textContent=uM),ys=a(l),z=i(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-si4m91"&&(z.innerHTML=fM),ps=a(l),p(S.$$.fragment,l),Us=a(l),p(H.$$.fragment,l),ds=a(l),F=i(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-bvl6dd"&&(F.innerHTML=IM),ws=a(l),p(L.$$.fragment,l),cs=a(l),O=i(l,"P",{"data-svelte-h":!0}),o(O)!=="svelte-6v2s2r"&&(O.innerHTML=AM),rs=a(l),D=i(l,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1cop7hb"&&(D.textContent=bM),js=a(l),P=i(l,"UL",{"data-svelte-h":!0}),o(P)!=="svelte-579f4p"&&(P.innerHTML=_M),Ts=a(l),K=i(l,"P",{"data-svelte-h":!0}),o(K)!=="svelte-52k0wz"&&(K.innerHTML=ZM),ms=a(l),q=i(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-33jo7g"&&(q.textContent=GM),Js=a(l),p(ll.$$.fragment,l),Cs=a(l),el=i(l,"P",{"data-svelte-h":!0}),o(el)!=="svelte-1xf26oy"&&(el.innerHTML=gM),hs=a(l),p(sl.$$.fragment,l),us=a(l),tl=i(l,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-17h1ydr"&&(tl.innerHTML=BM),fs=a(l),Ml=i(l,"OL",{"data-svelte-h":!0}),o(Ml)!=="svelte-wmze1e"&&(Ml.innerHTML=vM),Is=a(l),al=i(l,"P",{"data-svelte-h":!0}),o(al)!=="svelte-18k2jgy"&&(al.innerHTML=kM),As=a(l),nl=i(l,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-8zw5rz"&&(nl.innerHTML=RM),bs=a(l),p(il.$$.fragment,l),_s=a(l),ol=i(l,"P",{"data-svelte-h":!0}),o(ol)!=="svelte-zq0wu8"&&(ol.innerHTML=WM),Zs=a(l),p(yl.$$.fragment,l),Gs=a(l),pl=i(l,"P",{"data-svelte-h":!0}),o(pl)!=="svelte-4e6smr"&&(pl.innerHTML=NM),gs=a(l),p(Ul.$$.fragment,l),Bs=a(l),dl=i(l,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-m4gli0"&&(dl.innerHTML=EM),vs=a(l),p(wl.$$.fragment,l),ks=a(l),cl=i(l,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-f779jp"&&(cl.innerHTML=XM),Rs=a(l),p(rl.$$.fragment,l),Ws=a(l),jl=i(l,"P",{"data-svelte-h":!0}),o(jl)!=="svelte-8hd4fl"&&(jl.innerHTML=VM),Ns=a(l),p(Tl.$$.fragment,l),Es=a(l),ml=i(l,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-1puk9ym"&&(ml.innerHTML=$M),Xs=a(l),Jl=i(l,"P",{"data-svelte-h":!0}),o(Jl)!=="svelte-1jvwg68"&&(Jl.innerHTML=xM),Vs=a(l),p(Cl.$$.fragment,l),$s=a(l),p(hl.$$.fragment,l),xs=a(l),ul=i(l,"P",{"data-svelte-h":!0}),o(ul)!=="svelte-1upff2z"&&(ul.innerHTML=QM),Qs=a(l),p(fl.$$.fragment,l),Ys=a(l),Il=i(l,"P",{"data-svelte-h":!0}),o(Il)!=="svelte-hjuool"&&(Il.innerHTML=YM),zs=a(l),p(Al.$$.fragment,l),Ss=a(l),bl=i(l,"P",{"data-svelte-h":!0}),o(bl)!=="svelte-1p1nc5i"&&(bl.innerHTML=zM),Hs=a(l),ke=i(l,"A",{id:!0}),eM(ke).forEach(s),Fs=ga(l,`
### But... What about the MLP, RotaryEmbedding and PreTrainedModel classes?
`),_l=i(l,"P",{"data-svelte-h":!0}),o(_l)!=="svelte-129wpkp"&&(_l.innerHTML=SM),Ls=a(l),Zl=i(l,"P",{"data-svelte-h":!0}),o(Zl)!=="svelte-1iwt0rn"&&(Zl.innerHTML=HM),Os=a(l),p(Gl.$$.fragment,l),Ds=a(l),gl=i(l,"P",{"data-svelte-h":!0}),o(gl)!=="svelte-hx072i"&&(gl.innerHTML=FM),Ps=a(l),Bl=i(l,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-115qkhu"&&(Bl.innerHTML=LM),Ks=a(l),p(vl.$$.fragment,l),qs=a(l),p(kl.$$.fragment,l),lt=a(l),Rl=i(l,"P",{"data-svelte-h":!0}),o(Rl)!=="svelte-2lsmzy"&&(Rl.textContent=OM),et=a(l),p(Wl.$$.fragment,l),st=a(l),Nl=i(l,"P",{"data-svelte-h":!0}),o(Nl)!=="svelte-j6677p"&&(Nl.innerHTML=DM),tt=a(l),p(El.$$.fragment,l),Mt=a(l),Xl=i(l,"P",{"data-svelte-h":!0}),o(Xl)!=="svelte-1y6u0yw"&&(Xl.innerHTML=PM),at=a(l),p(Vl.$$.fragment,l),nt=a(l),$l=i(l,"P",{"data-svelte-h":!0}),o($l)!=="svelte-1gbrqtm"&&($l.innerHTML=KM),it=a(l),xl=i(l,"P",{"data-svelte-h":!0}),o(xl)!=="svelte-1kphpee"&&(xl.innerHTML=qM),ot=a(l),p(Ql.$$.fragment,l),yt=a(l),Yl=i(l,"P",{"data-svelte-h":!0}),o(Yl)!=="svelte-1bd6kt0"&&(Yl.innerHTML=la),pt=a(l),p(zl.$$.fragment,l),Ut=a(l),p(Sl.$$.fragment,l),dt=a(l),Hl=i(l,"P",{"data-svelte-h":!0}),o(Hl)!=="svelte-c9w476"&&(Hl.innerHTML=ea),wt=a(l),p(Fl.$$.fragment,l),ct=a(l),p(Ll.$$.fragment,l),rt=a(l),Ol=i(l,"P",{"data-svelte-h":!0}),o(Ol)!=="svelte-hvsyf6"&&(Ol.innerHTML=sa),jt=a(l),p(Dl.$$.fragment,l),Tt=a(l),Pl=i(l,"P",{"data-svelte-h":!0}),o(Pl)!=="svelte-1ov84rp"&&(Pl.innerHTML=ta),mt=a(l),p(Kl.$$.fragment,l),Jt=a(l),ql=i(l,"P",{"data-svelte-h":!0}),o(ql)!=="svelte-i7t16s"&&(ql.innerHTML=Ma),Ct=a(l),le=i(l,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1xerhbv"&&(le.textContent=aa),ht=a(l),p(ee.$$.fragment,l),ut=a(l),se=i(l,"P",{"data-svelte-h":!0}),o(se)!=="svelte-3hueol"&&(se.textContent=na),ft=a(l),p(te.$$.fragment,l),It=a(l),Me=i(l,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-gta4rc"&&(Me.textContent=ia),At=a(l),p(ae.$$.fragment,l),bt=a(l),ne=i(l,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1u8jzso"&&(ne.textContent=oa),_t=a(l),p(ie.$$.fragment,l),Zt=a(l),oe=i(l,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-cbveqz"&&(oe.innerHTML=ya),Gt=a(l),p(ye.$$.fragment,l),gt=a(l),pe=i(l,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-154jhi"&&(pe.textContent=pa),Bt=a(l),p(Ue.$$.fragment,l),vt=a(l),de=i(l,"P",{"data-svelte-h":!0}),o(de)!=="svelte-2ilo5h"&&(de.innerHTML=Ua),kt=a(l),we=i(l,"P",{"data-svelte-h":!0}),o(we)!=="svelte-sb4f3e"&&(we.innerHTML=da),Rt=a(l),p(ce.$$.fragment,l),Wt=a(l),re=i(l,"P",{"data-svelte-h":!0}),o(re)!=="svelte-187vlwj"&&(re.innerHTML=wa),Nt=a(l),p(je.$$.fragment,l),Et=a(l),Te=i(l,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-sm5l0i"&&(Te.innerHTML=ca),Xt=a(l),p(me.$$.fragment,l),Vt=a(l),Je=i(l,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-168b6cn"&&(Je.textContent=ra),$t=a(l),p(Ce.$$.fragment,l),xt=a(l),he=i(l,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1gs6a5h"&&(he.innerHTML=ja),Qt=a(l),p(ue.$$.fragment,l),Yt=a(l),fe=i(l,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-um3kky"&&(fe.innerHTML=Ta),zt=a(l),Ie=i(l,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-143l68k"&&(Ie.innerHTML=ma),St=a(l),Ae=i(l,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1b02g9p"&&(Ae.textContent=Ja),Ht=a(l),p(be.$$.fragment,l),Ft=a(l),_e=i(l,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-152u23"&&(_e.innerHTML=Ca),Lt=a(l),p(Ze.$$.fragment,l),Ot=a(l),Ge=i(l,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1sm5een"&&(Ge.innerHTML=ha),Dt=a(l),p(ge.$$.fragment,l),Pt=a(l),Be=i(l,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1i3zif8"&&(Be.textContent=ua),Kt=a(l),p(ve.$$.fragment,l),qt=a(l),We=i(l,"P",{}),eM(We).forEach(s),this.h()},h(){sM(T,"name","hf:doc:metadata"),sM(T,"content",Ra),sM(ke,"id","dependencies")},m(l,e){Ba(document.head,T),t(l,Ne,e),t(l,Re,e),t(l,Ee,e),U(m,l,e),t(l,Xe,e),t(l,J,e),t(l,Ve,e),t(l,C,e),t(l,$e,e),t(l,h,e),t(l,xe,e),t(l,u,e),t(l,Qe,e),t(l,f,e),t(l,Ye,e),t(l,I,e),t(l,ze,e),t(l,A,e),t(l,Se,e),U(b,l,e),t(l,He,e),t(l,_,e),t(l,Fe,e),t(l,Z,e),t(l,Le,e),t(l,G,e),t(l,Oe,e),t(l,g,e),t(l,De,e),t(l,B,e),t(l,Pe,e),U(v,l,e),t(l,Ke,e),t(l,k,e),t(l,qe,e),U(R,l,e),t(l,ls,e),t(l,W,e),t(l,es,e),t(l,N,e),t(l,ss,e),t(l,E,e),t(l,ts,e),t(l,X,e),t(l,Ms,e),U(V,l,e),t(l,as,e),t(l,$,e),t(l,ns,e),U(x,l,e),t(l,is,e),U(Q,l,e),t(l,os,e),t(l,Y,e),t(l,ys,e),t(l,z,e),t(l,ps,e),U(S,l,e),t(l,Us,e),U(H,l,e),t(l,ds,e),t(l,F,e),t(l,ws,e),U(L,l,e),t(l,cs,e),t(l,O,e),t(l,rs,e),t(l,D,e),t(l,js,e),t(l,P,e),t(l,Ts,e),t(l,K,e),t(l,ms,e),t(l,q,e),t(l,Js,e),U(ll,l,e),t(l,Cs,e),t(l,el,e),t(l,hs,e),U(sl,l,e),t(l,us,e),t(l,tl,e),t(l,fs,e),t(l,Ml,e),t(l,Is,e),t(l,al,e),t(l,As,e),t(l,nl,e),t(l,bs,e),U(il,l,e),t(l,_s,e),t(l,ol,e),t(l,Zs,e),U(yl,l,e),t(l,Gs,e),t(l,pl,e),t(l,gs,e),U(Ul,l,e),t(l,Bs,e),t(l,dl,e),t(l,vs,e),U(wl,l,e),t(l,ks,e),t(l,cl,e),t(l,Rs,e),U(rl,l,e),t(l,Ws,e),t(l,jl,e),t(l,Ns,e),U(Tl,l,e),t(l,Es,e),t(l,ml,e),t(l,Xs,e),t(l,Jl,e),t(l,Vs,e),U(Cl,l,e),t(l,$s,e),U(hl,l,e),t(l,xs,e),t(l,ul,e),t(l,Qs,e),U(fl,l,e),t(l,Ys,e),t(l,Il,e),t(l,zs,e),U(Al,l,e),t(l,Ss,e),t(l,bl,e),t(l,Hs,e),t(l,ke,e),t(l,Fs,e),t(l,_l,e),t(l,Ls,e),t(l,Zl,e),t(l,Os,e),U(Gl,l,e),t(l,Ds,e),t(l,gl,e),t(l,Ps,e),t(l,Bl,e),t(l,Ks,e),U(vl,l,e),t(l,qs,e),U(kl,l,e),t(l,lt,e),t(l,Rl,e),t(l,et,e),U(Wl,l,e),t(l,st,e),t(l,Nl,e),t(l,tt,e),U(El,l,e),t(l,Mt,e),t(l,Xl,e),t(l,at,e),U(Vl,l,e),t(l,nt,e),t(l,$l,e),t(l,it,e),t(l,xl,e),t(l,ot,e),U(Ql,l,e),t(l,yt,e),t(l,Yl,e),t(l,pt,e),U(zl,l,e),t(l,Ut,e),U(Sl,l,e),t(l,dt,e),t(l,Hl,e),t(l,wt,e),U(Fl,l,e),t(l,ct,e),U(Ll,l,e),t(l,rt,e),t(l,Ol,e),t(l,jt,e),U(Dl,l,e),t(l,Tt,e),t(l,Pl,e),t(l,mt,e),U(Kl,l,e),t(l,Jt,e),t(l,ql,e),t(l,Ct,e),t(l,le,e),t(l,ht,e),U(ee,l,e),t(l,ut,e),t(l,se,e),t(l,ft,e),U(te,l,e),t(l,It,e),t(l,Me,e),t(l,At,e),U(ae,l,e),t(l,bt,e),t(l,ne,e),t(l,_t,e),U(ie,l,e),t(l,Zt,e),t(l,oe,e),t(l,Gt,e),U(ye,l,e),t(l,gt,e),t(l,pe,e),t(l,Bt,e),U(Ue,l,e),t(l,vt,e),t(l,de,e),t(l,kt,e),t(l,we,e),t(l,Rt,e),U(ce,l,e),t(l,Wt,e),t(l,re,e),t(l,Nt,e),U(je,l,e),t(l,Et,e),t(l,Te,e),t(l,Xt,e),U(me,l,e),t(l,Vt,e),t(l,Je,e),t(l,$t,e),U(Ce,l,e),t(l,xt,e),t(l,he,e),t(l,Qt,e),U(ue,l,e),t(l,Yt,e),t(l,fe,e),t(l,zt,e),t(l,Ie,e),t(l,St,e),t(l,Ae,e),t(l,Ht,e),U(be,l,e),t(l,Ft,e),t(l,_e,e),t(l,Lt,e),U(Ze,l,e),t(l,Ot,e),t(l,Ge,e),t(l,Dt,e),U(ge,l,e),t(l,Pt,e),t(l,Be,e),t(l,Kt,e),U(ve,l,e),t(l,qt,e),t(l,We,e),lM=!0},p:Ia,i(l){lM||(d(m.$$.fragment,l),d(b.$$.fragment,l),d(v.$$.fragment,l),d(R.$$.fragment,l),d(V.$$.fragment,l),d(x.$$.fragment,l),d(Q.$$.fragment,l),d(S.$$.fragment,l),d(H.$$.fragment,l),d(L.$$.fragment,l),d(ll.$$.fragment,l),d(sl.$$.fragment,l),d(il.$$.fragment,l),d(yl.$$.fragment,l),d(Ul.$$.fragment,l),d(wl.$$.fragment,l),d(rl.$$.fragment,l),d(Tl.$$.fragment,l),d(Cl.$$.fragment,l),d(hl.$$.fragment,l),d(fl.$$.fragment,l),d(Al.$$.fragment,l),d(Gl.$$.fragment,l),d(vl.$$.fragment,l),d(kl.$$.fragment,l),d(Wl.$$.fragment,l),d(El.$$.fragment,l),d(Vl.$$.fragment,l),d(Ql.$$.fragment,l),d(zl.$$.fragment,l),d(Sl.$$.fragment,l),d(Fl.$$.fragment,l),d(Ll.$$.fragment,l),d(Dl.$$.fragment,l),d(Kl.$$.fragment,l),d(ee.$$.fragment,l),d(te.$$.fragment,l),d(ae.$$.fragment,l),d(ie.$$.fragment,l),d(ye.$$.fragment,l),d(Ue.$$.fragment,l),d(ce.$$.fragment,l),d(je.$$.fragment,l),d(me.$$.fragment,l),d(Ce.$$.fragment,l),d(ue.$$.fragment,l),d(be.$$.fragment,l),d(Ze.$$.fragment,l),d(ge.$$.fragment,l),d(ve.$$.fragment,l),lM=!0)},o(l){w(m.$$.fragment,l),w(b.$$.fragment,l),w(v.$$.fragment,l),w(R.$$.fragment,l),w(V.$$.fragment,l),w(x.$$.fragment,l),w(Q.$$.fragment,l),w(S.$$.fragment,l),w(H.$$.fragment,l),w(L.$$.fragment,l),w(ll.$$.fragment,l),w(sl.$$.fragment,l),w(il.$$.fragment,l),w(yl.$$.fragment,l),w(Ul.$$.fragment,l),w(wl.$$.fragment,l),w(rl.$$.fragment,l),w(Tl.$$.fragment,l),w(Cl.$$.fragment,l),w(hl.$$.fragment,l),w(fl.$$.fragment,l),w(Al.$$.fragment,l),w(Gl.$$.fragment,l),w(vl.$$.fragment,l),w(kl.$$.fragment,l),w(Wl.$$.fragment,l),w(El.$$.fragment,l),w(Vl.$$.fragment,l),w(Ql.$$.fragment,l),w(zl.$$.fragment,l),w(Sl.$$.fragment,l),w(Fl.$$.fragment,l),w(Ll.$$.fragment,l),w(Dl.$$.fragment,l),w(Kl.$$.fragment,l),w(ee.$$.fragment,l),w(te.$$.fragment,l),w(ae.$$.fragment,l),w(ie.$$.fragment,l),w(ye.$$.fragment,l),w(Ue.$$.fragment,l),w(ce.$$.fragment,l),w(je.$$.fragment,l),w(me.$$.fragment,l),w(Ce.$$.fragment,l),w(ue.$$.fragment,l),w(be.$$.fragment,l),w(Ze.$$.fragment,l),w(ge.$$.fragment,l),w(ve.$$.fragment,l),lM=!1},d(l){l&&(s(Ne),s(Re),s(Ee),s(Xe),s(J),s(Ve),s(C),s($e),s(h),s(xe),s(u),s(Qe),s(f),s(Ye),s(I),s(ze),s(A),s(Se),s(He),s(_),s(Fe),s(Z),s(Le),s(G),s(Oe),s(g),s(De),s(B),s(Pe),s(Ke),s(k),s(qe),s(ls),s(W),s(es),s(N),s(ss),s(E),s(ts),s(X),s(Ms),s(as),s($),s(ns),s(is),s(os),s(Y),s(ys),s(z),s(ps),s(Us),s(ds),s(F),s(ws),s(cs),s(O),s(rs),s(D),s(js),s(P),s(Ts),s(K),s(ms),s(q),s(Js),s(Cs),s(el),s(hs),s(us),s(tl),s(fs),s(Ml),s(Is),s(al),s(As),s(nl),s(bs),s(_s),s(ol),s(Zs),s(Gs),s(pl),s(gs),s(Bs),s(dl),s(vs),s(ks),s(cl),s(Rs),s(Ws),s(jl),s(Ns),s(Es),s(ml),s(Xs),s(Jl),s(Vs),s($s),s(xs),s(ul),s(Qs),s(Ys),s(Il),s(zs),s(Ss),s(bl),s(Hs),s(ke),s(Fs),s(_l),s(Ls),s(Zl),s(Os),s(Ds),s(gl),s(Ps),s(Bl),s(Ks),s(qs),s(lt),s(Rl),s(et),s(st),s(Nl),s(tt),s(Mt),s(Xl),s(at),s(nt),s($l),s(it),s(xl),s(ot),s(yt),s(Yl),s(pt),s(Ut),s(dt),s(Hl),s(wt),s(ct),s(rt),s(Ol),s(jt),s(Tt),s(Pl),s(mt),s(Jt),s(ql),s(Ct),s(le),s(ht),s(ut),s(se),s(ft),s(It),s(Me),s(At),s(bt),s(ne),s(_t),s(Zt),s(oe),s(Gt),s(gt),s(pe),s(Bt),s(vt),s(de),s(kt),s(we),s(Rt),s(Wt),s(re),s(Nt),s(Et),s(Te),s(Xt),s(Vt),s(Je),s($t),s(xt),s(he),s(Qt),s(Yt),s(fe),s(zt),s(Ie),s(St),s(Ae),s(Ht),s(Ft),s(_e),s(Lt),s(Ot),s(Ge),s(Dt),s(Pt),s(Be),s(Kt),s(qt),s(We)),s(T),c(m,l),c(b,l),c(v,l),c(R,l),c(V,l),c(x,l),c(Q,l),c(S,l),c(H,l),c(L,l),c(ll,l),c(sl,l),c(il,l),c(yl,l),c(Ul,l),c(wl,l),c(rl,l),c(Tl,l),c(Cl,l),c(hl,l),c(fl,l),c(Al,l),c(Gl,l),c(vl,l),c(kl,l),c(Wl,l),c(El,l),c(Vl,l),c(Ql,l),c(zl,l),c(Sl,l),c(Fl,l),c(Ll,l),c(Dl,l),c(Kl,l),c(ee,l),c(te,l),c(ae,l),c(ie,l),c(ye,l),c(Ue,l),c(ce,l),c(je,l),c(me,l),c(Ce,l),c(ue,l),c(be,l),c(Ze,l),c(ge,l),c(ve,l)}}}const Ra='{"title":"Modular transformers","local":"modular-transformers","sections":[{"title":"What is it?","local":"what-is-it","sections":[{"title":"Details","local":"details","sections":[],"depth":3},{"title":"Enforcement","local":"enforcement","sections":[],"depth":3},{"title":"Examples","local":"examples","sections":[],"depth":3}],"depth":2},{"title":"What it is not","local":"what-it-is-not","sections":[],"depth":2},{"title":"Real world example breakdown","local":"real-world-example-breakdown","sections":[{"title":"Config class","local":"config-class","sections":[],"depth":3},{"title":"Norm class","local":"norm-class","sections":[],"depth":3},{"title":"Attention class","local":"attention-class","sections":[],"depth":3},{"title":"The DecoderLayer class","local":"the-decoderlayer-class","sections":[],"depth":3},{"title":"The Model class","local":"the-model-class","sections":[],"depth":3},{"title":"Finally… The ForCausalLM class","local":"finally-the-forcausallm-class","sections":[],"depth":3}],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Removing attributes which are not just assignments","local":"removing-attributes-which-are-not-just-assignments","sections":[],"depth":3},{"title":"Avoiding super() special meaning","local":"avoiding-super-special-meaning","sections":[],"depth":3},{"title":"Deleting unused methods","local":"deleting-unused-methods","sections":[],"depth":3},{"title":"Define new functions","local":"define-new-functions","sections":[],"depth":3},{"title":"Decorators","local":"decorators","sections":[],"depth":3},{"title":"The super_kwargs special case","local":"the-superkwargs-special-case","sections":[],"depth":3},{"title":"The DOCSTRING variables","local":"the-docstring-variables","sections":[],"depth":3}],"depth":2},{"title":"Limitations","local":"limitations","sections":[{"title":"Special naming (essentially for multimodal models)","local":"special-naming-essentially-for-multimodal-models","sections":[],"depth":3},{"title":"Automatic docstrings issue (mostly for Configs)","local":"automatic-docstrings-issue-mostly-for-configs","sections":[],"depth":3}],"depth":2}],"depth":1}';function Wa(tM){return Aa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $a extends ba{constructor(T){super(),_a(this,T,Wa,ka,fa,{})}}export{$a as component};
