import{s as aM,o as nM,n as ut}from"../chunks/scheduler.37c15a92.js";import{S as pM,i as MM,g as p,s as a,r,A as iM,h as M,f as t,c as n,j as tM,u as J,x as i,k as sM,y as rM,a as s,v as m,d as y,t as c,w as d}from"../chunks/index.2bf4358c.js";import{T as Tt}from"../chunks/Tip.363c041f.js";import{Y as JM}from"../chunks/Youtube.1e50a667.js";import{C as w}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as mM}from"../chunks/CourseFloatingBanner.06521e8b.js";import{F as yM}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as b}from"../chunks/Heading.8ada512a.js";function cM(u){let j,o="✏️ <strong>Ваша очередь!</strong> Проверьте, все ли правильно со вторым элементом обучающего набора данных.";return{c(){j=p("p"),j.innerHTML=o},l(U){j=M(U,"P",{"data-svelte-h":!0}),i(j)!=="svelte-453sg9"&&(j.innerHTML=o)},m(U,T){s(U,j,T)},p:ut,d(U){U&&t(j)}}}function dM(u){let j,o="В следующей части курса мы рассмотрим более продвинутые техники, которые помогут вам уменьшить объем занимаемой памяти и позволят точно настроить самые большие модели.";return{c(){j=p("p"),j.textContent=o},l(U){j=M(U,"P",{"data-svelte-h":!0}),i(j)!=="svelte-3zd7su"&&(j.textContent=o)},m(U,T){s(U,j,T)},p:ut,d(U){U&&t(j)}}}function jM(u){let j,o="💡 Перед запуском <code>trainer.train()</code> всегда следует убедиться, что вы можете запустить <code>trainer.evaluate()</code>, чтобы не тратить много вычислительных ресурсов до того, как столкнетесь с ошибкой.";return{c(){j=p("p"),j.innerHTML=o},l(U){j=M(U,"P",{"data-svelte-h":!0}),i(j)!=="svelte-1942v49"&&(j.innerHTML=o)},m(U,T){s(U,j,T)},p:ut,d(U){U&&t(j)}}}function wM(u){let j,o="💡 Если вы используете ручной цикл обучения, для отладки пайплайна обучения применимы те же шаги, но их проще разделить. Убедитесь, что вы не забыли <code>model.eval()</code> или <code>model.train()</code> в нужных местах, или <code>zero_grad()</code> на каждом шаге!";return{c(){j=p("p"),j.innerHTML=o},l(U){j=M(U,"P",{"data-svelte-h":!0}),i(j)!=="svelte-1gym4dk"&&(j.innerHTML=o)},m(U,T){s(U,j,T)},p:ut,d(U){U&&t(j)}}}function UM(u){let j,o="⚠️ Если вы проводите распределенное обучение, распечатайте образцы набора данных в каждом процессе и трижды проверьте, что вы получаете одно и то же. Одна из распространенных ошибок - наличие некоторого источника случайности при создании данных, из-за которого каждый процесс имеет свою версию набора данных.";return{c(){j=p("p"),j.textContent=o},l(U){j=M(U,"P",{"data-svelte-h":!0}),i(j)!=="svelte-12z68zh"&&(j.textContent=o)},m(U,T){s(U,j,T)},p:ut,d(U){U&&t(j)}}}function oM(u){let j,o="💡 Если ваши обучающие данные несбалансированы, обязательно создайте батч обучающих данных, содержащий все метки.";return{c(){j=p("p"),j.textContent=o},l(U){j=M(U,"P",{"data-svelte-h":!0}),i(j)!=="svelte-w8su75"&&(j.textContent=o)},m(U,T){s(U,j,T)},p:ut,d(U){U&&t(j)}}}function TM(u){let j,o="⚠️ Вам придется пересоздать модель и <code>Trainer</code> после этого теста на переобучение, поскольку полученная модель, вероятно, не сможет восстановиться и научиться чему-то полезному на полном наборе данных.";return{c(){j=p("p"),j.innerHTML=o},l(U){j=M(U,"P",{"data-svelte-h":!0}),i(j)!=="svelte-6bq32q"&&(j.innerHTML=o)},m(U,T){s(U,j,T)},p:ut,d(U){U&&t(j)}}}function uM(u){let j,o,U,T,h,ht,X,ft,W,$t,R,bn='Вы написали прекрасный сценарий для обучения или дообучения модели на заданной задаче, послушно следуя советам из <a href="/course/chapter7/1">Главы 7</a>. Но когда вы запускаете команду <code>model.fit()</code>, происходит нечто ужасное: вы получаете ошибку 😱! Или, что еще хуже, все вроде бы хорошо, обучение проходит без ошибок, но результирующая модель получается плохой. В этом разделе мы покажем вам, что можно сделать для отладки подобных проблем.',Ct,g,Zt,G,It,v,hn="Проблема, когда вы сталкиваетесь с ошибкой в <code>trainer.train()</code>, заключается в том, что она может возникнуть из нескольких источников, поскольку <code>Trainer</code> обычно собирает вместе множество вещей. Он преобразует наборы данных в загрузчики данных, поэтому проблема может заключаться в том, что в вашем наборе данных что-то не так, или в том, что вы пытаетесь объединить элементы наборов данных в батч. Затем он берет батч данных и подает его в модель, так что проблема может быть в коде модели. После этого вычисляются градиенты и выполняется этап оптимизации, так что проблема может быть и в вашем оптимизаторе. И даже если во время обучения все идет хорошо, во время валидации все равно что-то может пойти не так, если проблема в метрике.",kt,V,fn="Лучший способ отладить ошибку, возникшую в <code>trainer.train()</code>, - это вручную пройти весь пайплайн и посмотреть, где все пошло не так. В этом случае ошибку часто очень легко устранить.",Bt,_,$n='Чтобы продемонстрировать это, мы используем следующий скрипт, который (пытается) точно настроить модель DistilBERT на наборе данных <a href="https://huggingface.co/datasets/glue" rel="nofollow">MNLI dataset</a>:',Xt,x,Wt,Q,Cn="Если вы попытаетесь выполнить его, то столкнетесь с довольно загадочной ошибкой:",Rt,Y,gt,F,Gt,A,Zn="Это может быть очевидно, но если ваши данные повреждены, <code>Trainer</code> не сможет сформировать батчи, не говоря уже об обучении вашей модели. Поэтому прежде всего необходимо посмотреть, что находится в вашем обучающем наборе.",vt,H,In="Чтобы избежать бесчисленных часов, потраченных на попытки исправить то, что не является источником ошибки, мы рекомендуем использовать <code>trainer.train_dataset</code> для проверок и ничего больше. Так что давайте сделаем это здесь:",Vt,z,_t,E,xt,N,kn="Вы заметили что-то неладное? В сочетании с сообщением об ошибке <code>input_ids</code>, вы должны понять, что это тексты, а не числа, которые модель может понять. Здесь исходная ошибка вводит в заблуждение, потому что <code>Trainer</code> автоматически удаляет столбцы, которые не соответствуют сигнатуре модели (то есть аргументам, ожидаемым моделью). Это означает, что здесь было удалено все, кроме меток. Таким образом, не было никаких проблем с созданием батчей и отправкой их модели, которая, в свою очередь, жаловалась, что не получила нужных входных данных.",Qt,S,Bn="Почему данные не обрабатывались? Мы действительно использовали метод <code>Dataset.map()</code> для наборов данных, чтобы применить токенизатор к каждой выборке. Но если вы внимательно посмотрите на код, то увидите, что мы допустили ошибку при передаче обучающего и валидационного наборов в <code>Trainer</code>. Вместо того чтобы использовать <code>tokenized_datasets</code>, мы использовали <code>raw_datasets</code> 🤦. Так что давайте исправим это!",Yt,q,Ft,L,Xn="Теперь этот новый код будет выдавать другую ошибку (прогресс!):",At,D,Ht,P,Wn="Посмотрев на трассировку, мы видим, что ошибка происходит на этапе сборки данных:",zt,K,Et,O,Rn="Поэтому нам следует перейти к этому. Однако перед этим давайте закончим проверку наших данных, чтобы быть на 100% уверенными в их правильности.",Nt,ll,gn="При отладке обучения всегда нужно смотреть на декодированные входы модели. Мы не можем понять смысл чисел, которые подаем ей напрямую, поэтому мы должны посмотреть, что эти числа представляют. В компьютерном зрении, например, это означает просмотр декодированных изображений пройденных пикселей, в речи - прослушивание декодированных образцов звука, а в нашем примере с NLP - использование нашего токенизатора для декодирования входных данных:",St,el,qt,tl,Lt,sl,Gn="Так что, похоже, все правильно. Вы должны сделать это для всех ключей во входах:",Dt,al,Pt,nl,Kt,pl,vn="Обратите внимание, что ключи, не соответствующие входам, принимаемым моделью, будут автоматически отброшены, поэтому здесь мы оставим только <code>input_ids</code>, <code>attention_mask</code> и <code>label</code> (которая будет переименована в <code>labels</code>). Чтобы перепроверить сигнатуру модели, вы можете вывести класс вашей модели, а затем проверить ее документацию:",Ot,Ml,ls,il,es,rl,Vn='Итак, в нашем случае мы можем проверить принятые параметры на <a href="https://huggingface.co/transformers/model_doc/distilbert.html#distilbertforsequenceclassification" rel="nofollow">этой странице</a>. “Trainer” также будет регистрировать столбцы, которые он отбрасывает.',ts,Jl,_n="Мы проверили правильность входных идентификаторов, декодировав их. Далее находится <code>attention_mask</code>:",ss,ml,as,yl,ns,cl,xn="Так как мы не применяли в препроцессинге дополнение нулями, это кажется совершенно естественным. Чтобы убедиться в отсутствии проблем с этой маской внимания, давайте проверим, что она имеет ту же длину, что и наши входные идентификаторы:",ps,dl,Ms,jl,is,wl,Qn="Это хорошо! И наконец, давайте проверим нашу метку класса:",rs,Ul,Js,ol,ms,Tl,Yn="Как и входные идентификаторы, это число, которое само по себе не имеет смысла. Как мы уже видели, соответствие между целыми числами и именами меток хранится в атрибуте <code>names</code> соответствующей <em>функции</em> набора данных:",ys,ul,cs,bl,ds,hl,Fn="Итак, <code>1</code> означает <code>нейтральный</code>, а значит, два предложения, которые мы видели выше, не противоречат друг другу, и из первого не следует второе. Это кажется правильным!",js,fl,An="Здесь у нас нет идентификаторов типов токенов, поскольку DistilBERT их не ожидает; если в вашей модели они есть, вам также следует убедиться, что они правильно соответствуют месту первого и второго предложений во входных данных.",ws,f,Us,$l,Hn="В данном случае мы проверяем только обучающий набор, но, конечно, вы должны дважды проверить валидационный и тестовый наборы таким же образом.",os,Cl,zn="Теперь, когда мы знаем, что наши наборы данных выглядят хорошо, пришло время проверить следующий этап пайплайна обучения.",Ts,Zl,us,Il,En="Следующее, что может пойти не так в пайплайне обучения, - это когда <code>Trainer</code> пытается сформировать батчи из обучающего или проверочного набора. Убедившись, что наборы данных <code>Trainer</code> корректны, можно попробовать вручную сформировать батч, выполнив следующие действия (замените <code>train</code> на <code>eval</code> для валидационного загрузчика данных):",bs,kl,hs,Bl,Nn="Этот код создает загрузчик данных для обучения, затем выполняет итерации по нему, останавливаясь на первой итерации. Если код выполняется без ошибок, у вас есть первый обучающий батч, который можно проверить, а если код выдает ошибку, вы точно знаете, что проблема в загрузчике данных, как в данном случае:",fs,Xl,$s,Wl,Sn="Осмотра последнего кадра трассировки должно быть достаточно, чтобы дать вам подсказку, но давайте покопаемся еще немного. Большинство проблем при создании батчей возникает из-за объединения примеров в один батч, поэтому первое, что нужно проверить при возникновении сомнений, это то, какой <code>collate_fn</code> использует ваш <code>DataLoader</code>:",Cs,Rl,Zs,gl,Is,Gl,qn="Этот <code>default_data_collator</code>  не то, что нам нужно в данном случае. Мы хотим разбить наши примеры на самые длинные предложения в пакете, что делает <code>DataCollatorWithPadding</code>. И этот класс данных должен использоваться по умолчанию в <code>Trainer</code>, так почему же он не используется здесь?",ks,vl,Ln="Ответ заключается в том, что мы не передали <code>tokenizer</code> в <code>Trainer</code>, поэтому он не смог создать нужный нам <code>DataCollatorWithPadding</code>. На практике вам никогда не следует стесняться явно передавать data collator, который вы хотите использовать, чтобы избежать подобных ошибок. Давайте адаптируем наш код, чтобы сделать именно это:",Bs,Vl,Xs,_l,Dn="Хорошие новости? Мы не получаем ту же ошибку, что и раньше, что, безусловно, является прогрессом. Плохие новости? Вместо нее мы получаем печально известную ошибку CUDA:",Ws,xl,Rs,Ql,Pn="Это плохо, потому что ошибки CUDA вообще очень трудно отлаживать. Через минуту мы увидим, как решить эту проблему, но сначала давайте закончим анализ создания батчей.",gs,Yl,Kn="Если вы уверены, что ваш data collator правильный, попробуйте применить его на паре примеров вашего набора данных:",Gs,Fl,vs,Al,On="Этот код не сработает, потому что <code>train_dataset</code> содержит строковые колонки, которые <code>Trainer</code> обычно удаляет. Вы можете удалить их вручную, или, если вы хотите в точности повторить то, что <code>Trainer</code> делает за кулисами: нужно вызвать приватный метод <code>Trainer._remove_unused_columns()</code>, который делает это:",Vs,Hl,_s,zl,lp="Если ошибка не исчезнет, вы сможете вручную отладить, что происходит внутри data collator.",xs,El,ep="Теперь, когда мы отладили процесс создания батча, пришло время пропустить его через модель!",Qs,Nl,Ys,Sl,tp="Вы должны иметь возможность получить батч, выполнив следующую команду:",Fs,ql,As,Ll,sp="Если вы выполняете этот код в ноутбуке, вы можете получить ошибку CUDA, похожую на ту, что мы видели ранее, и в этом случае вам нужно перезапустить ноутбук и заново выполнить последний фрагмент без строки <code>trainer.train()</code>. Это вторая самая неприятная вещь в ошибках CUDA: они безвозвратно ломают ваше ядро. Самое неприятное в них то, что их трудно отлаживать.",Hs,Dl,ap="Почему? Это связано с тем, как работают графические процессоры. Они чрезвычайно эффективны при параллельном выполнении множества операций, но их недостаток в том, что когда одна из этих инструкций приводит к ошибке, вы не сразу об этом узнаете. Только когда программа вызовет синхронизацию нескольких процессов на GPU, она поймет, что что-то пошло не так, поэтому ошибка возникает в том месте, которое не имеет никакого отношения к тому, что ее создало. Например, если мы посмотрим на наш предыдущий трассировочный откат, ошибка была вызвана во время обратного прохода, но через минуту мы увидим, что на самом деле она возникла из-за чего-то в прямом проходе через модель.",zs,Pl,np="Так как же отладить эти ошибки? Ответ прост: никак. Если только ошибка CUDA не является ошибкой вне памяти (что означает, что в вашем GPU недостаточно памяти), вы всегда должны возвращаться к CPU, чтобы отладить ее.",Es,Kl,pp="Чтобы сделать это в нашем случае, нам просто нужно вернуть модель на CPU и вызвать ее на нашем пакете - пакет, возвращаемый <code>DataLoader</code>, еще не был перемещен на GPU:",Ns,Ol,Ss,le,qs,ee,Mp="Итак, картина проясняется. Вместо ошибки CUDA у нас теперь <code>IndexError</code> при вычислении функции потерь (так что обратный проход, как мы уже говорили, здесь ни при чем). Точнее, мы видим, что ошибка возникает именно в метке класса 2, так что это очень хороший момент для проверки количества меток нашей модели:",Ls,te,Ds,se,Ps,ae,ip="При двух метках в качестве значений допускаются только 0 и 1, но, согласно сообщению об ошибке, мы получили 2. Получение 2 на самом деле нормально: если мы помним имена меток, которые мы извлекли ранее, их было три, поэтому в нашем наборе данных есть индексы 0, 1 и 2. Проблема в том, что мы не сообщили об этом нашей модели, которая должна была быть создана с тремя метками. Так что давайте это исправим!",Ks,ne,Os,pe,rp="Мы пока не включаем строку <code>trainer.train()</code>, чтобы потратить время на проверку того, что все выглядит хорошо. Если мы запросим батч и передадим ее нашей модели, то теперь она работает без ошибок!",la,Me,ea,ie,Jp="Следующим шагом будет возвращение к графическому процессору и проверка того, что все по-прежнему работает:",ta,re,sa,Je,mp="Если вы все еще получаете ошибку, убедитесь, что перезагрузили ноутбук и выполнили только последнюю версию скрипта.",aa,me,na,ye,yp="Теперь, когда мы знаем, что можем создавать батчи, которые действительно проходят через модель без ошибок, мы готовы к следующему шагу пайплайна обучения: вычислению градиентов и выполнению шага оптимизации.",pa,ce,cp="Первая часть заключается в вызове метода <code>backward()</code> для функции потерь:",Ma,de,ia,je,dp="Ошибки на этом этапе возникают довольно редко, но если они все же возникнут, обязательно вернитесь к процессору, чтобы получить полезное сообщение об ошибке.",ra,we,jp="Чтобы выполнить шаг оптимизации, нам нужно просто создать <code>optimizer</code> и вызвать его метод <code>step()</code>:",Ja,Ue,ma,oe,wp="Опять же, если вы используете оптимизатор по умолчанию в <code>Trainer</code>, вы не должны получить ошибку на этом этапе, но если вы используете собственный оптимизатор, здесь могут возникнуть некоторые проблемы для отладки. Не забудьте вернуться к процессору, если на этом этапе вы получите странную ошибку CUDA. Говоря об ошибках CUDA, ранее мы упоминали особый случай. Давайте посмотрим на него сейчас.",ya,Te,ca,ue,Up="Если вы получаете сообщение об ошибке, начинающееся с <code>RuntimeError: CUDA out of memory</code>, это означает, что вам не хватает памяти GPU. Это не связано напрямую с вашим кодом, и может произойти со скриптом, который работает совершенно нормально. Эта ошибка означает, что вы пытались поместить слишком много данных во внутреннюю память вашего GPU, и это привело к ошибке. Как и в случае с другими ошибками CUDA, вам придется перезапустить ядро, чтобы снова запустить обучение.",da,be,op="Чтобы решить эту проблему, нужно просто использовать меньше памяти на GPU - что зачастую легче сказать, чем сделать. Во-первых, убедитесь, что у вас нет двух моделей на GPU одновременно (если, конечно, это не требуется для решения вашей задачи). Затем, вероятно, следует уменьшить размер батча, поскольку он напрямую влияет на размеры всех промежуточных выходов модели и их градиентов. Если проблема сохраняется, подумайте о том, чтобы использовать меньшую версию модели.",ja,$,wa,he,Ua,fe,Tp="Теперь, когда мы решили все проблемы с нашим кодом, все идеально, и обучение должно пройти гладко, верно? Не так быстро! Если вы запустите команду <code>trainer.train()</code>, сначала все будет выглядеть хорошо, но через некоторое время вы получите следующее:",oa,$e,Ta,Ce,ua,Ze,up="Вы поймете, что эта ошибка появляется во время фазы валидации, так что это последнее, что нам нужно будет отладить.",ba,Ie,bp="Вы можете запустить цикл оценки <code>Trainer</code> независимо от обучения следующим образом:",ha,ke,fa,Be,$a,C,Ca,Xe,hp="Прежде чем пытаться отладить проблему в цикле валидации, нужно сначала убедиться, что вы посмотрели на данные, смогли правильно сформировать батч и запустить на нем свою модель. Мы выполнили все эти шаги, поэтому следующий код может быть выполнен без ошибок:",Za,We,Ia,Re,fp="Ошибка возникает позже, в конце фазы валидации, и если мы посмотрим на трассировку, то увидим следующее:",ka,ge,Ba,Ge,$p="Это говорит нам о том, что ошибка возникает в модуле <code>datasets/metric.py</code> - так что это проблема с нашей функцией <code>compute_metrics()</code>. Она принимает кортеж с логитами и метками в виде массивов NumPy, так что давайте попробуем скормить ей это:",Xa,ve,Wa,Ve,Ra,_e,Cp="Мы получаем ту же ошибку, так что проблема определенно кроется в этой функции. Если мы посмотрим на ее код, то увидим, что она просто передает <code>predictions</code> и <code>labels</code> в <code>metric.compute()</code>. Так есть ли проблема в этом методе? На самом деле нет. Давайте посмотрим на размерности:",ga,xe,Ga,Qe,va,Ye,Zp="Наши предсказания все еще являются логитами, а не реальными предсказаниями, поэтому метрика возвращает эту (несколько непонятную) ошибку. Исправить это довольно просто: нужно просто добавить argmax в функцию <code>compute_metrics()</code>:",Va,Fe,_a,Ae,xa,He,Ip="Теперь наша ошибка исправлена! Она была последней, поэтому теперь наш скрипт будет правильно обучать модель.",Qa,ze,kp="Для справки, вот полностью исправленный скрипт:",Ya,Ee,Fa,Ne,Bp="В этом случае проблем больше нет, и наш скрипт обучит модель, которая должна дать приемлемые результаты. Но что делать, если обучение проходит без ошибок, а обученная модель совсем не работает? Это самая сложная часть машинного обучения, и мы покажем вам несколько приемов, которые могут помочь.",Aa,Z,Ha,Se,za,qe,Xp="Что можно сделать, чтобы отладить обучение, которое завершается без ошибок, но не дает хороших результатов? Мы дадим вам несколько советов, но имейте в виду, что такая отладка - самая сложная часть машинного обучения, и волшебного ответа на этот вопрос не существует.",Ea,Le,Na,De,Wp="Ваша модель научится чему-то только в том случае, если из ваших данных действительно можно чему-то научиться. Если в данных есть ошибка, которая портит их, или метки приписаны случайным образом, то, скорее всего, вы не сможете обучить модель на своем наборе данных. Поэтому всегда начинайте с перепроверки декодированных входных данных и меток и задавайте себе следующие вопросы:",Sa,Pe,Rp="<li>Понятны ли декодированные данные?</li> <li>Правильные ли метки?</li> <li>Есть ли одна метка, которая встречается чаще других?</li> <li>Каким должно быть значение функции потерь/метрики если модель предсказала случайный ответ/всегда один и тот же ответ?</li>",qa,I,La,Ke,gp="Просмотрев данные, проанализируйте несколько предсказаний модели и декодируйте их. Если модель постоянно предсказывает одно и то же, это может быть связано с тем, что ваш набор данных смещен в сторону одной категории (для проблем классификации); здесь могут помочь такие методы, как oversampling редких классов.",Da,Oe,Gp="Если значения функции потерь/метрики, которые вы получаете на начальной модели, сильно отличаются от значений функции потерь/метрик, которые можно было бы ожидать для случайных предсказаний, перепроверьте способ вычисления потерь или метрик, так как, возможно, в них есть ошибка. Если вы используете несколько функций потерь, убедитесь, что они имеют одинаковый масштаб.",Pa,lt,vp="Когда вы убедитесь, что ваши данные идеальны, вы можете проверить, способна ли модель обучаться на них, с помощью одного простого теста.",Ka,et,Oa,tt,Vp="Обычно мы стараемся избегать переобучения при тренировке модели, поскольку это означает, что модель не учится распознавать общие характеристики, а просто запоминает обучающие выборки. Однако попытка обучить модель на одной выборке снова и снова - это хороший тест, позволяющий проверить, может ли проблема в том виде, в котором вы ее сформулировали, быть решена с помощью модели, которую вы пытаетесь обучить. Это также поможет вам понять, не слишком ли высока ваша начальная скорость обучения.",ln,st,_p="Сделать это после того, как вы определили свой <code>Trainer</code>, очень просто: просто возьмите батч обучающих данных, а затем запустите небольшой цикл ручного обучения, используя только этот батч в течение примерно 20 шагов:",en,at,tn,k,sn,nt,xp="Результирующая модель должна иметь близкие к идеальным результаты на одном и том же батче. Вычислим метрику по полученным предсказаниям:",an,pt,nn,Mt,pn,it,Qp="Точность 100 %, вот это хороший пример переобучения (это значит, что если вы попробуете использовать модель на любом другом предложении, она, скорее всего, даст вам неправильный ответ)!",Mn,rt,Yp="Если вам не удается добиться от модели таких идеальных результатов, значит, что-то не так с постановкой задачи или данными, и вам следует это исправить. Только когда вам удастся пройти тест на переобучение, вы сможете быть уверены, что ваша модель действительно способна чему-то научиться.",rn,B,Jn,Jt,mn,mt,Fp="Настройка гиперпараметров всегда считается самой сложной частью машинного обучения, но это всего лишь последний шаг, который поможет вам немного улучшить метрику. В большинстве случаев гиперпараметры по умолчанию <code>Trainer</code> будут работать нормально и давать вам хорошие результаты, поэтому не приступайте к трудоемкому и дорогостоящему поиску гиперпараметров, пока у вас не будет чего-то, что превосходит базовый уровень, который у вас есть в вашем наборе данных.",yn,yt,Ap="Как только у вас будет достаточно хорошая модель, вы можете начать ее немного оптимизировать. Не пытайтесь запустить тысячу раз с разными гиперпараметрами, но сравните пару запусков с разными значениями одного гиперпараметра, чтобы получить представление о том, какой из них оказывает наибольшее влияние.",cn,ct,Hp="Если вы настраиваете саму модель, будьте проще и не пробуйте то, что не можете обосновать. Всегда возвращайтесь к тесту на перебор, чтобы проверить, не привело ли ваше изменение к каким-либо непредвиденным последствиям.",dn,dt,jn,jt,zp='Надеемся, вы нашли в этом разделе советы, которые помогли вам решить вашу проблему, но если это не так, помните, что вы всегда можете спросить у сообщества на <a href="https://discuss.huggingface.co/" rel="nofollow">форумах</a>.',wn,wt,Ep="Вот некоторые дополнительные ресурсы, которые могут оказаться полезными:",Un,Ut,Np='<li><a href="https://docs.google.com/presentation/d/1yHLPvPhUs2KGI5ZWo0sU-PKU3GimAk3iTsI38Z-B5Gw/edit#slide=id.p" rel="nofollow">” Reproducibility as a vehicle for engineering best practices”</a> by Joel Grus</li> <li><a href="https://towardsdatascience.com/checklist-for-debugging-neural-networks-d8b2a9434f21" rel="nofollow">“Checklist for debugging neural networks”</a> by Cecelia Shao</li> <li><a href="https://medium.com/@keeper6928/how-to-unit-test-machine-learning-code-57cf6fd81765" rel="nofollow">” How to unit test machine learning code”</a> by Chase Roberts</li> <li><a href="http://karpathy.github.io/2019/04/25/recipe/" rel="nofollow">&quot;&quot;A Recipe for Training Neural Networks”</a> by Andrej Karpathy</li>',on,ot,Sp="Конечно, не все проблемы, с которыми вы сталкиваетесь при обучении нейросетей, возникают по вашей вине! Если в библиотеке 🤗 Transformers или 🤗 Datasets вы столкнулись с чем-то, что кажется вам неправильным, возможно, вы обнаружили ошибку. Вам обязательно нужно рассказать нам об этом, и в следующем разделе мы объясним, как именно это сделать.",Tn,bt,un;return h=new yM({props:{fw:u[0]}}),X=new b({props:{title:"Отладка обучения",local:"debugging-the-training-pipeline",headingTag:"h1"}}),W=new mM({props:{chapter:8,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter8/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter8/section4.ipynb"}]}}),g=new b({props:{title:"Отладка обучающего пайплайна",local:"debugging-the-training-pipeline",headingTag:"h2"}}),G=new JM({props:{id:"L-WSwUWde1U"}}),x=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=raw_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=raw_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),Y=new w({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBZb3UlMjBoYXZlJTIwdG8lMjBzcGVjaWZ5JTIwZWl0aGVyJTIwaW5wdXRfaWRzJTIwb3IlMjBpbnB1dHNfZW1iZWRzJw==",highlighted:'<span class="hljs-string">&#x27;ValueError: You have to specify either input_ids or inputs_embeds&#x27;</span>',wrap:!1}}),F=new b({props:{title:"Проверка данных",local:"check-your-data",headingTag:"h3"}}),z=new w({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RA==",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),E=new w({props:{code:"JTdCJ2h5cG90aGVzaXMnJTNBJTIwJ1Byb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHklMjBhcmUlMjB3aGF0JTIwbWFrZSUyMGNyZWFtJTIwc2tpbW1pbmclMjB3b3JrLiUyMCclMkMlMEElMjAnaWR4JyUzQSUyMDAlMkMlMEElMjAnbGFiZWwnJTNBJTIwMSUyQyUwQSUyMCdwcmVtaXNlJyUzQSUyMCdDb25jZXB0dWFsbHklMjBjcmVhbSUyMHNraW1taW5nJTIwaGFzJTIwdHdvJTIwYmFzaWMlMjBkaW1lbnNpb25zJTIwLSUyMHByb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHkuJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;hypothesis&#x27;</span>: <span class="hljs-string">&#x27;Product and geography are what make cream skimming work. &#x27;</span>,
 <span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;premise&#x27;</span>: <span class="hljs-string">&#x27;Conceptually cream skimming has two basic dimensions - product and geography.&#x27;</span>}`,wrap:!1}}),q=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwZXZhbHVhdGUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMEF1dG9Ub2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwVHJhaW5pbmdBcmd1bWVudHMlMkMlMEElMjAlMjAlMjAlMjBUcmFpbmVyJTJDJTBBKSUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybW5saSUyMiklMEElMEFtb2RlbF9jaGVja3BvaW50JTIwJTNEJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHByZXByb2Nlc3NfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGVzJTVCJTIycHJlbWlzZSUyMiU1RCUyQyUyMGV4YW1wbGVzJTVCJTIyaHlwb3RoZXNpcyUyMiU1RCUyQyUyMHRydW5jYXRpb24lM0RUcnVlKSUwQSUwQSUwQXRva2VuaXplZF9kYXRhc2V0cyUyMCUzRCUyMHJhd19kYXRhc2V0cy5tYXAocHJlcHJvY2Vzc19mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfY2hlY2twb2ludCklMEElMEFhcmdzJTIwJTNEJTIwVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwZiUyMmRpc3RpbGJlcnQtZmluZXR1bmVkLW1ubGklMjIlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEMmUtNSUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QzJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEMC4wMSUyQyUwQSklMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtbmxpJTIyKSUwQSUwQSUwQWRlZiUyMGNvbXB1dGVfbWV0cmljcyhldmFsX3ByZWQpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBtZXRyaWMuY29tcHV0ZShwcmVkaWN0aW9ucyUzRHByZWRpY3Rpb25zJTJDJTIwcmVmZXJlbmNlcyUzRGxhYmVscyklMEElMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uX21hdGNoZWQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEpJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),D=new w({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0MyUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjAzNykn",highlighted:'<span class="hljs-string">&#x27;ValueError: expected sequence of length 43 at dim 1 (got 37)&#x27;</span>',wrap:!1}}),K=new w({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaA==",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch`,wrap:!1}}),el=new w({props:{code:"dG9rZW5pemVyLmRlY29kZSh0cmFpbmVyLnRyYWluX2RhdGFzZXQlNUIwJTVEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKQ==",highlighted:'tokenizer.decode(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>])',wrap:!1}}),tl=new w({props:{code:"JyU1QkNMUyU1RCUyMGNvbmNlcHR1YWxseSUyMGNyZWFtJTIwc2tpbW1pbmclMjBoYXMlMjB0d28lMjBiYXNpYyUyMGRpbWVuc2lvbnMlMjAtJTIwcHJvZHVjdCUyMGFuZCUyMGdlb2dyYXBoeS4lMjAlNUJTRVAlNUQlMjBwcm9kdWN0JTIwYW5kJTIwZ2VvZ3JhcGh5JTIwYXJlJTIwd2hhdCUyMG1ha2UlMjBjcmVhbSUyMHNraW1taW5nJTIwd29yay4lMjAlNUJTRVAlNUQn",highlighted:'<span class="hljs-string">&#x27;[CLS] conceptually cream skimming has two basic dimensions - product and geography. [SEP] product and geography are what make cream skimming work. [SEP]&#x27;</span>',wrap:!1}}),al=new w({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RC5rZXlzKCk=",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>].keys()',wrap:!1}}),nl=new w({props:{code:"ZGljdF9rZXlzKCU1QidhdHRlbnRpb25fbWFzayclMkMlMjAnaHlwb3RoZXNpcyclMkMlMjAnaWR4JyUyQyUyMCdpbnB1dF9pZHMnJTJDJTIwJ2xhYmVsJyUyQyUyMCdwcmVtaXNlJyU1RCk=",highlighted:'dict_keys([<span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;hypothesis&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;premise&#x27;</span>])',wrap:!1}}),Ml=new w({props:{code:"dHlwZSh0cmFpbmVyLm1vZGVsKQ==",highlighted:'<span class="hljs-built_in">type</span>(trainer.model)',wrap:!1}}),il=new w({props:{code:"dHJhbnNmb3JtZXJzLm1vZGVscy5kaXN0aWxiZXJ0Lm1vZGVsaW5nX2Rpc3RpbGJlcnQuRGlzdGlsQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24=",highlighted:"transformers.models.distilbert.modeling_distilbert.DistilBertForSequenceClassification",wrap:!1}}),ml=new w({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVE",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>]',wrap:!1}}),yl=new w({props:{code:"JTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSU1RA==",highlighted:'[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]',wrap:!1}}),dl=new w({props:{code:"bGVuKHRyYWluZXIudHJhaW5fZGF0YXNldCU1QjAlNUQlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCklMjAlM0QlM0QlMjBsZW4oJTBBJTIwJTIwJTIwJTIwdHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQSk=",highlighted:`<span class="hljs-built_in">len</span>(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>]) == <span class="hljs-built_in">len</span>(
    trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>]
)`,wrap:!1}}),jl=new w({props:{code:"VHJ1ZQ==",highlighted:'<span class="hljs-literal">True</span>',wrap:!1}}),Ul=new w({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmxhYmVsJTIyJTVE",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;label&quot;</span>]',wrap:!1}}),ol=new w({props:{code:"MQ==",highlighted:'<span class="hljs-number">1</span>',wrap:!1}}),ul=new w({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0LmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXM=",highlighted:'trainer.train_dataset.features[<span class="hljs-string">&quot;label&quot;</span>].names',wrap:!1}}),bl=new w({props:{code:"JTVCJ2VudGFpbG1lbnQnJTJDJTIwJ25ldXRyYWwnJTJDJTIwJ2NvbnRyYWRpY3Rpb24nJTVE",highlighted:'[<span class="hljs-string">&#x27;entailment&#x27;</span>, <span class="hljs-string">&#x27;neutral&#x27;</span>, <span class="hljs-string">&#x27;contradiction&#x27;</span>]',wrap:!1}}),f=new Tt({props:{$$slots:{default:[cM]},$$scope:{ctx:u}}}),Zl=new b({props:{title:"От датасетов к загрузчикам данных",local:"from-datasets-to-dataloaders",headingTag:"h3"}}),kl=new w({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),Xl=new w({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaCUwQSUwQVZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0NSUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjA3Nik=",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch

ValueError: expected sequence of length <span class="hljs-number">45</span> at dim <span class="hljs-number">1</span> (got <span class="hljs-number">76</span>)`,wrap:!1}}),Rl=new w({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBZGF0YV9jb2xsYXRvcg==",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
data_collator`,wrap:!1}}),gl=new w({props:{code:"JTNDZnVuY3Rpb24lMjB0cmFuc2Zvcm1lcnMuZGF0YS5kYXRhX2NvbGxhdG9yLmRlZmF1bHRfZGF0YV9jb2xsYXRvcihmZWF0dXJlcyUzQSUyMExpc3QlNUJJbnB1dERhdGFDbGFzcyU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJ3B0JyklMjAtJTNFJTIwRGljdCU1QnN0ciUyQyUyMEFueSU1RCUzRQ==",highlighted:'&lt;function transformers.data.data_collator.default_data_collator(features: <span class="hljs-type">List</span>[InputDataClass], return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]&gt;',wrap:!1}}),Vl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),xl=new w({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ1VEQSUyMGVycm9yJTNBJTIwQ1VCTEFTX1NUQVRVU19BTExPQ19GQUlMRUQlMjB3aGVuJTIwY2FsbGluZyUyMCU2MGN1Ymxhc0NyZWF0ZShoYW5kbGUpJTYw",highlighted:"RuntimeError: CUDA error: CUBLAS_STATUS_ALLOC_FAILED when calling `cublasCreate(handle)`",wrap:!1}}),Fl=new w({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QnRyYWluZXIudHJhaW5fZGF0YXNldCU1QmklNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSg0KSU1RCk=",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
batch = data_collator([trainer.train_dataset[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),Hl=new w({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYWN0dWFsX3RyYWluX3NldCUyMCUzRCUyMHRyYWluZXIuX3JlbW92ZV91bnVzZWRfY29sdW1ucyh0cmFpbmVyLnRyYWluX2RhdGFzZXQpJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QmFjdHVhbF90cmFpbl9zZXQlNUJpJTVEJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoNCklNUQp",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
actual_train_set = trainer._remove_unused_columns(trainer.train_dataset)
batch = data_collator([actual_train_set[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),Nl=new b({props:{title:"Проверьте данные",local:"going-through-the-model",headingTag:"h3"}}),ql=new w({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),Ol=new w({props:{code:"b3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:"outputs = trainer.model.cpu()(**batch)",wrap:!1}}),le=new w({props:{code:"fiUyRi5weWVudiUyRnZlcnNpb25zJTJGMy43LjklMkZlbnZzJTJGYmFzZSUyRmxpYiUyRnB5dGhvbjMuNyUyRnNpdGUtcGFja2FnZXMlMkZ0b3JjaCUyRm5uJTJGZnVuY3Rpb25hbC5weSUyMGluJTIwbmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBzaXplX2F2ZXJhZ2UlMkMlMjBpZ25vcmVfaW5kZXglMkMlMjByZWR1Y2UlMkMlMjByZWR1Y3Rpb24pJTBBJTIwJTIwJTIwMjM4NiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAyMzg3JTIwJTIwJTIwJTIwJTIwaWYlMjBkaW0lMjAlM0QlM0QlMjAyJTNBJTBBLSUzRSUyMDIzODglMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXQlMjAlM0QlMjB0b3JjaC5fQy5fbm4ubmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBfUmVkdWN0aW9uLmdldF9lbnVtKHJlZHVjdGlvbiklMkMlMjBpZ25vcmVfaW5kZXgpJTBBJTIwJTIwJTIwMjM4OSUyMCUyMCUyMCUyMCUyMGVsaWYlMjBkaW0lMjAlM0QlM0QlMjA0JTNBJTBBJTIwJTIwJTIwMjM5MCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldCUyMCUzRCUyMHRvcmNoLl9DLl9ubi5ubGxfbG9zczJkKGlucHV0JTJDJTIwdGFyZ2V0JTJDJTIwd2VpZ2h0JTJDJTIwX1JlZHVjdGlvbi5nZXRfZW51bShyZWR1Y3Rpb24pJTJDJTIwaWdub3JlX2luZGV4KSUwQSUwQUluZGV4RXJyb3IlM0ElMjBUYXJnZXQlMjAyJTIwaXMlMjBvdXQlMjBvZiUyMGJvdW5kcy4=",highlighted:`~/.pyenv/versions/<span class="hljs-number">3.7</span><span class="hljs-number">.9</span>/envs/base/lib/python3<span class="hljs-number">.7</span>/site-packages/torch/nn/functional.py <span class="hljs-keyword">in</span> nll_loss(<span class="hljs-built_in">input</span>, target, weight, size_average, ignore_index, reduce, reduction)
   <span class="hljs-number">2386</span>         )
   <span class="hljs-number">2387</span>     <span class="hljs-keyword">if</span> dim == <span class="hljs-number">2</span>:
-&gt; <span class="hljs-number">2388</span>         ret = torch._C._nn.nll_loss(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)
   <span class="hljs-number">2389</span>     <span class="hljs-keyword">elif</span> dim == <span class="hljs-number">4</span>:
   <span class="hljs-number">2390</span>         ret = torch._C._nn.nll_loss2d(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)

IndexError: Target <span class="hljs-number">2</span> <span class="hljs-keyword">is</span> out of bounds.`,wrap:!1}}),te=new w({props:{code:"dHJhaW5lci5tb2RlbC5jb25maWcubnVtX2xhYmVscw==",highlighted:"trainer.model.config.num_labels",wrap:!1}}),se=new w({props:{code:"Mg==",highlighted:'<span class="hljs-number">2</span>',wrap:!1}}),ne=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),Me=new w({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBb3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

outputs = trainer.model.cpu()(**batch)`,wrap:!1}}),re=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQW91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsLnRvKGRldmljZSkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

outputs = trainer.model.to(device)(**batch)`,wrap:!1}}),me=new b({props:{title:"Выполнение одного шага оптиимзации",local:"performing-one-optimization-step",headingTag:"h3"}}),de=new w({props:{code:"bG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvc3MuYmFja3dhcmQoKQ==",highlighted:`loss = outputs.loss
loss.backward()`,wrap:!1}}),Ue=new w({props:{code:"dHJhaW5lci5jcmVhdGVfb3B0aW1pemVyKCklMEF0cmFpbmVyLm9wdGltaXplci5zdGVwKCk=",highlighted:`trainer.create_optimizer()
trainer.optimizer.step()`,wrap:!1}}),Te=new b({props:{title:"Как справиться с ошибками нехватки памяти",local:"dealing-with-cuda-out-of-memory-errors",headingTag:"h3"}}),$=new Tt({props:{$$slots:{default:[dM]},$$scope:{ctx:u}}}),he=new b({props:{title:"Валидация модели",local:"evaluating-the-model",headingTag:"h3"}}),$e=new w({props:{code:"JTIzJTIwJUQwJUFEJUQxJTgyJUQwJUJFJTIwJUQwJUI3JUQwJUIwJUQwJUI5JUQwJUJDJUQwJUI1JUQxJTgyJTIwJUQwJUJDJUQwJUJEJUQwJUJFJUQwJUIzJUQwJUJFJTIwJUQwJUIyJUQxJTgwJUQwJUI1JUQwJUJDJUQwJUI1JUQwJUJEJUQwJUI4JTIwJUQwJUI4JTIwJUQwJUJGJUQxJTgwJUQwJUI4JUQwJUIyJUQwJUI1JUQwJUI0JUQwJUI1JUQxJTgyJTIwJUQwJUJBJTIwJUQwJUJFJUQxJTg4JUQwJUI4JUQwJUIxJUQwJUJBJUQwJUI1JTJDJTIwJUQwJUJGJUQwJUJFJUQxJThEJUQxJTgyJUQwJUJFJUQwJUJDJUQxJTgzJTIwJUQwJUJEJUQwJUI1JTIwJUQxJTgxJUQxJTgyJUQwJUJFJUQwJUI4JUQxJTgyJTIwJUQwJUI3JUQwJUIwJUQwJUJGJUQxJTgzJUQxJTgxJUQwJUJBJUQwJUIwJUQxJTgyJUQxJThDJTIwJUQxJThEJUQxJTgyJUQxJTgzJTIwJUQxJThGJUQxJTg3JUQwJUI1JUQwJUI5JUQwJUJBJUQxJTgzJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-comment"># Это займет много времени и приведет к ошибке, поэтому не стоит запускать эту ячейку</span>
trainer.train()`,wrap:!1}}),Ce=new w({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),ke=new w({props:{code:"dHJhaW5lci5ldmFsdWF0ZSgp",highlighted:"trainer.evaluate()",wrap:!1}}),Be=new w({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),C=new Tt({props:{$$slots:{default:[jM]},$$scope:{ctx:u}}}),We=new w({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X2V2YWxfZGF0YWxvYWRlcigpJTNBJTBBJTIwJTIwJTIwJTIwYnJlYWslMEElMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwdHJhaW5lci5tb2RlbCgqKmJhdGNoKQ==",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_eval_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)`,wrap:!1}}),ge=new w({props:{code:"fiUyRmdpdCUyRmRhdGFzZXRzJTJGc3JjJTJGZGF0YXNldHMlMkZtZXRyaWMucHklMjBpbiUyMGFkZF9iYXRjaChzZWxmJTJDJTIwcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzKSUwQSUyMCUyMCUyMCUyMDQzMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMDQzMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwJTdCJTIycHJlZGljdGlvbnMlMjIlM0ElMjBwcmVkaWN0aW9ucyUyQyUyMCUyMnJlZmVyZW5jZXMlMjIlM0ElMjByZWZlcmVuY2VzJTdEJTBBLS0lM0UlMjA0MzMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMHNlbGYuaW5mby5mZWF0dXJlcy5lbmNvZGVfYmF0Y2goYmF0Y2gpJTBBJTIwJTIwJTIwJTIwNDM0JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLndyaXRlciUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMDQzNSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuX2luaXRfd3JpdGVyKCk=",highlighted:`~/git/datasets/src/datasets/metric.py <span class="hljs-keyword">in</span> add_batch(self, predictions, references)
    <span class="hljs-number">431</span>         <span class="hljs-string">&quot;&quot;&quot;
    432         batch = {&quot;predictions&quot;: predictions, &quot;references&quot;: references}
--&gt; 433         batch = self.info.features.encode_batch(batch)
    434         if self.writer is None:
    435             self._init_writer()</span>`,wrap:!1}}),ve=new w({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cy5jcHUoKS5udW1weSgpJTBBbGFiZWxzJTIwJTNEJTIwYmF0Y2glNUIlMjJsYWJlbHMlMjIlNUQuY3B1KCkubnVtcHkoKSUwQSUwQWNvbXB1dGVfbWV0cmljcygocHJlZGljdGlvbnMlMkMlMjBsYWJlbHMpKQ==",highlighted:`predictions = outputs.logits.cpu().numpy()
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>].cpu().numpy()

compute_metrics((predictions, labels))`,wrap:!1}}),Ve=new w({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),xe=new w({props:{code:"cHJlZGljdGlvbnMuc2hhcGUlMkMlMjBsYWJlbHMuc2hhcGU=",highlighted:"predictions.shape, labels.shape",wrap:!1}}),Qe=new w({props:{code:"KCg4JTJDJTIwMyklMkMlMjAoOCUyQykp",highlighted:'((<span class="hljs-number">8</span>, <span class="hljs-number">3</span>), (<span class="hljs-number">8</span>,))',wrap:!1}}),Fe=new w({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwbnAuYXJnbWF4KHByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbHMpJTBBJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkaWN0aW9ucyUyQyUyMGxhYmVscykp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


compute_metrics((predictions, labels))`,wrap:!1}}),Ae=new w({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuNjI1JTdE",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.625</span>}',wrap:!1}}),Ee=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),Z=new Tt({props:{$$slots:{default:[wM]},$$scope:{ctx:u}}}),Se=new b({props:{title:"Отладка скрытых ошибок во время обучения",local:"debugging-silent-errors-during-training",headingTag:"h2"}}),Le=new b({props:{title:"Проверьте свои данные (еще раз!)",local:"check-your-data-again",headingTag:"h3"}}),I=new Tt({props:{warning:!0,$$slots:{default:[UM]},$$scope:{ctx:u}}}),et=new b({props:{title:"Переобучение модели на одном батче",local:"overfit-your-model-on-one-batch",headingTag:"h3"}}),at=new w({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEF0cmFpbmVyLmNyZWF0ZV9vcHRpbWl6ZXIoKSUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDIwKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMGxvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnplcm9fZ3JhZCgp",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
trainer.create_optimizer()

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">20</span>):
    outputs = trainer.model(**batch)
    loss = outputs.loss
    loss.backward()
    trainer.optimizer.step()
    trainer.optimizer.zero_grad()`,wrap:!1}}),k=new Tt({props:{$$slots:{default:[oM]},$$scope:{ctx:u}}}),pt=new w({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBcHJlZHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxhYmVscyUyMCUzRCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkcy5jcHUoKS5udW1weSgpJTJDJTIwbGFiZWxzLmNwdSgpLm51bXB5KCkpKQ==",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)
preds = outputs.logits
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>]

compute_metrics((preds.cpu().numpy(), labels.cpu().numpy()))`,wrap:!1}}),Mt=new w({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDEuMCU3RA==",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">1.0</span>}',wrap:!1}}),B=new Tt({props:{warning:!0,$$slots:{default:[TM]},$$scope:{ctx:u}}}),Jt=new b({props:{title:"Не обучайте ничего, пока не получите первый бейзлайн.",local:"dont-tune-anything-until-you-have-a-first-baseline",headingTag:"h3"}}),dt=new b({props:{title:"Попросите о помощи",local:"ask-for-help",headingTag:"h3"}}),{c(){j=p("meta"),o=a(),U=p("p"),T=a(),r(h.$$.fragment),ht=a(),r(X.$$.fragment),ft=a(),r(W.$$.fragment),$t=a(),R=p("p"),R.innerHTML=bn,Ct=a(),r(g.$$.fragment),Zt=a(),r(G.$$.fragment),It=a(),v=p("p"),v.innerHTML=hn,kt=a(),V=p("p"),V.innerHTML=fn,Bt=a(),_=p("p"),_.innerHTML=$n,Xt=a(),r(x.$$.fragment),Wt=a(),Q=p("p"),Q.textContent=Cn,Rt=a(),r(Y.$$.fragment),gt=a(),r(F.$$.fragment),Gt=a(),A=p("p"),A.innerHTML=Zn,vt=a(),H=p("p"),H.innerHTML=In,Vt=a(),r(z.$$.fragment),_t=a(),r(E.$$.fragment),xt=a(),N=p("p"),N.innerHTML=kn,Qt=a(),S=p("p"),S.innerHTML=Bn,Yt=a(),r(q.$$.fragment),Ft=a(),L=p("p"),L.textContent=Xn,At=a(),r(D.$$.fragment),Ht=a(),P=p("p"),P.textContent=Wn,zt=a(),r(K.$$.fragment),Et=a(),O=p("p"),O.textContent=Rn,Nt=a(),ll=p("p"),ll.textContent=gn,St=a(),r(el.$$.fragment),qt=a(),r(tl.$$.fragment),Lt=a(),sl=p("p"),sl.textContent=Gn,Dt=a(),r(al.$$.fragment),Pt=a(),r(nl.$$.fragment),Kt=a(),pl=p("p"),pl.innerHTML=vn,Ot=a(),r(Ml.$$.fragment),ls=a(),r(il.$$.fragment),es=a(),rl=p("p"),rl.innerHTML=Vn,ts=a(),Jl=p("p"),Jl.innerHTML=_n,ss=a(),r(ml.$$.fragment),as=a(),r(yl.$$.fragment),ns=a(),cl=p("p"),cl.textContent=xn,ps=a(),r(dl.$$.fragment),Ms=a(),r(jl.$$.fragment),is=a(),wl=p("p"),wl.textContent=Qn,rs=a(),r(Ul.$$.fragment),Js=a(),r(ol.$$.fragment),ms=a(),Tl=p("p"),Tl.innerHTML=Yn,ys=a(),r(ul.$$.fragment),cs=a(),r(bl.$$.fragment),ds=a(),hl=p("p"),hl.innerHTML=Fn,js=a(),fl=p("p"),fl.textContent=An,ws=a(),r(f.$$.fragment),Us=a(),$l=p("p"),$l.textContent=Hn,os=a(),Cl=p("p"),Cl.textContent=zn,Ts=a(),r(Zl.$$.fragment),us=a(),Il=p("p"),Il.innerHTML=En,bs=a(),r(kl.$$.fragment),hs=a(),Bl=p("p"),Bl.textContent=Nn,fs=a(),r(Xl.$$.fragment),$s=a(),Wl=p("p"),Wl.innerHTML=Sn,Cs=a(),r(Rl.$$.fragment),Zs=a(),r(gl.$$.fragment),Is=a(),Gl=p("p"),Gl.innerHTML=qn,ks=a(),vl=p("p"),vl.innerHTML=Ln,Bs=a(),r(Vl.$$.fragment),Xs=a(),_l=p("p"),_l.textContent=Dn,Ws=a(),r(xl.$$.fragment),Rs=a(),Ql=p("p"),Ql.textContent=Pn,gs=a(),Yl=p("p"),Yl.textContent=Kn,Gs=a(),r(Fl.$$.fragment),vs=a(),Al=p("p"),Al.innerHTML=On,Vs=a(),r(Hl.$$.fragment),_s=a(),zl=p("p"),zl.textContent=lp,xs=a(),El=p("p"),El.textContent=ep,Qs=a(),r(Nl.$$.fragment),Ys=a(),Sl=p("p"),Sl.textContent=tp,Fs=a(),r(ql.$$.fragment),As=a(),Ll=p("p"),Ll.innerHTML=sp,Hs=a(),Dl=p("p"),Dl.textContent=ap,zs=a(),Pl=p("p"),Pl.textContent=np,Es=a(),Kl=p("p"),Kl.innerHTML=pp,Ns=a(),r(Ol.$$.fragment),Ss=a(),r(le.$$.fragment),qs=a(),ee=p("p"),ee.innerHTML=Mp,Ls=a(),r(te.$$.fragment),Ds=a(),r(se.$$.fragment),Ps=a(),ae=p("p"),ae.textContent=ip,Ks=a(),r(ne.$$.fragment),Os=a(),pe=p("p"),pe.innerHTML=rp,la=a(),r(Me.$$.fragment),ea=a(),ie=p("p"),ie.textContent=Jp,ta=a(),r(re.$$.fragment),sa=a(),Je=p("p"),Je.textContent=mp,aa=a(),r(me.$$.fragment),na=a(),ye=p("p"),ye.textContent=yp,pa=a(),ce=p("p"),ce.innerHTML=cp,Ma=a(),r(de.$$.fragment),ia=a(),je=p("p"),je.textContent=dp,ra=a(),we=p("p"),we.innerHTML=jp,Ja=a(),r(Ue.$$.fragment),ma=a(),oe=p("p"),oe.innerHTML=wp,ya=a(),r(Te.$$.fragment),ca=a(),ue=p("p"),ue.innerHTML=Up,da=a(),be=p("p"),be.textContent=op,ja=a(),r($.$$.fragment),wa=a(),r(he.$$.fragment),Ua=a(),fe=p("p"),fe.innerHTML=Tp,oa=a(),r($e.$$.fragment),Ta=a(),r(Ce.$$.fragment),ua=a(),Ze=p("p"),Ze.textContent=up,ba=a(),Ie=p("p"),Ie.innerHTML=bp,ha=a(),r(ke.$$.fragment),fa=a(),r(Be.$$.fragment),$a=a(),r(C.$$.fragment),Ca=a(),Xe=p("p"),Xe.textContent=hp,Za=a(),r(We.$$.fragment),Ia=a(),Re=p("p"),Re.textContent=fp,ka=a(),r(ge.$$.fragment),Ba=a(),Ge=p("p"),Ge.innerHTML=$p,Xa=a(),r(ve.$$.fragment),Wa=a(),r(Ve.$$.fragment),Ra=a(),_e=p("p"),_e.innerHTML=Cp,ga=a(),r(xe.$$.fragment),Ga=a(),r(Qe.$$.fragment),va=a(),Ye=p("p"),Ye.innerHTML=Zp,Va=a(),r(Fe.$$.fragment),_a=a(),r(Ae.$$.fragment),xa=a(),He=p("p"),He.textContent=Ip,Qa=a(),ze=p("p"),ze.textContent=kp,Ya=a(),r(Ee.$$.fragment),Fa=a(),Ne=p("p"),Ne.textContent=Bp,Aa=a(),r(Z.$$.fragment),Ha=a(),r(Se.$$.fragment),za=a(),qe=p("p"),qe.textContent=Xp,Ea=a(),r(Le.$$.fragment),Na=a(),De=p("p"),De.textContent=Wp,Sa=a(),Pe=p("ul"),Pe.innerHTML=Rp,qa=a(),r(I.$$.fragment),La=a(),Ke=p("p"),Ke.textContent=gp,Da=a(),Oe=p("p"),Oe.textContent=Gp,Pa=a(),lt=p("p"),lt.textContent=vp,Ka=a(),r(et.$$.fragment),Oa=a(),tt=p("p"),tt.textContent=Vp,ln=a(),st=p("p"),st.innerHTML=_p,en=a(),r(at.$$.fragment),tn=a(),r(k.$$.fragment),sn=a(),nt=p("p"),nt.textContent=xp,an=a(),r(pt.$$.fragment),nn=a(),r(Mt.$$.fragment),pn=a(),it=p("p"),it.textContent=Qp,Mn=a(),rt=p("p"),rt.textContent=Yp,rn=a(),r(B.$$.fragment),Jn=a(),r(Jt.$$.fragment),mn=a(),mt=p("p"),mt.innerHTML=Fp,yn=a(),yt=p("p"),yt.textContent=Ap,cn=a(),ct=p("p"),ct.textContent=Hp,dn=a(),r(dt.$$.fragment),jn=a(),jt=p("p"),jt.innerHTML=zp,wn=a(),wt=p("p"),wt.textContent=Ep,Un=a(),Ut=p("ul"),Ut.innerHTML=Np,on=a(),ot=p("p"),ot.textContent=Sp,Tn=a(),bt=p("p"),this.h()},l(l){const e=iM("svelte-u9bgzb",document.head);j=M(e,"META",{name:!0,content:!0}),e.forEach(t),o=n(l),U=M(l,"P",{}),tM(U).forEach(t),T=n(l),J(h.$$.fragment,l),ht=n(l),J(X.$$.fragment,l),ft=n(l),J(W.$$.fragment,l),$t=n(l),R=M(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-i74yku"&&(R.innerHTML=bn),Ct=n(l),J(g.$$.fragment,l),Zt=n(l),J(G.$$.fragment,l),It=n(l),v=M(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-16g84ru"&&(v.innerHTML=hn),kt=n(l),V=M(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-j3otxp"&&(V.innerHTML=fn),Bt=n(l),_=M(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-7his7t"&&(_.innerHTML=$n),Xt=n(l),J(x.$$.fragment,l),Wt=n(l),Q=M(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-fuew7a"&&(Q.textContent=Cn),Rt=n(l),J(Y.$$.fragment,l),gt=n(l),J(F.$$.fragment,l),Gt=n(l),A=M(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1ae2sud"&&(A.innerHTML=Zn),vt=n(l),H=M(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1yz06m4"&&(H.innerHTML=In),Vt=n(l),J(z.$$.fragment,l),_t=n(l),J(E.$$.fragment,l),xt=n(l),N=M(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1fjzhww"&&(N.innerHTML=kn),Qt=n(l),S=M(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1x1vxdz"&&(S.innerHTML=Bn),Yt=n(l),J(q.$$.fragment,l),Ft=n(l),L=M(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-kzrtgn"&&(L.textContent=Xn),At=n(l),J(D.$$.fragment,l),Ht=n(l),P=M(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-gwq31x"&&(P.textContent=Wn),zt=n(l),J(K.$$.fragment,l),Et=n(l),O=M(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-gm88e5"&&(O.textContent=Rn),Nt=n(l),ll=M(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-2f8x3p"&&(ll.textContent=gn),St=n(l),J(el.$$.fragment,l),qt=n(l),J(tl.$$.fragment,l),Lt=n(l),sl=M(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-fhhvpq"&&(sl.textContent=Gn),Dt=n(l),J(al.$$.fragment,l),Pt=n(l),J(nl.$$.fragment,l),Kt=n(l),pl=M(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-1hcvxf"&&(pl.innerHTML=vn),Ot=n(l),J(Ml.$$.fragment,l),ls=n(l),J(il.$$.fragment,l),es=n(l),rl=M(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-1sjbam"&&(rl.innerHTML=Vn),ts=n(l),Jl=M(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-e8yr2f"&&(Jl.innerHTML=_n),ss=n(l),J(ml.$$.fragment,l),as=n(l),J(yl.$$.fragment,l),ns=n(l),cl=M(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-1ptp61"&&(cl.textContent=xn),ps=n(l),J(dl.$$.fragment,l),Ms=n(l),J(jl.$$.fragment,l),is=n(l),wl=M(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-41fi5j"&&(wl.textContent=Qn),rs=n(l),J(Ul.$$.fragment,l),Js=n(l),J(ol.$$.fragment,l),ms=n(l),Tl=M(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-3wlf7g"&&(Tl.innerHTML=Yn),ys=n(l),J(ul.$$.fragment,l),cs=n(l),J(bl.$$.fragment,l),ds=n(l),hl=M(l,"P",{"data-svelte-h":!0}),i(hl)!=="svelte-1cvooet"&&(hl.innerHTML=Fn),js=n(l),fl=M(l,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-1nf3k9j"&&(fl.textContent=An),ws=n(l),J(f.$$.fragment,l),Us=n(l),$l=M(l,"P",{"data-svelte-h":!0}),i($l)!=="svelte-9ucqbl"&&($l.textContent=Hn),os=n(l),Cl=M(l,"P",{"data-svelte-h":!0}),i(Cl)!=="svelte-8755tv"&&(Cl.textContent=zn),Ts=n(l),J(Zl.$$.fragment,l),us=n(l),Il=M(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-1ubc5pl"&&(Il.innerHTML=En),bs=n(l),J(kl.$$.fragment,l),hs=n(l),Bl=M(l,"P",{"data-svelte-h":!0}),i(Bl)!=="svelte-b63dqv"&&(Bl.textContent=Nn),fs=n(l),J(Xl.$$.fragment,l),$s=n(l),Wl=M(l,"P",{"data-svelte-h":!0}),i(Wl)!=="svelte-o0yb3p"&&(Wl.innerHTML=Sn),Cs=n(l),J(Rl.$$.fragment,l),Zs=n(l),J(gl.$$.fragment,l),Is=n(l),Gl=M(l,"P",{"data-svelte-h":!0}),i(Gl)!=="svelte-s94t3r"&&(Gl.innerHTML=qn),ks=n(l),vl=M(l,"P",{"data-svelte-h":!0}),i(vl)!=="svelte-qlao8o"&&(vl.innerHTML=Ln),Bs=n(l),J(Vl.$$.fragment,l),Xs=n(l),_l=M(l,"P",{"data-svelte-h":!0}),i(_l)!=="svelte-kbq8q2"&&(_l.textContent=Dn),Ws=n(l),J(xl.$$.fragment,l),Rs=n(l),Ql=M(l,"P",{"data-svelte-h":!0}),i(Ql)!=="svelte-1u2oyow"&&(Ql.textContent=Pn),gs=n(l),Yl=M(l,"P",{"data-svelte-h":!0}),i(Yl)!=="svelte-2bykvd"&&(Yl.textContent=Kn),Gs=n(l),J(Fl.$$.fragment,l),vs=n(l),Al=M(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-fe3ado"&&(Al.innerHTML=On),Vs=n(l),J(Hl.$$.fragment,l),_s=n(l),zl=M(l,"P",{"data-svelte-h":!0}),i(zl)!=="svelte-1k2z729"&&(zl.textContent=lp),xs=n(l),El=M(l,"P",{"data-svelte-h":!0}),i(El)!=="svelte-1movyjg"&&(El.textContent=ep),Qs=n(l),J(Nl.$$.fragment,l),Ys=n(l),Sl=M(l,"P",{"data-svelte-h":!0}),i(Sl)!=="svelte-a2nxrs"&&(Sl.textContent=tp),Fs=n(l),J(ql.$$.fragment,l),As=n(l),Ll=M(l,"P",{"data-svelte-h":!0}),i(Ll)!=="svelte-5zx2a4"&&(Ll.innerHTML=sp),Hs=n(l),Dl=M(l,"P",{"data-svelte-h":!0}),i(Dl)!=="svelte-cef22x"&&(Dl.textContent=ap),zs=n(l),Pl=M(l,"P",{"data-svelte-h":!0}),i(Pl)!=="svelte-btkayt"&&(Pl.textContent=np),Es=n(l),Kl=M(l,"P",{"data-svelte-h":!0}),i(Kl)!=="svelte-1iaolg6"&&(Kl.innerHTML=pp),Ns=n(l),J(Ol.$$.fragment,l),Ss=n(l),J(le.$$.fragment,l),qs=n(l),ee=M(l,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-1xr2p7k"&&(ee.innerHTML=Mp),Ls=n(l),J(te.$$.fragment,l),Ds=n(l),J(se.$$.fragment,l),Ps=n(l),ae=M(l,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-yblc4i"&&(ae.textContent=ip),Ks=n(l),J(ne.$$.fragment,l),Os=n(l),pe=M(l,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-1ififvv"&&(pe.innerHTML=rp),la=n(l),J(Me.$$.fragment,l),ea=n(l),ie=M(l,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-1nhffwj"&&(ie.textContent=Jp),ta=n(l),J(re.$$.fragment,l),sa=n(l),Je=M(l,"P",{"data-svelte-h":!0}),i(Je)!=="svelte-6b6rwu"&&(Je.textContent=mp),aa=n(l),J(me.$$.fragment,l),na=n(l),ye=M(l,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-156whrd"&&(ye.textContent=yp),pa=n(l),ce=M(l,"P",{"data-svelte-h":!0}),i(ce)!=="svelte-1o4uma2"&&(ce.innerHTML=cp),Ma=n(l),J(de.$$.fragment,l),ia=n(l),je=M(l,"P",{"data-svelte-h":!0}),i(je)!=="svelte-16fqkcw"&&(je.textContent=dp),ra=n(l),we=M(l,"P",{"data-svelte-h":!0}),i(we)!=="svelte-1vb7gyx"&&(we.innerHTML=jp),Ja=n(l),J(Ue.$$.fragment,l),ma=n(l),oe=M(l,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-7xu1gs"&&(oe.innerHTML=wp),ya=n(l),J(Te.$$.fragment,l),ca=n(l),ue=M(l,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-15f70qk"&&(ue.innerHTML=Up),da=n(l),be=M(l,"P",{"data-svelte-h":!0}),i(be)!=="svelte-19lrb7"&&(be.textContent=op),ja=n(l),J($.$$.fragment,l),wa=n(l),J(he.$$.fragment,l),Ua=n(l),fe=M(l,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-1cp8phi"&&(fe.innerHTML=Tp),oa=n(l),J($e.$$.fragment,l),Ta=n(l),J(Ce.$$.fragment,l),ua=n(l),Ze=M(l,"P",{"data-svelte-h":!0}),i(Ze)!=="svelte-c1eyic"&&(Ze.textContent=up),ba=n(l),Ie=M(l,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-18eb5gd"&&(Ie.innerHTML=bp),ha=n(l),J(ke.$$.fragment,l),fa=n(l),J(Be.$$.fragment,l),$a=n(l),J(C.$$.fragment,l),Ca=n(l),Xe=M(l,"P",{"data-svelte-h":!0}),i(Xe)!=="svelte-mqpinc"&&(Xe.textContent=hp),Za=n(l),J(We.$$.fragment,l),Ia=n(l),Re=M(l,"P",{"data-svelte-h":!0}),i(Re)!=="svelte-n1tv18"&&(Re.textContent=fp),ka=n(l),J(ge.$$.fragment,l),Ba=n(l),Ge=M(l,"P",{"data-svelte-h":!0}),i(Ge)!=="svelte-grkkrc"&&(Ge.innerHTML=$p),Xa=n(l),J(ve.$$.fragment,l),Wa=n(l),J(Ve.$$.fragment,l),Ra=n(l),_e=M(l,"P",{"data-svelte-h":!0}),i(_e)!=="svelte-12fcw8q"&&(_e.innerHTML=Cp),ga=n(l),J(xe.$$.fragment,l),Ga=n(l),J(Qe.$$.fragment,l),va=n(l),Ye=M(l,"P",{"data-svelte-h":!0}),i(Ye)!=="svelte-1794hwq"&&(Ye.innerHTML=Zp),Va=n(l),J(Fe.$$.fragment,l),_a=n(l),J(Ae.$$.fragment,l),xa=n(l),He=M(l,"P",{"data-svelte-h":!0}),i(He)!=="svelte-wlyrc"&&(He.textContent=Ip),Qa=n(l),ze=M(l,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-16ewhvs"&&(ze.textContent=kp),Ya=n(l),J(Ee.$$.fragment,l),Fa=n(l),Ne=M(l,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-14zkqr0"&&(Ne.textContent=Bp),Aa=n(l),J(Z.$$.fragment,l),Ha=n(l),J(Se.$$.fragment,l),za=n(l),qe=M(l,"P",{"data-svelte-h":!0}),i(qe)!=="svelte-11ajyay"&&(qe.textContent=Xp),Ea=n(l),J(Le.$$.fragment,l),Na=n(l),De=M(l,"P",{"data-svelte-h":!0}),i(De)!=="svelte-6w5kk9"&&(De.textContent=Wp),Sa=n(l),Pe=M(l,"UL",{"data-svelte-h":!0}),i(Pe)!=="svelte-1d8vmua"&&(Pe.innerHTML=Rp),qa=n(l),J(I.$$.fragment,l),La=n(l),Ke=M(l,"P",{"data-svelte-h":!0}),i(Ke)!=="svelte-1lctfpx"&&(Ke.textContent=gp),Da=n(l),Oe=M(l,"P",{"data-svelte-h":!0}),i(Oe)!=="svelte-5eyk32"&&(Oe.textContent=Gp),Pa=n(l),lt=M(l,"P",{"data-svelte-h":!0}),i(lt)!=="svelte-hhg4yn"&&(lt.textContent=vp),Ka=n(l),J(et.$$.fragment,l),Oa=n(l),tt=M(l,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-1cslmaj"&&(tt.textContent=Vp),ln=n(l),st=M(l,"P",{"data-svelte-h":!0}),i(st)!=="svelte-1slr0p1"&&(st.innerHTML=_p),en=n(l),J(at.$$.fragment,l),tn=n(l),J(k.$$.fragment,l),sn=n(l),nt=M(l,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-90whek"&&(nt.textContent=xp),an=n(l),J(pt.$$.fragment,l),nn=n(l),J(Mt.$$.fragment,l),pn=n(l),it=M(l,"P",{"data-svelte-h":!0}),i(it)!=="svelte-1q8k6oi"&&(it.textContent=Qp),Mn=n(l),rt=M(l,"P",{"data-svelte-h":!0}),i(rt)!=="svelte-1rfk2rq"&&(rt.textContent=Yp),rn=n(l),J(B.$$.fragment,l),Jn=n(l),J(Jt.$$.fragment,l),mn=n(l),mt=M(l,"P",{"data-svelte-h":!0}),i(mt)!=="svelte-amuojt"&&(mt.innerHTML=Fp),yn=n(l),yt=M(l,"P",{"data-svelte-h":!0}),i(yt)!=="svelte-scvkmh"&&(yt.textContent=Ap),cn=n(l),ct=M(l,"P",{"data-svelte-h":!0}),i(ct)!=="svelte-1xje688"&&(ct.textContent=Hp),dn=n(l),J(dt.$$.fragment,l),jn=n(l),jt=M(l,"P",{"data-svelte-h":!0}),i(jt)!=="svelte-1hsg2d4"&&(jt.innerHTML=zp),wn=n(l),wt=M(l,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-25fayq"&&(wt.textContent=Ep),Un=n(l),Ut=M(l,"UL",{"data-svelte-h":!0}),i(Ut)!=="svelte-s74dcg"&&(Ut.innerHTML=Np),on=n(l),ot=M(l,"P",{"data-svelte-h":!0}),i(ot)!=="svelte-t3dqmr"&&(ot.textContent=Sp),Tn=n(l),bt=M(l,"P",{}),tM(bt).forEach(t),this.h()},h(){sM(j,"name","hf:doc:metadata"),sM(j,"content",bM)},m(l,e){rM(document.head,j),s(l,o,e),s(l,U,e),s(l,T,e),m(h,l,e),s(l,ht,e),m(X,l,e),s(l,ft,e),m(W,l,e),s(l,$t,e),s(l,R,e),s(l,Ct,e),m(g,l,e),s(l,Zt,e),m(G,l,e),s(l,It,e),s(l,v,e),s(l,kt,e),s(l,V,e),s(l,Bt,e),s(l,_,e),s(l,Xt,e),m(x,l,e),s(l,Wt,e),s(l,Q,e),s(l,Rt,e),m(Y,l,e),s(l,gt,e),m(F,l,e),s(l,Gt,e),s(l,A,e),s(l,vt,e),s(l,H,e),s(l,Vt,e),m(z,l,e),s(l,_t,e),m(E,l,e),s(l,xt,e),s(l,N,e),s(l,Qt,e),s(l,S,e),s(l,Yt,e),m(q,l,e),s(l,Ft,e),s(l,L,e),s(l,At,e),m(D,l,e),s(l,Ht,e),s(l,P,e),s(l,zt,e),m(K,l,e),s(l,Et,e),s(l,O,e),s(l,Nt,e),s(l,ll,e),s(l,St,e),m(el,l,e),s(l,qt,e),m(tl,l,e),s(l,Lt,e),s(l,sl,e),s(l,Dt,e),m(al,l,e),s(l,Pt,e),m(nl,l,e),s(l,Kt,e),s(l,pl,e),s(l,Ot,e),m(Ml,l,e),s(l,ls,e),m(il,l,e),s(l,es,e),s(l,rl,e),s(l,ts,e),s(l,Jl,e),s(l,ss,e),m(ml,l,e),s(l,as,e),m(yl,l,e),s(l,ns,e),s(l,cl,e),s(l,ps,e),m(dl,l,e),s(l,Ms,e),m(jl,l,e),s(l,is,e),s(l,wl,e),s(l,rs,e),m(Ul,l,e),s(l,Js,e),m(ol,l,e),s(l,ms,e),s(l,Tl,e),s(l,ys,e),m(ul,l,e),s(l,cs,e),m(bl,l,e),s(l,ds,e),s(l,hl,e),s(l,js,e),s(l,fl,e),s(l,ws,e),m(f,l,e),s(l,Us,e),s(l,$l,e),s(l,os,e),s(l,Cl,e),s(l,Ts,e),m(Zl,l,e),s(l,us,e),s(l,Il,e),s(l,bs,e),m(kl,l,e),s(l,hs,e),s(l,Bl,e),s(l,fs,e),m(Xl,l,e),s(l,$s,e),s(l,Wl,e),s(l,Cs,e),m(Rl,l,e),s(l,Zs,e),m(gl,l,e),s(l,Is,e),s(l,Gl,e),s(l,ks,e),s(l,vl,e),s(l,Bs,e),m(Vl,l,e),s(l,Xs,e),s(l,_l,e),s(l,Ws,e),m(xl,l,e),s(l,Rs,e),s(l,Ql,e),s(l,gs,e),s(l,Yl,e),s(l,Gs,e),m(Fl,l,e),s(l,vs,e),s(l,Al,e),s(l,Vs,e),m(Hl,l,e),s(l,_s,e),s(l,zl,e),s(l,xs,e),s(l,El,e),s(l,Qs,e),m(Nl,l,e),s(l,Ys,e),s(l,Sl,e),s(l,Fs,e),m(ql,l,e),s(l,As,e),s(l,Ll,e),s(l,Hs,e),s(l,Dl,e),s(l,zs,e),s(l,Pl,e),s(l,Es,e),s(l,Kl,e),s(l,Ns,e),m(Ol,l,e),s(l,Ss,e),m(le,l,e),s(l,qs,e),s(l,ee,e),s(l,Ls,e),m(te,l,e),s(l,Ds,e),m(se,l,e),s(l,Ps,e),s(l,ae,e),s(l,Ks,e),m(ne,l,e),s(l,Os,e),s(l,pe,e),s(l,la,e),m(Me,l,e),s(l,ea,e),s(l,ie,e),s(l,ta,e),m(re,l,e),s(l,sa,e),s(l,Je,e),s(l,aa,e),m(me,l,e),s(l,na,e),s(l,ye,e),s(l,pa,e),s(l,ce,e),s(l,Ma,e),m(de,l,e),s(l,ia,e),s(l,je,e),s(l,ra,e),s(l,we,e),s(l,Ja,e),m(Ue,l,e),s(l,ma,e),s(l,oe,e),s(l,ya,e),m(Te,l,e),s(l,ca,e),s(l,ue,e),s(l,da,e),s(l,be,e),s(l,ja,e),m($,l,e),s(l,wa,e),m(he,l,e),s(l,Ua,e),s(l,fe,e),s(l,oa,e),m($e,l,e),s(l,Ta,e),m(Ce,l,e),s(l,ua,e),s(l,Ze,e),s(l,ba,e),s(l,Ie,e),s(l,ha,e),m(ke,l,e),s(l,fa,e),m(Be,l,e),s(l,$a,e),m(C,l,e),s(l,Ca,e),s(l,Xe,e),s(l,Za,e),m(We,l,e),s(l,Ia,e),s(l,Re,e),s(l,ka,e),m(ge,l,e),s(l,Ba,e),s(l,Ge,e),s(l,Xa,e),m(ve,l,e),s(l,Wa,e),m(Ve,l,e),s(l,Ra,e),s(l,_e,e),s(l,ga,e),m(xe,l,e),s(l,Ga,e),m(Qe,l,e),s(l,va,e),s(l,Ye,e),s(l,Va,e),m(Fe,l,e),s(l,_a,e),m(Ae,l,e),s(l,xa,e),s(l,He,e),s(l,Qa,e),s(l,ze,e),s(l,Ya,e),m(Ee,l,e),s(l,Fa,e),s(l,Ne,e),s(l,Aa,e),m(Z,l,e),s(l,Ha,e),m(Se,l,e),s(l,za,e),s(l,qe,e),s(l,Ea,e),m(Le,l,e),s(l,Na,e),s(l,De,e),s(l,Sa,e),s(l,Pe,e),s(l,qa,e),m(I,l,e),s(l,La,e),s(l,Ke,e),s(l,Da,e),s(l,Oe,e),s(l,Pa,e),s(l,lt,e),s(l,Ka,e),m(et,l,e),s(l,Oa,e),s(l,tt,e),s(l,ln,e),s(l,st,e),s(l,en,e),m(at,l,e),s(l,tn,e),m(k,l,e),s(l,sn,e),s(l,nt,e),s(l,an,e),m(pt,l,e),s(l,nn,e),m(Mt,l,e),s(l,pn,e),s(l,it,e),s(l,Mn,e),s(l,rt,e),s(l,rn,e),m(B,l,e),s(l,Jn,e),m(Jt,l,e),s(l,mn,e),s(l,mt,e),s(l,yn,e),s(l,yt,e),s(l,cn,e),s(l,ct,e),s(l,dn,e),m(dt,l,e),s(l,jn,e),s(l,jt,e),s(l,wn,e),s(l,wt,e),s(l,Un,e),s(l,Ut,e),s(l,on,e),s(l,ot,e),s(l,Tn,e),s(l,bt,e),un=!0},p(l,[e]){const qp={};e&1&&(qp.fw=l[0]),h.$set(qp);const Lp={};e&2&&(Lp.$$scope={dirty:e,ctx:l}),f.$set(Lp);const Dp={};e&2&&(Dp.$$scope={dirty:e,ctx:l}),$.$set(Dp);const Pp={};e&2&&(Pp.$$scope={dirty:e,ctx:l}),C.$set(Pp);const Kp={};e&2&&(Kp.$$scope={dirty:e,ctx:l}),Z.$set(Kp);const Op={};e&2&&(Op.$$scope={dirty:e,ctx:l}),I.$set(Op);const lM={};e&2&&(lM.$$scope={dirty:e,ctx:l}),k.$set(lM);const eM={};e&2&&(eM.$$scope={dirty:e,ctx:l}),B.$set(eM)},i(l){un||(y(h.$$.fragment,l),y(X.$$.fragment,l),y(W.$$.fragment,l),y(g.$$.fragment,l),y(G.$$.fragment,l),y(x.$$.fragment,l),y(Y.$$.fragment,l),y(F.$$.fragment,l),y(z.$$.fragment,l),y(E.$$.fragment,l),y(q.$$.fragment,l),y(D.$$.fragment,l),y(K.$$.fragment,l),y(el.$$.fragment,l),y(tl.$$.fragment,l),y(al.$$.fragment,l),y(nl.$$.fragment,l),y(Ml.$$.fragment,l),y(il.$$.fragment,l),y(ml.$$.fragment,l),y(yl.$$.fragment,l),y(dl.$$.fragment,l),y(jl.$$.fragment,l),y(Ul.$$.fragment,l),y(ol.$$.fragment,l),y(ul.$$.fragment,l),y(bl.$$.fragment,l),y(f.$$.fragment,l),y(Zl.$$.fragment,l),y(kl.$$.fragment,l),y(Xl.$$.fragment,l),y(Rl.$$.fragment,l),y(gl.$$.fragment,l),y(Vl.$$.fragment,l),y(xl.$$.fragment,l),y(Fl.$$.fragment,l),y(Hl.$$.fragment,l),y(Nl.$$.fragment,l),y(ql.$$.fragment,l),y(Ol.$$.fragment,l),y(le.$$.fragment,l),y(te.$$.fragment,l),y(se.$$.fragment,l),y(ne.$$.fragment,l),y(Me.$$.fragment,l),y(re.$$.fragment,l),y(me.$$.fragment,l),y(de.$$.fragment,l),y(Ue.$$.fragment,l),y(Te.$$.fragment,l),y($.$$.fragment,l),y(he.$$.fragment,l),y($e.$$.fragment,l),y(Ce.$$.fragment,l),y(ke.$$.fragment,l),y(Be.$$.fragment,l),y(C.$$.fragment,l),y(We.$$.fragment,l),y(ge.$$.fragment,l),y(ve.$$.fragment,l),y(Ve.$$.fragment,l),y(xe.$$.fragment,l),y(Qe.$$.fragment,l),y(Fe.$$.fragment,l),y(Ae.$$.fragment,l),y(Ee.$$.fragment,l),y(Z.$$.fragment,l),y(Se.$$.fragment,l),y(Le.$$.fragment,l),y(I.$$.fragment,l),y(et.$$.fragment,l),y(at.$$.fragment,l),y(k.$$.fragment,l),y(pt.$$.fragment,l),y(Mt.$$.fragment,l),y(B.$$.fragment,l),y(Jt.$$.fragment,l),y(dt.$$.fragment,l),un=!0)},o(l){c(h.$$.fragment,l),c(X.$$.fragment,l),c(W.$$.fragment,l),c(g.$$.fragment,l),c(G.$$.fragment,l),c(x.$$.fragment,l),c(Y.$$.fragment,l),c(F.$$.fragment,l),c(z.$$.fragment,l),c(E.$$.fragment,l),c(q.$$.fragment,l),c(D.$$.fragment,l),c(K.$$.fragment,l),c(el.$$.fragment,l),c(tl.$$.fragment,l),c(al.$$.fragment,l),c(nl.$$.fragment,l),c(Ml.$$.fragment,l),c(il.$$.fragment,l),c(ml.$$.fragment,l),c(yl.$$.fragment,l),c(dl.$$.fragment,l),c(jl.$$.fragment,l),c(Ul.$$.fragment,l),c(ol.$$.fragment,l),c(ul.$$.fragment,l),c(bl.$$.fragment,l),c(f.$$.fragment,l),c(Zl.$$.fragment,l),c(kl.$$.fragment,l),c(Xl.$$.fragment,l),c(Rl.$$.fragment,l),c(gl.$$.fragment,l),c(Vl.$$.fragment,l),c(xl.$$.fragment,l),c(Fl.$$.fragment,l),c(Hl.$$.fragment,l),c(Nl.$$.fragment,l),c(ql.$$.fragment,l),c(Ol.$$.fragment,l),c(le.$$.fragment,l),c(te.$$.fragment,l),c(se.$$.fragment,l),c(ne.$$.fragment,l),c(Me.$$.fragment,l),c(re.$$.fragment,l),c(me.$$.fragment,l),c(de.$$.fragment,l),c(Ue.$$.fragment,l),c(Te.$$.fragment,l),c($.$$.fragment,l),c(he.$$.fragment,l),c($e.$$.fragment,l),c(Ce.$$.fragment,l),c(ke.$$.fragment,l),c(Be.$$.fragment,l),c(C.$$.fragment,l),c(We.$$.fragment,l),c(ge.$$.fragment,l),c(ve.$$.fragment,l),c(Ve.$$.fragment,l),c(xe.$$.fragment,l),c(Qe.$$.fragment,l),c(Fe.$$.fragment,l),c(Ae.$$.fragment,l),c(Ee.$$.fragment,l),c(Z.$$.fragment,l),c(Se.$$.fragment,l),c(Le.$$.fragment,l),c(I.$$.fragment,l),c(et.$$.fragment,l),c(at.$$.fragment,l),c(k.$$.fragment,l),c(pt.$$.fragment,l),c(Mt.$$.fragment,l),c(B.$$.fragment,l),c(Jt.$$.fragment,l),c(dt.$$.fragment,l),un=!1},d(l){l&&(t(o),t(U),t(T),t(ht),t(ft),t($t),t(R),t(Ct),t(Zt),t(It),t(v),t(kt),t(V),t(Bt),t(_),t(Xt),t(Wt),t(Q),t(Rt),t(gt),t(Gt),t(A),t(vt),t(H),t(Vt),t(_t),t(xt),t(N),t(Qt),t(S),t(Yt),t(Ft),t(L),t(At),t(Ht),t(P),t(zt),t(Et),t(O),t(Nt),t(ll),t(St),t(qt),t(Lt),t(sl),t(Dt),t(Pt),t(Kt),t(pl),t(Ot),t(ls),t(es),t(rl),t(ts),t(Jl),t(ss),t(as),t(ns),t(cl),t(ps),t(Ms),t(is),t(wl),t(rs),t(Js),t(ms),t(Tl),t(ys),t(cs),t(ds),t(hl),t(js),t(fl),t(ws),t(Us),t($l),t(os),t(Cl),t(Ts),t(us),t(Il),t(bs),t(hs),t(Bl),t(fs),t($s),t(Wl),t(Cs),t(Zs),t(Is),t(Gl),t(ks),t(vl),t(Bs),t(Xs),t(_l),t(Ws),t(Rs),t(Ql),t(gs),t(Yl),t(Gs),t(vs),t(Al),t(Vs),t(_s),t(zl),t(xs),t(El),t(Qs),t(Ys),t(Sl),t(Fs),t(As),t(Ll),t(Hs),t(Dl),t(zs),t(Pl),t(Es),t(Kl),t(Ns),t(Ss),t(qs),t(ee),t(Ls),t(Ds),t(Ps),t(ae),t(Ks),t(Os),t(pe),t(la),t(ea),t(ie),t(ta),t(sa),t(Je),t(aa),t(na),t(ye),t(pa),t(ce),t(Ma),t(ia),t(je),t(ra),t(we),t(Ja),t(ma),t(oe),t(ya),t(ca),t(ue),t(da),t(be),t(ja),t(wa),t(Ua),t(fe),t(oa),t(Ta),t(ua),t(Ze),t(ba),t(Ie),t(ha),t(fa),t($a),t(Ca),t(Xe),t(Za),t(Ia),t(Re),t(ka),t(Ba),t(Ge),t(Xa),t(Wa),t(Ra),t(_e),t(ga),t(Ga),t(va),t(Ye),t(Va),t(_a),t(xa),t(He),t(Qa),t(ze),t(Ya),t(Fa),t(Ne),t(Aa),t(Ha),t(za),t(qe),t(Ea),t(Na),t(De),t(Sa),t(Pe),t(qa),t(La),t(Ke),t(Da),t(Oe),t(Pa),t(lt),t(Ka),t(Oa),t(tt),t(ln),t(st),t(en),t(tn),t(sn),t(nt),t(an),t(nn),t(pn),t(it),t(Mn),t(rt),t(rn),t(Jn),t(mn),t(mt),t(yn),t(yt),t(cn),t(ct),t(dn),t(jn),t(jt),t(wn),t(wt),t(Un),t(Ut),t(on),t(ot),t(Tn),t(bt)),t(j),d(h,l),d(X,l),d(W,l),d(g,l),d(G,l),d(x,l),d(Y,l),d(F,l),d(z,l),d(E,l),d(q,l),d(D,l),d(K,l),d(el,l),d(tl,l),d(al,l),d(nl,l),d(Ml,l),d(il,l),d(ml,l),d(yl,l),d(dl,l),d(jl,l),d(Ul,l),d(ol,l),d(ul,l),d(bl,l),d(f,l),d(Zl,l),d(kl,l),d(Xl,l),d(Rl,l),d(gl,l),d(Vl,l),d(xl,l),d(Fl,l),d(Hl,l),d(Nl,l),d(ql,l),d(Ol,l),d(le,l),d(te,l),d(se,l),d(ne,l),d(Me,l),d(re,l),d(me,l),d(de,l),d(Ue,l),d(Te,l),d($,l),d(he,l),d($e,l),d(Ce,l),d(ke,l),d(Be,l),d(C,l),d(We,l),d(ge,l),d(ve,l),d(Ve,l),d(xe,l),d(Qe,l),d(Fe,l),d(Ae,l),d(Ee,l),d(Z,l),d(Se,l),d(Le,l),d(I,l),d(et,l),d(at,l),d(k,l),d(pt,l),d(Mt,l),d(B,l),d(Jt,l),d(dt,l)}}}const bM='{"title":"Отладка обучения","local":"debugging-the-training-pipeline","sections":[{"title":"Отладка обучающего пайплайна","local":"debugging-the-training-pipeline","sections":[{"title":"Проверка данных","local":"check-your-data","sections":[],"depth":3},{"title":"От датасетов к загрузчикам данных","local":"from-datasets-to-dataloaders","sections":[],"depth":3},{"title":"Проверьте данные","local":"going-through-the-model","sections":[],"depth":3},{"title":"Выполнение одного шага оптиимзации","local":"performing-one-optimization-step","sections":[],"depth":3},{"title":"Как справиться с ошибками нехватки памяти","local":"dealing-with-cuda-out-of-memory-errors","sections":[],"depth":3},{"title":"Валидация модели","local":"evaluating-the-model","sections":[],"depth":3}],"depth":2},{"title":"Отладка скрытых ошибок во время обучения","local":"debugging-silent-errors-during-training","sections":[{"title":"Проверьте свои данные (еще раз!)","local":"check-your-data-again","sections":[],"depth":3},{"title":"Переобучение модели на одном батче","local":"overfit-your-model-on-one-batch","sections":[],"depth":3},{"title":"Не обучайте ничего, пока не получите первый бейзлайн.","local":"dont-tune-anything-until-you-have-a-first-baseline","sections":[],"depth":3},{"title":"Попросите о помощи","local":"ask-for-help","sections":[],"depth":3}],"depth":2}],"depth":1}';function hM(u,j,o){let U="pt";return nM(()=>{const T=new URLSearchParams(window.location.search);o(0,U=T.get("fw")||"pt")}),[U]}class WM extends pM{constructor(j){super(),MM(this,j,hM,uM,aM,{})}}export{WM as component};
