import{s as Ln,f as en,n as Nn,o as Wn}from"../chunks/scheduler.37c15a92.js";import{S as Rn,i as Qn,g as i,s,r as m,A as Vn,h as o,f as e,c as a,j as ct,u as y,x as h,k as c,y as Sn,a as l,v as M,d,t as g,w as T}from"../chunks/index.2bf4358c.js";import{C as ln}from"../chunks/CodeBlock.4f5fc1ad.js";import{D as Xn}from"../chunks/DocNotebookDropdown.d9dfeb24.js";import{H as it}from"../chunks/Heading.8ada512a.js";function Yn(sn){let w,pt,ot,rt,j,ut,J,mt,b,an="Trong phần này, chúng ta sẽ xem xét kỹ hơn về lớp <code>Interface</code> và hiểu các tham số chính được sử dụng để tạo ra nó.",yt,v,Mt,f,on="Bạn sẽ nhận thấy rằng lớp <code>Interface</code> có 3 tham số bắt buộc:",dt,U,hn="<code>Interface(fn, inputs, outputs, ...)</code>",gt,I,cn="Các tham số này là:",Tt,C,pn="<li><code>fn</code>: hàm dự đoán được bao bọc bởi giao diện Gradio. Hàm này có thể nhận một hoặc nhiều tham số và trả về một hoặc nhiều giá trị</li> <li><code>inputs</code>: (các) loại thành phần đầu vào. Gradio cung cấp nhiều thành phần được tạo sẵn như<code>&quot;image&quot;</code> hay <code>&quot;mic&quot;</code>.</li> <li><code>outputs</code>: (các) loại thành phần đầu ra. Một lần nữa, Gradio cung cấp nhiều thành phần được tạo sẵn, ví dụ: <code>&quot;image&quot;</code> hay <code>&quot;label&quot;</code>.</li>",wt,k,rn='Để có danh sách đầy đủ các thành phần, <a href="https://gradio.app/docs" rel="nofollow">xem tài liệu Gradio</a>. Mỗi thành phần được tạo sẵn có thể được tùy chỉnh bằng cách khởi tạo lớp tương ứng với thành phần.',jt,x,un='Ví dụ: như chúng ta đã thấy trong <a href="/course/chapter9/2">phần trước</a>, thay vì truyền tham số <code>input</code> vào trong <code>&quot;textbox&quot;</code>, bạn có thể truyền vào <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> để tạo một hộp văn bản có 7 dòng và một nhãn.',Jt,q,mn="Hãy xem một ví dụ khác, lần này với thành phần <code>Audio</code>.",bt,A,vt,G,yn=`Như đã đề cập trước đó, Gradio cung cấp nhiều đầu vào và đầu ra khác nhau.
Vì vậy, hãy xây dựng một  <code>Interface</code> hoạt động với âm thanh.`,ft,H,Mn="Trong ví dụ này, chúng tôi sẽ xây dựng một hàm chuyển đổi âm thanh sang âm thanh mà nhận tập tin âm thanh và chỉ cần đảo ngược nó.",Ut,B,dn=`Chúng ta sẽ sử dụng thành phần <code>Audio</code> cho đầu vào. Khi sử dụng thành phần <code>Audio</code>, bạn có thể chỉ định xem bạn có muốn <code>source</code> của âm thanh là một tệp mà người dùng
tải lên hoặc micrô mà người dùng ghi lại giọng nói của họ. Trong trường hợp này, hãy đặt nó thành <code>&quot;microphone&quot;</code>. Chỉ cho vui thôi, chúng ta sẽ thêm một nhãn vào phần  <code>Audio</code> của mình có nội dung “Speak here…”, nghĩa là “Nói ở đây …“.`,It,_,gn=`Ngoài ra, chúng ta muốn nhận âm thanh dưới dạng mảng numpy để ta có thể dễ dàng “đảo ngược” nó lại. Vì vậy, chúng ta sẽ đặt <code>&quot;type&quot;</code> là <code>&quot;numpy&quot;</code>, chuyển đầu vào
dữ liệu dưới dạng một bộ (<code>sample_rate</code>, <code>data</code>) trong hàm của chúng ta.`,Ct,$,Tn="Chúng ta cũng sẽ sử dụng thành phần đầu ra <code>Audio</code> có thể tự động hiển thị một bộ tuple với tốc độ mẫu và mảng dữ liệu phức tạp dưới dạng tệp âm thanh có thể phát. Trong trường hợp này, chúng ta không cần thực hiện bất kỳ tùy chỉnh nào, vì vậy cta sẽ sử dụng chuỗi phím tắt <code>&quot;audio&quot;</code>.",kt,Z,xt,E,wn='Đoạn mã trên sẽ tạo ra một giao diện giống như bên dưới (nếu trình duyệt của bạn không yêu cầu bạn cấp quyền đối với micrô, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">mở bản demo sang một tab khác</a>.)',qt,p,jn,At,L,Jn="Bây giờ bạn có thể ghi lại giọng nói của mình và nghe thấy chính mình đang nói ngược lại - thật ma quái 👻!",Gt,N,Ht,W,bn="Giả sử chúng ta có một hàm phức tạp hơn, với nhiều đầu vào và đầu ra. Trong ví dụ dưới đây, chúng ta có một hàm lấy chỉ mục thả xuống, giá trị thanh trượt và số, và trả về một mẫu âm thanh của một giai điệu âm nhạc.",Bt,R,vn="Hãy xem cách chúng ta chuyển danh sách các thành phần đầu vào và đầu ra, và xem liệu bạn có thể theo dõi những gì đang xảy ra không.",_t,Q,fn="Chìa khóa ở đây là khi bạn truyền vào:",$t,V,Un="<li>danh sách các thành phần đầu vào, mỗi thành phần tương ứng với một tham số theo thứ tự.</li> <li>danh sách các thành phần đầu ra, mỗi thành phần tương ứng với một giá trị trả về.</li>",Zt,S,In="Đoạn mã bên dưới cho thấy cách ba thành phần đầu vào xếp hàng với ba tham số của hàm <code>generate_tone()</code>:",Et,X,Lt,r,Cn,Nt,Y,Wt,P,kn="Cho đến nay, chúng tôi đã sử dụng phương thức <code>launch()</code> để khởi chạy giao diện, nhưng chúng ta chưa thực sự thảo luận về những gì nó làm.",Rt,z,xn="Theo mặc định, phương thức <code>launch()</code> sẽ khởi chạy bản demo trong một máy chủ web đang chạy cục bộ. Nếu bạn đang chạy mã của mình trong notebook Jupyter hoặc Colab, thì Gradio sẽ nhúng GUI demo vào notebook để bạn có thể dễ dàng sử dụng.",Qt,F,qn="Bạn có thể tùy chỉnh hành vi của <code>launch()</code> thông qua các tham số khác nhau:",Vt,D,An="<li><code>inline</code> - có hiển thị giao diện nội tuyến trên notebook Python hay không.</li> <li><code>inbrowser</code> - có tự động khởi chạy giao diện trong tab mới trên trình duyệt mặc định hay không.</li> <li><code>share</code> - có tạo một liên kết có thể chia sẻ công khai từ máy tính của bạn cho giao diện hay không. Giống như một liên kết Google Drive!</li>",St,K,Gn="Chúng tôi sẽ trình bày chi tiết hơn về tham số <code>share</code> trong phần tiếp theo!",Xt,O,Yt,tt,Hn="Hãy xây dựng một giao diện cho phép bạn giới thiệu mô hình <strong>nhận dạng giọng nói</strong>. Để làm cho nó thú vị, chúng ta sẽ chấp nhận hoặc đầu vào micrô hoặc một tệp đã tải lên.",Pt,nt,Bn=`Như thường lệ, chúng ta sẽ tải mô hình nhận dạng giọng nói của mình bằng cách sử dụng hàm <code>pipeline()</code> từ 🤗 Transformers.
Nếu bạn cần cập nhật nhanh, bạn có thể quay lại <a href="/course/chapter1/3">phần đó trong Chương 1</a>. Tiếp theo, chúng ta sẽ triển khai một hàm <code>transcribe_audio()</code> để xử lý âm thanh và trả về phiên âm. Cuối cùng, chúng ta sẽ gói hàm này trong một <code>Interface</code> với các thành phần <code>Audio</code> cho đầu vào và chỉ văn bản cho đầu ra. Nhìn chung, mã cho ứng dụng này như sau:`,zt,et,Ft,lt,_n='Nếu trình duyệt của bạn không yêu cầu bạn cấp quyền đối với micrô, hãy <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">mở bản demo trong một tab riêng</a>.',Dt,u,$n,Kt,st,Zn="Nó đó! Bây giờ bạn có thể sử dụng giao diện này để phiên âm âm thanh. Chú ý ở đây rằng bằng cách đặt tham số <code>option</code> là <code>True</code>, chúng ta cho phép người dùng cung cấp micrô hoặc tệp âm thanh (hoặc không, nhưng điều đó sẽ trả lại thông báo lỗi).",Ot,at,En="Tiếp tục xem cách chia sẻ giao diện của bạn với những người khác!",tn,ht,nn;return j=new it({props:{title:"Hiểu lớp Interface",local:"hiểu-lớp-interface",headingTag:"h1"}}),J=new Xn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/vi/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/vi/chapter9/section3.ipynb"}]}}),v=new it({props:{title:"Cách tạo một Interface",local:"cách-tạo-một-interface",headingTag:"h2"}}),A=new it({props:{title:"Một ví dụ đơn giản với âm thanh",local:"một-ví-dụ-đơn-giản-với-âm-thanh",headingTag:"h2"}}),Z=new ln({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),N=new it({props:{title:"Xử lý nhiều đầu vào và đầu ra",local:"xử-lý-nhiều-đầu-vào-và-đầu-ra",headingTag:"h2"}}),X=new ln({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3godHlwZSUzRCUyMm51bWJlciUyMiUyQyUyMHZhbHVlJTNEMSUyQyUyMGxhYmVsJTNEJTIyRHVyYXRpb24lMjBpbiUyMHNlY29uZHMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8lMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Textbox(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;number&quot;</span>, value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),Y=new it({props:{title:"Phương thức launch()",local:"phương-thức-launch",headingTag:"h3"}}),O=new it({props:{title:"✏️ Hãy áp dụng nó!",local:"-hãy-áp-dụng-nó",headingTag:"h2"}}),et=new ln({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKG1pYyUzRE5vbmUlMkMlMjBmaWxlJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG1pYyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbWljJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGZpbGUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyWW91JTIwbXVzdCUyMGVpdGhlciUyMHByb3ZpZGUlMjBhJTIwbWljJTIwcmVjb3JkaW5nJTIwb3IlMjBhJTIwZmlsZSUyMiUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2UlM0QlMjJtaWNyb3Bob25lJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyJTJDJTIwb3B0aW9uYWwlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiUyQyUyMG9wdGlvbmFsJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIydGV4dCUyMiUyQyUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">mic=<span class="hljs-literal">None</span>, file=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> mic <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = mic
    <span class="hljs-keyword">elif</span> file <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = file
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;You must either provide a mic recording or a file&quot;</span>
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=[
        gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
        gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
    ],
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),{c(){w=i("meta"),pt=s(),ot=i("p"),rt=s(),m(j.$$.fragment),ut=s(),m(J.$$.fragment),mt=s(),b=i("p"),b.innerHTML=an,yt=s(),m(v.$$.fragment),Mt=s(),f=i("p"),f.innerHTML=on,dt=s(),U=i("p"),U.innerHTML=hn,gt=s(),I=i("p"),I.textContent=cn,Tt=s(),C=i("ul"),C.innerHTML=pn,wt=s(),k=i("p"),k.innerHTML=rn,jt=s(),x=i("p"),x.innerHTML=un,Jt=s(),q=i("p"),q.innerHTML=mn,bt=s(),m(A.$$.fragment),vt=s(),G=i("p"),G.innerHTML=yn,ft=s(),H=i("p"),H.textContent=Mn,Ut=s(),B=i("p"),B.innerHTML=dn,It=s(),_=i("p"),_.innerHTML=gn,Ct=s(),$=i("p"),$.innerHTML=Tn,kt=s(),m(Z.$$.fragment),xt=s(),E=i("p"),E.innerHTML=wn,qt=s(),p=i("iframe"),At=s(),L=i("p"),L.textContent=Jn,Gt=s(),m(N.$$.fragment),Ht=s(),W=i("p"),W.textContent=bn,Bt=s(),R=i("p"),R.textContent=vn,_t=s(),Q=i("p"),Q.textContent=fn,$t=s(),V=i("ul"),V.innerHTML=Un,Zt=s(),S=i("p"),S.innerHTML=In,Et=s(),m(X.$$.fragment),Lt=s(),r=i("iframe"),Nt=s(),m(Y.$$.fragment),Wt=s(),P=i("p"),P.innerHTML=kn,Rt=s(),z=i("p"),z.innerHTML=xn,Qt=s(),F=i("p"),F.innerHTML=qn,Vt=s(),D=i("ul"),D.innerHTML=An,St=s(),K=i("p"),K.innerHTML=Gn,Xt=s(),m(O.$$.fragment),Yt=s(),tt=i("p"),tt.innerHTML=Hn,Pt=s(),nt=i("p"),nt.innerHTML=Bn,zt=s(),m(et.$$.fragment),Ft=s(),lt=i("p"),lt.innerHTML=_n,Dt=s(),u=i("iframe"),Kt=s(),st=i("p"),st.innerHTML=Zn,Ot=s(),at=i("p"),at.textContent=En,tn=s(),ht=i("p"),this.h()},l(t){const n=Vn("svelte-u9bgzb",document.head);w=o(n,"META",{name:!0,content:!0}),n.forEach(e),pt=a(t),ot=o(t,"P",{}),ct(ot).forEach(e),rt=a(t),y(j.$$.fragment,t),ut=a(t),y(J.$$.fragment,t),mt=a(t),b=o(t,"P",{"data-svelte-h":!0}),h(b)!=="svelte-xe96uk"&&(b.innerHTML=an),yt=a(t),y(v.$$.fragment,t),Mt=a(t),f=o(t,"P",{"data-svelte-h":!0}),h(f)!=="svelte-1cjdu40"&&(f.innerHTML=on),dt=a(t),U=o(t,"P",{"data-svelte-h":!0}),h(U)!=="svelte-5xxju6"&&(U.innerHTML=hn),gt=a(t),I=o(t,"P",{"data-svelte-h":!0}),h(I)!=="svelte-xqxlrw"&&(I.textContent=cn),Tt=a(t),C=o(t,"UL",{"data-svelte-h":!0}),h(C)!=="svelte-x74dgj"&&(C.innerHTML=pn),wt=a(t),k=o(t,"P",{"data-svelte-h":!0}),h(k)!=="svelte-1sk6bds"&&(k.innerHTML=rn),jt=a(t),x=o(t,"P",{"data-svelte-h":!0}),h(x)!=="svelte-1b5q675"&&(x.innerHTML=un),Jt=a(t),q=o(t,"P",{"data-svelte-h":!0}),h(q)!=="svelte-1wnp7jd"&&(q.innerHTML=mn),bt=a(t),y(A.$$.fragment,t),vt=a(t),G=o(t,"P",{"data-svelte-h":!0}),h(G)!=="svelte-f05xnr"&&(G.innerHTML=yn),ft=a(t),H=o(t,"P",{"data-svelte-h":!0}),h(H)!=="svelte-l08naj"&&(H.textContent=Mn),Ut=a(t),B=o(t,"P",{"data-svelte-h":!0}),h(B)!=="svelte-1pxvmk3"&&(B.innerHTML=dn),It=a(t),_=o(t,"P",{"data-svelte-h":!0}),h(_)!=="svelte-j9pi35"&&(_.innerHTML=gn),Ct=a(t),$=o(t,"P",{"data-svelte-h":!0}),h($)!=="svelte-7m2l6g"&&($.innerHTML=Tn),kt=a(t),y(Z.$$.fragment,t),xt=a(t),E=o(t,"P",{"data-svelte-h":!0}),h(E)!=="svelte-16fqgts"&&(E.innerHTML=wn),qt=a(t),p=o(t,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ct(p).forEach(e),At=a(t),L=o(t,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1q6fanq"&&(L.textContent=Jn),Gt=a(t),y(N.$$.fragment,t),Ht=a(t),W=o(t,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1ripq4o"&&(W.textContent=bn),Bt=a(t),R=o(t,"P",{"data-svelte-h":!0}),h(R)!=="svelte-1n0hhrk"&&(R.textContent=vn),_t=a(t),Q=o(t,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-e4msx3"&&(Q.textContent=fn),$t=a(t),V=o(t,"UL",{"data-svelte-h":!0}),h(V)!=="svelte-27kd5i"&&(V.innerHTML=Un),Zt=a(t),S=o(t,"P",{"data-svelte-h":!0}),h(S)!=="svelte-12b4chk"&&(S.innerHTML=In),Et=a(t),y(X.$$.fragment,t),Lt=a(t),r=o(t,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ct(r).forEach(e),Nt=a(t),y(Y.$$.fragment,t),Wt=a(t),P=o(t,"P",{"data-svelte-h":!0}),h(P)!=="svelte-1e24e0s"&&(P.innerHTML=kn),Rt=a(t),z=o(t,"P",{"data-svelte-h":!0}),h(z)!=="svelte-ss0j09"&&(z.innerHTML=xn),Qt=a(t),F=o(t,"P",{"data-svelte-h":!0}),h(F)!=="svelte-1n38ln1"&&(F.innerHTML=qn),Vt=a(t),D=o(t,"UL",{"data-svelte-h":!0}),h(D)!=="svelte-wa3lyf"&&(D.innerHTML=An),St=a(t),K=o(t,"P",{"data-svelte-h":!0}),h(K)!=="svelte-597w6a"&&(K.innerHTML=Gn),Xt=a(t),y(O.$$.fragment,t),Yt=a(t),tt=o(t,"P",{"data-svelte-h":!0}),h(tt)!=="svelte-znezbr"&&(tt.innerHTML=Hn),Pt=a(t),nt=o(t,"P",{"data-svelte-h":!0}),h(nt)!=="svelte-1d14t68"&&(nt.innerHTML=Bn),zt=a(t),y(et.$$.fragment,t),Ft=a(t),lt=o(t,"P",{"data-svelte-h":!0}),h(lt)!=="svelte-w71vac"&&(lt.innerHTML=_n),Dt=a(t),u=o(t,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ct(u).forEach(e),Kt=a(t),st=o(t,"P",{"data-svelte-h":!0}),h(st)!=="svelte-o3694q"&&(st.innerHTML=Zn),Ot=a(t),at=o(t,"P",{"data-svelte-h":!0}),h(at)!=="svelte-1mcu745"&&(at.textContent=En),tn=a(t),ht=o(t,"P",{}),ct(ht).forEach(e),this.h()},h(){c(w,"name","hf:doc:metadata"),c(w,"content",Pn),en(p.src,jn="https://course-demos-audio-reverse.hf.space")||c(p,"src",jn),c(p,"frameborder","0"),c(p,"height","250"),c(p,"title","Gradio app"),c(p,"class","container p-0 flex-grow space-iframe"),c(p,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),c(p,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),en(r.src,Cn="https://course-demos-generate-tone.hf.space")||c(r,"src",Cn),c(r,"frameborder","0"),c(r,"height","450"),c(r,"title","Gradio app"),c(r,"class","container p-0 flex-grow space-iframe"),c(r,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),c(r,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),en(u.src,$n="https://course-demos-asr.hf.space")||c(u,"src",$n),c(u,"frameborder","0"),c(u,"height","550"),c(u,"title","Gradio app"),c(u,"class","container p-0 flex-grow space-iframe"),c(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),c(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(t,n){Sn(document.head,w),l(t,pt,n),l(t,ot,n),l(t,rt,n),M(j,t,n),l(t,ut,n),M(J,t,n),l(t,mt,n),l(t,b,n),l(t,yt,n),M(v,t,n),l(t,Mt,n),l(t,f,n),l(t,dt,n),l(t,U,n),l(t,gt,n),l(t,I,n),l(t,Tt,n),l(t,C,n),l(t,wt,n),l(t,k,n),l(t,jt,n),l(t,x,n),l(t,Jt,n),l(t,q,n),l(t,bt,n),M(A,t,n),l(t,vt,n),l(t,G,n),l(t,ft,n),l(t,H,n),l(t,Ut,n),l(t,B,n),l(t,It,n),l(t,_,n),l(t,Ct,n),l(t,$,n),l(t,kt,n),M(Z,t,n),l(t,xt,n),l(t,E,n),l(t,qt,n),l(t,p,n),l(t,At,n),l(t,L,n),l(t,Gt,n),M(N,t,n),l(t,Ht,n),l(t,W,n),l(t,Bt,n),l(t,R,n),l(t,_t,n),l(t,Q,n),l(t,$t,n),l(t,V,n),l(t,Zt,n),l(t,S,n),l(t,Et,n),M(X,t,n),l(t,Lt,n),l(t,r,n),l(t,Nt,n),M(Y,t,n),l(t,Wt,n),l(t,P,n),l(t,Rt,n),l(t,z,n),l(t,Qt,n),l(t,F,n),l(t,Vt,n),l(t,D,n),l(t,St,n),l(t,K,n),l(t,Xt,n),M(O,t,n),l(t,Yt,n),l(t,tt,n),l(t,Pt,n),l(t,nt,n),l(t,zt,n),M(et,t,n),l(t,Ft,n),l(t,lt,n),l(t,Dt,n),l(t,u,n),l(t,Kt,n),l(t,st,n),l(t,Ot,n),l(t,at,n),l(t,tn,n),l(t,ht,n),nn=!0},p:Nn,i(t){nn||(d(j.$$.fragment,t),d(J.$$.fragment,t),d(v.$$.fragment,t),d(A.$$.fragment,t),d(Z.$$.fragment,t),d(N.$$.fragment,t),d(X.$$.fragment,t),d(Y.$$.fragment,t),d(O.$$.fragment,t),d(et.$$.fragment,t),nn=!0)},o(t){g(j.$$.fragment,t),g(J.$$.fragment,t),g(v.$$.fragment,t),g(A.$$.fragment,t),g(Z.$$.fragment,t),g(N.$$.fragment,t),g(X.$$.fragment,t),g(Y.$$.fragment,t),g(O.$$.fragment,t),g(et.$$.fragment,t),nn=!1},d(t){t&&(e(pt),e(ot),e(rt),e(ut),e(mt),e(b),e(yt),e(Mt),e(f),e(dt),e(U),e(gt),e(I),e(Tt),e(C),e(wt),e(k),e(jt),e(x),e(Jt),e(q),e(bt),e(vt),e(G),e(ft),e(H),e(Ut),e(B),e(It),e(_),e(Ct),e($),e(kt),e(xt),e(E),e(qt),e(p),e(At),e(L),e(Gt),e(Ht),e(W),e(Bt),e(R),e(_t),e(Q),e($t),e(V),e(Zt),e(S),e(Et),e(Lt),e(r),e(Nt),e(Wt),e(P),e(Rt),e(z),e(Qt),e(F),e(Vt),e(D),e(St),e(K),e(Xt),e(Yt),e(tt),e(Pt),e(nt),e(zt),e(Ft),e(lt),e(Dt),e(u),e(Kt),e(st),e(Ot),e(at),e(tn),e(ht)),e(w),T(j,t),T(J,t),T(v,t),T(A,t),T(Z,t),T(N,t),T(X,t),T(Y,t),T(O,t),T(et,t)}}}const Pn='{"title":"Hiểu lớp Interface","local":"hiểu-lớp-interface","sections":[{"title":"Cách tạo một Interface","local":"cách-tạo-một-interface","sections":[],"depth":2},{"title":"Một ví dụ đơn giản với âm thanh","local":"một-ví-dụ-đơn-giản-với-âm-thanh","sections":[],"depth":2},{"title":"Xử lý nhiều đầu vào và đầu ra","local":"xử-lý-nhiều-đầu-vào-và-đầu-ra","sections":[{"title":"Phương thức launch()","local":"phương-thức-launch","sections":[],"depth":3}],"depth":2},{"title":"✏️ Hãy áp dụng nó!","local":"-hãy-áp-dụng-nó","sections":[],"depth":2}],"depth":1}';function zn(sn){return Wn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ne extends Rn{constructor(w){super(),Qn(this,w,zn,Yn,Ln,{})}}export{ne as component};
