import{s as ue,n as we,o as Je}from"../chunks/scheduler.39a43cde.js";import{S as je,i as be,g as y,s as a,r as p,A as Ue,h,f as t,c as n,j as ce,u as i,x as c,k as ge,y as fe,a as l,v as m,d,t as o,w as r}from"../chunks/index.23ec2204.js";import{D as Ze,C as M}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as Ds}from"../chunks/Heading.c42e7061.js";function Te(Os){let g,is,ns,ms,u,ds,w,os,J,se=`Embeddings are semantically meaningful compressions of information. They can be used to do similarity search, zero-shot classification or simply train a new model. Use cases for similarity search include searching for similar products in e-commerce, content search in social media and more.
This notebook walks you through using 🤗transformers, 🤗datasets and FAISS to create and index embeddings from a feature extraction model to later use them for similarity search.
Let’s install necessary libraries.`,rs,j,Ms,b,ee='For this tutorial, we will use <a href="https://huggingface.co/openai/clip-vit-base-patch16" rel="nofollow">CLIP model</a> to extract the features. CLIP is a revolutionary model that introduced joint training of a text encoder and an image encoder to connect two modalities.',ys,U,hs,f,te='Load the dataset. To keep this notebook light, we will use a small captioning dataset, <a href="https://huggingface.co/datasets/jmhessel/newyorker_caption_contest" rel="nofollow">jmhessel/newyorker_caption_contest</a>.',cs,Z,gs,T,le="See an example.",us,$,ws,C,Js,I,ae="We don’t have to write any function to embed examples or create an index. 🤗 datasets library’s FAISS integration abstracts these processes. We can simply use <code>map</code> method of the dataset to create a new column with the embeddings for each example like below. Let’s create one for text features on the prompt column.",js,W,bs,k,Us,G,ne="We can do the same and get the image embeddings.",fs,_,Zs,V,Ts,X,$s,R,pe="We can now query the dataset with text or image to get similar items from it.",Cs,B,Is,q,Ws,Q,ie=`['A man is in the snow. A boy with a huge snow shovel is there too. They are outside a house.']
`,ks,v,Gs,A,me="Image similarity inference is similar, where you just call <code>get_image_features</code>.",_s,N,Vs,x,de="Search for the similar image.",Xs,z,Rs,F,oe="Display the most similar image to the beaver image.",Bs,Y,qs,S,re=`['Salmon swim upstream but they see a grizzly bear and are in shock. The bear has a smug look on his face when he sees the salmon.']
`,Qs,E,vs,H,Me="We can save the dataset with embeddings with <code>save_faiss_index</code>.",As,L,Ns,K,xs,P,ye=`It’s a good practice to store the embeddings in a dataset repository, so we will create one and push our embeddings there to pull later.
We will login to Hugging Face Hub, create a dataset repository there and push our indexes there and load using <code>snapshot_download</code>.`,zs,D,Fs,O,Ys,ss,Ss,es,he="We can load the embeddings to the dataset with no embeddings using <code>load_faiss_index</code>.",Es,ts,Hs,ls,Ls,as,Ks,ps,Ps;return u=new Ze({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/FAISS_with_HF_datasets_and_CLIP.ipynb"}]}}),w=new Ds({props:{title:"Embedding multimodal data for similarity search using 🤗 transformers, 🤗 datasets and FAISS",local:"embedding-multimodal-data-for-similarity-search-using--transformers--datasets-and-faiss",headingTag:"h1"}}),j=new M({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGRhdGFzZXRzJTIwZmFpc3MtZ3B1JTIwdHJhbnNmb3JtZXJzJTIwc2VudGVuY2VwaWVjZQ==",highlighted:"!pip install -q datasets faiss-gpu transformers sentencepiece",wrap:!1}}),U=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ltYWdlUHJvY2Vzc29yJTJDJTIwQXV0b01vZGVsJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMGZhaXNzJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZjbGlwLXZpdC1iYXNlLXBhdGNoMTYlMjIpLnRvKGRldmljZSklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRmNsaXAtdml0LWJhc2UtcGF0Y2gxNiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZjbGlwLXZpdC1iYXNlLXBhdGNoMTYlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel, AutoTokenizer
<span class="hljs-keyword">import</span> faiss
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>).to(device)
processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>)`,wrap:!1}}),Z=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyam1oZXNzZWwlMkZuZXd5b3JrZXJfY2FwdGlvbl9jb250ZXN0JTIyJTJDJTIwJTIyZXhwbGFuYXRpb24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;jmhessel/newyorker_caption_contest&quot;</span>, <span class="hljs-string">&quot;explanation&quot;</span>)`,wrap:!1}}),$=new M({props:{code:"ZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQlNUIlMjJpbWFnZSUyMiU1RA==",highlighted:'ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]',wrap:!1}}),C=new M({props:{code:"ZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQlNUIlMjJpbWFnZV9kZXNjcmlwdGlvbiUyMiU1RA==",highlighted:'ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image_description&quot;</span>]',wrap:!1}}),W=new M({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRzJTVCJTIydHJhaW4lMjIlNUQlMEFkc193aXRoX2VtYmVkZGluZ3MlMjAlM0QlMjBkYXRhc2V0Lm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjBleGFtcGxlJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW1iZWRkaW5ncyUyMiUzQSUyMG1vZGVsLmdldF90ZXh0X2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCoqdG9rZW5pemVyKCU1QmV4YW1wbGUlNUIlMjJpbWFnZV9kZXNjcmlwdGlvbiUyMiU1RCU1RCUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC5kZXRhY2goKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC5jcHUoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC5udW1weSgpJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`dataset = ds[<span class="hljs-string">&quot;train&quot;</span>]
ds_with_embeddings = dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> example: {
        <span class="hljs-string">&quot;embeddings&quot;</span>: model.get_text_features(
            **tokenizer([example[<span class="hljs-string">&quot;image_description&quot;</span>]], truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
        )[<span class="hljs-number">0</span>]
        .detach()
        .cpu()
        .numpy()
    }
)`,wrap:!1}}),k=new M({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzLmFkZF9mYWlzc19pbmRleChjb2x1bW4lM0QlMjJlbWJlZGRpbmdzJTIyKQ==",highlighted:'ds_with_embeddings.add_faiss_index(column=<span class="hljs-string">&quot;embeddings&quot;</span>)',wrap:!1}}),_=new M({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzJTIwJTNEJTIwZHNfd2l0aF9lbWJlZGRpbmdzLm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjBleGFtcGxlJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW1hZ2VfZW1iZWRkaW5ncyUyMiUzQSUyMG1vZGVsLmdldF9pbWFnZV9mZWF0dXJlcygqKnByb2Nlc3NvciglNUJleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSklNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLmRldGFjaCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLmNwdSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLm51bXB5KCklMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`ds_with_embeddings = ds_with_embeddings.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> example: {
        <span class="hljs-string">&quot;image_embeddings&quot;</span>: model.get_image_features(**processor([example[<span class="hljs-string">&quot;image&quot;</span>]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[
            <span class="hljs-number">0</span>
        ]
        .detach()
        .cpu()
        .numpy()
    }
)`,wrap:!1}}),V=new M({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzLmFkZF9mYWlzc19pbmRleChjb2x1bW4lM0QlMjJpbWFnZV9lbWJlZGRpbmdzJTIyKQ==",highlighted:'ds_with_embeddings.add_faiss_index(column=<span class="hljs-string">&quot;image_embeddings&quot;</span>)',wrap:!1}}),X=new Ds({props:{title:"Querying the data with text prompts",local:"querying-the-data-with-text-prompts",headingTag:"h2"}}),B=new M({props:{code:"cHJtdCUyMCUzRCUyMCUyMmElMjBzbm93eSUyMGRheSUyMiUwQXBybXRfZW1iZWRkaW5nJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMG1vZGVsLmdldF90ZXh0X2ZlYXR1cmVzKCoqdG9rZW5pemVyKCU1QnBybXQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpLnRvKCUyMmN1ZGElMjIpKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAuZGV0YWNoKCklMEElMjAlMjAlMjAlMjAuY3B1KCklMEElMjAlMjAlMjAlMjAubnVtcHkoKSUwQSklMEFzY29yZXMlMkMlMjByZXRyaWV2ZWRfZXhhbXBsZXMlMjAlM0QlMjBkc193aXRoX2VtYmVkZGluZ3MuZ2V0X25lYXJlc3RfZXhhbXBsZXMoJTIyZW1iZWRkaW5ncyUyMiUyQyUyMHBybXRfZW1iZWRkaW5nJTJDJTIwayUzRDEp",highlighted:`prmt = <span class="hljs-string">&quot;a snowy day&quot;</span>
prmt_embedding = (
    model.get_text_features(**tokenizer([prmt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, truncation=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[<span class="hljs-number">0</span>]
    .detach()
    .cpu()
    .numpy()
)
scores, retrieved_examples = ds_with_embeddings.get_nearest_examples(<span class="hljs-string">&quot;embeddings&quot;</span>, prmt_embedding, k=<span class="hljs-number">1</span>)`,wrap:!1}}),q=new M({props:{code:"ZGVmJTIwZG93bnNjYWxlX2ltYWdlcyhpbWFnZSklM0ElMEElMjAlMjAlMjAlMjB3aWR0aCUyMCUzRCUyMDIwMCUwQSUyMCUyMCUyMCUyMHJhdGlvJTIwJTNEJTIwd2lkdGglMjAlMkYlMjBmbG9hdChpbWFnZS5zaXplJTVCMCU1RCklMEElMjAlMjAlMjAlMjBoZWlnaHQlMjAlM0QlMjBpbnQoKGZsb2F0KGltYWdlLnNpemUlNUIxJTVEKSUyMColMjBmbG9hdChyYXRpbykpKSUwQSUyMCUyMCUyMCUyMGltZyUyMCUzRCUyMGltYWdlLnJlc2l6ZSgod2lkdGglMkMlMjBoZWlnaHQpJTJDJTIwSW1hZ2UuUmVzYW1wbGluZy5MQU5DWk9TKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGltZyUwQSUwQSUwQWltYWdlcyUyMCUzRCUyMCU1QmRvd25zY2FsZV9pbWFnZXMoaW1hZ2UpJTIwZm9yJTIwaW1hZ2UlMjBpbiUyMHJldHJpZXZlZF9leGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIzJTIwc2VlJTIwdGhlJTIwY2xvc2VzdCUyMHRleHQlMjBhbmQlMjBpbWFnZSUwQXByaW50KHJldHJpZXZlZF9leGFtcGxlcyU1QiUyMmltYWdlX2Rlc2NyaXB0aW9uJTIyJTVEKSUwQWRpc3BsYXkoaW1hZ2VzJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">downscale_images</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    width = <span class="hljs-number">200</span>
<span class="hljs-meta">... </span>    ratio = width / <span class="hljs-built_in">float</span>(image.size[<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>    height = <span class="hljs-built_in">int</span>((<span class="hljs-built_in">float</span>(image.size[<span class="hljs-number">1</span>]) * <span class="hljs-built_in">float</span>(ratio)))
<span class="hljs-meta">... </span>    img = image.resize((width, height), Image.Resampling.LANCZOS)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> img


<span class="hljs-meta">&gt;&gt;&gt; </span>images = [downscale_images(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> retrieved_examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see the closest text and image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_examples[<span class="hljs-string">&quot;image_description&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>display(images[<span class="hljs-number">0</span>])`,wrap:!1}}),v=new Ds({props:{title:"Querying the data with image prompts",local:"querying-the-data-with-image-prompts",headingTag:"h2"}}),N=new M({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMjMlMjBpbWFnZSUyMG9mJTIwYSUyMGJlYXZlciUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnRyYW5zZm9ybWVycyUyRmJlYXZlci5wbmclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFkaXNwbGF5KGRvd25zY2FsZV9pbWFnZXMoaW1hZ2UpKQ==",highlighted:`<span class="hljs-keyword">import</span> requests

<span class="hljs-comment"># image of a beaver</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/beaver.png&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
display(downscale_images(image))`,wrap:!1}}),z=new M({props:{code:"aW1nX2VtYmVkZGluZyUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjBtb2RlbC5nZXRfaW1hZ2VfZmVhdHVyZXMoKipwcm9jZXNzb3IoJTVCaW1hZ2UlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpLnRvKCUyMmN1ZGElMjIpKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAuZGV0YWNoKCklMEElMjAlMjAlMjAlMjAuY3B1KCklMEElMjAlMjAlMjAlMjAubnVtcHkoKSUwQSklMEFzY29yZXMlMkMlMjByZXRyaWV2ZWRfZXhhbXBsZXMlMjAlM0QlMjBkc193aXRoX2VtYmVkZGluZ3MuZ2V0X25lYXJlc3RfZXhhbXBsZXMoJTIyaW1hZ2VfZW1iZWRkaW5ncyUyMiUyQyUyMGltZ19lbWJlZGRpbmclMkMlMjBrJTNEMSk=",highlighted:`img_embedding = (
    model.get_image_features(**processor([image], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, truncation=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[<span class="hljs-number">0</span>]
    .detach()
    .cpu()
    .numpy()
)
scores, retrieved_examples = ds_with_embeddings.get_nearest_examples(<span class="hljs-string">&quot;image_embeddings&quot;</span>, img_embedding, k=<span class="hljs-number">1</span>)`,wrap:!1}}),Y=new M({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCZG93bnNjYWxlX2ltYWdlcyhpbWFnZSklMjBmb3IlMjBpbWFnZSUyMGluJTIwcmV0cmlldmVkX2V4YW1wbGVzJTVCJTIyaW1hZ2UlMjIlNUQlNUQlMEElMjMlMjBzZWUlMjB0aGUlMjBjbG9zZXN0JTIwdGV4dCUyMGFuZCUyMGltYWdlJTBBcHJpbnQocmV0cmlldmVkX2V4YW1wbGVzJTVCJTIyaW1hZ2VfZGVzY3JpcHRpb24lMjIlNUQpJTBBZGlzcGxheShpbWFnZXMlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>images = [downscale_images(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> retrieved_examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see the closest text and image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_examples[<span class="hljs-string">&quot;image_description&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>display(images[<span class="hljs-number">0</span>])`,wrap:!1}}),E=new Ds({props:{title:"Saving, pushing and loading the embeddings",local:"saving-pushing-and-loading-the-embeddings",headingTag:"h2"}}),L=new M({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzLnNhdmVfZmFpc3NfaW5kZXgoJTIyZW1iZWRkaW5ncyUyMiUyQyUyMCUyMmVtYmVkZGluZ3MlMkZlbWJlZGRpbmdzLmZhaXNzJTIyKQ==",highlighted:'ds_with_embeddings.save_faiss_index(<span class="hljs-string">&quot;embeddings&quot;</span>, <span class="hljs-string">&quot;embeddings/embeddings.faiss&quot;</span>)',wrap:!1}}),K=new M({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzLnNhdmVfZmFpc3NfaW5kZXgoJTIyaW1hZ2VfZW1iZWRkaW5ncyUyMiUyQyUyMCUyMmVtYmVkZGluZ3MlMkZpbWFnZV9lbWJlZGRpbmdzLmZhaXNzJTIyKQ==",highlighted:'ds_with_embeddings.save_faiss_index(<span class="hljs-string">&quot;image_embeddings&quot;</span>, <span class="hljs-string">&quot;embeddings/image_embeddings.faiss&quot;</span>)',wrap:!1}}),D=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwbm90ZWJvb2tfbG9naW4lMkMlMjBzbmFwc2hvdF9kb3dubG9hZCUwQSUwQW5vdGVib29rX2xvZ2luKCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, notebook_login, snapshot_download

notebook_login()`,wrap:!1}}),O=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5jcmVhdGVfcmVwbyglMjJtZXJ2ZSUyRmZhaXNzX2VtYmVkZGluZ3MlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKSUwQWFwaS51cGxvYWRfZm9sZGVyKCUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEJTIyLiUyRmVtYmVkZGluZ3MlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIybWVydmUlMkZmYWlzc19lbWJlZGRpbmdzJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

api = HfApi()
api.create_repo(<span class="hljs-string">&quot;merve/faiss_embeddings&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
api.upload_folder(
    folder_path=<span class="hljs-string">&quot;./embeddings&quot;</span>,
    repo_id=<span class="hljs-string">&quot;merve/faiss_embeddings&quot;</span>,
    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
)`,wrap:!1}}),ss=new M({props:{code:"c25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMm1lcnZlJTJGZmFpc3NfZW1iZWRkaW5ncyUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMjBsb2NhbF9kaXIlM0QlMjJkb3dubG9hZGVkX2VtYmVkZGluZ3MlMjIp",highlighted:'snapshot_download(repo_id=<span class="hljs-string">&quot;merve/faiss_embeddings&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, local_dir=<span class="hljs-string">&quot;downloaded_embeddings&quot;</span>)',wrap:!1}}),ts=new M({props:{code:"ZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVEJTBBZHMubG9hZF9mYWlzc19pbmRleCglMjJlbWJlZGRpbmdzJTIyJTJDJTIwJTIyLiUyRmRvd25sb2FkZWRfZW1iZWRkaW5ncyUyRmVtYmVkZGluZ3MuZmFpc3MlMjIpJTBBJTIzJTIwaW5mZXIlMjBhZ2FpbiUwQXBybXQlMjAlM0QlMjAlMjJwZW9wbGUlMjB1bmRlciUyMHRoZSUyMHJhaW4lMjI=",highlighted:`ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
ds.load_faiss_index(<span class="hljs-string">&quot;embeddings&quot;</span>, <span class="hljs-string">&quot;./downloaded_embeddings/embeddings.faiss&quot;</span>)
<span class="hljs-comment"># infer again</span>
prmt = <span class="hljs-string">&quot;people under the rain&quot;</span>`,wrap:!1}}),ls=new M({props:{code:"cHJtdF9lbWJlZGRpbmclMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwbW9kZWwuZ2V0X3RleHRfZmVhdHVyZXMoKip0b2tlbml6ZXIoJTVCcHJtdCU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSkudG8oJTIyY3VkYSUyMikpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMC5kZXRhY2goKSUwQSUyMCUyMCUyMCUyMC5jcHUoKSUwQSUyMCUyMCUyMCUyMC5udW1weSgpJTBBKSUwQSUwQXNjb3JlcyUyQyUyMHJldHJpZXZlZF9leGFtcGxlcyUyMCUzRCUyMGRzLmdldF9uZWFyZXN0X2V4YW1wbGVzKCUyMmVtYmVkZGluZ3MlMjIlMkMlMjBwcm10X2VtYmVkZGluZyUyQyUyMGslM0QxKQ==",highlighted:`prmt_embedding = (
    model.get_text_features(**tokenizer([prmt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, truncation=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[<span class="hljs-number">0</span>]
    .detach()
    .cpu()
    .numpy()
)

scores, retrieved_examples = ds.get_nearest_examples(<span class="hljs-string">&quot;embeddings&quot;</span>, prmt_embedding, k=<span class="hljs-number">1</span>)`,wrap:!1}}),as=new M({props:{code:"ZGlzcGxheShyZXRyaWV2ZWRfZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQp",highlighted:'display(retrieved_examples[<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>])',wrap:!1}}),{c(){g=y("meta"),is=a(),ns=y("p"),ms=a(),p(u.$$.fragment),ds=a(),p(w.$$.fragment),os=a(),J=y("p"),J.textContent=se,rs=a(),p(j.$$.fragment),Ms=a(),b=y("p"),b.innerHTML=ee,ys=a(),p(U.$$.fragment),hs=a(),f=y("p"),f.innerHTML=te,cs=a(),p(Z.$$.fragment),gs=a(),T=y("p"),T.textContent=le,us=a(),p($.$$.fragment),ws=a(),p(C.$$.fragment),Js=a(),I=y("p"),I.innerHTML=ae,js=a(),p(W.$$.fragment),bs=a(),p(k.$$.fragment),Us=a(),G=y("p"),G.textContent=ne,fs=a(),p(_.$$.fragment),Zs=a(),p(V.$$.fragment),Ts=a(),p(X.$$.fragment),$s=a(),R=y("p"),R.textContent=pe,Cs=a(),p(B.$$.fragment),Is=a(),p(q.$$.fragment),Ws=a(),Q=y("pre"),Q.textContent=ie,ks=a(),p(v.$$.fragment),Gs=a(),A=y("p"),A.innerHTML=me,_s=a(),p(N.$$.fragment),Vs=a(),x=y("p"),x.textContent=de,Xs=a(),p(z.$$.fragment),Rs=a(),F=y("p"),F.textContent=oe,Bs=a(),p(Y.$$.fragment),qs=a(),S=y("pre"),S.textContent=re,Qs=a(),p(E.$$.fragment),vs=a(),H=y("p"),H.innerHTML=Me,As=a(),p(L.$$.fragment),Ns=a(),p(K.$$.fragment),xs=a(),P=y("p"),P.innerHTML=ye,zs=a(),p(D.$$.fragment),Fs=a(),p(O.$$.fragment),Ys=a(),p(ss.$$.fragment),Ss=a(),es=y("p"),es.innerHTML=he,Es=a(),p(ts.$$.fragment),Hs=a(),p(ls.$$.fragment),Ls=a(),p(as.$$.fragment),Ks=a(),ps=y("p"),this.h()},l(s){const e=Ue("svelte-u9bgzb",document.head);g=h(e,"META",{name:!0,content:!0}),e.forEach(t),is=n(s),ns=h(s,"P",{}),ce(ns).forEach(t),ms=n(s),i(u.$$.fragment,s),ds=n(s),i(w.$$.fragment,s),os=n(s),J=h(s,"P",{"data-svelte-h":!0}),c(J)!=="svelte-zwp9uq"&&(J.textContent=se),rs=n(s),i(j.$$.fragment,s),Ms=n(s),b=h(s,"P",{"data-svelte-h":!0}),c(b)!=="svelte-sn5lc0"&&(b.innerHTML=ee),ys=n(s),i(U.$$.fragment,s),hs=n(s),f=h(s,"P",{"data-svelte-h":!0}),c(f)!=="svelte-1wmuyvg"&&(f.innerHTML=te),cs=n(s),i(Z.$$.fragment,s),gs=n(s),T=h(s,"P",{"data-svelte-h":!0}),c(T)!=="svelte-1gyk1gq"&&(T.textContent=le),us=n(s),i($.$$.fragment,s),ws=n(s),i(C.$$.fragment,s),Js=n(s),I=h(s,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1t8sl7t"&&(I.innerHTML=ae),js=n(s),i(W.$$.fragment,s),bs=n(s),i(k.$$.fragment,s),Us=n(s),G=h(s,"P",{"data-svelte-h":!0}),c(G)!=="svelte-hqeotv"&&(G.textContent=ne),fs=n(s),i(_.$$.fragment,s),Zs=n(s),i(V.$$.fragment,s),Ts=n(s),i(X.$$.fragment,s),$s=n(s),R=h(s,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1ik94z"&&(R.textContent=pe),Cs=n(s),i(B.$$.fragment,s),Is=n(s),i(q.$$.fragment,s),Ws=n(s),Q=h(s,"PRE",{"data-svelte-h":!0}),c(Q)!=="svelte-uwozqd"&&(Q.textContent=ie),ks=n(s),i(v.$$.fragment,s),Gs=n(s),A=h(s,"P",{"data-svelte-h":!0}),c(A)!=="svelte-1rpqt4z"&&(A.innerHTML=me),_s=n(s),i(N.$$.fragment,s),Vs=n(s),x=h(s,"P",{"data-svelte-h":!0}),c(x)!=="svelte-dx7tpa"&&(x.textContent=de),Xs=n(s),i(z.$$.fragment,s),Rs=n(s),F=h(s,"P",{"data-svelte-h":!0}),c(F)!=="svelte-l7920"&&(F.textContent=oe),Bs=n(s),i(Y.$$.fragment,s),qs=n(s),S=h(s,"PRE",{"data-svelte-h":!0}),c(S)!=="svelte-17oljg4"&&(S.textContent=re),Qs=n(s),i(E.$$.fragment,s),vs=n(s),H=h(s,"P",{"data-svelte-h":!0}),c(H)!=="svelte-19kef5w"&&(H.innerHTML=Me),As=n(s),i(L.$$.fragment,s),Ns=n(s),i(K.$$.fragment,s),xs=n(s),P=h(s,"P",{"data-svelte-h":!0}),c(P)!=="svelte-14p0fu2"&&(P.innerHTML=ye),zs=n(s),i(D.$$.fragment,s),Fs=n(s),i(O.$$.fragment,s),Ys=n(s),i(ss.$$.fragment,s),Ss=n(s),es=h(s,"P",{"data-svelte-h":!0}),c(es)!=="svelte-1duibn7"&&(es.innerHTML=he),Es=n(s),i(ts.$$.fragment,s),Hs=n(s),i(ls.$$.fragment,s),Ls=n(s),i(as.$$.fragment,s),Ks=n(s),ps=h(s,"P",{}),ce(ps).forEach(t),this.h()},h(){ge(g,"name","hf:doc:metadata"),ge(g,"content",$e)},m(s,e){fe(document.head,g),l(s,is,e),l(s,ns,e),l(s,ms,e),m(u,s,e),l(s,ds,e),m(w,s,e),l(s,os,e),l(s,J,e),l(s,rs,e),m(j,s,e),l(s,Ms,e),l(s,b,e),l(s,ys,e),m(U,s,e),l(s,hs,e),l(s,f,e),l(s,cs,e),m(Z,s,e),l(s,gs,e),l(s,T,e),l(s,us,e),m($,s,e),l(s,ws,e),m(C,s,e),l(s,Js,e),l(s,I,e),l(s,js,e),m(W,s,e),l(s,bs,e),m(k,s,e),l(s,Us,e),l(s,G,e),l(s,fs,e),m(_,s,e),l(s,Zs,e),m(V,s,e),l(s,Ts,e),m(X,s,e),l(s,$s,e),l(s,R,e),l(s,Cs,e),m(B,s,e),l(s,Is,e),m(q,s,e),l(s,Ws,e),l(s,Q,e),l(s,ks,e),m(v,s,e),l(s,Gs,e),l(s,A,e),l(s,_s,e),m(N,s,e),l(s,Vs,e),l(s,x,e),l(s,Xs,e),m(z,s,e),l(s,Rs,e),l(s,F,e),l(s,Bs,e),m(Y,s,e),l(s,qs,e),l(s,S,e),l(s,Qs,e),m(E,s,e),l(s,vs,e),l(s,H,e),l(s,As,e),m(L,s,e),l(s,Ns,e),m(K,s,e),l(s,xs,e),l(s,P,e),l(s,zs,e),m(D,s,e),l(s,Fs,e),m(O,s,e),l(s,Ys,e),m(ss,s,e),l(s,Ss,e),l(s,es,e),l(s,Es,e),m(ts,s,e),l(s,Hs,e),m(ls,s,e),l(s,Ls,e),m(as,s,e),l(s,Ks,e),l(s,ps,e),Ps=!0},p:we,i(s){Ps||(d(u.$$.fragment,s),d(w.$$.fragment,s),d(j.$$.fragment,s),d(U.$$.fragment,s),d(Z.$$.fragment,s),d($.$$.fragment,s),d(C.$$.fragment,s),d(W.$$.fragment,s),d(k.$$.fragment,s),d(_.$$.fragment,s),d(V.$$.fragment,s),d(X.$$.fragment,s),d(B.$$.fragment,s),d(q.$$.fragment,s),d(v.$$.fragment,s),d(N.$$.fragment,s),d(z.$$.fragment,s),d(Y.$$.fragment,s),d(E.$$.fragment,s),d(L.$$.fragment,s),d(K.$$.fragment,s),d(D.$$.fragment,s),d(O.$$.fragment,s),d(ss.$$.fragment,s),d(ts.$$.fragment,s),d(ls.$$.fragment,s),d(as.$$.fragment,s),Ps=!0)},o(s){o(u.$$.fragment,s),o(w.$$.fragment,s),o(j.$$.fragment,s),o(U.$$.fragment,s),o(Z.$$.fragment,s),o($.$$.fragment,s),o(C.$$.fragment,s),o(W.$$.fragment,s),o(k.$$.fragment,s),o(_.$$.fragment,s),o(V.$$.fragment,s),o(X.$$.fragment,s),o(B.$$.fragment,s),o(q.$$.fragment,s),o(v.$$.fragment,s),o(N.$$.fragment,s),o(z.$$.fragment,s),o(Y.$$.fragment,s),o(E.$$.fragment,s),o(L.$$.fragment,s),o(K.$$.fragment,s),o(D.$$.fragment,s),o(O.$$.fragment,s),o(ss.$$.fragment,s),o(ts.$$.fragment,s),o(ls.$$.fragment,s),o(as.$$.fragment,s),Ps=!1},d(s){s&&(t(is),t(ns),t(ms),t(ds),t(os),t(J),t(rs),t(Ms),t(b),t(ys),t(hs),t(f),t(cs),t(gs),t(T),t(us),t(ws),t(Js),t(I),t(js),t(bs),t(Us),t(G),t(fs),t(Zs),t(Ts),t($s),t(R),t(Cs),t(Is),t(Ws),t(Q),t(ks),t(Gs),t(A),t(_s),t(Vs),t(x),t(Xs),t(Rs),t(F),t(Bs),t(qs),t(S),t(Qs),t(vs),t(H),t(As),t(Ns),t(xs),t(P),t(zs),t(Fs),t(Ys),t(Ss),t(es),t(Es),t(Hs),t(Ls),t(Ks),t(ps)),t(g),r(u,s),r(w,s),r(j,s),r(U,s),r(Z,s),r($,s),r(C,s),r(W,s),r(k,s),r(_,s),r(V,s),r(X,s),r(B,s),r(q,s),r(v,s),r(N,s),r(z,s),r(Y,s),r(E,s),r(L,s),r(K,s),r(D,s),r(O,s),r(ss,s),r(ts,s),r(ls,s),r(as,s)}}}const $e='{"title":"Embedding multimodal data for similarity search using 🤗 transformers, 🤗 datasets and FAISS","local":"embedding-multimodal-data-for-similarity-search-using--transformers--datasets-and-faiss","sections":[{"title":"Querying the data with text prompts","local":"querying-the-data-with-text-prompts","sections":[],"depth":2},{"title":"Querying the data with image prompts","local":"querying-the-data-with-image-prompts","sections":[],"depth":2},{"title":"Saving, pushing and loading the embeddings","local":"saving-pushing-and-loading-the-embeddings","sections":[],"depth":2}],"depth":1}';function Ce(Os){return Je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _e extends je{constructor(g){super(),be(this,g,Ce,Te,ue,{})}}export{_e as component};
