import{s as to,n as ao,o as no}from"../chunks/scheduler.9039eef2.js";import{S as oo,i as lo,g as s,s as n,r as m,A as ro,h as i,f as a,c as o,j as T,u as h,x as d,k as y,l as so,y as r,a as l,v as u,d as M,t as f,w as g}from"../chunks/index.ded8f90d.js";import{D as b}from"../chunks/Docstring.a2ba2b54.js";import{C as gt}from"../chunks/CodeBlock.8580f3e8.js";import{H as _}from"../chunks/Heading.f027f30d.js";function io(nn){let I,Tt,Mt,yt,E,bt,O,on='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://arxiv.org/abs/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by Rafailov et al., 2023. For a full example have a look at  <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo.py" rel="nofollow"><code>examples/scripts/dpo.py</code></a>.',wt,R,ln="The first step as always is to train your SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",_t,L,Jt,F,rn='The DPO trainer expects a very specific format for the dataset. Since the model will be trained to directly optimize the preference of which sentence is the most relevant, given two sentences. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',vt,C,sn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',Ut,H,dn="Therefore the final dataset object should contain these 3 entries if you use the default <code>DPODataCollatorWithPadding</code> data collator. The entries should be named:",jt,N,cn="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",It,Q,pn="for example:",Ct,G,xt,z,mn="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",$t,X,Dt,V,hn="The DPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",At,Y,Pt,S,un="For a detailed example have a look at the <code>examples/scripts/dpo.py</code> script. At a high level we need to initialize the <code>DPOTrainer</code> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",kt,K,Bt,ee,Mn="After this one can then call:",qt,te,Wt,ae,fn="Note that the <code>beta</code> is the temperature parameter for the DPO loss, typically something in the range of <code>0.1</code> to <code>0.5</code>. We ignore the reference model as <code>beta</code> -&gt; 0.",Zt,ne,Et,oe,gn="Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the DPO authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.",Ot,le,Tn='The <a href="https://arxiv.org/abs/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper. The <code>DPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;hinge&quot;</code> argument and the <code>beta</code> in this case is the reciprocal of the margin.',Rt,re,yn='The <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss which can be used via the <code>loss_type=&quot;ipo&quot;</code> argument to the trainer. Note that the <code>beta</code>  parameter is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike DPO which is summed only).',Lt,se,bn='The <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> is a tweak on the DPO loss where we assume that the preference labels are noisy with some probability that can be passed to the <code>DPOTrainer</code> via <code>label_smoothing</code> argument (between 0 and 0.5) and then a conservative DPO loss is used. Use the <code>loss_type=&quot;cdpo&quot;</code> argument to the trainer to use it.',Ft,ie,wn='The <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">KTO</a> loss is derived to directly maximize the utility of LLM generations instead of the log-likelihood of preferences. Thus the dataset are not necessarily preferences but rather desirable vs undesirable completions. For paired preference data as required by the <code>DPOTrainer</code>, use the <code>loss_type=&quot;kto_pair&quot;</code> argument to the trainer to utilize this loss, while for the more general case of desired and undesirable data, use the as of yet unimplemented <code>KTOTrainer</code>.',Ht,de,Nt,ce,_n="While training and evaluating we record the following reward metrics:",Qt,pe,Jn="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",Gt,me,zt,he,vn='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks for DPO listed below:',Xt,ue,Un="<thead><tr><th>GPU</th> <th>Model</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>A100 40G</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.24x</td> <td><strong>1.88x</strong></td> <td>-11.6%</td></tr> <tr><td>Tesla T4</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.09x</td> <td><strong>1.55x</strong></td> <td>-18.6%</td></tr></tbody>",Vt,Me,jn='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',Yt,fe,St,ge,In='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',Kt,Te,ea,ye,Cn="You have three main options (plus several variants) for how the reference model works when using PEFT, assuming the model that you would like to further enhance with DPO was tuned using (Q)LoRA.",ta,be,xn="<li>Simply create two instances of the model, each loading your adapter - works fine but is very inefficient.</li> <li>Merge the adapter into the base model, create another adapter on top, then leave the <code>model_ref</code> param null, in which case DPOTrainer will unload the adapter for reference inference - efficient, but has potential downsides discussed below.</li> <li>Load the adapter twice with different names, then use <code>set_adapter</code> during training to swap between the adapter being DPO’d and the reference adapter - slightly less efficient compared to 2 (~adapter size VRAM overhead), but avoids the pitfalls.</li>",aa,we,na,_e,$n='As suggested by <a href="https://medium.com/@bnjmn_marie/dont-merge-your-lora-adapter-into-a-4-bit-llm-65b6da287997" rel="nofollow">Benjamin Marie</a>, the best option for merging QLoRA adapters is to first dequantize the base model, then merge the adapter. Something similar to <a href="https://github.com/jondurbin/qlora/blob/main/qmerge.py" rel="nofollow">this script</a>.',oa,Je,Dn="However, after using this approach, you will have an unquantized base model. Therefore, to use QLoRA for DPO, you will need to re-quantize the merged model or use the unquantized merge (resulting in higher memory demand).",la,ve,ra,Ue,An="To avoid the downsides with option 2, you can load your fine-tuned adapter into the model twice, with different names, and set the model/ref adapter names in DPOTrainer.",sa,je,Pn="For example:",ia,Ie,da,Ce,ca,c,xe,_a,He,kn="Initialize DPOTrainer.",Ja,x,$e,va,Ne,Bn=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Ua,$,De,ja,Qe,qn="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",Ia,J,Ae,Ca,Ge,Wn="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",xa,ze,Zn="We do this to avoid doing two forward passes, because it’s faster for FSDP.",$a,D,Pe,Da,Xe,En="Concatenate the chosen and rejected inputs into a single tensor.",Aa,A,ke,Pa,Ve,On="Compute the DPO loss for a batch of policy and reference model log probabilities.",ka,v,Be,Ba,Ye,Rn=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,qa,Se,Ln="Works both with or without labels.",Wa,P,qe,Za,Ke,Fn="Compute the log probabilities of the given labels under the given logits.",Ea,k,We,Oa,et,Hn="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",Ra,B,Ze,La,tt,Nn="Generate samples from the model and reference model for the given batch of inputs.",Fa,U,Ee,Ha,at,Qn="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Na,nt,Gn="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Qa,j,Oe,Ga,ot,zn="Returns the training <code>~torch.utils.data.DataLoader</code>.",za,lt,Xn="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Xa,q,Re,Va,rt,Vn="Log <code>logs</code> on the various objects watching training, including stored metrics.",Ya,W,Le,Sa,st,Yn="Context manager for handling null reference model (that is, peft adapter manipulation).",Ka,w,Fe,en,it,Sn="Tokenize a single row from a DPO specific dataset.",tn,dt,Kn=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,an,ct,eo=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,pa,ft,ma;return E=new _({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),L=new _({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),G=new gt({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),X=new _({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),Y=new _({props:{title:"Using the DPOTrainer",local:"using-the-dpotrainer",headingTag:"h2"}}),K=new gt({props:{code:"JTIwZHBvX3RyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfcmVmJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:` dpo_trainer = DPOTrainer(
    model,
    model_ref,
    args=training_args,
    beta=<span class="hljs-number">0.1</span>,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),te=new gt({props:{code:"ZHBvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"dpo_trainer.train()",wrap:!1}}),ne=new _({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),de=new _({props:{title:"Logging",local:"logging",headingTag:"h2"}}),me=new _({props:{title:"Accelerate DPO fine-tuning using unsloth",local:"accelerate-dpo-fine-tuning-using-unsloth",headingTag:"h2"}}),fe=new gt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number.</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/zephyr-sft&quot;</span>,
    max_seq_length = max_seq_length,
    dtype = <span class="hljs-literal">None</span>, <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False.</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
)

training_args = TrainingArguments(output_dir=<span class="hljs-string">&quot;./output&quot;</span>)

dpo_trainer = DPOTrainer(
    model,
    model_ref=<span class="hljs-literal">None</span>,
    args=training_args,
    beta=<span class="hljs-number">0.1</span>,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)
dpo_trainer.train()`,wrap:!1}}),Te=new _({props:{title:"Reference model considerations with PEFT",local:"reference-model-considerations-with-peft",headingTag:"h2"}}),we=new _({props:{title:"Downsides to merging QLoRA before DPO (approach 2)",local:"downsides-to-merging-qlora-before-dpo-approach-2",headingTag:"h3"}}),ve=new _({props:{title:"Using option 3 - load the adapter twice",local:"using-option-3---load-the-adapter-twice",headingTag:"h3"}}),Ie=new gt({props:{code:"JTIzJTIwTG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbC4lMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBsbG1faW50OF90aHJlc2hvbGQlM0Q2LjAlMkMlMEElMjAlMjAlMjAlMjBsbG1faW50OF9oYXNfZnAxNl93ZWlnaHQlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUwQSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtaXN0cmFsYWklMkZtaXh0cmFsLTh4N2ItdjAuMSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSklMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwYWRhcHRlci4lMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAlMjIlMkZwYXRoJTJGdG8lMkZwZWZ0JTIyJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5hYmxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGFkYXB0ZXJfbmFtZSUzRCUyMnRyYWluJTIyJTJDJTBBKSUwQSUyMyUyMExvYWQlMjB0aGUlMjBhZGFwdGVyJTIwYSUyMHNlY29uZCUyMHRpbWUlMkMlMjB3aXRoJTIwYSUyMGRpZmZlcmVudCUyMG5hbWUlMkMlMjB3aGljaCUyMHdpbGwlMjBiZSUyMG91ciUyMHJlZmVyZW5jZSUyMG1vZGVsLiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjIlMkZwYXRoJTJGdG8lMkZwZWZ0JTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIycmVmZXJlbmNlJTIyKSUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjB0cmFpbmVyJTJDJTIwd2l0aG91dCUyMGElMjByZWZfbW9kZWwlMjBwYXJhbS4lMEFkcG9fdHJhaW5lciUyMCUzRCUyMERQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjBtb2RlbF9hZGFwdGVyX25hbWUlM0QlMjJ0cmFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZl9hZGFwdGVyX25hbWUlM0QlMjJyZWZlcmVuY2UlMjIlMkMlMEEp",highlighted:`<span class="hljs-comment"># Load the base model.</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    llm_int8_threshold=<span class="hljs-number">6.0</span>,
    llm_int8_has_fp16_weight=<span class="hljs-literal">False</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/mixtral-8x7b-v0.1&quot;</span>,
    load_in_4bit=<span class="hljs-literal">True</span>,
    quantization_config=bnb_config,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the adapter.</span>
model = PeftModel.from_pretrained(
    model,
    <span class="hljs-string">&quot;/path/to/peft&quot;</span>,
    is_trainable=<span class="hljs-literal">True</span>,
    adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
)
<span class="hljs-comment"># Load the adapter a second time, with a different name, which will be our reference model.</span>
model.load_adapter(<span class="hljs-string">&quot;/path/to/peft&quot;</span>, adapter_name=<span class="hljs-string">&quot;reference&quot;</span>)

<span class="hljs-comment"># Initialize the trainer, without a ref_model param.</span>
dpo_trainer = DPOTrainer(
    model,
    ...
    model_adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
    ref_adapter_name=<span class="hljs-string">&quot;reference&quot;</span>,
)`,wrap:!1}}),Ce=new _({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),xe=new b({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOTrainer.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOTrainer.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss,<code>&quot;hinge&quot;</code> loss from <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper, <code>&quot;ipo&quot;</code> from <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> paper, or <code>&quot;kto&quot;</code> from the HALOs <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">report</a>.`,name:"loss_type"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>transformers.TrainingArguments</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOTrainer.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOTrainer.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOTrainer.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOTrainer.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOTrainer.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.DPOTrainer.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.DPOTrainer.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.DPOTrainer.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"ref_model_init_kwargs"},{anchor:"trl.DPOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"},{anchor:"trl.DPOTrainer.reference_free",description:`<strong>reference_free</strong> (<code>bool</code>) &#x2014;
If True, we ignore the <em>provided</em> reference model and implicitly use a reference model that assigns equal probability to all responses.`,name:"reference_free"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L65"}}),$e=new b({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L546"}}),De=new b({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L754"}}),Ae=new b({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L957"}}),Pe=new b({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L778",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),ke=new b({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L840",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Be=new b({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1176"}}),qe=new b({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L919",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),We=new b({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1004"}}),Ze=new b({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1086"}}),Ee=new b({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L494"}}),Oe=new b({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L451"}}),Re=new b({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1226"}}),Le=new b({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L742"}}),Fe=new b({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L596"}}),{c(){I=s("meta"),Tt=n(),Mt=s("p"),yt=n(),m(E.$$.fragment),bt=n(),O=s("p"),O.innerHTML=on,wt=n(),R=s("p"),R.textContent=ln,_t=n(),m(L.$$.fragment),Jt=n(),F=s("p"),F.innerHTML=rn,vt=n(),C=s("div"),C.innerHTML=sn,Ut=n(),H=s("p"),H.innerHTML=dn,jt=n(),N=s("ul"),N.innerHTML=cn,It=n(),Q=s("p"),Q.textContent=pn,Ct=n(),m(G.$$.fragment),xt=n(),z=s("p"),z.innerHTML=mn,$t=n(),m(X.$$.fragment),Dt=n(),V=s("p"),V.innerHTML=hn,At=n(),m(Y.$$.fragment),Pt=n(),S=s("p"),S.innerHTML=un,kt=n(),m(K.$$.fragment),Bt=n(),ee=s("p"),ee.textContent=Mn,qt=n(),m(te.$$.fragment),Wt=n(),ae=s("p"),ae.innerHTML=fn,Zt=n(),m(ne.$$.fragment),Et=n(),oe=s("p"),oe.innerHTML=gn,Ot=n(),le=s("p"),le.innerHTML=Tn,Rt=n(),re=s("p"),re.innerHTML=yn,Lt=n(),se=s("p"),se.innerHTML=bn,Ft=n(),ie=s("p"),ie.innerHTML=wn,Ht=n(),m(de.$$.fragment),Nt=n(),ce=s("p"),ce.textContent=_n,Qt=n(),pe=s("ul"),pe.innerHTML=Jn,Gt=n(),m(me.$$.fragment),zt=n(),he=s("p"),he.innerHTML=vn,Xt=n(),ue=s("table"),ue.innerHTML=Un,Vt=n(),Me=s("p"),Me.innerHTML=jn,Yt=n(),m(fe.$$.fragment),St=n(),ge=s("p"),ge.innerHTML=In,Kt=n(),m(Te.$$.fragment),ea=n(),ye=s("p"),ye.textContent=Cn,ta=n(),be=s("ol"),be.innerHTML=xn,aa=n(),m(we.$$.fragment),na=n(),_e=s("p"),_e.innerHTML=$n,oa=n(),Je=s("p"),Je.textContent=Dn,la=n(),m(ve.$$.fragment),ra=n(),Ue=s("p"),Ue.textContent=An,sa=n(),je=s("p"),je.textContent=Pn,ia=n(),m(Ie.$$.fragment),da=n(),m(Ce.$$.fragment),ca=n(),c=s("div"),m(xe.$$.fragment),_a=n(),He=s("p"),He.textContent=kn,Ja=n(),x=s("div"),m($e.$$.fragment),va=n(),Ne=s("p"),Ne.innerHTML=Bn,Ua=n(),$=s("div"),m(De.$$.fragment),ja=n(),Qe=s("p"),Qe.textContent=qn,Ia=n(),J=s("div"),m(Ae.$$.fragment),Ca=n(),Ge=s("p"),Ge.textContent=Wn,xa=n(),ze=s("p"),ze.textContent=Zn,$a=n(),D=s("div"),m(Pe.$$.fragment),Da=n(),Xe=s("p"),Xe.textContent=En,Aa=n(),A=s("div"),m(ke.$$.fragment),Pa=n(),Ve=s("p"),Ve.textContent=On,ka=n(),v=s("div"),m(Be.$$.fragment),Ba=n(),Ye=s("p"),Ye.innerHTML=Rn,qa=n(),Se=s("p"),Se.textContent=Ln,Wa=n(),P=s("div"),m(qe.$$.fragment),Za=n(),Ke=s("p"),Ke.textContent=Fn,Ea=n(),k=s("div"),m(We.$$.fragment),Oa=n(),et=s("p"),et.textContent=Hn,Ra=n(),B=s("div"),m(Ze.$$.fragment),La=n(),tt=s("p"),tt.textContent=Nn,Fa=n(),U=s("div"),m(Ee.$$.fragment),Ha=n(),at=s("p"),at.innerHTML=Qn,Na=n(),nt=s("p"),nt.innerHTML=Gn,Qa=n(),j=s("div"),m(Oe.$$.fragment),Ga=n(),ot=s("p"),ot.innerHTML=zn,za=n(),lt=s("p"),lt.innerHTML=Xn,Xa=n(),q=s("div"),m(Re.$$.fragment),Va=n(),rt=s("p"),rt.innerHTML=Vn,Ya=n(),W=s("div"),m(Le.$$.fragment),Sa=n(),st=s("p"),st.textContent=Yn,Ka=n(),w=s("div"),m(Fe.$$.fragment),en=n(),it=s("p"),it.textContent=Sn,tn=n(),dt=s("p"),dt.textContent=Kn,an=n(),ct=s("p"),ct.textContent=eo,pa=n(),ft=s("p"),this.h()},l(e){const t=ro("svelte-u9bgzb",document.head);I=i(t,"META",{name:!0,content:!0}),t.forEach(a),Tt=o(e),Mt=i(e,"P",{}),T(Mt).forEach(a),yt=o(e),h(E.$$.fragment,e),bt=o(e),O=i(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-5p7twb"&&(O.innerHTML=on),wt=o(e),R=i(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-xh4sh7"&&(R.textContent=ln),_t=o(e),h(L.$$.fragment,e),Jt=o(e),F=i(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-dcawbe"&&(F.innerHTML=rn),vt=o(e),C=i(e,"DIV",{style:!0,"data-svelte-h":!0}),d(C)!=="svelte-z15c7z"&&(C.innerHTML=sn),Ut=o(e),H=i(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-cb9b0v"&&(H.innerHTML=dn),jt=o(e),N=i(e,"UL",{"data-svelte-h":!0}),d(N)!=="svelte-17vxuta"&&(N.innerHTML=cn),It=o(e),Q=i(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1gl9mvz"&&(Q.textContent=pn),Ct=o(e),h(G.$$.fragment,e),xt=o(e),z=i(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1a8oxjk"&&(z.innerHTML=mn),$t=o(e),h(X.$$.fragment,e),Dt=o(e),V=i(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-174yw9s"&&(V.innerHTML=hn),At=o(e),h(Y.$$.fragment,e),Pt=o(e),S=i(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1wn9xrv"&&(S.innerHTML=un),kt=o(e),h(K.$$.fragment,e),Bt=o(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1lg6q1l"&&(ee.textContent=Mn),qt=o(e),h(te.$$.fragment,e),Wt=o(e),ae=i(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1ac5mum"&&(ae.innerHTML=fn),Zt=o(e),h(ne.$$.fragment,e),Et=o(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-7nvktz"&&(oe.innerHTML=gn),Ot=o(e),le=i(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-bl9wh7"&&(le.innerHTML=Tn),Rt=o(e),re=i(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1quvcuu"&&(re.innerHTML=yn),Lt=o(e),se=i(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-x8vvul"&&(se.innerHTML=bn),Ft=o(e),ie=i(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-qfh893"&&(ie.innerHTML=wn),Ht=o(e),h(de.$$.fragment,e),Nt=o(e),ce=i(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-132s7j9"&&(ce.textContent=_n),Qt=o(e),pe=i(e,"UL",{"data-svelte-h":!0}),d(pe)!=="svelte-1oji3mm"&&(pe.innerHTML=Jn),Gt=o(e),h(me.$$.fragment,e),zt=o(e),he=i(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-2145zu"&&(he.innerHTML=vn),Xt=o(e),ue=i(e,"TABLE",{"data-svelte-h":!0}),d(ue)!=="svelte-435mua"&&(ue.innerHTML=Un),Vt=o(e),Me=i(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-1p74c9x"&&(Me.innerHTML=jn),Yt=o(e),h(fe.$$.fragment,e),St=o(e),ge=i(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-1o18rwj"&&(ge.innerHTML=In),Kt=o(e),h(Te.$$.fragment,e),ea=o(e),ye=i(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-4infz6"&&(ye.textContent=Cn),ta=o(e),be=i(e,"OL",{"data-svelte-h":!0}),d(be)!=="svelte-1p7od7"&&(be.innerHTML=xn),aa=o(e),h(we.$$.fragment,e),na=o(e),_e=i(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-rqj7uy"&&(_e.innerHTML=$n),oa=o(e),Je=i(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1xhv3st"&&(Je.textContent=Dn),la=o(e),h(ve.$$.fragment,e),ra=o(e),Ue=i(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-a0kxee"&&(Ue.textContent=An),sa=o(e),je=i(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1gkqha7"&&(je.textContent=Pn),ia=o(e),h(Ie.$$.fragment,e),da=o(e),h(Ce.$$.fragment,e),ca=o(e),c=i(e,"DIV",{class:!0});var p=T(c);h(xe.$$.fragment,p),_a=o(p),He=i(p,"P",{"data-svelte-h":!0}),d(He)!=="svelte-n6cc8y"&&(He.textContent=kn),Ja=o(p),x=i(p,"DIV",{class:!0});var ha=T(x);h($e.$$.fragment,ha),va=o(ha),Ne=i(ha,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-mcz8nm"&&(Ne.innerHTML=Bn),ha.forEach(a),Ua=o(p),$=i(p,"DIV",{class:!0});var ua=T($);h(De.$$.fragment,ua),ja=o(ua),Qe=i(ua,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-10t1062"&&(Qe.textContent=qn),ua.forEach(a),Ia=o(p),J=i(p,"DIV",{class:!0});var pt=T(J);h(Ae.$$.fragment,pt),Ca=o(pt),Ge=i(pt,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-16i1nac"&&(Ge.textContent=Wn),xa=o(pt),ze=i(pt,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-tgti68"&&(ze.textContent=Zn),pt.forEach(a),$a=o(p),D=i(p,"DIV",{class:!0});var Ma=T(D);h(Pe.$$.fragment,Ma),Da=o(Ma),Xe=i(Ma,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-1cvsgkk"&&(Xe.textContent=En),Ma.forEach(a),Aa=o(p),A=i(p,"DIV",{class:!0});var fa=T(A);h(ke.$$.fragment,fa),Pa=o(fa),Ve=i(fa,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-ymgxq7"&&(Ve.textContent=On),fa.forEach(a),ka=o(p),v=i(p,"DIV",{class:!0});var mt=T(v);h(Be.$$.fragment,mt),Ba=o(mt),Ye=i(mt,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-8qlty5"&&(Ye.innerHTML=Rn),qa=o(mt),Se=i(mt,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-1tyo99t"&&(Se.textContent=Ln),mt.forEach(a),Wa=o(p),P=i(p,"DIV",{class:!0});var ga=T(P);h(qe.$$.fragment,ga),Za=o(ga),Ke=i(ga,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-4nmimv"&&(Ke.textContent=Fn),ga.forEach(a),Ea=o(p),k=i(p,"DIV",{class:!0});var Ta=T(k);h(We.$$.fragment,Ta),Oa=o(Ta),et=i(Ta,"P",{"data-svelte-h":!0}),d(et)!=="svelte-11q8u7l"&&(et.textContent=Hn),Ta.forEach(a),Ra=o(p),B=i(p,"DIV",{class:!0});var ya=T(B);h(Ze.$$.fragment,ya),La=o(ya),tt=i(ya,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-18uwvbi"&&(tt.textContent=Nn),ya.forEach(a),Fa=o(p),U=i(p,"DIV",{class:!0});var ht=T(U);h(Ee.$$.fragment,ht),Ha=o(ht),at=i(ht,"P",{"data-svelte-h":!0}),d(at)!=="svelte-xesobz"&&(at.innerHTML=Qn),Na=o(ht),nt=i(ht,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-qg43tm"&&(nt.innerHTML=Gn),ht.forEach(a),Qa=o(p),j=i(p,"DIV",{class:!0});var ut=T(j);h(Oe.$$.fragment,ut),Ga=o(ut),ot=i(ut,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-dkae9b"&&(ot.innerHTML=zn),za=o(ut),lt=i(ut,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-hmd5cw"&&(lt.innerHTML=Xn),ut.forEach(a),Xa=o(p),q=i(p,"DIV",{class:!0});var ba=T(q);h(Re.$$.fragment,ba),Va=o(ba),rt=i(ba,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-nqksfz"&&(rt.innerHTML=Vn),ba.forEach(a),Ya=o(p),W=i(p,"DIV",{class:!0});var wa=T(W);h(Le.$$.fragment,wa),Sa=o(wa),st=i(wa,"P",{"data-svelte-h":!0}),d(st)!=="svelte-17kjsy4"&&(st.textContent=Yn),wa.forEach(a),Ka=o(p),w=i(p,"DIV",{class:!0});var Z=T(w);h(Fe.$$.fragment,Z),en=o(Z),it=i(Z,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1861yti"&&(it.textContent=Sn),tn=o(Z),dt=i(Z,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-1mn1gnw"&&(dt.textContent=Kn),an=o(Z),ct=i(Z,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-1xvpyih"&&(ct.textContent=eo),Z.forEach(a),p.forEach(a),pa=o(e),ft=i(e,"P",{}),T(ft).forEach(a),this.h()},h(){y(I,"name","hf:doc:metadata"),y(I,"content",co),so(C,"text-align","center"),y(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,I),l(e,Tt,t),l(e,Mt,t),l(e,yt,t),u(E,e,t),l(e,bt,t),l(e,O,t),l(e,wt,t),l(e,R,t),l(e,_t,t),u(L,e,t),l(e,Jt,t),l(e,F,t),l(e,vt,t),l(e,C,t),l(e,Ut,t),l(e,H,t),l(e,jt,t),l(e,N,t),l(e,It,t),l(e,Q,t),l(e,Ct,t),u(G,e,t),l(e,xt,t),l(e,z,t),l(e,$t,t),u(X,e,t),l(e,Dt,t),l(e,V,t),l(e,At,t),u(Y,e,t),l(e,Pt,t),l(e,S,t),l(e,kt,t),u(K,e,t),l(e,Bt,t),l(e,ee,t),l(e,qt,t),u(te,e,t),l(e,Wt,t),l(e,ae,t),l(e,Zt,t),u(ne,e,t),l(e,Et,t),l(e,oe,t),l(e,Ot,t),l(e,le,t),l(e,Rt,t),l(e,re,t),l(e,Lt,t),l(e,se,t),l(e,Ft,t),l(e,ie,t),l(e,Ht,t),u(de,e,t),l(e,Nt,t),l(e,ce,t),l(e,Qt,t),l(e,pe,t),l(e,Gt,t),u(me,e,t),l(e,zt,t),l(e,he,t),l(e,Xt,t),l(e,ue,t),l(e,Vt,t),l(e,Me,t),l(e,Yt,t),u(fe,e,t),l(e,St,t),l(e,ge,t),l(e,Kt,t),u(Te,e,t),l(e,ea,t),l(e,ye,t),l(e,ta,t),l(e,be,t),l(e,aa,t),u(we,e,t),l(e,na,t),l(e,_e,t),l(e,oa,t),l(e,Je,t),l(e,la,t),u(ve,e,t),l(e,ra,t),l(e,Ue,t),l(e,sa,t),l(e,je,t),l(e,ia,t),u(Ie,e,t),l(e,da,t),u(Ce,e,t),l(e,ca,t),l(e,c,t),u(xe,c,null),r(c,_a),r(c,He),r(c,Ja),r(c,x),u($e,x,null),r(x,va),r(x,Ne),r(c,Ua),r(c,$),u(De,$,null),r($,ja),r($,Qe),r(c,Ia),r(c,J),u(Ae,J,null),r(J,Ca),r(J,Ge),r(J,xa),r(J,ze),r(c,$a),r(c,D),u(Pe,D,null),r(D,Da),r(D,Xe),r(c,Aa),r(c,A),u(ke,A,null),r(A,Pa),r(A,Ve),r(c,ka),r(c,v),u(Be,v,null),r(v,Ba),r(v,Ye),r(v,qa),r(v,Se),r(c,Wa),r(c,P),u(qe,P,null),r(P,Za),r(P,Ke),r(c,Ea),r(c,k),u(We,k,null),r(k,Oa),r(k,et),r(c,Ra),r(c,B),u(Ze,B,null),r(B,La),r(B,tt),r(c,Fa),r(c,U),u(Ee,U,null),r(U,Ha),r(U,at),r(U,Na),r(U,nt),r(c,Qa),r(c,j),u(Oe,j,null),r(j,Ga),r(j,ot),r(j,za),r(j,lt),r(c,Xa),r(c,q),u(Re,q,null),r(q,Va),r(q,rt),r(c,Ya),r(c,W),u(Le,W,null),r(W,Sa),r(W,st),r(c,Ka),r(c,w),u(Fe,w,null),r(w,en),r(w,it),r(w,tn),r(w,dt),r(w,an),r(w,ct),l(e,pa,t),l(e,ft,t),ma=!0},p:ao,i(e){ma||(M(E.$$.fragment,e),M(L.$$.fragment,e),M(G.$$.fragment,e),M(X.$$.fragment,e),M(Y.$$.fragment,e),M(K.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(de.$$.fragment,e),M(me.$$.fragment,e),M(fe.$$.fragment,e),M(Te.$$.fragment,e),M(we.$$.fragment,e),M(ve.$$.fragment,e),M(Ie.$$.fragment,e),M(Ce.$$.fragment,e),M(xe.$$.fragment,e),M($e.$$.fragment,e),M(De.$$.fragment,e),M(Ae.$$.fragment,e),M(Pe.$$.fragment,e),M(ke.$$.fragment,e),M(Be.$$.fragment,e),M(qe.$$.fragment,e),M(We.$$.fragment,e),M(Ze.$$.fragment,e),M(Ee.$$.fragment,e),M(Oe.$$.fragment,e),M(Re.$$.fragment,e),M(Le.$$.fragment,e),M(Fe.$$.fragment,e),ma=!0)},o(e){f(E.$$.fragment,e),f(L.$$.fragment,e),f(G.$$.fragment,e),f(X.$$.fragment,e),f(Y.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(de.$$.fragment,e),f(me.$$.fragment,e),f(fe.$$.fragment,e),f(Te.$$.fragment,e),f(we.$$.fragment,e),f(ve.$$.fragment,e),f(Ie.$$.fragment,e),f(Ce.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(De.$$.fragment,e),f(Ae.$$.fragment,e),f(Pe.$$.fragment,e),f(ke.$$.fragment,e),f(Be.$$.fragment,e),f(qe.$$.fragment,e),f(We.$$.fragment,e),f(Ze.$$.fragment,e),f(Ee.$$.fragment,e),f(Oe.$$.fragment,e),f(Re.$$.fragment,e),f(Le.$$.fragment,e),f(Fe.$$.fragment,e),ma=!1},d(e){e&&(a(Tt),a(Mt),a(yt),a(bt),a(O),a(wt),a(R),a(_t),a(Jt),a(F),a(vt),a(C),a(Ut),a(H),a(jt),a(N),a(It),a(Q),a(Ct),a(xt),a(z),a($t),a(Dt),a(V),a(At),a(Pt),a(S),a(kt),a(Bt),a(ee),a(qt),a(Wt),a(ae),a(Zt),a(Et),a(oe),a(Ot),a(le),a(Rt),a(re),a(Lt),a(se),a(Ft),a(ie),a(Ht),a(Nt),a(ce),a(Qt),a(pe),a(Gt),a(zt),a(he),a(Xt),a(ue),a(Vt),a(Me),a(Yt),a(St),a(ge),a(Kt),a(ea),a(ye),a(ta),a(be),a(aa),a(na),a(_e),a(oa),a(Je),a(la),a(ra),a(Ue),a(sa),a(je),a(ia),a(da),a(ca),a(c),a(pa),a(ft)),a(I),g(E,e),g(L,e),g(G,e),g(X,e),g(Y,e),g(K,e),g(te,e),g(ne,e),g(de,e),g(me,e),g(fe,e),g(Te,e),g(we,e),g(ve,e),g(Ie,e),g(Ce,e),g(xe),g($e),g(De),g(Ae),g(Pe),g(ke),g(Be),g(qe),g(We),g(Ze),g(Ee),g(Oe),g(Re),g(Le),g(Fe)}}}const co='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the DPOTrainer","local":"using-the-dpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"Accelerate DPO fine-tuning using unsloth","local":"accelerate-dpo-fine-tuning-using-unsloth","sections":[],"depth":2},{"title":"Reference model considerations with PEFT","local":"reference-model-considerations-with-peft","sections":[{"title":"Downsides to merging QLoRA before DPO (approach 2)","local":"downsides-to-merging-qlora-before-dpo-approach-2","sections":[],"depth":3},{"title":"Using option 3 - load the adapter twice","local":"using-option-3---load-the-adapter-twice","sections":[],"depth":3}],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2}],"depth":1}';function po(nn){return no(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class go extends oo{constructor(I){super(),lo(this,I,po,io,to,{})}}export{go as component};
