import{s as Kt,f as Vt,o as qt,n as ze}from"../chunks/scheduler.9bc65507.js";import{S as Ht,i as Pt,g as d,s as a,r as g,A as Lt,h as c,f as s,c as r,j as X,u,x as h,k as U,y as i,a as l,v as f,d as _,t as b,w as M}from"../chunks/index.707bf1b6.js";import{T as Gt}from"../chunks/Tip.c2ecdbf4.js";import{D as he}from"../chunks/Docstring.17db21ae.js";import{C as Se}from"../chunks/CodeBlock.54a9f38d.js";import{E as Mt}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as P}from"../chunks/Heading.342b1fa6.js";function Yt(x){let o,w="Example:",m,p,T;return p=new Se({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEtvc21vczJDb25maWclMkMlMjBLb3Ntb3MyTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwS29zbW9zLTIlMjBrb3Ntb3MtMi1wYXRjaDE0LTIyNCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBLb3Ntb3MyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGtvc21vcy0yLXBhdGNoMTQtMjI0JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBLb3Ntb3MyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Kosmos2Config, Kosmos2Model

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Kosmos-2 kosmos-2-patch14-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Kosmos2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the kosmos-2-patch14-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Kosmos2Model(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=d("p"),o.textContent=w,m=a(),g(p.$$.fragment)},l(n){o=c(n,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=w),m=r(n),u(p.$$.fragment,n)},m(n,y){l(n,o,y),l(n,m,y),f(p,n,y),T=!0},p:ze,i(n){T||(_(p.$$.fragment,n),T=!0)},o(n){b(p.$$.fragment,n),T=!1},d(n){n&&(s(o),s(m)),M(p,n)}}}function Qt(x){let o,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=d("p"),o.innerHTML=w},l(m){o=c(m,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=w)},m(m,p){l(m,o,p)},p:ze,d(m){m&&s(o)}}}function St(x){let o,w="Examples:",m,p,T;return p=new Se({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEtvc21vczJNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwS29zbW9zMk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZrb3Ntb3MtMi1wYXRjaDE0LTIyNCUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZrb3Ntb3MtMi1wYXRjaDE0LTIyNCUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGbWljcm9zb2Z0JTJGa29zbW9zLTItcGF0Y2gxNC0yMjQlMkZyZXNvbHZlJTJGbWFpbiUyRnNub3dtYW4uanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBdGV4dCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjIlM0Nncm91bmRpbmclM0UlMjBBbiUyMGltYWdlJTIwb2YlM0NwaHJhc2UlM0UlMjBhJTIwc25vd21hbiUzQyUyRnBocmFzZSUzRSUzQ29iamVjdCUzRSUzQ3BhdGNoX2luZGV4XzAwNDQlM0UlM0NwYXRjaF9pbmRleF8wODYzJTNFJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTNDJTJGb2JqZWN0JTNFJTIwd2FybWluZyUyMGhpbXNlbGYlMjBieSUzQ3BocmFzZSUzRSUyMGElMjBmaXJlJTNDJTJGcGhyYXNlJTNFJTNDb2JqZWN0JTNFJTNDcGF0Y2hfaW5kZXhfMDAwNSUzRSUzQ3BhdGNoX2luZGV4XzA5MTElM0UlMjIlMEElMjAlMjAlMjAlMjAlMjIlM0MlMkZvYmplY3QlM0UlMjIlMEEpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0JTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwYWRkX2Vvc190b2tlbiUzRFRydWUpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGUlMjAlM0QlMjBtb2RlbCglMEElMjAlMjAlMjAlMjBwaXhlbF92YWx1ZXMlM0RpbnB1dHMlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBpbnB1dF9pZHMlM0RpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUzRGlucHV0cyU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW1iZWRzX3Bvc2l0aW9uX21hc2slM0RpbnB1dHMlNUIlMjJpbWFnZV9lbWJlZHNfcG9zaXRpb25fbWFzayUyMiU1RCUyQyUwQSkubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Kosmos2Model

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Kosmos2Model.from_pretrained(<span class="hljs-string">&quot;microsoft/kosmos-2-patch14-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/kosmos-2-patch14-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/microsoft/kosmos-2-patch14-224/resolve/main/snowman.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&lt;grounding&gt; An image of&lt;phrase&gt; a snowman&lt;/phrase&gt;&lt;object&gt;&lt;patch_index_0044&gt;&lt;patch_index_0863&gt;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&lt;/object&gt; warming himself by&lt;phrase&gt; a fire&lt;/phrase&gt;&lt;object&gt;&lt;patch_index_0005&gt;&lt;patch_index_0911&gt;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&lt;/object&gt;&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, add_eos_token=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = model(
<span class="hljs-meta">... </span>    pixel_values=inputs[<span class="hljs-string">&quot;pixel_values&quot;</span>],
<span class="hljs-meta">... </span>    input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>],
<span class="hljs-meta">... </span>    attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
<span class="hljs-meta">... </span>    image_embeds_position_mask=inputs[<span class="hljs-string">&quot;image_embeds_position_mask&quot;</span>],
<span class="hljs-meta">... </span>).last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">91</span>, <span class="hljs-number">2048</span>]`,wrap:!1}}),{c(){o=d("p"),o.textContent=w,m=a(),g(p.$$.fragment)},l(n){o=c(n,"P",{"data-svelte-h":!0}),h(o)!=="svelte-kvfsh7"&&(o.textContent=w),m=r(n),u(p.$$.fragment,n)},m(n,y){l(n,o,y),l(n,m,y),f(p,n,y),T=!0},p:ze,i(n){T||(_(p.$$.fragment,n),T=!0)},o(n){b(p.$$.fragment,n),T=!1},d(n){n&&(s(o),s(m)),M(p,n)}}}function At(x){let o,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=d("p"),o.innerHTML=w},l(m){o=c(m,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=w)},m(m,p){l(m,o,p)},p:ze,d(m){m&&s(o)}}}function Ot(x){let o,w="Examples:",m,p,T;return p=new Se({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEtvc21vczJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEtvc21vczJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmtvc21vcy0yLXBhdGNoMTQtMjI0JTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmtvc21vcy0yLXBhdGNoMTQtMjI0JTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZtaWNyb3NvZnQlMkZrb3Ntb3MtMi1wYXRjaDE0LTIyNCUyRnJlc29sdmUlMkZtYWluJTJGc25vd21hbi5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjIlM0Nncm91bmRpbmclM0UlMjBBbiUyMGltYWdlJTIwb2YlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHByb21wdCUyQyUyMGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwcGl4ZWxfdmFsdWVzJTNEaW5wdXRzJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0RpbnB1dHMlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2VtYmVkcyUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHNfcG9zaXRpb25fbWFzayUzRGlucHV0cyU1QiUyMmltYWdlX2VtYmVkc19wb3NpdGlvbl9tYXNrJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2NhY2hlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENjQlMkMlMEEpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBcHJvY2Vzc2VkX3RleHQlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX2dlbmVyYXRpb24oZ2VuZXJhdGVkX3RleHQlMkMlMjBjbGVhbnVwX2FuZF9leHRyYWN0JTNERmFsc2UpJTBBcHJvY2Vzc2VkX3RleHQlMEElMEFjYXB0aW9uJTJDJTIwZW50aXRpZXMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX2dlbmVyYXRpb24oZ2VuZXJhdGVkX3RleHQpJTBBY2FwdGlvbiUwQSUwQWVudGl0aWVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Kosmos2ForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Kosmos2ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;microsoft/kosmos-2-patch14-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/kosmos-2-patch14-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/microsoft/kosmos-2-patch14-224/resolve/main/snowman.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&lt;grounding&gt; An image of&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(
<span class="hljs-meta">... </span>    pixel_values=inputs[<span class="hljs-string">&quot;pixel_values&quot;</span>],
<span class="hljs-meta">... </span>    input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>],
<span class="hljs-meta">... </span>    attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
<span class="hljs-meta">... </span>    image_embeds=<span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>    image_embeds_position_mask=inputs[<span class="hljs-string">&quot;image_embeds_position_mask&quot;</span>],
<span class="hljs-meta">... </span>    use_cache=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">64</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_text = processor.post_process_generation(generated_text, cleanup_and_extract=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_text
<span class="hljs-string">&#x27;&lt;grounding&gt; An image of&lt;phrase&gt; a snowman&lt;/phrase&gt;&lt;object&gt;&lt;patch_index_0044&gt;&lt;patch_index_0863&gt;&lt;/object&gt; warming himself by&lt;phrase&gt; a fire&lt;/phrase&gt;&lt;object&gt;&lt;patch_index_0005&gt;&lt;patch_index_0911&gt;&lt;/object&gt;.&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>caption, entities = processor.post_process_generation(generated_text)
<span class="hljs-meta">&gt;&gt;&gt; </span>caption
<span class="hljs-string">&#x27;An image of a snowman warming himself by a fire.&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>entities
[(<span class="hljs-string">&#x27;a snowman&#x27;</span>, (<span class="hljs-number">12</span>, <span class="hljs-number">21</span>), [(<span class="hljs-number">0.390625</span>, <span class="hljs-number">0.046875</span>, <span class="hljs-number">0.984375</span>, <span class="hljs-number">0.828125</span>)]), (<span class="hljs-string">&#x27;a fire&#x27;</span>, (<span class="hljs-number">41</span>, <span class="hljs-number">47</span>), [(<span class="hljs-number">0.171875</span>, <span class="hljs-number">0.015625</span>, <span class="hljs-number">0.484375</span>, <span class="hljs-number">0.890625</span>)])]`,wrap:!1}}),{c(){o=d("p"),o.textContent=w,m=a(),g(p.$$.fragment)},l(n){o=c(n,"P",{"data-svelte-h":!0}),h(o)!=="svelte-kvfsh7"&&(o.textContent=w),m=r(n),u(p.$$.fragment,n)},m(n,y){l(n,o,y),l(n,m,y),f(p,n,y),T=!0},p:ze,i(n){T||(_(p.$$.fragment,n),T=!0)},o(n){b(p.$$.fragment,n),T=!1},d(n){n&&(s(o),s(m)),M(p,n)}}}function Dt(x){let o,w,m,p,T,n,y,Ie,L,Tt='The KOSMOS-2 model was proposed in <a href="https://arxiv.org/abs/2306.14824" rel="nofollow">Kosmos-2: Grounding Multimodal Large Language Models to the World</a> by Zhiliang Peng, Wenhui Wang, Li Dong, Yaru Hao, Shaohan Huang, Shuming Ma, Furu Wei.',Ue,Y,wt=`KOSMOS-2 is a Transformer-based causal language model and is trained using the next-word prediction task on a web-scale
dataset of grounded image-text pairs <a href="https://huggingface.co/datasets/zzliang/GRIT" rel="nofollow">GRIT</a>. The spatial coordinates of
the bounding boxes in the dataset are converted to a sequence of location tokens, which are appended to their respective
entity text spans (for example, <code>a snowman</code> followed by <code>&lt;patch_index_0044&gt;&lt;patch_index_0863&gt;</code>). The data format is
similar to “hyperlinks” that connect the object regions in an image to their text span in the corresponding caption.`,Ce,Q,yt="The abstract from the paper is the following:",Ne,S,vt='<em>We introduce Kosmos-2, a Multimodal Large Language Model (MLLM), enabling new capabilities of perceiving object descriptions (e.g., bounding boxes) and grounding text to the visual world. Specifically, we represent refer expressions as links in Markdown, i.e., “[text span](bounding boxes)”, where object descriptions are sequences of location tokens. Together with multimodal corpora, we construct large-scale data of grounded image-text pairs (called GrIT) to train the model. In addition to the existing capabilities of MLLMs (e.g., perceiving general modalities, following instructions, and performing in-context learning), Kosmos-2 integrates the grounding capability into downstream applications. We evaluate Kosmos-2 on a wide range of tasks, including (i) multimodal grounding, such as referring expression comprehension, and phrase grounding, (ii) multimodal referring, such as referring expression generation, (iii) perception-language tasks, and (iv) language understanding and generation. This work lays out the foundation for the development of Embodiment AI and sheds light on the big convergence of language, multimodal perception, action, and world modeling, which is a key step toward artificial general intelligence. Code and pretrained models are available at <a href="https://aka.ms/kosmos-2" rel="nofollow">https://aka.ms/kosmos-2</a>.</em>',We,B,kt,Fe,A,jt='Overview of tasks that KOSMOS-2 can handle. Taken from the <a href="https://arxiv.org/abs/2306.14824">original paper</a>.',Ze,O,Re,D,Xe,ee,Jt='This model was contributed by <a href="https://huggingface.co/ydshieh" rel="nofollow">Yih-Dar SHIEH</a>. The original code can be found <a href="https://github.com/microsoft/unilm/tree/master/kosmos-2" rel="nofollow">here</a>.',Be,te,Ee,C,se,Ae,ge,xt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.39.0/en/model_doc/kosmos-2#transformers.Kosmos2Model">Kosmos2Model</a>. It is used to instantiate a
KOSMOS-2 model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the KOSMOS-2
<a href="https://huggingface.co/microsoft/kosmos-2-patch14-224" rel="nofollow">microsoft/kosmos-2-patch14-224</a> architecture.`,Oe,E,Ge,oe,Ke,ne,Ve,j,ae,De,ue,$t=`Constructs an KOSMOS-2 processor which wraps a KOSMOS-2 image processor and a KOSMOS-2 tokenizer into a single
processor.`,et,fe,zt=`<a href="/docs/transformers/v4.39.0/en/model_doc/kosmos-2#transformers.Kosmos2Processor">Kosmos2Processor</a> offers all the functionalities of <a href="/docs/transformers/v4.39.0/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> and some functionalities of
<a href="/docs/transformers/v4.39.0/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a>. See the docstring of <a href="/docs/transformers/v4.39.0/en/model_doc/kosmos-2#transformers.Kosmos2Processor.__call__"><strong>call</strong>()</a> and <code>decode()</code>
for more information.`,tt,$,re,st,_e,It=`This method uses <a href="/docs/transformers/v4.39.0/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> method to prepare image(s) for the model, and
<a href="/docs/transformers/v4.39.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">XLMRobertaTokenizerFast.<strong>call</strong>()</a> to prepare text for the model.`,ot,be,Ut="Please refer to the docstring of the above two methods for more information.",nt,Me,Ct="The rest of this documentation shows the arguments specific to <code>Kosmos2Processor</code>.",qe,le,He,v,ie,at,Te,Nt="KOSMOS-2 Model for generating text and image features. The model consists of a vision encoder and a language model.",rt,we,Wt=`This model inherits from <a href="/docs/transformers/v4.39.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,lt,ye,Ft=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,it,z,de,dt,ve,Zt='The <a href="/docs/transformers/v4.39.0/en/model_doc/kosmos-2#transformers.Kosmos2Model">Kosmos2Model</a> forward method, overrides the <code>__call__</code> special method.',ct,G,mt,K,Pe,ce,Le,k,me,pt,ke,Rt=`KOSMOS-2 Model for generating text and bounding boxes given an image. The model consists of a vision encoder and a
language model.`,ht,je,Xt=`This model inherits from <a href="/docs/transformers/v4.39.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,gt,Je,Bt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ut,I,pe,ft,xe,Et='The <a href="/docs/transformers/v4.39.0/en/model_doc/kosmos-2#transformers.Kosmos2ForConditionalGeneration">Kosmos2ForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',_t,V,bt,q,Ye,$e,Qe;return T=new P({props:{title:"KOSMOS-2",local:"kosmos-2",headingTag:"h1"}}),y=new P({props:{title:"Overview",local:"overview",headingTag:"h2"}}),O=new P({props:{title:"Example",local:"example",headingTag:"h2"}}),D=new Se({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEtvc21vczJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEtvc21vczJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmtvc21vcy0yLXBhdGNoMTQtMjI0JTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmtvc21vcy0yLXBhdGNoMTQtMjI0JTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZtaWNyb3NvZnQlMkZrb3Ntb3MtMi1wYXRjaDE0LTIyNCUyRnJlc29sdmUlMkZtYWluJTJGc25vd21hbi5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjIlM0Nncm91bmRpbmclM0UlMjBBbiUyMGltYWdlJTIwb2YlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHByb21wdCUyQyUyMGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwcGl4ZWxfdmFsdWVzJTNEaW5wdXRzJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0RpbnB1dHMlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2VtYmVkcyUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHNfcG9zaXRpb25fbWFzayUzRGlucHV0cyU1QiUyMmltYWdlX2VtYmVkc19wb3NpdGlvbl9tYXNrJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2NhY2hlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENjQlMkMlMEEpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBcHJvY2Vzc2VkX3RleHQlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX2dlbmVyYXRpb24oZ2VuZXJhdGVkX3RleHQlMkMlMjBjbGVhbnVwX2FuZF9leHRyYWN0JTNERmFsc2UpJTBBcHJvY2Vzc2VkX3RleHQlMEElMEFjYXB0aW9uJTJDJTIwZW50aXRpZXMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX2dlbmVyYXRpb24oZ2VuZXJhdGVkX3RleHQpJTBBY2FwdGlvbiUwQSUwQWVudGl0aWVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Kosmos2ForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Kosmos2ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;microsoft/kosmos-2-patch14-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/kosmos-2-patch14-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/microsoft/kosmos-2-patch14-224/resolve/main/snowman.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&lt;grounding&gt; An image of&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(
<span class="hljs-meta">... </span>    pixel_values=inputs[<span class="hljs-string">&quot;pixel_values&quot;</span>],
<span class="hljs-meta">... </span>    input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>],
<span class="hljs-meta">... </span>    attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
<span class="hljs-meta">... </span>    image_embeds=<span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>    image_embeds_position_mask=inputs[<span class="hljs-string">&quot;image_embeds_position_mask&quot;</span>],
<span class="hljs-meta">... </span>    use_cache=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">64</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_text = processor.post_process_generation(generated_text, cleanup_and_extract=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_text
<span class="hljs-string">&#x27;&lt;grounding&gt; An image of&lt;phrase&gt; a snowman&lt;/phrase&gt;&lt;object&gt;&lt;patch_index_0044&gt;&lt;patch_index_0863&gt;&lt;/object&gt; warming himself by&lt;phrase&gt; a fire&lt;/phrase&gt;&lt;object&gt;&lt;patch_index_0005&gt;&lt;patch_index_0911&gt;&lt;/object&gt;.&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>caption, entities = processor.post_process_generation(generated_text)
<span class="hljs-meta">&gt;&gt;&gt; </span>caption
<span class="hljs-string">&#x27;An image of a snowman warming himself by a fire.&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>entities
[(<span class="hljs-string">&#x27;a snowman&#x27;</span>, (<span class="hljs-number">12</span>, <span class="hljs-number">21</span>), [(<span class="hljs-number">0.390625</span>, <span class="hljs-number">0.046875</span>, <span class="hljs-number">0.984375</span>, <span class="hljs-number">0.828125</span>)]), (<span class="hljs-string">&#x27;a fire&#x27;</span>, (<span class="hljs-number">41</span>, <span class="hljs-number">47</span>), [(<span class="hljs-number">0.171875</span>, <span class="hljs-number">0.015625</span>, <span class="hljs-number">0.484375</span>, <span class="hljs-number">0.890625</span>)])]`,wrap:!1}}),te=new P({props:{title:"Kosmos2Config",local:"transformers.Kosmos2Config",headingTag:"h2"}}),se=new he({props:{name:"class transformers.Kosmos2Config",anchor:"transformers.Kosmos2Config",parameters:[{name:"text_config",val:" = None"},{name:"vision_config",val:" = None"},{name:"latent_query_num",val:" = 64"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Kosmos2Config.text_config",description:`<strong>text_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <code>Kosmos2TextConfig</code>.`,name:"text_config"},{anchor:"transformers.Kosmos2Config.vision_config",description:`<strong>vision_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <code>Kosmos2VisionConfig</code>.`,name:"vision_config"},{anchor:"transformers.Kosmos2Config.latent_query_num",description:`<strong>latent_query_num</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The number of latent query tokens that represent the image features used in the text decoder component.`,name:"latent_query_num"},{anchor:"transformers.Kosmos2Config.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.39.0/src/transformers/models/kosmos2/configuration_kosmos2.py#L244"}}),E=new Mt({props:{anchor:"transformers.Kosmos2Config.example",$$slots:{default:[Yt]},$$scope:{ctx:x}}}),oe=new P({props:{title:"Kosmos2ImageProcessor",local:"kosmos2imageprocessor",headingTag:"h2"}}),ne=new P({props:{title:"Kosmos2Processor",local:"transformers.Kosmos2Processor",headingTag:"h2"}}),ae=new he({props:{name:"class transformers.Kosmos2Processor",anchor:"transformers.Kosmos2Processor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""},{name:"num_patch_index_tokens",val:" = 1024"}],parametersDescription:[{anchor:"transformers.Kosmos2Processor.image_processor",description:`<strong>image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.39.0/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a>. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.Kosmos2Processor.tokenizer",description:"<strong>tokenizer</strong> (<code>XLMRobertaTokenizerFast</code>) &#x2014;\nAn instance of [&#x2018;XLMRobertaTokenizerFast`]. The tokenizer is a required input.",name:"tokenizer"},{anchor:"transformers.Kosmos2Processor.num_patch_index_tokens",description:`<strong>num_patch_index_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The number of tokens that represent patch indices.`,name:"num_patch_index_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.39.0/src/transformers/models/kosmos2/processing_kosmos2.py#L38"}}),re=new he({props:{name:"__call__",anchor:"transformers.Kosmos2Processor.__call__",parameters:[{name:"images",val:": Union = None"},{name:"text",val:": Union = None"},{name:"bboxes",val:": Union = None"},{name:"num_image_tokens",val:": Optional = 64"},{name:"first_image_token_id",val:": Optional = None"},{name:"add_special_tokens",val:": bool = True"},{name:"add_eos_token",val:": bool = False"},{name:"padding",val:": Union = False"},{name:"truncation",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"return_tensors",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Kosmos2Processor.__call__.bboxes",description:`<strong>bboxes</strong> (<code>Union[List[Tuple[int]], List[Tuple[float]], List[List[Tuple[int]]], List[List[Tuple[float]]]]</code>, <em>optional</em>) &#x2014;
The bounding bboxes associated to <code>texts</code>.`,name:"bboxes"},{anchor:"transformers.Kosmos2Processor.__call__.num_image_tokens",description:`<strong>num_image_tokens</strong> (<code>int</code>, defaults to 64) &#x2014;
The number of (consecutive) places that are used to mark the placeholders to store image information.
This should be the same as <code>latent_query_num</code> in the instance of <code>Kosmos2Config</code> you are using.`,name:"num_image_tokens"},{anchor:"transformers.Kosmos2Processor.__call__.first_image_token_id",description:`<strong>first_image_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The token id that will be used for the first place of the subsequence that is reserved to store image
information. If unset, will default to <code>self.tokenizer.unk_token_id + 1</code>.`,name:"first_image_token_id"},{anchor:"transformers.Kosmos2Processor.__call__.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not to include <code>EOS</code> token id in the encoding when <code>add_special_tokens=True</code>.`,name:"add_eos_token"}],source:"https://github.com/huggingface/transformers/blob/v4.39.0/src/transformers/models/kosmos2/processing_kosmos2.py#L105"}}),le=new P({props:{title:"Kosmos2Model",local:"transformers.Kosmos2Model",headingTag:"h2"}}),ie=new he({props:{name:"class transformers.Kosmos2Model",anchor:"transformers.Kosmos2Model",parameters:[{name:"config",val:": Kosmos2Config"}],parametersDescription:[{anchor:"transformers.Kosmos2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.0/en/model_doc/kosmos-2#transformers.Kosmos2Config">Kosmos2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.39.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.39.0/src/transformers/models/kosmos2/modeling_kosmos2.py#L1735"}}),de=new he({props:{name:"forward",anchor:"transformers.Kosmos2Model.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"input_ids",val:": Optional = None"},{name:"image_embeds_position_mask",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"image_embeds",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Kosmos2Model.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.39.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.39.0/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.Kosmos2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.39.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.39.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.39.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Kosmos2Model.forward.image_embeds_position_mask",description:`<strong>image_embeds_position_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to indicate the location in a sequence to insert the image features . Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for places where to put the image features,</li>
<li>0 for places that are not for image features (i.e. for text tokens).</li>
</ul>`,name:"image_embeds_position_mask"},{anchor:"transformers.Kosmos2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Kosmos2Model.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Kosmos2Model.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.
image_embeds &#x2014; (<code>torch.FloatTensor</code> of shape <code>(batch_size, latent_query_num, hidden_size)</code>, <em>optional</em>):
Sequence of hidden-states at the output of <code>Kosmos2ImageToTextProjection</code>.`,name:"past_key_values"},{anchor:"transformers.Kosmos2Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Kosmos2Model.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Kosmos2Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Kosmos2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Kosmos2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Kosmos2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.39.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.39.0/src/transformers/models/kosmos2/modeling_kosmos2.py#L1761",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.kosmos2.modeling_kosmos2.Kosmos2ModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.kosmos2.configuration_kosmos2.Kosmos2Config'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, latent_query_num, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of <code>Kosmos2ImageToTextProjection</code>.</p>
</li>
<li>
<p><strong>projection_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights given by <code>Kosmos2ImageToTextProjection</code>, after the attention softmax, used to compute
the weighted average in the self-attention heads.</p>
</li>
<li>
<p><strong>vision_model_output(<code>BaseModelOutputWithPooling</code>,</strong> <em>optional</em>) — The output of the <code>Kosmos2VisionModel</code>.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.kosmos2.modeling_kosmos2.Kosmos2ModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),G=new Gt({props:{$$slots:{default:[Qt]},$$scope:{ctx:x}}}),K=new Mt({props:{anchor:"transformers.Kosmos2Model.forward.example",$$slots:{default:[St]},$$scope:{ctx:x}}}),ce=new P({props:{title:"Kosmos2ForConditionalGeneration",local:"transformers.Kosmos2ForConditionalGeneration",headingTag:"h2"}}),me=new he({props:{name:"class transformers.Kosmos2ForConditionalGeneration",anchor:"transformers.Kosmos2ForConditionalGeneration",parameters:[{name:"config",val:": Kosmos2Config"}],parametersDescription:[{anchor:"transformers.Kosmos2ForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.0/en/model_doc/kosmos-2#transformers.Kosmos2Config">Kosmos2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.39.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.39.0/src/transformers/models/kosmos2/modeling_kosmos2.py#L1866"}}),pe=new he({props:{name:"forward",anchor:"transformers.Kosmos2ForConditionalGeneration.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"input_ids",val:": Optional = None"},{name:"image_embeds_position_mask",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"image_embeds",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Kosmos2ForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.39.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.39.0/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.Kosmos2ForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.39.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.39.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.39.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Kosmos2ForConditionalGeneration.forward.image_embeds_position_mask",description:`<strong>image_embeds_position_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to indicate the location in a sequence to insert the image features . Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for places where to put the image features,</li>
<li>0 for places that are not for image features (i.e. for text tokens).</li>
</ul>`,name:"image_embeds_position_mask"},{anchor:"transformers.Kosmos2ForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Kosmos2ForConditionalGeneration.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Kosmos2ForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.
image_embeds &#x2014; (<code>torch.FloatTensor</code> of shape <code>(batch_size, latent_query_num, hidden_size)</code>, <em>optional</em>):
Sequence of hidden-states at the output of <code>Kosmos2ImageToTextProjection</code>.`,name:"past_key_values"},{anchor:"transformers.Kosmos2ForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Kosmos2ForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Kosmos2ForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Kosmos2ForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Kosmos2ForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Kosmos2ForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.39.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Kosmos2ForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the left-to-right language modeling loss (next word prediction). Indices should be in
<code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are
ignored (masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.39.0/src/transformers/models/kosmos2/modeling_kosmos2.py#L1901",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.kosmos2.modeling_kosmos2.Kosmos2ForConditionalGenerationModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.kosmos2.configuration_kosmos2.Kosmos2Config'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, latent_query_num, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of <code>Kosmos2ImageToTextProjection</code>.</p>
</li>
<li>
<p><strong>projection_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights given by <code>Kosmos2ImageToTextProjection</code>, after the attention softmax, used to compute
the weighted average in the self-attention heads.</p>
</li>
<li>
<p><strong>vision_model_output(<code>BaseModelOutputWithPooling</code>,</strong> <em>optional</em>) — The output of the <code>Kosmos2VisionModel</code>.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.kosmos2.modeling_kosmos2.Kosmos2ForConditionalGenerationModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),V=new Gt({props:{$$slots:{default:[At]},$$scope:{ctx:x}}}),q=new Mt({props:{anchor:"transformers.Kosmos2ForConditionalGeneration.forward.example",$$slots:{default:[Ot]},$$scope:{ctx:x}}}),{c(){o=d("meta"),w=a(),m=d("p"),p=a(),g(T.$$.fragment),n=a(),g(y.$$.fragment),Ie=a(),L=d("p"),L.innerHTML=Tt,Ue=a(),Y=d("p"),Y.innerHTML=wt,Ce=a(),Q=d("p"),Q.textContent=yt,Ne=a(),S=d("p"),S.innerHTML=vt,We=a(),B=d("img"),Fe=a(),A=d("small"),A.innerHTML=jt,Ze=a(),g(O.$$.fragment),Re=a(),g(D.$$.fragment),Xe=a(),ee=d("p"),ee.innerHTML=Jt,Be=a(),g(te.$$.fragment),Ee=a(),C=d("div"),g(se.$$.fragment),Ae=a(),ge=d("p"),ge.innerHTML=xt,Oe=a(),g(E.$$.fragment),Ge=a(),g(oe.$$.fragment),Ke=a(),g(ne.$$.fragment),Ve=a(),j=d("div"),g(ae.$$.fragment),De=a(),ue=d("p"),ue.textContent=$t,et=a(),fe=d("p"),fe.innerHTML=zt,tt=a(),$=d("div"),g(re.$$.fragment),st=a(),_e=d("p"),_e.innerHTML=It,ot=a(),be=d("p"),be.textContent=Ut,nt=a(),Me=d("p"),Me.innerHTML=Ct,qe=a(),g(le.$$.fragment),He=a(),v=d("div"),g(ie.$$.fragment),at=a(),Te=d("p"),Te.textContent=Nt,rt=a(),we=d("p"),we.innerHTML=Wt,lt=a(),ye=d("p"),ye.innerHTML=Ft,it=a(),z=d("div"),g(de.$$.fragment),dt=a(),ve=d("p"),ve.innerHTML=Zt,ct=a(),g(G.$$.fragment),mt=a(),g(K.$$.fragment),Pe=a(),g(ce.$$.fragment),Le=a(),k=d("div"),g(me.$$.fragment),pt=a(),ke=d("p"),ke.textContent=Rt,ht=a(),je=d("p"),je.innerHTML=Xt,gt=a(),Je=d("p"),Je.innerHTML=Bt,ut=a(),I=d("div"),g(pe.$$.fragment),ft=a(),xe=d("p"),xe.innerHTML=Et,_t=a(),g(V.$$.fragment),bt=a(),g(q.$$.fragment),Ye=a(),$e=d("p"),this.h()},l(e){const t=Lt("svelte-u9bgzb",document.head);o=c(t,"META",{name:!0,content:!0}),t.forEach(s),w=r(e),m=c(e,"P",{}),X(m).forEach(s),p=r(e),u(T.$$.fragment,e),n=r(e),u(y.$$.fragment,e),Ie=r(e),L=c(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-xd2oy9"&&(L.innerHTML=Tt),Ue=r(e),Y=c(e,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-19ehga5"&&(Y.innerHTML=wt),Ce=r(e),Q=c(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-vfdo9a"&&(Q.textContent=yt),Ne=r(e),S=c(e,"P",{"data-svelte-h":!0}),h(S)!=="svelte-1tb5s4o"&&(S.innerHTML=vt),We=r(e),B=c(e,"IMG",{src:!0,alt:!0,width:!0}),Fe=r(e),A=c(e,"SMALL",{"data-svelte-h":!0}),h(A)!=="svelte-dphpfh"&&(A.innerHTML=jt),Ze=r(e),u(O.$$.fragment,e),Re=r(e),u(D.$$.fragment,e),Xe=r(e),ee=c(e,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-1x2oym7"&&(ee.innerHTML=Jt),Be=r(e),u(te.$$.fragment,e),Ee=r(e),C=c(e,"DIV",{class:!0});var R=X(C);u(se.$$.fragment,R),Ae=r(R),ge=c(R,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-186k5yf"&&(ge.innerHTML=xt),Oe=r(R),u(E.$$.fragment,R),R.forEach(s),Ge=r(e),u(oe.$$.fragment,e),Ke=r(e),u(ne.$$.fragment,e),Ve=r(e),j=c(e,"DIV",{class:!0});var N=X(j);u(ae.$$.fragment,N),De=r(N),ue=c(N,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-q6hxku"&&(ue.textContent=$t),et=r(N),fe=c(N,"P",{"data-svelte-h":!0}),h(fe)!=="svelte-1fcz4v6"&&(fe.innerHTML=zt),tt=r(N),$=c(N,"DIV",{class:!0});var W=X($);u(re.$$.fragment,W),st=r(W),_e=c(W,"P",{"data-svelte-h":!0}),h(_e)!=="svelte-gk41d7"&&(_e.innerHTML=It),ot=r(W),be=c(W,"P",{"data-svelte-h":!0}),h(be)!=="svelte-ws0hzs"&&(be.textContent=Ut),nt=r(W),Me=c(W,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-ar15lt"&&(Me.innerHTML=Ct),W.forEach(s),N.forEach(s),qe=r(e),u(le.$$.fragment,e),He=r(e),v=c(e,"DIV",{class:!0});var J=X(v);u(ie.$$.fragment,J),at=r(J),Te=c(J,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-6ep7ku"&&(Te.textContent=Nt),rt=r(J),we=c(J,"P",{"data-svelte-h":!0}),h(we)!=="svelte-1c30htx"&&(we.innerHTML=Wt),lt=r(J),ye=c(J,"P",{"data-svelte-h":!0}),h(ye)!=="svelte-hswkmf"&&(ye.innerHTML=Ft),it=r(J),z=c(J,"DIV",{class:!0});var F=X(z);u(de.$$.fragment,F),dt=r(F),ve=c(F,"P",{"data-svelte-h":!0}),h(ve)!=="svelte-1quspqr"&&(ve.innerHTML=Zt),ct=r(F),u(G.$$.fragment,F),mt=r(F),u(K.$$.fragment,F),F.forEach(s),J.forEach(s),Pe=r(e),u(ce.$$.fragment,e),Le=r(e),k=c(e,"DIV",{class:!0});var Z=X(k);u(me.$$.fragment,Z),pt=r(Z),ke=c(Z,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-ydmd28"&&(ke.textContent=Rt),ht=r(Z),je=c(Z,"P",{"data-svelte-h":!0}),h(je)!=="svelte-1c30htx"&&(je.innerHTML=Xt),gt=r(Z),Je=c(Z,"P",{"data-svelte-h":!0}),h(Je)!=="svelte-hswkmf"&&(Je.innerHTML=Bt),ut=r(Z),I=c(Z,"DIV",{class:!0});var H=X(I);u(pe.$$.fragment,H),ft=r(H),xe=c(H,"P",{"data-svelte-h":!0}),h(xe)!=="svelte-2ztz2h"&&(xe.innerHTML=Et),_t=r(H),u(V.$$.fragment,H),bt=r(H),u(q.$$.fragment,H),H.forEach(s),Z.forEach(s),Ye=r(e),$e=c(e,"P",{}),X($e).forEach(s),this.h()},h(){U(o,"name","hf:doc:metadata"),U(o,"content",es),Vt(B.src,kt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/kosmos_2_overview.jpg")||U(B,"src",kt),U(B,"alt","drawing"),U(B,"width","600"),U(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,o),l(e,w,t),l(e,m,t),l(e,p,t),f(T,e,t),l(e,n,t),f(y,e,t),l(e,Ie,t),l(e,L,t),l(e,Ue,t),l(e,Y,t),l(e,Ce,t),l(e,Q,t),l(e,Ne,t),l(e,S,t),l(e,We,t),l(e,B,t),l(e,Fe,t),l(e,A,t),l(e,Ze,t),f(O,e,t),l(e,Re,t),f(D,e,t),l(e,Xe,t),l(e,ee,t),l(e,Be,t),f(te,e,t),l(e,Ee,t),l(e,C,t),f(se,C,null),i(C,Ae),i(C,ge),i(C,Oe),f(E,C,null),l(e,Ge,t),f(oe,e,t),l(e,Ke,t),f(ne,e,t),l(e,Ve,t),l(e,j,t),f(ae,j,null),i(j,De),i(j,ue),i(j,et),i(j,fe),i(j,tt),i(j,$),f(re,$,null),i($,st),i($,_e),i($,ot),i($,be),i($,nt),i($,Me),l(e,qe,t),f(le,e,t),l(e,He,t),l(e,v,t),f(ie,v,null),i(v,at),i(v,Te),i(v,rt),i(v,we),i(v,lt),i(v,ye),i(v,it),i(v,z),f(de,z,null),i(z,dt),i(z,ve),i(z,ct),f(G,z,null),i(z,mt),f(K,z,null),l(e,Pe,t),f(ce,e,t),l(e,Le,t),l(e,k,t),f(me,k,null),i(k,pt),i(k,ke),i(k,ht),i(k,je),i(k,gt),i(k,Je),i(k,ut),i(k,I),f(pe,I,null),i(I,ft),i(I,xe),i(I,_t),f(V,I,null),i(I,bt),f(q,I,null),l(e,Ye,t),l(e,$e,t),Qe=!0},p(e,[t]){const R={};t&2&&(R.$$scope={dirty:t,ctx:e}),E.$set(R);const N={};t&2&&(N.$$scope={dirty:t,ctx:e}),G.$set(N);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),K.$set(W);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),V.$set(J);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),q.$set(F)},i(e){Qe||(_(T.$$.fragment,e),_(y.$$.fragment,e),_(O.$$.fragment,e),_(D.$$.fragment,e),_(te.$$.fragment,e),_(se.$$.fragment,e),_(E.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(G.$$.fragment,e),_(K.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(V.$$.fragment,e),_(q.$$.fragment,e),Qe=!0)},o(e){b(T.$$.fragment,e),b(y.$$.fragment,e),b(O.$$.fragment,e),b(D.$$.fragment,e),b(te.$$.fragment,e),b(se.$$.fragment,e),b(E.$$.fragment,e),b(oe.$$.fragment,e),b(ne.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),b(ie.$$.fragment,e),b(de.$$.fragment,e),b(G.$$.fragment,e),b(K.$$.fragment,e),b(ce.$$.fragment,e),b(me.$$.fragment,e),b(pe.$$.fragment,e),b(V.$$.fragment,e),b(q.$$.fragment,e),Qe=!1},d(e){e&&(s(w),s(m),s(p),s(n),s(Ie),s(L),s(Ue),s(Y),s(Ce),s(Q),s(Ne),s(S),s(We),s(B),s(Fe),s(A),s(Ze),s(Re),s(Xe),s(ee),s(Be),s(Ee),s(C),s(Ge),s(Ke),s(Ve),s(j),s(qe),s(He),s(v),s(Pe),s(Le),s(k),s(Ye),s($e)),s(o),M(T,e),M(y,e),M(O,e),M(D,e),M(te,e),M(se),M(E),M(oe,e),M(ne,e),M(ae),M(re),M(le,e),M(ie),M(de),M(G),M(K),M(ce,e),M(me),M(pe),M(V),M(q)}}}const es='{"title":"KOSMOS-2","local":"kosmos-2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Example","local":"example","sections":[],"depth":2},{"title":"Kosmos2Config","local":"transformers.Kosmos2Config","sections":[],"depth":2},{"title":"Kosmos2ImageProcessor","local":"kosmos2imageprocessor","sections":[],"depth":2},{"title":"Kosmos2Processor","local":"transformers.Kosmos2Processor","sections":[],"depth":2},{"title":"Kosmos2Model","local":"transformers.Kosmos2Model","sections":[],"depth":2},{"title":"Kosmos2ForConditionalGeneration","local":"transformers.Kosmos2ForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function ts(x){return qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ds extends Ht{constructor(o){super(),Pt(this,o,ts,Dt,Kt,{})}}export{ds as component};
