import{s as Dt,n as Kt,o as Ot}from"../chunks/scheduler.d586627e.js";import{S as el,i as tl,g as o,s as a,r as d,A as ll,h as i,f as l,c as n,j as Pt,u as r,x as m,k as St,y as sl,a as s,v as p,d as u,t as g,w as c}from"../chunks/index.8589a59c.js";import{C as M}from"../chunks/CodeBlock.47c46d2c.js";import{D as al}from"../chunks/DocNotebookDropdown.43d2c946.js";import{H as f}from"../chunks/Heading.a70e045b.js";function nl(ft){let b,fe,Me,Je,J,Te,T,ye,y,Jt=`Existem vários modelos multilinguísticos no 🤗 Transformers e seus usos para inferência diferem dos modelos monolíngues.
No entanto, nem <em>todos</em> os usos dos modelos multilíngues são tão diferentes.
Alguns modelos, como o <a href="https://huggingface.co/google-bert/bert-base-multilingual-uncased" rel="nofollow">google-bert/bert-base-multilingual-uncased</a>,
podem ser usados como se fossem monolíngues. Este guia irá te ajudar a usar modelos multilíngues cujo uso difere
para o propósito de inferência.`,he,h,Ue,U,Tt=`O XLM tem dez checkpoints diferentes dos quais apenas um é monolíngue.
Os nove checkpoints restantes do modelo são subdivididos em duas categorias:
checkpoints que usam de language embeddings e os que não.`,ke,k,$e,$,yt="Os seguintes modelos de XLM usam language embeddings para especificar a linguagem utilizada para a inferência.",we,w,ht="<li><code>FacebookAI/xlm-mlm-ende-1024</code> (Masked language modeling, English-German)</li> <li><code>FacebookAI/xlm-mlm-enfr-1024</code> (Masked language modeling, English-French)</li> <li><code>FacebookAI/xlm-mlm-enro-1024</code> (Masked language modeling, English-Romanian)</li> <li><code>FacebookAI/xlm-mlm-xnli15-1024</code> (Masked language modeling, XNLI languages)</li> <li><code>FacebookAI/xlm-mlm-tlm-xnli15-1024</code> (Masked language modeling + translation, XNLI languages)</li> <li><code>FacebookAI/xlm-clm-enfr-1024</code> (Causal language modeling, English-French)</li> <li><code>FacebookAI/xlm-clm-ende-1024</code> (Causal language modeling, English-German)</li>",je,j,Ut=`Os language embeddings são representados por um tensor de mesma dimensão que os <code>input_ids</code> passados ao modelo.
Os valores destes tensores dependem do idioma utilizado e se identificam pelos atributos <code>lang2id</code> e <code>id2lang</code> do tokenizador.`,xe,x,kt="Neste exemplo, carregamos o checkpoint <code>FacebookAI/xlm-clm-enfr-1024</code>(Causal language modeling, English-French):",ve,v,Ze,Z,$t="O atributo <code>lang2id</code> do tokenizador mostra os idiomas deste modelo e seus ids:",Ce,C,_e,_,wt="Em seguida, cria-se um input de exemplo:",Ie,I,Xe,X,jt=`Estabelece-se o id do idioma, por exemplo <code>&quot;en&quot;</code>, e utiliza-se o mesmo para definir a language embedding.
A language embedding é um tensor preenchido com <code>0</code>, que é o id de idioma para o inglês.
Este tensor deve ser do mesmo tamanho que os <code>input_ids</code>.`,Ge,G,ze,z,xt="Agora você pode passar os <code>input_ids</code> e a language embedding ao modelo:",We,W,Ve,V,vt='O script <a href="https://github.com/huggingface/transformers/tree/master/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> pode gerar um texto com language embeddings utilizando os checkpoints <code>xlm-clm</code>.',Le,L,Re,R,Zt="Os seguintes modelos XLM não requerem o uso de language embeddings durante a inferência:",Be,B,Ct="<li><code>FacebookAI/xlm-mlm-17-1280</code> (Modelagem de linguagem com máscara, 17 idiomas)</li> <li><code>FacebookAI/xlm-mlm-100-1280</code> (Modelagem de linguagem com máscara, 100 idiomas)</li>",Ee,E,_t="Estes modelos são utilizados para representações genéricas de frase diferentemente dos checkpoints XLM anteriores.",Fe,F,qe,q,It="Os seguintes modelos do BERT podem ser utilizados para tarefas multilinguísticas:",He,H,Xt="<li><code>google-bert/bert-base-multilingual-uncased</code> (Modelagem de linguagem com máscara + Previsão de frases, 102 idiomas)</li> <li><code>google-bert/bert-base-multilingual-cased</code> (Modelagem de linguagem com máscara + Previsão de frases, 104 idiomas)</li>",Qe,Q,Gt=`Estes modelos não requerem language embeddings durante a inferência. Devem identificar a linguagem a partir
do contexto e realizar a inferência em sequência.`,Ne,N,Ye,Y,zt="Os seguintes modelos do XLM-RoBERTa podem ser utilizados para tarefas multilinguísticas:",Ae,A,Wt="<li><code>FacebookAI/xlm-roberta-base</code> (Modelagem de linguagem com máscara, 100 idiomas)</li> <li><code>FacebookAI/xlm-roberta-large</code> Modelagem de linguagem com máscara, 100 idiomas)</li>",Pe,P,Vt=`O XLM-RoBERTa foi treinado com 2,5 TB de dados do CommonCrawl recém-criados e testados em 100 idiomas.
Proporciona fortes vantagens sobre os modelos multilinguísticos publicados anteriormente como o mBERT e o XLM em tarefas
subsequentes como a classificação, a rotulagem de sequências e à respostas a perguntas.`,Se,S,De,D,Lt="Os seguintes modelos de M2M100 podem ser utilizados para traduções multilinguísticas:",Ke,K,Rt="<li><code>facebook/m2m100_418M</code> (Tradução)</li> <li><code>facebook/m2m100_1.2B</code> (Tradução)</li>",Oe,O,Bt=`Neste exemplo, o checkpoint <code>facebook/m2m100_418M</code> é carregado para traduzir do mandarim ao inglês. É possível
estabelecer o idioma de origem no tokenizador:`,et,ee,tt,te,Et="Tokenização do texto:",lt,le,st,se,Ft=`O M2M100 força o id do idioma de destino como o primeiro token gerado para traduzir ao idioma de destino.
É definido o <code>forced_bos_token_id</code> como <code>en</code> no método <code>generate</code> para traduzir ao inglês.`,at,ae,nt,ne,ot,oe,qt="Os seguintes modelos do MBart podem ser utilizados para tradução multilinguística:",it,ie,Ht="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> (Tradução automática multilinguística de um a vários, 50 idiomas)</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> (Tradução automática multilinguística de vários a vários, 50 idiomas)</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> (Tradução automática multilinguística vários a um, 50 idiomas)</li> <li><code>facebook/mbart-large-50</code> (Tradução multilinguística, 50 idiomas)</li> <li><code>facebook/mbart-large-cc25</code></li>",mt,me,Qt=`Neste exemplo, carrega-se o checkpoint <code>facebook/mbart-large-50-many-to-many-mmt</code> para traduzir do finlandês ao inglês.
Pode-se definir o idioma de origem no tokenizador:`,dt,de,rt,re,Nt="Tokenizando o texto:",pt,pe,ut,ue,Yt=`O MBart força o id do idioma de destino como o primeiro token gerado para traduzir ao idioma de destino.
É definido o <code>forced_bos_token_id</code> como <code>en</code> no método <code>generate</code> para traduzir ao inglês.`,gt,ge,ct,ce,At=`Se estiver usando o checkpoint <code>facebook/mbart-large-50-many-to-one-mmt</code> não será necessário forçar o id do idioma de destino
como sendo o primeiro token generado, caso contrário a usagem é a mesma.`,Mt,be,bt;return J=new f({props:{title:"Modelos multilinguísticos para inferência",local:"modelos-multilinguísticos-para-inferência",headingTag:"h1"}}),T=new al({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/tensorflow/multilingual.ipynb"}]}}),h=new f({props:{title:"XLM",local:"xlm",headingTag:"h2"}}),k=new f({props:{title:"XLM com language embeddings",local:"xlm-com-language-embeddings",headingTag:"h3"}}),v=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJGYWNlYm9va0FJJTJGeGxtLWNsbS1lbmZyLTEwMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBYTE1XaXRoTE1IZWFkTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkZhY2Vib29rQUklMkZ4bG0tY2xtLWVuZnItMTAyNCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;FacebookAI/xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;FacebookAI/xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),C=new M({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),I=new M({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjBvZiUyMDE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size of 1</span>',wrap:!1}}),G=new M({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwV2UlMjByZXNoYXBlJTIwaXQlMjB0byUyMGJlJTIwb2YlMjBzaXplJTIwKGJhdGNoX3NpemUlMkMlMjBzZXF1ZW5jZV9sZW5ndGgpJTBBbGFuZ3MlMjAlM0QlMjBsYW5ncy52aWV3KDElMkMlMjAtMSklMjAlMjAlMjMlMjBpcyUyMG5vdyUyMG9mJTIwc2hhcGUlMjAlNUIxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTVEJTIwKHdlJTIwaGF2ZSUyMGElMjBiYXRjaCUyMHNpemUlMjBvZiUyMDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We reshape it to be of size (batch_size, sequence_length)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># is now of shape [1, sequence_length] (we have a batch size of 1)</span>`,wrap:!1}}),W=new M({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),L=new f({props:{title:"XLM sem language embeddings",local:"xlm-sem-language-embeddings",headingTag:"h3"}}),F=new f({props:{title:"BERT",local:"bert",headingTag:"h2"}}),N=new f({props:{title:"XLM-RoBERTa",local:"xlm-roberta",headingTag:"h2"}}),S=new f({props:{title:"M2M100",local:"m2m100",headingTag:"h2"}}),ee=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),le=new M({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ae=new M({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),ne=new f({props:{title:"MBart",local:"mbart",headingTag:"h2"}}),de=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),pe=new M({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ge=new M({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkKCUyMmVuX1hYJTIyKSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id(<span class="hljs-string">&quot;en_XX&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),{c(){b=o("meta"),fe=a(),Me=o("p"),Je=a(),d(J.$$.fragment),Te=a(),d(T.$$.fragment),ye=a(),y=o("p"),y.innerHTML=Jt,he=a(),d(h.$$.fragment),Ue=a(),U=o("p"),U.textContent=Tt,ke=a(),d(k.$$.fragment),$e=a(),$=o("p"),$.textContent=yt,we=a(),w=o("ul"),w.innerHTML=ht,je=a(),j=o("p"),j.innerHTML=Ut,xe=a(),x=o("p"),x.innerHTML=kt,ve=a(),d(v.$$.fragment),Ze=a(),Z=o("p"),Z.innerHTML=$t,Ce=a(),d(C.$$.fragment),_e=a(),_=o("p"),_.textContent=wt,Ie=a(),d(I.$$.fragment),Xe=a(),X=o("p"),X.innerHTML=jt,Ge=a(),d(G.$$.fragment),ze=a(),z=o("p"),z.innerHTML=xt,We=a(),d(W.$$.fragment),Ve=a(),V=o("p"),V.innerHTML=vt,Le=a(),d(L.$$.fragment),Re=a(),R=o("p"),R.textContent=Zt,Be=a(),B=o("ul"),B.innerHTML=Ct,Ee=a(),E=o("p"),E.textContent=_t,Fe=a(),d(F.$$.fragment),qe=a(),q=o("p"),q.textContent=It,He=a(),H=o("ul"),H.innerHTML=Xt,Qe=a(),Q=o("p"),Q.textContent=Gt,Ne=a(),d(N.$$.fragment),Ye=a(),Y=o("p"),Y.textContent=zt,Ae=a(),A=o("ul"),A.innerHTML=Wt,Pe=a(),P=o("p"),P.textContent=Vt,Se=a(),d(S.$$.fragment),De=a(),D=o("p"),D.textContent=Lt,Ke=a(),K=o("ul"),K.innerHTML=Rt,Oe=a(),O=o("p"),O.innerHTML=Bt,et=a(),d(ee.$$.fragment),tt=a(),te=o("p"),te.textContent=Et,lt=a(),d(le.$$.fragment),st=a(),se=o("p"),se.innerHTML=Ft,at=a(),d(ae.$$.fragment),nt=a(),d(ne.$$.fragment),ot=a(),oe=o("p"),oe.textContent=qt,it=a(),ie=o("ul"),ie.innerHTML=Ht,mt=a(),me=o("p"),me.innerHTML=Qt,dt=a(),d(de.$$.fragment),rt=a(),re=o("p"),re.textContent=Nt,pt=a(),d(pe.$$.fragment),ut=a(),ue=o("p"),ue.innerHTML=Yt,gt=a(),d(ge.$$.fragment),ct=a(),ce=o("p"),ce.innerHTML=At,Mt=a(),be=o("p"),this.h()},l(e){const t=ll("svelte-u9bgzb",document.head);b=i(t,"META",{name:!0,content:!0}),t.forEach(l),fe=n(e),Me=i(e,"P",{}),Pt(Me).forEach(l),Je=n(e),r(J.$$.fragment,e),Te=n(e),r(T.$$.fragment,e),ye=n(e),y=i(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-16vg6ah"&&(y.innerHTML=Jt),he=n(e),r(h.$$.fragment,e),Ue=n(e),U=i(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1b8wedt"&&(U.textContent=Tt),ke=n(e),r(k.$$.fragment,e),$e=n(e),$=i(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1g05fmh"&&($.textContent=yt),we=n(e),w=i(e,"UL",{"data-svelte-h":!0}),m(w)!=="svelte-bq7gp5"&&(w.innerHTML=ht),je=n(e),j=i(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1wzx267"&&(j.innerHTML=Ut),xe=n(e),x=i(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-16xglvw"&&(x.innerHTML=kt),ve=n(e),r(v.$$.fragment,e),Ze=n(e),Z=i(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1jlw8vy"&&(Z.innerHTML=$t),Ce=n(e),r(C.$$.fragment,e),_e=n(e),_=i(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-fdserj"&&(_.textContent=wt),Ie=n(e),r(I.$$.fragment,e),Xe=n(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-gr6p76"&&(X.innerHTML=jt),Ge=n(e),r(G.$$.fragment,e),ze=n(e),z=i(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-syxnxn"&&(z.innerHTML=xt),We=n(e),r(W.$$.fragment,e),Ve=n(e),V=i(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1olpich"&&(V.innerHTML=vt),Le=n(e),r(L.$$.fragment,e),Re=n(e),R=i(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-uu1fkj"&&(R.textContent=Zt),Be=n(e),B=i(e,"UL",{"data-svelte-h":!0}),m(B)!=="svelte-1fta402"&&(B.innerHTML=Ct),Ee=n(e),E=i(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1647i4h"&&(E.textContent=_t),Fe=n(e),r(F.$$.fragment,e),qe=n(e),q=i(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1otw1i1"&&(q.textContent=It),He=n(e),H=i(e,"UL",{"data-svelte-h":!0}),m(H)!=="svelte-e6dubl"&&(H.innerHTML=Xt),Qe=n(e),Q=i(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-188d9hb"&&(Q.textContent=Gt),Ne=n(e),r(N.$$.fragment,e),Ye=n(e),Y=i(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1on8run"&&(Y.textContent=zt),Ae=n(e),A=i(e,"UL",{"data-svelte-h":!0}),m(A)!=="svelte-10y283s"&&(A.innerHTML=Wt),Pe=n(e),P=i(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1mo7moz"&&(P.textContent=Vt),Se=n(e),r(S.$$.fragment,e),De=n(e),D=i(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1uzzyuv"&&(D.textContent=Lt),Ke=n(e),K=i(e,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-1811mz9"&&(K.innerHTML=Rt),Oe=n(e),O=i(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-18dxqmr"&&(O.innerHTML=Bt),et=n(e),r(ee.$$.fragment,e),tt=n(e),te=i(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-6ksz4d"&&(te.textContent=Et),lt=n(e),r(le.$$.fragment,e),st=n(e),se=i(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-1k8y33q"&&(se.innerHTML=Ft),at=n(e),r(ae.$$.fragment,e),nt=n(e),r(ne.$$.fragment,e),ot=n(e),oe=i(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-i72hny"&&(oe.textContent=qt),it=n(e),ie=i(e,"UL",{"data-svelte-h":!0}),m(ie)!=="svelte-1wsg399"&&(ie.innerHTML=Ht),mt=n(e),me=i(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-134fnsi"&&(me.innerHTML=Qt),dt=n(e),r(de.$$.fragment,e),rt=n(e),re=i(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-u1agxv"&&(re.textContent=Nt),pt=n(e),r(pe.$$.fragment,e),ut=n(e),ue=i(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-ybbnzp"&&(ue.innerHTML=Yt),gt=n(e),r(ge.$$.fragment,e),ct=n(e),ce=i(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-quxms0"&&(ce.innerHTML=At),Mt=n(e),be=i(e,"P",{}),Pt(be).forEach(l),this.h()},h(){St(b,"name","hf:doc:metadata"),St(b,"content",ol)},m(e,t){sl(document.head,b),s(e,fe,t),s(e,Me,t),s(e,Je,t),p(J,e,t),s(e,Te,t),p(T,e,t),s(e,ye,t),s(e,y,t),s(e,he,t),p(h,e,t),s(e,Ue,t),s(e,U,t),s(e,ke,t),p(k,e,t),s(e,$e,t),s(e,$,t),s(e,we,t),s(e,w,t),s(e,je,t),s(e,j,t),s(e,xe,t),s(e,x,t),s(e,ve,t),p(v,e,t),s(e,Ze,t),s(e,Z,t),s(e,Ce,t),p(C,e,t),s(e,_e,t),s(e,_,t),s(e,Ie,t),p(I,e,t),s(e,Xe,t),s(e,X,t),s(e,Ge,t),p(G,e,t),s(e,ze,t),s(e,z,t),s(e,We,t),p(W,e,t),s(e,Ve,t),s(e,V,t),s(e,Le,t),p(L,e,t),s(e,Re,t),s(e,R,t),s(e,Be,t),s(e,B,t),s(e,Ee,t),s(e,E,t),s(e,Fe,t),p(F,e,t),s(e,qe,t),s(e,q,t),s(e,He,t),s(e,H,t),s(e,Qe,t),s(e,Q,t),s(e,Ne,t),p(N,e,t),s(e,Ye,t),s(e,Y,t),s(e,Ae,t),s(e,A,t),s(e,Pe,t),s(e,P,t),s(e,Se,t),p(S,e,t),s(e,De,t),s(e,D,t),s(e,Ke,t),s(e,K,t),s(e,Oe,t),s(e,O,t),s(e,et,t),p(ee,e,t),s(e,tt,t),s(e,te,t),s(e,lt,t),p(le,e,t),s(e,st,t),s(e,se,t),s(e,at,t),p(ae,e,t),s(e,nt,t),p(ne,e,t),s(e,ot,t),s(e,oe,t),s(e,it,t),s(e,ie,t),s(e,mt,t),s(e,me,t),s(e,dt,t),p(de,e,t),s(e,rt,t),s(e,re,t),s(e,pt,t),p(pe,e,t),s(e,ut,t),s(e,ue,t),s(e,gt,t),p(ge,e,t),s(e,ct,t),s(e,ce,t),s(e,Mt,t),s(e,be,t),bt=!0},p:Kt,i(e){bt||(u(J.$$.fragment,e),u(T.$$.fragment,e),u(h.$$.fragment,e),u(k.$$.fragment,e),u(v.$$.fragment,e),u(C.$$.fragment,e),u(I.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u(L.$$.fragment,e),u(F.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(de.$$.fragment,e),u(pe.$$.fragment,e),u(ge.$$.fragment,e),bt=!0)},o(e){g(J.$$.fragment,e),g(T.$$.fragment,e),g(h.$$.fragment,e),g(k.$$.fragment,e),g(v.$$.fragment,e),g(C.$$.fragment,e),g(I.$$.fragment,e),g(G.$$.fragment,e),g(W.$$.fragment,e),g(L.$$.fragment,e),g(F.$$.fragment,e),g(N.$$.fragment,e),g(S.$$.fragment,e),g(ee.$$.fragment,e),g(le.$$.fragment,e),g(ae.$$.fragment,e),g(ne.$$.fragment,e),g(de.$$.fragment,e),g(pe.$$.fragment,e),g(ge.$$.fragment,e),bt=!1},d(e){e&&(l(fe),l(Me),l(Je),l(Te),l(ye),l(y),l(he),l(Ue),l(U),l(ke),l($e),l($),l(we),l(w),l(je),l(j),l(xe),l(x),l(ve),l(Ze),l(Z),l(Ce),l(_e),l(_),l(Ie),l(Xe),l(X),l(Ge),l(ze),l(z),l(We),l(Ve),l(V),l(Le),l(Re),l(R),l(Be),l(B),l(Ee),l(E),l(Fe),l(qe),l(q),l(He),l(H),l(Qe),l(Q),l(Ne),l(Ye),l(Y),l(Ae),l(A),l(Pe),l(P),l(Se),l(De),l(D),l(Ke),l(K),l(Oe),l(O),l(et),l(tt),l(te),l(lt),l(st),l(se),l(at),l(nt),l(ot),l(oe),l(it),l(ie),l(mt),l(me),l(dt),l(rt),l(re),l(pt),l(ut),l(ue),l(gt),l(ct),l(ce),l(Mt),l(be)),l(b),c(J,e),c(T,e),c(h,e),c(k,e),c(v,e),c(C,e),c(I,e),c(G,e),c(W,e),c(L,e),c(F,e),c(N,e),c(S,e),c(ee,e),c(le,e),c(ae,e),c(ne,e),c(de,e),c(pe,e),c(ge,e)}}}const ol='{"title":"Modelos multilinguísticos para inferência","local":"modelos-multilinguísticos-para-inferência","sections":[{"title":"XLM","local":"xlm","sections":[{"title":"XLM com language embeddings","local":"xlm-com-language-embeddings","sections":[],"depth":3},{"title":"XLM sem language embeddings","local":"xlm-sem-language-embeddings","sections":[],"depth":3}],"depth":2},{"title":"BERT","local":"bert","sections":[],"depth":2},{"title":"XLM-RoBERTa","local":"xlm-roberta","sections":[],"depth":2},{"title":"M2M100","local":"m2m100","sections":[],"depth":2},{"title":"MBart","local":"mbart","sections":[],"depth":2}],"depth":1}';function il(ft){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gl extends el{constructor(b){super(),tl(this,b,il,nl,Dt,{})}}export{gl as component};
