import{s as Zs,o as Ns,n as V}from"../chunks/scheduler.22bf70d2.js";import{S as Xs,i as Ws,g as c,s as l,r as g,A as Qs,h as p,f as d,c as r,j as T,u as f,x as u,k as x,y as a,a as j,v as M,d as y,t as b,w}from"../chunks/index.59178e06.js";import{D as B}from"../chunks/Docstring.cefe8221.js";import{C as A}from"../chunks/CodeBlock.f7047b13.js";import{E as Y}from"../chunks/ExampleCodeBlock.36f5c5dc.js";import{H as Ps}from"../chunks/Heading.f8746c79.js";function zs(J){let s,$="Example:",i,n,o;return n=new A({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUuc3RhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBd2l0aCUyMHN0YXRlLmxvY2FsX21haW5fcHJvY2Vzc19maXJzdCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVGhpcyUyMHdpbGwlMjBiZSUyMHByaW50ZWQlMjBmaXJzdCUyMGJ5JTIwbG9jYWwlMjBwcm9jZXNzJTIwMCUyMHRoZW4lMjBpbiUyMGElMjBzZWVtaW5nbHklMEElMjAlMjAlMjAlMjAlMjMlMjByYW5kb20lMjBvcmRlciUyMGJ5JTIwdGhlJTIwb3RoZXIlMjBwcm9jZXNzZXMuJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlRoaXMlMjB3aWxsJTIwYmUlMjBwcmludGVkJTIwYnklMjBwcm9jZXNzJTIwJTdCc3RhdGUubG9jYWxfcHJvY2Vzc19pbmRleCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

<span class="hljs-meta">&gt;&gt;&gt; </span>state = PartialState()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> state.local_main_process_first():
<span class="hljs-meta">... </span>    <span class="hljs-comment"># This will be printed first by local process 0 then in a seemingly</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># random order by the other processes.</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;This will be printed by process <span class="hljs-subst">{state.local_process_index}</span>&quot;</span>)`,wrap:!1}}),{c(){s=c("p"),s.textContent=$,i=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),i=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,i,m),M(n,e,m),o=!0},p:V,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(i)),w(n,e)}}}function Fs(J){let s,$="Example:",i,n,o;return n=new A({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQXdpdGglMjBhY2NlbGVyYXRvci5tYWluX3Byb2Nlc3NfZmlyc3QoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFRoaXMlMjB3aWxsJTIwYmUlMjBwcmludGVkJTIwZmlyc3QlMjBieSUyMHByb2Nlc3MlMjAwJTIwdGhlbiUyMGluJTIwYSUyMHNlZW1pbmdseSUwQSUyMCUyMCUyMCUyMCUyMyUyMHJhbmRvbSUyMG9yZGVyJTIwYnklMjB0aGUlMjBvdGhlciUyMHByb2Nlc3Nlcy4lMEElMjAlMjAlMjAlMjBwcmludChmJTIyVGhpcyUyMHdpbGwlMjBiZSUyMHByaW50ZWQlMjBieSUyMHByb2Nlc3MlMjAlN0JhY2NlbGVyYXRvci5wcm9jZXNzX2luZGV4JTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> accelerator.main_process_first():
<span class="hljs-meta">... </span>    <span class="hljs-comment"># This will be printed first by process 0 then in a seemingly</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># random order by the other processes.</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;This will be printed by process <span class="hljs-subst">{accelerator.process_index}</span>&quot;</span>)`,wrap:!1}}),{c(){s=c("p"),s.textContent=$,i=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),i=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,i,m),M(n,e,m),o=!0},p:V,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(i)),w(n,e)}}}function Hs(J){let s,$="Example:",i,n,o;return n=new A({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwNCUyMHByb2Nlc3Nlcy4lMEFmcm9tJTIwYWNjZWxlcmF0ZS5zdGF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQSUwQXN0YXRlJTIwJTNEJTIwUGFydGlhbFN0YXRlKCklMEElMEElMEElNDBzdGF0ZS5vbl9sYXN0X3Byb2Nlc3MlMEFkZWYlMjBwcmludF9zb21ldGhpbmcoKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJQcmludGVkJTIwb24lMjBwcm9jZXNzJTIwJTdCc3RhdGUucHJvY2Vzc19pbmRleCU3RCUyMiklMEElMEElMEFwcmludF9zb21ldGhpbmcoKSUwQSUyMlByaW50ZWQlMjBvbiUyMHByb2Nlc3MlMjAzJTIy",highlighted:`<span class="hljs-comment"># Assume we have 4 processes.</span>
<span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

state = PartialState()


<span class="hljs-meta">@state.on_last_process</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Printed on process <span class="hljs-subst">{state.process_index}</span>&quot;</span>)


print_something()
<span class="hljs-string">&quot;Printed on process 3&quot;</span>`,wrap:!1}}),{c(){s=c("p"),s.textContent=$,i=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),i=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,i,m),M(n,e,m),o=!0},p:V,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(i)),w(n,e)}}}function qs(J){let s,$="Example:",i,n,o;return n=new A({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwMiUyMHNlcnZlcnMlMjB3aXRoJTIwNCUyMHByb2Nlc3NlcyUyMGVhY2guJTBBZnJvbSUyMGFjY2VsZXJhdGUuc3RhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBJTBBJTBBJTQwc3RhdGUub25fbG9jYWxfbWFpbl9wcm9jZXNzJTBBZGVmJTIwcHJpbnRfc29tZXRoaW5nKCklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJUaGlzJTIwd2lsbCUyMGJlJTIwcHJpbnRlZCUyMGJ5JTIwcHJvY2VzcyUyMDAlMjBvbmx5JTIwb24lMjBlYWNoJTIwc2VydmVyLiUyMiklMEElMEElMEFwcmludF9zb21ldGhpbmcoKSUwQSUyMyUyME9uJTIwc2VydmVyJTIwMSUzQSUwQSUyMlRoaXMlMjB3aWxsJTIwYmUlMjBwcmludGVkJTIwYnklMjBwcm9jZXNzJTIwMCUyMG9ubHklMjIlMEElMjMlMjBPbiUyMHNlcnZlciUyMDIlM0ElMEElMjJUaGlzJTIwd2lsbCUyMGJlJTIwcHJpbnRlZCUyMGJ5JTIwcHJvY2VzcyUyMDAlMjBvbmx5JTIy",highlighted:`<span class="hljs-comment"># Assume we have 2 servers with 4 processes each.</span>
<span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

state = PartialState()


<span class="hljs-meta">@state.on_local_main_process</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;This will be printed by process 0 only on each server.&quot;</span>)


print_something()
<span class="hljs-comment"># On server 1:</span>
<span class="hljs-string">&quot;This will be printed by process 0 only&quot;</span>
<span class="hljs-comment"># On server 2:</span>
<span class="hljs-string">&quot;This will be printed by process 0 only&quot;</span>`,wrap:!1}}),{c(){s=c("p"),s.textContent=$,i=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),i=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,i,m),M(n,e,m),o=!0},p:V,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(i)),w(n,e)}}}function Rs(J){let s,$="Example:",i,n,o;return n=new A({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwMiUyMHNlcnZlcnMlMjB3aXRoJTIwNCUyMHByb2Nlc3NlcyUyMGVhY2guJTBBZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUwQSU0MGFjY2VsZXJhdG9yLm9uX2xvY2FsX3Byb2Nlc3MobG9jYWxfcHJvY2Vzc19pbmRleCUzRDIpJTBBZGVmJTIwcHJpbnRfc29tZXRoaW5nKCklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyUHJpbnRlZCUyMG9uJTIwcHJvY2VzcyUyMCU3QmFjY2VsZXJhdG9yLmxvY2FsX3Byb2Nlc3NfaW5kZXglN0QlMjIpJTBBJTBBJTBBcHJpbnRfc29tZXRoaW5nKCklMEElMjMlMjBPbiUyMHNlcnZlciUyMDElM0ElMEElMjJQcmludGVkJTIwb24lMjBwcm9jZXNzJTIwMiUyMiUwQSUyMyUyME9uJTIwc2VydmVyJTIwMiUzQSUwQSUyMlByaW50ZWQlMjBvbiUyMHByb2Nlc3MlMjAyJTIy",highlighted:`<span class="hljs-comment"># Assume we have 2 servers with 4 processes each.</span>
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()


<span class="hljs-meta">@accelerator.on_local_process(<span class="hljs-params">local_process_index=<span class="hljs-number">2</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Printed on process <span class="hljs-subst">{accelerator.local_process_index}</span>&quot;</span>)


print_something()
<span class="hljs-comment"># On server 1:</span>
<span class="hljs-string">&quot;Printed on process 2&quot;</span>
<span class="hljs-comment"># On server 2:</span>
<span class="hljs-string">&quot;Printed on process 2&quot;</span>`,wrap:!1}}),{c(){s=c("p"),s.textContent=$,i=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),i=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,i,m),M(n,e,m),o=!0},p:V,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(i)),w(n,e)}}}function Ys(J){let s,$="Example:",i,n,o;return n=new A({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUuc3RhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBJTBBJTBBJTQwc3RhdGUub25fbWFpbl9wcm9jZXNzJTBBZGVmJTIwcHJpbnRfc29tZXRoaW5nKCklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJUaGlzJTIwd2lsbCUyMGJlJTIwcHJpbnRlZCUyMGJ5JTIwcHJvY2VzcyUyMDAlMjBvbmx5LiUyMiklMEElMEElMEFwcmludF9zb21ldGhpbmcoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

<span class="hljs-meta">&gt;&gt;&gt; </span>state = PartialState()


<span class="hljs-meta">&gt;&gt;&gt; </span>@state.on_main_process
<span class="hljs-meta">... </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;This will be printed by process 0 only.&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>print_something()
<span class="hljs-string">&quot;This will be printed by process 0 only&quot;</span>`,wrap:!1}}),{c(){s=c("p"),s.textContent=$,i=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),i=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,i,m),M(n,e,m),o=!0},p:V,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(i)),w(n,e)}}}function Vs(J){let s,$="Example:",i,n,o;return n=new A({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwNCUyMHByb2Nlc3Nlcy4lMEFmcm9tJTIwYWNjZWxlcmF0ZS5zdGF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQSUwQXN0YXRlJTIwJTNEJTIwUGFydGlhbFN0YXRlKCklMEElMEElMEElNDBzdGF0ZS5vbl9wcm9jZXNzKHByb2Nlc3NfaW5kZXglM0QyKSUwQWRlZiUyMHByaW50X3NvbWV0aGluZygpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlByaW50ZWQlMjBvbiUyMHByb2Nlc3MlMjAlN0JzdGF0ZS5wcm9jZXNzX2luZGV4JTdEJTIyKSUwQSUwQSUwQXByaW50X3NvbWV0aGluZygpJTBBJTIyUHJpbnRlZCUyMG9uJTIwcHJvY2VzcyUyMDIlMjI=",highlighted:`<span class="hljs-comment"># Assume we have 4 processes.</span>
<span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

state = PartialState()


<span class="hljs-meta">@state.on_process(<span class="hljs-params">process_index=<span class="hljs-number">2</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Printed on process <span class="hljs-subst">{state.process_index}</span>&quot;</span>)


print_something()
<span class="hljs-string">&quot;Printed on process 2&quot;</span>`,wrap:!1}}),{c(){s=c("p"),s.textContent=$,i=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),i=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,i,m),M(n,e,m),o=!0},p:V,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(i)),w(n,e)}}}function As(J){let s,$="Example:",i,n,o;return n=new A({props:{code:"JTIzJTIwQXNzdW1lJTIwdGhlcmUlMjBhcmUlMjB0d28lMjBwcm9jZXNzZXMlMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQSUwQXN0YXRlJTIwJTNEJTIwUGFydGlhbFN0YXRlKCklMEF3aXRoJTIwc3RhdGUuc3BsaXRfYmV0d2Vlbl9wcm9jZXNzZXMoJTVCJTIyQSUyMiUyQyUyMCUyMkIlMjIlMkMlMjAlMjJDJTIyJTVEKSUyMGFzJTIwaW5wdXRzJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoaW5wdXRzKSUwQSUyMyUyMFByb2Nlc3MlMjAwJTBBJTVCJTIyQSUyMiUyQyUyMCUyMkIlMjIlNUQlMEElMjMlMjBQcm9jZXNzJTIwMSUwQSU1QiUyMkMlMjIlNUQlMEElMEF3aXRoJTIwc3RhdGUuc3BsaXRfYmV0d2Vlbl9wcm9jZXNzZXMoJTVCJTIyQSUyMiUyQyUyMCUyMkIlMjIlMkMlMjAlMjJDJTIyJTVEJTJDJTIwYXBwbHlfcGFkZGluZyUzRFRydWUpJTIwYXMlMjBpbnB1dHMlM0ElMEElMjAlMjAlMjAlMjBwcmludChpbnB1dHMpJTBBJTIzJTIwUHJvY2VzcyUyMDAlMEElNUIlMjJBJTIyJTJDJTIwJTIyQiUyMiU1RCUwQSUyMyUyMFByb2Nlc3MlMjAxJTBBJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjIlNUQ=",highlighted:`<span class="hljs-comment"># Assume there are two processes</span>
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState

state = PartialState()
<span class="hljs-keyword">with</span> state.split_between_processes([<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>]) <span class="hljs-keyword">as</span> inputs:
    <span class="hljs-built_in">print</span>(inputs)
<span class="hljs-comment"># Process 0</span>
[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]
<span class="hljs-comment"># Process 1</span>
[<span class="hljs-string">&quot;C&quot;</span>]

<span class="hljs-keyword">with</span> state.split_between_processes([<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>], apply_padding=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> inputs:
    <span class="hljs-built_in">print</span>(inputs)
<span class="hljs-comment"># Process 0</span>
[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]
<span class="hljs-comment"># Process 1</span>
[<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>]`,wrap:!1}}),{c(){s=c("p"),s.textContent=$,i=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),i=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,i,m),M(n,e,m),o=!0},p:V,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(i)),w(n,e)}}}function Ds(J){let s,$="Example:",i,n,o;return n=new A({props:{code:"JTIzJTIwQXNzdW1pbmclMjB0d28lMjBHUFUlMjBwcm9jZXNzZXMlMEFpbXBvcnQlMjB0aW1lJTBBZnJvbSUyMGFjY2VsZXJhdGUuc3RhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBaWYlMjBzdGF0ZS5pc19tYWluX3Byb2Nlc3MlM0ElMEElMjAlMjAlMjAlMjB0aW1lLnNsZWVwKDIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkknbSUyMHdhaXRpbmclMjBmb3IlMjB0aGUlMjBtYWluJTIwcHJvY2VzcyUyMHRvJTIwZmluaXNoJTIwaXRzJTIwc2xlZXAuLi4lMjIpJTBBc3RhdGUud2FpdF9mb3JfZXZlcnlvbmUoKSUwQSUyMyUyMFNob3VsZCUyMHByaW50JTIwb24lMjBldmVyeSUyMHByb2Nlc3MlMjBhdCUyMHRoZSUyMHNhbWUlMjB0aW1lJTBBcHJpbnQoJTIyRXZlcnlvbmUlMjBpcyUyMGhlcmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assuming two GPU processes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> time
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

<span class="hljs-meta">&gt;&gt;&gt; </span>state = PartialState()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> state.is_main_process:
<span class="hljs-meta">... </span>    time.sleep(<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;I&#x27;m waiting for the main process to finish its sleep...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>state.wait_for_everyone()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Should print on every process at the same time</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Everyone is here&quot;</span>)`,wrap:!1}}),{c(){s=c("p"),s.textContent=$,i=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),i=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,i,m),M(n,e,m),o=!0},p:V,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(i)),w(n,e)}}}function Ls(J){let s,$="Example:",i,n,o;return n=new A({props:{code:"JTIzJTIwQXNzdW1lJTIwdGhlcmUlMjBhcmUlMjB0d28lMjBwcm9jZXNzZXMlMEFmcm9tJTIwYWNjZWxlcmF0ZS5zdGF0ZSUyMGltcG9ydCUyMEFjY2VsZXJhdG9yU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMEFjY2VsZXJhdG9yU3RhdGUoKSUwQXdpdGglMjBzdGF0ZS5zcGxpdF9iZXR3ZWVuX3Byb2Nlc3NlcyglNUIlMjJBJTIyJTJDJTIwJTIyQiUyMiUyQyUyMCUyMkMlMjIlNUQpJTIwYXMlMjBpbnB1dHMlM0ElMEElMjAlMjAlMjAlMjBwcmludChpbnB1dHMpJTBBJTIzJTIwUHJvY2VzcyUyMDAlMEElNUIlMjJBJTIyJTJDJTIwJTIyQiUyMiU1RCUwQSUyMyUyMFByb2Nlc3MlMjAxJTBBJTVCJTIyQyUyMiU1RCUwQSUwQXdpdGglMjBzdGF0ZS5zcGxpdF9iZXR3ZWVuX3Byb2Nlc3NlcyglNUIlMjJBJTIyJTJDJTIwJTIyQiUyMiUyQyUyMCUyMkMlMjIlNUQlMkMlMjBhcHBseV9wYWRkaW5nJTNEVHJ1ZSklMjBhcyUyMGlucHV0cyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGlucHV0cyklMEElMjMlMjBQcm9jZXNzJTIwMCUwQSU1QiUyMkElMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTIzJTIwUHJvY2VzcyUyMDElMEElNUIlMjJDJTIyJTJDJTIwJTIyQyUyMiU1RA==",highlighted:`<span class="hljs-comment"># Assume there are two processes</span>
<span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> AcceleratorState

state = AcceleratorState()
<span class="hljs-keyword">with</span> state.split_between_processes([<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>]) <span class="hljs-keyword">as</span> inputs:
    <span class="hljs-built_in">print</span>(inputs)
<span class="hljs-comment"># Process 0</span>
[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]
<span class="hljs-comment"># Process 1</span>
[<span class="hljs-string">&quot;C&quot;</span>]

<span class="hljs-keyword">with</span> state.split_between_processes([<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>], apply_padding=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> inputs:
    <span class="hljs-built_in">print</span>(inputs)
<span class="hljs-comment"># Process 0</span>
[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]
<span class="hljs-comment"># Process 1</span>
[<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>]`,wrap:!1}}),{c(){s=c("p"),s.textContent=$,i=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=$),i=r(e),f(n.$$.fragment,e)},m(e,m){j(e,s,m),j(e,i,m),M(n,e,m),o=!0},p:V,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(i)),w(n,e)}}}function Ks(J){let s,$,i,n,o,e,m,os=`Below are variations of a <a href="https://en.wikipedia.org/wiki/Singleton_pattern" rel="nofollow">singleton class</a> in the sense that all
instances share the same state, which is initialized on the first instantiation.`,rt,ue,cs=`These classes are immutable and store information about certain configurations or
states.`,ot,_,ge,mt,Ce,ps=`Singleton class that has information about the current training environment and functions to help with process
control. Designed to be used when only process control and device execution states are needed. Does <em>not</em> need to
be initialized from <code>Accelerator</code>.`,ht,Ie,is="<strong>Available attributes:</strong>",ut,Se,ds=`<li><strong>device</strong> (<code>torch.device</code>) — The device to use.</li> <li><strong>distributed_type</strong> (<a href="/docs/accelerate/v0.28.0/en/package_reference/utilities#accelerate.DistributedType">DistributedType</a>) — The type of distributed environment currently
in use.</li> <li><strong>local_process_index</strong> (<code>int</code>) — The index of the current process on the current server.</li> <li><strong>mixed_precision</strong> (<code>str</code>) — Whether or not the current script will use mixed precision, and if so the type
of mixed precision being performed. (Choose from ‘no’,‘fp16’,‘bf16 or ‘fp8’).</li> <li><strong>num_processes</strong> (<code>int</code>) — The number of processes currently launched in parallel.</li> <li><strong>process_index</strong> (<code>int</code>) — The index of the current process.</li> <li><strong>is_last_process</strong> (<code>bool</code>) — Whether or not the current process is the last one.</li> <li><strong>is_main_process</strong> (<code>bool</code>) — Whether or not the current process is the main one.</li> <li><strong>is_local_main_process</strong> (<code>bool</code>) — Whether or not the current process is the main one on the local node.</li> <li><strong>debug</strong> (<code>bool</code>) — Whether or not the current script is being run in debug mode.</li>`,gt,S,fe,ft,Ee,ms="Lets the local main process go inside a with block.",Mt,Ge,hs="The other processes will enter the with block after the main process exits.",yt,se,bt,E,Me,wt,ke,us="Lets the main process go first inside a with block.",jt,Ze,gs="The other processes will enter the with block after the main process exits.",$t,ae,_t,W,ye,Ut,Ne,fs="Decorator that only runs the decorated function on the last process.",Jt,ne,vt,Q,be,Tt,Xe,Ms="Decorator that only runs the decorated function on the local main process.",xt,le,Bt,P,we,Ct,We,ys="Decorator that only runs the decorated function on the process with the given index on the current node.",It,re,St,z,je,Et,Qe,bs="Decorator that only runs the decorated function on the main process.",Gt,oe,kt,F,$e,Zt,Pe,ws="Decorator that only runs the decorated function on the process with the given index.",Nt,ce,Xt,G,_e,Wt,ze,js=`Splits <code>input</code> between <code>self.num_processes</code> quickly and can be then used on that process. Useful when doing
distributed inference, such as with different prompts.`,Qt,Fe,$s="Note that when using a <code>dict</code>, all keys need to have the same number of elements.",Pt,pe,zt,H,Ue,Ft,He,_s=`Will stop the execution of the current process until every other process has reached that point (so this does
nothing when the script is only run in one process). Useful to do before saving a model.`,Ht,ie,ct,v,Je,qt,qe,Us="Singleton class that has information about the current training environment.",Rt,Re,Js="<strong>Available attributes:</strong>",Yt,Ye,vs=`<li><strong>device</strong> (<code>torch.device</code>) — The device to use.</li> <li><strong>distributed_type</strong> (<a href="/docs/accelerate/v0.28.0/en/package_reference/utilities#accelerate.DistributedType">DistributedType</a>) — The type of distributed environment currently
in use.</li> <li><strong>initialized</strong> (<code>bool</code>) — Whether or not the <code>AcceleratorState</code> has been initialized from <code>Accelerator</code>.</li> <li><strong>local_process_index</strong> (<code>int</code>) — The index of the current process on the current server.</li> <li><strong>mixed_precision</strong> (<code>str</code>) — Whether or not the current script will use mixed precision, and if so the type
of mixed precision being performed. (Choose from ‘no’,‘fp16’,‘bf16 or ‘fp8’).</li> <li><strong>num_processes</strong> (<code>int</code>) — The number of processes currently launched in parallel.</li> <li><strong>process_index</strong> (<code>int</code>) — The index of the current process.</li> <li><strong>is_last_process</strong> (<code>bool</code>) — Whether or not the current process is the last one.</li> <li><strong>is_main_process</strong> (<code>bool</code>) — Whether or not the current process is the main one.</li> <li><strong>is_local_main_process</strong> (<code>bool</code>) — Whether or not the current process is the main one on the local node.</li> <li><strong>debug</strong> (<code>bool</code>) — Whether or not the current script is being run in debug mode.</li>`,Vt,q,ve,At,Ve,Ts="Lets the local main process go inside a with block.",Dt,Ae,xs="The other processes will enter the with block after the main process exits.",Lt,R,Te,Kt,De,Bs="Lets the main process go first inside a with block.",Ot,Le,Cs="The other processes will enter the with block after the main process exits.",es,k,xe,ts,Ke,Is=`Splits <code>input</code> between <code>self.num_processes</code> quickly and can be then used on that process. Useful when doing
distributed inference, such as with different prompts.`,ss,Oe,Ss="Note that when using a <code>dict</code>, all keys need to have the same number of elements.",as,de,pt,I,Be,ns,et,Es="Singleton class that has information related to gradient synchronization for gradient accumulation",ls,tt,Gs="<strong>Available attributes:</strong>",rs,st,ks=`<li><strong>end_of_dataloader</strong> (<code>bool</code>) — Whether we have reached the end the current dataloader</li> <li><strong>remainder</strong> (<code>int</code>) — The number of extra samples that were added from padding the dataloader</li> <li><strong>sync_gradients</strong> (<code>bool</code>) — Whether the gradients should be synced across all devices</li> <li><strong>active_dataloader</strong> (<code>Optional[DataLoader]</code>) — The dataloader that is currently being iterated over</li> <li><strong>dataloader_references</strong> (<code>List[Optional[DataLoader]]</code>) — A list of references to the dataloaders that are
being iterated over</li> <li><strong>num_steps</strong> (<code>int</code>) — The number of steps to accumulate over</li> <li><strong>adjust_scheduler</strong> (<code>bool</code>) — Whether the scheduler should be adjusted to account for the gradient
accumulation</li> <li><strong>sync_with_dataloader</strong> (<code>bool</code>) — Whether the gradients should be synced at the end of the dataloader
iteration and the number of total steps reset</li> <li><strong>is_xla_gradients_synced</strong> (<code>bool</code>) — Whether the XLA gradients have been synchronized. It is initialized
as false. Once gradients have been reduced before the optimizer step, this flag is set to true. Subsequently,
after each step, the flag is reset to false. FSDP will always synchronize the gradients, hence
is_xla_gradients_synced is always true.</li>`,it,lt,dt;return o=new Ps({props:{title:"Stateful Classes",local:"accelerate.PartialState",headingTag:"h1"}}),ge=new B({props:{name:"class accelerate.PartialState",anchor:"accelerate.PartialState",parameters:[{name:"cpu",val:": bool = False"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/accelerate/blob/v0.28.0/src/accelerate/state.py#L105"}}),fe=new B({props:{name:"local_main_process_first",anchor:"accelerate.PartialState.local_main_process_first",parameters:[],source:"https://github.com/huggingface/accelerate/blob/v0.28.0/src/accelerate/state.py#L534"}}),se=new Y({props:{anchor:"accelerate.PartialState.local_main_process_first.example",$$slots:{default:[zs]},$$scope:{ctx:J}}}),Me=new B({props:{name:"main_process_first",anchor:"accelerate.PartialState.main_process_first",parameters:[],source:"https://github.com/huggingface/accelerate/blob/v0.28.0/src/accelerate/state.py#L513"}}),ae=new Y({props:{anchor:"accelerate.PartialState.main_process_first.example",$$slots:{default:[Fs]},$$scope:{ctx:J}}}),ye=new B({props:{name:"on_last_process",anchor:"accelerate.PartialState.on_last_process",parameters:[{name:"function",val:": Callable[..., Any]"}],parametersDescription:[{anchor:"accelerate.PartialState.on_last_process.function",description:"<strong>function</strong> (<code>Callable</code>) &#x2014; The function to decorate.",name:"function"}],source:"https://github.com/huggingface/accelerate/blob/v0.28.0/src/accelerate/state.py#L616"}}),ne=new Y({props:{anchor:"accelerate.PartialState.on_last_process.example",$$slots:{default:[Hs]},$$scope:{ctx:J}}}),be=new B({props:{name:"on_local_main_process",anchor:"accelerate.PartialState.on_local_main_process",parameters:[{name:"function",val:": Callable[..., Any] = None"}],parametersDescription:[{anchor:"accelerate.PartialState.on_local_main_process.function",description:"<strong>function</strong> (<code>Callable</code>) &#x2014; The function to decorate.",name:"function"}],source:"https://github.com/huggingface/accelerate/blob/v0.28.0/src/accelerate/state.py#L585"}}),le=new Y({props:{anchor:"accelerate.PartialState.on_local_main_process.example",$$slots:{default:[qs]},$$scope:{ctx:J}}}),we=new B({props:{name:"on_local_process",anchor:"accelerate.PartialState.on_local_process",parameters:[{name:"function",val:": Callable[..., Any] = None"},{name:"local_process_index",val:": int = None"}],parametersDescription:[{anchor:"accelerate.PartialState.on_local_process.function",description:`<strong>function</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
The function to decorate.`,name:"function"},{anchor:"accelerate.PartialState.on_local_process.local_process_index",description:`<strong>local_process_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the local process on which to run the function.`,name:"local_process_index"}],source:"https://github.com/huggingface/accelerate/blob/v0.28.0/src/accelerate/state.py#L677"}}),re=new Y({props:{anchor:"accelerate.PartialState.on_local_process.example",$$slots:{default:[Rs]},$$scope:{ctx:J}}}),je=new B({props:{name:"on_main_process",anchor:"accelerate.PartialState.on_main_process",parameters:[{name:"function",val:": Callable[..., Any] = None"}],parametersDescription:[{anchor:"accelerate.PartialState.on_main_process.function",description:"<strong>function</strong> (<code>Callable</code>) &#x2014; The function to decorate.",name:"function"}],source:"https://github.com/huggingface/accelerate/blob/v0.28.0/src/accelerate/state.py#L555"}}),oe=new Y({props:{anchor:"accelerate.PartialState.on_main_process.example",$$slots:{default:[Ys]},$$scope:{ctx:J}}}),$e=new B({props:{name:"on_process",anchor:"accelerate.PartialState.on_process",parameters:[{name:"function",val:": Callable[..., Any] = None"},{name:"process_index",val:": int = None"}],parametersDescription:[{anchor:"accelerate.PartialState.on_process.function",description:`<strong>function</strong> (<code>Callable</code>, <code>optional</code>) &#x2014;
The function to decorate.`,name:"function"},{anchor:"accelerate.PartialState.on_process.process_index",description:`<strong>process_index</strong> (<code>int</code>, <code>optional</code>) &#x2014;
The index of the process on which to run the function.`,name:"process_index"}],source:"https://github.com/huggingface/accelerate/blob/v0.28.0/src/accelerate/state.py#L644"}}),ce=new Y({props:{anchor:"accelerate.PartialState.on_process.example",$$slots:{default:[Vs]},$$scope:{ctx:J}}}),_e=new B({props:{name:"split_between_processes",anchor:"accelerate.PartialState.split_between_processes",parameters:[{name:"inputs",val:": list | tuple | dict | torch.Tensor"},{name:"apply_padding",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.PartialState.split_between_processes.inputs",description:`<strong>inputs</strong> (<code>list</code>, <code>tuple</code>, <code>torch.Tensor</code>, or <code>dict</code> of <code>list</code>/<code>tuple</code>/<code>torch.Tensor</code>) &#x2014;
The input to split between processes.`,name:"inputs"},{anchor:"accelerate.PartialState.split_between_processes.apply_padding",description:`<strong>apply_padding</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>False</code>) &#x2014;
Whether to apply padding by repeating the last element of the input so that all processes have the same
number of elements. Useful when trying to perform actions such as <code>gather()</code> on the outputs or passing
in less inputs than there are processes. If so, just remember to drop the padded elements afterwards.`,name:"apply_padding"}],source:"https://github.com/huggingface/accelerate/blob/v0.28.0/src/accelerate/state.py#L434"}}),pe=new Y({props:{anchor:"accelerate.PartialState.split_between_processes.example",$$slots:{default:[As]},$$scope:{ctx:J}}}),Ue=new B({props:{name:"wait_for_everyone",anchor:"accelerate.PartialState.wait_for_everyone",parameters:[],source:"https://github.com/huggingface/accelerate/blob/v0.28.0/src/accelerate/state.py#L391"}}),ie=new Y({props:{anchor:"accelerate.PartialState.wait_for_everyone.example",$$slots:{default:[Ds]},$$scope:{ctx:J}}}),Je=new B({props:{name:"class accelerate.state.AcceleratorState",anchor:"accelerate.state.AcceleratorState",parameters:[{name:"mixed_precision",val:": str = None"},{name:"cpu",val:": bool = False"},{name:"dynamo_plugin",val:" = None"},{name:"deepspeed_plugin",val:" = None"},{name:"fsdp_plugin",val:" = None"},{name:"megatron_lm_plugin",val:" = None"},{name:"_from_accelerator",val:": bool = False"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/accelerate/blob/v0.28.0/src/accelerate/state.py#L739"}}),ve=new B({props:{name:"local_main_process_first",anchor:"accelerate.state.AcceleratorState.local_main_process_first",parameters:[],source:"https://github.com/huggingface/accelerate/blob/v0.28.0/src/accelerate/state.py#L988"}}),Te=new B({props:{name:"main_process_first",anchor:"accelerate.state.AcceleratorState.main_process_first",parameters:[],source:"https://github.com/huggingface/accelerate/blob/v0.28.0/src/accelerate/state.py#L978"}}),xe=new B({props:{name:"split_between_processes",anchor:"accelerate.state.AcceleratorState.split_between_processes",parameters:[{name:"inputs",val:": list | tuple | dict | torch.Tensor"},{name:"apply_padding",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.state.AcceleratorState.split_between_processes.inputs",description:`<strong>inputs</strong> (<code>list</code>, <code>tuple</code>, <code>torch.Tensor</code>, or <code>dict</code> of <code>list</code>/<code>tuple</code>/<code>torch.Tensor</code>) &#x2014;
The input to split between processes.`,name:"inputs"},{anchor:"accelerate.state.AcceleratorState.split_between_processes.apply_padding",description:`<strong>apply_padding</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>False</code>) &#x2014;
Whether to apply padding by repeating the last element of the input so that all processes have the same
number of elements. Useful when trying to perform actions such as <code>gather()</code> on the outputs or passing
in less inputs than there are processes. If so, just remember to drop the padded elements afterwards.`,name:"apply_padding"}],source:"https://github.com/huggingface/accelerate/blob/v0.28.0/src/accelerate/state.py#L936"}}),de=new Y({props:{anchor:"accelerate.state.AcceleratorState.split_between_processes.example",$$slots:{default:[Ls]},$$scope:{ctx:J}}}),Be=new B({props:{name:"class accelerate.state.GradientState",anchor:"accelerate.state.GradientState",parameters:[{name:"gradient_accumulation_plugin",val:": Optional[GradientAccumulationPlugin] = None"}],source:"https://github.com/huggingface/accelerate/blob/v0.28.0/src/accelerate/state.py#L1002"}}),{c(){s=c("meta"),$=l(),i=c("p"),n=l(),g(o.$$.fragment),e=l(),m=c("p"),m.innerHTML=os,rt=l(),ue=c("p"),ue.textContent=cs,ot=l(),_=c("div"),g(ge.$$.fragment),mt=l(),Ce=c("p"),Ce.innerHTML=ps,ht=l(),Ie=c("p"),Ie.innerHTML=is,ut=l(),Se=c("ul"),Se.innerHTML=ds,gt=l(),S=c("div"),g(fe.$$.fragment),ft=l(),Ee=c("p"),Ee.textContent=ms,Mt=l(),Ge=c("p"),Ge.textContent=hs,yt=l(),g(se.$$.fragment),bt=l(),E=c("div"),g(Me.$$.fragment),wt=l(),ke=c("p"),ke.textContent=us,jt=l(),Ze=c("p"),Ze.textContent=gs,$t=l(),g(ae.$$.fragment),_t=l(),W=c("div"),g(ye.$$.fragment),Ut=l(),Ne=c("p"),Ne.textContent=fs,Jt=l(),g(ne.$$.fragment),vt=l(),Q=c("div"),g(be.$$.fragment),Tt=l(),Xe=c("p"),Xe.textContent=Ms,xt=l(),g(le.$$.fragment),Bt=l(),P=c("div"),g(we.$$.fragment),Ct=l(),We=c("p"),We.textContent=ys,It=l(),g(re.$$.fragment),St=l(),z=c("div"),g(je.$$.fragment),Et=l(),Qe=c("p"),Qe.textContent=bs,Gt=l(),g(oe.$$.fragment),kt=l(),F=c("div"),g($e.$$.fragment),Zt=l(),Pe=c("p"),Pe.textContent=ws,Nt=l(),g(ce.$$.fragment),Xt=l(),G=c("div"),g(_e.$$.fragment),Wt=l(),ze=c("p"),ze.innerHTML=js,Qt=l(),Fe=c("p"),Fe.innerHTML=$s,Pt=l(),g(pe.$$.fragment),zt=l(),H=c("div"),g(Ue.$$.fragment),Ft=l(),He=c("p"),He.textContent=_s,Ht=l(),g(ie.$$.fragment),ct=l(),v=c("div"),g(Je.$$.fragment),qt=l(),qe=c("p"),qe.textContent=Us,Rt=l(),Re=c("p"),Re.innerHTML=Js,Yt=l(),Ye=c("ul"),Ye.innerHTML=vs,Vt=l(),q=c("div"),g(ve.$$.fragment),At=l(),Ve=c("p"),Ve.textContent=Ts,Dt=l(),Ae=c("p"),Ae.textContent=xs,Lt=l(),R=c("div"),g(Te.$$.fragment),Kt=l(),De=c("p"),De.textContent=Bs,Ot=l(),Le=c("p"),Le.textContent=Cs,es=l(),k=c("div"),g(xe.$$.fragment),ts=l(),Ke=c("p"),Ke.innerHTML=Is,ss=l(),Oe=c("p"),Oe.innerHTML=Ss,as=l(),g(de.$$.fragment),pt=l(),I=c("div"),g(Be.$$.fragment),ns=l(),et=c("p"),et.textContent=Es,ls=l(),tt=c("p"),tt.innerHTML=Gs,rs=l(),st=c("ul"),st.innerHTML=ks,it=l(),lt=c("p"),this.h()},l(t){const h=Qs("svelte-u9bgzb",document.head);s=p(h,"META",{name:!0,content:!0}),h.forEach(d),$=r(t),i=p(t,"P",{}),T(i).forEach(d),n=r(t),f(o.$$.fragment,t),e=r(t),m=p(t,"P",{"data-svelte-h":!0}),u(m)!=="svelte-6w5h2d"&&(m.innerHTML=os),rt=r(t),ue=p(t,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-n5bwiq"&&(ue.textContent=cs),ot=r(t),_=p(t,"DIV",{class:!0});var U=T(_);f(ge.$$.fragment,U),mt=r(U),Ce=p(U,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-b0lfuj"&&(Ce.innerHTML=ps),ht=r(U),Ie=p(U,"P",{"data-svelte-h":!0}),u(Ie)!=="svelte-17v1xbv"&&(Ie.innerHTML=is),ut=r(U),Se=p(U,"UL",{"data-svelte-h":!0}),u(Se)!=="svelte-mu8yn4"&&(Se.innerHTML=ds),gt=r(U),S=p(U,"DIV",{class:!0});var Z=T(S);f(fe.$$.fragment,Z),ft=r(Z),Ee=p(Z,"P",{"data-svelte-h":!0}),u(Ee)!=="svelte-1xrqyx2"&&(Ee.textContent=ms),Mt=r(Z),Ge=p(Z,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-144ycie"&&(Ge.textContent=hs),yt=r(Z),f(se.$$.fragment,Z),Z.forEach(d),bt=r(U),E=p(U,"DIV",{class:!0});var N=T(E);f(Me.$$.fragment,N),wt=r(N),ke=p(N,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-f40x3x"&&(ke.textContent=us),jt=r(N),Ze=p(N,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-144ycie"&&(Ze.textContent=gs),$t=r(N),f(ae.$$.fragment,N),N.forEach(d),_t=r(U),W=p(U,"DIV",{class:!0});var D=T(W);f(ye.$$.fragment,D),Ut=r(D),Ne=p(D,"P",{"data-svelte-h":!0}),u(Ne)!=="svelte-15mu2x9"&&(Ne.textContent=fs),Jt=r(D),f(ne.$$.fragment,D),D.forEach(d),vt=r(U),Q=p(U,"DIV",{class:!0});var L=T(Q);f(be.$$.fragment,L),Tt=r(L),Xe=p(L,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-10pbn0p"&&(Xe.textContent=Ms),xt=r(L),f(le.$$.fragment,L),L.forEach(d),Bt=r(U),P=p(U,"DIV",{class:!0});var K=T(P);f(we.$$.fragment,K),Ct=r(K),We=p(K,"P",{"data-svelte-h":!0}),u(We)!=="svelte-3g0as"&&(We.textContent=ys),It=r(K),f(re.$$.fragment,K),K.forEach(d),St=r(U),z=p(U,"DIV",{class:!0});var O=T(z);f(je.$$.fragment,O),Et=r(O),Qe=p(O,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-1dr4vmg"&&(Qe.textContent=bs),Gt=r(O),f(oe.$$.fragment,O),O.forEach(d),kt=r(U),F=p(U,"DIV",{class:!0});var ee=T(F);f($e.$$.fragment,ee),Zt=r(ee),Pe=p(ee,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-1uajfn5"&&(Pe.textContent=ws),Nt=r(ee),f(ce.$$.fragment,ee),ee.forEach(d),Xt=r(U),G=p(U,"DIV",{class:!0});var X=T(G);f(_e.$$.fragment,X),Wt=r(X),ze=p(X,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-xr05jy"&&(ze.innerHTML=js),Qt=r(X),Fe=p(X,"P",{"data-svelte-h":!0}),u(Fe)!=="svelte-hvuw2l"&&(Fe.innerHTML=$s),Pt=r(X),f(pe.$$.fragment,X),X.forEach(d),zt=r(U),H=p(U,"DIV",{class:!0});var te=T(H);f(Ue.$$.fragment,te),Ft=r(te),He=p(te,"P",{"data-svelte-h":!0}),u(He)!=="svelte-tmafbn"&&(He.textContent=_s),Ht=r(te),f(ie.$$.fragment,te),te.forEach(d),U.forEach(d),ct=r(t),v=p(t,"DIV",{class:!0});var C=T(v);f(Je.$$.fragment,C),qt=r(C),qe=p(C,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-x2ar5c"&&(qe.textContent=Us),Rt=r(C),Re=p(C,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-17v1xbv"&&(Re.innerHTML=Js),Yt=r(C),Ye=p(C,"UL",{"data-svelte-h":!0}),u(Ye)!=="svelte-1x9032p"&&(Ye.innerHTML=vs),Vt=r(C),q=p(C,"DIV",{class:!0});var at=T(q);f(ve.$$.fragment,at),At=r(at),Ve=p(at,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-1xrqyx2"&&(Ve.textContent=Ts),Dt=r(at),Ae=p(at,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-144ycie"&&(Ae.textContent=xs),at.forEach(d),Lt=r(C),R=p(C,"DIV",{class:!0});var nt=T(R);f(Te.$$.fragment,nt),Kt=r(nt),De=p(nt,"P",{"data-svelte-h":!0}),u(De)!=="svelte-f40x3x"&&(De.textContent=Bs),Ot=r(nt),Le=p(nt,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-144ycie"&&(Le.textContent=Cs),nt.forEach(d),es=r(C),k=p(C,"DIV",{class:!0});var me=T(k);f(xe.$$.fragment,me),ts=r(me),Ke=p(me,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-xr05jy"&&(Ke.innerHTML=Is),ss=r(me),Oe=p(me,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-hvuw2l"&&(Oe.innerHTML=Ss),as=r(me),f(de.$$.fragment,me),me.forEach(d),C.forEach(d),pt=r(t),I=p(t,"DIV",{class:!0});var he=T(I);f(Be.$$.fragment,he),ns=r(he),et=p(he,"P",{"data-svelte-h":!0}),u(et)!=="svelte-1pw2ldw"&&(et.textContent=Es),ls=r(he),tt=p(he,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-17v1xbv"&&(tt.innerHTML=Gs),rs=r(he),st=p(he,"UL",{"data-svelte-h":!0}),u(st)!=="svelte-kdkw1r"&&(st.innerHTML=ks),he.forEach(d),it=r(t),lt=p(t,"P",{}),T(lt).forEach(d),this.h()},h(){x(s,"name","hf:doc:metadata"),x(s,"content",Os),x(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,h){a(document.head,s),j(t,$,h),j(t,i,h),j(t,n,h),M(o,t,h),j(t,e,h),j(t,m,h),j(t,rt,h),j(t,ue,h),j(t,ot,h),j(t,_,h),M(ge,_,null),a(_,mt),a(_,Ce),a(_,ht),a(_,Ie),a(_,ut),a(_,Se),a(_,gt),a(_,S),M(fe,S,null),a(S,ft),a(S,Ee),a(S,Mt),a(S,Ge),a(S,yt),M(se,S,null),a(_,bt),a(_,E),M(Me,E,null),a(E,wt),a(E,ke),a(E,jt),a(E,Ze),a(E,$t),M(ae,E,null),a(_,_t),a(_,W),M(ye,W,null),a(W,Ut),a(W,Ne),a(W,Jt),M(ne,W,null),a(_,vt),a(_,Q),M(be,Q,null),a(Q,Tt),a(Q,Xe),a(Q,xt),M(le,Q,null),a(_,Bt),a(_,P),M(we,P,null),a(P,Ct),a(P,We),a(P,It),M(re,P,null),a(_,St),a(_,z),M(je,z,null),a(z,Et),a(z,Qe),a(z,Gt),M(oe,z,null),a(_,kt),a(_,F),M($e,F,null),a(F,Zt),a(F,Pe),a(F,Nt),M(ce,F,null),a(_,Xt),a(_,G),M(_e,G,null),a(G,Wt),a(G,ze),a(G,Qt),a(G,Fe),a(G,Pt),M(pe,G,null),a(_,zt),a(_,H),M(Ue,H,null),a(H,Ft),a(H,He),a(H,Ht),M(ie,H,null),j(t,ct,h),j(t,v,h),M(Je,v,null),a(v,qt),a(v,qe),a(v,Rt),a(v,Re),a(v,Yt),a(v,Ye),a(v,Vt),a(v,q),M(ve,q,null),a(q,At),a(q,Ve),a(q,Dt),a(q,Ae),a(v,Lt),a(v,R),M(Te,R,null),a(R,Kt),a(R,De),a(R,Ot),a(R,Le),a(v,es),a(v,k),M(xe,k,null),a(k,ts),a(k,Ke),a(k,ss),a(k,Oe),a(k,as),M(de,k,null),j(t,pt,h),j(t,I,h),M(Be,I,null),a(I,ns),a(I,et),a(I,ls),a(I,tt),a(I,rs),a(I,st),j(t,it,h),j(t,lt,h),dt=!0},p(t,[h]){const U={};h&2&&(U.$$scope={dirty:h,ctx:t}),se.$set(U);const Z={};h&2&&(Z.$$scope={dirty:h,ctx:t}),ae.$set(Z);const N={};h&2&&(N.$$scope={dirty:h,ctx:t}),ne.$set(N);const D={};h&2&&(D.$$scope={dirty:h,ctx:t}),le.$set(D);const L={};h&2&&(L.$$scope={dirty:h,ctx:t}),re.$set(L);const K={};h&2&&(K.$$scope={dirty:h,ctx:t}),oe.$set(K);const O={};h&2&&(O.$$scope={dirty:h,ctx:t}),ce.$set(O);const ee={};h&2&&(ee.$$scope={dirty:h,ctx:t}),pe.$set(ee);const X={};h&2&&(X.$$scope={dirty:h,ctx:t}),ie.$set(X);const te={};h&2&&(te.$$scope={dirty:h,ctx:t}),de.$set(te)},i(t){dt||(y(o.$$.fragment,t),y(ge.$$.fragment,t),y(fe.$$.fragment,t),y(se.$$.fragment,t),y(Me.$$.fragment,t),y(ae.$$.fragment,t),y(ye.$$.fragment,t),y(ne.$$.fragment,t),y(be.$$.fragment,t),y(le.$$.fragment,t),y(we.$$.fragment,t),y(re.$$.fragment,t),y(je.$$.fragment,t),y(oe.$$.fragment,t),y($e.$$.fragment,t),y(ce.$$.fragment,t),y(_e.$$.fragment,t),y(pe.$$.fragment,t),y(Ue.$$.fragment,t),y(ie.$$.fragment,t),y(Je.$$.fragment,t),y(ve.$$.fragment,t),y(Te.$$.fragment,t),y(xe.$$.fragment,t),y(de.$$.fragment,t),y(Be.$$.fragment,t),dt=!0)},o(t){b(o.$$.fragment,t),b(ge.$$.fragment,t),b(fe.$$.fragment,t),b(se.$$.fragment,t),b(Me.$$.fragment,t),b(ae.$$.fragment,t),b(ye.$$.fragment,t),b(ne.$$.fragment,t),b(be.$$.fragment,t),b(le.$$.fragment,t),b(we.$$.fragment,t),b(re.$$.fragment,t),b(je.$$.fragment,t),b(oe.$$.fragment,t),b($e.$$.fragment,t),b(ce.$$.fragment,t),b(_e.$$.fragment,t),b(pe.$$.fragment,t),b(Ue.$$.fragment,t),b(ie.$$.fragment,t),b(Je.$$.fragment,t),b(ve.$$.fragment,t),b(Te.$$.fragment,t),b(xe.$$.fragment,t),b(de.$$.fragment,t),b(Be.$$.fragment,t),dt=!1},d(t){t&&(d($),d(i),d(n),d(e),d(m),d(rt),d(ue),d(ot),d(_),d(ct),d(v),d(pt),d(I),d(it),d(lt)),d(s),w(o,t),w(ge),w(fe),w(se),w(Me),w(ae),w(ye),w(ne),w(be),w(le),w(we),w(re),w(je),w(oe),w($e),w(ce),w(_e),w(pe),w(Ue),w(ie),w(Je),w(ve),w(Te),w(xe),w(de),w(Be)}}}const Os='{"title":"Stateful Classes","local":"accelerate.PartialState","sections":[],"depth":1}';function ea(J){return Ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oa extends Xs{constructor(s){super(),Ws(this,s,ea,Ks,Zs,{})}}export{oa as component};
