import{s as st,n as ot,o as it}from"../chunks/scheduler.85c25b89.js";import{S as rt,i as ht,g as a,s as o,u as d,A as pt,h as s,f as t,c as i,j as p,v as u,y as m,k as r,o as h,a as n,w as c,d as f,t as g,x as v}from"../chunks/index.9633332f.js";import{I as Le}from"../chunks/IconCopyLink.a4acffac.js";import{C as q}from"../chunks/CodeBlock.00597c71.js";function mt(Ee){let b,ae,K,se,$,y,O,j,Ze,Q,Ge="Sharing and Loading Models From the Hugging Face Hub",oe,C,Ae="The <code>timm</code> library has a built-in integration with the Hugging Face Hub, making it easy to share and load models from the 🤗 Hub.",ie,T,Ne="In this short guide, we’ll see how to:",re,J,Ve="<li>Share a <code>timm</code> model on the Hub</li> <li>How to load that model back from the Hub</li>",he,w,M,ee,L,Se,X,Ye="Authenticating",pe,Z,Ie="First, you’ll need to make sure you have the <code>huggingface_hub</code> package installed.",me,S,de,P,Fe="Then, you’ll need to authenticate yourself. You can do this by running the following command:",ue,W,ce,E,Ue="Or, if you’re using a notebook, you can use the <code>notebook_login</code> helper:",fe,G,ge,_,k,te,A,Pe,z,Re="Sharing a Model",ve,N,be,V,Be="Here is where you would normally train or fine-tune the model. We’ll skip that for the sake of this tutorial.",$e,Y,Qe="Let’s pretend we’ve now fine-tuned the model. The next step would be to push it to the Hub! We can do this with the <code>timm.models.hub.push_to_hf_hub</code> function.",we,I,_e,F,Xe="Running the above would push the model to <code>&lt;your-username&gt;/resnet18-random</code> on the Hub. You can now share this model with your friends, or use it in your own code!",xe,x,H,le,U,We,D,ze="Loading a Model",ye,R,De='Loading a model from the Hub is as simple as calling <code>timm.create_model</code> with the <code>pretrained</code> argument set to the name of the model you want to load. In this case, we’ll use <a href="https://huggingface.co/nateraw/resnet18-random" rel="nofollow"><code>nateraw/resnet18-random</code></a>, which is the model we just pushed to the Hub.',Me,B,ke,ne,He;return j=new Le({}),L=new Le({}),S=new q({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1Yg==",highlighted:"pip install huggingface_hub"}}),W=new q({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login"}}),G=new q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login
<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`}}),A=new Le({}),N=new q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldDE4JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0Q0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">4</span>)`}}),I=new q({props:{code:"bW9kZWxfY2ZnJTIwJTNEJTIwZGljdChsYWJlbHMlM0QlNUInYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclNUQpJTBBdGltbS5tb2RlbHMuaHViLnB1c2hfdG9faGZfaHViKG1vZGVsJTJDJTIwJ3Jlc25ldDE4LXJhbmRvbSclMkMlMjBtb2RlbF9jb25maWclM0Rtb2RlbF9jZmcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model_cfg = <span class="hljs-built_in">dict</span>(labels=[<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>timm.models.hub.push_to_hf_hub(model, <span class="hljs-string">&#x27;resnet18-random&#x27;</span>, model_config=model_cfg)`}}),U=new Le({}),B=new q({props:{code:"bW9kZWxfcmVsb2FkZWQlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaGZfaHViJTNBbmF0ZXJhdyUyRnJlc25ldDE4LXJhbmRvbSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model_reloaded = timm.create_model(<span class="hljs-string">&#x27;hf_hub:nateraw/resnet18-random&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)'}}),{c(){b=a("meta"),ae=o(),K=a("p"),se=o(),$=a("h1"),y=a("a"),O=a("span"),d(j.$$.fragment),Ze=o(),Q=a("span"),Q.textContent=Ge,oe=o(),C=a("p"),C.innerHTML=Ae,ie=o(),T=a("p"),T.textContent=Ne,re=o(),J=a("ol"),J.innerHTML=Ve,he=o(),w=a("h2"),M=a("a"),ee=a("span"),d(L.$$.fragment),Se=o(),X=a("span"),X.textContent=Ye,pe=o(),Z=a("p"),Z.innerHTML=Ie,me=o(),d(S.$$.fragment),de=o(),P=a("p"),P.textContent=Fe,ue=o(),d(W.$$.fragment),ce=o(),E=a("p"),E.innerHTML=Ue,fe=o(),d(G.$$.fragment),ge=o(),_=a("h2"),k=a("a"),te=a("span"),d(A.$$.fragment),Pe=o(),z=a("span"),z.textContent=Re,ve=o(),d(N.$$.fragment),be=o(),V=a("p"),V.textContent=Be,$e=o(),Y=a("p"),Y.innerHTML=Qe,we=o(),d(I.$$.fragment),_e=o(),F=a("p"),F.innerHTML=Xe,xe=o(),x=a("h2"),H=a("a"),le=a("span"),d(U.$$.fragment),We=o(),D=a("span"),D.textContent=ze,ye=o(),R=a("p"),R.innerHTML=De,Me=o(),d(B.$$.fragment),ke=o(),ne=a("p"),this.h()},l(e){const l=pt("svelte-1phssyn",document.head);b=s(l,"META",{name:!0,content:!0}),l.forEach(t),ae=i(e),K=s(e,"P",{}),p(K).forEach(t),se=i(e),$=s(e,"H1",{class:!0});var je=p($);y=s(je,"A",{id:!0,class:!0,href:!0});var qe=p(y);O=s(qe,"SPAN",{});var Ke=p(O);u(j.$$.fragment,Ke),Ke.forEach(t),qe.forEach(t),Ze=i(je),Q=s(je,"SPAN",{"data-svelte-h":!0}),m(Q)!=="svelte-1obwpd8"&&(Q.textContent=Ge),je.forEach(t),oe=i(e),C=s(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1lmv8hz"&&(C.innerHTML=Ae),ie=i(e),T=s(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-11r33nm"&&(T.textContent=Ne),re=i(e),J=s(e,"OL",{"data-svelte-h":!0}),m(J)!=="svelte-1t5ulh6"&&(J.innerHTML=Ve),he=i(e),w=s(e,"H2",{class:!0});var Ce=p(w);M=s(Ce,"A",{id:!0,class:!0,href:!0});var Oe=p(M);ee=s(Oe,"SPAN",{});var et=p(ee);u(L.$$.fragment,et),et.forEach(t),Oe.forEach(t),Se=i(Ce),X=s(Ce,"SPAN",{"data-svelte-h":!0}),m(X)!=="svelte-yvfklr"&&(X.textContent=Ye),Ce.forEach(t),pe=i(e),Z=s(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-18o00ln"&&(Z.innerHTML=Ie),me=i(e),u(S.$$.fragment,e),de=i(e),P=s(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1dqusp5"&&(P.textContent=Fe),ue=i(e),u(W.$$.fragment,e),ce=i(e),E=s(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-yj2stu"&&(E.innerHTML=Ue),fe=i(e),u(G.$$.fragment,e),ge=i(e),_=s(e,"H2",{class:!0});var Te=p(_);k=s(Te,"A",{id:!0,class:!0,href:!0});var tt=p(k);te=s(tt,"SPAN",{});var lt=p(te);u(A.$$.fragment,lt),lt.forEach(t),tt.forEach(t),Pe=i(Te),z=s(Te,"SPAN",{"data-svelte-h":!0}),m(z)!=="svelte-scut6l"&&(z.textContent=Re),Te.forEach(t),ve=i(e),u(N.$$.fragment,e),be=i(e),V=s(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1d50rfn"&&(V.textContent=Be),$e=i(e),Y=s(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-jqz7ws"&&(Y.innerHTML=Qe),we=i(e),u(I.$$.fragment,e),_e=i(e),F=s(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-jnvz89"&&(F.innerHTML=Xe),xe=i(e),x=s(e,"H2",{class:!0});var Je=p(x);H=s(Je,"A",{id:!0,class:!0,href:!0});var nt=p(H);le=s(nt,"SPAN",{});var at=p(le);u(U.$$.fragment,at),at.forEach(t),nt.forEach(t),We=i(Je),D=s(Je,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-n6i0wt"&&(D.textContent=ze),Je.forEach(t),ye=i(e),R=s(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-kug5in"&&(R.innerHTML=De),Me=i(e),u(B.$$.fragment,e),ke=i(e),ne=s(e,"P",{}),p(ne).forEach(t),this.h()},h(){r(b,"name","hf:doc:metadata"),r(b,"content",JSON.stringify(dt)),r(y,"id","sharing-and-loading-models-from-the-hugging-face-hub"),r(y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(y,"href","#sharing-and-loading-models-from-the-hugging-face-hub"),r($,"class","relative group"),r(M,"id","authenticating"),r(M,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(M,"href","#authenticating"),r(w,"class","relative group"),r(k,"id","sharing-a-model"),r(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(k,"href","#sharing-a-model"),r(_,"class","relative group"),r(H,"id","loading-a-model"),r(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(H,"href","#loading-a-model"),r(x,"class","relative group")},m(e,l){h(document.head,b),n(e,ae,l),n(e,K,l),n(e,se,l),n(e,$,l),h($,y),h(y,O),c(j,O,null),h($,Ze),h($,Q),n(e,oe,l),n(e,C,l),n(e,ie,l),n(e,T,l),n(e,re,l),n(e,J,l),n(e,he,l),n(e,w,l),h(w,M),h(M,ee),c(L,ee,null),h(w,Se),h(w,X),n(e,pe,l),n(e,Z,l),n(e,me,l),c(S,e,l),n(e,de,l),n(e,P,l),n(e,ue,l),c(W,e,l),n(e,ce,l),n(e,E,l),n(e,fe,l),c(G,e,l),n(e,ge,l),n(e,_,l),h(_,k),h(k,te),c(A,te,null),h(_,Pe),h(_,z),n(e,ve,l),c(N,e,l),n(e,be,l),n(e,V,l),n(e,$e,l),n(e,Y,l),n(e,we,l),c(I,e,l),n(e,_e,l),n(e,F,l),n(e,xe,l),n(e,x,l),h(x,H),h(H,le),c(U,le,null),h(x,We),h(x,D),n(e,ye,l),n(e,R,l),n(e,Me,l),c(B,e,l),n(e,ke,l),n(e,ne,l),He=!0},p:ot,i(e){He||(f(j.$$.fragment,e),f(L.$$.fragment,e),f(S.$$.fragment,e),f(W.$$.fragment,e),f(G.$$.fragment,e),f(A.$$.fragment,e),f(N.$$.fragment,e),f(I.$$.fragment,e),f(U.$$.fragment,e),f(B.$$.fragment,e),He=!0)},o(e){g(j.$$.fragment,e),g(L.$$.fragment,e),g(S.$$.fragment,e),g(W.$$.fragment,e),g(G.$$.fragment,e),g(A.$$.fragment,e),g(N.$$.fragment,e),g(I.$$.fragment,e),g(U.$$.fragment,e),g(B.$$.fragment,e),He=!1},d(e){e&&(t(ae),t(K),t(se),t($),t(oe),t(C),t(ie),t(T),t(re),t(J),t(he),t(w),t(pe),t(Z),t(me),t(de),t(P),t(ue),t(ce),t(E),t(fe),t(ge),t(_),t(ve),t(be),t(V),t($e),t(Y),t(we),t(_e),t(F),t(xe),t(x),t(ye),t(R),t(Me),t(ke),t(ne)),t(b),v(j),v(L),v(S,e),v(W,e),v(G,e),v(A),v(N,e),v(I,e),v(U),v(B,e)}}}const dt={local:"sharing-and-loading-models-from-the-hugging-face-hub",sections:[{local:"authenticating",title:"Authenticating"},{local:"sharing-a-model",title:"Sharing a Model"},{local:"loading-a-model",title:"Loading a Model"}],title:"Sharing and Loading Models From the Hugging Face Hub"};function ut(Ee){return it(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bt extends rt{constructor(b){super(),ht(this,b,ut,mt,st,{})}}export{bt as component};
