import{s as Ca,o as $a,n as Ua}from"../chunks/scheduler.6062bdaf.js";import{S as Za,i as Ba,g as p,s as e,r as c,A as Ea,h as i,f as a,c as n,j as Ja,u as h,x as M,k as ba,y as xa,a as t,v as r,d,t as o,w as j}from"../chunks/index.4bca734e.js";import{T as Ta}from"../chunks/Tip.b9ac1f03.js";import{C as u}from"../chunks/CodeBlock.cbbddafc.js";import{H as g,E as Ia}from"../chunks/index.60dd99e8.js";function Ga(xs){let m,w="Note that you will have to have Jinja2 installed to use <code>from_template</code>. You can do so with <code>pip install Jinja2</code>.";return{c(){m=p("p"),m.innerHTML=w},l(y){m=i(y,"P",{"data-svelte-h":!0}),M(m)!=="svelte-tehb0q"&&(m.innerHTML=w)},m(y,f){t(y,m,f)},p:Ua,d(y){y&&a(m)}}}function Ra(xs){let m,w='Note that using this function requires you to include the <code>model_name</code> attribute in <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.ModelCardData">ModelCardData</a>.';return{c(){m=p("p"),m.innerHTML=w},l(y){m=i(y,"P",{"data-svelte-h":!0}),M(m)!=="svelte-1to89y7"&&(m.innerHTML=w)},m(y,f){t(y,m,f)},p:Ua,d(y){y&&a(m)}}}function Xa(xs){let m,w,y,f,T,Gs,U,Ql=`The <code>huggingface_hub</code> library provides a Python interface to create, share, and update Model Cards.
Visit <a href="https://huggingface.co/docs/hub/models-cards" rel="nofollow">the dedicated documentation page</a>
for a deeper view of what Model Cards on the Hub are, and how they work under the hood.`,Rs,C,Xs,$,Fl='To load an existing card from the Hub, you can use the <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.RepoCard.load">ModelCard.load()</a> function. Here, we’ll load the card from <a href="https://huggingface.co/nateraw/vit-base-beans" rel="nofollow"><code>nateraw/vit-base-beans</code></a>.',_s,Z,ks,B,Sl="This card has some helpful attributes that you may want to access/leverage:",Ys,E,Vl='<li><code>card.data</code>: Returns a <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.ModelCardData">ModelCardData</a> instance with the model card’s metadata. Call <code>.to_dict()</code> on this instance to get the representation as a dictionary.</li> <li><code>card.text</code>: Returns the text of the card, <em>excluding the metadata header</em>.</li> <li><code>card.content</code>: Returns the text content of the card, <em>including the metadata header</em>.</li>',As,x,vs,I,Ws,G,Hl="To initialize a Model Card from text, just pass the text content of the card to the <code>ModelCard</code> on init.",Ns,R,Qs,X,Ll="Another way you might want to do this is with f-strings. In the following example, we:",Fs,_,zl='<li>Use <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.CardData.to_yaml">ModelCardData.to_yaml()</a> to convert metadata we defined to YAML so we can use it to insert the YAML block in the model card.</li> <li>Show how you might use a template variable via Python f-strings.</li>',Ss,k,Vs,Y,ql="The above example would leave us with a card that looks like this:",Hs,A,Ls,v,zs,W,Pl="If you have <code>Jinja2</code> installed, you can create Model Cards from a jinja template file. Let’s see a basic example:",qs,N,Ps,Q,Dl="The resulting card’s markdown looks like this:",Ds,F,Ks,S,Kl="If you update any card.data, it’ll reflect in the card itself.",Os,V,sl,H,Ol="Now, as you can see, the metadata header has been updated:",ll,L,al,z,sa='As you update the card data, you can validate the card is still valid against the Hub by calling <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.RepoCard.validate">ModelCard.validate()</a>. This ensures that the card passes any validation rules set up on the Hugging Face Hub.',tl,q,el,P,la='Instead of using your own template, you can also use the <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/templates/modelcard_template.md" rel="nofollow">default template</a>, which is a fully featured model card with tons of sections you may want to fill out. Under the hood, it uses <a href="https://jinja.palletsprojects.com/en/3.1.x/" rel="nofollow">Jinja2</a> to fill out a template file.',nl,J,pl,D,il,K,Ml,O,aa='If you’re authenticated with the Hugging Face Hub (either by using <code>huggingface-cli login</code> or <a href="/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.login">login()</a>), you can push cards to the Hub by simply calling <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.RepoCard.push_to_hub">ModelCard.push_to_hub()</a>. Let’s take a look at how to do that…',cl,ss,ta="First, we’ll create a new repo called ‘hf-hub-modelcards-pr-test’ under the authenticated user’s namespace:",hl,ls,rl,as,ea="Then, we’ll create a card from the default template (same as the one defined in the section above):",dl,ts,ol,es,na="Finally, we’ll push that up to the hub",jl,ns,ml,ps,pa='You can check out the resulting card <a href="https://huggingface.co/nateraw/hf-hub-modelcards-pr-test/blob/main/README.md" rel="nofollow">here</a>.',ul,is,ia="If you instead wanted to push a card as a pull request, you can just say <code>create_pr=True</code> when calling <code>push_to_hub</code>:",yl,Ms,wl,cs,Ma='A resulting PR created from this command can be seen <a href="https://huggingface.co/nateraw/hf-hub-modelcards-pr-test/discussions/3" rel="nofollow">here</a>.',gl,hs,fl,rs,ca="In this section we will see what metadata are in repo cards and how to update them.",Jl,ds,ha=`<code>metadata</code> refers to a hash map (or key value) context that provides some high-level information about a model, dataset or Space. That information can include details such as the model’s <code>pipeline type</code>, <code>model_id</code> or <code>model_description</code>. For more detail you can take a look to these guides: <a href="https://huggingface.co/docs/hub/model-cards#model-card-metadata" rel="nofollow">Model Card</a>, <a href="https://huggingface.co/docs/hub/datasets-cards#dataset-card-metadata" rel="nofollow">Dataset Card</a> and <a href="https://huggingface.co/docs/hub/spaces-settings#spaces-settings" rel="nofollow">Spaces Settings</a>.
Now lets see some examples on how to update those metadata.`,bl,os,ra="Let’s start with a first example:",Tl,js,Ul,ms,da="With these two lines of code you will update the metadata to set a new <code>pipeline_tag</code>.",Cl,us,oa=`By default, you cannot update a key that is already existing on the card. If you want to do so, you must pass
<code>overwrite=True</code> explicitly:`,$l,ys,Zl,ws,ja=`It often happen that you want to suggest some changes to a repository
on which you don’t have write permission. You can do that by creating a PR on that repo which will allow the owners to
review and merge your suggestions.`,Bl,gs,El,fs,xl,Js,ma='To include evaluation results in the metadata <code>model-index</code>, you can pass an <a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.EvalResult">EvalResult</a> or a list of <code>EvalResult</code> with your associated evaluation results. Under the hood it’ll create the <code>model-index</code> when you call <code>card.data.to_dict()</code>. For more information on how this works, you can check out <a href="https://huggingface.co/docs/hub/models-cards#evaluation-results" rel="nofollow">this section of the Hub docs</a>.',Il,b,Gl,bs,Rl,Ts,ua="The resulting <code>card.data</code> should look like this:",Xl,Us,_l,Cs,ya="If you have more than one evaluation result you’d like to share, just pass a list of <code>EvalResult</code>:",kl,$s,Yl,Zs,wa="Which should leave you with the following <code>card.data</code>:",Al,Bs,vl,Es,Wl,Is,Nl;return T=new g({props:{title:"Create and share Model Cards",local:"create-and-share-model-cards",headingTag:"h1"}}),C=new g({props:{title:"Load a Model Card from the Hub",local:"load-a-model-card-from-the-hub",headingTag:"h2"}}),Z=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUwQSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQubG9hZCgnbmF0ZXJhdyUyRnZpdC1iYXNlLWJlYW5zJyk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard

card = ModelCard.load(<span class="hljs-string">&#x27;nateraw/vit-base-beans&#x27;</span>)`,wrap:!1}}),x=new g({props:{title:"Create Model Cards",local:"create-model-cards",headingTag:"h2"}}),I=new g({props:{title:"From Text",local:"from-text",headingTag:"h3"}}),R=new u({props:{code:"Y29udGVudCUyMCUzRCUyMCUyMiUyMiUyMiUwQS0tLSUwQWxhbmd1YWdlJTNBJTIwZW4lMEFsaWNlbnNlJTNBJTIwbWl0JTBBLS0tJTBBJTBBJTIzJTIwTXklMjBNb2RlbCUyMENhcmQlMEElMjIlMjIlMjIlMEElMEFjYXJkJTIwJTNEJTIwTW9kZWxDYXJkKGNvbnRlbnQpJTBBY2FyZC5kYXRhLnRvX2RpY3QoKSUyMCUzRCUzRCUyMCU3QidsYW5ndWFnZSclM0ElMjAnZW4nJTJDJTIwJ2xpY2Vuc2UnJTNBJTIwJ21pdCclN0QlMjAlMjAlMjMlMjBUcnVl",highlighted:`content = <span class="hljs-string">&quot;&quot;&quot;
---
language: en
license: mit
---

# My Model Card
&quot;&quot;&quot;</span>

card = ModelCard(content)
card.data.to_dict() == {<span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;license&#x27;</span>: <span class="hljs-string">&#x27;mit&#x27;</span>}  <span class="hljs-comment"># True</span>`,wrap:!1}}),k=new u({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YShsYW5ndWFnZSUzRCdlbiclMkMlMjBsaWNlbnNlJTNEJ21pdCclMkMlMjBsaWJyYXJ5JTNEJ3RpbW0nKSUwQSUwQWV4YW1wbGVfdGVtcGxhdGVfdmFyJTIwJTNEJTIwJ25hdGVyYXcnJTBBY29udGVudCUyMCUzRCUyMGYlMjIlMjIlMjIlMEEtLS0lMEElN0IlMjBjYXJkX2RhdGEudG9feWFtbCgpJTIwJTdEJTBBLS0tJTBBJTBBJTIzJTIwTXklMjBNb2RlbCUyMENhcmQlMEElMEFUaGlzJTIwbW9kZWwlMjBjcmVhdGVkJTIwYnklMjAlNUIlNDAlN0JleGFtcGxlX3RlbXBsYXRlX3ZhciU3RCU1RChodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkYlN0JleGFtcGxlX3RlbXBsYXRlX3ZhciU3RCklMEElMjIlMjIlMjIlMEElMEFjYXJkJTIwJTNEJTIwTW9kZWxDYXJkKGNvbnRlbnQpJTBBcHJpbnQoY2FyZCk=",highlighted:`card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library=<span class="hljs-string">&#x27;timm&#x27;</span>)

example_template_var = <span class="hljs-string">&#x27;nateraw&#x27;</span>
content = <span class="hljs-string">f&quot;&quot;&quot;
---
<span class="hljs-subst">{ card_data.to_yaml() }</span>
---

# My Model Card

This model created by [@<span class="hljs-subst">{example_template_var}</span>](https://github.com/<span class="hljs-subst">{example_template_var}</span>)
&quot;&quot;&quot;</span>

card = ModelCard(content)
<span class="hljs-built_in">print</span>(card)`,wrap:!1}}),A=new u({props:{code:"LS0tJTBBbGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFsaWJyYXJ5JTNBJTIwdGltbSUwQS0tLSUwQSUwQSUyMyUyME15JTIwTW9kZWwlMjBDYXJkJTBBJTBBVGhpcyUyMG1vZGVsJTIwY3JlYXRlZCUyMGJ5JTIwJTVCJTQwbmF0ZXJhdyU1RChodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZuYXRlcmF3KQ==",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">language:</span> <span class="hljs-string">en</span>
<span class="hljs-attr">license:</span> <span class="hljs-string">mit</span>
<span class="hljs-attr">library:</span> <span class="hljs-string">timm</span>
<span class="hljs-meta">---
</span>
<span class="hljs-comment"># My Model Card</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">created</span> <span class="hljs-string">by</span> [<span class="hljs-string">@nateraw</span>]<span class="hljs-string">(https://github.com/nateraw)</span>`,wrap:!1}}),v=new g({props:{title:"From a Jinja Template",local:"from-a-jinja-template",headingTag:"h3"}}),N=new u({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUyQyUyME1vZGVsQ2FyZERhdGElMEElMEElMjMlMjBEZWZpbmUlMjB5b3VyJTIwamluamElMjB0ZW1wbGF0ZSUwQXRlbXBsYXRlX3RleHQlMjAlM0QlMjAlMjIlMjIlMjIlMEEtLS0lMEElN0IlN0IlMjBjYXJkX2RhdGElMjAlN0QlN0QlMEEtLS0lMEElMEElMjMlMjBNb2RlbCUyMENhcmQlMjBmb3IlMjBNeUNvb2xNb2RlbCUwQSUwQVRoaXMlMjBtb2RlbCUyMGRvZXMlMjB0aGlzJTIwYW5kJTIwdGhhdC4lMEElMEFUaGlzJTIwbW9kZWwlMjB3YXMlMjBjcmVhdGVkJTIwYnklMjAlNUIlNDAlN0IlN0IlMjBhdXRob3IlMjAlN0QlN0QlNUQoaHR0cHMlM0ElMkYlMkZoZi5jbyUyRiU3QiU3QmF1dGhvciU3RCU3RCkuJTBBJTIyJTIyJTIyLnN0cmlwKCklMEElMEElMjMlMjBXcml0ZSUyMHRoZSUyMHRlbXBsYXRlJTIwdG8lMjBhJTIwZmlsZSUwQVBhdGgoJ2N1c3RvbV90ZW1wbGF0ZS5tZCcpLndyaXRlX3RleHQodGVtcGxhdGVfdGV4dCklMEElMEElMjMlMjBEZWZpbmUlMjBjYXJkJTIwbWV0YWRhdGElMEFjYXJkX2RhdGElMjAlM0QlMjBNb2RlbENhcmREYXRhKGxhbmd1YWdlJTNEJ2VuJyUyQyUyMGxpY2Vuc2UlM0QnbWl0JyUyQyUyMGxpYnJhcnlfbmFtZSUzRCdrZXJhcycpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwY2FyZCUyMGZyb20lMjB0ZW1wbGF0ZSUyQyUyMHBhc3NpbmclMjBpdCUyMGFueSUyMGppbmphJTIwdGVtcGxhdGUlMjB2YXJpYWJsZXMlMjB5b3UlMjB3YW50LiUwQSUyMyUyMEluJTIwb3VyJTIwY2FzZSUyQyUyMHdlJ2xsJTIwcGFzcyUyMGF1dGhvciUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZShjYXJkX2RhdGElMkMlMjB0ZW1wbGF0ZV9wYXRoJTNEJ2N1c3RvbV90ZW1wbGF0ZS5tZCclMkMlMjBhdXRob3IlM0QnbmF0ZXJhdycpJTBBY2FyZC5zYXZlKCdteV9tb2RlbF9jYXJkXzEubWQnKSUwQXByaW50KGNhcmQp",highlighted:`<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, ModelCardData

<span class="hljs-comment"># Define your jinja template</span>
template_text = <span class="hljs-string">&quot;&quot;&quot;
---
{{ card_data }}
---

# Model Card for MyCoolModel

This model does this and that.

This model was created by [@{{ author }}](https://hf.co/{{author}}).
&quot;&quot;&quot;</span>.strip()

<span class="hljs-comment"># Write the template to a file</span>
Path(<span class="hljs-string">&#x27;custom_template.md&#x27;</span>).write_text(template_text)

<span class="hljs-comment"># Define card metadata</span>
card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library_name=<span class="hljs-string">&#x27;keras&#x27;</span>)

<span class="hljs-comment"># Create card from template, passing it any jinja template variables you want.</span>
<span class="hljs-comment"># In our case, we&#x27;ll pass author</span>
card = ModelCard.from_template(card_data, template_path=<span class="hljs-string">&#x27;custom_template.md&#x27;</span>, author=<span class="hljs-string">&#x27;nateraw&#x27;</span>)
card.save(<span class="hljs-string">&#x27;my_model_card_1.md&#x27;</span>)
<span class="hljs-built_in">print</span>(card)`,wrap:!1}}),F=new u({props:{code:"LS0tJTBBbGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFsaWJyYXJ5X25hbWUlM0ElMjBrZXJhcyUwQS0tLSUwQSUwQSUyMyUyME1vZGVsJTIwQ2FyZCUyMGZvciUyME15Q29vbE1vZGVsJTBBJTBBVGhpcyUyMG1vZGVsJTIwZG9lcyUyMHRoaXMlMjBhbmQlMjB0aGF0LiUwQSUwQVRoaXMlMjBtb2RlbCUyMHdhcyUyMGNyZWF0ZWQlMjBieSUyMCU1QiU0MG5hdGVyYXclNUQoaHR0cHMlM0ElMkYlMkZoZi5jbyUyRm5hdGVyYXcpLg==",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">language:</span> <span class="hljs-string">en</span>
<span class="hljs-attr">license:</span> <span class="hljs-string">mit</span>
<span class="hljs-attr">library_name:</span> <span class="hljs-string">keras</span>
<span class="hljs-meta">---
</span>
<span class="hljs-comment"># Model Card for MyCoolModel</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">does</span> <span class="hljs-string">this</span> <span class="hljs-string">and</span> <span class="hljs-string">that.</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">was</span> <span class="hljs-string">created</span> <span class="hljs-string">by</span> [<span class="hljs-string">@nateraw</span>]<span class="hljs-string">(https://hf.co/nateraw).</span>`,wrap:!1}}),V=new u({props:{code:"Y2FyZC5kYXRhLmxpYnJhcnlfbmFtZSUyMCUzRCUyMCd0aW1tJyUwQWNhcmQuZGF0YS5sYW5ndWFnZSUyMCUzRCUyMCdmciclMEFjYXJkLmRhdGEubGljZW5zZSUyMCUzRCUyMCdhcGFjaGUtMi4wJyUwQXByaW50KGNhcmQp",highlighted:`card<span class="hljs-selector-class">.data</span><span class="hljs-selector-class">.library_name</span> = <span class="hljs-string">&#x27;timm&#x27;</span>
card<span class="hljs-selector-class">.data</span><span class="hljs-selector-class">.language</span> = <span class="hljs-string">&#x27;fr&#x27;</span>
card<span class="hljs-selector-class">.data</span><span class="hljs-selector-class">.license</span> = <span class="hljs-string">&#x27;apache-2.0&#x27;</span>
<span class="hljs-function"><span class="hljs-title">print</span><span class="hljs-params">(card)</span></span>`,wrap:!1}}),L=new u({props:{code:"LS0tJTBBbGFuZ3VhZ2UlM0ElMjBmciUwQWxpY2Vuc2UlM0ElMjBhcGFjaGUtMi4wJTBBbGlicmFyeV9uYW1lJTNBJTIwdGltbSUwQS0tLSUwQSUwQSUyMyUyME1vZGVsJTIwQ2FyZCUyMGZvciUyME15Q29vbE1vZGVsJTBBJTBBVGhpcyUyMG1vZGVsJTIwZG9lcyUyMHRoaXMlMjBhbmQlMjB0aGF0LiUwQSUwQVRoaXMlMjBtb2RlbCUyMHdhcyUyMGNyZWF0ZWQlMjBieSUyMCU1QiU0MG5hdGVyYXclNUQoaHR0cHMlM0ElMkYlMkZoZi5jbyUyRm5hdGVyYXcpLg==",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">language:</span> <span class="hljs-string">fr</span>
<span class="hljs-attr">license:</span> <span class="hljs-string">apache-2.0</span>
<span class="hljs-attr">library_name:</span> <span class="hljs-string">timm</span>
<span class="hljs-meta">---
</span>
<span class="hljs-comment"># Model Card for MyCoolModel</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">does</span> <span class="hljs-string">this</span> <span class="hljs-string">and</span> <span class="hljs-string">that.</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">was</span> <span class="hljs-string">created</span> <span class="hljs-string">by</span> [<span class="hljs-string">@nateraw</span>]<span class="hljs-string">(https://hf.co/nateraw).</span>`,wrap:!1}}),q=new g({props:{title:"From the Default Template",local:"from-the-default-template",headingTag:"h3"}}),J=new Ta({props:{$$slots:{default:[Ga]},$$scope:{ctx:xs}}}),D=new u({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YShsYW5ndWFnZSUzRCdlbiclMkMlMjBsaWNlbnNlJTNEJ21pdCclMkMlMjBsaWJyYXJ5X25hbWUlM0Qna2VyYXMnKSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBjYXJkX2RhdGElMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdteS1jb29sLW1vZGVsJyUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2Rlc2NyaXB0aW9uJTNEJTIydGhpcyUyMG1vZGVsJTIwZG9lcyUyMHRoaXMlMjBhbmQlMjB0aGF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2ZWxvcGVycyUzRCUyMk5hdGUlMjBSYXclMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvJTNEJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZodWdnaW5nZmFjZV9odWIlMjIlMkMlMEEpJTBBY2FyZC5zYXZlKCdteV9tb2RlbF9jYXJkXzIubWQnKSUwQXByaW50KGNhcmQp",highlighted:`card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library_name=<span class="hljs-string">&#x27;keras&#x27;</span>)
card = ModelCard.from_template(
    card_data,
    model_id=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    model_description=<span class="hljs-string">&quot;this model does this and that&quot;</span>,
    developers=<span class="hljs-string">&quot;Nate Raw&quot;</span>,
    repo=<span class="hljs-string">&quot;https://github.com/huggingface/huggingface_hub&quot;</span>,
)
card.save(<span class="hljs-string">&#x27;my_model_card_2.md&#x27;</span>)
<span class="hljs-built_in">print</span>(card)`,wrap:!1}}),K=new g({props:{title:"Share Model Cards",local:"share-model-cards",headingTag:"h2"}}),ls=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdob2FtaSUyQyUyMGNyZWF0ZV9yZXBvJTBBJTBBdXNlciUyMCUzRCUyMHdob2FtaSgpJTVCJ25hbWUnJTVEJTBBcmVwb19pZCUyMCUzRCUyMGYnJTdCdXNlciU3RCUyRmhmLWh1Yi1tb2RlbGNhcmRzLXByLXRlc3QnJTBBdXJsJTIwJTNEJTIwY3JlYXRlX3JlcG8ocmVwb19pZCUyQyUyMGV4aXN0X29rJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> whoami, create_repo

user = whoami()[<span class="hljs-string">&#x27;name&#x27;</span>]
repo_id = <span class="hljs-string">f&#x27;<span class="hljs-subst">{user}</span>/hf-hub-modelcards-pr-test&#x27;</span>
url = create_repo(repo_id, exist_ok=<span class="hljs-literal">True</span>)`,wrap:!1}}),ts=new u({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YShsYW5ndWFnZSUzRCdlbiclMkMlMjBsaWNlbnNlJTNEJ21pdCclMkMlMjBsaWJyYXJ5X25hbWUlM0Qna2VyYXMnKSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBjYXJkX2RhdGElMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdteS1jb29sLW1vZGVsJyUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2Rlc2NyaXB0aW9uJTNEJTIydGhpcyUyMG1vZGVsJTIwZG9lcyUyMHRoaXMlMjBhbmQlMjB0aGF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2ZWxvcGVycyUzRCUyMk5hdGUlMjBSYXclMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvJTNEJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZodWdnaW5nZmFjZV9odWIlMjIlMkMlMEEp",highlighted:`card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library_name=<span class="hljs-string">&#x27;keras&#x27;</span>)
card = ModelCard.from_template(
    card_data,
    model_id=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    model_description=<span class="hljs-string">&quot;this model does this and that&quot;</span>,
    developers=<span class="hljs-string">&quot;Nate Raw&quot;</span>,
    repo=<span class="hljs-string">&quot;https://github.com/huggingface/huggingface_hub&quot;</span>,
)`,wrap:!1}}),ns=new u({props:{code:"Y2FyZC5wdXNoX3RvX2h1YihyZXBvX2lkKQ==",highlighted:"card.push_to_hub(repo_id)",wrap:!1}}),Ms=new u({props:{code:"Y2FyZC5wdXNoX3RvX2h1YihyZXBvX2lkJTJDJTIwY3JlYXRlX3ByJTNEVHJ1ZSk=",highlighted:'card.push_to_hub(repo_id, create_pr=<span class="hljs-literal">True</span>)',wrap:!1}}),hs=new g({props:{title:"Update metadata",local:"update-metadata",headingTag:"h2"}}),js=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQW1ldGFkYXRhX3VwZGF0ZSglMjJ1c2VybmFtZSUyRm15LWNvb2wtbW9kZWwlMjIlMkMlMjAlN0IlMjJwaXBlbGluZV90YWclMjIlM0ElMjAlMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiU3RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata_update(<span class="hljs-string">&quot;username/my-cool-model&quot;</span>, {<span class="hljs-string">&quot;pipeline_tag&quot;</span>: <span class="hljs-string">&quot;image-classification&quot;</span>})`,wrap:!1}}),ys=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQW1ldGFkYXRhX3VwZGF0ZSglMjJ1c2VybmFtZSUyRm15LWNvb2wtbW9kZWwlMjIlMkMlMjAlN0IlMjJwaXBlbGluZV90YWclMjIlM0ElMjAlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlN0QlMkMlMjBvdmVyd3JpdGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata_update(<span class="hljs-string">&quot;username/my-cool-model&quot;</span>, {<span class="hljs-string">&quot;pipeline_tag&quot;</span>: <span class="hljs-string">&quot;text-generation&quot;</span>}, overwrite=<span class="hljs-literal">True</span>)`,wrap:!1}}),gs=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQW1ldGFkYXRhX3VwZGF0ZSglMjJzb21lb25lJTJGbW9kZWwlMjIlMkMlMjAlN0IlMjJwaXBlbGluZV90YWclMjIlM0ElMjAlMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyJTdEJTJDJTIwY3JlYXRlX3ByJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata_update(<span class="hljs-string">&quot;someone/model&quot;</span>, {<span class="hljs-string">&quot;pipeline_tag&quot;</span>: <span class="hljs-string">&quot;text-classification&quot;</span>}, create_pr=<span class="hljs-literal">True</span>)`,wrap:!1}}),fs=new g({props:{title:"Include Evaluation Results",local:"include-evaluation-results",headingTag:"h2"}}),b=new Ta({props:{$$slots:{default:[Ra]},$$scope:{ctx:xs}}}),bs=new u({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YSglMEElMjAlMjAlMjAlMjBsYW5ndWFnZSUzRCdlbiclMkMlMEElMjAlMjAlMjAlMjBsaWNlbnNlJTNEJ21pdCclMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJ215LWNvb2wtbW9kZWwnJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9yZXN1bHRzJTIwJTNEJTIwRXZhbFJlc3VsdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QnaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF90eXBlJTNEJ2JlYW5zJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCdCZWFucyclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdHlwZSUzRCdhY2N1cmFjeSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdmFsdWUlM0QwLjclMEElMjAlMjAlMjAlMjApJTBBKSUwQSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZShjYXJkX2RhdGEpJTBBcHJpbnQoY2FyZC5kYXRhKQ==",highlighted:`card_data = ModelCardData(
    language=<span class="hljs-string">&#x27;en&#x27;</span>,
    license=<span class="hljs-string">&#x27;mit&#x27;</span>,
    model_name=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    eval_results = EvalResult(
        task_type=<span class="hljs-string">&#x27;image-classification&#x27;</span>,
        dataset_type=<span class="hljs-string">&#x27;beans&#x27;</span>,
        dataset_name=<span class="hljs-string">&#x27;Beans&#x27;</span>,
        metric_type=<span class="hljs-string">&#x27;accuracy&#x27;</span>,
        metric_value=<span class="hljs-number">0.7</span>
    )
)

card = ModelCard.from_template(card_data)
<span class="hljs-built_in">print</span>(card.data)`,wrap:!1}}),Us=new u({props:{code:"bGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFtb2RlbC1pbmRleCUzQSUwQS0lMjBuYW1lJTNBJTIwbXktY29vbC1tb2RlbCUwQSUyMCUyMHJlc3VsdHMlM0ElMEElMjAlMjAtJTIwdGFzayUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0ElMjBpbWFnZS1jbGFzc2lmaWNhdGlvbiUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwQmVhbnMlMEElMjAlMjAlMjAlMjAlMjAlMjB0eXBlJTNBJTIwYmVhbnMlMEElMjAlMjAlMjAlMjBtZXRyaWNzJTNBJTBBJTIwJTIwJTIwJTIwLSUyMHR5cGUlM0ElMjBhY2N1cmFjeSUwQSUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlJTNBJTIwMC43",highlighted:`<span class="hljs-attribute">language</span><span class="hljs-punctuation">:</span> <span class="hljs-string">en</span>
<span class="hljs-attribute">license</span><span class="hljs-punctuation">:</span> <span class="hljs-string">mit</span>
<span class="hljs-attribute">model-index</span><span class="hljs-punctuation">:</span>
<span class="hljs-bullet">-</span> <span class="hljs-string">name: my-cool-model</span>
  <span class="hljs-attribute">results</span><span class="hljs-punctuation">:</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">task:</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">image-classification</span>
    <span class="hljs-attribute">dataset</span><span class="hljs-punctuation">:</span>
      <span class="hljs-attribute">name</span><span class="hljs-punctuation">:</span> <span class="hljs-string">Beans</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">beans</span>
    <span class="hljs-attribute">metrics</span><span class="hljs-punctuation">:</span>
    <span class="hljs-bullet">-</span> <span class="hljs-string">type: accuracy</span>
      <span class="hljs-attribute">value</span><span class="hljs-punctuation">:</span> <span class="hljs-string">0.7</span>`,wrap:!1}}),$s=new u({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YSglMEElMjAlMjAlMjAlMjBsYW5ndWFnZSUzRCdlbiclMkMlMEElMjAlMjAlMjAlMjBsaWNlbnNlJTNEJ21pdCclMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJ215LWNvb2wtbW9kZWwnJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9yZXN1bHRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRXZhbFJlc3VsdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QnaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF90eXBlJTNEJ2JlYW5zJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCdCZWFucyclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdHlwZSUzRCdhY2N1cmFjeSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdmFsdWUlM0QwLjclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRXZhbFJlc3VsdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QnaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF90eXBlJTNEJ2JlYW5zJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCdCZWFucyclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdHlwZSUzRCdmMSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdmFsdWUlM0QwLjY1JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMEFjYXJkJTIwJTNEJTIwTW9kZWxDYXJkLmZyb21fdGVtcGxhdGUoY2FyZF9kYXRhKSUwQWNhcmQuZGF0YQ==",highlighted:`card_data = ModelCardData(
    language=<span class="hljs-string">&#x27;en&#x27;</span>,
    license=<span class="hljs-string">&#x27;mit&#x27;</span>,
    model_name=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    eval_results = [
        EvalResult(
            task_type=<span class="hljs-string">&#x27;image-classification&#x27;</span>,
            dataset_type=<span class="hljs-string">&#x27;beans&#x27;</span>,
            dataset_name=<span class="hljs-string">&#x27;Beans&#x27;</span>,
            metric_type=<span class="hljs-string">&#x27;accuracy&#x27;</span>,
            metric_value=<span class="hljs-number">0.7</span>
        ),
        EvalResult(
            task_type=<span class="hljs-string">&#x27;image-classification&#x27;</span>,
            dataset_type=<span class="hljs-string">&#x27;beans&#x27;</span>,
            dataset_name=<span class="hljs-string">&#x27;Beans&#x27;</span>,
            metric_type=<span class="hljs-string">&#x27;f1&#x27;</span>,
            metric_value=<span class="hljs-number">0.65</span>
        )
    ]
)
card = ModelCard.from_template(card_data)
card.data`,wrap:!1}}),Bs=new u({props:{code:"bGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFtb2RlbC1pbmRleCUzQSUwQS0lMjBuYW1lJTNBJTIwbXktY29vbC1tb2RlbCUwQSUyMCUyMHJlc3VsdHMlM0ElMEElMjAlMjAtJTIwdGFzayUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0ElMjBpbWFnZS1jbGFzc2lmaWNhdGlvbiUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwQmVhbnMlMEElMjAlMjAlMjAlMjAlMjAlMjB0eXBlJTNBJTIwYmVhbnMlMEElMjAlMjAlMjAlMjBtZXRyaWNzJTNBJTBBJTIwJTIwJTIwJTIwLSUyMHR5cGUlM0ElMjBhY2N1cmFjeSUwQSUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlJTNBJTIwMC43JTBBJTIwJTIwJTIwJTIwLSUyMHR5cGUlM0ElMjBmMSUwQSUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlJTNBJTIwMC42NQ==",highlighted:`<span class="hljs-attribute">language</span><span class="hljs-punctuation">:</span> <span class="hljs-string">en</span>
<span class="hljs-attribute">license</span><span class="hljs-punctuation">:</span> <span class="hljs-string">mit</span>
<span class="hljs-attribute">model-index</span><span class="hljs-punctuation">:</span>
<span class="hljs-bullet">-</span> <span class="hljs-string">name: my-cool-model</span>
  <span class="hljs-attribute">results</span><span class="hljs-punctuation">:</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">task:</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">image-classification</span>
    <span class="hljs-attribute">dataset</span><span class="hljs-punctuation">:</span>
      <span class="hljs-attribute">name</span><span class="hljs-punctuation">:</span> <span class="hljs-string">Beans</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">beans</span>
    <span class="hljs-attribute">metrics</span><span class="hljs-punctuation">:</span>
    <span class="hljs-bullet">-</span> <span class="hljs-string">type: accuracy</span>
      <span class="hljs-attribute">value</span><span class="hljs-punctuation">:</span> <span class="hljs-string">0.7</span>
    <span class="hljs-bullet">-</span> <span class="hljs-string">type: f1</span>
      <span class="hljs-attribute">value</span><span class="hljs-punctuation">:</span> <span class="hljs-string">0.65</span>`,wrap:!1}}),Es=new Ia({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/model-cards.md"}}),{c(){m=p("meta"),w=e(),y=p("p"),f=e(),c(T.$$.fragment),Gs=e(),U=p("p"),U.innerHTML=Ql,Rs=e(),c(C.$$.fragment),Xs=e(),$=p("p"),$.innerHTML=Fl,_s=e(),c(Z.$$.fragment),ks=e(),B=p("p"),B.textContent=Sl,Ys=e(),E=p("ul"),E.innerHTML=Vl,As=e(),c(x.$$.fragment),vs=e(),c(I.$$.fragment),Ws=e(),G=p("p"),G.innerHTML=Hl,Ns=e(),c(R.$$.fragment),Qs=e(),X=p("p"),X.textContent=Ll,Fs=e(),_=p("ul"),_.innerHTML=zl,Ss=e(),c(k.$$.fragment),Vs=e(),Y=p("p"),Y.textContent=ql,Hs=e(),c(A.$$.fragment),Ls=e(),c(v.$$.fragment),zs=e(),W=p("p"),W.innerHTML=Pl,qs=e(),c(N.$$.fragment),Ps=e(),Q=p("p"),Q.textContent=Dl,Ds=e(),c(F.$$.fragment),Ks=e(),S=p("p"),S.textContent=Kl,Os=e(),c(V.$$.fragment),sl=e(),H=p("p"),H.textContent=Ol,ll=e(),c(L.$$.fragment),al=e(),z=p("p"),z.innerHTML=sa,tl=e(),c(q.$$.fragment),el=e(),P=p("p"),P.innerHTML=la,nl=e(),c(J.$$.fragment),pl=e(),c(D.$$.fragment),il=e(),c(K.$$.fragment),Ml=e(),O=p("p"),O.innerHTML=aa,cl=e(),ss=p("p"),ss.textContent=ta,hl=e(),c(ls.$$.fragment),rl=e(),as=p("p"),as.textContent=ea,dl=e(),c(ts.$$.fragment),ol=e(),es=p("p"),es.textContent=na,jl=e(),c(ns.$$.fragment),ml=e(),ps=p("p"),ps.innerHTML=pa,ul=e(),is=p("p"),is.innerHTML=ia,yl=e(),c(Ms.$$.fragment),wl=e(),cs=p("p"),cs.innerHTML=Ma,gl=e(),c(hs.$$.fragment),fl=e(),rs=p("p"),rs.textContent=ca,Jl=e(),ds=p("p"),ds.innerHTML=ha,bl=e(),os=p("p"),os.textContent=ra,Tl=e(),c(js.$$.fragment),Ul=e(),ms=p("p"),ms.innerHTML=da,Cl=e(),us=p("p"),us.innerHTML=oa,$l=e(),c(ys.$$.fragment),Zl=e(),ws=p("p"),ws.textContent=ja,Bl=e(),c(gs.$$.fragment),El=e(),c(fs.$$.fragment),xl=e(),Js=p("p"),Js.innerHTML=ma,Il=e(),c(b.$$.fragment),Gl=e(),c(bs.$$.fragment),Rl=e(),Ts=p("p"),Ts.innerHTML=ua,Xl=e(),c(Us.$$.fragment),_l=e(),Cs=p("p"),Cs.innerHTML=ya,kl=e(),c($s.$$.fragment),Yl=e(),Zs=p("p"),Zs.innerHTML=wa,Al=e(),c(Bs.$$.fragment),vl=e(),c(Es.$$.fragment),Wl=e(),Is=p("p"),this.h()},l(s){const l=Ea("svelte-u9bgzb",document.head);m=i(l,"META",{name:!0,content:!0}),l.forEach(a),w=n(s),y=i(s,"P",{}),Ja(y).forEach(a),f=n(s),h(T.$$.fragment,s),Gs=n(s),U=i(s,"P",{"data-svelte-h":!0}),M(U)!=="svelte-sb4v4f"&&(U.innerHTML=Ql),Rs=n(s),h(C.$$.fragment,s),Xs=n(s),$=i(s,"P",{"data-svelte-h":!0}),M($)!=="svelte-1ezm0us"&&($.innerHTML=Fl),_s=n(s),h(Z.$$.fragment,s),ks=n(s),B=i(s,"P",{"data-svelte-h":!0}),M(B)!=="svelte-10yvqaf"&&(B.textContent=Sl),Ys=n(s),E=i(s,"UL",{"data-svelte-h":!0}),M(E)!=="svelte-xs8zal"&&(E.innerHTML=Vl),As=n(s),h(x.$$.fragment,s),vs=n(s),h(I.$$.fragment,s),Ws=n(s),G=i(s,"P",{"data-svelte-h":!0}),M(G)!=="svelte-17iybkb"&&(G.innerHTML=Hl),Ns=n(s),h(R.$$.fragment,s),Qs=n(s),X=i(s,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1i1nzes"&&(X.textContent=Ll),Fs=n(s),_=i(s,"UL",{"data-svelte-h":!0}),M(_)!=="svelte-1a2t6et"&&(_.innerHTML=zl),Ss=n(s),h(k.$$.fragment,s),Vs=n(s),Y=i(s,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-azweip"&&(Y.textContent=ql),Hs=n(s),h(A.$$.fragment,s),Ls=n(s),h(v.$$.fragment,s),zs=n(s),W=i(s,"P",{"data-svelte-h":!0}),M(W)!=="svelte-w5ezj2"&&(W.innerHTML=Pl),qs=n(s),h(N.$$.fragment,s),Ps=n(s),Q=i(s,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-186asy8"&&(Q.textContent=Dl),Ds=n(s),h(F.$$.fragment,s),Ks=n(s),S=i(s,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1uu9tt7"&&(S.textContent=Kl),Os=n(s),h(V.$$.fragment,s),sl=n(s),H=i(s,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1pjyyfy"&&(H.textContent=Ol),ll=n(s),h(L.$$.fragment,s),al=n(s),z=i(s,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1d3izsf"&&(z.innerHTML=sa),tl=n(s),h(q.$$.fragment,s),el=n(s),P=i(s,"P",{"data-svelte-h":!0}),M(P)!=="svelte-bhtooo"&&(P.innerHTML=la),nl=n(s),h(J.$$.fragment,s),pl=n(s),h(D.$$.fragment,s),il=n(s),h(K.$$.fragment,s),Ml=n(s),O=i(s,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1cfaoeg"&&(O.innerHTML=aa),cl=n(s),ss=i(s,"P",{"data-svelte-h":!0}),M(ss)!=="svelte-4nym2l"&&(ss.textContent=ta),hl=n(s),h(ls.$$.fragment,s),rl=n(s),as=i(s,"P",{"data-svelte-h":!0}),M(as)!=="svelte-m495as"&&(as.textContent=ea),dl=n(s),h(ts.$$.fragment,s),ol=n(s),es=i(s,"P",{"data-svelte-h":!0}),M(es)!=="svelte-17rhkin"&&(es.textContent=na),jl=n(s),h(ns.$$.fragment,s),ml=n(s),ps=i(s,"P",{"data-svelte-h":!0}),M(ps)!=="svelte-1ecq7w8"&&(ps.innerHTML=pa),ul=n(s),is=i(s,"P",{"data-svelte-h":!0}),M(is)!=="svelte-1wkut12"&&(is.innerHTML=ia),yl=n(s),h(Ms.$$.fragment,s),wl=n(s),cs=i(s,"P",{"data-svelte-h":!0}),M(cs)!=="svelte-bvjuqo"&&(cs.innerHTML=Ma),gl=n(s),h(hs.$$.fragment,s),fl=n(s),rs=i(s,"P",{"data-svelte-h":!0}),M(rs)!=="svelte-1r8ornf"&&(rs.textContent=ca),Jl=n(s),ds=i(s,"P",{"data-svelte-h":!0}),M(ds)!=="svelte-1k83g63"&&(ds.innerHTML=ha),bl=n(s),os=i(s,"P",{"data-svelte-h":!0}),M(os)!=="svelte-1myl3lm"&&(os.textContent=ra),Tl=n(s),h(js.$$.fragment,s),Ul=n(s),ms=i(s,"P",{"data-svelte-h":!0}),M(ms)!=="svelte-1tsl7te"&&(ms.innerHTML=da),Cl=n(s),us=i(s,"P",{"data-svelte-h":!0}),M(us)!=="svelte-jfkfc6"&&(us.innerHTML=oa),$l=n(s),h(ys.$$.fragment,s),Zl=n(s),ws=i(s,"P",{"data-svelte-h":!0}),M(ws)!=="svelte-1qf6a5n"&&(ws.textContent=ja),Bl=n(s),h(gs.$$.fragment,s),El=n(s),h(fs.$$.fragment,s),xl=n(s),Js=i(s,"P",{"data-svelte-h":!0}),M(Js)!=="svelte-w53c2y"&&(Js.innerHTML=ma),Il=n(s),h(b.$$.fragment,s),Gl=n(s),h(bs.$$.fragment,s),Rl=n(s),Ts=i(s,"P",{"data-svelte-h":!0}),M(Ts)!=="svelte-ejf86q"&&(Ts.innerHTML=ua),Xl=n(s),h(Us.$$.fragment,s),_l=n(s),Cs=i(s,"P",{"data-svelte-h":!0}),M(Cs)!=="svelte-1k9vy6l"&&(Cs.innerHTML=ya),kl=n(s),h($s.$$.fragment,s),Yl=n(s),Zs=i(s,"P",{"data-svelte-h":!0}),M(Zs)!=="svelte-12f1f8r"&&(Zs.innerHTML=wa),Al=n(s),h(Bs.$$.fragment,s),vl=n(s),h(Es.$$.fragment,s),Wl=n(s),Is=i(s,"P",{}),Ja(Is).forEach(a),this.h()},h(){ba(m,"name","hf:doc:metadata"),ba(m,"content",_a)},m(s,l){xa(document.head,m),t(s,w,l),t(s,y,l),t(s,f,l),r(T,s,l),t(s,Gs,l),t(s,U,l),t(s,Rs,l),r(C,s,l),t(s,Xs,l),t(s,$,l),t(s,_s,l),r(Z,s,l),t(s,ks,l),t(s,B,l),t(s,Ys,l),t(s,E,l),t(s,As,l),r(x,s,l),t(s,vs,l),r(I,s,l),t(s,Ws,l),t(s,G,l),t(s,Ns,l),r(R,s,l),t(s,Qs,l),t(s,X,l),t(s,Fs,l),t(s,_,l),t(s,Ss,l),r(k,s,l),t(s,Vs,l),t(s,Y,l),t(s,Hs,l),r(A,s,l),t(s,Ls,l),r(v,s,l),t(s,zs,l),t(s,W,l),t(s,qs,l),r(N,s,l),t(s,Ps,l),t(s,Q,l),t(s,Ds,l),r(F,s,l),t(s,Ks,l),t(s,S,l),t(s,Os,l),r(V,s,l),t(s,sl,l),t(s,H,l),t(s,ll,l),r(L,s,l),t(s,al,l),t(s,z,l),t(s,tl,l),r(q,s,l),t(s,el,l),t(s,P,l),t(s,nl,l),r(J,s,l),t(s,pl,l),r(D,s,l),t(s,il,l),r(K,s,l),t(s,Ml,l),t(s,O,l),t(s,cl,l),t(s,ss,l),t(s,hl,l),r(ls,s,l),t(s,rl,l),t(s,as,l),t(s,dl,l),r(ts,s,l),t(s,ol,l),t(s,es,l),t(s,jl,l),r(ns,s,l),t(s,ml,l),t(s,ps,l),t(s,ul,l),t(s,is,l),t(s,yl,l),r(Ms,s,l),t(s,wl,l),t(s,cs,l),t(s,gl,l),r(hs,s,l),t(s,fl,l),t(s,rs,l),t(s,Jl,l),t(s,ds,l),t(s,bl,l),t(s,os,l),t(s,Tl,l),r(js,s,l),t(s,Ul,l),t(s,ms,l),t(s,Cl,l),t(s,us,l),t(s,$l,l),r(ys,s,l),t(s,Zl,l),t(s,ws,l),t(s,Bl,l),r(gs,s,l),t(s,El,l),r(fs,s,l),t(s,xl,l),t(s,Js,l),t(s,Il,l),r(b,s,l),t(s,Gl,l),r(bs,s,l),t(s,Rl,l),t(s,Ts,l),t(s,Xl,l),r(Us,s,l),t(s,_l,l),t(s,Cs,l),t(s,kl,l),r($s,s,l),t(s,Yl,l),t(s,Zs,l),t(s,Al,l),r(Bs,s,l),t(s,vl,l),r(Es,s,l),t(s,Wl,l),t(s,Is,l),Nl=!0},p(s,[l]){const ga={};l&2&&(ga.$$scope={dirty:l,ctx:s}),J.$set(ga);const fa={};l&2&&(fa.$$scope={dirty:l,ctx:s}),b.$set(fa)},i(s){Nl||(d(T.$$.fragment,s),d(C.$$.fragment,s),d(Z.$$.fragment,s),d(x.$$.fragment,s),d(I.$$.fragment,s),d(R.$$.fragment,s),d(k.$$.fragment,s),d(A.$$.fragment,s),d(v.$$.fragment,s),d(N.$$.fragment,s),d(F.$$.fragment,s),d(V.$$.fragment,s),d(L.$$.fragment,s),d(q.$$.fragment,s),d(J.$$.fragment,s),d(D.$$.fragment,s),d(K.$$.fragment,s),d(ls.$$.fragment,s),d(ts.$$.fragment,s),d(ns.$$.fragment,s),d(Ms.$$.fragment,s),d(hs.$$.fragment,s),d(js.$$.fragment,s),d(ys.$$.fragment,s),d(gs.$$.fragment,s),d(fs.$$.fragment,s),d(b.$$.fragment,s),d(bs.$$.fragment,s),d(Us.$$.fragment,s),d($s.$$.fragment,s),d(Bs.$$.fragment,s),d(Es.$$.fragment,s),Nl=!0)},o(s){o(T.$$.fragment,s),o(C.$$.fragment,s),o(Z.$$.fragment,s),o(x.$$.fragment,s),o(I.$$.fragment,s),o(R.$$.fragment,s),o(k.$$.fragment,s),o(A.$$.fragment,s),o(v.$$.fragment,s),o(N.$$.fragment,s),o(F.$$.fragment,s),o(V.$$.fragment,s),o(L.$$.fragment,s),o(q.$$.fragment,s),o(J.$$.fragment,s),o(D.$$.fragment,s),o(K.$$.fragment,s),o(ls.$$.fragment,s),o(ts.$$.fragment,s),o(ns.$$.fragment,s),o(Ms.$$.fragment,s),o(hs.$$.fragment,s),o(js.$$.fragment,s),o(ys.$$.fragment,s),o(gs.$$.fragment,s),o(fs.$$.fragment,s),o(b.$$.fragment,s),o(bs.$$.fragment,s),o(Us.$$.fragment,s),o($s.$$.fragment,s),o(Bs.$$.fragment,s),o(Es.$$.fragment,s),Nl=!1},d(s){s&&(a(w),a(y),a(f),a(Gs),a(U),a(Rs),a(Xs),a($),a(_s),a(ks),a(B),a(Ys),a(E),a(As),a(vs),a(Ws),a(G),a(Ns),a(Qs),a(X),a(Fs),a(_),a(Ss),a(Vs),a(Y),a(Hs),a(Ls),a(zs),a(W),a(qs),a(Ps),a(Q),a(Ds),a(Ks),a(S),a(Os),a(sl),a(H),a(ll),a(al),a(z),a(tl),a(el),a(P),a(nl),a(pl),a(il),a(Ml),a(O),a(cl),a(ss),a(hl),a(rl),a(as),a(dl),a(ol),a(es),a(jl),a(ml),a(ps),a(ul),a(is),a(yl),a(wl),a(cs),a(gl),a(fl),a(rs),a(Jl),a(ds),a(bl),a(os),a(Tl),a(Ul),a(ms),a(Cl),a(us),a($l),a(Zl),a(ws),a(Bl),a(El),a(xl),a(Js),a(Il),a(Gl),a(Rl),a(Ts),a(Xl),a(_l),a(Cs),a(kl),a(Yl),a(Zs),a(Al),a(vl),a(Wl),a(Is)),a(m),j(T,s),j(C,s),j(Z,s),j(x,s),j(I,s),j(R,s),j(k,s),j(A,s),j(v,s),j(N,s),j(F,s),j(V,s),j(L,s),j(q,s),j(J,s),j(D,s),j(K,s),j(ls,s),j(ts,s),j(ns,s),j(Ms,s),j(hs,s),j(js,s),j(ys,s),j(gs,s),j(fs,s),j(b,s),j(bs,s),j(Us,s),j($s,s),j(Bs,s),j(Es,s)}}}const _a='{"title":"Create and share Model Cards","local":"create-and-share-model-cards","sections":[{"title":"Load a Model Card from the Hub","local":"load-a-model-card-from-the-hub","sections":[],"depth":2},{"title":"Create Model Cards","local":"create-model-cards","sections":[{"title":"From Text","local":"from-text","sections":[],"depth":3},{"title":"From a Jinja Template","local":"from-a-jinja-template","sections":[],"depth":3},{"title":"From the Default Template","local":"from-the-default-template","sections":[],"depth":3}],"depth":2},{"title":"Share Model Cards","local":"share-model-cards","sections":[],"depth":2},{"title":"Update metadata","local":"update-metadata","sections":[],"depth":2},{"title":"Include Evaluation Results","local":"include-evaluation-results","sections":[],"depth":2}],"depth":1}';function ka(xs){return $a(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qa extends Za{constructor(m){super(),Ba(this,m,ka,Xa,Ca,{})}}export{Qa as component};
