import{s as ay,o as ly,n as J}from"../chunks/scheduler.6062bdaf.js";import{S as oy,i as iy,g as b,s as r,r as g,m as Ue,A as ry,h as j,f as M,c,j as v,u,x as I,n as xe,k,y as l,a as T,v as m,d as h,t as d,w as f}from"../chunks/index.4bca734e.js";import{T as V}from"../chunks/Tip.b9ac1f03.js";import{D as A}from"../chunks/Docstring.ff53aa02.js";import{C as w}from"../chunks/CodeBlock.cbbddafc.js";import{E as U}from"../chunks/ExampleCodeBlock.d2834193.js";import{H as ir,E as cy}from"../chunks/index.60dd99e8.js";function py(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function gy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBYXVkaW9fb3V0cHV0JTIwJTNEJTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBZm9yJTIwaSUyQyUyMGl0ZW0lMjBpbiUyMGVudW1lcmF0ZShhdWRpb19vdXRwdXQpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oZiUyMm91dHB1dF8lN0JpJTdELmZsYWMlMjIlMkMlMjAlMjJ3YiUyMiklMjBhcyUyMGYlM0E=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function uy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function my(_){let n,o=`The <code>client.chat_completion</code> method is aliased as <code>client.chat.completions.create</code> for compatibility with OpenAI’s client.
Inputs and outputs are strictly the same and using either syntax will yield the same results.
Check out the <a href="https://huggingface.co/docs/huggingface_hub/guides/inference#openai-compatibility" rel="nofollow">Inference guide</a>
for more details about OpenAI’s compatibility.`;return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-9iksi9"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function hy(_){let n;return{c(){n=Ue("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=xe(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){T(o,n,t)},d(o){o&&M(n)}}}function dy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function fy(_){let n,o="Example using streaming:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBZm9yJTIwdG9rZW4lMjBpbiUyMGNsaWVudC5jaGF0X2NvbXBsZXRpb24obWVzc2FnZXMlMkMlMjBtYXhfdG9rZW5zJTNEMTAlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHRva2VuKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1mc18uw"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function yy(_){let n,o="Example using OpenAI’s syntax:",t,s,i;return s=new w({props:{code:"JTIzJTIwaW5zdGVhZCUyMG9mJTIwJTYwZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSU2MCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnQlMEElMEElMjMlMjBpbnN0ZWFkJTIwb2YlMjAlNjBjbGllbnQlMjAlM0QlMjBPcGVuQUkoLi4uKSU2MCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRC4uLiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QuLi4lMkMlMEEpJTBBJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDb3VudCUyMHRvJTIwMTAlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEwMjQlMkMlMEEpJTBBJTBBZm9yJTIwY2h1bmslMjBpbiUyMG91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQp",highlighted:`<span class="hljs-comment"># instead of \`from openai import OpenAI\`</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># instead of \`client = OpenAI(...)\`</span>
client = InferenceClient(
    base_url=...,
    api_key=...,
)

output = client.chat.completions.create(
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-i0a0yp"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function My(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyJTJDJTIwJTIwJTIzJTIwVXNlJTIwVG9nZXRoZXIlMjBBSSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMiUzQ3RvZ2V0aGVyX2FwaV9rZXklM0UlMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMFRvZ2V0aGVyJTIwQVBJJTIwa2V5JTIwZGlyZWN0bHklMEEpJTBBY2xpZW50LmNoYXRfY29tcGxldGlvbiglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUzRiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMGV4dHJhX2JvZHklM0QlN0IlMjJzYWZldHlfbW9kZWwlMjIlM0ElMjAlMjJNZXRhLUxsYW1hJTJGTGxhbWEtR3VhcmQtN2IlMjIlN0QlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;together&quot;</span>,  <span class="hljs-comment"># Use Together AI provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;&lt;together_api_key&gt;&quot;</span>,  <span class="hljs-comment"># Pass your Together API key directly</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}],
<span class="hljs-meta">... </span>    extra_body={<span class="hljs-string">&quot;safety_model&quot;</span>: <span class="hljs-string">&quot;Meta-Llama/Llama-Guard-7b&quot;</span>},
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function by(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnNhbWJhbm92YSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMFNhbWJhbm92YSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFjbGllbnQuY2hhdF9jb21wbGV0aW9uKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;sambanova&quot;</span>,  <span class="hljs-comment"># Use Sambanova provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function jy(_){let n,o="Example using Image + Text as input:",t,s,i;return s=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># provide a remote URL</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url =<span class="hljs-string">&quot;https://cdn.britannica.com/61/93061-050-99147DCE/Statue-of-Liberty-Island-New-York-Bay.jpg&quot;</span>
<span class="hljs-comment"># or a base64-encoded image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_path = <span class="hljs-string">&quot;/path/to/image.jpeg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(image_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    base64_image = base64.b64encode(f.read()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">f&quot;data:image/jpeg;base64,<span class="hljs-subst">{base64_image}</span>&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = client.chat.completions.create(
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: image_url},
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image in one sentence.&quot;</span>,
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>            ],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
The image depicts the iconic Statue of Liberty situated <span class="hljs-keyword">in</span> New York Harbor, New York, on a clear day.`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1e6ij9p"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function _y(_){let n,o="Example using tools:",t,s,i;return s=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1ksikbz"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Ty(_){let n,o="Example using response_format:",t,s,i;return s=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park. What did I saw and when?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>response_format = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat_completion(
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    response_format=response_format,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.content
<span class="hljs-string">&#x27;{

y&quot;: &quot;bike ride&quot;,
&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;],
_seen&quot;: 3,
n&quot;: &quot;park&quot;}&#x27;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1klcxsv"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Iy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9999666213989258</span>, start=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Jy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function wy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Uy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQi1JbnN0cnVjdCUyMiklMEFjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function xy(_){let n,o=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1igz3dx"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function Cy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_model_status(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function $y(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwcyUzQSUyRiUyRmp6Z3UwYnVlaTUudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMjIpJTBBY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function vy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>, score=<span class="hljs-number">0.9779096841812134</span>), ...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function ky(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function qy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Ay(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function Zy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Ey(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFjbGllbnQuaW1hZ2VfdG9fdGV4dCglMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Wy(_){let n,o=`This endpoint method does not return a live list of all models available for the HF Inference API service.
It searches over a cached list of models that were recently available and the list may not be up to date.
If you want to know the live status of a specific model, use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1fn4rzj"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function Ny(_){let n,o=`This endpoint method is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-ygzr4s"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function Gy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBbW9kZWxzJTIwJTNEJTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFjbGllbnQubGlzdF9kZXBsb3llZF9tb2RlbHMoJTIydGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function By(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function Vy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>)
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Qy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;Clara&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9326565265655518</span>, start=<span class="hljs-number">11</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Sy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Yy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Ry(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcXVlcnklMjAlM0QlMjAlMjJIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YlMjIlMEF0YWJsZSUyMCUzRCUyMCU3QiUyMlJlcG9zaXRvcnklMjIlM0ElMjAlNUIlMjJUcmFuc2Zvcm1lcnMlMjIlMkMlMjAlMjJEYXRhc2V0cyUyMiUyQyUyMCUyMlRva2VuaXplcnMlMjIlNUQlMkMlMjAlMjJTdGFycyUyMiUzQSUyMCU1QiUyMjM2NTQyJTIyJTJDJTIwJTIyNDUxMiUyMiUyQyUyMCUyMjM5MzQlMjIlNUQlN0QlMEFjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Xy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMkMlMEElN0QlMEFjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function zy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJIZWlnaHQlMjIlM0ElMjAlNUIlMjIxMS41MiUyMiUyQyUyMCUyMjEyLjQ4JTIyJTJDJTIwJTIyMTIuMzc3OCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDElMjIlM0ElMjAlNUIlMjIyMy4yJTIyJTJDJTIwJTIyMjQlMjIlMkMlMjAlMjIyMy45JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMiUyMiUzQSUyMCU1QiUyMjI1LjQlMjIlMkMlMjAlMjIyNi4zJTIyJTJDJTIwJTIyMjYuNSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDMlMjIlM0ElMjAlNUIlMjIzMCUyMiUyQyUyMCUyMjMxLjIlMjIlMkMlMjAlMjIzMS4xJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyU3BlY2llcyUyMiUzQSUyMCU1QiUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMldpZHRoJTIyJTNBJTIwJTVCJTIyNC4wMiUyMiUyQyUyMCUyMjQuMzA1NiUyMiUyQyUyMCUyMjQuNjk2MSUyMiU1RCUyQyUwQSU3RCUwQWNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Fy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Hy(_){let n,o=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-gq0ddh"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function Dy(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Ly(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function Oy(_){let n;return{c(){n=Ue("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=xe(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){T(o,n,t)},d(o){o&&M(n)}}}function Py(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIybG93JTIwcmVzb2x1dGlvbiUyQyUyMGJsdXJyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmJldHRlcl9hc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Ky(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMGZhbC5haSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmZhbC1haS1hcGkta2V5JTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBmYWwuYWklMjBBUEklMjBrZXklMEEpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBJTIwbWFqZXN0aWMlMjBsaW9uJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmxpb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,  <span class="hljs-comment"># Use fal.ai provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;fal-ai-api-key&quot;</span>,  <span class="hljs-comment"># Pass your fal.ai API key</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;lion.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function eM(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMHJlcGxpY2F0ZSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFpbWFnZSUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMkFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjB0aGUlMjBtb29uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBKSUwQWltYWdlLnNhdmUoJTIyYXN0cm9uYXV0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Use replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function nM(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMHJlcGxpY2F0ZSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFpbWFnZSUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMkFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjB0aGUlMjBtb29uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMGV4dHJhX2JvZHklM0QlN0IlMjJvdXRwdXRfcXVhbGl0eSUyMiUzQSUyMDEwMCU3RCUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmFzdHJvbmF1dC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Use replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
<span class="hljs-meta">... </span>    extra_body={<span class="hljs-string">&quot;output_quality&quot;</span>: <span class="hljs-number">100</span>},
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function tM(_){let n;return{c(){n=Ue("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=xe(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){T(o,n,t)},d(o){o&&M(n)}}}function sM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBYXVkaW8lMjAlM0QlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function aM(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjJ5b3VyLXJlcGxpY2F0ZS1hcGkta2V5JTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBSZXBsaWNhdGUlMjBBUEklMjBrZXklMjBkaXJlY3RseSUwQSklMEFhdWRpbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3NwZWVjaCglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTIySGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyT3V0ZUFJJTJGT3V0ZVRUUy0wLjMtNTAwTSUyMiUyQyUwQSklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;your-replicate-api-key&quot;</span>,  <span class="hljs-comment"># Pass your Replicate API key directly</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(
<span class="hljs-meta">... </span>    text=<span class="hljs-string">&quot;Hello world&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;OuteAI/OuteTTS-0.3-500M&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function lM(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjJoZl8uLi4lMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMEhGJTIwdG9rZW4lMEEpJTBBYXVkaW8lMjAlM0RjbGllbnQudGV4dF90b19zcGVlY2goJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCUyMkhlbGxvJTIwd29ybGQlMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMk91dGVBSSUyRk91dGVUVFMtMC4zLTUwME0lMjIlMkMlMEEpJTBBUGF0aCglMjJoZWxsb193b3JsZC5mbGFjJTIyKS53cml0ZV9ieXRlcyhhdWRpbyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio =client.text_to_speech(
<span class="hljs-meta">... </span>    text=<span class="hljs-string">&quot;Hello world&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;OuteAI/OuteTTS-0.3-500M&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function oM(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMHJlcGxpY2F0ZSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFhdWRpbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3NwZWVjaCglMEElMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwbmFtZSUyMGlzJTIwS29yb3JvJTJDJTIwYW4lMjBhd2Vzb21lJTIwdGV4dC10by1zcGVlY2glMjBtb2RlbC4lMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMmhleGdyYWQlMkZLb2tvcm8tODJNJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXh0cmFfYm9keSUzRCU3QiUyMnZvaWNlJTIyJTNBJTIwJTIyYWZfbmljb2xlJTIyJTdEJTJDJTBBKSUwQVBhdGgoJTIyaGVsbG8uZmxhYyUyMikud3JpdGVfYnl0ZXMoYXVkaW8p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Use replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Hello, my name is Kororo, an awesome text-to-speech model.&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;hexgrad/Kokoro-82M&quot;</span>,
<span class="hljs-meta">... </span>    extra_body={<span class="hljs-string">&quot;voice&quot;</span>: <span class="hljs-string">&quot;af_nicole&quot;</span>},
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function iM(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWx5cmljcyUyMCUzRCUyMCcnJyUwQSU1QnZlcnNlJTVEJTBBSW4lMjB0aGUlMjB0b3duJTIwd2hlcmUlMjBJJTIwd2FzJTIwYm9ybiUwQUxpdmVkJTIwYSUyMG1hbiUyMHdobyUyMHNhaWxlZCUyMHRvJTIwc2VhJTBBQW5kJTIwaGUlMjB0b2xkJTIwdXMlMjBvZiUyMGhpcyUyMGxpZmUlMEFJbiUyMHRoZSUyMGxhbmQlMjBvZiUyMHN1Ym1hcmluZXMlMEFTbyUyMHdlJTIwc2FpbGVkJTIwb24lMjB0byUyMHRoZSUyMHN1biUwQSdUaWwlMjB3ZSUyMGZvdW5kJTIwYSUyMHNlYSUyMG9mJTIwZ3JlZW4lMEFBbmQlMjB3ZSUyMGxpdmVkJTIwYmVuZWF0aCUyMHRoZSUyMHdhdmVzJTBBSW4lMjBvdXIlMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEElMEElNUJjaG9ydXMlNUQlMEFXZSUyMGFsbCUyMGxpdmUlMjBpbiUyMGElMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEFZZWxsb3clMjBzdWJtYXJpbmUlMkMlMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEFXZSUyMGFsbCUyMGxpdmUlMjBpbiUyMGElMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEFZZWxsb3clMjBzdWJtYXJpbmUlMkMlMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEEnJyclMEFnZW5yZXMlMjAlM0QlMjAlMjJwYXZhcm90dGktc3R5bGUlMjB0ZW5vciUyMHZvaWNlJTIyJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNEJTIyZmFsLWFpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJtLWEtcCUyRll1RS1zMS03Qi1hbm5lYWwtZW4tY290JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRC4uLiUyQyUwQSklMEFhdWRpbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3NwZWVjaChseXJpY3MlMkMlMjBleHRyYV9ib2R5JTNEJTdCJTIyZ2VucmVzJTIyJTNBJTIwZ2VucmVzJTdEKSUwQXdpdGglMjBvcGVuKCUyMm91dHB1dC5tcDMlMjIlMkMlMjAlMjJ3YiUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmLndyaXRlKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>lyrics = <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>[verse]
<span class="hljs-meta">... </span>In the town where I was born
<span class="hljs-meta">... </span>Lived a man who sailed to sea
<span class="hljs-meta">... </span>And he told us of his life
<span class="hljs-meta">... </span>In the land of submarines
<span class="hljs-meta">... </span>So we sailed on to the sun
<span class="hljs-meta">... </span>&#x27;Til we found a sea of green
<span class="hljs-meta">... </span>And we lived beneath the waves
<span class="hljs-meta">... </span>In our yellow submarine

<span class="hljs-meta">... </span>[chorus]
<span class="hljs-meta">... </span>We all live in a yellow submarine
<span class="hljs-meta">... </span>Yellow submarine, yellow submarine
<span class="hljs-meta">... </span>We all live in a yellow submarine
<span class="hljs-meta">... </span>Yellow submarine, yellow submarine
<span class="hljs-meta">... </span>&#x27;&#x27;&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>genres = <span class="hljs-string">&quot;pavarotti-style tenor voice&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;m-a-p/YuE-s1-7B-anneal-en-cot&quot;</span>,
<span class="hljs-meta">... </span>    api_key=...,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(lyrics, extra_body={<span class="hljs-string">&quot;genres&quot;</span>: genres})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;output.mp3&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function rM(_){let n;return{c(){n=Ue("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=xe(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){T(o,n,t)},d(o){o&&M(n)}}}function cM(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMCUyMCUyMyUyMFVzaW5nJTIwZmFsLmFpJTIwcHJvdmlkZXIlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyZmFsLWFpLWFwaS1rZXklMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMGZhbC5haSUyMEFQSSUyMGtleSUwQSklMEF2aWRlbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3ZpZGVvKCUwQSUyMCUyMCUyMCUyMCUyMkElMjBtYWplc3RpYyUyMGxpb24lMjBydW5uaW5nJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGVuY2VudCUyRkh1bnl1YW5WaWRlbyUyMiUyQyUwQSklMEF3aXRoJTIwb3BlbiglMjJsaW9uLm1wNCUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZmlsZSUzQSUwQSUyMCUyMCUyMCUyMGZpbGUud3JpdGUodmlkZW8p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,  <span class="hljs-comment"># Using fal.ai provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;fal-ai-api-key&quot;</span>,  <span class="hljs-comment"># Pass your fal.ai API key</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = client.text_to_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion running in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;tencent/HunyuanVideo&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;lion.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    file.write(video)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function pM(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzaW5nJTIwcmVwbGljYXRlJTIwcHJvdmlkZXIlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyaGZfLi4uJTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBIRiUyMHRva2VuJTBBKSUwQXZpZGVvJTIwJTNEJTIwY2xpZW50LnRleHRfdG9fdmlkZW8oJTBBJTIwJTIwJTIwJTIwJTIyQSUyMGNhdCUyMHJ1bm5pbmclMjBpbiUyMGElMjBwYXJrJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJnZW5tbyUyRm1vY2hpLTEtcHJldmlldyUyMiUyQyUwQSklMEF3aXRoJTIwb3BlbiglMjJjYXQubXA0JTIyJTJDJTIwJTIyd2IlMjIpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwZmlsZS53cml0ZSh2aWRlbyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Using replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = client.text_to_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A cat running in a park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;cat.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    file.write(video)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function gM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function uM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWNsaWVudC50cmFuc2xhdGlvbiglMjJNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiUyMiUyQyUyMG1vZGVsJTNEJTIySGVsc2lua2ktTkxQJTJGb3B1cy1tdC1lbi1mciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function mM(_){let n,o="Specifying languages:",t,s,i;return s=new w({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-mhcj6c"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function hM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function dM(_){let n,o="Example with <code>multi_label=False</code>:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGV4dCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJBJTIwbmV3JTIwbW9kZWwlMjBvZmZlcnMlMjBhbiUyMGV4cGxhbmF0aW9uJTIwZm9yJTIwaG93JTIwdGhlJTIwR2FsaWxlYW4lMjBzYXRlbGxpdGVzJTIwZm9ybWVkJTIwYXJvdW5kJTIwdGhlJTIwc29sYXIlMjBzeXN0ZW0ncyUyMiUwQSUyMCUyMCUyMCUyMCUyMmxhcmdlc3QlMjB3b3JsZC4lMjBLb25zdGFudGluJTIwQmF0eWdpbiUyMGRpZCUyMG5vdCUyMHNldCUyMG91dCUyMHRvJTIwc29sdmUlMjBvbmUlMjBvZiUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjBtb3N0JTIwcHV6emxpbmclMjIlMEElMjAlMjAlMjAlMjAlMjIlMjBteXN0ZXJpZXMlMjB3aGVuJTIwaGUlMjB3ZW50JTIwZm9yJTIwYSUyMHJ1biUyMHVwJTIwYSUyMGhpbGwlMjBpbiUyME5pY2UlMkMlMjBGcmFuY2UuJTIyJTBBKSUwQWxhYmVscyUyMCUzRCUyMCU1QiUyMnNwYWNlJTIwJTI2JTIwY29zbW9zJTIyJTJDJTIwJTIyc2NpZW50aWZpYyUyMGRpc2NvdmVyeSUyMiUyQyUyMCUyMm1pY3JvYmlvbG9neSUyMiUyQyUyMCUyMnJvYm90cyUyMiUyQyUyMCUyMmFyY2hlb2xvZ3klMjIlNUQlMEFjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=b("p"),n.innerHTML=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-90ztrp"&&(n.innerHTML=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function fM(_){let n,o="Example with <code>multi_label=True</code> and a custom <code>hypothesis_template</code>:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjB0ZXh0JTNEJTIySSUyMHJlYWxseSUyMGxpa2UlMjBvdXIlMjBkaW5uZXIlMjBhbmQlMjBJJ20lMjB2ZXJ5JTIwaGFwcHkuJTIwSSUyMGRvbid0JTIwbGlrZSUyMHRoZSUyMHdlYXRoZXIlMjB0aG91Z2guJTIyJTJDJTBBJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZWdhdGl2ZSUyMiUyQyUyMCUyMnBlc3NpbWlzdGljJTIyJTJDJTIwJTIyb3B0aW1pc3RpYyUyMiU1RCUyQyUwQSUyMCUyMCUyMG11bHRpX2xhYmVsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMGh5cG90aGVzaXNfdGVtcGxhdGUlM0QlMjJUaGlzJTIwdGV4dCUyMGlzJTIwJTdCJTdEJTIwdG93YXJkcyUyMHRoZSUyMHdlYXRoZXIlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(
<span class="hljs-meta">... </span>   text=<span class="hljs-string">&quot;I really like our dinner and I&#x27;m very happy. I don&#x27;t like the weather though.&quot;</span>,
<span class="hljs-meta">... </span>   labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;pessimistic&quot;</span>, <span class="hljs-string">&quot;optimistic&quot;</span>],
<span class="hljs-meta">... </span>   multi_label=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>   hypothesis_template=<span class="hljs-string">&quot;This text is {} towards the weather&quot;</span>
<span class="hljs-meta">... </span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;negative&#x27;</span>, score=<span class="hljs-number">0.9231801629066467</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;pessimistic&#x27;</span>, score=<span class="hljs-number">0.8760990500450134</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;optimistic&#x27;</span>, score=<span class="hljs-number">0.0008674879791215062</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.0005250611575320363</span>)
]`,wrap:!1}}),{c(){n=b("p"),n.innerHTML=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1qklg9x"&&(n.innerHTML=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function yM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function MM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function bM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF1ZGlvX291dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBYXN5bmMlMjBmb3IlMjBpJTJDJTIwaXRlbSUyMGluJTIwZW51bWVyYXRlKGF1ZGlvX291dHB1dCklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwb3BlbihmJTIyb3V0cHV0XyU3QmklN0QuZmxhYyUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZiUzQQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = <span class="hljs-keyword">await</span> client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function jM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function _M(_){let n,o=`The <code>client.chat_completion</code> method is aliased as <code>client.chat.completions.create</code> for compatibility with OpenAI’s client.
Inputs and outputs are strictly the same and using either syntax will yield the same results.
Check out the <a href="https://huggingface.co/docs/huggingface_hub/guides/inference#openai-compatibility" rel="nofollow">Inference guide</a>
for more details about OpenAI’s compatibility.`;return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-9iksi9"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function TM(_){let n;return{c(){n=Ue("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=xe(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){T(o,n,t)},d(o){o&&M(n)}}}function IM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlNUQlMEFjbGllbnQlMjAlM0QlMjBBc3luY0luZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyKSUwQWF3YWl0JTIwY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMDAp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function JM(_){let n,o="Example using streaming:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlNUQlMEFjbGllbnQlMjAlM0QlMjBBc3luY0luZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyKSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMCUyQyUyMHN0cmVhbSUzRFRydWUpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW4p",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1mc18uw"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function wM(_){let n,o="Example using OpenAI’s syntax:",t,s,i;return s=new w({props:{code:"JTIzJTIwTXVzdCUyMGJlJTIwcnVuJTIwaW4lMjBhbiUyMGFzeW5jJTIwY29udGV4dCUwQSUyMyUyMGluc3RlYWQlMjBvZiUyMCU2MGZyb20lMjBvcGVuYWklMjBpbXBvcnQlMjBPcGVuQUklNjAlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwQXN5bmNJbmZlcmVuY2VDbGllbnQlMEElMEElMjMlMjBpbnN0ZWFkJTIwb2YlMjAlNjBjbGllbnQlMjAlM0QlMjBPcGVuQUkoLi4uKSU2MCUwQWNsaWVudCUyMCUzRCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNELi4uJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRC4uLiUyQyUwQSklMEElMEFvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ291bnQlMjB0byUyMDEwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQSUwQWZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50KQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-comment"># instead of \`from openai import OpenAI\`</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

<span class="hljs-comment"># instead of \`client = OpenAI(...)\`</span>
client = AsyncInferenceClient(
    base_url=...,
    api_key=...,
)

output = <span class="hljs-keyword">await</span> client.chat.completions.create(
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-i0a0yp"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function UM(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyJTJDJTIwJTIwJTIzJTIwVXNlJTIwVG9nZXRoZXIlMjBBSSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMiUzQ3RvZ2V0aGVyX2FwaV9rZXklM0UlMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMFRvZ2V0aGVyJTIwQVBJJTIwa2V5JTIwZGlyZWN0bHklMEEpJTBBY2xpZW50LmNoYXRfY29tcGxldGlvbiglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUzRiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMGV4dHJhX2JvZHklM0QlN0IlMjJzYWZldHlfbW9kZWwlMjIlM0ElMjAlMjJNZXRhLUxsYW1hJTJGTGxhbWEtR3VhcmQtN2IlMjIlN0QlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;together&quot;</span>,  <span class="hljs-comment"># Use Together AI provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;&lt;together_api_key&gt;&quot;</span>,  <span class="hljs-comment"># Pass your Together API key directly</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}],
<span class="hljs-meta">... </span>    extra_body={<span class="hljs-string">&quot;safety_model&quot;</span>: <span class="hljs-string">&quot;Meta-Llama/Llama-Guard-7b&quot;</span>},
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function xM(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnNhbWJhbm92YSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMFNhbWJhbm92YSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFjbGllbnQuY2hhdF9jb21wbGV0aW9uKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;sambanova&quot;</span>,  <span class="hljs-comment"># Use Sambanova provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function CM(_){let n,o="Example using Image + Text as input:",t,s,i;return s=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

<span class="hljs-comment"># provide a remote URL</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url =<span class="hljs-string">&quot;https://cdn.britannica.com/61/93061-050-99147DCE/Statue-of-Liberty-Island-New-York-Bay.jpg&quot;</span>
<span class="hljs-comment"># or a base64-encoded image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_path = <span class="hljs-string">&quot;/path/to/image.jpeg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(image_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    base64_image = base64.b64encode(f.read()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">f&quot;data:image/jpeg;base64,<span class="hljs-subst">{base64_image}</span>&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = <span class="hljs-keyword">await</span> client.chat.completions.create(
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: image_url},
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image in one sentence.&quot;</span>,
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>            ],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
The image depicts the iconic Statue of Liberty situated <span class="hljs-keyword">in</span> New York Harbor, New York, on a clear day.`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1e6ij9p"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function $M(_){let n,o="Example using tools:",t,s,i;return s=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1ksikbz"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function vM(_){let n,o="Example using response_format:",t,s,i;return s=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park. What did I saw and when?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>response_format = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.chat_completion(
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    response_format=response_format,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.content
<span class="hljs-string">&#x27;{

y&quot;: &quot;bike ride&quot;,
&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;],
_seen&quot;: 3,
n&quot;: &quot;park&quot;}&#x27;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1klcxsv"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function kM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9999666213989258</span>, start=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function qM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function AM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function ZM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIpJTBBYXdhaXQlMjBjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function EM(_){let n,o=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1igz3dx"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function WM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_model_status(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function NM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIyaHR0cHMlM0ElMkYlMkZqemd1MGJ1ZWk1LnVzLWVhc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTIyKSUwQWF3YWl0JTIwY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function GM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>, score=<span class="hljs-number">0.9779096841812134</span>), ...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function BM(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function VM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function QM(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function SM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function YM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFhd2FpdCUyMGNsaWVudC5pbWFnZV90b190ZXh0KCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function RM(_){let n,o=`This endpoint method does not return a live list of all models available for the HF Inference API service.
It searches over a cached list of models that were recently available and the list may not be up to date.
If you want to know the live status of a specific model, use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1fn4rzj"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function XM(_){let n,o=`This endpoint method is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-ygzr4s"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function zM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQW1vZGVscyUyMCUzRCUyMGF3YWl0JTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFhd2FpdCUyMGNsaWVudC5saXN0X2RlcGxveWVkX21vZGVscyglMjJ0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async contextthon</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = <span class="hljs-keyword">await</span> client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function FM(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function HM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>)
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function DM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;Clara&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9326565265655518</span>, start=<span class="hljs-number">11</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function LM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function OM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function PM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXF1ZXJ5JTIwJTNEJTIwJTIySG93JTIwbWFueSUyMHN0YXJzJTIwZG9lcyUyMHRoZSUyMHRyYW5zZm9ybWVycyUyMHJlcG9zaXRvcnklMjBoYXZlJTNGJTIyJTBBdGFibGUlMjAlM0QlMjAlN0IlMjJSZXBvc2l0b3J5JTIyJTNBJTIwJTVCJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyRGF0YXNldHMlMjIlMkMlMjAlMjJUb2tlbml6ZXJzJTIyJTVEJTJDJTIwJTIyU3RhcnMlMjIlM0ElMjAlNUIlMjIzNjU0MiUyMiUyQyUyMCUyMjQ1MTIlMjIlMkMlMjAlMjIzOTM0JTIyJTVEJTdEJTBBYXdhaXQlMjBjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function KM(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZml4ZWRfYWNpZGl0eSUyMiUzQSUyMCU1QiUyMjcuNCUyMiUyQyUyMCUyMjcuOCUyMiUyQyUyMCUyMjEwLjMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ2b2xhdGlsZV9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyMC43JTIyJTJDJTIwJTIyMC44OCUyMiUyQyUyMCUyMjAuMzIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaXRyaWNfYWNpZCUyMiUzQSUyMCU1QiUyMjAlMjIlMkMlMjAlMjIwJTIyJTJDJTIwJTIyMC40NSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlc2lkdWFsX3N1Z2FyJTIyJTNBJTIwJTVCJTIyMS45JTIyJTJDJTIwJTIyMi42JTIyJTJDJTIwJTIyNi40JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hsb3JpZGVzJTIyJTNBJTIwJTVCJTIyMC4wNzYlMjIlMkMlMjAlMjIwLjA5OCUyMiUyQyUyMCUyMjAuMDczJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyZnJlZV9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjExJTIyJTJDJTIwJTIyMjUlMjIlMkMlMjAlMjI1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIydG90YWxfc3VsZnVyX2Rpb3hpZGUlMjIlM0ElMjAlNUIlMjIzNCUyMiUyQyUyMCUyMjY3JTIyJTJDJTIwJTIyMTMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJkZW5zaXR5JTIyJTNBJTIwJTVCJTIyMC45OTc4JTIyJTJDJTIwJTIyMC45OTY4JTIyJTJDJTIwJTIyMC45OTc2JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycEglMjIlM0ElMjAlNUIlMjIzLjUxJTIyJTJDJTIwJTIyMy4yJTIyJTJDJTIwJTIyMy4yMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnN1bHBoYXRlcyUyMiUzQSUyMCU1QiUyMjAuNTYlMjIlMkMlMjAlMjIwLjY4JTIyJTJDJTIwJTIyMC44MiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmFsY29ob2wlMjIlM0ElMjAlNUIlMjI5LjQlMjIlMkMlMjAlMjI5LjglMjIlMkMlMjAlMjIxMi42JTIyJTVEJTJDJTBBJTdEJTBBYXdhaXQlMjBjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function eb(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIySGVpZ2h0JTIyJTNBJTIwJTVCJTIyMTEuNTIlMjIlMkMlMjAlMjIxMi40OCUyMiUyQyUyMCUyMjEyLjM3NzglMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgxJTIyJTNBJTIwJTVCJTIyMjMuMiUyMiUyQyUyMCUyMjI0JTIyJTJDJTIwJTIyMjMuOSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDIlMjIlM0ElMjAlNUIlMjIyNS40JTIyJTJDJTIwJTIyMjYuMyUyMiUyQyUyMCUyMjI2LjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgzJTIyJTNBJTIwJTVCJTIyMzAlMjIlMkMlMjAlMjIzMS4yJTIyJTJDJTIwJTIyMzEuMSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMlNwZWNpZXMlMjIlM0ElMjAlNUIlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJXaWR0aCUyMiUzQSUyMCU1QiUyMjQuMDIlMjIlMkMlMjAlMjI0LjMwNTYlMjIlMkMlMjAlMjI0LjY5NjElMjIlNUQlMkMlMEElN0QlMEFhd2FpdCUyMGNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function nb(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function tb(_){let n,o=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-gq0ddh"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function sb(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function ab(_){let n,o="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=b("p"),n.innerHTML=o},l(t){n=j(t,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=o)},m(t,s){T(t,n,s)},p:J,d(t){t&&M(n)}}}function lb(_){let n;return{c(){n=Ue("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=xe(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){T(o,n,t)},d(o){o&&M(n)}}}function ob(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJsb3clMjByZXNvbHV0aW9uJTJDJTIwYmx1cnJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyJTJDJTBBKSUwQWltYWdlLnNhdmUoJTIyYmV0dGVyX2FzdHJvbmF1dC5wbmclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function ib(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMGZhbC5haSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmZhbC1haS1hcGkta2V5JTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBmYWwuYWklMjBBUEklMjBrZXklMEEpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBJTIwbWFqZXN0aWMlMjBsaW9uJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmxpb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,  <span class="hljs-comment"># Use fal.ai provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;fal-ai-api-key&quot;</span>,  <span class="hljs-comment"># Pass your fal.ai API key</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;lion.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function rb(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMHJlcGxpY2F0ZSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFpbWFnZSUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMkFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjB0aGUlMjBtb29uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBKSUwQWltYWdlLnNhdmUoJTIyYXN0cm9uYXV0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Use replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function cb(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMHJlcGxpY2F0ZSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFpbWFnZSUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMkFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjB0aGUlMjBtb29uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMGV4dHJhX2JvZHklM0QlN0IlMjJvdXRwdXRfcXVhbGl0eSUyMiUzQSUyMDEwMCU3RCUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmFzdHJvbmF1dC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Use replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
<span class="hljs-meta">... </span>    extra_body={<span class="hljs-string">&quot;output_quality&quot;</span>: <span class="hljs-number">100</span>},
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function pb(_){let n;return{c(){n=Ue("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=xe(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){T(o,n,t)},d(o){o&&M(n)}}}function gb(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF1ZGlvJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = <span class="hljs-keyword">await</span> client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function ub(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjJ5b3VyLXJlcGxpY2F0ZS1hcGkta2V5JTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBSZXBsaWNhdGUlMjBBUEklMjBrZXklMjBkaXJlY3RseSUwQSklMEFhdWRpbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3NwZWVjaCglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTIySGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyT3V0ZUFJJTJGT3V0ZVRUUy0wLjMtNTAwTSUyMiUyQyUwQSklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;your-replicate-api-key&quot;</span>,  <span class="hljs-comment"># Pass your Replicate API key directly</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(
<span class="hljs-meta">... </span>    text=<span class="hljs-string">&quot;Hello world&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;OuteAI/OuteTTS-0.3-500M&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function mb(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjJoZl8uLi4lMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMEhGJTIwdG9rZW4lMEEpJTBBYXVkaW8lMjAlM0RjbGllbnQudGV4dF90b19zcGVlY2goJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCUyMkhlbGxvJTIwd29ybGQlMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMk91dGVBSSUyRk91dGVUVFMtMC4zLTUwME0lMjIlMkMlMEEpJTBBUGF0aCglMjJoZWxsb193b3JsZC5mbGFjJTIyKS53cml0ZV9ieXRlcyhhdWRpbyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio =client.text_to_speech(
<span class="hljs-meta">... </span>    text=<span class="hljs-string">&quot;Hello world&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;OuteAI/OuteTTS-0.3-500M&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function hb(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMHJlcGxpY2F0ZSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFhdWRpbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3NwZWVjaCglMEElMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwbmFtZSUyMGlzJTIwS29yb3JvJTJDJTIwYW4lMjBhd2Vzb21lJTIwdGV4dC10by1zcGVlY2glMjBtb2RlbC4lMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMmhleGdyYWQlMkZLb2tvcm8tODJNJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXh0cmFfYm9keSUzRCU3QiUyMnZvaWNlJTIyJTNBJTIwJTIyYWZfbmljb2xlJTIyJTdEJTJDJTBBKSUwQVBhdGgoJTIyaGVsbG8uZmxhYyUyMikud3JpdGVfYnl0ZXMoYXVkaW8p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Use replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Hello, my name is Kororo, an awesome text-to-speech model.&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;hexgrad/Kokoro-82M&quot;</span>,
<span class="hljs-meta">... </span>    extra_body={<span class="hljs-string">&quot;voice&quot;</span>: <span class="hljs-string">&quot;af_nicole&quot;</span>},
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function db(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWx5cmljcyUyMCUzRCUyMCcnJyUwQSU1QnZlcnNlJTVEJTBBSW4lMjB0aGUlMjB0b3duJTIwd2hlcmUlMjBJJTIwd2FzJTIwYm9ybiUwQUxpdmVkJTIwYSUyMG1hbiUyMHdobyUyMHNhaWxlZCUyMHRvJTIwc2VhJTBBQW5kJTIwaGUlMjB0b2xkJTIwdXMlMjBvZiUyMGhpcyUyMGxpZmUlMEFJbiUyMHRoZSUyMGxhbmQlMjBvZiUyMHN1Ym1hcmluZXMlMEFTbyUyMHdlJTIwc2FpbGVkJTIwb24lMjB0byUyMHRoZSUyMHN1biUwQSdUaWwlMjB3ZSUyMGZvdW5kJTIwYSUyMHNlYSUyMG9mJTIwZ3JlZW4lMEFBbmQlMjB3ZSUyMGxpdmVkJTIwYmVuZWF0aCUyMHRoZSUyMHdhdmVzJTBBSW4lMjBvdXIlMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEElMEElNUJjaG9ydXMlNUQlMEFXZSUyMGFsbCUyMGxpdmUlMjBpbiUyMGElMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEFZZWxsb3clMjBzdWJtYXJpbmUlMkMlMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEFXZSUyMGFsbCUyMGxpdmUlMjBpbiUyMGElMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEFZZWxsb3clMjBzdWJtYXJpbmUlMkMlMjB5ZWxsb3clMjBzdWJtYXJpbmUlMEEnJyclMEFnZW5yZXMlMjAlM0QlMjAlMjJwYXZhcm90dGktc3R5bGUlMjB0ZW5vciUyMHZvaWNlJTIyJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNEJTIyZmFsLWFpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJtLWEtcCUyRll1RS1zMS03Qi1hbm5lYWwtZW4tY290JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRC4uLiUyQyUwQSklMEFhdWRpbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3NwZWVjaChseXJpY3MlMkMlMjBleHRyYV9ib2R5JTNEJTdCJTIyZ2VucmVzJTIyJTNBJTIwZ2VucmVzJTdEKSUwQXdpdGglMjBvcGVuKCUyMm91dHB1dC5tcDMlMjIlMkMlMjAlMjJ3YiUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmLndyaXRlKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>lyrics = <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>[verse]
<span class="hljs-meta">... </span>In the town where I was born
<span class="hljs-meta">... </span>Lived a man who sailed to sea
<span class="hljs-meta">... </span>And he told us of his life
<span class="hljs-meta">... </span>In the land of submarines
<span class="hljs-meta">... </span>So we sailed on to the sun
<span class="hljs-meta">... </span>&#x27;Til we found a sea of green
<span class="hljs-meta">... </span>And we lived beneath the waves
<span class="hljs-meta">... </span>In our yellow submarine

<span class="hljs-meta">... </span>[chorus]
<span class="hljs-meta">... </span>We all live in a yellow submarine
<span class="hljs-meta">... </span>Yellow submarine, yellow submarine
<span class="hljs-meta">... </span>We all live in a yellow submarine
<span class="hljs-meta">... </span>Yellow submarine, yellow submarine
<span class="hljs-meta">... </span>&#x27;&#x27;&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>genres = <span class="hljs-string">&quot;pavarotti-style tenor voice&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;m-a-p/YuE-s1-7B-anneal-en-cot&quot;</span>,
<span class="hljs-meta">... </span>    api_key=...,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(lyrics, extra_body={<span class="hljs-string">&quot;genres&quot;</span>: genres})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;output.mp3&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function fb(_){let n;return{c(){n=Ue("You can pass provider-specific parameters to the model by using the `extra_body` argument.")},l(o){n=xe(o,"You can pass provider-specific parameters to the model by using the `extra_body` argument.")},m(o,t){T(o,n,t)},d(o){o&&M(n)}}}function yb(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMCUyMCUyMyUyMFVzaW5nJTIwZmFsLmFpJTIwcHJvdmlkZXIlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyZmFsLWFpLWFwaS1rZXklMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMGZhbC5haSUyMEFQSSUyMGtleSUwQSklMEF2aWRlbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3ZpZGVvKCUwQSUyMCUyMCUyMCUyMCUyMkElMjBtYWplc3RpYyUyMGxpb24lMjBydW5uaW5nJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGVuY2VudCUyRkh1bnl1YW5WaWRlbyUyMiUyQyUwQSklMEF3aXRoJTIwb3BlbiglMjJsaW9uLm1wNCUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZmlsZSUzQSUwQSUyMCUyMCUyMCUyMGZpbGUud3JpdGUodmlkZW8p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,  <span class="hljs-comment"># Using fal.ai provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;fal-ai-api-key&quot;</span>,  <span class="hljs-comment"># Pass your fal.ai API key</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = client.text_to_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion running in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;tencent/HunyuanVideo&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;lion.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    file.write(video)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function Mb(_){let n,o;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzaW5nJTIwcmVwbGljYXRlJTIwcHJvdmlkZXIlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyaGZfLi4uJTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBIRiUyMHRva2VuJTBBKSUwQXZpZGVvJTIwJTNEJTIwY2xpZW50LnRleHRfdG9fdmlkZW8oJTBBJTIwJTIwJTIwJTIwJTIyQSUyMGNhdCUyMHJ1bm5pbmclMjBpbiUyMGElMjBwYXJrJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJnZW5tbyUyRm1vY2hpLTEtcHJldmlldyUyMiUyQyUwQSklMEF3aXRoJTIwb3BlbiglMjJjYXQubXA0JTIyJTJDJTIwJTIyd2IlMjIpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwZmlsZS53cml0ZSh2aWRlbyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Using replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = client.text_to_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A cat running in a park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;cat.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    file.write(video)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(t){u(n.$$.fragment,t)},m(t,s){m(n,t,s),o=!0},p:J,i(t){o||(h(n.$$.fragment,t),o=!0)},o(t){d(n.$$.fragment,t),o=!1},d(t){f(n,t)}}}function bb(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function jb(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyJTJDJTIwbW9kZWwlM0QlMjJIZWxzaW5raS1OTFAlMkZvcHVzLW10LWVuLWZyJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function _b(_){let n,o="Specifying languages:",t,s,i;return s=new w({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-mhcj6c"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Tb(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Ib(_){let n,o="Example with <code>multi_label=False</code>:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRleHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMG5ldyUyMG1vZGVsJTIwb2ZmZXJzJTIwYW4lMjBleHBsYW5hdGlvbiUyMGZvciUyMGhvdyUyMHRoZSUyMEdhbGlsZWFuJTIwc2F0ZWxsaXRlcyUyMGZvcm1lZCUyMGFyb3VuZCUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjIlMEElMjAlMjAlMjAlMjAlMjJsYXJnZXN0JTIwd29ybGQuJTIwS29uc3RhbnRpbiUyMEJhdHlnaW4lMjBkaWQlMjBub3QlMjBzZXQlMjBvdXQlMjB0byUyMHNvbHZlJTIwb25lJTIwb2YlMjB0aGUlMjBzb2xhciUyMHN5c3RlbSdzJTIwbW9zdCUyMHB1enpsaW5nJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTIwbXlzdGVyaWVzJTIwd2hlbiUyMGhlJTIwd2VudCUyMGZvciUyMGElMjBydW4lMjB1cCUyMGElMjBoaWxsJTIwaW4lMjBOaWNlJTJDJTIwRnJhbmNlLiUyMiUwQSklMEFsYWJlbHMlMjAlM0QlMjAlNUIlMjJzcGFjZSUyMCUyNiUyMGNvc21vcyUyMiUyQyUyMCUyMnNjaWVudGlmaWMlMjBkaXNjb3ZlcnklMjIlMkMlMjAlMjJtaWNyb2Jpb2xvZ3klMjIlMkMlMjAlMjJyb2JvdHMlMjIlMkMlMjAlMjJhcmNoZW9sb2d5JTIyJTVEJTBBYXdhaXQlMjBjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBYXdhaXQlMjBjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMlMkMlMjBtdWx0aV9sYWJlbCUzRFRydWUp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=b("p"),n.innerHTML=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-90ztrp"&&(n.innerHTML=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Jb(_){let n,o="Example with <code>multi_label=True</code> and a custom <code>hypothesis_template</code>:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjB0ZXh0JTNEJTIySSUyMHJlYWxseSUyMGxpa2UlMjBvdXIlMjBkaW5uZXIlMjBhbmQlMjBJJ20lMjB2ZXJ5JTIwaGFwcHkuJTIwSSUyMGRvbid0JTIwbGlrZSUyMHRoZSUyMHdlYXRoZXIlMjB0aG91Z2guJTIyJTJDJTBBJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZWdhdGl2ZSUyMiUyQyUyMCUyMnBlc3NpbWlzdGljJTIyJTJDJTIwJTIyb3B0aW1pc3RpYyUyMiU1RCUyQyUwQSUyMCUyMCUyMG11bHRpX2xhYmVsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMGh5cG90aGVzaXNfdGVtcGxhdGUlM0QlMjJUaGlzJTIwdGV4dCUyMGlzJTIwJTdCJTdEJTIwdG93YXJkcyUyMHRoZSUyMHdlYXRoZXIlMjIlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(
<span class="hljs-meta">... </span>   text=<span class="hljs-string">&quot;I really like our dinner and I&#x27;m very happy. I don&#x27;t like the weather though.&quot;</span>,
<span class="hljs-meta">... </span>   labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;pessimistic&quot;</span>, <span class="hljs-string">&quot;optimistic&quot;</span>],
<span class="hljs-meta">... </span>   multi_label=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>   hypothesis_template=<span class="hljs-string">&quot;This text is {} towards the weather&quot;</span>
<span class="hljs-meta">... </span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;negative&#x27;</span>, score=<span class="hljs-number">0.9231801629066467</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;pessimistic&#x27;</span>, score=<span class="hljs-number">0.8760990500450134</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;optimistic&#x27;</span>, score=<span class="hljs-number">0.0008674879791215062</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.0005250611575320363</span>)
]`,wrap:!1}}),{c(){n=b("p"),n.innerHTML=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1qklg9x"&&(n.innerHTML=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function wb(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function Ub(_){let n,o="Example:",t,s,i;return s=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.inference_api <span class="hljs-keyword">import</span> InferenceApi

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Mask-fill example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Question Answering example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>,
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9326569437980652</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;Clara&#x27;</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Zero-shot example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>: [<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Overriding configured task</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Text-to-image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(<span class="hljs-string">&quot;cat&quot;</span>)
&lt;PIL.PngImagePlugin.PngImageFile image (...)&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Return as raw response to parse the output yourself</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;mio/amadeus&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = inference(<span class="hljs-string">&quot;hello world&quot;</span>, raw_response=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.headers
{<span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;audio/flac&quot;</span>, ...}
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes from server</span>
<span class="hljs-string">b&#x27;(...)&#x27;</span>`,wrap:!1}}),{c(){n=b("p"),n.textContent=o,t=r(),g(s.$$.fragment)},l(e){n=j(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=o),t=c(e),u(s.$$.fragment,e)},m(e,p){T(e,n,p),T(e,t,p),m(s,e,p),i=!0},p:J,i(e){i||(h(s.$$.fragment,e),i=!0)},o(e){d(s.$$.fragment,e),i=!1},d(e){e&&(M(n),M(t)),f(s,e)}}}function xb(_){let n,o,t,s,i,e,p,nh=`Inference is the process of using a trained model to make predictions on new data. Because this process can be compute-intensive, running on a dedicated or external service can be an interesting option.<br/>
The <code>huggingface_hub</code>  library provides a unified interface to run inference across multiple services for models hosted on the Hugging Face Hub:`,cr,$a,th='<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>: a serverless solution that allows you to run accelerated inference on Hugging Face’s infrastructure for free. This service is a fast way to get started, test different models, and prototype AI products.</li> <li>Third-party providers: various serverless solution provided by external providers (Together, Sambanova, etc.). These providers offer production-ready APIs on a pay-a-you-go model. This is the fastest way to integrate AI in your products with a maintenance-free and scalable solution. Refer to the <a href="../guides/inference#supported-providers-and-tasks">Supported providers and tasks</a> section for a list of supported providers.</li> <li><a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production. Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li>',pr,va,sh=`These services can be called with the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> object. Please refer to <a href="../guides/inference">this guide</a>
for more information on how to use it.`,gr,ka,ur,C,qa,xr,ro,ah="Initialize a new Inference Client.",Cr,co,lh=`<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API, self-hosted Inference Endpoints, or third-party Inference Providers.`,$r,Fe,Aa,vr,po,oh="Perform audio classification on the provided audio content.",kr,pt,qr,He,Za,Ar,go,ih="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",Zr,gt,Er,De,Ea,Wr,uo,rh="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",Nr,ut,Gr,Z,Wa,Br,mo,ch="A method for completing conversations using a specified language model.",Vr,mt,Qr,ht,Sr,dt,Yr,ft,Rr,yt,Xr,ho,ph="Example using a third-party provider directly with extra (provider-specific) parameters. Usage will be billed on your Together AI account.",zr,Mt,Fr,fo,gh="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",Hr,bt,Dr,jt,Lr,_t,Or,Tt,Pr,Le,Na,Kr,yo,uh="Answer questions on document images.",ec,It,nc,Oe,Ga,tc,Mo,mh="Generate embeddings for a given text.",sc,Jt,ac,Pe,Ba,lc,bo,hh="Fill in a hole with a missing word (token to be precise).",oc,wt,ic,ie,Va,rc,jo,dh="Get information about the deployed endpoint.",cc,_o,fh=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,pc,Ut,gc,re,Qa,uc,To,yh="Get the status of a model hosted on the HF Inference API.",mc,xt,hc,Ct,dc,ce,Sa,fc,Io,Mh="Check the health of the deployed endpoint.",yc,Jo,bh=`Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
For Inference API, please use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">InferenceClient.get_model_status()</a> instead.`,Mc,$t,bc,Ke,Ya,jc,wo,jh="Perform image classification on the given image using the specified model.",_c,vt,Tc,pe,Ra,Ic,Uo,_h="Perform image segmentation on the given image using the specified model.",Jc,kt,wc,qt,Uc,ge,Xa,xc,xo,Th="Perform image-to-image translation using a specified model.",Cc,At,$c,Zt,vc,ue,za,kc,Co,Ih="Takes an input image and return text.",qc,$o,Jh=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,Ac,Et,Zc,O,Fa,Ec,vo,wh="List models deployed on the HF Serverless Inference API service.",Wc,ko,Uh=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,Nc,Wt,Gc,Nt,Bc,Gt,Vc,me,Ha,Qc,qo,xh="Perform object detection on the given image using the specified model.",Sc,Bt,Yc,Vt,Rc,en,Da,Xc,Ao,Ch="Retrieve the answer to a question from a given text.",zc,Qt,Fc,nn,La,Hc,Zo,$h="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",Dc,St,Lc,tn,Oa,Oc,Eo,vh="Generate a summary of a given text using a specified model.",Pc,Yt,Kc,sn,Pa,ep,Wo,kh="Retrieve the answer to a question from information given in a table.",np,Rt,tp,an,Ka,sp,No,qh="Classifying a target category (a group) based on a set of attributes.",ap,Xt,lp,ln,el,op,Go,Ah="Predicting a numerical target value given a set of attributes/features in a table.",ip,zt,rp,on,nl,cp,Bo,Zh="Perform text classification (e.g. sentiment-analysis) on the given text.",pp,Ft,gp,he,tl,up,Vo,Eh="Given a prompt, generate the following text.",mp,Ht,hp,Dt,dp,Y,sl,fp,Qo,Wh="Generate an image based on a given text using a specified model.",yp,Lt,Mp,Ot,bp,Pt,jp,Kt,_p,So,Nh="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",Tp,es,Ip,Yo,Gh="Example using Replicate provider with extra parameters",Jp,ns,wp,G,al,Up,Ro,Bh="Synthesize an audio of a voice pronouncing a given text.",xp,ts,Cp,ss,$p,Xo,Vh="Example using a third-party provider directly. Usage will be billed on your Replicate account.",vp,as,kp,zo,Qh="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",qp,ls,Ap,os,Zp,Fo,Sh="Example music-gen using “YuE-s1-7B-anneal-en-cot” on fal.ai",Ep,is,Wp,F,ll,Np,Ho,Yh="Generate a video based on a given text.",Gp,rs,Bp,Do,Rh="Example:",Vp,Lo,Xh="Example using a third-party provider directly. Usage will be billed on your fal.ai account.",Qp,cs,Sp,Oo,zh="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",Yp,ps,Rp,rn,ol,Xp,Po,Fh=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,zp,gs,Fp,te,il,Hp,Ko,Hh="Convert text from one language to another.",Dp,ei,Dh=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.`,Lp,us,Op,ms,Pp,cn,rl,Kp,ni,Lh="Answering open-ended questions based on an image.",eg,hs,ng,de,cl,tg,ti,Oh="Provide as input a text and a set of candidate labels to classify the input text.",sg,ds,ag,fs,lg,pn,pl,og,si,Ph="Provide input image and text labels to predict text labels for the image.",ig,ys,mr,gl,hr,ul,Kh=`An async version of the client is also provided, based on <code>asyncio</code> and <code>aiohttp</code>.
To use it, you can either install <code>aiohttp</code> directly or use the <code>[inference]</code> extra:`,dr,ml,fr,x,hl,rg,ai,ed="Initialize a new Inference Client.",cg,li,nd=`<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API, self-hosted Inference Endpoints, or third-party Inference Providers.`,pg,gn,dl,gg,oi,td="Perform audio classification on the provided audio content.",ug,Ms,mg,un,fl,hg,ii,sd="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",dg,bs,fg,mn,yl,yg,ri,ad="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",Mg,js,bg,E,Ml,jg,ci,ld="A method for completing conversations using a specified language model.",_g,_s,Tg,Ts,Ig,Is,Jg,Js,wg,ws,Ug,pi,od="Example using a third-party provider directly with extra (provider-specific) parameters. Usage will be billed on your Together AI account.",xg,Us,Cg,gi,id="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",$g,xs,vg,Cs,kg,$s,qg,vs,Ag,fe,bl,Zg,ui,rd="Close all open sessions.",Eg,mi,cd=`By default, ‘aiohttp.ClientSession’ objects are closed automatically when a call is completed. However, if you
are streaming data from the server and you stop before the stream is complete, you must call this method to
close the session properly.`,Wg,hi,pd="Another possibility is to use an async context (e.g. <code>async with AsyncInferenceClient(): ...</code>).",Ng,hn,jl,Gg,di,gd="Answer questions on document images.",Bg,ks,Vg,dn,_l,Qg,fi,ud="Generate embeddings for a given text.",Sg,qs,Yg,fn,Tl,Rg,yi,md="Fill in a hole with a missing word (token to be precise).",Xg,As,zg,ye,Il,Fg,Mi,hd="Get information about the deployed endpoint.",Hg,bi,dd=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,Dg,Zs,Lg,Me,Jl,Og,ji,fd="Get the status of a model hosted on the HF Inference API.",Pg,Es,Kg,Ws,eu,be,wl,nu,_i,yd="Check the health of the deployed endpoint.",tu,Ti,Md=`Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
For Inference API, please use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">InferenceClient.get_model_status()</a> instead.`,su,Ns,au,yn,Ul,lu,Ii,bd="Perform image classification on the given image using the specified model.",ou,Gs,iu,je,xl,ru,Ji,jd="Perform image segmentation on the given image using the specified model.",cu,Bs,pu,Vs,gu,_e,Cl,uu,wi,_d="Perform image-to-image translation using a specified model.",mu,Qs,hu,Ss,du,Te,$l,fu,Ui,Td="Takes an input image and return text.",yu,xi,Id=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,Mu,Ys,bu,P,vl,ju,Ci,Jd="List models deployed on the HF Serverless Inference API service.",_u,$i,wd=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,Tu,Rs,Iu,Xs,Ju,zs,wu,Ie,kl,Uu,vi,Ud="Perform object detection on the given image using the specified model.",xu,Fs,Cu,Hs,$u,Mn,ql,vu,ki,xd="Retrieve the answer to a question from a given text.",ku,Ds,qu,bn,Al,Au,qi,Cd="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",Zu,Ls,Eu,jn,Zl,Wu,Ai,$d="Generate a summary of a given text using a specified model.",Nu,Os,Gu,_n,El,Bu,Zi,vd="Retrieve the answer to a question from information given in a table.",Vu,Ps,Qu,Tn,Wl,Su,Ei,kd="Classifying a target category (a group) based on a set of attributes.",Yu,Ks,Ru,In,Nl,Xu,Wi,qd="Predicting a numerical target value given a set of attributes/features in a table.",zu,ea,Fu,Jn,Gl,Hu,Ni,Ad="Perform text classification (e.g. sentiment-analysis) on the given text.",Du,na,Lu,Je,Bl,Ou,Gi,Zd="Given a prompt, generate the following text.",Pu,ta,Ku,sa,em,R,Vl,nm,Bi,Ed="Generate an image based on a given text using a specified model.",tm,aa,sm,la,am,oa,lm,ia,om,Vi,Wd="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",im,ra,rm,Qi,Nd="Example using Replicate provider with extra parameters",cm,ca,pm,B,Ql,gm,Si,Gd="Synthesize an audio of a voice pronouncing a given text.",um,pa,mm,ga,hm,Yi,Bd="Example using a third-party provider directly. Usage will be billed on your Replicate account.",dm,ua,fm,Ri,Vd="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",ym,ma,Mm,ha,bm,Xi,Qd="Example music-gen using “YuE-s1-7B-anneal-en-cot” on fal.ai",jm,da,_m,H,Sl,Tm,zi,Sd="Generate a video based on a given text.",Im,fa,Jm,Fi,Yd="Example:",wm,Hi,Rd="Example using a third-party provider directly. Usage will be billed on your fal.ai account.",Um,ya,xm,Di,Xd="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",Cm,Ma,$m,wn,Yl,vm,Li,zd=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,km,ba,qm,se,Rl,Am,Oi,Fd="Convert text from one language to another.",Zm,Pi,Hd=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.`,Em,ja,Wm,_a,Nm,Un,Xl,Gm,Ki,Dd="Answering open-ended questions based on an image.",Bm,Ta,Vm,we,zl,Qm,er,Ld="Provide as input a text and a set of candidate labels to classify the input text.",Sm,Ia,Ym,Ja,Rm,xn,Fl,Xm,nr,Od="Provide input image and text labels to predict text labels for the image.",zm,wa,yr,Hl,Mr,Cn,Dl,Fm,tr,Pd="Error raised when a model is unavailable or the request times out.",br,Ll,jr,$n,Ol,Hm,sr,Kd="This Dataclass represents the model status in the HF Inference API.",_r,Pl,Tr,Kl,ef=`<code>InferenceAPI</code> is the legacy way to call the Inference API. The interface is more simplistic and requires knowing
the input parameters and output format for each task. It also lacks the ability to connect to other services like
Inference Endpoints or AWS SageMaker. <code>InferenceAPI</code> will soon be deprecated so we recommend using <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
whenever possible. Check out <a href="../guides/inference#legacy-inferenceapi-client">this guide</a> to learn how to switch from
<code>InferenceAPI</code> to <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> in your scripts.`,Ir,K,eo,Dm,ar,nf="Client to configure requests and make calls to the HuggingFace Inference API.",Lm,Ua,Om,xa,no,Pm,lr,tf="Inits headers and API call information.",Km,Ca,to,eh,or,sf="Make a call to the Inference API.",Jr,so,wr,rr,Ur;return i=new ir({props:{title:"Inference",local:"inference",headingTag:"h1"}}),ka=new ir({props:{title:"Inference Client",local:"huggingface_hub.InferenceClient",headingTag:"h2"}}),qa=new A({props:{name:"class huggingface_hub.InferenceClient",anchor:"huggingface_hub.InferenceClient",parameters:[{name:"model",val:": typing.Optional[str] = None"},{name:"provider",val:": typing.Union[typing.Literal['black-forest-labs', 'cerebras', 'cohere', 'fal-ai', 'featherless-ai', 'fireworks-ai', 'hf-inference', 'hyperbolic', 'nebius', 'novita', 'nscale', 'openai', 'replicate', 'sambanova', 'together'], typing.Literal['auto'], NoneType] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"timeout",val:": typing.Optional[float] = None"},{name:"headers",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"cookies",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"proxies",val:": typing.Optional[typing.Any] = None"},{name:"bill_to",val:": typing.Optional[str] = None"},{name:"base_url",val:": typing.Optional[str] = None"},{name:"api_key",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>meta-llama/Meta-Llama-3-8B-Instruct</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.
Note: for better compatibility with OpenAI&#x2019;s client, <code>model</code> has been aliased as <code>base_url</code>. Those 2
arguments are mutually exclusive. If using <code>base_url</code> for chat completion, the <code>/chat/completions</code> suffix
path will be appended to the base URL (see the <a href="https://huggingface.co/docs/text-generation-inference/en/messages_api" rel="nofollow">TGI Messages API</a>
documentation for details). When passing a URL as <code>model</code>, the client will not append any suffix path to it.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.provider",description:"<strong>provider</strong> (<code>str</code>, <em>optional</em>) &#x2014;\nName of the provider to use for inference. Can be <code>&quot;black-forest-labs&quot;</code>, <code>&quot;cerebras&quot;</code>, <code>&quot;cohere&quot;</code>, <code>&quot;fal-ai&quot;</code>, <code>&quot;featherless-ai&quot;</code>, <code>&quot;fireworks-ai&quot;</code>, <code>&quot;hf-inference&quot;</code>, <code>&quot;hyperbolic&quot;</code>, <code>&quot;nebius&quot;</code>, <code>&quot;novita&quot;</code>, <code>&quot;nscale&quot;</code>, <code>&quot;openai&quot;</code>, <code>&quot;replicate&quot;</code>, &#x201C;sambanova&#x201D;<code>or</code>&#x201C;together&#x201D;<code>. Defaults to &quot;auto&quot; i.e. the first of the providers available for the model, sorted by the user&apos;s order in https://hf.co/settings/inference-providers. If model is a URL or </code>base_url<code>is passed, then</code>provider` is not used.",name:"provider"},{anchor:"huggingface_hub.InferenceClient.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Note: for better compatibility with OpenAI&#x2019;s client, <code>token</code> has been aliased as <code>api_key</code>. Those 2
arguments are mutually exclusive and have the exact same behavior.`,name:"token"},{anchor:"huggingface_hub.InferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.InferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.InferenceClient.bill_to",description:`<strong>bill_to</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The billing account to use for the requests. By default the requests are billed on the user&#x2019;s account.
Requests can only be billed to an organization the user is a member of, and which has subscribed to Enterprise Hub.`,name:"bill_to"},{anchor:"huggingface_hub.InferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"},{anchor:"huggingface_hub.InferenceClient.proxies",description:`<strong>proxies</strong> (<code>Any</code>, <code>optional</code>) &#x2014;
Proxies to use for the request.`,name:"proxies"},{anchor:"huggingface_hub.InferenceClient.base_url",description:`<strong>base_url</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Base URL to run inference. This is a duplicated argument from <code>model</code> to make <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>model</code> is set. Defaults to None.`,name:"base_url"},{anchor:"huggingface_hub.InferenceClient.api_key",description:`<strong>api_key</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Token to use for authentication. This is a duplicated argument from <code>token</code> to make <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>token</code> is set. Defaults to None.`,name:"api_key"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L120"}}),Aa=new A({props:{name:"audio_classification",anchor:"huggingface_hub.InferenceClient.audio_classification",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('AudioClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.audio_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.audio_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;AudioClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L290",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),pt=new U({props:{anchor:"huggingface_hub.InferenceClient.audio_classification.example",$$slots:{default:[py]},$$scope:{ctx:_}}}),Za=new A({props:{name:"audio_to_audio",anchor:"huggingface_hub.InferenceClient.audio_to_audio",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L347",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),gt=new U({props:{anchor:"huggingface_hub.InferenceClient.audio_to_audio.example",$$slots:{default:[gy]},$$scope:{ctx:_}}}),Ea=new A({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.extra_body",description:`<strong>extra_body</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L399",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ut=new U({props:{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.example",$$slots:{default:[uy]},$$scope:{ctx:_}}}),Wa=new A({props:{name:"chat_completion",anchor:"huggingface_hub.InferenceClient.chat_completion",parameters:[{name:"messages",val:": typing.List[typing.Union[typing.Dict, huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputMessage]]"},{name:"model",val:": typing.Optional[str] = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"logit_bias",val:": typing.Optional[typing.List[float]] = None"},{name:"logprobs",val:": typing.Optional[bool] = None"},{name:"max_tokens",val:": typing.Optional[int] = None"},{name:"n",val:": typing.Optional[int] = None"},{name:"presence_penalty",val:": typing.Optional[float] = None"},{name:"response_format",val:": typing.Union[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputResponseFormatText, huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputResponseFormatJSONSchema, huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputResponseFormatJSONObject, NoneType] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stream_options",val:": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputStreamOptions] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"tool_choice",val:": typing.Union[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputToolChoiceClass, ForwardRef('ChatCompletionInputToolChoiceEnum'), NoneType] = None"},{name:"tool_prompt",val:": typing.Optional[str] = None"},{name:"tools",val:": typing.Optional[typing.List[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputTool]] = None"},{name:"top_logprobs",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List of <a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputMessage">ChatCompletionInputMessage</a>) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.InferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.
If <code>model</code> is a model ID, it is passed to the server as the <code>model</code> parameter. If you want to define a
custom URL while setting <code>model</code> in the request payload, you must set <code>base_url</code> when initializing <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Adjusts the likelihood of specific tokens appearing in the generated output.`,name:"logit_bias"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 100.`,name:"max_tokens"},{anchor:"huggingface_hub.InferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of completions to generate for each prompt.`,name:"n"},{anchor:"huggingface_hub.InferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.response_format",description:`<strong>response_format</strong> (<code>ChatCompletionInputGrammarType()</code>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"response_format"},{anchor:"huggingface_hub.InferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stream_options",description:`<strong>stream_options</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputStreamOptions">ChatCompletionInputStreamOptions</a>, <em>optional</em>) &#x2014;
Options for streaming completions.`,name:"stream_options"},{anchor:"huggingface_hub.InferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolChoiceClass">ChatCompletionInputToolChoiceClass</a> or <code>ChatCompletionInputToolChoiceEnum()</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputTool">ChatCompletionInputTool</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"},{anchor:"huggingface_hub.InferenceClient.chat_completion.extra_body",description:`<strong>extra_body</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L525",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),mt=new V({props:{$$slots:{default:[my]},$$scope:{ctx:_}}}),ht=new V({props:{$$slots:{default:[hy]},$$scope:{ctx:_}}}),dt=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example",$$slots:{default:[dy]},$$scope:{ctx:_}}}),ft=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-2",$$slots:{default:[fy]},$$scope:{ctx:_}}}),yt=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-3",$$slots:{default:[yy]},$$scope:{ctx:_}}}),Mt=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-4",$$slots:{default:[My]},$$scope:{ctx:_}}}),bt=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-5",$$slots:{default:[by]},$$scope:{ctx:_}}}),jt=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-6",$$slots:{default:[jy]},$$scope:{ctx:_}}}),_t=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-7",$$slots:{default:[_y]},$$scope:{ctx:_}}}),Tt=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-8",$$slots:{default:[Ty]},$$scope:{ctx:_}}}),Na=new A({props:{name:"document_question_answering",anchor:"huggingface_hub.InferenceClient.document_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"lang",val:": typing.Optional[str] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"word_boxes",val:": typing.Optional[typing.List[typing.Union[typing.List[float], str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the words in the document are too long to fit with the question for the model, it will be split in
several chunks with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.lang",description:`<strong>lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Language to use while running OCR. Defaults to english.`,name:"lang"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using doc_stride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Can return less than top_k
answers if there are not enough options available within the context.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.word_boxes",description:`<strong>word_boxes</strong> (<code>List[Union[List[float], str</code>, <em>optional</em>) &#x2014;
A list of words and bounding boxes (normalized 0-&gt;1000). If provided, the inference will skip the OCR
step and use the provided bounding boxes instead.`,name:"word_boxes"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L931",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),It=new U({props:{anchor:"huggingface_hub.InferenceClient.document_question_answering.example",$$slots:{default:[Iy]},$$scope:{ctx:_}}}),Ga=new A({props:{name:"feature_extraction",anchor:"huggingface_hub.InferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": typing.Optional[bool] = None"},{name:"prompt_name",val:": typing.Optional[str] = None"},{name:"truncate",val:": typing.Optional[bool] = None"},{name:"truncation_direction",val:": typing.Optional[typing.Literal['Left', 'Right']] = None"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the feature extraction task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended feature extraction model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1018",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>HTTPError</code></p>
`}}),Jt=new U({props:{anchor:"huggingface_hub.InferenceClient.feature_extraction.example",$$slots:{default:[Jy]},$$scope:{ctx:_}}}),Ba=new A({props:{name:"fill_mask",anchor:"huggingface_hub.InferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"targets",val:": typing.Optional[typing.List[str]] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.InferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.fill_mask.targets",description:`<strong>targets</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
When passed, the model will limit the scores to the passed targets instead of looking up in the whole
vocabulary. If the provided targets are not in the model vocab, they will be tokenized and the first
resulting token will be used (with a warning, and that might be slower).`,name:"targets"},{anchor:"huggingface_hub.InferenceClient.fill_mask.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When passed, overrides the number of predictions to return.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1091",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),wt=new U({props:{anchor:"huggingface_hub.InferenceClient.fill_mask.example",$$slots:{default:[wy]},$$scope:{ctx:_}}}),Va=new A({props:{name:"get_endpoint_info",anchor:"huggingface_hub.InferenceClient.get_endpoint_info",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3294",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Ut=new U({props:{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.example",$$slots:{default:[Uy]},$$scope:{ctx:_}}}),Qa=new A({props:{name:"get_model_status",anchor:"huggingface_hub.InferenceClient.get_model_status",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only HF Inference API service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3389",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),xt=new V({props:{$$slots:{default:[xy]},$$scope:{ctx:_}}}),Ct=new U({props:{anchor:"huggingface_hub.InferenceClient.get_model_status.example",$$slots:{default:[Cy]},$$scope:{ctx:_}}}),Sa=new A({props:{name:"health_check",anchor:"huggingface_hub.InferenceClient.health_check",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3352",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),$t=new U({props:{anchor:"huggingface_hub.InferenceClient.health_check.example",$$slots:{default:[$y]},$$scope:{ctx:_}}}),Ya=new A({props:{name:"image_classification",anchor:"huggingface_hub.InferenceClient.image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('ImageClassificationOutputTransform')] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.image_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;ImageClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"},{anchor:"huggingface_hub.InferenceClient.image_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1147",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),vt=new U({props:{anchor:"huggingface_hub.InferenceClient.image_classification.example",$$slots:{default:[vy]},$$scope:{ctx:_}}}),Ra=new A({props:{name:"image_segmentation",anchor:"huggingface_hub.InferenceClient.image_segmentation",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"mask_threshold",val:": typing.Optional[float] = None"},{name:"overlap_mask_area_threshold",val:": typing.Optional[float] = None"},{name:"subtask",val:": typing.Optional[ForwardRef('ImageSegmentationSubtask')] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Mask overlap threshold to eliminate small, disconnected segments.`,name:"overlap_mask_area_threshold"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.subtask",description:`<strong>subtask</strong> (<code>&quot;ImageSegmentationSubtask&quot;</code>, <em>optional</em>) &#x2014;
Segmentation task to be performed, depending on model capabilities.`,name:"subtask"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Probability threshold to filter out predicted masks.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1197",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),kt=new V({props:{warning:!0,$$slots:{default:[ky]},$$scope:{ctx:_}}}),qt=new U({props:{anchor:"huggingface_hub.InferenceClient.image_segmentation.example",$$slots:{default:[qy]},$$scope:{ctx:_}}}),Xa=new A({props:{name:"image_to_image",anchor:"huggingface_hub.InferenceClient.image_to_image",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"target_size",val:": typing.Optional[huggingface_hub.inference._generated.types.image_to_image.ImageToImageTargetSize] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
One prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
For diffusion models. The number of denoising steps. More denoising steps usually lead to a higher
quality image at the expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
For diffusion models. A higher guidance scale value encourages the model to generate images closely
linked to the text prompt at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.image_to_image.target_size",description:`<strong>target_size</strong> (<code>ImageToImageTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output image.`,name:"target_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1267",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),At=new V({props:{warning:!0,$$slots:{default:[Ay]},$$scope:{ctx:_}}}),Zt=new U({props:{anchor:"huggingface_hub.InferenceClient.image_to_image.example",$$slots:{default:[Zy]},$$scope:{ctx:_}}}),za=new A({props:{name:"image_to_text",anchor:"huggingface_hub.InferenceClient.image_to_text",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1343",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Et=new U({props:{anchor:"huggingface_hub.InferenceClient.image_to_text.example",$$slots:{default:[Ey]},$$scope:{ctx:_}}}),Fa=new A({props:{name:"list_deployed_models",anchor:"huggingface_hub.InferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": typing.Union[NoneType, str, typing.Literal['all'], typing.List[str]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3199",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),Wt=new V({props:{warning:!0,$$slots:{default:[Wy]},$$scope:{ctx:_}}}),Nt=new V({props:{$$slots:{default:[Ny]},$$scope:{ctx:_}}}),Gt=new U({props:{anchor:"huggingface_hub.InferenceClient.list_deployed_models.example",$$slots:{default:[Gy]},$$scope:{ctx:_}}}),Ha=new A({props:{name:"object_detection",anchor:"huggingface_hub.InferenceClient.object_detection",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The probability necessary to make a prediction.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1389",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),Bt=new V({props:{warning:!0,$$slots:{default:[By]},$$scope:{ctx:_}}}),Vt=new U({props:{anchor:"huggingface_hub.InferenceClient.object_detection.example",$$slots:{default:[Vy]},$$scope:{ctx:_}}}),Da=new A({props:{name:"question_answering",anchor:"huggingface_hub.InferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"align_to_words",val:": typing.Optional[bool] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.InferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.question_answering.align_to_words",description:`<strong>align_to_words</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Attempts to align the answer to real words. Improves quality on space separated languages. Might hurt
on non-space-separated languages (like Japanese or Chinese)`,name:"align_to_words"},{anchor:"huggingface_hub.InferenceClient.question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the context is too long to fit with the question for the model, it will be split in several chunks
with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.InferenceClient.question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer.`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.InferenceClient.question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.InferenceClient.question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.InferenceClient.question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using docStride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.InferenceClient.question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1440",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>When top_k is 1 or not provided, it returns a single <code>QuestionAnsweringOutputElement</code>.
When top_k is greater than 1, it returns a list of <code>QuestionAnsweringOutputElement</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Union[<code>QuestionAnsweringOutputElement</code>, List<a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a>]</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Qt=new U({props:{anchor:"huggingface_hub.InferenceClient.question_answering.example",$$slots:{default:[Qy]},$$scope:{ctx:_}}}),La=new A({props:{name:"sentence_similarity",anchor:"huggingface_hub.InferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": typing.List[str]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the sentence similarity task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended sentence similarity model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1525",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),St=new U({props:{anchor:"huggingface_hub.InferenceClient.sentence_similarity.example",$$slots:{default:[Sy]},$$scope:{ctx:_}}}),Oa=new A({props:{name:"summarization",anchor:"huggingface_hub.InferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('SummarizationTruncationStrategy')] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for summarization will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.summarization.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.InferenceClient.summarization.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"},{anchor:"huggingface_hub.InferenceClient.summarization.truncation",description:`<strong>truncation</strong> (<code>&quot;SummarizationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1578",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Yt=new U({props:{anchor:"huggingface_hub.InferenceClient.summarization.example",$$slots:{default:[Yy]},$$scope:{ctx:_}}}),Pa=new A({props:{name:"table_question_answering",anchor:"huggingface_hub.InferenceClient.table_question_answering",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"query",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"padding",val:": typing.Optional[ForwardRef('Padding')] = None"},{name:"sequential",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.padding",description:`<strong>padding</strong> (<code>&quot;Padding&quot;</code>, <em>optional</em>) &#x2014;
Activates and controls padding.`,name:"padding"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.sequential",description:`<strong>sequential</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to do inference sequentially or as a batch. Batching is faster, but models like SQA require the
inference to be done sequentially to extract relations within sequences, given their conversational
nature.`,name:"sequential"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activates and controls truncation.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1636",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Rt=new U({props:{anchor:"huggingface_hub.InferenceClient.table_question_answering.example",$$slots:{default:[Ry]},$$scope:{ctx:_}}}),Ka=new A({props:{name:"tabular_classification",anchor:"huggingface_hub.InferenceClient.tabular_classification",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1699",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Xt=new U({props:{anchor:"huggingface_hub.InferenceClient.tabular_classification.example",$$slots:{default:[Xy]},$$scope:{ctx:_}}}),el=new A({props:{name:"tabular_regression",anchor:"huggingface_hub.InferenceClient.tabular_regression",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1754",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),zt=new U({props:{anchor:"huggingface_hub.InferenceClient.tabular_regression.example",$$slots:{default:[zy]},$$scope:{ctx:_}}}),nl=new A({props:{name:"text_classification",anchor:"huggingface_hub.InferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('TextClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;TextClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1804",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ft=new U({props:{anchor:"huggingface_hub.InferenceClient.text_classification.example",$$slots:{default:[Fy]},$$scope:{ctx:_}}}),tl=new A({props:{name:"text_generation",anchor:"huggingface_hub.InferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": typing.Optional[str] = None"},{name:"adapter_id",val:": typing.Optional[str] = None"},{name:"best_of",val:": typing.Optional[int] = None"},{name:"decoder_input_details",val:": typing.Optional[bool] = None"},{name:"do_sample",val:": typing.Optional[bool] = False"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"grammar",val:": typing.Optional[huggingface_hub.inference._generated.types.text_generation.TextGenerationInputGrammarType] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"repetition_penalty",val:": typing.Optional[float] = None"},{name:"return_full_text",val:": typing.Optional[bool] = False"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stop_sequences",val:": typing.Optional[typing.List[str]] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_n_tokens",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"truncate",val:": typing.Optional[int] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"watermark",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.InferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_generation.adapter_id",description:`<strong>adapter_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Lora adapter id.`,name:"adapter_id"},{anchor:"huggingface_hub.InferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.InferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.InferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.InferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.InferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens. Defaults to 100.`,name:"max_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.InferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.text_generation.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop</code> is generated.`,name:"stop"},{anchor:"huggingface_hub.InferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Deprecated argument. Use <code>stop</code> instead.`,name:"stop_sequences"},{anchor:"huggingface_hub.InferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.InferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.watermark",description:'<strong>watermark</strong> (<code>bool</code>, *optional`) &#x2014;\nWatermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>',name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2012",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ht=new V({props:{$$slots:{default:[Hy]},$$scope:{ctx:_}}}),Dt=new U({props:{anchor:"huggingface_hub.InferenceClient.text_generation.example",$$slots:{default:[Dy]},$$scope:{ctx:_}}}),sl=new A({props:{name:"text_to_image",anchor:"huggingface_hub.InferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"scheduler",val:": typing.Optional[str] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
One prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in pixels of the output image`,name:"height"},{anchor:"huggingface_hub.InferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The width in pixels of the output image`,name:"width"},{anchor:"huggingface_hub.InferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
prompt, but values too high may cause saturation and other artifacts.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-image model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_to_image.scheduler",description:`<strong>scheduler</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Override the scheduler with a compatible one.`,name:"scheduler"},{anchor:"huggingface_hub.InferenceClient.text_to_image.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.text_to_image.extra_body",description:`<strong>extra_body</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2354",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Lt=new V({props:{warning:!0,$$slots:{default:[Ly]},$$scope:{ctx:_}}}),Ot=new V({props:{$$slots:{default:[Oy]},$$scope:{ctx:_}}}),Pt=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example",$$slots:{default:[Py]},$$scope:{ctx:_}}}),Kt=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example-2",$$slots:{default:[Ky]},$$scope:{ctx:_}}}),es=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example-3",$$slots:{default:[eM]},$$scope:{ctx:_}}}),ns=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example-4",$$slots:{default:[nM]},$$scope:{ctx:_}}}),al=new A({props:{name:"text_to_speech",anchor:"huggingface_hub.InferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"do_sample",val:": typing.Optional[bool] = None"},{name:"early_stopping",val:": typing.Union[bool, ForwardRef('TextToSpeechEarlyStoppingEnum'), NoneType] = None"},{name:"epsilon_cutoff",val:": typing.Optional[float] = None"},{name:"eta_cutoff",val:": typing.Optional[float] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"min_length",val:": typing.Optional[int] = None"},{name:"min_new_tokens",val:": typing.Optional[int] = None"},{name:"num_beam_groups",val:": typing.Optional[int] = None"},{name:"num_beams",val:": typing.Optional[int] = None"},{name:"penalty_alpha",val:": typing.Optional[float] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-speech model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use sampling instead of greedy decoding when generating new tokens.`,name:"do_sample"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.early_stopping",description:`<strong>early_stopping</strong> (<code>Union[bool, &quot;TextToSpeechEarlyStoppingEnum&quot;]</code>, <em>optional</em>) &#x2014;
Controls the stopping condition for beam-based methods.`,name:"early_stopping"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
epsilon_cutoff will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on
the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly
between 0 and 1, a token is only considered if it is greater than either eta_cutoff or sqrt(eta_cutoff)<ul>
<li>exp(-entropy(softmax(next_token_logits))). The latter term is intuitively the expected next token
probability, scaled by sqrt(eta_cutoff). In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.</li>
</ul>`,name:"eta_cutoff"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length (in tokens) of the generated text, including the input.`,name:"max_length"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of tokens to generate. Takes precedence over max_length.`,name:"max_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum length (in tokens) of the generated text, including the input.`,name:"min_length"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of tokens to generate. Takes precedence over min_length.`,name:"min_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of groups to divide num_beams into in order to ensure diversity among different groups of beams.
See <a href="https://hf.co/papers/1610.02424" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of beams to use for beam search.`,name:"num_beams"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value balances the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
top_p or higher are kept for generation.`,name:"top_p"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is
to the expected conditional probability of predicting a random token next, given the partial text
already generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with
probabilities that add up to typical_p or higher are kept for generation. See <a href="https://hf.co/papers/2202.00666" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the model should use the past last key/values attentions to speed up decoding`,name:"use_cache"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.extra_body",description:`<strong>extra_body</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2594",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ts=new V({props:{$$slots:{default:[tM]},$$scope:{ctx:_}}}),ss=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example",$$slots:{default:[sM]},$$scope:{ctx:_}}}),as=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example-2",$$slots:{default:[aM]},$$scope:{ctx:_}}}),ls=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example-3",$$slots:{default:[lM]},$$scope:{ctx:_}}}),os=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example-4",$$slots:{default:[oM]},$$scope:{ctx:_}}}),is=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example-5",$$slots:{default:[iM]},$$scope:{ctx:_}}}),ll=new A({props:{name:"text_to_video",anchor:"huggingface_hub.InferenceClient.text_to_video",parameters:[{name:"prompt",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"negative_prompt",val:": typing.Optional[typing.List[str]] = None"},{name:"num_frames",val:": typing.Optional[float] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_video.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate a video from.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_video.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-video model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_to_video.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A higher guidance scale value encourages the model to generate videos closely linked to the text
prompt, but values too high may cause saturation and other artifacts.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.text_to_video.negative_prompt",description:`<strong>negative_prompt</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
One or several prompt to guide what NOT to include in video generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_video.num_frames",description:`<strong>num_frames</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The num_frames parameter determines how many video frames are generated.`,name:"num_frames"},{anchor:"huggingface_hub.InferenceClient.text_to_video.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality video at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.text_to_video.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.text_to_video.extra_body",description:`<strong>extra_body</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2497",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated video.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`}}),rs=new V({props:{$$slots:{default:[rM]},$$scope:{ctx:_}}}),cs=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_video.example",$$slots:{default:[cM]},$$scope:{ctx:_}}}),ps=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_video.example-2",$$slots:{default:[pM]},$$scope:{ctx:_}}}),ol=new A({props:{name:"token_classification",anchor:"huggingface_hub.InferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"aggregation_strategy",val:": typing.Optional[ForwardRef('TokenClassificationAggregationStrategy')] = None"},{name:"ignore_labels",val:": typing.Optional[typing.List[str]] = None"},{name:"stride",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.token_classification.aggregation_strategy",description:`<strong>aggregation_strategy</strong> (<code>&quot;TokenClassificationAggregationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The strategy used to fuse tokens based on model predictions`,name:"aggregation_strategy"},{anchor:"huggingface_hub.InferenceClient.token_classification.ignore_labels",description:`<strong>ignore_labels</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
A list of labels to ignore`,name:"ignore_labels"},{anchor:"huggingface_hub.InferenceClient.token_classification.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of overlapping tokens between chunks when splitting the input text.`,name:"stride"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2803",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),gs=new U({props:{anchor:"huggingface_hub.InferenceClient.token_classification.example",$$slots:{default:[gM]},$$scope:{ctx:_}}}),il=new A({props:{name:"translation",anchor:"huggingface_hub.InferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"src_lang",val:": typing.Optional[str] = None"},{name:"tgt_lang",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('TranslationTruncationStrategy')] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The source language of the text. Required for models that can translate from multiple languages.`,name:"src_lang"},{anchor:"huggingface_hub.InferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language to translate to. Required for models that can translate to multiple languages.`,name:"tgt_lang"},{anchor:"huggingface_hub.InferenceClient.translation.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.InferenceClient.translation.truncation",description:`<strong>truncation</strong> (<code>&quot;TranslationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"},{anchor:"huggingface_hub.InferenceClient.translation.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2878",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),us=new U({props:{anchor:"huggingface_hub.InferenceClient.translation.example",$$slots:{default:[uM]},$$scope:{ctx:_}}}),ms=new U({props:{anchor:"huggingface_hub.InferenceClient.translation.example-2",$$slots:{default:[mM]},$$scope:{ctx:_}}}),rl=new A({props:{name:"visual_question_answering",anchor:"huggingface_hub.InferenceClient.visual_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2967",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),hs=new U({props:{anchor:"huggingface_hub.InferenceClient.visual_question_answering.example",$$slots:{default:[hM]},$$scope:{ctx:_}}}),cl=new A({props:{name:"zero_shot_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"candidate_labels",val:": typing.List[str]"},{name:"multi_label",val:": typing.Optional[bool] = False"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The set of possible class labels to classify the text into.`,name:"candidate_labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of strings. Each string is the verbalization of a possible label for the input text.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether multiple candidate labels can be true. If false, the scores are normalized such that the sum of
the label likelihoods for each sequence is 1. If true, the labels are considered independent and
probabilities are normalized for each candidate.`,name:"multi_label"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the text classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot classification model will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3026",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ds=new U({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example",$$slots:{default:[dM]},$$scope:{ctx:_}}}),fs=new U({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example-2",$$slots:{default:[fM]},$$scope:{ctx:_}}}),pl=new A({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"candidate_labels",val:": typing.List[str]"},{name:"model",val:": typing.Optional[str] = None"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.List[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The candidate labels for this image`,name:"candidate_labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot image classification model will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the image classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3132",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ys=new U({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.example",$$slots:{default:[yM]},$$scope:{ctx:_}}}),gl=new ir({props:{title:"Async Inference Client",local:"huggingface_hub.AsyncInferenceClient",headingTag:"h2"}}),ml=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMG9yJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFpb2h0dHA=",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># or</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),hl=new A({props:{name:"class huggingface_hub.AsyncInferenceClient",anchor:"huggingface_hub.AsyncInferenceClient",parameters:[{name:"model",val:": typing.Optional[str] = None"},{name:"provider",val:": typing.Union[typing.Literal['black-forest-labs', 'cerebras', 'cohere', 'fal-ai', 'featherless-ai', 'fireworks-ai', 'hf-inference', 'hyperbolic', 'nebius', 'novita', 'nscale', 'openai', 'replicate', 'sambanova', 'together'], typing.Literal['auto'], NoneType] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"timeout",val:": typing.Optional[float] = None"},{name:"headers",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"cookies",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"trust_env",val:": bool = False"},{name:"proxies",val:": typing.Optional[typing.Any] = None"},{name:"bill_to",val:": typing.Optional[str] = None"},{name:"base_url",val:": typing.Optional[str] = None"},{name:"api_key",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>meta-llama/Meta-Llama-3-8B-Instruct</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.
Note: for better compatibility with OpenAI&#x2019;s client, <code>model</code> has been aliased as <code>base_url</code>. Those 2
arguments are mutually exclusive. If using <code>base_url</code> for chat completion, the <code>/chat/completions</code> suffix
path will be appended to the base URL (see the <a href="https://huggingface.co/docs/text-generation-inference/en/messages_api" rel="nofollow">TGI Messages API</a>
documentation for details). When passing a URL as <code>model</code>, the client will not append any suffix path to it.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.provider",description:"<strong>provider</strong> (<code>str</code>, <em>optional</em>) &#x2014;\nName of the provider to use for inference. Can be <code>&quot;black-forest-labs&quot;</code>, <code>&quot;cerebras&quot;</code>, <code>&quot;cohere&quot;</code>, <code>&quot;fal-ai&quot;</code>, <code>&quot;featherless-ai&quot;</code>, <code>&quot;fireworks-ai&quot;</code>, <code>&quot;hf-inference&quot;</code>, <code>&quot;hyperbolic&quot;</code>, <code>&quot;nebius&quot;</code>, <code>&quot;novita&quot;</code>, <code>&quot;nscale&quot;</code>, <code>&quot;openai&quot;</code>, <code>&quot;replicate&quot;</code>, &#x201C;sambanova&#x201D;<code>or</code>&#x201C;together&#x201D;<code>. Defaults to &quot;auto&quot; i.e. the first of the providers available for the model, sorted by the user&apos;s order in https://hf.co/settings/inference-providers. If model is a URL or </code>base_url<code>is passed, then</code>provider` is not used.",name:"provider"},{anchor:"huggingface_hub.AsyncInferenceClient.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Note: for better compatibility with OpenAI&#x2019;s client, <code>token</code> has been aliased as <code>api_key</code>. Those 2
arguments are mutually exclusive and have the exact same behavior.`,name:"token"},{anchor:"huggingface_hub.AsyncInferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.AsyncInferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.AsyncInferenceClient.bill_to",description:`<strong>bill_to</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The billing account to use for the requests. By default the requests are billed on the user&#x2019;s account.
Requests can only be billed to an organization the user is a member of, and which has subscribed to Enterprise Hub.`,name:"bill_to"},{anchor:"huggingface_hub.AsyncInferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"},{anchor:"huggingface_hub.AsyncInferenceClient.trust_env",description:`<strong>trust_env</strong> (&#x2018;bool&#x2019;, &#x2018;optional&#x2019;) &#x2014;
Trust environment settings for proxy configuration if the parameter is <code>True</code> (<code>False</code> by default).`,name:"trust_env"},{anchor:"huggingface_hub.AsyncInferenceClient.proxies",description:`<strong>proxies</strong> (<code>Any</code>, <code>optional</code>) &#x2014;
Proxies to use for the request.`,name:"proxies"},{anchor:"huggingface_hub.AsyncInferenceClient.base_url",description:`<strong>base_url</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Base URL to run inference. This is a duplicated argument from <code>model</code> to make <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>model</code> is set. Defaults to None.`,name:"base_url"},{anchor:"huggingface_hub.AsyncInferenceClient.api_key",description:`<strong>api_key</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Token to use for authentication. This is a duplicated argument from <code>token</code> to make <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>token</code> is set. Defaults to None.`,name:"api_key"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L108"}}),dl=new A({props:{name:"audio_classification",anchor:"huggingface_hub.AsyncInferenceClient.audio_classification",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('AudioClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;AudioClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L321",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ms=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.example",$$slots:{default:[MM]},$$scope:{ctx:_}}}),fl=new A({props:{name:"audio_to_audio",anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L379",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),bs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.example",$$slots:{default:[bM]},$$scope:{ctx:_}}}),yl=new A({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.extra_body",description:`<strong>extra_body</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L432",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),js=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.example",$$slots:{default:[jM]},$$scope:{ctx:_}}}),Ml=new A({props:{name:"chat_completion",anchor:"huggingface_hub.AsyncInferenceClient.chat_completion",parameters:[{name:"messages",val:": typing.List[typing.Union[typing.Dict, huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputMessage]]"},{name:"model",val:": typing.Optional[str] = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"logit_bias",val:": typing.Optional[typing.List[float]] = None"},{name:"logprobs",val:": typing.Optional[bool] = None"},{name:"max_tokens",val:": typing.Optional[int] = None"},{name:"n",val:": typing.Optional[int] = None"},{name:"presence_penalty",val:": typing.Optional[float] = None"},{name:"response_format",val:": typing.Union[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputResponseFormatText, huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputResponseFormatJSONSchema, huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputResponseFormatJSONObject, NoneType] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stream_options",val:": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputStreamOptions] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"tool_choice",val:": typing.Union[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputToolChoiceClass, ForwardRef('ChatCompletionInputToolChoiceEnum'), NoneType] = None"},{name:"tool_prompt",val:": typing.Optional[str] = None"},{name:"tools",val:": typing.Optional[typing.List[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputTool]] = None"},{name:"top_logprobs",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List of <a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputMessage">ChatCompletionInputMessage</a>) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.
If <code>model</code> is a model ID, it is passed to the server as the <code>model</code> parameter. If you want to define a
custom URL while setting <code>model</code> in the request payload, you must set <code>base_url</code> when initializing <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Adjusts the likelihood of specific tokens appearing in the generated output.`,name:"logit_bias"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 100.`,name:"max_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of completions to generate for each prompt.`,name:"n"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.response_format",description:`<strong>response_format</strong> (<code>ChatCompletionInputGrammarType()</code>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"response_format"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stream_options",description:`<strong>stream_options</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputStreamOptions">ChatCompletionInputStreamOptions</a>, <em>optional</em>) &#x2014;
Options for streaming completions.`,name:"stream_options"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolChoiceClass">ChatCompletionInputToolChoiceClass</a> or <code>ChatCompletionInputToolChoiceEnum()</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionInputTool">ChatCompletionInputTool</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.extra_body",description:`<strong>extra_body</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L559",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),_s=new V({props:{$$slots:{default:[_M]},$$scope:{ctx:_}}}),Ts=new V({props:{$$slots:{default:[TM]},$$scope:{ctx:_}}}),Is=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example",$$slots:{default:[IM]},$$scope:{ctx:_}}}),Js=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-2",$$slots:{default:[JM]},$$scope:{ctx:_}}}),ws=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-3",$$slots:{default:[wM]},$$scope:{ctx:_}}}),Us=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-4",$$slots:{default:[UM]},$$scope:{ctx:_}}}),xs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-5",$$slots:{default:[xM]},$$scope:{ctx:_}}}),Cs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-6",$$slots:{default:[CM]},$$scope:{ctx:_}}}),$s=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-7",$$slots:{default:[$M]},$$scope:{ctx:_}}}),vs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-8",$$slots:{default:[vM]},$$scope:{ctx:_}}}),bl=new A({props:{name:"close",anchor:"huggingface_hub.AsyncInferenceClient.close",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L310"}}),jl=new A({props:{name:"document_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"lang",val:": typing.Optional[str] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"word_boxes",val:": typing.Optional[typing.List[typing.Union[typing.List[float], str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the words in the document are too long to fit with the question for the model, it will be split in
several chunks with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.lang",description:`<strong>lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Language to use while running OCR. Defaults to english.`,name:"lang"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using doc_stride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Can return less than top_k
answers if there are not enough options available within the context.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.word_boxes",description:`<strong>word_boxes</strong> (<code>List[Union[List[float], str</code>, <em>optional</em>) &#x2014;
A list of words and bounding boxes (normalized 0-&gt;1000). If provided, the inference will skip the OCR
step and use the provided bounding boxes instead.`,name:"word_boxes"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L971",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ks=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.example",$$slots:{default:[kM]},$$scope:{ctx:_}}}),_l=new A({props:{name:"feature_extraction",anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": typing.Optional[bool] = None"},{name:"prompt_name",val:": typing.Optional[str] = None"},{name:"truncate",val:": typing.Optional[bool] = None"},{name:"truncation_direction",val:": typing.Optional[typing.Literal['Left', 'Right']] = None"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the feature extraction task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended feature extraction model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1059",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>aiohttp.ClientResponseError</code></p>
`}}),qs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.example",$$slots:{default:[qM]},$$scope:{ctx:_}}}),Tl=new A({props:{name:"fill_mask",anchor:"huggingface_hub.AsyncInferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"targets",val:": typing.Optional[typing.List[str]] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.targets",description:`<strong>targets</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
When passed, the model will limit the scores to the passed targets instead of looking up in the whole
vocabulary. If the provided targets are not in the model vocab, they will be tokenized and the first
resulting token will be used (with a warning, and that might be slower).`,name:"targets"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When passed, overrides the number of predictions to return.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1133",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),As=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.example",$$slots:{default:[AM]},$$scope:{ctx:_}}}),Il=new A({props:{name:"get_endpoint_info",anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3400",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Zs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.example",$$slots:{default:[ZM]},$$scope:{ctx:_}}}),Jl=new A({props:{name:"get_model_status",anchor:"huggingface_hub.AsyncInferenceClient.get_model_status",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only HF Inference API service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3499",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),Es=new V({props:{$$slots:{default:[EM]},$$scope:{ctx:_}}}),Ws=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.example",$$slots:{default:[WM]},$$scope:{ctx:_}}}),wl=new A({props:{name:"health_check",anchor:"huggingface_hub.AsyncInferenceClient.health_check",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3460",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Ns=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.health_check.example",$$slots:{default:[NM]},$$scope:{ctx:_}}}),Ul=new A({props:{name:"image_classification",anchor:"huggingface_hub.AsyncInferenceClient.image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('ImageClassificationOutputTransform')] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;ImageClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1190",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Gs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.example",$$slots:{default:[GM]},$$scope:{ctx:_}}}),xl=new A({props:{name:"image_segmentation",anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"mask_threshold",val:": typing.Optional[float] = None"},{name:"overlap_mask_area_threshold",val:": typing.Optional[float] = None"},{name:"subtask",val:": typing.Optional[ForwardRef('ImageSegmentationSubtask')] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Mask overlap threshold to eliminate small, disconnected segments.`,name:"overlap_mask_area_threshold"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.subtask",description:`<strong>subtask</strong> (<code>&quot;ImageSegmentationSubtask&quot;</code>, <em>optional</em>) &#x2014;
Segmentation task to be performed, depending on model capabilities.`,name:"subtask"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Probability threshold to filter out predicted masks.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1241",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Bs=new V({props:{warning:!0,$$slots:{default:[BM]},$$scope:{ctx:_}}}),Vs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.example",$$slots:{default:[VM]},$$scope:{ctx:_}}}),Cl=new A({props:{name:"image_to_image",anchor:"huggingface_hub.AsyncInferenceClient.image_to_image",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"target_size",val:": typing.Optional[huggingface_hub.inference._generated.types.image_to_image.ImageToImageTargetSize] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
One prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
For diffusion models. The number of denoising steps. More denoising steps usually lead to a higher
quality image at the expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
For diffusion models. A higher guidance scale value encourages the model to generate images closely
linked to the text prompt at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.target_size",description:`<strong>target_size</strong> (<code>ImageToImageTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output image.`,name:"target_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1312",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Qs=new V({props:{warning:!0,$$slots:{default:[QM]},$$scope:{ctx:_}}}),Ss=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.example",$$slots:{default:[SM]},$$scope:{ctx:_}}}),$l=new A({props:{name:"image_to_text",anchor:"huggingface_hub.AsyncInferenceClient.image_to_text",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1389",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ys=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.example",$$slots:{default:[YM]},$$scope:{ctx:_}}}),vl=new A({props:{name:"list_deployed_models",anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": typing.Union[NoneType, str, typing.Literal['all'], typing.List[str]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3263",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),Rs=new V({props:{warning:!0,$$slots:{default:[RM]},$$scope:{ctx:_}}}),Xs=new V({props:{$$slots:{default:[XM]},$$scope:{ctx:_}}}),zs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.example",$$slots:{default:[zM]},$$scope:{ctx:_}}}),kl=new A({props:{name:"object_detection",anchor:"huggingface_hub.AsyncInferenceClient.object_detection",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The probability necessary to make a prediction.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1436",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),Fs=new V({props:{warning:!0,$$slots:{default:[FM]},$$scope:{ctx:_}}}),Hs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.example",$$slots:{default:[HM]},$$scope:{ctx:_}}}),ql=new A({props:{name:"question_answering",anchor:"huggingface_hub.AsyncInferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"align_to_words",val:": typing.Optional[bool] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.align_to_words",description:`<strong>align_to_words</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Attempts to align the answer to real words. Improves quality on space separated languages. Might hurt
on non-space-separated languages (like Japanese or Chinese)`,name:"align_to_words"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the context is too long to fit with the question for the model, it will be split in several chunks
with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer.`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using docStride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1488",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>When top_k is 1 or not provided, it returns a single <code>QuestionAnsweringOutputElement</code>.
When top_k is greater than 1, it returns a list of <code>QuestionAnsweringOutputElement</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Union[<code>QuestionAnsweringOutputElement</code>, List<a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a>]</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ds=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.example",$$slots:{default:[DM]},$$scope:{ctx:_}}}),Al=new A({props:{name:"sentence_similarity",anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": typing.List[str]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the sentence similarity task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended sentence similarity model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ls=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.example",$$slots:{default:[LM]},$$scope:{ctx:_}}}),Zl=new A({props:{name:"summarization",anchor:"huggingface_hub.AsyncInferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('SummarizationTruncationStrategy')] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for summarization will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.truncation",description:`<strong>truncation</strong> (<code>&quot;SummarizationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1628",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Os=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.summarization.example",$$slots:{default:[OM]},$$scope:{ctx:_}}}),El=new A({props:{name:"table_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"query",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"padding",val:": typing.Optional[ForwardRef('Padding')] = None"},{name:"sequential",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.padding",description:`<strong>padding</strong> (<code>&quot;Padding&quot;</code>, <em>optional</em>) &#x2014;
Activates and controls padding.`,name:"padding"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.sequential",description:`<strong>sequential</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to do inference sequentially or as a batch. Batching is faster, but models like SQA require the
inference to be done sequentially to extract relations within sequences, given their conversational
nature.`,name:"sequential"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activates and controls truncation.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1687",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ps=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.example",$$slots:{default:[PM]},$$scope:{ctx:_}}}),Wl=new A({props:{name:"tabular_classification",anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1751",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ks=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.example",$$slots:{default:[KM]},$$scope:{ctx:_}}}),Nl=new A({props:{name:"tabular_regression",anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1807",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ea=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.example",$$slots:{default:[eb]},$$scope:{ctx:_}}}),Gl=new A({props:{name:"text_classification",anchor:"huggingface_hub.AsyncInferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('TextClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;TextClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1858",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),na=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.example",$$slots:{default:[nb]},$$scope:{ctx:_}}}),Bl=new A({props:{name:"text_generation",anchor:"huggingface_hub.AsyncInferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": typing.Optional[str] = None"},{name:"adapter_id",val:": typing.Optional[str] = None"},{name:"best_of",val:": typing.Optional[int] = None"},{name:"decoder_input_details",val:": typing.Optional[bool] = None"},{name:"do_sample",val:": typing.Optional[bool] = False"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"grammar",val:": typing.Optional[huggingface_hub.inference._generated.types.text_generation.TextGenerationInputGrammarType] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"repetition_penalty",val:": typing.Optional[float] = None"},{name:"return_full_text",val:": typing.Optional[bool] = False"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stop_sequences",val:": typing.Optional[typing.List[str]] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_n_tokens",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"truncate",val:": typing.Optional[int] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"watermark",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.adapter_id",description:`<strong>adapter_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Lora adapter id.`,name:"adapter_id"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens. Defaults to 100.`,name:"max_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop</code> is generated.`,name:"stop"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Deprecated argument. Use <code>stop</code> instead.`,name:"stop_sequences"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.watermark",description:'<strong>watermark</strong> (<code>bool</code>, *optional`) &#x2014;\nWatermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>',name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2067",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ta=new V({props:{$$slots:{default:[tb]},$$scope:{ctx:_}}}),sa=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.example",$$slots:{default:[sb]},$$scope:{ctx:_}}}),Vl=new A({props:{name:"text_to_image",anchor:"huggingface_hub.AsyncInferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"scheduler",val:": typing.Optional[str] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
One prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in pixels of the output image`,name:"height"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The width in pixels of the output image`,name:"width"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
prompt, but values too high may cause saturation and other artifacts.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-image model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.scheduler",description:`<strong>scheduler</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Override the scheduler with a compatible one.`,name:"scheduler"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.extra_body",description:`<strong>extra_body</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2410",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),aa=new V({props:{warning:!0,$$slots:{default:[ab]},$$scope:{ctx:_}}}),la=new V({props:{$$slots:{default:[lb]},$$scope:{ctx:_}}}),oa=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example",$$slots:{default:[ob]},$$scope:{ctx:_}}}),ia=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example-2",$$slots:{default:[ib]},$$scope:{ctx:_}}}),ra=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example-3",$$slots:{default:[rb]},$$scope:{ctx:_}}}),ca=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example-4",$$slots:{default:[cb]},$$scope:{ctx:_}}}),Ql=new A({props:{name:"text_to_speech",anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"do_sample",val:": typing.Optional[bool] = None"},{name:"early_stopping",val:": typing.Union[bool, ForwardRef('TextToSpeechEarlyStoppingEnum'), NoneType] = None"},{name:"epsilon_cutoff",val:": typing.Optional[float] = None"},{name:"eta_cutoff",val:": typing.Optional[float] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"min_length",val:": typing.Optional[int] = None"},{name:"min_new_tokens",val:": typing.Optional[int] = None"},{name:"num_beam_groups",val:": typing.Optional[int] = None"},{name:"num_beams",val:": typing.Optional[int] = None"},{name:"penalty_alpha",val:": typing.Optional[float] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-speech model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use sampling instead of greedy decoding when generating new tokens.`,name:"do_sample"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.early_stopping",description:`<strong>early_stopping</strong> (<code>Union[bool, &quot;TextToSpeechEarlyStoppingEnum&quot;]</code>, <em>optional</em>) &#x2014;
Controls the stopping condition for beam-based methods.`,name:"early_stopping"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
epsilon_cutoff will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on
the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly
between 0 and 1, a token is only considered if it is greater than either eta_cutoff or sqrt(eta_cutoff)<ul>
<li>exp(-entropy(softmax(next_token_logits))). The latter term is intuitively the expected next token
probability, scaled by sqrt(eta_cutoff). In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.</li>
</ul>`,name:"eta_cutoff"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length (in tokens) of the generated text, including the input.`,name:"max_length"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of tokens to generate. Takes precedence over max_length.`,name:"max_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum length (in tokens) of the generated text, including the input.`,name:"min_length"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of tokens to generate. Takes precedence over min_length.`,name:"min_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of groups to divide num_beams into in order to ensure diversity among different groups of beams.
See <a href="https://hf.co/papers/1610.02424" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of beams to use for beam search.`,name:"num_beams"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value balances the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
top_p or higher are kept for generation.`,name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is
to the expected conditional probability of predicting a random token next, given the partial text
already generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with
probabilities that add up to typical_p or higher are kept for generation. See <a href="https://hf.co/papers/2202.00666" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the model should use the past last key/values attentions to speed up decoding`,name:"use_cache"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.extra_body",description:`<strong>extra_body</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2651",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),pa=new V({props:{$$slots:{default:[pb]},$$scope:{ctx:_}}}),ga=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example",$$slots:{default:[gb]},$$scope:{ctx:_}}}),ua=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example-2",$$slots:{default:[ub]},$$scope:{ctx:_}}}),ma=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example-3",$$slots:{default:[mb]},$$scope:{ctx:_}}}),ha=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example-4",$$slots:{default:[hb]},$$scope:{ctx:_}}}),da=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example-5",$$slots:{default:[db]},$$scope:{ctx:_}}}),Sl=new A({props:{name:"text_to_video",anchor:"huggingface_hub.AsyncInferenceClient.text_to_video",parameters:[{name:"prompt",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"negative_prompt",val:": typing.Optional[typing.List[str]] = None"},{name:"num_frames",val:": typing.Optional[float] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"extra_body",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate a video from.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-video model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A higher guidance scale value encourages the model to generate videos closely linked to the text
prompt, but values too high may cause saturation and other artifacts.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.negative_prompt",description:`<strong>negative_prompt</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
One or several prompt to guide what NOT to include in video generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.num_frames",description:`<strong>num_frames</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The num_frames parameter determines how many video frames are generated.`,name:"num_frames"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality video at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.extra_body",description:`<strong>extra_body</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional provider-specific parameters to pass to the model. Refer to the provider&#x2019;s documentation
for supported parameters.`,name:"extra_body"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2554",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated video.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`}}),fa=new V({props:{$$slots:{default:[fb]},$$scope:{ctx:_}}}),ya=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.example",$$slots:{default:[yb]},$$scope:{ctx:_}}}),Ma=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.example-2",$$slots:{default:[Mb]},$$scope:{ctx:_}}}),Yl=new A({props:{name:"token_classification",anchor:"huggingface_hub.AsyncInferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"aggregation_strategy",val:": typing.Optional[ForwardRef('TokenClassificationAggregationStrategy')] = None"},{name:"ignore_labels",val:": typing.Optional[typing.List[str]] = None"},{name:"stride",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.aggregation_strategy",description:`<strong>aggregation_strategy</strong> (<code>&quot;TokenClassificationAggregationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The strategy used to fuse tokens based on model predictions`,name:"aggregation_strategy"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.ignore_labels",description:`<strong>ignore_labels</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
A list of labels to ignore`,name:"ignore_labels"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of overlapping tokens between chunks when splitting the input text.`,name:"stride"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2861",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ba=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.example",$$slots:{default:[bb]},$$scope:{ctx:_}}}),Rl=new A({props:{name:"translation",anchor:"huggingface_hub.AsyncInferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"src_lang",val:": typing.Optional[str] = None"},{name:"tgt_lang",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('TranslationTruncationStrategy')] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The source language of the text. Required for models that can translate from multiple languages.`,name:"src_lang"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language to translate to. Required for models that can translate to multiple languages.`,name:"tgt_lang"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.truncation",description:`<strong>truncation</strong> (<code>&quot;TranslationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2937",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),ja=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example",$$slots:{default:[jb]},$$scope:{ctx:_}}}),_a=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example-2",$$slots:{default:[_b]},$$scope:{ctx:_}}}),Xl=new A({props:{name:"visual_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3027",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ta=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.example",$$slots:{default:[Tb]},$$scope:{ctx:_}}}),zl=new A({props:{name:"zero_shot_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"candidate_labels",val:": typing.List[str]"},{name:"multi_label",val:": typing.Optional[bool] = False"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The set of possible class labels to classify the text into.`,name:"candidate_labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of strings. Each string is the verbalization of a possible label for the input text.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether multiple candidate labels can be true. If false, the scores are normalized such that the sum of
the label likelihoods for each sequence is 1. If true, the labels are considered independent and
probabilities are normalized for each candidate.`,name:"multi_label"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the text classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot classification model will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3087",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ia=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example",$$slots:{default:[Ib]},$$scope:{ctx:_}}}),Ja=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example-2",$$slots:{default:[Jb]},$$scope:{ctx:_}}}),Fl=new A({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"candidate_labels",val:": typing.List[str]"},{name:"model",val:": typing.Optional[str] = None"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.List[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The candidate labels for this image`,name:"candidate_labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot image classification model will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the image classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3195",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/en/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),wa=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.example",$$slots:{default:[wb]},$$scope:{ctx:_}}}),Hl=new ir({props:{title:"InferenceTimeoutError",local:"huggingface_hub.InferenceTimeoutError",headingTag:"h2"}}),Dl=new A({props:{name:"class huggingface_hub.InferenceTimeoutError",anchor:"huggingface_hub.InferenceTimeoutError",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L92"}}),Ll=new ir({props:{title:"ModelStatus",local:"huggingface_hub.inference._common.ModelStatus",headingTag:"h3"}}),Ol=new A({props:{name:"class huggingface_hub.inference._common.ModelStatus",anchor:"huggingface_hub.inference._common.ModelStatus",parameters:[{name:"loaded",val:": bool"},{name:"state",val:": str"},{name:"compute_type",val:": typing.Dict"},{name:"framework",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.inference._common.ModelStatus.loaded",description:`<strong>loaded</strong> (<code>bool</code>) &#x2014;
If the model is currently loaded into HF&#x2019;s Inference API. Models
are loaded on-demand, leading to the user&#x2019;s first request taking longer.
If a model is loaded, you can be assured that it is in a healthy state.`,name:"loaded"},{anchor:"huggingface_hub.inference._common.ModelStatus.state",description:`<strong>state</strong> (<code>str</code>) &#x2014;
The current state of the model. This can be &#x2018;Loaded&#x2019;, &#x2018;Loadable&#x2019;, &#x2018;TooBig&#x2019;.
If a model&#x2019;s state is &#x2018;Loadable&#x2019;, it&#x2019;s not too big and has a supported
backend. Loadable models are automatically loaded when the user first
requests inference on the endpoint. This means it is transparent for the
user to load a model, except that the first call takes longer to complete.`,name:"state"},{anchor:"huggingface_hub.inference._common.ModelStatus.compute_type",description:`<strong>compute_type</strong> (<code>Dict</code>) &#x2014;
Information about the compute resource the model is using or will use, such as &#x2018;gpu&#x2019; type and number of
replicas.`,name:"compute_type"},{anchor:"huggingface_hub.inference._common.ModelStatus.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The name of the framework that the model was built with, such as &#x2018;transformers&#x2019;
or &#x2018;text-generation-inference&#x2019;.`,name:"framework"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_common.py#L83"}}),Pl=new ir({props:{title:"InferenceAPI",local:"huggingface_hub.InferenceApi",headingTag:"h2"}}),eo=new A({props:{name:"class huggingface_hub.InferenceApi",anchor:"huggingface_hub.InferenceApi",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"gpu",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference_api.py#L46"}}),Ua=new U({props:{anchor:"huggingface_hub.InferenceApi.example",$$slots:{default:[Ub]},$$scope:{ctx:_}}}),no=new A({props:{name:"__init__",anchor:"huggingface_hub.InferenceApi.__init__",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"gpu",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__init__.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
Id of repository (e.g. <em>user/bert-base-uncased</em>).`,name:"repo_id"},{anchor:"huggingface_hub.InferenceApi.__init__.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>, defaults <code>None</code>) &#x2014;
Whether to force a task instead of using task specified in the
repository.`,name:"task"},{anchor:"huggingface_hub.InferenceApi.__init__.token",description:`<strong>token</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The API token to use as HTTP bearer authorization. This is not
the authentication token. You can find the token in
<a href="https://huggingface.co/settings/token" rel="nofollow">https://huggingface.co/settings/token</a>. Alternatively, you can
find both your organizations and personal API tokens using
<em>HfApi().whoami(token)</em>.`,name:"token"},{anchor:"huggingface_hub.InferenceApi.__init__.gpu",description:`<strong>gpu</strong> (<em>bool</em>, <em>optional</em>, defaults <em>False</em>) &#x2014;
Whether to use GPU instead of CPU for inference(requires Startup
plan at least).`,name:"gpu"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference_api.py#L93"}}),to=new A({props:{name:"__call__",anchor:"huggingface_hub.InferenceApi.__call__",parameters:[{name:"inputs",val:": typing.Union[str, typing.Dict, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"params",val:": typing.Optional[typing.Dict] = None"},{name:"data",val:": typing.Optional[bytes] = None"},{name:"raw_response",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code> or <code>Dict</code> or <code>List[str]</code> or <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
Inputs for the prediction.`,name:"inputs"},{anchor:"huggingface_hub.InferenceApi.__call__.params",description:`<strong>params</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional parameters for the models. Will be sent as <code>parameters</code> in the
payload.`,name:"params"},{anchor:"huggingface_hub.InferenceApi.__call__.data",description:`<strong>data</strong> (<code>bytes</code>, <em>optional</em>) &#x2014;
Bytes content of the request. In this case, leave <code>inputs</code> and <code>params</code> empty.`,name:"data"},{anchor:"huggingface_hub.InferenceApi.__call__.raw_response",description:`<strong>raw_response</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the raw <code>Response</code> object is returned. You can parse its content
as preferred. By default, the content is parsed into a more practical format
(json dictionary or PIL Image for example).`,name:"raw_response"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference_api.py#L158"}}),so=new cy({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/inference_client.md"}}),{c(){n=b("meta"),o=r(),t=b("p"),s=r(),g(i.$$.fragment),e=r(),p=b("p"),p.innerHTML=nh,cr=r(),$a=b("ol"),$a.innerHTML=th,pr=r(),va=b("p"),va.innerHTML=sh,gr=r(),g(ka.$$.fragment),ur=r(),C=b("div"),g(qa.$$.fragment),xr=r(),ro=b("p"),ro.textContent=ah,Cr=r(),co=b("p"),co.innerHTML=lh,$r=r(),Fe=b("div"),g(Aa.$$.fragment),vr=r(),po=b("p"),po.textContent=oh,kr=r(),g(pt.$$.fragment),qr=r(),He=b("div"),g(Za.$$.fragment),Ar=r(),go=b("p"),go.textContent=ih,Zr=r(),g(gt.$$.fragment),Er=r(),De=b("div"),g(Ea.$$.fragment),Wr=r(),uo=b("p"),uo.textContent=rh,Nr=r(),g(ut.$$.fragment),Gr=r(),Z=b("div"),g(Wa.$$.fragment),Br=r(),mo=b("p"),mo.textContent=ch,Vr=r(),g(mt.$$.fragment),Qr=r(),g(ht.$$.fragment),Sr=r(),g(dt.$$.fragment),Yr=r(),g(ft.$$.fragment),Rr=r(),g(yt.$$.fragment),Xr=r(),ho=b("p"),ho.textContent=ph,zr=r(),g(Mt.$$.fragment),Fr=r(),fo=b("p"),fo.textContent=gh,Hr=r(),g(bt.$$.fragment),Dr=r(),g(jt.$$.fragment),Lr=r(),g(_t.$$.fragment),Or=r(),g(Tt.$$.fragment),Pr=r(),Le=b("div"),g(Na.$$.fragment),Kr=r(),yo=b("p"),yo.textContent=uh,ec=r(),g(It.$$.fragment),nc=r(),Oe=b("div"),g(Ga.$$.fragment),tc=r(),Mo=b("p"),Mo.textContent=mh,sc=r(),g(Jt.$$.fragment),ac=r(),Pe=b("div"),g(Ba.$$.fragment),lc=r(),bo=b("p"),bo.textContent=hh,oc=r(),g(wt.$$.fragment),ic=r(),ie=b("div"),g(Va.$$.fragment),rc=r(),jo=b("p"),jo.textContent=dh,cc=r(),_o=b("p"),_o.innerHTML=fh,pc=r(),g(Ut.$$.fragment),gc=r(),re=b("div"),g(Qa.$$.fragment),uc=r(),To=b("p"),To.textContent=yh,mc=r(),g(xt.$$.fragment),hc=r(),g(Ct.$$.fragment),dc=r(),ce=b("div"),g(Sa.$$.fragment),fc=r(),Io=b("p"),Io.textContent=Mh,yc=r(),Jo=b("p"),Jo.innerHTML=bh,Mc=r(),g($t.$$.fragment),bc=r(),Ke=b("div"),g(Ya.$$.fragment),jc=r(),wo=b("p"),wo.textContent=jh,_c=r(),g(vt.$$.fragment),Tc=r(),pe=b("div"),g(Ra.$$.fragment),Ic=r(),Uo=b("p"),Uo.textContent=_h,Jc=r(),g(kt.$$.fragment),wc=r(),g(qt.$$.fragment),Uc=r(),ge=b("div"),g(Xa.$$.fragment),xc=r(),xo=b("p"),xo.textContent=Th,Cc=r(),g(At.$$.fragment),$c=r(),g(Zt.$$.fragment),vc=r(),ue=b("div"),g(za.$$.fragment),kc=r(),Co=b("p"),Co.textContent=Ih,qc=r(),$o=b("p"),$o.textContent=Jh,Ac=r(),g(Et.$$.fragment),Zc=r(),O=b("div"),g(Fa.$$.fragment),Ec=r(),vo=b("p"),vo.textContent=wh,Wc=r(),ko=b("p"),ko.innerHTML=Uh,Nc=r(),g(Wt.$$.fragment),Gc=r(),g(Nt.$$.fragment),Bc=r(),g(Gt.$$.fragment),Vc=r(),me=b("div"),g(Ha.$$.fragment),Qc=r(),qo=b("p"),qo.textContent=xh,Sc=r(),g(Bt.$$.fragment),Yc=r(),g(Vt.$$.fragment),Rc=r(),en=b("div"),g(Da.$$.fragment),Xc=r(),Ao=b("p"),Ao.textContent=Ch,zc=r(),g(Qt.$$.fragment),Fc=r(),nn=b("div"),g(La.$$.fragment),Hc=r(),Zo=b("p"),Zo.textContent=$h,Dc=r(),g(St.$$.fragment),Lc=r(),tn=b("div"),g(Oa.$$.fragment),Oc=r(),Eo=b("p"),Eo.textContent=vh,Pc=r(),g(Yt.$$.fragment),Kc=r(),sn=b("div"),g(Pa.$$.fragment),ep=r(),Wo=b("p"),Wo.textContent=kh,np=r(),g(Rt.$$.fragment),tp=r(),an=b("div"),g(Ka.$$.fragment),sp=r(),No=b("p"),No.textContent=qh,ap=r(),g(Xt.$$.fragment),lp=r(),ln=b("div"),g(el.$$.fragment),op=r(),Go=b("p"),Go.textContent=Ah,ip=r(),g(zt.$$.fragment),rp=r(),on=b("div"),g(nl.$$.fragment),cp=r(),Bo=b("p"),Bo.textContent=Zh,pp=r(),g(Ft.$$.fragment),gp=r(),he=b("div"),g(tl.$$.fragment),up=r(),Vo=b("p"),Vo.textContent=Eh,mp=r(),g(Ht.$$.fragment),hp=r(),g(Dt.$$.fragment),dp=r(),Y=b("div"),g(sl.$$.fragment),fp=r(),Qo=b("p"),Qo.textContent=Wh,yp=r(),g(Lt.$$.fragment),Mp=r(),g(Ot.$$.fragment),bp=r(),g(Pt.$$.fragment),jp=Ue(`
Example using a third-party provider directly. Usage will be billed on your fal.ai account.
`),g(Kt.$$.fragment),_p=r(),So=b("p"),So.textContent=Nh,Tp=r(),g(es.$$.fragment),Ip=r(),Yo=b("p"),Yo.textContent=Gh,Jp=r(),g(ns.$$.fragment),wp=r(),G=b("div"),g(al.$$.fragment),Up=r(),Ro=b("p"),Ro.textContent=Bh,xp=r(),g(ts.$$.fragment),Cp=r(),g(ss.$$.fragment),$p=r(),Xo=b("p"),Xo.textContent=Vh,vp=r(),g(as.$$.fragment),kp=r(),zo=b("p"),zo.textContent=Qh,qp=r(),g(ls.$$.fragment),Ap=Ue(`
Example using Replicate provider with extra parameters
`),g(os.$$.fragment),Zp=r(),Fo=b("p"),Fo.textContent=Sh,Ep=r(),g(is.$$.fragment),Wp=r(),F=b("div"),g(ll.$$.fragment),Np=r(),Ho=b("p"),Ho.textContent=Yh,Gp=r(),g(rs.$$.fragment),Bp=r(),Do=b("p"),Do.textContent=Rh,Vp=r(),Lo=b("p"),Lo.textContent=Xh,Qp=r(),g(cs.$$.fragment),Sp=r(),Oo=b("p"),Oo.textContent=zh,Yp=r(),g(ps.$$.fragment),Rp=r(),rn=b("div"),g(ol.$$.fragment),Xp=r(),Po=b("p"),Po.textContent=Fh,zp=r(),g(gs.$$.fragment),Fp=r(),te=b("div"),g(il.$$.fragment),Hp=r(),Ko=b("p"),Ko.textContent=Hh,Dp=r(),ei=b("p"),ei.innerHTML=Dh,Lp=r(),g(us.$$.fragment),Op=r(),g(ms.$$.fragment),Pp=r(),cn=b("div"),g(rl.$$.fragment),Kp=r(),ni=b("p"),ni.textContent=Lh,eg=r(),g(hs.$$.fragment),ng=r(),de=b("div"),g(cl.$$.fragment),tg=r(),ti=b("p"),ti.textContent=Oh,sg=r(),g(ds.$$.fragment),ag=r(),g(fs.$$.fragment),lg=r(),pn=b("div"),g(pl.$$.fragment),og=r(),si=b("p"),si.textContent=Ph,ig=r(),g(ys.$$.fragment),mr=r(),g(gl.$$.fragment),hr=r(),ul=b("p"),ul.innerHTML=Kh,dr=r(),g(ml.$$.fragment),fr=r(),x=b("div"),g(hl.$$.fragment),rg=r(),ai=b("p"),ai.textContent=ed,cg=r(),li=b("p"),li.innerHTML=nd,pg=r(),gn=b("div"),g(dl.$$.fragment),gg=r(),oi=b("p"),oi.textContent=td,ug=r(),g(Ms.$$.fragment),mg=r(),un=b("div"),g(fl.$$.fragment),hg=r(),ii=b("p"),ii.textContent=sd,dg=r(),g(bs.$$.fragment),fg=r(),mn=b("div"),g(yl.$$.fragment),yg=r(),ri=b("p"),ri.textContent=ad,Mg=r(),g(js.$$.fragment),bg=r(),E=b("div"),g(Ml.$$.fragment),jg=r(),ci=b("p"),ci.textContent=ld,_g=r(),g(_s.$$.fragment),Tg=r(),g(Ts.$$.fragment),Ig=r(),g(Is.$$.fragment),Jg=r(),g(Js.$$.fragment),wg=r(),g(ws.$$.fragment),Ug=r(),pi=b("p"),pi.textContent=od,xg=r(),g(Us.$$.fragment),Cg=r(),gi=b("p"),gi.textContent=id,$g=r(),g(xs.$$.fragment),vg=r(),g(Cs.$$.fragment),kg=r(),g($s.$$.fragment),qg=r(),g(vs.$$.fragment),Ag=r(),fe=b("div"),g(bl.$$.fragment),Zg=r(),ui=b("p"),ui.textContent=rd,Eg=r(),mi=b("p"),mi.textContent=cd,Wg=r(),hi=b("p"),hi.innerHTML=pd,Ng=r(),hn=b("div"),g(jl.$$.fragment),Gg=r(),di=b("p"),di.textContent=gd,Bg=r(),g(ks.$$.fragment),Vg=r(),dn=b("div"),g(_l.$$.fragment),Qg=r(),fi=b("p"),fi.textContent=ud,Sg=r(),g(qs.$$.fragment),Yg=r(),fn=b("div"),g(Tl.$$.fragment),Rg=r(),yi=b("p"),yi.textContent=md,Xg=r(),g(As.$$.fragment),zg=r(),ye=b("div"),g(Il.$$.fragment),Fg=r(),Mi=b("p"),Mi.textContent=hd,Hg=r(),bi=b("p"),bi.innerHTML=dd,Dg=r(),g(Zs.$$.fragment),Lg=r(),Me=b("div"),g(Jl.$$.fragment),Og=r(),ji=b("p"),ji.textContent=fd,Pg=r(),g(Es.$$.fragment),Kg=r(),g(Ws.$$.fragment),eu=r(),be=b("div"),g(wl.$$.fragment),nu=r(),_i=b("p"),_i.textContent=yd,tu=r(),Ti=b("p"),Ti.innerHTML=Md,su=r(),g(Ns.$$.fragment),au=r(),yn=b("div"),g(Ul.$$.fragment),lu=r(),Ii=b("p"),Ii.textContent=bd,ou=r(),g(Gs.$$.fragment),iu=r(),je=b("div"),g(xl.$$.fragment),ru=r(),Ji=b("p"),Ji.textContent=jd,cu=r(),g(Bs.$$.fragment),pu=r(),g(Vs.$$.fragment),gu=r(),_e=b("div"),g(Cl.$$.fragment),uu=r(),wi=b("p"),wi.textContent=_d,mu=r(),g(Qs.$$.fragment),hu=r(),g(Ss.$$.fragment),du=r(),Te=b("div"),g($l.$$.fragment),fu=r(),Ui=b("p"),Ui.textContent=Td,yu=r(),xi=b("p"),xi.textContent=Id,Mu=r(),g(Ys.$$.fragment),bu=r(),P=b("div"),g(vl.$$.fragment),ju=r(),Ci=b("p"),Ci.textContent=Jd,_u=r(),$i=b("p"),$i.innerHTML=wd,Tu=r(),g(Rs.$$.fragment),Iu=r(),g(Xs.$$.fragment),Ju=r(),g(zs.$$.fragment),wu=r(),Ie=b("div"),g(kl.$$.fragment),Uu=r(),vi=b("p"),vi.textContent=Ud,xu=r(),g(Fs.$$.fragment),Cu=r(),g(Hs.$$.fragment),$u=r(),Mn=b("div"),g(ql.$$.fragment),vu=r(),ki=b("p"),ki.textContent=xd,ku=r(),g(Ds.$$.fragment),qu=r(),bn=b("div"),g(Al.$$.fragment),Au=r(),qi=b("p"),qi.textContent=Cd,Zu=r(),g(Ls.$$.fragment),Eu=r(),jn=b("div"),g(Zl.$$.fragment),Wu=r(),Ai=b("p"),Ai.textContent=$d,Nu=r(),g(Os.$$.fragment),Gu=r(),_n=b("div"),g(El.$$.fragment),Bu=r(),Zi=b("p"),Zi.textContent=vd,Vu=r(),g(Ps.$$.fragment),Qu=r(),Tn=b("div"),g(Wl.$$.fragment),Su=r(),Ei=b("p"),Ei.textContent=kd,Yu=r(),g(Ks.$$.fragment),Ru=r(),In=b("div"),g(Nl.$$.fragment),Xu=r(),Wi=b("p"),Wi.textContent=qd,zu=r(),g(ea.$$.fragment),Fu=r(),Jn=b("div"),g(Gl.$$.fragment),Hu=r(),Ni=b("p"),Ni.textContent=Ad,Du=r(),g(na.$$.fragment),Lu=r(),Je=b("div"),g(Bl.$$.fragment),Ou=r(),Gi=b("p"),Gi.textContent=Zd,Pu=r(),g(ta.$$.fragment),Ku=r(),g(sa.$$.fragment),em=r(),R=b("div"),g(Vl.$$.fragment),nm=r(),Bi=b("p"),Bi.textContent=Ed,tm=r(),g(aa.$$.fragment),sm=r(),g(la.$$.fragment),am=r(),g(oa.$$.fragment),lm=Ue(`
Example using a third-party provider directly. Usage will be billed on your fal.ai account.
`),g(ia.$$.fragment),om=r(),Vi=b("p"),Vi.textContent=Wd,im=r(),g(ra.$$.fragment),rm=r(),Qi=b("p"),Qi.textContent=Nd,cm=r(),g(ca.$$.fragment),pm=r(),B=b("div"),g(Ql.$$.fragment),gm=r(),Si=b("p"),Si.textContent=Gd,um=r(),g(pa.$$.fragment),mm=r(),g(ga.$$.fragment),hm=r(),Yi=b("p"),Yi.textContent=Bd,dm=r(),g(ua.$$.fragment),fm=r(),Ri=b("p"),Ri.textContent=Vd,ym=r(),g(ma.$$.fragment),Mm=Ue(`
Example using Replicate provider with extra parameters
`),g(ha.$$.fragment),bm=r(),Xi=b("p"),Xi.textContent=Qd,jm=r(),g(da.$$.fragment),_m=r(),H=b("div"),g(Sl.$$.fragment),Tm=r(),zi=b("p"),zi.textContent=Sd,Im=r(),g(fa.$$.fragment),Jm=r(),Fi=b("p"),Fi.textContent=Yd,wm=r(),Hi=b("p"),Hi.textContent=Rd,Um=r(),g(ya.$$.fragment),xm=r(),Di=b("p"),Di.textContent=Xd,Cm=r(),g(Ma.$$.fragment),$m=r(),wn=b("div"),g(Yl.$$.fragment),vm=r(),Li=b("p"),Li.textContent=zd,km=r(),g(ba.$$.fragment),qm=r(),se=b("div"),g(Rl.$$.fragment),Am=r(),Oi=b("p"),Oi.textContent=Fd,Zm=r(),Pi=b("p"),Pi.innerHTML=Hd,Em=r(),g(ja.$$.fragment),Wm=r(),g(_a.$$.fragment),Nm=r(),Un=b("div"),g(Xl.$$.fragment),Gm=r(),Ki=b("p"),Ki.textContent=Dd,Bm=r(),g(Ta.$$.fragment),Vm=r(),we=b("div"),g(zl.$$.fragment),Qm=r(),er=b("p"),er.textContent=Ld,Sm=r(),g(Ia.$$.fragment),Ym=r(),g(Ja.$$.fragment),Rm=r(),xn=b("div"),g(Fl.$$.fragment),Xm=r(),nr=b("p"),nr.textContent=Od,zm=r(),g(wa.$$.fragment),yr=r(),g(Hl.$$.fragment),Mr=r(),Cn=b("div"),g(Dl.$$.fragment),Fm=r(),tr=b("p"),tr.textContent=Pd,br=r(),g(Ll.$$.fragment),jr=r(),$n=b("div"),g(Ol.$$.fragment),Hm=r(),sr=b("p"),sr.textContent=Kd,_r=r(),g(Pl.$$.fragment),Tr=r(),Kl=b("p"),Kl.innerHTML=ef,Ir=r(),K=b("div"),g(eo.$$.fragment),Dm=r(),ar=b("p"),ar.textContent=nf,Lm=r(),g(Ua.$$.fragment),Om=r(),xa=b("div"),g(no.$$.fragment),Pm=r(),lr=b("p"),lr.textContent=tf,Km=r(),Ca=b("div"),g(to.$$.fragment),eh=r(),or=b("p"),or.textContent=sf,Jr=r(),g(so.$$.fragment),wr=r(),rr=b("p"),this.h()},l(a){const y=ry("svelte-u9bgzb",document.head);n=j(y,"META",{name:!0,content:!0}),y.forEach(M),o=c(a),t=j(a,"P",{}),v(t).forEach(M),s=c(a),u(i.$$.fragment,a),e=c(a),p=j(a,"P",{"data-svelte-h":!0}),I(p)!=="svelte-1jn5i7g"&&(p.innerHTML=nh),cr=c(a),$a=j(a,"OL",{"data-svelte-h":!0}),I($a)!=="svelte-1b8mr6t"&&($a.innerHTML=th),pr=c(a),va=j(a,"P",{"data-svelte-h":!0}),I(va)!=="svelte-s9duup"&&(va.innerHTML=sh),gr=c(a),u(ka.$$.fragment,a),ur=c(a),C=j(a,"DIV",{class:!0});var q=v(C);u(qa.$$.fragment,q),xr=c(q),ro=j(q,"P",{"data-svelte-h":!0}),I(ro)!=="svelte-1p4u01l"&&(ro.textContent=ah),Cr=c(q),co=j(q,"P",{"data-svelte-h":!0}),I(co)!=="svelte-1pw8cnp"&&(co.innerHTML=lh),$r=c(q),Fe=j(q,"DIV",{class:!0});var vn=v(Fe);u(Aa.$$.fragment,vn),vr=c(vn),po=j(vn,"P",{"data-svelte-h":!0}),I(po)!=="svelte-1hs5qib"&&(po.textContent=oh),kr=c(vn),u(pt.$$.fragment,vn),vn.forEach(M),qr=c(q),He=j(q,"DIV",{class:!0});var kn=v(He);u(Za.$$.fragment,kn),Ar=c(kn),go=j(kn,"P",{"data-svelte-h":!0}),I(go)!=="svelte-z9e742"&&(go.textContent=ih),Zr=c(kn),u(gt.$$.fragment,kn),kn.forEach(M),Er=c(q),De=j(q,"DIV",{class:!0});var qn=v(De);u(Ea.$$.fragment,qn),Wr=c(qn),uo=j(qn,"P",{"data-svelte-h":!0}),I(uo)!=="svelte-lahnll"&&(uo.textContent=rh),Nr=c(qn),u(ut.$$.fragment,qn),qn.forEach(M),Gr=c(q),Z=j(q,"DIV",{class:!0});var W=v(Z);u(Wa.$$.fragment,W),Br=c(W),mo=j(W,"P",{"data-svelte-h":!0}),I(mo)!=="svelte-5o70yf"&&(mo.textContent=ch),Vr=c(W),u(mt.$$.fragment,W),Qr=c(W),u(ht.$$.fragment,W),Sr=c(W),u(dt.$$.fragment,W),Yr=c(W),u(ft.$$.fragment,W),Rr=c(W),u(yt.$$.fragment,W),Xr=c(W),ho=j(W,"P",{"data-svelte-h":!0}),I(ho)!=="svelte-m78oie"&&(ho.textContent=ph),zr=c(W),u(Mt.$$.fragment,W),Fr=c(W),fo=j(W,"P",{"data-svelte-h":!0}),I(fo)!=="svelte-gzqu78"&&(fo.textContent=gh),Hr=c(W),u(bt.$$.fragment,W),Dr=c(W),u(jt.$$.fragment,W),Lr=c(W),u(_t.$$.fragment,W),Or=c(W),u(Tt.$$.fragment,W),W.forEach(M),Pr=c(q),Le=j(q,"DIV",{class:!0});var An=v(Le);u(Na.$$.fragment,An),Kr=c(An),yo=j(An,"P",{"data-svelte-h":!0}),I(yo)!=="svelte-qs8cmr"&&(yo.textContent=uh),ec=c(An),u(It.$$.fragment,An),An.forEach(M),nc=c(q),Oe=j(q,"DIV",{class:!0});var Zn=v(Oe);u(Ga.$$.fragment,Zn),tc=c(Zn),Mo=j(Zn,"P",{"data-svelte-h":!0}),I(Mo)!=="svelte-1axtrg9"&&(Mo.textContent=mh),sc=c(Zn),u(Jt.$$.fragment,Zn),Zn.forEach(M),ac=c(q),Pe=j(q,"DIV",{class:!0});var En=v(Pe);u(Ba.$$.fragment,En),lc=c(En),bo=j(En,"P",{"data-svelte-h":!0}),I(bo)!=="svelte-1lnjtsz"&&(bo.textContent=hh),oc=c(En),u(wt.$$.fragment,En),En.forEach(M),ic=c(q),ie=j(q,"DIV",{class:!0});var Ce=v(ie);u(Va.$$.fragment,Ce),rc=c(Ce),jo=j(Ce,"P",{"data-svelte-h":!0}),I(jo)!=="svelte-s2la9t"&&(jo.textContent=dh),cc=c(Ce),_o=j(Ce,"P",{"data-svelte-h":!0}),I(_o)!=="svelte-1xhka28"&&(_o.innerHTML=fh),pc=c(Ce),u(Ut.$$.fragment,Ce),Ce.forEach(M),gc=c(q),re=j(q,"DIV",{class:!0});var $e=v(re);u(Qa.$$.fragment,$e),uc=c($e),To=j($e,"P",{"data-svelte-h":!0}),I(To)!=="svelte-61gv64"&&(To.textContent=yh),mc=c($e),u(xt.$$.fragment,$e),hc=c($e),u(Ct.$$.fragment,$e),$e.forEach(M),dc=c(q),ce=j(q,"DIV",{class:!0});var ve=v(ce);u(Sa.$$.fragment,ve),fc=c(ve),Io=j(ve,"P",{"data-svelte-h":!0}),I(Io)!=="svelte-1m9sgvu"&&(Io.textContent=Mh),yc=c(ve),Jo=j(ve,"P",{"data-svelte-h":!0}),I(Jo)!=="svelte-vl8nvd"&&(Jo.innerHTML=bh),Mc=c(ve),u($t.$$.fragment,ve),ve.forEach(M),bc=c(q),Ke=j(q,"DIV",{class:!0});var Wn=v(Ke);u(Ya.$$.fragment,Wn),jc=c(Wn),wo=j(Wn,"P",{"data-svelte-h":!0}),I(wo)!=="svelte-u63854"&&(wo.textContent=jh),_c=c(Wn),u(vt.$$.fragment,Wn),Wn.forEach(M),Tc=c(q),pe=j(q,"DIV",{class:!0});var ke=v(pe);u(Ra.$$.fragment,ke),Ic=c(ke),Uo=j(ke,"P",{"data-svelte-h":!0}),I(Uo)!=="svelte-k6f11e"&&(Uo.textContent=_h),Jc=c(ke),u(kt.$$.fragment,ke),wc=c(ke),u(qt.$$.fragment,ke),ke.forEach(M),Uc=c(q),ge=j(q,"DIV",{class:!0});var qe=v(ge);u(Xa.$$.fragment,qe),xc=c(qe),xo=j(qe,"P",{"data-svelte-h":!0}),I(xo)!=="svelte-7cx5l1"&&(xo.textContent=Th),Cc=c(qe),u(At.$$.fragment,qe),$c=c(qe),u(Zt.$$.fragment,qe),qe.forEach(M),vc=c(q),ue=j(q,"DIV",{class:!0});var Ae=v(ue);u(za.$$.fragment,Ae),kc=c(Ae),Co=j(Ae,"P",{"data-svelte-h":!0}),I(Co)!=="svelte-1tnfouk"&&(Co.textContent=Ih),qc=c(Ae),$o=j(Ae,"P",{"data-svelte-h":!0}),I($o)!=="svelte-qrqo93"&&($o.textContent=Jh),Ac=c(Ae),u(Et.$$.fragment,Ae),Ae.forEach(M),Zc=c(q),O=j(q,"DIV",{class:!0});var ee=v(O);u(Fa.$$.fragment,ee),Ec=c(ee),vo=j(ee,"P",{"data-svelte-h":!0}),I(vo)!=="svelte-1yinsm0"&&(vo.textContent=wh),Wc=c(ee),ko=j(ee,"P",{"data-svelte-h":!0}),I(ko)!=="svelte-1k36r1q"&&(ko.innerHTML=Uh),Nc=c(ee),u(Wt.$$.fragment,ee),Gc=c(ee),u(Nt.$$.fragment,ee),Bc=c(ee),u(Gt.$$.fragment,ee),ee.forEach(M),Vc=c(q),me=j(q,"DIV",{class:!0});var Ze=v(me);u(Ha.$$.fragment,Ze),Qc=c(Ze),qo=j(Ze,"P",{"data-svelte-h":!0}),I(qo)!=="svelte-fzfwfh"&&(qo.textContent=xh),Sc=c(Ze),u(Bt.$$.fragment,Ze),Yc=c(Ze),u(Vt.$$.fragment,Ze),Ze.forEach(M),Rc=c(q),en=j(q,"DIV",{class:!0});var Nn=v(en);u(Da.$$.fragment,Nn),Xc=c(Nn),Ao=j(Nn,"P",{"data-svelte-h":!0}),I(Ao)!=="svelte-1mibg86"&&(Ao.textContent=Ch),zc=c(Nn),u(Qt.$$.fragment,Nn),Nn.forEach(M),Fc=c(q),nn=j(q,"DIV",{class:!0});var Gn=v(nn);u(La.$$.fragment,Gn),Hc=c(Gn),Zo=j(Gn,"P",{"data-svelte-h":!0}),I(Zo)!=="svelte-1nuhgbh"&&(Zo.textContent=$h),Dc=c(Gn),u(St.$$.fragment,Gn),Gn.forEach(M),Lc=c(q),tn=j(q,"DIV",{class:!0});var Bn=v(tn);u(Oa.$$.fragment,Bn),Oc=c(Bn),Eo=j(Bn,"P",{"data-svelte-h":!0}),I(Eo)!=="svelte-1uepm2o"&&(Eo.textContent=vh),Pc=c(Bn),u(Yt.$$.fragment,Bn),Bn.forEach(M),Kc=c(q),sn=j(q,"DIV",{class:!0});var Vn=v(sn);u(Pa.$$.fragment,Vn),ep=c(Vn),Wo=j(Vn,"P",{"data-svelte-h":!0}),I(Wo)!=="svelte-77a94i"&&(Wo.textContent=kh),np=c(Vn),u(Rt.$$.fragment,Vn),Vn.forEach(M),tp=c(q),an=j(q,"DIV",{class:!0});var Qn=v(an);u(Ka.$$.fragment,Qn),sp=c(Qn),No=j(Qn,"P",{"data-svelte-h":!0}),I(No)!=="svelte-61sxmo"&&(No.textContent=qh),ap=c(Qn),u(Xt.$$.fragment,Qn),Qn.forEach(M),lp=c(q),ln=j(q,"DIV",{class:!0});var Sn=v(ln);u(el.$$.fragment,Sn),op=c(Sn),Go=j(Sn,"P",{"data-svelte-h":!0}),I(Go)!=="svelte-hzldyu"&&(Go.textContent=Ah),ip=c(Sn),u(zt.$$.fragment,Sn),Sn.forEach(M),rp=c(q),on=j(q,"DIV",{class:!0});var Yn=v(on);u(nl.$$.fragment,Yn),cp=c(Yn),Bo=j(Yn,"P",{"data-svelte-h":!0}),I(Bo)!=="svelte-b4yzyj"&&(Bo.textContent=Zh),pp=c(Yn),u(Ft.$$.fragment,Yn),Yn.forEach(M),gp=c(q),he=j(q,"DIV",{class:!0});var Ee=v(he);u(tl.$$.fragment,Ee),up=c(Ee),Vo=j(Ee,"P",{"data-svelte-h":!0}),I(Vo)!=="svelte-qakvx8"&&(Vo.textContent=Eh),mp=c(Ee),u(Ht.$$.fragment,Ee),hp=c(Ee),u(Dt.$$.fragment,Ee),Ee.forEach(M),dp=c(q),Y=j(q,"DIV",{class:!0});var X=v(Y);u(sl.$$.fragment,X),fp=c(X),Qo=j(X,"P",{"data-svelte-h":!0}),I(Qo)!=="svelte-9lmcnw"&&(Qo.textContent=Wh),yp=c(X),u(Lt.$$.fragment,X),Mp=c(X),u(Ot.$$.fragment,X),bp=c(X),u(Pt.$$.fragment,X),jp=xe(X,`
Example using a third-party provider directly. Usage will be billed on your fal.ai account.
`),u(Kt.$$.fragment,X),_p=c(X),So=j(X,"P",{"data-svelte-h":!0}),I(So)!=="svelte-gzqu78"&&(So.textContent=Nh),Tp=c(X),u(es.$$.fragment,X),Ip=c(X),Yo=j(X,"P",{"data-svelte-h":!0}),I(Yo)!=="svelte-q7xnhs"&&(Yo.textContent=Gh),Jp=c(X),u(ns.$$.fragment,X),X.forEach(M),wp=c(q),G=j(q,"DIV",{class:!0});var Q=v(G);u(al.$$.fragment,Q),Up=c(Q),Ro=j(Q,"P",{"data-svelte-h":!0}),I(Ro)!=="svelte-12mjzdy"&&(Ro.textContent=Bh),xp=c(Q),u(ts.$$.fragment,Q),Cp=c(Q),u(ss.$$.fragment,Q),$p=c(Q),Xo=j(Q,"P",{"data-svelte-h":!0}),I(Xo)!=="svelte-6wr902"&&(Xo.textContent=Vh),vp=c(Q),u(as.$$.fragment,Q),kp=c(Q),zo=j(Q,"P",{"data-svelte-h":!0}),I(zo)!=="svelte-gzqu78"&&(zo.textContent=Qh),qp=c(Q),u(ls.$$.fragment,Q),Ap=xe(Q,`
Example using Replicate provider with extra parameters
`),u(os.$$.fragment,Q),Zp=c(Q),Fo=j(Q,"P",{"data-svelte-h":!0}),I(Fo)!=="svelte-ecr35g"&&(Fo.textContent=Sh),Ep=c(Q),u(is.$$.fragment,Q),Q.forEach(M),Wp=c(q),F=j(q,"DIV",{class:!0});var D=v(F);u(ll.$$.fragment,D),Np=c(D),Ho=j(D,"P",{"data-svelte-h":!0}),I(Ho)!=="svelte-17lryks"&&(Ho.textContent=Yh),Gp=c(D),u(rs.$$.fragment,D),Bp=c(D),Do=j(D,"P",{"data-svelte-h":!0}),I(Do)!=="svelte-11lpom8"&&(Do.textContent=Rh),Vp=c(D),Lo=j(D,"P",{"data-svelte-h":!0}),I(Lo)!=="svelte-vt1ppo"&&(Lo.textContent=Xh),Qp=c(D),u(cs.$$.fragment,D),Sp=c(D),Oo=j(D,"P",{"data-svelte-h":!0}),I(Oo)!=="svelte-gzqu78"&&(Oo.textContent=zh),Yp=c(D),u(ps.$$.fragment,D),D.forEach(M),Rp=c(q),rn=j(q,"DIV",{class:!0});var Rn=v(rn);u(ol.$$.fragment,Rn),Xp=c(Rn),Po=j(Rn,"P",{"data-svelte-h":!0}),I(Po)!=="svelte-1araal"&&(Po.textContent=Fh),zp=c(Rn),u(gs.$$.fragment,Rn),Rn.forEach(M),Fp=c(q),te=j(q,"DIV",{class:!0});var ae=v(te);u(il.$$.fragment,ae),Hp=c(ae),Ko=j(ae,"P",{"data-svelte-h":!0}),I(Ko)!=="svelte-1v3lqck"&&(Ko.textContent=Hh),Dp=c(ae),ei=j(ae,"P",{"data-svelte-h":!0}),I(ei)!=="svelte-jwmjgr"&&(ei.innerHTML=Dh),Lp=c(ae),u(us.$$.fragment,ae),Op=c(ae),u(ms.$$.fragment,ae),ae.forEach(M),Pp=c(q),cn=j(q,"DIV",{class:!0});var Xn=v(cn);u(rl.$$.fragment,Xn),Kp=c(Xn),ni=j(Xn,"P",{"data-svelte-h":!0}),I(ni)!=="svelte-1jbp6ey"&&(ni.textContent=Lh),eg=c(Xn),u(hs.$$.fragment,Xn),Xn.forEach(M),ng=c(q),de=j(q,"DIV",{class:!0});var We=v(de);u(cl.$$.fragment,We),tg=c(We),ti=j(We,"P",{"data-svelte-h":!0}),I(ti)!=="svelte-1c9xuqj"&&(ti.textContent=Oh),sg=c(We),u(ds.$$.fragment,We),ag=c(We),u(fs.$$.fragment,We),We.forEach(M),lg=c(q),pn=j(q,"DIV",{class:!0});var zn=v(pn);u(pl.$$.fragment,zn),og=c(zn),si=j(zn,"P",{"data-svelte-h":!0}),I(si)!=="svelte-108ipf8"&&(si.textContent=Ph),ig=c(zn),u(ys.$$.fragment,zn),zn.forEach(M),q.forEach(M),mr=c(a),u(gl.$$.fragment,a),hr=c(a),ul=j(a,"P",{"data-svelte-h":!0}),I(ul)!=="svelte-nn0rvx"&&(ul.innerHTML=Kh),dr=c(a),u(ml.$$.fragment,a),fr=c(a),x=j(a,"DIV",{class:!0});var $=v(x);u(hl.$$.fragment,$),rg=c($),ai=j($,"P",{"data-svelte-h":!0}),I(ai)!=="svelte-1p4u01l"&&(ai.textContent=ed),cg=c($),li=j($,"P",{"data-svelte-h":!0}),I(li)!=="svelte-1pw8cnp"&&(li.innerHTML=nd),pg=c($),gn=j($,"DIV",{class:!0});var Fn=v(gn);u(dl.$$.fragment,Fn),gg=c(Fn),oi=j(Fn,"P",{"data-svelte-h":!0}),I(oi)!=="svelte-1hs5qib"&&(oi.textContent=td),ug=c(Fn),u(Ms.$$.fragment,Fn),Fn.forEach(M),mg=c($),un=j($,"DIV",{class:!0});var Hn=v(un);u(fl.$$.fragment,Hn),hg=c(Hn),ii=j(Hn,"P",{"data-svelte-h":!0}),I(ii)!=="svelte-z9e742"&&(ii.textContent=sd),dg=c(Hn),u(bs.$$.fragment,Hn),Hn.forEach(M),fg=c($),mn=j($,"DIV",{class:!0});var Dn=v(mn);u(yl.$$.fragment,Dn),yg=c(Dn),ri=j(Dn,"P",{"data-svelte-h":!0}),I(ri)!=="svelte-lahnll"&&(ri.textContent=ad),Mg=c(Dn),u(js.$$.fragment,Dn),Dn.forEach(M),bg=c($),E=j($,"DIV",{class:!0});var N=v(E);u(Ml.$$.fragment,N),jg=c(N),ci=j(N,"P",{"data-svelte-h":!0}),I(ci)!=="svelte-5o70yf"&&(ci.textContent=ld),_g=c(N),u(_s.$$.fragment,N),Tg=c(N),u(Ts.$$.fragment,N),Ig=c(N),u(Is.$$.fragment,N),Jg=c(N),u(Js.$$.fragment,N),wg=c(N),u(ws.$$.fragment,N),Ug=c(N),pi=j(N,"P",{"data-svelte-h":!0}),I(pi)!=="svelte-m78oie"&&(pi.textContent=od),xg=c(N),u(Us.$$.fragment,N),Cg=c(N),gi=j(N,"P",{"data-svelte-h":!0}),I(gi)!=="svelte-gzqu78"&&(gi.textContent=id),$g=c(N),u(xs.$$.fragment,N),vg=c(N),u(Cs.$$.fragment,N),kg=c(N),u($s.$$.fragment,N),qg=c(N),u(vs.$$.fragment,N),N.forEach(M),Ag=c($),fe=j($,"DIV",{class:!0});var Ne=v(fe);u(bl.$$.fragment,Ne),Zg=c(Ne),ui=j(Ne,"P",{"data-svelte-h":!0}),I(ui)!=="svelte-vcr7iw"&&(ui.textContent=rd),Eg=c(Ne),mi=j(Ne,"P",{"data-svelte-h":!0}),I(mi)!=="svelte-1jtca0b"&&(mi.textContent=cd),Wg=c(Ne),hi=j(Ne,"P",{"data-svelte-h":!0}),I(hi)!=="svelte-1sz3ulv"&&(hi.innerHTML=pd),Ne.forEach(M),Ng=c($),hn=j($,"DIV",{class:!0});var Ln=v(hn);u(jl.$$.fragment,Ln),Gg=c(Ln),di=j(Ln,"P",{"data-svelte-h":!0}),I(di)!=="svelte-qs8cmr"&&(di.textContent=gd),Bg=c(Ln),u(ks.$$.fragment,Ln),Ln.forEach(M),Vg=c($),dn=j($,"DIV",{class:!0});var On=v(dn);u(_l.$$.fragment,On),Qg=c(On),fi=j(On,"P",{"data-svelte-h":!0}),I(fi)!=="svelte-1axtrg9"&&(fi.textContent=ud),Sg=c(On),u(qs.$$.fragment,On),On.forEach(M),Yg=c($),fn=j($,"DIV",{class:!0});var Pn=v(fn);u(Tl.$$.fragment,Pn),Rg=c(Pn),yi=j(Pn,"P",{"data-svelte-h":!0}),I(yi)!=="svelte-1lnjtsz"&&(yi.textContent=md),Xg=c(Pn),u(As.$$.fragment,Pn),Pn.forEach(M),zg=c($),ye=j($,"DIV",{class:!0});var Ge=v(ye);u(Il.$$.fragment,Ge),Fg=c(Ge),Mi=j(Ge,"P",{"data-svelte-h":!0}),I(Mi)!=="svelte-s2la9t"&&(Mi.textContent=hd),Hg=c(Ge),bi=j(Ge,"P",{"data-svelte-h":!0}),I(bi)!=="svelte-1xhka28"&&(bi.innerHTML=dd),Dg=c(Ge),u(Zs.$$.fragment,Ge),Ge.forEach(M),Lg=c($),Me=j($,"DIV",{class:!0});var Be=v(Me);u(Jl.$$.fragment,Be),Og=c(Be),ji=j(Be,"P",{"data-svelte-h":!0}),I(ji)!=="svelte-61gv64"&&(ji.textContent=fd),Pg=c(Be),u(Es.$$.fragment,Be),Kg=c(Be),u(Ws.$$.fragment,Be),Be.forEach(M),eu=c($),be=j($,"DIV",{class:!0});var Ve=v(be);u(wl.$$.fragment,Ve),nu=c(Ve),_i=j(Ve,"P",{"data-svelte-h":!0}),I(_i)!=="svelte-1m9sgvu"&&(_i.textContent=yd),tu=c(Ve),Ti=j(Ve,"P",{"data-svelte-h":!0}),I(Ti)!=="svelte-vl8nvd"&&(Ti.innerHTML=Md),su=c(Ve),u(Ns.$$.fragment,Ve),Ve.forEach(M),au=c($),yn=j($,"DIV",{class:!0});var Kn=v(yn);u(Ul.$$.fragment,Kn),lu=c(Kn),Ii=j(Kn,"P",{"data-svelte-h":!0}),I(Ii)!=="svelte-u63854"&&(Ii.textContent=bd),ou=c(Kn),u(Gs.$$.fragment,Kn),Kn.forEach(M),iu=c($),je=j($,"DIV",{class:!0});var Qe=v(je);u(xl.$$.fragment,Qe),ru=c(Qe),Ji=j(Qe,"P",{"data-svelte-h":!0}),I(Ji)!=="svelte-k6f11e"&&(Ji.textContent=jd),cu=c(Qe),u(Bs.$$.fragment,Qe),pu=c(Qe),u(Vs.$$.fragment,Qe),Qe.forEach(M),gu=c($),_e=j($,"DIV",{class:!0});var Se=v(_e);u(Cl.$$.fragment,Se),uu=c(Se),wi=j(Se,"P",{"data-svelte-h":!0}),I(wi)!=="svelte-7cx5l1"&&(wi.textContent=_d),mu=c(Se),u(Qs.$$.fragment,Se),hu=c(Se),u(Ss.$$.fragment,Se),Se.forEach(M),du=c($),Te=j($,"DIV",{class:!0});var Ye=v(Te);u($l.$$.fragment,Ye),fu=c(Ye),Ui=j(Ye,"P",{"data-svelte-h":!0}),I(Ui)!=="svelte-1tnfouk"&&(Ui.textContent=Td),yu=c(Ye),xi=j(Ye,"P",{"data-svelte-h":!0}),I(xi)!=="svelte-qrqo93"&&(xi.textContent=Id),Mu=c(Ye),u(Ys.$$.fragment,Ye),Ye.forEach(M),bu=c($),P=j($,"DIV",{class:!0});var ne=v(P);u(vl.$$.fragment,ne),ju=c(ne),Ci=j(ne,"P",{"data-svelte-h":!0}),I(Ci)!=="svelte-1yinsm0"&&(Ci.textContent=Jd),_u=c(ne),$i=j(ne,"P",{"data-svelte-h":!0}),I($i)!=="svelte-1k36r1q"&&($i.innerHTML=wd),Tu=c(ne),u(Rs.$$.fragment,ne),Iu=c(ne),u(Xs.$$.fragment,ne),Ju=c(ne),u(zs.$$.fragment,ne),ne.forEach(M),wu=c($),Ie=j($,"DIV",{class:!0});var Re=v(Ie);u(kl.$$.fragment,Re),Uu=c(Re),vi=j(Re,"P",{"data-svelte-h":!0}),I(vi)!=="svelte-fzfwfh"&&(vi.textContent=Ud),xu=c(Re),u(Fs.$$.fragment,Re),Cu=c(Re),u(Hs.$$.fragment,Re),Re.forEach(M),$u=c($),Mn=j($,"DIV",{class:!0});var et=v(Mn);u(ql.$$.fragment,et),vu=c(et),ki=j(et,"P",{"data-svelte-h":!0}),I(ki)!=="svelte-1mibg86"&&(ki.textContent=xd),ku=c(et),u(Ds.$$.fragment,et),et.forEach(M),qu=c($),bn=j($,"DIV",{class:!0});var nt=v(bn);u(Al.$$.fragment,nt),Au=c(nt),qi=j(nt,"P",{"data-svelte-h":!0}),I(qi)!=="svelte-1nuhgbh"&&(qi.textContent=Cd),Zu=c(nt),u(Ls.$$.fragment,nt),nt.forEach(M),Eu=c($),jn=j($,"DIV",{class:!0});var tt=v(jn);u(Zl.$$.fragment,tt),Wu=c(tt),Ai=j(tt,"P",{"data-svelte-h":!0}),I(Ai)!=="svelte-1uepm2o"&&(Ai.textContent=$d),Nu=c(tt),u(Os.$$.fragment,tt),tt.forEach(M),Gu=c($),_n=j($,"DIV",{class:!0});var st=v(_n);u(El.$$.fragment,st),Bu=c(st),Zi=j(st,"P",{"data-svelte-h":!0}),I(Zi)!=="svelte-77a94i"&&(Zi.textContent=vd),Vu=c(st),u(Ps.$$.fragment,st),st.forEach(M),Qu=c($),Tn=j($,"DIV",{class:!0});var at=v(Tn);u(Wl.$$.fragment,at),Su=c(at),Ei=j(at,"P",{"data-svelte-h":!0}),I(Ei)!=="svelte-61sxmo"&&(Ei.textContent=kd),Yu=c(at),u(Ks.$$.fragment,at),at.forEach(M),Ru=c($),In=j($,"DIV",{class:!0});var lt=v(In);u(Nl.$$.fragment,lt),Xu=c(lt),Wi=j(lt,"P",{"data-svelte-h":!0}),I(Wi)!=="svelte-hzldyu"&&(Wi.textContent=qd),zu=c(lt),u(ea.$$.fragment,lt),lt.forEach(M),Fu=c($),Jn=j($,"DIV",{class:!0});var ot=v(Jn);u(Gl.$$.fragment,ot),Hu=c(ot),Ni=j(ot,"P",{"data-svelte-h":!0}),I(Ni)!=="svelte-b4yzyj"&&(Ni.textContent=Ad),Du=c(ot),u(na.$$.fragment,ot),ot.forEach(M),Lu=c($),Je=j($,"DIV",{class:!0});var Xe=v(Je);u(Bl.$$.fragment,Xe),Ou=c(Xe),Gi=j(Xe,"P",{"data-svelte-h":!0}),I(Gi)!=="svelte-qakvx8"&&(Gi.textContent=Zd),Pu=c(Xe),u(ta.$$.fragment,Xe),Ku=c(Xe),u(sa.$$.fragment,Xe),Xe.forEach(M),em=c($),R=j($,"DIV",{class:!0});var z=v(R);u(Vl.$$.fragment,z),nm=c(z),Bi=j(z,"P",{"data-svelte-h":!0}),I(Bi)!=="svelte-9lmcnw"&&(Bi.textContent=Ed),tm=c(z),u(aa.$$.fragment,z),sm=c(z),u(la.$$.fragment,z),am=c(z),u(oa.$$.fragment,z),lm=xe(z,`
Example using a third-party provider directly. Usage will be billed on your fal.ai account.
`),u(ia.$$.fragment,z),om=c(z),Vi=j(z,"P",{"data-svelte-h":!0}),I(Vi)!=="svelte-gzqu78"&&(Vi.textContent=Wd),im=c(z),u(ra.$$.fragment,z),rm=c(z),Qi=j(z,"P",{"data-svelte-h":!0}),I(Qi)!=="svelte-q7xnhs"&&(Qi.textContent=Nd),cm=c(z),u(ca.$$.fragment,z),z.forEach(M),pm=c($),B=j($,"DIV",{class:!0});var S=v(B);u(Ql.$$.fragment,S),gm=c(S),Si=j(S,"P",{"data-svelte-h":!0}),I(Si)!=="svelte-12mjzdy"&&(Si.textContent=Gd),um=c(S),u(pa.$$.fragment,S),mm=c(S),u(ga.$$.fragment,S),hm=c(S),Yi=j(S,"P",{"data-svelte-h":!0}),I(Yi)!=="svelte-6wr902"&&(Yi.textContent=Bd),dm=c(S),u(ua.$$.fragment,S),fm=c(S),Ri=j(S,"P",{"data-svelte-h":!0}),I(Ri)!=="svelte-gzqu78"&&(Ri.textContent=Vd),ym=c(S),u(ma.$$.fragment,S),Mm=xe(S,`
Example using Replicate provider with extra parameters
`),u(ha.$$.fragment,S),bm=c(S),Xi=j(S,"P",{"data-svelte-h":!0}),I(Xi)!=="svelte-ecr35g"&&(Xi.textContent=Qd),jm=c(S),u(da.$$.fragment,S),S.forEach(M),_m=c($),H=j($,"DIV",{class:!0});var L=v(H);u(Sl.$$.fragment,L),Tm=c(L),zi=j(L,"P",{"data-svelte-h":!0}),I(zi)!=="svelte-17lryks"&&(zi.textContent=Sd),Im=c(L),u(fa.$$.fragment,L),Jm=c(L),Fi=j(L,"P",{"data-svelte-h":!0}),I(Fi)!=="svelte-11lpom8"&&(Fi.textContent=Yd),wm=c(L),Hi=j(L,"P",{"data-svelte-h":!0}),I(Hi)!=="svelte-vt1ppo"&&(Hi.textContent=Rd),Um=c(L),u(ya.$$.fragment,L),xm=c(L),Di=j(L,"P",{"data-svelte-h":!0}),I(Di)!=="svelte-gzqu78"&&(Di.textContent=Xd),Cm=c(L),u(Ma.$$.fragment,L),L.forEach(M),$m=c($),wn=j($,"DIV",{class:!0});var it=v(wn);u(Yl.$$.fragment,it),vm=c(it),Li=j(it,"P",{"data-svelte-h":!0}),I(Li)!=="svelte-1araal"&&(Li.textContent=zd),km=c(it),u(ba.$$.fragment,it),it.forEach(M),qm=c($),se=j($,"DIV",{class:!0});var le=v(se);u(Rl.$$.fragment,le),Am=c(le),Oi=j(le,"P",{"data-svelte-h":!0}),I(Oi)!=="svelte-1v3lqck"&&(Oi.textContent=Fd),Zm=c(le),Pi=j(le,"P",{"data-svelte-h":!0}),I(Pi)!=="svelte-jwmjgr"&&(Pi.innerHTML=Hd),Em=c(le),u(ja.$$.fragment,le),Wm=c(le),u(_a.$$.fragment,le),le.forEach(M),Nm=c($),Un=j($,"DIV",{class:!0});var rt=v(Un);u(Xl.$$.fragment,rt),Gm=c(rt),Ki=j(rt,"P",{"data-svelte-h":!0}),I(Ki)!=="svelte-1jbp6ey"&&(Ki.textContent=Dd),Bm=c(rt),u(Ta.$$.fragment,rt),rt.forEach(M),Vm=c($),we=j($,"DIV",{class:!0});var ze=v(we);u(zl.$$.fragment,ze),Qm=c(ze),er=j(ze,"P",{"data-svelte-h":!0}),I(er)!=="svelte-1c9xuqj"&&(er.textContent=Ld),Sm=c(ze),u(Ia.$$.fragment,ze),Ym=c(ze),u(Ja.$$.fragment,ze),ze.forEach(M),Rm=c($),xn=j($,"DIV",{class:!0});var ct=v(xn);u(Fl.$$.fragment,ct),Xm=c(ct),nr=j(ct,"P",{"data-svelte-h":!0}),I(nr)!=="svelte-108ipf8"&&(nr.textContent=Od),zm=c(ct),u(wa.$$.fragment,ct),ct.forEach(M),$.forEach(M),yr=c(a),u(Hl.$$.fragment,a),Mr=c(a),Cn=j(a,"DIV",{class:!0});var ao=v(Cn);u(Dl.$$.fragment,ao),Fm=c(ao),tr=j(ao,"P",{"data-svelte-h":!0}),I(tr)!=="svelte-2793d9"&&(tr.textContent=Pd),ao.forEach(M),br=c(a),u(Ll.$$.fragment,a),jr=c(a),$n=j(a,"DIV",{class:!0});var lo=v($n);u(Ol.$$.fragment,lo),Hm=c(lo),sr=j(lo,"P",{"data-svelte-h":!0}),I(sr)!=="svelte-pxiqlg"&&(sr.textContent=Kd),lo.forEach(M),_r=c(a),u(Pl.$$.fragment,a),Tr=c(a),Kl=j(a,"P",{"data-svelte-h":!0}),I(Kl)!=="svelte-t9bv3o"&&(Kl.innerHTML=ef),Ir=c(a),K=j(a,"DIV",{class:!0});var oe=v(K);u(eo.$$.fragment,oe),Dm=c(oe),ar=j(oe,"P",{"data-svelte-h":!0}),I(ar)!=="svelte-xkrgz1"&&(ar.textContent=nf),Lm=c(oe),u(Ua.$$.fragment,oe),Om=c(oe),xa=j(oe,"DIV",{class:!0});var oo=v(xa);u(no.$$.fragment,oo),Pm=c(oo),lr=j(oo,"P",{"data-svelte-h":!0}),I(lr)!=="svelte-1ruvvxs"&&(lr.textContent=tf),oo.forEach(M),Km=c(oe),Ca=j(oe,"DIV",{class:!0});var io=v(Ca);u(to.$$.fragment,io),eh=c(io),or=j(io,"P",{"data-svelte-h":!0}),I(or)!=="svelte-ss15d2"&&(or.textContent=sf),io.forEach(M),oe.forEach(M),Jr=c(a),u(so.$$.fragment,a),wr=c(a),rr=j(a,"P",{}),v(rr).forEach(M),this.h()},h(){k(n,"name","hf:doc:metadata"),k(n,"content",Cb),k(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(xa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ca,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(a,y){l(document.head,n),T(a,o,y),T(a,t,y),T(a,s,y),m(i,a,y),T(a,e,y),T(a,p,y),T(a,cr,y),T(a,$a,y),T(a,pr,y),T(a,va,y),T(a,gr,y),m(ka,a,y),T(a,ur,y),T(a,C,y),m(qa,C,null),l(C,xr),l(C,ro),l(C,Cr),l(C,co),l(C,$r),l(C,Fe),m(Aa,Fe,null),l(Fe,vr),l(Fe,po),l(Fe,kr),m(pt,Fe,null),l(C,qr),l(C,He),m(Za,He,null),l(He,Ar),l(He,go),l(He,Zr),m(gt,He,null),l(C,Er),l(C,De),m(Ea,De,null),l(De,Wr),l(De,uo),l(De,Nr),m(ut,De,null),l(C,Gr),l(C,Z),m(Wa,Z,null),l(Z,Br),l(Z,mo),l(Z,Vr),m(mt,Z,null),l(Z,Qr),m(ht,Z,null),l(Z,Sr),m(dt,Z,null),l(Z,Yr),m(ft,Z,null),l(Z,Rr),m(yt,Z,null),l(Z,Xr),l(Z,ho),l(Z,zr),m(Mt,Z,null),l(Z,Fr),l(Z,fo),l(Z,Hr),m(bt,Z,null),l(Z,Dr),m(jt,Z,null),l(Z,Lr),m(_t,Z,null),l(Z,Or),m(Tt,Z,null),l(C,Pr),l(C,Le),m(Na,Le,null),l(Le,Kr),l(Le,yo),l(Le,ec),m(It,Le,null),l(C,nc),l(C,Oe),m(Ga,Oe,null),l(Oe,tc),l(Oe,Mo),l(Oe,sc),m(Jt,Oe,null),l(C,ac),l(C,Pe),m(Ba,Pe,null),l(Pe,lc),l(Pe,bo),l(Pe,oc),m(wt,Pe,null),l(C,ic),l(C,ie),m(Va,ie,null),l(ie,rc),l(ie,jo),l(ie,cc),l(ie,_o),l(ie,pc),m(Ut,ie,null),l(C,gc),l(C,re),m(Qa,re,null),l(re,uc),l(re,To),l(re,mc),m(xt,re,null),l(re,hc),m(Ct,re,null),l(C,dc),l(C,ce),m(Sa,ce,null),l(ce,fc),l(ce,Io),l(ce,yc),l(ce,Jo),l(ce,Mc),m($t,ce,null),l(C,bc),l(C,Ke),m(Ya,Ke,null),l(Ke,jc),l(Ke,wo),l(Ke,_c),m(vt,Ke,null),l(C,Tc),l(C,pe),m(Ra,pe,null),l(pe,Ic),l(pe,Uo),l(pe,Jc),m(kt,pe,null),l(pe,wc),m(qt,pe,null),l(C,Uc),l(C,ge),m(Xa,ge,null),l(ge,xc),l(ge,xo),l(ge,Cc),m(At,ge,null),l(ge,$c),m(Zt,ge,null),l(C,vc),l(C,ue),m(za,ue,null),l(ue,kc),l(ue,Co),l(ue,qc),l(ue,$o),l(ue,Ac),m(Et,ue,null),l(C,Zc),l(C,O),m(Fa,O,null),l(O,Ec),l(O,vo),l(O,Wc),l(O,ko),l(O,Nc),m(Wt,O,null),l(O,Gc),m(Nt,O,null),l(O,Bc),m(Gt,O,null),l(C,Vc),l(C,me),m(Ha,me,null),l(me,Qc),l(me,qo),l(me,Sc),m(Bt,me,null),l(me,Yc),m(Vt,me,null),l(C,Rc),l(C,en),m(Da,en,null),l(en,Xc),l(en,Ao),l(en,zc),m(Qt,en,null),l(C,Fc),l(C,nn),m(La,nn,null),l(nn,Hc),l(nn,Zo),l(nn,Dc),m(St,nn,null),l(C,Lc),l(C,tn),m(Oa,tn,null),l(tn,Oc),l(tn,Eo),l(tn,Pc),m(Yt,tn,null),l(C,Kc),l(C,sn),m(Pa,sn,null),l(sn,ep),l(sn,Wo),l(sn,np),m(Rt,sn,null),l(C,tp),l(C,an),m(Ka,an,null),l(an,sp),l(an,No),l(an,ap),m(Xt,an,null),l(C,lp),l(C,ln),m(el,ln,null),l(ln,op),l(ln,Go),l(ln,ip),m(zt,ln,null),l(C,rp),l(C,on),m(nl,on,null),l(on,cp),l(on,Bo),l(on,pp),m(Ft,on,null),l(C,gp),l(C,he),m(tl,he,null),l(he,up),l(he,Vo),l(he,mp),m(Ht,he,null),l(he,hp),m(Dt,he,null),l(C,dp),l(C,Y),m(sl,Y,null),l(Y,fp),l(Y,Qo),l(Y,yp),m(Lt,Y,null),l(Y,Mp),m(Ot,Y,null),l(Y,bp),m(Pt,Y,null),l(Y,jp),m(Kt,Y,null),l(Y,_p),l(Y,So),l(Y,Tp),m(es,Y,null),l(Y,Ip),l(Y,Yo),l(Y,Jp),m(ns,Y,null),l(C,wp),l(C,G),m(al,G,null),l(G,Up),l(G,Ro),l(G,xp),m(ts,G,null),l(G,Cp),m(ss,G,null),l(G,$p),l(G,Xo),l(G,vp),m(as,G,null),l(G,kp),l(G,zo),l(G,qp),m(ls,G,null),l(G,Ap),m(os,G,null),l(G,Zp),l(G,Fo),l(G,Ep),m(is,G,null),l(C,Wp),l(C,F),m(ll,F,null),l(F,Np),l(F,Ho),l(F,Gp),m(rs,F,null),l(F,Bp),l(F,Do),l(F,Vp),l(F,Lo),l(F,Qp),m(cs,F,null),l(F,Sp),l(F,Oo),l(F,Yp),m(ps,F,null),l(C,Rp),l(C,rn),m(ol,rn,null),l(rn,Xp),l(rn,Po),l(rn,zp),m(gs,rn,null),l(C,Fp),l(C,te),m(il,te,null),l(te,Hp),l(te,Ko),l(te,Dp),l(te,ei),l(te,Lp),m(us,te,null),l(te,Op),m(ms,te,null),l(C,Pp),l(C,cn),m(rl,cn,null),l(cn,Kp),l(cn,ni),l(cn,eg),m(hs,cn,null),l(C,ng),l(C,de),m(cl,de,null),l(de,tg),l(de,ti),l(de,sg),m(ds,de,null),l(de,ag),m(fs,de,null),l(C,lg),l(C,pn),m(pl,pn,null),l(pn,og),l(pn,si),l(pn,ig),m(ys,pn,null),T(a,mr,y),m(gl,a,y),T(a,hr,y),T(a,ul,y),T(a,dr,y),m(ml,a,y),T(a,fr,y),T(a,x,y),m(hl,x,null),l(x,rg),l(x,ai),l(x,cg),l(x,li),l(x,pg),l(x,gn),m(dl,gn,null),l(gn,gg),l(gn,oi),l(gn,ug),m(Ms,gn,null),l(x,mg),l(x,un),m(fl,un,null),l(un,hg),l(un,ii),l(un,dg),m(bs,un,null),l(x,fg),l(x,mn),m(yl,mn,null),l(mn,yg),l(mn,ri),l(mn,Mg),m(js,mn,null),l(x,bg),l(x,E),m(Ml,E,null),l(E,jg),l(E,ci),l(E,_g),m(_s,E,null),l(E,Tg),m(Ts,E,null),l(E,Ig),m(Is,E,null),l(E,Jg),m(Js,E,null),l(E,wg),m(ws,E,null),l(E,Ug),l(E,pi),l(E,xg),m(Us,E,null),l(E,Cg),l(E,gi),l(E,$g),m(xs,E,null),l(E,vg),m(Cs,E,null),l(E,kg),m($s,E,null),l(E,qg),m(vs,E,null),l(x,Ag),l(x,fe),m(bl,fe,null),l(fe,Zg),l(fe,ui),l(fe,Eg),l(fe,mi),l(fe,Wg),l(fe,hi),l(x,Ng),l(x,hn),m(jl,hn,null),l(hn,Gg),l(hn,di),l(hn,Bg),m(ks,hn,null),l(x,Vg),l(x,dn),m(_l,dn,null),l(dn,Qg),l(dn,fi),l(dn,Sg),m(qs,dn,null),l(x,Yg),l(x,fn),m(Tl,fn,null),l(fn,Rg),l(fn,yi),l(fn,Xg),m(As,fn,null),l(x,zg),l(x,ye),m(Il,ye,null),l(ye,Fg),l(ye,Mi),l(ye,Hg),l(ye,bi),l(ye,Dg),m(Zs,ye,null),l(x,Lg),l(x,Me),m(Jl,Me,null),l(Me,Og),l(Me,ji),l(Me,Pg),m(Es,Me,null),l(Me,Kg),m(Ws,Me,null),l(x,eu),l(x,be),m(wl,be,null),l(be,nu),l(be,_i),l(be,tu),l(be,Ti),l(be,su),m(Ns,be,null),l(x,au),l(x,yn),m(Ul,yn,null),l(yn,lu),l(yn,Ii),l(yn,ou),m(Gs,yn,null),l(x,iu),l(x,je),m(xl,je,null),l(je,ru),l(je,Ji),l(je,cu),m(Bs,je,null),l(je,pu),m(Vs,je,null),l(x,gu),l(x,_e),m(Cl,_e,null),l(_e,uu),l(_e,wi),l(_e,mu),m(Qs,_e,null),l(_e,hu),m(Ss,_e,null),l(x,du),l(x,Te),m($l,Te,null),l(Te,fu),l(Te,Ui),l(Te,yu),l(Te,xi),l(Te,Mu),m(Ys,Te,null),l(x,bu),l(x,P),m(vl,P,null),l(P,ju),l(P,Ci),l(P,_u),l(P,$i),l(P,Tu),m(Rs,P,null),l(P,Iu),m(Xs,P,null),l(P,Ju),m(zs,P,null),l(x,wu),l(x,Ie),m(kl,Ie,null),l(Ie,Uu),l(Ie,vi),l(Ie,xu),m(Fs,Ie,null),l(Ie,Cu),m(Hs,Ie,null),l(x,$u),l(x,Mn),m(ql,Mn,null),l(Mn,vu),l(Mn,ki),l(Mn,ku),m(Ds,Mn,null),l(x,qu),l(x,bn),m(Al,bn,null),l(bn,Au),l(bn,qi),l(bn,Zu),m(Ls,bn,null),l(x,Eu),l(x,jn),m(Zl,jn,null),l(jn,Wu),l(jn,Ai),l(jn,Nu),m(Os,jn,null),l(x,Gu),l(x,_n),m(El,_n,null),l(_n,Bu),l(_n,Zi),l(_n,Vu),m(Ps,_n,null),l(x,Qu),l(x,Tn),m(Wl,Tn,null),l(Tn,Su),l(Tn,Ei),l(Tn,Yu),m(Ks,Tn,null),l(x,Ru),l(x,In),m(Nl,In,null),l(In,Xu),l(In,Wi),l(In,zu),m(ea,In,null),l(x,Fu),l(x,Jn),m(Gl,Jn,null),l(Jn,Hu),l(Jn,Ni),l(Jn,Du),m(na,Jn,null),l(x,Lu),l(x,Je),m(Bl,Je,null),l(Je,Ou),l(Je,Gi),l(Je,Pu),m(ta,Je,null),l(Je,Ku),m(sa,Je,null),l(x,em),l(x,R),m(Vl,R,null),l(R,nm),l(R,Bi),l(R,tm),m(aa,R,null),l(R,sm),m(la,R,null),l(R,am),m(oa,R,null),l(R,lm),m(ia,R,null),l(R,om),l(R,Vi),l(R,im),m(ra,R,null),l(R,rm),l(R,Qi),l(R,cm),m(ca,R,null),l(x,pm),l(x,B),m(Ql,B,null),l(B,gm),l(B,Si),l(B,um),m(pa,B,null),l(B,mm),m(ga,B,null),l(B,hm),l(B,Yi),l(B,dm),m(ua,B,null),l(B,fm),l(B,Ri),l(B,ym),m(ma,B,null),l(B,Mm),m(ha,B,null),l(B,bm),l(B,Xi),l(B,jm),m(da,B,null),l(x,_m),l(x,H),m(Sl,H,null),l(H,Tm),l(H,zi),l(H,Im),m(fa,H,null),l(H,Jm),l(H,Fi),l(H,wm),l(H,Hi),l(H,Um),m(ya,H,null),l(H,xm),l(H,Di),l(H,Cm),m(Ma,H,null),l(x,$m),l(x,wn),m(Yl,wn,null),l(wn,vm),l(wn,Li),l(wn,km),m(ba,wn,null),l(x,qm),l(x,se),m(Rl,se,null),l(se,Am),l(se,Oi),l(se,Zm),l(se,Pi),l(se,Em),m(ja,se,null),l(se,Wm),m(_a,se,null),l(x,Nm),l(x,Un),m(Xl,Un,null),l(Un,Gm),l(Un,Ki),l(Un,Bm),m(Ta,Un,null),l(x,Vm),l(x,we),m(zl,we,null),l(we,Qm),l(we,er),l(we,Sm),m(Ia,we,null),l(we,Ym),m(Ja,we,null),l(x,Rm),l(x,xn),m(Fl,xn,null),l(xn,Xm),l(xn,nr),l(xn,zm),m(wa,xn,null),T(a,yr,y),m(Hl,a,y),T(a,Mr,y),T(a,Cn,y),m(Dl,Cn,null),l(Cn,Fm),l(Cn,tr),T(a,br,y),m(Ll,a,y),T(a,jr,y),T(a,$n,y),m(Ol,$n,null),l($n,Hm),l($n,sr),T(a,_r,y),m(Pl,a,y),T(a,Tr,y),T(a,Kl,y),T(a,Ir,y),T(a,K,y),m(eo,K,null),l(K,Dm),l(K,ar),l(K,Lm),m(Ua,K,null),l(K,Om),l(K,xa),m(no,xa,null),l(xa,Pm),l(xa,lr),l(K,Km),l(K,Ca),m(to,Ca,null),l(Ca,eh),l(Ca,or),T(a,Jr,y),m(so,a,y),T(a,wr,y),T(a,rr,y),Ur=!0},p(a,[y]){const q={};y&2&&(q.$$scope={dirty:y,ctx:a}),pt.$set(q);const vn={};y&2&&(vn.$$scope={dirty:y,ctx:a}),gt.$set(vn);const kn={};y&2&&(kn.$$scope={dirty:y,ctx:a}),ut.$set(kn);const qn={};y&2&&(qn.$$scope={dirty:y,ctx:a}),mt.$set(qn);const W={};y&2&&(W.$$scope={dirty:y,ctx:a}),ht.$set(W);const An={};y&2&&(An.$$scope={dirty:y,ctx:a}),dt.$set(An);const Zn={};y&2&&(Zn.$$scope={dirty:y,ctx:a}),ft.$set(Zn);const En={};y&2&&(En.$$scope={dirty:y,ctx:a}),yt.$set(En);const Ce={};y&2&&(Ce.$$scope={dirty:y,ctx:a}),Mt.$set(Ce);const $e={};y&2&&($e.$$scope={dirty:y,ctx:a}),bt.$set($e);const ve={};y&2&&(ve.$$scope={dirty:y,ctx:a}),jt.$set(ve);const Wn={};y&2&&(Wn.$$scope={dirty:y,ctx:a}),_t.$set(Wn);const ke={};y&2&&(ke.$$scope={dirty:y,ctx:a}),Tt.$set(ke);const qe={};y&2&&(qe.$$scope={dirty:y,ctx:a}),It.$set(qe);const Ae={};y&2&&(Ae.$$scope={dirty:y,ctx:a}),Jt.$set(Ae);const ee={};y&2&&(ee.$$scope={dirty:y,ctx:a}),wt.$set(ee);const Ze={};y&2&&(Ze.$$scope={dirty:y,ctx:a}),Ut.$set(Ze);const Nn={};y&2&&(Nn.$$scope={dirty:y,ctx:a}),xt.$set(Nn);const Gn={};y&2&&(Gn.$$scope={dirty:y,ctx:a}),Ct.$set(Gn);const Bn={};y&2&&(Bn.$$scope={dirty:y,ctx:a}),$t.$set(Bn);const Vn={};y&2&&(Vn.$$scope={dirty:y,ctx:a}),vt.$set(Vn);const Qn={};y&2&&(Qn.$$scope={dirty:y,ctx:a}),kt.$set(Qn);const Sn={};y&2&&(Sn.$$scope={dirty:y,ctx:a}),qt.$set(Sn);const Yn={};y&2&&(Yn.$$scope={dirty:y,ctx:a}),At.$set(Yn);const Ee={};y&2&&(Ee.$$scope={dirty:y,ctx:a}),Zt.$set(Ee);const X={};y&2&&(X.$$scope={dirty:y,ctx:a}),Et.$set(X);const Q={};y&2&&(Q.$$scope={dirty:y,ctx:a}),Wt.$set(Q);const D={};y&2&&(D.$$scope={dirty:y,ctx:a}),Nt.$set(D);const Rn={};y&2&&(Rn.$$scope={dirty:y,ctx:a}),Gt.$set(Rn);const ae={};y&2&&(ae.$$scope={dirty:y,ctx:a}),Bt.$set(ae);const Xn={};y&2&&(Xn.$$scope={dirty:y,ctx:a}),Vt.$set(Xn);const We={};y&2&&(We.$$scope={dirty:y,ctx:a}),Qt.$set(We);const zn={};y&2&&(zn.$$scope={dirty:y,ctx:a}),St.$set(zn);const $={};y&2&&($.$$scope={dirty:y,ctx:a}),Yt.$set($);const Fn={};y&2&&(Fn.$$scope={dirty:y,ctx:a}),Rt.$set(Fn);const Hn={};y&2&&(Hn.$$scope={dirty:y,ctx:a}),Xt.$set(Hn);const Dn={};y&2&&(Dn.$$scope={dirty:y,ctx:a}),zt.$set(Dn);const N={};y&2&&(N.$$scope={dirty:y,ctx:a}),Ft.$set(N);const Ne={};y&2&&(Ne.$$scope={dirty:y,ctx:a}),Ht.$set(Ne);const Ln={};y&2&&(Ln.$$scope={dirty:y,ctx:a}),Dt.$set(Ln);const On={};y&2&&(On.$$scope={dirty:y,ctx:a}),Lt.$set(On);const Pn={};y&2&&(Pn.$$scope={dirty:y,ctx:a}),Ot.$set(Pn);const Ge={};y&2&&(Ge.$$scope={dirty:y,ctx:a}),Pt.$set(Ge);const Be={};y&2&&(Be.$$scope={dirty:y,ctx:a}),Kt.$set(Be);const Ve={};y&2&&(Ve.$$scope={dirty:y,ctx:a}),es.$set(Ve);const Kn={};y&2&&(Kn.$$scope={dirty:y,ctx:a}),ns.$set(Kn);const Qe={};y&2&&(Qe.$$scope={dirty:y,ctx:a}),ts.$set(Qe);const Se={};y&2&&(Se.$$scope={dirty:y,ctx:a}),ss.$set(Se);const Ye={};y&2&&(Ye.$$scope={dirty:y,ctx:a}),as.$set(Ye);const ne={};y&2&&(ne.$$scope={dirty:y,ctx:a}),ls.$set(ne);const Re={};y&2&&(Re.$$scope={dirty:y,ctx:a}),os.$set(Re);const et={};y&2&&(et.$$scope={dirty:y,ctx:a}),is.$set(et);const nt={};y&2&&(nt.$$scope={dirty:y,ctx:a}),rs.$set(nt);const tt={};y&2&&(tt.$$scope={dirty:y,ctx:a}),cs.$set(tt);const st={};y&2&&(st.$$scope={dirty:y,ctx:a}),ps.$set(st);const at={};y&2&&(at.$$scope={dirty:y,ctx:a}),gs.$set(at);const lt={};y&2&&(lt.$$scope={dirty:y,ctx:a}),us.$set(lt);const ot={};y&2&&(ot.$$scope={dirty:y,ctx:a}),ms.$set(ot);const Xe={};y&2&&(Xe.$$scope={dirty:y,ctx:a}),hs.$set(Xe);const z={};y&2&&(z.$$scope={dirty:y,ctx:a}),ds.$set(z);const S={};y&2&&(S.$$scope={dirty:y,ctx:a}),fs.$set(S);const L={};y&2&&(L.$$scope={dirty:y,ctx:a}),ys.$set(L);const it={};y&2&&(it.$$scope={dirty:y,ctx:a}),Ms.$set(it);const le={};y&2&&(le.$$scope={dirty:y,ctx:a}),bs.$set(le);const rt={};y&2&&(rt.$$scope={dirty:y,ctx:a}),js.$set(rt);const ze={};y&2&&(ze.$$scope={dirty:y,ctx:a}),_s.$set(ze);const ct={};y&2&&(ct.$$scope={dirty:y,ctx:a}),Ts.$set(ct);const ao={};y&2&&(ao.$$scope={dirty:y,ctx:a}),Is.$set(ao);const lo={};y&2&&(lo.$$scope={dirty:y,ctx:a}),Js.$set(lo);const oe={};y&2&&(oe.$$scope={dirty:y,ctx:a}),ws.$set(oe);const oo={};y&2&&(oo.$$scope={dirty:y,ctx:a}),Us.$set(oo);const io={};y&2&&(io.$$scope={dirty:y,ctx:a}),xs.$set(io);const af={};y&2&&(af.$$scope={dirty:y,ctx:a}),Cs.$set(af);const lf={};y&2&&(lf.$$scope={dirty:y,ctx:a}),$s.$set(lf);const of={};y&2&&(of.$$scope={dirty:y,ctx:a}),vs.$set(of);const rf={};y&2&&(rf.$$scope={dirty:y,ctx:a}),ks.$set(rf);const cf={};y&2&&(cf.$$scope={dirty:y,ctx:a}),qs.$set(cf);const pf={};y&2&&(pf.$$scope={dirty:y,ctx:a}),As.$set(pf);const gf={};y&2&&(gf.$$scope={dirty:y,ctx:a}),Zs.$set(gf);const uf={};y&2&&(uf.$$scope={dirty:y,ctx:a}),Es.$set(uf);const mf={};y&2&&(mf.$$scope={dirty:y,ctx:a}),Ws.$set(mf);const hf={};y&2&&(hf.$$scope={dirty:y,ctx:a}),Ns.$set(hf);const df={};y&2&&(df.$$scope={dirty:y,ctx:a}),Gs.$set(df);const ff={};y&2&&(ff.$$scope={dirty:y,ctx:a}),Bs.$set(ff);const yf={};y&2&&(yf.$$scope={dirty:y,ctx:a}),Vs.$set(yf);const Mf={};y&2&&(Mf.$$scope={dirty:y,ctx:a}),Qs.$set(Mf);const bf={};y&2&&(bf.$$scope={dirty:y,ctx:a}),Ss.$set(bf);const jf={};y&2&&(jf.$$scope={dirty:y,ctx:a}),Ys.$set(jf);const _f={};y&2&&(_f.$$scope={dirty:y,ctx:a}),Rs.$set(_f);const Tf={};y&2&&(Tf.$$scope={dirty:y,ctx:a}),Xs.$set(Tf);const If={};y&2&&(If.$$scope={dirty:y,ctx:a}),zs.$set(If);const Jf={};y&2&&(Jf.$$scope={dirty:y,ctx:a}),Fs.$set(Jf);const wf={};y&2&&(wf.$$scope={dirty:y,ctx:a}),Hs.$set(wf);const Uf={};y&2&&(Uf.$$scope={dirty:y,ctx:a}),Ds.$set(Uf);const xf={};y&2&&(xf.$$scope={dirty:y,ctx:a}),Ls.$set(xf);const Cf={};y&2&&(Cf.$$scope={dirty:y,ctx:a}),Os.$set(Cf);const $f={};y&2&&($f.$$scope={dirty:y,ctx:a}),Ps.$set($f);const vf={};y&2&&(vf.$$scope={dirty:y,ctx:a}),Ks.$set(vf);const kf={};y&2&&(kf.$$scope={dirty:y,ctx:a}),ea.$set(kf);const qf={};y&2&&(qf.$$scope={dirty:y,ctx:a}),na.$set(qf);const Af={};y&2&&(Af.$$scope={dirty:y,ctx:a}),ta.$set(Af);const Zf={};y&2&&(Zf.$$scope={dirty:y,ctx:a}),sa.$set(Zf);const Ef={};y&2&&(Ef.$$scope={dirty:y,ctx:a}),aa.$set(Ef);const Wf={};y&2&&(Wf.$$scope={dirty:y,ctx:a}),la.$set(Wf);const Nf={};y&2&&(Nf.$$scope={dirty:y,ctx:a}),oa.$set(Nf);const Gf={};y&2&&(Gf.$$scope={dirty:y,ctx:a}),ia.$set(Gf);const Bf={};y&2&&(Bf.$$scope={dirty:y,ctx:a}),ra.$set(Bf);const Vf={};y&2&&(Vf.$$scope={dirty:y,ctx:a}),ca.$set(Vf);const Qf={};y&2&&(Qf.$$scope={dirty:y,ctx:a}),pa.$set(Qf);const Sf={};y&2&&(Sf.$$scope={dirty:y,ctx:a}),ga.$set(Sf);const Yf={};y&2&&(Yf.$$scope={dirty:y,ctx:a}),ua.$set(Yf);const Rf={};y&2&&(Rf.$$scope={dirty:y,ctx:a}),ma.$set(Rf);const Xf={};y&2&&(Xf.$$scope={dirty:y,ctx:a}),ha.$set(Xf);const zf={};y&2&&(zf.$$scope={dirty:y,ctx:a}),da.$set(zf);const Ff={};y&2&&(Ff.$$scope={dirty:y,ctx:a}),fa.$set(Ff);const Hf={};y&2&&(Hf.$$scope={dirty:y,ctx:a}),ya.$set(Hf);const Df={};y&2&&(Df.$$scope={dirty:y,ctx:a}),Ma.$set(Df);const Lf={};y&2&&(Lf.$$scope={dirty:y,ctx:a}),ba.$set(Lf);const Of={};y&2&&(Of.$$scope={dirty:y,ctx:a}),ja.$set(Of);const Pf={};y&2&&(Pf.$$scope={dirty:y,ctx:a}),_a.$set(Pf);const Kf={};y&2&&(Kf.$$scope={dirty:y,ctx:a}),Ta.$set(Kf);const ey={};y&2&&(ey.$$scope={dirty:y,ctx:a}),Ia.$set(ey);const ny={};y&2&&(ny.$$scope={dirty:y,ctx:a}),Ja.$set(ny);const ty={};y&2&&(ty.$$scope={dirty:y,ctx:a}),wa.$set(ty);const sy={};y&2&&(sy.$$scope={dirty:y,ctx:a}),Ua.$set(sy)},i(a){Ur||(h(i.$$.fragment,a),h(ka.$$.fragment,a),h(qa.$$.fragment,a),h(Aa.$$.fragment,a),h(pt.$$.fragment,a),h(Za.$$.fragment,a),h(gt.$$.fragment,a),h(Ea.$$.fragment,a),h(ut.$$.fragment,a),h(Wa.$$.fragment,a),h(mt.$$.fragment,a),h(ht.$$.fragment,a),h(dt.$$.fragment,a),h(ft.$$.fragment,a),h(yt.$$.fragment,a),h(Mt.$$.fragment,a),h(bt.$$.fragment,a),h(jt.$$.fragment,a),h(_t.$$.fragment,a),h(Tt.$$.fragment,a),h(Na.$$.fragment,a),h(It.$$.fragment,a),h(Ga.$$.fragment,a),h(Jt.$$.fragment,a),h(Ba.$$.fragment,a),h(wt.$$.fragment,a),h(Va.$$.fragment,a),h(Ut.$$.fragment,a),h(Qa.$$.fragment,a),h(xt.$$.fragment,a),h(Ct.$$.fragment,a),h(Sa.$$.fragment,a),h($t.$$.fragment,a),h(Ya.$$.fragment,a),h(vt.$$.fragment,a),h(Ra.$$.fragment,a),h(kt.$$.fragment,a),h(qt.$$.fragment,a),h(Xa.$$.fragment,a),h(At.$$.fragment,a),h(Zt.$$.fragment,a),h(za.$$.fragment,a),h(Et.$$.fragment,a),h(Fa.$$.fragment,a),h(Wt.$$.fragment,a),h(Nt.$$.fragment,a),h(Gt.$$.fragment,a),h(Ha.$$.fragment,a),h(Bt.$$.fragment,a),h(Vt.$$.fragment,a),h(Da.$$.fragment,a),h(Qt.$$.fragment,a),h(La.$$.fragment,a),h(St.$$.fragment,a),h(Oa.$$.fragment,a),h(Yt.$$.fragment,a),h(Pa.$$.fragment,a),h(Rt.$$.fragment,a),h(Ka.$$.fragment,a),h(Xt.$$.fragment,a),h(el.$$.fragment,a),h(zt.$$.fragment,a),h(nl.$$.fragment,a),h(Ft.$$.fragment,a),h(tl.$$.fragment,a),h(Ht.$$.fragment,a),h(Dt.$$.fragment,a),h(sl.$$.fragment,a),h(Lt.$$.fragment,a),h(Ot.$$.fragment,a),h(Pt.$$.fragment,a),h(Kt.$$.fragment,a),h(es.$$.fragment,a),h(ns.$$.fragment,a),h(al.$$.fragment,a),h(ts.$$.fragment,a),h(ss.$$.fragment,a),h(as.$$.fragment,a),h(ls.$$.fragment,a),h(os.$$.fragment,a),h(is.$$.fragment,a),h(ll.$$.fragment,a),h(rs.$$.fragment,a),h(cs.$$.fragment,a),h(ps.$$.fragment,a),h(ol.$$.fragment,a),h(gs.$$.fragment,a),h(il.$$.fragment,a),h(us.$$.fragment,a),h(ms.$$.fragment,a),h(rl.$$.fragment,a),h(hs.$$.fragment,a),h(cl.$$.fragment,a),h(ds.$$.fragment,a),h(fs.$$.fragment,a),h(pl.$$.fragment,a),h(ys.$$.fragment,a),h(gl.$$.fragment,a),h(ml.$$.fragment,a),h(hl.$$.fragment,a),h(dl.$$.fragment,a),h(Ms.$$.fragment,a),h(fl.$$.fragment,a),h(bs.$$.fragment,a),h(yl.$$.fragment,a),h(js.$$.fragment,a),h(Ml.$$.fragment,a),h(_s.$$.fragment,a),h(Ts.$$.fragment,a),h(Is.$$.fragment,a),h(Js.$$.fragment,a),h(ws.$$.fragment,a),h(Us.$$.fragment,a),h(xs.$$.fragment,a),h(Cs.$$.fragment,a),h($s.$$.fragment,a),h(vs.$$.fragment,a),h(bl.$$.fragment,a),h(jl.$$.fragment,a),h(ks.$$.fragment,a),h(_l.$$.fragment,a),h(qs.$$.fragment,a),h(Tl.$$.fragment,a),h(As.$$.fragment,a),h(Il.$$.fragment,a),h(Zs.$$.fragment,a),h(Jl.$$.fragment,a),h(Es.$$.fragment,a),h(Ws.$$.fragment,a),h(wl.$$.fragment,a),h(Ns.$$.fragment,a),h(Ul.$$.fragment,a),h(Gs.$$.fragment,a),h(xl.$$.fragment,a),h(Bs.$$.fragment,a),h(Vs.$$.fragment,a),h(Cl.$$.fragment,a),h(Qs.$$.fragment,a),h(Ss.$$.fragment,a),h($l.$$.fragment,a),h(Ys.$$.fragment,a),h(vl.$$.fragment,a),h(Rs.$$.fragment,a),h(Xs.$$.fragment,a),h(zs.$$.fragment,a),h(kl.$$.fragment,a),h(Fs.$$.fragment,a),h(Hs.$$.fragment,a),h(ql.$$.fragment,a),h(Ds.$$.fragment,a),h(Al.$$.fragment,a),h(Ls.$$.fragment,a),h(Zl.$$.fragment,a),h(Os.$$.fragment,a),h(El.$$.fragment,a),h(Ps.$$.fragment,a),h(Wl.$$.fragment,a),h(Ks.$$.fragment,a),h(Nl.$$.fragment,a),h(ea.$$.fragment,a),h(Gl.$$.fragment,a),h(na.$$.fragment,a),h(Bl.$$.fragment,a),h(ta.$$.fragment,a),h(sa.$$.fragment,a),h(Vl.$$.fragment,a),h(aa.$$.fragment,a),h(la.$$.fragment,a),h(oa.$$.fragment,a),h(ia.$$.fragment,a),h(ra.$$.fragment,a),h(ca.$$.fragment,a),h(Ql.$$.fragment,a),h(pa.$$.fragment,a),h(ga.$$.fragment,a),h(ua.$$.fragment,a),h(ma.$$.fragment,a),h(ha.$$.fragment,a),h(da.$$.fragment,a),h(Sl.$$.fragment,a),h(fa.$$.fragment,a),h(ya.$$.fragment,a),h(Ma.$$.fragment,a),h(Yl.$$.fragment,a),h(ba.$$.fragment,a),h(Rl.$$.fragment,a),h(ja.$$.fragment,a),h(_a.$$.fragment,a),h(Xl.$$.fragment,a),h(Ta.$$.fragment,a),h(zl.$$.fragment,a),h(Ia.$$.fragment,a),h(Ja.$$.fragment,a),h(Fl.$$.fragment,a),h(wa.$$.fragment,a),h(Hl.$$.fragment,a),h(Dl.$$.fragment,a),h(Ll.$$.fragment,a),h(Ol.$$.fragment,a),h(Pl.$$.fragment,a),h(eo.$$.fragment,a),h(Ua.$$.fragment,a),h(no.$$.fragment,a),h(to.$$.fragment,a),h(so.$$.fragment,a),Ur=!0)},o(a){d(i.$$.fragment,a),d(ka.$$.fragment,a),d(qa.$$.fragment,a),d(Aa.$$.fragment,a),d(pt.$$.fragment,a),d(Za.$$.fragment,a),d(gt.$$.fragment,a),d(Ea.$$.fragment,a),d(ut.$$.fragment,a),d(Wa.$$.fragment,a),d(mt.$$.fragment,a),d(ht.$$.fragment,a),d(dt.$$.fragment,a),d(ft.$$.fragment,a),d(yt.$$.fragment,a),d(Mt.$$.fragment,a),d(bt.$$.fragment,a),d(jt.$$.fragment,a),d(_t.$$.fragment,a),d(Tt.$$.fragment,a),d(Na.$$.fragment,a),d(It.$$.fragment,a),d(Ga.$$.fragment,a),d(Jt.$$.fragment,a),d(Ba.$$.fragment,a),d(wt.$$.fragment,a),d(Va.$$.fragment,a),d(Ut.$$.fragment,a),d(Qa.$$.fragment,a),d(xt.$$.fragment,a),d(Ct.$$.fragment,a),d(Sa.$$.fragment,a),d($t.$$.fragment,a),d(Ya.$$.fragment,a),d(vt.$$.fragment,a),d(Ra.$$.fragment,a),d(kt.$$.fragment,a),d(qt.$$.fragment,a),d(Xa.$$.fragment,a),d(At.$$.fragment,a),d(Zt.$$.fragment,a),d(za.$$.fragment,a),d(Et.$$.fragment,a),d(Fa.$$.fragment,a),d(Wt.$$.fragment,a),d(Nt.$$.fragment,a),d(Gt.$$.fragment,a),d(Ha.$$.fragment,a),d(Bt.$$.fragment,a),d(Vt.$$.fragment,a),d(Da.$$.fragment,a),d(Qt.$$.fragment,a),d(La.$$.fragment,a),d(St.$$.fragment,a),d(Oa.$$.fragment,a),d(Yt.$$.fragment,a),d(Pa.$$.fragment,a),d(Rt.$$.fragment,a),d(Ka.$$.fragment,a),d(Xt.$$.fragment,a),d(el.$$.fragment,a),d(zt.$$.fragment,a),d(nl.$$.fragment,a),d(Ft.$$.fragment,a),d(tl.$$.fragment,a),d(Ht.$$.fragment,a),d(Dt.$$.fragment,a),d(sl.$$.fragment,a),d(Lt.$$.fragment,a),d(Ot.$$.fragment,a),d(Pt.$$.fragment,a),d(Kt.$$.fragment,a),d(es.$$.fragment,a),d(ns.$$.fragment,a),d(al.$$.fragment,a),d(ts.$$.fragment,a),d(ss.$$.fragment,a),d(as.$$.fragment,a),d(ls.$$.fragment,a),d(os.$$.fragment,a),d(is.$$.fragment,a),d(ll.$$.fragment,a),d(rs.$$.fragment,a),d(cs.$$.fragment,a),d(ps.$$.fragment,a),d(ol.$$.fragment,a),d(gs.$$.fragment,a),d(il.$$.fragment,a),d(us.$$.fragment,a),d(ms.$$.fragment,a),d(rl.$$.fragment,a),d(hs.$$.fragment,a),d(cl.$$.fragment,a),d(ds.$$.fragment,a),d(fs.$$.fragment,a),d(pl.$$.fragment,a),d(ys.$$.fragment,a),d(gl.$$.fragment,a),d(ml.$$.fragment,a),d(hl.$$.fragment,a),d(dl.$$.fragment,a),d(Ms.$$.fragment,a),d(fl.$$.fragment,a),d(bs.$$.fragment,a),d(yl.$$.fragment,a),d(js.$$.fragment,a),d(Ml.$$.fragment,a),d(_s.$$.fragment,a),d(Ts.$$.fragment,a),d(Is.$$.fragment,a),d(Js.$$.fragment,a),d(ws.$$.fragment,a),d(Us.$$.fragment,a),d(xs.$$.fragment,a),d(Cs.$$.fragment,a),d($s.$$.fragment,a),d(vs.$$.fragment,a),d(bl.$$.fragment,a),d(jl.$$.fragment,a),d(ks.$$.fragment,a),d(_l.$$.fragment,a),d(qs.$$.fragment,a),d(Tl.$$.fragment,a),d(As.$$.fragment,a),d(Il.$$.fragment,a),d(Zs.$$.fragment,a),d(Jl.$$.fragment,a),d(Es.$$.fragment,a),d(Ws.$$.fragment,a),d(wl.$$.fragment,a),d(Ns.$$.fragment,a),d(Ul.$$.fragment,a),d(Gs.$$.fragment,a),d(xl.$$.fragment,a),d(Bs.$$.fragment,a),d(Vs.$$.fragment,a),d(Cl.$$.fragment,a),d(Qs.$$.fragment,a),d(Ss.$$.fragment,a),d($l.$$.fragment,a),d(Ys.$$.fragment,a),d(vl.$$.fragment,a),d(Rs.$$.fragment,a),d(Xs.$$.fragment,a),d(zs.$$.fragment,a),d(kl.$$.fragment,a),d(Fs.$$.fragment,a),d(Hs.$$.fragment,a),d(ql.$$.fragment,a),d(Ds.$$.fragment,a),d(Al.$$.fragment,a),d(Ls.$$.fragment,a),d(Zl.$$.fragment,a),d(Os.$$.fragment,a),d(El.$$.fragment,a),d(Ps.$$.fragment,a),d(Wl.$$.fragment,a),d(Ks.$$.fragment,a),d(Nl.$$.fragment,a),d(ea.$$.fragment,a),d(Gl.$$.fragment,a),d(na.$$.fragment,a),d(Bl.$$.fragment,a),d(ta.$$.fragment,a),d(sa.$$.fragment,a),d(Vl.$$.fragment,a),d(aa.$$.fragment,a),d(la.$$.fragment,a),d(oa.$$.fragment,a),d(ia.$$.fragment,a),d(ra.$$.fragment,a),d(ca.$$.fragment,a),d(Ql.$$.fragment,a),d(pa.$$.fragment,a),d(ga.$$.fragment,a),d(ua.$$.fragment,a),d(ma.$$.fragment,a),d(ha.$$.fragment,a),d(da.$$.fragment,a),d(Sl.$$.fragment,a),d(fa.$$.fragment,a),d(ya.$$.fragment,a),d(Ma.$$.fragment,a),d(Yl.$$.fragment,a),d(ba.$$.fragment,a),d(Rl.$$.fragment,a),d(ja.$$.fragment,a),d(_a.$$.fragment,a),d(Xl.$$.fragment,a),d(Ta.$$.fragment,a),d(zl.$$.fragment,a),d(Ia.$$.fragment,a),d(Ja.$$.fragment,a),d(Fl.$$.fragment,a),d(wa.$$.fragment,a),d(Hl.$$.fragment,a),d(Dl.$$.fragment,a),d(Ll.$$.fragment,a),d(Ol.$$.fragment,a),d(Pl.$$.fragment,a),d(eo.$$.fragment,a),d(Ua.$$.fragment,a),d(no.$$.fragment,a),d(to.$$.fragment,a),d(so.$$.fragment,a),Ur=!1},d(a){a&&(M(o),M(t),M(s),M(e),M(p),M(cr),M($a),M(pr),M(va),M(gr),M(ur),M(C),M(mr),M(hr),M(ul),M(dr),M(fr),M(x),M(yr),M(Mr),M(Cn),M(br),M(jr),M($n),M(_r),M(Tr),M(Kl),M(Ir),M(K),M(Jr),M(wr),M(rr)),M(n),f(i,a),f(ka,a),f(qa),f(Aa),f(pt),f(Za),f(gt),f(Ea),f(ut),f(Wa),f(mt),f(ht),f(dt),f(ft),f(yt),f(Mt),f(bt),f(jt),f(_t),f(Tt),f(Na),f(It),f(Ga),f(Jt),f(Ba),f(wt),f(Va),f(Ut),f(Qa),f(xt),f(Ct),f(Sa),f($t),f(Ya),f(vt),f(Ra),f(kt),f(qt),f(Xa),f(At),f(Zt),f(za),f(Et),f(Fa),f(Wt),f(Nt),f(Gt),f(Ha),f(Bt),f(Vt),f(Da),f(Qt),f(La),f(St),f(Oa),f(Yt),f(Pa),f(Rt),f(Ka),f(Xt),f(el),f(zt),f(nl),f(Ft),f(tl),f(Ht),f(Dt),f(sl),f(Lt),f(Ot),f(Pt),f(Kt),f(es),f(ns),f(al),f(ts),f(ss),f(as),f(ls),f(os),f(is),f(ll),f(rs),f(cs),f(ps),f(ol),f(gs),f(il),f(us),f(ms),f(rl),f(hs),f(cl),f(ds),f(fs),f(pl),f(ys),f(gl,a),f(ml,a),f(hl),f(dl),f(Ms),f(fl),f(bs),f(yl),f(js),f(Ml),f(_s),f(Ts),f(Is),f(Js),f(ws),f(Us),f(xs),f(Cs),f($s),f(vs),f(bl),f(jl),f(ks),f(_l),f(qs),f(Tl),f(As),f(Il),f(Zs),f(Jl),f(Es),f(Ws),f(wl),f(Ns),f(Ul),f(Gs),f(xl),f(Bs),f(Vs),f(Cl),f(Qs),f(Ss),f($l),f(Ys),f(vl),f(Rs),f(Xs),f(zs),f(kl),f(Fs),f(Hs),f(ql),f(Ds),f(Al),f(Ls),f(Zl),f(Os),f(El),f(Ps),f(Wl),f(Ks),f(Nl),f(ea),f(Gl),f(na),f(Bl),f(ta),f(sa),f(Vl),f(aa),f(la),f(oa),f(ia),f(ra),f(ca),f(Ql),f(pa),f(ga),f(ua),f(ma),f(ha),f(da),f(Sl),f(fa),f(ya),f(Ma),f(Yl),f(ba),f(Rl),f(ja),f(_a),f(Xl),f(Ta),f(zl),f(Ia),f(Ja),f(Fl),f(wa),f(Hl,a),f(Dl),f(Ll,a),f(Ol),f(Pl,a),f(eo),f(Ua),f(no),f(to),f(so,a)}}}const Cb='{"title":"Inference","local":"inference","sections":[{"title":"Inference Client","local":"huggingface_hub.InferenceClient","sections":[],"depth":2},{"title":"Async Inference Client","local":"huggingface_hub.AsyncInferenceClient","sections":[],"depth":2},{"title":"InferenceTimeoutError","local":"huggingface_hub.InferenceTimeoutError","sections":[{"title":"ModelStatus","local":"huggingface_hub.inference._common.ModelStatus","sections":[],"depth":3}],"depth":2},{"title":"InferenceAPI","local":"huggingface_hub.InferenceApi","sections":[],"depth":2}],"depth":1}';function $b(_){return ly(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nb extends oy{constructor(n){super(),iy(this,n,$b,xb,ay,{})}}export{Nb as component};
