import{s as Dt,o as Kt,n as Pt}from"../chunks/scheduler.6062bdaf.js";import{S as Ot,i as el,g as i,s as a,r as m,A as tl,h as o,f as l,c as n,j as St,u as d,x as c,k as Mt,y as ll,a as s,v as g,d as u,t as h,w as r}from"../chunks/index.4bca734e.js";import{T as Ft}from"../chunks/Tip.b9ac1f03.js";import{C as b}from"../chunks/CodeBlock.cbbddafc.js";import{H as j,E as sl}from"../chunks/index.60dd99e8.js";function al(Me){let p,M='When listing collections, the item list per collection is truncated to 4 items maximum. To retrieve all items from a collection, you must use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_collection">get_collection()</a>.';return{c(){p=i("p"),p.innerHTML=M},l(f){p=o(f,"P",{"data-svelte-h":!0}),c(p)!=="svelte-1989bk8"&&(p.innerHTML=M)},m(f,y){s(f,p,y)},p:Pt,d(f){f&&l(p)}}}function nl(Me){let p,M="This is a non-revertible action. A deleted collection cannot be restored.";return{c(){p=i("p"),p.textContent=M},l(f){p=o(f,"P",{"data-svelte-h":!0}),c(p)!=="svelte-1k7dttx"&&(p.textContent=M)},m(f,y){s(f,p,y)},p:Pt,d(f){f&&l(p)}}}function il(Me){let p,M,f,y,U,ye,w,jt='A collection is a group of related items on the Hub (models, datasets, Spaces, papers) that are organized together on the same page. Collections are useful for creating your own portfolio, bookmarking content in categories, or presenting a curated list of items you want to share. Check out this <a href="https://huggingface.co/docs/hub/collections" rel="nofollow">guide</a> to understand in more detail what collections are and how they look on the Hub.',_e,v,yt="You can directly manage collections in the browser, but in this guide, we will focus on how to manage them programmatically.",$e,T,Ge,x,_t='Use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_collection">get_collection()</a> to fetch your collections or any public ones. You must have the collection’s <em>slug</em> to retrieve a collection. A slug is an identifier for a collection based on the title and a unique ID. You can find the slug in the URL of the collection page.',Ue,_,$t='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hfh_collection_slug.png"/>',we,k,Gt="Let’s fetch the collection with, <code>&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</code>:",ve,Z,Te,C,Ut='The <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.Collection">Collection</a> object returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_collection">get_collection()</a> contains:',xe,J,wt='<li>high-level metadata: <code>slug</code>, <code>owner</code>, <code>title</code>, <code>description</code>, etc.</li> <li>a list of <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.CollectionItem">CollectionItem</a> objects; each item represents a model, a dataset, a Space, or a paper.</li>',ke,W,vt="All collection items are guaranteed to have:",Ze,Y,Tt='<li>a unique <code>item_object_id</code>: this is the id of the collection item in the database</li> <li>an <code>item_id</code>: this is the id on the Hub of the underlying item (model, dataset, Space, paper); it is not necessarily unique, and only the <code>item_id</code>/<code>item_type</code> pair is unique</li> <li>an <code>item_type</code>: model, dataset, Space, paper</li> <li>the <code>position</code> of the item in the collection, which can be updated to reorganize your collection (see <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.update_collection_item">update_collection_item()</a> below)</li>',Ce,N,xt="A <code>note</code> can also be attached to the item. This is useful to add additional information about the item (a comment, a link to a blog post, etc.). The attribute still has a <code>None</code> value if an item doesn’t have a note.",Je,R,kt="In addition to these base attributes, returned items can have additional attributes depending on their type: <code>author</code>, <code>private</code>, <code>lastModified</code>, <code>gated</code>, <code>title</code>, <code>likes</code>, <code>upvotes</code>, etc. None of these attributes are guaranteed to be returned.",We,H,Ye,V,Zt='We can also retrieve collections using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_collections">list_collections()</a>. Collections can be filtered using some parameters. Let’s list all the collections from the user <a href="https://huggingface.co/teknium" rel="nofollow"><code>teknium</code></a>.',Ne,q,Re,X,Ct="This returns an iterable of <code>Collection</code> objects. We can iterate over them to print, for example, the number of upvotes for each collection.",He,L,Ve,$,qe,B,Jt='It is possible to do more advanced filtering. Let’s get all collections containing the model <a href="https://huggingface.co/TheBloke/OpenHermes-2.5-Mistral-7B-GGUF" rel="nofollow">TheBloke/OpenHermes-2.5-Mistral-7B-GGUF</a>, sorted by trending, and limit the count to 5.',Xe,I,Le,Q,Wt="Parameter <code>sort</code> must be one of  <code>&quot;last_modified&quot;</code>,  <code>&quot;trending&quot;</code> or <code>&quot;upvotes&quot;</code>. Parameter <code>item</code> accepts any particular item. For example:",Be,z,Yt="<li><code>&quot;models/teknium/OpenHermes-2.5-Mistral-7B&quot;</code></li> <li><code>&quot;spaces/julien-c/open-gpt-rhyming-robot&quot;</code></li> <li><code>&quot;datasets/squad&quot;</code></li> <li><code>&quot;papers/2311.12983&quot;</code></li>",Ie,A,Nt='For more details, please check out <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_collections">list_collections()</a> reference.',Qe,E,ze,S,Rt='Now that we know how to get a <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.Collection">Collection</a>, let’s create our own! Use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_collection">create_collection()</a> with a title and description. To create a collection on an organization page, pass <code>namespace=&quot;my-cool-org&quot;</code> when creating the collection. Finally, you can also create private collections by passing <code>private=True</code>.',Ae,F,Ee,P,Ht='It will return a <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.Collection">Collection</a> object with the high-level metadata (title, description, owner, etc.) and an empty list of items. You will now be able to refer to this collection using its <code>slug</code>.',Se,D,Fe,K,Pe,O,Vt='Now that we have a <a href="/docs/huggingface_hub/main/en/package_reference/collections#huggingface_hub.Collection">Collection</a>, we want to add items to it and organize them.',De,ee,Ke,te,qt='Items have to be added one by one using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.add_collection_item">add_collection_item()</a>. You only need to know the <code>collection_slug</code>, <code>item_id</code> and <code>item_type</code>. Optionally, you can also add a <code>note</code> to the item (500 characters maximum).',Oe,le,et,se,Xt="If an item already exists in a collection (same <code>item_id</code>/<code>item_type</code> pair), an HTTP 409 error will be raised. You can choose to ignore this error by setting <code>exists_ok=True</code>.",tt,ae,lt,ne,Lt='You can modify an existing item to add or modify the note attached to it using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.update_collection_item">update_collection_item()</a>. Let’s reuse the example above:',st,ie,at,oe,nt,ce,Bt='Items in a collection are ordered. The order is determined by the <code>position</code> attribute of each item. By default, items are ordered by appending new items at the end of the collection. You can update the order using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.update_collection_item">update_collection_item()</a> the same way you would add a note.',it,pe,It="Let’s reuse our example above:",ot,me,ct,de,pt,ge,Qt='Finally, you can also remove an item using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_collection_item">delete_collection_item()</a>.',mt,ue,dt,he,gt,re,zt='A collection can be deleted using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_collection">delete_collection()</a>.',ut,G,ht,fe,rt,be,ft,je,bt;return U=new j({props:{title:"Collections",local:"collections",headingTag:"h1"}}),T=new j({props:{title:"Fetch a collection",local:"fetch-a-collection",headingTag:"h2"}}),Z=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGdldF9jb2xsZWN0aW9uKCUyMlRoZUJsb2tlJTJGcmVjZW50LW1vZGVscy02NGY5YTU1YmIzMTE1YjRmNTEzZWMwMjYlMjIpJTBBY29sbGVjdGlvbiUwQWNvbGxlY3Rpb24uaXRlbXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(<span class="hljs-string">&quot;TheBloke/recent-models-64f9a55bb3115b4f513ec026&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection
Collection(
  slug=<span class="hljs-string">&#x27;TheBloke/recent-models-64f9a55bb3115b4f513ec026&#x27;</span>,
  title=<span class="hljs-string">&#x27;Recent models&#x27;</span>,
  owner=<span class="hljs-string">&#x27;TheBloke&#x27;</span>,
  items=[...],
  last_updated=datetime.datetime(<span class="hljs-number">2023</span>, <span class="hljs-number">10</span>, <span class="hljs-number">2</span>, <span class="hljs-number">22</span>, <span class="hljs-number">56</span>, <span class="hljs-number">48</span>, <span class="hljs-number">632000</span>, tzinfo=datetime.timezone.utc),
  position=<span class="hljs-number">1</span>,
  private=<span class="hljs-literal">False</span>,
  theme=<span class="hljs-string">&#x27;green&#x27;</span>,
  upvotes=<span class="hljs-number">90</span>,
  description=<span class="hljs-string">&quot;Models I&#x27;ve recently quantized. Please note that currently this list has to be updated manually, and therefore is not guaranteed to be up-to-date.&quot;</span>
)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.items[<span class="hljs-number">0</span>]
CollectionItem(
  item_object_id=<span class="hljs-string">&#x27;651446103cd773a050bf64c2&#x27;</span>,
  item_id=<span class="hljs-string">&#x27;TheBloke/U-Amethyst-20B-AWQ&#x27;</span>,
  item_type=<span class="hljs-string">&#x27;model&#x27;</span>,
  position=<span class="hljs-number">88</span>,
  note=<span class="hljs-literal">None</span>
)`,wrap:!1}}),H=new j({props:{title:"List collections",local:"list-collections",headingTag:"h2"}}),q=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfY29sbGVjdGlvbnMlMEElMEFjb2xsZWN0aW9ucyUyMCUzRCUyMGxpc3RfY29sbGVjdGlvbnMob3duZXIlM0QlMjJ0ZWtuaXVtJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_collections

<span class="hljs-meta">&gt;&gt;&gt; </span>collections = list_collections(owner=<span class="hljs-string">&quot;teknium&quot;</span>)`,wrap:!1}}),L=new b({props:{code:"Zm9yJTIwY29sbGVjdGlvbiUyMGluJTIwY29sbGVjdGlvbnMlM0ElMEElMjAlMjBwcmludCglMjJOdW1iZXIlMjBvZiUyMHVwdm90ZXMlM0ElMjIlMkMlMjBjb2xsZWN0aW9uLnVwdm90ZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> collection <span class="hljs-keyword">in</span> collections:
<span class="hljs-meta">... </span>  <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Number of upvotes:&quot;</span>, collection.upvotes)
Number of upvotes: <span class="hljs-number">1</span>
Number of upvotes: <span class="hljs-number">5</span>`,wrap:!1}}),$=new Ft({props:{warning:!0,$$slots:{default:[al]},$$scope:{ctx:Me}}}),I=new b({props:{code:"Y29sbGVjdGlvbnMlMjAlM0QlMjBsaXN0X2NvbGxlY3Rpb25zKGl0ZW0lM0QlMjJtb2RlbHMlMkZUaGVCbG9rZSUyRk9wZW5IZXJtZXMtMi41LU1pc3RyYWwtN0ItR0dVRiUyMiUyQyUyMHNvcnQlM0QlMjJ0cmVuZGluZyUyMiUyQyUyMGxpbWl0JTNENSklM0ElMEFmb3IlMjBjb2xsZWN0aW9uJTIwaW4lMjBjb2xsZWN0aW9ucyUzQSUwQSUyMCUyMHByaW50KGNvbGxlY3Rpb24uc2x1Zyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>collections = list_collections(item=<span class="hljs-string">&quot;models/TheBloke/OpenHermes-2.5-Mistral-7B-GGUF&quot;</span>, sort=<span class="hljs-string">&quot;trending&quot;</span>, limit=<span class="hljs-number">5</span>):
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> collection <span class="hljs-keyword">in</span> collections:
<span class="hljs-meta">... </span>  <span class="hljs-built_in">print</span>(collection.slug)
teknium/quantized-models-6544690bb978e0b0f7328748
AmeerH/function-calling-65560a2565d7a6ef568527af
PostArchitekt/7bz-65479bb8c194936469697d8c
gnomealone/need-to-test-652007226c6ce4cdacf9c233
Crataco/favorite-7b-models-651944072b4fffcb41f8b568`,wrap:!1}}),E=new j({props:{title:"Create a new collection",local:"create-a-new-collection",headingTag:"h2"}}),F=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9jb2xsZWN0aW9uJTBBJTBBY29sbGVjdGlvbiUyMCUzRCUyMGNyZWF0ZV9jb2xsZWN0aW9uKCUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIySUNDViUyMDIwMjMlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlBvcnRmb2xpbyUyMG9mJTIwbW9kZWxzJTJDJTIwcGFwZXJzJTIwYW5kJTIwZGVtb3MlMjBJJTIwcHJlc2VudGVkJTIwYXQlMjBJQ0NWJTIwMjAyMyUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_collection

<span class="hljs-meta">&gt;&gt;&gt; </span>collection = create_collection(
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;ICCV 2023&quot;</span>,
<span class="hljs-meta">... </span>    description=<span class="hljs-string">&quot;Portfolio of models, papers and demos I presented at ICCV 2023&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),D=new b({props:{code:"Y29sbGVjdGlvbi5zbHVnJTBBY29sbGVjdGlvbi50aXRsZSUwQWNvbGxlY3Rpb24ub3duZXIlMEFjb2xsZWN0aW9uLnVybA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>collection.slug
<span class="hljs-string">&#x27;owner/iccv-2023-15e23b46cb98efca45&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.title
<span class="hljs-string">&quot;ICCV 2023&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.owner
<span class="hljs-string">&quot;username&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.url
<span class="hljs-string">&#x27;https://huggingface.co/collections/owner/iccv-2023-15e23b46cb98efca45&#x27;</span>`,wrap:!1}}),K=new j({props:{title:"Manage items in a collection",local:"manage-items-in-a-collection",headingTag:"h2"}}),ee=new j({props:{title:"Add items",local:"add-items",headingTag:"h3"}}),le=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9jb2xsZWN0aW9uJTJDJTIwYWRkX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb24lMjAlM0QlMjBjcmVhdGVfY29sbGVjdGlvbih0aXRsZSUzRCUyMk9TJTIwV2VlayUyMEhpZ2hsaWdodHMlMjAtJTIwU2VwdCUyMDE4JTIwLSUyMDI0JTIyJTJDJTIwbmFtZXNwYWNlJTNEJTIyb3NhbnNldmllcm8lMjIpJTBBY29sbGVjdGlvbi5zbHVnJTBBJTBBYWRkX2NvbGxlY3Rpb25faXRlbShjb2xsZWN0aW9uLnNsdWclMkMlMjBpdGVtX2lkJTNEJTIyY29xdWklMkZ4dHRzJTIyJTJDJTIwaXRlbV90eXBlJTNEJTIyc3BhY2UlMjIpJTBBYWRkX2NvbGxlY3Rpb25faXRlbSglMEElMjAlMjAlMjAlMjBjb2xsZWN0aW9uLnNsdWclMkMlMEElMjAlMjAlMjAlMjBpdGVtX2lkJTNEJTIyd2FycC1haSUyRnd1ZXJzdGNoZW4lMjIlMkMlMEElMjAlMjAlMjAlMjBpdGVtX3R5cGUlM0QlMjJtb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5vdGUlM0QlMjJXJUMzJUJDcnN0Y2hlbiUyMGlzJTIwYSUyMG5ldyUyMGZhc3QlMjBhbmQlMjBlZmZpY2llbnQlMjBoaWdoJTIwcmVzb2x1dGlvbiUyMHRleHQtdG8taW1hZ2UlMjBhcmNoaXRlY3R1cmUlMjBhbmQlMjBtb2RlbCUyMiUwQSklMEFhZGRfY29sbGVjdGlvbl9pdGVtKGNvbGxlY3Rpb24uc2x1ZyUyQyUyMGl0ZW1faWQlM0QlMjJsbXN5cyUyRmxtc3lzLWNoYXQtMW0lMjIlMkMlMjBpdGVtX3R5cGUlM0QlMjJkYXRhc2V0JTIyKSUwQWFkZF9jb2xsZWN0aW9uX2l0ZW0oY29sbGVjdGlvbi5zbHVnJTJDJTIwaXRlbV9pZCUzRCUyMndhcnAtYWklMkZ3dWVyc3RjaGVuJTIyJTJDJTIwaXRlbV90eXBlJTNEJTIyc3BhY2UlMjIpJTIwJTIzJTIwc2FtZSUyMGl0ZW1faWQlMkMlMjBkaWZmZXJlbnQlMjBpdGVtX3R5cGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_collection, add_collection_item

<span class="hljs-meta">&gt;&gt;&gt; </span>collection = create_collection(title=<span class="hljs-string">&quot;OS Week Highlights - Sept 18 - 24&quot;</span>, namespace=<span class="hljs-string">&quot;osanseviero&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.slug
<span class="hljs-string">&quot;osanseviero/os-week-highlights-sept-18-24-650bfed7f795a59f491afb80&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>add_collection_item(collection.slug, item_id=<span class="hljs-string">&quot;coqui/xtts&quot;</span>, item_type=<span class="hljs-string">&quot;space&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>add_collection_item(
<span class="hljs-meta">... </span>    collection.slug,
<span class="hljs-meta">... </span>    item_id=<span class="hljs-string">&quot;warp-ai/wuerstchen&quot;</span>,
<span class="hljs-meta">... </span>    item_type=<span class="hljs-string">&quot;model&quot;</span>,
<span class="hljs-meta">... </span>    note=<span class="hljs-string">&quot;Würstchen is a new fast and efficient high resolution text-to-image architecture and model&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>add_collection_item(collection.slug, item_id=<span class="hljs-string">&quot;lmsys/lmsys-chat-1m&quot;</span>, item_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>add_collection_item(collection.slug, item_id=<span class="hljs-string">&quot;warp-ai/wuerstchen&quot;</span>, item_type=<span class="hljs-string">&quot;space&quot;</span>) <span class="hljs-comment"># same item_id, different item_type</span>`,wrap:!1}}),ae=new j({props:{title:"Add a note to an existing item",local:"add-a-note-to-an-existing-item",headingTag:"h3"}}),ie=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwdXBkYXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb25fc2x1ZyUyMCUzRCUyMCUyMm9zYW5zZXZpZXJvJTJGb3Mtd2Vlay1oaWdobGlnaHRzLXNlcHQtMTgtMjQtNjUwYmZlZDdmNzk1YTU5ZjQ5MWFmYjgwJTIyJTBBY29sbGVjdGlvbiUyMCUzRCUyMGdldF9jb2xsZWN0aW9uKGNvbGxlY3Rpb25fc2x1ZyklMEElMEF1cGRhdGVfY29sbGVjdGlvbl9pdGVtKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRGNvbGxlY3Rpb25fc2x1ZyUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1QjIlNUQuaXRlbV9vYmplY3RfaWQlMkMlMEElMjAlMjAlMjAlMjBub3RlJTNEJTIyVGhpcyUyMGRhdGFzZXQlMjBjb250YWlucyUyMG9uZSUyMG1pbGxpb24lMjByZWFsLXdvcmxkJTIwY29udmVyc2F0aW9ucyUyMHdpdGglMjAyNSUyMHN0YXRlLW9mLXRoZS1hcnQlMjBMTE1zLiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, update_collection_item

<span class="hljs-comment"># Fetch collection with newly added items</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection_slug = <span class="hljs-string">&quot;osanseviero/os-week-highlights-sept-18-24-650bfed7f795a59f491afb80&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(collection_slug)

<span class="hljs-comment"># Add note the \`lmsys-chat-1m\` dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>update_collection_item(
<span class="hljs-meta">... </span>    collection_slug=collection_slug,
<span class="hljs-meta">... </span>    item_object_id=collection.items[<span class="hljs-number">2</span>].item_object_id,
<span class="hljs-meta">... </span>    note=<span class="hljs-string">&quot;This dataset contains one million real-world conversations with 25 state-of-the-art LLMs.&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),oe=new j({props:{title:"Reorder items",local:"reorder-items",headingTag:"h3"}}),me=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwdXBkYXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb25fc2x1ZyUyMCUzRCUyMCUyMm9zYW5zZXZpZXJvJTJGb3Mtd2Vlay1oaWdobGlnaHRzLXNlcHQtMTgtMjQtNjUwYmZlZDdmNzk1YTU5ZjQ5MWFmYjgwJTIyJTBBY29sbGVjdGlvbiUyMCUzRCUyMGdldF9jb2xsZWN0aW9uKGNvbGxlY3Rpb25fc2x1ZyklMEElMEF1cGRhdGVfY29sbGVjdGlvbl9pdGVtKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRGNvbGxlY3Rpb25fc2x1ZyUyQyUwQSUyMCUyMCUyMCUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1QjMlNUQuaXRlbV9vYmplY3RfaWQlMkMlMEElMjAlMjAlMjAlMjBwb3NpdGlvbiUzRDIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, update_collection_item

<span class="hljs-comment"># Fetch collection</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection_slug = <span class="hljs-string">&quot;osanseviero/os-week-highlights-sept-18-24-650bfed7f795a59f491afb80&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(collection_slug)

<span class="hljs-comment"># Reorder to place the two \`Wuerstchen\` items together</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>update_collection_item(
<span class="hljs-meta">... </span>    collection_slug=collection_slug,
<span class="hljs-meta">... </span>    item_object_id=collection.items[<span class="hljs-number">3</span>].item_object_id,
<span class="hljs-meta">... </span>    position=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),de=new j({props:{title:"Remove items",local:"remove-items",headingTag:"h3"}}),ue=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9jb2xsZWN0aW9uJTJDJTIwdXBkYXRlX2NvbGxlY3Rpb25faXRlbSUwQSUwQWNvbGxlY3Rpb25fc2x1ZyUyMCUzRCUyMCUyMm9zYW5zZXZpZXJvJTJGb3Mtd2Vlay1oaWdobGlnaHRzLXNlcHQtMTgtMjQtNjUwYmZlZDdmNzk1YTU5ZjQ5MWFmYjgwJTIyJTBBY29sbGVjdGlvbiUyMCUzRCUyMGdldF9jb2xsZWN0aW9uKGNvbGxlY3Rpb25fc2x1ZyklMEElMEFkZWxldGVfY29sbGVjdGlvbl9pdGVtKGNvbGxlY3Rpb25fc2x1ZyUzRGNvbGxlY3Rpb25fc2x1ZyUyQyUyMGl0ZW1fb2JqZWN0X2lkJTNEY29sbGVjdGlvbi5pdGVtcyU1QjAlNUQuaXRlbV9vYmplY3RfaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_collection, update_collection_item

<span class="hljs-comment"># Fetch collection</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection_slug = <span class="hljs-string">&quot;osanseviero/os-week-highlights-sept-18-24-650bfed7f795a59f491afb80&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = get_collection(collection_slug)

<span class="hljs-comment"># Remove \`coqui/xtts\` Space from the list</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>delete_collection_item(collection_slug=collection_slug, item_object_id=collection.items[<span class="hljs-number">0</span>].item_object_id)`,wrap:!1}}),he=new j({props:{title:"Delete collection",local:"delete-collection",headingTag:"h2"}}),G=new Ft({props:{warning:!0,$$slots:{default:[nl]},$$scope:{ctx:Me}}}),fe=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV9jb2xsZWN0aW9uJTBBY29sbGVjdGlvbiUyMCUzRCUyMGRlbGV0ZV9jb2xsZWN0aW9uKCUyMnVzZXJuYW1lJTJGdXNlbGVzcy1jb2xsZWN0aW9uLTY0ZjlhNTViYjMxMTViNGY1MTNlYzAyNiUyMiUyQyUyMG1pc3Npbmdfb2slM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_collection
<span class="hljs-meta">&gt;&gt;&gt; </span>collection = delete_collection(<span class="hljs-string">&quot;username/useless-collection-64f9a55bb3115b4f513ec026&quot;</span>, missing_ok=<span class="hljs-literal">True</span>)`,wrap:!1}}),be=new sl({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/collections.md"}}),{c(){p=i("meta"),M=a(),f=i("p"),y=a(),m(U.$$.fragment),ye=a(),w=i("p"),w.innerHTML=jt,_e=a(),v=i("p"),v.textContent=yt,$e=a(),m(T.$$.fragment),Ge=a(),x=i("p"),x.innerHTML=_t,Ue=a(),_=i("div"),_.innerHTML=$t,we=a(),k=i("p"),k.innerHTML=Gt,ve=a(),m(Z.$$.fragment),Te=a(),C=i("p"),C.innerHTML=Ut,xe=a(),J=i("ul"),J.innerHTML=wt,ke=a(),W=i("p"),W.textContent=vt,Ze=a(),Y=i("ul"),Y.innerHTML=Tt,Ce=a(),N=i("p"),N.innerHTML=xt,Je=a(),R=i("p"),R.innerHTML=kt,We=a(),m(H.$$.fragment),Ye=a(),V=i("p"),V.innerHTML=Zt,Ne=a(),m(q.$$.fragment),Re=a(),X=i("p"),X.innerHTML=Ct,He=a(),m(L.$$.fragment),Ve=a(),m($.$$.fragment),qe=a(),B=i("p"),B.innerHTML=Jt,Xe=a(),m(I.$$.fragment),Le=a(),Q=i("p"),Q.innerHTML=Wt,Be=a(),z=i("ul"),z.innerHTML=Yt,Ie=a(),A=i("p"),A.innerHTML=Nt,Qe=a(),m(E.$$.fragment),ze=a(),S=i("p"),S.innerHTML=Rt,Ae=a(),m(F.$$.fragment),Ee=a(),P=i("p"),P.innerHTML=Ht,Se=a(),m(D.$$.fragment),Fe=a(),m(K.$$.fragment),Pe=a(),O=i("p"),O.innerHTML=Vt,De=a(),m(ee.$$.fragment),Ke=a(),te=i("p"),te.innerHTML=qt,Oe=a(),m(le.$$.fragment),et=a(),se=i("p"),se.innerHTML=Xt,tt=a(),m(ae.$$.fragment),lt=a(),ne=i("p"),ne.innerHTML=Lt,st=a(),m(ie.$$.fragment),at=a(),m(oe.$$.fragment),nt=a(),ce=i("p"),ce.innerHTML=Bt,it=a(),pe=i("p"),pe.textContent=It,ot=a(),m(me.$$.fragment),ct=a(),m(de.$$.fragment),pt=a(),ge=i("p"),ge.innerHTML=Qt,mt=a(),m(ue.$$.fragment),dt=a(),m(he.$$.fragment),gt=a(),re=i("p"),re.innerHTML=zt,ut=a(),m(G.$$.fragment),ht=a(),m(fe.$$.fragment),rt=a(),m(be.$$.fragment),ft=a(),je=i("p"),this.h()},l(e){const t=tl("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),M=n(e),f=o(e,"P",{}),St(f).forEach(l),y=n(e),d(U.$$.fragment,e),ye=n(e),w=o(e,"P",{"data-svelte-h":!0}),c(w)!=="svelte-1d0qk1y"&&(w.innerHTML=jt),_e=n(e),v=o(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-4hgj6g"&&(v.textContent=yt),$e=n(e),d(T.$$.fragment,e),Ge=n(e),x=o(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-rie3o0"&&(x.innerHTML=_t),Ue=n(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),c(_)!=="svelte-1jx0yaw"&&(_.innerHTML=$t),we=n(e),k=o(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-xc9ft8"&&(k.innerHTML=Gt),ve=n(e),d(Z.$$.fragment,e),Te=n(e),C=o(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-1tzn150"&&(C.innerHTML=Ut),xe=n(e),J=o(e,"UL",{"data-svelte-h":!0}),c(J)!=="svelte-t1xz7m"&&(J.innerHTML=wt),ke=n(e),W=o(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1nrz3rc"&&(W.textContent=vt),Ze=n(e),Y=o(e,"UL",{"data-svelte-h":!0}),c(Y)!=="svelte-s2jbhz"&&(Y.innerHTML=Tt),Ce=n(e),N=o(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-yexhpv"&&(N.innerHTML=xt),Je=n(e),R=o(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1ih3le2"&&(R.innerHTML=kt),We=n(e),d(H.$$.fragment,e),Ye=n(e),V=o(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-a4ao54"&&(V.innerHTML=Zt),Ne=n(e),d(q.$$.fragment,e),Re=n(e),X=o(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-4v5som"&&(X.innerHTML=Ct),He=n(e),d(L.$$.fragment,e),Ve=n(e),d($.$$.fragment,e),qe=n(e),B=o(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1kzgk7s"&&(B.innerHTML=Jt),Xe=n(e),d(I.$$.fragment,e),Le=n(e),Q=o(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-jv0r4p"&&(Q.innerHTML=Wt),Be=n(e),z=o(e,"UL",{"data-svelte-h":!0}),c(z)!=="svelte-jnqrtk"&&(z.innerHTML=Yt),Ie=n(e),A=o(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-m2h1ym"&&(A.innerHTML=Nt),Qe=n(e),d(E.$$.fragment,e),ze=n(e),S=o(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-501c91"&&(S.innerHTML=Rt),Ae=n(e),d(F.$$.fragment,e),Ee=n(e),P=o(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-66g7bu"&&(P.innerHTML=Ht),Se=n(e),d(D.$$.fragment,e),Fe=n(e),d(K.$$.fragment,e),Pe=n(e),O=o(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1ki396m"&&(O.innerHTML=Vt),De=n(e),d(ee.$$.fragment,e),Ke=n(e),te=o(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-1tpd8hc"&&(te.innerHTML=qt),Oe=n(e),d(le.$$.fragment,e),et=n(e),se=o(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-k9xloo"&&(se.innerHTML=Xt),tt=n(e),d(ae.$$.fragment,e),lt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-apj23c"&&(ne.innerHTML=Lt),st=n(e),d(ie.$$.fragment,e),at=n(e),d(oe.$$.fragment,e),nt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-1z102in"&&(ce.innerHTML=Bt),it=n(e),pe=o(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-jrb2lu"&&(pe.textContent=It),ot=n(e),d(me.$$.fragment,e),ct=n(e),d(de.$$.fragment,e),pt=n(e),ge=o(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-1xi21qg"&&(ge.innerHTML=Qt),mt=n(e),d(ue.$$.fragment,e),dt=n(e),d(he.$$.fragment,e),gt=n(e),re=o(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-8f1m1m"&&(re.innerHTML=zt),ut=n(e),d(G.$$.fragment,e),ht=n(e),d(fe.$$.fragment,e),rt=n(e),d(be.$$.fragment,e),ft=n(e),je=o(e,"P",{}),St(je).forEach(l),this.h()},h(){Mt(p,"name","hf:doc:metadata"),Mt(p,"content",ol),Mt(_,"class","flex justify-center")},m(e,t){ll(document.head,p),s(e,M,t),s(e,f,t),s(e,y,t),g(U,e,t),s(e,ye,t),s(e,w,t),s(e,_e,t),s(e,v,t),s(e,$e,t),g(T,e,t),s(e,Ge,t),s(e,x,t),s(e,Ue,t),s(e,_,t),s(e,we,t),s(e,k,t),s(e,ve,t),g(Z,e,t),s(e,Te,t),s(e,C,t),s(e,xe,t),s(e,J,t),s(e,ke,t),s(e,W,t),s(e,Ze,t),s(e,Y,t),s(e,Ce,t),s(e,N,t),s(e,Je,t),s(e,R,t),s(e,We,t),g(H,e,t),s(e,Ye,t),s(e,V,t),s(e,Ne,t),g(q,e,t),s(e,Re,t),s(e,X,t),s(e,He,t),g(L,e,t),s(e,Ve,t),g($,e,t),s(e,qe,t),s(e,B,t),s(e,Xe,t),g(I,e,t),s(e,Le,t),s(e,Q,t),s(e,Be,t),s(e,z,t),s(e,Ie,t),s(e,A,t),s(e,Qe,t),g(E,e,t),s(e,ze,t),s(e,S,t),s(e,Ae,t),g(F,e,t),s(e,Ee,t),s(e,P,t),s(e,Se,t),g(D,e,t),s(e,Fe,t),g(K,e,t),s(e,Pe,t),s(e,O,t),s(e,De,t),g(ee,e,t),s(e,Ke,t),s(e,te,t),s(e,Oe,t),g(le,e,t),s(e,et,t),s(e,se,t),s(e,tt,t),g(ae,e,t),s(e,lt,t),s(e,ne,t),s(e,st,t),g(ie,e,t),s(e,at,t),g(oe,e,t),s(e,nt,t),s(e,ce,t),s(e,it,t),s(e,pe,t),s(e,ot,t),g(me,e,t),s(e,ct,t),g(de,e,t),s(e,pt,t),s(e,ge,t),s(e,mt,t),g(ue,e,t),s(e,dt,t),g(he,e,t),s(e,gt,t),s(e,re,t),s(e,ut,t),g(G,e,t),s(e,ht,t),g(fe,e,t),s(e,rt,t),g(be,e,t),s(e,ft,t),s(e,je,t),bt=!0},p(e,[t]){const At={};t&2&&(At.$$scope={dirty:t,ctx:e}),$.$set(At);const Et={};t&2&&(Et.$$scope={dirty:t,ctx:e}),G.$set(Et)},i(e){bt||(u(U.$$.fragment,e),u(T.$$.fragment,e),u(Z.$$.fragment,e),u(H.$$.fragment,e),u(q.$$.fragment,e),u(L.$$.fragment,e),u($.$$.fragment,e),u(I.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(me.$$.fragment,e),u(de.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(G.$$.fragment,e),u(fe.$$.fragment,e),u(be.$$.fragment,e),bt=!0)},o(e){h(U.$$.fragment,e),h(T.$$.fragment,e),h(Z.$$.fragment,e),h(H.$$.fragment,e),h(q.$$.fragment,e),h(L.$$.fragment,e),h($.$$.fragment,e),h(I.$$.fragment,e),h(E.$$.fragment,e),h(F.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(me.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(G.$$.fragment,e),h(fe.$$.fragment,e),h(be.$$.fragment,e),bt=!1},d(e){e&&(l(M),l(f),l(y),l(ye),l(w),l(_e),l(v),l($e),l(Ge),l(x),l(Ue),l(_),l(we),l(k),l(ve),l(Te),l(C),l(xe),l(J),l(ke),l(W),l(Ze),l(Y),l(Ce),l(N),l(Je),l(R),l(We),l(Ye),l(V),l(Ne),l(Re),l(X),l(He),l(Ve),l(qe),l(B),l(Xe),l(Le),l(Q),l(Be),l(z),l(Ie),l(A),l(Qe),l(ze),l(S),l(Ae),l(Ee),l(P),l(Se),l(Fe),l(Pe),l(O),l(De),l(Ke),l(te),l(Oe),l(et),l(se),l(tt),l(lt),l(ne),l(st),l(at),l(nt),l(ce),l(it),l(pe),l(ot),l(ct),l(pt),l(ge),l(mt),l(dt),l(gt),l(re),l(ut),l(ht),l(rt),l(ft),l(je)),l(p),r(U,e),r(T,e),r(Z,e),r(H,e),r(q,e),r(L,e),r($,e),r(I,e),r(E,e),r(F,e),r(D,e),r(K,e),r(ee,e),r(le,e),r(ae,e),r(ie,e),r(oe,e),r(me,e),r(de,e),r(ue,e),r(he,e),r(G,e),r(fe,e),r(be,e)}}}const ol='{"title":"Collections","local":"collections","sections":[{"title":"Fetch a collection","local":"fetch-a-collection","sections":[],"depth":2},{"title":"List collections","local":"list-collections","sections":[],"depth":2},{"title":"Create a new collection","local":"create-a-new-collection","sections":[],"depth":2},{"title":"Manage items in a collection","local":"manage-items-in-a-collection","sections":[{"title":"Add items","local":"add-items","sections":[],"depth":3},{"title":"Add a note to an existing item","local":"add-a-note-to-an-existing-item","sections":[],"depth":3},{"title":"Reorder items","local":"reorder-items","sections":[],"depth":3},{"title":"Remove items","local":"remove-items","sections":[],"depth":3}],"depth":2},{"title":"Delete collection","local":"delete-collection","sections":[],"depth":2}],"depth":1}';function cl(Me){return Kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hl extends Ot{constructor(p){super(),el(this,p,cl,il,Dt,{})}}export{hl as component};
