import{s as mt,o as ut,n as dt}from"../chunks/scheduler.8c3d61f6.js";import{S as ft,i as ht,g as i,s,r as c,A as gt,h as r,f as n,c as o,j as de,u as d,x as _,k as me,y as T,a as l,v as m,d as u,t as f,w as h,m as _t,n as Mt}from"../chunks/index.da70eac4.js";import{T as ct}from"../chunks/Tip.1d9b8c37.js";import{D as qe}from"../chunks/Docstring.ee4b6913.js";import{C as re}from"../chunks/CodeBlock.00a903b3.js";import{E as bt}from"../chunks/ExampleCodeBlock.f7bd2c1f.js";import{H as ie,E as wt}from"../chunks/EditOnGithub.1e64e623.js";function yt(Z){let a,M='Flux can be quite expensive to run on consumer hardware devices. However, you can perform a suite of optimizations to run it faster and in a more memory-friendly manner. Check out <a href="https://huggingface.co/blog/sd3#memory-optimizations-for-sd3" rel="nofollow">this section</a> for more details. Additionally, Flux can benefit from quantization for memory efficiency with a trade-off in inference latency. Refer to <a href="https://huggingface.co/blog/quanto-diffusers" rel="nofollow">this blog post</a> to learn more.  For an exhaustive list of resources, check out <a href="https://gist.github.com/sayakpaul/b664605caf0aa3bf8585ab109dd5ac9c" rel="nofollow">this gist</a>.';return{c(){a=i("p"),a.innerHTML=M},l(g){a=r(g,"P",{"data-svelte-h":!0}),_(a)!=="svelte-1nl2vrj"&&(a.innerHTML=M)},m(g,w){l(g,a,w)},p:dt,d(g){g&&n(a)}}}function xt(Z){let a;return{c(){a=_t("`FP8` inference can be brittle depending on the GPU type, CUDA version, and `torch` version that you are using. It is recommended that you use the `optimum-quanto` library in order to run FP8 inference on your machine.")},l(M){a=Mt(M,"`FP8` inference can be brittle depending on the GPU type, CUDA version, and `torch` version that you are using. It is recommended that you use the `optimum-quanto` library in order to run FP8 inference on your machine.")},m(M,g){l(M,a,g)},d(M){M&&n(a)}}}function Tt(Z){let a,M="Examples:",g,w,x;return w=new re({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEElMjMlMjBEZXBlbmRpbmclMjBvbiUyMHRoZSUyMHZhcmlhbnQlMjBiZWluZyUyMHVzZWQlMkMlMjB0aGUlMjBwaXBlbGluZSUyMGNhbGwlMjB3aWxsJTIwc2xpZ2h0bHklMjB2YXJ5LiUwQSUyMyUyMFJlZmVyJTIwdG8lMjB0aGUlMjBwaXBlbGluZSUyMGRvY3VtZW50YXRpb24lMjBmb3IlMjBtb3JlJTIwZGV0YWlscy4lMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyZmx1eC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Depending on the variant being used, the pipeline call will slightly vary.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Refer to the pipeline documentation for more details.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">0.0</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;flux.png&quot;</span>)`,wrap:!1}}),{c(){a=i("p"),a.textContent=M,g=s(),c(w.$$.fragment)},l(p){a=r(p,"P",{"data-svelte-h":!0}),_(a)!=="svelte-kvfsh7"&&(a.textContent=M),g=o(p),d(w.$$.fragment,p)},m(p,j){l(p,a,j),l(p,g,j),m(w,p,j),x=!0},p:dt,i(p){x||(u(w.$$.fragment,p),x=!0)},o(p){f(w.$$.fragment,p),x=!1},d(p){p&&(n(a),n(g)),h(w,p)}}}function jt(Z){let a,M,g,w,x,p,j,He='Flux is a series of text-to-image generation models based on diffusion transformers. To know more about Flux, check out the original <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">blog post</a> by the creators of Flux, Black Forest Labs.',ue,k,Ae='Original model checkpoints for Flux can be found <a href="https://huggingface.co/black-forest-labs" rel="nofollow">here</a>. Original inference code can be found <a href="https://github.com/black-forest-labs/flux" rel="nofollow">here</a>.',fe,v,he,$,Se="Flux comes in two variants:",ge,G,De="<li>Timestep-distilled (<code>black-forest-labs/FLUX.1-schnell</code>)</li> <li>Guidance-distilled (<code>black-forest-labs/FLUX.1-dev</code>)</li>",_e,I,Oe="Both checkpoints have slightly difference usage which we detail below.",Me,C,be,X,Ke="<li><code>max_sequence_length</code> cannot be more than 256.</li> <li><code>guidance_scale</code> needs to be 0.</li> <li>As this is a timestep-distilled model, it benefits from fewer sampling steps.</li>",we,W,ye,E,xe,P,et="<li>The guidance-distilled variant takes about 50 sampling steps for good-quality generation.</li> <li>It doesn’t have any limitations around the <code>max_sequence_length</code>.</li>",Te,z,je,N,Je,V,tt='Flux can generate high-quality images with FP16 (i.e. to accelerate inference on Turing/Volta GPUs) but produces different outputs compared to FP32/BF16. The issue is that some activations in the text encoders have to be clipped when running in FP16, which affects the overall image. Forcing text encoders to run with FP32 inference thus removes this output difference. See <a href="https://github.com/huggingface/diffusers/pull/9097#issuecomment-2272292516" rel="nofollow">here</a> for details.',Ue,Y,nt="FP16 inference code:",Ze,R,ve,L,Fe,Q,lt="The <code>FluxTransformer2DModel</code> supports loading checkpoints in the original format shipped by Black Forest Labs. This is also useful when trying to load finetunes or quantized versions of the models that have been published by the community.",Be,F,ke,q,st="The following example demonstrates how to run Flux with less than 16GB of VRAM.",$e,H,ot="First install <code>optimum-quanto</code>",Ge,A,Ie,S,at="Then run the following example",Ce,D,Xe,O,We,b,K,Ne,le,it="The Flux pipeline for text-to-image generation.",Ve,se,rt='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',Ye,J,ee,Re,oe,pt="Function invoked when calling the pipeline for generation.",Le,B,Qe,ae,te,Ee,ne,Pe,pe,ze;return x=new ie({props:{title:"Flux",local:"flux",headingTag:"h1"}}),v=new ct({props:{$$slots:{default:[yt]},$$scope:{ctx:Z}}}),C=new ie({props:{title:"Timestep-distilled",local:"timestep-distilled",headingTag:"h3"}}),W=new re({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEFvdXQlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMC4lMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q3NjglMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEzNjAlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXF1ZW5jZV9sZW5ndGglM0QyNTYlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFvdXQuc2F2ZSglMjJpbWFnZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
out = pipe(
    prompt=prompt,
    guidance_scale=<span class="hljs-number">0.</span>,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">1360</span>,
    num_inference_steps=<span class="hljs-number">4</span>,
    max_sequence_length=<span class="hljs-number">256</span>,
).images[<span class="hljs-number">0</span>]
out.save(<span class="hljs-string">&quot;image.png&quot;</span>)`,wrap:!1}}),E=new ie({props:{title:"Guidance-distilled",local:"guidance-distilled",headingTag:"h3"}}),z=new re({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHRpbnklMjBhc3Ryb25hdXQlMjBoYXRjaGluZyUyMGZyb20lMjBhbiUyMGVnZyUyMG9uJTIwdGhlJTIwbW9vbiUyMiUwQW91dCUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzLjUlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q3NjglMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEzNjAlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFvdXQuc2F2ZSglMjJpbWFnZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, torch_dtype=torch.bfloat16)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;a tiny astronaut hatching from an egg on the moon&quot;</span>
out = pipe(
    prompt=prompt,
    guidance_scale=<span class="hljs-number">3.5</span>,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">1360</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
).images[<span class="hljs-number">0</span>]
out.save(<span class="hljs-string">&quot;image.png&quot;</span>)`,wrap:!1}}),N=new ie({props:{title:"Running FP16 inference",local:"running-fp16-inference",headingTag:"h2"}}),R=new re({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTIwJTIzJTIwY2FuJTIwcmVwbGFjZSUyMHNjaG5lbGwlMjB3aXRoJTIwZGV2JTBBJTIzJTIwdG8lMjBydW4lMjBvbiUyMGxvdyUyMHZyYW0lMjBHUFVzJTIwKGkuZS4lMjBiZXR3ZWVuJTIwNCUyMGFuZCUyMDMyJTIwR0IlMjBWUkFNKSUwQXBpcGUuZW5hYmxlX3NlcXVlbnRpYWxfY3B1X29mZmxvYWQoKSUwQXBpcGUudmFlLmVuYWJsZV9zbGljaW5nKCklMEFwaXBlLnZhZS5lbmFibGVfdGlsaW5nKCklMEElMEFwaXBlLnRvKHRvcmNoLmZsb2F0MTYpJTIwJTIzJTIwY2FzdGluZyUyMGhlcmUlMjBpbnN0ZWFkJTIwb2YlMjBpbiUyMHRoZSUyMHBpcGVsaW5lJTIwY29uc3RydWN0b3IlMjBiZWNhdXNlJTIwZG9pbmclMjBzbyUyMGluJTIwdGhlJTIwY29uc3RydWN0b3IlMjBsb2FkcyUyMGFsbCUyMG1vZGVscyUyMGludG8lMjBDUFUlMjBtZW1vcnklMjBhdCUyMG9uY2UlMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBb3V0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAuJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMzYwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxdWVuY2VfbGVuZ3RoJTNEMjU2JTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBb3V0LnNhdmUoJTIyaW1hZ2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16) <span class="hljs-comment"># can replace schnell with dev</span>
<span class="hljs-comment"># to run on low vram GPUs (i.e. between 4 and 32 GB VRAM)</span>
pipe.enable_sequential_cpu_offload()
pipe.vae.enable_slicing()
pipe.vae.enable_tiling()

pipe.to(torch.float16) <span class="hljs-comment"># casting here instead of in the pipeline constructor because doing so in the constructor loads all models into CPU memory at once</span>

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
out = pipe(
    prompt=prompt,
    guidance_scale=<span class="hljs-number">0.</span>,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">1360</span>,
    num_inference_steps=<span class="hljs-number">4</span>,
    max_sequence_length=<span class="hljs-number">256</span>,
).images[<span class="hljs-number">0</span>]
out.save(<span class="hljs-string">&quot;image.png&quot;</span>)`,wrap:!1}}),L=new ie({props:{title:"Single File Loading for the FluxTransformer2DModel",local:"single-file-loading-for-the-fluxtransformer2dmodel",headingTag:"h2"}}),F=new ct({props:{$$slots:{default:[xt]},$$scope:{ctx:Z}}}),A=new re({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdGltdW0tcXVhbnRv",highlighted:"pip install optimum-quanto",wrap:!1}}),D=new re({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMEZsdXhQaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUNUVuY29kZXJNb2RlbCUyQyUyMENMSVBUZXh0TW9kZWwlMEFmcm9tJTIwb3B0aW11bS5xdWFudG8lMjBpbXBvcnQlMjBmcmVlemUlMkMlMjBxZmxvYXQ4JTJDJTIwcXVhbnRpemUlMEElMEFiZmxfcmVwbyUyMCUzRCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUwQWR0eXBlJTIwJTNEJTIwdG9yY2guYmZsb2F0MTYlMEElMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9zaW5nbGVfZmlsZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGS2lqYWklMkZmbHV4LWZwOCUyRmJsb2IlMkZtYWluJTJGZmx1eDEtZGV2LWZwOC5zYWZldGVuc29ycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEZHR5cGUpJTBBcXVhbnRpemUodHJhbnNmb3JtZXIlMkMlMjB3ZWlnaHRzJTNEcWZsb2F0OCklMEFmcmVlemUodHJhbnNmb3JtZXIpJTBBJTBBdGV4dF9lbmNvZGVyXzIlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmZsX3JlcG8lMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEZHR5cGUpJTBBcXVhbnRpemUodGV4dF9lbmNvZGVyXzIlMkMlMjB3ZWlnaHRzJTNEcWZsb2F0OCklMEFmcmVlemUodGV4dF9lbmNvZGVyXzIpJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoYmZsX3JlcG8lMkMlMjB0cmFuc2Zvcm1lciUzRE5vbmUlMkMlMjB0ZXh0X2VuY29kZXJfMiUzRE5vbmUlMkMlMjB0b3JjaF9kdHlwZSUzRGR0eXBlKSUwQXBpcGUudHJhbnNmb3JtZXIlMjAlM0QlMjB0cmFuc2Zvcm1lciUwQXBpcGUudGV4dF9lbmNvZGVyXzIlMjAlM0QlMjB0ZXh0X2VuY29kZXJfMiUwQSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMy41JTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJwaWwlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyZmx1eC1mcDgtZGV2LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, FluxPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel, CLIPTextModel
<span class="hljs-keyword">from</span> optimum.quanto <span class="hljs-keyword">import</span> freeze, qfloat8, quantize

bfl_repo = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
dtype = torch.bfloat16

transformer = FluxTransformer2DModel.from_single_file(<span class="hljs-string">&quot;https://huggingface.co/Kijai/flux-fp8/blob/main/flux1-dev-fp8.safetensors&quot;</span>, torch_dtype=dtype)
quantize(transformer, weights=qfloat8)
freeze(transformer)

text_encoder_2 = T5EncoderModel.from_pretrained(bfl_repo, subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>, torch_dtype=dtype)
quantize(text_encoder_2, weights=qfloat8)
freeze(text_encoder_2)

pipe = FluxPipeline.from_pretrained(bfl_repo, transformer=<span class="hljs-literal">None</span>, text_encoder_2=<span class="hljs-literal">None</span>, torch_dtype=dtype)
pipe.transformer = transformer
pipe.text_encoder_2 = text_encoder_2

pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(
    prompt,
    guidance_scale=<span class="hljs-number">3.5</span>,
    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;flux-fp8-dev.png&quot;</span>)`,wrap:!1}}),O=new ie({props:{title:"FluxPipeline",local:"diffusers.FluxPipeline",headingTag:"h2"}}),K=new qe({props:{name:"class diffusers.FluxPipeline",anchor:"diffusers.FluxPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.FluxPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/v0.30.0/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.30.0/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.30.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.0/src/diffusers/pipelines/flux/pipeline_flux.py#L140"}}),ee=new qe({props:{name:"__call__",anchor:"diffusers.FluxPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 28"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.FluxPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.FluxPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.FluxPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.FluxPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.FluxPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.FluxPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FluxPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.0/src/diffusers/pipelines/flux/pipeline_flux.py#L506",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),B=new bt({props:{anchor:"diffusers.FluxPipeline.__call__.example",$$slots:{default:[Tt]},$$scope:{ctx:Z}}}),te=new qe({props:{name:"encode_prompt",anchor:"diffusers.FluxPipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"prompt_2",val:": Union"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.FluxPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.FluxPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.0/src/diffusers/pipelines/flux/pipeline_flux.py#L288"}}),ne=new wt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/flux.md"}}),{c(){a=i("meta"),M=s(),g=i("p"),w=s(),c(x.$$.fragment),p=s(),j=i("p"),j.innerHTML=He,ue=s(),k=i("p"),k.innerHTML=Ae,fe=s(),c(v.$$.fragment),he=s(),$=i("p"),$.textContent=Se,ge=s(),G=i("ul"),G.innerHTML=De,_e=s(),I=i("p"),I.textContent=Oe,Me=s(),c(C.$$.fragment),be=s(),X=i("ul"),X.innerHTML=Ke,we=s(),c(W.$$.fragment),ye=s(),c(E.$$.fragment),xe=s(),P=i("ul"),P.innerHTML=et,Te=s(),c(z.$$.fragment),je=s(),c(N.$$.fragment),Je=s(),V=i("p"),V.innerHTML=tt,Ue=s(),Y=i("p"),Y.textContent=nt,Ze=s(),c(R.$$.fragment),ve=s(),c(L.$$.fragment),Fe=s(),Q=i("p"),Q.innerHTML=lt,Be=s(),c(F.$$.fragment),ke=s(),q=i("p"),q.textContent=st,$e=s(),H=i("p"),H.innerHTML=ot,Ge=s(),c(A.$$.fragment),Ie=s(),S=i("p"),S.textContent=at,Ce=s(),c(D.$$.fragment),Xe=s(),c(O.$$.fragment),We=s(),b=i("div"),c(K.$$.fragment),Ne=s(),le=i("p"),le.textContent=it,Ve=s(),se=i("p"),se.innerHTML=rt,Ye=s(),J=i("div"),c(ee.$$.fragment),Re=s(),oe=i("p"),oe.textContent=pt,Le=s(),c(B.$$.fragment),Qe=s(),ae=i("div"),c(te.$$.fragment),Ee=s(),c(ne.$$.fragment),Pe=s(),pe=i("p"),this.h()},l(e){const t=gt("svelte-u9bgzb",document.head);a=r(t,"META",{name:!0,content:!0}),t.forEach(n),M=o(e),g=r(e,"P",{}),de(g).forEach(n),w=o(e),d(x.$$.fragment,e),p=o(e),j=r(e,"P",{"data-svelte-h":!0}),_(j)!=="svelte-mlg237"&&(j.innerHTML=He),ue=o(e),k=r(e,"P",{"data-svelte-h":!0}),_(k)!=="svelte-pdc76o"&&(k.innerHTML=Ae),fe=o(e),d(v.$$.fragment,e),he=o(e),$=r(e,"P",{"data-svelte-h":!0}),_($)!=="svelte-3w7f1n"&&($.textContent=Se),ge=o(e),G=r(e,"UL",{"data-svelte-h":!0}),_(G)!=="svelte-g4tu0n"&&(G.innerHTML=De),_e=o(e),I=r(e,"P",{"data-svelte-h":!0}),_(I)!=="svelte-r8tuq5"&&(I.textContent=Oe),Me=o(e),d(C.$$.fragment,e),be=o(e),X=r(e,"UL",{"data-svelte-h":!0}),_(X)!=="svelte-459kcz"&&(X.innerHTML=Ke),we=o(e),d(W.$$.fragment,e),ye=o(e),d(E.$$.fragment,e),xe=o(e),P=r(e,"UL",{"data-svelte-h":!0}),_(P)!=="svelte-k8komj"&&(P.innerHTML=et),Te=o(e),d(z.$$.fragment,e),je=o(e),d(N.$$.fragment,e),Je=o(e),V=r(e,"P",{"data-svelte-h":!0}),_(V)!=="svelte-17mig8z"&&(V.innerHTML=tt),Ue=o(e),Y=r(e,"P",{"data-svelte-h":!0}),_(Y)!=="svelte-1gjlc3h"&&(Y.textContent=nt),Ze=o(e),d(R.$$.fragment,e),ve=o(e),d(L.$$.fragment,e),Fe=o(e),Q=r(e,"P",{"data-svelte-h":!0}),_(Q)!=="svelte-hittsd"&&(Q.innerHTML=lt),Be=o(e),d(F.$$.fragment,e),ke=o(e),q=r(e,"P",{"data-svelte-h":!0}),_(q)!=="svelte-1pyamwr"&&(q.textContent=st),$e=o(e),H=r(e,"P",{"data-svelte-h":!0}),_(H)!=="svelte-1ljbc3s"&&(H.innerHTML=ot),Ge=o(e),d(A.$$.fragment,e),Ie=o(e),S=r(e,"P",{"data-svelte-h":!0}),_(S)!=="svelte-15rpvn4"&&(S.textContent=at),Ce=o(e),d(D.$$.fragment,e),Xe=o(e),d(O.$$.fragment,e),We=o(e),b=r(e,"DIV",{class:!0});var y=de(b);d(K.$$.fragment,y),Ne=o(y),le=r(y,"P",{"data-svelte-h":!0}),_(le)!=="svelte-77uxl4"&&(le.textContent=it),Ve=o(y),se=r(y,"P",{"data-svelte-h":!0}),_(se)!=="svelte-mxgguy"&&(se.innerHTML=rt),Ye=o(y),J=r(y,"DIV",{class:!0});var U=de(J);d(ee.$$.fragment,U),Re=o(U),oe=r(U,"P",{"data-svelte-h":!0}),_(oe)!=="svelte-v78lg8"&&(oe.textContent=pt),Le=o(U),d(B.$$.fragment,U),U.forEach(n),Qe=o(y),ae=r(y,"DIV",{class:!0});var ce=de(ae);d(te.$$.fragment,ce),ce.forEach(n),y.forEach(n),Ee=o(e),d(ne.$$.fragment,e),Pe=o(e),pe=r(e,"P",{}),de(pe).forEach(n),this.h()},h(){me(a,"name","hf:doc:metadata"),me(a,"content",Jt),me(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),me(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),me(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){T(document.head,a),l(e,M,t),l(e,g,t),l(e,w,t),m(x,e,t),l(e,p,t),l(e,j,t),l(e,ue,t),l(e,k,t),l(e,fe,t),m(v,e,t),l(e,he,t),l(e,$,t),l(e,ge,t),l(e,G,t),l(e,_e,t),l(e,I,t),l(e,Me,t),m(C,e,t),l(e,be,t),l(e,X,t),l(e,we,t),m(W,e,t),l(e,ye,t),m(E,e,t),l(e,xe,t),l(e,P,t),l(e,Te,t),m(z,e,t),l(e,je,t),m(N,e,t),l(e,Je,t),l(e,V,t),l(e,Ue,t),l(e,Y,t),l(e,Ze,t),m(R,e,t),l(e,ve,t),m(L,e,t),l(e,Fe,t),l(e,Q,t),l(e,Be,t),m(F,e,t),l(e,ke,t),l(e,q,t),l(e,$e,t),l(e,H,t),l(e,Ge,t),m(A,e,t),l(e,Ie,t),l(e,S,t),l(e,Ce,t),m(D,e,t),l(e,Xe,t),m(O,e,t),l(e,We,t),l(e,b,t),m(K,b,null),T(b,Ne),T(b,le),T(b,Ve),T(b,se),T(b,Ye),T(b,J),m(ee,J,null),T(J,Re),T(J,oe),T(J,Le),m(B,J,null),T(b,Qe),T(b,ae),m(te,ae,null),l(e,Ee,t),m(ne,e,t),l(e,Pe,t),l(e,pe,t),ze=!0},p(e,[t]){const y={};t&2&&(y.$$scope={dirty:t,ctx:e}),v.$set(y);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),F.$set(U);const ce={};t&2&&(ce.$$scope={dirty:t,ctx:e}),B.$set(ce)},i(e){ze||(u(x.$$.fragment,e),u(v.$$.fragment,e),u(C.$$.fragment,e),u(W.$$.fragment,e),u(E.$$.fragment,e),u(z.$$.fragment,e),u(N.$$.fragment,e),u(R.$$.fragment,e),u(L.$$.fragment,e),u(F.$$.fragment,e),u(A.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(B.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),ze=!0)},o(e){f(x.$$.fragment,e),f(v.$$.fragment,e),f(C.$$.fragment,e),f(W.$$.fragment,e),f(E.$$.fragment,e),f(z.$$.fragment,e),f(N.$$.fragment,e),f(R.$$.fragment,e),f(L.$$.fragment,e),f(F.$$.fragment,e),f(A.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(B.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),ze=!1},d(e){e&&(n(M),n(g),n(w),n(p),n(j),n(ue),n(k),n(fe),n(he),n($),n(ge),n(G),n(_e),n(I),n(Me),n(be),n(X),n(we),n(ye),n(xe),n(P),n(Te),n(je),n(Je),n(V),n(Ue),n(Y),n(Ze),n(ve),n(Fe),n(Q),n(Be),n(ke),n(q),n($e),n(H),n(Ge),n(Ie),n(S),n(Ce),n(Xe),n(We),n(b),n(Ee),n(Pe),n(pe)),n(a),h(x,e),h(v,e),h(C,e),h(W,e),h(E,e),h(z,e),h(N,e),h(R,e),h(L,e),h(F,e),h(A,e),h(D,e),h(O,e),h(K),h(ee),h(B),h(te),h(ne,e)}}}const Jt='{"title":"Flux","local":"flux","sections":[{"title":"Timestep-distilled","local":"timestep-distilled","sections":[],"depth":3},{"title":"Guidance-distilled","local":"guidance-distilled","sections":[],"depth":3},{"title":"Running FP16 inference","local":"running-fp16-inference","sections":[],"depth":2},{"title":"Single File Loading for the FluxTransformer2DModel","local":"single-file-loading-for-the-fluxtransformer2dmodel","sections":[],"depth":2},{"title":"FluxPipeline","local":"diffusers.FluxPipeline","sections":[],"depth":2}],"depth":1}';function Ut(Z){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends ft{constructor(a){super(),ht(this,a,Ut,jt,mt,{})}}export{It as component};
