import{s as Gn,o as Xn,n as In}from"../chunks/scheduler.25b97de1.js";import{S as Qn,i as Nn,g as s,s as o,r as p,A as qn,h as l,f as a,c as r,j as Z,u as m,x as d,k as T,y as i,a as n,v as f,d as c,t as u,w as h}from"../chunks/index.d9030fc9.js";import{T as Vn}from"../chunks/Tip.baa67368.js";import{D as A}from"../chunks/Docstring.ffac8efa.js";import{C as _}from"../chunks/CodeBlock.e6cd0d95.js";import{D as zn}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as U,E as Yn}from"../chunks/EditOnGithub.91d95064.js";function Sn(Xe){let y,$="You can load a PEFT adapter with either an <code>AutoModelFor</code> class or the base model class like <code>OPTForCausalLM</code> or <code>LlamaForCausalLM</code>.";return{c(){y=s("p"),y.innerHTML=$},l(M){y=l(M,"P",{"data-svelte-h":!0}),d(y)!=="svelte-1cdoj9o"&&(y.innerHTML=$)},m(M,E){n(M,y,E)},p:In,d(M){M&&a(y)}}}function Dn(Xe){let y,$='If you aren’t familiar with fine-tuning a model with <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a>, take a look at the <a href="training">Fine-tune a pretrained model</a> tutorial.';return{c(){y=s("p"),y.innerHTML=$},l(M){y=l(M,"P",{"data-svelte-h":!0}),d(y)!=="svelte-1aqapad"&&(y.innerHTML=$)},m(M,E){n(M,y,E)},p:In,d(M){M&&a(y)}}}function Kn(Xe){let y,$,M,E,V,yt,I,Mt,G,za='<a href="https://huggingface.co/blog/peft" rel="nofollow">Parameter-Efficient Fine Tuning (PEFT)</a> methods freeze the pretrained model parameters during fine-tuning and add a small number of trainable parameters (the adapters) on top of it. The adapters are trained to learn task-specific information. This approach has been shown to be very memory-efficient with lower compute usage while producing results comparable to a fully fine-tuned model.',_t,X,Ya="Adapters trained with PEFT are also usually an order of magnitude smaller than the full model, making it convenient to share, store, and load them.",Tt,W,Sa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/PEFT-hub-screenshot.png"/> <figcaption class="text-center">The adapter weights for a OPTForCausalLM model stored on the Hub are only ~6MB compared to the full size of the model weights, which can be ~700MB.</figcaption>',wt,Q,Da='If you’re interested in learning more about the 🤗 PEFT library, check out the <a href="https://huggingface.co/docs/peft/index" rel="nofollow">documentation</a>.',$t,N,vt,q,Ka="Get started by installing 🤗 PEFT:",xt,z,Ct,Y,Oa="If you want to try out the brand new features, you might be interested in installing the library from source:",kt,S,Jt,D,Ft,K,en="🤗 Transformers natively supports some PEFT methods, meaning you can load adapter weights stored locally or on the Hub and easily run or train them with a few lines of code. The following methods are supported:",Zt,O,tn='<li><a href="https://huggingface.co/docs/peft/conceptual_guides/lora" rel="nofollow">Low Rank Adapters</a></li> <li><a href="https://huggingface.co/docs/peft/conceptual_guides/ia3" rel="nofollow">IA3</a></li> <li><a href="https://arxiv.org/abs/2303.10512" rel="nofollow">AdaLoRA</a></li>',Ut,ee,an='If you want to use other PEFT methods, such as prompt learning or prompt tuning, or learn about the 🤗 PEFT library in general, please refer to the <a href="https://huggingface.co/docs/peft/index" rel="nofollow">documentation</a>.',Pt,te,Et,ae,nn="To load and use a PEFT adapter model from 🤗 Transformers, make sure the Hub repository or local directory contains an <code>adapter_config.json</code> file and the adapter weights, as shown in the example image above. Then you can load the PEFT adapter model using the <code>AutoModelFor</code> class. For example, to load a PEFT adapter model for causal language modeling:",Wt,ne,on='<li>specify the PEFT model id</li> <li>pass it to the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM">AutoModelForCausalLM</a> class</li>',Bt,oe,jt,B,Lt,re,rn="You can also load a PEFT adapter by calling the <code>load_adapter</code> method:",Rt,se,Ht,le,sn='Check out the <a href="#transformers.integrations.PeftAdapterMixin">API documentation</a> section below for more details.',At,ie,Vt,de,ln='The <code>bitsandbytes</code> integration supports 8bit and 4bit precision data types, which are useful for loading large models because it saves memory (see the <code>bitsandbytes</code> integration <a href="./quantization#bitsandbytes-integration">guide</a> to learn more). Add the <code>load_in_8bit</code> or <code>load_in_4bit</code> parameters to <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> and set <code>device_map=&quot;auto&quot;</code> to effectively distribute the model to your hardware:',It,pe,Gt,me,Xt,fe,dn="You can use <code>~peft.PeftModel.add_adapter</code> to add a new adapter to a model with an existing adapter as long as the new adapter is the same type as the current one. For example, if you have an existing LoRA adapter attached to a model:",Qt,ce,Nt,ue,pn="To add a new adapter:",qt,he,zt,ge,mn="Now you can use <code>~peft.PeftModel.set_adapter</code> to set which adapter to use:",Yt,be,St,ye,Dt,Me,fn="Once you’ve added an adapter to a model, you can enable or disable the adapter module. To enable the adapter module:",Kt,_e,Ot,Te,cn="To disable the adapter module:",ea,we,ta,$e,aa,ve,un='PEFT adapters are supported by the <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> class so that you can train an adapter for your specific use case. It only requires adding a few more lines of code. For example, to train a LoRA adapter:',na,j,oa,xe,hn="<li>Define your adapter configuration with the task type and hyperparameters (see <code>~peft.LoraConfig</code> for more details about what the hyperparameters do).</li>",ra,Ce,sa,L,gn="<li>Add adapter to the model.</li>",la,ke,ia,R,bn='<li>Now you can pass the model to <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a>!</li>',da,Je,pa,Fe,yn="To save your trained adapter and load it back:",ma,Ze,fa,Ue,ca,Pe,Mn="You can also fine-tune additional trainable adapters on top of a model that has adapters attached by passing <code>modules_to_save</code> in your PEFT config. For example, if you want to also fine-tune the lm_head on top of a model with a LoRA adapter:",ua,Ee,ha,We,ga,g,Be,_a,Qe,_n=`A class containing all functions for loading and using adapters weights that are supported in PEFT library. For
more details about adapters and injecting them on a transformer-based model, check out the documentation of PEFT
library: <a href="https://huggingface.co/docs/peft/index" rel="nofollow">https://huggingface.co/docs/peft/index</a>`,Ta,Ne,Tn=`Currently supported PEFT methods are all non-prefix tuning methods. Below is the list of supported PEFT methods
that anyone can load, train and run with this mixin class:`,wa,qe,wn='<li>Low Rank Adapters (LoRA): <a href="https://huggingface.co/docs/peft/conceptual_guides/lora" rel="nofollow">https://huggingface.co/docs/peft/conceptual_guides/lora</a></li> <li>IA3: <a href="https://huggingface.co/docs/peft/conceptual_guides/ia3" rel="nofollow">https://huggingface.co/docs/peft/conceptual_guides/ia3</a></li> <li>AdaLora: <a href="https://arxiv.org/abs/2303.10512" rel="nofollow">https://arxiv.org/abs/2303.10512</a></li>',$a,ze,$n=`Other PEFT models such as prompt tuning, prompt learning are out of scope as these adapters are not “injectable”
into a torch module. For using these methods, please refer to the usage guide of PEFT library.`,va,Ye,vn="With this mixin, if the correct PEFT version is installed, it is possible to:",xa,Se,xn="<li>Load an adapter stored on a local path or in a remote Hub repository, and inject it in the model</li> <li>Attach new adapters in the model and train them with Trainer or by your own.</li> <li>Attach multiple adapters and iteratively activate / deactivate them</li> <li>Activate / deactivate all adapters from the model.</li> <li>Get the <code>state_dict</code> of the active adapter.</li>",Ca,v,je,ka,De,Cn=`Load adapter weights from file or remote Hub folder. If you are not familiar with adapters and PEFT methods, we
invite you to read more about them on PEFT official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Ja,Ke,kn="Requires peft as a backend to load the adapter weights.",Fa,x,Le,Za,Oe,Jn=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Ua,et,Fn=`Adds a fresh new adapter to the current model for training purpose. If no adapter name is passed, a default
name is assigned to the adapter to follow the convention of PEFT library (in PEFT we use “default” as the
default adapter name).`,Pa,C,Re,Ea,tt,Zn=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Wa,at,Un="Sets a specific adapter by forcing the model to use a that adapter and disable the other adapters.",Ba,k,He,ja,nt,Pn=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,La,ot,En="Disable all adapters that are attached to the model. This leads to inferring with the base model only.",Ra,J,Ae,Ha,rt,Wn=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Aa,st,Bn="Enable adapters that are attached to the model.",Va,w,Ve,Ia,lt,jn=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,Ga,it,Ln=`Gets the current active adapters of the model. In case of multi-adapter inference (combining multiple adapters
for inference) returns the list of all active adapters so that users can deal with them accordingly.`,Xa,dt,Rn=`For previous PEFT versions (that does not support multi-adapter inference), <code>module.active_adapter</code> will return
a single string.`,Qa,F,Ie,Na,pt,Hn=`If you are not familiar with adapters and PEFT methods, we invite you to read more about them on the PEFT
official documentation: <a href="https://huggingface.co/docs/peft" rel="nofollow">https://huggingface.co/docs/peft</a>`,qa,mt,An=`Gets the adapter state dict that should only contain the weights tensors of the specified adapter_name adapter.
If no adapter_name is passed, the active adapter is used.`,ba,Ge,ya,bt,Ma;return V=new U({props:{title:"Load adapters with 🤗 PEFT",local:"load-adapters-with--peft",headingTag:"h1"}}),I=new zn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/peft.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/peft.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/peft.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/peft.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/peft.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/peft.ipynb"}]}}),N=new U({props:{title:"Setup",local:"setup",headingTag:"h2"}}),z=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMHBlZnQ=",highlighted:"pip install peft",wrap:!1}}),S=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGcGVmdC5naXQ=",highlighted:"pip install git+https://github.com/huggingface/peft.git",wrap:!1}}),D=new U({props:{title:"Supported PEFT models",local:"supported-peft-models",headingTag:"h2"}}),te=new U({props:{title:"Load a PEFT adapter",local:"load-a-peft-adapter",headingTag:"h2"}}),oe=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
model = AutoModelForCausalLM.from_pretrained(peft_model_id)`,wrap:!1}}),B=new Vn({props:{$$slots:{default:[Sn]},$$scope:{ctx:Xe}}}),se=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbC5sb2FkX2FkYXB0ZXIocGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>

model = AutoModelForCausalLM.from_pretrained(model_id)
model.load_adapter(peft_model_id)`,wrap:!1}}),ie=new U({props:{title:"Load in 8bit or 4bit",local:"load-in-8bit-or-4bit",headingTag:"h2"}}),pe=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzREJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
model = AutoModelForCausalLM.from_pretrained(peft_model_id, quantization_config=BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>))`,wrap:!1}}),me=new U({props:{title:"Add a new adapter",local:"add-a-new-adapter",headingTag:"h2"}}),ce=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwaW5pdF9sb3JhX3dlaWdodHMlM0RGYWxzZSUwQSklMEElMEFtb2RlbC5hZGRfYWRhcHRlcihsb3JhX2NvbmZpZyUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXJfMSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id)

lora_config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>],
    init_lora_weights=<span class="hljs-literal">False</span>
)

model.add_adapter(lora_config, adapter_name=<span class="hljs-string">&quot;adapter_1&quot;</span>)`,wrap:!1}}),he=new _({props:{code:"JTIzJTIwYXR0YWNoJTIwbmV3JTIwYWRhcHRlciUyMHdpdGglMjBzYW1lJTIwY29uZmlnJTBBbW9kZWwuYWRkX2FkYXB0ZXIobG9yYV9jb25maWclMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyXzIlMjIp",highlighted:`<span class="hljs-comment"># attach new adapter with same config</span>
model.add_adapter(lora_config, adapter_name=<span class="hljs-string">&quot;adapter_2&quot;</span>)`,wrap:!1}}),be=new _({props:{code:"JTIzJTIwdXNlJTIwYWRhcHRlcl8xJTBBbW9kZWwuc2V0X2FkYXB0ZXIoJTIyYWRhcHRlcl8xJTIyKSUwQW91dHB1dF9kaXNhYmxlZCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0X2Rpc2FibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjB1c2UlMjBhZGFwdGVyXzIlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJhZGFwdGVyXzIlMjIpJTBBb3V0cHV0X2VuYWJsZWQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dF9lbmFibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-comment"># use adapter_1</span>
model.set_adapter(<span class="hljs-string">&quot;adapter_1&quot;</span>)
output_disabled = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_disabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))

<span class="hljs-comment"># use adapter_2</span>
model.set_adapter(<span class="hljs-string">&quot;adapter_2&quot;</span>)
output_enabled = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_enabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),ye=new U({props:{title:"Enable and disable adapters",local:"enable-and-disable-adapters",headingTag:"h2"}}),_e=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBYWRhcHRlcl9tb2RlbF9pZCUyMCUzRCUyMCUyMnliZWxrYWRhJTJGb3B0LTM1MG0tbG9yYSUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRleHQlMjAlM0QlMjAlMjJIZWxsbyUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMFBlZnRDb25maWcuZnJvbV9wcmV0cmFpbmVkKGFkYXB0ZXJfbW9kZWxfaWQpJTBBJTBBJTIzJTIwdG8lMjBpbml0aWF0ZSUyMHdpdGglMjByYW5kb20lMjB3ZWlnaHRzJTBBcGVmdF9jb25maWcuaW5pdF9sb3JhX3dlaWdodHMlMjAlM0QlMjBGYWxzZSUwQSUwQW1vZGVsLmFkZF9hZGFwdGVyKHBlZnRfY29uZmlnKSUwQW1vZGVsLmVuYWJsZV9hZGFwdGVycygpJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
adapter_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
text = <span class="hljs-string">&quot;Hello&quot;</span>
inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(model_id)
peft_config = PeftConfig.from_pretrained(adapter_model_id)

<span class="hljs-comment"># to initiate with random weights</span>
peft_config.init_lora_weights = <span class="hljs-literal">False</span>

model.add_adapter(peft_config)
model.enable_adapters()
output = model.generate(**inputs)`,wrap:!1}}),we=new _({props:{code:"bW9kZWwuZGlzYWJsZV9hZGFwdGVycygpJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMp",highlighted:`model.disable_adapters()
output = model.generate(**inputs)`,wrap:!1}}),$e=new U({props:{title:"Train a PEFT adapter",local:"train-a-peft-adapter",headingTag:"h2"}}),j=new Vn({props:{$$slots:{default:[Dn]},$$scope:{ctx:Xe}}}),Ce=new _({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMHIlM0Q2NCUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

peft_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)`,wrap:!1}}),ke=new _({props:{code:"bW9kZWwuYWRkX2FkYXB0ZXIocGVmdF9jb25maWcp",highlighted:"model.add_adapter(peft_config)",wrap:!1}}),Je=new _({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMC4uLiklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`trainer = Trainer(model=model, ...)
trainer.train()`,wrap:!1}}),Ze=new _({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKHNhdmVfZGlyKQ==",highlighted:`model.save_pretrained(save_dir)
model = AutoModelForCausalLM.from_pretrained(save_dir)`,wrap:!1}}),Ue=new U({props:{title:"Add additional trainable layers to a PEFT adapter",local:"add-additional-trainable-layers-to-a-peft-adapter",headingTag:"h2"}}),Ee=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIybG1faGVhZCUyMiU1RCUyQyUwQSklMEElMEFtb2RlbC5hZGRfYWRhcHRlcihsb3JhX2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id)

lora_config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;lm_head&quot;</span>],
)

model.add_adapter(lora_config)`,wrap:!1}}),We=new U({props:{title:"API docs",local:"transformers.integrations.PeftAdapterMixin",headingTag:"h2"}}),Be=new A({props:{name:"class transformers.integrations.PeftAdapterMixin",anchor:"transformers.integrations.PeftAdapterMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L45"}}),je=new A({props:{name:"load_adapter",anchor:"transformers.integrations.PeftAdapterMixin.load_adapter",parameters:[{name:"peft_model_id",val:": typing.Optional[str] = None"},{name:"adapter_name",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"device_map",val:": typing.Optional[str] = 'auto'"},{name:"max_memory",val:": typing.Optional[str] = None"},{name:"offload_folder",val:": typing.Optional[str] = None"},{name:"offload_index",val:": typing.Optional[int] = None"},{name:"peft_config",val:": typing.Dict[str, typing.Any] = None"},{name:"adapter_state_dict",val:": typing.Optional[typing.Dict[str, ForwardRef('torch.Tensor')]] = None"},{name:"low_cpu_mem_usage",val:": bool = False"},{name:"is_trainable",val:": bool = False"},{name:"adapter_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.peft_model_id",description:`<strong>peft_model_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The identifier of the model to look for on the Hub, or a local path to the saved adapter config file
and adapter weights.`,name:"peft_model_id"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The adapter name to use. If not set, will use the default adapter.`,name:"adapter_name"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass <code>revision=&quot;refs/pr/&lt;pr_number&gt;&quot;</code>.</p>

					</div>`,name:"revision"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.token",description:`<strong>token</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Whether to use authentication token to load the remote folder. Userful to load private repositories
that are on HuggingFace Hub. You might need to call <code>huggingface-cli login</code> and paste your tokens to
cache it.`,name:"token"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]]</code> or <code>int</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be refined to each
parameter/buffer name, once a given module name is inside, every submodule of it will be sent to the
same device. If we only pass the device (<em>e.g.</em>, <code>&quot;cpu&quot;</code>, <code>&quot;cuda:1&quot;</code>, <code>&quot;mps&quot;</code>, or a GPU ordinal rank
like <code>1</code>) on which the model will be allocated, the device map will map the entire model to this
device. Passing <code>device_map = 0</code> means put the whole model on GPU 0.</p>
<p>To have Accelerate compute the most optimized <code>device_map</code> automatically, set <code>device_map=&quot;auto&quot;</code>. For
more information about each option see <a href="https://hf.co/docs/accelerate/main/en/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">designing a device
map</a>.`,name:"device_map"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier to maximum memory. Will default to the maximum memory available for each
GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <code>optional</code>) &#x2014;
If the <code>device_map</code> contains any value <code>&quot;disk&quot;</code>, the folder where we will offload weights.`,name:"offload_folder"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.offload_index",description:`<strong>offload_index</strong> (<code>int</code>, <code>optional</code>) &#x2014;
<code>offload_index</code> argument to be passed to <code>accelerate.dispatch_model</code> method.`,name:"offload_index"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.peft_config",description:`<strong>peft_config</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The configuration of the adapter to add, supported adapters are non-prefix tuning and adaption prompts
methods. This argument is used in case users directly pass PEFT state dicts`,name:"peft_config"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.adapter_state_dict",description:`<strong>adapter_state_dict</strong> (<code>Dict[str, torch.Tensor]</code>, <em>optional</em>) &#x2014;
The state dict of the adapter to load. This argument is used in case users directly pass PEFT state
dicts`,name:"adapter_state_dict"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Reduce memory usage while loading the PEFT adapter. This should also speed up the loading process.
Requires PEFT version 0.13.0 or higher.`,name:"low_cpu_mem_usage"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.is_trainable",description:`<strong>is_trainable</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the adapter should be trainable or not. If <code>False</code>, the adapter will be frozen and can only be
used for inference.`,name:"is_trainable"},{anchor:"transformers.integrations.PeftAdapterMixin.load_adapter.adapter_kwargs",description:`<strong>adapter_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <code>from_pretrained</code> method of the adapter config and
<code>find_adapter_config_file</code> method.`,name:"adapter_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L71"}}),Le=new A({props:{name:"add_adapter",anchor:"transformers.integrations.PeftAdapterMixin.add_adapter",parameters:[{name:"adapter_config",val:""},{name:"adapter_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.integrations.PeftAdapterMixin.add_adapter.adapter_config",description:`<strong>adapter_config</strong> (<code>~peft.PeftConfig</code>) &#x2014;
The configuration of the adapter to add, supported adapters are non-prefix tuning and adaption prompts
methods`,name:"adapter_config"},{anchor:"transformers.integrations.PeftAdapterMixin.add_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The name of the adapter to add. If no name is passed, a default name is assigned to the adapter.`,name:"adapter_name"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L282"}}),Re=new A({props:{name:"set_adapter",anchor:"transformers.integrations.PeftAdapterMixin.set_adapter",parameters:[{name:"adapter_name",val:": typing.Union[typing.List[str], str]"}],parametersDescription:[{anchor:"transformers.integrations.PeftAdapterMixin.set_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>Union[List[str], str]</code>) &#x2014;
The name of the adapter to set. Can be also a list of strings to set multiple adapters.`,name:"adapter_name"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L319"}}),He=new A({props:{name:"disable_adapters",anchor:"transformers.integrations.PeftAdapterMixin.disable_adapters",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L364"}}),Ae=new A({props:{name:"enable_adapters",anchor:"transformers.integrations.PeftAdapterMixin.enable_adapters",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L387"}}),Ve=new A({props:{name:"active_adapters",anchor:"transformers.integrations.PeftAdapterMixin.active_adapters",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L409"}}),Ie=new A({props:{name:"get_adapter_state_dict",anchor:"transformers.integrations.PeftAdapterMixin.get_adapter_state_dict",parameters:[{name:"adapter_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.integrations.PeftAdapterMixin.get_adapter_state_dict.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the adapter to get the state dict from. If no name is passed, the active adapter is used.`,name:"adapter_name"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/integrations/peft.py#L448"}}),Ge=new Yn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/peft.md"}}),{c(){y=s("meta"),$=o(),M=s("p"),E=o(),p(V.$$.fragment),yt=o(),p(I.$$.fragment),Mt=o(),G=s("p"),G.innerHTML=za,_t=o(),X=s("p"),X.textContent=Ya,Tt=o(),W=s("div"),W.innerHTML=Sa,wt=o(),Q=s("p"),Q.innerHTML=Da,$t=o(),p(N.$$.fragment),vt=o(),q=s("p"),q.textContent=Ka,xt=o(),p(z.$$.fragment),Ct=o(),Y=s("p"),Y.textContent=Oa,kt=o(),p(S.$$.fragment),Jt=o(),p(D.$$.fragment),Ft=o(),K=s("p"),K.textContent=en,Zt=o(),O=s("ul"),O.innerHTML=tn,Ut=o(),ee=s("p"),ee.innerHTML=an,Pt=o(),p(te.$$.fragment),Et=o(),ae=s("p"),ae.innerHTML=nn,Wt=o(),ne=s("ol"),ne.innerHTML=on,Bt=o(),p(oe.$$.fragment),jt=o(),p(B.$$.fragment),Lt=o(),re=s("p"),re.innerHTML=rn,Rt=o(),p(se.$$.fragment),Ht=o(),le=s("p"),le.innerHTML=sn,At=o(),p(ie.$$.fragment),Vt=o(),de=s("p"),de.innerHTML=ln,It=o(),p(pe.$$.fragment),Gt=o(),p(me.$$.fragment),Xt=o(),fe=s("p"),fe.innerHTML=dn,Qt=o(),p(ce.$$.fragment),Nt=o(),ue=s("p"),ue.textContent=pn,qt=o(),p(he.$$.fragment),zt=o(),ge=s("p"),ge.innerHTML=mn,Yt=o(),p(be.$$.fragment),St=o(),p(ye.$$.fragment),Dt=o(),Me=s("p"),Me.textContent=fn,Kt=o(),p(_e.$$.fragment),Ot=o(),Te=s("p"),Te.textContent=cn,ea=o(),p(we.$$.fragment),ta=o(),p($e.$$.fragment),aa=o(),ve=s("p"),ve.innerHTML=un,na=o(),p(j.$$.fragment),oa=o(),xe=s("ol"),xe.innerHTML=hn,ra=o(),p(Ce.$$.fragment),sa=o(),L=s("ol"),L.innerHTML=gn,la=o(),p(ke.$$.fragment),ia=o(),R=s("ol"),R.innerHTML=bn,da=o(),p(Je.$$.fragment),pa=o(),Fe=s("p"),Fe.textContent=yn,ma=o(),p(Ze.$$.fragment),fa=o(),p(Ue.$$.fragment),ca=o(),Pe=s("p"),Pe.innerHTML=Mn,ua=o(),p(Ee.$$.fragment),ha=o(),p(We.$$.fragment),ga=o(),g=s("div"),p(Be.$$.fragment),_a=o(),Qe=s("p"),Qe.innerHTML=_n,Ta=o(),Ne=s("p"),Ne.textContent=Tn,wa=o(),qe=s("ul"),qe.innerHTML=wn,$a=o(),ze=s("p"),ze.textContent=$n,va=o(),Ye=s("p"),Ye.textContent=vn,xa=o(),Se=s("ul"),Se.innerHTML=xn,Ca=o(),v=s("div"),p(je.$$.fragment),ka=o(),De=s("p"),De.innerHTML=Cn,Ja=o(),Ke=s("p"),Ke.textContent=kn,Fa=o(),x=s("div"),p(Le.$$.fragment),Za=o(),Oe=s("p"),Oe.innerHTML=Jn,Ua=o(),et=s("p"),et.textContent=Fn,Pa=o(),C=s("div"),p(Re.$$.fragment),Ea=o(),tt=s("p"),tt.innerHTML=Zn,Wa=o(),at=s("p"),at.textContent=Un,Ba=o(),k=s("div"),p(He.$$.fragment),ja=o(),nt=s("p"),nt.innerHTML=Pn,La=o(),ot=s("p"),ot.textContent=En,Ra=o(),J=s("div"),p(Ae.$$.fragment),Ha=o(),rt=s("p"),rt.innerHTML=Wn,Aa=o(),st=s("p"),st.textContent=Bn,Va=o(),w=s("div"),p(Ve.$$.fragment),Ia=o(),lt=s("p"),lt.innerHTML=jn,Ga=o(),it=s("p"),it.textContent=Ln,Xa=o(),dt=s("p"),dt.innerHTML=Rn,Qa=o(),F=s("div"),p(Ie.$$.fragment),Na=o(),pt=s("p"),pt.innerHTML=Hn,qa=o(),mt=s("p"),mt.textContent=An,ba=o(),p(Ge.$$.fragment),ya=o(),bt=s("p"),this.h()},l(e){const t=qn("svelte-u9bgzb",document.head);y=l(t,"META",{name:!0,content:!0}),t.forEach(a),$=r(e),M=l(e,"P",{}),Z(M).forEach(a),E=r(e),m(V.$$.fragment,e),yt=r(e),m(I.$$.fragment,e),Mt=r(e),G=l(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-378l9l"&&(G.innerHTML=za),_t=r(e),X=l(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-nc5pgb"&&(X.textContent=Ya),Tt=r(e),W=l(e,"DIV",{class:!0,"data-svelte-h":!0}),d(W)!=="svelte-1gn6iv2"&&(W.innerHTML=Sa),wt=r(e),Q=l(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1ldq9i6"&&(Q.innerHTML=Da),$t=r(e),m(N.$$.fragment,e),vt=r(e),q=l(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1rn19ih"&&(q.textContent=Ka),xt=r(e),m(z.$$.fragment,e),Ct=r(e),Y=l(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-cgwmeo"&&(Y.textContent=Oa),kt=r(e),m(S.$$.fragment,e),Jt=r(e),m(D.$$.fragment,e),Ft=r(e),K=l(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-5xdqaf"&&(K.textContent=en),Zt=r(e),O=l(e,"UL",{"data-svelte-h":!0}),d(O)!=="svelte-1ulyaf4"&&(O.innerHTML=tn),Ut=r(e),ee=l(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1jtpf1q"&&(ee.innerHTML=an),Pt=r(e),m(te.$$.fragment,e),Et=r(e),ae=l(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-c3wuk0"&&(ae.innerHTML=nn),Wt=r(e),ne=l(e,"OL",{"data-svelte-h":!0}),d(ne)!=="svelte-1yy7goh"&&(ne.innerHTML=on),Bt=r(e),m(oe.$$.fragment,e),jt=r(e),m(B.$$.fragment,e),Lt=r(e),re=l(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1l4y13r"&&(re.innerHTML=rn),Rt=r(e),m(se.$$.fragment,e),Ht=r(e),le=l(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-3yz3tt"&&(le.innerHTML=sn),At=r(e),m(ie.$$.fragment,e),Vt=r(e),de=l(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-15a7q7h"&&(de.innerHTML=ln),It=r(e),m(pe.$$.fragment,e),Gt=r(e),m(me.$$.fragment,e),Xt=r(e),fe=l(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1xpot6r"&&(fe.innerHTML=dn),Qt=r(e),m(ce.$$.fragment,e),Nt=r(e),ue=l(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1t2m746"&&(ue.textContent=pn),qt=r(e),m(he.$$.fragment,e),zt=r(e),ge=l(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-adr915"&&(ge.innerHTML=mn),Yt=r(e),m(be.$$.fragment,e),St=r(e),m(ye.$$.fragment,e),Dt=r(e),Me=l(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-gwuro2"&&(Me.textContent=fn),Kt=r(e),m(_e.$$.fragment,e),Ot=r(e),Te=l(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-tzq689"&&(Te.textContent=cn),ea=r(e),m(we.$$.fragment,e),ta=r(e),m($e.$$.fragment,e),aa=r(e),ve=l(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-1jgkwn3"&&(ve.innerHTML=un),na=r(e),m(j.$$.fragment,e),oa=r(e),xe=l(e,"OL",{"data-svelte-h":!0}),d(xe)!=="svelte-28sdvg"&&(xe.innerHTML=hn),ra=r(e),m(Ce.$$.fragment,e),sa=r(e),L=l(e,"OL",{start:!0,"data-svelte-h":!0}),d(L)!=="svelte-1qk52ef"&&(L.innerHTML=gn),la=r(e),m(ke.$$.fragment,e),ia=r(e),R=l(e,"OL",{start:!0,"data-svelte-h":!0}),d(R)!=="svelte-e9niqx"&&(R.innerHTML=bn),da=r(e),m(Je.$$.fragment,e),pa=r(e),Fe=l(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1nalv2a"&&(Fe.textContent=yn),ma=r(e),m(Ze.$$.fragment,e),fa=r(e),m(Ue.$$.fragment,e),ca=r(e),Pe=l(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-6009n9"&&(Pe.innerHTML=Mn),ua=r(e),m(Ee.$$.fragment,e),ha=r(e),m(We.$$.fragment,e),ga=r(e),g=l(e,"DIV",{class:!0});var b=Z(g);m(Be.$$.fragment,b),_a=r(b),Qe=l(b,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1lavptw"&&(Qe.innerHTML=_n),Ta=r(b),Ne=l(b,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-2z4u5p"&&(Ne.textContent=Tn),wa=r(b),qe=l(b,"UL",{"data-svelte-h":!0}),d(qe)!=="svelte-1ug31ta"&&(qe.innerHTML=wn),$a=r(b),ze=l(b,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1nqkdi3"&&(ze.textContent=$n),va=r(b),Ye=l(b,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-wzrwkl"&&(Ye.textContent=vn),xa=r(b),Se=l(b,"UL",{"data-svelte-h":!0}),d(Se)!=="svelte-4kner1"&&(Se.innerHTML=xn),Ca=r(b),v=l(b,"DIV",{class:!0});var P=Z(v);m(je.$$.fragment,P),ka=r(P),De=l(P,"P",{"data-svelte-h":!0}),d(De)!=="svelte-k3pc0b"&&(De.innerHTML=Cn),Ja=r(P),Ke=l(P,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-qhx0qk"&&(Ke.textContent=kn),P.forEach(a),Fa=r(b),x=l(b,"DIV",{class:!0});var ft=Z(x);m(Le.$$.fragment,ft),Za=r(ft),Oe=l(ft,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-esrgfk"&&(Oe.innerHTML=Jn),Ua=r(ft),et=l(ft,"P",{"data-svelte-h":!0}),d(et)!=="svelte-11mk5e0"&&(et.textContent=Fn),ft.forEach(a),Pa=r(b),C=l(b,"DIV",{class:!0});var ct=Z(C);m(Re.$$.fragment,ct),Ea=r(ct),tt=l(ct,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-esrgfk"&&(tt.innerHTML=Zn),Wa=r(ct),at=l(ct,"P",{"data-svelte-h":!0}),d(at)!=="svelte-dcd4bp"&&(at.textContent=Un),ct.forEach(a),Ba=r(b),k=l(b,"DIV",{class:!0});var ut=Z(k);m(He.$$.fragment,ut),ja=r(ut),nt=l(ut,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-esrgfk"&&(nt.innerHTML=Pn),La=r(ut),ot=l(ut,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-1h3d7ho"&&(ot.textContent=En),ut.forEach(a),Ra=r(b),J=l(b,"DIV",{class:!0});var ht=Z(J);m(Ae.$$.fragment,ht),Ha=r(ht),rt=l(ht,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-esrgfk"&&(rt.innerHTML=Wn),Aa=r(ht),st=l(ht,"P",{"data-svelte-h":!0}),d(st)!=="svelte-fvwnbf"&&(st.textContent=Bn),ht.forEach(a),Va=r(b),w=l(b,"DIV",{class:!0});var H=Z(w);m(Ve.$$.fragment,H),Ia=r(H),lt=l(H,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-esrgfk"&&(lt.innerHTML=jn),Ga=r(H),it=l(H,"P",{"data-svelte-h":!0}),d(it)!=="svelte-kqotd"&&(it.textContent=Ln),Xa=r(H),dt=l(H,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-13oobru"&&(dt.innerHTML=Rn),H.forEach(a),Qa=r(b),F=l(b,"DIV",{class:!0});var gt=Z(F);m(Ie.$$.fragment,gt),Na=r(gt),pt=l(gt,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-esrgfk"&&(pt.innerHTML=Hn),qa=r(gt),mt=l(gt,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-tj66gs"&&(mt.textContent=An),gt.forEach(a),b.forEach(a),ba=r(e),m(Ge.$$.fragment,e),ya=r(e),bt=l(e,"P",{}),Z(bt).forEach(a),this.h()},h(){T(y,"name","hf:doc:metadata"),T(y,"content",On),T(W,"class","flex flex-col justify-center"),T(L,"start","2"),T(R,"start","3"),T(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,y),n(e,$,t),n(e,M,t),n(e,E,t),f(V,e,t),n(e,yt,t),f(I,e,t),n(e,Mt,t),n(e,G,t),n(e,_t,t),n(e,X,t),n(e,Tt,t),n(e,W,t),n(e,wt,t),n(e,Q,t),n(e,$t,t),f(N,e,t),n(e,vt,t),n(e,q,t),n(e,xt,t),f(z,e,t),n(e,Ct,t),n(e,Y,t),n(e,kt,t),f(S,e,t),n(e,Jt,t),f(D,e,t),n(e,Ft,t),n(e,K,t),n(e,Zt,t),n(e,O,t),n(e,Ut,t),n(e,ee,t),n(e,Pt,t),f(te,e,t),n(e,Et,t),n(e,ae,t),n(e,Wt,t),n(e,ne,t),n(e,Bt,t),f(oe,e,t),n(e,jt,t),f(B,e,t),n(e,Lt,t),n(e,re,t),n(e,Rt,t),f(se,e,t),n(e,Ht,t),n(e,le,t),n(e,At,t),f(ie,e,t),n(e,Vt,t),n(e,de,t),n(e,It,t),f(pe,e,t),n(e,Gt,t),f(me,e,t),n(e,Xt,t),n(e,fe,t),n(e,Qt,t),f(ce,e,t),n(e,Nt,t),n(e,ue,t),n(e,qt,t),f(he,e,t),n(e,zt,t),n(e,ge,t),n(e,Yt,t),f(be,e,t),n(e,St,t),f(ye,e,t),n(e,Dt,t),n(e,Me,t),n(e,Kt,t),f(_e,e,t),n(e,Ot,t),n(e,Te,t),n(e,ea,t),f(we,e,t),n(e,ta,t),f($e,e,t),n(e,aa,t),n(e,ve,t),n(e,na,t),f(j,e,t),n(e,oa,t),n(e,xe,t),n(e,ra,t),f(Ce,e,t),n(e,sa,t),n(e,L,t),n(e,la,t),f(ke,e,t),n(e,ia,t),n(e,R,t),n(e,da,t),f(Je,e,t),n(e,pa,t),n(e,Fe,t),n(e,ma,t),f(Ze,e,t),n(e,fa,t),f(Ue,e,t),n(e,ca,t),n(e,Pe,t),n(e,ua,t),f(Ee,e,t),n(e,ha,t),f(We,e,t),n(e,ga,t),n(e,g,t),f(Be,g,null),i(g,_a),i(g,Qe),i(g,Ta),i(g,Ne),i(g,wa),i(g,qe),i(g,$a),i(g,ze),i(g,va),i(g,Ye),i(g,xa),i(g,Se),i(g,Ca),i(g,v),f(je,v,null),i(v,ka),i(v,De),i(v,Ja),i(v,Ke),i(g,Fa),i(g,x),f(Le,x,null),i(x,Za),i(x,Oe),i(x,Ua),i(x,et),i(g,Pa),i(g,C),f(Re,C,null),i(C,Ea),i(C,tt),i(C,Wa),i(C,at),i(g,Ba),i(g,k),f(He,k,null),i(k,ja),i(k,nt),i(k,La),i(k,ot),i(g,Ra),i(g,J),f(Ae,J,null),i(J,Ha),i(J,rt),i(J,Aa),i(J,st),i(g,Va),i(g,w),f(Ve,w,null),i(w,Ia),i(w,lt),i(w,Ga),i(w,it),i(w,Xa),i(w,dt),i(g,Qa),i(g,F),f(Ie,F,null),i(F,Na),i(F,pt),i(F,qa),i(F,mt),n(e,ba,t),f(Ge,e,t),n(e,ya,t),n(e,bt,t),Ma=!0},p(e,[t]){const b={};t&2&&(b.$$scope={dirty:t,ctx:e}),B.$set(b);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),j.$set(P)},i(e){Ma||(c(V.$$.fragment,e),c(I.$$.fragment,e),c(N.$$.fragment,e),c(z.$$.fragment,e),c(S.$$.fragment,e),c(D.$$.fragment,e),c(te.$$.fragment,e),c(oe.$$.fragment,e),c(B.$$.fragment,e),c(se.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(he.$$.fragment,e),c(be.$$.fragment,e),c(ye.$$.fragment,e),c(_e.$$.fragment,e),c(we.$$.fragment,e),c($e.$$.fragment,e),c(j.$$.fragment,e),c(Ce.$$.fragment,e),c(ke.$$.fragment,e),c(Je.$$.fragment,e),c(Ze.$$.fragment,e),c(Ue.$$.fragment,e),c(Ee.$$.fragment,e),c(We.$$.fragment,e),c(Be.$$.fragment,e),c(je.$$.fragment,e),c(Le.$$.fragment,e),c(Re.$$.fragment,e),c(He.$$.fragment,e),c(Ae.$$.fragment,e),c(Ve.$$.fragment,e),c(Ie.$$.fragment,e),c(Ge.$$.fragment,e),Ma=!0)},o(e){u(V.$$.fragment,e),u(I.$$.fragment,e),u(N.$$.fragment,e),u(z.$$.fragment,e),u(S.$$.fragment,e),u(D.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(B.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(he.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(_e.$$.fragment,e),u(we.$$.fragment,e),u($e.$$.fragment,e),u(j.$$.fragment,e),u(Ce.$$.fragment,e),u(ke.$$.fragment,e),u(Je.$$.fragment,e),u(Ze.$$.fragment,e),u(Ue.$$.fragment,e),u(Ee.$$.fragment,e),u(We.$$.fragment,e),u(Be.$$.fragment,e),u(je.$$.fragment,e),u(Le.$$.fragment,e),u(Re.$$.fragment,e),u(He.$$.fragment,e),u(Ae.$$.fragment,e),u(Ve.$$.fragment,e),u(Ie.$$.fragment,e),u(Ge.$$.fragment,e),Ma=!1},d(e){e&&(a($),a(M),a(E),a(yt),a(Mt),a(G),a(_t),a(X),a(Tt),a(W),a(wt),a(Q),a($t),a(vt),a(q),a(xt),a(Ct),a(Y),a(kt),a(Jt),a(Ft),a(K),a(Zt),a(O),a(Ut),a(ee),a(Pt),a(Et),a(ae),a(Wt),a(ne),a(Bt),a(jt),a(Lt),a(re),a(Rt),a(Ht),a(le),a(At),a(Vt),a(de),a(It),a(Gt),a(Xt),a(fe),a(Qt),a(Nt),a(ue),a(qt),a(zt),a(ge),a(Yt),a(St),a(Dt),a(Me),a(Kt),a(Ot),a(Te),a(ea),a(ta),a(aa),a(ve),a(na),a(oa),a(xe),a(ra),a(sa),a(L),a(la),a(ia),a(R),a(da),a(pa),a(Fe),a(ma),a(fa),a(ca),a(Pe),a(ua),a(ha),a(ga),a(g),a(ba),a(ya),a(bt)),a(y),h(V,e),h(I,e),h(N,e),h(z,e),h(S,e),h(D,e),h(te,e),h(oe,e),h(B,e),h(se,e),h(ie,e),h(pe,e),h(me,e),h(ce,e),h(he,e),h(be,e),h(ye,e),h(_e,e),h(we,e),h($e,e),h(j,e),h(Ce,e),h(ke,e),h(Je,e),h(Ze,e),h(Ue,e),h(Ee,e),h(We,e),h(Be),h(je),h(Le),h(Re),h(He),h(Ae),h(Ve),h(Ie),h(Ge,e)}}}const On='{"title":"Load adapters with 🤗 PEFT","local":"load-adapters-with--peft","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Supported PEFT models","local":"supported-peft-models","sections":[],"depth":2},{"title":"Load a PEFT adapter","local":"load-a-peft-adapter","sections":[],"depth":2},{"title":"Load in 8bit or 4bit","local":"load-in-8bit-or-4bit","sections":[],"depth":2},{"title":"Add a new adapter","local":"add-a-new-adapter","sections":[],"depth":2},{"title":"Enable and disable adapters","local":"enable-and-disable-adapters","sections":[],"depth":2},{"title":"Train a PEFT adapter","local":"train-a-peft-adapter","sections":[],"depth":2},{"title":"Add additional trainable layers to a PEFT adapter","local":"add-additional-trainable-layers-to-a-peft-adapter","sections":[],"depth":2},{"title":"API docs","local":"transformers.integrations.PeftAdapterMixin","sections":[],"depth":2}],"depth":1}';function eo(Xe){return Xn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class io extends Qn{constructor(y){super(),Nn(this,y,eo,Kn,Gn,{})}}export{io as component};
