import{s as Wt,o as Zt,n as xe}from"../chunks/scheduler.9bc65507.js";import{S as Ht,i as Nt,g as l,s as a,r as p,A as Bt,h as c,f as n,c as s,j as I,u,x as _,k as J,y as r,a as d,v as m,d as h,t as f,w as g}from"../chunks/index.707bf1b6.js";import{T as gt}from"../chunks/Tip.c2ecdbf4.js";import{D as ue}from"../chunks/Docstring.17db21ae.js";import{C as _t}from"../chunks/CodeBlock.54a9f38d.js";import{E as Pt}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as G}from"../chunks/Heading.342b1fa6.js";function Rt(S){let o,b;return o=new _t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN0YXJjb2RlcjJNb2RlbCUyQyUyMFN0YXJjb2RlcjJDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3RhcmNvZGVyMiUyMDdCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFN0YXJjb2RlcjJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBTdGFyY29kZXIyJTIwN0IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFN0YXJjb2RlcjJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Starcoder2Model, Starcoder2Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Starcoder2 7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Starcoder2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Starcoder2 7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Starcoder2Model(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){p(o.$$.fragment)},l(i){u(o.$$.fragment,i)},m(i,v){m(o,i,v),b=!0},p:xe,i(i){b||(h(o.$$.fragment,i),b=!0)},o(i){f(o.$$.fragment,i),b=!1},d(i){g(o,i)}}}function Gt(S){let o,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=l("p"),o.innerHTML=b},l(i){o=c(i,"P",{"data-svelte-h":!0}),_(o)!=="svelte-fincs2"&&(o.innerHTML=b)},m(i,v){d(i,o,v)},p:xe,d(i){i&&n(o)}}}function Xt(S){let o,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=l("p"),o.innerHTML=b},l(i){o=c(i,"P",{"data-svelte-h":!0}),_(o)!=="svelte-fincs2"&&(o.innerHTML=b)},m(i,v){d(i,o,v)},p:xe,d(i){i&&n(o)}}}function Et(S){let o,b="Example:",i,v,C;return v=new _t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTdGFyY29kZXIyRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyMFN0YXJjb2RlcjJGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRnN0YXJjb2RlcjItN2JfMTZrJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ2NvZGUlMkZzdGFyY29kZXIyLTdiXzE2ayUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Starcoder2ForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Starcoder2ForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b_16k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b_16k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){o=l("p"),o.textContent=b,i=a(),p(v.$$.fragment)},l(y){o=c(y,"P",{"data-svelte-h":!0}),_(o)!=="svelte-11lpom8"&&(o.textContent=b),i=s(y),u(v.$$.fragment,y)},m(y,x){d(y,o,x),d(y,i,x),m(v,y,x),C=!0},p:xe,i(y){C||(h(v.$$.fragment,y),C=!0)},o(y){f(v.$$.fragment,y),C=!1},d(y){y&&(n(o),n(i)),g(v,y)}}}function At(S){let o,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=l("p"),o.innerHTML=b},l(i){o=c(i,"P",{"data-svelte-h":!0}),_(o)!=="svelte-fincs2"&&(o.innerHTML=b)},m(i,v){d(i,o,v)},p:xe,d(i){i&&n(o)}}}function Vt(S){let o,b,i,v,C,y,x,Le,X,bt='StarCoder2 is a family of open LLMs for code and comes in 3 different sizes with 3B, 7B and 15B parameters. The flagship StarCoder2-15B model is trained on over 4 trillion tokens and 600+ programming languages from The Stack v2. All models use Grouped Query Attention, a context window of 16,384 tokens with a sliding window attention of 4,096 tokens, and were trained using the Fill-in-the-Middle objective. The models have been released with the paper <a href="https://arxiv.org/abs/2402.19173" rel="nofollow">StarCoder 2 and The Stack v2: The Next Generation</a> by Anton Lozhkov, Raymond Li, Loubna Ben Allal, Federico Cassano, Joel Lamy-Poirier, Nouamane Tazi, Ao Tang, Dmytro Pykhtar, Jiawei Liu, Yuxiang Wei, Tianyang Liu, Max Tian, Denis Kocetkov, Arthur Zucker, Younes Belkada, Zijian Wang, Qian Liu, Dmitry Abulkhanov, Indraneil Paul, Zhuang Li, Wen-Ding Li, Megan Risdal, Jia Li, Jian Zhu, Terry Yue Zhuo, Evgenii Zheltonozhskii, Nii Osae Osae Dade, Wenhao Yu, Lucas Krauß, Naman Jain, Yixuan Su, Xuanli He, Manan Dey, Edoardo Abati, Yekun Chai, Niklas Muennighoff, Xiangru Tang, Muhtasham Oblokulov, Christopher Akiki, Marc Marone, Chenghao Mou, Mayank Mishra, Alex Gu, Binyuan Hui, Tri Dao, Armel Zebaze, Olivier Dehaene, Nicolas Patry, Canwen Xu, Julian McAuley, Han Hu, Torsten Scholak, Sebastien Paquet, Jennifer Robinson, Carolyn Jane Anderson, Nicolas Chapados, Mostofa Patwary, Nima Tajbakhsh, Yacine Jernite, Carlos Muñoz Ferrandis, Lingming Zhang, Sean Hughes, Thomas Wolf, Arjun Guha, Leandro von Werra, and Harm de Vries.',je,E,vt="The abstract of the paper is the following:",Fe,P,me,yt="The BigCode project, an open-scientific collaboration focused on the responsible development of Large Language Models for Code (Code LLMs), introduces StarCoder2. In partnership with Software Heritage (SWH), we build The Stack v2 on top of the digital commons of their source code archive. Alongside the SWH repositories spanning 619 programming languages, we carefully select other high-quality data sources, such as GitHub pull requests, Kaggle notebooks, and code documentation. This results in a training set that is 4x larger than the first StarCoder dataset. We train StarCoder2 models with 3B, 7B, and 15B parameters on 3.3 to 4.3 trillion tokens and thoroughly evaluate them on a comprehensive set of Code LLM benchmarks. We find that our small model, StarCoder2-3B, outperforms other Code LLMs of similar size on most benchmarks, and also outperforms StarCoderBase-15B. Our large model, StarCoder2- 15B, significantly outperforms other models of comparable size. In addition, it matches or outperforms CodeLlama-34B, a model more than twice its size. Although DeepSeekCoder- 33B is the best-performing model at code completion for high-resource languages, we find that StarCoder2-15B outperforms it on math and code reasoning benchmarks, as well as several low-resource languages. We make the model weights available under an OpenRAIL license and ensure full transparency regarding the training data by releasing the SoftWare Heritage persistent IDentifiers (SWHIDs) of the source code data.",Ve,A,Ie,V,kt='The models are licensed under the <a href="https://huggingface.co/spaces/bigcode/bigcode-model-license-agreement" rel="nofollow">BigCode OpenRAIL-M v1 license agreement</a>.',Ue,O,qe,Y,Tt='The StarCoder2 models can be found in the <a href="https://huggingface.co/collections/bigcode/starcoder2-65de6da6e87db3383572be1a" rel="nofollow">HuggingFace hub</a>. You can find some examples for inference and fine-tuning in StarCoder2’s <a href="https://github.com/bigcode-project/starcoder2" rel="nofollow">GitHub repo</a>.',Je,D,wt="These ready-to-use checkpoints can be downloaded and used via the HuggingFace Hub:",Pe,Q,We,K,Ze,M,ee,Oe,he,Mt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.39.3/en/model_doc/starcoder2#transformers.Starcoder2Model">Starcoder2Model</a>. It is used to instantiate a
Starcoder2 model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/bigcode/starcoder2-7b_16k" rel="nofollow">bigcode/starcoder2-7b_16k</a> model.`,Ye,fe,$t=`Configuration objects inherit from <a href="/docs/transformers/v4.39.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.39.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,De,W,He,te,Ne,T,oe,Qe,ge,St=`The bare Starcoder2 Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/v4.39.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ke,_e,Ct=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,et,be,zt="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>Starcoder2DecoderLayer</code>",tt,j,ne,ot,ve,xt='The <a href="/docs/transformers/v4.39.3/en/model_doc/starcoder2#transformers.Starcoder2Model">Starcoder2Model</a> forward method, overrides the <code>__call__</code> special method.',nt,Z,Be,ae,Re,U,se,at,z,re,st,ye,Lt='The <a href="/docs/transformers/v4.39.3/en/model_doc/starcoder2#transformers.Starcoder2ForCausalLM">Starcoder2ForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',rt,H,it,N,Ge,ie,Xe,k,de,dt,ke,jt="The Starcoder2 Model transformer with a sequence classification head on top (linear layer).",lt,Te,Ft=`<a href="/docs/transformers/v4.39.3/en/model_doc/starcoder2#transformers.Starcoder2ForSequenceClassification">Starcoder2ForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,ct,we,It=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,pt,Me,Ut=`This model inherits from <a href="/docs/transformers/v4.39.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ut,$e,qt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,mt,F,le,ht,Se,Jt='The <a href="/docs/transformers/v4.39.3/en/model_doc/starcoder2#transformers.Starcoder2ForSequenceClassification">Starcoder2ForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',ft,B,Ee,ze,Ae;return C=new G({props:{title:"Starcoder2",local:"starcoder2",headingTag:"h1"}}),x=new G({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new G({props:{title:"License",local:"license",headingTag:"h2"}}),O=new G({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),Q=new _t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ2NvZGUlMkZzdGFyY29kZXIyLTdiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRnN0YXJjb2RlcjItN2IlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZGVmJTIwcHJpbnRfaGVsbG9fd29ybGQoKSUzQSUyMiUwQSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUJwcm9tcHQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQW1vZGVsLnRvKGRldmljZSklMEElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;def print_hello_world():&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([prompt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">10</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;def print_hello_world():\\n\\treturn &#x27;Hello World!&#x27;&quot;</span>`,wrap:!1}}),K=new G({props:{title:"Starcoder2Config",local:"transformers.Starcoder2Config",headingTag:"h2"}}),ee=new ue({props:{name:"class transformers.Starcoder2Config",anchor:"transformers.Starcoder2Config",parameters:[{name:"vocab_size",val:" = 49152"},{name:"hidden_size",val:" = 3072"},{name:"intermediate_size",val:" = 12288"},{name:"num_hidden_layers",val:" = 30"},{name:"num_attention_heads",val:" = 24"},{name:"num_key_value_heads",val:" = 2"},{name:"hidden_act",val:" = 'gelu_pytorch_tanh'"},{name:"max_position_embeddings",val:" = 4096"},{name:"initializer_range",val:" = 0.018042"},{name:"norm_epsilon",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"bos_token_id",val:" = 50256"},{name:"eos_token_id",val:" = 50256"},{name:"rope_theta",val:" = 10000.0"},{name:"sliding_window",val:" = None"},{name:"attention_dropout",val:" = 0.0"},{name:"residual_dropout",val:" = 0.0"},{name:"embedding_dropout",val:" = 0.0"},{name:"use_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Starcoder2Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 49152) &#x2014;
Vocabulary size of the Starcoder2 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.39.3/en/model_doc/starcoder2#transformers.Starcoder2Model">Starcoder2Model</a>`,name:"vocab_size"},{anchor:"transformers.Starcoder2Config.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.Starcoder2Config.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 12288) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.Starcoder2Config.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 30) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Starcoder2Config.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Starcoder2Config.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details checkout [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>8\`.`,name:"num_key_value_heads"},{anchor:"transformers.Starcoder2Config.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu_pytorch_tanh&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.Starcoder2Config.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model might ever be used with. Starcoder2&#x2019;s sliding window attention
allows sequence of up to 4096*32 tokens.`,name:"max_position_embeddings"},{anchor:"transformers.Starcoder2Config.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Starcoder2Config.norm_epsilon",description:`<strong>norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
Epsilon value for the layer norm`,name:"norm_epsilon"},{anchor:"transformers.Starcoder2Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.Starcoder2Config.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 50256) &#x2014;
The id of the &#x201C;beginning-of-sequence&#x201D; token.`,name:"bos_token_id"},{anchor:"transformers.Starcoder2Config.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 50256) &#x2014;
The id of the &#x201C;end-of-sequence&#x201D; token.`,name:"eos_token_id"},{anchor:"transformers.Starcoder2Config.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.Starcoder2Config.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Sliding window attention window size. If not specified, will default to <code>None</code> (no sliding window).`,name:"sliding_window"},{anchor:"transformers.Starcoder2Config.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Starcoder2Config.residual_dropout",description:`<strong>residual_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Residual connection dropout value.`,name:"residual_dropout"},{anchor:"transformers.Starcoder2Config.embedding_dropout",description:`<strong>embedding_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Embedding dropout.`,name:"embedding_dropout"},{anchor:"transformers.Starcoder2Config.use_bias",description:`<strong>use_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias term on linear layers of the model.`,name:"use_bias"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/starcoder2/configuration_starcoder2.py#L26"}}),W=new Pt({props:{anchor:"transformers.Starcoder2Config.example",$$slots:{default:[Rt]},$$scope:{ctx:S}}}),te=new G({props:{title:"Starcoder2Model",local:"transformers.Starcoder2Model",headingTag:"h2"}}),oe=new ue({props:{name:"class transformers.Starcoder2Model",anchor:"transformers.Starcoder2Model",parameters:[{name:"config",val:": Starcoder2Config"}],parametersDescription:[{anchor:"transformers.Starcoder2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.3/en/model_doc/starcoder2#transformers.Starcoder2Config">Starcoder2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.39.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; Starcoder2Config`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/starcoder2/modeling_starcoder2.py#L886"}}),ne=new ue({props:{name:"forward",anchor:"transformers.Starcoder2Model.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Starcoder2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Starcoder2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Starcoder2Model.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Starcoder2Model.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/v4.39.3/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Starcoder2Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Starcoder2Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Starcoder2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Starcoder2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Starcoder2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.39.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/starcoder2/modeling_starcoder2.py#L920"}}),Z=new gt({props:{$$slots:{default:[Gt]},$$scope:{ctx:S}}}),ae=new G({props:{title:"Starcoder2ForCausalLM",local:"transformers.Starcoder2ForCausalLM",headingTag:"h2"}}),se=new ue({props:{name:"class transformers.Starcoder2ForCausalLM",anchor:"transformers.Starcoder2ForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/starcoder2/modeling_starcoder2.py#L1070"}}),re=new ue({props:{name:"forward",anchor:"transformers.Starcoder2ForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Starcoder2ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Starcoder2ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Starcoder2ForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Starcoder2ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/v4.39.3/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Starcoder2ForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Starcoder2ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Starcoder2ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Starcoder2ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Starcoder2ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.39.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/starcoder2/modeling_starcoder2.py#L1100",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.39.3/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.39.3/en/model_doc/starcoder2#transformers.Starcoder2Config"
>Starcoder2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.39.3/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),H=new gt({props:{$$slots:{default:[Xt]},$$scope:{ctx:S}}}),N=new Pt({props:{anchor:"transformers.Starcoder2ForCausalLM.forward.example",$$slots:{default:[Et]},$$scope:{ctx:S}}}),ie=new G({props:{title:"Starcoder2ForSequenceClassification",local:"transformers.Starcoder2ForSequenceClassification",headingTag:"h2"}}),de=new ue({props:{name:"class transformers.Starcoder2ForSequenceClassification",anchor:"transformers.Starcoder2ForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Starcoder2ForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.39.3/en/model_doc/starcoder2#transformers.Starcoder2Config">Starcoder2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.39.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/starcoder2/modeling_starcoder2.py#L1256"}}),le=new ue({props:{name:"forward",anchor:"transformers.Starcoder2ForSequenceClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Starcoder2ForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.39.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.39.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/v4.39.3/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.39.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.39.3/src/transformers/models/starcoder2/modeling_starcoder2.py#L1288"}}),B=new gt({props:{$$slots:{default:[At]},$$scope:{ctx:S}}}),{c(){o=l("meta"),b=a(),i=l("p"),v=a(),p(C.$$.fragment),y=a(),p(x.$$.fragment),Le=a(),X=l("p"),X.innerHTML=bt,je=a(),E=l("p"),E.textContent=vt,Fe=a(),P=l("blockquote"),me=l("p"),me.textContent=yt,Ve=a(),p(A.$$.fragment),Ie=a(),V=l("p"),V.innerHTML=kt,Ue=a(),p(O.$$.fragment),qe=a(),Y=l("p"),Y.innerHTML=Tt,Je=a(),D=l("p"),D.textContent=wt,Pe=a(),p(Q.$$.fragment),We=a(),p(K.$$.fragment),Ze=a(),M=l("div"),p(ee.$$.fragment),Oe=a(),he=l("p"),he.innerHTML=Mt,Ye=a(),fe=l("p"),fe.innerHTML=$t,De=a(),p(W.$$.fragment),He=a(),p(te.$$.fragment),Ne=a(),T=l("div"),p(oe.$$.fragment),Qe=a(),ge=l("p"),ge.innerHTML=St,Ke=a(),_e=l("p"),_e.innerHTML=Ct,et=a(),be=l("p"),be.innerHTML=zt,tt=a(),j=l("div"),p(ne.$$.fragment),ot=a(),ve=l("p"),ve.innerHTML=xt,nt=a(),p(Z.$$.fragment),Be=a(),p(ae.$$.fragment),Re=a(),U=l("div"),p(se.$$.fragment),at=a(),z=l("div"),p(re.$$.fragment),st=a(),ye=l("p"),ye.innerHTML=Lt,rt=a(),p(H.$$.fragment),it=a(),p(N.$$.fragment),Ge=a(),p(ie.$$.fragment),Xe=a(),k=l("div"),p(de.$$.fragment),dt=a(),ke=l("p"),ke.textContent=jt,lt=a(),Te=l("p"),Te.innerHTML=Ft,ct=a(),we=l("p"),we.innerHTML=It,pt=a(),Me=l("p"),Me.innerHTML=Ut,ut=a(),$e=l("p"),$e.innerHTML=qt,mt=a(),F=l("div"),p(le.$$.fragment),ht=a(),Se=l("p"),Se.innerHTML=Jt,ft=a(),p(B.$$.fragment),Ee=a(),ze=l("p"),this.h()},l(e){const t=Bt("svelte-u9bgzb",document.head);o=c(t,"META",{name:!0,content:!0}),t.forEach(n),b=s(e),i=c(e,"P",{}),I(i).forEach(n),v=s(e),u(C.$$.fragment,e),y=s(e),u(x.$$.fragment,e),Le=s(e),X=c(e,"P",{"data-svelte-h":!0}),_(X)!=="svelte-1n8n0dk"&&(X.innerHTML=bt),je=s(e),E=c(e,"P",{"data-svelte-h":!0}),_(E)!=="svelte-wu27l3"&&(E.textContent=vt),Fe=s(e),P=c(e,"BLOCKQUOTE",{});var ce=I(P);me=c(ce,"P",{"data-svelte-h":!0}),_(me)!=="svelte-1cdgnq1"&&(me.textContent=yt),Ve=s(ce),u(A.$$.fragment,ce),ce.forEach(n),Ie=s(e),V=c(e,"P",{"data-svelte-h":!0}),_(V)!=="svelte-1289i3b"&&(V.innerHTML=kt),Ue=s(e),u(O.$$.fragment,e),qe=s(e),Y=c(e,"P",{"data-svelte-h":!0}),_(Y)!=="svelte-1gol27n"&&(Y.innerHTML=Tt),Je=s(e),D=c(e,"P",{"data-svelte-h":!0}),_(D)!=="svelte-a5tlwb"&&(D.textContent=wt),Pe=s(e),u(Q.$$.fragment,e),We=s(e),u(K.$$.fragment,e),Ze=s(e),M=c(e,"DIV",{class:!0});var L=I(M);u(ee.$$.fragment,L),Oe=s(L),he=c(L,"P",{"data-svelte-h":!0}),_(he)!=="svelte-szj2k3"&&(he.innerHTML=Mt),Ye=s(L),fe=c(L,"P",{"data-svelte-h":!0}),_(fe)!=="svelte-fgm5f9"&&(fe.innerHTML=$t),De=s(L),u(W.$$.fragment,L),L.forEach(n),He=s(e),u(te.$$.fragment,e),Ne=s(e),T=c(e,"DIV",{class:!0});var $=I(T);u(oe.$$.fragment,$),Qe=s($),ge=c($,"P",{"data-svelte-h":!0}),_(ge)!=="svelte-m56hbh"&&(ge.innerHTML=St),Ke=s($),_e=c($,"P",{"data-svelte-h":!0}),_(_e)!=="svelte-hswkmf"&&(_e.innerHTML=Ct),et=s($),be=c($,"P",{"data-svelte-h":!0}),_(be)!=="svelte-1inq57c"&&(be.innerHTML=zt),tt=s($),j=c($,"DIV",{class:!0});var q=I(j);u(ne.$$.fragment,q),ot=s(q),ve=c(q,"P",{"data-svelte-h":!0}),_(ve)!=="svelte-1i7lowy"&&(ve.innerHTML=xt),nt=s(q),u(Z.$$.fragment,q),q.forEach(n),$.forEach(n),Be=s(e),u(ae.$$.fragment,e),Re=s(e),U=c(e,"DIV",{class:!0});var pe=I(U);u(se.$$.fragment,pe),at=s(pe),z=c(pe,"DIV",{class:!0});var R=I(z);u(re.$$.fragment,R),st=s(R),ye=c(R,"P",{"data-svelte-h":!0}),_(ye)!=="svelte-1kbc6vm"&&(ye.innerHTML=Lt),rt=s(R),u(H.$$.fragment,R),it=s(R),u(N.$$.fragment,R),R.forEach(n),pe.forEach(n),Ge=s(e),u(ie.$$.fragment,e),Xe=s(e),k=c(e,"DIV",{class:!0});var w=I(k);u(de.$$.fragment,w),dt=s(w),ke=c(w,"P",{"data-svelte-h":!0}),_(ke)!=="svelte-pjsk7t"&&(ke.textContent=jt),lt=s(w),Te=c(w,"P",{"data-svelte-h":!0}),_(Te)!=="svelte-n92it7"&&(Te.innerHTML=Ft),ct=s(w),we=c(w,"P",{"data-svelte-h":!0}),_(we)!=="svelte-10ugs3m"&&(we.innerHTML=It),pt=s(w),Me=c(w,"P",{"data-svelte-h":!0}),_(Me)!=="svelte-8in0zq"&&(Me.innerHTML=Ut),ut=s(w),$e=c(w,"P",{"data-svelte-h":!0}),_($e)!=="svelte-hswkmf"&&($e.innerHTML=qt),mt=s(w),F=c(w,"DIV",{class:!0});var Ce=I(F);u(le.$$.fragment,Ce),ht=s(Ce),Se=c(Ce,"P",{"data-svelte-h":!0}),_(Se)!=="svelte-1pc6cp2"&&(Se.innerHTML=Jt),ft=s(Ce),u(B.$$.fragment,Ce),Ce.forEach(n),w.forEach(n),Ee=s(e),ze=c(e,"P",{}),I(ze).forEach(n),this.h()},h(){J(o,"name","hf:doc:metadata"),J(o,"content",Ot),J(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,o),d(e,b,t),d(e,i,t),d(e,v,t),m(C,e,t),d(e,y,t),m(x,e,t),d(e,Le,t),d(e,X,t),d(e,je,t),d(e,E,t),d(e,Fe,t),d(e,P,t),r(P,me),r(P,Ve),m(A,P,null),d(e,Ie,t),d(e,V,t),d(e,Ue,t),m(O,e,t),d(e,qe,t),d(e,Y,t),d(e,Je,t),d(e,D,t),d(e,Pe,t),m(Q,e,t),d(e,We,t),m(K,e,t),d(e,Ze,t),d(e,M,t),m(ee,M,null),r(M,Oe),r(M,he),r(M,Ye),r(M,fe),r(M,De),m(W,M,null),d(e,He,t),m(te,e,t),d(e,Ne,t),d(e,T,t),m(oe,T,null),r(T,Qe),r(T,ge),r(T,Ke),r(T,_e),r(T,et),r(T,be),r(T,tt),r(T,j),m(ne,j,null),r(j,ot),r(j,ve),r(j,nt),m(Z,j,null),d(e,Be,t),m(ae,e,t),d(e,Re,t),d(e,U,t),m(se,U,null),r(U,at),r(U,z),m(re,z,null),r(z,st),r(z,ye),r(z,rt),m(H,z,null),r(z,it),m(N,z,null),d(e,Ge,t),m(ie,e,t),d(e,Xe,t),d(e,k,t),m(de,k,null),r(k,dt),r(k,ke),r(k,lt),r(k,Te),r(k,ct),r(k,we),r(k,pt),r(k,Me),r(k,ut),r(k,$e),r(k,mt),r(k,F),m(le,F,null),r(F,ht),r(F,Se),r(F,ft),m(B,F,null),d(e,Ee,t),d(e,ze,t),Ae=!0},p(e,[t]){const ce={};t&2&&(ce.$$scope={dirty:t,ctx:e}),W.$set(ce);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),Z.$set(L);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),H.$set($);const q={};t&2&&(q.$$scope={dirty:t,ctx:e}),N.$set(q);const pe={};t&2&&(pe.$$scope={dirty:t,ctx:e}),B.$set(pe)},i(e){Ae||(h(C.$$.fragment,e),h(x.$$.fragment,e),h(A.$$.fragment,e),h(O.$$.fragment,e),h(Q.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(W.$$.fragment,e),h(te.$$.fragment,e),h(oe.$$.fragment,e),h(ne.$$.fragment,e),h(Z.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(H.$$.fragment,e),h(N.$$.fragment,e),h(ie.$$.fragment,e),h(de.$$.fragment,e),h(le.$$.fragment,e),h(B.$$.fragment,e),Ae=!0)},o(e){f(C.$$.fragment,e),f(x.$$.fragment,e),f(A.$$.fragment,e),f(O.$$.fragment,e),f(Q.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(W.$$.fragment,e),f(te.$$.fragment,e),f(oe.$$.fragment,e),f(ne.$$.fragment,e),f(Z.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),f(re.$$.fragment,e),f(H.$$.fragment,e),f(N.$$.fragment,e),f(ie.$$.fragment,e),f(de.$$.fragment,e),f(le.$$.fragment,e),f(B.$$.fragment,e),Ae=!1},d(e){e&&(n(b),n(i),n(v),n(y),n(Le),n(X),n(je),n(E),n(Fe),n(P),n(Ie),n(V),n(Ue),n(qe),n(Y),n(Je),n(D),n(Pe),n(We),n(Ze),n(M),n(He),n(Ne),n(T),n(Be),n(Re),n(U),n(Ge),n(Xe),n(k),n(Ee),n(ze)),n(o),g(C,e),g(x,e),g(A),g(O,e),g(Q,e),g(K,e),g(ee),g(W),g(te,e),g(oe),g(ne),g(Z),g(ae,e),g(se),g(re),g(H),g(N),g(ie,e),g(de),g(le),g(B)}}}const Ot='{"title":"Starcoder2","local":"starcoder2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"License","local":"license","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Starcoder2Config","local":"transformers.Starcoder2Config","sections":[],"depth":2},{"title":"Starcoder2Model","local":"transformers.Starcoder2Model","sections":[],"depth":2},{"title":"Starcoder2ForCausalLM","local":"transformers.Starcoder2ForCausalLM","sections":[],"depth":2},{"title":"Starcoder2ForSequenceClassification","local":"transformers.Starcoder2ForSequenceClassification","sections":[],"depth":2}],"depth":1}';function Yt(S){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ao extends Ht{constructor(o){super(),Nt(this,o,Yt,Vt,Wt,{})}}export{ao as component};
