import{s as Re,o as We,n as Oe}from"../chunks/scheduler.182ea377.js";import{S as Ye,i as Xe,g as r,s as i,r as _,A as Qe,h as l,f as n,c as s,j as O,u as b,x as m,k as R,y as d,a as o,v,d as M,t as y,w}from"../chunks/index.abf12888.js";import{T as Ke}from"../chunks/Tip.230e2334.js";import{D as oe}from"../chunks/Docstring.93f6f462.js";import{C as et}from"../chunks/CodeBlock.57fe6e13.js";import{E as tt}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as we}from"../chunks/Heading.16916d63.js";function nt(W){let a,x='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){a=r("p"),a.innerHTML=x},l(u){a=l(u,"P",{"data-svelte-h":!0}),m(a)!=="svelte-1wmc0l4"&&(a.innerHTML=x)},m(u,h){o(u,a,h)},p:Oe,d(u){u&&n(a)}}}function ot(W){let a,x="Examples:",u,h,g;return h=new et({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1ZGlvTERNUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMHNjaXB5JTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmN2c3NwJTJGYXVkaW9sZG0tcy1mdWxsLXYyJTIyJTBBcGlwZSUyMCUzRCUyMEF1ZGlvTERNUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJUZWNobm8lMjBtdXNpYyUyMHdpdGglMjBhJTIwc3Ryb25nJTJDJTIwdXBiZWF0JTIwdGVtcG8lMjBhbmQlMjBoaWdoJTIwbWVsb2RpYyUyMHJpZmZzJTIyJTBBYXVkaW8lMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxMCUyQyUyMGF1ZGlvX2xlbmd0aF9pbl9zJTNENS4wKS5hdWRpb3MlNUIwJTVEJTBBJTBBJTIzJTIwc2F2ZSUyMHRoZSUyMGF1ZGlvJTIwc2FtcGxlJTIwYXMlMjBhJTIwLndhdiUyMGZpbGUlMEFzY2lweS5pby53YXZmaWxlLndyaXRlKCUyMnRlY2huby53YXYlMjIlMkMlMjByYXRlJTNEMTYwMDAlMkMlMjBkYXRhJTNEYXVkaW8p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AudioLDMPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;cvssp/audioldm-s-full-v2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AudioLDMPipeline.from_pretrained(repo_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Techno music with a strong, upbeat tempo and high melodic riffs&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = pipe(prompt, num_inference_steps=<span class="hljs-number">10</span>, audio_length_in_s=<span class="hljs-number">5.0</span>).audios[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save the audio sample as a .wav file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;techno.wav&quot;</span>, rate=<span class="hljs-number">16000</span>, data=audio)`,wrap:!1}}),{c(){a=r("p"),a.textContent=x,u=i(),_(h.$$.fragment)},l(p){a=l(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-kvfsh7"&&(a.textContent=x),u=s(p),b(h.$$.fragment,p)},m(p,T){o(p,a,T),o(p,u,T),v(h,p,T),g=!0},p:Oe,i(p){g||(M(h.$$.fragment,p),g=!0)},o(p){y(h.$$.fragment,p),g=!1},d(p){p&&(n(a),n(u)),w(h,p)}}}function it(W){let a,x,u,h,g,p,T,Ue=`AudioLDM was proposed in <a href="https://huggingface.co/papers/2301.12503" rel="nofollow">AudioLDM: Text-to-Audio Generation with Latent Diffusion Models</a> by Haohe Liu et al. Inspired by <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview" rel="nofollow">Stable Diffusion</a>, AudioLDM
is a text-to-audio <em>latent diffusion model (LDM)</em> that learns continuous audio representations from <a href="https://huggingface.co/docs/transformers/main/model_doc/clap" rel="nofollow">CLAP</a>
latents. AudioLDM takes a text prompt as input and predicts the corresponding audio. It can generate text-conditional
sound effects, human speech and music.`,ie,j,Ge="The abstract from the paper is:",se,U,Ie='<em>Text-to-audio (TTA) system has recently gained attention for its ability to synthesize general audio based on text descriptions. However, previous studies in TTA have limited generation quality with high computational costs. In this study, we propose AudioLDM, a TTA system that is built on a latent space to learn the continuous audio representations from contrastive language-audio pretraining (CLAP) latents. The pretrained CLAP models enable us to train LDMs with audio embedding while providing text embedding as a condition during sampling. By learning the latent representations of audio signals and their compositions without modeling the cross-modal relationship, AudioLDM is advantageous in both generation quality and computational efficiency. Trained on AudioCaps with a single GPU, AudioLDM achieves state-of-the-art TTA performance measured by both objective and subjective metrics (e.g., frechet distance). Moreover, AudioLDM is the first TTA system that enables various text-guided audio manipulations (e.g., style transfer) in a zero-shot fashion. Our implementation and demos are available at <a href="https://audioldm.github.io/" rel="nofollow">this https URL</a>.</em>',ae,G,He='The original codebase can be found at <a href="https://github.com/haoheliu/AudioLDM" rel="nofollow">haoheliu/AudioLDM</a>.',re,I,le,H,Ne="When constructing a prompt, keep in mind:",de,N,Be="<li>Descriptive prompt inputs work best; you can use adjectives to describe the sound (for example, “high quality” or “clear”) and make the prompt context specific (for example, “water stream in a forest” instead of “stream”).</li> <li>It’s best to use general terms like “cat” or “dog” instead of specific names or abstract objects the model may not be familiar with.</li>",pe,B,Je="During inference:",ce,J,Se="<li>The <em>quality</em> of the predicted audio sample can be controlled by the <code>num_inference_steps</code> argument; higher steps give higher quality audio at the expense of slower inference.</li> <li>The <em>length</em> of the predicted audio sample can be controlled by varying the <code>audio_length_in_s</code> argument.</li>",ue,D,me,S,fe,c,E,Te,Y,Ee="Pipeline for text-to-audio generation using AudioLDM.",xe,X,ze=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,$e,$,z,Le,Q,Ve="The call function to the pipeline for generation.",Ae,P,De,C,V,Pe,K,qe=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ce,k,q,ke,ee,Ze=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,he,Z,ge,L,F,je,te,Fe="Output class for audio pipelines.",_e,ne,be;return g=new we({props:{title:"AudioLDM",local:"audioldm",headingTag:"h1"}}),I=new we({props:{title:"Tips",local:"tips",headingTag:"h2"}}),D=new Ke({props:{$$slots:{default:[nt]},$$scope:{ctx:W}}}),S=new we({props:{title:"AudioLDMPipeline",local:"diffusers.AudioLDMPipeline",headingTag:"h2"}}),E=new oe({props:{name:"class diffusers.AudioLDMPipeline",anchor:"diffusers.AudioLDMPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": ClapTextModelWithProjection"},{name:"tokenizer",val:": typing.Union[transformers.models.roberta.tokenization_roberta.RobertaTokenizer, transformers.models.roberta.tokenization_roberta_fast.RobertaTokenizerFast]"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vocoder",val:": SpeechT5HifiGan"}],parametersDescription:[{anchor:"diffusers.AudioLDMPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AudioLDMPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap#transformers.ClapTextModelWithProjection" rel="nofollow">ClapTextModelWithProjection</a>) &#x2014;
Frozen text-encoder (<code>ClapTextModelWithProjection</code>, specifically the
<a href="https://huggingface.co/laion/clap-htsat-unfused" rel="nofollow">laion/clap-htsat-unfused</a> variant.`,name:"text_encoder"},{anchor:"diffusers.AudioLDMPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer" rel="nofollow">RobertaTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AudioLDMPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded audio latents.`,name:"unet"},{anchor:"diffusers.AudioLDMPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded audio latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.AudioLDMPipeline.vocoder",description:`<strong>vocoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5HifiGan" rel="nofollow">SpeechT5HifiGan</a>) &#x2014;
Vocoder of class <code>SpeechT5HifiGan</code>.`,name:"vocoder"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm/pipeline_audioldm.py#L52"}}),z=new oe({props:{name:"__call__",anchor:"diffusers.AudioLDMPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"audio_length_in_s",val:": typing.Optional[float] = None"},{name:"num_inference_steps",val:": int = 10"},{name:"guidance_scale",val:": float = 2.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_waveforms_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": typing.Optional[int] = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"}],parametersDescription:[{anchor:"diffusers.AudioLDMPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide audio generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AudioLDMPipeline.__call__.audio_length_in_s",description:`<strong>audio_length_in_s</strong> (<code>int</code>, <em>optional</em>, defaults to 5.12) &#x2014;
The length of the generated audio sample in seconds.`,name:"audio_length_in_s"},{anchor:"diffusers.AudioLDMPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality audio at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AudioLDMPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
A higher guidance scale value encourages the model to generate audio that is closely linked to the text
<code>prompt</code> at the expense of lower sound quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AudioLDMPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in audio generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AudioLDMPipeline.__call__.num_waveforms_per_prompt",description:`<strong>num_waveforms_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of waveforms to generate per prompt.`,name:"num_waveforms_per_prompt"},{anchor:"diffusers.AudioLDMPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AudioLDMPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AudioLDMPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.AudioLDMPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AudioLDMPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AudioLDMPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/dance_diffusion#diffusers.AudioPipelineOutput">AudioPipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AudioLDMPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.AudioLDMPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.AudioLDMPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AudioLDMPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>&quot;np&quot;</code> to return a NumPy <code>np.ndarray</code> or
<code>&quot;pt&quot;</code> to return a PyTorch <code>torch.Tensor</code> object.`,name:"output_type"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm/pipeline_audioldm.py#L367",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/dance_diffusion#diffusers.AudioPipelineOutput"
>AudioPipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/dance_diffusion#diffusers.AudioPipelineOutput"
>AudioPipelineOutput</a> or <code>tuple</code></p>
`}}),P=new tt({props:{anchor:"diffusers.AudioLDMPipeline.__call__.example",$$slots:{default:[ot]},$$scope:{ctx:W}}}),V=new oe({props:{name:"disable_vae_slicing",anchor:"diffusers.AudioLDMPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm/pipeline_audioldm.py#L108"}}),q=new oe({props:{name:"enable_vae_slicing",anchor:"diffusers.AudioLDMPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm/pipeline_audioldm.py#L100"}}),Z=new we({props:{title:"AudioPipelineOutput",local:"diffusers.AudioPipelineOutput",headingTag:"h2"}}),F=new oe({props:{name:"class diffusers.AudioPipelineOutput",anchor:"diffusers.AudioPipelineOutput",parameters:[{name:"audios",val:": ndarray"}],parametersDescription:[{anchor:"diffusers.AudioPipelineOutput.audios",description:`<strong>audios</strong> (<code>np.ndarray</code>) &#x2014;
List of denoised audio samples of a NumPy array of shape <code>(batch_size, num_channels, sample_rate)</code>.`,name:"audios"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L130"}}),{c(){a=r("meta"),x=i(),u=r("p"),h=i(),_(g.$$.fragment),p=i(),T=r("p"),T.innerHTML=Ue,ie=i(),j=r("p"),j.textContent=Ge,se=i(),U=r("p"),U.innerHTML=Ie,ae=i(),G=r("p"),G.innerHTML=He,re=i(),_(I.$$.fragment),le=i(),H=r("p"),H.textContent=Ne,de=i(),N=r("ul"),N.innerHTML=Be,pe=i(),B=r("p"),B.textContent=Je,ce=i(),J=r("ul"),J.innerHTML=Se,ue=i(),_(D.$$.fragment),me=i(),_(S.$$.fragment),fe=i(),c=r("div"),_(E.$$.fragment),Te=i(),Y=r("p"),Y.textContent=Ee,xe=i(),X=r("p"),X.innerHTML=ze,$e=i(),$=r("div"),_(z.$$.fragment),Le=i(),Q=r("p"),Q.textContent=Ve,Ae=i(),_(P.$$.fragment),De=i(),C=r("div"),_(V.$$.fragment),Pe=i(),K=r("p"),K.innerHTML=qe,Ce=i(),k=r("div"),_(q.$$.fragment),ke=i(),ee=r("p"),ee.textContent=Ze,he=i(),_(Z.$$.fragment),ge=i(),L=r("div"),_(F.$$.fragment),je=i(),te=r("p"),te.textContent=Fe,_e=i(),ne=r("p"),this.h()},l(e){const t=Qe("svelte-u9bgzb",document.head);a=l(t,"META",{name:!0,content:!0}),t.forEach(n),x=s(e),u=l(e,"P",{}),O(u).forEach(n),h=s(e),b(g.$$.fragment,e),p=s(e),T=l(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-1ozr8g7"&&(T.innerHTML=Ue),ie=s(e),j=l(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1cwsb16"&&(j.textContent=Ge),se=s(e),U=l(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-64lmgc"&&(U.innerHTML=Ie),ae=s(e),G=l(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n8fwj9"&&(G.innerHTML=He),re=s(e),b(I.$$.fragment,e),le=s(e),H=l(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1dvtu0c"&&(H.textContent=Ne),de=s(e),N=l(e,"UL",{"data-svelte-h":!0}),m(N)!=="svelte-msgw5q"&&(N.innerHTML=Be),pe=s(e),B=l(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1g0t9wk"&&(B.textContent=Je),ce=s(e),J=l(e,"UL",{"data-svelte-h":!0}),m(J)!=="svelte-jm9a2k"&&(J.innerHTML=Se),ue=s(e),b(D.$$.fragment,e),me=s(e),b(S.$$.fragment,e),fe=s(e),c=l(e,"DIV",{class:!0});var f=O(c);b(E.$$.fragment,f),Te=s(f),Y=l(f,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1vrcpd4"&&(Y.textContent=Ee),xe=s(f),X=l(f,"P",{"data-svelte-h":!0}),m(X)!=="svelte-496sm0"&&(X.innerHTML=ze),$e=s(f),$=l(f,"DIV",{class:!0});var A=O($);b(z.$$.fragment,A),Le=s(A),Q=l(A,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-50j04k"&&(Q.textContent=Ve),Ae=s(A),b(P.$$.fragment,A),A.forEach(n),De=s(f),C=l(f,"DIV",{class:!0});var ve=O(C);b(V.$$.fragment,ve),Pe=s(ve),K=l(ve,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1s3c06i"&&(K.innerHTML=qe),ve.forEach(n),Ce=s(f),k=l(f,"DIV",{class:!0});var Me=O(k);b(q.$$.fragment,Me),ke=s(Me),ee=l(Me,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-14bnrb6"&&(ee.textContent=Ze),Me.forEach(n),f.forEach(n),he=s(e),b(Z.$$.fragment,e),ge=s(e),L=l(e,"DIV",{class:!0});var ye=O(L);b(F.$$.fragment,ye),je=s(ye),te=l(ye,"P",{"data-svelte-h":!0}),m(te)!=="svelte-19ryw33"&&(te.textContent=Fe),ye.forEach(n),_e=s(e),ne=l(e,"P",{}),O(ne).forEach(n),this.h()},h(){R(a,"name","hf:doc:metadata"),R(a,"content",st),R($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,a),o(e,x,t),o(e,u,t),o(e,h,t),v(g,e,t),o(e,p,t),o(e,T,t),o(e,ie,t),o(e,j,t),o(e,se,t),o(e,U,t),o(e,ae,t),o(e,G,t),o(e,re,t),v(I,e,t),o(e,le,t),o(e,H,t),o(e,de,t),o(e,N,t),o(e,pe,t),o(e,B,t),o(e,ce,t),o(e,J,t),o(e,ue,t),v(D,e,t),o(e,me,t),v(S,e,t),o(e,fe,t),o(e,c,t),v(E,c,null),d(c,Te),d(c,Y),d(c,xe),d(c,X),d(c,$e),d(c,$),v(z,$,null),d($,Le),d($,Q),d($,Ae),v(P,$,null),d(c,De),d(c,C),v(V,C,null),d(C,Pe),d(C,K),d(c,Ce),d(c,k),v(q,k,null),d(k,ke),d(k,ee),o(e,he,t),v(Z,e,t),o(e,ge,t),o(e,L,t),v(F,L,null),d(L,je),d(L,te),o(e,_e,t),o(e,ne,t),be=!0},p(e,[t]){const f={};t&2&&(f.$$scope={dirty:t,ctx:e}),D.$set(f);const A={};t&2&&(A.$$scope={dirty:t,ctx:e}),P.$set(A)},i(e){be||(M(g.$$.fragment,e),M(I.$$.fragment,e),M(D.$$.fragment,e),M(S.$$.fragment,e),M(E.$$.fragment,e),M(z.$$.fragment,e),M(P.$$.fragment,e),M(V.$$.fragment,e),M(q.$$.fragment,e),M(Z.$$.fragment,e),M(F.$$.fragment,e),be=!0)},o(e){y(g.$$.fragment,e),y(I.$$.fragment,e),y(D.$$.fragment,e),y(S.$$.fragment,e),y(E.$$.fragment,e),y(z.$$.fragment,e),y(P.$$.fragment,e),y(V.$$.fragment,e),y(q.$$.fragment,e),y(Z.$$.fragment,e),y(F.$$.fragment,e),be=!1},d(e){e&&(n(x),n(u),n(h),n(p),n(T),n(ie),n(j),n(se),n(U),n(ae),n(G),n(re),n(le),n(H),n(de),n(N),n(pe),n(B),n(ce),n(J),n(ue),n(me),n(fe),n(c),n(he),n(ge),n(L),n(_e),n(ne)),n(a),w(g,e),w(I,e),w(D,e),w(S,e),w(E),w(z),w(P),w(V),w(q),w(Z,e),w(F)}}}const st='{"title":"AudioLDM","local":"audioldm","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"AudioLDMPipeline","local":"diffusers.AudioLDMPipeline","sections":[],"depth":2},{"title":"AudioPipelineOutput","local":"diffusers.AudioPipelineOutput","sections":[],"depth":2}],"depth":1}';function at(W){return We(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ft extends Ye{constructor(a){super(),Xe(this,a,at,it,Re,{})}}export{ft as component};
