import{s as bo,o as Mo,n as Et}from"../chunks/scheduler.182ea377.js";import{S as vo,i as yo,g as d,s as n,r as m,A as wo,h as r,f as o,c as i,j as x,u,x as p,k as D,y as a,a as s,v as f,d as g,t as h,w as _}from"../chunks/index.abf12888.js";import{T as To}from"../chunks/Tip.230e2334.js";import{D as L}from"../chunks/Docstring.93f6f462.js";import{C as _o}from"../chunks/CodeBlock.57fe6e13.js";import{E as ho}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as U}from"../chunks/Heading.16916d63.js";function xo(B){let c,k='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){c=d("p"),c.innerHTML=k},l(v){c=r(v,"P",{"data-svelte-h":!0}),p(c)!=="svelte-1wmc0l4"&&(c.innerHTML=k)},m(v,M){s(v,c,M)},p:Et,d(v){v&&o(c)}}}function Do(B){let c,k="Examples:",v,M,w;return M=new _o({props:{code:"aW1wb3J0JTIwc2NpcHklMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBBdWRpb0xETTJQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJjdnNzcCUyRmF1ZGlvbGRtMiUyMiUwQXBpcGUlMjAlM0QlMjBBdWRpb0xETTJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGRlZmluZSUyMHRoZSUyMHByb21wdHMlMEFwcm9tcHQlMjAlM0QlMjAlMjJUaGUlMjBzb3VuZCUyMG9mJTIwYSUyMGhhbW1lciUyMGhpdHRpbmclMjBhJTIwd29vZGVuJTIwc3VyZmFjZS4lMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJMb3clMjBxdWFsaXR5LiUyMiUwQSUwQSUyMyUyMHNldCUyMHRoZSUyMHNlZWQlMjBmb3IlMjBnZW5lcmF0b3IlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCklMEElMEElMjMlMjBydW4lMjB0aGUlMjBnZW5lcmF0aW9uJTBBYXVkaW8lMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMDAlMkMlMEElMjAlMjAlMjAlMjBhdWRpb19sZW5ndGhfaW5fcyUzRDEwLjAlMkMlMEElMjAlMjAlMjAlMjBudW1fd2F2ZWZvcm1zX3Blcl9wcm9tcHQlM0QzJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5hdWRpb3MlMEElMEElMjMlMjBzYXZlJTIwdGhlJTIwYmVzdCUyMGF1ZGlvJTIwc2FtcGxlJTIwKGluZGV4JTIwMCklMjBhcyUyMGElMjAud2F2JTIwZmlsZSUwQXNjaXB5LmlvLndhdmZpbGUud3JpdGUoJTIydGVjaG5vLndhdiUyMiUyQyUyMHJhdGUlM0QxNjAwMCUyQyUyMGRhdGElM0RhdWRpbyU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AudioLDM2Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;cvssp/audioldm2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AudioLDM2Pipeline.from_pretrained(repo_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define the prompts</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;The sound of a hammer hitting a wooden surface.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;Low quality.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set the seed for generator</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># run the generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    audio_length_in_s=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    num_waveforms_per_prompt=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>).audios

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save the best audio sample (index 0) as a .wav file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;techno.wav&quot;</span>, rate=<span class="hljs-number">16000</span>, data=audio[<span class="hljs-number">0</span>])`,wrap:!1}}),{c(){c=d("p"),c.textContent=k,v=n(),m(M.$$.fragment)},l(l){c=r(l,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=k),v=i(l),u(M.$$.fragment,l)},m(l,T){s(l,c,T),s(l,v,T),f(M,l,T),w=!0},p:Et,i(l){w||(g(M.$$.fragment,l),w=!0)},o(l){h(M.$$.fragment,l),w=!1},d(l){l&&(o(c),o(v)),_(M,l)}}}function ko(B){let c,k="Example:",v,M,w;return M=new _o({props:{code:"aW1wb3J0JTIwc2NpcHklMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBBdWRpb0xETTJQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJjdnNzcCUyRmF1ZGlvbGRtMiUyMiUwQXBpcGUlMjAlM0QlMjBBdWRpb0xETTJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMEdldCUyMHRleHQlMjBlbWJlZGRpbmclMjB2ZWN0b3JzJTBBcHJvbXB0X2VtYmVkcyUyQyUyMGF0dGVudGlvbl9tYXNrJTJDJTIwZ2VuZXJhdGVkX3Byb21wdF9lbWJlZHMlMjAlM0QlMjBwaXBlLmVuY29kZV9wcm9tcHQoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyVGVjaG5vJTIwbXVzaWMlMjB3aXRoJTIwYSUyMHN0cm9uZyUyQyUyMHVwYmVhdCUyMHRlbXBvJTIwYW5kJTIwaGlnaCUyMG1lbG9kaWMlMjByaWZmcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMEElMjAlMjAlMjAlMjBkb19jbGFzc2lmaWVyX2ZyZWVfZ3VpZGFuY2UlM0RUcnVlJTJDJTBBKSUwQSUwQSUyMyUyMFBhc3MlMjB0ZXh0JTIwZW1iZWRkaW5ncyUyMHRvJTIwcGlwZWxpbmUlMjBmb3IlMjB0ZXh0LWNvbmRpdGlvbmFsJTIwYXVkaW8lMjBnZW5lcmF0aW9uJTBBYXVkaW8lMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdF9lbWJlZHMlM0Rwcm9tcHRfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0RhdHRlbnRpb25fbWFzayUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF9wcm9tcHRfZW1iZWRzJTNEZ2VuZXJhdGVkX3Byb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAwJTJDJTBBJTIwJTIwJTIwJTIwYXVkaW9fbGVuZ3RoX2luX3MlM0QxMC4wJTJDJTBBKS5hdWRpb3MlNUIwJTVEJTBBJTBBJTIzJTIwc2F2ZSUyMGdlbmVyYXRlZCUyMGF1ZGlvJTIwc2FtcGxlJTBBc2NpcHkuaW8ud2F2ZmlsZS53cml0ZSglMjJ0ZWNobm8ud2F2JTIyJTJDJTIwcmF0ZSUzRDE2MDAwJTJDJTIwZGF0YSUzRGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AudioLDM2Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;cvssp/audioldm2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AudioLDM2Pipeline.from_pretrained(repo_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get text embedding vectors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_embeds, attention_mask, generated_prompt_embeds = pipe.encode_prompt(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;Techno music with a strong, upbeat tempo and high melodic riffs&quot;</span>,
<span class="hljs-meta">... </span>    device=<span class="hljs-string">&quot;cuda&quot;</span>,
<span class="hljs-meta">... </span>    do_classifier_free_guidance=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pass text embeddings to pipeline for text-conditional audio generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = pipe(
<span class="hljs-meta">... </span>    prompt_embeds=prompt_embeds,
<span class="hljs-meta">... </span>    attention_mask=attention_mask,
<span class="hljs-meta">... </span>    generated_prompt_embeds=generated_prompt_embeds,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    audio_length_in_s=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>).audios[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save generated audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;techno.wav&quot;</span>, rate=<span class="hljs-number">16000</span>, data=audio)`,wrap:!1}}),{c(){c=d("p"),c.textContent=k,v=n(),m(M.$$.fragment)},l(l){c=r(l,"P",{"data-svelte-h":!0}),p(c)!=="svelte-11lpom8"&&(c.textContent=k),v=i(l),u(M.$$.fragment,l)},m(l,T){s(l,c,T),s(l,v,T),f(M,l,T),w=!0},p:Et,i(l){w||(g(M.$$.fragment,l),w=!0)},o(l){h(M.$$.fragment,l),w=!1},d(l){l&&(o(c),o(v)),_(M,l)}}}function Ao(B){let c,k,v,M,w,l,T,St='AudioLDM 2 was proposed in <a href="https://arxiv.org/abs/2308.05734" rel="nofollow">AudioLDM 2: Learning Holistic Audio Generation with Self-supervised Pretraining</a> by Haohe Liu et al. AudioLDM 2 takes a text prompt as input and predicts the corresponding audio. It can generate text-conditional sound effects, human speech and music.',Fe,H,Wt='Inspired by <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview" rel="nofollow">Stable Diffusion</a>, AudioLDM 2 is a text-to-audio <em>latent diffusion model (LDM)</em> that learns continuous audio representations from text embeddings. Two text encoder models are used to compute the text embeddings from a prompt input: the text-branch of <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap" rel="nofollow">CLAP</a> and the encoder of <a href="https://huggingface.co/docs/transformers/main/en/model_doc/flan-t5" rel="nofollow">Flan-T5</a>. These text embeddings are then projected to a shared embedding space by an <a href="https://huggingface.co/docs/diffusers/main/api/pipelines/audioldm2#diffusers.AudioLDM2ProjectionModel" rel="nofollow">AudioLDM2ProjectionModel</a>. A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/gpt2" rel="nofollow">GPT2</a> <em>language model (LM)</em> is used to auto-regressively predict eight new embedding vectors, conditional on the projected CLAP and Flan-T5 embeddings. The generated embedding vectors and Flan-T5 text embeddings are used as cross-attention conditioning in the LDM. The <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioLDM2UNet2DConditionModel" rel="nofollow">UNet</a> of AudioLDM 2 is unique in the sense that it takes <strong>two</strong> cross-attention embeddings, as opposed to one cross-attention conditioning, as in most other LDMs.',Ee,z,Ht="The abstract of the paper is the following:",Se,O,zt='<em>Although audio generation shares commonalities across different types of audio, such as speech, music, and sound effects, designing models for each type requires careful consideration of specific objectives and biases that can significantly differ from those of other types. To bring us closer to a unified perspective of audio generation, this paper proposes a framework that utilizes the same learning method for speech, music, and sound effect generation. Our framework introduces a general representation of audio, called “language of audio” (LOA). Any audio can be translated into LOA based on AudioMAE, a self-supervised pre-trained representation learning model. In the generation process, we translate any modalities into LOA by using a GPT-2 model, and we perform self-supervised audio generation learning with a latent diffusion model conditioned on LOA. The proposed framework naturally brings advantages such as in-context learning abilities and reusable self-supervised pretrained AudioMAE and latent diffusion models. Experiments on the major benchmarks of text-to-audio, text-to-music, and text-to-speech demonstrate state-of-the-art or competitive performance against previous approaches. Our code, pretrained model, and demo are available at <a href="https://audioldm.github.io/audioldm2" rel="nofollow">this https URL</a>.</em>',We,Q,Ot='This pipeline was contributed by <a href="https://huggingface.co/sanchit-gandhi" rel="nofollow">sanchit-gandhi</a>. The original codebase can be found at <a href="https://github.com/haoheliu/audioldm2" rel="nofollow">haoheliu/audioldm2</a>.',He,X,ze,R,Oe,V,Qt="AudioLDM2 comes in three variants. Two of these checkpoints are applicable to the general task of text-to-audio generation. The third checkpoint is trained exclusively on text-to-music generation.",Qe,Y,Xt=`All checkpoints share the same model size for the text encoders and VAE. They differ in the size and depth of the UNet.
See table below for details on the three checkpoints:`,Xe,K,Rt='<thead><tr><th>Checkpoint</th> <th>Task</th> <th>UNet Model Size</th> <th>Total Model Size</th> <th>Training Data / h</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/cvssp/audioldm2" rel="nofollow">audioldm2</a></td> <td>Text-to-audio</td> <td>350M</td> <td>1.1B</td> <td>1150k</td></tr> <tr><td><a href="https://huggingface.co/cvssp/audioldm2-large" rel="nofollow">audioldm2-large</a></td> <td>Text-to-audio</td> <td>750M</td> <td>1.5B</td> <td>1150k</td></tr> <tr><td><a href="https://huggingface.co/cvssp/audioldm2-music" rel="nofollow">audioldm2-music</a></td> <td>Text-to-music</td> <td>350M</td> <td>1.1B</td> <td>665k</td></tr></tbody>',Re,ee,Ve,te,Vt="<li>Descriptive prompt inputs work best: use adjectives to describe the sound (e.g. “high quality” or “clear”) and make the prompt context specific (e.g. “water stream in a forest” instead of “stream”).</li> <li>It’s best to use general terms like “cat” or “dog” instead of specific names or abstract objects the model may not be familiar with.</li> <li>Using a <strong>negative prompt</strong> can significantly improve the quality of the generated waveform, by guiding the generation away from terms that correspond to poor quality audio. Try using a negative prompt of “Low quality.”</li>",Ye,oe,Ke,ne,Yt="<li>The <em>quality</em> of the predicted audio sample can be controlled by the <code>num_inference_steps</code> argument; higher steps give higher quality audio at the expense of slower inference.</li> <li>The <em>length</em> of the predicted audio sample can be controlled by varying the <code>audio_length_in_s</code> argument.</li>",et,ie,tt,se,Kt="<li>The quality of the generated waveforms can vary significantly based on the seed. Try generating with different seeds until you find a satisfactory generation.</li> <li>Multiple waveforms can be generated in one go: set <code>num_waveforms_per_prompt</code> to a value greater than 1. Automatic scoring will be performed between the generated waveforms and prompt text, and the audios ranked from best to worst accordingly.</li>",ot,ae,eo='The following example demonstrates how to construct good music generation using the aforementioned tips: <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioLDM2Pipeline.__call__.example" rel="nofollow">example</a>.',nt,J,it,de,st,b,re,Mt,xe,to="Pipeline for text-to-audio generation using AudioLDM2.",vt,De,oo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,yt,j,le,wt,ke,no="The call function to the pipeline for generation.",Tt,I,xt,q,ce,Dt,Ae,io=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,kt,G,pe,At,Le,so=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Lt,Z,me,$t,$e,ao=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,jt,C,ue,Ct,je,ro="Encodes the prompt into text encoder hidden states.",Ut,F,Nt,E,fe,Pt,Ce,lo="Generates a sequence of hidden-states from the language model, conditioned on the embedding inputs.",at,ge,dt,$,he,Bt,Ue,co=`A simple linear projection model to map two text embeddings to a shared latent space. It also inserts learned
embedding vectors at the start and end of each text embedding sequence respectively. Each variable appended with
<code>_1</code> refers to that corresponding to the second text encoder. Otherwise, it is from the first.`,Jt,Ne,_e,rt,be,lt,A,Me,It,Pe,po=`A conditional 2D UNet model that takes a noisy sample, conditional state, and a timestep and returns a sample
shaped output. Compared to the vanilla <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>, this variant optionally includes an additional
self-attention layer in each Transformer block, as well as multiple cross-attention layers. It also allows for up
to two cross-attention embeddings, <code>encoder_hidden_states</code> and <code>encoder_hidden_states_1</code>.`,qt,Be,mo=`This model inherits from <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. Check the superclass documentation for it’s generic methods implemented
for all models (such as downloading or saving).`,Gt,S,ve,Zt,Je,uo='The <a href="/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioLDM2UNet2DConditionModel">AudioLDM2UNet2DConditionModel</a> forward method.',ct,ye,pt,N,we,Ft,Ie,fo="Output class for audio pipelines.",mt,Ze,ut;return w=new U({props:{title:"AudioLDM 2",local:"audioldm-2",headingTag:"h1"}}),X=new U({props:{title:"Tips",local:"tips",headingTag:"h2"}}),R=new U({props:{title:"Choosing a checkpoint",local:"choosing-a-checkpoint",headingTag:"h3"}}),ee=new U({props:{title:"Constructing a prompt",local:"constructing-a-prompt",headingTag:"h3"}}),oe=new U({props:{title:"Controlling inference",local:"controlling-inference",headingTag:"h3"}}),ie=new U({props:{title:"Evaluating generated waveforms:",local:"evaluating-generated-waveforms",headingTag:"h3"}}),J=new To({props:{$$slots:{default:[xo]},$$scope:{ctx:B}}}),de=new U({props:{title:"AudioLDM2Pipeline",local:"diffusers.AudioLDM2Pipeline",headingTag:"h2"}}),re=new L({props:{name:"class diffusers.AudioLDM2Pipeline",anchor:"diffusers.AudioLDM2Pipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": ClapModel"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"projection_model",val:": AudioLDM2ProjectionModel"},{name:"language_model",val:": GPT2Model"},{name:"tokenizer",val:": typing.Union[transformers.models.roberta.tokenization_roberta.RobertaTokenizer, transformers.models.roberta.tokenization_roberta_fast.RobertaTokenizerFast]"},{name:"tokenizer_2",val:": typing.Union[transformers.models.t5.tokenization_t5.T5Tokenizer, transformers.models.t5.tokenization_t5_fast.T5TokenizerFast]"},{name:"feature_extractor",val:": ClapFeatureExtractor"},{name:"unet",val:": AudioLDM2UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vocoder",val:": SpeechT5HifiGan"}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AudioLDM2Pipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap#transformers.ClapModel" rel="nofollow">ClapModel</a>) &#x2014;
First frozen text-encoder. AudioLDM2 uses the joint audio-text embedding model
<a href="https://huggingface.co/docs/transformers/model_doc/clap#transformers.CLAPTextModelWithProjection" rel="nofollow">CLAP</a>,
specifically the <a href="https://huggingface.co/laion/clap-htsat-unfused" rel="nofollow">laion/clap-htsat-unfused</a> variant. The
text branch is used to encode the text prompt to a prompt embedding. The full audio-text model is used to
rank generated waveforms against the text prompt by computing similarity scores.`,name:"text_encoder"},{anchor:"diffusers.AudioLDM2Pipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a>) &#x2014;
Second frozen text-encoder. AudioLDM2 uses the encoder of
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/google/flan-t5-large" rel="nofollow">google/flan-t5-large</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.AudioLDM2Pipeline.projection_model",description:`<strong>projection_model</strong> (<a href="/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioLDM2ProjectionModel">AudioLDM2ProjectionModel</a>) &#x2014;
A trained model used to linearly project the hidden-states from the first and second text encoder models
and insert learned SOS and EOS token embeddings. The projected hidden-states from the two text encoders are
concatenated to give the input to the language model.`,name:"projection_model"},{anchor:"diffusers.AudioLDM2Pipeline.language_model",description:`<strong>language_model</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Model" rel="nofollow">GPT2Model</a>) &#x2014;
An auto-regressive language model used to generate a sequence of hidden-states conditioned on the projected
outputs from the two text encoders.`,name:"language_model"},{anchor:"diffusers.AudioLDM2Pipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer" rel="nofollow">RobertaTokenizer</a>) &#x2014;
Tokenizer to tokenize text for the first frozen text-encoder.`,name:"tokenizer"},{anchor:"diffusers.AudioLDM2Pipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/mt5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>) &#x2014;
Tokenizer to tokenize text for the second frozen text-encoder.`,name:"tokenizer_2"},{anchor:"diffusers.AudioLDM2Pipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap#transformers.ClapFeatureExtractor" rel="nofollow">ClapFeatureExtractor</a>) &#x2014;
Feature extractor to pre-process generated audio waveforms to log-mel spectrograms for automatic scoring.`,name:"feature_extractor"},{anchor:"diffusers.AudioLDM2Pipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded audio latents.`,name:"unet"},{anchor:"diffusers.AudioLDM2Pipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded audio latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.AudioLDM2Pipeline.vocoder",description:`<strong>vocoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5HifiGan" rel="nofollow">SpeechT5HifiGan</a>) &#x2014;
Vocoder of class <code>SpeechT5HifiGan</code> to convert the mel-spectrogram latents to the final audio waveform.`,name:"vocoder"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L103"}}),le=new L({props:{name:"__call__",anchor:"diffusers.AudioLDM2Pipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"audio_length_in_s",val:": typing.Optional[float] = None"},{name:"num_inference_steps",val:": int = 200"},{name:"guidance_scale",val:": float = 3.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_waveforms_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"generated_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_generated_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"negative_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": typing.Optional[int] = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide audio generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.audio_length_in_s",description:`<strong>audio_length_in_s</strong> (<code>int</code>, <em>optional</em>, defaults to 10.24) &#x2014;
The length of the generated audio sample in seconds.`,name:"audio_length_in_s"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 200) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality audio at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.5) &#x2014;
A higher guidance scale value encourages the model to generate audio that is closely linked to the text
<code>prompt</code> at the expense of lower sound quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in audio generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.num_waveforms_per_prompt",description:`<strong>num_waveforms_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of waveforms to generate per prompt. If <code>num_waveforms_per_prompt &gt; 1</code>, then automatic
scoring is performed between the generated outputs and the text prompt. This scoring ranks the
generated waveforms based on their cosine similarity with the text input in the joint text-audio
embedding space.`,name:"num_waveforms_per_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for spectrogram
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.generated_prompt_embeds",description:`<strong>generated_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings from the GPT2 langauge model. Can be used to easily tweak text inputs,
<em>e.g.</em> prompt weighting. If not provided, text embeddings will be generated from <code>prompt</code> input
argument.`,name:"generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_generated_prompt_embeds",description:`<strong>negative_generated_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings from the GPT2 language model. Can be used to easily tweak text
inputs, <em>e.g.</em> prompt weighting. If not provided, negative_prompt_embeds will be computed from
<code>negative_prompt</code> input argument.`,name:"negative_generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>prompt_embeds</code>. If not provided, attention mask will
be computed from <code>prompt</code> input argument.`,name:"attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_attention_mask",description:`<strong>negative_attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>negative_prompt_embeds</code>. If not provided, attention
mask will be computed from <code>negative_prompt</code> input argument.`,name:"negative_attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to None) &#x2014;
Number of new tokens to generate with the GPT2 language model. If not provided, number of tokens will
be taken from the config of the model.`,name:"max_new_tokens"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated audio. Choose between <code>&quot;np&quot;</code> to return a NumPy <code>np.ndarray</code> or
<code>&quot;pt&quot;</code> to return a PyTorch <code>torch.Tensor</code> object. Set to <code>&quot;latent&quot;</code> to return the latent diffusion
model (LDM) output.`,name:"output_type"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L732",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),I=new ho({props:{anchor:"diffusers.AudioLDM2Pipeline.__call__.example",$$slots:{default:[Do]},$$scope:{ctx:B}}}),ce=new L({props:{name:"disable_vae_slicing",anchor:"diffusers.AudioLDM2Pipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L185"}}),pe=new L({props:{name:"enable_model_cpu_offload",anchor:"diffusers.AudioLDM2Pipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L192"}}),me=new L({props:{name:"enable_vae_slicing",anchor:"diffusers.AudioLDM2Pipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L177"}}),ue=new L({props:{name:"encode_prompt",anchor:"diffusers.AudioLDM2Pipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_waveforms_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"generated_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_generated_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"negative_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
torch device`,name:"device"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.num_waveforms_per_prompt",description:`<strong>num_waveforms_per_prompt</strong> (<code>int</code>) &#x2014;
number of waveforms that should be generated per prompt`,name:"num_waveforms_per_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the audio generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-computed text embeddings from the Flan T5 model. Can be used to easily tweak text inputs, <em>e.g.</em>
prompt weighting. If not provided, text embeddings will be computed from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-computed negative text embeddings from the Flan T5 model. Can be used to easily tweak text inputs,
<em>e.g.</em> prompt weighting. If not provided, negative_prompt_embeds will be computed from
<code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.generated_prompt_embeds",description:`<strong>generated_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings from the GPT2 langauge model. Can be used to easily tweak text inputs,
<em>e.g.</em> prompt weighting. If not provided, text embeddings will be generated from <code>prompt</code> input
argument.`,name:"generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_generated_prompt_embeds",description:`<strong>negative_generated_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings from the GPT2 language model. Can be used to easily tweak text
inputs, <em>e.g.</em> prompt weighting. If not provided, negative_prompt_embeds will be computed from
<code>negative_prompt</code> input argument.`,name:"negative_generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>prompt_embeds</code>. If not provided, attention mask will
be computed from <code>prompt</code> input argument.`,name:"attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_attention_mask",description:`<strong>negative_attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>negative_prompt_embeds</code>. If not provided, attention
mask will be computed from <code>negative_prompt</code> input argument.`,name:"negative_attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to None) &#x2014;
The number of new tokens to generate with the GPT2 language model.`,name:"max_new_tokens"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L270",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Text embeddings from the Flan T5 model.
attention_mask (<code>torch.LongTensor</code>):
Attention mask to be applied to the <code>prompt_embeds</code>.
generated_prompt_embeds (<code>torch.FloatTensor</code>):
Text embeddings generated from the GPT2 langauge model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>prompt_embeds (<code>torch.FloatTensor</code>)</p>
`}}),F=new ho({props:{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.example",$$slots:{default:[ko]},$$scope:{ctx:B}}}),fe=new L({props:{name:"generate_language_model",anchor:"diffusers.AudioLDM2Pipeline.generate_language_model",parameters:[{name:"inputs_embeds",val:": Tensor = None"},{name:"max_new_tokens",val:": int = 8"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.generate_language_model.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"inputs_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.generate_language_model.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>) &#x2014;
Number of new tokens to generate.`,name:"max_new_tokens"},{anchor:"diffusers.AudioLDM2Pipeline.generate_language_model.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of additional model-specific kwargs that will be forwarded to the <code>forward</code>
function of the model.`,name:"model_kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L229",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sequence of generated hidden-states.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>inputs_embeds (</code>torch.FloatTensor<code>of shape</code>(batch_size, sequence_length, hidden_size)\`)</p>
`}}),ge=new U({props:{title:"AudioLDM2ProjectionModel",local:"diffusers.AudioLDM2ProjectionModel",headingTag:"h2"}}),he=new L({props:{name:"class diffusers.AudioLDM2ProjectionModel",anchor:"diffusers.AudioLDM2ProjectionModel",parameters:[{name:"text_encoder_dim",val:""},{name:"text_encoder_1_dim",val:""},{name:"langauge_model_dim",val:""}],parametersDescription:[{anchor:"diffusers.AudioLDM2ProjectionModel.text_encoder_dim",description:`<strong>text_encoder_dim</strong> (<code>int</code>) &#x2014;
Dimensionality of the text embeddings from the first text encoder (CLAP).`,name:"text_encoder_dim"},{anchor:"diffusers.AudioLDM2ProjectionModel.text_encoder_1_dim",description:`<strong>text_encoder_1_dim</strong> (<code>int</code>) &#x2014;
Dimensionality of the text embeddings from the second text encoder (T5 or VITS).`,name:"text_encoder_1_dim"},{anchor:"diffusers.AudioLDM2ProjectionModel.langauge_model_dim",description:`<strong>langauge_model_dim</strong> (<code>int</code>) &#x2014;
Dimensionality of the text embeddings from the language model (GPT2).`,name:"langauge_model_dim"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L82"}}),_e=new L({props:{name:"forward",anchor:"diffusers.AudioLDM2ProjectionModel.forward",parameters:[{name:"hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"hidden_states_1",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask_1",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L111"}}),be=new U({props:{title:"AudioLDM2UNet2DConditionModel",local:"diffusers.AudioLDM2UNet2DConditionModel",headingTag:"h2"}}),Me=new L({props:{name:"class diffusers.AudioLDM2UNet2DConditionModel",anchor:"diffusers.AudioLDM2UNet2DConditionModel",parameters:[{name:"sample_size",val:": typing.Optional[int] = None"},{name:"in_channels",val:": int = 4"},{name:"out_channels",val:": int = 4"},{name:"flip_sin_to_cos",val:": bool = True"},{name:"freq_shift",val:": int = 0"},{name:"down_block_types",val:": typing.Tuple[str] = ('CrossAttnDownBlock2D', 'CrossAttnDownBlock2D', 'CrossAttnDownBlock2D', 'DownBlock2D')"},{name:"mid_block_type",val:": typing.Optional[str] = 'UNetMidBlock2DCrossAttn'"},{name:"up_block_types",val:": typing.Tuple[str] = ('UpBlock2D', 'CrossAttnUpBlock2D', 'CrossAttnUpBlock2D', 'CrossAttnUpBlock2D')"},{name:"only_cross_attention",val:": typing.Union[bool, typing.Tuple[bool]] = False"},{name:"block_out_channels",val:": typing.Tuple[int] = (320, 640, 1280, 1280)"},{name:"layers_per_block",val:": typing.Union[int, typing.Tuple[int]] = 2"},{name:"downsample_padding",val:": int = 1"},{name:"mid_block_scale_factor",val:": float = 1"},{name:"act_fn",val:": str = 'silu'"},{name:"norm_num_groups",val:": typing.Optional[int] = 32"},{name:"norm_eps",val:": float = 1e-05"},{name:"cross_attention_dim",val:": typing.Union[int, typing.Tuple[int]] = 1280"},{name:"transformer_layers_per_block",val:": typing.Union[int, typing.Tuple[int]] = 1"},{name:"attention_head_dim",val:": typing.Union[int, typing.Tuple[int]] = 8"},{name:"num_attention_heads",val:": typing.Union[int, typing.Tuple[int], NoneType] = None"},{name:"use_linear_projection",val:": bool = False"},{name:"class_embed_type",val:": typing.Optional[str] = None"},{name:"num_class_embeds",val:": typing.Optional[int] = None"},{name:"upcast_attention",val:": bool = False"},{name:"resnet_time_scale_shift",val:": str = 'default'"},{name:"time_embedding_type",val:": str = 'positional'"},{name:"time_embedding_dim",val:": typing.Optional[int] = None"},{name:"time_embedding_act_fn",val:": typing.Optional[str] = None"},{name:"timestep_post_act",val:": typing.Optional[str] = None"},{name:"time_cond_proj_dim",val:": typing.Optional[int] = None"},{name:"conv_in_kernel",val:": int = 3"},{name:"conv_out_kernel",val:": int = 3"},{name:"projection_class_embeddings_input_dim",val:": typing.Optional[int] = None"},{name:"class_embeddings_concat",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.AudioLDM2UNet2DConditionModel.sample_size",description:`<strong>sample_size</strong> (<code>int</code> or <code>Tuple[int, int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Height and width of input/output sample.`,name:"sample_size"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.in_channels",description:"<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Number of channels in the input sample.",name:"in_channels"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.out_channels",description:"<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Number of channels in the output.",name:"out_channels"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.flip_sin_to_cos",description:`<strong>flip_sin_to_cos</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to flip the sin to cos in the time embedding.`,name:"flip_sin_to_cos"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.freq_shift",description:"<strong>freq_shift</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014; The frequency shift to apply to the time embedding.",name:"freq_shift"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.down_block_types",description:`<strong>down_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;CrossAttnDownBlock2D&quot;, &quot;CrossAttnDownBlock2D&quot;, &quot;CrossAttnDownBlock2D&quot;, &quot;DownBlock2D&quot;)</code>) &#x2014;
The tuple of downsample blocks to use.`,name:"down_block_types"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.mid_block_type",description:`<strong>mid_block_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;UNetMidBlock2DCrossAttn&quot;</code>) &#x2014;
Block type for middle of UNet, it can only be <code>UNetMidBlock2DCrossAttn</code> for AudioLDM2.`,name:"mid_block_type"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.up_block_types",description:`<strong>up_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;UpBlock2D&quot;, &quot;CrossAttnUpBlock2D&quot;, &quot;CrossAttnUpBlock2D&quot;, &quot;CrossAttnUpBlock2D&quot;)</code>) &#x2014;
The tuple of upsample blocks to use.`,name:"up_block_types"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.only_cross_attention",description:`<strong>only_cross_attention</strong> (<code>bool</code> or <code>Tuple[bool]</code>, <em>optional</em>, default to <code>False</code>) &#x2014;
Whether to include self-attention in the basic transformer blocks, see
<code>BasicTransformerBlock</code>.`,name:"only_cross_attention"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.block_out_channels",description:`<strong>block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(320, 640, 1280, 1280)</code>) &#x2014;
The tuple of output channels for each block.`,name:"block_out_channels"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.layers_per_block",description:"<strong>layers_per_block</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014; The number of layers per block.",name:"layers_per_block"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.downsample_padding",description:"<strong>downsample_padding</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014; The padding to use for the downsampling convolution.",name:"downsample_padding"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.mid_block_scale_factor",description:"<strong>mid_block_scale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014; The scale factor to use for the mid block.",name:"mid_block_scale_factor"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.act_fn",description:"<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014; The activation function to use.",name:"act_fn"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.norm_num_groups",description:`<strong>norm_num_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014; The number of groups to use for the normalization.
If <code>None</code>, normalization and activation layers is skipped in post-processing.`,name:"norm_num_groups"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.norm_eps",description:"<strong>norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-5) &#x2014; The epsilon to use for the normalization.",name:"norm_eps"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.cross_attention_dim",description:`<strong>cross_attention_dim</strong> (<code>int</code> or <code>Tuple[int]</code>, <em>optional</em>, defaults to 1280) &#x2014;
The dimension of the cross attention features.`,name:"cross_attention_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.transformer_layers_per_block",description:`<strong>transformer_layers_per_block</strong> (<code>int</code> or <code>Tuple[int]</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of transformer blocks of type <code>BasicTransformerBlock</code>. Only relevant for
<code>CrossAttnDownBlock2D</code>, <code>CrossAttnUpBlock2D</code>,
<code>UNetMidBlock2DCrossAttn</code>.`,name:"transformer_layers_per_block"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.attention_head_dim",description:"<strong>attention_head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014; The dimension of the attention heads.",name:"attention_head_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of attention heads. If not defined, defaults to <code>attention_head_dim</code>`,name:"num_attention_heads"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.resnet_time_scale_shift",description:`<strong>resnet_time_scale_shift</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014; Time scale shift config
for ResNet blocks (see <code>ResnetBlock2D</code>). Choose from <code>default</code> or <code>scale_shift</code>.`,name:"resnet_time_scale_shift"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.class_embed_type",description:`<strong>class_embed_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The type of class embedding to use which is ultimately summed with the time embeddings. Choose from <code>None</code>,
<code>&quot;timestep&quot;</code>, <code>&quot;identity&quot;</code>, <code>&quot;projection&quot;</code>, or <code>&quot;simple_projection&quot;</code>.`,name:"class_embed_type"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.num_class_embeds",description:`<strong>num_class_embeds</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Input dimension of the learnable embedding matrix to be projected to <code>time_embed_dim</code>, when performing
class conditioning with <code>class_embed_type</code> equal to <code>None</code>.`,name:"num_class_embeds"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_embedding_type",description:`<strong>time_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>positional</code>) &#x2014;
The type of position embedding to use for timesteps. Choose from <code>positional</code> or <code>fourier</code>.`,name:"time_embedding_type"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_embedding_dim",description:`<strong>time_embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An optional override for the dimension of the projected time embedding.`,name:"time_embedding_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_embedding_act_fn",description:`<strong>time_embedding_act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Optional activation function to use only once on the time embeddings before they are passed to the rest of
the UNet. Choose from <code>silu</code>, <code>mish</code>, <code>gelu</code>, and <code>swish</code>.`,name:"time_embedding_act_fn"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.timestep_post_act",description:`<strong>timestep_post_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The second activation function to use in timestep embedding. Choose from <code>silu</code>, <code>mish</code> and <code>gelu</code>.`,name:"timestep_post_act"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_cond_proj_dim",description:`<strong>time_cond_proj_dim</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The dimension of <code>cond_proj</code> layer in the timestep embedding.`,name:"time_cond_proj_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.conv_in_kernel",description:"<strong>conv_in_kernel</strong> (<code>int</code>, <em>optional</em>, default to <code>3</code>) &#x2014; The kernel size of <code>conv_in</code> layer.",name:"conv_in_kernel"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.conv_out_kernel",description:"<strong>conv_out_kernel</strong> (<code>int</code>, <em>optional</em>, default to <code>3</code>) &#x2014; The kernel size of <code>conv_out</code> layer.",name:"conv_out_kernel"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.projection_class_embeddings_input_dim",description:`<strong>projection_class_embeddings_input_dim</strong> (<code>int</code>, <em>optional</em>) &#x2014; The dimension of the <code>class_labels</code> input when
<code>class_embed_type=&quot;projection&quot;</code>. Required when <code>class_embed_type=&quot;projection&quot;</code>.`,name:"projection_class_embeddings_input_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.class_embeddings_concat",description:`<strong>class_embeddings_concat</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to concatenate the time
embeddings with the class embeddings.`,name:"class_embeddings_concat"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L148"}}),ve=new L({props:{name:"forward",anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward",parameters:[{name:"sample",val:": FloatTensor"},{name:"timestep",val:": typing.Union[torch.Tensor, float, int]"},{name:"encoder_hidden_states",val:": Tensor"},{name:"class_labels",val:": typing.Optional[torch.Tensor] = None"},{name:"timestep_cond",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": bool = True"},{name:"encoder_hidden_states_1",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_attention_mask_1",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The noisy input tensor with the following shape <code>(batch, channel, height, width)</code>.`,name:"sample"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.timestep",description:"<strong>timestep</strong> (<code>torch.FloatTensor</code> or <code>float</code> or <code>int</code>) &#x2014; The number of timesteps to denoise an input.",name:"timestep"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder hidden states with shape <code>(batch, sequence_length, feature_dim)</code>.`,name:"encoder_hidden_states"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.Tensor</code>) &#x2014;
A cross-attention mask of shape <code>(batch, sequence_length)</code> is applied to <code>encoder_hidden_states</code>. If
<code>True</code> the mask is kept, otherwise if <code>False</code> it is discarded. Mask will be converted into a bias,
which adds large negative values to the attention scores corresponding to &#x201C;discard&#x201D; tokens.`,name:"encoder_attention_mask"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.models.unet_2d_condition.UNet2DConditionOutput">UNet2DConditionOutput</a> instead of a plain
tuple.`,name:"return_dict"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttnProcessor</code>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_hidden_states_1",description:`<strong>encoder_hidden_states_1</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
A second set of encoder hidden states with shape <code>(batch, sequence_length_2, feature_dim_2)</code>. Can be
used to condition the model on a different set of embeddings to <code>encoder_hidden_states</code>.`,name:"encoder_hidden_states_1"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_attention_mask_1",description:`<strong>encoder_attention_mask_1</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
A cross-attention mask of shape <code>(batch, sequence_length_2)</code> is applied to <code>encoder_hidden_states_1</code>.
If <code>True</code> the mask is kept, otherwise if <code>False</code> it is discarded. Mask will be converted into a bias,
which adds large negative values to the attention scores corresponding to &#x201C;discard&#x201D; tokens.`,name:"encoder_attention_mask_1"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L664",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is True, an <a
  href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.models.unet_2d_condition.UNet2DConditionOutput"
>UNet2DConditionOutput</a> is returned, otherwise
a <code>tuple</code> is returned where the first element is the sample tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.models.unet_2d_condition.UNet2DConditionOutput"
>UNet2DConditionOutput</a> or <code>tuple</code></p>
`}}),ye=new U({props:{title:"AudioPipelineOutput",local:"diffusers.AudioPipelineOutput",headingTag:"h2"}}),we=new L({props:{name:"class diffusers.AudioPipelineOutput",anchor:"diffusers.AudioPipelineOutput",parameters:[{name:"audios",val:": ndarray"}],parametersDescription:[{anchor:"diffusers.AudioPipelineOutput.audios",description:`<strong>audios</strong> (<code>np.ndarray</code>) &#x2014;
List of denoised audio samples of a NumPy array of shape <code>(batch_size, num_channels, sample_rate)</code>.`,name:"audios"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L130"}}),{c(){c=d("meta"),k=n(),v=d("p"),M=n(),m(w.$$.fragment),l=n(),T=d("p"),T.innerHTML=St,Fe=n(),H=d("p"),H.innerHTML=Wt,Ee=n(),z=d("p"),z.textContent=Ht,Se=n(),O=d("p"),O.innerHTML=zt,We=n(),Q=d("p"),Q.innerHTML=Ot,He=n(),m(X.$$.fragment),ze=n(),m(R.$$.fragment),Oe=n(),V=d("p"),V.textContent=Qt,Qe=n(),Y=d("p"),Y.textContent=Xt,Xe=n(),K=d("table"),K.innerHTML=Rt,Re=n(),m(ee.$$.fragment),Ve=n(),te=d("ul"),te.innerHTML=Vt,Ye=n(),m(oe.$$.fragment),Ke=n(),ne=d("ul"),ne.innerHTML=Yt,et=n(),m(ie.$$.fragment),tt=n(),se=d("ul"),se.innerHTML=Kt,ot=n(),ae=d("p"),ae.innerHTML=eo,nt=n(),m(J.$$.fragment),it=n(),m(de.$$.fragment),st=n(),b=d("div"),m(re.$$.fragment),Mt=n(),xe=d("p"),xe.textContent=to,vt=n(),De=d("p"),De.innerHTML=oo,yt=n(),j=d("div"),m(le.$$.fragment),wt=n(),ke=d("p"),ke.textContent=no,Tt=n(),m(I.$$.fragment),xt=n(),q=d("div"),m(ce.$$.fragment),Dt=n(),Ae=d("p"),Ae.innerHTML=io,kt=n(),G=d("div"),m(pe.$$.fragment),At=n(),Le=d("p"),Le.innerHTML=so,Lt=n(),Z=d("div"),m(me.$$.fragment),$t=n(),$e=d("p"),$e.textContent=ao,jt=n(),C=d("div"),m(ue.$$.fragment),Ct=n(),je=d("p"),je.textContent=ro,Ut=n(),m(F.$$.fragment),Nt=n(),E=d("div"),m(fe.$$.fragment),Pt=n(),Ce=d("p"),Ce.textContent=lo,at=n(),m(ge.$$.fragment),dt=n(),$=d("div"),m(he.$$.fragment),Bt=n(),Ue=d("p"),Ue.innerHTML=co,Jt=n(),Ne=d("div"),m(_e.$$.fragment),rt=n(),m(be.$$.fragment),lt=n(),A=d("div"),m(Me.$$.fragment),It=n(),Pe=d("p"),Pe.innerHTML=po,qt=n(),Be=d("p"),Be.innerHTML=mo,Gt=n(),S=d("div"),m(ve.$$.fragment),Zt=n(),Je=d("p"),Je.innerHTML=uo,ct=n(),m(ye.$$.fragment),pt=n(),N=d("div"),m(we.$$.fragment),Ft=n(),Ie=d("p"),Ie.textContent=fo,mt=n(),Ze=d("p"),this.h()},l(e){const t=wo("svelte-u9bgzb",document.head);c=r(t,"META",{name:!0,content:!0}),t.forEach(o),k=i(e),v=r(e,"P",{}),x(v).forEach(o),M=i(e),u(w.$$.fragment,e),l=i(e),T=r(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-ta0apn"&&(T.innerHTML=St),Fe=i(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-117z0zb"&&(H.innerHTML=Wt),Ee=i(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-wu27l3"&&(z.textContent=Ht),Se=i(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1ddltfs"&&(O.innerHTML=zt),We=i(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-gffixp"&&(Q.innerHTML=Ot),He=i(e),u(X.$$.fragment,e),ze=i(e),u(R.$$.fragment,e),Oe=i(e),V=r(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1hmv6lf"&&(V.textContent=Qt),Qe=i(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1hmqwck"&&(Y.textContent=Xt),Xe=i(e),K=r(e,"TABLE",{"data-svelte-h":!0}),p(K)!=="svelte-qdkw13"&&(K.innerHTML=Rt),Re=i(e),u(ee.$$.fragment,e),Ve=i(e),te=r(e,"UL",{"data-svelte-h":!0}),p(te)!=="svelte-1ry6k60"&&(te.innerHTML=Vt),Ye=i(e),u(oe.$$.fragment,e),Ke=i(e),ne=r(e,"UL",{"data-svelte-h":!0}),p(ne)!=="svelte-jm9a2k"&&(ne.innerHTML=Yt),et=i(e),u(ie.$$.fragment,e),tt=i(e),se=r(e,"UL",{"data-svelte-h":!0}),p(se)!=="svelte-9fhj5v"&&(se.innerHTML=Kt),ot=i(e),ae=r(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-18kt9eu"&&(ae.innerHTML=eo),nt=i(e),u(J.$$.fragment,e),it=i(e),u(de.$$.fragment,e),st=i(e),b=r(e,"DIV",{class:!0});var y=x(b);u(re.$$.fragment,y),Mt=i(y),xe=r(y,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-m23e7a"&&(xe.textContent=to),vt=i(y),De=r(y,"P",{"data-svelte-h":!0}),p(De)!=="svelte-496sm0"&&(De.innerHTML=oo),yt=i(y),j=r(y,"DIV",{class:!0});var P=x(j);u(le.$$.fragment,P),wt=i(P),ke=r(P,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-50j04k"&&(ke.textContent=no),Tt=i(P),u(I.$$.fragment,P),P.forEach(o),xt=i(y),q=r(y,"DIV",{class:!0});var Te=x(q);u(ce.$$.fragment,Te),Dt=i(Te),Ae=r(Te,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1s3c06i"&&(Ae.innerHTML=io),Te.forEach(o),kt=i(y),G=r(y,"DIV",{class:!0});var ft=x(G);u(pe.$$.fragment,ft),At=i(ft),Le=r(ft,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-d7vywi"&&(Le.innerHTML=so),ft.forEach(o),Lt=i(y),Z=r(y,"DIV",{class:!0});var gt=x(Z);u(me.$$.fragment,gt),$t=i(gt),$e=r(gt,"P",{"data-svelte-h":!0}),p($e)!=="svelte-14bnrb6"&&($e.textContent=ao),gt.forEach(o),jt=i(y),C=r(y,"DIV",{class:!0});var qe=x(C);u(ue.$$.fragment,qe),Ct=i(qe),je=r(qe,"P",{"data-svelte-h":!0}),p(je)!=="svelte-16q0ax1"&&(je.textContent=ro),Ut=i(qe),u(F.$$.fragment,qe),qe.forEach(o),Nt=i(y),E=r(y,"DIV",{class:!0});var ht=x(E);u(fe.$$.fragment,ht),Pt=i(ht),Ce=r(ht,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1whwjf0"&&(Ce.textContent=lo),ht.forEach(o),y.forEach(o),at=i(e),u(ge.$$.fragment,e),dt=i(e),$=r(e,"DIV",{class:!0});var Ge=x($);u(he.$$.fragment,Ge),Bt=i(Ge),Ue=r(Ge,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-eyi7ar"&&(Ue.innerHTML=co),Jt=i(Ge),Ne=r(Ge,"DIV",{class:!0});var go=x(Ne);u(_e.$$.fragment,go),go.forEach(o),Ge.forEach(o),rt=i(e),u(be.$$.fragment,e),lt=i(e),A=r(e,"DIV",{class:!0});var W=x(A);u(Me.$$.fragment,W),It=i(W),Pe=r(W,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-pvv01z"&&(Pe.innerHTML=po),qt=i(W),Be=r(W,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1hyu2ru"&&(Be.innerHTML=mo),Gt=i(W),S=r(W,"DIV",{class:!0});var _t=x(S);u(ve.$$.fragment,_t),Zt=i(_t),Je=r(_t,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-112grcz"&&(Je.innerHTML=uo),_t.forEach(o),W.forEach(o),ct=i(e),u(ye.$$.fragment,e),pt=i(e),N=r(e,"DIV",{class:!0});var bt=x(N);u(we.$$.fragment,bt),Ft=i(bt),Ie=r(bt,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-19ryw33"&&(Ie.textContent=fo),bt.forEach(o),mt=i(e),Ze=r(e,"P",{}),x(Ze).forEach(o),this.h()},h(){D(c,"name","hf:doc:metadata"),D(c,"content",Lo),D(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){a(document.head,c),s(e,k,t),s(e,v,t),s(e,M,t),f(w,e,t),s(e,l,t),s(e,T,t),s(e,Fe,t),s(e,H,t),s(e,Ee,t),s(e,z,t),s(e,Se,t),s(e,O,t),s(e,We,t),s(e,Q,t),s(e,He,t),f(X,e,t),s(e,ze,t),f(R,e,t),s(e,Oe,t),s(e,V,t),s(e,Qe,t),s(e,Y,t),s(e,Xe,t),s(e,K,t),s(e,Re,t),f(ee,e,t),s(e,Ve,t),s(e,te,t),s(e,Ye,t),f(oe,e,t),s(e,Ke,t),s(e,ne,t),s(e,et,t),f(ie,e,t),s(e,tt,t),s(e,se,t),s(e,ot,t),s(e,ae,t),s(e,nt,t),f(J,e,t),s(e,it,t),f(de,e,t),s(e,st,t),s(e,b,t),f(re,b,null),a(b,Mt),a(b,xe),a(b,vt),a(b,De),a(b,yt),a(b,j),f(le,j,null),a(j,wt),a(j,ke),a(j,Tt),f(I,j,null),a(b,xt),a(b,q),f(ce,q,null),a(q,Dt),a(q,Ae),a(b,kt),a(b,G),f(pe,G,null),a(G,At),a(G,Le),a(b,Lt),a(b,Z),f(me,Z,null),a(Z,$t),a(Z,$e),a(b,jt),a(b,C),f(ue,C,null),a(C,Ct),a(C,je),a(C,Ut),f(F,C,null),a(b,Nt),a(b,E),f(fe,E,null),a(E,Pt),a(E,Ce),s(e,at,t),f(ge,e,t),s(e,dt,t),s(e,$,t),f(he,$,null),a($,Bt),a($,Ue),a($,Jt),a($,Ne),f(_e,Ne,null),s(e,rt,t),f(be,e,t),s(e,lt,t),s(e,A,t),f(Me,A,null),a(A,It),a(A,Pe),a(A,qt),a(A,Be),a(A,Gt),a(A,S),f(ve,S,null),a(S,Zt),a(S,Je),s(e,ct,t),f(ye,e,t),s(e,pt,t),s(e,N,t),f(we,N,null),a(N,Ft),a(N,Ie),s(e,mt,t),s(e,Ze,t),ut=!0},p(e,[t]){const y={};t&2&&(y.$$scope={dirty:t,ctx:e}),J.$set(y);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),I.$set(P);const Te={};t&2&&(Te.$$scope={dirty:t,ctx:e}),F.$set(Te)},i(e){ut||(g(w.$$.fragment,e),g(X.$$.fragment,e),g(R.$$.fragment,e),g(ee.$$.fragment,e),g(oe.$$.fragment,e),g(ie.$$.fragment,e),g(J.$$.fragment,e),g(de.$$.fragment,e),g(re.$$.fragment,e),g(le.$$.fragment,e),g(I.$$.fragment,e),g(ce.$$.fragment,e),g(pe.$$.fragment,e),g(me.$$.fragment,e),g(ue.$$.fragment,e),g(F.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),g(he.$$.fragment,e),g(_e.$$.fragment,e),g(be.$$.fragment,e),g(Me.$$.fragment,e),g(ve.$$.fragment,e),g(ye.$$.fragment,e),g(we.$$.fragment,e),ut=!0)},o(e){h(w.$$.fragment,e),h(X.$$.fragment,e),h(R.$$.fragment,e),h(ee.$$.fragment,e),h(oe.$$.fragment,e),h(ie.$$.fragment,e),h(J.$$.fragment,e),h(de.$$.fragment,e),h(re.$$.fragment,e),h(le.$$.fragment,e),h(I.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),h(F.$$.fragment,e),h(fe.$$.fragment,e),h(ge.$$.fragment,e),h(he.$$.fragment,e),h(_e.$$.fragment,e),h(be.$$.fragment,e),h(Me.$$.fragment,e),h(ve.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),ut=!1},d(e){e&&(o(k),o(v),o(M),o(l),o(T),o(Fe),o(H),o(Ee),o(z),o(Se),o(O),o(We),o(Q),o(He),o(ze),o(Oe),o(V),o(Qe),o(Y),o(Xe),o(K),o(Re),o(Ve),o(te),o(Ye),o(Ke),o(ne),o(et),o(tt),o(se),o(ot),o(ae),o(nt),o(it),o(st),o(b),o(at),o(dt),o($),o(rt),o(lt),o(A),o(ct),o(pt),o(N),o(mt),o(Ze)),o(c),_(w,e),_(X,e),_(R,e),_(ee,e),_(oe,e),_(ie,e),_(J,e),_(de,e),_(re),_(le),_(I),_(ce),_(pe),_(me),_(ue),_(F),_(fe),_(ge,e),_(he),_(_e),_(be,e),_(Me),_(ve),_(ye,e),_(we)}}}const Lo='{"title":"AudioLDM 2","local":"audioldm-2","sections":[{"title":"Tips","local":"tips","sections":[{"title":"Choosing a checkpoint","local":"choosing-a-checkpoint","sections":[],"depth":3},{"title":"Constructing a prompt","local":"constructing-a-prompt","sections":[],"depth":3},{"title":"Controlling inference","local":"controlling-inference","sections":[],"depth":3},{"title":"Evaluating generated waveforms:","local":"evaluating-generated-waveforms","sections":[],"depth":3}],"depth":2},{"title":"AudioLDM2Pipeline","local":"diffusers.AudioLDM2Pipeline","sections":[],"depth":2},{"title":"AudioLDM2ProjectionModel","local":"diffusers.AudioLDM2ProjectionModel","sections":[],"depth":2},{"title":"AudioLDM2UNet2DConditionModel","local":"diffusers.AudioLDM2UNet2DConditionModel","sections":[],"depth":2},{"title":"AudioPipelineOutput","local":"diffusers.AudioPipelineOutput","sections":[],"depth":2}],"depth":1}';function $o(B){return Mo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Io extends vo{constructor(c){super(),yo(this,c,$o,Ao,bo,{})}}export{Io as component};
