import{s as Jt,o as Ut,n as mt}from"../chunks/scheduler.182ea377.js";import{S as Wt,i as Zt,g as a,s as i,r as u,A as Ft,h as r,f as o,c as s,j as X,u as h,x as f,k as T,y as t,a as c,v as _,d as b,t as v,w as y}from"../chunks/index.abf12888.js";import{T as jt}from"../chunks/Tip.230e2334.js";import{D as M}from"../chunks/Docstring.93f6f462.js";import{C as zt}from"../chunks/CodeBlock.57fe6e13.js";import{E as Bt}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as ft}from"../chunks/Heading.16916d63.js";function Gt($){let l,w='🧪 Many of the SDXL ControlNet checkpoints are experimental, and there is a lot of room for improvement. Feel free to open an <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">Issue</a> and leave us feedback on how we can improve!';return{c(){l=a("p"),l.innerHTML=w},l(m){l=r(m,"P",{"data-svelte-h":!0}),f(l)!=="svelte-1q1xjpk"&&(l.innerHTML=w)},m(m,x){c(m,l,x)},p:mt,d(m){m&&o(l)}}}function Et($){let l,w='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){l=a("p"),l.innerHTML=w},l(m){l=r(m,"P",{"data-svelte-h":!0}),f(l)!=="svelte-1wmc0l4"&&(l.innerHTML=w)},m(m,x){c(m,l,x)},p:mt,d(m){m&&o(l)}}}function Ht($){let l,w="Examples:",m,x,S;return x=new zt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install opencv-python transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetXSPipeline, ControlNetXSModel, AutoencoderKL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> cv2
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;low quality, bad quality, sketches&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># initialize the models and pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet_conditioning_scale = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># recommended for good generalization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetXSModel.from_pretrained(<span class="hljs-string">&quot;UmerHA/ConrolNetXS-SDXL-canny&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLControlNetXSPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnet, vae=vae, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get canny image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.array(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>canny_image = Image.fromarray(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt, controlnet_conditioning_scale=controlnet_conditioning_scale, image=canny_image
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=a("p"),l.textContent=w,m=i(),u(x.$$.fragment)},l(g){l=r(g,"P",{"data-svelte-h":!0}),f(l)!=="svelte-kvfsh7"&&(l.textContent=w),m=s(g),h(x.$$.fragment,g)},m(g,L){c(g,l,L),c(g,m,L),_(x,g,L),S=!0},p:mt,i(g){S||(b(x.$$.fragment,g),S=!0)},o(g){v(x.$$.fragment,g),S=!1},d(g){g&&(o(l),o(m)),y(x,g)}}}function Yt($){let l,w,m,x,S,g,L,gt='ControlNet-XS was introduced in <a href="https://vislearn.github.io/ControlNet-XS/" rel="nofollow">ControlNet-XS</a> by Denis Zavadski and Carsten Rother. It is based on the observation that the control model in the <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">original ControlNet</a> can be made much smaller and still produce good results.',Se,G,ut="Like the original ControlNet model, you can provide an additional control image to condition and control Stable Diffusion generation. For example, if you provide a depth map, the ControlNet model generates an image that’ll preserve the spatial information from the depth map. It is a more flexible and accurate way to control the image generation process.",Ce,E,ht='ControlNet-XS generates images with comparable quality to a regular ControlNet, but it is 20-25% faster (<a href="https://github.com/UmerHA/controlnet-xs-benchmark/blob/main/Speed%20Benchmark.ipynb" rel="nofollow">see benchmark</a>) and uses ~45% less memory.',Xe,H,_t='Here’s the overview from the <a href="https://vislearn.github.io/ControlNet-XS/" rel="nofollow">project page</a>:',Te,Y,bt="<em>With increasing computing capabilities, current model architectures appear to follow the trend of simply upscaling all components without validating the necessity for doing so. In this project we investigate the size and architectural design of ControlNet [Zhang et al., 2023] for controlling the image generation process with stable diffusion-based models. We show that a new architecture with as little as 1% of the parameters of the base model achieves state-of-the art results, considerably better than ControlNet in terms of FID score. Hence we call it ControlNet-XS. We provide the code for controlling StableDiffusion-XL [Podell et al., 2023] (Model B, 48M Parameters) and StableDiffusion 2.1 [Rombach et al. 2022] (Model B, 14M Parameters), all under openrail license.</em>",Le,R,vt='This model was contributed by <a href="https://twitter.com/UmerHAdil" rel="nofollow">UmerHA</a>. ❤️',Ne,k,Me,I,Pe,V,De,p,A,Be,re,yt="Pipeline for text-to-image generation using Stable Diffusion XL with ControlNet-XS guidance.",Ge,le,xt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ee,pe,wt="The pipeline also inherits the following loading methods:",He,de,St='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.from_single_file">loaders.FromSingleFileMixin.from_single_file()</a> for loading <code>.ckpt</code> files</li>',Ye,N,Q,Re,ce,Ct="The call function to the pipeline for generation.",Ve,j,Ae,J,O,Qe,fe,Xt="Disables the FreeU mechanism if enabled.",Oe,U,q,qe,me,Tt=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ke,W,K,et,ge,Lt=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,tt,C,ee,ot,ue,Nt='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',nt,he,Mt="The suffixes after the scaling factors represent the stages where they are being applied.",it,_e,Pt=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,st,Z,te,at,be,Dt=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,rt,F,oe,lt,ve,$t=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,pt,z,ne,dt,ye,kt="Encodes the prompt into text encoder hidden states.",$e,ie,ke,P,se,ct,xe,It="Output class for Stable Diffusion pipelines.",Ie,we,je;return S=new ft({props:{title:"ControlNet-XS with Stable Diffusion XL",local:"controlnet-xs-with-stable-diffusion-xl",headingTag:"h1"}}),k=new jt({props:{warning:!0,$$slots:{default:[Gt]},$$scope:{ctx:$}}}),I=new jt({props:{$$slots:{default:[Et]},$$scope:{ctx:$}}}),V=new ft({props:{title:"StableDiffusionXLControlNetXSPipeline",local:"diffusers.StableDiffusionXLControlNetXSPipeline",headingTag:"h2"}}),A=new M({props:{name:"class diffusers.StableDiffusionXLControlNetXSPipeline",anchor:"diffusers.StableDiffusionXLControlNetXSPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": ControlNetXSModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIPTextModelWithProjection</a>) &#x2014;
Second frozen text-encoder
(<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>).`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.controlnet",description:`<strong>controlnet</strong> (<code>ControlNetXSModel</code> &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings should always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark</a> library to
watermark output images. If not defined, it defaults to <code>True</code> if the package is installed; otherwise no
watermarker is used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs_sd_xl.py#L94"}}),Q=new M({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"control_guidance_start",val:": float = 0.0"},{name:"control_guidance_end",val:": float = 1.0"},{name:"original_size",val:": typing.Tuple[int, int] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Tuple[int, int] = None"},{name:"negative_original_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"},{name:"negative_crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders.`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.FloatTensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be
accepted as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height
and/or width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in
<code>init</code>, images must be passed as a list such that each element of the list can be correctly batched for
input to a single ControlNet.`,name:"image"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. This is sent to <code>tokenizer_2</code>
and <code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, pooled text embeddings are generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs (prompt
weighting). If not provided, pooled <code>negative_prompt_embeds</code> are generated from <code>negative_prompt</code> input
argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(width, height)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(width, height)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs_sd_xl.py#L731",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> is
returned, otherwise a <code>tuple</code> is returned containing the output images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),j=new Bt({props:{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.example",$$slots:{default:[Ht]},$$scope:{ctx:$}}}),O=new M({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs_sd_xl.py#L727"}}),q=new M({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs_sd_xl.py#L196"}}),K=new M({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs_sd_xl.py#L213"}}),ee=new M({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs_sd_xl.py#L704"}}),te=new M({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs_sd_xl.py#L188"}}),oe=new M({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs_sd_xl.py#L204"}}),ne=new M({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": typing.Optional[str] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt_2",val:": typing.Optional[str] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs_sd_xl.py#L221"}}),ie=new ft({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),se=new M({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L11"}}),{c(){l=a("meta"),w=i(),m=a("p"),x=i(),u(S.$$.fragment),g=i(),L=a("p"),L.innerHTML=gt,Se=i(),G=a("p"),G.textContent=ut,Ce=i(),E=a("p"),E.innerHTML=ht,Xe=i(),H=a("p"),H.innerHTML=_t,Te=i(),Y=a("p"),Y.innerHTML=bt,Le=i(),R=a("p"),R.innerHTML=vt,Ne=i(),u(k.$$.fragment),Me=i(),u(I.$$.fragment),Pe=i(),u(V.$$.fragment),De=i(),p=a("div"),u(A.$$.fragment),Be=i(),re=a("p"),re.textContent=yt,Ge=i(),le=a("p"),le.innerHTML=xt,Ee=i(),pe=a("p"),pe.textContent=wt,He=i(),de=a("ul"),de.innerHTML=St,Ye=i(),N=a("div"),u(Q.$$.fragment),Re=i(),ce=a("p"),ce.textContent=Ct,Ve=i(),u(j.$$.fragment),Ae=i(),J=a("div"),u(O.$$.fragment),Qe=i(),fe=a("p"),fe.textContent=Xt,Oe=i(),U=a("div"),u(q.$$.fragment),qe=i(),me=a("p"),me.innerHTML=Tt,Ke=i(),W=a("div"),u(K.$$.fragment),et=i(),ge=a("p"),ge.innerHTML=Lt,tt=i(),C=a("div"),u(ee.$$.fragment),ot=i(),ue=a("p"),ue.innerHTML=Nt,nt=i(),he=a("p"),he.textContent=Mt,it=i(),_e=a("p"),_e.innerHTML=Pt,st=i(),Z=a("div"),u(te.$$.fragment),at=i(),be=a("p"),be.textContent=Dt,rt=i(),F=a("div"),u(oe.$$.fragment),lt=i(),ve=a("p"),ve.textContent=$t,pt=i(),z=a("div"),u(ne.$$.fragment),dt=i(),ye=a("p"),ye.textContent=kt,$e=i(),u(ie.$$.fragment),ke=i(),P=a("div"),u(se.$$.fragment),ct=i(),xe=a("p"),xe.textContent=It,Ie=i(),we=a("p"),this.h()},l(e){const n=Ft("svelte-u9bgzb",document.head);l=r(n,"META",{name:!0,content:!0}),n.forEach(o),w=s(e),m=r(e,"P",{}),X(m).forEach(o),x=s(e),h(S.$$.fragment,e),g=s(e),L=r(e,"P",{"data-svelte-h":!0}),f(L)!=="svelte-p0mo4d"&&(L.innerHTML=gt),Se=s(e),G=r(e,"P",{"data-svelte-h":!0}),f(G)!=="svelte-6nd4qa"&&(G.textContent=ut),Ce=s(e),E=r(e,"P",{"data-svelte-h":!0}),f(E)!=="svelte-161jfc5"&&(E.innerHTML=ht),Xe=s(e),H=r(e,"P",{"data-svelte-h":!0}),f(H)!=="svelte-1dkixh6"&&(H.innerHTML=_t),Te=s(e),Y=r(e,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-1e1zrpk"&&(Y.innerHTML=bt),Le=s(e),R=r(e,"P",{"data-svelte-h":!0}),f(R)!=="svelte-udfi85"&&(R.innerHTML=vt),Ne=s(e),h(k.$$.fragment,e),Me=s(e),h(I.$$.fragment,e),Pe=s(e),h(V.$$.fragment,e),De=s(e),p=r(e,"DIV",{class:!0});var d=X(p);h(A.$$.fragment,d),Be=s(d),re=r(d,"P",{"data-svelte-h":!0}),f(re)!=="svelte-1lh3w5q"&&(re.textContent=yt),Ge=s(d),le=r(d,"P",{"data-svelte-h":!0}),f(le)!=="svelte-496sm0"&&(le.innerHTML=xt),Ee=s(d),pe=r(d,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-14s6m4u"&&(pe.textContent=wt),He=s(d),de=r(d,"UL",{"data-svelte-h":!0}),f(de)!=="svelte-1h4pnzr"&&(de.innerHTML=St),Ye=s(d),N=r(d,"DIV",{class:!0});var D=X(N);h(Q.$$.fragment,D),Re=s(D),ce=r(D,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-50j04k"&&(ce.textContent=Ct),Ve=s(D),h(j.$$.fragment,D),D.forEach(o),Ae=s(d),J=r(d,"DIV",{class:!0});var ae=X(J);h(O.$$.fragment,ae),Qe=s(ae),fe=r(ae,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-psupw6"&&(fe.textContent=Xt),ae.forEach(o),Oe=s(d),U=r(d,"DIV",{class:!0});var Je=X(U);h(q.$$.fragment,Je),qe=s(Je),me=r(Je,"P",{"data-svelte-h":!0}),f(me)!=="svelte-1s3c06i"&&(me.innerHTML=Tt),Je.forEach(o),Ke=s(d),W=r(d,"DIV",{class:!0});var Ue=X(W);h(K.$$.fragment,Ue),et=s(Ue),ge=r(Ue,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-pkn4ui"&&(ge.innerHTML=Lt),Ue.forEach(o),tt=s(d),C=r(d,"DIV",{class:!0});var B=X(C);h(ee.$$.fragment,B),ot=s(B),ue=r(B,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-1f3tmq1"&&(ue.innerHTML=Nt),nt=s(B),he=r(B,"P",{"data-svelte-h":!0}),f(he)!=="svelte-xjijlp"&&(he.textContent=Mt),it=s(B),_e=r(B,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-hy0nzs"&&(_e.innerHTML=Pt),B.forEach(o),st=s(d),Z=r(d,"DIV",{class:!0});var We=X(Z);h(te.$$.fragment,We),at=s(We),be=r(We,"P",{"data-svelte-h":!0}),f(be)!=="svelte-14bnrb6"&&(be.textContent=Dt),We.forEach(o),rt=s(d),F=r(d,"DIV",{class:!0});var Ze=X(F);h(oe.$$.fragment,Ze),lt=s(Ze),ve=r(Ze,"P",{"data-svelte-h":!0}),f(ve)!=="svelte-1xwrf7t"&&(ve.textContent=$t),Ze.forEach(o),pt=s(d),z=r(d,"DIV",{class:!0});var Fe=X(z);h(ne.$$.fragment,Fe),dt=s(Fe),ye=r(Fe,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-16q0ax1"&&(ye.textContent=kt),Fe.forEach(o),d.forEach(o),$e=s(e),h(ie.$$.fragment,e),ke=s(e),P=r(e,"DIV",{class:!0});var ze=X(P);h(se.$$.fragment,ze),ct=s(ze),xe=r(ze,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-1qpjiuf"&&(xe.textContent=It),ze.forEach(o),Ie=s(e),we=r(e,"P",{}),X(we).forEach(o),this.h()},h(){T(l,"name","hf:doc:metadata"),T(l,"content",Rt),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){t(document.head,l),c(e,w,n),c(e,m,n),c(e,x,n),_(S,e,n),c(e,g,n),c(e,L,n),c(e,Se,n),c(e,G,n),c(e,Ce,n),c(e,E,n),c(e,Xe,n),c(e,H,n),c(e,Te,n),c(e,Y,n),c(e,Le,n),c(e,R,n),c(e,Ne,n),_(k,e,n),c(e,Me,n),_(I,e,n),c(e,Pe,n),_(V,e,n),c(e,De,n),c(e,p,n),_(A,p,null),t(p,Be),t(p,re),t(p,Ge),t(p,le),t(p,Ee),t(p,pe),t(p,He),t(p,de),t(p,Ye),t(p,N),_(Q,N,null),t(N,Re),t(N,ce),t(N,Ve),_(j,N,null),t(p,Ae),t(p,J),_(O,J,null),t(J,Qe),t(J,fe),t(p,Oe),t(p,U),_(q,U,null),t(U,qe),t(U,me),t(p,Ke),t(p,W),_(K,W,null),t(W,et),t(W,ge),t(p,tt),t(p,C),_(ee,C,null),t(C,ot),t(C,ue),t(C,nt),t(C,he),t(C,it),t(C,_e),t(p,st),t(p,Z),_(te,Z,null),t(Z,at),t(Z,be),t(p,rt),t(p,F),_(oe,F,null),t(F,lt),t(F,ve),t(p,pt),t(p,z),_(ne,z,null),t(z,dt),t(z,ye),c(e,$e,n),_(ie,e,n),c(e,ke,n),c(e,P,n),_(se,P,null),t(P,ct),t(P,xe),c(e,Ie,n),c(e,we,n),je=!0},p(e,[n]){const d={};n&2&&(d.$$scope={dirty:n,ctx:e}),k.$set(d);const D={};n&2&&(D.$$scope={dirty:n,ctx:e}),I.$set(D);const ae={};n&2&&(ae.$$scope={dirty:n,ctx:e}),j.$set(ae)},i(e){je||(b(S.$$.fragment,e),b(k.$$.fragment,e),b(I.$$.fragment,e),b(V.$$.fragment,e),b(A.$$.fragment,e),b(Q.$$.fragment,e),b(j.$$.fragment,e),b(O.$$.fragment,e),b(q.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(oe.$$.fragment,e),b(ne.$$.fragment,e),b(ie.$$.fragment,e),b(se.$$.fragment,e),je=!0)},o(e){v(S.$$.fragment,e),v(k.$$.fragment,e),v(I.$$.fragment,e),v(V.$$.fragment,e),v(A.$$.fragment,e),v(Q.$$.fragment,e),v(j.$$.fragment,e),v(O.$$.fragment,e),v(q.$$.fragment,e),v(K.$$.fragment,e),v(ee.$$.fragment,e),v(te.$$.fragment,e),v(oe.$$.fragment,e),v(ne.$$.fragment,e),v(ie.$$.fragment,e),v(se.$$.fragment,e),je=!1},d(e){e&&(o(w),o(m),o(x),o(g),o(L),o(Se),o(G),o(Ce),o(E),o(Xe),o(H),o(Te),o(Y),o(Le),o(R),o(Ne),o(Me),o(Pe),o(De),o(p),o($e),o(ke),o(P),o(Ie),o(we)),o(l),y(S,e),y(k,e),y(I,e),y(V,e),y(A),y(Q),y(j),y(O),y(q),y(K),y(ee),y(te),y(oe),y(ne),y(ie,e),y(se)}}}const Rt='{"title":"ControlNet-XS with Stable Diffusion XL","local":"controlnet-xs-with-stable-diffusion-xl","sections":[{"title":"StableDiffusionXLControlNetXSPipeline","local":"diffusers.StableDiffusionXLControlNetXSPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function Vt($){return Ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oo extends Wt{constructor(l){super(),Zt(this,l,Vt,Yt,Jt,{})}}export{oo as component};
