import{s as tt,n as lt,o as nt}from"../chunks/scheduler.182ea377.js";import{S as it,i as at,g as s,s as i,r,A as st,h as p,f as l,c as a,j as Ke,u as c,x as o,k as et,y as pt,a as n,v as m,d,t as f,w as u}from"../chunks/index.abf12888.js";import{C as y}from"../chunks/CodeBlock.57fe6e13.js";import{H as b}from"../chunks/Heading.16916d63.js";function ot(xe){let h,K,P,ee,M,te,g,Ie='The <code>train_t2i_adapter_sdxl.py</code> script (as shown below) shows how to implement the <a href="https://hf.co/papers/2302.08453" rel="nofollow">T2I-Adapter training procedure</a> for <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">Stable Diffusion XL</a>.',le,w,ne,U,ie,T,Xe="Before running the scripts, make sure to install the library’s training dependencies:",ae,Z,Ye="<strong>Important</strong>",se,J,Fe="To make sure you can successfully run the latest versions of the example scripts, we highly recommend <strong>installing from source</strong> and keeping the install up to date as we update the example scripts frequently and install some example-specific requirements. To do this, execute the following steps in a new virtual environment:",pe,$,oe,_,ke="Then cd in the <code>examples/t2i_adapter</code> folder and run",re,G,ce,R,He='And initialize an <a href="https://github.com/huggingface/accelerate/" rel="nofollow">🤗Accelerate</a> environment with:',me,j,de,v,Le="Or for a default accelerate configuration without answering questions about your environment",fe,W,ue,C,Ee="Or if your environment doesn’t support an interactive shell (e.g., a notebook)",he,V,ye,B,Ne="When running <code>accelerate config</code>, if we specify torch compile mode to True there can be dramatic speedups.",be,x,Me,I,ze='The original dataset is hosted in the <a href="https://huggingface.co/lllyasviel/ControlNet/blob/main/training/fill50k.zip" rel="nofollow">ControlNet repo</a>. We re-uploaded it to be compatible with <code>datasets</code> <a href="https://huggingface.co/datasets/fusing/fill50k" rel="nofollow">here</a>. Note that <code>datasets</code> handles dataloading within the training script.',ge,X,we,Y,Se="Our training examples use two test conditioning images. They can be downloaded by running",Ue,F,Te,k,Qe="Then run <code>huggingface-cli login</code> to log into your Hugging Face account. This is needed to be able to push the trained T2IAdapter parameters to Hugging Face Hub.",Ze,H,Je,L,Ae="To better track our training experiments, we’re using the following flags in the command above:",$e,E,qe="<li><code>report_to=&quot;wandb</code> will ensure the training runs are tracked on Weights and Biases. To use it, be sure to install <code>wandb</code> with <code>pip install wandb</code>.</li> <li><code>validation_image</code>, <code>validation_prompt</code>, and <code>validation_steps</code> to allow the script to do a few validation inference runs. This allows us to qualitatively check if the training is progressing as expected.</li>",_e,N,De="Our experiments were conducted on a single 40GB A100 GPU.",Ge,z,Re,S,Pe="Once training is done, we can perform inference like so:",je,Q,ve,A,We,q,Ce,D,Oe='SDXL’s VAE is known to suffer from numerical instability issues. This is why we also expose a CLI argument namely <code>--pretrained_vae_model_name_or_path</code> that lets you specify the location of a better VAE (such as <a href="https://huggingface.co/madebyollin/sdxl-vae-fp16-fix" rel="nofollow">this one</a>).',Ve,O,Be;return M=new b({props:{title:"T2I-Adapters for Stable Diffusion XL (SDXL)",local:"t2i-adapters-for-stable-diffusion-xl-sdxl",headingTag:"h1"}}),w=new b({props:{title:"Running locally with PyTorch",local:"running-locally-with-pytorch",headingTag:"h2"}}),U=new b({props:{title:"Installing the dependencies",local:"installing-the-dependencies",headingTag:"h3"}}),$=new y({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC1lJTIwLg==",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install -e .`,wrap:!1}}),G=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzX3NkeGwudHh0",highlighted:"pip install -r requirements_sdxl.txt",wrap:!1}}),j=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),W=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),V=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config
write_basic_config()`,wrap:!1}}),x=new b({props:{title:"Circle filling dataset",local:"circle-filling-dataset",headingTag:"h2"}}),X=new b({props:{title:"Training",local:"training",headingTag:"h2"}}),F=new y({props:{code:"d2dldCUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmNvbnRyb2xuZXRfdHJhaW5pbmclMkZjb25kaXRpb25pbmdfaW1hZ2VfMS5wbmclMEElMEF3Z2V0JTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGY29udHJvbG5ldF90cmFpbmluZyUyRmNvbmRpdGlvbmluZ19pbWFnZV8yLnBuZw==",highlighted:`wget https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/conditioning_image_1.png

wget https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/conditioning_image_2.png`,wrap:!1}}),H=new y({props:{code:"ZXhwb3J0JTIwTU9ERUxfRElSJTNEJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBZXhwb3J0JTIwT1VUUFVUX0RJUiUzRCUyMnBhdGglMjB0byUyMHNhdmUlMjBtb2RlbCUyMiUwQSUwQWFjY2VsZXJhdGUlMjBsYXVuY2glMjB0cmFpbl90MmlfYWRhcHRlcl9zZHhsLnB5JTIwJTVDJTBBJTIwLS1wcmV0cmFpbmVkX21vZGVsX25hbWVfb3JfcGF0aCUzRCUyNE1PREVMX0RJUiUyMCU1QyUwQSUyMC0tb3V0cHV0X2RpciUzRCUyNE9VVFBVVF9ESVIlMjAlNUMlMEElMjAtLWRhdGFzZXRfbmFtZSUzRGZ1c2luZyUyRmZpbGw1MGslMjAlNUMlMEElMjAtLW1peGVkX3ByZWNpc2lvbiUzRCUyMmZwMTYlMjIlMjAlNUMlMEElMjAtLXJlc29sdXRpb24lM0QxMDI0JTIwJTVDJTBBJTIwLS1sZWFybmluZ19yYXRlJTNEMWUtNSUyMCU1QyUwQSUyMC0tbWF4X3RyYWluX3N0ZXBzJTNEMTUwMDAlMjAlNUMlMEElMjAtLXZhbGlkYXRpb25faW1hZ2UlMjAlMjIuJTJGY29uZGl0aW9uaW5nX2ltYWdlXzEucG5nJTIyJTIwJTIyLiUyRmNvbmRpdGlvbmluZ19pbWFnZV8yLnBuZyUyMiUyMCU1QyUwQSUyMC0tdmFsaWRhdGlvbl9wcm9tcHQlMjAlMjJyZWQlMjBjaXJjbGUlMjB3aXRoJTIwYmx1ZSUyMGJhY2tncm91bmQlMjIlMjAlMjJjeWFuJTIwY2lyY2xlJTIwd2l0aCUyMGJyb3duJTIwZmxvcmFsJTIwYmFja2dyb3VuZCUyMiUyMCU1QyUwQSUyMC0tdmFsaWRhdGlvbl9zdGVwcyUzRDEwMCUyMCU1QyUwQSUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMjAlNUMlMEElMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAtLXJlcG9ydF90byUzRCUyMndhbmRiJTIyJTIwJTVDJTBBJTIwLS1zZWVkJTNENDIlMjAlNUMlMEElMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_DIR=<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path to save model&quot;</span>

accelerate launch train_t2i_adapter_sdxl.py \\
 --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_DIR</span> \\
 --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
 --dataset_name=fusing/fill50k \\
 --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> \\
 --resolution=1024 \\
 --learning_rate=1e-5 \\
 --max_train_steps=15000 \\
 --validation_image <span class="hljs-string">&quot;./conditioning_image_1.png&quot;</span> <span class="hljs-string">&quot;./conditioning_image_2.png&quot;</span> \\
 --validation_prompt <span class="hljs-string">&quot;red circle with blue background&quot;</span> <span class="hljs-string">&quot;cyan circle with brown floral background&quot;</span> \\
 --validation_steps=100 \\
 --train_batch_size=1 \\
 --gradient_accumulation_steps=4 \\
 --report_to=<span class="hljs-string">&quot;wandb&quot;</span> \\
 --seed=42 \\
 --push_to_hub`,wrap:!1}}),z=new b({props:{title:"Inference",local:"inference",headingTag:"h3"}}),Q=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMQWRhcHRlclBpcGVsaW5lJTJDJTIwVDJJQWRhcHRlciUyQyUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXJUZXN0JTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWxfcGF0aCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUwQWFkYXB0ZXJfcGF0aCUyMCUzRCUyMCUyMnBhdGglMjB0byUyMGFkYXB0ZXIlMjIlMEElMEFhZGFwdGVyJTIwJTNEJTIwVDJJQWRhcHRlci5mcm9tX3ByZXRyYWluZWQoYWRhcHRlcl9wYXRoJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEFkYXB0ZXJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwYmFzZV9tb2RlbF9wYXRoJTJDJTIwYWRhcHRlciUzRGFkYXB0ZXIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBJTBBJTIzJTIwc3BlZWQlMjB1cCUyMGRpZmZ1c2lvbiUyMHByb2Nlc3MlMjB3aXRoJTIwZmFzdGVyJTIwc2NoZWR1bGVyJTIwYW5kJTIwbWVtb3J5JTIwb3B0aW1pemF0aW9uJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBFdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyVGVzdC5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweGZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIwd2hlbiUyMHVzaW5nJTIwVG9yY2glMjAyLjAuJTBBcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUyMyUyMG1lbW9yeSUyMG9wdGltaXphdGlvbi4lMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyLiUyRmNvbmRpdGlvbmluZ19pbWFnZV8xLnBuZyUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJwYWxlJTIwZ29sZGVuJTIwcm9kJTIwY2lyY2xlJTIwd2l0aCUyMG9sZCUyMGxhY2UlMjBiYWNrZ3JvdW5kJTIyJTBBJTBBJTIzJTIwZ2VuZXJhdGUlMjBpbWFnZSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMGltYWdlJTNEY29udHJvbF9pbWFnZSUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyLiUyRm91dHB1dC5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLAdapterPipeline, T2IAdapter, EulerAncestralDiscreteSchedulerTest
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

base_model_path = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
adapter_path = <span class="hljs-string">&quot;path to adapter&quot;</span>

adapter = T2IAdapter.from_pretrained(adapter_path, torch_dtype=torch.float16)
pipe = StableDiffusionXLAdapterPipeline.from_pretrained(
    base_model_path, adapter=adapter, torch_dtype=torch.float16
)

<span class="hljs-comment"># speed up diffusion process with faster scheduler and memory optimization</span>
pipe.scheduler = EulerAncestralDiscreteSchedulerTest.from_config(pipe.scheduler.config)
<span class="hljs-comment"># remove following line if xformers is not installed or when using Torch 2.0.</span>
pipe.enable_xformers_memory_efficient_attention()
<span class="hljs-comment"># memory optimization.</span>
pipe.enable_model_cpu_offload()

control_image = load_image(<span class="hljs-string">&quot;./conditioning_image_1.png&quot;</span>)
prompt = <span class="hljs-string">&quot;pale golden rod circle with old lace background&quot;</span>

<span class="hljs-comment"># generate image</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt, num_inference_steps=<span class="hljs-number">20</span>, generator=generator, image=control_image
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;./output.png&quot;</span>)`,wrap:!1}}),A=new b({props:{title:"Notes",local:"notes",headingTag:"h2"}}),q=new b({props:{title:"Specifying a better VAE",local:"specifying-a-better-vae",headingTag:"h3"}}),{c(){h=s("meta"),K=i(),P=s("p"),ee=i(),r(M.$$.fragment),te=i(),g=s("p"),g.innerHTML=Ie,le=i(),r(w.$$.fragment),ne=i(),r(U.$$.fragment),ie=i(),T=s("p"),T.textContent=Xe,ae=i(),Z=s("p"),Z.innerHTML=Ye,se=i(),J=s("p"),J.innerHTML=Fe,pe=i(),r($.$$.fragment),oe=i(),_=s("p"),_.innerHTML=ke,re=i(),r(G.$$.fragment),ce=i(),R=s("p"),R.innerHTML=He,me=i(),r(j.$$.fragment),de=i(),v=s("p"),v.textContent=Le,fe=i(),r(W.$$.fragment),ue=i(),C=s("p"),C.textContent=Ee,he=i(),r(V.$$.fragment),ye=i(),B=s("p"),B.innerHTML=Ne,be=i(),r(x.$$.fragment),Me=i(),I=s("p"),I.innerHTML=ze,ge=i(),r(X.$$.fragment),we=i(),Y=s("p"),Y.textContent=Se,Ue=i(),r(F.$$.fragment),Te=i(),k=s("p"),k.innerHTML=Qe,Ze=i(),r(H.$$.fragment),Je=i(),L=s("p"),L.textContent=Ae,$e=i(),E=s("ul"),E.innerHTML=qe,_e=i(),N=s("p"),N.textContent=De,Ge=i(),r(z.$$.fragment),Re=i(),S=s("p"),S.textContent=Pe,je=i(),r(Q.$$.fragment),ve=i(),r(A.$$.fragment),We=i(),r(q.$$.fragment),Ce=i(),D=s("p"),D.innerHTML=Oe,Ve=i(),O=s("p"),this.h()},l(e){const t=st("svelte-u9bgzb",document.head);h=p(t,"META",{name:!0,content:!0}),t.forEach(l),K=a(e),P=p(e,"P",{}),Ke(P).forEach(l),ee=a(e),c(M.$$.fragment,e),te=a(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1n0bgfv"&&(g.innerHTML=Ie),le=a(e),c(w.$$.fragment,e),ne=a(e),c(U.$$.fragment,e),ie=a(e),T=p(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-19lpyev"&&(T.textContent=Xe),ae=a(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-hai21j"&&(Z.innerHTML=Ye),se=a(e),J=p(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-yv8b1i"&&(J.innerHTML=Fe),pe=a(e),c($.$$.fragment,e),oe=a(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-be6uvc"&&(_.innerHTML=ke),re=a(e),c(G.$$.fragment,e),ce=a(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1apictl"&&(R.innerHTML=He),me=a(e),c(j.$$.fragment,e),de=a(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1gl04sb"&&(v.textContent=Le),fe=a(e),c(W.$$.fragment,e),ue=a(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1w15gal"&&(C.textContent=Ee),he=a(e),c(V.$$.fragment,e),ye=a(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1sdc5tr"&&(B.innerHTML=Ne),be=a(e),c(x.$$.fragment,e),Me=a(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1i4urlz"&&(I.innerHTML=ze),ge=a(e),c(X.$$.fragment,e),we=a(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1aweqq1"&&(Y.textContent=Se),Ue=a(e),c(F.$$.fragment,e),Te=a(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1bqr4va"&&(k.innerHTML=Qe),Ze=a(e),c(H.$$.fragment,e),Je=a(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-gpe60h"&&(L.textContent=Ae),$e=a(e),E=p(e,"UL",{"data-svelte-h":!0}),o(E)!=="svelte-1ennrj"&&(E.innerHTML=qe),_e=a(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-p3jdhz"&&(N.textContent=De),Ge=a(e),c(z.$$.fragment,e),Re=a(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-qvz1ik"&&(S.textContent=Pe),je=a(e),c(Q.$$.fragment,e),ve=a(e),c(A.$$.fragment,e),We=a(e),c(q.$$.fragment,e),Ce=a(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-38fryi"&&(D.innerHTML=Oe),Ve=a(e),O=p(e,"P",{}),Ke(O).forEach(l),this.h()},h(){et(h,"name","hf:doc:metadata"),et(h,"content",rt)},m(e,t){pt(document.head,h),n(e,K,t),n(e,P,t),n(e,ee,t),m(M,e,t),n(e,te,t),n(e,g,t),n(e,le,t),m(w,e,t),n(e,ne,t),m(U,e,t),n(e,ie,t),n(e,T,t),n(e,ae,t),n(e,Z,t),n(e,se,t),n(e,J,t),n(e,pe,t),m($,e,t),n(e,oe,t),n(e,_,t),n(e,re,t),m(G,e,t),n(e,ce,t),n(e,R,t),n(e,me,t),m(j,e,t),n(e,de,t),n(e,v,t),n(e,fe,t),m(W,e,t),n(e,ue,t),n(e,C,t),n(e,he,t),m(V,e,t),n(e,ye,t),n(e,B,t),n(e,be,t),m(x,e,t),n(e,Me,t),n(e,I,t),n(e,ge,t),m(X,e,t),n(e,we,t),n(e,Y,t),n(e,Ue,t),m(F,e,t),n(e,Te,t),n(e,k,t),n(e,Ze,t),m(H,e,t),n(e,Je,t),n(e,L,t),n(e,$e,t),n(e,E,t),n(e,_e,t),n(e,N,t),n(e,Ge,t),m(z,e,t),n(e,Re,t),n(e,S,t),n(e,je,t),m(Q,e,t),n(e,ve,t),m(A,e,t),n(e,We,t),m(q,e,t),n(e,Ce,t),n(e,D,t),n(e,Ve,t),n(e,O,t),Be=!0},p:lt,i(e){Be||(d(M.$$.fragment,e),d(w.$$.fragment,e),d(U.$$.fragment,e),d($.$$.fragment,e),d(G.$$.fragment,e),d(j.$$.fragment,e),d(W.$$.fragment,e),d(V.$$.fragment,e),d(x.$$.fragment,e),d(X.$$.fragment,e),d(F.$$.fragment,e),d(H.$$.fragment,e),d(z.$$.fragment,e),d(Q.$$.fragment,e),d(A.$$.fragment,e),d(q.$$.fragment,e),Be=!0)},o(e){f(M.$$.fragment,e),f(w.$$.fragment,e),f(U.$$.fragment,e),f($.$$.fragment,e),f(G.$$.fragment,e),f(j.$$.fragment,e),f(W.$$.fragment,e),f(V.$$.fragment,e),f(x.$$.fragment,e),f(X.$$.fragment,e),f(F.$$.fragment,e),f(H.$$.fragment,e),f(z.$$.fragment,e),f(Q.$$.fragment,e),f(A.$$.fragment,e),f(q.$$.fragment,e),Be=!1},d(e){e&&(l(K),l(P),l(ee),l(te),l(g),l(le),l(ne),l(ie),l(T),l(ae),l(Z),l(se),l(J),l(pe),l(oe),l(_),l(re),l(ce),l(R),l(me),l(de),l(v),l(fe),l(ue),l(C),l(he),l(ye),l(B),l(be),l(Me),l(I),l(ge),l(we),l(Y),l(Ue),l(Te),l(k),l(Ze),l(Je),l(L),l($e),l(E),l(_e),l(N),l(Ge),l(Re),l(S),l(je),l(ve),l(We),l(Ce),l(D),l(Ve),l(O)),l(h),u(M,e),u(w,e),u(U,e),u($,e),u(G,e),u(j,e),u(W,e),u(V,e),u(x,e),u(X,e),u(F,e),u(H,e),u(z,e),u(Q,e),u(A,e),u(q,e)}}}const rt='{"title":"T2I-Adapters for Stable Diffusion XL (SDXL)","local":"t2i-adapters-for-stable-diffusion-xl-sdxl","sections":[{"title":"Running locally with PyTorch","local":"running-locally-with-pytorch","sections":[{"title":"Installing the dependencies","local":"installing-the-dependencies","sections":[],"depth":3}],"depth":2},{"title":"Circle filling dataset","local":"circle-filling-dataset","sections":[],"depth":2},{"title":"Training","local":"training","sections":[{"title":"Inference","local":"inference","sections":[],"depth":3}],"depth":2},{"title":"Notes","local":"notes","sections":[{"title":"Specifying a better VAE","local":"specifying-a-better-vae","sections":[],"depth":3}],"depth":2}],"depth":1}';function ct(xe){return nt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ht extends it{constructor(h){super(),at(this,h,ct,ot,tt,{})}}export{ht as component};
