import{s as Ad,n as Rd,o as Ud}from"../chunks/scheduler.b108d059.js";import{S as zd,i as Dd,g as l,s as o,r as p,A as Bd,h as d,f as r,c as a,j as f,u as m,x as c,k as i,y as Wd,a as s,v as n,d as u,t as h,w as _}from"../chunks/index.008de539.js";import{C as al}from"../chunks/CodeBlock.3968c746.js";import{H as g}from"../chunks/Heading.88bfeb84.js";function Nd(ll){let x,dr,ar,cr,T,ir,b,pr,y,dl="Processors are used to prepare non-textual inputs (e.g., image or audio) for a model.",mr,v,cl="<strong>Example:</strong> Using a <code>WhisperProcessor</code> to prepare an audio input for a model.",nr,M,ur,$,il='<li><a href="#module_processors">processors</a><ul><li><em>static</em><ul><li><a href="#module_processors.FeatureExtractor">.FeatureExtractor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.FeatureExtractor_new"><code>new FeatureExtractor(config)</code></a></li></ul></li> <li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li> <li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li> <li><a href="#module_processors.Processor">.Processor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.WhisperProcessor">.WhisperProcessor</a> ⇐ <code>Processor</code><ul><li><a href="#module_processors.WhisperProcessor+_call"><code>._call(audio)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.AutoProcessor">.AutoProcessor</a><ul><li><a href="#module_processors.AutoProcessor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_processors..center_to_corners_format"><code>~center_to_corners_format(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_processors..HeightWidth"><code>~HeightWidth</code></a> : <code>*</code></li> <li><a href="#module_processors..ImageFeatureExtractorResult"><code>~ImageFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..PreprocessedImage"><code>~PreprocessedImage</code></a> : <code>object</code></li> <li><a href="#module_processors..DetrFeatureExtractorResult"><code>~DetrFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..SamImageProcessorResult"><code>~SamImageProcessorResult</code></a> : <code>object</code></li></ul></li></ul></li>',hr,_r,fr,w,gr,E,xr,C,pl="Base class for feature extractors.",Tr,J,ml='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',br,yr,vr,P,Mr,H,$r,k,nl="Constructs a new FeatureExtractor instance.",wr,j,ul="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td></tr></tbody>",Er,Cr,Jr,I,Pr,F,Hr,L,hl="Feature extractor for image models.",kr,A,_l='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>FeatureExtractor</code>',jr,R,fl='<li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li>',Ir,Fr,Lr,U,Ar,z,Rr,D,gl="Constructs a new ImageFeatureExtractor instance.",Ur,B,xl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td> </tr><tr><td>config.image_mean</td><td><code>Array.&lt;number&gt;</code></td><td><p>The mean values for image normalization.</p></td> </tr><tr><td>config.image_std</td><td><code>Array.&lt;number&gt;</code></td><td><p>The standard deviation values for image normalization.</p></td> </tr><tr><td>config.do_rescale</td><td><code>boolean</code></td><td><p>Whether to rescale the image pixel values to the [0,1] range.</p></td> </tr><tr><td>config.rescale_factor</td><td><code>number</code></td><td><p>The factor to use for rescaling the image pixel values.</p></td> </tr><tr><td>config.do_normalize</td><td><code>boolean</code></td><td><p>Whether to normalize the image pixel values.</p></td> </tr><tr><td>config.do_resize</td><td><code>boolean</code></td><td><p>Whether to resize the image.</p></td> </tr><tr><td>config.resample</td><td><code>number</code></td><td><p>What method to use for resampling.</p></td> </tr><tr><td>config.size</td><td><code>number</code></td><td><p>The size to resize the image to.</p></td></tr></tbody>",zr,Dr,Br,W,Wr,N,Nr,G,Tl=`Resize the image to make a thumbnail. The image is resized so that no dimension is larger than any
corresponding dimension of the specified size.`,Gr,Z,bl='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',Zr,Q,yl="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be resized.</p></td> </tr><tr><td>size</td><td><code>Object</code></td><td></td><td><p>The size <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> to resize the image to.</p></td> </tr><tr><td>[resample]</td><td><code>string</code> | <code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code></td><td><code>2</code></td><td><p>The resampling filter to use.</p></td></tr></tbody>",Qr,Xr,Vr,X,Yr,V,Sr,Y,vl="Crops the margin of the image. Gray pixels are considered margin (i.e., pixels with a value below the threshold).",Kr,S,Ml='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The cropped image.',qr,K,$l="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be cropped.</p></td> </tr><tr><td>gray_threshold</td><td><code>number</code></td><td><code>200</code></td><td><p>Value below which pixels are considered to be gray.</p></td></tr></tbody>",Or,es,ts,q,rs,O,ss,ee,wl="Pad the image by a certain amount.",os,te,El='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The padded pixel data and image dimensions.',as,re,Cl="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td></td><td><p>The pixel data to pad.</p></td> </tr><tr><td>imgDims</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The dimensions of the image.</p></td> </tr><tr><td>padSize</td><td><code>*</code></td><td></td><td><p>The dimensions of the padded image.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for padding.</p></td> </tr><tr><td>[options.mode]</td><td><code>&#39;constant&#39;</code> | <code>&#39;symmetric&#39;</code></td><td><code>&#39;constant&#39;</code></td><td><p>The type of padding to add.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to center the image.</p></td> </tr><tr><td>[options.constant_values]</td><td><code>number</code></td><td><code>0</code></td><td><p>The constant value to use for padding.</p></td></tr></tbody>",ls,ds,cs,se,is,oe,ps,ae,Jl="Rescale the image’ pixel values by <code>this.rescale_factor</code>.",ms,le,Pl='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a>',ns,de,Hl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td><p>The pixel data to rescale.</p></td></tr></tbody>",us,hs,_s,ce,fs,ie,gs,pe,kl="Preprocesses the given image.",xs,me,jl='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;PreprocessedImage&gt;</code> - The preprocessed image.',Ts,ne,Il="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to preprocess.</p></td> </tr><tr><td>overrides</td><td><code>Object</code></td><td><p>The overrides for the preprocessing options.</p></td></tr></tbody>",bs,ys,vs,ue,Ms,he,$s,_e,Fl=`Calls the feature extraction process on an array of images,
preprocesses each image, and concatenates the resulting
features into a single Tensor.`,ws,fe,Ll='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values (and other metadata) of the preprocessed images.',Es,ge,Al="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",Cs,Js,Ps,xe,Hs,Te,ks,be,Rl="Detr Feature Extractor.",js,ye,Ul='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>ImageFeatureExtractor</code>',Is,ve,zl='<li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li>',Fs,Ls,As,Me,Rs,$e,Us,we,Dl=`Calls the feature extraction process on an array of images, preprocesses
each image, and concatenates the resulting features into a single Tensor.`,zs,Ee,Bl='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values of the preprocessed images.',Ds,Ce,Wl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td></tr></tbody>",Bs,Ws,Ns,Je,Gs,Pe,Zs,He,Nl='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',Qs,Xs,Vs,ke,Ys,je,Ss,Ie,Gl="Binarize the given masks using <code>object_mask_threshold</code>, it returns the associated values of <code>masks</code>, <code>scores</code> and <code>labels</code>.",Ks,Fe,Zl='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The binarized masks, the scores, and the labels.',qs,Le,Ql="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>class_logits</td><td><code>Tensor</code></td><td><p>The class logits.</p></td> </tr><tr><td>mask_logits</td><td><code>Tensor</code></td><td><p>The mask logits.</p></td> </tr><tr><td>object_mask_threshold</td><td><code>number</code></td><td><p>A number between 0 and 1 used to binarize the masks.</p></td> </tr><tr><td>num_labels</td><td><code>number</code></td><td><p>The number of labels.</p></td></tr></tbody>",Os,eo,to,Ae,ro,Re,so,Ue,Xl="Checks whether the segment is valid or not.",oo,ze,Vl='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - Whether the segment is valid or not, and the indices of the valid labels.',ao,De,Yl="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_labels</td><td><code>Int32Array</code></td><td></td><td><p>Labels for each pixel in the mask.</p></td> </tr><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>Probabilities for each pixel in the masks.</p></td> </tr><tr><td>k</td><td><code>number</code></td><td></td><td><p>The class id of the segment.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold.</p></td></tr></tbody>",lo,co,io,Be,po,We,mo,Ne,Sl="Computes the segments.",no,Ge,Kl='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The computed segments.',uo,Ze,ql="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>The mask probabilities.</p></td> </tr><tr><td>pred_scores</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted scores.</p></td> </tr><tr><td>pred_labels</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted labels.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td></td><td><p>The overlap mask area threshold.</p></td> </tr><tr><td>label_ids_to_fuse</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The label ids to fuse.</p></td> </tr><tr><td>target_size</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>The target size of the image.</p></td></tr></tbody>",ho,_o,fo,Qe,go,Xe,xo,Ve,Ol="Post-process the model output to generate the final panoptic segmentation.",To,Ye,ed='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',bo,Se,td="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>outputs</td><td><code>*</code></td><td></td><td><p>The model output to post process</p></td> </tr><tr><td>[threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The probability score threshold to keep predicted instance masks.</p></td> </tr><tr><td>[mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold to merge or discard small disconnected parts within each binary instance mask.</p></td> </tr><tr><td>[label_ids_to_fuse]</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The labels in this state will have all their instances be fused together.</p></td> </tr><tr><td>[target_sizes]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>The target sizes to resize the masks to.</p></td></tr></tbody>",yo,vo,Mo,Ke,$o,qe,wo,Oe,rd="Represents a Processor that extracts features from an input.",Eo,et,sd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',Co,tt,od='<li><a href="#module_processors.Processor">.Processor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',Jo,Po,Ho,rt,ko,st,jo,ot,ad="Creates a new Processor with the given feature extractor.",Io,at,ld="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>feature_extractor</td><td><code>FeatureExtractor</code></td><td><p>The function used to extract features from the input.</p></td></tr></tbody>",Fo,Lo,Ao,lt,Ro,dt,Uo,ct,dd="Calls the feature_extractor function with the given input.",zo,it,cd='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',Do,pt,id="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>any</code></td><td><p>The input to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",Bo,Wo,No,mt,Go,nt,Zo,ut,pd="Represents a WhisperProcessor that extracts features from an audio input.",Qo,ht,md='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Processor</code>',Xo,Vo,Yo,_t,So,ft,Ko,gt,nd="Calls the feature_extractor function with the given audio input.",qo,xt,ud='<strong>Kind</strong>: instance method of <a href="#module_processors.WhisperProcessor"><code>WhisperProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',Oo,Tt,hd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td><p>The audio input to extract features from.</p></td></tr></tbody>",ea,ta,ra,bt,sa,yt,oa,vt,_d=`Helper class which is used to instantiate pretrained processors with the <code>from_pretrained</code> function.
The chosen processor class is determined by the type specified in the processor config.`,aa,Mt,fd="<strong>Example:</strong> Load a processor using <code>from_pretrained</code>.",la,$t,da,wt,gd="<strong>Example:</strong> Run an image through a processor.",ca,Et,ia,Ct,xd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a>',pa,ma,na,Jt,ua,Pt,ha,Ht,Td="Instantiate one of the processor classes of the library from a pretrained model.",_a,kt,bd=`The processor class to instantiate is selected based on the <code>feature_extractor_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible)`,fa,jt,yd='<strong>Kind</strong>: static method of <a href="#module_processors.AutoProcessor"><code>AutoProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Processor&gt;</code> - A new instance of the Processor class.',ga,It,vd=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pretrained_model_name_or_path</td><td><code>string</code></td><td><p>The name or path of the pretrained model. Can be either:</p> <ul><li>A string, the <em>model id</em> of a pretrained processor hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li> <li>A path to a <em>directory</em> containing processor files, e.g., <code>./my_model_directory/</code>.</li></ul></td> </tr><tr><td>options</td><td><code>*</code></td><td><p>Additional options for loading the processor.</p></td></tr></tbody>`,xa,Ta,ba,Ft,ya,Lt,va,At,Md="Converts bounding boxes from center format to corners format.",Ma,Rt,$d='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The coodinates for the top-left and bottom-right corners of the box (top_left_x, top_left_y, bottom_right_x, bottom_right_y)',$a,Ut,wd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The coordinate for the center of the box and its width, height dimensions (center_x, center_y, width, height)</p></td></tr></tbody>",wa,Ea,Ca,zt,Ja,Dt,Pa,Bt,Ed=`Named tuple to indicate the order we are using is (height x width), even though
the Graphics’ industry standard is (width x height).`,Ha,Wt,Cd='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a>',ka,ja,Ia,Nt,Fa,Gt,La,Zt,Jd='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Aa,Qt,Pd="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the batched preprocessed images.</p></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[480, 640]].</p></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[1000, 1330]].</p></td></tr></tbody>",Ra,Ua,za,Xt,Da,Vt,Ba,Yt,Hd='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Wa,St,kd="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>original_size</td><td><code>HeightWidth</code></td><td><p>The original size of the image.</p></td> </tr><tr><td>reshaped_input_size</td><td><code>HeightWidth</code></td><td><p>The reshaped input size of the image.</p></td> </tr><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the preprocessed image.</p></td></tr></tbody>",Na,Ga,Za,Kt,Qa,qt,Xa,Ot,jd='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Va,er,Id="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_mask</td><td><code>Tensor</code></td></tr></tbody>",Ya,Sa,Ka,tr,qa,rr,Oa,sr,Fd='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',el,or,Ld="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>input_points</td><td><code>Tensor</code></td></tr></tbody>",tl,rl,sl,lr,ol;return b=new g({props:{title:"processors",local:"processors",headingTag:"h1"}}),M=new al({props:{code:"aW1wb3J0JTIwJTdCJTIwQXV0b1Byb2Nlc3NvciUyQyUyMHJlYWRfYXVkaW8lMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFsZXQlMjBwcm9jZXNzb3IlMjAlM0QlMjBhd2FpdCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCdvcGVuYWklMkZ3aGlzcGVyLXRpbnkuZW4nKSUzQiUwQWxldCUyMGF1ZGlvJTIwJTNEJTIwYXdhaXQlMjByZWFkX2F1ZGlvKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJyUyQyUyMDE2MDAwKSUzQiUwQWxldCUyMCU3QiUyMGlucHV0X2ZlYXR1cmVzJTIwJTdEJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoYXVkaW8pJTNCJTBBJTJGJTJGJTIwVGVuc29yJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSgyNDAwMDApJTIwJTVCMC40NzUyOTg0NjQyOTgyNDgzJTJDJTIwMC41NTk3MjU4ODA2MjI4NjM4JTJDJTIwMC41NjQzNDE2NjQzMTQyNyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwODAlMkMlMjAzMDAwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwdHlwZSUzQSUyMCdmbG9hdDMyJyUyQyUwQSUyRiUyRiUyMCUyMCUyMHNpemUlM0ElMjAyNDAwMDAlMkMlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">AutoProcessor</span>, read_audio } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> audio = <span class="hljs-keyword">await</span> <span class="hljs-title function_">read_audio</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>, <span class="hljs-number">16000</span>);
<span class="hljs-keyword">let</span> { input_features } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(audio);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   data: Float32Array(240000) [0.4752984642982483, 0.5597258806228638, 0.56434166431427, ...],</span>
<span class="hljs-comment">//   dims: [1, 80, 3000],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   size: 240000,</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),E=new g({props:{title:"processors.FeatureExtractor ⇐ <code> Callable </code>",local:"processorsfeatureextractor--code-callable-code",headingTag:"h2"}}),H=new g({props:{title:"new FeatureExtractor(config)",local:"new-featureextractorconfig",headingTag:"h3"}}),F=new g({props:{title:"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>",local:"processorsimagefeatureextractor--code-featureextractor-code",headingTag:"h2"}}),z=new g({props:{title:"new ImageFeatureExtractor(config)",local:"new-imagefeatureextractorconfig",headingTag:"h3"}}),N=new g({props:{title:"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code",headingTag:"h3"}}),V=new g({props:{title:"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code",headingTag:"h3"}}),O=new g({props:{title:"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>",local:"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code",headingTag:"h3"}}),oe=new g({props:{title:"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>",local:"imagefeatureextractorrescalepixeldata--code-void-code",headingTag:"h3"}}),ie=new g({props:{title:"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>",local:"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code",headingTag:"h3"}}),he=new g({props:{title:"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>",local:"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code",headingTag:"h3"}}),Te=new g({props:{title:"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>",local:"processorsdetrfeatureextractor--code-imagefeatureextractor-code",headingTag:"h2"}}),$e=new g({props:{title:"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>",local:"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code",headingTag:"h3"}}),Pe=new g({props:{title:"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>",local:"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code",headingTag:"h3"}}),je=new g({props:{title:"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>",local:"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code",headingTag:"h3"}}),Re=new g({props:{title:"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>",local:"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code",headingTag:"h3"}}),We=new g({props:{title:"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>",local:"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code",headingTag:"h3"}}),Xe=new g({props:{title:"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>",local:"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code",headingTag:"h3"}}),qe=new g({props:{title:"processors.Processor ⇐ <code> Callable </code>",local:"processorsprocessor--code-callable-code",headingTag:"h2"}}),st=new g({props:{title:"new Processor(feature_extractor)",local:"new-processorfeatureextractor",headingTag:"h3"}}),dt=new g({props:{title:"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>",local:"processorcallinput-args--code-promise--any--code",headingTag:"h3"}}),nt=new g({props:{title:"processors.WhisperProcessor ⇐ <code> Processor </code>",local:"processorswhisperprocessor--code-processor-code",headingTag:"h2"}}),ft=new g({props:{title:"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>",local:"whisperprocessorcallaudio--code-promise--any--code",headingTag:"h3"}}),yt=new g({props:{title:"processors.AutoProcessor",local:"processorsautoprocessor",headingTag:"h2"}}),$t=new al({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJyklM0I=",highlighted:'<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);',wrap:!1}}),Et=new al({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDE2JyklM0IlMEFsZXQlMjBpbWFnZSUyMCUzRCUyMGF3YWl0JTIwUmF3SW1hZ2UucmVhZCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmZvb3RiYWxsLW1hdGNoLmpwZycpJTNCJTBBbGV0JTIwaW1hZ2VfaW5wdXRzJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoaW1hZ2UpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIyZGltcyUyMiUzQSUyMCU1QiUyMDElMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZsb2F0MzIlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJkYXRhJTIyJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTQ0MDg5MzE3MzIxNzc3MyUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMnNpemUlMjIlM0ElMjAxNTA1MjglMEElMkYlMkYlMjAlMjAlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJvcmlnaW5hbF9zaXplcyUyMiUzQSUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU1QiUyMDUzMyUyQyUyMDgwMCUyMCU1RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMnJlc2hhcGVkX2lucHV0X3NpemVzJTIyJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTVCJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTBBJTJGJTJGJTIwJTIwJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;Xenova/clip-vit-base-patch16&#x27;</span>);
<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-keyword">let</span> image_inputs = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(image);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;pixel_values&quot;: {</span>
<span class="hljs-comment">//     &quot;dims&quot;: [ 1, 3, 224, 224 ],</span>
<span class="hljs-comment">//     &quot;type&quot;: &quot;float32&quot;,</span>
<span class="hljs-comment">//     &quot;data&quot;: Float32Array [ -1.558687686920166, -1.558687686920166, -1.5440893173217773, ... ],</span>
<span class="hljs-comment">//     &quot;size&quot;: 150528</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   &quot;original_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 533, 800 ]</span>
<span class="hljs-comment">//   ],</span>
<span class="hljs-comment">//   &quot;reshaped_input_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 224, 224 ]</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Pt=new g({props:{title:"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>",local:"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code",headingTag:"h3"}}),Lt=new g({props:{title:"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>",local:"processorscentertocornersformatarr--code-array--number--code",headingTag:"h2"}}),Dt=new g({props:{title:"processors~HeightWidth : <code> * </code>",local:"processorsheightwidth--code--code",headingTag:"h2"}}),Gt=new g({props:{title:"processors~ImageFeatureExtractorResult : <code> object </code>",local:"processorsimagefeatureextractorresult--code-object-code",headingTag:"h2"}}),Vt=new g({props:{title:"processors~PreprocessedImage : <code> object </code>",local:"processorspreprocessedimage--code-object-code",headingTag:"h2"}}),qt=new g({props:{title:"processors~DetrFeatureExtractorResult : <code> object </code>",local:"processorsdetrfeatureextractorresult--code-object-code",headingTag:"h2"}}),rr=new g({props:{title:"processors~SamImageProcessorResult : <code> object </code>",local:"processorssamimageprocessorresult--code-object-code",headingTag:"h2"}}),{c(){x=l("meta"),dr=o(),ar=l("p"),cr=o(),T=l("a"),ir=o(),p(b.$$.fragment),pr=o(),y=l("p"),y.textContent=dl,mr=o(),v=l("p"),v.innerHTML=cl,nr=o(),p(M.$$.fragment),ur=o(),$=l("ul"),$.innerHTML=il,hr=o(),_r=l("hr"),fr=o(),w=l("a"),gr=o(),p(E.$$.fragment),xr=o(),C=l("p"),C.textContent=pl,Tr=o(),J=l("p"),J.innerHTML=ml,br=o(),yr=l("hr"),vr=o(),P=l("a"),Mr=o(),p(H.$$.fragment),$r=o(),k=l("p"),k.textContent=nl,wr=o(),j=l("table"),j.innerHTML=ul,Er=o(),Cr=l("hr"),Jr=o(),I=l("a"),Pr=o(),p(F.$$.fragment),Hr=o(),L=l("p"),L.textContent=hl,kr=o(),A=l("p"),A.innerHTML=_l,jr=o(),R=l("ul"),R.innerHTML=fl,Ir=o(),Fr=l("hr"),Lr=o(),U=l("a"),Ar=o(),p(z.$$.fragment),Rr=o(),D=l("p"),D.textContent=gl,Ur=o(),B=l("table"),B.innerHTML=xl,zr=o(),Dr=l("hr"),Br=o(),W=l("a"),Wr=o(),p(N.$$.fragment),Nr=o(),G=l("p"),G.textContent=Tl,Gr=o(),Z=l("p"),Z.innerHTML=bl,Zr=o(),Q=l("table"),Q.innerHTML=yl,Qr=o(),Xr=l("hr"),Vr=o(),X=l("a"),Yr=o(),p(V.$$.fragment),Sr=o(),Y=l("p"),Y.textContent=vl,Kr=o(),S=l("p"),S.innerHTML=Ml,qr=o(),K=l("table"),K.innerHTML=$l,Or=o(),es=l("hr"),ts=o(),q=l("a"),rs=o(),p(O.$$.fragment),ss=o(),ee=l("p"),ee.textContent=wl,os=o(),te=l("p"),te.innerHTML=El,as=o(),re=l("table"),re.innerHTML=Cl,ls=o(),ds=l("hr"),cs=o(),se=l("a"),is=o(),p(oe.$$.fragment),ps=o(),ae=l("p"),ae.innerHTML=Jl,ms=o(),le=l("p"),le.innerHTML=Pl,ns=o(),de=l("table"),de.innerHTML=Hl,us=o(),hs=l("hr"),_s=o(),ce=l("a"),fs=o(),p(ie.$$.fragment),gs=o(),pe=l("p"),pe.textContent=kl,xs=o(),me=l("p"),me.innerHTML=jl,Ts=o(),ne=l("table"),ne.innerHTML=Il,bs=o(),ys=l("hr"),vs=o(),ue=l("a"),Ms=o(),p(he.$$.fragment),$s=o(),_e=l("p"),_e.textContent=Fl,ws=o(),fe=l("p"),fe.innerHTML=Ll,Es=o(),ge=l("table"),ge.innerHTML=Al,Cs=o(),Js=l("hr"),Ps=o(),xe=l("a"),Hs=o(),p(Te.$$.fragment),ks=o(),be=l("p"),be.textContent=Rl,js=o(),ye=l("p"),ye.innerHTML=Ul,Is=o(),ve=l("ul"),ve.innerHTML=zl,Fs=o(),Ls=l("hr"),As=o(),Me=l("a"),Rs=o(),p($e.$$.fragment),Us=o(),we=l("p"),we.textContent=Dl,zs=o(),Ee=l("p"),Ee.innerHTML=Bl,Ds=o(),Ce=l("table"),Ce.innerHTML=Wl,Bs=o(),Ws=l("hr"),Ns=o(),Je=l("a"),Gs=o(),p(Pe.$$.fragment),Zs=o(),He=l("p"),He.innerHTML=Nl,Qs=o(),Xs=l("hr"),Vs=o(),ke=l("a"),Ys=o(),p(je.$$.fragment),Ss=o(),Ie=l("p"),Ie.innerHTML=Gl,Ks=o(),Fe=l("p"),Fe.innerHTML=Zl,qs=o(),Le=l("table"),Le.innerHTML=Ql,Os=o(),eo=l("hr"),to=o(),Ae=l("a"),ro=o(),p(Re.$$.fragment),so=o(),Ue=l("p"),Ue.textContent=Xl,oo=o(),ze=l("p"),ze.innerHTML=Vl,ao=o(),De=l("table"),De.innerHTML=Yl,lo=o(),co=l("hr"),io=o(),Be=l("a"),po=o(),p(We.$$.fragment),mo=o(),Ne=l("p"),Ne.textContent=Sl,no=o(),Ge=l("p"),Ge.innerHTML=Kl,uo=o(),Ze=l("table"),Ze.innerHTML=ql,ho=o(),_o=l("hr"),fo=o(),Qe=l("a"),go=o(),p(Xe.$$.fragment),xo=o(),Ve=l("p"),Ve.textContent=Ol,To=o(),Ye=l("p"),Ye.innerHTML=ed,bo=o(),Se=l("table"),Se.innerHTML=td,yo=o(),vo=l("hr"),Mo=o(),Ke=l("a"),$o=o(),p(qe.$$.fragment),wo=o(),Oe=l("p"),Oe.textContent=rd,Eo=o(),et=l("p"),et.innerHTML=sd,Co=o(),tt=l("ul"),tt.innerHTML=od,Jo=o(),Po=l("hr"),Ho=o(),rt=l("a"),ko=o(),p(st.$$.fragment),jo=o(),ot=l("p"),ot.textContent=ad,Io=o(),at=l("table"),at.innerHTML=ld,Fo=o(),Lo=l("hr"),Ao=o(),lt=l("a"),Ro=o(),p(dt.$$.fragment),Uo=o(),ct=l("p"),ct.textContent=dd,zo=o(),it=l("p"),it.innerHTML=cd,Do=o(),pt=l("table"),pt.innerHTML=id,Bo=o(),Wo=l("hr"),No=o(),mt=l("a"),Go=o(),p(nt.$$.fragment),Zo=o(),ut=l("p"),ut.textContent=pd,Qo=o(),ht=l("p"),ht.innerHTML=md,Xo=o(),Vo=l("hr"),Yo=o(),_t=l("a"),So=o(),p(ft.$$.fragment),Ko=o(),gt=l("p"),gt.textContent=nd,qo=o(),xt=l("p"),xt.innerHTML=ud,Oo=o(),Tt=l("table"),Tt.innerHTML=hd,ea=o(),ta=l("hr"),ra=o(),bt=l("a"),sa=o(),p(yt.$$.fragment),oa=o(),vt=l("p"),vt.innerHTML=_d,aa=o(),Mt=l("p"),Mt.innerHTML=fd,la=o(),p($t.$$.fragment),da=o(),wt=l("p"),wt.innerHTML=gd,ca=o(),p(Et.$$.fragment),ia=o(),Ct=l("p"),Ct.innerHTML=xd,pa=o(),ma=l("hr"),na=o(),Jt=l("a"),ua=o(),p(Pt.$$.fragment),ha=o(),Ht=l("p"),Ht.textContent=Td,_a=o(),kt=l("p"),kt.innerHTML=bd,fa=o(),jt=l("p"),jt.innerHTML=yd,ga=o(),It=l("table"),It.innerHTML=vd,xa=o(),Ta=l("hr"),ba=o(),Ft=l("a"),ya=o(),p(Lt.$$.fragment),va=o(),At=l("p"),At.textContent=Md,Ma=o(),Rt=l("p"),Rt.innerHTML=$d,$a=o(),Ut=l("table"),Ut.innerHTML=wd,wa=o(),Ea=l("hr"),Ca=o(),zt=l("a"),Ja=o(),p(Dt.$$.fragment),Pa=o(),Bt=l("p"),Bt.textContent=Ed,Ha=o(),Wt=l("p"),Wt.innerHTML=Cd,ka=o(),ja=l("hr"),Ia=o(),Nt=l("a"),Fa=o(),p(Gt.$$.fragment),La=o(),Zt=l("p"),Zt.innerHTML=Jd,Aa=o(),Qt=l("table"),Qt.innerHTML=Pd,Ra=o(),Ua=l("hr"),za=o(),Xt=l("a"),Da=o(),p(Vt.$$.fragment),Ba=o(),Yt=l("p"),Yt.innerHTML=Hd,Wa=o(),St=l("table"),St.innerHTML=kd,Na=o(),Ga=l("hr"),Za=o(),Kt=l("a"),Qa=o(),p(qt.$$.fragment),Xa=o(),Ot=l("p"),Ot.innerHTML=jd,Va=o(),er=l("table"),er.innerHTML=Id,Ya=o(),Sa=l("hr"),Ka=o(),tr=l("a"),qa=o(),p(rr.$$.fragment),Oa=o(),sr=l("p"),sr.innerHTML=Fd,el=o(),or=l("table"),or.innerHTML=Ld,tl=o(),rl=l("hr"),sl=o(),lr=l("p"),this.h()},l(e){const t=Bd("svelte-u9bgzb",document.head);x=d(t,"META",{name:!0,content:!0}),t.forEach(r),dr=a(e),ar=d(e,"P",{}),f(ar).forEach(r),cr=a(e),T=d(e,"A",{id:!0,class:!0}),f(T).forEach(r),ir=a(e),m(b.$$.fragment,e),pr=a(e),y=d(e,"P",{"data-svelte-h":!0}),c(y)!=="svelte-w0rx8m"&&(y.textContent=dl),mr=a(e),v=d(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1olsie5"&&(v.innerHTML=cl),nr=a(e),m(M.$$.fragment,e),ur=a(e),$=d(e,"UL",{"data-svelte-h":!0}),c($)!=="svelte-19dyg6m"&&($.innerHTML=il),hr=a(e),_r=d(e,"HR",{}),fr=a(e),w=d(e,"A",{id:!0,class:!0}),f(w).forEach(r),gr=a(e),m(E.$$.fragment,e),xr=a(e),C=d(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-14r3pvv"&&(C.textContent=pl),Tr=a(e),J=d(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-fac4cj"&&(J.innerHTML=ml),br=a(e),yr=d(e,"HR",{}),vr=a(e),P=d(e,"A",{id:!0,class:!0}),f(P).forEach(r),Mr=a(e),m(H.$$.fragment,e),$r=a(e),k=d(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-k3m2wg"&&(k.textContent=nl),wr=a(e),j=d(e,"TABLE",{"data-svelte-h":!0}),c(j)!=="svelte-rd7ds7"&&(j.innerHTML=ul),Er=a(e),Cr=d(e,"HR",{}),Jr=a(e),I=d(e,"A",{id:!0,class:!0}),f(I).forEach(r),Pr=a(e),m(F.$$.fragment,e),Hr=a(e),L=d(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-8k8cys"&&(L.textContent=hl),kr=a(e),A=d(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-18p52n5"&&(A.innerHTML=_l),jr=a(e),R=d(e,"UL",{"data-svelte-h":!0}),c(R)!=="svelte-1urckha"&&(R.innerHTML=fl),Ir=a(e),Fr=d(e,"HR",{}),Lr=a(e),U=d(e,"A",{id:!0,class:!0}),f(U).forEach(r),Ar=a(e),m(z.$$.fragment,e),Rr=a(e),D=d(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-1mp2vol"&&(D.textContent=gl),Ur=a(e),B=d(e,"TABLE",{"data-svelte-h":!0}),c(B)!=="svelte-eb9kev"&&(B.innerHTML=xl),zr=a(e),Dr=d(e,"HR",{}),Br=a(e),W=d(e,"A",{id:!0,class:!0}),f(W).forEach(r),Wr=a(e),m(N.$$.fragment,e),Nr=a(e),G=d(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1q6eyx4"&&(G.textContent=Tl),Gr=a(e),Z=d(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-ar7q77"&&(Z.innerHTML=bl),Zr=a(e),Q=d(e,"TABLE",{"data-svelte-h":!0}),c(Q)!=="svelte-klyf4z"&&(Q.innerHTML=yl),Qr=a(e),Xr=d(e,"HR",{}),Vr=a(e),X=d(e,"A",{id:!0,class:!0}),f(X).forEach(r),Yr=a(e),m(V.$$.fragment,e),Sr=a(e),Y=d(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-7fx89a"&&(Y.textContent=vl),Kr=a(e),S=d(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-65os4c"&&(S.innerHTML=Ml),qr=a(e),K=d(e,"TABLE",{"data-svelte-h":!0}),c(K)!=="svelte-1dnvwno"&&(K.innerHTML=$l),Or=a(e),es=d(e,"HR",{}),ts=a(e),q=d(e,"A",{id:!0,class:!0}),f(q).forEach(r),rs=a(e),m(O.$$.fragment,e),ss=a(e),ee=d(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1mmkb9p"&&(ee.textContent=wl),os=a(e),te=d(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-110o3sn"&&(te.innerHTML=El),as=a(e),re=d(e,"TABLE",{"data-svelte-h":!0}),c(re)!=="svelte-iqjbgm"&&(re.innerHTML=Cl),ls=a(e),ds=d(e,"HR",{}),cs=a(e),se=d(e,"A",{id:!0,class:!0}),f(se).forEach(r),is=a(e),m(oe.$$.fragment,e),ps=a(e),ae=d(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-pyd72v"&&(ae.innerHTML=Jl),ms=a(e),le=d(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1isxmg1"&&(le.innerHTML=Pl),ns=a(e),de=d(e,"TABLE",{"data-svelte-h":!0}),c(de)!=="svelte-1e1ka8e"&&(de.innerHTML=Hl),us=a(e),hs=d(e,"HR",{}),_s=a(e),ce=d(e,"A",{id:!0,class:!0}),f(ce).forEach(r),fs=a(e),m(ie.$$.fragment,e),gs=a(e),pe=d(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-10g8wi9"&&(pe.textContent=kl),xs=a(e),me=d(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-cd20o3"&&(me.innerHTML=jl),Ts=a(e),ne=d(e,"TABLE",{"data-svelte-h":!0}),c(ne)!=="svelte-1773mps"&&(ne.innerHTML=Il),bs=a(e),ys=d(e,"HR",{}),vs=a(e),ue=d(e,"A",{id:!0,class:!0}),f(ue).forEach(r),Ms=a(e),m(he.$$.fragment,e),$s=a(e),_e=d(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-1uytqp8"&&(_e.textContent=Fl),ws=a(e),fe=d(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-1pa0uk8"&&(fe.innerHTML=Ll),Es=a(e),ge=d(e,"TABLE",{"data-svelte-h":!0}),c(ge)!=="svelte-hch5rz"&&(ge.innerHTML=Al),Cs=a(e),Js=d(e,"HR",{}),Ps=a(e),xe=d(e,"A",{id:!0,class:!0}),f(xe).forEach(r),Hs=a(e),m(Te.$$.fragment,e),ks=a(e),be=d(e,"P",{"data-svelte-h":!0}),c(be)!=="svelte-y1gxwn"&&(be.textContent=Rl),js=a(e),ye=d(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-1xz91ac"&&(ye.innerHTML=Ul),Is=a(e),ve=d(e,"UL",{"data-svelte-h":!0}),c(ve)!=="svelte-1obx36y"&&(ve.innerHTML=zl),Fs=a(e),Ls=d(e,"HR",{}),As=a(e),Me=d(e,"A",{id:!0,class:!0}),f(Me).forEach(r),Rs=a(e),m($e.$$.fragment,e),Us=a(e),we=d(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-1ec3vsm"&&(we.textContent=Dl),zs=a(e),Ee=d(e,"P",{"data-svelte-h":!0}),c(Ee)!=="svelte-6tjpr7"&&(Ee.innerHTML=Bl),Ds=a(e),Ce=d(e,"TABLE",{"data-svelte-h":!0}),c(Ce)!=="svelte-1px7bnv"&&(Ce.innerHTML=Wl),Bs=a(e),Ws=d(e,"HR",{}),Ns=a(e),Je=d(e,"A",{id:!0,class:!0}),f(Je).forEach(r),Gs=a(e),m(Pe.$$.fragment,e),Zs=a(e),He=d(e,"P",{"data-svelte-h":!0}),c(He)!=="svelte-j2v54d"&&(He.innerHTML=Nl),Qs=a(e),Xs=d(e,"HR",{}),Vs=a(e),ke=d(e,"A",{id:!0,class:!0}),f(ke).forEach(r),Ys=a(e),m(je.$$.fragment,e),Ss=a(e),Ie=d(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-75c7d5"&&(Ie.innerHTML=Gl),Ks=a(e),Fe=d(e,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-o8p6wm"&&(Fe.innerHTML=Zl),qs=a(e),Le=d(e,"TABLE",{"data-svelte-h":!0}),c(Le)!=="svelte-yqya7v"&&(Le.innerHTML=Ql),Os=a(e),eo=d(e,"HR",{}),to=a(e),Ae=d(e,"A",{id:!0,class:!0}),f(Ae).forEach(r),ro=a(e),m(Re.$$.fragment,e),so=a(e),Ue=d(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-gl8gb6"&&(Ue.textContent=Xl),oo=a(e),ze=d(e,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-1qxvzd2"&&(ze.innerHTML=Vl),ao=a(e),De=d(e,"TABLE",{"data-svelte-h":!0}),c(De)!=="svelte-1f7z42u"&&(De.innerHTML=Yl),lo=a(e),co=d(e,"HR",{}),io=a(e),Be=d(e,"A",{id:!0,class:!0}),f(Be).forEach(r),po=a(e),m(We.$$.fragment,e),mo=a(e),Ne=d(e,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-7vs1p7"&&(Ne.textContent=Sl),no=a(e),Ge=d(e,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-15rcpil"&&(Ge.innerHTML=Kl),uo=a(e),Ze=d(e,"TABLE",{"data-svelte-h":!0}),c(Ze)!=="svelte-3xdz32"&&(Ze.innerHTML=ql),ho=a(e),_o=d(e,"HR",{}),fo=a(e),Qe=d(e,"A",{id:!0,class:!0}),f(Qe).forEach(r),go=a(e),m(Xe.$$.fragment,e),xo=a(e),Ve=d(e,"P",{"data-svelte-h":!0}),c(Ve)!=="svelte-frdp8m"&&(Ve.textContent=Ol),To=a(e),Ye=d(e,"P",{"data-svelte-h":!0}),c(Ye)!=="svelte-j2v54d"&&(Ye.innerHTML=ed),bo=a(e),Se=d(e,"TABLE",{"data-svelte-h":!0}),c(Se)!=="svelte-11rkhka"&&(Se.innerHTML=td),yo=a(e),vo=d(e,"HR",{}),Mo=a(e),Ke=d(e,"A",{id:!0,class:!0}),f(Ke).forEach(r),$o=a(e),m(qe.$$.fragment,e),wo=a(e),Oe=d(e,"P",{"data-svelte-h":!0}),c(Oe)!=="svelte-o9f953"&&(Oe.textContent=rd),Eo=a(e),et=d(e,"P",{"data-svelte-h":!0}),c(et)!=="svelte-fac4cj"&&(et.innerHTML=sd),Co=a(e),tt=d(e,"UL",{"data-svelte-h":!0}),c(tt)!=="svelte-1v579im"&&(tt.innerHTML=od),Jo=a(e),Po=d(e,"HR",{}),Ho=a(e),rt=d(e,"A",{id:!0,class:!0}),f(rt).forEach(r),ko=a(e),m(st.$$.fragment,e),jo=a(e),ot=d(e,"P",{"data-svelte-h":!0}),c(ot)!=="svelte-1naom0u"&&(ot.textContent=ad),Io=a(e),at=d(e,"TABLE",{"data-svelte-h":!0}),c(at)!=="svelte-ilxs6c"&&(at.innerHTML=ld),Fo=a(e),Lo=d(e,"HR",{}),Ao=a(e),lt=d(e,"A",{id:!0,class:!0}),f(lt).forEach(r),Ro=a(e),m(dt.$$.fragment,e),Uo=a(e),ct=d(e,"P",{"data-svelte-h":!0}),c(ct)!=="svelte-zbbm3j"&&(ct.textContent=dd),zo=a(e),it=d(e,"P",{"data-svelte-h":!0}),c(it)!=="svelte-kflsb2"&&(it.innerHTML=cd),Do=a(e),pt=d(e,"TABLE",{"data-svelte-h":!0}),c(pt)!=="svelte-pm1u9z"&&(pt.innerHTML=id),Bo=a(e),Wo=d(e,"HR",{}),No=a(e),mt=d(e,"A",{id:!0,class:!0}),f(mt).forEach(r),Go=a(e),m(nt.$$.fragment,e),Zo=a(e),ut=d(e,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-17pib55"&&(ut.textContent=pd),Qo=a(e),ht=d(e,"P",{"data-svelte-h":!0}),c(ht)!=="svelte-1ljhyyr"&&(ht.innerHTML=md),Xo=a(e),Vo=d(e,"HR",{}),Yo=a(e),_t=d(e,"A",{id:!0,class:!0}),f(_t).forEach(r),So=a(e),m(ft.$$.fragment,e),Ko=a(e),gt=d(e,"P",{"data-svelte-h":!0}),c(gt)!=="svelte-r5x3fh"&&(gt.textContent=nd),qo=a(e),xt=d(e,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-1vpvonk"&&(xt.innerHTML=ud),Oo=a(e),Tt=d(e,"TABLE",{"data-svelte-h":!0}),c(Tt)!=="svelte-nv3lon"&&(Tt.innerHTML=hd),ea=a(e),ta=d(e,"HR",{}),ra=a(e),bt=d(e,"A",{id:!0,class:!0}),f(bt).forEach(r),sa=a(e),m(yt.$$.fragment,e),oa=a(e),vt=d(e,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-62dsf9"&&(vt.innerHTML=_d),aa=a(e),Mt=d(e,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-11vd43e"&&(Mt.innerHTML=fd),la=a(e),m($t.$$.fragment,e),da=a(e),wt=d(e,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-c0cgha"&&(wt.innerHTML=gd),ca=a(e),m(Et.$$.fragment,e),ia=a(e),Ct=d(e,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-wmyz1o"&&(Ct.innerHTML=xd),pa=a(e),ma=d(e,"HR",{}),na=a(e),Jt=d(e,"A",{id:!0,class:!0}),f(Jt).forEach(r),ua=a(e),m(Pt.$$.fragment,e),ha=a(e),Ht=d(e,"P",{"data-svelte-h":!0}),c(Ht)!=="svelte-jwfdp9"&&(Ht.textContent=Td),_a=a(e),kt=d(e,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-t85gxq"&&(kt.innerHTML=bd),fa=a(e),jt=d(e,"P",{"data-svelte-h":!0}),c(jt)!=="svelte-y7m8db"&&(jt.innerHTML=yd),ga=a(e),It=d(e,"TABLE",{"data-svelte-h":!0}),c(It)!=="svelte-1oj79mt"&&(It.innerHTML=vd),xa=a(e),Ta=d(e,"HR",{}),ba=a(e),Ft=d(e,"A",{id:!0,class:!0}),f(Ft).forEach(r),ya=a(e),m(Lt.$$.fragment,e),va=a(e),At=d(e,"P",{"data-svelte-h":!0}),c(At)!=="svelte-kjzox5"&&(At.textContent=Md),Ma=a(e),Rt=d(e,"P",{"data-svelte-h":!0}),c(Rt)!=="svelte-19qboln"&&(Rt.innerHTML=$d),$a=a(e),Ut=d(e,"TABLE",{"data-svelte-h":!0}),c(Ut)!=="svelte-1bv5sxq"&&(Ut.innerHTML=wd),wa=a(e),Ea=d(e,"HR",{}),Ca=a(e),zt=d(e,"A",{id:!0,class:!0}),f(zt).forEach(r),Ja=a(e),m(Dt.$$.fragment,e),Pa=a(e),Bt=d(e,"P",{"data-svelte-h":!0}),c(Bt)!=="svelte-2u8xbp"&&(Bt.textContent=Ed),Ha=a(e),Wt=d(e,"P",{"data-svelte-h":!0}),c(Wt)!=="svelte-3xndnt"&&(Wt.innerHTML=Cd),ka=a(e),ja=d(e,"HR",{}),Ia=a(e),Nt=d(e,"A",{id:!0,class:!0}),f(Nt).forEach(r),Fa=a(e),m(Gt.$$.fragment,e),La=a(e),Zt=d(e,"P",{"data-svelte-h":!0}),c(Zt)!=="svelte-cy5pwv"&&(Zt.innerHTML=Jd),Aa=a(e),Qt=d(e,"TABLE",{"data-svelte-h":!0}),c(Qt)!=="svelte-1dyar84"&&(Qt.innerHTML=Pd),Ra=a(e),Ua=d(e,"HR",{}),za=a(e),Xt=d(e,"A",{id:!0,class:!0}),f(Xt).forEach(r),Da=a(e),m(Vt.$$.fragment,e),Ba=a(e),Yt=d(e,"P",{"data-svelte-h":!0}),c(Yt)!=="svelte-cy5pwv"&&(Yt.innerHTML=Hd),Wa=a(e),St=d(e,"TABLE",{"data-svelte-h":!0}),c(St)!=="svelte-1cnys15"&&(St.innerHTML=kd),Na=a(e),Ga=d(e,"HR",{}),Za=a(e),Kt=d(e,"A",{id:!0,class:!0}),f(Kt).forEach(r),Qa=a(e),m(qt.$$.fragment,e),Xa=a(e),Ot=d(e,"P",{"data-svelte-h":!0}),c(Ot)!=="svelte-cy5pwv"&&(Ot.innerHTML=jd),Va=a(e),er=d(e,"TABLE",{"data-svelte-h":!0}),c(er)!=="svelte-179cln2"&&(er.innerHTML=Id),Ya=a(e),Sa=d(e,"HR",{}),Ka=a(e),tr=d(e,"A",{id:!0,class:!0}),f(tr).forEach(r),qa=a(e),m(rr.$$.fragment,e),Oa=a(e),sr=d(e,"P",{"data-svelte-h":!0}),c(sr)!=="svelte-cy5pwv"&&(sr.innerHTML=Fd),el=a(e),or=d(e,"TABLE",{"data-svelte-h":!0}),c(or)!=="svelte-1btb1vt"&&(or.innerHTML=Ld),tl=a(e),rl=d(e,"HR",{}),sl=a(e),lr=d(e,"P",{}),f(lr).forEach(r),this.h()},h(){i(x,"name","hf:doc:metadata"),i(x,"content",Gd),i(T,"id","module_processors"),i(T,"class","group"),i(w,"id","module_processors.FeatureExtractor"),i(w,"class","group"),i(P,"id","new_module_processors.FeatureExtractor_new"),i(P,"class","group"),i(I,"id","module_processors.ImageFeatureExtractor"),i(I,"class","group"),i(U,"id","new_module_processors.ImageFeatureExtractor_new"),i(U,"class","group"),i(W,"id","module_processors.ImageFeatureExtractor+thumbnail"),i(W,"class","group"),i(X,"id","module_processors.ImageFeatureExtractor+crop_margin"),i(X,"class","group"),i(q,"id","module_processors.ImageFeatureExtractor+pad_image"),i(q,"class","group"),i(se,"id","module_processors.ImageFeatureExtractor+rescale"),i(se,"class","group"),i(ce,"id","module_processors.ImageFeatureExtractor+preprocess"),i(ce,"class","group"),i(ue,"id","module_processors.ImageFeatureExtractor+_call"),i(ue,"class","group"),i(xe,"id","module_processors.DetrFeatureExtractor"),i(xe,"class","group"),i(Me,"id","module_processors.DetrFeatureExtractor+_call"),i(Me,"class","group"),i(Je,"id","module_processors.DetrFeatureExtractor+post_process_object_detection"),i(Je,"class","group"),i(ke,"id","module_processors.DetrFeatureExtractor+remove_low_and_no_objects"),i(ke,"class","group"),i(Ae,"id","module_processors.DetrFeatureExtractor+check_segment_validity"),i(Ae,"class","group"),i(Be,"id","module_processors.DetrFeatureExtractor+compute_segments"),i(Be,"class","group"),i(Qe,"id","module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"),i(Qe,"class","group"),i(Ke,"id","module_processors.Processor"),i(Ke,"class","group"),i(rt,"id","new_module_processors.Processor_new"),i(rt,"class","group"),i(lt,"id","module_processors.Processor+_call"),i(lt,"class","group"),i(mt,"id","module_processors.WhisperProcessor"),i(mt,"class","group"),i(_t,"id","module_processors.WhisperProcessor+_call"),i(_t,"class","group"),i(bt,"id","module_processors.AutoProcessor"),i(bt,"class","group"),i(Jt,"id","module_processors.AutoProcessor.from_pretrained"),i(Jt,"class","group"),i(Ft,"id","module_processors..center_to_corners_format"),i(Ft,"class","group"),i(zt,"id","module_processors..HeightWidth"),i(zt,"class","group"),i(Nt,"id","module_processors..ImageFeatureExtractorResult"),i(Nt,"class","group"),i(Xt,"id","module_processors..PreprocessedImage"),i(Xt,"class","group"),i(Kt,"id","module_processors..DetrFeatureExtractorResult"),i(Kt,"class","group"),i(tr,"id","module_processors..SamImageProcessorResult"),i(tr,"class","group")},m(e,t){Wd(document.head,x),s(e,dr,t),s(e,ar,t),s(e,cr,t),s(e,T,t),s(e,ir,t),n(b,e,t),s(e,pr,t),s(e,y,t),s(e,mr,t),s(e,v,t),s(e,nr,t),n(M,e,t),s(e,ur,t),s(e,$,t),s(e,hr,t),s(e,_r,t),s(e,fr,t),s(e,w,t),s(e,gr,t),n(E,e,t),s(e,xr,t),s(e,C,t),s(e,Tr,t),s(e,J,t),s(e,br,t),s(e,yr,t),s(e,vr,t),s(e,P,t),s(e,Mr,t),n(H,e,t),s(e,$r,t),s(e,k,t),s(e,wr,t),s(e,j,t),s(e,Er,t),s(e,Cr,t),s(e,Jr,t),s(e,I,t),s(e,Pr,t),n(F,e,t),s(e,Hr,t),s(e,L,t),s(e,kr,t),s(e,A,t),s(e,jr,t),s(e,R,t),s(e,Ir,t),s(e,Fr,t),s(e,Lr,t),s(e,U,t),s(e,Ar,t),n(z,e,t),s(e,Rr,t),s(e,D,t),s(e,Ur,t),s(e,B,t),s(e,zr,t),s(e,Dr,t),s(e,Br,t),s(e,W,t),s(e,Wr,t),n(N,e,t),s(e,Nr,t),s(e,G,t),s(e,Gr,t),s(e,Z,t),s(e,Zr,t),s(e,Q,t),s(e,Qr,t),s(e,Xr,t),s(e,Vr,t),s(e,X,t),s(e,Yr,t),n(V,e,t),s(e,Sr,t),s(e,Y,t),s(e,Kr,t),s(e,S,t),s(e,qr,t),s(e,K,t),s(e,Or,t),s(e,es,t),s(e,ts,t),s(e,q,t),s(e,rs,t),n(O,e,t),s(e,ss,t),s(e,ee,t),s(e,os,t),s(e,te,t),s(e,as,t),s(e,re,t),s(e,ls,t),s(e,ds,t),s(e,cs,t),s(e,se,t),s(e,is,t),n(oe,e,t),s(e,ps,t),s(e,ae,t),s(e,ms,t),s(e,le,t),s(e,ns,t),s(e,de,t),s(e,us,t),s(e,hs,t),s(e,_s,t),s(e,ce,t),s(e,fs,t),n(ie,e,t),s(e,gs,t),s(e,pe,t),s(e,xs,t),s(e,me,t),s(e,Ts,t),s(e,ne,t),s(e,bs,t),s(e,ys,t),s(e,vs,t),s(e,ue,t),s(e,Ms,t),n(he,e,t),s(e,$s,t),s(e,_e,t),s(e,ws,t),s(e,fe,t),s(e,Es,t),s(e,ge,t),s(e,Cs,t),s(e,Js,t),s(e,Ps,t),s(e,xe,t),s(e,Hs,t),n(Te,e,t),s(e,ks,t),s(e,be,t),s(e,js,t),s(e,ye,t),s(e,Is,t),s(e,ve,t),s(e,Fs,t),s(e,Ls,t),s(e,As,t),s(e,Me,t),s(e,Rs,t),n($e,e,t),s(e,Us,t),s(e,we,t),s(e,zs,t),s(e,Ee,t),s(e,Ds,t),s(e,Ce,t),s(e,Bs,t),s(e,Ws,t),s(e,Ns,t),s(e,Je,t),s(e,Gs,t),n(Pe,e,t),s(e,Zs,t),s(e,He,t),s(e,Qs,t),s(e,Xs,t),s(e,Vs,t),s(e,ke,t),s(e,Ys,t),n(je,e,t),s(e,Ss,t),s(e,Ie,t),s(e,Ks,t),s(e,Fe,t),s(e,qs,t),s(e,Le,t),s(e,Os,t),s(e,eo,t),s(e,to,t),s(e,Ae,t),s(e,ro,t),n(Re,e,t),s(e,so,t),s(e,Ue,t),s(e,oo,t),s(e,ze,t),s(e,ao,t),s(e,De,t),s(e,lo,t),s(e,co,t),s(e,io,t),s(e,Be,t),s(e,po,t),n(We,e,t),s(e,mo,t),s(e,Ne,t),s(e,no,t),s(e,Ge,t),s(e,uo,t),s(e,Ze,t),s(e,ho,t),s(e,_o,t),s(e,fo,t),s(e,Qe,t),s(e,go,t),n(Xe,e,t),s(e,xo,t),s(e,Ve,t),s(e,To,t),s(e,Ye,t),s(e,bo,t),s(e,Se,t),s(e,yo,t),s(e,vo,t),s(e,Mo,t),s(e,Ke,t),s(e,$o,t),n(qe,e,t),s(e,wo,t),s(e,Oe,t),s(e,Eo,t),s(e,et,t),s(e,Co,t),s(e,tt,t),s(e,Jo,t),s(e,Po,t),s(e,Ho,t),s(e,rt,t),s(e,ko,t),n(st,e,t),s(e,jo,t),s(e,ot,t),s(e,Io,t),s(e,at,t),s(e,Fo,t),s(e,Lo,t),s(e,Ao,t),s(e,lt,t),s(e,Ro,t),n(dt,e,t),s(e,Uo,t),s(e,ct,t),s(e,zo,t),s(e,it,t),s(e,Do,t),s(e,pt,t),s(e,Bo,t),s(e,Wo,t),s(e,No,t),s(e,mt,t),s(e,Go,t),n(nt,e,t),s(e,Zo,t),s(e,ut,t),s(e,Qo,t),s(e,ht,t),s(e,Xo,t),s(e,Vo,t),s(e,Yo,t),s(e,_t,t),s(e,So,t),n(ft,e,t),s(e,Ko,t),s(e,gt,t),s(e,qo,t),s(e,xt,t),s(e,Oo,t),s(e,Tt,t),s(e,ea,t),s(e,ta,t),s(e,ra,t),s(e,bt,t),s(e,sa,t),n(yt,e,t),s(e,oa,t),s(e,vt,t),s(e,aa,t),s(e,Mt,t),s(e,la,t),n($t,e,t),s(e,da,t),s(e,wt,t),s(e,ca,t),n(Et,e,t),s(e,ia,t),s(e,Ct,t),s(e,pa,t),s(e,ma,t),s(e,na,t),s(e,Jt,t),s(e,ua,t),n(Pt,e,t),s(e,ha,t),s(e,Ht,t),s(e,_a,t),s(e,kt,t),s(e,fa,t),s(e,jt,t),s(e,ga,t),s(e,It,t),s(e,xa,t),s(e,Ta,t),s(e,ba,t),s(e,Ft,t),s(e,ya,t),n(Lt,e,t),s(e,va,t),s(e,At,t),s(e,Ma,t),s(e,Rt,t),s(e,$a,t),s(e,Ut,t),s(e,wa,t),s(e,Ea,t),s(e,Ca,t),s(e,zt,t),s(e,Ja,t),n(Dt,e,t),s(e,Pa,t),s(e,Bt,t),s(e,Ha,t),s(e,Wt,t),s(e,ka,t),s(e,ja,t),s(e,Ia,t),s(e,Nt,t),s(e,Fa,t),n(Gt,e,t),s(e,La,t),s(e,Zt,t),s(e,Aa,t),s(e,Qt,t),s(e,Ra,t),s(e,Ua,t),s(e,za,t),s(e,Xt,t),s(e,Da,t),n(Vt,e,t),s(e,Ba,t),s(e,Yt,t),s(e,Wa,t),s(e,St,t),s(e,Na,t),s(e,Ga,t),s(e,Za,t),s(e,Kt,t),s(e,Qa,t),n(qt,e,t),s(e,Xa,t),s(e,Ot,t),s(e,Va,t),s(e,er,t),s(e,Ya,t),s(e,Sa,t),s(e,Ka,t),s(e,tr,t),s(e,qa,t),n(rr,e,t),s(e,Oa,t),s(e,sr,t),s(e,el,t),s(e,or,t),s(e,tl,t),s(e,rl,t),s(e,sl,t),s(e,lr,t),ol=!0},p:Rd,i(e){ol||(u(b.$$.fragment,e),u(M.$$.fragment,e),u(E.$$.fragment,e),u(H.$$.fragment,e),u(F.$$.fragment,e),u(z.$$.fragment,e),u(N.$$.fragment,e),u(V.$$.fragment,e),u(O.$$.fragment,e),u(oe.$$.fragment,e),u(ie.$$.fragment,e),u(he.$$.fragment,e),u(Te.$$.fragment,e),u($e.$$.fragment,e),u(Pe.$$.fragment,e),u(je.$$.fragment,e),u(Re.$$.fragment,e),u(We.$$.fragment,e),u(Xe.$$.fragment,e),u(qe.$$.fragment,e),u(st.$$.fragment,e),u(dt.$$.fragment,e),u(nt.$$.fragment,e),u(ft.$$.fragment,e),u(yt.$$.fragment,e),u($t.$$.fragment,e),u(Et.$$.fragment,e),u(Pt.$$.fragment,e),u(Lt.$$.fragment,e),u(Dt.$$.fragment,e),u(Gt.$$.fragment,e),u(Vt.$$.fragment,e),u(qt.$$.fragment,e),u(rr.$$.fragment,e),ol=!0)},o(e){h(b.$$.fragment,e),h(M.$$.fragment,e),h(E.$$.fragment,e),h(H.$$.fragment,e),h(F.$$.fragment,e),h(z.$$.fragment,e),h(N.$$.fragment,e),h(V.$$.fragment,e),h(O.$$.fragment,e),h(oe.$$.fragment,e),h(ie.$$.fragment,e),h(he.$$.fragment,e),h(Te.$$.fragment,e),h($e.$$.fragment,e),h(Pe.$$.fragment,e),h(je.$$.fragment,e),h(Re.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(qe.$$.fragment,e),h(st.$$.fragment,e),h(dt.$$.fragment,e),h(nt.$$.fragment,e),h(ft.$$.fragment,e),h(yt.$$.fragment,e),h($t.$$.fragment,e),h(Et.$$.fragment,e),h(Pt.$$.fragment,e),h(Lt.$$.fragment,e),h(Dt.$$.fragment,e),h(Gt.$$.fragment,e),h(Vt.$$.fragment,e),h(qt.$$.fragment,e),h(rr.$$.fragment,e),ol=!1},d(e){e&&(r(dr),r(ar),r(cr),r(T),r(ir),r(pr),r(y),r(mr),r(v),r(nr),r(ur),r($),r(hr),r(_r),r(fr),r(w),r(gr),r(xr),r(C),r(Tr),r(J),r(br),r(yr),r(vr),r(P),r(Mr),r($r),r(k),r(wr),r(j),r(Er),r(Cr),r(Jr),r(I),r(Pr),r(Hr),r(L),r(kr),r(A),r(jr),r(R),r(Ir),r(Fr),r(Lr),r(U),r(Ar),r(Rr),r(D),r(Ur),r(B),r(zr),r(Dr),r(Br),r(W),r(Wr),r(Nr),r(G),r(Gr),r(Z),r(Zr),r(Q),r(Qr),r(Xr),r(Vr),r(X),r(Yr),r(Sr),r(Y),r(Kr),r(S),r(qr),r(K),r(Or),r(es),r(ts),r(q),r(rs),r(ss),r(ee),r(os),r(te),r(as),r(re),r(ls),r(ds),r(cs),r(se),r(is),r(ps),r(ae),r(ms),r(le),r(ns),r(de),r(us),r(hs),r(_s),r(ce),r(fs),r(gs),r(pe),r(xs),r(me),r(Ts),r(ne),r(bs),r(ys),r(vs),r(ue),r(Ms),r($s),r(_e),r(ws),r(fe),r(Es),r(ge),r(Cs),r(Js),r(Ps),r(xe),r(Hs),r(ks),r(be),r(js),r(ye),r(Is),r(ve),r(Fs),r(Ls),r(As),r(Me),r(Rs),r(Us),r(we),r(zs),r(Ee),r(Ds),r(Ce),r(Bs),r(Ws),r(Ns),r(Je),r(Gs),r(Zs),r(He),r(Qs),r(Xs),r(Vs),r(ke),r(Ys),r(Ss),r(Ie),r(Ks),r(Fe),r(qs),r(Le),r(Os),r(eo),r(to),r(Ae),r(ro),r(so),r(Ue),r(oo),r(ze),r(ao),r(De),r(lo),r(co),r(io),r(Be),r(po),r(mo),r(Ne),r(no),r(Ge),r(uo),r(Ze),r(ho),r(_o),r(fo),r(Qe),r(go),r(xo),r(Ve),r(To),r(Ye),r(bo),r(Se),r(yo),r(vo),r(Mo),r(Ke),r($o),r(wo),r(Oe),r(Eo),r(et),r(Co),r(tt),r(Jo),r(Po),r(Ho),r(rt),r(ko),r(jo),r(ot),r(Io),r(at),r(Fo),r(Lo),r(Ao),r(lt),r(Ro),r(Uo),r(ct),r(zo),r(it),r(Do),r(pt),r(Bo),r(Wo),r(No),r(mt),r(Go),r(Zo),r(ut),r(Qo),r(ht),r(Xo),r(Vo),r(Yo),r(_t),r(So),r(Ko),r(gt),r(qo),r(xt),r(Oo),r(Tt),r(ea),r(ta),r(ra),r(bt),r(sa),r(oa),r(vt),r(aa),r(Mt),r(la),r(da),r(wt),r(ca),r(ia),r(Ct),r(pa),r(ma),r(na),r(Jt),r(ua),r(ha),r(Ht),r(_a),r(kt),r(fa),r(jt),r(ga),r(It),r(xa),r(Ta),r(ba),r(Ft),r(ya),r(va),r(At),r(Ma),r(Rt),r($a),r(Ut),r(wa),r(Ea),r(Ca),r(zt),r(Ja),r(Pa),r(Bt),r(Ha),r(Wt),r(ka),r(ja),r(Ia),r(Nt),r(Fa),r(La),r(Zt),r(Aa),r(Qt),r(Ra),r(Ua),r(za),r(Xt),r(Da),r(Ba),r(Yt),r(Wa),r(St),r(Na),r(Ga),r(Za),r(Kt),r(Qa),r(Xa),r(Ot),r(Va),r(er),r(Ya),r(Sa),r(Ka),r(tr),r(qa),r(Oa),r(sr),r(el),r(or),r(tl),r(rl),r(sl),r(lr)),r(x),_(b,e),_(M,e),_(E,e),_(H,e),_(F,e),_(z,e),_(N,e),_(V,e),_(O,e),_(oe,e),_(ie,e),_(he,e),_(Te,e),_($e,e),_(Pe,e),_(je,e),_(Re,e),_(We,e),_(Xe,e),_(qe,e),_(st,e),_(dt,e),_(nt,e),_(ft,e),_(yt,e),_($t,e),_(Et,e),_(Pt,e),_(Lt,e),_(Dt,e),_(Gt,e),_(Vt,e),_(qt,e),_(rr,e)}}}const Gd='{"title":"processors","local":"processors","sections":[{"title":"processors.FeatureExtractor ⇐ <code> Callable </code>","local":"processorsfeatureextractor--code-callable-code","sections":[{"title":"new FeatureExtractor(config)","local":"new-featureextractorconfig","sections":[],"depth":3}],"depth":2},{"title":"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>","local":"processorsimagefeatureextractor--code-featureextractor-code","sections":[{"title":"new ImageFeatureExtractor(config)","local":"new-imagefeatureextractorconfig","sections":[],"depth":3},{"title":"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>","local":"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>","local":"imagefeatureextractorrescalepixeldata--code-void-code","sections":[],"depth":3},{"title":"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>","local":"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>","local":"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code","sections":[],"depth":3}],"depth":2},{"title":"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>","local":"processorsdetrfeatureextractor--code-imagefeatureextractor-code","sections":[{"title":"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>","local":"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>","local":"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code","sections":[],"depth":3},{"title":"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>","local":"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>","local":"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>","local":"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>","local":"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code","sections":[],"depth":3}],"depth":2},{"title":"processors.Processor ⇐ <code> Callable </code>","local":"processorsprocessor--code-callable-code","sections":[{"title":"new Processor(feature_extractor)","local":"new-processorfeatureextractor","sections":[],"depth":3},{"title":"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>","local":"processorcallinput-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.WhisperProcessor ⇐ <code> Processor </code>","local":"processorswhisperprocessor--code-processor-code","sections":[{"title":"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>","local":"whisperprocessorcallaudio--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.AutoProcessor","local":"processorsautoprocessor","sections":[{"title":"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>","local":"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code","sections":[],"depth":3}],"depth":2},{"title":"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>","local":"processorscentertocornersformatarr--code-array--number--code","sections":[],"depth":2},{"title":"processors~HeightWidth : <code> * </code>","local":"processorsheightwidth--code--code","sections":[],"depth":2},{"title":"processors~ImageFeatureExtractorResult : <code> object </code>","local":"processorsimagefeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~PreprocessedImage : <code> object </code>","local":"processorspreprocessedimage--code-object-code","sections":[],"depth":2},{"title":"processors~DetrFeatureExtractorResult : <code> object </code>","local":"processorsdetrfeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~SamImageProcessorResult : <code> object </code>","local":"processorssamimageprocessorresult--code-object-code","sections":[],"depth":2}],"depth":1}';function Zd(ll){return Ud(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sd extends zd{constructor(x){super(),Dd(this,x,Zd,Nd,Ad,{})}}export{Sd as component};
