import{s as at,n as rt,o as it}from"../chunks/scheduler.182ea377.js";import{S as lt,i as dt,g as i,s as o,r as u,A as ct,h as l,f as n,c as s,j as y,u as f,x as b,k as _,y as t,a as c,v as p,d as m,t as h,w as g}from"../chunks/index.abf12888.js";import{D as w}from"../chunks/Docstring.93f6f462.js";import{C as st}from"../chunks/CodeBlock.57fe6e13.js";import{H as Se}from"../chunks/Heading.16916d63.js";function ut(Le){let v,ae,oe,re,C,ie,E,Ne='Tiny AutoEncoder for Stable Diffusion (TAESD) was introduced in <a href="https://github.com/madebyollin/taesd" rel="nofollow">madebyollin/taesd</a> by Ollin Boer Bohan. It is a tiny distilled version of Stable Diffusion’s VAE that can quickly decode the latents in a <a href="/docs/diffusers/v0.25.1/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> or <a href="/docs/diffusers/v0.25.1/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> almost instantly.',le,k,Fe="To use with Stable Diffusion v-2.1:",de,Z,ce,W,Ye="To use with Stable Diffusion XL 1.0",ue,V,fe,I,pe,a,j,Me,Y,ze="A tiny distilled VAE model for encoding images into latents and decoding latent representations into images.",Ue,z,Pe='<a href="/docs/diffusers/v0.25.1/en/api/models/autoencoder_tiny#diffusers.AutoencoderTiny">AutoencoderTiny</a> is a wrapper around the original implementation of <code>TAESD</code>.',Ae,P,qe=`This model inherits from <a href="/docs/diffusers/v0.25.1/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. Check the superclass documentation for its generic methods implemented for
all models (such as downloading or saving).`,Je,$,B,Ce,q,He=`Disable sliced VAE decoding. If <code>enable_slicing</code> was previously enabled, this method will go back to computing
decoding in one step.`,Ee,x,G,ke,H,Qe=`Disable tiled VAE decoding. If <code>enable_tiling</code> was previously enabled, this method will go back to computing
decoding in one step.`,Ze,M,X,We,Q,Oe=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Ve,U,D,Ie,O,Ke=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,je,K,R,Be,A,S,Ge,ee,et="raw latents -> [0, 1]",Xe,J,L,De,te,tt="[0, 1] -> raw latents",me,N,he,T,F,Re,ne,nt="Output of AutoencoderTiny encoding method.",ge,se,be;return C=new Se({props:{title:"Tiny AutoEncoder",local:"tiny-autoencoder",headingTag:"h1"}}),Z=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBBdXRvZW5jb2RlclRpbnklMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0yLTEtYmFzZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyVGlueS5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZ0YWVzZCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMnNsaWNlJTIwb2YlMjBkZWxpY2lvdXMlMjBOZXclMjBZb3JrLXN0eWxlJTIwYmVycnklMjBjaGVlc2VjYWtlJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, AutoencoderTiny

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-base&quot;</span>, torch_dtype=torch.float16
)
pipe.vae = AutoencoderTiny.from_pretrained(<span class="hljs-string">&quot;madebyollin/taesd&quot;</span>, torch_dtype=torch.float16)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;slice of delicious New York-style berry cheesecake&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),V=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBBdXRvZW5jb2RlclRpbnklMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyVGlueS5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZ0YWVzZHhsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyc2xpY2UlMjBvZiUyMGRlbGljaW91cyUyME5ldyUyMFlvcmstc3R5bGUlMjBiZXJyeSUyMGNoZWVzZWNha2UlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, AutoencoderTiny

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
)
pipe.vae = AutoencoderTiny.from_pretrained(<span class="hljs-string">&quot;madebyollin/taesdxl&quot;</span>, torch_dtype=torch.float16)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;slice of delicious New York-style berry cheesecake&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),I=new Se({props:{title:"AutoencoderTiny",local:"diffusers.AutoencoderTiny",headingTag:"h2"}}),j=new w({props:{name:"class diffusers.AutoencoderTiny",anchor:"diffusers.AutoencoderTiny",parameters:[{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 3"},{name:"encoder_block_out_channels",val:": Tuple = (64, 64, 64, 64)"},{name:"decoder_block_out_channels",val:": Tuple = (64, 64, 64, 64)"},{name:"act_fn",val:": str = 'relu'"},{name:"latent_channels",val:": int = 4"},{name:"upsampling_scaling_factor",val:": int = 2"},{name:"num_encoder_blocks",val:": Tuple = (1, 3, 3, 3)"},{name:"num_decoder_blocks",val:": Tuple = (3, 3, 3, 1)"},{name:"latent_magnitude",val:": int = 3"},{name:"latent_shift",val:": float = 0.5"},{name:"force_upcast",val:": bool = False"},{name:"scaling_factor",val:": float = 1.0"}],parametersDescription:[{anchor:"diffusers.AutoencoderTiny.in_channels",description:"<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014; Number of channels in the input image.",name:"in_channels"},{anchor:"diffusers.AutoencoderTiny.out_channels",description:"<strong>out_channels</strong> (<code>int</code>,  <em>optional</em>, defaults to 3) &#x2014; Number of channels in the output.",name:"out_channels"},{anchor:"diffusers.AutoencoderTiny.encoder_block_out_channels",description:`<strong>encoder_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64, 64, 64, 64)</code>) &#x2014;
Tuple of integers representing the number of output channels for each encoder block. The length of the
tuple should be equal to the number of encoder blocks.`,name:"encoder_block_out_channels"},{anchor:"diffusers.AutoencoderTiny.decoder_block_out_channels",description:`<strong>decoder_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64, 64, 64, 64)</code>) &#x2014;
Tuple of integers representing the number of output channels for each decoder block. The length of the
tuple should be equal to the number of decoder blocks.`,name:"decoder_block_out_channels"},{anchor:"diffusers.AutoencoderTiny.act_fn",description:`<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
Activation function to be used throughout the model.`,name:"act_fn"},{anchor:"diffusers.AutoencoderTiny.latent_channels",description:`<strong>latent_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of channels in the latent representation. The latent space acts as a compressed representation of
the input image.`,name:"latent_channels"},{anchor:"diffusers.AutoencoderTiny.upsampling_scaling_factor",description:`<strong>upsampling_scaling_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Scaling factor for upsampling in the decoder. It determines the size of the output image during the
upsampling process.`,name:"upsampling_scaling_factor"},{anchor:"diffusers.AutoencoderTiny.num_encoder_blocks",description:`<strong>num_encoder_blocks</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(1, 3, 3, 3)</code>) &#x2014;
Tuple of integers representing the number of encoder blocks at each stage of the encoding process. The
length of the tuple should be equal to the number of stages in the encoder. Each stage has a different
number of encoder blocks.`,name:"num_encoder_blocks"},{anchor:"diffusers.AutoencoderTiny.num_decoder_blocks",description:`<strong>num_decoder_blocks</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(3, 3, 3, 1)</code>) &#x2014;
Tuple of integers representing the number of decoder blocks at each stage of the decoding process. The
length of the tuple should be equal to the number of stages in the decoder. Each stage has a different
number of decoder blocks.`,name:"num_decoder_blocks"},{anchor:"diffusers.AutoencoderTiny.latent_magnitude",description:`<strong>latent_magnitude</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
Magnitude of the latent representation. This parameter scales the latent representation values to control
the extent of information preservation.`,name:"latent_magnitude"},{anchor:"diffusers.AutoencoderTiny.latent_shift",description:`<strong>latent_shift</strong> (float, <em>optional</em>, defaults to 0.5) &#x2014;
Shift applied to the latent representation. This parameter controls the center of the latent space.`,name:"latent_shift"},{anchor:"diffusers.AutoencoderTiny.scaling_factor",description:`<strong>scaling_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The component-wise standard deviation of the trained latent space computed using the first batch of the
training set. This is used to scale the latent space to have unit variance when training the diffusion
model. The latents are scaled with the formula <code>z = z * scaling_factor</code> before being passed to the
diffusion model. When decoding, the latents are scaled back to the original scale with the formula: <code>z = 1 / scaling_factor * z</code>. For more details, refer to sections 4.3.2 and D.1 of the <a href="https://arxiv.org/abs/2112.10752" rel="nofollow">High-Resolution Image
Synthesis with Latent Diffusion Models</a> paper. For this Autoencoder,
however, no such scaling factor was used, hence the value of 1.0 as the default.`,name:"scaling_factor"},{anchor:"diffusers.AutoencoderTiny.force_upcast",description:`<strong>force_upcast</strong> (<code>bool</code>, <em>optional</em>, default to <code>False</code>) &#x2014;
If enabled it will force the VAE to run in float32 for high image resolution pipelines, such as SD-XL. VAE
can be fine-tuned / trained to a lower range without losing too much precision, in which case
<code>force_upcast</code> can be set to <code>False</code> (see this fp16-friendly
<a href="https://huggingface.co/madebyollin/sdxl-vae-fp16-fix" rel="nofollow">AutoEncoder</a>).`,name:"force_upcast"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.1/src/diffusers/models/autoencoders/autoencoder_tiny.py#L41"}}),B=new w({props:{name:"disable_slicing",anchor:"diffusers.AutoencoderTiny.disable_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.1/src/diffusers/models/autoencoders/autoencoder_tiny.py#L173"}}),G=new w({props:{name:"disable_tiling",anchor:"diffusers.AutoencoderTiny.disable_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.1/src/diffusers/models/autoencoders/autoencoder_tiny.py#L188"}}),X=new w({props:{name:"enable_slicing",anchor:"diffusers.AutoencoderTiny.enable_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.1/src/diffusers/models/autoencoders/autoencoder_tiny.py#L166"}}),D=new w({props:{name:"enable_tiling",anchor:"diffusers.AutoencoderTiny.enable_tiling",parameters:[{name:"use_tiling",val:": bool = True"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.1/src/diffusers/models/autoencoders/autoencoder_tiny.py#L180"}}),R=new w({props:{name:"forward",anchor:"diffusers.AutoencoderTiny.forward",parameters:[{name:"sample",val:": FloatTensor"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.AutoencoderTiny.forward.sample",description:"<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014; Input sample.",name:"sample"},{anchor:"diffusers.AutoencoderTiny.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>DecoderOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.1/src/diffusers/models/autoencoders/autoencoder_tiny.py#L320"}}),S=new w({props:{name:"scale_latents",anchor:"diffusers.AutoencoderTiny.scale_latents",parameters:[{name:"x",val:": FloatTensor"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.1/src/diffusers/models/autoencoders/autoencoder_tiny.py#L158"}}),L=new w({props:{name:"unscale_latents",anchor:"diffusers.AutoencoderTiny.unscale_latents",parameters:[{name:"x",val:": FloatTensor"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.1/src/diffusers/models/autoencoders/autoencoder_tiny.py#L162"}}),N=new Se({props:{title:"AutoencoderTinyOutput",local:"diffusers.models.autoencoders.autoencoder_tiny.AutoencoderTinyOutput",headingTag:"h2"}}),F=new w({props:{name:"class diffusers.models.autoencoders.autoencoder_tiny.AutoencoderTinyOutput",anchor:"diffusers.models.autoencoders.autoencoder_tiny.AutoencoderTinyOutput",parameters:[{name:"latents",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.models.autoencoders.autoencoder_tiny.AutoencoderTinyOutput.latents",description:"<strong>latents</strong> (<code>torch.Tensor</code>) &#x2014; Encoded outputs of the <code>Encoder</code>.",name:"latents"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.1/src/diffusers/models/autoencoders/autoencoder_tiny.py#L28"}}),{c(){v=i("meta"),ae=o(),oe=i("p"),re=o(),u(C.$$.fragment),ie=o(),E=i("p"),E.innerHTML=Ne,le=o(),k=i("p"),k.textContent=Fe,de=o(),u(Z.$$.fragment),ce=o(),W=i("p"),W.textContent=Ye,ue=o(),u(V.$$.fragment),fe=o(),u(I.$$.fragment),pe=o(),a=i("div"),u(j.$$.fragment),Me=o(),Y=i("p"),Y.textContent=ze,Ue=o(),z=i("p"),z.innerHTML=Pe,Ae=o(),P=i("p"),P.innerHTML=qe,Je=o(),$=i("div"),u(B.$$.fragment),Ce=o(),q=i("p"),q.innerHTML=He,Ee=o(),x=i("div"),u(G.$$.fragment),ke=o(),H=i("p"),H.innerHTML=Qe,Ze=o(),M=i("div"),u(X.$$.fragment),We=o(),Q=i("p"),Q.textContent=Oe,Ve=o(),U=i("div"),u(D.$$.fragment),Ie=o(),O=i("p"),O.textContent=Ke,je=o(),K=i("div"),u(R.$$.fragment),Be=o(),A=i("div"),u(S.$$.fragment),Ge=o(),ee=i("p"),ee.textContent=et,Xe=o(),J=i("div"),u(L.$$.fragment),De=o(),te=i("p"),te.textContent=tt,me=o(),u(N.$$.fragment),he=o(),T=i("div"),u(F.$$.fragment),Re=o(),ne=i("p"),ne.textContent=nt,ge=o(),se=i("p"),this.h()},l(e){const r=ct("svelte-u9bgzb",document.head);v=l(r,"META",{name:!0,content:!0}),r.forEach(n),ae=s(e),oe=l(e,"P",{}),y(oe).forEach(n),re=s(e),f(C.$$.fragment,e),ie=s(e),E=l(e,"P",{"data-svelte-h":!0}),b(E)!=="svelte-tt8a0g"&&(E.innerHTML=Ne),le=s(e),k=l(e,"P",{"data-svelte-h":!0}),b(k)!=="svelte-1j0g63g"&&(k.textContent=Fe),de=s(e),f(Z.$$.fragment,e),ce=s(e),W=l(e,"P",{"data-svelte-h":!0}),b(W)!=="svelte-dyqzt3"&&(W.textContent=Ye),ue=s(e),f(V.$$.fragment,e),fe=s(e),f(I.$$.fragment,e),pe=s(e),a=l(e,"DIV",{class:!0});var d=y(a);f(j.$$.fragment,d),Me=s(d),Y=l(d,"P",{"data-svelte-h":!0}),b(Y)!=="svelte-pqpiv3"&&(Y.textContent=ze),Ue=s(d),z=l(d,"P",{"data-svelte-h":!0}),b(z)!=="svelte-11im5hp"&&(z.innerHTML=Pe),Ae=s(d),P=l(d,"P",{"data-svelte-h":!0}),b(P)!=="svelte-s8xiwi"&&(P.innerHTML=qe),Je=s(d),$=l(d,"DIV",{class:!0});var ye=y($);f(B.$$.fragment,ye),Ce=s(ye),q=l(ye,"P",{"data-svelte-h":!0}),b(q)!=="svelte-189cc7b"&&(q.innerHTML=He),ye.forEach(n),Ee=s(d),x=l(d,"DIV",{class:!0});var _e=y(x);f(G.$$.fragment,_e),ke=s(_e),H=l(_e,"P",{"data-svelte-h":!0}),b(H)!=="svelte-1f366pl"&&(H.innerHTML=Qe),_e.forEach(n),Ze=s(d),M=l(d,"DIV",{class:!0});var ve=y(M);f(X.$$.fragment,ve),We=s(ve),Q=l(ve,"P",{"data-svelte-h":!0}),b(Q)!=="svelte-14bnrb6"&&(Q.textContent=Oe),ve.forEach(n),Ve=s(d),U=l(d,"DIV",{class:!0});var Te=y(U);f(D.$$.fragment,Te),Ie=s(Te),O=l(Te,"P",{"data-svelte-h":!0}),b(O)!=="svelte-1xwrf7t"&&(O.textContent=Ke),Te.forEach(n),je=s(d),K=l(d,"DIV",{class:!0});var ot=y(K);f(R.$$.fragment,ot),ot.forEach(n),Be=s(d),A=l(d,"DIV",{class:!0});var we=y(A);f(S.$$.fragment,we),Ge=s(we),ee=l(we,"P",{"data-svelte-h":!0}),b(ee)!=="svelte-1jovd99"&&(ee.textContent=et),we.forEach(n),Xe=s(d),J=l(d,"DIV",{class:!0});var $e=y(J);f(L.$$.fragment,$e),De=s($e),te=l($e,"P",{"data-svelte-h":!0}),b(te)!=="svelte-hggkbx"&&(te.textContent=tt),$e.forEach(n),d.forEach(n),me=s(e),f(N.$$.fragment,e),he=s(e),T=l(e,"DIV",{class:!0});var xe=y(T);f(F.$$.fragment,xe),Re=s(xe),ne=l(xe,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-11to6kt"&&(ne.textContent=nt),xe.forEach(n),ge=s(e),se=l(e,"P",{}),y(se).forEach(n),this.h()},h(){_(v,"name","hf:doc:metadata"),_(v,"content",ft),_($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){t(document.head,v),c(e,ae,r),c(e,oe,r),c(e,re,r),p(C,e,r),c(e,ie,r),c(e,E,r),c(e,le,r),c(e,k,r),c(e,de,r),p(Z,e,r),c(e,ce,r),c(e,W,r),c(e,ue,r),p(V,e,r),c(e,fe,r),p(I,e,r),c(e,pe,r),c(e,a,r),p(j,a,null),t(a,Me),t(a,Y),t(a,Ue),t(a,z),t(a,Ae),t(a,P),t(a,Je),t(a,$),p(B,$,null),t($,Ce),t($,q),t(a,Ee),t(a,x),p(G,x,null),t(x,ke),t(x,H),t(a,Ze),t(a,M),p(X,M,null),t(M,We),t(M,Q),t(a,Ve),t(a,U),p(D,U,null),t(U,Ie),t(U,O),t(a,je),t(a,K),p(R,K,null),t(a,Be),t(a,A),p(S,A,null),t(A,Ge),t(A,ee),t(a,Xe),t(a,J),p(L,J,null),t(J,De),t(J,te),c(e,me,r),p(N,e,r),c(e,he,r),c(e,T,r),p(F,T,null),t(T,Re),t(T,ne),c(e,ge,r),c(e,se,r),be=!0},p:rt,i(e){be||(m(C.$$.fragment,e),m(Z.$$.fragment,e),m(V.$$.fragment,e),m(I.$$.fragment,e),m(j.$$.fragment,e),m(B.$$.fragment,e),m(G.$$.fragment,e),m(X.$$.fragment,e),m(D.$$.fragment,e),m(R.$$.fragment,e),m(S.$$.fragment,e),m(L.$$.fragment,e),m(N.$$.fragment,e),m(F.$$.fragment,e),be=!0)},o(e){h(C.$$.fragment,e),h(Z.$$.fragment,e),h(V.$$.fragment,e),h(I.$$.fragment,e),h(j.$$.fragment,e),h(B.$$.fragment,e),h(G.$$.fragment,e),h(X.$$.fragment,e),h(D.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(L.$$.fragment,e),h(N.$$.fragment,e),h(F.$$.fragment,e),be=!1},d(e){e&&(n(ae),n(oe),n(re),n(ie),n(E),n(le),n(k),n(de),n(ce),n(W),n(ue),n(fe),n(pe),n(a),n(me),n(he),n(T),n(ge),n(se)),n(v),g(C,e),g(Z,e),g(V,e),g(I,e),g(j),g(B),g(G),g(X),g(D),g(R),g(S),g(L),g(N,e),g(F)}}}const ft='{"title":"Tiny AutoEncoder","local":"tiny-autoencoder","sections":[{"title":"AutoencoderTiny","local":"diffusers.AutoencoderTiny","sections":[],"depth":2},{"title":"AutoencoderTinyOutput","local":"diffusers.models.autoencoders.autoencoder_tiny.AutoencoderTinyOutput","sections":[],"depth":2}],"depth":1}';function pt(Le){return it(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends lt{constructor(v){super(),dt(this,v,pt,ut,at,{})}}export{_t as component};
