import{s as ts,n as ns,o as as}from"../chunks/scheduler.182ea377.js";import{S as os,i as is,g as o,s as n,r as p,A as ps,h as i,f as l,c as a,j as ss,u,x as r,k as ls,y as us,a as t,v as h,d as M,t as c,w as b}from"../chunks/index.abf12888.js";import{C as m}from"../chunks/CodeBlock.57fe6e13.js";import{D as rs}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as O}from"../chunks/Heading.16916d63.js";function hs(Ne){let T,ee,L,se,J,le,d,te,f,Ee='🤗 Diffusers provides a <a href="/docs/diffusers/v0.22.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin">PushToHubMixin</a> for uploading your model, scheduler, or pipeline to the Hub. It is an easy way to store your files on the Hub, and also allows you to share your work with others. Under the hood, the <a href="/docs/diffusers/v0.22.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin">PushToHubMixin</a>:',ne,y,We="<li>creates a repository on the Hub</li> <li>saves your model, scheduler, or pipeline files so they can be reloaded later</li> <li>uploads folder containing these files to the Hub</li>",ae,w,Re='This guide will show you how to use the <a href="/docs/diffusers/v0.22.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin">PushToHubMixin</a> to upload your files to the Hub.',oe,j,He='You’ll need to log in to your Hub account with your access <a href="https://huggingface.co/settings/tokens" rel="nofollow">token</a> first:',ie,I,pe,_,ue,U,xe='To push a model to the Hub, call <a href="/docs/diffusers/v0.22.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> and specify the repository id of the model to be stored on the Hub:',re,v,he,k,Ye='For models, you can also specify the <a href="loading#checkpoint-variants"><em>variant</em></a> of the weights to push to the Hub. For example, to push <code>fp16</code> weights:',Me,Z,ce,$,Qe='The <a href="/docs/diffusers/v0.22.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function saves the model’s <code>config.json</code> file and the weights are automatically saved in the <code>safetensors</code> format.',be,B,ze="Now you can reload the model from your repository on the Hub:",me,g,Te,C,Je,G,Se='To push a scheduler to the Hub, call <a href="/docs/diffusers/v0.22.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> and specify the repository id of the scheduler to be stored on the Hub:',de,V,fe,D,Ae='The <a href="/docs/diffusers/v0.22.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function saves the scheduler’s <code>scheduler_config.json</code> file to the specified repository.',ye,X,qe="Now you can reload the scheduler from your repository on the Hub:",we,N,je,E,Ie,W,Fe='You can also push an entire pipeline with all it’s components to the Hub. For example, initialize the components of a <a href="/docs/diffusers/v0.22.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> with the parameters you want:',_e,R,Ue,H,Pe='Pass all of the components to the <a href="/docs/diffusers/v0.22.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> and call <a href="/docs/diffusers/v0.22.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to push the pipeline to the Hub:',ve,x,ke,Y,Le='The <a href="/docs/diffusers/v0.22.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function saves each component to a subfolder in the repository. Now you can reload the pipeline from your repository on the Hub:',Ze,Q,$e,z,Be,S,Ke='Set <code>private=True</code> in the <a href="/docs/diffusers/v0.22.0/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function to keep your model, scheduler, or pipeline files private:',ge,A,Ce,q,Oe="Private repositories are only visible to you, and other users won’t be able to clone the repository and your repository won’t appear in search results. Even if a user has the URL to your private repository, they’ll receive a <code>404 - Sorry, we can&#39;t find the page you are looking for.</code>",Ge,F,es="To load a model, scheduler, or pipeline from private or gated repositories, set <code>use_auth_token=True</code>:",Ve,P,De,K,Xe;return J=new O({props:{title:"Push files to the Hub",local:"push-files-to-the-hub",headingTag:"h1"}}),d=new rs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/push_to_hub.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/push_to_hub.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/push_to_hub.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/push_to_hub.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/push_to_hub.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/push_to_hub.ipynb"}]}}),I=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),_=new O({props:{title:"Models",local:"models",headingTag:"h2"}}),v=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbnRyb2xOZXRNb2RlbCUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwoJTBBJTIwJTIwJTIwJTIwYmxvY2tfb3V0X2NoYW5uZWxzJTNEKDMyJTJDJTIwNjQpJTJDJTBBJTIwJTIwJTIwJTIwbGF5ZXJzX3Blcl9ibG9jayUzRDIlMkMlMEElMjAlMjAlMjAlMjBpbl9jaGFubmVscyUzRDQlMkMlMEElMjAlMjAlMjAlMjBkb3duX2Jsb2NrX3R5cGVzJTNEKCUyMkRvd25CbG9jazJEJTIyJTJDJTIwJTIyQ3Jvc3NBdHRuRG93bkJsb2NrMkQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwY3Jvc3NfYXR0ZW50aW9uX2RpbSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwY29uZGl0aW9uaW5nX2VtYmVkZGluZ19vdXRfY2hhbm5lbHMlM0QoMTYlMkMlMjAzMiklMkMlMEEpJTBBY29udHJvbG5ldC5wdXNoX3RvX2h1YiglMjJteS1jb250cm9sbmV0LW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel

controlnet = ControlNetModel(
    block_out_channels=(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>),
    layers_per_block=<span class="hljs-number">2</span>,
    in_channels=<span class="hljs-number">4</span>,
    down_block_types=(<span class="hljs-string">&quot;DownBlock2D&quot;</span>, <span class="hljs-string">&quot;CrossAttnDownBlock2D&quot;</span>),
    cross_attention_dim=<span class="hljs-number">32</span>,
    conditioning_embedding_out_channels=(<span class="hljs-number">16</span>, <span class="hljs-number">32</span>),
)
controlnet.push_to_hub(<span class="hljs-string">&quot;my-controlnet-model&quot;</span>)`,wrap:!1}}),Z=new m({props:{code:"Y29udHJvbG5ldC5wdXNoX3RvX2h1YiglMjJteS1jb250cm9sbmV0LW1vZGVsJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIp",highlighted:'controlnet.push_to_hub(<span class="hljs-string">&quot;my-controlnet-model&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)',wrap:!1}}),g=new m({props:{code:"bW9kZWwlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnlvdXItbmFtZXNwYWNlJTJGbXktY29udHJvbG5ldC1tb2RlbCUyMik=",highlighted:'model = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;your-namespace/my-controlnet-model&quot;</span>)',wrap:!1}}),C=new O({props:{title:"Scheduler",local:"scheduler",headingTag:"h2"}}),V=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1TY2hlZHVsZXIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMGJldGFfc3RhcnQlM0QwLjAwMDg1JTJDJTBBJTIwJTIwJTIwJTIwYmV0YV9lbmQlM0QwLjAxMiUyQyUwQSUyMCUyMCUyMCUyMGJldGFfc2NoZWR1bGUlM0QlMjJzY2FsZWRfbGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9zYW1wbGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHNldF9hbHBoYV90b19vbmUlM0RGYWxzZSUyQyUwQSklMEFzY2hlZHVsZXIucHVzaF90b19odWIoJTIybXktY29udHJvbG5ldC1zY2hlZHVsZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler

scheduler = DDIMScheduler(
    beta_start=<span class="hljs-number">0.00085</span>,
    beta_end=<span class="hljs-number">0.012</span>,
    beta_schedule=<span class="hljs-string">&quot;scaled_linear&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    set_alpha_to_one=<span class="hljs-literal">False</span>,
)
scheduler.push_to_hub(<span class="hljs-string">&quot;my-controlnet-scheduler&quot;</span>)`,wrap:!1}}),N=new m({props:{code:"c2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci1uYW1lcHNhY2UlMkZteS1jb250cm9sbmV0LXNjaGVkdWxlciUyMik=",highlighted:'scheduler = DDIMScheduler.from_pretrained(<span class="hljs-string">&quot;your-namepsace/my-controlnet-scheduler&quot;</span>)',wrap:!1}}),E=new O({props:{title:"Pipeline",local:"pipeline",headingTag:"h2"}}),R=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    UNet2DConditionModel,
    AutoencoderKL,
    DDIMScheduler,
    StableDiffusionPipeline,
)
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTextModel, CLIPTextConfig, CLIPTokenizer

unet = UNet2DConditionModel(
    block_out_channels=(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>),
    layers_per_block=<span class="hljs-number">2</span>,
    sample_size=<span class="hljs-number">32</span>,
    in_channels=<span class="hljs-number">4</span>,
    out_channels=<span class="hljs-number">4</span>,
    down_block_types=(<span class="hljs-string">&quot;DownBlock2D&quot;</span>, <span class="hljs-string">&quot;CrossAttnDownBlock2D&quot;</span>),
    up_block_types=(<span class="hljs-string">&quot;CrossAttnUpBlock2D&quot;</span>, <span class="hljs-string">&quot;UpBlock2D&quot;</span>),
    cross_attention_dim=<span class="hljs-number">32</span>,
)

scheduler = DDIMScheduler(
    beta_start=<span class="hljs-number">0.00085</span>,
    beta_end=<span class="hljs-number">0.012</span>,
    beta_schedule=<span class="hljs-string">&quot;scaled_linear&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    set_alpha_to_one=<span class="hljs-literal">False</span>,
)

vae = AutoencoderKL(
    block_out_channels=[<span class="hljs-number">32</span>, <span class="hljs-number">64</span>],
    in_channels=<span class="hljs-number">3</span>,
    out_channels=<span class="hljs-number">3</span>,
    down_block_types=[<span class="hljs-string">&quot;DownEncoderBlock2D&quot;</span>, <span class="hljs-string">&quot;DownEncoderBlock2D&quot;</span>],
    up_block_types=[<span class="hljs-string">&quot;UpDecoderBlock2D&quot;</span>, <span class="hljs-string">&quot;UpDecoderBlock2D&quot;</span>],
    latent_channels=<span class="hljs-number">4</span>,
)

text_encoder_config = CLIPTextConfig(
    bos_token_id=<span class="hljs-number">0</span>,
    eos_token_id=<span class="hljs-number">2</span>,
    hidden_size=<span class="hljs-number">32</span>,
    intermediate_size=<span class="hljs-number">37</span>,
    layer_norm_eps=<span class="hljs-number">1e-05</span>,
    num_attention_heads=<span class="hljs-number">4</span>,
    num_hidden_layers=<span class="hljs-number">5</span>,
    pad_token_id=<span class="hljs-number">1</span>,
    vocab_size=<span class="hljs-number">1000</span>,
)
text_encoder = CLIPTextModel(text_encoder_config)
tokenizer = CLIPTokenizer.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/tiny-random-clip&quot;</span>)`,wrap:!1}}),x=new m({props:{code:"Y29tcG9uZW50cyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnVuZXQlMjIlM0ElMjB1bmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwc2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwJTIydmFlJTIyJTNBJTIwdmFlJTJDJTBBJTIwJTIwJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwdGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwJTIydG9rZW5pemVyJTIyJTNBJTIwdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIyc2FmZXR5X2NoZWNrZXIlMjIlM0ElMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjBOb25lJTJDJTBBJTdEJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSgqKmNvbXBvbmVudHMpJTBBcGlwZWxpbmUucHVzaF90b19odWIoJTIybXktcGlwZWxpbmUlMjIp",highlighted:`components = {
    <span class="hljs-string">&quot;unet&quot;</span>: unet,
    <span class="hljs-string">&quot;scheduler&quot;</span>: scheduler,
    <span class="hljs-string">&quot;vae&quot;</span>: vae,
    <span class="hljs-string">&quot;text_encoder&quot;</span>: text_encoder,
    <span class="hljs-string">&quot;tokenizer&quot;</span>: tokenizer,
    <span class="hljs-string">&quot;safety_checker&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;feature_extractor&quot;</span>: <span class="hljs-literal">None</span>,
}

pipeline = StableDiffusionPipeline(**components)
pipeline.push_to_hub(<span class="hljs-string">&quot;my-pipeline&quot;</span>)`,wrap:!1}}),Q=new m({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci1uYW1lc3BhY2UlMkZteS1waXBlbGluZSUyMik=",highlighted:'pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;your-namespace/my-pipeline&quot;</span>)',wrap:!1}}),z=new O({props:{title:"Privacy",local:"privacy",headingTag:"h2"}}),A=new m({props:{code:"Y29udHJvbG5ldC5wdXNoX3RvX2h1YiglMjJteS1jb250cm9sbmV0LW1vZGVsLXByaXZhdGUlMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:'controlnet.push_to_hub(<span class="hljs-string">&quot;my-controlnet-model-private&quot;</span>, private=<span class="hljs-literal">True</span>)',wrap:!1}}),P=new m({props:{code:"bW9kZWwlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnlvdXItbmFtZXNwYWNlJTJGbXktY29udHJvbG5ldC1tb2RlbC1wcml2YXRlJTIyJTJDJTIwdXNlX2F1dGhfdG9rZW4lM0RUcnVlKQ==",highlighted:'model = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;your-namespace/my-controlnet-model-private&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)',wrap:!1}}),{c(){T=o("meta"),ee=n(),L=o("p"),se=n(),p(J.$$.fragment),le=n(),p(d.$$.fragment),te=n(),f=o("p"),f.innerHTML=Ee,ne=n(),y=o("ol"),y.innerHTML=We,ae=n(),w=o("p"),w.innerHTML=Re,oe=n(),j=o("p"),j.innerHTML=He,ie=n(),p(I.$$.fragment),pe=n(),p(_.$$.fragment),ue=n(),U=o("p"),U.innerHTML=xe,re=n(),p(v.$$.fragment),he=n(),k=o("p"),k.innerHTML=Ye,Me=n(),p(Z.$$.fragment),ce=n(),$=o("p"),$.innerHTML=Qe,be=n(),B=o("p"),B.textContent=ze,me=n(),p(g.$$.fragment),Te=n(),p(C.$$.fragment),Je=n(),G=o("p"),G.innerHTML=Se,de=n(),p(V.$$.fragment),fe=n(),D=o("p"),D.innerHTML=Ae,ye=n(),X=o("p"),X.textContent=qe,we=n(),p(N.$$.fragment),je=n(),p(E.$$.fragment),Ie=n(),W=o("p"),W.innerHTML=Fe,_e=n(),p(R.$$.fragment),Ue=n(),H=o("p"),H.innerHTML=Pe,ve=n(),p(x.$$.fragment),ke=n(),Y=o("p"),Y.innerHTML=Le,Ze=n(),p(Q.$$.fragment),$e=n(),p(z.$$.fragment),Be=n(),S=o("p"),S.innerHTML=Ke,ge=n(),p(A.$$.fragment),Ce=n(),q=o("p"),q.innerHTML=Oe,Ge=n(),F=o("p"),F.innerHTML=es,Ve=n(),p(P.$$.fragment),De=n(),K=o("p"),this.h()},l(e){const s=ps("svelte-u9bgzb",document.head);T=i(s,"META",{name:!0,content:!0}),s.forEach(l),ee=a(e),L=i(e,"P",{}),ss(L).forEach(l),se=a(e),u(J.$$.fragment,e),le=a(e),u(d.$$.fragment,e),te=a(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1e5sfak"&&(f.innerHTML=Ee),ne=a(e),y=i(e,"OL",{"data-svelte-h":!0}),r(y)!=="svelte-11ocvlf"&&(y.innerHTML=We),ae=a(e),w=i(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-4s5ymh"&&(w.innerHTML=Re),oe=a(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1bojsgz"&&(j.innerHTML=He),ie=a(e),u(I.$$.fragment,e),pe=a(e),u(_.$$.fragment,e),ue=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1sawvgi"&&(U.innerHTML=xe),re=a(e),u(v.$$.fragment,e),he=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1eiubrc"&&(k.innerHTML=Ye),Me=a(e),u(Z.$$.fragment,e),ce=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1jm461p"&&($.innerHTML=Qe),be=a(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1bcc50k"&&(B.textContent=ze),me=a(e),u(g.$$.fragment,e),Te=a(e),u(C.$$.fragment,e),Je=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1mv37x6"&&(G.innerHTML=Se),de=a(e),u(V.$$.fragment,e),fe=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-14agmmh"&&(D.innerHTML=Ae),ye=a(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-rpu5q4"&&(X.textContent=qe),we=a(e),u(N.$$.fragment,e),je=a(e),u(E.$$.fragment,e),Ie=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-rv9uap"&&(W.innerHTML=Fe),_e=a(e),u(R.$$.fragment,e),Ue=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-x901v5"&&(H.innerHTML=Pe),ve=a(e),u(x.$$.fragment,e),ke=a(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-15e2ncl"&&(Y.innerHTML=Le),Ze=a(e),u(Q.$$.fragment,e),$e=a(e),u(z.$$.fragment,e),Be=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1t67y12"&&(S.innerHTML=Ke),ge=a(e),u(A.$$.fragment,e),Ce=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1xaf5nd"&&(q.innerHTML=Oe),Ge=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1fm5zde"&&(F.innerHTML=es),Ve=a(e),u(P.$$.fragment,e),De=a(e),K=i(e,"P",{}),ss(K).forEach(l),this.h()},h(){ls(T,"name","hf:doc:metadata"),ls(T,"content",Ms)},m(e,s){us(document.head,T),t(e,ee,s),t(e,L,s),t(e,se,s),h(J,e,s),t(e,le,s),h(d,e,s),t(e,te,s),t(e,f,s),t(e,ne,s),t(e,y,s),t(e,ae,s),t(e,w,s),t(e,oe,s),t(e,j,s),t(e,ie,s),h(I,e,s),t(e,pe,s),h(_,e,s),t(e,ue,s),t(e,U,s),t(e,re,s),h(v,e,s),t(e,he,s),t(e,k,s),t(e,Me,s),h(Z,e,s),t(e,ce,s),t(e,$,s),t(e,be,s),t(e,B,s),t(e,me,s),h(g,e,s),t(e,Te,s),h(C,e,s),t(e,Je,s),t(e,G,s),t(e,de,s),h(V,e,s),t(e,fe,s),t(e,D,s),t(e,ye,s),t(e,X,s),t(e,we,s),h(N,e,s),t(e,je,s),h(E,e,s),t(e,Ie,s),t(e,W,s),t(e,_e,s),h(R,e,s),t(e,Ue,s),t(e,H,s),t(e,ve,s),h(x,e,s),t(e,ke,s),t(e,Y,s),t(e,Ze,s),h(Q,e,s),t(e,$e,s),h(z,e,s),t(e,Be,s),t(e,S,s),t(e,ge,s),h(A,e,s),t(e,Ce,s),t(e,q,s),t(e,Ge,s),t(e,F,s),t(e,Ve,s),h(P,e,s),t(e,De,s),t(e,K,s),Xe=!0},p:ns,i(e){Xe||(M(J.$$.fragment,e),M(d.$$.fragment,e),M(I.$$.fragment,e),M(_.$$.fragment,e),M(v.$$.fragment,e),M(Z.$$.fragment,e),M(g.$$.fragment,e),M(C.$$.fragment,e),M(V.$$.fragment,e),M(N.$$.fragment,e),M(E.$$.fragment,e),M(R.$$.fragment,e),M(x.$$.fragment,e),M(Q.$$.fragment,e),M(z.$$.fragment,e),M(A.$$.fragment,e),M(P.$$.fragment,e),Xe=!0)},o(e){c(J.$$.fragment,e),c(d.$$.fragment,e),c(I.$$.fragment,e),c(_.$$.fragment,e),c(v.$$.fragment,e),c(Z.$$.fragment,e),c(g.$$.fragment,e),c(C.$$.fragment,e),c(V.$$.fragment,e),c(N.$$.fragment,e),c(E.$$.fragment,e),c(R.$$.fragment,e),c(x.$$.fragment,e),c(Q.$$.fragment,e),c(z.$$.fragment,e),c(A.$$.fragment,e),c(P.$$.fragment,e),Xe=!1},d(e){e&&(l(ee),l(L),l(se),l(le),l(te),l(f),l(ne),l(y),l(ae),l(w),l(oe),l(j),l(ie),l(pe),l(ue),l(U),l(re),l(he),l(k),l(Me),l(ce),l($),l(be),l(B),l(me),l(Te),l(Je),l(G),l(de),l(fe),l(D),l(ye),l(X),l(we),l(je),l(Ie),l(W),l(_e),l(Ue),l(H),l(ve),l(ke),l(Y),l(Ze),l($e),l(Be),l(S),l(ge),l(Ce),l(q),l(Ge),l(F),l(Ve),l(De),l(K)),l(T),b(J,e),b(d,e),b(I,e),b(_,e),b(v,e),b(Z,e),b(g,e),b(C,e),b(V,e),b(N,e),b(E,e),b(R,e),b(x,e),b(Q,e),b(z,e),b(A,e),b(P,e)}}}const Ms='{"title":"Push files to the Hub","local":"push-files-to-the-hub","sections":[{"title":"Models","local":"models","sections":[],"depth":2},{"title":"Scheduler","local":"scheduler","sections":[],"depth":2},{"title":"Pipeline","local":"pipeline","sections":[],"depth":2},{"title":"Privacy","local":"privacy","sections":[],"depth":2}],"depth":1}';function cs(Ne){return as(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fs extends os{constructor(T){super(),is(this,T,cs,hs,ts,{})}}export{fs as component};
