import{s as bl,f as dl,n as Tl,o as fl}from"../chunks/scheduler.37c15a92.js";import{S as Il,i as gl,g as p,s as a,r as Z,A as Cl,h as i,f as s,c as n,j as al,u as B,x as M,k as o,y as kl,a as t,v as x,d as W,t as A,w as v}from"../chunks/index.2bf4358c.js";import{C as Ul}from"../chunks/CodeBlock.4f5fc1ad.js";import{D as Gl}from"../chunks/DocNotebookDropdown.d9dfeb24.js";import{H as nl}from"../chunks/Heading.8ada512a.js";function Zl(ol){let m,$,Q,E,y,R,u,_,w,pl="现在我们可以构建和共享一个基本接口, 让我们来探索一些更高级的特性, 如状态和解释。",q,h,Y,J,il="Gradio 支持 <em>会话状态</em>, 其中数据在页面加载中的多个提交中持续存在。会话状态对于构建演示很有用, 例如, 你希望在用户与模型交互时保留数据的聊天机器人。请注意, 会话状态不会在模型的不同用户之间共享数据。",N,j,rl="要将数据存储在会话状态中, 你需要做三件事:",z,d,cl="<li>向函数中传递一个 <em>额外的参数</em> , 该参数表示接口的状态。</li> <li>在函数结束时, 将状态的更新值作为 <em>额外的返回值</em> 返回。</li> <li>在创建<code>接口</code>时添加 ‘state’ 输入和 ‘state’ 输出组件。</li>",X,U,Ml="请参阅下面的聊天机器人示例:",V,b,F,r,ml,H,T,yl="请注意输出组件的状态如何在提交之间保持不变。注意: 可以给 state 参数传入一个默认值, 作为 state 的初始值。",D,f,L,I,ul="大多数机器学习模型都是黑盒子, 函数的内部逻辑对终端用户是隐藏的。为了提高透明度, 我们通过简单地将 Interface 类中的解释关键字设置为默认值, 使向模型添加解释变得非常容易。这允许你的用户理解输入的哪些部分负责输出。看看下面这个简单的接口, 它显示了一个还包括解释的图像分类器:",K,g,P,C,wl="通过提交一个输入, 然后单击输出组件下的Interpret来测试解释功能。",O,c,hl,ll,k,Jl='除了Gradio提供的默认解释方法之外, 你还可以为 <code>interpretation</code> 参数指定 <code>shap</code>, 并设置 <code>num_shap</code> 参数。这使用基于 Shapley 的解释, 你可以在 <a href="https://christophm.github.io/interpretable-ml-book/shap.html" rel="nofollow">here</a> 阅读更多信息。最后, 还可以将自己的解释函数传入 <code>interpretation</code> 参数。在Gradio的入门页面 <a href="https://gradio.app/getting_started/" rel="nofollow">here</a> 中可以看到一个例子。',el,G,jl="这结束了我们对Gradio的<code>Interface</code>类的深入研究。正如我们所看到的, 这个类使用几行Python代码创建机器学习演示变得简单。然而, 有时你会想通过改变布局或链接多个预测函数来定制你的demo。如果我们能以某种方式将 <code>接口</code> 分成可定制的 “块”, 那不是很好吗? 幸运的是, 有! 这是最后一部分的主题。",sl,S,tl;return y=new nl({props:{title:"高级接口功能",local:"高级接口功能",headingTag:"h1"}}),u=new Gl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter9/section6.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter9/section6.ipynb"}]}}),h=new nl({props:{title:"使用状态保存数据",local:"使用状态保存数据",headingTag:"h3"}}),b=new Ul({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGNoYXQobWVzc2FnZSUyQyUyMGhpc3RvcnkpJTNBJTBBJTIwJTIwJTIwJTIwaGlzdG9yeSUyMCUzRCUyMGhpc3RvcnklMjBvciUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZS5zdGFydHN3aXRoKCUyMkhvdyUyMG1hbnklMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByYW5kb20ucmFuZGludCgxJTJDJTIwMTApJTBBJTIwJTIwJTIwJTIwZWxpZiUyMG1lc3NhZ2Uuc3RhcnRzd2l0aCglMjJIb3clMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByYW5kb20uY2hvaWNlKCU1QiUyMkdyZWF0JTIyJTJDJTIwJTIyR29vZCUyMiUyQyUyMCUyMk9rYXklMjIlMkMlMjAlMjJCYWQlMjIlNUQpJTBBJTIwJTIwJTIwJTIwZWxpZiUyMG1lc3NhZ2Uuc3RhcnRzd2l0aCglMjJXaGVyZSUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHJhbmRvbS5jaG9pY2UoJTVCJTIySGVyZSUyMiUyQyUyMCUyMlRoZXJlJTIyJTJDJTIwJTIyU29tZXdoZXJlJTIyJTVEKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMCUyMkklMjBkb24ndCUyMGtub3clMjIlMEElMjAlMjAlMjAlMjBoaXN0b3J5LmFwcGVuZCgobWVzc2FnZSUyQyUyMHJlc3BvbnNlKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBoaXN0b3J5JTJDJTIwaGlzdG9yeSUwQSUwQSUwQWlmYWNlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGNoYXQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJ0ZXh0JTIyJTJDJTIwJTIyc3RhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJjaGF0Ym90JTIyJTJDJTIwJTIyc3RhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBhbGxvd19zY3JlZW5zaG90JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBhbGxvd19mbGFnZ2luZyUzRCUyMm5ldmVyJTIyJTJDJTBBKSUwQWlmYWNlLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> random

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">chat</span>(<span class="hljs-params">message, history</span>):
    history = history <span class="hljs-keyword">or</span> []
    <span class="hljs-keyword">if</span> message.startswith(<span class="hljs-string">&quot;How many&quot;</span>):
        response = random.randint(<span class="hljs-number">1</span>, <span class="hljs-number">10</span>)
    <span class="hljs-keyword">elif</span> message.startswith(<span class="hljs-string">&quot;How&quot;</span>):
        response = random.choice([<span class="hljs-string">&quot;Great&quot;</span>, <span class="hljs-string">&quot;Good&quot;</span>, <span class="hljs-string">&quot;Okay&quot;</span>, <span class="hljs-string">&quot;Bad&quot;</span>])
    <span class="hljs-keyword">elif</span> message.startswith(<span class="hljs-string">&quot;Where&quot;</span>):
        response = random.choice([<span class="hljs-string">&quot;Here&quot;</span>, <span class="hljs-string">&quot;There&quot;</span>, <span class="hljs-string">&quot;Somewhere&quot;</span>])
    <span class="hljs-keyword">else</span>:
        response = <span class="hljs-string">&quot;I don&#x27;t know&quot;</span>
    history.append((message, response))
    <span class="hljs-keyword">return</span> history, history


iface = gr.Interface(
    chat,
    [<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;state&quot;</span>],
    [<span class="hljs-string">&quot;chatbot&quot;</span>, <span class="hljs-string">&quot;state&quot;</span>],
    allow_screenshot=<span class="hljs-literal">False</span>,
    allow_flagging=<span class="hljs-string">&quot;never&quot;</span>,
)
iface.launch()`,wrap:!1}}),f=new nl({props:{title:"通过解释来理解预测",local:"通过解释来理解预测",headingTag:"h3"}}),g=new Ul({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQSUwQWltcG9ydCUyMGdyYWRpbyUyMGFzJTIwZ3IlMEElMEFpbmNlcHRpb25fbmV0JTIwJTNEJTIwdGYua2VyYXMuYXBwbGljYXRpb25zLk1vYmlsZU5ldFYyKCklMjAlMjAlMjMlMjBsb2FkJTIwdGhlJTIwbW9kZWwlMEElMEElMjMlMjBEb3dubG9hZCUyMGh1bWFuLXJlYWRhYmxlJTIwbGFiZWxzJTIwZm9yJTIwSW1hZ2VOZXQuJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQoJTIyaHR0cHMlM0ElMkYlMkZnaXQuaW8lMkZKSmtZTiUyMiklMEFsYWJlbHMlMjAlM0QlMjByZXNwb25zZS50ZXh0LnNwbGl0KCUyMiU1Q24lMjIpJTBBJTBBJTBBZGVmJTIwY2xhc3NpZnlfaW1hZ2UoaW5wKSUzQSUwQSUyMCUyMCUyMCUyMGlucCUyMCUzRCUyMGlucC5yZXNoYXBlKCgtMSUyQyUyMDIyNCUyQyUyMDIyNCUyQyUyMDMpKSUwQSUyMCUyMCUyMCUyMGlucCUyMCUzRCUyMHRmLmtlcmFzLmFwcGxpY2F0aW9ucy5tb2JpbGVuZXRfdjIucHJlcHJvY2Vzc19pbnB1dChpbnApJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbiUyMCUzRCUyMGluY2VwdGlvbl9uZXQucHJlZGljdChpbnApLmZsYXR0ZW4oKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QmxhYmVscyU1QmklNUQlM0ElMjBmbG9hdChwcmVkaWN0aW9uJTVCaSU1RCklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMDAwKSU3RCUwQSUwQSUwQWltYWdlJTIwJTNEJTIwZ3IuSW1hZ2Uoc2hhcGUlM0QoMjI0JTJDJTIwMjI0KSklMEFsYWJlbCUyMCUzRCUyMGdyLkxhYmVsKG51bV90b3BfY2xhc3NlcyUzRDMpJTBBJTBBdGl0bGUlMjAlM0QlMjAlMjJHcmFkaW8lMjBJbWFnZSUyMENsYXNzaWZpY3Rpb24lMjAlMkIlMjBJbnRlcnByZXRhdGlvbiUyMEV4YW1wbGUlMjIlMEFnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RjbGFzc2lmeV9pbWFnZSUyQyUyMGlucHV0cyUzRGltYWdlJTJDJTIwb3V0cHV0cyUzRGxhYmVsJTJDJTIwaW50ZXJwcmV0YXRpb24lM0QlMjJkZWZhdWx0JTIyJTJDJTIwdGl0bGUlM0R0aXRsZSUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

inception_net = tf.keras.applications.MobileNetV2()  <span class="hljs-comment"># load the model</span>

<span class="hljs-comment"># Download human-readable labels for ImageNet.</span>
response = requests.get(<span class="hljs-string">&quot;https://git.io/JJkYN&quot;</span>)
labels = response.text.split(<span class="hljs-string">&quot;\\n&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_image</span>(<span class="hljs-params">inp</span>):
    inp = inp.reshape((-<span class="hljs-number">1</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>, <span class="hljs-number">3</span>))
    inp = tf.keras.applications.mobilenet_v2.preprocess_input(inp)
    prediction = inception_net.predict(inp).flatten()
    <span class="hljs-keyword">return</span> {labels[i]: <span class="hljs-built_in">float</span>(prediction[i]) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>)}


image = gr.Image(shape=(<span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
label = gr.Label(num_top_classes=<span class="hljs-number">3</span>)

title = <span class="hljs-string">&quot;Gradio Image Classifiction + Interpretation Example&quot;</span>
gr.Interface(
    fn=classify_image, inputs=image, outputs=label, interpretation=<span class="hljs-string">&quot;default&quot;</span>, title=title
).launch()`,wrap:!1}}),{c(){m=p("meta"),$=a(),Q=p("p"),E=a(),Z(y.$$.fragment),R=a(),Z(u.$$.fragment),_=a(),w=p("p"),w.textContent=pl,q=a(),Z(h.$$.fragment),Y=a(),J=p("p"),J.innerHTML=il,N=a(),j=p("p"),j.textContent=rl,z=a(),d=p("ol"),d.innerHTML=cl,X=a(),U=p("p"),U.textContent=Ml,V=a(),Z(b.$$.fragment),F=a(),r=p("iframe"),H=a(),T=p("p"),T.textContent=yl,D=a(),Z(f.$$.fragment),L=a(),I=p("p"),I.textContent=ul,K=a(),Z(g.$$.fragment),P=a(),C=p("p"),C.textContent=wl,O=a(),c=p("iframe"),ll=a(),k=p("p"),k.innerHTML=Jl,el=a(),G=p("p"),G.innerHTML=jl,sl=a(),S=p("p"),this.h()},l(l){const e=Cl("svelte-u9bgzb",document.head);m=i(e,"META",{name:!0,content:!0}),e.forEach(s),$=n(l),Q=i(l,"P",{}),al(Q).forEach(s),E=n(l),B(y.$$.fragment,l),R=n(l),B(u.$$.fragment,l),_=n(l),w=i(l,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1njo2d0"&&(w.textContent=pl),q=n(l),B(h.$$.fragment,l),Y=n(l),J=i(l,"P",{"data-svelte-h":!0}),M(J)!=="svelte-13iexw"&&(J.innerHTML=il),N=n(l),j=i(l,"P",{"data-svelte-h":!0}),M(j)!=="svelte-52u7b5"&&(j.textContent=rl),z=n(l),d=i(l,"OL",{"data-svelte-h":!0}),M(d)!=="svelte-py0t3w"&&(d.innerHTML=cl),X=n(l),U=i(l,"P",{"data-svelte-h":!0}),M(U)!=="svelte-acbgvf"&&(U.textContent=Ml),V=n(l),B(b.$$.fragment,l),F=n(l),r=i(l,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),al(r).forEach(s),H=n(l),T=i(l,"P",{"data-svelte-h":!0}),M(T)!=="svelte-qgn2e2"&&(T.textContent=yl),D=n(l),B(f.$$.fragment,l),L=n(l),I=i(l,"P",{"data-svelte-h":!0}),M(I)!=="svelte-x0uo6q"&&(I.textContent=ul),K=n(l),B(g.$$.fragment,l),P=n(l),C=i(l,"P",{"data-svelte-h":!0}),M(C)!=="svelte-qloega"&&(C.textContent=wl),O=n(l),c=i(l,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),al(c).forEach(s),ll=n(l),k=i(l,"P",{"data-svelte-h":!0}),M(k)!=="svelte-hyesi6"&&(k.innerHTML=Jl),el=n(l),G=i(l,"P",{"data-svelte-h":!0}),M(G)!=="svelte-3fjgax"&&(G.innerHTML=jl),sl=n(l),S=i(l,"P",{}),al(S).forEach(s),this.h()},h(){o(m,"name","hf:doc:metadata"),o(m,"content",Bl),dl(r.src,ml="https://course-demos-Chatbot-Demo.hf.space")||o(r,"src",ml),o(r,"frameborder","0"),o(r,"height","350"),o(r,"title","Gradio app"),o(r,"class","container p-0 flex-grow space-iframe"),o(r,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),o(r,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),dl(c.src,hl="https://course-demos-gradio-image-interpretation.hf.space")||o(c,"src",hl),o(c,"frameborder","0"),o(c,"height","570"),o(c,"title","Gradio app"),o(c,"class","container p-0 flex-grow space-iframe"),o(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),o(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(l,e){kl(document.head,m),t(l,$,e),t(l,Q,e),t(l,E,e),x(y,l,e),t(l,R,e),x(u,l,e),t(l,_,e),t(l,w,e),t(l,q,e),x(h,l,e),t(l,Y,e),t(l,J,e),t(l,N,e),t(l,j,e),t(l,z,e),t(l,d,e),t(l,X,e),t(l,U,e),t(l,V,e),x(b,l,e),t(l,F,e),t(l,r,e),t(l,H,e),t(l,T,e),t(l,D,e),x(f,l,e),t(l,L,e),t(l,I,e),t(l,K,e),x(g,l,e),t(l,P,e),t(l,C,e),t(l,O,e),t(l,c,e),t(l,ll,e),t(l,k,e),t(l,el,e),t(l,G,e),t(l,sl,e),t(l,S,e),tl=!0},p:Tl,i(l){tl||(W(y.$$.fragment,l),W(u.$$.fragment,l),W(h.$$.fragment,l),W(b.$$.fragment,l),W(f.$$.fragment,l),W(g.$$.fragment,l),tl=!0)},o(l){A(y.$$.fragment,l),A(u.$$.fragment,l),A(h.$$.fragment,l),A(b.$$.fragment,l),A(f.$$.fragment,l),A(g.$$.fragment,l),tl=!1},d(l){l&&(s($),s(Q),s(E),s(R),s(_),s(w),s(q),s(Y),s(J),s(N),s(j),s(z),s(d),s(X),s(U),s(V),s(F),s(r),s(H),s(T),s(D),s(L),s(I),s(K),s(P),s(C),s(O),s(c),s(ll),s(k),s(el),s(G),s(sl),s(S)),s(m),v(y,l),v(u,l),v(h,l),v(b,l),v(f,l),v(g,l)}}}const Bl='{"title":"高级接口功能","local":"高级接口功能","sections":[{"title":"使用状态保存数据","local":"使用状态保存数据","sections":[],"depth":3},{"title":"通过解释来理解预测","local":"通过解释来理解预测","sections":[],"depth":3}],"depth":1}';function xl(ol){return fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $l extends Il{constructor(m){super(),gl(this,m,xl,Zl,bl,{})}}export{$l as component};
