import{s as Nw,o as Rw,n as Vw}from"../chunks/scheduler.9bc65507.js";import{S as qw,i as Aw,g as i,s as n,r as d,m as r,H as c,A as Ew,h as p,f as a,c as l,j as M,u as g,x as o,n as h,B as u,k as L,y as m,a as e,v as y,d as f,t as w,w as b}from"../chunks/index.707bf1b6.js";import{T as Yw}from"../chunks/Tip.c2ecdbf4.js";import{C as v}from"../chunks/CodeBlock.54a9f38d.js";import{D as Sw}from"../chunks/DocNotebookDropdown.3e6b3817.js";import{H as is}from"../chunks/Heading.342b1fa6.js";function Fw(hl){let G,Cs='Note that, despite our advice to use key-value caches, your LLM output may be slightly different when you use them. This is a property of the matrix multiplication kernels themselves — you can read more about it <a href="https://github.com/huggingface/transformers/issues/25420#issuecomment-1775317535" rel="nofollow">here</a>.';return{c(){G=i("p"),G.innerHTML=Cs},l(P){G=p(P,"P",{"data-svelte-h":!0}),o(G)!=="svelte-18twd2j"&&(G.innerHTML=Cs)},m(P,yn){e(P,G,yn)},p:Vw,d(P){P&&a(G)}}}function Pw(hl){let G,Cs,P,yn,zs,cl,Ls,ul,Gs,Yu=`Large Language Models (LLMs) such as GPT3/4, <a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow">Falcon</a>, and <a href="https://huggingface.co/meta-llama/Llama-2-70b-hf" rel="nofollow">Llama</a> are rapidly advancing in their ability to tackle human-centric tasks, establishing themselves as essential tools in modern knowledge-based industries.
Deploying these models in real-world tasks remains challenging, however:`,dl,Bs,Su='<li>To exhibit near-human text understanding and generation capabilities, LLMs currently require to be composed of billions of parameters (see <a href="https://arxiv.org/abs/2001.08361" rel="nofollow">Kaplan et al</a>, <a href="https://arxiv.org/abs/2206.07682" rel="nofollow">Wei et. al</a>). This consequently amplifies the memory demands for inference.</li> <li>In many real-world tasks, LLMs need to be given extensive contextual information. This necessitates the model’s capability to manage very long input sequences during inference.</li>',gl,$s,Fu="The crux of these challenges lies in augmenting the computational and memory capabilities of LLMs, especially when handling expansive input sequences.",yl,Zs,Pu="In this guide, we will go over the effective techniques for efficient LLM deployment:",fl,Is,Ku='<li><p><strong>Lower Precision:</strong> Research has shown that operating at reduced numerical precision, namely <a href="./main_classes/quantization.md">8-bit and 4-bit</a> can achieve computational advantages without a considerable decline in model performance.</p></li> <li><p><strong>Flash Attention:</strong> Flash Attention is a variation of the attention algorithm that not only provides a more memory-efficient approach but also realizes increased efficiency due to optimized GPU memory utilization.</p></li> <li><p><strong>Architectural Innovations:</strong> Considering that LLMs are always deployed in the same way during inference, namely autoregressive text generation with a long input context, specialized model architectures have been proposed that allow for more efficient inference. The most important advancement in model architectures hereby are <a href="https://arxiv.org/abs/2108.12409" rel="nofollow">Alibi</a>, <a href="https://arxiv.org/abs/2104.09864" rel="nofollow">Rotary embeddings</a>, <a href="https://arxiv.org/abs/1911.02150" rel="nofollow">Multi-Query Attention (MQA)</a> and <a href="(https://arxiv.org/abs/2305.13245)">Grouped-Query-Attention (GQA)</a>.</p></li>',wl,Ws,Du="Throughout this guide, we will offer an analysis of auto-regressive generation from a tensor’s perspective. We delve into the pros and cons of adopting lower precision, provide a comprehensive exploration of the latest attention algorithms, and discuss improved LLM architectures. While doing so, we run practical examples showcasing each of the feature improvements.",bl,Qs,vl,Hs,Ou="Memory requirements of LLMs can be best understood by seeing the LLM as a set of weight matrices and vectors and the text inputs as a sequence of vectors. In the following, the definition <em>weights</em> will be used to signify all model weight matrices and vectors.",Ml,Xs,sd='At the time of writing this guide, LLMs consist of at least a couple billion parameters. Each parameter thereby is made of a decimal number, e.g. <code>4.5689</code> which is usually stored in either <a href="https://en.wikipedia.org/wiki/Single-precision_floating-point_format" rel="nofollow">float32</a>, <a href="https://en.wikipedia.org/wiki/Bfloat16_floating-point_format" rel="nofollow">bfloat16</a>, or <a href="https://en.wikipedia.org/wiki/Half-precision_floating-point_format" rel="nofollow">float16</a> format. This allows us to easily compute the memory requirement to load the LLM into memory:',xl,Ns,td="<p><em>Loading the weights of a model having X billion parameters requires roughly 4</em> X GB of VRAM in float32 precision*</p>",kl,Rs,ad="Nowadays, models are however rarely trained in full float32 precision, but usually in bfloat16 precision or less frequently in float16 precision. Therefore the rule of thumb becomes:",Tl,Vs,ed="<p><em>Loading the weights of a model having X billion parameters requires roughly 2</em> X GB of VRAM in bfloat16/float16 precision*</p>",jl,qs,nd="For shorter text inputs (less than 1024 tokens), the memory requirement for inference is very much dominated by the memory requirement to load the weights. Therefore, for now, let’s assume that the memory requirement for inference is equal to the memory requirement to load the model into the GPU VRAM.",_l,As,ld="To give some examples of how much VRAM it roughly takes to load a model in bfloat16:",Jl,Es,id='<li><strong>GPT3</strong> requires 2 * 175 GB = <strong>350 GB</strong> VRAM</li> <li><a href="https://huggingface.co/bigscience/bloom" rel="nofollow"><strong>Bloom</strong></a> requires 2 * 176 GB = <strong>352 GB</strong> VRAM</li> <li><a href="https://huggingface.co/meta-llama/Llama-2-70b-hf" rel="nofollow"><strong>Llama-2-70b</strong></a> requires 2 * 70 GB = <strong>140 GB</strong> VRAM</li> <li><a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow"><strong>Falcon-40b</strong></a> requires 2 * 40 GB = <strong>80 GB</strong> VRAM</li> <li><a href="https://huggingface.co/mosaicml/mpt-30b" rel="nofollow"><strong>MPT-30b</strong></a> requires 2 * 30 GB = <strong>60 GB</strong> VRAM</li> <li><a href="https://huggingface.co/bigcode/starcoder" rel="nofollow"><strong>bigcode/starcoder</strong></a> requires 2 * 15.5 = <strong>31 GB</strong> VRAM</li>',Ul,Ys,pd='As of writing this document, the largest GPU chip on the market is the A100 &amp; H100 offering 80GB of VRAM. Most of the models listed before require more than 80GB just to be loaded and therefore necessarily require <a href="https://huggingface.co/docs/transformers/perf_train_gpu_many#tensor-parallelism" rel="nofollow">tensor parallelism</a> and/or <a href="https://huggingface.co/docs/transformers/perf_train_gpu_many#naive-model-parallelism-vertical-and-pipeline-parallelism" rel="nofollow">pipeline parallelism</a>.',Cl,Ss,md='🤗 Transformers does not support tensor parallelism out of the box as it requires the model architecture to be written in a specific way. If you’re interested in writing models in a tensor-parallelism-friendly way, feel free to have a look at <a href="https://github.com/huggingface/text-generation-inference/tree/main/server/text_generation_server/models/custom_modeling" rel="nofollow">the text-generation-inference library</a>.',zl,Fs,od=`Naive pipeline parallelism is supported out of the box. For this, simply load the model with <code>device=&quot;auto&quot;</code> which will automatically place the different layers on the available GPUs as explained <a href="https://huggingface.co/docs/accelerate/v0.22.0/en/concept_guides/big_model_inference" rel="nofollow">here</a>.
Note, however that while very effective, this naive pipeline parallelism does not tackle the issues of GPU idling. For this more advanced pipeline parallelism is required as explained <a href="https://huggingface.co/docs/transformers/en/perf_train_gpu_many#naive-model-parallelism-vertical-and-pipeline-parallelism" rel="nofollow">here</a>.`,Ll,Ps,rd="If you have access to an 8 x 80GB A100 node, you could load BLOOM as follows",Gl,Ks,Bl,Ds,$l,Os,hd="By using <code>device_map=&quot;auto&quot;</code> the attention layers would be equally distributed over all available GPUs.",Zl,st,cd='In this guide, we will use <a href="https://huggingface.co/bigcode/octocoder" rel="nofollow">bigcode/octocoder</a> as it can be run on a single 40 GB A100 GPU device chip. Note that all memory and speed optimizations that we will apply going forward, are equally applicable to models that require model or tensor parallelism.',Il,tt,ud="Since the model is loaded in bfloat16 precision, using our rule of thumb above, we would expect the memory requirement to run inference with <code>bigcode/octocoder</code> to be around 31 GB VRAM. Let’s give it a try.",Wl,at,dd='We first load the model and tokenizer and then pass both to Transformers’ <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow">pipeline</a> object.',Ql,et,Hl,nt,Xl,lt,gd="<strong>Output</strong>:",Nl,it,Rl,pt,yd="Nice, we can now directly use the result to convert bytes into Gigabytes.",Vl,mt,ql,ot,fd='Let’s call <a href="https://pytorch.org/docs/stable/generated/torch.cuda.max_memory_allocated.html" rel="nofollow"><code>torch.cuda.max_memory_allocated</code></a> to measure the peak GPU memory allocation.',Al,rt,El,ht,wd="<strong>Output</strong>:",Yl,ct,Sl,ut,bd=`Close enough to our back-of-the-envelope computation! We can see the number is not exactly correct as going from bytes to kilobytes requires a multiplication of 1024 instead of 1000. Therefore the back-of-the-envelope formula can also be understood as an “at most X GB” computation.
Note that if we had tried to run the model in full float32 precision, a whopping 64 GB of VRAM would have been required.`,Fl,dt,vd='<p>Almost all models are trained in bfloat16 nowadays, there is no reason to run the model in full float32 precision if <a href="https://discuss.pytorch.org/t/bfloat16-native-support/117155/5" rel="nofollow">your GPU supports bfloat16</a>. Float32 won’t give better inference results than the precision that was used to train the model.</p>',Pl,gt,Md='If you are unsure in which format the model weights are stored on the Hub, you can always look into the checkpoint’s config under <code>&quot;torch_dtype&quot;</code>, <em>e.g.</em> <a href="https://huggingface.co/meta-llama/Llama-2-7b-hf/blob/6fdf2e60f86ff2481f2241aaee459f85b5b0bbb9/config.json#L21" rel="nofollow">here</a>. It is recommended to set the model to the same precision type as written in the config when loading with <code>from_pretrained(..., torch_dtype=...)</code> except when the original type is float32 in which case one can use both <code>float16</code> or <code>bfloat16</code> for inference.',Kl,yt,xd="Let’s define a <code>flush(...)</code> function to free all allocated memory so that we can accurately measure the peak allocated GPU memory.",Dl,ft,Ol,wt,kd="Let’s call it now for the next experiment.",si,bt,ti,vt,Td="In the recent version of the accelerate library, you can also use an utility method called <code>release_memory()</code>",ai,Mt,ei,xt,jd=`Now what if your GPU does not have 32 GB of VRAM? It has been found that model weights can be quantized to 8-bit or 4-bits without a significant loss in performance (see <a href="https://arxiv.org/abs/2208.07339" rel="nofollow">Dettmers et al.</a>).
Model can be quantized to even 3 or 2 bits with an acceptable loss in performance as shown in the recent <a href="https://arxiv.org/abs/2210.17323" rel="nofollow">GPTQ paper</a> 🤯.`,ni,kt,_d=`Without going into too many details, quantization schemes aim at reducing the precision of weights while trying to keep the model’s inference results as accurate as possible (<em>a.k.a</em> as close as possible to bfloat16).
Note that quantization works especially well for text generation since all we care about is choosing the <em>set of most likely next tokens</em> and don’t really care about the exact values of the next token <em>logit</em> distribution.
All that matters is that the next token <em>logit</em> distribution stays roughly the same so that an <code>argmax</code> or <code>topk</code> operation gives the same results.`,li,Tt,Jd="There are various quantization techniques, which we won’t discuss in detail here, but in general, all quantization techniques work as follows:",ii,jt,Ud='<li><ol><li>Quantize all weights to the target precision</li></ol></li> <li><ol start="2"><li>Load the quantized weights, and pass the input sequence of vectors in bfloat16 precision</li></ol></li> <li><ol start="3"><li>Dynamically dequantize weights to bfloat16 to perform the computation with their input vectors in bfloat16 precision</li></ol></li>',pi,B,Uc,fn,Cd="inputs-weight matrix",Cc,mi,gf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>X</mi></mrow><annotation encoding="application/x-tex"> X </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span></span></span></span>',oi,wn,zd="inputs",zc,ri,yf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>W</mi></mrow><annotation encoding="application/x-tex"> W </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">W</span></span></span></span>',hi,ci,ff='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Y</mi></mrow><annotation encoding="application/x-tex"> Y </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.22222em;">Y</span></span></span></span>',ui,di,wf='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>Y</mi><mo>=</mo><mi>X</mi><mo>∗</mo><mi>W</mi></mrow><annotation encoding="application/x-tex"> Y = X * W </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.22222em;">Y</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">W</span></span></span></span></span>',gi,_t,Lc,yi,bf='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>Y</mi><mo>=</mo><mi>X</mi><mo>∗</mo><mtext>dequantize</mtext><mo stretchy="false">(</mo><mi>W</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex"> Y = X * \\text{dequantize}(W) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.22222em;">Y</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">dequantize</span></span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.13889em;">W</span><span class="mclose">)</span></span></span></span></span>',fi,Jt,Ld="for every matrix multiplication. Dequantization and re-quantization is performed sequentially for all weight matrices as the inputs run through the network graph.",wi,Ut,Gd=`Therefore, inference time is often <strong>not</strong> reduced when using quantized weights, but rather increases.
Enough theory, let’s give it a try! To quantize the weights with Transformers, you need to make sure that
the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow"><code>bitsandbytes</code></a> library is installed.`,bi,Ct,vi,zt,Bd="We can then load models in 8-bit quantization by simply adding a <code>load_in_8bit=True</code> flag to <code>from_pretrained</code>.",Mi,Lt,xi,Gt,$d="Now, let’s run our example again and measure the memory usage.",ki,Bt,Ti,$t,Zd="<strong>Output</strong>:",ji,Zt,_i,It,Id="Nice, we’re getting the same result as before, so no loss in accuracy! Let’s look at how much memory was used this time.",Ji,Wt,Ui,Qt,Wd="<strong>Output</strong>:",Ci,Ht,zi,Xt,Qd=`Significantly less! We’re down to just a bit over 15 GBs and could therefore run this model on consumer GPUs like the 4090.
We’re seeing a very nice gain in memory efficiency and more or less no degradation to the model’s output. However, we can also notice a slight slow-down during inference.`,Li,Nt,Hd="We delete the models and flush the memory again.",Gi,Rt,Bi,Vt,$i,qt,Xd="Let’s see what peak GPU memory consumption 4-bit quantization gives. Quantizing the model to 4-bit can be done with the same API as before - this time by passing <code>load_in_4bit=True</code> instead of <code>load_in_8bit=True</code>.",Zi,At,Ii,Et,Nd="<strong>Output</strong>:",Wi,Yt,Qi,St,Rd="We’re almost seeing the same output text as before - just the <code>python</code> is missing just before the code snippet. Let’s see how much memory was required.",Hi,Ft,Xi,Pt,Vd="<strong>Output</strong>:",Ni,Kt,Ri,Dt,qd="Just 9.5GB! That’s really not a lot for a >15 billion parameter model.",Vi,Ot,Ad="While we see very little degradation in accuracy for our model here, 4-bit quantization can in practice often lead to different results compared to 8-bit quantization or full <code>bfloat16</code> inference. It is up to the user to try it out.",qi,K,Gc,Ai,vf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mtext>quantize</mtext></mrow><annotation encoding="application/x-tex"> \\text{quantize} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8623em;vertical-align:-0.1944em;"></span><span class="mord text"><span class="mord">quantize</span></span></span></span></span>',Ei,Yi,Mf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mtext>dequantize</mtext></mrow><annotation encoding="application/x-tex"> \\text{dequantize} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord text"><span class="mord">dequantize</span></span></span></span></span>',Si,Fi,sa,Pi,ta,Ki,aa,Ed="Overall, we saw that running OctoCoder in 8-bit precision reduced the required GPU VRAM from 32G GPU VRAM to only 15GB and running the model in 4-bit precision further reduces the required GPU VRAM to just a bit over 9GB.",Di,ea,Yd="4-bit quantization allows the model to be run on GPUs such as RTX3090, V100, and T4 which are quite accessible for most people.",Oi,na,Sd='For more information on quantization and to see how one can quantize models to require even less GPU VRAM memory than 4-bit, we recommend looking into the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#autogptq-integration%60" rel="nofollow"><code>AutoGPTQ</code></a> implementation.',sp,la,Fd="<p>As a conclusion, it is important to remember that model quantization trades improved memory efficiency against accuracy and in some cases inference time.</p>",tp,ia,Pd="If GPU memory is not a constraint for your use case, there is often no need to look into quantization. However many GPUs simply can’t run LLMs without quantization methods and in this case, 4-bit and 8-bit quantization schemes are extremely useful tools.",ap,pa,Kd=`For more in-detail usage information, we strongly recommend taking a look at the <a href="https://huggingface.co/docs/transformers/main_classes/quantization#general-usage" rel="nofollow">Transformers Quantization Docs</a>.
Next, let’s look into how we can improve computational and memory efficiency by using better algorithms and an improved model architecture.`,ep,ma,np,oa,Dd="Today’s top-performing LLMs share more or less the same fundamental architecture that consists of feed-forward layers, activation layers, layer normalization layers, and most crucially, self-attention layers.",lp,q,Bc,bn,Od="quadratically",$c,vn,sg="sequence length",Zc,ip,xf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',pp,mp,T,Ic,op,kf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">O</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{O} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">O</span></span></span></span>',rp,hp,Tf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">X</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{X} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">X</span></span></span></span>',cp,up,jf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',dp,gp,_f='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mtext mathvariant="bold">O</mtext><mo>=</mo><mtext>Attn</mtext><mo stretchy="false">(</mo><mi mathvariant="bold">X</mi><mo stretchy="false">)</mo><mo>=</mo><mi mathvariant="bold">V</mi><mo>×</mo><mtext>Softmax</mtext><mo stretchy="false">(</mo><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup><mo stretchy="false">)</mo><mtext> with </mtext><mi mathvariant="bold">Q</mi><mo>=</mo><msub><mi mathvariant="bold">W</mi><mi>q</mi></msub><mi mathvariant="bold">X</mi><mo separator="true">,</mo><mi mathvariant="bold">V</mi><mo>=</mo><msub><mi mathvariant="bold">W</mi><mi>v</mi></msub><mi mathvariant="bold">X</mi><mo separator="true">,</mo><mi mathvariant="bold">K</mi><mo>=</mo><msub><mi mathvariant="bold">W</mi><mi>k</mi></msub><mi mathvariant="bold">X</mi></mrow><annotation encoding="application/x-tex"> \\textbf{O} = \\text{Attn}(\\mathbf{X}) = \\mathbf{V} \\times \\text{Softmax}(\\mathbf{QK}^T) \\text{ with } \\mathbf{Q} = \\mathbf{W}_q \\mathbf{X}, \\mathbf{V} = \\mathbf{W}_v \\mathbf{X}, \\mathbf{K} = \\mathbf{W}_k \\mathbf{X} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord text"><span class="mord textbf">O</span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Attn</span></span><span class="mopen">(</span><span class="mord mathbf">X</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.7694em;vertical-align:-0.0833em;"></span><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1673em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span><span class="mclose">)</span><span class="mord text"><span class="mord"> with </span></span><span class="mord mathbf">Q</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.9722em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">W</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">q</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mord mathbf">X</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8805em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">W</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">v</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathbf">X</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathbf">K</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8361em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">W</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03148em;">k</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathbf">X</span></span></span></span></span>',yp,fp,Jf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">X</mi><mo>=</mo><mo stretchy="false">(</mo><msub><mi mathvariant="bold">x</mi><mn>1</mn></msub><mo separator="true">,</mo><mi mathvariant="normal">.</mi><mi mathvariant="normal">.</mi><mi mathvariant="normal">.</mi><msub><mi mathvariant="bold">x</mi><mi>N</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">  \\mathbf{X} = (\\mathbf{x}_1, ... \\mathbf{x}_{N}) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">X</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">...</span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',wp,bp,Uf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">Q</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{Q} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8805em;vertical-align:-0.1944em;"></span><span class="mord mathbf">Q</span></span></span></span>',vp,Mp,Cf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">K</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{K} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">K</span></span></span></span>',xp,kp,zf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',Tp,jp,Lf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',_p,Jp,Gf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mi>N</mi><mn>2</mn></msup></mrow><annotation encoding="application/x-tex"> N^2 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span></span></span></span>',Up,Cp,U,Wc,zp,Bf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">Q</mi><msup><mi mathvariant="bold">K</mi><mi mathvariant="bold">T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK^T} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0377em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">Q</span><span class="mord"><span class="mord mathbf">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8433em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathbf mtight">T</span></span></span></span></span></span></span></span></span></span></span></span>',Lp,Gp,$f='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>40</mn><mo>∗</mo><mn>2</mn><mo>∗</mo><msup><mi>N</mi><mn>2</mn></msup></mrow><annotation encoding="application/x-tex"> 40 * 2 * N^2 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">40</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span></span></span></span>',Bp,$p,Zf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi><mo>=</mo><mn>1000</mn></mrow><annotation encoding="application/x-tex"> N=1000 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1000</span></span></span></span>',Zp,Ip,If='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi><mo>=</mo><mn>16000</mn></mrow><annotation encoding="application/x-tex"> N=16000 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">16000</span></span></span></span>',Wp,Qp,Wf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi><mo>=</mo><mn>100</mn><mo separator="true">,</mo><mn>000</mn></mrow><annotation encoding="application/x-tex"> N=100,000 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8389em;vertical-align:-0.1944em;"></span><span class="mord">100</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">000</span></span></span></span>',Hp,Xp,Qf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Np,Rp,ra,tg="Long story short, the default self-attention algorithm quickly becomes prohibitively memory-expensive for large input contexts.",Vp,ha,ag="As LLMs improve in text comprehension and generation, they are applied to increasingly complex tasks. While models once handled the translation or summarization of a few sentences, they now manage entire pages, demanding the capability to process extensive input lengths.",qp,A,Qc,Ap,Hf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Q</mi><msup><mi>K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> QK^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">Q</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07153em;">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Ep,hs,eg="Tri Dao et al.",Hc,Mn,ng="Flash Attention",Xc,Yp,ps,Nc,Sp,Xf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">V</mi><mo>×</mo><mtext>Softmax</mtext><mo stretchy="false">(</mo><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex">\\mathbf{V} \\times \\text{Softmax}(\\mathbf{QK}^T</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7694em;vertical-align:-0.0833em;"></span><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1673em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Fp,Pp,Nf='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msub><mtext mathvariant="bold">O</mtext><mi>i</mi></msub><mo>←</mo><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>a</mi></msubsup><mo>∗</mo><msub><mtext mathvariant="bold">O</mtext><mi>i</mi></msub><mo>+</mo><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>b</mi></msubsup><mo>∗</mo><msub><mi mathvariant="bold">V</mi><mi>j</mi></msub><mo>×</mo><mtext>Softmax</mtext><mo stretchy="false">(</mo><msubsup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow><mi>T</mi></msubsup><mo stretchy="false">)</mo><mtext> for multiple </mtext><mi>i</mi><mo separator="true">,</mo><mi>j</mi><mtext> iterations</mtext></mrow><annotation encoding="application/x-tex"> \\textbf{O}_i \\leftarrow s^a_{ij} * \\textbf{O}_i + s^b_{ij} * \\mathbf{V}_{j} \\times \\text{Softmax}(\\mathbf{QK}^T_{i,j}) \\text{ for multiple } i, j \\text{ iterations} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8361em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord text"><span class="mord textbf">O</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">←</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0975em;vertical-align:-0.3831em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7144em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">a</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.8361em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord text"><span class="mord textbf">O</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.2822em;vertical-align:-0.3831em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8991em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">b</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9722em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.3004em;vertical-align:-0.3831em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-2.453em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mclose">)</span><span class="mord text"><span class="mord"> for multiple </span></span><span class="mord mathnormal">i</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mord text"><span class="mord"> iterations</span></span></span></span></span></span>',Kp,W,Rc,Dp,Rf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>a</mi></msubsup></mrow><annotation encoding="application/x-tex"> s^a_{ij} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0592em;vertical-align:-0.3948em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6644em;"><span style="top:-2.4413em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">a</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3948em;"><span></span></span></span></span></span></span></span></span></span>',Op,sm,Vf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>b</mi></msubsup></mrow><annotation encoding="application/x-tex"> s^b_{ij} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.2439em;vertical-align:-0.3948em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8491em;"><span style="top:-2.4413em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">b</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3948em;"><span></span></span></span></span></span></span></span></span></span>',tm,am,qf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',em,nm,Af='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>j</mi></mrow><annotation encoding="application/x-tex"> j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',lm,im,ca,lg='Please note that the whole Flash Attention is a bit more complex and is greatly simplified here as going in too much depth is out of scope for this guide. The reader is invited to take a look at the well-written <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention paper</a> for more details.',pm,ua,ig="The main takeaway here is:",mm,xn,ms,Vc,kn,pg="numerical identical",qc,om,Ef='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',rm,hm,da,mg='Looking at the formula, one would intuitively say that Flash Attention must be much slower compared to the default self-attention formula as more computation needs to be done. Indeed Flash Attention requires more FLOPs compared to normal attention as the softmax normalization statistics have to constantly be recomputed (see <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">paper</a> for more details if interested)',cm,ga,og="<p>However, Flash Attention is much faster in inference compared to default attention which comes from its ability to significantly reduce the demands on the slower, high-bandwidth memory of the GPU (VRAM), focusing instead on the faster on-chip memory (SRAM).</p>",um,D,Ac,Tn,rg="on-chip",Ec,dm,Yf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">O</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{O} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">O</span></span></span></span>',gm,ym,ya,hg="In practice, there is currently absolutely no reason to <strong>not</strong> use Flash Attention if available. The algorithm gives mathematically the same outputs, and is both faster and more memory-efficient.",fm,fa,cg="Let’s look at a practical example.",wm,wa,ug=`Our OctoCoder model now gets a significantly longer input prompt which includes a so-called <em>system prompt</em>. System prompts are used to steer the LLM into a better assistant that is tailored to the users’ task.
In the following, we use a system prompt that will make OctoCoder a better coding assistant.`,bm,ba,vm,va,dg=`For demonstration purposes, we duplicate the system prompt by ten so that the input length is long enough to observe Flash Attention’s memory savings.
We append the original text prompt <code>&quot;Question: Please write a function in Python that transforms bytes to Giga bytes.\\n\\nAnswer: Here&quot;</code>`,Mm,Ma,xm,xa,gg="We instantiate our model again in bfloat16 precision.",km,ka,Tm,Ta,yg="Let’s now run the model just like before <em>without Flash Attention</em> and measure the peak GPU memory requirement and inference time.",jm,ja,_m,_a,fg="<strong>Output</strong>:",Jm,Ja,Um,Ua,wg="We’re getting the same output as before, however this time, the model repeats the answer multiple times until it’s 60 tokens cut-off. This is not surprising as we’ve repeated the system prompt ten times for demonstration purposes and thus cued the model to repeat itself.",Cm,Ca,bg="<strong>Note</strong> that the system prompt should not be repeated ten times in real-world applications - one time is enough!",zm,za,vg="Let’s measure the peak GPU memory requirement.",Lm,La,Gm,Ga,Mg="<strong>Output</strong>:",Bm,Ba,$m,$a,xg="As we can see the peak GPU memory requirement is now significantly higher than in the beginning, which is largely due to the longer input sequence. Also the generation takes a little over a minute now.",Zm,Za,kg="We call <code>flush()</code> to free GPU memory for our next experiment.",Im,Ia,Wm,Wa,Tg=`For comparison, let’s run the same function, but enable Flash Attention instead.
To do so, we convert the model to <a href="https://huggingface.co/docs/optimum/bettertransformer/overview" rel="nofollow">BetterTransformer</a> and by doing so enabling PyTorch’s <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention" rel="nofollow">SDPA self-attention</a> which in turn is able to use Flash Attention.`,Qm,Qa,Hm,Ha,jg="Now we run the exact same code snippet as before and under the hood Transformers will make use of Flash Attention.",Xm,Xa,Nm,Na,_g="<strong>Output</strong>:",Rm,Ra,Vm,Va,Jg="We’re getting the exact same result as before, but can observe a very significant speed-up thanks to Flash Attention.",qm,qa,Ug="Let’s measure the memory consumption one last time.",Am,Aa,Em,Ea,Cg="<strong>Output</strong>:",Ym,Ya,Sm,Sa,zg="And we’re almost back to our original 29GB peak GPU memory from the beginning.",Fm,Fa,Lg="We can observe that we only use roughly 100MB more GPU memory when passing a very long input sequence with Flash Attention compared to passing a short input sequence as done in the beginning.",Pm,Pa,Km,Ka,Gg='For more information on how to use Flash Attention, please have a look at <a href="https://huggingface.co/docs/transformers/en/perf_infer_gpu_one#flashattention-2" rel="nofollow">this doc page</a>.',Dm,Da,Om,Oa,Bg="So far we have looked into improving computational and memory efficiency by:",so,se,$g="<li>Casting the weights to a lower precision format</li> <li>Replacing the self-attention algorithm with a more memory- and compute efficient version</li>",to,te,Zg="Let’s now look into how we can change the architecture of an LLM so that it is most effective and efficient for task that require long text inputs, <em>e.g.</em>:",ao,ae,Ig="<li>Retrieval augmented Questions Answering,</li> <li>Summarization,</li> <li>Chat</li>",eo,ee,Wg="Note that <em>chat</em> not only requires the LLM to handle long text inputs, but it also necessitates that the LLM is able to efficiently handle the back-and-forth dialogue between user and assistant (such as ChatGPT).",no,ne,Qg=`Once trained, the fundamental LLM architecture is difficult to change, so it is important to make considerations about the LLM’s tasks beforehand and accordingly optimize the model’s architecture.
There are two important components of the model architecture that quickly become memory and/or performance bottlenecks for large input sequences.`,lo,le,Hg="<li>The positional embeddings</li> <li>The key-value cache</li>",io,ie,Xg="Let’s go over each component in more detail",po,pe,mo,O,Yc,oo,Sf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mtext>Softmax</mtext><mo stretchy="false">(</mo><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex"> \\text{Softmax}(\\mathbf{QK}^T) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1673em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',ro,jn,Ng="“Hello”, “I”, “love”, “you”",Sc,ho,me,Rg='<img src="/blog/assets/163_optimize_llm/self_attn_tokens.png"/>',co,oe,Vg="Each word token is given a probability mass at which it attends all other word tokens and, therefore is put into relation with all other word tokens. E.g. the word <em>“love”</em> attends to the word <em>“Hello”</em> with 5%, to <em>“I”</em> with 30%, and to itself with 65%.",uo,Z,Fc,go,Ff='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',yo,fo,Pf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>O</mi><mo stretchy="false">(</mo><mn>1</mn><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex"> O(1) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mopen">(</span><span class="mord">1</span><span class="mclose">)</span></span></span></span>',wo,_n,qg="e.g.",Pc,Jn,Ag="“Hello I love you”",Kc,Un,Eg="“You love I hello”",Dc,bo,re,Yg=`For the LLM to understand sentence order, an additional <em>cue</em> is needed and is usually applied in the form of <em>positional encodings</em> (or also called <em>positional embeddings</em>).
Positional encodings, encode the position of each token into a numerical presentation that the LLM can leverage to better understand sentence order.`,vo,C,Oc,cs,Sg="<em>Attention Is All You Need</em>",su,Mo,Kf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">P</mi><mo>=</mo><msub><mi mathvariant="bold">p</mi><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi mathvariant="bold">p</mi><mi>N</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{P} = \\mathbf{p}_1, \\ldots, \\mathbf{p}_N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">P</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',xo,ko,Df='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">p</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{p}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',To,jo,Of='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',_o,Jo,sw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mover accent="true"><mi mathvariant="bold">X</mi><mo>^</mo></mover><mo>=</mo><msub><mover accent="true"><mi mathvariant="bold">x</mi><mo>^</mo></mover><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mover accent="true"><mi mathvariant="bold">x</mi><mo>^</mo></mover><mi>N</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{\\hat{X}} = \\mathbf{\\hat{x}}_1, \\ldots, \\mathbf{\\hat{x}}_N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9495em;"></span><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9495em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">X</span></span><span style="top:-3.2551em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.9023em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">x</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">x</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Uo,Co,tw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">x</mi><mn>1</mn></msub><mo>+</mo><msub><mi mathvariant="bold">p</mi><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi mathvariant="bold">x</mi><mi>N</mi></msub><mo>+</mo><msub><mi mathvariant="bold">p</mi><mi>N</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{x}_1 + \\mathbf{p}_1, \\ldots, \\mathbf{x}_N + \\mathbf{p}_N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.7778em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',zo,Lo,ss,tu,us,Fg="Devlin et al.",au,Go,aw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">P</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{P} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">P</span></span></span></span>',Bo,$o,he,Pg="Sinusoidal and learned position embeddings used to be the predominant methods to encode sentence order into LLMs, but a couple of problems related to these positional encodings were found:",Zo,ds,R,eu,Cn,Kg="i.e.",nu,Io,ew='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>0</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><mi>N</mi></mrow><annotation encoding="application/x-tex"> 0, \\ldots, N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8778em;vertical-align:-0.1944em;"></span><span class="mord">0</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',Wo,gs,Dg="Huang et al.",lu,ys,Og="Su et al.",iu,pu,ce,mu,Qo,nw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',Ho,Xo,ue,sy="Recently, relative positional embeddings that can tackle the above mentioned problems have become more popular, most notably:",No,de,ty='<li><a href="https://arxiv.org/abs/2104.09864" rel="nofollow">Rotary Position Embedding (RoPE)</a></li> <li><a href="https://arxiv.org/abs/2108.12409" rel="nofollow">ALiBi</a></li>',Ro,E,ou,zn,ay="RoPE",ru,Ln,ey="ALiBi",hu,Vo,lw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',qo,Ao,k,cu,Gn,ny="RoPE",uu,Bn,ly="e.g.",Eo,iw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Yo,So,pw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">x</mi><mi>j</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{x}_j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7305em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',Fo,Po,mw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi><mo>∗</mo><mi>i</mi></mrow><annotation encoding="application/x-tex"> \\theta * i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Ko,Do,ow='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi><mo>∗</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> \\theta * j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',Oo,sr,rw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> i, j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">i</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',tr,ar,hw='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msubsup><mover accent="true"><mi mathvariant="bold">q</mi><mo>^</mo></mover><mi>i</mi><mi>T</mi></msubsup><msub><mover accent="true"><mi mathvariant="bold">x</mi><mo>^</mo></mover><mi>j</mi></msub><mo>=</mo><msubsup><mi mathvariant="bold">q</mi><mi>i</mi><mi>T</mi></msubsup><msub><mi mathvariant="bold">R</mi><mrow><mi>θ</mi><mo separator="true">,</mo><mi>i</mi><mo>−</mo><mi>j</mi></mrow></msub><msub><mi mathvariant="bold">x</mi><mi>j</mi></msub><mi mathvariant="normal">.</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{\\hat{q}}_i^T \\mathbf{\\hat{x}}_j = \\mathbf{{q}}_i^T \\mathbf{R}_{\\theta, i -j} \\mathbf{{x}}_j. </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.2252em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord accent"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">q</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1944em;"><span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.9391em;"><span style="top:-2.453em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span><span style="top:-3.1608em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">x</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.1774em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">q</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8913em;"><span style="top:-2.453em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord mathbf">R</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight">i</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord"><span class="mord mathbf">x</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mord">.</span></span></span></span></span>',er,nr,cw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">R</mi><mrow><mi>θ</mi><mo separator="true">,</mo><mi>i</mi><mo>−</mo><mi>j</mi></mrow></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{R}_{\\theta, i - j} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9722em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">R</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight">i</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',lr,ir,uw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi></mrow><annotation encoding="application/x-tex"> \\theta </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span></span></span></span>',pr,$n,iy="not",du,mr,Zn,$,gu,or,dw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',rr,hr,gw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>j</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7305em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',cr,ur,yw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo mathvariant="normal">≠</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> i \\ne j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel"><span class="mrel"><span class="mord vbox"><span class="thinbox"><span class="rlap"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="inner"><span class="mord"><span class="mrel"></span></span></span><span class="fix"></span></span></span></span></span><span class="mrel">=</span></span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',dr,gr,fw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>−</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> i - j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',yr,fr,ww='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',wr,br,bw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>j</mi></mrow><annotation encoding="application/x-tex"> j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',vr,Mr,ge,py="<em>RoPE</em> is used in multiple of today’s most important LLMs, such as:",xr,ye,my='<li><a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow"><strong>Falcon</strong></a></li> <li><a href="https://arxiv.org/abs/2302.13971" rel="nofollow"><strong>Llama</strong></a></li> <li><a href="https://arxiv.org/abs/2204.02311" rel="nofollow"><strong>PaLM</strong></a></li>',kr,Y,yu,In,oy="ALiBi",fu,Wn,ry="m",wu,Tr,vw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',jr,_r,fe,hy='<img src="/blog/assets/163_optimize_llm/alibi.png"/>',Jr,we,cy='As shown in the <a href="https://arxiv.org/abs/2108.12409" rel="nofollow">ALiBi</a> paper, this simple relative positional encoding allows the model to retain a high performance even at very long text input sequences.',Ur,be,uy="<em>ALiBi</em> is used in multiple of today’s most important LLMs, such as:",Cr,ve,dy='<li><a href="https://huggingface.co/mosaicml/mpt-30b" rel="nofollow"><strong>MPT</strong></a></li> <li><a href="https://huggingface.co/bigscience/bloom" rel="nofollow"><strong>BLOOM</strong></a></li>',zr,x,bu,Qn,gy="RoPE",vu,Hn,yy="ALiBi",Mu,Xn,fy="ALiBi",xu,Nn,wy="RoPE",ku,Rn,by="RoPE",Tu,Lr,Mw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi></mrow><annotation encoding="application/x-tex"> \\theta </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span></span></span></span>',Gr,Vn,vy="c.f",ju,fs,My="Press et al.",_u,Br,xw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi></mrow><annotation encoding="application/x-tex"> \\theta </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span></span></span></span>',$r,qn,xy="RoPE",Ju,ws,ky="here",Uu,Zr,bs,An,Ty="Both RoPE and ALiBi are relative positional embeddings that are <em>not</em> learned during training, but instead are based on the following intuitions:",Cu,os,Me,zu,Ir,kw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Q</mi><msup><mi>K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> QK^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">Q</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07153em;">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Wr,Lu,En,jy="The LLM should be incentivized to learn a constant <em>relative</em> distance positional encodings have to each other",Gu,Yn,_y="The further text input tokens are from each other, the lower the probability of their query-value probability. Both RoPE and ALiBi lower the query-key probability of tokens far away from each other. RoPE by decreasing their vector product by increasing the angle between the query-key vectors. ALiBi by adding large negative numbers to the vector product",Qr,S,Bu,Hr,Tw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>N</mi><mn>1</mn></msub><mo>=</mo><mn>2048</mn></mrow><annotation encoding="application/x-tex"> N_1 = 2048 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2048</span></span></span></span>',Xr,Nr,jw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>N</mi><mn>1</mn></msub></mrow><annotation encoding="application/x-tex"> N_1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Rr,Vr,_w='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>N</mi><mn>2</mn></msub><mo>=</mo><mn>8192</mn><mo>&gt;</mo><msub><mi>N</mi><mn>1</mn></msub></mrow><annotation encoding="application/x-tex"> N_2 = 8192 &gt; N_1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6835em;vertical-align:-0.0391em;"></span><span class="mord">8192</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">&gt;</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',qr,Ar,xe,Er,ke,Jy="Auto-regressive text generation with LLMs works by iteratively putting in an input sequence, sampling the next token, appending the next token to the input sequence, and continuing to do so until the LLM produces a token that signifies that the generation has finished.",Yr,Te,Uy='Please have a look at <a href="https://huggingface.co/docs/transformers/llm_tutorial#generate-text" rel="nofollow">Transformer’s Generate Text Tutorial</a> to get a more visual explanation of how auto-regressive generation works.',Sr,je,Cy="Let’s run a quick code snippet to show how auto-regressive works in practice. We will simply take the most likely next token via <code>torch.argmax</code>.",Fr,_e,Pr,Je,zy="<strong>Output</strong>:",Kr,Ue,Dr,Ce,Ly="As we can see every time we increase the text input tokens by the just sampled token.",Or,ze,Gy='With very few exceptions, LLMs are trained using the <a href="https://huggingface.co/docs/transformers/tasks/language_modeling#causal-language-modeling" rel="nofollow">causal language modeling objective</a> and therefore mask the upper triangle matrix of the attention score - this is why in the two diagrams above the attention scores are left blank (<em>a.k.a</em> have 0 probability). For a quick recap on causal language modeling you can refer to the <a href="https://jalammar.github.io/illustrated-gpt2/#part-2-illustrated-self-attention" rel="nofollow"><em>Illustrated Self Attention blog</em></a>.',sh,z,$u,Sn,By="never",Zu,th,Jw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',ah,eh,Uw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">k</mi><mi>j</mi></msub><mo separator="true">,</mo><msub><mi mathvariant="bold">v</mi><mi>j</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{k}_j, \\mathbf{v}_j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9805em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',nh,lh,Cw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>j</mi><mo>&gt;</mo><mi>i</mi></mrow><annotation encoding="application/x-tex"> j &gt; i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">&gt;</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',ih,ph,zw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',mh,oh,Lw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">k</mi><mrow><mi>m</mi><mo>&lt;</mo><mi>i</mi></mrow></msub><mo separator="true">,</mo><msub><mi mathvariant="bold">v</mi><mrow><mi>m</mi><mo>&lt;</mo><mi>i</mi></mrow></msub><mtext> , for </mtext><mi>m</mi><mo>∈</mo><mo stretchy="false">{</mo><mn>0</mn><mo separator="true">,</mo><mo>…</mo><mi>i</mi><mo>−</mo><mn>1</mn><mo stretchy="false">}</mo></mrow><annotation encoding="application/x-tex"> \\mathbf{k}_{m &lt; i}, \\mathbf{v}_{m &lt; i} \\text{ , for } m \\in \\{0, \\ldots i - 1\\} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">m</span><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">m</span><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mord text"><span class="mord"> , for </span></span><span class="mord mathnormal">m</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">{</span><span class="mord">0</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">1</span><span class="mclose">}</span></span></span></span>',rh,hh,Le,$y=`In the following, we will tell the LLM to make use of the key-value cache by retrieving and forwarding it for each forward pass.
In Transformers, we can retrieve the key-value cache by passing the <code>use_cache</code> flag to the <code>forward</code> call and can then pass it with the current token.`,ch,Ge,uh,Be,Zy="<strong>Output</strong>:",dh,$e,gh,Ze,Iy="As one can see, when using the key-value cache the text input tokens are <em>not</em> increased in length, but remain a single input vector. The length of the key-value cache on the other hand is increased by one at every decoding step.",yh,Fn,V,Iu,fh,Gw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',wh,bh,Bw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>c</mi></msub><msup><mi mathvariant="bold">K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_c\\mathbf{K}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">c</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord mathbf">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',vh,Mh,$w='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>c</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_c </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">c</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',xh,Pn,Wy="always",Wu,kh,Ie,Qy="Using the key-value cache has two advantages:",Th,vs,We,Qu,jh,Zw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',_h,Hu,Kn,Hy="The maximum required memory is not increased quadratically with the number of generated tokens, but only increases linearly.",Jh,Qe,Xy='<p>One should <em>always</em> make use of the key-value cache as it leads to identical results and a significant speed-up for longer input sequences. Transformers has the key-value cache enabled by default when making use of the text pipeline or the <a href="https://huggingface.co/docs/transformers/main_classes/text_generation" rel="nofollow"><code>generate</code> method</a>.</p>',Uh,Ms,Ch,He,zh,Xe,Ny="The key-value cache is especially useful for applications such as chat where multiple passes of auto-regressive decoding are required. Let’s look at an example.",Lh,Ne,Gh,Re,Ry="In this chat, the LLM runs auto-regressive decoding twice:",Bh,Ve,Vy="<li>The first time, the key-value cache is empty and the input prompt is <code>&quot;User: How many people live in France?&quot;</code> and the model auto-regressively generates the text <code>&quot;Roughly 75 million people live in France&quot;</code> while increasing the key-value cache at every decoding step.</li> <li>The second time the input prompt is <code>&quot;User: How many people live in France? \\n Assistant: Roughly 75 million people live in France \\n User: And how many in Germany?&quot;</code>. Thanks to the cache, all key-value vectors for the first two sentences are already computed. Therefore the input prompt only consists of <code>&quot;User: And how many in Germany?&quot;</code>. While processing the shortened input prompt, it’s computed key-value vectors are concatenated to the key-value cache of the first decoding. The second Assistant’s answer <code>&quot;Germany has ca. 81 million inhabitants&quot;</code> is then auto-regressively generated with the key-value cache consisting of encoded key-value vectors of <code>&quot;User: How many people live in France? \\n Assistant: Roughly 75 million people live in France \\n User: And how many are in Germany?&quot;</code>.</li>",$h,qe,qy="Two things should be noted here:",Zh,Ae,Ay="<li>Keeping all the context is crucial for LLMs deployed in chat so that the LLM understands all the previous context of the conversation. E.g. for the example above the LLM needs to understand that the user refers to the population when asking <code>&quot;And how many are in Germany&quot;</code>.</li> <li>The key-value cache is extremely useful for chat as it allows us to continuously grow the encoded chat history instead of having to re-encode the chat history again from scratch (as e.g. would be the case when using an encoder-decoder architecture).</li>",Ih,Ee,Ey="In <code>transformers</code>, a <code>generate</code> call will return <code>past_key_values</code> when <code>return_dict_in_generate=True</code> is passed, in addition to the default <code>use_cache=True</code>. Note that it is not yet available through the <code>pipeline</code> interface.",Wh,Ye,Qh,Se,Yy="<strong>Output</strong>:",Hh,Fe,Xh,ts,Xu,Nh,Iw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Rh,Vh,Ww='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">x</mi><mi>i</mi></msub><mtext>, for </mtext><mi>i</mi><mo>∈</mo><mo stretchy="false">{</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><mi>c</mi><mo>−</mo><mn>1</mn><mo stretchy="false">}</mo></mrow><annotation encoding="application/x-tex"> \\mathbf{x}_i \\text{, for } i \\in \\{1, \\ldots, c - 1\\} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord text"><span class="mord">, for </span></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">{</span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">c</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">1</span><span class="mclose">}</span></span></span></span>',qh,Ah,Pe,Sy=`Let’s compute the number of float values that need to be stored in the key-value cache for the LLM <code>bigcode/octocoder</code> that we used before.
The number of float values amounts to two times the sequence length times the number of attention heads times the attention head dimension and times the number of layers.
Computing this for our LLM at a hypothetical input sequence length of 16000 gives:`,Eh,Ke,Yh,De,Fy="<strong>Output</strong>:",Sh,Oe,Fh,sn,Py=`Roughly 8 billion float values! Storing 8 billion float values in <code>float16</code> precision requires around 15 GB of RAM which is circa half as much as the model weights themselves!
Researchers have proposed two methods that allow to significantly reduce the memory cost of storing the key-value cache, which are explored in the next subsections.`,Ph,tn,Kh,an,Ky='<a href="https://arxiv.org/abs/1911.02150" rel="nofollow">Multi-Query-Attention</a> was proposed in Noam Shazeer’s <em>Fast Transformer Decoding: One Write-Head is All You Need</em> paper. As the title says, Noam found out that instead of using <code>n_head</code> key-value projections weights, one can use a single head-value projection weight pair that is shared across all attention heads without that the model’s performance significantly degrades.',Dh,Dn,rs,Nu,Oh,Qw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">k</mi><mi>i</mi></msub><mo separator="true">,</mo><msub><mi mathvariant="bold">v</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{k}_i, \\mathbf{v}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',sc,On,Dy="n_head",Ru,tc,en,Oy="As most LLMs use between 20 and 100 attention heads, MQA significantly reduces the memory consumption of the key-value cache. For the LLM used in this notebook we could therefore reduce the required memory consumption from 15 GB to less than 400 MB at an input sequence length of 16000.",ac,as,Vu,ec,Hw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>c</mi></msub><msup><mi mathvariant="bold">K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_c\\mathbf{K}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">c</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord mathbf">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',nc,xs,sf="Noam’s paper",qu,lc,ks,Au,ic,Xw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',pc,mc,nn,tf="MQA has seen wide adoption by the community and is now used by many of the most popular LLMs:",oc,ln,af='<li><a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow"><strong>Falcon</strong></a></li> <li><a href="https://arxiv.org/abs/2204.02311" rel="nofollow"><strong>PaLM</strong></a></li> <li><a href="https://huggingface.co/mosaicml/mpt-30b" rel="nofollow"><strong>MPT</strong></a></li> <li><a href="https://huggingface.co/bigscience/bloom" rel="nofollow"><strong>BLOOM</strong></a></li>',rc,pn,ef="Also, the checkpoint used in this notebook - <code>bigcode/octocoder</code> - makes use of MQA.",hc,mn,cc,on,nf='<a href="https://arxiv.org/abs/2305.13245" rel="nofollow">Grouped-Query-Attention</a>, as proposed by Ainslie et al. from Google, found that using MQA can often lead to quality degradation compared to using vanilla multi-key-value head projections. The paper argues that more model performance can be kept by less drastically reducing the number of query head projection weights. Instead of using just a single key-value projection weight, <code>n &lt; n_head</code> key-value projection weights should be used. By choosing <code>n</code> to a significantly smaller value than <code>n_head</code>, such as 2,4 or 8 almost all of the memory and speed gains from MQA can be kept while sacrificing less model capacity and thus arguably less performance.',uc,rn,lf="Moreover, the authors of GQA found out that existing model checkpoints can be <em>uptrained</em> to have a GQA architecture with as little as 5% of the original pre-training compute. While 5% of the original pre-training compute can still be a massive amount, GQA <em>uptraining</em> allows existing checkpoints to be useful for longer input sequences.",dc,hn,pf=`GQA was only recently proposed which is why there is less adoption at the time of writing this notebook.
The most notable application of GQA is <a href="https://huggingface.co/meta-llama/Llama-2-70b-hf" rel="nofollow">Llama-v2</a>.`,gc,cn,mf="<p>As a conclusion, it is strongly recommended to make use of either GQA or MQA if the LLM is deployed with auto-regressive decoding and is required to handle large input sequences as is the case for example for chat.</p>",yc,un,fc,dn,of='The research community is constantly coming up with new, nifty ways to speed up inference time for ever-larger LLMs. As an example, one such promising research direction is <a href="https://arxiv.org/abs/2211.17192" rel="nofollow">speculative decoding</a> where “easy tokens” are generated by smaller, faster language models and only “hard tokens” are generated by the LLM itself. Going into more detail is out of the scope of this notebook, but can be read upon in this <a href="https://huggingface.co/blog/assisted-generation" rel="nofollow">nice blog post</a>.',wc,gn,rf=`The reason massive LLMs such as GPT3/4, Llama-2-70b, Claude, PaLM can run so quickly in chat-interfaces such as <a href="https://huggingface.co/chat/" rel="nofollow">Hugging Face Chat</a> or ChatGPT is to a big part thanks to the above-mentioned improvements in precision, algorithms, and architecture.
Going forward, accelerators such as GPUs, TPUs, etc… will only get faster and allow for more memory, but one should nevertheless always make sure to use the best available algorithms and architectures to get the most bang for your buck 🤗`,bc,ol,vc;return zs=new is({props:{title:"Optimizing LLMs for Speed and Memory",local:"optimizing-llms-for-speed-and-memory",headingTag:"h1"}}),Ls=new Sw({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial_optimization.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial_optimization.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial_optimization.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial_optimization.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial_optimization.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial_optimization.ipynb"}]}}),Qs=new is({props:{title:"1. Lower Precision",local:"1-lower-precision",headingTag:"h2"}}),Ks=new v({props:{code:"IXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwYml0c2FuZGJ5dGVzJTIwb3B0aW11bQ==",highlighted:"!pip install transformers accelerate bitsandbytes optimum",wrap:!1}}),Ds=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRmJsb29tJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBwYWRfdG9rZW5faWQlM0QwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, pad_token_id=<span class="hljs-number">0</span>)`,wrap:!1}}),et=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdjb2RlJTJGb2N0b2NvZGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwcGFkX3Rva2VuX2lkJTNEMCklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdjb2RlJTJGb2N0b2NvZGVyJTIyKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, pipeline
<span class="hljs-keyword">import</span> torch

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>, pad_token_id=<span class="hljs-number">0</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>)

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),nt=new v({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyUXVlc3Rpb24lM0ElMjBQbGVhc2UlMjB3cml0ZSUyMGElMjBmdW5jdGlvbiUyMGluJTIwUHl0aG9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzLiU1Q24lNUNuQW5zd2VyJTNBJTIyJTBBJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYwKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qmxlbihwcm9tcHQpJTNBJTVEJTBBcmVzdWx0",highlighted:`prompt = <span class="hljs-string">&quot;Question: Please write a function in Python that transforms bytes to Giga bytes.\\n\\nAnswer:&quot;</span>

result = pipe(prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(prompt):]
result`,wrap:!1}}),it=new v({props:{code:"SGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzJTNBJTVDbiU1Q24lNjAlNjAlNjBweXRob24lNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElNUNuJTIwJTIwJTIwJTIwcmV0dXJuJTIwYnl0ZXMlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUyMCUyRiUyMDEwMjQlNUNuJTYwJTYwJTYwJTVDbiU1Q25UaGlzJTIwZnVuY3Rpb24lMjB0YWtlcyUyMGElMjBzaW5nbGU=",highlighted:'Here <span class="hljs-keyword">is</span> a Python <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> transforms bytes <span class="hljs-keyword">to</span> Giga bytes:<span class="hljs-string">\\n\\n```python\\ndef</span> bytes_to_giga_bytes(bytes):<span class="hljs-string">\\n</span>    <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n```\\n\\nThis</span> <span class="hljs-keyword">function</span> takes a single',wrap:!1}}),mt=new v({props:{code:"ZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElMEElMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">bytes_to_giga_bytes</span>(<span class="hljs-params"><span class="hljs-built_in">bytes</span></span>):
  <span class="hljs-keyword">return</span> <span class="hljs-built_in">bytes</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span>`,wrap:!1}}),rt=new v({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),ct=new v({props:{code:"MjkuMDI2MDY0ODcyNzQxNw==",highlighted:"29.0260648727417",wrap:!1}}),ft=new v({props:{code:"ZGVsJTIwcGlwZSUwQWRlbCUyMG1vZGVsJTBBJTBBaW1wb3J0JTIwZ2MlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRlZiUyMGZsdXNoKCklM0ElMEElMjAlMjBnYy5jb2xsZWN0KCklMEElMjAlMjB0b3JjaC5jdWRhLmVtcHR5X2NhY2hlKCklMEElMjAlMjB0b3JjaC5jdWRhLnJlc2V0X3BlYWtfbWVtb3J5X3N0YXRzKCk=",highlighted:`<span class="hljs-keyword">del</span> pipe
<span class="hljs-keyword">del</span> model

<span class="hljs-keyword">import</span> gc
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">flush</span>():
  gc.collect()
  torch.cuda.empty_cache()
  torch.cuda.reset_peak_memory_stats()`,wrap:!1}}),bt=new v({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),Mt=new v({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjByZWxlYXNlX21lbW9yeSUwQSUyMyUyMC4uLiUwQSUwQXJlbGVhc2VfbWVtb3J5KG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> release_memory
<span class="hljs-comment"># ...</span>

release_memory(model)`,wrap:!1}}),Ct=new v({props:{code:"IXBpcCUyMGluc3RhbGwlMjBiaXRzYW5kYnl0ZXM=",highlighted:"!pip install bitsandbytes",wrap:!1}}),Lt=new v({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRm9jdG9jb2RlciUyMiUyQyUyMGxvYWRfaW5fOGJpdCUzRFRydWUlMkMlMjBwYWRfdG9rZW5faWQlM0QwKQ==",highlighted:'model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>, pad_token_id=<span class="hljs-number">0</span>)',wrap:!1}}),Bt=new v({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYwKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qmxlbihwcm9tcHQpJTNBJTVEJTBBcmVzdWx0",highlighted:`pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

result = pipe(prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(prompt):]
result`,wrap:!1}}),Zt=new v({props:{code:"SGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzJTNBJTVDbiU1Q24lNjAlNjAlNjBweXRob24lNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElNUNuJTIwJTIwJTIwJTIwcmV0dXJuJTIwYnl0ZXMlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUyMCUyRiUyMDEwMjQlNUNuJTYwJTYwJTYwJTVDbiU1Q25UaGlzJTIwZnVuY3Rpb24lMjB0YWtlcyUyMGElMjBzaW5nbGU=",highlighted:'Here <span class="hljs-keyword">is</span> a Python <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> transforms bytes <span class="hljs-keyword">to</span> Giga bytes:<span class="hljs-string">\\n\\n```python\\ndef</span> bytes_to_giga_bytes(bytes):<span class="hljs-string">\\n</span>    <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n```\\n\\nThis</span> <span class="hljs-keyword">function</span> takes a single',wrap:!1}}),Wt=new v({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),Ht=new v({props:{code:"MTUuMjE5MjM0NDY2NTUyNzM0",highlighted:'<span class="hljs-attribute">15</span>.<span class="hljs-number">219234466552734</span>',wrap:!1}}),Rt=new v({props:{code:"ZGVsJTIwbW9kZWwlMEFkZWwlMjBwaXBl",highlighted:`<span class="hljs-keyword">del</span> model
<span class="hljs-keyword">del</span> pipe`,wrap:!1}}),Vt=new v({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),At=new v({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRm9jdG9jb2RlciUyMiUyQyUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMjBwYWRfdG9rZW5faWQlM0QwKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXJlc3VsdCUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbWF4X25ld190b2tlbnMlM0Q2MCklNUIwJTVEJTVCJTIyZ2VuZXJhdGVkX3RleHQlMjIlNUQlNUJsZW4ocHJvbXB0KSUzQSU1RCUwQXJlc3VsdA==",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>, low_cpu_mem_usage=<span class="hljs-literal">True</span>, pad_token_id=<span class="hljs-number">0</span>)

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

result = pipe(prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(prompt):]
result`,wrap:!1}}),Yt=new v({props:{code:"SGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzJTNBJTVDbiU1Q24lNjAlNjAlNjAlNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYWJ5dGVzKGJ5dGVzKSUzQSU1Q24lMjAlMjAlMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCU1Q24lNjAlNjAlNjAlNUNuJTVDblRoaXMlMjBmdW5jdGlvbiUyMHRha2VzJTIwYSUyMHNpbmdsZSUyMGFyZ3VtZW50",highlighted:'Here <span class="hljs-keyword">is</span> a Python <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> transforms bytes <span class="hljs-keyword">to</span> Giga bytes:<span class="hljs-string">\\n\\n```\\ndef</span> bytes_to_gigabytes(bytes):<span class="hljs-string">\\n</span>    <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n```\\n\\nThis</span> <span class="hljs-keyword">function</span> takes a single argument',wrap:!1}}),Ft=new v({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),Kt=new v({props:{code:"OS41NDM1NzQzMzMxOTA5MTg=",highlighted:'<span class="hljs-attribute">9</span>.<span class="hljs-number">543574333190918</span>',wrap:!1}}),sa=new v({props:{code:"ZGVsJTIwbW9kZWwlMEFkZWwlMjBwaXBl",highlighted:`<span class="hljs-keyword">del</span> model
<span class="hljs-keyword">del</span> pipe`,wrap:!1}}),ta=new v({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),ma=new is({props:{title:"2. Flash Attention",local:"2-flash-attention",headingTag:"h2"}}),ba=new v({props:{code:"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",highlighted:`system_prompt = <span class="hljs-string">&quot;&quot;&quot;Below are a series of dialogues between various people and an AI technical assistant.
The assistant tries to be helpful, polite, honest, sophisticated, emotionally aware, and humble but knowledgeable.
The assistant is happy to help with code questions and will do their best to understand exactly what is needed.
It also tries to avoid giving false or misleading information, and it caveats when it isn&#x27;t entirely sure about the right answer.
That said, the assistant is practical really does its best, and doesn&#x27;t let caution get too much in the way of being useful.

The Starcoder models are a series of 15.5B parameter models trained on 80+ programming languages from The Stack (v1.2) (excluding opt-out requests).
The model uses Multi Query Attention, was trained using the Fill-in-the-Middle objective, and with 8,192 tokens context window for a trillion tokens of heavily deduplicated data.

-----

Question: Write a function that takes two lists and returns a list that has alternating elements from each input list.

Answer: Sure. Here is a function that does that.

def alternating(list1, list2):
   results = []
   for i in range(len(list1)):
       results.append(list1[i])
       results.append(list2[i])
   return results

Question: Can you write some test cases for this function?

Answer: Sure, here are some tests.

assert alternating([10, 20, 30], [1, 2, 3]) == [10, 1, 20, 2, 30, 3]
assert alternating([True, False], [4, 5]) == [True, 4, False, 5]
assert alternating([], []) == []

Question: Modify the function so that it returns all input elements when the lists have uneven length. The elements from the longer list should be at the end.

Answer: Here is the modified function.

def alternating(list1, list2):
   results = []
   for i in range(min(len(list1), len(list2))):
       results.append(list1[i])
       results.append(list2[i])
   if len(list1) &gt; len(list2):
       results.extend(list1[i+1:])
   else:
       results.extend(list2[i+1:])
   return results

-----
&quot;&quot;&quot;</span>`,wrap:!1}}),Ma=new v({props:{code:"bG9uZ19wcm9tcHQlMjAlM0QlMjAxMCUyMColMjBzeXN0ZW1fcHJvbXB0JTIwJTJCJTIwcHJvbXB0",highlighted:'long_prompt = <span class="hljs-number">10</span> * system_prompt + prompt',wrap:!1}}),ka=new v({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRm9jdG9jb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdjb2RlJTJGb2N0b2NvZGVyJTIyKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKQ==",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>)

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),ja=new v({props:{code:"aW1wb3J0JTIwdGltZSUwQSUwQXN0YXJ0X3RpbWUlMjAlM0QlMjB0aW1lLnRpbWUoKSUwQXJlc3VsdCUyMCUzRCUyMHBpcGUobG9uZ19wcm9tcHQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYwKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qmxlbihsb25nX3Byb21wdCklM0ElNUQlMEElMEFwcmludChmJTIyR2VuZXJhdGVkJTIwaW4lMjAlN0J0aW1lLnRpbWUoKSUyMC0lMjBzdGFydF90aW1lJTdEJTIwc2Vjb25kcy4lMjIpJTBBcmVzdWx0",highlighted:`<span class="hljs-keyword">import</span> time

start_time = time.time()
result = pipe(long_prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(long_prompt):]

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated in <span class="hljs-subst">{time.time() - start_time}</span> seconds.&quot;</span>)
result`,wrap:!1}}),Ja=new v({props:{code:"R2VuZXJhdGVkJTIwaW4lMjAxMC45Njg1NDAxOTE2NTAzOSUyMHNlY29uZHMuJTBBU3VyZS4lMjBIZXJlJTIwaXMlMjBhJTIwZnVuY3Rpb24lMjB0aGF0JTIwZG9lcyUyMHRoYXQuJTVDbiU1Q25kZWYlMjBieXRlc190b19naWdhKGJ5dGVzKSUzQSU1Q24lMjAlMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCU1Q24lNUNuQW5zd2VyJTNBJTIwU3VyZS4lMjBIZXJlJTIwaXMlMjBhJTIwZnVuY3Rpb24lMjB0aGF0JTIwZG9lcyUyMHRoYXQuJTVDbiU1Q25kZWY=",highlighted:`Generated <span class="hljs-keyword">in</span> <span class="hljs-number">10.96854019165039</span> seconds.
Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span> bytes_to_giga(bytes):<span class="hljs-string">\\n</span>   <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n\\nAnswer:</span> Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span>`,wrap:!1}}),La=new v({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),Ba=new v({props:{code:"MzcuNjY4MTkzMzQwMzAxNTE0",highlighted:"37.668193340301514",wrap:!1}}),Ia=new v({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),Qa=new v({props:{code:"bW9kZWwudG9fYmV0dGVydHJhbnNmb3JtZXIoKQ==",highlighted:"model.to_bettertransformer()",wrap:!1}}),Xa=new v({props:{code:"c3RhcnRfdGltZSUyMCUzRCUyMHRpbWUudGltZSgpJTBBd2l0aCUyMHRvcmNoLmJhY2tlbmRzLmN1ZGEuc2RwX2tlcm5lbChlbmFibGVfZmxhc2glM0RUcnVlJTJDJTIwZW5hYmxlX21hdGglM0RGYWxzZSUyQyUyMGVuYWJsZV9tZW1fZWZmaWNpZW50JTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwcGlwZShsb25nX3Byb21wdCUyQyUyMG1heF9uZXdfdG9rZW5zJTNENjApJTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEJTVCbGVuKGxvbmdfcHJvbXB0KSUzQSU1RCUwQSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjBpbiUyMCU3QnRpbWUudGltZSgpJTIwLSUyMHN0YXJ0X3RpbWUlN0QlMjBzZWNvbmRzLiUyMiklMEFyZXN1bHQ=",highlighted:`start_time = time.time()
<span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">True</span>, enable_math=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>):
    result = pipe(long_prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(long_prompt):]

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated in <span class="hljs-subst">{time.time() - start_time}</span> seconds.&quot;</span>)
result`,wrap:!1}}),Ra=new v({props:{code:"R2VuZXJhdGVkJTIwaW4lMjAzLjAyMTE2MTc5NDY2MjQ3NTYlMjBzZWNvbmRzLiUwQSUyMFN1cmUuJTIwSGVyZSUyMGlzJTIwYSUyMGZ1bmN0aW9uJTIwdGhhdCUyMGRvZXMlMjB0aGF0LiU1Q24lNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYShieXRlcyklM0ElNUNuJTIwJTIwJTIwcmV0dXJuJTIwYnl0ZXMlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUyMCUyRiUyMDEwMjQlNUNuJTVDbkFuc3dlciUzQSUyMFN1cmUuJTIwSGVyZSUyMGlzJTIwYSUyMGZ1bmN0aW9uJTIwdGhhdCUyMGRvZXMlMjB0aGF0LiU1Q24lNUNuZGVm",highlighted:`Generated <span class="hljs-keyword">in</span> <span class="hljs-number">3.0211617946624756</span> seconds.
 Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span> bytes_to_giga(bytes):<span class="hljs-string">\\n</span>   <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n\\nAnswer:</span> Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span>`,wrap:!1}}),Aa=new v({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),Ya=new v({props:{code:"MzIuNjE3MzMxOTgxNjU4OTM2",highlighted:'<span class="hljs-attribute">32</span>.<span class="hljs-number">617331981658936</span>',wrap:!1}}),Pa=new v({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),Da=new is({props:{title:"3. Architectural Innovations",local:"3-architectural-innovations",headingTag:"h2"}}),pe=new is({props:{title:"3.1 Improving positional embeddings of LLMs",local:"31-improving-positional-embeddings-of-llms",headingTag:"h3"}}),xe=new is({props:{title:"3.2 The key-value cache",local:"32-the-key-value-cache",headingTag:"h3"}}),_e=new v({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTVCJTIyaW5wdXRfaWRzJTIyJTVELnRvKCUyMmN1ZGElMjIpJTBBJTBBZm9yJTIwXyUyMGluJTIwcmFuZ2UoNSklM0ElMEElMjAlMjBuZXh0X2xvZ2l0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyklNUIlMjJsb2dpdHMlMjIlNUQlNUIlM0ElMkMlMjAtMSUzQSU1RCUwQSUyMCUyMG5leHRfdG9rZW5faWQlMjAlM0QlMjB0b3JjaC5hcmdtYXgobmV4dF9sb2dpdHMlMkNkaW0lM0QtMSklMEElMEElMjAlMjBpbnB1dF9pZHMlMjAlM0QlMjB0b3JjaC5jYXQoJTVCaW5wdXRfaWRzJTJDJTIwbmV4dF90b2tlbl9pZCU1RCUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMHByaW50KCUyMnNoYXBlJTIwb2YlMjBpbnB1dF9pZHMlMjIlMkMlMjBpbnB1dF9pZHMuc2hhcGUpJTBBJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGlucHV0X2lkcyU1QiUzQSUyQyUyMC01JTNBJTVEKSUwQWdlbmVyYXRlZF90ZXh0",highlighted:`input_ids = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>].to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
  next_logits = model(input_ids)[<span class="hljs-string">&quot;logits&quot;</span>][:, -<span class="hljs-number">1</span>:]
  next_token_id = torch.argmax(next_logits,dim=-<span class="hljs-number">1</span>)

  input_ids = torch.cat([input_ids, next_token_id], dim=-<span class="hljs-number">1</span>)
  <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;shape of input_ids&quot;</span>, input_ids.shape)

generated_text = tokenizer.batch_decode(input_ids[:, -<span class="hljs-number">5</span>:])
generated_text`,wrap:!1}}),Ue=new v({props:{code:"c2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDIxJTVEKSUwQXNoYXBlJTIwb2YlMjBpbnB1dF9pZHMlMjB0b3JjaC5TaXplKCU1QjElMkMlMjAyMiU1RCklMEFzaGFwZSUyMG9mJTIwaW5wdXRfaWRzJTIwdG9yY2guU2l6ZSglNUIxJTJDJTIwMjMlNUQpJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDI0JTVEKSUwQXNoYXBlJTIwb2YlMjBpbnB1dF9pZHMlMjB0b3JjaC5TaXplKCU1QjElMkMlMjAyNSU1RCklMEElNUInJTIwSGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJyU1RA==",highlighted:`shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 21]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 22]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 23]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 24]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 25]</span>)
<span class="hljs-selector-attr">[<span class="hljs-string">&#x27; Here is a Python function&#x27;</span>]</span>`,wrap:!1}}),Ge=new v({props:{code:"cGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwTm9uZSUyMCUyMyUyMHBhc3Rfa2V5X3ZhbHVlcyUyMGlzJTIwdGhlJTIwa2V5LXZhbHVlJTIwY2FjaGUlMEFnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIwJTVCJTVEJTBBbmV4dF90b2tlbl9pZCUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RC50byglMjJjdWRhJTIyKSUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDUpJTNBJTBBJTIwJTIwbmV4dF9sb2dpdHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlMjAlM0QlMjBtb2RlbChuZXh0X3Rva2VuX2lkJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSkudG9fdHVwbGUoKSUwQSUyMCUyMG5leHRfbG9naXRzJTIwJTNEJTIwbmV4dF9sb2dpdHMlNUIlM0ElMkMlMjAtMSUzQSU1RCUwQSUyMCUyMG5leHRfdG9rZW5faWQlMjAlM0QlMjB0b3JjaC5hcmdtYXgobmV4dF9sb2dpdHMlMkMlMjBkaW0lM0QtMSklMEElMEElMjAlMjBwcmludCglMjJzaGFwZSUyMG9mJTIwaW5wdXRfaWRzJTIyJTJDJTIwbmV4dF90b2tlbl9pZC5zaGFwZSklMEElMjAlMjBwcmludCglMjJsZW5ndGglMjBvZiUyMGtleS12YWx1ZSUyMGNhY2hlJTIyJTJDJTIwbGVuKHBhc3Rfa2V5X3ZhbHVlcyU1QjAlNUQlNUIwJTVEKSklMjAlMjAlMjMlMjBwYXN0X2tleV92YWx1ZXMlMjBhcmUlMjBvZiUyMHNoYXBlJTIwJTVCbnVtX2xheWVycyUyQyUyMDAlMjBmb3IlMjBrJTJDJTIwMSUyMGZvciUyMHYlMkMlMjBiYXRjaF9zaXplJTJDJTIwbGVuZ3RoJTJDJTIwaGlkZGVuX2RpbSU1RCUwQSUyMCUyMGdlbmVyYXRlZF90b2tlbnMuYXBwZW5kKG5leHRfdG9rZW5faWQuaXRlbSgpKSUwQSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfdG9rZW5zKSUwQWdlbmVyYXRlZF90ZXh0",highlighted:`past_key_values = <span class="hljs-literal">None</span> <span class="hljs-comment"># past_key_values is the key-value cache</span>
generated_tokens = []
next_token_id = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>].to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
  next_logits, past_key_values = model(next_token_id, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>).to_tuple()
  next_logits = next_logits[:, -<span class="hljs-number">1</span>:]
  next_token_id = torch.argmax(next_logits, dim=-<span class="hljs-number">1</span>)

  <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;shape of input_ids&quot;</span>, next_token_id.shape)
  <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;length of key-value cache&quot;</span>, <span class="hljs-built_in">len</span>(past_key_values[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]))  <span class="hljs-comment"># past_key_values are of shape [num_layers, 0 for k, 1 for v, batch_size, length, hidden_dim]</span>
  generated_tokens.append(next_token_id.item())

generated_text = tokenizer.batch_decode(generated_tokens)
generated_text`,wrap:!1}}),$e=new v({props:{code:"c2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIwJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIxJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIyJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIzJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDI0JTBBJTVCJyUyMEhlcmUnJTJDJTIwJyUyMGlzJyUyQyUyMCclMjBhJyUyQyUyMCclMjBQeXRob24nJTJDJTIwJyUyMGZ1bmN0aW9uJyU1RA==",highlighted:`<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">20</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">21</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">22</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">23</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">24</span><span class="hljs-meta">
[&#x27; Here&#x27;, &#x27; is&#x27;, &#x27; a&#x27;, &#x27; Python&#x27;, &#x27; function&#x27;]</span>`,wrap:!1}}),Ms=new Yw({props:{warning:!0,$$slots:{default:[Fw]},$$scope:{ctx:hl}}}),He=new is({props:{title:"3.2.1 Multi-round conversation",local:"321-multi-round-conversation",headingTag:"h4"}}),Ne=new v({props:{code:"VXNlciUzQSUyMEhvdyUyMG1hbnklMjBwZW9wbGUlMjBsaXZlJTIwaW4lMjBGcmFuY2UlM0YlMEFBc3Npc3RhbnQlM0ElMjBSb3VnaGx5JTIwNzUlMjBtaWxsaW9uJTIwcGVvcGxlJTIwbGl2ZSUyMGluJTIwRnJhbmNlJTBBVXNlciUzQSUyMEFuZCUyMGhvdyUyMG1hbnklMjBhcmUlMjBpbiUyMEdlcm1hbnklM0YlMEFBc3Npc3RhbnQlM0ElMjBHZXJtYW55JTIwaGFzJTIwY2EuJTIwODElMjBtaWxsaW9uJTIwaW5oYWJpdGFudHM=",highlighted:`<span class="hljs-symbol">User:</span> How many people live <span class="hljs-keyword">in</span> France?
<span class="hljs-symbol">Assistant:</span> Roughly <span class="hljs-number">75</span> million people live <span class="hljs-keyword">in</span> France
<span class="hljs-symbol">User:</span> <span class="hljs-keyword">And</span> how many are <span class="hljs-keyword">in</span> Germany?
<span class="hljs-symbol">Assistant:</span> Germany has ca. <span class="hljs-number">81</span> million inhabitants`,wrap:!1}}),Ye=new v({props:{code:"JTIzJTIwR2VuZXJhdGlvbiUyMGFzJTIwdXN1YWwlMEFwcm9tcHQlMjAlM0QlMjBzeXN0ZW1fcHJvbXB0JTIwJTJCJTIwJTIyUXVlc3Rpb24lM0ElMjBQbGVhc2UlMjB3cml0ZSUyMGElMjBmdW5jdGlvbiUyMGluJTIwUHl0aG9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzLiU1Q24lNUNuQW5zd2VyJTNBJTIwSGVyZSUyMiUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCdwdCcpJTBBZ2VuZXJhdGlvbl9vdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENjAlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUpJTBBZGVjb2RlZF9vdXRwdXQlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRpb25fb3V0cHV0LnNlcXVlbmNlcyklNUIwJTVEJTBBJTBBJTIzJTIwUGlwaW5nJTIwdGhlJTIwcmV0dXJuZWQlMjAlNjBwYXN0X2tleV92YWx1ZXMlNjAlMjB0byUyMHNwZWVkJTIwdXAlMjB0aGUlMjBuZXh0JTIwY29udmVyc2F0aW9uJTIwcm91bmQlMEFwcm9tcHQlMjAlM0QlMjBkZWNvZGVkX291dHB1dCUyMCUyQiUyMCUyMiU1Q25RdWVzdGlvbiUzQSUyMEhvdyUyMGNhbiUyMEklMjBtb2RpZnklMjB0aGUlMjBmdW5jdGlvbiUyMGFib3ZlJTIwdG8lMjByZXR1cm4lMjBNZWdhJTIwYnl0ZXMlMjBpbnN0ZWFkJTNGJTVDbiU1Q25BbnN3ZXIlM0ElMjBIZXJlJTIyJTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJ3B0JyklMEFnZW5lcmF0aW9uX291dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCoqbW9kZWxfaW5wdXRzJTJDJTBBJTIwJTIwcGFzdF9rZXlfdmFsdWVzJTNEZ2VuZXJhdGlvbl9vdXRwdXQucGFzdF9rZXlfdmFsdWVzJTJDJTBBJTIwJTIwbWF4X25ld190b2tlbnMlM0Q2MCUyQyUwQSUyMCUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUwQSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRpb25fb3V0cHV0LnNlcXVlbmNlcyklNUIwJTVEJTVCbGVuKHByb21wdCklM0ElNUQ=",highlighted:`<span class="hljs-comment"># Generation as usual</span>
prompt = system_prompt + <span class="hljs-string">&quot;Question: Please write a function in Python that transforms bytes to Giga bytes.\\n\\nAnswer: Here&quot;</span>
model_inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>)
generation_output = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">60</span>, return_dict_in_generate=<span class="hljs-literal">True</span>)
decoded_output = tokenizer.batch_decode(generation_output.sequences)[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Piping the returned \`past_key_values\` to speed up the next conversation round</span>
prompt = decoded_output + <span class="hljs-string">&quot;\\nQuestion: How can I modify the function above to return Mega bytes instead?\\n\\nAnswer: Here&quot;</span>
model_inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>)
generation_output = model.generate(
  **model_inputs,
  past_key_values=generation_output.past_key_values,
  max_new_tokens=<span class="hljs-number">60</span>,
  return_dict_in_generate=<span class="hljs-literal">True</span>
)
tokenizer.batch_decode(generation_output.sequences)[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(prompt):]`,wrap:!1}}),Fe=new v({props:{code:"JTIwaXMlMjBhJTIwbW9kaWZpZWQlMjB2ZXJzaW9uJTIwb2YlMjB0aGUlMjBmdW5jdGlvbiUyMHRoYXQlMjByZXR1cm5zJTIwTWVnYSUyMGJ5dGVzJTIwaW5zdGVhZC4lMEElMEFkZWYlMjBieXRlc190b19tZWdhYnl0ZXMoYnl0ZXMpJTNBJTBBJTIwJTIwJTIwcmV0dXJuJTIwYnl0ZXMlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUwQSUwQUFuc3dlciUzQSUyMFRoZSUyMGZ1bmN0aW9uJTIwdGFrZXMlMjBhJTIwbnVtYmVyJTIwb2YlMjBieXRlcyUyMGFzJTIwaW5wdXQlMjBhbmQlMjByZXR1cm5zJTIwdGhlJTIwbnVtYmVyJTIwb2Y=",highlighted:` <span class="hljs-keyword">is</span> a modified <span class="hljs-keyword">version</span> <span class="hljs-keyword">of</span> the <span class="hljs-keyword">function</span> that <span class="hljs-keyword">returns</span> Mega bytes <span class="hljs-keyword">instead</span>.

def bytes_to_megabytes(bytes):
   <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span>

Answer: The <span class="hljs-keyword">function</span> takes a number <span class="hljs-keyword">of</span> bytes <span class="hljs-keyword">as</span> <span class="hljs-keyword">input</span> <span class="hljs-keyword">and</span> <span class="hljs-keyword">returns</span> the number <span class="hljs-keyword">of</span>`,wrap:!1}}),Ke=new v({props:{code:"Y29uZmlnJTIwJTNEJTIwbW9kZWwuY29uZmlnJTBBMiUyMColMjAxNl8wMDAlMjAqJTIwY29uZmlnLm5fbGF5ZXIlMjAqJTIwY29uZmlnLm5faGVhZCUyMColMjBjb25maWcubl9lbWJkJTIwJTJGJTJGJTIwY29uZmlnLm5faGVhZA==",highlighted:`config = model.config
<span class="hljs-number">2</span> * <span class="hljs-number">16_000</span> * config.n_layer * config.n_head * config.n_embd // config.n_head`,wrap:!1}}),Oe=new v({props:{code:"Nzg2NDMyMDAwMA==",highlighted:'<span class="hljs-number">7864320000</span>',wrap:!1}}),tn=new is({props:{title:"3.2.2 Multi-Query-Attention (MQA)",local:"322-multi-query-attention-mqa",headingTag:"h4"}}),mn=new is({props:{title:"3.2.3 Grouped-Query-Attention (GQA)",local:"323-grouped-query-attention-gqa",headingTag:"h4"}}),un=new is({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),{c(){G=i("meta"),Cs=n(),P=i("p"),yn=n(),d(zs.$$.fragment),cl=n(),d(Ls.$$.fragment),ul=n(),Gs=i("p"),Gs.innerHTML=Yu,dl=n(),Bs=i("ul"),Bs.innerHTML=Su,gl=n(),$s=i("p"),$s.textContent=Fu,yl=n(),Zs=i("p"),Zs.textContent=Pu,fl=n(),Is=i("ol"),Is.innerHTML=Ku,wl=n(),Ws=i("p"),Ws.textContent=Du,bl=n(),d(Qs.$$.fragment),vl=n(),Hs=i("p"),Hs.innerHTML=Ou,Ml=n(),Xs=i("p"),Xs.innerHTML=sd,xl=n(),Ns=i("blockquote"),Ns.innerHTML=td,kl=n(),Rs=i("p"),Rs.textContent=ad,Tl=n(),Vs=i("blockquote"),Vs.innerHTML=ed,jl=n(),qs=i("p"),qs.textContent=nd,_l=n(),As=i("p"),As.textContent=ld,Jl=n(),Es=i("ul"),Es.innerHTML=id,Ul=n(),Ys=i("p"),Ys.innerHTML=pd,Cl=n(),Ss=i("p"),Ss.innerHTML=md,zl=n(),Fs=i("p"),Fs.innerHTML=od,Ll=n(),Ps=i("p"),Ps.textContent=rd,Gl=n(),d(Ks.$$.fragment),Bl=n(),d(Ds.$$.fragment),$l=n(),Os=i("p"),Os.innerHTML=hd,Zl=n(),st=i("p"),st.innerHTML=cd,Il=n(),tt=i("p"),tt.innerHTML=ud,Wl=n(),at=i("p"),at.innerHTML=dd,Ql=n(),d(et.$$.fragment),Hl=n(),d(nt.$$.fragment),Xl=n(),lt=i("p"),lt.innerHTML=gd,Nl=n(),d(it.$$.fragment),Rl=n(),pt=i("p"),pt.textContent=yd,Vl=n(),d(mt.$$.fragment),ql=n(),ot=i("p"),ot.innerHTML=fd,Al=n(),d(rt.$$.fragment),El=n(),ht=i("p"),ht.innerHTML=wd,Yl=n(),d(ct.$$.fragment),Sl=n(),ut=i("p"),ut.textContent=bd,Fl=n(),dt=i("blockquote"),dt.innerHTML=vd,Pl=n(),gt=i("p"),gt.innerHTML=Md,Kl=n(),yt=i("p"),yt.innerHTML=xd,Dl=n(),d(ft.$$.fragment),Ol=n(),wt=i("p"),wt.textContent=kd,si=n(),d(bt.$$.fragment),ti=n(),vt=i("p"),vt.innerHTML=Td,ai=n(),d(Mt.$$.fragment),ei=n(),xt=i("p"),xt.innerHTML=jd,ni=n(),kt=i("p"),kt.innerHTML=_d,li=n(),Tt=i("p"),Tt.textContent=Jd,ii=n(),jt=i("ul"),jt.innerHTML=Ud,pi=n(),B=i("p"),Uc=r("In a nutshell, this means that "),fn=i("em"),fn.textContent=Cd,Cc=r(" multiplications, with"),mi=new c(!1),oi=r(" being the "),wn=i("em"),wn.textContent=zd,zc=r(","),ri=new c(!1),hi=r(" being a weight matrix and"),ci=new c(!1),ui=r(` being the output:
`),di=new c(!1),gi=n(),_t=i("p"),Lc=r(`are changed to
`),yi=new c(!1),fi=n(),Jt=i("p"),Jt.textContent=Ld,wi=n(),Ut=i("p"),Ut.innerHTML=Gd,bi=n(),d(Ct.$$.fragment),vi=n(),zt=i("p"),zt.innerHTML=Bd,Mi=n(),d(Lt.$$.fragment),xi=n(),Gt=i("p"),Gt.textContent=$d,ki=n(),d(Bt.$$.fragment),Ti=n(),$t=i("p"),$t.innerHTML=Zd,ji=n(),d(Zt.$$.fragment),_i=n(),It=i("p"),It.textContent=Id,Ji=n(),d(Wt.$$.fragment),Ui=n(),Qt=i("p"),Qt.innerHTML=Wd,Ci=n(),d(Ht.$$.fragment),zi=n(),Xt=i("p"),Xt.textContent=Qd,Li=n(),Nt=i("p"),Nt.textContent=Hd,Gi=n(),d(Rt.$$.fragment),Bi=n(),d(Vt.$$.fragment),$i=n(),qt=i("p"),qt.innerHTML=Xd,Zi=n(),d(At.$$.fragment),Ii=n(),Et=i("p"),Et.innerHTML=Nd,Wi=n(),d(Yt.$$.fragment),Qi=n(),St=i("p"),St.innerHTML=Rd,Hi=n(),d(Ft.$$.fragment),Xi=n(),Pt=i("p"),Pt.innerHTML=Vd,Ni=n(),d(Kt.$$.fragment),Ri=n(),Dt=i("p"),Dt.textContent=qd,Vi=n(),Ot=i("p"),Ot.innerHTML=Ad,qi=n(),K=i("p"),Gc=r("Also note that inference here was again a bit slower compared to 8-bit quantization which is due to the more aggressive quantization method used for 4-bit quantization leading to"),Ai=new c(!1),Ei=r(" and"),Yi=new c(!1),Si=r(" taking longer during inference."),Fi=n(),d(sa.$$.fragment),Pi=n(),d(ta.$$.fragment),Ki=n(),aa=i("p"),aa.textContent=Ed,Di=n(),ea=i("p"),ea.textContent=Yd,Oi=n(),na=i("p"),na.innerHTML=Sd,sp=n(),la=i("blockquote"),la.innerHTML=Fd,tp=n(),ia=i("p"),ia.textContent=Pd,ap=n(),pa=i("p"),pa.innerHTML=Kd,ep=n(),d(ma.$$.fragment),np=n(),oa=i("p"),oa.textContent=Dd,lp=n(),q=i("p"),Bc=r(`Self-attention layers are central to Large Language Models (LLMs) in that they enable the model to understand the contextual relationships between input tokens.
However, the peak GPU memory consumption for self-attention layers grows `),bn=i("em"),bn.textContent=Od,$c=r(" both in compute and memory complexity with number of input tokens (also called "),vn=i("em"),vn.textContent=sg,Zc=r(") that we denote in the following by"),ip=new c(!1),pp=r(` .
While this is not really noticeable for shorter input sequences (of up to 1000 input tokens), it becomes a serious problem for longer input sequences (at around 16000 input tokens).`),mp=n(),T=i("p"),Ic=r("Let’s take a closer look. The formula to compute the output"),op=new c(!1),rp=r(" of a self-attention layer for an input"),hp=new c(!1),cp=r(" of length"),up=new c(!1),dp=r(` is:
`),gp=new c(!1),yp=n(),fp=new c(!1),wp=r(" is thereby the input sequence to the attention layer. The projections"),bp=new c(!1),vp=r(" and"),Mp=new c(!1),xp=r(" will each consist of"),kp=new c(!1),Tp=r(" vectors resulting in the"),jp=new c(!1),_p=r(" being of size"),Jp=new c(!1),Up=r(" ."),Cp=n(),U=i("p"),Wc=r(`LLMs usually have multiple attention heads, thus doing multiple self-attention computations in parallel.
Assuming, the LLM has 40 attention heads and runs in bfloat16 precision, we can calculate the memory requirement to store the`),zp=new c(!1),Lp=r(" matrices to be"),Gp=new c(!1),Bp=r(" bytes. For"),$p=new c(!1),Zp=r(" only around 50 MB of VRAM are needed, however, for"),Ip=new c(!1),Wp=r(" we would need 19 GB of VRAM, and for"),Qp=new c(!1),Hp=r(" we would need almost 1TB just to store the"),Xp=new c(!1),Np=r(" matrices."),Rp=n(),ra=i("p"),ra.textContent=tg,Vp=n(),ha=i("p"),ha.textContent=ag,qp=n(),A=i("p"),Qc=r("How can we get rid of the exorbitant memory requirements for large input lengths? We need a new way to compute the self-attention mechanism that gets rid of the"),Ap=new c(!1),Ep=r(" matrix. "),hs=i("a"),hs.textContent=eg,Hc=r(" developed exactly such a new algorithm and called it "),Mn=i("strong"),Mn.textContent=ng,Xc=r("."),Yp=n(),ps=i("p"),Nc=r("In a nutshell, Flash Attention breaks the "),Sp=new c(!1),Fp=r(`) computation apart and instead computes smaller chunks of the output by iterating over multiple softmax computation steps:
`),Pp=new c(!1),Kp=n(),W=i("p"),Rc=r("with"),Dp=new c(!1),Op=r(" and"),sm=new c(!1),tm=r(" being some softmax normalization statistics that need to be recomputed for every"),am=new c(!1),em=r(" and"),nm=new c(!1),lm=r(" ."),im=n(),ca=i("p"),ca.innerHTML=lg,pm=n(),ua=i("p"),ua.textContent=ig,mm=n(),xn=i("blockquote"),ms=i("p"),Vc=r("By keeping track of softmax normalization statistics and by using some smart mathematics, Flash Attention gives "),kn=i("strong"),kn.textContent=pg,qc=r(" outputs compared to the default self-attention layer at a memory cost that only increases linearly with"),om=new c(!1),rm=r(" ."),hm=n(),da=i("p"),da.innerHTML=mg,cm=n(),ga=i("blockquote"),ga.innerHTML=og,um=n(),D=i("p"),Ac=r("Essentially, Flash Attention makes sure that all intermediate write and read operations can be done using the fast "),Tn=i("em"),Tn.textContent=rg,Ec=r(" SRAM memory instead of having to access the slower VRAM memory to compute the output vector"),dm=new c(!1),gm=r(" ."),ym=n(),ya=i("p"),ya.innerHTML=hg,fm=n(),fa=i("p"),fa.textContent=cg,wm=n(),wa=i("p"),wa.innerHTML=ug,bm=n(),d(ba.$$.fragment),vm=n(),va=i("p"),va.innerHTML=dg,Mm=n(),d(Ma.$$.fragment),xm=n(),xa=i("p"),xa.textContent=gg,km=n(),d(ka.$$.fragment),Tm=n(),Ta=i("p"),Ta.innerHTML=yg,jm=n(),d(ja.$$.fragment),_m=n(),_a=i("p"),_a.innerHTML=fg,Jm=n(),d(Ja.$$.fragment),Um=n(),Ua=i("p"),Ua.textContent=wg,Cm=n(),Ca=i("p"),Ca.innerHTML=bg,zm=n(),za=i("p"),za.textContent=vg,Lm=n(),d(La.$$.fragment),Gm=n(),Ga=i("p"),Ga.innerHTML=Mg,Bm=n(),d(Ba.$$.fragment),$m=n(),$a=i("p"),$a.textContent=xg,Zm=n(),Za=i("p"),Za.innerHTML=kg,Im=n(),d(Ia.$$.fragment),Wm=n(),Wa=i("p"),Wa.innerHTML=Tg,Qm=n(),d(Qa.$$.fragment),Hm=n(),Ha=i("p"),Ha.textContent=jg,Xm=n(),d(Xa.$$.fragment),Nm=n(),Na=i("p"),Na.innerHTML=_g,Rm=n(),d(Ra.$$.fragment),Vm=n(),Va=i("p"),Va.textContent=Jg,qm=n(),qa=i("p"),qa.textContent=Ug,Am=n(),d(Aa.$$.fragment),Em=n(),Ea=i("p"),Ea.innerHTML=Cg,Ym=n(),d(Ya.$$.fragment),Sm=n(),Sa=i("p"),Sa.textContent=zg,Fm=n(),Fa=i("p"),Fa.textContent=Lg,Pm=n(),d(Pa.$$.fragment),Km=n(),Ka=i("p"),Ka.innerHTML=Gg,Dm=n(),d(Da.$$.fragment),Om=n(),Oa=i("p"),Oa.textContent=Bg,so=n(),se=i("ul"),se.innerHTML=$g,to=n(),te=i("p"),te.innerHTML=Zg,ao=n(),ae=i("ul"),ae.innerHTML=Ig,eo=n(),ee=i("p"),ee.innerHTML=Wg,no=n(),ne=i("p"),ne.textContent=Qg,lo=n(),le=i("ul"),le.innerHTML=Hg,io=n(),ie=i("p"),ie.textContent=Xg,po=n(),d(pe.$$.fragment),mo=n(),O=i("p"),Yc=r(`Self-attention puts each token in relation to each other’s tokens.
As an example, the`),oo=new c(!1),ro=r(" matrix of the text input sequence "),jn=i("em"),jn.textContent=Ng,Sc=r(" could look as follows:"),ho=n(),me=i("p"),me.innerHTML=Rg,co=n(),oe=i("p"),oe.innerHTML=Vg,uo=n(),Z=i("p"),Fc=r(`A LLM based on self-attention, but without position embeddings would have great difficulties in understanding the positions of the text inputs to each other.
This is because the probability score computed by`),go=new c(!1),yo=r(" relates each word token to each other word token in"),fo=new c(!1),wo=r(` computations regardless of their relative positional distance to each other.
Therefore, for the LLM without position embeddings each token appears to have the same distance to all other tokens, `),_n=i("em"),_n.textContent=qg,Pc=r(" differentiating between "),Jn=i("em"),Jn.textContent=Ag,Kc=r(" and "),Un=i("em"),Un.textContent=Eg,Dc=r(" would be very challenging."),bo=n(),re=i("p"),re.innerHTML=Yg,vo=n(),C=i("p"),Oc=r("The authors of the "),cs=i("a"),cs.innerHTML=Sg,su=r(" paper introduced sinusoidal positional embeddings"),Mo=new c(!1),xo=r(` .
where each vector`),ko=new c(!1),To=r(" is computed as a sinusoidal function of its position"),jo=new c(!1),_o=r(` .
The positional encodings are then simply added to the input sequence vectors`),Jo=new c(!1),Uo=r(" ="),Co=new c(!1),zo=r(" thereby cueing the model to better learn sentence order."),Lo=n(),ss=i("p"),tu=r("Instead of using fixed position embeddings, others (such as "),us=i("a"),us.textContent=Fg,au=r(") used learned positional encodings for which the positional embeddings"),Go=new c(!1),Bo=r(" are learned during training."),$o=n(),he=i("p"),he.textContent=Pg,Zo=n(),ds=i("ol"),R=i("li"),eu=r("Sinusoidal and learned position embeddings are both absolute positional embeddings, "),Cn=i("em"),Cn.textContent=Kg,nu=r(" encoding a unique embedding for each position id:"),Io=new c(!1),Wo=r(" . As shown by "),gs=i("a"),gs.textContent=Dg,lu=r(" and "),ys=i("a"),ys.textContent=Og,iu=r(", absolute positional embeddings lead to poor LLM performance for long text inputs. For long text inputs, it is advantageous if the model learns the relative positional distance input tokens have to each other instead of their absolute position."),pu=n(),ce=i("li"),mu=r("When using learned position embeddings, the LLM has to be trained on a fixed input length"),Qo=new c(!1),Ho=r(", which makes it difficult to extrapolate to an input length longer than what it was trained on."),Xo=n(),ue=i("p"),ue.textContent=sy,No=n(),de=i("ul"),de.innerHTML=ty,Ro=n(),E=i("p"),ou=r("Both "),zn=i("em"),zn.textContent=ay,ru=r(" and "),Ln=i("em"),Ln.textContent=ey,hu=r(" argue that it’s best to cue the LLM about sentence order directly in the self-attention algorithm as it’s there that word tokens are put into relation with each other. More specifically, sentence order should be cued by modifying the"),Vo=new c(!1),qo=r(" computation."),Ao=n(),k=i("p"),cu=r("Without going into too many details, "),Gn=i("em"),Gn.textContent=ny,uu=r(" notes that positional information can be encoded into query-key pairs, "),Bn=i("em"),Bn.textContent=ly,Eo=new c(!1),Yo=r(" and"),So=new c(!1),Fo=r(" by rotating each vector by an angle"),Po=new c(!1),Ko=r(" and"),Do=new c(!1),Oo=r(" respectively with"),sr=new c(!1),tr=r(` describing each vectors sentence position:
`),ar=new c(!1),er=n(),nr=new c(!1),lr=r(" thereby represents a rotational matrix."),ir=new c(!1),pr=r(" is "),$n=i("em"),$n.textContent=iy,du=r(" learned during training, but instead set to a pre-defined value that depends on the maximum input sequence length during training."),mr=n(),Zn=i("blockquote"),$=i("p"),gu=r("By doing so, the propability score between"),or=new c(!1),rr=r(" and"),hr=new c(!1),cr=r(" is only affected if"),ur=new c(!1),dr=r(" and solely depends on the relative distance"),gr=new c(!1),yr=r(" regardless of each vector’s specific positions"),fr=new c(!1),wr=r(" and"),br=new c(!1),vr=r(" ."),Mr=n(),ge=i("p"),ge.innerHTML=py,xr=n(),ye=i("ul"),ye.innerHTML=my,kr=n(),Y=i("p"),yu=r("As an alternative, "),In=i("em"),In.textContent=oy,fu=r(" proposes a much simpler relative position encoding scheme. The relative distance that input tokens have to each other is added as a negative integer scaled by a pre-defined value "),Wn=i("code"),Wn.textContent=ry,wu=r(" to each query-key entry of the"),Tr=new c(!1),jr=r(" matrix right before the softmax computation."),_r=n(),fe=i("p"),fe.innerHTML=hy,Jr=n(),we=i("p"),we.innerHTML=cy,Ur=n(),be=i("p"),be.innerHTML=uy,Cr=n(),ve=i("ul"),ve.innerHTML=dy,zr=n(),x=i("p"),bu=r("Both "),Qn=i("em"),Qn.textContent=gy,vu=r(" and "),Hn=i("em"),Hn.textContent=yy,Mu=r(" position encodings can extrapolate to input lengths not seen during training whereas it has been shown that extrapolation works much better out-of-the-box for "),Xn=i("em"),Xn.textContent=fy,xu=r(" as compared to "),Nn=i("em"),Nn.textContent=wy,ku=r(`.
For ALiBi, one simply increases the values of the lower triangular position matrix to match the length of the input sequence.
For `),Rn=i("em"),Rn.textContent=by,Tu=r(", keeping the same"),Lr=new c(!1),Gr=r(" that was used during training leads to poor results when passing text inputs much longer than those seen during training, "),Vn=i("em"),Vn.textContent=vy,ju=n(),fs=i("a"),fs.textContent=My,_u=r(". However, the community has found a couple of effective tricks that adapt"),Br=new c(!1),$r=r(", thereby allowing "),qn=i("em"),qn.textContent=xy,Ju=r(" position embeddings to work well for extrapolated text input sequences (see "),ws=i("a"),ws.textContent=ky,Uu=r(")."),Zr=n(),bs=i("blockquote"),An=i("p"),An.innerHTML=Ty,Cu=n(),os=i("ul"),Me=i("li"),zu=r("Positional cues about the text inputs should be given directly to the"),Ir=new c(!1),Wr=r(" matrix of the self-attention layer"),Lu=n(),En=i("li"),En.innerHTML=jy,Gu=n(),Yn=i("li"),Yn.textContent=_y,Qr=n(),S=i("p"),Bu=r("In conclusion, LLMs that are intended to be deployed in tasks that require handling large text inputs are better trained with relative positional embeddings, such as RoPE and ALiBi. Also note that even if an LLM with RoPE and ALiBi has been trained only on a fixed length of say"),Hr=new c(!1),Xr=r(" it can still be used in practice with text inputs much larger than"),Nr=new c(!1),Rr=r(", like"),Vr=new c(!1),qr=r(" by extrapolating the positional embeddings."),Ar=n(),d(xe.$$.fragment),Er=n(),ke=i("p"),ke.textContent=Jy,Yr=n(),Te=i("p"),Te.innerHTML=Uy,Sr=n(),je=i("p"),je.innerHTML=Cy,Fr=n(),d(_e.$$.fragment),Pr=n(),Je=i("p"),Je.innerHTML=zy,Kr=n(),d(Ue.$$.fragment),Dr=n(),Ce=i("p"),Ce.textContent=Ly,Or=n(),ze=i("p"),ze.innerHTML=Gy,sh=n(),z=i("p"),$u=r("As a consequence, tokens "),Sn=i("em"),Sn.textContent=By,Zu=r(" depend on previous tokens, more specifically the"),th=new c(!1),ah=r(" vector is never put in relation with any key, values vectors"),eh=new c(!1),nh=r(" if"),lh=new c(!1),ih=r(" . Instead"),ph=new c(!1),mh=r(" only attends to previous key-value vectors"),oh=new c(!1),rh=r(". In order to reduce unnecessary computation, one can therefore cache each layer’s key-value vectors for all previous timesteps."),hh=n(),Le=i("p"),Le.innerHTML=$y,ch=n(),d(Ge.$$.fragment),uh=n(),Be=i("p"),Be.innerHTML=Zy,dh=n(),d($e.$$.fragment),gh=n(),Ze=i("p"),Ze.innerHTML=Iy,yh=n(),Fn=i("blockquote"),V=i("p"),Iu=r("Making use of the key-value cache means that the"),fh=new c(!1),wh=r(" is essentially reduced to"),bh=new c(!1),vh=r(" with"),Mh=new c(!1),xh=r(" being the query projection of the currently passed input token which is "),Pn=i("em"),Pn.textContent=Wy,Wu=r(" just a single vector."),kh=n(),Ie=i("p"),Ie.textContent=Qy,Th=n(),vs=i("ul"),We=i("li"),Qu=r("Significant increase in computational efficiency as less computations are performed compared to computing the full"),jh=new c(!1),_h=r(" matrix. This leads to an increase in inference speed"),Hu=n(),Kn=i("li"),Kn.textContent=Hy,Jh=n(),Qe=i("blockquote"),Qe.innerHTML=Xy,Uh=n(),d(Ms.$$.fragment),Ch=n(),d(He.$$.fragment),zh=n(),Xe=i("p"),Xe.textContent=Ny,Lh=n(),d(Ne.$$.fragment),Gh=n(),Re=i("p"),Re.textContent=Ry,Bh=n(),Ve=i("ol"),Ve.innerHTML=Vy,$h=n(),qe=i("p"),qe.textContent=qy,Zh=n(),Ae=i("ol"),Ae.innerHTML=Ay,Ih=n(),Ee=i("p"),Ee.innerHTML=Ey,Wh=n(),d(Ye.$$.fragment),Qh=n(),Se=i("p"),Se.innerHTML=Yy,Hh=n(),d(Fe.$$.fragment),Xh=n(),ts=i("p"),Xu=r("Great, no additional time is spent recomputing the same key and values for the attention layer! There is however one catch. While the required peak memory for the"),Nh=new c(!1),Rh=r(" matrix is significantly reduced, holding the key-value cache in memory can become very memory expensive for long input sequences or multi-turn chat. Remember that the key-value cache needs to store the key-value vectors for all previous input vectors"),Vh=new c(!1),qh=r(" for all self-attention layers and for all attention heads."),Ah=n(),Pe=i("p"),Pe.innerHTML=Sy,Eh=n(),d(Ke.$$.fragment),Yh=n(),De=i("p"),De.innerHTML=Fy,Sh=n(),d(Oe.$$.fragment),Fh=n(),sn=i("p"),sn.innerHTML=Py,Ph=n(),d(tn.$$.fragment),Kh=n(),an=i("p"),an.innerHTML=Ky,Dh=n(),Dn=i("blockquote"),rs=i("p"),Nu=r("By using a single head-value projection weight pair, the key value vectors"),Oh=new c(!1),sc=r(" have to be identical across all attention heads which in turn means that we only need to store 1 key-value projection pair in the cache instead of "),On=i("code"),On.textContent=Dy,Ru=r(" ones."),tc=n(),en=i("p"),en.textContent=Oy,ac=n(),as=i("p"),Vu=r(`In addition to memory savings, MQA also leads to improved computational efficiency as explained in the following.
In auto-regressive decoding, large key-value vectors need to be reloaded, concatenated with the current key-value vector pair to be then fed into the`),ec=new c(!1),nc=r(" computation at every step. For auto-regressive decoding, the required memory bandwidth for the constant reloading can become a serious time bottleneck. By reducing the size of the key-value vectors less memory needs to be accessed, thus reducing the memory bandwidth bottleneck. For more detail, please have a look at "),xs=i("a"),xs.textContent=sf,qu=r("."),lc=n(),ks=i("p"),Au=r("The important part to understand here is that reducing the number of key-value attention heads to 1 only makes sense if a key-value cache is used. The peak memory consumption of the model for a single forward pass without key-value cache stays unchanged as every attention head still has a unique query vector so that each attention head still has a different"),ic=new c(!1),pc=r(" matrix."),mc=n(),nn=i("p"),nn.textContent=tf,oc=n(),ln=i("ul"),ln.innerHTML=af,rc=n(),pn=i("p"),pn.innerHTML=ef,hc=n(),d(mn.$$.fragment),cc=n(),on=i("p"),on.innerHTML=nf,uc=n(),rn=i("p"),rn.innerHTML=lf,dc=n(),hn=i("p"),hn.innerHTML=pf,gc=n(),cn=i("blockquote"),cn.innerHTML=mf,yc=n(),d(un.$$.fragment),fc=n(),dn=i("p"),dn.innerHTML=of,wc=n(),gn=i("p"),gn.innerHTML=rf,bc=n(),ol=i("p"),this.h()},l(s){const t=Ew("svelte-u9bgzb",document.head);G=p(t,"META",{name:!0,content:!0}),t.forEach(a),Cs=l(s),P=p(s,"P",{}),M(P).forEach(a),yn=l(s),g(zs.$$.fragment,s),cl=l(s),g(Ls.$$.fragment,s),ul=l(s),Gs=p(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-1b2qao5"&&(Gs.innerHTML=Yu),dl=l(s),Bs=p(s,"UL",{"data-svelte-h":!0}),o(Bs)!=="svelte-xknchk"&&(Bs.innerHTML=Su),gl=l(s),$s=p(s,"P",{"data-svelte-h":!0}),o($s)!=="svelte-1cl588t"&&($s.textContent=Fu),yl=l(s),Zs=p(s,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-f1zoss"&&(Zs.textContent=Pu),fl=l(s),Is=p(s,"OL",{"data-svelte-h":!0}),o(Is)!=="svelte-yc0h5e"&&(Is.innerHTML=Ku),wl=l(s),Ws=p(s,"P",{"data-svelte-h":!0}),o(Ws)!=="svelte-ihy2a8"&&(Ws.textContent=Du),bl=l(s),g(Qs.$$.fragment,s),vl=l(s),Hs=p(s,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-qqgdso"&&(Hs.innerHTML=Ou),Ml=l(s),Xs=p(s,"P",{"data-svelte-h":!0}),o(Xs)!=="svelte-ljb3iz"&&(Xs.innerHTML=sd),xl=l(s),Ns=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Ns)!=="svelte-4jkxwr"&&(Ns.innerHTML=td),kl=l(s),Rs=p(s,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-i58rjm"&&(Rs.textContent=ad),Tl=l(s),Vs=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Vs)!=="svelte-z4szg9"&&(Vs.innerHTML=ed),jl=l(s),qs=p(s,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-28orre"&&(qs.textContent=nd),_l=l(s),As=p(s,"P",{"data-svelte-h":!0}),o(As)!=="svelte-1jmd8j1"&&(As.textContent=ld),Jl=l(s),Es=p(s,"UL",{"data-svelte-h":!0}),o(Es)!=="svelte-1th1pdf"&&(Es.innerHTML=id),Ul=l(s),Ys=p(s,"P",{"data-svelte-h":!0}),o(Ys)!=="svelte-28fp1w"&&(Ys.innerHTML=pd),Cl=l(s),Ss=p(s,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-189eose"&&(Ss.innerHTML=md),zl=l(s),Fs=p(s,"P",{"data-svelte-h":!0}),o(Fs)!=="svelte-6j2ucx"&&(Fs.innerHTML=od),Ll=l(s),Ps=p(s,"P",{"data-svelte-h":!0}),o(Ps)!=="svelte-g7zrz4"&&(Ps.textContent=rd),Gl=l(s),g(Ks.$$.fragment,s),Bl=l(s),g(Ds.$$.fragment,s),$l=l(s),Os=p(s,"P",{"data-svelte-h":!0}),o(Os)!=="svelte-z9gs9x"&&(Os.innerHTML=hd),Zl=l(s),st=p(s,"P",{"data-svelte-h":!0}),o(st)!=="svelte-19462o4"&&(st.innerHTML=cd),Il=l(s),tt=p(s,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-ppeb89"&&(tt.innerHTML=ud),Wl=l(s),at=p(s,"P",{"data-svelte-h":!0}),o(at)!=="svelte-81gnnp"&&(at.innerHTML=dd),Ql=l(s),g(et.$$.fragment,s),Hl=l(s),g(nt.$$.fragment,s),Xl=l(s),lt=p(s,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-jl1fz0"&&(lt.innerHTML=gd),Nl=l(s),g(it.$$.fragment,s),Rl=l(s),pt=p(s,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-174suzs"&&(pt.textContent=yd),Vl=l(s),g(mt.$$.fragment,s),ql=l(s),ot=p(s,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-138fn6l"&&(ot.innerHTML=fd),Al=l(s),g(rt.$$.fragment,s),El=l(s),ht=p(s,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-jl1fz0"&&(ht.innerHTML=wd),Yl=l(s),g(ct.$$.fragment,s),Sl=l(s),ut=p(s,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-14j7eyl"&&(ut.textContent=bd),Fl=l(s),dt=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(dt)!=="svelte-1gvcuxd"&&(dt.innerHTML=vd),Pl=l(s),gt=p(s,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1urmxur"&&(gt.innerHTML=Md),Kl=l(s),yt=p(s,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1uylvrd"&&(yt.innerHTML=xd),Dl=l(s),g(ft.$$.fragment,s),Ol=l(s),wt=p(s,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-zicod6"&&(wt.textContent=kd),si=l(s),g(bt.$$.fragment,s),ti=l(s),vt=p(s,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-1prc48e"&&(vt.innerHTML=Td),ai=l(s),g(Mt.$$.fragment,s),ei=l(s),xt=p(s,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-1xisv4k"&&(xt.innerHTML=jd),ni=l(s),kt=p(s,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-xkk23p"&&(kt.innerHTML=_d),li=l(s),Tt=p(s,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-171gpq5"&&(Tt.textContent=Jd),ii=l(s),jt=p(s,"UL",{"data-svelte-h":!0}),o(jt)!=="svelte-11ifrvi"&&(jt.innerHTML=Ud),pi=l(s),B=p(s,"P",{});var I=M(B);Uc=h(I,"In a nutshell, this means that "),fn=p(I,"EM",{"data-svelte-h":!0}),o(fn)!=="svelte-1hxrv2n"&&(fn.textContent=Cd),Cc=h(I," multiplications, with"),mi=u(I,!1),oi=h(I," being the "),wn=p(I,"EM",{"data-svelte-h":!0}),o(wn)!=="svelte-9j42in"&&(wn.textContent=zd),zc=h(I,","),ri=u(I,!1),hi=h(I," being a weight matrix and"),ci=u(I,!1),ui=h(I,` being the output:
`),di=u(I,!1),I.forEach(a),gi=l(s),_t=p(s,"P",{});var Eu=M(_t);Lc=h(Eu,`are changed to
`),yi=u(Eu,!1),Eu.forEach(a),fi=l(s),Jt=p(s,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-12wl41q"&&(Jt.textContent=Ld),wi=l(s),Ut=p(s,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-8mpqh2"&&(Ut.innerHTML=Gd),bi=l(s),g(Ct.$$.fragment,s),vi=l(s),zt=p(s,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-6n5flp"&&(zt.innerHTML=Bd),Mi=l(s),g(Lt.$$.fragment,s),xi=l(s),Gt=p(s,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-1yy92n4"&&(Gt.textContent=$d),ki=l(s),g(Bt.$$.fragment,s),Ti=l(s),$t=p(s,"P",{"data-svelte-h":!0}),o($t)!=="svelte-jl1fz0"&&($t.innerHTML=Zd),ji=l(s),g(Zt.$$.fragment,s),_i=l(s),It=p(s,"P",{"data-svelte-h":!0}),o(It)!=="svelte-12urs7j"&&(It.textContent=Id),Ji=l(s),g(Wt.$$.fragment,s),Ui=l(s),Qt=p(s,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-jl1fz0"&&(Qt.innerHTML=Wd),Ci=l(s),g(Ht.$$.fragment,s),zi=l(s),Xt=p(s,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-x8wynt"&&(Xt.textContent=Qd),Li=l(s),Nt=p(s,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-3uld8v"&&(Nt.textContent=Hd),Gi=l(s),g(Rt.$$.fragment,s),Bi=l(s),g(Vt.$$.fragment,s),$i=l(s),qt=p(s,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-1sadlnz"&&(qt.innerHTML=Xd),Zi=l(s),g(At.$$.fragment,s),Ii=l(s),Et=p(s,"P",{"data-svelte-h":!0}),o(Et)!=="svelte-jl1fz0"&&(Et.innerHTML=Nd),Wi=l(s),g(Yt.$$.fragment,s),Qi=l(s),St=p(s,"P",{"data-svelte-h":!0}),o(St)!=="svelte-1scve2"&&(St.innerHTML=Rd),Hi=l(s),g(Ft.$$.fragment,s),Xi=l(s),Pt=p(s,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-jl1fz0"&&(Pt.innerHTML=Vd),Ni=l(s),g(Kt.$$.fragment,s),Ri=l(s),Dt=p(s,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-1mhmf5k"&&(Dt.textContent=qd),Vi=l(s),Ot=p(s,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-sad4qj"&&(Ot.innerHTML=Ad),qi=l(s),K=p(s,"P",{});var sl=M(K);Gc=h(sl,"Also note that inference here was again a bit slower compared to 8-bit quantization which is due to the more aggressive quantization method used for 4-bit quantization leading to"),Ai=u(sl,!1),Ei=h(sl," and"),Yi=u(sl,!1),Si=h(sl," taking longer during inference."),sl.forEach(a),Fi=l(s),g(sa.$$.fragment,s),Pi=l(s),g(ta.$$.fragment,s),Ki=l(s),aa=p(s,"P",{"data-svelte-h":!0}),o(aa)!=="svelte-9e7sx8"&&(aa.textContent=Ed),Di=l(s),ea=p(s,"P",{"data-svelte-h":!0}),o(ea)!=="svelte-pphiln"&&(ea.textContent=Yd),Oi=l(s),na=p(s,"P",{"data-svelte-h":!0}),o(na)!=="svelte-6h5u0r"&&(na.innerHTML=Sd),sp=l(s),la=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(la)!=="svelte-i1sgud"&&(la.innerHTML=Fd),tp=l(s),ia=p(s,"P",{"data-svelte-h":!0}),o(ia)!=="svelte-68w1lt"&&(ia.textContent=Pd),ap=l(s),pa=p(s,"P",{"data-svelte-h":!0}),o(pa)!=="svelte-ei9u00"&&(pa.innerHTML=Kd),ep=l(s),g(ma.$$.fragment,s),np=l(s),oa=p(s,"P",{"data-svelte-h":!0}),o(oa)!=="svelte-649tnu"&&(oa.textContent=Dd),lp=l(s),q=p(s,"P",{});var Ts=M(q);Bc=h(Ts,`Self-attention layers are central to Large Language Models (LLMs) in that they enable the model to understand the contextual relationships between input tokens.
However, the peak GPU memory consumption for self-attention layers grows `),bn=p(Ts,"EM",{"data-svelte-h":!0}),o(bn)!=="svelte-1jeo576"&&(bn.textContent=Od),$c=h(Ts," both in compute and memory complexity with number of input tokens (also called "),vn=p(Ts,"EM",{"data-svelte-h":!0}),o(vn)!=="svelte-1xe7eav"&&(vn.textContent=sg),Zc=h(Ts,") that we denote in the following by"),ip=u(Ts,!1),pp=h(Ts,` .
While this is not really noticeable for shorter input sequences (of up to 1000 input tokens), it becomes a serious problem for longer input sequences (at around 16000 input tokens).`),Ts.forEach(a),mp=l(s),T=p(s,"P",{});var J=M(T);Ic=h(J,"Let’s take a closer look. The formula to compute the output"),op=u(J,!1),rp=h(J," of a self-attention layer for an input"),hp=u(J,!1),cp=h(J," of length"),up=u(J,!1),dp=h(J,` is:
`),gp=u(J,!1),yp=l(J),fp=u(J,!1),wp=h(J," is thereby the input sequence to the attention layer. The projections"),bp=u(J,!1),vp=h(J," and"),Mp=u(J,!1),xp=h(J," will each consist of"),kp=u(J,!1),Tp=h(J," vectors resulting in the"),jp=u(J,!1),_p=h(J," being of size"),Jp=u(J,!1),Up=h(J," ."),J.forEach(a),Cp=l(s),U=p(s,"P",{});var Q=M(U);Wc=h(Q,`LLMs usually have multiple attention heads, thus doing multiple self-attention computations in parallel.
Assuming, the LLM has 40 attention heads and runs in bfloat16 precision, we can calculate the memory requirement to store the`),zp=u(Q,!1),Lp=h(Q," matrices to be"),Gp=u(Q,!1),Bp=h(Q," bytes. For"),$p=u(Q,!1),Zp=h(Q," only around 50 MB of VRAM are needed, however, for"),Ip=u(Q,!1),Wp=h(Q," we would need 19 GB of VRAM, and for"),Qp=u(Q,!1),Hp=h(Q," we would need almost 1TB just to store the"),Xp=u(Q,!1),Np=h(Q," matrices."),Q.forEach(a),Rp=l(s),ra=p(s,"P",{"data-svelte-h":!0}),o(ra)!=="svelte-bptbn2"&&(ra.textContent=tg),Vp=l(s),ha=p(s,"P",{"data-svelte-h":!0}),o(ha)!=="svelte-opmd8n"&&(ha.textContent=ag),qp=l(s),A=p(s,"P",{});var js=M(A);Qc=h(js,"How can we get rid of the exorbitant memory requirements for large input lengths? We need a new way to compute the self-attention mechanism that gets rid of the"),Ap=u(js,!1),Ep=h(js," matrix. "),hs=p(js,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(hs)!=="svelte-1h13bsr"&&(hs.textContent=eg),Hc=h(js," developed exactly such a new algorithm and called it "),Mn=p(js,"STRONG",{"data-svelte-h":!0}),o(Mn)!=="svelte-eh0j4m"&&(Mn.textContent=ng),Xc=h(js,"."),js.forEach(a),Yp=l(s),ps=p(s,"P",{});var rl=M(ps);Nc=h(rl,"In a nutshell, Flash Attention breaks the "),Sp=u(rl,!1),Fp=h(rl,`) computation apart and instead computes smaller chunks of the output by iterating over multiple softmax computation steps:
`),Pp=u(rl,!1),rl.forEach(a),Kp=l(s),W=p(s,"P",{});var es=M(W);Rc=h(es,"with"),Dp=u(es,!1),Op=h(es," and"),sm=u(es,!1),tm=h(es," being some softmax normalization statistics that need to be recomputed for every"),am=u(es,!1),em=h(es," and"),nm=u(es,!1),lm=h(es," ."),es.forEach(a),im=l(s),ca=p(s,"P",{"data-svelte-h":!0}),o(ca)!=="svelte-1q8406g"&&(ca.innerHTML=lg),pm=l(s),ua=p(s,"P",{"data-svelte-h":!0}),o(ua)!=="svelte-1ufr4xd"&&(ua.textContent=ig),mm=l(s),xn=p(s,"BLOCKQUOTE",{});var hf=M(xn);ms=p(hf,"P",{});var tl=M(ms);Vc=h(tl,"By keeping track of softmax normalization statistics and by using some smart mathematics, Flash Attention gives "),kn=p(tl,"STRONG",{"data-svelte-h":!0}),o(kn)!=="svelte-1fh6qbl"&&(kn.textContent=pg),qc=h(tl," outputs compared to the default self-attention layer at a memory cost that only increases linearly with"),om=u(tl,!1),rm=h(tl," ."),tl.forEach(a),hf.forEach(a),hm=l(s),da=p(s,"P",{"data-svelte-h":!0}),o(da)!=="svelte-1re0bhf"&&(da.innerHTML=mg),cm=l(s),ga=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(ga)!=="svelte-m261q0"&&(ga.innerHTML=og),um=l(s),D=p(s,"P",{});var al=M(D);Ac=h(al,"Essentially, Flash Attention makes sure that all intermediate write and read operations can be done using the fast "),Tn=p(al,"EM",{"data-svelte-h":!0}),o(Tn)!=="svelte-1g1d7vc"&&(Tn.textContent=rg),Ec=h(al," SRAM memory instead of having to access the slower VRAM memory to compute the output vector"),dm=u(al,!1),gm=h(al," ."),al.forEach(a),ym=l(s),ya=p(s,"P",{"data-svelte-h":!0}),o(ya)!=="svelte-1ew53wd"&&(ya.innerHTML=hg),fm=l(s),fa=p(s,"P",{"data-svelte-h":!0}),o(fa)!=="svelte-1uhed9l"&&(fa.textContent=cg),wm=l(s),wa=p(s,"P",{"data-svelte-h":!0}),o(wa)!=="svelte-66kx9u"&&(wa.innerHTML=ug),bm=l(s),g(ba.$$.fragment,s),vm=l(s),va=p(s,"P",{"data-svelte-h":!0}),o(va)!=="svelte-1qzrmrh"&&(va.innerHTML=dg),Mm=l(s),g(Ma.$$.fragment,s),xm=l(s),xa=p(s,"P",{"data-svelte-h":!0}),o(xa)!=="svelte-1lfqnh1"&&(xa.textContent=gg),km=l(s),g(ka.$$.fragment,s),Tm=l(s),Ta=p(s,"P",{"data-svelte-h":!0}),o(Ta)!=="svelte-tc5wkn"&&(Ta.innerHTML=yg),jm=l(s),g(ja.$$.fragment,s),_m=l(s),_a=p(s,"P",{"data-svelte-h":!0}),o(_a)!=="svelte-jl1fz0"&&(_a.innerHTML=fg),Jm=l(s),g(Ja.$$.fragment,s),Um=l(s),Ua=p(s,"P",{"data-svelte-h":!0}),o(Ua)!=="svelte-sz1cee"&&(Ua.textContent=wg),Cm=l(s),Ca=p(s,"P",{"data-svelte-h":!0}),o(Ca)!=="svelte-d2g4iy"&&(Ca.innerHTML=bg),zm=l(s),za=p(s,"P",{"data-svelte-h":!0}),o(za)!=="svelte-2il51v"&&(za.textContent=vg),Lm=l(s),g(La.$$.fragment,s),Gm=l(s),Ga=p(s,"P",{"data-svelte-h":!0}),o(Ga)!=="svelte-jl1fz0"&&(Ga.innerHTML=Mg),Bm=l(s),g(Ba.$$.fragment,s),$m=l(s),$a=p(s,"P",{"data-svelte-h":!0}),o($a)!=="svelte-1uumitt"&&($a.textContent=xg),Zm=l(s),Za=p(s,"P",{"data-svelte-h":!0}),o(Za)!=="svelte-bk1lpp"&&(Za.innerHTML=kg),Im=l(s),g(Ia.$$.fragment,s),Wm=l(s),Wa=p(s,"P",{"data-svelte-h":!0}),o(Wa)!=="svelte-wh831x"&&(Wa.innerHTML=Tg),Qm=l(s),g(Qa.$$.fragment,s),Hm=l(s),Ha=p(s,"P",{"data-svelte-h":!0}),o(Ha)!=="svelte-ncw8pe"&&(Ha.textContent=jg),Xm=l(s),g(Xa.$$.fragment,s),Nm=l(s),Na=p(s,"P",{"data-svelte-h":!0}),o(Na)!=="svelte-jl1fz0"&&(Na.innerHTML=_g),Rm=l(s),g(Ra.$$.fragment,s),Vm=l(s),Va=p(s,"P",{"data-svelte-h":!0}),o(Va)!=="svelte-1onj0qe"&&(Va.textContent=Jg),qm=l(s),qa=p(s,"P",{"data-svelte-h":!0}),o(qa)!=="svelte-1b8rrkf"&&(qa.textContent=Ug),Am=l(s),g(Aa.$$.fragment,s),Em=l(s),Ea=p(s,"P",{"data-svelte-h":!0}),o(Ea)!=="svelte-jl1fz0"&&(Ea.innerHTML=Cg),Ym=l(s),g(Ya.$$.fragment,s),Sm=l(s),Sa=p(s,"P",{"data-svelte-h":!0}),o(Sa)!=="svelte-gk4woy"&&(Sa.textContent=zg),Fm=l(s),Fa=p(s,"P",{"data-svelte-h":!0}),o(Fa)!=="svelte-1lt2th7"&&(Fa.textContent=Lg),Pm=l(s),g(Pa.$$.fragment,s),Km=l(s),Ka=p(s,"P",{"data-svelte-h":!0}),o(Ka)!=="svelte-fkwi5h"&&(Ka.innerHTML=Gg),Dm=l(s),g(Da.$$.fragment,s),Om=l(s),Oa=p(s,"P",{"data-svelte-h":!0}),o(Oa)!=="svelte-1i10a94"&&(Oa.textContent=Bg),so=l(s),se=p(s,"UL",{"data-svelte-h":!0}),o(se)!=="svelte-1ti1vbk"&&(se.innerHTML=$g),to=l(s),te=p(s,"P",{"data-svelte-h":!0}),o(te)!=="svelte-jqprou"&&(te.innerHTML=Zg),ao=l(s),ae=p(s,"UL",{"data-svelte-h":!0}),o(ae)!=="svelte-ig4ec7"&&(ae.innerHTML=Ig),eo=l(s),ee=p(s,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-awpy0j"&&(ee.innerHTML=Wg),no=l(s),ne=p(s,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-152e8kl"&&(ne.textContent=Qg),lo=l(s),le=p(s,"UL",{"data-svelte-h":!0}),o(le)!=="svelte-k4f0dn"&&(le.innerHTML=Hg),io=l(s),ie=p(s,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-wxdkvm"&&(ie.textContent=Xg),po=l(s),g(pe.$$.fragment,s),mo=l(s),O=p(s,"P",{});var el=M(O);Yc=h(el,`Self-attention puts each token in relation to each other’s tokens.
As an example, the`),oo=u(el,!1),ro=h(el," matrix of the text input sequence "),jn=p(el,"EM",{"data-svelte-h":!0}),o(jn)!=="svelte-13ogmf8"&&(jn.textContent=Ng),Sc=h(el," could look as follows:"),el.forEach(a),ho=l(s),me=p(s,"P",{"data-svelte-h":!0}),o(me)!=="svelte-7ssrcl"&&(me.innerHTML=Rg),co=l(s),oe=p(s,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1xg4o0y"&&(oe.innerHTML=Vg),uo=l(s),Z=p(s,"P",{});var F=M(Z);Fc=h(F,`A LLM based on self-attention, but without position embeddings would have great difficulties in understanding the positions of the text inputs to each other.
This is because the probability score computed by`),go=u(F,!1),yo=h(F," relates each word token to each other word token in"),fo=u(F,!1),wo=h(F,` computations regardless of their relative positional distance to each other.
Therefore, for the LLM without position embeddings each token appears to have the same distance to all other tokens, `),_n=p(F,"EM",{"data-svelte-h":!0}),o(_n)!=="svelte-2dbwd4"&&(_n.textContent=qg),Pc=h(F," differentiating between "),Jn=p(F,"EM",{"data-svelte-h":!0}),o(Jn)!=="svelte-1u1601v"&&(Jn.textContent=Ag),Kc=h(F," and "),Un=p(F,"EM",{"data-svelte-h":!0}),o(Un)!=="svelte-16pe0y3"&&(Un.textContent=Eg),Dc=h(F," would be very challenging."),F.forEach(a),bo=l(s),re=p(s,"P",{"data-svelte-h":!0}),o(re)!=="svelte-10v2cm"&&(re.innerHTML=Yg),vo=l(s),C=p(s,"P",{});var H=M(C);Oc=h(H,"The authors of the "),cs=p(H,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(cs)!=="svelte-507xi2"&&(cs.innerHTML=Sg),su=h(H," paper introduced sinusoidal positional embeddings"),Mo=u(H,!1),xo=h(H,` .
where each vector`),ko=u(H,!1),To=h(H," is computed as a sinusoidal function of its position"),jo=u(H,!1),_o=h(H,` .
The positional encodings are then simply added to the input sequence vectors`),Jo=u(H,!1),Uo=h(H," ="),Co=u(H,!1),zo=h(H," thereby cueing the model to better learn sentence order."),H.forEach(a),Lo=l(s),ss=p(s,"P",{});var nl=M(ss);tu=h(nl,"Instead of using fixed position embeddings, others (such as "),us=p(nl,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(us)!=="svelte-1j8obl2"&&(us.textContent=Fg),au=h(nl,") used learned positional encodings for which the positional embeddings"),Go=u(nl,!1),Bo=h(nl," are learned during training."),nl.forEach(a),$o=l(s),he=p(s,"P",{"data-svelte-h":!0}),o(he)!=="svelte-gfh3nk"&&(he.textContent=Pg),Zo=l(s),ds=p(s,"OL",{});var Mc=M(ds);R=p(Mc,"LI",{});var ns=M(R);eu=h(ns,"Sinusoidal and learned position embeddings are both absolute positional embeddings, "),Cn=p(ns,"EM",{"data-svelte-h":!0}),o(Cn)!=="svelte-1636wt6"&&(Cn.textContent=Kg),nu=h(ns," encoding a unique embedding for each position id:"),Io=u(ns,!1),Wo=h(ns," . As shown by "),gs=p(ns,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(gs)!=="svelte-1elqrnk"&&(gs.textContent=Dg),lu=h(ns," and "),ys=p(ns,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(ys)!=="svelte-sksjon"&&(ys.textContent=Og),iu=h(ns,", absolute positional embeddings lead to poor LLM performance for long text inputs. For long text inputs, it is advantageous if the model learns the relative positional distance input tokens have to each other instead of their absolute position."),ns.forEach(a),pu=l(Mc),ce=p(Mc,"LI",{});var xc=M(ce);mu=h(xc,"When using learned position embeddings, the LLM has to be trained on a fixed input length"),Qo=u(xc,!1),Ho=h(xc,", which makes it difficult to extrapolate to an input length longer than what it was trained on."),xc.forEach(a),Mc.forEach(a),Xo=l(s),ue=p(s,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-pzlnat"&&(ue.textContent=sy),No=l(s),de=p(s,"UL",{"data-svelte-h":!0}),o(de)!=="svelte-1q2i0ic"&&(de.innerHTML=ty),Ro=l(s),E=p(s,"P",{});var _s=M(E);ou=h(_s,"Both "),zn=p(_s,"EM",{"data-svelte-h":!0}),o(zn)!=="svelte-1koqbni"&&(zn.textContent=ay),ru=h(_s," and "),Ln=p(_s,"EM",{"data-svelte-h":!0}),o(Ln)!=="svelte-4g6i8t"&&(Ln.textContent=ey),hu=h(_s," argue that it’s best to cue the LLM about sentence order directly in the self-attention algorithm as it’s there that word tokens are put into relation with each other. More specifically, sentence order should be cued by modifying the"),Vo=u(_s,!1),qo=h(_s," computation."),_s.forEach(a),Ao=l(s),k=p(s,"P",{});var _=M(k);cu=h(_,"Without going into too many details, "),Gn=p(_,"EM",{"data-svelte-h":!0}),o(Gn)!=="svelte-1koqbni"&&(Gn.textContent=ny),uu=h(_," notes that positional information can be encoded into query-key pairs, "),Bn=p(_,"EM",{"data-svelte-h":!0}),o(Bn)!=="svelte-2dbwd4"&&(Bn.textContent=ly),Eo=u(_,!1),Yo=h(_," and"),So=u(_,!1),Fo=h(_," by rotating each vector by an angle"),Po=u(_,!1),Ko=h(_," and"),Do=u(_,!1),Oo=h(_," respectively with"),sr=u(_,!1),tr=h(_,` describing each vectors sentence position:
`),ar=u(_,!1),er=l(_),nr=u(_,!1),lr=h(_," thereby represents a rotational matrix."),ir=u(_,!1),pr=h(_," is "),$n=p(_,"EM",{"data-svelte-h":!0}),o($n)!=="svelte-r5iszh"&&($n.textContent=iy),du=h(_," learned during training, but instead set to a pre-defined value that depends on the maximum input sequence length during training."),_.forEach(a),mr=l(s),Zn=p(s,"BLOCKQUOTE",{});var cf=M(Zn);$=p(cf,"P",{});var X=M($);gu=h(X,"By doing so, the propability score between"),or=u(X,!1),rr=h(X," and"),hr=u(X,!1),cr=h(X," is only affected if"),ur=u(X,!1),dr=h(X," and solely depends on the relative distance"),gr=u(X,!1),yr=h(X," regardless of each vector’s specific positions"),fr=u(X,!1),wr=h(X," and"),br=u(X,!1),vr=h(X," ."),X.forEach(a),cf.forEach(a),Mr=l(s),ge=p(s,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1ct7c61"&&(ge.innerHTML=py),xr=l(s),ye=p(s,"UL",{"data-svelte-h":!0}),o(ye)!=="svelte-1ggqrue"&&(ye.innerHTML=my),kr=l(s),Y=p(s,"P",{});var Js=M(Y);yu=h(Js,"As an alternative, "),In=p(Js,"EM",{"data-svelte-h":!0}),o(In)!=="svelte-4g6i8t"&&(In.textContent=oy),fu=h(Js," proposes a much simpler relative position encoding scheme. The relative distance that input tokens have to each other is added as a negative integer scaled by a pre-defined value "),Wn=p(Js,"CODE",{"data-svelte-h":!0}),o(Wn)!=="svelte-1gskrin"&&(Wn.textContent=ry),wu=h(Js," to each query-key entry of the"),Tr=u(Js,!1),jr=h(Js," matrix right before the softmax computation."),Js.forEach(a),_r=l(s),fe=p(s,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1sb0gvf"&&(fe.innerHTML=hy),Jr=l(s),we=p(s,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1stpbxv"&&(we.innerHTML=cy),Ur=l(s),be=p(s,"P",{"data-svelte-h":!0}),o(be)!=="svelte-3uyjm"&&(be.innerHTML=uy),Cr=l(s),ve=p(s,"UL",{"data-svelte-h":!0}),o(ve)!=="svelte-l3k8fx"&&(ve.innerHTML=dy),zr=l(s),x=p(s,"P",{});var j=M(x);bu=h(j,"Both "),Qn=p(j,"EM",{"data-svelte-h":!0}),o(Qn)!=="svelte-1koqbni"&&(Qn.textContent=gy),vu=h(j," and "),Hn=p(j,"EM",{"data-svelte-h":!0}),o(Hn)!=="svelte-4g6i8t"&&(Hn.textContent=yy),Mu=h(j," position encodings can extrapolate to input lengths not seen during training whereas it has been shown that extrapolation works much better out-of-the-box for "),Xn=p(j,"EM",{"data-svelte-h":!0}),o(Xn)!=="svelte-4g6i8t"&&(Xn.textContent=fy),xu=h(j," as compared to "),Nn=p(j,"EM",{"data-svelte-h":!0}),o(Nn)!=="svelte-1koqbni"&&(Nn.textContent=wy),ku=h(j,`.
For ALiBi, one simply increases the values of the lower triangular position matrix to match the length of the input sequence.
For `),Rn=p(j,"EM",{"data-svelte-h":!0}),o(Rn)!=="svelte-1koqbni"&&(Rn.textContent=by),Tu=h(j,", keeping the same"),Lr=u(j,!1),Gr=h(j," that was used during training leads to poor results when passing text inputs much longer than those seen during training, "),Vn=p(j,"EM",{"data-svelte-h":!0}),o(Vn)!=="svelte-6ye6px"&&(Vn.textContent=vy),ju=l(j),fs=p(j,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(fs)!=="svelte-1wv3alf"&&(fs.textContent=My),_u=h(j,". However, the community has found a couple of effective tricks that adapt"),Br=u(j,!1),$r=h(j,", thereby allowing "),qn=p(j,"EM",{"data-svelte-h":!0}),o(qn)!=="svelte-1koqbni"&&(qn.textContent=xy),Ju=h(j," position embeddings to work well for extrapolated text input sequences (see "),ws=p(j,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(ws)!=="svelte-ax8fr8"&&(ws.textContent=ky),Uu=h(j,")."),j.forEach(a),Zr=l(s),bs=p(s,"BLOCKQUOTE",{});var kc=M(bs);An=p(kc,"P",{"data-svelte-h":!0}),o(An)!=="svelte-1bw79ap"&&(An.innerHTML=Ty),Cu=l(kc),os=p(kc,"UL",{});var ll=M(os);Me=p(ll,"LI",{});var Tc=M(Me);zu=h(Tc,"Positional cues about the text inputs should be given directly to the"),Ir=u(Tc,!1),Wr=h(Tc," matrix of the self-attention layer"),Tc.forEach(a),Lu=l(ll),En=p(ll,"LI",{"data-svelte-h":!0}),o(En)!=="svelte-lwsxvy"&&(En.innerHTML=jy),Gu=l(ll),Yn=p(ll,"LI",{"data-svelte-h":!0}),o(Yn)!=="svelte-as1kp0"&&(Yn.textContent=_y),ll.forEach(a),kc.forEach(a),Qr=l(s),S=p(s,"P",{});var Us=M(S);Bu=h(Us,"In conclusion, LLMs that are intended to be deployed in tasks that require handling large text inputs are better trained with relative positional embeddings, such as RoPE and ALiBi. Also note that even if an LLM with RoPE and ALiBi has been trained only on a fixed length of say"),Hr=u(Us,!1),Xr=h(Us," it can still be used in practice with text inputs much larger than"),Nr=u(Us,!1),Rr=h(Us,", like"),Vr=u(Us,!1),qr=h(Us," by extrapolating the positional embeddings."),Us.forEach(a),Ar=l(s),g(xe.$$.fragment,s),Er=l(s),ke=p(s,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-ph4j6j"&&(ke.textContent=Jy),Yr=l(s),Te=p(s,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-583sqe"&&(Te.innerHTML=Uy),Sr=l(s),je=p(s,"P",{"data-svelte-h":!0}),o(je)!=="svelte-809dal"&&(je.innerHTML=Cy),Fr=l(s),g(_e.$$.fragment,s),Pr=l(s),Je=p(s,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-jl1fz0"&&(Je.innerHTML=zy),Kr=l(s),g(Ue.$$.fragment,s),Dr=l(s),Ce=p(s,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1hvw6ou"&&(Ce.textContent=Ly),Or=l(s),ze=p(s,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-cclyh"&&(ze.innerHTML=Gy),sh=l(s),z=p(s,"P",{});var N=M(z);$u=h(N,"As a consequence, tokens "),Sn=p(N,"EM",{"data-svelte-h":!0}),o(Sn)!=="svelte-1pjm1n8"&&(Sn.textContent=By),Zu=h(N," depend on previous tokens, more specifically the"),th=u(N,!1),ah=h(N," vector is never put in relation with any key, values vectors"),eh=u(N,!1),nh=h(N," if"),lh=u(N,!1),ih=h(N," . Instead"),ph=u(N,!1),mh=h(N," only attends to previous key-value vectors"),oh=u(N,!1),rh=h(N,". In order to reduce unnecessary computation, one can therefore cache each layer’s key-value vectors for all previous timesteps."),N.forEach(a),hh=l(s),Le=p(s,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-1f21m0a"&&(Le.innerHTML=$y),ch=l(s),g(Ge.$$.fragment,s),uh=l(s),Be=p(s,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-jl1fz0"&&(Be.innerHTML=Zy),dh=l(s),g($e.$$.fragment,s),gh=l(s),Ze=p(s,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-sjvt58"&&(Ze.innerHTML=Iy),yh=l(s),Fn=p(s,"BLOCKQUOTE",{});var uf=M(Fn);V=p(uf,"P",{});var ls=M(V);Iu=h(ls,"Making use of the key-value cache means that the"),fh=u(ls,!1),wh=h(ls," is essentially reduced to"),bh=u(ls,!1),vh=h(ls," with"),Mh=u(ls,!1),xh=h(ls," being the query projection of the currently passed input token which is "),Pn=p(ls,"EM",{"data-svelte-h":!0}),o(Pn)!=="svelte-x3mkar"&&(Pn.textContent=Wy),Wu=h(ls," just a single vector."),ls.forEach(a),uf.forEach(a),kh=l(s),Ie=p(s,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1xsdpw0"&&(Ie.textContent=Qy),Th=l(s),vs=p(s,"UL",{});var jc=M(vs);We=p(jc,"LI",{});var _c=M(We);Qu=h(_c,"Significant increase in computational efficiency as less computations are performed compared to computing the full"),jh=u(_c,!1),_h=h(_c," matrix. This leads to an increase in inference speed"),_c.forEach(a),Hu=l(jc),Kn=p(jc,"LI",{"data-svelte-h":!0}),o(Kn)!=="svelte-1uy8i0e"&&(Kn.textContent=Hy),jc.forEach(a),Jh=l(s),Qe=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Qe)!=="svelte-ecu5gq"&&(Qe.innerHTML=Xy),Uh=l(s),g(Ms.$$.fragment,s),Ch=l(s),g(He.$$.fragment,s),zh=l(s),Xe=p(s,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-15et702"&&(Xe.textContent=Ny),Lh=l(s),g(Ne.$$.fragment,s),Gh=l(s),Re=p(s,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1nmendz"&&(Re.textContent=Ry),Bh=l(s),Ve=p(s,"OL",{"data-svelte-h":!0}),o(Ve)!=="svelte-shg0uc"&&(Ve.innerHTML=Vy),$h=l(s),qe=p(s,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-cqzbwt"&&(qe.textContent=qy),Zh=l(s),Ae=p(s,"OL",{"data-svelte-h":!0}),o(Ae)!=="svelte-1bgwi27"&&(Ae.innerHTML=Ay),Ih=l(s),Ee=p(s,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-naw54a"&&(Ee.innerHTML=Ey),Wh=l(s),g(Ye.$$.fragment,s),Qh=l(s),Se=p(s,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-jl1fz0"&&(Se.innerHTML=Yy),Hh=l(s),g(Fe.$$.fragment,s),Xh=l(s),ts=p(s,"P",{});var il=M(ts);Xu=h(il,"Great, no additional time is spent recomputing the same key and values for the attention layer! There is however one catch. While the required peak memory for the"),Nh=u(il,!1),Rh=h(il," matrix is significantly reduced, holding the key-value cache in memory can become very memory expensive for long input sequences or multi-turn chat. Remember that the key-value cache needs to store the key-value vectors for all previous input vectors"),Vh=u(il,!1),qh=h(il," for all self-attention layers and for all attention heads."),il.forEach(a),Ah=l(s),Pe=p(s,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-hoekyy"&&(Pe.innerHTML=Sy),Eh=l(s),g(Ke.$$.fragment,s),Yh=l(s),De=p(s,"P",{"data-svelte-h":!0}),o(De)!=="svelte-jl1fz0"&&(De.innerHTML=Fy),Sh=l(s),g(Oe.$$.fragment,s),Fh=l(s),sn=p(s,"P",{"data-svelte-h":!0}),o(sn)!=="svelte-yntyqd"&&(sn.innerHTML=Py),Ph=l(s),g(tn.$$.fragment,s),Kh=l(s),an=p(s,"P",{"data-svelte-h":!0}),o(an)!=="svelte-15s0o0t"&&(an.innerHTML=Ky),Dh=l(s),Dn=p(s,"BLOCKQUOTE",{});var df=M(Dn);rs=p(df,"P",{});var pl=M(rs);Nu=h(pl,"By using a single head-value projection weight pair, the key value vectors"),Oh=u(pl,!1),sc=h(pl," have to be identical across all attention heads which in turn means that we only need to store 1 key-value projection pair in the cache instead of "),On=p(pl,"CODE",{"data-svelte-h":!0}),o(On)!=="svelte-6j0g1x"&&(On.textContent=Dy),Ru=h(pl," ones."),pl.forEach(a),df.forEach(a),tc=l(s),en=p(s,"P",{"data-svelte-h":!0}),o(en)!=="svelte-16lijvq"&&(en.textContent=Oy),ac=l(s),as=p(s,"P",{});var ml=M(as);Vu=h(ml,`In addition to memory savings, MQA also leads to improved computational efficiency as explained in the following.
In auto-regressive decoding, large key-value vectors need to be reloaded, concatenated with the current key-value vector pair to be then fed into the`),ec=u(ml,!1),nc=h(ml," computation at every step. For auto-regressive decoding, the required memory bandwidth for the constant reloading can become a serious time bottleneck. By reducing the size of the key-value vectors less memory needs to be accessed, thus reducing the memory bandwidth bottleneck. For more detail, please have a look at "),xs=p(ml,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(xs)!=="svelte-cg4wmi"&&(xs.textContent=sf),qu=h(ml,"."),ml.forEach(a),lc=l(s),ks=p(s,"P",{});var Jc=M(ks);Au=h(Jc,"The important part to understand here is that reducing the number of key-value attention heads to 1 only makes sense if a key-value cache is used. The peak memory consumption of the model for a single forward pass without key-value cache stays unchanged as every attention head still has a unique query vector so that each attention head still has a different"),ic=u(Jc,!1),pc=h(Jc," matrix."),Jc.forEach(a),mc=l(s),nn=p(s,"P",{"data-svelte-h":!0}),o(nn)!=="svelte-1q4ym7y"&&(nn.textContent=tf),oc=l(s),ln=p(s,"UL",{"data-svelte-h":!0}),o(ln)!=="svelte-c4p3y"&&(ln.innerHTML=af),rc=l(s),pn=p(s,"P",{"data-svelte-h":!0}),o(pn)!=="svelte-fzvfyw"&&(pn.innerHTML=ef),hc=l(s),g(mn.$$.fragment,s),cc=l(s),on=p(s,"P",{"data-svelte-h":!0}),o(on)!=="svelte-1vaiukl"&&(on.innerHTML=nf),uc=l(s),rn=p(s,"P",{"data-svelte-h":!0}),o(rn)!=="svelte-1rn3bde"&&(rn.innerHTML=lf),dc=l(s),hn=p(s,"P",{"data-svelte-h":!0}),o(hn)!=="svelte-c4mo8y"&&(hn.innerHTML=pf),gc=l(s),cn=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(cn)!=="svelte-xhly52"&&(cn.innerHTML=mf),yc=l(s),g(un.$$.fragment,s),fc=l(s),dn=p(s,"P",{"data-svelte-h":!0}),o(dn)!=="svelte-1r7m8vw"&&(dn.innerHTML=of),wc=l(s),gn=p(s,"P",{"data-svelte-h":!0}),o(gn)!=="svelte-2w30uj"&&(gn.innerHTML=rf),bc=l(s),ol=p(s,"P",{}),M(ol).forEach(a),this.h()},h(){L(G,"name","hf:doc:metadata"),L(G,"content",Kw),mi.a=oi,ri.a=hi,ci.a=ui,di.a=null,yi.a=null,Ai.a=Ei,Yi.a=Si,ip.a=pp,op.a=rp,hp.a=cp,up.a=dp,gp.a=yp,fp.a=wp,bp.a=vp,Mp.a=xp,kp.a=Tp,jp.a=_p,Jp.a=Up,zp.a=Lp,Gp.a=Bp,$p.a=Zp,Ip.a=Wp,Qp.a=Hp,Xp.a=Np,Ap.a=Ep,L(hs,"href","https://arxiv.org/abs/2205.14135"),L(hs,"rel","nofollow"),Sp.a=Fp,Pp.a=null,Dp.a=Op,sm.a=tm,am.a=em,nm.a=lm,om.a=rm,dm.a=gm,oo.a=ro,go.a=yo,fo.a=wo,L(cs,"href","https://arxiv.org/abs/1706.03762"),L(cs,"rel","nofollow"),Mo.a=xo,ko.a=To,jo.a=_o,Jo.a=Uo,Co.a=zo,L(us,"href","https://arxiv.org/abs/1810.04805"),L(us,"rel","nofollow"),Go.a=Bo,Io.a=Wo,L(gs,"href","https://arxiv.org/abs/2009.13658"),L(gs,"rel","nofollow"),L(ys,"href","https://arxiv.org/abs/2104.09864"),L(ys,"rel","nofollow"),Qo.a=Ho,Vo.a=qo,Eo.a=Yo,So.a=Fo,Po.a=Ko,Do.a=Oo,sr.a=tr,ar.a=er,nr.a=lr,ir.a=pr,or.a=rr,hr.a=cr,ur.a=dr,gr.a=yr,fr.a=wr,br.a=vr,Tr.a=jr,Lr.a=Gr,L(fs,"href","https://arxiv.org/abs/2108.12409"),L(fs,"rel","nofollow"),Br.a=$r,L(ws,"href","https://github.com/huggingface/transformers/pull/24653"),L(ws,"rel","nofollow"),Ir.a=Wr,Hr.a=Xr,Nr.a=Rr,Vr.a=qr,th.a=ah,eh.a=nh,lh.a=ih,ph.a=mh,oh.a=rh,fh.a=wh,bh.a=vh,Mh.a=xh,jh.a=_h,Nh.a=Rh,Vh.a=qh,Oh.a=sc,ec.a=nc,L(xs,"href","https://arxiv.org/abs/1911.02150"),L(xs,"rel","nofollow"),ic.a=pc},m(s,t){m(document.head,G),e(s,Cs,t),e(s,P,t),e(s,yn,t),y(zs,s,t),e(s,cl,t),y(Ls,s,t),e(s,ul,t),e(s,Gs,t),e(s,dl,t),e(s,Bs,t),e(s,gl,t),e(s,$s,t),e(s,yl,t),e(s,Zs,t),e(s,fl,t),e(s,Is,t),e(s,wl,t),e(s,Ws,t),e(s,bl,t),y(Qs,s,t),e(s,vl,t),e(s,Hs,t),e(s,Ml,t),e(s,Xs,t),e(s,xl,t),e(s,Ns,t),e(s,kl,t),e(s,Rs,t),e(s,Tl,t),e(s,Vs,t),e(s,jl,t),e(s,qs,t),e(s,_l,t),e(s,As,t),e(s,Jl,t),e(s,Es,t),e(s,Ul,t),e(s,Ys,t),e(s,Cl,t),e(s,Ss,t),e(s,zl,t),e(s,Fs,t),e(s,Ll,t),e(s,Ps,t),e(s,Gl,t),y(Ks,s,t),e(s,Bl,t),y(Ds,s,t),e(s,$l,t),e(s,Os,t),e(s,Zl,t),e(s,st,t),e(s,Il,t),e(s,tt,t),e(s,Wl,t),e(s,at,t),e(s,Ql,t),y(et,s,t),e(s,Hl,t),y(nt,s,t),e(s,Xl,t),e(s,lt,t),e(s,Nl,t),y(it,s,t),e(s,Rl,t),e(s,pt,t),e(s,Vl,t),y(mt,s,t),e(s,ql,t),e(s,ot,t),e(s,Al,t),y(rt,s,t),e(s,El,t),e(s,ht,t),e(s,Yl,t),y(ct,s,t),e(s,Sl,t),e(s,ut,t),e(s,Fl,t),e(s,dt,t),e(s,Pl,t),e(s,gt,t),e(s,Kl,t),e(s,yt,t),e(s,Dl,t),y(ft,s,t),e(s,Ol,t),e(s,wt,t),e(s,si,t),y(bt,s,t),e(s,ti,t),e(s,vt,t),e(s,ai,t),y(Mt,s,t),e(s,ei,t),e(s,xt,t),e(s,ni,t),e(s,kt,t),e(s,li,t),e(s,Tt,t),e(s,ii,t),e(s,jt,t),e(s,pi,t),e(s,B,t),m(B,Uc),m(B,fn),m(B,Cc),mi.m(gf,B),m(B,oi),m(B,wn),m(B,zc),ri.m(yf,B),m(B,hi),ci.m(ff,B),m(B,ui),di.m(wf,B),e(s,gi,t),e(s,_t,t),m(_t,Lc),yi.m(bf,_t),e(s,fi,t),e(s,Jt,t),e(s,wi,t),e(s,Ut,t),e(s,bi,t),y(Ct,s,t),e(s,vi,t),e(s,zt,t),e(s,Mi,t),y(Lt,s,t),e(s,xi,t),e(s,Gt,t),e(s,ki,t),y(Bt,s,t),e(s,Ti,t),e(s,$t,t),e(s,ji,t),y(Zt,s,t),e(s,_i,t),e(s,It,t),e(s,Ji,t),y(Wt,s,t),e(s,Ui,t),e(s,Qt,t),e(s,Ci,t),y(Ht,s,t),e(s,zi,t),e(s,Xt,t),e(s,Li,t),e(s,Nt,t),e(s,Gi,t),y(Rt,s,t),e(s,Bi,t),y(Vt,s,t),e(s,$i,t),e(s,qt,t),e(s,Zi,t),y(At,s,t),e(s,Ii,t),e(s,Et,t),e(s,Wi,t),y(Yt,s,t),e(s,Qi,t),e(s,St,t),e(s,Hi,t),y(Ft,s,t),e(s,Xi,t),e(s,Pt,t),e(s,Ni,t),y(Kt,s,t),e(s,Ri,t),e(s,Dt,t),e(s,Vi,t),e(s,Ot,t),e(s,qi,t),e(s,K,t),m(K,Gc),Ai.m(vf,K),m(K,Ei),Yi.m(Mf,K),m(K,Si),e(s,Fi,t),y(sa,s,t),e(s,Pi,t),y(ta,s,t),e(s,Ki,t),e(s,aa,t),e(s,Di,t),e(s,ea,t),e(s,Oi,t),e(s,na,t),e(s,sp,t),e(s,la,t),e(s,tp,t),e(s,ia,t),e(s,ap,t),e(s,pa,t),e(s,ep,t),y(ma,s,t),e(s,np,t),e(s,oa,t),e(s,lp,t),e(s,q,t),m(q,Bc),m(q,bn),m(q,$c),m(q,vn),m(q,Zc),ip.m(xf,q),m(q,pp),e(s,mp,t),e(s,T,t),m(T,Ic),op.m(kf,T),m(T,rp),hp.m(Tf,T),m(T,cp),up.m(jf,T),m(T,dp),gp.m(_f,T),m(T,yp),fp.m(Jf,T),m(T,wp),bp.m(Uf,T),m(T,vp),Mp.m(Cf,T),m(T,xp),kp.m(zf,T),m(T,Tp),jp.m(Lf,T),m(T,_p),Jp.m(Gf,T),m(T,Up),e(s,Cp,t),e(s,U,t),m(U,Wc),zp.m(Bf,U),m(U,Lp),Gp.m($f,U),m(U,Bp),$p.m(Zf,U),m(U,Zp),Ip.m(If,U),m(U,Wp),Qp.m(Wf,U),m(U,Hp),Xp.m(Qf,U),m(U,Np),e(s,Rp,t),e(s,ra,t),e(s,Vp,t),e(s,ha,t),e(s,qp,t),e(s,A,t),m(A,Qc),Ap.m(Hf,A),m(A,Ep),m(A,hs),m(A,Hc),m(A,Mn),m(A,Xc),e(s,Yp,t),e(s,ps,t),m(ps,Nc),Sp.m(Xf,ps),m(ps,Fp),Pp.m(Nf,ps),e(s,Kp,t),e(s,W,t),m(W,Rc),Dp.m(Rf,W),m(W,Op),sm.m(Vf,W),m(W,tm),am.m(qf,W),m(W,em),nm.m(Af,W),m(W,lm),e(s,im,t),e(s,ca,t),e(s,pm,t),e(s,ua,t),e(s,mm,t),e(s,xn,t),m(xn,ms),m(ms,Vc),m(ms,kn),m(ms,qc),om.m(Ef,ms),m(ms,rm),e(s,hm,t),e(s,da,t),e(s,cm,t),e(s,ga,t),e(s,um,t),e(s,D,t),m(D,Ac),m(D,Tn),m(D,Ec),dm.m(Yf,D),m(D,gm),e(s,ym,t),e(s,ya,t),e(s,fm,t),e(s,fa,t),e(s,wm,t),e(s,wa,t),e(s,bm,t),y(ba,s,t),e(s,vm,t),e(s,va,t),e(s,Mm,t),y(Ma,s,t),e(s,xm,t),e(s,xa,t),e(s,km,t),y(ka,s,t),e(s,Tm,t),e(s,Ta,t),e(s,jm,t),y(ja,s,t),e(s,_m,t),e(s,_a,t),e(s,Jm,t),y(Ja,s,t),e(s,Um,t),e(s,Ua,t),e(s,Cm,t),e(s,Ca,t),e(s,zm,t),e(s,za,t),e(s,Lm,t),y(La,s,t),e(s,Gm,t),e(s,Ga,t),e(s,Bm,t),y(Ba,s,t),e(s,$m,t),e(s,$a,t),e(s,Zm,t),e(s,Za,t),e(s,Im,t),y(Ia,s,t),e(s,Wm,t),e(s,Wa,t),e(s,Qm,t),y(Qa,s,t),e(s,Hm,t),e(s,Ha,t),e(s,Xm,t),y(Xa,s,t),e(s,Nm,t),e(s,Na,t),e(s,Rm,t),y(Ra,s,t),e(s,Vm,t),e(s,Va,t),e(s,qm,t),e(s,qa,t),e(s,Am,t),y(Aa,s,t),e(s,Em,t),e(s,Ea,t),e(s,Ym,t),y(Ya,s,t),e(s,Sm,t),e(s,Sa,t),e(s,Fm,t),e(s,Fa,t),e(s,Pm,t),y(Pa,s,t),e(s,Km,t),e(s,Ka,t),e(s,Dm,t),y(Da,s,t),e(s,Om,t),e(s,Oa,t),e(s,so,t),e(s,se,t),e(s,to,t),e(s,te,t),e(s,ao,t),e(s,ae,t),e(s,eo,t),e(s,ee,t),e(s,no,t),e(s,ne,t),e(s,lo,t),e(s,le,t),e(s,io,t),e(s,ie,t),e(s,po,t),y(pe,s,t),e(s,mo,t),e(s,O,t),m(O,Yc),oo.m(Sf,O),m(O,ro),m(O,jn),m(O,Sc),e(s,ho,t),e(s,me,t),e(s,co,t),e(s,oe,t),e(s,uo,t),e(s,Z,t),m(Z,Fc),go.m(Ff,Z),m(Z,yo),fo.m(Pf,Z),m(Z,wo),m(Z,_n),m(Z,Pc),m(Z,Jn),m(Z,Kc),m(Z,Un),m(Z,Dc),e(s,bo,t),e(s,re,t),e(s,vo,t),e(s,C,t),m(C,Oc),m(C,cs),m(C,su),Mo.m(Kf,C),m(C,xo),ko.m(Df,C),m(C,To),jo.m(Of,C),m(C,_o),Jo.m(sw,C),m(C,Uo),Co.m(tw,C),m(C,zo),e(s,Lo,t),e(s,ss,t),m(ss,tu),m(ss,us),m(ss,au),Go.m(aw,ss),m(ss,Bo),e(s,$o,t),e(s,he,t),e(s,Zo,t),e(s,ds,t),m(ds,R),m(R,eu),m(R,Cn),m(R,nu),Io.m(ew,R),m(R,Wo),m(R,gs),m(R,lu),m(R,ys),m(R,iu),m(ds,pu),m(ds,ce),m(ce,mu),Qo.m(nw,ce),m(ce,Ho),e(s,Xo,t),e(s,ue,t),e(s,No,t),e(s,de,t),e(s,Ro,t),e(s,E,t),m(E,ou),m(E,zn),m(E,ru),m(E,Ln),m(E,hu),Vo.m(lw,E),m(E,qo),e(s,Ao,t),e(s,k,t),m(k,cu),m(k,Gn),m(k,uu),m(k,Bn),Eo.m(iw,k),m(k,Yo),So.m(pw,k),m(k,Fo),Po.m(mw,k),m(k,Ko),Do.m(ow,k),m(k,Oo),sr.m(rw,k),m(k,tr),ar.m(hw,k),m(k,er),nr.m(cw,k),m(k,lr),ir.m(uw,k),m(k,pr),m(k,$n),m(k,du),e(s,mr,t),e(s,Zn,t),m(Zn,$),m($,gu),or.m(dw,$),m($,rr),hr.m(gw,$),m($,cr),ur.m(yw,$),m($,dr),gr.m(fw,$),m($,yr),fr.m(ww,$),m($,wr),br.m(bw,$),m($,vr),e(s,Mr,t),e(s,ge,t),e(s,xr,t),e(s,ye,t),e(s,kr,t),e(s,Y,t),m(Y,yu),m(Y,In),m(Y,fu),m(Y,Wn),m(Y,wu),Tr.m(vw,Y),m(Y,jr),e(s,_r,t),e(s,fe,t),e(s,Jr,t),e(s,we,t),e(s,Ur,t),e(s,be,t),e(s,Cr,t),e(s,ve,t),e(s,zr,t),e(s,x,t),m(x,bu),m(x,Qn),m(x,vu),m(x,Hn),m(x,Mu),m(x,Xn),m(x,xu),m(x,Nn),m(x,ku),m(x,Rn),m(x,Tu),Lr.m(Mw,x),m(x,Gr),m(x,Vn),m(x,ju),m(x,fs),m(x,_u),Br.m(xw,x),m(x,$r),m(x,qn),m(x,Ju),m(x,ws),m(x,Uu),e(s,Zr,t),e(s,bs,t),m(bs,An),m(bs,Cu),m(bs,os),m(os,Me),m(Me,zu),Ir.m(kw,Me),m(Me,Wr),m(os,Lu),m(os,En),m(os,Gu),m(os,Yn),e(s,Qr,t),e(s,S,t),m(S,Bu),Hr.m(Tw,S),m(S,Xr),Nr.m(jw,S),m(S,Rr),Vr.m(_w,S),m(S,qr),e(s,Ar,t),y(xe,s,t),e(s,Er,t),e(s,ke,t),e(s,Yr,t),e(s,Te,t),e(s,Sr,t),e(s,je,t),e(s,Fr,t),y(_e,s,t),e(s,Pr,t),e(s,Je,t),e(s,Kr,t),y(Ue,s,t),e(s,Dr,t),e(s,Ce,t),e(s,Or,t),e(s,ze,t),e(s,sh,t),e(s,z,t),m(z,$u),m(z,Sn),m(z,Zu),th.m(Jw,z),m(z,ah),eh.m(Uw,z),m(z,nh),lh.m(Cw,z),m(z,ih),ph.m(zw,z),m(z,mh),oh.m(Lw,z),m(z,rh),e(s,hh,t),e(s,Le,t),e(s,ch,t),y(Ge,s,t),e(s,uh,t),e(s,Be,t),e(s,dh,t),y($e,s,t),e(s,gh,t),e(s,Ze,t),e(s,yh,t),e(s,Fn,t),m(Fn,V),m(V,Iu),fh.m(Gw,V),m(V,wh),bh.m(Bw,V),m(V,vh),Mh.m($w,V),m(V,xh),m(V,Pn),m(V,Wu),e(s,kh,t),e(s,Ie,t),e(s,Th,t),e(s,vs,t),m(vs,We),m(We,Qu),jh.m(Zw,We),m(We,_h),m(vs,Hu),m(vs,Kn),e(s,Jh,t),e(s,Qe,t),e(s,Uh,t),y(Ms,s,t),e(s,Ch,t),y(He,s,t),e(s,zh,t),e(s,Xe,t),e(s,Lh,t),y(Ne,s,t),e(s,Gh,t),e(s,Re,t),e(s,Bh,t),e(s,Ve,t),e(s,$h,t),e(s,qe,t),e(s,Zh,t),e(s,Ae,t),e(s,Ih,t),e(s,Ee,t),e(s,Wh,t),y(Ye,s,t),e(s,Qh,t),e(s,Se,t),e(s,Hh,t),y(Fe,s,t),e(s,Xh,t),e(s,ts,t),m(ts,Xu),Nh.m(Iw,ts),m(ts,Rh),Vh.m(Ww,ts),m(ts,qh),e(s,Ah,t),e(s,Pe,t),e(s,Eh,t),y(Ke,s,t),e(s,Yh,t),e(s,De,t),e(s,Sh,t),y(Oe,s,t),e(s,Fh,t),e(s,sn,t),e(s,Ph,t),y(tn,s,t),e(s,Kh,t),e(s,an,t),e(s,Dh,t),e(s,Dn,t),m(Dn,rs),m(rs,Nu),Oh.m(Qw,rs),m(rs,sc),m(rs,On),m(rs,Ru),e(s,tc,t),e(s,en,t),e(s,ac,t),e(s,as,t),m(as,Vu),ec.m(Hw,as),m(as,nc),m(as,xs),m(as,qu),e(s,lc,t),e(s,ks,t),m(ks,Au),ic.m(Xw,ks),m(ks,pc),e(s,mc,t),e(s,nn,t),e(s,oc,t),e(s,ln,t),e(s,rc,t),e(s,pn,t),e(s,hc,t),y(mn,s,t),e(s,cc,t),e(s,on,t),e(s,uc,t),e(s,rn,t),e(s,dc,t),e(s,hn,t),e(s,gc,t),e(s,cn,t),e(s,yc,t),y(un,s,t),e(s,fc,t),e(s,dn,t),e(s,wc,t),e(s,gn,t),e(s,bc,t),e(s,ol,t),vc=!0},p(s,[t]){const I={};t&2&&(I.$$scope={dirty:t,ctx:s}),Ms.$set(I)},i(s){vc||(f(zs.$$.fragment,s),f(Ls.$$.fragment,s),f(Qs.$$.fragment,s),f(Ks.$$.fragment,s),f(Ds.$$.fragment,s),f(et.$$.fragment,s),f(nt.$$.fragment,s),f(it.$$.fragment,s),f(mt.$$.fragment,s),f(rt.$$.fragment,s),f(ct.$$.fragment,s),f(ft.$$.fragment,s),f(bt.$$.fragment,s),f(Mt.$$.fragment,s),f(Ct.$$.fragment,s),f(Lt.$$.fragment,s),f(Bt.$$.fragment,s),f(Zt.$$.fragment,s),f(Wt.$$.fragment,s),f(Ht.$$.fragment,s),f(Rt.$$.fragment,s),f(Vt.$$.fragment,s),f(At.$$.fragment,s),f(Yt.$$.fragment,s),f(Ft.$$.fragment,s),f(Kt.$$.fragment,s),f(sa.$$.fragment,s),f(ta.$$.fragment,s),f(ma.$$.fragment,s),f(ba.$$.fragment,s),f(Ma.$$.fragment,s),f(ka.$$.fragment,s),f(ja.$$.fragment,s),f(Ja.$$.fragment,s),f(La.$$.fragment,s),f(Ba.$$.fragment,s),f(Ia.$$.fragment,s),f(Qa.$$.fragment,s),f(Xa.$$.fragment,s),f(Ra.$$.fragment,s),f(Aa.$$.fragment,s),f(Ya.$$.fragment,s),f(Pa.$$.fragment,s),f(Da.$$.fragment,s),f(pe.$$.fragment,s),f(xe.$$.fragment,s),f(_e.$$.fragment,s),f(Ue.$$.fragment,s),f(Ge.$$.fragment,s),f($e.$$.fragment,s),f(Ms.$$.fragment,s),f(He.$$.fragment,s),f(Ne.$$.fragment,s),f(Ye.$$.fragment,s),f(Fe.$$.fragment,s),f(Ke.$$.fragment,s),f(Oe.$$.fragment,s),f(tn.$$.fragment,s),f(mn.$$.fragment,s),f(un.$$.fragment,s),vc=!0)},o(s){w(zs.$$.fragment,s),w(Ls.$$.fragment,s),w(Qs.$$.fragment,s),w(Ks.$$.fragment,s),w(Ds.$$.fragment,s),w(et.$$.fragment,s),w(nt.$$.fragment,s),w(it.$$.fragment,s),w(mt.$$.fragment,s),w(rt.$$.fragment,s),w(ct.$$.fragment,s),w(ft.$$.fragment,s),w(bt.$$.fragment,s),w(Mt.$$.fragment,s),w(Ct.$$.fragment,s),w(Lt.$$.fragment,s),w(Bt.$$.fragment,s),w(Zt.$$.fragment,s),w(Wt.$$.fragment,s),w(Ht.$$.fragment,s),w(Rt.$$.fragment,s),w(Vt.$$.fragment,s),w(At.$$.fragment,s),w(Yt.$$.fragment,s),w(Ft.$$.fragment,s),w(Kt.$$.fragment,s),w(sa.$$.fragment,s),w(ta.$$.fragment,s),w(ma.$$.fragment,s),w(ba.$$.fragment,s),w(Ma.$$.fragment,s),w(ka.$$.fragment,s),w(ja.$$.fragment,s),w(Ja.$$.fragment,s),w(La.$$.fragment,s),w(Ba.$$.fragment,s),w(Ia.$$.fragment,s),w(Qa.$$.fragment,s),w(Xa.$$.fragment,s),w(Ra.$$.fragment,s),w(Aa.$$.fragment,s),w(Ya.$$.fragment,s),w(Pa.$$.fragment,s),w(Da.$$.fragment,s),w(pe.$$.fragment,s),w(xe.$$.fragment,s),w(_e.$$.fragment,s),w(Ue.$$.fragment,s),w(Ge.$$.fragment,s),w($e.$$.fragment,s),w(Ms.$$.fragment,s),w(He.$$.fragment,s),w(Ne.$$.fragment,s),w(Ye.$$.fragment,s),w(Fe.$$.fragment,s),w(Ke.$$.fragment,s),w(Oe.$$.fragment,s),w(tn.$$.fragment,s),w(mn.$$.fragment,s),w(un.$$.fragment,s),vc=!1},d(s){s&&(a(Cs),a(P),a(yn),a(cl),a(ul),a(Gs),a(dl),a(Bs),a(gl),a($s),a(yl),a(Zs),a(fl),a(Is),a(wl),a(Ws),a(bl),a(vl),a(Hs),a(Ml),a(Xs),a(xl),a(Ns),a(kl),a(Rs),a(Tl),a(Vs),a(jl),a(qs),a(_l),a(As),a(Jl),a(Es),a(Ul),a(Ys),a(Cl),a(Ss),a(zl),a(Fs),a(Ll),a(Ps),a(Gl),a(Bl),a($l),a(Os),a(Zl),a(st),a(Il),a(tt),a(Wl),a(at),a(Ql),a(Hl),a(Xl),a(lt),a(Nl),a(Rl),a(pt),a(Vl),a(ql),a(ot),a(Al),a(El),a(ht),a(Yl),a(Sl),a(ut),a(Fl),a(dt),a(Pl),a(gt),a(Kl),a(yt),a(Dl),a(Ol),a(wt),a(si),a(ti),a(vt),a(ai),a(ei),a(xt),a(ni),a(kt),a(li),a(Tt),a(ii),a(jt),a(pi),a(B),a(gi),a(_t),a(fi),a(Jt),a(wi),a(Ut),a(bi),a(vi),a(zt),a(Mi),a(xi),a(Gt),a(ki),a(Ti),a($t),a(ji),a(_i),a(It),a(Ji),a(Ui),a(Qt),a(Ci),a(zi),a(Xt),a(Li),a(Nt),a(Gi),a(Bi),a($i),a(qt),a(Zi),a(Ii),a(Et),a(Wi),a(Qi),a(St),a(Hi),a(Xi),a(Pt),a(Ni),a(Ri),a(Dt),a(Vi),a(Ot),a(qi),a(K),a(Fi),a(Pi),a(Ki),a(aa),a(Di),a(ea),a(Oi),a(na),a(sp),a(la),a(tp),a(ia),a(ap),a(pa),a(ep),a(np),a(oa),a(lp),a(q),a(mp),a(T),a(Cp),a(U),a(Rp),a(ra),a(Vp),a(ha),a(qp),a(A),a(Yp),a(ps),a(Kp),a(W),a(im),a(ca),a(pm),a(ua),a(mm),a(xn),a(hm),a(da),a(cm),a(ga),a(um),a(D),a(ym),a(ya),a(fm),a(fa),a(wm),a(wa),a(bm),a(vm),a(va),a(Mm),a(xm),a(xa),a(km),a(Tm),a(Ta),a(jm),a(_m),a(_a),a(Jm),a(Um),a(Ua),a(Cm),a(Ca),a(zm),a(za),a(Lm),a(Gm),a(Ga),a(Bm),a($m),a($a),a(Zm),a(Za),a(Im),a(Wm),a(Wa),a(Qm),a(Hm),a(Ha),a(Xm),a(Nm),a(Na),a(Rm),a(Vm),a(Va),a(qm),a(qa),a(Am),a(Em),a(Ea),a(Ym),a(Sm),a(Sa),a(Fm),a(Fa),a(Pm),a(Km),a(Ka),a(Dm),a(Om),a(Oa),a(so),a(se),a(to),a(te),a(ao),a(ae),a(eo),a(ee),a(no),a(ne),a(lo),a(le),a(io),a(ie),a(po),a(mo),a(O),a(ho),a(me),a(co),a(oe),a(uo),a(Z),a(bo),a(re),a(vo),a(C),a(Lo),a(ss),a($o),a(he),a(Zo),a(ds),a(Xo),a(ue),a(No),a(de),a(Ro),a(E),a(Ao),a(k),a(mr),a(Zn),a(Mr),a(ge),a(xr),a(ye),a(kr),a(Y),a(_r),a(fe),a(Jr),a(we),a(Ur),a(be),a(Cr),a(ve),a(zr),a(x),a(Zr),a(bs),a(Qr),a(S),a(Ar),a(Er),a(ke),a(Yr),a(Te),a(Sr),a(je),a(Fr),a(Pr),a(Je),a(Kr),a(Dr),a(Ce),a(Or),a(ze),a(sh),a(z),a(hh),a(Le),a(ch),a(uh),a(Be),a(dh),a(gh),a(Ze),a(yh),a(Fn),a(kh),a(Ie),a(Th),a(vs),a(Jh),a(Qe),a(Uh),a(Ch),a(zh),a(Xe),a(Lh),a(Gh),a(Re),a(Bh),a(Ve),a($h),a(qe),a(Zh),a(Ae),a(Ih),a(Ee),a(Wh),a(Qh),a(Se),a(Hh),a(Xh),a(ts),a(Ah),a(Pe),a(Eh),a(Yh),a(De),a(Sh),a(Fh),a(sn),a(Ph),a(Kh),a(an),a(Dh),a(Dn),a(tc),a(en),a(ac),a(as),a(lc),a(ks),a(mc),a(nn),a(oc),a(ln),a(rc),a(pn),a(hc),a(cc),a(on),a(uc),a(rn),a(dc),a(hn),a(gc),a(cn),a(yc),a(fc),a(dn),a(wc),a(gn),a(bc),a(ol)),a(G),b(zs,s),b(Ls,s),b(Qs,s),b(Ks,s),b(Ds,s),b(et,s),b(nt,s),b(it,s),b(mt,s),b(rt,s),b(ct,s),b(ft,s),b(bt,s),b(Mt,s),b(Ct,s),b(Lt,s),b(Bt,s),b(Zt,s),b(Wt,s),b(Ht,s),b(Rt,s),b(Vt,s),b(At,s),b(Yt,s),b(Ft,s),b(Kt,s),b(sa,s),b(ta,s),b(ma,s),b(ba,s),b(Ma,s),b(ka,s),b(ja,s),b(Ja,s),b(La,s),b(Ba,s),b(Ia,s),b(Qa,s),b(Xa,s),b(Ra,s),b(Aa,s),b(Ya,s),b(Pa,s),b(Da,s),b(pe,s),b(xe,s),b(_e,s),b(Ue,s),b(Ge,s),b($e,s),b(Ms,s),b(He,s),b(Ne,s),b(Ye,s),b(Fe,s),b(Ke,s),b(Oe,s),b(tn,s),b(mn,s),b(un,s)}}}const Kw='{"title":"Optimizing LLMs for Speed and Memory","local":"optimizing-llms-for-speed-and-memory","sections":[{"title":"1. Lower Precision","local":"1-lower-precision","sections":[],"depth":2},{"title":"2. Flash Attention","local":"2-flash-attention","sections":[],"depth":2},{"title":"3. Architectural Innovations","local":"3-architectural-innovations","sections":[{"title":"3.1 Improving positional embeddings of LLMs","local":"31-improving-positional-embeddings-of-llms","sections":[],"depth":3},{"title":"3.2 The key-value cache","local":"32-the-key-value-cache","sections":[{"title":"3.2.1 Multi-round conversation","local":"321-multi-round-conversation","sections":[],"depth":4},{"title":"3.2.2 Multi-Query-Attention (MQA)","local":"322-multi-query-attention-mqa","sections":[],"depth":4},{"title":"3.2.3 Grouped-Query-Attention (GQA)","local":"323-grouped-query-attention-gqa","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Dw(hl){return Rw(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lb extends qw{constructor(G){super(),Aw(this,G,Dw,Pw,Nw,{})}}export{lb as component};
