import{s as mN,o as cN,n as k}from"../chunks/scheduler.9bc65507.js";import{S as fN,i as gN,g as i,s as n,r as p,A as pN,h as l,f as d,c as a,j as C,u as h,x as f,k as w,y as r,a as F,v as u,d as _,t as b,w as v}from"../chunks/index.707bf1b6.js";import{T as V2}from"../chunks/Tip.c2ecdbf4.js";import{D as x}from"../chunks/Docstring.17db21ae.js";import{C as L}from"../chunks/CodeBlock.54a9f38d.js";import{E as $}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as B}from"../chunks/Heading.342b1fa6.js";function hN(y){let t,T=`If your <code>NewModelConfig</code> is a subclass of <a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, make sure its
<code>model_type</code> attribute is set to the same key you use when registering the config (here <code>&quot;new-model&quot;</code>).`,m,s,c=`Likewise, if your <code>NewModel</code> is a subclass of <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, make sure its
<code>config_class</code> attribute is set to the same class you use when registering the model (here
<code>NewModelConfig</code>).`;return{c(){t=i("p"),t.innerHTML=T,m=n(),s=i("p"),s.innerHTML=c},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-10ifymt"&&(t.innerHTML=T),m=a(e),s=l(e,"P",{"data-svelte-h":!0}),f(s)!=="svelte-w5y6tt"&&(s.innerHTML=c)},m(e,M){F(e,t,M),F(e,m,M),F(e,s,M)},p:k,d(e){e&&(d(t),d(m),d(s))}}}function uN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjAodXNlci11cGxvYWRlZCklMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJkYm1keiUyRmJlcnQtYmFzZS1nZXJtYW4tY2FzZWQlMjIpJTBBJTBBJTIzJTIwSWYlMjBjb25maWd1cmF0aW9uJTIwZmlsZSUyMGlzJTIwaW4lMjBhJTIwZGlyZWN0b3J5JTIwKGUuZy4lMkMlMjB3YXMlMjBzYXZlZCUyMHVzaW5nJTIwKnNhdmVfcHJldHJhaW5lZCgnLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRicpKikuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRlc3QlMkZiZXJ0X3NhdmVkX21vZGVsJTJGJTIyKSUwQSUwQSUyMyUyMExvYWQlMjBhJTIwc3BlY2lmaWMlMjBjb25maWd1cmF0aW9uJTIwZmlsZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRmJlcnRfc2F2ZWRfbW9kZWwlMkZteV9jb25maWd1cmF0aW9uLmpzb24lMjIpJTBBJTBBJTIzJTIwQ2hhbmdlJTIwc29tZSUyMGNvbmZpZyUyMGF0dHJpYnV0ZXMlMjB3aGVuJTIwbG9hZGluZyUyMGElMjBwcmV0cmFpbmVkJTIwY29uZmlnLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlJTJDJTIwZm9vJTNERmFsc2UpJTBBY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBY29uZmlnJTJDJTIwdW51c2VkX2t3YXJncyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlJTJDJTIwZm9vJTNERmFsc2UlMkMlMjByZXR1cm5fdW51c2VkX2t3YXJncyUzRFRydWUlMEEpJTBBY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBdW51c2VkX2t3YXJncw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co (user-uploaded) and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;dbmdz/bert-base-german-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If configuration file is in a directory (e.g., was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./test/bert_saved_model/&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load a specific configuration file.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./test/bert_saved_model/my_configuration.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Change some config attributes when loading a pretrained config.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>, foo=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>config, unused_kwargs = AutoConfig.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>, foo=<span class="hljs-literal">False</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>unused_kwargs
{<span class="hljs-string">&#x27;foo&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function _N(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBEb3dubG9hZCUyMHZvY2FidWxhcnklMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEElMEElMjMlMjBEb3dubG9hZCUyMHZvY2FidWxhcnklMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjAodXNlci11cGxvYWRlZCklMjBhbmQlMjBjYWNoZS4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkYm1keiUyRmJlcnQtYmFzZS1nZXJtYW4tY2FzZWQlMjIpJTBBJTBBJTIzJTIwSWYlMjB2b2NhYnVsYXJ5JTIwZmlsZXMlMjBhcmUlMjBpbiUyMGElMjBkaXJlY3RvcnklMjAoZS5nLiUyMHRva2VuaXplciUyMHdhcyUyMHNhdmVkJTIwdXNpbmclMjAqc2F2ZV9wcmV0cmFpbmVkKCcuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJykqKSUwQSUyMyUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGYmVydF9zYXZlZF9tb2RlbCUyRiUyMiklMEElMEElMjMlMjBEb3dubG9hZCUyMHZvY2FidWxhcnklMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBkZWZpbmUlMjBtb2RlbC1zcGVjaWZpYyUyMGFyZ3VtZW50cyUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnJvYmVydGEtYmFzZSUyMiUyQyUyMGFkZF9wcmVmaXhfc3BhY2UlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download vocabulary from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download vocabulary from huggingface.co (user-uploaded) and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;dbmdz/bert-base-german-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If vocabulary files are in a directory (e.g. tokenizer was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tokenizer = AutoTokenizer.from_pretrained(&quot;./test/bert_saved_model/&quot;)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download vocabulary from huggingface.co and define model-specific arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;roberta-base&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function bN(y){let t,T="Passing <code>token=True</code> is required when you want to use a private model.";return{c(){t=i("p"),t.innerHTML=T},l(m){t=l(m,"P",{"data-svelte-h":!0}),f(t)!=="svelte-15auxyb"&&(t.innerHTML=T)},m(m,s){F(m,t,s)},p:k,d(m){m&&d(t)}}}function vN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBmZWF0dXJlJTIwZXh0cmFjdG9yJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1iYXNlLTk2MGglMjIpJTBBJTBBJTIzJTIwSWYlMjBmZWF0dXJlJTIwZXh0cmFjdG9yJTIwZmlsZXMlMjBhcmUlMjBpbiUyMGElMjBkaXJlY3RvcnklMjAoZS5nLiUyMGZlYXR1cmUlMjBleHRyYWN0b3IlMjB3YXMlMjBzYXZlZCUyMHVzaW5nJTIwKnNhdmVfcHJldHJhaW5lZCgnLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRicpKiklMEElMjMlMjBmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download feature extractor from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If feature extractor files are in a directory (e.g. feature extractor was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># feature_extractor = AutoFeatureExtractor.from_pretrained(&quot;./test/saved_model/&quot;)</span>`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function MN(y){let t,T="Passing <code>token=True</code> is required when you want to use a private model.";return{c(){t=i("p"),t.innerHTML=T},l(m){t=l(m,"P",{"data-svelte-h":!0}),f(t)!=="svelte-15auxyb"&&(t.innerHTML=T)},m(m,s){F(m,t,s)},p:k,d(m){m&&d(t)}}}function FN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQSUyMyUyMERvd25sb2FkJTIwaW1hZ2UlMjBwcm9jZXNzb3IlMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrJTIyKSUwQSUwQSUyMyUyMElmJTIwaW1hZ2UlMjBwcm9jZXNzb3IlMjBmaWxlcyUyMGFyZSUyMGluJTIwYSUyMGRpcmVjdG9yeSUyMChlLmcuJTIwaW1hZ2UlMjBwcm9jZXNzb3IlMjB3YXMlMjBzYXZlZCUyMHVzaW5nJTIwKnNhdmVfcHJldHJhaW5lZCgnLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRicpKiklMEElMjMlMjBpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download image processor from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If image processor files are in a directory (e.g. image processor was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># image_processor = AutoImageProcessor.from_pretrained(&quot;./test/saved_model/&quot;)</span>`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function TN(y){let t,T="Passing <code>token=True</code> is required when you want to use a private model.";return{c(){t=i("p"),t.innerHTML=T},l(m){t=l(m,"P",{"data-svelte-h":!0}),f(t)!=="svelte-15auxyb"&&(t.innerHTML=T)},m(m,s){F(m,t,s)},p:k,d(m){m&&d(t)}}}function yN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEElMjMlMjBEb3dubG9hZCUyMHByb2Nlc3NvciUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS05NjBoJTIyKSUwQSUwQSUyMyUyMElmJTIwcHJvY2Vzc29yJTIwZmlsZXMlMjBhcmUlMjBpbiUyMGElMjBkaXJlY3RvcnklMjAoZS5nLiUyMHByb2Nlc3NvciUyMHdhcyUyMHNhdmVkJTIwdXNpbmclMjAqc2F2ZV9wcmV0cmFpbmVkKCcuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJykqKSUwQSUyMyUyMHByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download processor from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If processor files are in a directory (e.g. processor was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># processor = AutoProcessor.from_pretrained(&quot;./test/saved_model/&quot;)</span>`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function CN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function wN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function xN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function kN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function LN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbC5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function $N(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function BN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JQcmVUcmFpbmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function jN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JQcmVUcmFpbmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JQcmVUcmFpbmluZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JQcmVUcmFpbmluZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yUHJlVHJhaW5pbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function AN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclByZVRyYWluaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JQcmVUcmFpbmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function ZN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclByZVRyYWluaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yUHJlVHJhaW5pbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JQcmVUcmFpbmluZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function RN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUHJlVHJhaW5pbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yUHJlVHJhaW5pbmcuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function WN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUHJlVHJhaW5pbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JQcmVUcmFpbmluZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yUHJlVHJhaW5pbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function VN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function SN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function PN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function GN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function JN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function IN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function UN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function EN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yTWFza2VkTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function NN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function XN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTWFza2VkTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function qN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTWFza2VkTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yTWFza2VkTE0uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function QN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTWFza2VkTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yTWFza2VkTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function DN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJ0NS1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function YN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJ0NS1iYXNlJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LWJhc2UlMjIlMkMlMjBvdXRwdXRfYXR0ZW50aW9ucyUzRFRydWUpJTBBbW9kZWwuY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBJTIzJTIwTG9hZGluZyUyMGZyb20lMjBhJTIwVEYlMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBQeVRvcmNoJTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0Zl9tb2RlbCUyRnQ1X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZ0NV90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/t5_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/t5_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function HN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function zN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIydDUtYmFzZSUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LWJhc2UlMjIlMkMlMjBvdXRwdXRfYXR0ZW50aW9ucyUzRFRydWUpJTBBbW9kZWwuY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBJTIzJTIwTG9hZGluZyUyMGZyb20lMjBhJTIwUHlUb3JjaCUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFRlbnNvckZsb3clMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnB0X21vZGVsJTJGdDVfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGdDVfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/t5_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/t5_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function ON(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxMlNlcUxNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIydDUtYmFzZSUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function KN(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxMlNlcUxNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LWJhc2UlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LWJhc2UlMjIlMkMlMjBvdXRwdXRfYXR0ZW50aW9ucyUzRFRydWUpJTBBbW9kZWwuY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBJTIzJTIwTG9hZGluZyUyMGZyb20lMjBhJTIwUHlUb3JjaCUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFRlbnNvckZsb3clMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnB0X21vZGVsJTJGdDVfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZ0NV9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/t5_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/t5_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function e5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function o5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function r5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function t5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function n5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function a5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function s5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function i5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function l5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function d5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function m5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function c5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function f5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function g5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function p5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function h5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function u5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function _5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function b5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function v5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function M5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function F5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function T5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function y5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function C5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function w5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function x5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function k5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function L5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function $5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function B5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEZXB0aEVzdGltYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JEZXB0aEVzdGltYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function j5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEZXB0aEVzdGltYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yRGVwdGhFc3RpbWF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yRGVwdGhFc3RpbWF0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function A5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function Z5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function R5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function W5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function V5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function S5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function P5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaWRlb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVmlkZW9DbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVideoClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function G5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaWRlb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpZGVvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVmlkZW9DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVmlkZW9DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVideoClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function J5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function I5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function U5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmcuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function E5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function N5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JPYmplY3REZXRlY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JPYmplY3REZXRlY3Rpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function X5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JPYmplY3REZXRlY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function q5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlU2VnbWVudGF0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function Q5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function D5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function Y5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function H5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function z5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function O5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckluc3RhbmNlU2VnbWVudGF0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForInstanceSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function K5(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW5zdGFuY2VTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForInstanceSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function eX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JVbml2ZXJzYWxTZWdtZW50YXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JVbml2ZXJzYWxTZWdtZW50YXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForUniversalSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function oX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JVbml2ZXJzYWxTZWdtZW50YXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclVuaXZlcnNhbFNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForUniversalSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function rX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function tX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function nX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yWmVyb1Nob3RJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function aX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function sX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90T2JqZWN0RGV0ZWN0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function iX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function lX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function dX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function mX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function cX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function fX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0ZyYW1lQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JBdWRpb0ZyYW1lQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioFrameClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function gX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0ZyYW1lQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioFrameClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function pX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDVEMlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDVEMuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCTC

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function hX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDVEMlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNUQy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCTC

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function uX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function _X(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function bX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function vX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function MX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function FX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function TX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb1hWZWN0b3IlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JBdWRpb1hWZWN0b3IuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioXVector

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function yX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb1hWZWN0b3IlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvWFZlY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioXVector

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function CX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVGFibGVRdWVzdGlvbkFuc3dlcmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function wX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVGFibGVRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZ0YXBhc190Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRnRhcGFzX3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/tapas_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/tapas_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function xX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC13dHElMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function kX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC13dHElMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yVGFibGVRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRnRhcGFzX3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZ0YXBhc19weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/tapas_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/tapas_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function LX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyaW1waXJhJTJGbGF5b3V0bG0tZG9jdW1lbnQtcWElMjIlMkMlMjByZXZpc2lvbiUzRCUyMjUyZTAxYjMlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function $X(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmltcGlyYSUyRmxheW91dGxtLWRvY3VtZW50LXFhJTIyJTJDJTIwcmV2aXNpb24lM0QlMjI1MmUwMWIzJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGbGF5b3V0bG1fdGZfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZsYXlvdXRsbV90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/layoutlm_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/layoutlm_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function BX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yRG9jdW1lbnRRdWVzdGlvbkFuc3dlcmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function jX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZsYXlvdXRsbV9wdF9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yRG9jdW1lbnRRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGbGF5b3V0bG1fcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/layoutlm_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/layoutlm_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function AX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmRhbmRlbGluJTJGdmlsdC1iMzItZmluZXR1bmVkLXZxYSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpc3VhbFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVisualQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;dandelin/vilt-b32-finetuned-vqa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function ZX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZGFuZGVsaW4lMkZ2aWx0LWIzMi1maW5ldHVuZWQtdnFhJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZGFuZGVsaW4lMkZ2aWx0LWIzMi1maW5ldHVuZWQtdnFhJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZ2aWx0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVmlzdWFsUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRnZpbHRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVisualQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;dandelin/vilt-b32-finetuned-vqa&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;dandelin/vilt-b32-finetuned-vqa&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/vilt_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/vilt_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function RX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function WX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpc2lvbjJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function VX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclZpc2lvbjJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclZpc2lvbjJTZXEuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function SX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclZpc2lvbjJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclZpc2lvbjJTZXEuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function PX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVmlzaW9uMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function GX(y){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVmlzaW9uMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function JX(y){let t,T,m,s,c,e,M,IW=`In many cases, the architecture you want to use can be guessed from the name or the path of the pretrained model you
are supplying to the <code>from_pretrained()</code> method. AutoClasses are here to do this job for you so that you
automatically retrieve the relevant model given the name/path to the pretrained weights/config/vocabulary.`,kC,yd,UW=`Instantiating one of <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.AutoConfig">AutoConfig</a>, <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.AutoModel">AutoModel</a>, and
<a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a> will directly create a class of the relevant architecture. For instance`,LC,Cd,$C,wd,EW='will create a model that is an instance of <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertModel">BertModel</a>.',BC,xd,NW="There is one class of <code>AutoModel</code> for each task, and for each backend (PyTorch, TensorFlow, or Flax).",jC,kd,AC,Ld,XW=`Each of the auto classes has a method to be extended with your custom classes. For instance, if you have defined a
custom class of model <code>NewModel</code>, make sure you have a <code>NewModelConfig</code> then you can add those to the auto
classes like this:`,ZC,$d,RC,Bd,qW="You will then be able to use the auto classes like you would usually do!",WC,ys,VC,jd,SC,me,Ad,S2,ph,QW=`This is a generic configuration class that will be instantiated as one of the configuration classes of the library
when created with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.AutoConfig.from_pretrained">from_pretrained()</a> class method.`,P2,hh,DW="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",G2,Uo,Zd,J2,uh,YW="Instantiate one of the configuration classes of the library from a pretrained model configuration.",I2,_h,HW=`The configuration class to instantiate is selected based on the <code>model_type</code> property of the config object that
is loaded, or when it’s missing, by falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,U2,bh,zW='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> (ALBERT model)</li> <li><strong>align</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/align#transformers.AlignConfig">AlignConfig</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/altclip#transformers.AltCLIPConfig">AltCLIPConfig</a> (AltCLIP model)</li> <li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/audio-spectrogram-transformer#transformers.ASTConfig">ASTConfig</a> (Audio Spectrogram Transformer model)</li> <li><strong>autoformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/autoformer#transformers.AutoformerConfig">AutoformerConfig</a> (Autoformer model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bark#transformers.BarkConfig">BarkConfig</a> (Bark model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartConfig">BartConfig</a> (BART model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a> (BEiT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertConfig">BertConfig</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert-generation#transformers.BertGenerationConfig">BertGenerationConfig</a> (Bert Generation model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusConfig">BigBirdPegasusConfig</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/biogpt#transformers.BioGptConfig">BioGptConfig</a> (BioGpt model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bit#transformers.BitConfig">BitConfig</a> (BiT model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip#transformers.BlipConfig">BlipConfig</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip-2#transformers.Blip2Config">Blip2Config</a> (BLIP-2 model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> (BLOOM model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bridgetower#transformers.BridgeTowerConfig">BridgeTowerConfig</a> (BridgeTower model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bros#transformers.BrosConfig">BrosConfig</a> (BROS model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/canine#transformers.CanineConfig">CanineConfig</a> (CANINE model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/chinese_clip#transformers.ChineseCLIPConfig">ChineseCLIPConfig</a> (Chinese-CLIP model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clap#transformers.ClapConfig">ClapConfig</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> (CLIP model)</li> <li><strong>clip_vision_model</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPVisionConfig">CLIPVisionConfig</a> (CLIPVisionModel model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clvp#transformers.ClvpConfig">ClvpConfig</a> (CLVP model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/codegen#transformers.CodeGenConfig">CodeGenConfig</a> (CodeGen model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/conditional_detr#transformers.ConditionalDetrConfig">ConditionalDetrConfig</a> (Conditional DETR model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> (ConvBERT model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextConfig">ConvNextConfig</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnextv2#transformers.ConvNextV2Config">ConvNextV2Config</a> (ConvNeXTV2 model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/cpmant#transformers.CpmAntConfig">CpmAntConfig</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> (CTRL model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/cvt#transformers.CvtConfig">CvtConfig</a> (CvT model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecAudioConfig">Data2VecAudioConfig</a> (Data2VecAudio model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> (Data2VecText model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecVisionConfig">Data2VecVisionConfig</a> (Data2VecVision model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> (DeBERTa-v2 model)</li> <li><strong>decision_transformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/decision_transformer#transformers.DecisionTransformerConfig">DecisionTransformerConfig</a> (Decision Transformer model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deformable_detr#transformers.DeformableDetrConfig">DeformableDetrConfig</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a> (DeiT model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deta#transformers.DetaConfig">DetaConfig</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a> (DETR model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dinat#transformers.DinatConfig">DinatConfig</a> (DiNAT model)</li> <li><strong>dinov2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dinov2#transformers.Dinov2Config">Dinov2Config</a> (DINOv2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> (DistilBERT model)</li> <li><strong>donut-swin</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/donut#transformers.DonutSwinConfig">DonutSwinConfig</a> (DonutSwin model)</li> <li><strong>dpr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dpr#transformers.DPRConfig">DPRConfig</a> (DPR model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dpt#transformers.DPTConfig">DPTConfig</a> (DPT model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/efficientnet#transformers.EfficientNetConfig">EfficientNetConfig</a> (EfficientNet model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> (ELECTRA model)</li> <li><strong>encodec</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/encodec#transformers.EncodecConfig">EncodecConfig</a> (EnCodec model)</li> <li><strong>encoder-decoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/encoder-decoder#transformers.EncoderDecoderConfig">EncoderDecoderConfig</a> (Encoder decoder model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a> (ErnieM model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.EsmConfig">EsmConfig</a> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a> (Falcon model)</li> <li><strong>fastspeech2_conformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerConfig">FastSpeech2ConformerConfig</a> (FastSpeech2Conformer model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> (FlauBERT model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flava#transformers.FlavaConfig">FlavaConfig</a> (FLAVA model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetConfig">FNetConfig</a> (FNet model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/focalnet#transformers.FocalNetConfig">FocalNetConfig</a> (FocalNet model)</li> <li><strong>fsmt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fsmt#transformers.FSMTConfig">FSMTConfig</a> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> (Funnel Transformer model)</li> <li><strong>fuyu</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fuyu#transformers.FuyuConfig">FuyuConfig</a> (Fuyu model)</li> <li><strong>git</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/git#transformers.GitConfig">GitConfig</a> (GIT model)</li> <li><strong>glpn</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/glpn#transformers.GLPNConfig">GLPNConfig</a> (GLPN model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig">GPTBigCodeConfig</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.GPTNeoConfig">GPTNeoConfig</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox#transformers.GPTNeoXConfig">GPTNeoXConfig</a> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseConfig">GPTNeoXJapaneseConfig</a> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> (GPT-J model)</li> <li><strong>gptsan-japanese</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseConfig">GPTSanJapaneseConfig</a> (GPTSAN-japanese model)</li> <li><strong>graphormer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/graphormer#transformers.GraphormerConfig">GraphormerConfig</a> (Graphormer model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/groupvit#transformers.GroupViTConfig">GroupViTConfig</a> (GroupViT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/hubert#transformers.HubertConfig">HubertConfig</a> (Hubert model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ibert#transformers.IBertConfig">IBertConfig</a> (I-BERT model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/idefics#transformers.IdeficsConfig">IdeficsConfig</a> (IDEFICS model)</li> <li><strong>imagegpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/imagegpt#transformers.ImageGPTConfig">ImageGPTConfig</a> (ImageGPT model)</li> <li><strong>informer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/informer#transformers.InformerConfig">InformerConfig</a> (Informer model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/instructblip#transformers.InstructBlipConfig">InstructBlipConfig</a> (InstructBLIP model)</li> <li><strong>jukebox</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/jukebox#transformers.JukeboxConfig">JukeboxConfig</a> (Jukebox model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/kosmos-2#transformers.Kosmos2Config">Kosmos2Config</a> (KOSMOS-2 model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv2#transformers.LayoutLMv2Config">LayoutLMv2Config</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3Config">LayoutLMv3Config</a> (LayoutLMv3 model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/led#transformers.LEDConfig">LEDConfig</a> (LED model)</li> <li><strong>levit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/levit#transformers.LevitConfig">LevitConfig</a> (LeViT model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/lilt#transformers.LiltConfig">LiltConfig</a> (LiLT model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a> (LLaMA model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llava#transformers.LlavaConfig">LlavaConfig</a> (LLaVa model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> (Longformer model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longt5#transformers.LongT5Config">LongT5Config</a> (LongT5 model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/luke#transformers.LukeConfig">LukeConfig</a> (LUKE model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.LxmertConfig">LxmertConfig</a> (LXMERT model)</li> <li><strong>m2m_100</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/m2m_100#transformers.M2M100Config">M2M100Config</a> (M2M100 model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a> (Marian model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a> (MarkupLM model)</li> <li><strong>mask2former</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a> (Mask2Former model)</li> <li><strong>maskformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a> (MaskFormer model)</li> <li><strong>maskformer-swin</strong> — <code>MaskFormerSwinConfig</code> (MaskFormerSwin model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> (mBART model)</li> <li><strong>mctct</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mctct#transformers.MCTCTConfig">MCTCTConfig</a> (M-CTC-T model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertConfig">MegatronBertConfig</a> (Megatron-BERT model)</li> <li><strong>mgp-str</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mgp-str#transformers.MgpstrConfig">MgpstrConfig</a> (MGP-STR model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mistral#transformers.MistralConfig">MistralConfig</a> (Mistral model)</li> <li><strong>mixtral</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mixtral#transformers.MixtralConfig">MixtralConfig</a> (Mixtral model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> (MobileBERT model)</li> <li><strong>mobilenet_v1</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilenet_v1#transformers.MobileNetV1Config">MobileNetV1Config</a> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilenet_v2#transformers.MobileNetV2Config">MobileNetV2Config</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevit#transformers.MobileViTConfig">MobileViTConfig</a> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevitv2#transformers.MobileViTV2Config">MobileViTV2Config</a> (MobileViTV2 model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpt#transformers.MptConfig">MptConfig</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mra#transformers.MraConfig">MraConfig</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.MT5Config">MT5Config</a> (MT5 model)</li> <li><strong>musicgen</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a> (MusicGen model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpConfig">MvpConfig</a> (MVP model)</li> <li><strong>nat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nat#transformers.NatConfig">NatConfig</a> (NAT model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nezha#transformers.NezhaConfig">NezhaConfig</a> (Nezha model)</li> <li><strong>nllb-moe</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nllb-moe#transformers.NllbMoeConfig">NllbMoeConfig</a> (NLLB-MOE model)</li> <li><strong>nougat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vision-encoder-decoder#transformers.VisionEncoderDecoderConfig">VisionEncoderDecoderConfig</a> (Nougat model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nystromformer#transformers.NystromformerConfig">NystromformerConfig</a> (Nyströmformer model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a> (OneFormer model)</li> <li><strong>open-llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/open-llama#transformers.OpenLlamaConfig">OpenLlamaConfig</a> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> (OPT model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/owlv2#transformers.Owlv2Config">Owlv2Config</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/owlvit#transformers.OwlViTConfig">OwlViTConfig</a> (OWL-ViT model)</li> <li><strong>patchtsmixer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/patchtsmixer#transformers.PatchTSMixerConfig">PatchTSMixerConfig</a> (PatchTSMixer model)</li> <li><strong>patchtst</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a> (PatchTST model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusConfig">PegasusConfig</a> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus_x#transformers.PegasusXConfig">PegasusXConfig</a> (PEGASUS-X model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a> (Perceiver model)</li> <li><strong>persimmon</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/persimmon#transformers.PersimmonConfig">PersimmonConfig</a> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/phi#transformers.PhiConfig">PhiConfig</a> (Phi model)</li> <li><strong>pix2struct</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pix2struct#transformers.Pix2StructConfig">Pix2StructConfig</a> (Pix2Struct model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/plbart#transformers.PLBartConfig">PLBartConfig</a> (PLBart model)</li> <li><strong>poolformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/poolformer#transformers.PoolFormerConfig">PoolFormerConfig</a> (PoolFormer model)</li> <li><strong>pop2piano</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pop2piano#transformers.Pop2PianoConfig">Pop2PianoConfig</a> (Pop2Piano model)</li> <li><strong>prophetnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/prophetnet#transformers.ProphetNetConfig">ProphetNetConfig</a> (ProphetNet model)</li> <li><strong>pvt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pvt#transformers.PvtConfig">PvtConfig</a> (PVT model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/qdqbert#transformers.QDQBertConfig">QDQBertConfig</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/qwen2#transformers.Qwen2Config">Qwen2Config</a> (Qwen2 model)</li> <li><strong>rag</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rag#transformers.RagConfig">RagConfig</a> (RAG model)</li> <li><strong>realm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/realm#transformers.RealmConfig">RealmConfig</a> (REALM model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a> (Reformer model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a> (RegNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> (RemBERT model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a> (ResNet model)</li> <li><strong>retribert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/retribert#transformers.RetriBertConfig">RetriBertConfig</a> (RetriBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertConfig">RoCBertConfig</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> (RoFormer model)</li> <li><strong>rwkv</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rwkv#transformers.RwkvConfig">RwkvConfig</a> (RWKV model)</li> <li><strong>sam</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/sam#transformers.SamConfig">SamConfig</a> (SAM model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t#transformers.SeamlessM4TConfig">SeamlessM4TConfig</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Config">SeamlessM4Tv2Config</a> (SeamlessM4Tv2 model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/segformer#transformers.SegformerConfig">SegformerConfig</a> (SegFormer model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/sew#transformers.SEWConfig">SEWConfig</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/sew-d#transformers.SEWDConfig">SEWDConfig</a> (SEW-D model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/siglip#transformers.SiglipConfig">SiglipConfig</a> (SigLIP model)</li> <li><strong>siglip_vision_model</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/siglip#transformers.SiglipVisionConfig">SiglipVisionConfig</a> (SiglipVisionModel model)</li> <li><strong>speech-encoder-decoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderConfig">SpeechEncoderDecoderConfig</a> (Speech Encoder decoder model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text#transformers.Speech2TextConfig">Speech2TextConfig</a> (Speech2Text model)</li> <li><strong>speech_to_text_2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Config">Speech2Text2Config</a> (Speech2Text2 model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speecht5#transformers.SpeechT5Config">SpeechT5Config</a> (SpeechT5 model)</li> <li><strong>splinter</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a> (Splinter model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a> (SqueezeBERT model)</li> <li><strong>swiftformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swiftformer#transformers.SwiftFormerConfig">SwiftFormerConfig</a> (SwiftFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a> (Swin Transformer model)</li> <li><strong>swin2sr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swin2sr#transformers.Swin2SRConfig">Swin2SRConfig</a> (Swin2SR model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swinv2#transformers.Swinv2Config">Swinv2Config</a> (Swin Transformer V2 model)</li> <li><strong>switch_transformers</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a> (SwitchTransformers model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.T5Config">T5Config</a> (T5 model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/table-transformer#transformers.TableTransformerConfig">TableTransformerConfig</a> (Table Transformer model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> (TAPAS model)</li> <li><strong>time_series_transformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/time_series_transformer#transformers.TimeSeriesTransformerConfig">TimeSeriesTransformerConfig</a> (Time Series Transformer model)</li> <li><strong>timesformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/timesformer#transformers.TimesformerConfig">TimesformerConfig</a> (TimeSformer model)</li> <li><strong>timm_backbone</strong> — <code>TimmBackboneConfig</code> (TimmBackbone model)</li> <li><strong>trajectory_transformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/trajectory_transformer#transformers.TrajectoryTransformerConfig">TrajectoryTransformerConfig</a> (Trajectory Transformer model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> (Transformer-XL model)</li> <li><strong>trocr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/trocr#transformers.TrOCRConfig">TrOCRConfig</a> (TrOCR model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tvlt#transformers.TvltConfig">TvltConfig</a> (TVLT model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tvp#transformers.TvpConfig">TvpConfig</a> (TVP model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/umt5#transformers.UMT5Config">UMT5Config</a> (UMT5 model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech#transformers.UniSpeechConfig">UniSpeechConfig</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig">UniSpeechSatConfig</a> (UniSpeechSat model)</li> <li><strong>univnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/univnet#transformers.UnivNetConfig">UnivNetConfig</a> (UnivNet model)</li> <li><strong>upernet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/upernet#transformers.UperNetConfig">UperNetConfig</a> (UPerNet model)</li> <li><strong>van</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/van#transformers.VanConfig">VanConfig</a> (VAN model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/videomae#transformers.VideoMAEConfig">VideoMAEConfig</a> (VideoMAE model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vilt#transformers.ViltConfig">ViltConfig</a> (ViLT model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vipllava#transformers.VipLlavaConfig">VipLlavaConfig</a> (VipLlava model)</li> <li><strong>vision-encoder-decoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vision-encoder-decoder#transformers.VisionEncoderDecoderConfig">VisionEncoderDecoderConfig</a> (Vision Encoder decoder model)</li> <li><strong>vision-text-dual-encoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> (VisionTextDualEncoder model)</li> <li><strong>visual_bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/visual_bert#transformers.VisualBertConfig">VisualBertConfig</a> (VisualBERT model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a> (ViT model)</li> <li><strong>vit_hybrid</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit_hybrid#transformers.ViTHybridConfig">ViTHybridConfig</a> (ViT Hybrid model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit_mae#transformers.ViTMAEConfig">ViTMAEConfig</a> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit_msn#transformers.ViTMSNConfig">ViTMSNConfig</a> (ViTMSN model)</li> <li><strong>vitdet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vitdet#transformers.VitDetConfig">VitDetConfig</a> (VitDet model)</li> <li><strong>vitmatte</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vitmatte#transformers.VitMatteConfig">VitMatteConfig</a> (ViTMatte model)</li> <li><strong>vits</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vits#transformers.VitsConfig">VitsConfig</a> (VITS model)</li> <li><strong>vivit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vivit#transformers.VivitConfig">VivitConfig</a> (ViViT model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertConfig">Wav2Vec2BertConfig</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerConfig">Wav2Vec2ConformerConfig</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wavlm#transformers.WavLMConfig">WavLMConfig</a> (WavLM model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xclip#transformers.XCLIPConfig">XCLIPConfig</a> (X-CLIP model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetConfig">XLMProphetNetConfig</a> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLConfig">XLMRobertaXLConfig</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodConfig">XmodConfig</a> (X-MOD model)</li> <li><strong>yolos</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a> (YOLOS model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/yoso#transformers.YosoConfig">YosoConfig</a> (YOSO model)</li>',E2,Cs,N2,ws,Rd,X2,vh,OW="Register a new configuration for this class.",PC,Wd,GC,ce,Vd,q2,Mh,KW=`This is a generic tokenizer class that will be instantiated as one of the tokenizer classes of the library when
created with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.AutoTokenizer.from_pretrained">AutoTokenizer.from_pretrained()</a> class method.`,Q2,Fh,eV="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",D2,Eo,Sd,Y2,Th,oV="Instantiate one of the tokenizer classes of the library from a pretrained model vocabulary.",H2,yh,rV=`The tokenizer class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,z2,Ch,tV='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertTokenizer">AlbertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertTokenizerFast">AlbertTokenizerFast</a> (ALBERT model)</li> <li><strong>align</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (ALIGN model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Bark model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartTokenizer">BartTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartTokenizerFast">BartTokenizerFast</a> (BART model)</li> <li><strong>barthez</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/barthez#transformers.BarthezTokenizer">BarthezTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/barthez#transformers.BarthezTokenizerFast">BarthezTokenizerFast</a> (BARThez model)</li> <li><strong>bartpho</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bartpho#transformers.BartphoTokenizer">BartphoTokenizer</a> (BARTpho model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert-generation#transformers.BertGenerationTokenizer">BertGenerationTokenizer</a> (Bert Generation model)</li> <li><strong>bert-japanese</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert-japanese#transformers.BertJapaneseTokenizer">BertJapaneseTokenizer</a> (BertJapanese model)</li> <li><strong>bertweet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bertweet#transformers.BertweetTokenizer">BertweetTokenizer</a> (BERTweet model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdTokenizer">BigBirdTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdTokenizerFast">BigBirdTokenizerFast</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusTokenizer">PegasusTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusTokenizerFast">PegasusTokenizerFast</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/biogpt#transformers.BioGptTokenizer">BioGptTokenizer</a> (BioGpt model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.BlenderbotTokenizer">BlenderbotTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.BlenderbotTokenizerFast">BlenderbotTokenizerFast</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.BlenderbotSmallTokenizer">BlenderbotSmallTokenizer</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (BLIP-2 model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomTokenizerFast">BloomTokenizerFast</a> (BLOOM model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (BridgeTower model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (BROS model)</li> <li><strong>byt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/byt5#transformers.ByT5Tokenizer">ByT5Tokenizer</a> (ByT5 model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertTokenizer">CamembertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertTokenizerFast">CamembertTokenizerFast</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/canine#transformers.CanineTokenizer">CanineTokenizer</a> (CANINE model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Chinese-CLIP model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clvp#transformers.ClvpTokenizer">ClvpTokenizer</a> (CLVP model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/code_llama#transformers.CodeLlamaTokenizer">CodeLlamaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/code_llama#transformers.CodeLlamaTokenizerFast">CodeLlamaTokenizerFast</a> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/codegen#transformers.CodeGenTokenizer">CodeGenTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/codegen#transformers.CodeGenTokenizerFast">CodeGenTokenizerFast</a> (CodeGen model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.ConvBertTokenizer">ConvBertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.ConvBertTokenizerFast">ConvBertTokenizerFast</a> (ConvBERT model)</li> <li><strong>cpm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/cpm#transformers.CpmTokenizer">CpmTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/cpm#transformers.CpmTokenizerFast">CpmTokenizerFast</a> (CPM model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/cpmant#transformers.CpmAntTokenizer">CpmAntTokenizer</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.CTRLTokenizer">CTRLTokenizer</a> (CTRL model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a> (Data2VecAudio model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaTokenizer">DebertaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaTokenizerFast">DebertaTokenizerFast</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2Tokenizer">DebertaV2Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2TokenizerFast">DebertaV2TokenizerFast</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertTokenizer">DistilBertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertTokenizerFast">DistilBertTokenizerFast</a> (DistilBERT model)</li> <li><strong>dpr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dpr#transformers.DPRQuestionEncoderTokenizer">DPRQuestionEncoderTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/dpr#transformers.DPRQuestionEncoderTokenizerFast">DPRQuestionEncoderTokenizerFast</a> (DPR model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraTokenizer">ElectraTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraTokenizerFast">ElectraTokenizerFast</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a> (ErnieM model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.EsmTokenizer">EsmTokenizer</a> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/v4.37.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> (Falcon model)</li> <li><strong>fastspeech2_conformer</strong> —  (FastSpeech2Conformer model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertTokenizer">FlaubertTokenizer</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetTokenizer">FNetTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetTokenizerFast">FNetTokenizerFast</a> (FNet model)</li> <li><strong>fsmt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fsmt#transformers.FSMTTokenizer">FSMTTokenizer</a> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelTokenizer">FunnelTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelTokenizerFast">FunnelTokenizerFast</a> (Funnel Transformer model)</li> <li><strong>git</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (GIT model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt-sw3#transformers.GPTSw3Tokenizer">GPTSw3Tokenizer</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox#transformers.GPTNeoXTokenizerFast">GPTNeoXTokenizerFast</a> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseTokenizer">GPTNeoXJapaneseTokenizer</a> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (GPT-J model)</li> <li><strong>gptsan-japanese</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseTokenizer">GPTSanJapaneseTokenizer</a> (GPTSAN-japanese model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (GroupViT model)</li> <li><strong>herbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/herbert#transformers.HerbertTokenizer">HerbertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/herbert#transformers.HerbertTokenizerFast">HerbertTokenizerFast</a> (HerBERT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a> (Hubert model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (I-BERT model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (IDEFICS model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (InstructBLIP model)</li> <li><strong>jukebox</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/jukebox#transformers.JukeboxTokenizer">JukeboxTokenizer</a> (Jukebox model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer">XLMRobertaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a> (KOSMOS-2 model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMTokenizer">LayoutLMTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMTokenizerFast">LayoutLMTokenizerFast</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv2#transformers.LayoutLMv2Tokenizer">LayoutLMv2Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv2#transformers.LayoutLMv2TokenizerFast">LayoutLMv2TokenizerFast</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3Tokenizer">LayoutLMv3Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3TokenizerFast">LayoutLMv3TokenizerFast</a> (LayoutLMv3 model)</li> <li><strong>layoutxlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutxlm#transformers.LayoutXLMTokenizer">LayoutXLMTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/layoutxlm#transformers.LayoutXLMTokenizerFast">LayoutXLMTokenizerFast</a> (LayoutXLM model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/led#transformers.LEDTokenizer">LEDTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/led#transformers.LEDTokenizerFast">LEDTokenizerFast</a> (LED model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3Tokenizer">LayoutLMv3Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3TokenizerFast">LayoutLMv3TokenizerFast</a> (LiLT model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (LLaMA model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (LLaVa model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerTokenizer">LongformerTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerTokenizerFast">LongformerTokenizerFast</a> (Longformer model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (LongT5 model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/luke#transformers.LukeTokenizer">LukeTokenizer</a> (LUKE model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.LxmertTokenizer">LxmertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.LxmertTokenizerFast">LxmertTokenizerFast</a> (LXMERT model)</li> <li><strong>m2m_100</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/m2m_100#transformers.M2M100Tokenizer">M2M100Tokenizer</a> (M2M100 model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.MarianTokenizer">MarianTokenizer</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartTokenizer">MBartTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartTokenizerFast">MBartTokenizerFast</a> (mBART model)</li> <li><strong>mbart50</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBart50Tokenizer">MBart50Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBart50TokenizerFast">MBart50TokenizerFast</a> (mBART-50 model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Megatron-BERT model)</li> <li><strong>mgp-str</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mgp-str#transformers.MgpstrTokenizer">MgpstrTokenizer</a> (MGP-STR model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (Mistral model)</li> <li><strong>mixtral</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (Mixtral model)</li> <li><strong>mluke</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mluke#transformers.MLukeTokenizer">MLukeTokenizer</a> (mLUKE model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertTokenizer">MobileBertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertTokenizerFast">MobileBertTokenizerFast</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetTokenizer">MPNetTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetTokenizerFast">MPNetTokenizerFast</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox#transformers.GPTNeoXTokenizerFast">GPTNeoXTokenizerFast</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.T5Tokenizer">MT5Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.T5TokenizerFast">MT5TokenizerFast</a> (MT5 model)</li> <li><strong>musicgen</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (MusicGen model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpTokenizer">MvpTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpTokenizerFast">MvpTokenizerFast</a> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Nezha model)</li> <li><strong>nllb</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nllb#transformers.NllbTokenizer">NllbTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/nllb#transformers.NllbTokenizerFast">NllbTokenizerFast</a> (NLLB model)</li> <li><strong>nllb-moe</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nllb#transformers.NllbTokenizer">NllbTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/nllb#transformers.NllbTokenizerFast">NllbTokenizerFast</a> (NLLB-MOE model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertTokenizer">AlbertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertTokenizerFast">AlbertTokenizerFast</a> (Nyströmformer model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (OneFormer model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTTokenizer">OpenAIGPTTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTTokenizerFast">OpenAIGPTTokenizerFast</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (OPT model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (OWL-ViT model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusTokenizer">PegasusTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusTokenizerFast">PegasusTokenizerFast</a> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusTokenizer">PegasusTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusTokenizerFast">PegasusTokenizerFast</a> (PEGASUS-X model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/perceiver#transformers.PerceiverTokenizer">PerceiverTokenizer</a> (Perceiver model)</li> <li><strong>persimmon</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/codegen#transformers.CodeGenTokenizer">CodeGenTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/codegen#transformers.CodeGenTokenizerFast">CodeGenTokenizerFast</a> (Phi model)</li> <li><strong>phobert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/phobert#transformers.PhobertTokenizer">PhobertTokenizer</a> (PhoBERT model)</li> <li><strong>pix2struct</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (Pix2Struct model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/plbart#transformers.PLBartTokenizer">PLBartTokenizer</a> (PLBart model)</li> <li><strong>prophetnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/prophetnet#transformers.ProphetNetTokenizer">ProphetNetTokenizer</a> (ProphetNet model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/qwen2#transformers.Qwen2Tokenizer">Qwen2Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/qwen2#transformers.Qwen2TokenizerFast">Qwen2TokenizerFast</a> (Qwen2 model)</li> <li><strong>rag</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rag#transformers.RagTokenizer">RagTokenizer</a> (RAG model)</li> <li><strong>realm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/realm#transformers.RealmTokenizer">RealmTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/realm#transformers.RealmTokenizerFast">RealmTokenizerFast</a> (REALM model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/reformer#transformers.ReformerTokenizer">ReformerTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/reformer#transformers.ReformerTokenizerFast">ReformerTokenizerFast</a> (Reformer model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertTokenizer">RemBertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertTokenizerFast">RemBertTokenizerFast</a> (RemBERT model)</li> <li><strong>retribert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/retribert#transformers.RetriBertTokenizer">RetriBertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/retribert#transformers.RetriBertTokenizerFast">RetriBertTokenizerFast</a> (RetriBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertTokenizer">RoCBertTokenizer</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerTokenizer">RoFormerTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerTokenizerFast">RoFormerTokenizerFast</a> (RoFormer model)</li> <li><strong>rwkv</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox#transformers.GPTNeoXTokenizerFast">GPTNeoXTokenizerFast</a> (RWKV model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t#transformers.SeamlessM4TTokenizer">SeamlessM4TTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t#transformers.SeamlessM4TTokenizerFast">SeamlessM4TTokenizerFast</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t#transformers.SeamlessM4TTokenizer">SeamlessM4TTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t#transformers.SeamlessM4TTokenizerFast">SeamlessM4TTokenizerFast</a> (SeamlessM4Tv2 model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/siglip#transformers.SiglipTokenizer">SiglipTokenizer</a> (SigLIP model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text#transformers.Speech2TextTokenizer">Speech2TextTokenizer</a> (Speech2Text model)</li> <li><strong>speech_to_text_2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a> (Speech2Text2 model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speecht5#transformers.SpeechT5Tokenizer">SpeechT5Tokenizer</a> (SpeechT5 model)</li> <li><strong>splinter</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/splinter#transformers.SplinterTokenizer">SplinterTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/splinter#transformers.SplinterTokenizerFast">SplinterTokenizerFast</a> (Splinter model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertTokenizer">SqueezeBertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertTokenizerFast">SqueezeBertTokenizerFast</a> (SqueezeBERT model)</li> <li><strong>switch_transformers</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (SwitchTransformers model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (T5 model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> (TAPAS model)</li> <li><strong>tapex</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tapex#transformers.TapexTokenizer">TapexTokenizer</a> (TAPEX model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TransfoXLTokenizer">TransfoXLTokenizer</a> (Transformer-XL model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (TVP model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (UMT5 model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (ViLT model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (VipLlava model)</li> <li><strong>visual_bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (VisualBERT model)</li> <li><strong>vits</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vits#transformers.VitsTokenizer">VitsTokenizer</a> (VITS model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a> (Wav2Vec2-Conformer model)</li> <li><strong>wav2vec2_phoneme</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2_phoneme#transformers.Wav2Vec2PhonemeCTCTokenizer">Wav2Vec2PhonemeCTCTokenizer</a> (Wav2Vec2Phoneme model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperTokenizer">WhisperTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperTokenizerFast">WhisperTokenizerFast</a> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (X-CLIP model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.XGLMTokenizer">XGLMTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.XGLMTokenizerFast">XGLMTokenizerFast</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMTokenizer">XLMTokenizer</a> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetTokenizer">XLMProphetNetTokenizer</a> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer">XLMRobertaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer">XLMRobertaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetTokenizer">XLNetTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetTokenizerFast">XLNetTokenizerFast</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer">XLMRobertaTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertTokenizer">AlbertTokenizer</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertTokenizerFast">AlbertTokenizerFast</a> (YOSO model)</li>',O2,xs,K2,ks,Pd,e4,wh,nV="Register a new tokenizer in this mapping.",JC,Gd,IC,fe,Jd,o4,xh,aV=`This is a generic feature extractor class that will be instantiated as one of the feature extractor classes of the
library when created with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.AutoFeatureExtractor.from_pretrained">AutoFeatureExtractor.from_pretrained()</a> class method.`,r4,kh,sV="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",t4,j,Id,n4,Lh,iV="Instantiate one of the feature extractor classes of the library from a pretrained model vocabulary.",a4,$h,lV=`The feature extractor class to instantiate is selected based on the <code>model_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s
missing, by falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,s4,Bh,dV='<li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/audio-spectrogram-transformer#transformers.ASTFeatureExtractor">ASTFeatureExtractor</a> (Audio Spectrogram Transformer model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/beit#transformers.BeitFeatureExtractor">BeitFeatureExtractor</a> (BEiT model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/chinese_clip#transformers.ChineseCLIPFeatureExtractor">ChineseCLIPFeatureExtractor</a> (Chinese-CLIP model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clap#transformers.ClapFeatureExtractor">ClapFeatureExtractor</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPFeatureExtractor">CLIPFeatureExtractor</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clvp#transformers.ClvpFeatureExtractor">ClvpFeatureExtractor</a> (CLVP model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/conditional_detr#transformers.ConditionalDetrFeatureExtractor">ConditionalDetrFeatureExtractor</a> (Conditional DETR model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (ConvNeXT model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (CvT model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (Data2VecAudio model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/beit#transformers.BeitFeatureExtractor">BeitFeatureExtractor</a> (Data2VecVision model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deformable_detr#transformers.DeformableDetrFeatureExtractor">DeformableDetrFeatureExtractor</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deit#transformers.DeiTFeatureExtractor">DeiTFeatureExtractor</a> (DeiT model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/detr#transformers.DetrFeatureExtractor">DetrFeatureExtractor</a> (DETR model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (DiNAT model)</li> <li><strong>donut-swin</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/donut#transformers.DonutFeatureExtractor">DonutFeatureExtractor</a> (DonutSwin model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dpt#transformers.DPTFeatureExtractor">DPTFeatureExtractor</a> (DPT model)</li> <li><strong>encodec</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/encodec#transformers.EncodecFeatureExtractor">EncodecFeatureExtractor</a> (EnCodec model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flava#transformers.FlavaFeatureExtractor">FlavaFeatureExtractor</a> (FLAVA model)</li> <li><strong>glpn</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/glpn#transformers.GLPNFeatureExtractor">GLPNFeatureExtractor</a> (GLPN model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPFeatureExtractor">CLIPFeatureExtractor</a> (GroupViT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (Hubert model)</li> <li><strong>imagegpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor">ImageGPTFeatureExtractor</a> (ImageGPT model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv2#transformers.LayoutLMv2FeatureExtractor">LayoutLMv2FeatureExtractor</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3FeatureExtractor">LayoutLMv3FeatureExtractor</a> (LayoutLMv3 model)</li> <li><strong>levit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/levit#transformers.LevitFeatureExtractor">LevitFeatureExtractor</a> (LeViT model)</li> <li><strong>maskformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor">MaskFormerFeatureExtractor</a> (MaskFormer model)</li> <li><strong>mctct</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mctct#transformers.MCTCTFeatureExtractor">MCTCTFeatureExtractor</a> (M-CTC-T model)</li> <li><strong>mobilenet_v1</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilenet_v1#transformers.MobileNetV1FeatureExtractor">MobileNetV1FeatureExtractor</a> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilenet_v2#transformers.MobileNetV2FeatureExtractor">MobileNetV2FeatureExtractor</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor">MobileViTFeatureExtractor</a> (MobileViT model)</li> <li><strong>nat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (NAT model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/owlvit#transformers.OwlViTFeatureExtractor">OwlViTFeatureExtractor</a> (OWL-ViT model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/perceiver#transformers.PerceiverFeatureExtractor">PerceiverFeatureExtractor</a> (Perceiver model)</li> <li><strong>poolformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/poolformer#transformers.PoolFormerFeatureExtractor">PoolFormerFeatureExtractor</a> (PoolFormer model)</li> <li><strong>pop2piano</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pop2piano#transformers.Pop2PianoFeatureExtractor">Pop2PianoFeatureExtractor</a> (Pop2Piano model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (ResNet model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t#transformers.SeamlessM4TFeatureExtractor">SeamlessM4TFeatureExtractor</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t#transformers.SeamlessM4TFeatureExtractor">SeamlessM4TFeatureExtractor</a> (SeamlessM4Tv2 model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/segformer#transformers.SegformerFeatureExtractor">SegformerFeatureExtractor</a> (SegFormer model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (SEW-D model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text#transformers.Speech2TextFeatureExtractor">Speech2TextFeatureExtractor</a> (Speech2Text model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speecht5#transformers.SpeechT5FeatureExtractor">SpeechT5FeatureExtractor</a> (SpeechT5 model)</li> <li><strong>swiftformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (SwiftFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (Swin Transformer model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (Swin Transformer V2 model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/detr#transformers.DetrFeatureExtractor">DetrFeatureExtractor</a> (Table Transformer model)</li> <li><strong>timesformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/videomae#transformers.VideoMAEFeatureExtractor">VideoMAEFeatureExtractor</a> (TimeSformer model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tvlt#transformers.TvltFeatureExtractor">TvltFeatureExtractor</a> (TVLT model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (UniSpeechSat model)</li> <li><strong>univnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/univnet#transformers.UnivNetFeatureExtractor">UnivNetFeatureExtractor</a> (UnivNet model)</li> <li><strong>van</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (VAN model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/videomae#transformers.VideoMAEFeatureExtractor">VideoMAEFeatureExtractor</a> (VideoMAE model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vilt#transformers.ViltFeatureExtractor">ViltFeatureExtractor</a> (ViLT model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (ViT model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (ViTMSN model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (WavLM model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperFeatureExtractor">WhisperFeatureExtractor</a> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPFeatureExtractor">CLIPFeatureExtractor</a> (X-CLIP model)</li> <li><strong>yolos</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/yolos#transformers.YolosFeatureExtractor">YolosFeatureExtractor</a> (YOLOS model)</li>',i4,Ls,l4,$s,d4,Bs,Ud,m4,jh,mV="Register a new feature extractor for this class.",UC,Ed,EC,ge,Nd,c4,Ah,cV=`This is a generic image processor class that will be instantiated as one of the image processor classes of the
library when created with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.AutoImageProcessor.from_pretrained">AutoImageProcessor.from_pretrained()</a> class method.`,f4,Zh,fV="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",g4,A,Xd,p4,Rh,gV="Instantiate one of the image processor classes of the library from a pretrained model vocabulary.",h4,Wh,pV=`The image processor class to instantiate is selected based on the <code>model_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s
missing, by falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,u4,Vh,hV='<li><strong>align</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/efficientnet#transformers.EfficientNetImageProcessor">EfficientNetImageProcessor</a> (ALIGN model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> (BEiT model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bit#transformers.BitImageProcessor">BitImageProcessor</a> (BiT model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip#transformers.BlipImageProcessor">BlipImageProcessor</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip#transformers.BlipImageProcessor">BlipImageProcessor</a> (BLIP-2 model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bridgetower#transformers.BridgeTowerImageProcessor">BridgeTowerImageProcessor</a> (BridgeTower model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/chinese_clip#transformers.ChineseCLIPImageProcessor">ChineseCLIPImageProcessor</a> (Chinese-CLIP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (CLIPSeg model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/conditional_detr#transformers.ConditionalDetrImageProcessor">ConditionalDetrImageProcessor</a> (Conditional DETR model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (ConvNeXTV2 model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> (Data2VecVision model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deformable_detr#transformers.DeformableDetrImageProcessor">DeformableDetrImageProcessor</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deit#transformers.DeiTImageProcessor">DeiTImageProcessor</a> (DeiT model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deta#transformers.DetaImageProcessor">DetaImageProcessor</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a> (DETR model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (DiNAT model)</li> <li><strong>dinov2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bit#transformers.BitImageProcessor">BitImageProcessor</a> (DINOv2 model)</li> <li><strong>donut-swin</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/donut#transformers.DonutImageProcessor">DonutImageProcessor</a> (DonutSwin model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dpt#transformers.DPTImageProcessor">DPTImageProcessor</a> (DPT model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/efficientformer#transformers.EfficientFormerImageProcessor">EfficientFormerImageProcessor</a> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/efficientnet#transformers.EfficientNetImageProcessor">EfficientNetImageProcessor</a> (EfficientNet model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flava#transformers.FlavaImageProcessor">FlavaImageProcessor</a> (FLAVA model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bit#transformers.BitImageProcessor">BitImageProcessor</a> (FocalNet model)</li> <li><strong>fuyu</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fuyu#transformers.FuyuImageProcessor">FuyuImageProcessor</a> (Fuyu model)</li> <li><strong>git</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (GIT model)</li> <li><strong>glpn</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/glpn#transformers.GLPNImageProcessor">GLPNImageProcessor</a> (GLPN model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (GroupViT model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/idefics#transformers.IdeficsImageProcessor">IdeficsImageProcessor</a> (IDEFICS model)</li> <li><strong>imagegpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/imagegpt#transformers.ImageGPTImageProcessor">ImageGPTImageProcessor</a> (ImageGPT model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip#transformers.BlipImageProcessor">BlipImageProcessor</a> (InstructBLIP model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (KOSMOS-2 model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv2#transformers.LayoutLMv2ImageProcessor">LayoutLMv2ImageProcessor</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3ImageProcessor">LayoutLMv3ImageProcessor</a> (LayoutLMv3 model)</li> <li><strong>levit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/levit#transformers.LevitImageProcessor">LevitImageProcessor</a> (LeViT model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (LLaVa model)</li> <li><strong>mask2former</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor">Mask2FormerImageProcessor</a> (Mask2Former model)</li> <li><strong>maskformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/maskformer#transformers.MaskFormerImageProcessor">MaskFormerImageProcessor</a> (MaskFormer model)</li> <li><strong>mgp-str</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (MGP-STR model)</li> <li><strong>mobilenet_v1</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilenet_v1#transformers.MobileNetV1ImageProcessor">MobileNetV1ImageProcessor</a> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilenet_v2#transformers.MobileNetV2ImageProcessor">MobileNetV2ImageProcessor</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevit#transformers.MobileViTImageProcessor">MobileViTImageProcessor</a> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevit#transformers.MobileViTImageProcessor">MobileViTImageProcessor</a> (MobileViTV2 model)</li> <li><strong>nat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (NAT model)</li> <li><strong>nougat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nougat#transformers.NougatImageProcessor">NougatImageProcessor</a> (Nougat model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a> (OneFormer model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/owlvit#transformers.OwlViTImageProcessor">OwlViTImageProcessor</a> (OWL-ViT model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/perceiver#transformers.PerceiverImageProcessor">PerceiverImageProcessor</a> (Perceiver model)</li> <li><strong>pix2struct</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pix2struct#transformers.Pix2StructImageProcessor">Pix2StructImageProcessor</a> (Pix2Struct model)</li> <li><strong>poolformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/poolformer#transformers.PoolFormerImageProcessor">PoolFormerImageProcessor</a> (PoolFormer model)</li> <li><strong>pvt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pvt#transformers.PvtImageProcessor">PvtImageProcessor</a> (PVT model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (ResNet model)</li> <li><strong>sam</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/sam#transformers.SamImageProcessor">SamImageProcessor</a> (SAM model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/segformer#transformers.SegformerImageProcessor">SegformerImageProcessor</a> (SegFormer model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a> (SigLIP model)</li> <li><strong>swiftformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (SwiftFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (Swin Transformer model)</li> <li><strong>swin2sr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swin2sr#transformers.Swin2SRImageProcessor">Swin2SRImageProcessor</a> (Swin2SR model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (Swin Transformer V2 model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a> (Table Transformer model)</li> <li><strong>timesformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/videomae#transformers.VideoMAEImageProcessor">VideoMAEImageProcessor</a> (TimeSformer model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tvlt#transformers.TvltImageProcessor">TvltImageProcessor</a> (TVLT model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tvp#transformers.TvpImageProcessor">TvpImageProcessor</a> (TVP model)</li> <li><strong>upernet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/segformer#transformers.SegformerImageProcessor">SegformerImageProcessor</a> (UPerNet model)</li> <li><strong>van</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (VAN model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/videomae#transformers.VideoMAEImageProcessor">VideoMAEImageProcessor</a> (VideoMAE model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vilt#transformers.ViltImageProcessor">ViltImageProcessor</a> (ViLT model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (VipLlava model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (ViT model)</li> <li><strong>vit_hybrid</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit_hybrid#transformers.ViTHybridImageProcessor">ViTHybridImageProcessor</a> (ViT Hybrid model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (ViTMSN model)</li> <li><strong>vitmatte</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vitmatte#transformers.VitMatteImageProcessor">VitMatteImageProcessor</a> (ViTMatte model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (X-CLIP model)</li> <li><strong>yolos</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/yolos#transformers.YolosImageProcessor">YolosImageProcessor</a> (YOLOS model)</li>',_4,js,b4,As,v4,Zs,qd,M4,Sh,uV="Register a new image processor for this class.",NC,Qd,XC,pe,Dd,F4,Ph,_V=`This is a generic processor class that will be instantiated as one of the processor classes of the library when
created with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.AutoProcessor.from_pretrained">AutoProcessor.from_pretrained()</a> class method.`,T4,Gh,bV="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",y4,Z,Yd,C4,Jh,vV="Instantiate one of the processor classes of the library from a pretrained model vocabulary.",w4,Ih,MV=`The processor class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible):`,x4,Uh,FV='<li><strong>align</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/align#transformers.AlignProcessor">AlignProcessor</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/altclip#transformers.AltCLIPProcessor">AltCLIPProcessor</a> (AltCLIP model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bark#transformers.BarkProcessor">BarkProcessor</a> (Bark model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip#transformers.BlipProcessor">BlipProcessor</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip-2#transformers.Blip2Processor">Blip2Processor</a> (BLIP-2 model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bridgetower#transformers.BridgeTowerProcessor">BridgeTowerProcessor</a> (BridgeTower model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/chinese_clip#transformers.ChineseCLIPProcessor">ChineseCLIPProcessor</a> (Chinese-CLIP model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clap#transformers.ClapProcessor">ClapProcessor</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPProcessor">CLIPProcessor</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clipseg#transformers.CLIPSegProcessor">CLIPSegProcessor</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clvp#transformers.ClvpProcessor">ClvpProcessor</a> (CLVP model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flava#transformers.FlavaProcessor">FlavaProcessor</a> (FLAVA model)</li> <li><strong>fuyu</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fuyu#transformers.FuyuProcessor">FuyuProcessor</a> (Fuyu model)</li> <li><strong>git</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/git#transformers.GitProcessor">GitProcessor</a> (GIT model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPProcessor">CLIPProcessor</a> (GroupViT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (Hubert model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/idefics#transformers.IdeficsProcessor">IdeficsProcessor</a> (IDEFICS model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/instructblip#transformers.InstructBlipProcessor">InstructBlipProcessor</a> (InstructBLIP model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/kosmos-2#transformers.Kosmos2Processor">Kosmos2Processor</a> (KOSMOS-2 model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv2#transformers.LayoutLMv2Processor">LayoutLMv2Processor</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3Processor">LayoutLMv3Processor</a> (LayoutLMv3 model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> (LLaVa model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/markuplm#transformers.MarkupLMProcessor">MarkupLMProcessor</a> (MarkupLM model)</li> <li><strong>mctct</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mctct#transformers.MCTCTProcessor">MCTCTProcessor</a> (M-CTC-T model)</li> <li><strong>mgp-str</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mgp-str#transformers.MgpstrProcessor">MgpstrProcessor</a> (MGP-STR model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a> (OneFormer model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/owlv2#transformers.Owlv2Processor">Owlv2Processor</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/owlvit#transformers.OwlViTProcessor">OwlViTProcessor</a> (OWL-ViT model)</li> <li><strong>pix2struct</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pix2struct#transformers.Pix2StructProcessor">Pix2StructProcessor</a> (Pix2Struct model)</li> <li><strong>pop2piano</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pop2piano#transformers.Pop2PianoProcessor">Pop2PianoProcessor</a> (Pop2Piano model)</li> <li><strong>sam</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/sam#transformers.SamProcessor">SamProcessor</a> (SAM model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t#transformers.SeamlessM4TProcessor">SeamlessM4TProcessor</a> (SeamlessM4T model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (SEW-D model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/siglip#transformers.SiglipProcessor">SiglipProcessor</a> (SigLIP model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text#transformers.Speech2TextProcessor">Speech2TextProcessor</a> (Speech2Text model)</li> <li><strong>speech_to_text_2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor">Speech2Text2Processor</a> (Speech2Text2 model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speecht5#transformers.SpeechT5Processor">SpeechT5Processor</a> (SpeechT5 model)</li> <li><strong>trocr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/trocr#transformers.TrOCRProcessor">TrOCRProcessor</a> (TrOCR model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a> (TVLT model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tvp#transformers.TvpProcessor">TvpProcessor</a> (TVP model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (UniSpeechSat model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vilt#transformers.ViltProcessor">ViltProcessor</a> (ViLT model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> (VipLlava model)</li> <li><strong>vision-text-dual-encoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderProcessor">VisionTextDualEncoderProcessor</a> (VisionTextDualEncoder model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (WavLM model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperProcessor">WhisperProcessor</a> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xclip#transformers.XCLIPProcessor">XCLIPProcessor</a> (X-CLIP model)</li>',k4,Rs,L4,Ws,$4,Vs,Hd,B4,Eh,TV="Register a new processor for this class.",qC,zd,QC,Od,yV="The following auto classes are available for instantiating a base model class without a specific head.",DC,Kd,YC,he,em,j4,Nh,CV=`This is a generic model class that will be instantiated as one of the base model classes of the library when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,A4,Xh,wV="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Z4,Vt,om,R4,qh,xV="Instantiates one of the base model classes of the library from a configuration.",W4,Qh,kV=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,V4,Ss,S4,R,rm,P4,Dh,LV="Instantiate one of the base model classes of the library from a pretrained model.",G4,Yh,$V=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,J4,Hh,BV='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertModel">AlbertModel</a> (ALBERT model)</li> <li><strong>align</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/align#transformers.AlignModel">AlignModel</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> (AltCLIP model)</li> <li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/audio-spectrogram-transformer#transformers.ASTModel">ASTModel</a> (Audio Spectrogram Transformer model)</li> <li><strong>autoformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/autoformer#transformers.AutoformerModel">AutoformerModel</a> (Autoformer model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bark#transformers.BarkModel">BarkModel</a> (Bark model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartModel">BartModel</a> (BART model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/beit#transformers.BeitModel">BeitModel</a> (BEiT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertModel">BertModel</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert-generation#transformers.BertGenerationEncoder">BertGenerationEncoder</a> (Bert Generation model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdModel">BigBirdModel</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusModel">BigBirdPegasusModel</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/biogpt#transformers.BioGptModel">BioGptModel</a> (BioGpt model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bit#transformers.BitModel">BitModel</a> (BiT model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.BlenderbotModel">BlenderbotModel</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.BlenderbotSmallModel">BlenderbotSmallModel</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip#transformers.BlipModel">BlipModel</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip-2#transformers.Blip2Model">Blip2Model</a> (BLIP-2 model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomModel">BloomModel</a> (BLOOM model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bridgetower#transformers.BridgeTowerModel">BridgeTowerModel</a> (BridgeTower model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bros#transformers.BrosModel">BrosModel</a> (BROS model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertModel">CamembertModel</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/canine#transformers.CanineModel">CanineModel</a> (CANINE model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/chinese_clip#transformers.ChineseCLIPModel">ChineseCLIPModel</a> (Chinese-CLIP model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clap#transformers.ClapModel">ClapModel</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPModel">CLIPModel</a> (CLIP model)</li> <li><strong>clip_vision_model</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPVisionModel">CLIPVisionModel</a> (CLIPVisionModel model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clvp#transformers.ClvpModelForConditionalGeneration">ClvpModelForConditionalGeneration</a> (CLVP model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaModel">LlamaModel</a> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/codegen#transformers.CodeGenModel">CodeGenModel</a> (CodeGen model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/conditional_detr#transformers.ConditionalDetrModel">ConditionalDetrModel</a> (Conditional DETR model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.ConvBertModel">ConvBertModel</a> (ConvBERT model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextModel">ConvNextModel</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnextv2#transformers.ConvNextV2Model">ConvNextV2Model</a> (ConvNeXTV2 model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/cpmant#transformers.CpmAntModel">CpmAntModel</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.CTRLModel">CTRLModel</a> (CTRL model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/cvt#transformers.CvtModel">CvtModel</a> (CvT model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecAudioModel">Data2VecAudioModel</a> (Data2VecAudio model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextModel">Data2VecTextModel</a> (Data2VecText model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecVisionModel">Data2VecVisionModel</a> (Data2VecVision model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaModel">DebertaModel</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2Model">DebertaV2Model</a> (DeBERTa-v2 model)</li> <li><strong>decision_transformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/decision_transformer#transformers.DecisionTransformerModel">DecisionTransformerModel</a> (Decision Transformer model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deformable_detr#transformers.DeformableDetrModel">DeformableDetrModel</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deit#transformers.DeiTModel">DeiTModel</a> (DeiT model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deta#transformers.DetaModel">DetaModel</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/detr#transformers.DetrModel">DetrModel</a> (DETR model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dinat#transformers.DinatModel">DinatModel</a> (DiNAT model)</li> <li><strong>dinov2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dinov2#transformers.Dinov2Model">Dinov2Model</a> (DINOv2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertModel">DistilBertModel</a> (DistilBERT model)</li> <li><strong>donut-swin</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/donut#transformers.DonutSwinModel">DonutSwinModel</a> (DonutSwin model)</li> <li><strong>dpr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dpr#transformers.DPRQuestionEncoder">DPRQuestionEncoder</a> (DPR model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dpt#transformers.DPTModel">DPTModel</a> (DPT model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/efficientformer#transformers.EfficientFormerModel">EfficientFormerModel</a> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/efficientnet#transformers.EfficientNetModel">EfficientNetModel</a> (EfficientNet model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraModel">ElectraModel</a> (ELECTRA model)</li> <li><strong>encodec</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a> (EnCodec model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieModel">ErnieModel</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a> (ErnieM model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.EsmModel">EsmModel</a> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/falcon#transformers.FalconModel">FalconModel</a> (Falcon model)</li> <li><strong>fastspeech2_conformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerModel">FastSpeech2ConformerModel</a> (FastSpeech2Conformer model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertModel">FlaubertModel</a> (FlauBERT model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flava#transformers.FlavaModel">FlavaModel</a> (FLAVA model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetModel">FNetModel</a> (FNet model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/focalnet#transformers.FocalNetModel">FocalNetModel</a> (FocalNet model)</li> <li><strong>fsmt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fsmt#transformers.FSMTModel">FSMTModel</a> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelModel">FunnelModel</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelBaseModel">FunnelBaseModel</a> (Funnel Transformer model)</li> <li><strong>git</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/git#transformers.GitModel">GitModel</a> (GIT model)</li> <li><strong>glpn</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a> (GLPN model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Model">GPT2Model</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Model">GPT2Model</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_bigcode#transformers.GPTBigCodeModel">GPTBigCodeModel</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.GPTNeoModel">GPTNeoModel</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox#transformers.GPTNeoXModel">GPTNeoXModel</a> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseModel">GPTNeoXJapaneseModel</a> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.GPTJModel">GPTJModel</a> (GPT-J model)</li> <li><strong>gptsan-japanese</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> (GPTSAN-japanese model)</li> <li><strong>graphormer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/graphormer#transformers.GraphormerModel">GraphormerModel</a> (Graphormer model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/groupvit#transformers.GroupViTModel">GroupViTModel</a> (GroupViT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/hubert#transformers.HubertModel">HubertModel</a> (Hubert model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ibert#transformers.IBertModel">IBertModel</a> (I-BERT model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a> (IDEFICS model)</li> <li><strong>imagegpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/imagegpt#transformers.ImageGPTModel">ImageGPTModel</a> (ImageGPT model)</li> <li><strong>informer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/informer#transformers.InformerModel">InformerModel</a> (Informer model)</li> <li><strong>jukebox</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/jukebox#transformers.JukeboxModel">JukeboxModel</a> (Jukebox model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/kosmos-2#transformers.Kosmos2Model">Kosmos2Model</a> (KOSMOS-2 model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMModel">LayoutLMModel</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv2#transformers.LayoutLMv2Model">LayoutLMv2Model</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3Model">LayoutLMv3Model</a> (LayoutLMv3 model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/led#transformers.LEDModel">LEDModel</a> (LED model)</li> <li><strong>levit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/levit#transformers.LevitModel">LevitModel</a> (LeViT model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/lilt#transformers.LiltModel">LiltModel</a> (LiLT model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaModel">LlamaModel</a> (LLaMA model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerModel">LongformerModel</a> (Longformer model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longt5#transformers.LongT5Model">LongT5Model</a> (LongT5 model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/luke#transformers.LukeModel">LukeModel</a> (LUKE model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.LxmertModel">LxmertModel</a> (LXMERT model)</li> <li><strong>m2m_100</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/m2m_100#transformers.M2M100Model">M2M100Model</a> (M2M100 model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.MarianModel">MarianModel</a> (Marian model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a> (MarkupLM model)</li> <li><strong>mask2former</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a> (Mask2Former model)</li> <li><strong>maskformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a> (MaskFormer model)</li> <li><strong>maskformer-swin</strong> — <code>MaskFormerSwinModel</code> (MaskFormerSwin model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartModel">MBartModel</a> (mBART model)</li> <li><strong>mctct</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mctct#transformers.MCTCTModel">MCTCTModel</a> (M-CTC-T model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaModel">MegaModel</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertModel">MegatronBertModel</a> (Megatron-BERT model)</li> <li><strong>mgp-str</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mgp-str#transformers.MgpstrForSceneTextRecognition">MgpstrForSceneTextRecognition</a> (MGP-STR model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mistral#transformers.MistralModel">MistralModel</a> (Mistral model)</li> <li><strong>mixtral</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mixtral#transformers.MixtralModel">MixtralModel</a> (Mixtral model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertModel">MobileBertModel</a> (MobileBERT model)</li> <li><strong>mobilenet_v1</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilenet_v1#transformers.MobileNetV1Model">MobileNetV1Model</a> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilenet_v2#transformers.MobileNetV2Model">MobileNetV2Model</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevit#transformers.MobileViTModel">MobileViTModel</a> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevitv2#transformers.MobileViTV2Model">MobileViTV2Model</a> (MobileViTV2 model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetModel">MPNetModel</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpt#transformers.MptModel">MptModel</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mra#transformers.MraModel">MraModel</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.MT5Model">MT5Model</a> (MT5 model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpModel">MvpModel</a> (MVP model)</li> <li><strong>nat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nat#transformers.NatModel">NatModel</a> (NAT model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nezha#transformers.NezhaModel">NezhaModel</a> (Nezha model)</li> <li><strong>nllb-moe</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nllb-moe#transformers.NllbMoeModel">NllbMoeModel</a> (NLLB-MOE model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nystromformer#transformers.NystromformerModel">NystromformerModel</a> (Nyströmformer model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a> (OneFormer model)</li> <li><strong>open-llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/open-llama#transformers.OpenLlamaModel">OpenLlamaModel</a> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTModel">OpenAIGPTModel</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.OPTModel">OPTModel</a> (OPT model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/owlvit#transformers.OwlViTModel">OwlViTModel</a> (OWL-ViT model)</li> <li><strong>patchtsmixer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/patchtsmixer#transformers.PatchTSMixerModel">PatchTSMixerModel</a> (PatchTSMixer model)</li> <li><strong>patchtst</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/patchtst#transformers.PatchTSTModel">PatchTSTModel</a> (PatchTST model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusModel">PegasusModel</a> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus_x#transformers.PegasusXModel">PegasusXModel</a> (PEGASUS-X model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> (Perceiver model)</li> <li><strong>persimmon</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/persimmon#transformers.PersimmonModel">PersimmonModel</a> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/phi#transformers.PhiModel">PhiModel</a> (Phi model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/plbart#transformers.PLBartModel">PLBartModel</a> (PLBart model)</li> <li><strong>poolformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/poolformer#transformers.PoolFormerModel">PoolFormerModel</a> (PoolFormer model)</li> <li><strong>prophetnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/prophetnet#transformers.ProphetNetModel">ProphetNetModel</a> (ProphetNet model)</li> <li><strong>pvt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pvt#transformers.PvtModel">PvtModel</a> (PVT model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/qdqbert#transformers.QDQBertModel">QDQBertModel</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/qwen2#transformers.Qwen2Model">Qwen2Model</a> (Qwen2 model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/reformer#transformers.ReformerModel">ReformerModel</a> (Reformer model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/regnet#transformers.RegNetModel">RegNetModel</a> (RegNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertModel">RemBertModel</a> (RemBERT model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/resnet#transformers.ResNetModel">ResNetModel</a> (ResNet model)</li> <li><strong>retribert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/retribert#transformers.RetriBertModel">RetriBertModel</a> (RetriBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaModel">RobertaModel</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormModel">RobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertModel">RoCBertModel</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerModel">RoFormerModel</a> (RoFormer model)</li> <li><strong>rwkv</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rwkv#transformers.RwkvModel">RwkvModel</a> (RWKV model)</li> <li><strong>sam</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/sam#transformers.SamModel">SamModel</a> (SAM model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t#transformers.SeamlessM4TModel">SeamlessM4TModel</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">SeamlessM4Tv2Model</a> (SeamlessM4Tv2 model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/segformer#transformers.SegformerModel">SegformerModel</a> (SegFormer model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/sew#transformers.SEWModel">SEWModel</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/sew-d#transformers.SEWDModel">SEWDModel</a> (SEW-D model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/siglip#transformers.SiglipModel">SiglipModel</a> (SigLIP model)</li> <li><strong>siglip_vision_model</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/siglip#transformers.SiglipVisionModel">SiglipVisionModel</a> (SiglipVisionModel model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text#transformers.Speech2TextModel">Speech2TextModel</a> (Speech2Text model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speecht5#transformers.SpeechT5Model">SpeechT5Model</a> (SpeechT5 model)</li> <li><strong>splinter</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a> (Splinter model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertModel">SqueezeBertModel</a> (SqueezeBERT model)</li> <li><strong>swiftformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swiftformer#transformers.SwiftFormerModel">SwiftFormerModel</a> (SwiftFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swin#transformers.SwinModel">SwinModel</a> (Swin Transformer model)</li> <li><strong>swin2sr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swin2sr#transformers.Swin2SRModel">Swin2SRModel</a> (Swin2SR model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swinv2#transformers.Swinv2Model">Swinv2Model</a> (Swin Transformer V2 model)</li> <li><strong>switch_transformers</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/switch_transformers#transformers.SwitchTransformersModel">SwitchTransformersModel</a> (SwitchTransformers model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.T5Model">T5Model</a> (T5 model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/table-transformer#transformers.TableTransformerModel">TableTransformerModel</a> (Table Transformer model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasModel">TapasModel</a> (TAPAS model)</li> <li><strong>time_series_transformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/time_series_transformer#transformers.TimeSeriesTransformerModel">TimeSeriesTransformerModel</a> (Time Series Transformer model)</li> <li><strong>timesformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/timesformer#transformers.TimesformerModel">TimesformerModel</a> (TimeSformer model)</li> <li><strong>timm_backbone</strong> — <code>TimmBackbone</code> (TimmBackbone model)</li> <li><strong>trajectory_transformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/trajectory_transformer#transformers.TrajectoryTransformerModel">TrajectoryTransformerModel</a> (Trajectory Transformer model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TransfoXLModel">TransfoXLModel</a> (Transformer-XL model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tvlt#transformers.TvltModel">TvltModel</a> (TVLT model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tvp#transformers.TvpModel">TvpModel</a> (TVP model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/umt5#transformers.UMT5Model">UMT5Model</a> (UMT5 model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech#transformers.UniSpeechModel">UniSpeechModel</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatModel">UniSpeechSatModel</a> (UniSpeechSat model)</li> <li><strong>univnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/univnet#transformers.UnivNetModel">UnivNetModel</a> (UnivNet model)</li> <li><strong>van</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/van#transformers.VanModel">VanModel</a> (VAN model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/videomae#transformers.VideoMAEModel">VideoMAEModel</a> (VideoMAE model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vilt#transformers.ViltModel">ViltModel</a> (ViLT model)</li> <li><strong>vision-text-dual-encoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li> <li><strong>visual_bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/visual_bert#transformers.VisualBertModel">VisualBertModel</a> (VisualBERT model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTModel">ViTModel</a> (ViT model)</li> <li><strong>vit_hybrid</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit_hybrid#transformers.ViTHybridModel">ViTHybridModel</a> (ViT Hybrid model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit_mae#transformers.ViTMAEModel">ViTMAEModel</a> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit_msn#transformers.ViTMSNModel">ViTMSNModel</a> (ViTMSN model)</li> <li><strong>vitdet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vitdet#transformers.VitDetModel">VitDetModel</a> (VitDet model)</li> <li><strong>vits</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vits#transformers.VitsModel">VitsModel</a> (VITS model)</li> <li><strong>vivit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vivit#transformers.VivitModel">VivitModel</a> (ViViT model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertModel">Wav2Vec2BertModel</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerModel">Wav2Vec2ConformerModel</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wavlm#transformers.WavLMModel">WavLMModel</a> (WavLM model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperModel">WhisperModel</a> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xclip#transformers.XCLIPModel">XCLIPModel</a> (X-CLIP model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.XGLMModel">XGLMModel</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMModel">XLMModel</a> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetModel">XLMProphetNetModel</a> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaModel">XLMRobertaModel</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLModel">XLMRobertaXLModel</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetModel">XLNetModel</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodModel">XmodModel</a> (X-MOD model)</li> <li><strong>yolos</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/yolos#transformers.YolosModel">YolosModel</a> (YOLOS model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/yoso#transformers.YosoModel">YosoModel</a> (YOSO model)</li>',I4,zh,jV=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,U4,Ps,HC,tm,zC,ue,nm,E4,Oh,AV=`This is a generic model class that will be instantiated as one of the base model classes of the library when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,N4,Kh,ZV="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",X4,St,am,q4,eu,RV="Instantiates one of the base model classes of the library from a configuration.",Q4,ou,WV=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,D4,Gs,Y4,No,sm,H4,ru,VV="Instantiate one of the base model classes of the library from a pretrained model.",z4,tu,SV=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,O4,nu,PV='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.TFAlbertModel">TFAlbertModel</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.TFBartModel">TFBartModel</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.TFBertModel">TFBertModel</a> (BERT model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.TFBlenderbotModel">TFBlenderbotModel</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.TFBlenderbotSmallModel">TFBlenderbotSmallModel</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip#transformers.TFBlipModel">TFBlipModel</a> (BLIP model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.TFCamembertModel">TFCamembertModel</a> (CamemBERT model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.TFCLIPModel">TFCLIPModel</a> (CLIP model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.TFConvBertModel">TFConvBertModel</a> (ConvBERT model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.TFConvNextModel">TFConvNextModel</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnextv2#transformers.TFConvNextV2Model">TFConvNextV2Model</a> (ConvNeXTV2 model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.TFCTRLModel">TFCTRLModel</a> (CTRL model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/cvt#transformers.TFCvtModel">TFCvtModel</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.TFData2VecVisionModel">TFData2VecVisionModel</a> (Data2VecVision model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.TFDebertaModel">TFDebertaModel</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.TFDebertaV2Model">TFDebertaV2Model</a> (DeBERTa-v2 model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deit#transformers.TFDeiTModel">TFDeiTModel</a> (DeiT model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.TFDistilBertModel">TFDistilBertModel</a> (DistilBERT model)</li> <li><strong>dpr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dpr#transformers.TFDPRQuestionEncoder">TFDPRQuestionEncoder</a> (DPR model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/efficientformer#transformers.TFEfficientFormerModel">TFEfficientFormerModel</a> (EfficientFormer model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.TFElectraModel">TFElectraModel</a> (ELECTRA model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.TFEsmModel">TFEsmModel</a> (ESM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.TFFlaubertModel">TFFlaubertModel</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.TFFunnelModel">TFFunnelModel</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.TFFunnelBaseModel">TFFunnelBaseModel</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.TFGPT2Model">TFGPT2Model</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.TFGPT2Model">TFGPT2Model</a> (OpenAI GPT-2 model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.TFGPTJModel">TFGPTJModel</a> (GPT-J model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/groupvit#transformers.TFGroupViTModel">TFGroupViTModel</a> (GroupViT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/hubert#transformers.TFHubertModel">TFHubertModel</a> (Hubert model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.TFLayoutLMModel">TFLayoutLMModel</a> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3Model">TFLayoutLMv3Model</a> (LayoutLMv3 model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/led#transformers.TFLEDModel">TFLEDModel</a> (LED model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.TFLongformerModel">TFLongformerModel</a> (Longformer model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.TFLxmertModel">TFLxmertModel</a> (LXMERT model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.TFMarianModel">TFMarianModel</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.TFMBartModel">TFMBartModel</a> (mBART model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.TFMobileBertModel">TFMobileBertModel</a> (MobileBERT model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevit#transformers.TFMobileViTModel">TFMobileViTModel</a> (MobileViT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.TFMPNetModel">TFMPNetModel</a> (MPNet model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.TFMT5Model">TFMT5Model</a> (MT5 model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.TFOpenAIGPTModel">TFOpenAIGPTModel</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.TFOPTModel">TFOPTModel</a> (OPT model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.TFPegasusModel">TFPegasusModel</a> (Pegasus model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/regnet#transformers.TFRegNetModel">TFRegNetModel</a> (RegNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.TFRemBertModel">TFRemBertModel</a> (RemBERT model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/resnet#transformers.TFResNetModel">TFResNetModel</a> (ResNet model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.TFRobertaModel">TFRobertaModel</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormModel">TFRobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.TFRoFormerModel">TFRoFormerModel</a> (RoFormer model)</li> <li><strong>sam</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/sam#transformers.TFSamModel">TFSamModel</a> (SAM model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/segformer#transformers.TFSegformerModel">TFSegformerModel</a> (SegFormer model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text#transformers.TFSpeech2TextModel">TFSpeech2TextModel</a> (Speech2Text model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swin#transformers.TFSwinModel">TFSwinModel</a> (Swin Transformer model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.TFT5Model">TFT5Model</a> (T5 model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TFTapasModel">TFTapasModel</a> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TFTransfoXLModel">TFTransfoXLModel</a> (Transformer-XL model)</li> <li><strong>vision-text-dual-encoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vision-text-dual-encoder#transformers.TFVisionTextDualEncoderModel">TFVisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.TFViTModel">TFViTModel</a> (ViT model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit_mae#transformers.TFViTMAEModel">TFViTMAEModel</a> (ViTMAE model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.TFWav2Vec2Model">TFWav2Vec2Model</a> (Wav2Vec2 model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.TFWhisperModel">TFWhisperModel</a> (Whisper model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.TFXGLMModel">TFXGLMModel</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.TFXLMModel">TFXLMModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.TFXLMRobertaModel">TFXLMRobertaModel</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.TFXLNetModel">TFXLNetModel</a> (XLNet model)</li>',K4,Js,OC,im,KC,_e,lm,e3,au,GV=`This is a generic model class that will be instantiated as one of the base model classes of the library when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,o3,su,JV="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",r3,Pt,dm,t3,iu,IV="Instantiates one of the base model classes of the library from a configuration.",n3,lu,UV=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,a3,Is,s3,Xo,mm,i3,du,EV="Instantiate one of the base model classes of the library from a pretrained model.",l3,mu,NV=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,d3,cu,XV='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.FlaxAlbertModel">FlaxAlbertModel</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.FlaxBartModel">FlaxBartModel</a> (BART model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/beit#transformers.FlaxBeitModel">FlaxBeitModel</a> (BEiT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.FlaxBertModel">FlaxBertModel</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.FlaxBigBirdModel">FlaxBigBirdModel</a> (BigBird model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.FlaxBlenderbotModel">FlaxBlenderbotModel</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.FlaxBlenderbotSmallModel">FlaxBlenderbotSmallModel</a> (BlenderbotSmall model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.FlaxBloomModel">FlaxBloomModel</a> (BLOOM model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.FlaxCLIPModel">FlaxCLIPModel</a> (CLIP model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.FlaxDistilBertModel">FlaxDistilBertModel</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.FlaxElectraModel">FlaxElectraModel</a> (ELECTRA model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.FlaxGPT2Model">FlaxGPT2Model</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.FlaxGPT2Model">FlaxGPT2Model</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.FlaxGPTNeoModel">FlaxGPTNeoModel</a> (GPT Neo model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.FlaxGPTJModel">FlaxGPTJModel</a> (GPT-J model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.FlaxLlamaModel">FlaxLlamaModel</a> (LLaMA model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longt5#transformers.FlaxLongT5Model">FlaxLongT5Model</a> (LongT5 model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.FlaxMarianModel">FlaxMarianModel</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.FlaxMBartModel">FlaxMBartModel</a> (mBART model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.FlaxMT5Model">FlaxMT5Model</a> (MT5 model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.FlaxOPTModel">FlaxOPTModel</a> (OPT model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.FlaxPegasusModel">FlaxPegasusModel</a> (Pegasus model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/regnet#transformers.FlaxRegNetModel">FlaxRegNetModel</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/resnet#transformers.FlaxResNetModel">FlaxResNetModel</a> (ResNet model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.FlaxRobertaModel">FlaxRobertaModel</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormModel">FlaxRobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.FlaxRoFormerModel">FlaxRoFormerModel</a> (RoFormer model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.FlaxT5Model">FlaxT5Model</a> (T5 model)</li> <li><strong>vision-text-dual-encoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vision-text-dual-encoder#transformers.FlaxVisionTextDualEncoderModel">FlaxVisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.FlaxViTModel">FlaxViTModel</a> (ViT model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.FlaxWav2Vec2Model">FlaxWav2Vec2Model</a> (Wav2Vec2 model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.FlaxWhisperModel">FlaxWhisperModel</a> (Whisper model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.FlaxXGLMModel">FlaxXGLMModel</a> (XGLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaModel">FlaxXLMRobertaModel</a> (XLM-RoBERTa model)</li>',m3,Us,e0,cm,o0,fm,qV="The following auto classes are available for instantiating a model with a pretraining head.",r0,gm,t0,be,pm,c3,fu,QV=`This is a generic model class that will be instantiated as one of the model classes of the library (with a pretraining head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,f3,gu,DV="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",g3,Gt,hm,p3,pu,YV="Instantiates one of the model classes of the library (with a pretraining head) from a configuration.",h3,hu,HV=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,u3,Es,_3,W,um,b3,uu,zV="Instantiate one of the model classes of the library (with a pretraining head) from a pretrained model.",v3,_u,OV=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,M3,bu,KV='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertForPreTraining">AlbertForPreTraining</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertForPreTraining">BertForPreTraining</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdForPreTraining">BigBirdForPreTraining</a> (BigBird model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertForMaskedLM">DistilBertForMaskedLM</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraForPreTraining">ElectraForPreTraining</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieForPreTraining">ErnieForPreTraining</a> (ERNIE model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertWithLMHeadModel">FlaubertWithLMHeadModel</a> (FlauBERT model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flava#transformers.FlavaForPreTraining">FlavaForPreTraining</a> (FLAVA model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetForPreTraining">FNetForPreTraining</a> (FNet model)</li> <li><strong>fsmt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fsmt#transformers.FSMTForConditionalGeneration">FSMTForConditionalGeneration</a> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelForPreTraining">FunnelForPreTraining</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForCausalLM">GPTBigCodeForCausalLM</a> (GPTBigCode model)</li> <li><strong>gptsan-japanese</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> (GPTSAN-japanese model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ibert#transformers.IBertForMaskedLM">IBertForMaskedLM</a> (I-BERT model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/idefics#transformers.IdeficsForVisionText2Text">IdeficsForVisionText2Text</a> (IDEFICS model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMForMaskedLM">LayoutLMForMaskedLM</a> (LayoutLM model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llava#transformers.LlavaForConditionalGeneration">LlavaForConditionalGeneration</a> (LLaVa model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerForMaskedLM">LongformerForMaskedLM</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/luke#transformers.LukeForMaskedLM">LukeForMaskedLM</a> (LUKE model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.LxmertForPreTraining">LxmertForPreTraining</a> (LXMERT model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaForMaskedLM">MegaForMaskedLM</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertForPreTraining">MegatronBertForPreTraining</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertForPreTraining">MobileBertForPreTraining</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetForMaskedLM">MPNetForMaskedLM</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpt#transformers.MptForCausalLM">MptForCausalLM</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mra#transformers.MraForMaskedLM">MraForMaskedLM</a> (MRA model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpForConditionalGeneration">MvpForConditionalGeneration</a> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nezha#transformers.NezhaForPreTraining">NezhaForPreTraining</a> (Nezha model)</li> <li><strong>nllb-moe</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nllb-moe#transformers.NllbMoeForConditionalGeneration">NllbMoeForConditionalGeneration</a> (NLLB-MOE model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li> <li><strong>retribert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/retribert#transformers.RetriBertModel">RetriBertModel</a> (RetriBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaForMaskedLM">RobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForMaskedLM">RobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertForPreTraining">RoCBertForPreTraining</a> (RoCBert model)</li> <li><strong>rwkv</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rwkv#transformers.RwkvForCausalLM">RwkvForCausalLM</a> (RWKV model)</li> <li><strong>splinter</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/splinter#transformers.SplinterForPreTraining">SplinterForPreTraining</a> (Splinter model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertForMaskedLM">SqueezeBertForMaskedLM</a> (SqueezeBERT model)</li> <li><strong>switch_transformers</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/switch_transformers#transformers.SwitchTransformersForConditionalGeneration">SwitchTransformersForConditionalGeneration</a> (SwitchTransformers model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.T5ForConditionalGeneration">T5ForConditionalGeneration</a> (T5 model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasForMaskedLM">TapasForMaskedLM</a> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TransfoXLLMHeadModel">TransfoXLLMHeadModel</a> (Transformer-XL model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tvlt#transformers.TvltForPreTraining">TvltForPreTraining</a> (TVLT model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech#transformers.UniSpeechForPreTraining">UniSpeechForPreTraining</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatForPreTraining">UniSpeechSatForPreTraining</a> (UniSpeechSat model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/videomae#transformers.VideoMAEForPreTraining">VideoMAEForPreTraining</a> (VideoMAE model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vipllava#transformers.VipLlavaForConditionalGeneration">VipLlavaForConditionalGeneration</a> (VipLlava model)</li> <li><strong>visual_bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/visual_bert#transformers.VisualBertForPreTraining">VisualBertForPreTraining</a> (VisualBERT model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit_mae#transformers.ViTMAEForPreTraining">ViTMAEForPreTraining</a> (ViTMAE model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2ForPreTraining">Wav2Vec2ForPreTraining</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForPreTraining">Wav2Vec2ConformerForPreTraining</a> (Wav2Vec2-Conformer model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaForMaskedLM">XLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForMaskedLM">XLMRobertaXLForMaskedLM</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetLMHeadModel">XLNetLMHeadModel</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodForMaskedLM">XmodForMaskedLM</a> (X-MOD model)</li>',F3,vu,eS=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,T3,Ns,n0,_m,a0,ve,bm,y3,Mu,oS=`This is a generic model class that will be instantiated as one of the model classes of the library (with a pretraining head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,C3,Fu,rS="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",w3,Jt,vm,x3,Tu,tS="Instantiates one of the model classes of the library (with a pretraining head) from a configuration.",k3,yu,nS=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,L3,Xs,$3,qo,Mm,B3,Cu,aS="Instantiate one of the model classes of the library (with a pretraining head) from a pretrained model.",j3,wu,sS=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,A3,xu,iS='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.TFAlbertForPreTraining">TFAlbertForPreTraining</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.TFBartForConditionalGeneration">TFBartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.TFBertForPreTraining">TFBertForPreTraining</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.TFCamembertForMaskedLM">TFCamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.TFDistilBertForMaskedLM">TFDistilBertForMaskedLM</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.TFElectraForPreTraining">TFElectraForPreTraining</a> (ELECTRA model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.TFFlaubertWithLMHeadModel">TFFlaubertWithLMHeadModel</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.TFFunnelForPreTraining">TFFunnelForPreTraining</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.TFLayoutLMForMaskedLM">TFLayoutLMForMaskedLM</a> (LayoutLM model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.TFLxmertForPreTraining">TFLxmertForPreTraining</a> (LXMERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.TFMobileBertForPreTraining">TFMobileBertForPreTraining</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.TFMPNetForMaskedLM">TFMPNetForMaskedLM</a> (MPNet model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.TFRobertaForMaskedLM">TFRobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForMaskedLM">TFRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.TFT5ForConditionalGeneration">TFT5ForConditionalGeneration</a> (T5 model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TFTapasForMaskedLM">TFTapasForMaskedLM</a> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TFTransfoXLLMHeadModel">TFTransfoXLLMHeadModel</a> (Transformer-XL model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit_mae#transformers.TFViTMAEForPreTraining">TFViTMAEForPreTraining</a> (ViTMAE model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForMaskedLM">TFXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.TFXLNetLMHeadModel">TFXLNetLMHeadModel</a> (XLNet model)</li>',Z3,qs,s0,Fm,i0,Me,Tm,R3,ku,lS=`This is a generic model class that will be instantiated as one of the model classes of the library (with a pretraining head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,W3,Lu,dS="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",V3,It,ym,S3,$u,mS="Instantiates one of the model classes of the library (with a pretraining head) from a configuration.",P3,Bu,cS=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,G3,Qs,J3,Qo,Cm,I3,ju,fS="Instantiate one of the model classes of the library (with a pretraining head) from a pretrained model.",U3,Au,gS=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,E3,Zu,pS='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.FlaxAlbertForPreTraining">FlaxAlbertForPreTraining</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.FlaxBertForPreTraining">FlaxBertForPreTraining</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.FlaxBigBirdForPreTraining">FlaxBigBirdForPreTraining</a> (BigBird model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.FlaxElectraForPreTraining">FlaxElectraForPreTraining</a> (ELECTRA model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longt5#transformers.FlaxLongT5ForConditionalGeneration">FlaxLongT5ForConditionalGeneration</a> (LongT5 model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.FlaxMBartForConditionalGeneration">FlaxMBartForConditionalGeneration</a> (mBART model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.FlaxMT5ForConditionalGeneration">FlaxMT5ForConditionalGeneration</a> (MT5 model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.FlaxRobertaForMaskedLM">FlaxRobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForMaskedLM">FlaxRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.FlaxRoFormerForMaskedLM">FlaxRoFormerForMaskedLM</a> (RoFormer model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.FlaxT5ForConditionalGeneration">FlaxT5ForConditionalGeneration</a> (T5 model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.FlaxWav2Vec2ForPreTraining">FlaxWav2Vec2ForPreTraining</a> (Wav2Vec2 model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.FlaxWhisperForConditionalGeneration">FlaxWhisperForConditionalGeneration</a> (Whisper model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForMaskedLM">FlaxXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>',N3,Ds,l0,wm,d0,xm,hS="The following auto classes are available for the following natural language processing tasks.",m0,km,c0,Fe,Lm,X3,Ru,uS=`This is a generic model class that will be instantiated as one of the model classes of the library (with a causal language modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,q3,Wu,_S="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Q3,Ut,$m,D3,Vu,bS="Instantiates one of the model classes of the library (with a causal language modeling head) from a configuration.",Y3,Su,vS=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,H3,Ys,z3,V,Bm,O3,Pu,MS="Instantiate one of the model classes of the library (with a causal language modeling head) from a pretrained model.",K3,Gu,FS=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,ex,Ju,TS='<li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartForCausalLM">BartForCausalLM</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertLMHeadModel">BertLMHeadModel</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert-generation#transformers.BertGenerationDecoder">BertGenerationDecoder</a> (Bert Generation model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdForCausalLM">BigBirdForCausalLM</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForCausalLM">BigBirdPegasusForCausalLM</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/biogpt#transformers.BioGptForCausalLM">BioGptForCausalLM</a> (BioGpt model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.BlenderbotForCausalLM">BlenderbotForCausalLM</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.BlenderbotSmallForCausalLM">BlenderbotSmallForCausalLM</a> (BlenderbotSmall model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertForCausalLM">CamembertForCausalLM</a> (CamemBERT model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaForCausalLM">LlamaForCausalLM</a> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/codegen#transformers.CodeGenForCausalLM">CodeGenForCausalLM</a> (CodeGen model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/cpmant#transformers.CpmAntForCausalLM">CpmAntForCausalLM</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextForCausalLM">Data2VecTextForCausalLM</a> (Data2VecText model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraForCausalLM">ElectraForCausalLM</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieForCausalLM">ErnieForCausalLM</a> (ERNIE model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/falcon#transformers.FalconForCausalLM">FalconForCausalLM</a> (Falcon model)</li> <li><strong>fuyu</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fuyu#transformers.FuyuForCausalLM">FuyuForCausalLM</a> (Fuyu model)</li> <li><strong>git</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/git#transformers.GitForCausalLM">GitForCausalLM</a> (GIT model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForCausalLM">GPTBigCodeForCausalLM</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.GPTNeoForCausalLM">GPTNeoForCausalLM</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox#transformers.GPTNeoXForCausalLM">GPTNeoXForCausalLM</a> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseForCausalLM">GPTNeoXJapaneseForCausalLM</a> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.GPTJForCausalLM">GPTJForCausalLM</a> (GPT-J model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaForCausalLM">LlamaForCausalLM</a> (LLaMA model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.MarianForCausalLM">MarianForCausalLM</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartForCausalLM">MBartForCausalLM</a> (mBART model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaForCausalLM">MegaForCausalLM</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertForCausalLM">MegatronBertForCausalLM</a> (Megatron-BERT model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mistral#transformers.MistralForCausalLM">MistralForCausalLM</a> (Mistral model)</li> <li><strong>mixtral</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mixtral#transformers.MixtralForCausalLM">MixtralForCausalLM</a> (Mixtral model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpt#transformers.MptForCausalLM">MptForCausalLM</a> (MPT model)</li> <li><strong>musicgen</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a> (MusicGen model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpForCausalLM">MvpForCausalLM</a> (MVP model)</li> <li><strong>open-llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/open-llama#transformers.OpenLlamaForCausalLM">OpenLlamaForCausalLM</a> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.OPTForCausalLM">OPTForCausalLM</a> (OPT model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusForCausalLM">PegasusForCausalLM</a> (Pegasus model)</li> <li><strong>persimmon</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/persimmon#transformers.PersimmonForCausalLM">PersimmonForCausalLM</a> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/phi#transformers.PhiForCausalLM">PhiForCausalLM</a> (Phi model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/plbart#transformers.PLBartForCausalLM">PLBartForCausalLM</a> (PLBart model)</li> <li><strong>prophetnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/prophetnet#transformers.ProphetNetForCausalLM">ProphetNetForCausalLM</a> (ProphetNet model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/qdqbert#transformers.QDQBertLMHeadModel">QDQBertLMHeadModel</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/qwen2#transformers.Qwen2ForCausalLM">Qwen2ForCausalLM</a> (Qwen2 model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/reformer#transformers.ReformerModelWithLMHead">ReformerModelWithLMHead</a> (Reformer model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertForCausalLM">RemBertForCausalLM</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaForCausalLM">RobertaForCausalLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForCausalLM">RobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertForCausalLM">RoCBertForCausalLM</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerForCausalLM">RoFormerForCausalLM</a> (RoFormer model)</li> <li><strong>rwkv</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rwkv#transformers.RwkvForCausalLM">RwkvForCausalLM</a> (RWKV model)</li> <li><strong>speech_to_text_2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2ForCausalLM">Speech2Text2ForCausalLM</a> (Speech2Text2 model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TransfoXLLMHeadModel">TransfoXLLMHeadModel</a> (Transformer-XL model)</li> <li><strong>trocr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/trocr#transformers.TrOCRForCausalLM">TrOCRForCausalLM</a> (TrOCR model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperForCausalLM">WhisperForCausalLM</a> (Whisper model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.XGLMForCausalLM">XGLMForCausalLM</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetForCausalLM">XLMProphetNetForCausalLM</a> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaForCausalLM">XLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForCausalLM">XLMRobertaXLForCausalLM</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetLMHeadModel">XLNetLMHeadModel</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodForCausalLM">XmodForCausalLM</a> (X-MOD model)</li>',ox,Iu,yS=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,rx,Hs,f0,jm,g0,Te,Am,tx,Uu,CS=`This is a generic model class that will be instantiated as one of the model classes of the library (with a causal language modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,nx,Eu,wS="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",ax,Et,Zm,sx,Nu,xS="Instantiates one of the model classes of the library (with a causal language modeling head) from a configuration.",ix,Xu,kS=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,lx,zs,dx,Do,Rm,mx,qu,LS="Instantiate one of the model classes of the library (with a causal language modeling head) from a pretrained model.",cx,Qu,$S=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,fx,Du,BS='<li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.TFBertLMHeadModel">TFBertLMHeadModel</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.TFCamembertForCausalLM">TFCamembertForCausalLM</a> (CamemBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.TFGPTJForCausalLM">TFGPTJForCausalLM</a> (GPT-J model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.TFOPTForCausalLM">TFOPTForCausalLM</a> (OPT model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.TFRemBertForCausalLM">TFRemBertForCausalLM</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.TFRobertaForCausalLM">TFRobertaForCausalLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForCausalLM">TFRobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.TFRoFormerForCausalLM">TFRoFormerForCausalLM</a> (RoFormer model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TFTransfoXLLMHeadModel">TFTransfoXLLMHeadModel</a> (Transformer-XL model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.TFXGLMForCausalLM">TFXGLMForCausalLM</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForCausalLM">TFXLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.TFXLNetLMHeadModel">TFXLNetLMHeadModel</a> (XLNet model)</li>',gx,Os,p0,Wm,h0,ye,Vm,px,Yu,jS=`This is a generic model class that will be instantiated as one of the model classes of the library (with a causal language modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,hx,Hu,AS="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",ux,Nt,Sm,_x,zu,ZS="Instantiates one of the model classes of the library (with a causal language modeling head) from a configuration.",bx,Ou,RS=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,vx,Ks,Mx,Yo,Pm,Fx,Ku,WS="Instantiate one of the model classes of the library (with a causal language modeling head) from a pretrained model.",Tx,e_,VS=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,yx,o_,SS='<li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.FlaxBartForCausalLM">FlaxBartForCausalLM</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.FlaxBertForCausalLM">FlaxBertForCausalLM</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.FlaxBigBirdForCausalLM">FlaxBigBirdForCausalLM</a> (BigBird model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.FlaxBloomForCausalLM">FlaxBloomForCausalLM</a> (BLOOM model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.FlaxElectraForCausalLM">FlaxElectraForCausalLM</a> (ELECTRA model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.FlaxGPT2LMHeadModel">FlaxGPT2LMHeadModel</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.FlaxGPT2LMHeadModel">FlaxGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.FlaxGPTNeoForCausalLM">FlaxGPTNeoForCausalLM</a> (GPT Neo model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.FlaxGPTJForCausalLM">FlaxGPTJForCausalLM</a> (GPT-J model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.FlaxLlamaForCausalLM">FlaxLlamaForCausalLM</a> (LLaMA model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.FlaxOPTForCausalLM">FlaxOPTForCausalLM</a> (OPT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.FlaxRobertaForCausalLM">FlaxRobertaForCausalLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForCausalLM">FlaxRobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.FlaxXGLMForCausalLM">FlaxXGLMForCausalLM</a> (XGLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForCausalLM">FlaxXLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li>',Cx,ei,u0,Gm,_0,Ce,Jm,wx,r_,PS=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked language modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,xx,t_,GS="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",kx,Xt,Im,Lx,n_,JS="Instantiates one of the model classes of the library (with a masked language modeling head) from a configuration.",$x,a_,IS=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Bx,oi,jx,S,Um,Ax,s_,US="Instantiate one of the model classes of the library (with a masked language modeling head) from a pretrained model.",Zx,i_,ES=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Rx,l_,NS='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertForMaskedLM">AlbertForMaskedLM</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertForMaskedLM">BertForMaskedLM</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdForMaskedLM">BigBirdForMaskedLM</a> (BigBird model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.ConvBertForMaskedLM">ConvBertForMaskedLM</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertForMaskedLM">DistilBertForMaskedLM</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraForMaskedLM">ElectraForMaskedLM</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieForMaskedLM">ErnieForMaskedLM</a> (ERNIE model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.EsmForMaskedLM">EsmForMaskedLM</a> (ESM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertWithLMHeadModel">FlaubertWithLMHeadModel</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetForMaskedLM">FNetForMaskedLM</a> (FNet model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelForMaskedLM">FunnelForMaskedLM</a> (Funnel Transformer model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ibert#transformers.IBertForMaskedLM">IBertForMaskedLM</a> (I-BERT model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMForMaskedLM">LayoutLMForMaskedLM</a> (LayoutLM model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerForMaskedLM">LongformerForMaskedLM</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/luke#transformers.LukeForMaskedLM">LukeForMaskedLM</a> (LUKE model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartForConditionalGeneration">MBartForConditionalGeneration</a> (mBART model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaForMaskedLM">MegaForMaskedLM</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertForMaskedLM">MegatronBertForMaskedLM</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertForMaskedLM">MobileBertForMaskedLM</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetForMaskedLM">MPNetForMaskedLM</a> (MPNet model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mra#transformers.MraForMaskedLM">MraForMaskedLM</a> (MRA model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpForConditionalGeneration">MvpForConditionalGeneration</a> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nezha#transformers.NezhaForMaskedLM">NezhaForMaskedLM</a> (Nezha model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nystromformer#transformers.NystromformerForMaskedLM">NystromformerForMaskedLM</a> (Nyströmformer model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/perceiver#transformers.PerceiverForMaskedLM">PerceiverForMaskedLM</a> (Perceiver model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/qdqbert#transformers.QDQBertForMaskedLM">QDQBertForMaskedLM</a> (QDQBert model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/reformer#transformers.ReformerForMaskedLM">ReformerForMaskedLM</a> (Reformer model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertForMaskedLM">RemBertForMaskedLM</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaForMaskedLM">RobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForMaskedLM">RobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertForMaskedLM">RoCBertForMaskedLM</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerForMaskedLM">RoFormerForMaskedLM</a> (RoFormer model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertForMaskedLM">SqueezeBertForMaskedLM</a> (SqueezeBERT model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasForMaskedLM">TapasForMaskedLM</a> (TAPAS model)</li> <li><strong>wav2vec2</strong> — <code>Wav2Vec2ForMaskedLM</code> (Wav2Vec2 model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaForMaskedLM">XLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForMaskedLM">XLMRobertaXLForMaskedLM</a> (XLM-RoBERTa-XL model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodForMaskedLM">XmodForMaskedLM</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/yoso#transformers.YosoForMaskedLM">YosoForMaskedLM</a> (YOSO model)</li>',Wx,d_,XS=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,Vx,ri,b0,Em,v0,we,Nm,Sx,m_,qS=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked language modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Px,c_,QS="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Gx,qt,Xm,Jx,f_,DS="Instantiates one of the model classes of the library (with a masked language modeling head) from a configuration.",Ix,g_,YS=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Ux,ti,Ex,Ho,qm,Nx,p_,HS="Instantiate one of the model classes of the library (with a masked language modeling head) from a pretrained model.",Xx,h_,zS=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,qx,u_,OS='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.TFAlbertForMaskedLM">TFAlbertForMaskedLM</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.TFBertForMaskedLM">TFBertForMaskedLM</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.TFCamembertForMaskedLM">TFCamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.TFConvBertForMaskedLM">TFConvBertForMaskedLM</a> (ConvBERT model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.TFDebertaForMaskedLM">TFDebertaForMaskedLM</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.TFDebertaV2ForMaskedLM">TFDebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.TFDistilBertForMaskedLM">TFDistilBertForMaskedLM</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.TFElectraForMaskedLM">TFElectraForMaskedLM</a> (ELECTRA model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.TFEsmForMaskedLM">TFEsmForMaskedLM</a> (ESM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.TFFlaubertWithLMHeadModel">TFFlaubertWithLMHeadModel</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.TFFunnelForMaskedLM">TFFunnelForMaskedLM</a> (Funnel Transformer model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.TFLayoutLMForMaskedLM">TFLayoutLMForMaskedLM</a> (LayoutLM model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.TFLongformerForMaskedLM">TFLongformerForMaskedLM</a> (Longformer model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.TFMobileBertForMaskedLM">TFMobileBertForMaskedLM</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.TFMPNetForMaskedLM">TFMPNetForMaskedLM</a> (MPNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.TFRemBertForMaskedLM">TFRemBertForMaskedLM</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.TFRobertaForMaskedLM">TFRobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForMaskedLM">TFRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.TFRoFormerForMaskedLM">TFRoFormerForMaskedLM</a> (RoFormer model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TFTapasForMaskedLM">TFTapasForMaskedLM</a> (TAPAS model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForMaskedLM">TFXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>',Qx,ni,M0,Qm,F0,xe,Dm,Dx,__,KS=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked language modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Yx,b_,eP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Hx,Qt,Ym,zx,v_,oP="Instantiates one of the model classes of the library (with a masked language modeling head) from a configuration.",Ox,M_,rP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Kx,ai,e7,zo,Hm,o7,F_,tP="Instantiate one of the model classes of the library (with a masked language modeling head) from a pretrained model.",r7,T_,nP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,t7,y_,aP='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.FlaxAlbertForMaskedLM">FlaxAlbertForMaskedLM</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.FlaxBertForMaskedLM">FlaxBertForMaskedLM</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.FlaxBigBirdForMaskedLM">FlaxBigBirdForMaskedLM</a> (BigBird model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.FlaxDistilBertForMaskedLM">FlaxDistilBertForMaskedLM</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.FlaxElectraForMaskedLM">FlaxElectraForMaskedLM</a> (ELECTRA model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.FlaxMBartForConditionalGeneration">FlaxMBartForConditionalGeneration</a> (mBART model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.FlaxRobertaForMaskedLM">FlaxRobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForMaskedLM">FlaxRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.FlaxRoFormerForMaskedLM">FlaxRoFormerForMaskedLM</a> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForMaskedLM">FlaxXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>',n7,si,T0,zm,y0,Om,Km,C0,ec,w0,oc,rc,x0,tc,k0,ke,nc,a7,C_,sP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence language modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,s7,w_,iP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",i7,Dt,ac,l7,x_,lP="Instantiates one of the model classes of the library (with a sequence-to-sequence language modeling head) from a configuration.",d7,k_,dP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,m7,ii,c7,P,sc,f7,L_,mP="Instantiate one of the model classes of the library (with a sequence-to-sequence language modeling head) from a pretrained model.",g7,$_,cP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,p7,B_,fP='<li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForConditionalGeneration">BigBirdPegasusForConditionalGeneration</a> (BigBird-Pegasus model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.BlenderbotForConditionalGeneration">BlenderbotForConditionalGeneration</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.BlenderbotSmallForConditionalGeneration">BlenderbotSmallForConditionalGeneration</a> (BlenderbotSmall model)</li> <li><strong>encoder-decoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/encoder-decoder#transformers.EncoderDecoderModel">EncoderDecoderModel</a> (Encoder decoder model)</li> <li><strong>fsmt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fsmt#transformers.FSMTForConditionalGeneration">FSMTForConditionalGeneration</a> (FairSeq Machine-Translation model)</li> <li><strong>gptsan-japanese</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> (GPTSAN-japanese model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/led#transformers.LEDForConditionalGeneration">LEDForConditionalGeneration</a> (LED model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longt5#transformers.LongT5ForConditionalGeneration">LongT5ForConditionalGeneration</a> (LongT5 model)</li> <li><strong>m2m_100</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/m2m_100#transformers.M2M100ForConditionalGeneration">M2M100ForConditionalGeneration</a> (M2M100 model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.MarianMTModel">MarianMTModel</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartForConditionalGeneration">MBartForConditionalGeneration</a> (mBART model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.MT5ForConditionalGeneration">MT5ForConditionalGeneration</a> (MT5 model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpForConditionalGeneration">MvpForConditionalGeneration</a> (MVP model)</li> <li><strong>nllb-moe</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nllb-moe#transformers.NllbMoeForConditionalGeneration">NllbMoeForConditionalGeneration</a> (NLLB-MOE model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusForConditionalGeneration">PegasusForConditionalGeneration</a> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus_x#transformers.PegasusXForConditionalGeneration">PegasusXForConditionalGeneration</a> (PEGASUS-X model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/plbart#transformers.PLBartForConditionalGeneration">PLBartForConditionalGeneration</a> (PLBart model)</li> <li><strong>prophetnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/prophetnet#transformers.ProphetNetForConditionalGeneration">ProphetNetForConditionalGeneration</a> (ProphetNet model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t#transformers.SeamlessM4TForTextToText">SeamlessM4TForTextToText</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForTextToText">SeamlessM4Tv2ForTextToText</a> (SeamlessM4Tv2 model)</li> <li><strong>switch_transformers</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/switch_transformers#transformers.SwitchTransformersForConditionalGeneration">SwitchTransformersForConditionalGeneration</a> (SwitchTransformers model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.T5ForConditionalGeneration">T5ForConditionalGeneration</a> (T5 model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/umt5#transformers.UMT5ForConditionalGeneration">UMT5ForConditionalGeneration</a> (UMT5 model)</li> <li><strong>xlm-prophetnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetForConditionalGeneration">XLMProphetNetForConditionalGeneration</a> (XLM-ProphetNet model)</li>',h7,j_,gP=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,u7,li,L0,ic,$0,Le,lc,_7,A_,pP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence language modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,b7,Z_,hP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",v7,Yt,dc,M7,R_,uP="Instantiates one of the model classes of the library (with a sequence-to-sequence language modeling head) from a configuration.",F7,W_,_P=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,T7,di,y7,Oo,mc,C7,V_,bP="Instantiate one of the model classes of the library (with a sequence-to-sequence language modeling head) from a pretrained model.",w7,S_,vP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,x7,P_,MP='<li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.TFBartForConditionalGeneration">TFBartForConditionalGeneration</a> (BART model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.TFBlenderbotForConditionalGeneration">TFBlenderbotForConditionalGeneration</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.TFBlenderbotSmallForConditionalGeneration">TFBlenderbotSmallForConditionalGeneration</a> (BlenderbotSmall model)</li> <li><strong>encoder-decoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/encoder-decoder#transformers.TFEncoderDecoderModel">TFEncoderDecoderModel</a> (Encoder decoder model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/led#transformers.TFLEDForConditionalGeneration">TFLEDForConditionalGeneration</a> (LED model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.TFMarianMTModel">TFMarianMTModel</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.TFMBartForConditionalGeneration">TFMBartForConditionalGeneration</a> (mBART model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.TFMT5ForConditionalGeneration">TFMT5ForConditionalGeneration</a> (MT5 model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.TFPegasusForConditionalGeneration">TFPegasusForConditionalGeneration</a> (Pegasus model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.TFT5ForConditionalGeneration">TFT5ForConditionalGeneration</a> (T5 model)</li>',k7,mi,B0,cc,j0,$e,fc,L7,G_,FP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence language modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,$7,J_,TP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",B7,Ht,gc,j7,I_,yP="Instantiates one of the model classes of the library (with a sequence-to-sequence language modeling head) from a configuration.",A7,U_,CP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Z7,ci,R7,Ko,pc,W7,E_,wP="Instantiate one of the model classes of the library (with a sequence-to-sequence language modeling head) from a pretrained model.",V7,N_,xP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,S7,X_,kP='<li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.FlaxBlenderbotForConditionalGeneration">FlaxBlenderbotForConditionalGeneration</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.FlaxBlenderbotSmallForConditionalGeneration">FlaxBlenderbotSmallForConditionalGeneration</a> (BlenderbotSmall model)</li> <li><strong>encoder-decoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/encoder-decoder#transformers.FlaxEncoderDecoderModel">FlaxEncoderDecoderModel</a> (Encoder decoder model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longt5#transformers.FlaxLongT5ForConditionalGeneration">FlaxLongT5ForConditionalGeneration</a> (LongT5 model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.FlaxMarianMTModel">FlaxMarianMTModel</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.FlaxMBartForConditionalGeneration">FlaxMBartForConditionalGeneration</a> (mBART model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.FlaxMT5ForConditionalGeneration">FlaxMT5ForConditionalGeneration</a> (MT5 model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.FlaxPegasusForConditionalGeneration">FlaxPegasusForConditionalGeneration</a> (Pegasus model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.FlaxT5ForConditionalGeneration">FlaxT5ForConditionalGeneration</a> (T5 model)</li>',P7,fi,A0,hc,Z0,Be,uc,G7,q_,LP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,J7,Q_,$P="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",I7,zt,_c,U7,D_,BP="Instantiates one of the model classes of the library (with a sequence classification head) from a configuration.",E7,Y_,jP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,N7,gi,X7,G,bc,q7,H_,AP="Instantiate one of the model classes of the library (with a sequence classification head) from a pretrained model.",Q7,z_,ZP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,D7,O_,RP='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertForSequenceClassification">AlbertForSequenceClassification</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartForSequenceClassification">BartForSequenceClassification</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertForSequenceClassification">BertForSequenceClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdForSequenceClassification">BigBirdForSequenceClassification</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForSequenceClassification">BigBirdPegasusForSequenceClassification</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/biogpt#transformers.BioGptForSequenceClassification">BioGptForSequenceClassification</a> (BioGpt model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomForSequenceClassification">BloomForSequenceClassification</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertForSequenceClassification">CamembertForSequenceClassification</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/canine#transformers.CanineForSequenceClassification">CanineForSequenceClassification</a> (CANINE model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaForSequenceClassification">LlamaForSequenceClassification</a> (CodeLlama model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.ConvBertForSequenceClassification">ConvBertForSequenceClassification</a> (ConvBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.CTRLForSequenceClassification">CTRLForSequenceClassification</a> (CTRL model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextForSequenceClassification">Data2VecTextForSequenceClassification</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaForSequenceClassification">DebertaForSequenceClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2ForSequenceClassification">DebertaV2ForSequenceClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertForSequenceClassification">DistilBertForSequenceClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraForSequenceClassification">ElectraForSequenceClassification</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieForSequenceClassification">ErnieForSequenceClassification</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie_m#transformers.ErnieMForSequenceClassification">ErnieMForSequenceClassification</a> (ErnieM model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.EsmForSequenceClassification">EsmForSequenceClassification</a> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/falcon#transformers.FalconForSequenceClassification">FalconForSequenceClassification</a> (Falcon model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertForSequenceClassification">FlaubertForSequenceClassification</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetForSequenceClassification">FNetForSequenceClassification</a> (FNet model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelForSequenceClassification">FunnelForSequenceClassification</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2ForSequenceClassification">GPT2ForSequenceClassification</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2ForSequenceClassification">GPT2ForSequenceClassification</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForSequenceClassification">GPTBigCodeForSequenceClassification</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.GPTNeoForSequenceClassification">GPTNeoForSequenceClassification</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox#transformers.GPTNeoXForSequenceClassification">GPTNeoXForSequenceClassification</a> (GPT NeoX model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.GPTJForSequenceClassification">GPTJForSequenceClassification</a> (GPT-J model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ibert#transformers.IBertForSequenceClassification">IBertForSequenceClassification</a> (I-BERT model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMForSequenceClassification">LayoutLMForSequenceClassification</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv2#transformers.LayoutLMv2ForSequenceClassification">LayoutLMv2ForSequenceClassification</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3ForSequenceClassification">LayoutLMv3ForSequenceClassification</a> (LayoutLMv3 model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/led#transformers.LEDForSequenceClassification">LEDForSequenceClassification</a> (LED model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/lilt#transformers.LiltForSequenceClassification">LiltForSequenceClassification</a> (LiLT model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaForSequenceClassification">LlamaForSequenceClassification</a> (LLaMA model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerForSequenceClassification">LongformerForSequenceClassification</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/luke#transformers.LukeForSequenceClassification">LukeForSequenceClassification</a> (LUKE model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/markuplm#transformers.MarkupLMForSequenceClassification">MarkupLMForSequenceClassification</a> (MarkupLM model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartForSequenceClassification">MBartForSequenceClassification</a> (mBART model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaForSequenceClassification">MegaForSequenceClassification</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertForSequenceClassification">MegatronBertForSequenceClassification</a> (Megatron-BERT model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mistral#transformers.MistralForSequenceClassification">MistralForSequenceClassification</a> (Mistral model)</li> <li><strong>mixtral</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mixtral#transformers.MixtralForSequenceClassification">MixtralForSequenceClassification</a> (Mixtral model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertForSequenceClassification">MobileBertForSequenceClassification</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetForSequenceClassification">MPNetForSequenceClassification</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpt#transformers.MptForSequenceClassification">MptForSequenceClassification</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mra#transformers.MraForSequenceClassification">MraForSequenceClassification</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.MT5ForSequenceClassification">MT5ForSequenceClassification</a> (MT5 model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpForSequenceClassification">MvpForSequenceClassification</a> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nezha#transformers.NezhaForSequenceClassification">NezhaForSequenceClassification</a> (Nezha model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nystromformer#transformers.NystromformerForSequenceClassification">NystromformerForSequenceClassification</a> (Nyströmformer model)</li> <li><strong>open-llama</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/open-llama#transformers.OpenLlamaForSequenceClassification">OpenLlamaForSequenceClassification</a> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTForSequenceClassification">OpenAIGPTForSequenceClassification</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.OPTForSequenceClassification">OPTForSequenceClassification</a> (OPT model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/perceiver#transformers.PerceiverForSequenceClassification">PerceiverForSequenceClassification</a> (Perceiver model)</li> <li><strong>persimmon</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/persimmon#transformers.PersimmonForSequenceClassification">PersimmonForSequenceClassification</a> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/phi#transformers.PhiForSequenceClassification">PhiForSequenceClassification</a> (Phi model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/plbart#transformers.PLBartForSequenceClassification">PLBartForSequenceClassification</a> (PLBart model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/qdqbert#transformers.QDQBertForSequenceClassification">QDQBertForSequenceClassification</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/qwen2#transformers.Qwen2ForSequenceClassification">Qwen2ForSequenceClassification</a> (Qwen2 model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/reformer#transformers.ReformerForSequenceClassification">ReformerForSequenceClassification</a> (Reformer model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertForSequenceClassification">RemBertForSequenceClassification</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaForSequenceClassification">RobertaForSequenceClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForSequenceClassification">RobertaPreLayerNormForSequenceClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertForSequenceClassification">RoCBertForSequenceClassification</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerForSequenceClassification">RoFormerForSequenceClassification</a> (RoFormer model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertForSequenceClassification">SqueezeBertForSequenceClassification</a> (SqueezeBERT model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.T5ForSequenceClassification">T5ForSequenceClassification</a> (T5 model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasForSequenceClassification">TapasForSequenceClassification</a> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TransfoXLForSequenceClassification">TransfoXLForSequenceClassification</a> (Transformer-XL model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/umt5#transformers.UMT5ForSequenceClassification">UMT5ForSequenceClassification</a> (UMT5 model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMForSequenceClassification">XLMForSequenceClassification</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaForSequenceClassification">XLMRobertaForSequenceClassification</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForSequenceClassification">XLMRobertaXLForSequenceClassification</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetForSequenceClassification">XLNetForSequenceClassification</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodForSequenceClassification">XmodForSequenceClassification</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/yoso#transformers.YosoForSequenceClassification">YosoForSequenceClassification</a> (YOSO model)</li>',Y7,K_,WP=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,H7,pi,R0,vc,W0,je,Mc,z7,eb,VP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,O7,ob,SP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",K7,Ot,Fc,ek,rb,PP="Instantiates one of the model classes of the library (with a sequence classification head) from a configuration.",ok,tb,GP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,rk,hi,tk,er,Tc,nk,nb,JP="Instantiate one of the model classes of the library (with a sequence classification head) from a pretrained model.",ak,ab,IP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,sk,sb,UP='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.TFAlbertForSequenceClassification">TFAlbertForSequenceClassification</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.TFBartForSequenceClassification">TFBartForSequenceClassification</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.TFBertForSequenceClassification">TFBertForSequenceClassification</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.TFCamembertForSequenceClassification">TFCamembertForSequenceClassification</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.TFConvBertForSequenceClassification">TFConvBertForSequenceClassification</a> (ConvBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.TFCTRLForSequenceClassification">TFCTRLForSequenceClassification</a> (CTRL model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.TFDebertaForSequenceClassification">TFDebertaForSequenceClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.TFDebertaV2ForSequenceClassification">TFDebertaV2ForSequenceClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.TFDistilBertForSequenceClassification">TFDistilBertForSequenceClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.TFElectraForSequenceClassification">TFElectraForSequenceClassification</a> (ELECTRA model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.TFEsmForSequenceClassification">TFEsmForSequenceClassification</a> (ESM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.TFFlaubertForSequenceClassification">TFFlaubertForSequenceClassification</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.TFFunnelForSequenceClassification">TFFunnelForSequenceClassification</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.TFGPT2ForSequenceClassification">TFGPT2ForSequenceClassification</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.TFGPT2ForSequenceClassification">TFGPT2ForSequenceClassification</a> (OpenAI GPT-2 model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.TFGPTJForSequenceClassification">TFGPTJForSequenceClassification</a> (GPT-J model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.TFLayoutLMForSequenceClassification">TFLayoutLMForSequenceClassification</a> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3ForSequenceClassification">TFLayoutLMv3ForSequenceClassification</a> (LayoutLMv3 model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.TFLongformerForSequenceClassification">TFLongformerForSequenceClassification</a> (Longformer model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.TFMobileBertForSequenceClassification">TFMobileBertForSequenceClassification</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.TFMPNetForSequenceClassification">TFMPNetForSequenceClassification</a> (MPNet model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.TFOpenAIGPTForSequenceClassification">TFOpenAIGPTForSequenceClassification</a> (OpenAI GPT model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.TFRemBertForSequenceClassification">TFRemBertForSequenceClassification</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.TFRobertaForSequenceClassification">TFRobertaForSequenceClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForSequenceClassification">TFRobertaPreLayerNormForSequenceClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.TFRoFormerForSequenceClassification">TFRoFormerForSequenceClassification</a> (RoFormer model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TFTapasForSequenceClassification">TFTapasForSequenceClassification</a> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TFTransfoXLForSequenceClassification">TFTransfoXLForSequenceClassification</a> (Transformer-XL model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.TFXLMForSequenceClassification">TFXLMForSequenceClassification</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForSequenceClassification">TFXLMRobertaForSequenceClassification</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.TFXLNetForSequenceClassification">TFXLNetForSequenceClassification</a> (XLNet model)</li>',ik,ui,V0,yc,S0,Ae,Cc,lk,ib,EP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,dk,lb,NP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",mk,Kt,wc,ck,db,XP="Instantiates one of the model classes of the library (with a sequence classification head) from a configuration.",fk,mb,qP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,gk,_i,pk,or,xc,hk,cb,QP="Instantiate one of the model classes of the library (with a sequence classification head) from a pretrained model.",uk,fb,DP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,_k,gb,YP='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.FlaxAlbertForSequenceClassification">FlaxAlbertForSequenceClassification</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.FlaxBartForSequenceClassification">FlaxBartForSequenceClassification</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.FlaxBertForSequenceClassification">FlaxBertForSequenceClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.FlaxBigBirdForSequenceClassification">FlaxBigBirdForSequenceClassification</a> (BigBird model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.FlaxDistilBertForSequenceClassification">FlaxDistilBertForSequenceClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.FlaxElectraForSequenceClassification">FlaxElectraForSequenceClassification</a> (ELECTRA model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.FlaxMBartForSequenceClassification">FlaxMBartForSequenceClassification</a> (mBART model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.FlaxRobertaForSequenceClassification">FlaxRobertaForSequenceClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForSequenceClassification">FlaxRobertaPreLayerNormForSequenceClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.FlaxRoFormerForSequenceClassification">FlaxRoFormerForSequenceClassification</a> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForSequenceClassification">FlaxXLMRobertaForSequenceClassification</a> (XLM-RoBERTa model)</li>',bk,bi,P0,kc,G0,Ze,Lc,vk,pb,HP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a multiple choice head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Mk,hb,zP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Fk,en,$c,Tk,ub,OP="Instantiates one of the model classes of the library (with a multiple choice head) from a configuration.",yk,_b,KP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Ck,vi,wk,J,Bc,xk,bb,eG="Instantiate one of the model classes of the library (with a multiple choice head) from a pretrained model.",kk,vb,oG=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Lk,Mb,rG='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertForMultipleChoice">AlbertForMultipleChoice</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertForMultipleChoice">BertForMultipleChoice</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdForMultipleChoice">BigBirdForMultipleChoice</a> (BigBird model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertForMultipleChoice">CamembertForMultipleChoice</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/canine#transformers.CanineForMultipleChoice">CanineForMultipleChoice</a> (CANINE model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.ConvBertForMultipleChoice">ConvBertForMultipleChoice</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextForMultipleChoice">Data2VecTextForMultipleChoice</a> (Data2VecText model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2ForMultipleChoice">DebertaV2ForMultipleChoice</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertForMultipleChoice">DistilBertForMultipleChoice</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraForMultipleChoice">ElectraForMultipleChoice</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieForMultipleChoice">ErnieForMultipleChoice</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie_m#transformers.ErnieMForMultipleChoice">ErnieMForMultipleChoice</a> (ErnieM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertForMultipleChoice">FlaubertForMultipleChoice</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetForMultipleChoice">FNetForMultipleChoice</a> (FNet model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelForMultipleChoice">FunnelForMultipleChoice</a> (Funnel Transformer model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ibert#transformers.IBertForMultipleChoice">IBertForMultipleChoice</a> (I-BERT model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerForMultipleChoice">LongformerForMultipleChoice</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/luke#transformers.LukeForMultipleChoice">LukeForMultipleChoice</a> (LUKE model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaForMultipleChoice">MegaForMultipleChoice</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertForMultipleChoice">MegatronBertForMultipleChoice</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertForMultipleChoice">MobileBertForMultipleChoice</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetForMultipleChoice">MPNetForMultipleChoice</a> (MPNet model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mra#transformers.MraForMultipleChoice">MraForMultipleChoice</a> (MRA model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nezha#transformers.NezhaForMultipleChoice">NezhaForMultipleChoice</a> (Nezha model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nystromformer#transformers.NystromformerForMultipleChoice">NystromformerForMultipleChoice</a> (Nyströmformer model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/qdqbert#transformers.QDQBertForMultipleChoice">QDQBertForMultipleChoice</a> (QDQBert model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertForMultipleChoice">RemBertForMultipleChoice</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaForMultipleChoice">RobertaForMultipleChoice</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForMultipleChoice">RobertaPreLayerNormForMultipleChoice</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertForMultipleChoice">RoCBertForMultipleChoice</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerForMultipleChoice">RoFormerForMultipleChoice</a> (RoFormer model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertForMultipleChoice">SqueezeBertForMultipleChoice</a> (SqueezeBERT model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMForMultipleChoice">XLMForMultipleChoice</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaForMultipleChoice">XLMRobertaForMultipleChoice</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForMultipleChoice">XLMRobertaXLForMultipleChoice</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetForMultipleChoice">XLNetForMultipleChoice</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodForMultipleChoice">XmodForMultipleChoice</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/yoso#transformers.YosoForMultipleChoice">YosoForMultipleChoice</a> (YOSO model)</li>',$k,Fb,tG=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,Bk,Mi,J0,jc,I0,Re,Ac,jk,Tb,nG=`This is a generic model class that will be instantiated as one of the model classes of the library (with a multiple choice head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Ak,yb,aG="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Zk,on,Zc,Rk,Cb,sG="Instantiates one of the model classes of the library (with a multiple choice head) from a configuration.",Wk,wb,iG=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Vk,Fi,Sk,rr,Rc,Pk,xb,lG="Instantiate one of the model classes of the library (with a multiple choice head) from a pretrained model.",Gk,kb,dG=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Jk,Lb,mG='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.TFAlbertForMultipleChoice">TFAlbertForMultipleChoice</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.TFBertForMultipleChoice">TFBertForMultipleChoice</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.TFCamembertForMultipleChoice">TFCamembertForMultipleChoice</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.TFConvBertForMultipleChoice">TFConvBertForMultipleChoice</a> (ConvBERT model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.TFDebertaV2ForMultipleChoice">TFDebertaV2ForMultipleChoice</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.TFDistilBertForMultipleChoice">TFDistilBertForMultipleChoice</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.TFElectraForMultipleChoice">TFElectraForMultipleChoice</a> (ELECTRA model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.TFFlaubertForMultipleChoice">TFFlaubertForMultipleChoice</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.TFFunnelForMultipleChoice">TFFunnelForMultipleChoice</a> (Funnel Transformer model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.TFLongformerForMultipleChoice">TFLongformerForMultipleChoice</a> (Longformer model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.TFMobileBertForMultipleChoice">TFMobileBertForMultipleChoice</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.TFMPNetForMultipleChoice">TFMPNetForMultipleChoice</a> (MPNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.TFRemBertForMultipleChoice">TFRemBertForMultipleChoice</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.TFRobertaForMultipleChoice">TFRobertaForMultipleChoice</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForMultipleChoice">TFRobertaPreLayerNormForMultipleChoice</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.TFRoFormerForMultipleChoice">TFRoFormerForMultipleChoice</a> (RoFormer model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.TFXLMForMultipleChoice">TFXLMForMultipleChoice</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForMultipleChoice">TFXLMRobertaForMultipleChoice</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.TFXLNetForMultipleChoice">TFXLNetForMultipleChoice</a> (XLNet model)</li>',Ik,Ti,U0,Wc,E0,We,Vc,Uk,$b,cG=`This is a generic model class that will be instantiated as one of the model classes of the library (with a multiple choice head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Ek,Bb,fG="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Nk,rn,Sc,Xk,jb,gG="Instantiates one of the model classes of the library (with a multiple choice head) from a configuration.",qk,Ab,pG=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Qk,yi,Dk,tr,Pc,Yk,Zb,hG="Instantiate one of the model classes of the library (with a multiple choice head) from a pretrained model.",Hk,Rb,uG=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,zk,Wb,_G='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.FlaxAlbertForMultipleChoice">FlaxAlbertForMultipleChoice</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.FlaxBertForMultipleChoice">FlaxBertForMultipleChoice</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.FlaxBigBirdForMultipleChoice">FlaxBigBirdForMultipleChoice</a> (BigBird model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.FlaxDistilBertForMultipleChoice">FlaxDistilBertForMultipleChoice</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.FlaxElectraForMultipleChoice">FlaxElectraForMultipleChoice</a> (ELECTRA model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.FlaxRobertaForMultipleChoice">FlaxRobertaForMultipleChoice</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForMultipleChoice">FlaxRobertaPreLayerNormForMultipleChoice</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.FlaxRoFormerForMultipleChoice">FlaxRoFormerForMultipleChoice</a> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForMultipleChoice">FlaxXLMRobertaForMultipleChoice</a> (XLM-RoBERTa model)</li>',Ok,Ci,N0,Gc,X0,Ve,Jc,Kk,Vb,bG=`This is a generic model class that will be instantiated as one of the model classes of the library (with a next sentence prediction head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,eL,Sb,vG="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",oL,tn,Ic,rL,Pb,MG="Instantiates one of the model classes of the library (with a next sentence prediction head) from a configuration.",tL,Gb,FG=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,nL,wi,aL,I,Uc,sL,Jb,TG="Instantiate one of the model classes of the library (with a next sentence prediction head) from a pretrained model.",iL,Ib,yG=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,lL,Ub,CG='<li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertForNextSentencePrediction">BertForNextSentencePrediction</a> (BERT model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieForNextSentencePrediction">ErnieForNextSentencePrediction</a> (ERNIE model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetForNextSentencePrediction">FNetForNextSentencePrediction</a> (FNet model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertForNextSentencePrediction">MegatronBertForNextSentencePrediction</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertForNextSentencePrediction">MobileBertForNextSentencePrediction</a> (MobileBERT model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nezha#transformers.NezhaForNextSentencePrediction">NezhaForNextSentencePrediction</a> (Nezha model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/qdqbert#transformers.QDQBertForNextSentencePrediction">QDQBertForNextSentencePrediction</a> (QDQBert model)</li>',dL,Eb,wG=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,mL,xi,q0,Ec,Q0,Se,Nc,cL,Nb,xG=`This is a generic model class that will be instantiated as one of the model classes of the library (with a next sentence prediction head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,fL,Xb,kG="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",gL,nn,Xc,pL,qb,LG="Instantiates one of the model classes of the library (with a next sentence prediction head) from a configuration.",hL,Qb,$G=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,uL,ki,_L,nr,qc,bL,Db,BG="Instantiate one of the model classes of the library (with a next sentence prediction head) from a pretrained model.",vL,Yb,jG=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,ML,Hb,AG='<li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.TFBertForNextSentencePrediction">TFBertForNextSentencePrediction</a> (BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.TFMobileBertForNextSentencePrediction">TFMobileBertForNextSentencePrediction</a> (MobileBERT model)</li>',FL,Li,D0,Qc,Y0,Pe,Dc,TL,zb,ZG=`This is a generic model class that will be instantiated as one of the model classes of the library (with a next sentence prediction head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,yL,Ob,RG="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",CL,an,Yc,wL,Kb,WG="Instantiates one of the model classes of the library (with a next sentence prediction head) from a configuration.",xL,ev,VG=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,kL,$i,LL,ar,Hc,$L,ov,SG="Instantiate one of the model classes of the library (with a next sentence prediction head) from a pretrained model.",BL,rv,PG=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,jL,tv,GG='<li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.FlaxBertForNextSentencePrediction">FlaxBertForNextSentencePrediction</a> (BERT model)</li>',AL,Bi,H0,zc,z0,Ge,Oc,ZL,nv,JG=`This is a generic model class that will be instantiated as one of the model classes of the library (with a token classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,RL,av,IG="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",WL,sn,Kc,VL,sv,UG="Instantiates one of the model classes of the library (with a token classification head) from a configuration.",SL,iv,EG=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,PL,ji,GL,U,ef,JL,lv,NG="Instantiate one of the model classes of the library (with a token classification head) from a pretrained model.",IL,dv,XG=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,UL,mv,qG='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertForTokenClassification">AlbertForTokenClassification</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertForTokenClassification">BertForTokenClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdForTokenClassification">BigBirdForTokenClassification</a> (BigBird model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/biogpt#transformers.BioGptForTokenClassification">BioGptForTokenClassification</a> (BioGpt model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomForTokenClassification">BloomForTokenClassification</a> (BLOOM model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bros#transformers.BrosForTokenClassification">BrosForTokenClassification</a> (BROS model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertForTokenClassification">CamembertForTokenClassification</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/canine#transformers.CanineForTokenClassification">CanineForTokenClassification</a> (CANINE model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.ConvBertForTokenClassification">ConvBertForTokenClassification</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextForTokenClassification">Data2VecTextForTokenClassification</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaForTokenClassification">DebertaForTokenClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2ForTokenClassification">DebertaV2ForTokenClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertForTokenClassification">DistilBertForTokenClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraForTokenClassification">ElectraForTokenClassification</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieForTokenClassification">ErnieForTokenClassification</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie_m#transformers.ErnieMForTokenClassification">ErnieMForTokenClassification</a> (ErnieM model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.EsmForTokenClassification">EsmForTokenClassification</a> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/falcon#transformers.FalconForTokenClassification">FalconForTokenClassification</a> (Falcon model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertForTokenClassification">FlaubertForTokenClassification</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetForTokenClassification">FNetForTokenClassification</a> (FNet model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelForTokenClassification">FunnelForTokenClassification</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2ForTokenClassification">GPT2ForTokenClassification</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2ForTokenClassification">GPT2ForTokenClassification</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForTokenClassification">GPTBigCodeForTokenClassification</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.GPTNeoForTokenClassification">GPTNeoForTokenClassification</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox#transformers.GPTNeoXForTokenClassification">GPTNeoXForTokenClassification</a> (GPT NeoX model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ibert#transformers.IBertForTokenClassification">IBertForTokenClassification</a> (I-BERT model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMForTokenClassification">LayoutLMForTokenClassification</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv2#transformers.LayoutLMv2ForTokenClassification">LayoutLMv2ForTokenClassification</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3ForTokenClassification">LayoutLMv3ForTokenClassification</a> (LayoutLMv3 model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/lilt#transformers.LiltForTokenClassification">LiltForTokenClassification</a> (LiLT model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerForTokenClassification">LongformerForTokenClassification</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/luke#transformers.LukeForTokenClassification">LukeForTokenClassification</a> (LUKE model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/markuplm#transformers.MarkupLMForTokenClassification">MarkupLMForTokenClassification</a> (MarkupLM model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaForTokenClassification">MegaForTokenClassification</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertForTokenClassification">MegatronBertForTokenClassification</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertForTokenClassification">MobileBertForTokenClassification</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetForTokenClassification">MPNetForTokenClassification</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpt#transformers.MptForTokenClassification">MptForTokenClassification</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mra#transformers.MraForTokenClassification">MraForTokenClassification</a> (MRA model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nezha#transformers.NezhaForTokenClassification">NezhaForTokenClassification</a> (Nezha model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nystromformer#transformers.NystromformerForTokenClassification">NystromformerForTokenClassification</a> (Nyströmformer model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/phi#transformers.PhiForTokenClassification">PhiForTokenClassification</a> (Phi model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/qdqbert#transformers.QDQBertForTokenClassification">QDQBertForTokenClassification</a> (QDQBert model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertForTokenClassification">RemBertForTokenClassification</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaForTokenClassification">RobertaForTokenClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForTokenClassification">RobertaPreLayerNormForTokenClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertForTokenClassification">RoCBertForTokenClassification</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerForTokenClassification">RoFormerForTokenClassification</a> (RoFormer model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertForTokenClassification">SqueezeBertForTokenClassification</a> (SqueezeBERT model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMForTokenClassification">XLMForTokenClassification</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaForTokenClassification">XLMRobertaForTokenClassification</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForTokenClassification">XLMRobertaXLForTokenClassification</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetForTokenClassification">XLNetForTokenClassification</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodForTokenClassification">XmodForTokenClassification</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/yoso#transformers.YosoForTokenClassification">YosoForTokenClassification</a> (YOSO model)</li>',EL,cv,QG=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,NL,Ai,O0,of,K0,Je,rf,XL,fv,DG=`This is a generic model class that will be instantiated as one of the model classes of the library (with a token classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,qL,gv,YG="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",QL,ln,tf,DL,pv,HG="Instantiates one of the model classes of the library (with a token classification head) from a configuration.",YL,hv,zG=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,HL,Zi,zL,sr,nf,OL,uv,OG="Instantiate one of the model classes of the library (with a token classification head) from a pretrained model.",KL,_v,KG=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,e$,bv,eJ='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.TFAlbertForTokenClassification">TFAlbertForTokenClassification</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.TFBertForTokenClassification">TFBertForTokenClassification</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.TFCamembertForTokenClassification">TFCamembertForTokenClassification</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.TFConvBertForTokenClassification">TFConvBertForTokenClassification</a> (ConvBERT model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.TFDebertaForTokenClassification">TFDebertaForTokenClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.TFDebertaV2ForTokenClassification">TFDebertaV2ForTokenClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.TFDistilBertForTokenClassification">TFDistilBertForTokenClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.TFElectraForTokenClassification">TFElectraForTokenClassification</a> (ELECTRA model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.TFEsmForTokenClassification">TFEsmForTokenClassification</a> (ESM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.TFFlaubertForTokenClassification">TFFlaubertForTokenClassification</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.TFFunnelForTokenClassification">TFFunnelForTokenClassification</a> (Funnel Transformer model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.TFLayoutLMForTokenClassification">TFLayoutLMForTokenClassification</a> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3ForTokenClassification">TFLayoutLMv3ForTokenClassification</a> (LayoutLMv3 model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.TFLongformerForTokenClassification">TFLongformerForTokenClassification</a> (Longformer model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.TFMobileBertForTokenClassification">TFMobileBertForTokenClassification</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.TFMPNetForTokenClassification">TFMPNetForTokenClassification</a> (MPNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.TFRemBertForTokenClassification">TFRemBertForTokenClassification</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.TFRobertaForTokenClassification">TFRobertaForTokenClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForTokenClassification">TFRobertaPreLayerNormForTokenClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.TFRoFormerForTokenClassification">TFRoFormerForTokenClassification</a> (RoFormer model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.TFXLMForTokenClassification">TFXLMForTokenClassification</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForTokenClassification">TFXLMRobertaForTokenClassification</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.TFXLNetForTokenClassification">TFXLNetForTokenClassification</a> (XLNet model)</li>',o$,Ri,ew,af,ow,Ie,sf,r$,vv,oJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a token classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,t$,Mv,rJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",n$,dn,lf,a$,Fv,tJ="Instantiates one of the model classes of the library (with a token classification head) from a configuration.",s$,Tv,nJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,i$,Wi,l$,ir,df,d$,yv,aJ="Instantiate one of the model classes of the library (with a token classification head) from a pretrained model.",m$,Cv,sJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,c$,wv,iJ='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.FlaxAlbertForTokenClassification">FlaxAlbertForTokenClassification</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.FlaxBertForTokenClassification">FlaxBertForTokenClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.FlaxBigBirdForTokenClassification">FlaxBigBirdForTokenClassification</a> (BigBird model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.FlaxDistilBertForTokenClassification">FlaxDistilBertForTokenClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.FlaxElectraForTokenClassification">FlaxElectraForTokenClassification</a> (ELECTRA model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.FlaxRobertaForTokenClassification">FlaxRobertaForTokenClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForTokenClassification">FlaxRobertaPreLayerNormForTokenClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.FlaxRoFormerForTokenClassification">FlaxRoFormerForTokenClassification</a> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForTokenClassification">FlaxXLMRobertaForTokenClassification</a> (XLM-RoBERTa model)</li>',f$,Vi,rw,mf,tw,Ue,cf,g$,xv,lJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a question answering head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,p$,kv,dJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",h$,mn,ff,u$,Lv,mJ="Instantiates one of the model classes of the library (with a question answering head) from a configuration.",_$,$v,cJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,b$,Si,v$,E,gf,M$,Bv,fJ="Instantiate one of the model classes of the library (with a question answering head) from a pretrained model.",F$,jv,gJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,T$,Av,pJ='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertForQuestionAnswering">AlbertForQuestionAnswering</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartForQuestionAnswering">BartForQuestionAnswering</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertForQuestionAnswering">BertForQuestionAnswering</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdForQuestionAnswering">BigBirdForQuestionAnswering</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForQuestionAnswering">BigBirdPegasusForQuestionAnswering</a> (BigBird-Pegasus model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomForQuestionAnswering">BloomForQuestionAnswering</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertForQuestionAnswering">CamembertForQuestionAnswering</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/canine#transformers.CanineForQuestionAnswering">CanineForQuestionAnswering</a> (CANINE model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.ConvBertForQuestionAnswering">ConvBertForQuestionAnswering</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextForQuestionAnswering">Data2VecTextForQuestionAnswering</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaForQuestionAnswering">DebertaForQuestionAnswering</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2ForQuestionAnswering">DebertaV2ForQuestionAnswering</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertForQuestionAnswering">DistilBertForQuestionAnswering</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraForQuestionAnswering">ElectraForQuestionAnswering</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieForQuestionAnswering">ErnieForQuestionAnswering</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ernie_m#transformers.ErnieMForQuestionAnswering">ErnieMForQuestionAnswering</a> (ErnieM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/falcon#transformers.FalconForQuestionAnswering">FalconForQuestionAnswering</a> (Falcon model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertForQuestionAnsweringSimple">FlaubertForQuestionAnsweringSimple</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetForQuestionAnswering">FNetForQuestionAnswering</a> (FNet model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelForQuestionAnswering">FunnelForQuestionAnswering</a> (Funnel Transformer model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2ForQuestionAnswering">GPT2ForQuestionAnswering</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.GPTNeoForQuestionAnswering">GPTNeoForQuestionAnswering</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox#transformers.GPTNeoXForQuestionAnswering">GPTNeoXForQuestionAnswering</a> (GPT NeoX model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.GPTJForQuestionAnswering">GPTJForQuestionAnswering</a> (GPT-J model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/ibert#transformers.IBertForQuestionAnswering">IBertForQuestionAnswering</a> (I-BERT model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv2#transformers.LayoutLMv2ForQuestionAnswering">LayoutLMv2ForQuestionAnswering</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3ForQuestionAnswering">LayoutLMv3ForQuestionAnswering</a> (LayoutLMv3 model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/led#transformers.LEDForQuestionAnswering">LEDForQuestionAnswering</a> (LED model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/lilt#transformers.LiltForQuestionAnswering">LiltForQuestionAnswering</a> (LiLT model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerForQuestionAnswering">LongformerForQuestionAnswering</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/luke#transformers.LukeForQuestionAnswering">LukeForQuestionAnswering</a> (LUKE model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.LxmertForQuestionAnswering">LxmertForQuestionAnswering</a> (LXMERT model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/markuplm#transformers.MarkupLMForQuestionAnswering">MarkupLMForQuestionAnswering</a> (MarkupLM model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartForQuestionAnswering">MBartForQuestionAnswering</a> (mBART model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaForQuestionAnswering">MegaForQuestionAnswering</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertForQuestionAnswering">MegatronBertForQuestionAnswering</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertForQuestionAnswering">MobileBertForQuestionAnswering</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetForQuestionAnswering">MPNetForQuestionAnswering</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpt#transformers.MptForQuestionAnswering">MptForQuestionAnswering</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mra#transformers.MraForQuestionAnswering">MraForQuestionAnswering</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.MT5ForQuestionAnswering">MT5ForQuestionAnswering</a> (MT5 model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpForQuestionAnswering">MvpForQuestionAnswering</a> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nezha#transformers.NezhaForQuestionAnswering">NezhaForQuestionAnswering</a> (Nezha model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nystromformer#transformers.NystromformerForQuestionAnswering">NystromformerForQuestionAnswering</a> (Nyströmformer model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.OPTForQuestionAnswering">OPTForQuestionAnswering</a> (OPT model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/qdqbert#transformers.QDQBertForQuestionAnswering">QDQBertForQuestionAnswering</a> (QDQBert model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/reformer#transformers.ReformerForQuestionAnswering">ReformerForQuestionAnswering</a> (Reformer model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertForQuestionAnswering">RemBertForQuestionAnswering</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaForQuestionAnswering">RobertaForQuestionAnswering</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForQuestionAnswering">RobertaPreLayerNormForQuestionAnswering</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertForQuestionAnswering">RoCBertForQuestionAnswering</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerForQuestionAnswering">RoFormerForQuestionAnswering</a> (RoFormer model)</li> <li><strong>splinter</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/splinter#transformers.SplinterForQuestionAnswering">SplinterForQuestionAnswering</a> (Splinter model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertForQuestionAnswering">SqueezeBertForQuestionAnswering</a> (SqueezeBERT model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.T5ForQuestionAnswering">T5ForQuestionAnswering</a> (T5 model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/umt5#transformers.UMT5ForQuestionAnswering">UMT5ForQuestionAnswering</a> (UMT5 model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMForQuestionAnsweringSimple">XLMForQuestionAnsweringSimple</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaForQuestionAnswering">XLMRobertaForQuestionAnswering</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForQuestionAnswering">XLMRobertaXLForQuestionAnswering</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetForQuestionAnsweringSimple">XLNetForQuestionAnsweringSimple</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodForQuestionAnswering">XmodForQuestionAnswering</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/yoso#transformers.YosoForQuestionAnswering">YosoForQuestionAnswering</a> (YOSO model)</li>',y$,Zv,hJ=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,C$,Pi,nw,pf,aw,Ee,hf,w$,Rv,uJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a question answering head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,x$,Wv,_J="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",k$,cn,uf,L$,Vv,bJ="Instantiates one of the model classes of the library (with a question answering head) from a configuration.",$$,Sv,vJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,B$,Gi,j$,lr,_f,A$,Pv,MJ="Instantiate one of the model classes of the library (with a question answering head) from a pretrained model.",Z$,Gv,FJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,R$,Jv,TJ='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.TFAlbertForQuestionAnswering">TFAlbertForQuestionAnswering</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.TFBertForQuestionAnswering">TFBertForQuestionAnswering</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.TFCamembertForQuestionAnswering">TFCamembertForQuestionAnswering</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.TFConvBertForQuestionAnswering">TFConvBertForQuestionAnswering</a> (ConvBERT model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.TFDebertaForQuestionAnswering">TFDebertaForQuestionAnswering</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.TFDebertaV2ForQuestionAnswering">TFDebertaV2ForQuestionAnswering</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.TFDistilBertForQuestionAnswering">TFDistilBertForQuestionAnswering</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.TFElectraForQuestionAnswering">TFElectraForQuestionAnswering</a> (ELECTRA model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.TFFlaubertForQuestionAnsweringSimple">TFFlaubertForQuestionAnsweringSimple</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.TFFunnelForQuestionAnswering">TFFunnelForQuestionAnswering</a> (Funnel Transformer model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.TFGPTJForQuestionAnswering">TFGPTJForQuestionAnswering</a> (GPT-J model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3ForQuestionAnswering">TFLayoutLMv3ForQuestionAnswering</a> (LayoutLMv3 model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.TFLongformerForQuestionAnswering">TFLongformerForQuestionAnswering</a> (Longformer model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.TFMobileBertForQuestionAnswering">TFMobileBertForQuestionAnswering</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.TFMPNetForQuestionAnswering">TFMPNetForQuestionAnswering</a> (MPNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.TFRemBertForQuestionAnswering">TFRemBertForQuestionAnswering</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.TFRobertaForQuestionAnswering">TFRobertaForQuestionAnswering</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForQuestionAnswering">TFRobertaPreLayerNormForQuestionAnswering</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.TFRoFormerForQuestionAnswering">TFRoFormerForQuestionAnswering</a> (RoFormer model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.TFXLMForQuestionAnsweringSimple">TFXLMForQuestionAnsweringSimple</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForQuestionAnswering">TFXLMRobertaForQuestionAnswering</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.TFXLNetForQuestionAnsweringSimple">TFXLNetForQuestionAnsweringSimple</a> (XLNet model)</li>',W$,Ji,sw,bf,iw,Ne,vf,V$,Iv,yJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a question answering head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,S$,Uv,CJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",P$,fn,Mf,G$,Ev,wJ="Instantiates one of the model classes of the library (with a question answering head) from a configuration.",J$,Nv,xJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,I$,Ii,U$,dr,Ff,E$,Xv,kJ="Instantiate one of the model classes of the library (with a question answering head) from a pretrained model.",N$,qv,LJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,X$,Qv,$J='<li><strong>albert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.FlaxAlbertForQuestionAnswering">FlaxAlbertForQuestionAnswering</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.FlaxBartForQuestionAnswering">FlaxBartForQuestionAnswering</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.FlaxBertForQuestionAnswering">FlaxBertForQuestionAnswering</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.FlaxBigBirdForQuestionAnswering">FlaxBigBirdForQuestionAnswering</a> (BigBird model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.FlaxDistilBertForQuestionAnswering">FlaxDistilBertForQuestionAnswering</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.FlaxElectraForQuestionAnswering">FlaxElectraForQuestionAnswering</a> (ELECTRA model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.FlaxMBartForQuestionAnswering">FlaxMBartForQuestionAnswering</a> (mBART model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.FlaxRobertaForQuestionAnswering">FlaxRobertaForQuestionAnswering</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForQuestionAnswering">FlaxRobertaPreLayerNormForQuestionAnswering</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.FlaxRoFormerForQuestionAnswering">FlaxRoFormerForQuestionAnswering</a> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForQuestionAnswering">FlaxXLMRobertaForQuestionAnswering</a> (XLM-RoBERTa model)</li>',q$,Ui,lw,Tf,dw,yf,Cf,mw,wf,cw,xf,kf,fw,Lf,gw,$f,BJ="The following auto classes are available for the following computer vision tasks.",pw,Bf,hw,Xe,jf,Q$,Dv,jJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a depth estimation head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,D$,Yv,AJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Y$,gn,Af,H$,Hv,ZJ="Instantiates one of the model classes of the library (with a depth estimation head) from a configuration.",z$,zv,RJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,O$,Ei,K$,N,Zf,e1,Ov,WJ="Instantiate one of the model classes of the library (with a depth estimation head) from a pretrained model.",o1,Kv,VJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,r1,eM,SJ='<li><strong>dpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dpt#transformers.DPTForDepthEstimation">DPTForDepthEstimation</a> (DPT model)</li> <li><strong>glpn</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/glpn#transformers.GLPNForDepthEstimation">GLPNForDepthEstimation</a> (GLPN model)</li>',t1,oM,PJ=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,n1,Ni,uw,Rf,_w,qe,Wf,a1,rM,GJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,s1,tM,JJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",i1,pn,Vf,l1,nM,IJ="Instantiates one of the model classes of the library (with a image classification head) from a configuration.",d1,aM,UJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,m1,Xi,c1,X,Sf,f1,sM,EJ="Instantiate one of the model classes of the library (with a image classification head) from a pretrained model.",g1,iM,NJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,p1,lM,XJ='<li><strong>beit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a> (BEiT model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/bit#transformers.BitForImageClassification">BitForImageClassification</a> (BiT model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextForImageClassification">ConvNextForImageClassification</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnextv2#transformers.ConvNextV2ForImageClassification">ConvNextV2ForImageClassification</a> (ConvNeXTV2 model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/cvt#transformers.CvtForImageClassification">CvtForImageClassification</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecVisionForImageClassification">Data2VecVisionForImageClassification</a> (Data2VecVision model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deit#transformers.DeiTForImageClassification">DeiTForImageClassification</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/deit#transformers.DeiTForImageClassificationWithTeacher">DeiTForImageClassificationWithTeacher</a> (DeiT model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dinat#transformers.DinatForImageClassification">DinatForImageClassification</a> (DiNAT model)</li> <li><strong>dinov2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dinov2#transformers.Dinov2ForImageClassification">Dinov2ForImageClassification</a> (DINOv2 model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/efficientformer#transformers.EfficientFormerForImageClassification">EfficientFormerForImageClassification</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/efficientformer#transformers.EfficientFormerForImageClassificationWithTeacher">EfficientFormerForImageClassificationWithTeacher</a> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/efficientnet#transformers.EfficientNetForImageClassification">EfficientNetForImageClassification</a> (EfficientNet model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/focalnet#transformers.FocalNetForImageClassification">FocalNetForImageClassification</a> (FocalNet model)</li> <li><strong>imagegpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/imagegpt#transformers.ImageGPTForImageClassification">ImageGPTForImageClassification</a> (ImageGPT model)</li> <li><strong>levit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/levit#transformers.LevitForImageClassification">LevitForImageClassification</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/levit#transformers.LevitForImageClassificationWithTeacher">LevitForImageClassificationWithTeacher</a> (LeViT model)</li> <li><strong>mobilenet_v1</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilenet_v1#transformers.MobileNetV1ForImageClassification">MobileNetV1ForImageClassification</a> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilenet_v2#transformers.MobileNetV2ForImageClassification">MobileNetV2ForImageClassification</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevit#transformers.MobileViTForImageClassification">MobileViTForImageClassification</a> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevitv2#transformers.MobileViTV2ForImageClassification">MobileViTV2ForImageClassification</a> (MobileViTV2 model)</li> <li><strong>nat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/nat#transformers.NatForImageClassification">NatForImageClassification</a> (NAT model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/perceiver#transformers.PerceiverForImageClassificationFourier">PerceiverForImageClassificationFourier</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/perceiver#transformers.PerceiverForImageClassificationConvProcessing">PerceiverForImageClassificationConvProcessing</a> (Perceiver model)</li> <li><strong>poolformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/poolformer#transformers.PoolFormerForImageClassification">PoolFormerForImageClassification</a> (PoolFormer model)</li> <li><strong>pvt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pvt#transformers.PvtForImageClassification">PvtForImageClassification</a> (PVT model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/regnet#transformers.RegNetForImageClassification">RegNetForImageClassification</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/resnet#transformers.ResNetForImageClassification">ResNetForImageClassification</a> (ResNet model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/segformer#transformers.SegformerForImageClassification">SegformerForImageClassification</a> (SegFormer model)</li> <li><strong>swiftformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swiftformer#transformers.SwiftFormerForImageClassification">SwiftFormerForImageClassification</a> (SwiftFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swin#transformers.SwinForImageClassification">SwinForImageClassification</a> (Swin Transformer model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swinv2#transformers.Swinv2ForImageClassification">Swinv2ForImageClassification</a> (Swin Transformer V2 model)</li> <li><strong>van</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/van#transformers.VanForImageClassification">VanForImageClassification</a> (VAN model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTForImageClassification">ViTForImageClassification</a> (ViT model)</li> <li><strong>vit_hybrid</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit_hybrid#transformers.ViTHybridForImageClassification">ViTHybridForImageClassification</a> (ViT Hybrid model)</li> <li><strong>vit_msn</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit_msn#transformers.ViTMSNForImageClassification">ViTMSNForImageClassification</a> (ViTMSN model)</li>',h1,dM,qJ=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,u1,qi,bw,Pf,vw,Qe,Gf,_1,mM,QJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,b1,cM,DJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",v1,hn,Jf,M1,fM,YJ="Instantiates one of the model classes of the library (with a image classification head) from a configuration.",F1,gM,HJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,T1,Qi,y1,mr,If,C1,pM,zJ="Instantiate one of the model classes of the library (with a image classification head) from a pretrained model.",w1,hM,OJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,x1,uM,KJ='<li><strong>convnext</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.TFConvNextForImageClassification">TFConvNextForImageClassification</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/convnextv2#transformers.TFConvNextV2ForImageClassification">TFConvNextV2ForImageClassification</a> (ConvNeXTV2 model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/cvt#transformers.TFCvtForImageClassification">TFCvtForImageClassification</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.TFData2VecVisionForImageClassification">TFData2VecVisionForImageClassification</a> (Data2VecVision model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deit#transformers.TFDeiTForImageClassification">TFDeiTForImageClassification</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/deit#transformers.TFDeiTForImageClassificationWithTeacher">TFDeiTForImageClassificationWithTeacher</a> (DeiT model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/efficientformer#transformers.TFEfficientFormerForImageClassification">TFEfficientFormerForImageClassification</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/efficientformer#transformers.TFEfficientFormerForImageClassificationWithTeacher">TFEfficientFormerForImageClassificationWithTeacher</a> (EfficientFormer model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevit#transformers.TFMobileViTForImageClassification">TFMobileViTForImageClassification</a> (MobileViT model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/regnet#transformers.TFRegNetForImageClassification">TFRegNetForImageClassification</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/resnet#transformers.TFResNetForImageClassification">TFResNetForImageClassification</a> (ResNet model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/segformer#transformers.TFSegformerForImageClassification">TFSegformerForImageClassification</a> (SegFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swin#transformers.TFSwinForImageClassification">TFSwinForImageClassification</a> (Swin Transformer model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.TFViTForImageClassification">TFViTForImageClassification</a> (ViT model)</li>',k1,Di,Mw,Uf,Fw,De,Ef,L1,_M,eI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,$1,bM,oI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",B1,un,Nf,j1,vM,rI="Instantiates one of the model classes of the library (with a image classification head) from a configuration.",A1,MM,tI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Z1,Yi,R1,cr,Xf,W1,FM,nI="Instantiate one of the model classes of the library (with a image classification head) from a pretrained model.",V1,TM,aI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,S1,yM,sI='<li><strong>beit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/beit#transformers.FlaxBeitForImageClassification">FlaxBeitForImageClassification</a> (BEiT model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/regnet#transformers.FlaxRegNetForImageClassification">FlaxRegNetForImageClassification</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/resnet#transformers.FlaxResNetForImageClassification">FlaxResNetForImageClassification</a> (ResNet model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.FlaxViTForImageClassification">FlaxViTForImageClassification</a> (ViT model)</li>',P1,Hi,Tw,qf,yw,Ye,Qf,G1,CM,iI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a video classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,J1,wM,lI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",I1,_n,Df,U1,xM,dI="Instantiates one of the model classes of the library (with a video classification head) from a configuration.",E1,kM,mI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,N1,zi,X1,q,Yf,q1,LM,cI="Instantiate one of the model classes of the library (with a video classification head) from a pretrained model.",Q1,$M,fI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,D1,BM,gI='<li><strong>timesformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/timesformer#transformers.TimesformerForVideoClassification">TimesformerForVideoClassification</a> (TimeSformer model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/videomae#transformers.VideoMAEForVideoClassification">VideoMAEForVideoClassification</a> (VideoMAE model)</li> <li><strong>vivit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vivit#transformers.VivitForVideoClassification">VivitForVideoClassification</a> (ViViT model)</li>',Y1,jM,pI=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,H1,Oi,Cw,Hf,ww,He,zf,z1,AM,hI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked image modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,O1,ZM,uI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",K1,bn,Of,eB,RM,_I="Instantiates one of the model classes of the library (with a masked image modeling head) from a configuration.",oB,WM,bI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,rB,Ki,tB,Q,Kf,nB,VM,vI="Instantiate one of the model classes of the library (with a masked image modeling head) from a pretrained model.",aB,SM,MI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,sB,PM,FI='<li><strong>deit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deit#transformers.DeiTForMaskedImageModeling">DeiTForMaskedImageModeling</a> (DeiT model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/focalnet#transformers.FocalNetForMaskedImageModeling">FocalNetForMaskedImageModeling</a> (FocalNet model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swin#transformers.SwinForMaskedImageModeling">SwinForMaskedImageModeling</a> (Swin Transformer model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swinv2#transformers.Swinv2ForMaskedImageModeling">Swinv2ForMaskedImageModeling</a> (Swin Transformer V2 model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTForMaskedImageModeling">ViTForMaskedImageModeling</a> (ViT model)</li>',iB,GM,TI=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,lB,el,xw,eg,kw,ze,og,dB,JM,yI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked image modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,mB,IM,CI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",cB,vn,rg,fB,UM,wI="Instantiates one of the model classes of the library (with a masked image modeling head) from a configuration.",gB,EM,xI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,pB,ol,hB,fr,tg,uB,NM,kI="Instantiate one of the model classes of the library (with a masked image modeling head) from a pretrained model.",_B,XM,LI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,bB,qM,$I='<li><strong>deit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deit#transformers.TFDeiTForMaskedImageModeling">TFDeiTForMaskedImageModeling</a> (DeiT model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/swin#transformers.TFSwinForMaskedImageModeling">TFSwinForMaskedImageModeling</a> (Swin Transformer model)</li>',vB,rl,Lw,ng,$w,Oe,ag,MB,QM,BI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a object detection head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,FB,DM,jI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",TB,Mn,sg,yB,YM,AI="Instantiates one of the model classes of the library (with a object detection head) from a configuration.",CB,HM,ZI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,wB,tl,xB,D,ig,kB,zM,RI="Instantiate one of the model classes of the library (with a object detection head) from a pretrained model.",LB,OM,WI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,$B,KM,VI='<li><strong>conditional_detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForObjectDetection">ConditionalDetrForObjectDetection</a> (Conditional DETR model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deformable_detr#transformers.DeformableDetrForObjectDetection">DeformableDetrForObjectDetection</a> (Deformable DETR model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/deta#transformers.DetaForObjectDetection">DetaForObjectDetection</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> (DETR model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/table-transformer#transformers.TableTransformerForObjectDetection">TableTransformerForObjectDetection</a> (Table Transformer model)</li> <li><strong>yolos</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> (YOLOS model)</li>',BB,eF,SI=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,jB,nl,Bw,lg,jw,Ke,dg,AB,oF,PI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image segmentation head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,ZB,rF,GI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",RB,Fn,mg,WB,tF,JI="Instantiates one of the model classes of the library (with a image segmentation head) from a configuration.",VB,nF,II=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,SB,al,PB,Y,cg,GB,aF,UI="Instantiate one of the model classes of the library (with a image segmentation head) from a pretrained model.",JB,sF,EI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,IB,iF,NI='<li><strong>detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> (DETR model)</li>',UB,lF,XI=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,EB,sl,Aw,fg,Zw,gg,pg,Rw,hg,Ww,eo,ug,NB,dF,qI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a semantic segmentation head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,XB,mF,QI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",qB,Tn,_g,QB,cF,DI="Instantiates one of the model classes of the library (with a semantic segmentation head) from a configuration.",DB,fF,YI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,YB,il,HB,H,bg,zB,gF,HI="Instantiate one of the model classes of the library (with a semantic segmentation head) from a pretrained model.",OB,pF,zI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,KB,hF,OI='<li><strong>beit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> (BEiT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecVisionForSemanticSegmentation">Data2VecVisionForSemanticSegmentation</a> (Data2VecVision model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a> (DPT model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilenet_v2#transformers.MobileNetV2ForSemanticSegmentation">MobileNetV2ForSemanticSegmentation</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevit#transformers.MobileViTForSemanticSegmentation">MobileViTForSemanticSegmentation</a> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevitv2#transformers.MobileViTV2ForSemanticSegmentation">MobileViTV2ForSemanticSegmentation</a> (MobileViTV2 model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/segformer#transformers.SegformerForSemanticSegmentation">SegformerForSemanticSegmentation</a> (SegFormer model)</li> <li><strong>upernet</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/upernet#transformers.UperNetForSemanticSegmentation">UperNetForSemanticSegmentation</a> (UPerNet model)</li>',ej,uF,KI=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,oj,ll,Vw,vg,Sw,oo,Mg,rj,_F,eU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a semantic segmentation head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,tj,bF,oU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",nj,yn,Fg,aj,vF,rU="Instantiates one of the model classes of the library (with a semantic segmentation head) from a configuration.",sj,MF,tU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,ij,dl,lj,gr,Tg,dj,FF,nU="Instantiate one of the model classes of the library (with a semantic segmentation head) from a pretrained model.",mj,TF,aU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,cj,yF,sU='<li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.TFData2VecVisionForSemanticSegmentation">TFData2VecVisionForSemanticSegmentation</a> (Data2VecVision model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevit#transformers.TFMobileViTForSemanticSegmentation">TFMobileViTForSemanticSegmentation</a> (MobileViT model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/segformer#transformers.TFSegformerForSemanticSegmentation">TFSegformerForSemanticSegmentation</a> (SegFormer model)</li>',fj,ml,Pw,yg,Gw,ro,Cg,gj,CF,iU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a instance segmentation head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,pj,wF,lU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",hj,Cn,wg,uj,xF,dU="Instantiates one of the model classes of the library (with a instance segmentation head) from a configuration.",_j,kF,mU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,bj,cl,vj,z,xg,Mj,LF,cU="Instantiate one of the model classes of the library (with a instance segmentation head) from a pretrained model.",Fj,$F,fU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Tj,BF,gU='<li><strong>maskformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> (MaskFormer model)</li>',yj,jF,pU=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,Cj,fl,Jw,kg,Iw,to,Lg,wj,AF,hU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a universal image segmentation head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,xj,ZF,uU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",kj,wn,$g,Lj,RF,_U="Instantiates one of the model classes of the library (with a universal image segmentation head) from a configuration.",$j,WF,bU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Bj,gl,jj,O,Bg,Aj,VF,vU="Instantiate one of the model classes of the library (with a universal image segmentation head) from a pretrained model.",Zj,SF,MU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Rj,PF,FU='<li><strong>detr</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> (DETR model)</li> <li><strong>mask2former</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> (Mask2Former model)</li> <li><strong>maskformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> (MaskFormer model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/oneformer#transformers.OneFormerForUniversalSegmentation">OneFormerForUniversalSegmentation</a> (OneFormer model)</li>',Wj,GF,TU=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,Vj,pl,Uw,jg,Ew,no,Ag,Sj,JF,yU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a zero-shot image classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Pj,IF,CU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Gj,xn,Zg,Jj,UF,wU="Instantiates one of the model classes of the library (with a zero-shot image classification head) from a configuration.",Ij,EF,xU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Uj,hl,Ej,K,Rg,Nj,NF,kU="Instantiate one of the model classes of the library (with a zero-shot image classification head) from a pretrained model.",Xj,XF,LU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,qj,qF,$U='<li><strong>align</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/align#transformers.AlignModel">AlignModel</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> (AltCLIP model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip#transformers.BlipModel">BlipModel</a> (BLIP model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/chinese_clip#transformers.ChineseCLIPModel">ChineseCLIPModel</a> (Chinese-CLIP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPModel">CLIPModel</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> (CLIPSeg model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/siglip#transformers.SiglipModel">SiglipModel</a> (SigLIP model)</li>',Qj,QF,BU=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,Dj,ul,Nw,Wg,Xw,ao,Vg,Yj,DF,jU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a zero-shot image classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Hj,YF,AU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",zj,kn,Sg,Oj,HF,ZU="Instantiates one of the model classes of the library (with a zero-shot image classification head) from a configuration.",Kj,zF,RU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,eA,_l,oA,pr,Pg,rA,OF,WU="Instantiate one of the model classes of the library (with a zero-shot image classification head) from a pretrained model.",tA,KF,VU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,nA,eT,SU='<li><strong>blip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip#transformers.TFBlipModel">TFBlipModel</a> (BLIP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.TFCLIPModel">TFCLIPModel</a> (CLIP model)</li>',aA,bl,qw,Gg,Qw,so,Jg,sA,oT,PU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a zero-shot object detection head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,iA,rT,GU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",lA,Ln,Ig,dA,tT,JU="Instantiates one of the model classes of the library (with a zero-shot object detection head) from a configuration.",mA,nT,IU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,cA,vl,fA,ee,Ug,gA,aT,UU="Instantiate one of the model classes of the library (with a zero-shot object detection head) from a pretrained model.",pA,sT,EU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,hA,iT,NU='<li><strong>owlv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/owlvit#transformers.OwlViTForObjectDetection">OwlViTForObjectDetection</a> (OWL-ViT model)</li>',uA,lT,XU=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,_A,Ml,Dw,Eg,Yw,Ng,qU="The following auto classes are available for the following audio tasks.",Hw,Xg,zw,io,qg,bA,dT,QU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,vA,mT,DU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",MA,$n,Qg,FA,cT,YU="Instantiates one of the model classes of the library (with a audio classification head) from a configuration.",TA,fT,HU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,yA,Fl,CA,oe,Dg,wA,gT,zU="Instantiate one of the model classes of the library (with a audio classification head) from a pretrained model.",xA,pT,OU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,kA,hT,KU='<li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/audio-spectrogram-transformer#transformers.ASTForAudioClassification">ASTForAudioClassification</a> (Audio Spectrogram Transformer model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecAudioForSequenceClassification">Data2VecAudioForSequenceClassification</a> (Data2VecAudio model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/hubert#transformers.HubertForSequenceClassification">HubertForSequenceClassification</a> (Hubert model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/sew#transformers.SEWForSequenceClassification">SEWForSequenceClassification</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/sew-d#transformers.SEWDForSequenceClassification">SEWDForSequenceClassification</a> (SEW-D model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech#transformers.UniSpeechForSequenceClassification">UniSpeechForSequenceClassification</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatForSequenceClassification">UniSpeechSatForSequenceClassification</a> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2ForSequenceClassification">Wav2Vec2ForSequenceClassification</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertForSequenceClassification">Wav2Vec2BertForSequenceClassification</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForSequenceClassification">Wav2Vec2ConformerForSequenceClassification</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wavlm#transformers.WavLMForSequenceClassification">WavLMForSequenceClassification</a> (WavLM model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperForAudioClassification">WhisperForAudioClassification</a> (Whisper model)</li>',LA,uT,eE=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,$A,Tl,Ow,Yg,Kw,lo,Hg,BA,_T,oE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,jA,bT,rE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",AA,Bn,zg,ZA,vT,tE="Instantiates one of the model classes of the library (with a audio classification head) from a configuration.",RA,MT,nE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,WA,yl,VA,hr,Og,SA,FT,aE="Instantiate one of the model classes of the library (with a audio classification head) from a pretrained model.",PA,TT,sE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,GA,yT,iE='<li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.TFWav2Vec2ForSequenceClassification">TFWav2Vec2ForSequenceClassification</a> (Wav2Vec2 model)</li>',JA,Cl,e2,Kg,o2,mo,ep,IA,CT,lE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio frame (token) classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,UA,wT,dE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",EA,jn,op,NA,xT,mE="Instantiates one of the model classes of the library (with a audio frame (token) classification head) from a configuration.",XA,kT,cE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,qA,wl,QA,re,rp,DA,LT,fE="Instantiate one of the model classes of the library (with a audio frame (token) classification head) from a pretrained model.",YA,$T,gE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,HA,BT,pE='<li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecAudioForAudioFrameClassification">Data2VecAudioForAudioFrameClassification</a> (Data2VecAudio model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatForAudioFrameClassification">UniSpeechSatForAudioFrameClassification</a> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2ForAudioFrameClassification">Wav2Vec2ForAudioFrameClassification</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertForAudioFrameClassification">Wav2Vec2BertForAudioFrameClassification</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForAudioFrameClassification">Wav2Vec2ConformerForAudioFrameClassification</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wavlm#transformers.WavLMForAudioFrameClassification">WavLMForAudioFrameClassification</a> (WavLM model)</li>',zA,jT,hE=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,OA,xl,r2,tp,t2,co,np,KA,AT,uE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a connectionist temporal classification head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,eZ,ZT,_E="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",oZ,An,ap,rZ,RT,bE="Instantiates one of the model classes of the library (with a connectionist temporal classification head) from a configuration.",tZ,WT,vE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,nZ,kl,aZ,te,sp,sZ,VT,ME="Instantiate one of the model classes of the library (with a connectionist temporal classification head) from a pretrained model.",iZ,ST,FE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,lZ,PT,TE='<li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecAudioForCTC">Data2VecAudioForCTC</a> (Data2VecAudio model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/hubert#transformers.HubertForCTC">HubertForCTC</a> (Hubert model)</li> <li><strong>mctct</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/mctct#transformers.MCTCTForCTC">MCTCTForCTC</a> (M-CTC-T model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/sew#transformers.SEWForCTC">SEWForCTC</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/sew-d#transformers.SEWDForCTC">SEWDForCTC</a> (SEW-D model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech#transformers.UniSpeechForCTC">UniSpeechForCTC</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatForCTC">UniSpeechSatForCTC</a> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertForCTC">Wav2Vec2BertForCTC</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForCTC">Wav2Vec2ConformerForCTC</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wavlm#transformers.WavLMForCTC">WavLMForCTC</a> (WavLM model)</li>',dZ,GT,yE=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,mZ,Ll,n2,ip,a2,fo,lp,cZ,JT,CE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,fZ,IT,wE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",gZ,Zn,dp,pZ,UT,xE="Instantiates one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a configuration.",hZ,ET,kE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,uZ,$l,_Z,ne,mp,bZ,NT,LE="Instantiate one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a pretrained model.",vZ,XT,$E=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,MZ,qT,BE='<li><strong>pop2piano</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pop2piano#transformers.Pop2PianoForConditionalGeneration">Pop2PianoForConditionalGeneration</a> (Pop2Piano model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t#transformers.SeamlessM4TForSpeechToText">SeamlessM4TForSpeechToText</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForSpeechToText">SeamlessM4Tv2ForSpeechToText</a> (SeamlessM4Tv2 model)</li> <li><strong>speech-encoder-decoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderModel">SpeechEncoderDecoderModel</a> (Speech Encoder decoder model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text#transformers.Speech2TextForConditionalGeneration">Speech2TextForConditionalGeneration</a> (Speech2Text model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speecht5#transformers.SpeechT5ForSpeechToText">SpeechT5ForSpeechToText</a> (SpeechT5 model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperForConditionalGeneration">WhisperForConditionalGeneration</a> (Whisper model)</li>',FZ,QT,jE=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,TZ,Bl,s2,cp,i2,go,fp,yZ,DT,AE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,CZ,YT,ZE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",wZ,Rn,gp,xZ,HT,RE="Instantiates one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a configuration.",kZ,zT,WE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,LZ,jl,$Z,ur,pp,BZ,OT,VE="Instantiate one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a pretrained model.",jZ,KT,SE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,AZ,ey,PE='<li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text#transformers.TFSpeech2TextForConditionalGeneration">TFSpeech2TextForConditionalGeneration</a> (Speech2Text model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.TFWhisperForConditionalGeneration">TFWhisperForConditionalGeneration</a> (Whisper model)</li>',ZZ,Al,l2,hp,d2,po,up,RZ,oy,GE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,WZ,ry,JE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",VZ,Wn,_p,SZ,ty,IE="Instantiates one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a configuration.",PZ,ny,UE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,GZ,Zl,JZ,_r,bp,IZ,ay,EE="Instantiate one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a pretrained model.",UZ,sy,NE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,EZ,iy,XE='<li><strong>speech-encoder-decoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/speech-encoder-decoder#transformers.FlaxSpeechEncoderDecoderModel">FlaxSpeechEncoderDecoderModel</a> (Speech Encoder decoder model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.FlaxWhisperForConditionalGeneration">FlaxWhisperForConditionalGeneration</a> (Whisper model)</li>',NZ,Rl,m2,vp,c2,ho,Mp,XZ,ly,qE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio retrieval via x-vector head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,qZ,dy,QE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",QZ,Vn,Fp,DZ,my,DE="Instantiates one of the model classes of the library (with a audio retrieval via x-vector head) from a configuration.",YZ,cy,YE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,HZ,Wl,zZ,ae,Tp,OZ,fy,HE="Instantiate one of the model classes of the library (with a audio retrieval via x-vector head) from a pretrained model.",KZ,gy,zE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,eR,py,OE='<li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecAudioForXVector">Data2VecAudioForXVector</a> (Data2VecAudio model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatForXVector">UniSpeechSatForXVector</a> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2ForXVector">Wav2Vec2ForXVector</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertForXVector">Wav2Vec2BertForXVector</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForXVector">Wav2Vec2ConformerForXVector</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/wavlm#transformers.WavLMForXVector">WavLMForXVector</a> (WavLM model)</li>',oR,hy,KE=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,rR,Vl,f2,yp,g2,Cp,wp,p2,xp,h2,kp,Lp,u2,$p,_2,Bp,e9="The following auto classes are available for the following multimodal tasks.",b2,jp,v2,uo,Ap,tR,uy,o9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a table question answering head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,nR,_y,r9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",aR,Sn,Zp,sR,by,t9="Instantiates one of the model classes of the library (with a table question answering head) from a configuration.",iR,vy,n9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,lR,Sl,dR,se,Rp,mR,My,a9="Instantiate one of the model classes of the library (with a table question answering head) from a pretrained model.",cR,Fy,s9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,fR,Ty,i9='<li><strong>tapas</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> (TAPAS model)</li>',gR,yy,l9=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,pR,Pl,M2,Wp,F2,_o,Vp,hR,Cy,d9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a table question answering head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,uR,wy,m9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",_R,Pn,Sp,bR,xy,c9="Instantiates one of the model classes of the library (with a table question answering head) from a configuration.",vR,ky,f9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,MR,Gl,FR,br,Pp,TR,Ly,g9="Instantiate one of the model classes of the library (with a table question answering head) from a pretrained model.",yR,$y,p9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,CR,By,h9='<li><strong>tapas</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> (TAPAS model)</li>',wR,Jl,T2,Gp,y2,bo,Jp,xR,jy,u9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a document question answering head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,kR,Ay,_9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",LR,Gn,Ip,$R,Zy,b9="Instantiates one of the model classes of the library (with a document question answering head) from a configuration.",BR,Ry,v9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,jR,Il,AR,ie,Up,ZR,Wy,M9="Instantiate one of the model classes of the library (with a document question answering head) from a pretrained model.",RR,Vy,F9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,WR,Sy,T9='<li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMForQuestionAnswering">LayoutLMForQuestionAnswering</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv2#transformers.LayoutLMv2ForQuestionAnswering">LayoutLMv2ForQuestionAnswering</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3ForQuestionAnswering">LayoutLMv3ForQuestionAnswering</a> (LayoutLMv3 model)</li>',VR,Py,y9=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,SR,Ul,C2,Ep,w2,vo,Np,PR,Gy,C9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a document question answering head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,GR,Jy,w9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",JR,Jn,Xp,IR,Iy,x9="Instantiates one of the model classes of the library (with a document question answering head) from a configuration.",UR,Uy,k9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,ER,El,NR,vr,qp,XR,Ey,L9="Instantiate one of the model classes of the library (with a document question answering head) from a pretrained model.",qR,Ny,$9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,QR,Xy,B9='<li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.TFLayoutLMForQuestionAnswering">TFLayoutLMForQuestionAnswering</a> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3ForQuestionAnswering">TFLayoutLMv3ForQuestionAnswering</a> (LayoutLMv3 model)</li>',DR,Nl,x2,Qp,k2,Mo,Dp,YR,qy,j9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a visual question answering head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,HR,Qy,A9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",zR,In,Yp,OR,Dy,Z9="Instantiates one of the model classes of the library (with a visual question answering head) from a configuration.",KR,Yy,R9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,eW,Xl,oW,le,Hp,rW,Hy,W9="Instantiate one of the model classes of the library (with a visual question answering head) from a pretrained model.",tW,zy,V9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,nW,Oy,S9='<li><strong>blip-2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip-2#transformers.Blip2ForConditionalGeneration">Blip2ForConditionalGeneration</a> (BLIP-2 model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vilt#transformers.ViltForQuestionAnswering">ViltForQuestionAnswering</a> (ViLT model)</li>',aW,Ky,P9=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,sW,ql,L2,zp,$2,Fo,Op,iW,eC,G9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a vision-to-text modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,lW,oC,J9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",dW,Un,Kp,mW,rC,I9="Instantiates one of the model classes of the library (with a vision-to-text modeling head) from a configuration.",cW,tC,U9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,fW,Ql,gW,de,eh,pW,nC,E9="Instantiate one of the model classes of the library (with a vision-to-text modeling head) from a pretrained model.",hW,aC,N9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,uW,sC,X9='<li><strong>blip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip#transformers.BlipForConditionalGeneration">BlipForConditionalGeneration</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip-2#transformers.Blip2ForConditionalGeneration">Blip2ForConditionalGeneration</a> (BLIP-2 model)</li> <li><strong>git</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/git#transformers.GitForCausalLM">GitForCausalLM</a> (GIT model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/instructblip#transformers.InstructBlipForConditionalGeneration">InstructBlipForConditionalGeneration</a> (InstructBLIP model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/kosmos-2#transformers.Kosmos2ForConditionalGeneration">Kosmos2ForConditionalGeneration</a> (KOSMOS-2 model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/llava#transformers.LlavaForConditionalGeneration">LlavaForConditionalGeneration</a> (LLaVa model)</li> <li><strong>pix2struct</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/pix2struct#transformers.Pix2StructForConditionalGeneration">Pix2StructForConditionalGeneration</a> (Pix2Struct model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vipllava#transformers.VipLlavaForConditionalGeneration">VipLlavaForConditionalGeneration</a> (VipLlava model)</li> <li><strong>vision-encoder-decoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vision-encoder-decoder#transformers.VisionEncoderDecoderModel">VisionEncoderDecoderModel</a> (Vision Encoder decoder model)</li>',_W,iC,q9=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,bW,Dl,B2,oh,j2,To,rh,vW,lC,Q9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a vision-to-text modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,MW,dC,D9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",FW,En,th,TW,mC,Y9="Instantiates one of the model classes of the library (with a vision-to-text modeling head) from a configuration.",yW,cC,H9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,CW,Yl,wW,Mr,nh,xW,fC,z9="Instantiate one of the model classes of the library (with a vision-to-text modeling head) from a pretrained model.",kW,gC,O9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,LW,pC,K9='<li><strong>blip</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/blip#transformers.TFBlipForConditionalGeneration">TFBlipForConditionalGeneration</a> (BLIP model)</li> <li><strong>vision-encoder-decoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vision-encoder-decoder#transformers.TFVisionEncoderDecoderModel">TFVisionEncoderDecoderModel</a> (Vision Encoder decoder model)</li>',$W,Hl,A2,ah,Z2,yo,sh,BW,hC,eN=`This is a generic model class that will be instantiated as one of the model classes of the library (with a vision-to-text modeling head) when created
with the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,jW,uC,oN="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",AW,Nn,ih,ZW,_C,rN="Instantiates one of the model classes of the library (with a vision-to-text modeling head) from a configuration.",RW,bC,tN=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.37.0/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,WW,zl,VW,Fr,lh,SW,vC,nN="Instantiate one of the model classes of the library (with a vision-to-text modeling head) from a pretrained model.",PW,MC,aN=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,GW,FC,sN='<li><strong>vision-encoder-decoder</strong> — <a href="/docs/transformers/v4.37.0/en/model_doc/vision-encoder-decoder#transformers.FlaxVisionEncoderDecoderModel">FlaxVisionEncoderDecoderModel</a> (Vision Encoder decoder model)</li>',JW,Ol,R2,TC,W2;return c=new B({props:{title:"Auto Classes",local:"auto-classes",headingTag:"h1"}}),Cd=new L({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMik=",highlighted:'model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)',wrap:!1}}),kd=new B({props:{title:"Extending the Auto Classes",local:"extending-the-auto-classes",headingTag:"h2"}}),$d=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMEElMEFBdXRvQ29uZmlnLnJlZ2lzdGVyKCUyMm5ldy1tb2RlbCUyMiUyQyUyME5ld01vZGVsQ29uZmlnKSUwQUF1dG9Nb2RlbC5yZWdpc3RlcihOZXdNb2RlbENvbmZpZyUyQyUyME5ld01vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel

AutoConfig.register(<span class="hljs-string">&quot;new-model&quot;</span>, NewModelConfig)
AutoModel.register(NewModelConfig, NewModel)`,wrap:!1}}),ys=new V2({props:{warning:!0,$$slots:{default:[hN]},$$scope:{ctx:y}}}),jd=new B({props:{title:"AutoConfig",local:"transformers.AutoConfig",headingTag:"h2"}}),Ad=new x({props:{name:"class transformers.AutoConfig",anchor:"transformers.AutoConfig",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/configuration_auto.py#L975"}}),Zd=new x({props:{name:"from_pretrained",anchor:"transformers.AutoConfig.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoConfig.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig.save_pretrained">save_pretrained()</a> method, or the <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> method,
e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a saved configuration JSON <em>file</em>, e.g.,
<code>./my_model_directory/configuration.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download the model weights and configuration files and override the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoConfig.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoConfig.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoConfig.from_pretrained.kwargs(additional",description:`<strong>kwargs(additional</strong> keyword arguments, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs(additional"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/configuration_auto.py#L998"}}),Cs=new $({props:{anchor:"transformers.AutoConfig.from_pretrained.example",$$slots:{default:[uN]},$$scope:{ctx:y}}}),Rd=new x({props:{name:"register",anchor:"transformers.AutoConfig.register",parameters:[{name:"model_type",val:""},{name:"config",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoConfig.register.model_type",description:"<strong>model_type</strong> (<code>str</code>) &#x2014; The model type like &#x201C;bert&#x201D; or &#x201C;gpt&#x201D;.",name:"model_type"},{anchor:"transformers.AutoConfig.register.config",description:'<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014; The config to register.',name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/configuration_auto.py#L1138"}}),Wd=new B({props:{title:"AutoTokenizer",local:"transformers.AutoTokenizer",headingTag:"h2"}}),Vd=new x({props:{name:"class transformers.AutoTokenizer",anchor:"transformers.AutoTokenizer",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/tokenization_auto.py#L616"}}),Sd=new x({props:{name:"from_pretrained",anchor:"transformers.AutoTokenizer.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoTokenizer.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a predefined tokenizer hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing vocabulary files required by the tokenizer, for instance saved
using the <a href="/docs/transformers/v4.37.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a single saved vocabulary file if and only if the tokenizer only requires a
single vocabulary file (like Bert or XLNet), e.g.: <code>./my_model_directory/vocab.txt</code>. (Not
applicable to all derived classes)</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoTokenizer.from_pretrained.inputs",description:`<strong>inputs</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the Tokenizer <code>__init__()</code> method.`,name:"inputs"},{anchor:"transformers.AutoTokenizer.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
The configuration object used to determine the tokenizer class to instantiate.`,name:"config"},{anchor:"transformers.AutoTokenizer.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoTokenizer.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download the model weights and configuration files and override the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoTokenizer.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoTokenizer.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoTokenizer.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoTokenizer.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co (e.g. for
facebook/rag-token-base), specify it here.`,name:"subfolder"},{anchor:"transformers.AutoTokenizer.from_pretrained.use_fast",description:`<strong>use_fast</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Use a <a href="https://huggingface.co/docs/tokenizers/index" rel="nofollow">fast Rust-based tokenizer</a> if it is supported for
a given model. If a fast tokenizer is not available for a given model, a normal Python-based tokenizer
is returned instead.`,name:"use_fast"},{anchor:"transformers.AutoTokenizer.from_pretrained.tokenizer_type",description:`<strong>tokenizer_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Tokenizer type to be loaded.`,name:"tokenizer_type"},{anchor:"transformers.AutoTokenizer.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoTokenizer.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Will be passed to the Tokenizer <code>__init__()</code> method. Can be used to set special tokens like
<code>bos_token</code>, <code>eos_token</code>, <code>unk_token</code>, <code>sep_token</code>, <code>pad_token</code>, <code>cls_token</code>, <code>mask_token</code>,
<code>additional_special_tokens</code>. See parameters in the <code>__init__()</code> for more details.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/tokenization_auto.py#L630"}}),xs=new $({props:{anchor:"transformers.AutoTokenizer.from_pretrained.example",$$slots:{default:[_N]},$$scope:{ctx:y}}}),Pd=new x({props:{name:"register",anchor:"transformers.AutoTokenizer.register",parameters:[{name:"config_class",val:""},{name:"slow_tokenizer_class",val:" = None"},{name:"fast_tokenizer_class",val:" = None"},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoTokenizer.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoTokenizer.register.slow_tokenizer_class",description:`<strong>slow_tokenizer_class</strong> (<code>PretrainedTokenizer</code>, <em>optional</em>) &#x2014;
The slow tokenizer to register.`,name:"slow_tokenizer_class"},{anchor:"transformers.AutoTokenizer.register.fast_tokenizer_class",description:`<strong>fast_tokenizer_class</strong> (<code>PretrainedTokenizerFast</code>, <em>optional</em>) &#x2014;
The fast tokenizer to register.`,name:"fast_tokenizer_class"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/tokenization_auto.py#L847"}}),Gd=new B({props:{title:"AutoFeatureExtractor",local:"transformers.AutoFeatureExtractor",headingTag:"h2"}}),Jd=new x({props:{name:"class transformers.AutoFeatureExtractor",anchor:"transformers.AutoFeatureExtractor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/feature_extraction_auto.py#L239"}}),Id=new x({props:{name:"from_pretrained",anchor:"transformers.AutoFeatureExtractor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoFeatureExtractor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/v4.37.0/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g.,
<code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model feature extractor should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the feature extractor files and override the cached versions
if they exist.`,name:"force_download"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final feature extractor object. If <code>True</code>, then this
functions returns a <code>Tuple(feature_extractor, unused_kwargs)</code> where <em>unused_kwargs</em> is a dictionary
consisting of the key/value pairs whose keys are not feature extractor attributes: i.e., the part of
<code>kwargs</code> which has not been used to update <code>feature_extractor</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are feature extractor attributes will be used to override the
loaded values. Behavior concerning key/value pairs whose keys are <em>not</em> feature extractor attributes is
controlled by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/feature_extraction_auto.py#L253"}}),Ls=new V2({props:{$$slots:{default:[bN]},$$scope:{ctx:y}}}),$s=new $({props:{anchor:"transformers.AutoFeatureExtractor.from_pretrained.example",$$slots:{default:[vN]},$$scope:{ctx:y}}}),Ud=new x({props:{name:"register",anchor:"transformers.AutoFeatureExtractor.register",parameters:[{name:"config_class",val:""},{name:"feature_extractor_class",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoFeatureExtractor.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoFeatureExtractor.register.feature_extractor_class",description:"<strong>feature_extractor_class</strong> (<code>FeatureExtractorMixin</code>) &#x2014; The feature extractor to register.",name:"feature_extractor_class"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/feature_extraction_auto.py#L388"}}),Ed=new B({props:{title:"AutoImageProcessor",local:"transformers.AutoImageProcessor",headingTag:"h2"}}),Nd=new x({props:{name:"class transformers.AutoImageProcessor",anchor:"transformers.AutoImageProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/image_processing_auto.py#L251"}}),Xd=new x({props:{name:"from_pretrained",anchor:"transformers.AutoImageProcessor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoImageProcessor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained image_processor hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a image processor file saved using the
<a href="/docs/transformers/v4.37.0/en/main_classes/image_processor#transformers.ImageProcessingMixin.save_pretrained">save_pretrained()</a> method, e.g.,
<code>./my_model_directory/</code>.</li>
<li>a path or url to a saved image processor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoImageProcessor.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model image processor should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoImageProcessor.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the image processor files and override the cached versions if
they exist.`,name:"force_download"},{anchor:"transformers.AutoImageProcessor.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.AutoImageProcessor.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoImageProcessor.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.AutoImageProcessor.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoImageProcessor.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final image processor object. If <code>True</code>, then this
functions returns a <code>Tuple(image_processor, unused_kwargs)</code> where <em>unused_kwargs</em> is a dictionary
consisting of the key/value pairs whose keys are not image processor attributes: i.e., the part of
<code>kwargs</code> which has not been used to update <code>image_processor</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoImageProcessor.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoImageProcessor.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are image processor attributes will be used to override the
loaded values. Behavior concerning key/value pairs whose keys are <em>not</em> image processor attributes is
controlled by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/image_processing_auto.py#L265"}}),js=new V2({props:{$$slots:{default:[MN]},$$scope:{ctx:y}}}),As=new $({props:{anchor:"transformers.AutoImageProcessor.from_pretrained.example",$$slots:{default:[FN]},$$scope:{ctx:y}}}),qd=new x({props:{name:"register",anchor:"transformers.AutoImageProcessor.register",parameters:[{name:"config_class",val:""},{name:"image_processor_class",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoImageProcessor.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoImageProcessor.register.image_processor_class",description:'<strong>image_processor_class</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/image_processor#transformers.ImageProcessingMixin">ImageProcessingMixin</a>) &#x2014; The image processor to register.',name:"image_processor_class"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/image_processing_auto.py#L422"}}),Qd=new B({props:{title:"AutoProcessor",local:"transformers.AutoProcessor",headingTag:"h2"}}),Dd=new x({props:{name:"class transformers.AutoProcessor",anchor:"transformers.AutoProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/processing_auto.py#L129"}}),Yd=new x({props:{name:"from_pretrained",anchor:"transformers.AutoProcessor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoProcessor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a processor files saved using the <code>save_pretrained()</code> method,
e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoProcessor.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model feature extractor should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoProcessor.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the feature extractor files and override the cached versions
if they exist.`,name:"force_download"},{anchor:"transformers.AutoProcessor.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.AutoProcessor.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoProcessor.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.AutoProcessor.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoProcessor.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final feature extractor object. If <code>True</code>, then this
functions returns a <code>Tuple(feature_extractor, unused_kwargs)</code> where <em>unused_kwargs</em> is a dictionary
consisting of the key/value pairs whose keys are not feature extractor attributes: i.e., the part of
<code>kwargs</code> which has not been used to update <code>feature_extractor</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoProcessor.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoProcessor.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are feature extractor attributes will be used to override the
loaded values. Behavior concerning key/value pairs whose keys are <em>not</em> feature extractor attributes is
controlled by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/processing_auto.py#L143"}}),Rs=new V2({props:{$$slots:{default:[TN]},$$scope:{ctx:y}}}),Ws=new $({props:{anchor:"transformers.AutoProcessor.from_pretrained.example",$$slots:{default:[yN]},$$scope:{ctx:y}}}),Hd=new x({props:{name:"register",anchor:"transformers.AutoProcessor.register",parameters:[{name:"config_class",val:""},{name:"processor_class",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoProcessor.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoProcessor.register.processor_class",description:"<strong>processor_class</strong> (<code>FeatureExtractorMixin</code>) &#x2014; The processor to register.",name:"processor_class"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/processing_auto.py#L347"}}),zd=new B({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),Kd=new B({props:{title:"AutoModel",local:"transformers.AutoModel",headingTag:"h3"}}),em=new x({props:{name:"class transformers.AutoModel",anchor:"transformers.AutoModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/modeling_auto.py#L1304"}}),om=new x({props:{name:"from_config",anchor:"transformers.AutoModel.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModel.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/audio-spectrogram-transformer#transformers.ASTConfig">ASTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/audio-spectrogram-transformer#transformers.ASTModel">ASTModel</a> (Audio Spectrogram Transformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertModel">AlbertModel</a> (ALBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/align#transformers.AlignConfig">AlignConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/align#transformers.AlignModel">AlignModel</a> (ALIGN model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/altclip#transformers.AltCLIPConfig">AltCLIPConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> (AltCLIP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/autoformer#transformers.AutoformerConfig">AutoformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/autoformer#transformers.AutoformerModel">AutoformerModel</a> (Autoformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bark#transformers.BarkConfig">BarkConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bark#transformers.BarkModel">BarkModel</a> (Bark model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartModel">BartModel</a> (BART model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/beit#transformers.BeitModel">BeitModel</a> (BEiT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertModel">BertModel</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bert-generation#transformers.BertGenerationConfig">BertGenerationConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bert-generation#transformers.BertGenerationEncoder">BertGenerationEncoder</a> (Bert Generation model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdModel">BigBirdModel</a> (BigBird model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusConfig">BigBirdPegasusConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusModel">BigBirdPegasusModel</a> (BigBird-Pegasus model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/biogpt#transformers.BioGptConfig">BioGptConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/biogpt#transformers.BioGptModel">BioGptModel</a> (BioGpt model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bit#transformers.BitConfig">BitConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bit#transformers.BitModel">BitModel</a> (BiT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.BlenderbotModel">BlenderbotModel</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.BlenderbotSmallModel">BlenderbotSmallModel</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/blip-2#transformers.Blip2Config">Blip2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/blip-2#transformers.Blip2Model">Blip2Model</a> (BLIP-2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/blip#transformers.BlipConfig">BlipConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/blip#transformers.BlipModel">BlipModel</a> (BLIP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomModel">BloomModel</a> (BLOOM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bridgetower#transformers.BridgeTowerConfig">BridgeTowerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bridgetower#transformers.BridgeTowerModel">BridgeTowerModel</a> (BridgeTower model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bros#transformers.BrosConfig">BrosConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bros#transformers.BrosModel">BrosModel</a> (BROS model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPModel">CLIPModel</a> (CLIP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> (CLIPSeg model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPVisionConfig">CLIPVisionConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPVisionModel">CLIPVisionModel</a> (CLIPVisionModel model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.CTRLModel">CTRLModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertModel">CamembertModel</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/canine#transformers.CanineConfig">CanineConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/canine#transformers.CanineModel">CanineModel</a> (CANINE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/chinese_clip#transformers.ChineseCLIPConfig">ChineseCLIPConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/chinese_clip#transformers.ChineseCLIPModel">ChineseCLIPModel</a> (Chinese-CLIP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/clap#transformers.ClapConfig">ClapConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/clap#transformers.ClapModel">ClapModel</a> (CLAP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/clvp#transformers.ClvpConfig">ClvpConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/clvp#transformers.ClvpModelForConditionalGeneration">ClvpModelForConditionalGeneration</a> (CLVP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/codegen#transformers.CodeGenConfig">CodeGenConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/codegen#transformers.CodeGenModel">CodeGenModel</a> (CodeGen model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/conditional_detr#transformers.ConditionalDetrConfig">ConditionalDetrConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/conditional_detr#transformers.ConditionalDetrModel">ConditionalDetrModel</a> (Conditional DETR model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.ConvBertModel">ConvBertModel</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextConfig">ConvNextConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextModel">ConvNextModel</a> (ConvNeXT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/convnextv2#transformers.ConvNextV2Config">ConvNextV2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/convnextv2#transformers.ConvNextV2Model">ConvNextV2Model</a> (ConvNeXTV2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/cpmant#transformers.CpmAntConfig">CpmAntConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/cpmant#transformers.CpmAntModel">CpmAntModel</a> (CPM-Ant model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/cvt#transformers.CvtConfig">CvtConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/cvt#transformers.CvtModel">CvtModel</a> (CvT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/dpr#transformers.DPRConfig">DPRConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/dpr#transformers.DPRQuestionEncoder">DPRQuestionEncoder</a> (DPR model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/dpt#transformers.DPTConfig">DPTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/dpt#transformers.DPTModel">DPTModel</a> (DPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecAudioConfig">Data2VecAudioConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecAudioModel">Data2VecAudioModel</a> (Data2VecAudio model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextModel">Data2VecTextModel</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecVisionConfig">Data2VecVisionConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecVisionModel">Data2VecVisionModel</a> (Data2VecVision model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaModel">DebertaModel</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2Model">DebertaV2Model</a> (DeBERTa-v2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/decision_transformer#transformers.DecisionTransformerConfig">DecisionTransformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/decision_transformer#transformers.DecisionTransformerModel">DecisionTransformerModel</a> (Decision Transformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/deformable_detr#transformers.DeformableDetrConfig">DeformableDetrConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/deformable_detr#transformers.DeformableDetrModel">DeformableDetrModel</a> (Deformable DETR model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/deit#transformers.DeiTModel">DeiTModel</a> (DeiT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/deta#transformers.DetaConfig">DetaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/deta#transformers.DetaModel">DetaModel</a> (DETA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/detr#transformers.DetrModel">DetrModel</a> (DETR model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/dinat#transformers.DinatConfig">DinatConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/dinat#transformers.DinatModel">DinatModel</a> (DiNAT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/dinov2#transformers.Dinov2Config">Dinov2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/dinov2#transformers.Dinov2Model">Dinov2Model</a> (DINOv2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertModel">DistilBertModel</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/donut#transformers.DonutSwinConfig">DonutSwinConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/donut#transformers.DonutSwinModel">DonutSwinModel</a> (DonutSwin model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/efficientformer#transformers.EfficientFormerModel">EfficientFormerModel</a> (EfficientFormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/efficientnet#transformers.EfficientNetConfig">EfficientNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/efficientnet#transformers.EfficientNetModel">EfficientNetModel</a> (EfficientNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraModel">ElectraModel</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/encodec#transformers.EncodecConfig">EncodecConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a> (EnCodec model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieModel">ErnieModel</a> (ERNIE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a> (ErnieM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.EsmConfig">EsmConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.EsmModel">EsmModel</a> (ESM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetConfig">FNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetModel">FNetModel</a> (FNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/fsmt#transformers.FSMTConfig">FSMTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/fsmt#transformers.FSMTModel">FSMTModel</a> (FairSeq Machine-Translation model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/falcon#transformers.FalconModel">FalconModel</a> (Falcon model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerConfig">FastSpeech2ConformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerModel">FastSpeech2ConformerModel</a> (FastSpeech2Conformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertModel">FlaubertModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/flava#transformers.FlavaConfig">FlavaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/flava#transformers.FlavaModel">FlavaModel</a> (FLAVA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/focalnet#transformers.FocalNetConfig">FocalNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/focalnet#transformers.FocalNetModel">FocalNetModel</a> (FocalNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelModel">FunnelModel</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelBaseModel">FunnelBaseModel</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/glpn#transformers.GLPNConfig">GLPNConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a> (GLPN model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Model">GPT2Model</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig">GPTBigCodeConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_bigcode#transformers.GPTBigCodeModel">GPTBigCodeModel</a> (GPTBigCode model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.GPTJModel">GPTJModel</a> (GPT-J model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.GPTNeoConfig">GPTNeoConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.GPTNeoModel">GPTNeoModel</a> (GPT Neo model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox#transformers.GPTNeoXConfig">GPTNeoXConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox#transformers.GPTNeoXModel">GPTNeoXModel</a> (GPT NeoX model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseConfig">GPTNeoXJapaneseConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseModel">GPTNeoXJapaneseModel</a> (GPT NeoX Japanese model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseConfig">GPTSanJapaneseConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> (GPTSAN-japanese model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/git#transformers.GitConfig">GitConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/git#transformers.GitModel">GitModel</a> (GIT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/graphormer#transformers.GraphormerConfig">GraphormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/graphormer#transformers.GraphormerModel">GraphormerModel</a> (Graphormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/groupvit#transformers.GroupViTConfig">GroupViTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/groupvit#transformers.GroupViTModel">GroupViTModel</a> (GroupViT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/hubert#transformers.HubertConfig">HubertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/hubert#transformers.HubertModel">HubertModel</a> (Hubert model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/ibert#transformers.IBertConfig">IBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/ibert#transformers.IBertModel">IBertModel</a> (I-BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/idefics#transformers.IdeficsConfig">IdeficsConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a> (IDEFICS model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/imagegpt#transformers.ImageGPTConfig">ImageGPTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/imagegpt#transformers.ImageGPTModel">ImageGPTModel</a> (ImageGPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/informer#transformers.InformerConfig">InformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/informer#transformers.InformerModel">InformerModel</a> (Informer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/jukebox#transformers.JukeboxConfig">JukeboxConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/jukebox#transformers.JukeboxModel">JukeboxModel</a> (Jukebox model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/kosmos-2#transformers.Kosmos2Config">Kosmos2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/kosmos-2#transformers.Kosmos2Model">Kosmos2Model</a> (KOSMOS-2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/led#transformers.LEDConfig">LEDConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/led#transformers.LEDModel">LEDModel</a> (LED model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMModel">LayoutLMModel</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv2#transformers.LayoutLMv2Config">LayoutLMv2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv2#transformers.LayoutLMv2Model">LayoutLMv2Model</a> (LayoutLMv2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3Config">LayoutLMv3Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3Model">LayoutLMv3Model</a> (LayoutLMv3 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/levit#transformers.LevitConfig">LevitConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/levit#transformers.LevitModel">LevitModel</a> (LeViT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/lilt#transformers.LiltConfig">LiltConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/lilt#transformers.LiltModel">LiltModel</a> (LiLT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaModel">LlamaModel</a> (LLaMA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/longt5#transformers.LongT5Config">LongT5Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/longt5#transformers.LongT5Model">LongT5Model</a> (LongT5 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerModel">LongformerModel</a> (Longformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/luke#transformers.LukeConfig">LukeConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/luke#transformers.LukeModel">LukeModel</a> (LUKE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.LxmertConfig">LxmertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.LxmertModel">LxmertModel</a> (LXMERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/m2m_100#transformers.M2M100Config">M2M100Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/m2m_100#transformers.M2M100Model">M2M100Model</a> (M2M100 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartModel">MBartModel</a> (mBART model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mctct#transformers.MCTCTConfig">MCTCTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mctct#transformers.MCTCTModel">MCTCTModel</a> (M-CTC-T model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetModel">MPNetModel</a> (MPNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.MT5Config">MT5Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.MT5Model">MT5Model</a> (MT5 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.MarianModel">MarianModel</a> (Marian model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a> (MarkupLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a> (Mask2Former model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a> (MaskFormer model)</li>
<li><code>MaskFormerSwinConfig</code> configuration class: <code>MaskFormerSwinModel</code> (MaskFormerSwin model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaModel">MegaModel</a> (MEGA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertConfig">MegatronBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertModel">MegatronBertModel</a> (Megatron-BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mgp-str#transformers.MgpstrConfig">MgpstrConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mgp-str#transformers.MgpstrForSceneTextRecognition">MgpstrForSceneTextRecognition</a> (MGP-STR model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mistral#transformers.MistralConfig">MistralConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mistral#transformers.MistralModel">MistralModel</a> (Mistral model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mixtral#transformers.MixtralConfig">MixtralConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mixtral#transformers.MixtralModel">MixtralModel</a> (Mixtral model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertModel">MobileBertModel</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mobilenet_v1#transformers.MobileNetV1Config">MobileNetV1Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mobilenet_v1#transformers.MobileNetV1Model">MobileNetV1Model</a> (MobileNetV1 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mobilenet_v2#transformers.MobileNetV2Config">MobileNetV2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mobilenet_v2#transformers.MobileNetV2Model">MobileNetV2Model</a> (MobileNetV2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mobilevit#transformers.MobileViTConfig">MobileViTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevit#transformers.MobileViTModel">MobileViTModel</a> (MobileViT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mobilevitv2#transformers.MobileViTV2Config">MobileViTV2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevitv2#transformers.MobileViTV2Model">MobileViTV2Model</a> (MobileViTV2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mpt#transformers.MptConfig">MptConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mpt#transformers.MptModel">MptModel</a> (MPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mra#transformers.MraConfig">MraConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mra#transformers.MraModel">MraModel</a> (MRA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpConfig">MvpConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpModel">MvpModel</a> (MVP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/nat#transformers.NatConfig">NatConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/nat#transformers.NatModel">NatModel</a> (NAT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/nezha#transformers.NezhaConfig">NezhaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/nezha#transformers.NezhaModel">NezhaModel</a> (Nezha model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/nllb-moe#transformers.NllbMoeConfig">NllbMoeConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/nllb-moe#transformers.NllbMoeModel">NllbMoeModel</a> (NLLB-MOE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/nystromformer#transformers.NystromformerConfig">NystromformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/nystromformer#transformers.NystromformerModel">NystromformerModel</a> (Nystr&#xF6;mformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.OPTModel">OPTModel</a> (OPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a> (OneFormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTModel">OpenAIGPTModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/open-llama#transformers.OpenLlamaConfig">OpenLlamaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/open-llama#transformers.OpenLlamaModel">OpenLlamaModel</a> (OpenLlama model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/owlvit#transformers.OwlViTConfig">OwlViTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/owlvit#transformers.OwlViTModel">OwlViTModel</a> (OWL-ViT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/owlv2#transformers.Owlv2Config">Owlv2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> (OWLv2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/plbart#transformers.PLBartConfig">PLBartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/plbart#transformers.PLBartModel">PLBartModel</a> (PLBart model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/patchtsmixer#transformers.PatchTSMixerConfig">PatchTSMixerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/patchtsmixer#transformers.PatchTSMixerModel">PatchTSMixerModel</a> (PatchTSMixer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/patchtst#transformers.PatchTSTModel">PatchTSTModel</a> (PatchTST model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusConfig">PegasusConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusModel">PegasusModel</a> (Pegasus model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/pegasus_x#transformers.PegasusXConfig">PegasusXConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus_x#transformers.PegasusXModel">PegasusXModel</a> (PEGASUS-X model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> (Perceiver model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/persimmon#transformers.PersimmonConfig">PersimmonConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/persimmon#transformers.PersimmonModel">PersimmonModel</a> (Persimmon model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/phi#transformers.PhiConfig">PhiConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/phi#transformers.PhiModel">PhiModel</a> (Phi model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/poolformer#transformers.PoolFormerConfig">PoolFormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/poolformer#transformers.PoolFormerModel">PoolFormerModel</a> (PoolFormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/prophetnet#transformers.ProphetNetConfig">ProphetNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/prophetnet#transformers.ProphetNetModel">ProphetNetModel</a> (ProphetNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/pvt#transformers.PvtConfig">PvtConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/pvt#transformers.PvtModel">PvtModel</a> (PVT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/qdqbert#transformers.QDQBertConfig">QDQBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/qdqbert#transformers.QDQBertModel">QDQBertModel</a> (QDQBert model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/qwen2#transformers.Qwen2Config">Qwen2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/qwen2#transformers.Qwen2Model">Qwen2Model</a> (Qwen2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/reformer#transformers.ReformerModel">ReformerModel</a> (Reformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/regnet#transformers.RegNetModel">RegNetModel</a> (RegNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertModel">RemBertModel</a> (RemBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/resnet#transformers.ResNetModel">ResNetModel</a> (ResNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/retribert#transformers.RetriBertConfig">RetriBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/retribert#transformers.RetriBertModel">RetriBertModel</a> (RetriBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertConfig">RoCBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertModel">RoCBertModel</a> (RoCBert model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerModel">RoFormerModel</a> (RoFormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaModel">RobertaModel</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormModel">RobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/rwkv#transformers.RwkvConfig">RwkvConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/rwkv#transformers.RwkvModel">RwkvModel</a> (RWKV model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/sew#transformers.SEWConfig">SEWConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/sew#transformers.SEWModel">SEWModel</a> (SEW model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/sew-d#transformers.SEWDConfig">SEWDConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/sew-d#transformers.SEWDModel">SEWDModel</a> (SEW-D model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/sam#transformers.SamConfig">SamConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/sam#transformers.SamModel">SamModel</a> (SAM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t#transformers.SeamlessM4TConfig">SeamlessM4TConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t#transformers.SeamlessM4TModel">SeamlessM4TModel</a> (SeamlessM4T model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Config">SeamlessM4Tv2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">SeamlessM4Tv2Model</a> (SeamlessM4Tv2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/segformer#transformers.SegformerConfig">SegformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/segformer#transformers.SegformerModel">SegformerModel</a> (SegFormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/siglip#transformers.SiglipConfig">SiglipConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/siglip#transformers.SiglipModel">SiglipModel</a> (SigLIP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/siglip#transformers.SiglipVisionConfig">SiglipVisionConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/siglip#transformers.SiglipVisionModel">SiglipVisionModel</a> (SiglipVisionModel model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text#transformers.Speech2TextConfig">Speech2TextConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text#transformers.Speech2TextModel">Speech2TextModel</a> (Speech2Text model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/speecht5#transformers.SpeechT5Config">SpeechT5Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/speecht5#transformers.SpeechT5Model">SpeechT5Model</a> (SpeechT5 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a> (Splinter model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertModel">SqueezeBertModel</a> (SqueezeBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/swiftformer#transformers.SwiftFormerConfig">SwiftFormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/swiftformer#transformers.SwiftFormerModel">SwiftFormerModel</a> (SwiftFormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/swin2sr#transformers.Swin2SRConfig">Swin2SRConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/swin2sr#transformers.Swin2SRModel">Swin2SRModel</a> (Swin2SR model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/swin#transformers.SwinModel">SwinModel</a> (Swin Transformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/swinv2#transformers.Swinv2Config">Swinv2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/swinv2#transformers.Swinv2Model">Swinv2Model</a> (Swin Transformer V2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/switch_transformers#transformers.SwitchTransformersModel">SwitchTransformersModel</a> (SwitchTransformers model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.T5Model">T5Model</a> (T5 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/table-transformer#transformers.TableTransformerConfig">TableTransformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/table-transformer#transformers.TableTransformerModel">TableTransformerModel</a> (Table Transformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasModel">TapasModel</a> (TAPAS model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/time_series_transformer#transformers.TimeSeriesTransformerConfig">TimeSeriesTransformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/time_series_transformer#transformers.TimeSeriesTransformerModel">TimeSeriesTransformerModel</a> (Time Series Transformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/timesformer#transformers.TimesformerConfig">TimesformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/timesformer#transformers.TimesformerModel">TimesformerModel</a> (TimeSformer model)</li>
<li><code>TimmBackboneConfig</code> configuration class: <code>TimmBackbone</code> (TimmBackbone model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/trajectory_transformer#transformers.TrajectoryTransformerConfig">TrajectoryTransformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/trajectory_transformer#transformers.TrajectoryTransformerModel">TrajectoryTransformerModel</a> (Trajectory Transformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TransfoXLModel">TransfoXLModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/tvlt#transformers.TvltConfig">TvltConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/tvlt#transformers.TvltModel">TvltModel</a> (TVLT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/tvp#transformers.TvpConfig">TvpConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/tvp#transformers.TvpModel">TvpModel</a> (TVP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/umt5#transformers.UMT5Config">UMT5Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/umt5#transformers.UMT5Model">UMT5Model</a> (UMT5 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/unispeech#transformers.UniSpeechConfig">UniSpeechConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech#transformers.UniSpeechModel">UniSpeechModel</a> (UniSpeech model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig">UniSpeechSatConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatModel">UniSpeechSatModel</a> (UniSpeechSat model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/univnet#transformers.UnivNetConfig">UnivNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/univnet#transformers.UnivNetModel">UnivNetModel</a> (UnivNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/van#transformers.VanConfig">VanConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/van#transformers.VanModel">VanModel</a> (VAN model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTModel">ViTModel</a> (ViT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vit_hybrid#transformers.ViTHybridConfig">ViTHybridConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vit_hybrid#transformers.ViTHybridModel">ViTHybridModel</a> (ViT Hybrid model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vit_mae#transformers.ViTMAEConfig">ViTMAEConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vit_mae#transformers.ViTMAEModel">ViTMAEModel</a> (ViTMAE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vit_msn#transformers.ViTMSNConfig">ViTMSNConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vit_msn#transformers.ViTMSNModel">ViTMSNModel</a> (ViTMSN model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/videomae#transformers.VideoMAEConfig">VideoMAEConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/videomae#transformers.VideoMAEModel">VideoMAEModel</a> (VideoMAE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vilt#transformers.ViltConfig">ViltConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vilt#transformers.ViltModel">ViltModel</a> (ViLT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/visual_bert#transformers.VisualBertConfig">VisualBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/visual_bert#transformers.VisualBertModel">VisualBertModel</a> (VisualBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vitdet#transformers.VitDetConfig">VitDetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vitdet#transformers.VitDetModel">VitDetModel</a> (VitDet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vits#transformers.VitsConfig">VitsConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vits#transformers.VitsModel">VitsModel</a> (VITS model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vivit#transformers.VivitConfig">VivitConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vivit#transformers.VivitModel">VivitModel</a> (ViViT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertConfig">Wav2Vec2BertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertModel">Wav2Vec2BertModel</a> (Wav2Vec2-BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerConfig">Wav2Vec2ConformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerModel">Wav2Vec2ConformerModel</a> (Wav2Vec2-Conformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/wavlm#transformers.WavLMConfig">WavLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/wavlm#transformers.WavLMModel">WavLMModel</a> (WavLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperModel">WhisperModel</a> (Whisper model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xclip#transformers.XCLIPConfig">XCLIPConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xclip#transformers.XCLIPModel">XCLIPModel</a> (X-CLIP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.XGLMModel">XGLMModel</a> (XGLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMModel">XLMModel</a> (XLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetConfig">XLMProphetNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetModel">XLMProphetNetModel</a> (XLM-ProphetNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaModel">XLMRobertaModel</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLConfig">XLMRobertaXLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLModel">XLMRobertaXLModel</a> (XLM-RoBERTa-XL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetModel">XLNetModel</a> (XLNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodConfig">XmodConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodModel">XmodModel</a> (X-MOD model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/yolos#transformers.YolosModel">YolosModel</a> (YOLOS model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/yoso#transformers.YosoConfig">YosoConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/yoso#transformers.YosoModel">YosoModel</a> (YOSO model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L417"}}),Ss=new $({props:{anchor:"transformers.AutoModel.from_config.example",$$slots:{default:[CN]},$$scope:{ctx:y}}}),rm=new x({props:{name:"from_pretrained",anchor:"transformers.AutoModel.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModel.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModel.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModel.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModel.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModel.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModel.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModel.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModel.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModel.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModel.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L448"}}),Ps=new $({props:{anchor:"transformers.AutoModel.from_pretrained.example",$$slots:{default:[wN]},$$scope:{ctx:y}}}),tm=new B({props:{title:"TFAutoModel",local:"transformers.TFAutoModel",headingTag:"h3"}}),nm=new x({props:{name:"class transformers.TFAutoModel",anchor:"transformers.TFAutoModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/modeling_tf_auto.py#L531"}}),am=new x({props:{name:"from_config",anchor:"transformers.TFAutoModel.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModel.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.TFAlbertModel">TFAlbertModel</a> (ALBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.TFBartModel">TFBartModel</a> (BART model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.TFBertModel">TFBertModel</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.TFBlenderbotModel">TFBlenderbotModel</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.TFBlenderbotSmallModel">TFBlenderbotSmallModel</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/blip#transformers.BlipConfig">BlipConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/blip#transformers.TFBlipModel">TFBlipModel</a> (BLIP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.TFCLIPModel">TFCLIPModel</a> (CLIP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.TFCTRLModel">TFCTRLModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.TFCamembertModel">TFCamembertModel</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.TFConvBertModel">TFConvBertModel</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.ConvNextConfig">ConvNextConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/convnext#transformers.TFConvNextModel">TFConvNextModel</a> (ConvNeXT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/convnextv2#transformers.ConvNextV2Config">ConvNextV2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/convnextv2#transformers.TFConvNextV2Model">TFConvNextV2Model</a> (ConvNeXTV2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/cvt#transformers.CvtConfig">CvtConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/cvt#transformers.TFCvtModel">TFCvtModel</a> (CvT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/dpr#transformers.DPRConfig">DPRConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/dpr#transformers.TFDPRQuestionEncoder">TFDPRQuestionEncoder</a> (DPR model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecVisionConfig">Data2VecVisionConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.TFData2VecVisionModel">TFData2VecVisionModel</a> (Data2VecVision model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.TFDebertaModel">TFDebertaModel</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.TFDebertaV2Model">TFDebertaV2Model</a> (DeBERTa-v2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/deit#transformers.TFDeiTModel">TFDeiTModel</a> (DeiT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.TFDistilBertModel">TFDistilBertModel</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/efficientformer#transformers.TFEfficientFormerModel">TFEfficientFormerModel</a> (EfficientFormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.TFElectraModel">TFElectraModel</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.EsmConfig">EsmConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.TFEsmModel">TFEsmModel</a> (ESM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.TFFlaubertModel">TFFlaubertModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.TFFunnelModel">TFFunnelModel</a> or <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.TFFunnelBaseModel">TFFunnelBaseModel</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.TFGPT2Model">TFGPT2Model</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.TFGPTJModel">TFGPTJModel</a> (GPT-J model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/groupvit#transformers.GroupViTConfig">GroupViTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/groupvit#transformers.TFGroupViTModel">TFGroupViTModel</a> (GroupViT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/hubert#transformers.HubertConfig">HubertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/hubert#transformers.TFHubertModel">TFHubertModel</a> (Hubert model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/led#transformers.LEDConfig">LEDConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/led#transformers.TFLEDModel">TFLEDModel</a> (LED model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.TFLayoutLMModel">TFLayoutLMModel</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3Config">LayoutLMv3Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3Model">TFLayoutLMv3Model</a> (LayoutLMv3 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.TFLongformerModel">TFLongformerModel</a> (Longformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.LxmertConfig">LxmertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.TFLxmertModel">TFLxmertModel</a> (LXMERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.TFMBartModel">TFMBartModel</a> (mBART model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.TFMPNetModel">TFMPNetModel</a> (MPNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.MT5Config">MT5Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.TFMT5Model">TFMT5Model</a> (MT5 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.TFMarianModel">TFMarianModel</a> (Marian model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.TFMobileBertModel">TFMobileBertModel</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mobilevit#transformers.MobileViTConfig">MobileViTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mobilevit#transformers.TFMobileViTModel">TFMobileViTModel</a> (MobileViT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.TFOPTModel">TFOPTModel</a> (OPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.TFOpenAIGPTModel">TFOpenAIGPTModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusConfig">PegasusConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.TFPegasusModel">TFPegasusModel</a> (Pegasus model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/regnet#transformers.TFRegNetModel">TFRegNetModel</a> (RegNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.TFRemBertModel">TFRemBertModel</a> (RemBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/resnet#transformers.TFResNetModel">TFResNetModel</a> (ResNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.TFRoFormerModel">TFRoFormerModel</a> (RoFormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.TFRobertaModel">TFRobertaModel</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormModel">TFRobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/sam#transformers.SamConfig">SamConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/sam#transformers.TFSamModel">TFSamModel</a> (SAM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/segformer#transformers.SegformerConfig">SegformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/segformer#transformers.TFSegformerModel">TFSegformerModel</a> (SegFormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text#transformers.Speech2TextConfig">Speech2TextConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text#transformers.TFSpeech2TextModel">TFSpeech2TextModel</a> (Speech2Text model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/swin#transformers.TFSwinModel">TFSwinModel</a> (Swin Transformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.TFT5Model">TFT5Model</a> (T5 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TFTapasModel">TFTapasModel</a> (TAPAS model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TFTransfoXLModel">TFTransfoXLModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.TFViTModel">TFViTModel</a> (ViT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vit_mae#transformers.ViTMAEConfig">ViTMAEConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vit_mae#transformers.TFViTMAEModel">TFViTMAEModel</a> (ViTMAE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vision-text-dual-encoder#transformers.TFVisionTextDualEncoderModel">TFVisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.TFWav2Vec2Model">TFWav2Vec2Model</a> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.TFWhisperModel">TFWhisperModel</a> (Whisper model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.TFXGLMModel">TFXGLMModel</a> (XGLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.TFXLMModel">TFXLMModel</a> (XLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.TFXLMRobertaModel">TFXLMRobertaModel</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.TFXLNetModel">TFXLNetModel</a> (XLNet model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L417"}}),Gs=new $({props:{anchor:"transformers.TFAutoModel.from_config.example",$$slots:{default:[xN]},$$scope:{ctx:y}}}),sm=new x({props:{name:"from_pretrained",anchor:"transformers.TFAutoModel.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModel.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModel.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModel.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModel.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModel.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModel.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModel.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModel.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModel.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L448"}}),Js=new $({props:{anchor:"transformers.TFAutoModel.from_pretrained.example",$$slots:{default:[kN]},$$scope:{ctx:y}}}),im=new B({props:{title:"FlaxAutoModel",local:"transformers.FlaxAutoModel",headingTag:"h3"}}),lm=new x({props:{name:"class transformers.FlaxAutoModel",anchor:"transformers.FlaxAutoModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/modeling_flax_auto.py#L276"}}),dm=new x({props:{name:"from_config",anchor:"transformers.FlaxAutoModel.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModel.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.FlaxAlbertModel">FlaxAlbertModel</a> (ALBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.FlaxBartModel">FlaxBartModel</a> (BART model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/beit#transformers.FlaxBeitModel">FlaxBeitModel</a> (BEiT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.FlaxBertModel">FlaxBertModel</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.FlaxBigBirdModel">FlaxBigBirdModel</a> (BigBird model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.FlaxBlenderbotModel">FlaxBlenderbotModel</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.FlaxBlenderbotSmallModel">FlaxBlenderbotSmallModel</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.FlaxBloomModel">FlaxBloomModel</a> (BLOOM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/clip#transformers.FlaxCLIPModel">FlaxCLIPModel</a> (CLIP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.FlaxDistilBertModel">FlaxDistilBertModel</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.FlaxElectraModel">FlaxElectraModel</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.FlaxGPT2Model">FlaxGPT2Model</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.FlaxGPTJModel">FlaxGPTJModel</a> (GPT-J model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.GPTNeoConfig">GPTNeoConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.FlaxGPTNeoModel">FlaxGPTNeoModel</a> (GPT Neo model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.FlaxLlamaModel">FlaxLlamaModel</a> (LLaMA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/longt5#transformers.LongT5Config">LongT5Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/longt5#transformers.FlaxLongT5Model">FlaxLongT5Model</a> (LongT5 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.FlaxMBartModel">FlaxMBartModel</a> (mBART model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.MT5Config">MT5Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.FlaxMT5Model">FlaxMT5Model</a> (MT5 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.FlaxMarianModel">FlaxMarianModel</a> (Marian model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.FlaxOPTModel">FlaxOPTModel</a> (OPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusConfig">PegasusConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.FlaxPegasusModel">FlaxPegasusModel</a> (Pegasus model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/regnet#transformers.FlaxRegNetModel">FlaxRegNetModel</a> (RegNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/resnet#transformers.FlaxResNetModel">FlaxResNetModel</a> (ResNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.FlaxRoFormerModel">FlaxRoFormerModel</a> (RoFormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.FlaxRobertaModel">FlaxRobertaModel</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormModel">FlaxRobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.FlaxT5Model">FlaxT5Model</a> (T5 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vit#transformers.FlaxViTModel">FlaxViTModel</a> (ViT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vision-text-dual-encoder#transformers.FlaxVisionTextDualEncoderModel">FlaxVisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.FlaxWav2Vec2Model">FlaxWav2Vec2Model</a> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.FlaxWhisperModel">FlaxWhisperModel</a> (Whisper model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.FlaxXGLMModel">FlaxXGLMModel</a> (XGLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaModel">FlaxXLMRobertaModel</a> (XLM-RoBERTa model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L417"}}),Is=new $({props:{anchor:"transformers.FlaxAutoModel.from_config.example",$$slots:{default:[LN]},$$scope:{ctx:y}}}),mm=new x({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModel.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModel.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModel.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModel.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModel.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModel.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModel.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModel.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModel.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModel.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L448"}}),Us=new $({props:{anchor:"transformers.FlaxAutoModel.from_pretrained.example",$$slots:{default:[$N]},$$scope:{ctx:y}}}),cm=new B({props:{title:"Generic pretraining classes",local:"generic-pretraining-classes",headingTag:"h2"}}),gm=new B({props:{title:"AutoModelForPreTraining",local:"transformers.AutoModelForPreTraining",headingTag:"h3"}}),pm=new x({props:{name:"class transformers.AutoModelForPreTraining",anchor:"transformers.AutoModelForPreTraining",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/modeling_auto.py#L1311"}}),hm=new x({props:{name:"from_config",anchor:"transformers.AutoModelForPreTraining.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForPreTraining.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertForPreTraining">AlbertForPreTraining</a> (ALBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertForPreTraining">BertForPreTraining</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdForPreTraining">BigBirdForPreTraining</a> (BigBird model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertForMaskedLM">DistilBertForMaskedLM</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraForPreTraining">ElectraForPreTraining</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieForPreTraining">ErnieForPreTraining</a> (ERNIE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetConfig">FNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetForPreTraining">FNetForPreTraining</a> (FNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/fsmt#transformers.FSMTConfig">FSMTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/fsmt#transformers.FSMTForConditionalGeneration">FSMTForConditionalGeneration</a> (FairSeq Machine-Translation model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertWithLMHeadModel">FlaubertWithLMHeadModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/flava#transformers.FlavaConfig">FlavaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/flava#transformers.FlavaForPreTraining">FlavaForPreTraining</a> (FLAVA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelForPreTraining">FunnelForPreTraining</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig">GPTBigCodeConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForCausalLM">GPTBigCodeForCausalLM</a> (GPTBigCode model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseConfig">GPTSanJapaneseConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> (GPTSAN-japanese model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/ibert#transformers.IBertConfig">IBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/ibert#transformers.IBertForMaskedLM">IBertForMaskedLM</a> (I-BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/idefics#transformers.IdeficsConfig">IdeficsConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/idefics#transformers.IdeficsForVisionText2Text">IdeficsForVisionText2Text</a> (IDEFICS model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMForMaskedLM">LayoutLMForMaskedLM</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/llava#transformers.LlavaConfig">LlavaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/llava#transformers.LlavaForConditionalGeneration">LlavaForConditionalGeneration</a> (LLaVa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerForMaskedLM">LongformerForMaskedLM</a> (Longformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/luke#transformers.LukeConfig">LukeConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/luke#transformers.LukeForMaskedLM">LukeForMaskedLM</a> (LUKE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.LxmertConfig">LxmertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.LxmertForPreTraining">LxmertForPreTraining</a> (LXMERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetForMaskedLM">MPNetForMaskedLM</a> (MPNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaForMaskedLM">MegaForMaskedLM</a> (MEGA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertConfig">MegatronBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertForPreTraining">MegatronBertForPreTraining</a> (Megatron-BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertForPreTraining">MobileBertForPreTraining</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mpt#transformers.MptConfig">MptConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mpt#transformers.MptForCausalLM">MptForCausalLM</a> (MPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mra#transformers.MraConfig">MraConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mra#transformers.MraForMaskedLM">MraForMaskedLM</a> (MRA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpConfig">MvpConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpForConditionalGeneration">MvpForConditionalGeneration</a> (MVP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/nezha#transformers.NezhaConfig">NezhaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/nezha#transformers.NezhaForPreTraining">NezhaForPreTraining</a> (Nezha model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/nllb-moe#transformers.NllbMoeConfig">NllbMoeConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/nllb-moe#transformers.NllbMoeForConditionalGeneration">NllbMoeForConditionalGeneration</a> (NLLB-MOE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/retribert#transformers.RetriBertConfig">RetriBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/retribert#transformers.RetriBertModel">RetriBertModel</a> (RetriBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertConfig">RoCBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertForPreTraining">RoCBertForPreTraining</a> (RoCBert model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaForMaskedLM">RobertaForMaskedLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForMaskedLM">RobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/rwkv#transformers.RwkvConfig">RwkvConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/rwkv#transformers.RwkvForCausalLM">RwkvForCausalLM</a> (RWKV model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/splinter#transformers.SplinterForPreTraining">SplinterForPreTraining</a> (Splinter model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertForMaskedLM">SqueezeBertForMaskedLM</a> (SqueezeBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/switch_transformers#transformers.SwitchTransformersForConditionalGeneration">SwitchTransformersForConditionalGeneration</a> (SwitchTransformers model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.T5ForConditionalGeneration">T5ForConditionalGeneration</a> (T5 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasForMaskedLM">TapasForMaskedLM</a> (TAPAS model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TransfoXLLMHeadModel">TransfoXLLMHeadModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/tvlt#transformers.TvltConfig">TvltConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/tvlt#transformers.TvltForPreTraining">TvltForPreTraining</a> (TVLT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/unispeech#transformers.UniSpeechConfig">UniSpeechConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech#transformers.UniSpeechForPreTraining">UniSpeechForPreTraining</a> (UniSpeech model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig">UniSpeechSatConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/unispeech-sat#transformers.UniSpeechSatForPreTraining">UniSpeechSatForPreTraining</a> (UniSpeechSat model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vit_mae#transformers.ViTMAEConfig">ViTMAEConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vit_mae#transformers.ViTMAEForPreTraining">ViTMAEForPreTraining</a> (ViTMAE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/videomae#transformers.VideoMAEConfig">VideoMAEConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/videomae#transformers.VideoMAEForPreTraining">VideoMAEForPreTraining</a> (VideoMAE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vipllava#transformers.VipLlavaConfig">VipLlavaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vipllava#transformers.VipLlavaForConditionalGeneration">VipLlavaForConditionalGeneration</a> (VipLlava model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/visual_bert#transformers.VisualBertConfig">VisualBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/visual_bert#transformers.VisualBertForPreTraining">VisualBertForPreTraining</a> (VisualBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2ForPreTraining">Wav2Vec2ForPreTraining</a> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerConfig">Wav2Vec2ConformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForPreTraining">Wav2Vec2ConformerForPreTraining</a> (Wav2Vec2-Conformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaForMaskedLM">XLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLConfig">XLMRobertaXLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForMaskedLM">XLMRobertaXLForMaskedLM</a> (XLM-RoBERTa-XL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetLMHeadModel">XLNetLMHeadModel</a> (XLNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodConfig">XmodConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodForMaskedLM">XmodForMaskedLM</a> (X-MOD model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L417"}}),Es=new $({props:{anchor:"transformers.AutoModelForPreTraining.from_config.example",$$slots:{default:[BN]},$$scope:{ctx:y}}}),um=new x({props:{name:"from_pretrained",anchor:"transformers.AutoModelForPreTraining.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForPreTraining.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L448"}}),Ns=new $({props:{anchor:"transformers.AutoModelForPreTraining.from_pretrained.example",$$slots:{default:[jN]},$$scope:{ctx:y}}}),_m=new B({props:{title:"TFAutoModelForPreTraining",local:"transformers.TFAutoModelForPreTraining",headingTag:"h3"}}),bm=new x({props:{name:"class transformers.TFAutoModelForPreTraining",anchor:"transformers.TFAutoModelForPreTraining",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/modeling_tf_auto.py#L547"}}),vm=new x({props:{name:"from_config",anchor:"transformers.TFAutoModelForPreTraining.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForPreTraining.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.TFAlbertForPreTraining">TFAlbertForPreTraining</a> (ALBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.TFBartForConditionalGeneration">TFBartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.TFBertForPreTraining">TFBertForPreTraining</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.TFCamembertForMaskedLM">TFCamembertForMaskedLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.TFDistilBertForMaskedLM">TFDistilBertForMaskedLM</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.TFElectraForPreTraining">TFElectraForPreTraining</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.TFFlaubertWithLMHeadModel">TFFlaubertWithLMHeadModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.TFFunnelForPreTraining">TFFunnelForPreTraining</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.TFLayoutLMForMaskedLM">TFLayoutLMForMaskedLM</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.LxmertConfig">LxmertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/lxmert#transformers.TFLxmertForPreTraining">TFLxmertForPreTraining</a> (LXMERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.TFMPNetForMaskedLM">TFMPNetForMaskedLM</a> (MPNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.TFMobileBertForPreTraining">TFMobileBertForPreTraining</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.TFRobertaForMaskedLM">TFRobertaForMaskedLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForMaskedLM">TFRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.TFT5ForConditionalGeneration">TFT5ForConditionalGeneration</a> (T5 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TFTapasForMaskedLM">TFTapasForMaskedLM</a> (TAPAS model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TFTransfoXLLMHeadModel">TFTransfoXLLMHeadModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/vit_mae#transformers.ViTMAEConfig">ViTMAEConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/vit_mae#transformers.TFViTMAEForPreTraining">TFViTMAEForPreTraining</a> (ViTMAE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForMaskedLM">TFXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.TFXLNetLMHeadModel">TFXLNetLMHeadModel</a> (XLNet model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L417"}}),Xs=new $({props:{anchor:"transformers.TFAutoModelForPreTraining.from_config.example",$$slots:{default:[AN]},$$scope:{ctx:y}}}),Mm=new x({props:{name:"from_pretrained",anchor:"transformers.TFAutoModelForPreTraining.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L448"}}),qs=new $({props:{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.example",$$slots:{default:[ZN]},$$scope:{ctx:y}}}),Fm=new B({props:{title:"FlaxAutoModelForPreTraining",local:"transformers.FlaxAutoModelForPreTraining",headingTag:"h3"}}),Tm=new x({props:{name:"class transformers.FlaxAutoModelForPreTraining",anchor:"transformers.FlaxAutoModelForPreTraining",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/modeling_flax_auto.py#L283"}}),ym=new x({props:{name:"from_config",anchor:"transformers.FlaxAutoModelForPreTraining.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForPreTraining.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.FlaxAlbertForPreTraining">FlaxAlbertForPreTraining</a> (ALBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.FlaxBertForPreTraining">FlaxBertForPreTraining</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.FlaxBigBirdForPreTraining">FlaxBigBirdForPreTraining</a> (BigBird model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.FlaxElectraForPreTraining">FlaxElectraForPreTraining</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/longt5#transformers.LongT5Config">LongT5Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/longt5#transformers.FlaxLongT5ForConditionalGeneration">FlaxLongT5ForConditionalGeneration</a> (LongT5 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.FlaxMBartForConditionalGeneration">FlaxMBartForConditionalGeneration</a> (mBART model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.MT5Config">MT5Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mt5#transformers.FlaxMT5ForConditionalGeneration">FlaxMT5ForConditionalGeneration</a> (MT5 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.FlaxRoFormerForMaskedLM">FlaxRoFormerForMaskedLM</a> (RoFormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.FlaxRobertaForMaskedLM">FlaxRobertaForMaskedLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForMaskedLM">FlaxRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/t5#transformers.FlaxT5ForConditionalGeneration">FlaxT5ForConditionalGeneration</a> (T5 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.FlaxWav2Vec2ForPreTraining">FlaxWav2Vec2ForPreTraining</a> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.FlaxWhisperForConditionalGeneration">FlaxWhisperForConditionalGeneration</a> (Whisper model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForMaskedLM">FlaxXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L417"}}),Qs=new $({props:{anchor:"transformers.FlaxAutoModelForPreTraining.from_config.example",$$slots:{default:[RN]},$$scope:{ctx:y}}}),Cm=new x({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L448"}}),Ds=new $({props:{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.example",$$slots:{default:[WN]},$$scope:{ctx:y}}}),wm=new B({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),km=new B({props:{title:"AutoModelForCausalLM",local:"transformers.AutoModelForCausalLM",headingTag:"h3"}}),Lm=new x({props:{name:"class transformers.AutoModelForCausalLM",anchor:"transformers.AutoModelForCausalLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/modeling_auto.py#L1326"}}),$m=new x({props:{name:"from_config",anchor:"transformers.AutoModelForCausalLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForCausalLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartForCausalLM">BartForCausalLM</a> (BART model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertLMHeadModel">BertLMHeadModel</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bert-generation#transformers.BertGenerationConfig">BertGenerationConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bert-generation#transformers.BertGenerationDecoder">BertGenerationDecoder</a> (Bert Generation model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdForCausalLM">BigBirdForCausalLM</a> (BigBird model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusConfig">BigBirdPegasusConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForCausalLM">BigBirdPegasusForCausalLM</a> (BigBird-Pegasus model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/biogpt#transformers.BioGptConfig">BioGptConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/biogpt#transformers.BioGptForCausalLM">BioGptForCausalLM</a> (BioGpt model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot#transformers.BlenderbotForCausalLM">BlenderbotForCausalLM</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/blenderbot-small#transformers.BlenderbotSmallForCausalLM">BlenderbotSmallForCausalLM</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertForCausalLM">CamembertForCausalLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/codegen#transformers.CodeGenConfig">CodeGenConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/codegen#transformers.CodeGenForCausalLM">CodeGenForCausalLM</a> (CodeGen model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/cpmant#transformers.CpmAntConfig">CpmAntConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/cpmant#transformers.CpmAntForCausalLM">CpmAntForCausalLM</a> (CPM-Ant model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextForCausalLM">Data2VecTextForCausalLM</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraForCausalLM">ElectraForCausalLM</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieForCausalLM">ErnieForCausalLM</a> (ERNIE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/falcon#transformers.FalconForCausalLM">FalconForCausalLM</a> (Falcon model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/fuyu#transformers.FuyuConfig">FuyuConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/fuyu#transformers.FuyuForCausalLM">FuyuForCausalLM</a> (Fuyu model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig">GPTBigCodeConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForCausalLM">GPTBigCodeForCausalLM</a> (GPTBigCode model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.GPTJForCausalLM">GPTJForCausalLM</a> (GPT-J model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.GPTNeoConfig">GPTNeoConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.GPTNeoForCausalLM">GPTNeoForCausalLM</a> (GPT Neo model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox#transformers.GPTNeoXConfig">GPTNeoXConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox#transformers.GPTNeoXForCausalLM">GPTNeoXForCausalLM</a> (GPT NeoX model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseConfig">GPTNeoXJapaneseConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseForCausalLM">GPTNeoXJapaneseForCausalLM</a> (GPT NeoX Japanese model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/git#transformers.GitConfig">GitConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/git#transformers.GitForCausalLM">GitForCausalLM</a> (GIT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaForCausalLM">LlamaForCausalLM</a> (LLaMA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartForCausalLM">MBartForCausalLM</a> (mBART model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/marian#transformers.MarianForCausalLM">MarianForCausalLM</a> (Marian model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaForCausalLM">MegaForCausalLM</a> (MEGA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertConfig">MegatronBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertForCausalLM">MegatronBertForCausalLM</a> (Megatron-BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mistral#transformers.MistralConfig">MistralConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mistral#transformers.MistralForCausalLM">MistralForCausalLM</a> (Mistral model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mixtral#transformers.MixtralConfig">MixtralConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mixtral#transformers.MixtralForCausalLM">MixtralForCausalLM</a> (Mixtral model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mpt#transformers.MptConfig">MptConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mpt#transformers.MptForCausalLM">MptForCausalLM</a> (MPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a> (MusicGen model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpConfig">MvpConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpForCausalLM">MvpForCausalLM</a> (MVP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.OPTForCausalLM">OPTForCausalLM</a> (OPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/open-llama#transformers.OpenLlamaConfig">OpenLlamaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/open-llama#transformers.OpenLlamaForCausalLM">OpenLlamaForCausalLM</a> (OpenLlama model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/plbart#transformers.PLBartConfig">PLBartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/plbart#transformers.PLBartForCausalLM">PLBartForCausalLM</a> (PLBart model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusConfig">PegasusConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/pegasus#transformers.PegasusForCausalLM">PegasusForCausalLM</a> (Pegasus model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/persimmon#transformers.PersimmonConfig">PersimmonConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/persimmon#transformers.PersimmonForCausalLM">PersimmonForCausalLM</a> (Persimmon model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/phi#transformers.PhiConfig">PhiConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/phi#transformers.PhiForCausalLM">PhiForCausalLM</a> (Phi model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/prophetnet#transformers.ProphetNetConfig">ProphetNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/prophetnet#transformers.ProphetNetForCausalLM">ProphetNetForCausalLM</a> (ProphetNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/qdqbert#transformers.QDQBertConfig">QDQBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/qdqbert#transformers.QDQBertLMHeadModel">QDQBertLMHeadModel</a> (QDQBert model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/qwen2#transformers.Qwen2Config">Qwen2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/qwen2#transformers.Qwen2ForCausalLM">Qwen2ForCausalLM</a> (Qwen2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/reformer#transformers.ReformerModelWithLMHead">ReformerModelWithLMHead</a> (Reformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertForCausalLM">RemBertForCausalLM</a> (RemBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertConfig">RoCBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertForCausalLM">RoCBertForCausalLM</a> (RoCBert model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerForCausalLM">RoFormerForCausalLM</a> (RoFormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaForCausalLM">RobertaForCausalLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForCausalLM">RobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/rwkv#transformers.RwkvConfig">RwkvConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/rwkv#transformers.RwkvForCausalLM">RwkvForCausalLM</a> (RWKV model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Config">Speech2Text2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2ForCausalLM">Speech2Text2ForCausalLM</a> (Speech2Text2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/trocr#transformers.TrOCRConfig">TrOCRConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/trocr#transformers.TrOCRForCausalLM">TrOCRForCausalLM</a> (TrOCR model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TransfoXLLMHeadModel">TransfoXLLMHeadModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/whisper#transformers.WhisperForCausalLM">WhisperForCausalLM</a> (Whisper model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.XGLMForCausalLM">XGLMForCausalLM</a> (XGLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetConfig">XLMProphetNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetForCausalLM">XLMProphetNetForCausalLM</a> (XLM-ProphetNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaForCausalLM">XLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLConfig">XLMRobertaXLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForCausalLM">XLMRobertaXLForCausalLM</a> (XLM-RoBERTa-XL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetLMHeadModel">XLNetLMHeadModel</a> (XLNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodConfig">XmodConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodForCausalLM">XmodForCausalLM</a> (X-MOD model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L417"}}),Ys=new $({props:{anchor:"transformers.AutoModelForCausalLM.from_config.example",$$slots:{default:[VN]},$$scope:{ctx:y}}}),Bm=new x({props:{name:"from_pretrained",anchor:"transformers.AutoModelForCausalLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForCausalLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L448"}}),Hs=new $({props:{anchor:"transformers.AutoModelForCausalLM.from_pretrained.example",$$slots:{default:[SN]},$$scope:{ctx:y}}}),jm=new B({props:{title:"TFAutoModelForCausalLM",local:"transformers.TFAutoModelForCausalLM",headingTag:"h3"}}),Am=new x({props:{name:"class transformers.TFAutoModelForCausalLM",anchor:"transformers.TFAutoModelForCausalLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/modeling_tf_auto.py#L562"}}),Zm=new x({props:{name:"from_config",anchor:"transformers.TFAutoModelForCausalLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForCausalLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.TFBertLMHeadModel">TFBertLMHeadModel</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.TFCamembertForCausalLM">TFCamembertForCausalLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.TFGPTJForCausalLM">TFGPTJForCausalLM</a> (GPT-J model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.TFOPTForCausalLM">TFOPTForCausalLM</a> (OPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.TFRemBertForCausalLM">TFRemBertForCausalLM</a> (RemBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.TFRoFormerForCausalLM">TFRoFormerForCausalLM</a> (RoFormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.TFRobertaForCausalLM">TFRobertaForCausalLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForCausalLM">TFRobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/transfo-xl#transformers.TFTransfoXLLMHeadModel">TFTransfoXLLMHeadModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.TFXGLMForCausalLM">TFXGLMForCausalLM</a> (XGLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForCausalLM">TFXLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlnet#transformers.TFXLNetLMHeadModel">TFXLNetLMHeadModel</a> (XLNet model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L417"}}),zs=new $({props:{anchor:"transformers.TFAutoModelForCausalLM.from_config.example",$$slots:{default:[PN]},$$scope:{ctx:y}}}),Rm=new x({props:{name:"from_pretrained",anchor:"transformers.TFAutoModelForCausalLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L448"}}),Os=new $({props:{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.example",$$slots:{default:[GN]},$$scope:{ctx:y}}}),Wm=new B({props:{title:"FlaxAutoModelForCausalLM",local:"transformers.FlaxAutoModelForCausalLM",headingTag:"h3"}}),Vm=new x({props:{name:"class transformers.FlaxAutoModelForCausalLM",anchor:"transformers.FlaxAutoModelForCausalLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/modeling_flax_auto.py#L290"}}),Sm=new x({props:{name:"from_config",anchor:"transformers.FlaxAutoModelForCausalLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForCausalLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.FlaxBartForCausalLM">FlaxBartForCausalLM</a> (BART model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.FlaxBertForCausalLM">FlaxBertForCausalLM</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.FlaxBigBirdForCausalLM">FlaxBigBirdForCausalLM</a> (BigBird model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bloom#transformers.FlaxBloomForCausalLM">FlaxBloomForCausalLM</a> (BLOOM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.FlaxElectraForCausalLM">FlaxElectraForCausalLM</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt2#transformers.FlaxGPT2LMHeadModel">FlaxGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gptj#transformers.FlaxGPTJForCausalLM">FlaxGPTJForCausalLM</a> (GPT-J model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.GPTNeoConfig">GPTNeoConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/gpt_neo#transformers.FlaxGPTNeoForCausalLM">FlaxGPTNeoForCausalLM</a> (GPT Neo model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.LlamaConfig">LlamaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/llama#transformers.FlaxLlamaForCausalLM">FlaxLlamaForCausalLM</a> (LLaMA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/opt#transformers.FlaxOPTForCausalLM">FlaxOPTForCausalLM</a> (OPT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.FlaxRobertaForCausalLM">FlaxRobertaForCausalLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForCausalLM">FlaxRobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xglm#transformers.FlaxXGLMForCausalLM">FlaxXGLMForCausalLM</a> (XGLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForCausalLM">FlaxXLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L417"}}),Ks=new $({props:{anchor:"transformers.FlaxAutoModelForCausalLM.from_config.example",$$slots:{default:[JN]},$$scope:{ctx:y}}}),Pm=new x({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L448"}}),ei=new $({props:{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.example",$$slots:{default:[IN]},$$scope:{ctx:y}}}),Gm=new B({props:{title:"AutoModelForMaskedLM",local:"transformers.AutoModelForMaskedLM",headingTag:"h3"}}),Jm=new x({props:{name:"class transformers.AutoModelForMaskedLM",anchor:"transformers.AutoModelForMaskedLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/modeling_auto.py#L1333"}}),Im=new x({props:{name:"from_config",anchor:"transformers.AutoModelForMaskedLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForMaskedLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertForMaskedLM">AlbertForMaskedLM</a> (ALBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertForMaskedLM">BertForMaskedLM</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/big_bird#transformers.BigBirdForMaskedLM">BigBirdForMaskedLM</a> (BigBird model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.ConvBertForMaskedLM">ConvBertForMaskedLM</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertForMaskedLM">DistilBertForMaskedLM</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraForMaskedLM">ElectraForMaskedLM</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/ernie#transformers.ErnieForMaskedLM">ErnieForMaskedLM</a> (ERNIE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.EsmConfig">EsmConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.EsmForMaskedLM">EsmForMaskedLM</a> (ESM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetConfig">FNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/fnet#transformers.FNetForMaskedLM">FNetForMaskedLM</a> (FNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertWithLMHeadModel">FlaubertWithLMHeadModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelForMaskedLM">FunnelForMaskedLM</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/ibert#transformers.IBertConfig">IBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/ibert#transformers.IBertForMaskedLM">IBertForMaskedLM</a> (I-BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMForMaskedLM">LayoutLMForMaskedLM</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerForMaskedLM">LongformerForMaskedLM</a> (Longformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/luke#transformers.LukeConfig">LukeConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/luke#transformers.LukeForMaskedLM">LukeForMaskedLM</a> (LUKE model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mbart#transformers.MBartForConditionalGeneration">MBartForConditionalGeneration</a> (mBART model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetForMaskedLM">MPNetForMaskedLM</a> (MPNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mega#transformers.MegaForMaskedLM">MegaForMaskedLM</a> (MEGA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertConfig">MegatronBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/megatron-bert#transformers.MegatronBertForMaskedLM">MegatronBertForMaskedLM</a> (Megatron-BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertForMaskedLM">MobileBertForMaskedLM</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mra#transformers.MraConfig">MraConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mra#transformers.MraForMaskedLM">MraForMaskedLM</a> (MRA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpConfig">MvpConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mvp#transformers.MvpForConditionalGeneration">MvpForConditionalGeneration</a> (MVP model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/nezha#transformers.NezhaConfig">NezhaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/nezha#transformers.NezhaForMaskedLM">NezhaForMaskedLM</a> (Nezha model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/nystromformer#transformers.NystromformerConfig">NystromformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/nystromformer#transformers.NystromformerForMaskedLM">NystromformerForMaskedLM</a> (Nystr&#xF6;mformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/perceiver#transformers.PerceiverForMaskedLM">PerceiverForMaskedLM</a> (Perceiver model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/qdqbert#transformers.QDQBertConfig">QDQBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/qdqbert#transformers.QDQBertForMaskedLM">QDQBertForMaskedLM</a> (QDQBert model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/reformer#transformers.ReformerForMaskedLM">ReformerForMaskedLM</a> (Reformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertForMaskedLM">RemBertForMaskedLM</a> (RemBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertConfig">RoCBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roc_bert#transformers.RoCBertForMaskedLM">RoCBertForMaskedLM</a> (RoCBert model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerForMaskedLM">RoFormerForMaskedLM</a> (RoFormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaForMaskedLM">RobertaForMaskedLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForMaskedLM">RobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/squeezebert#transformers.SqueezeBertForMaskedLM">SqueezeBertForMaskedLM</a> (SqueezeBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasForMaskedLM">TapasForMaskedLM</a> (TAPAS model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <code>Wav2Vec2ForMaskedLM</code> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaForMaskedLM">XLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLConfig">XLMRobertaXLConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForMaskedLM">XLMRobertaXLForMaskedLM</a> (XLM-RoBERTa-XL model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodConfig">XmodConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xmod#transformers.XmodForMaskedLM">XmodForMaskedLM</a> (X-MOD model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/yoso#transformers.YosoConfig">YosoConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/yoso#transformers.YosoForMaskedLM">YosoForMaskedLM</a> (YOSO model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L417"}}),oi=new $({props:{anchor:"transformers.AutoModelForMaskedLM.from_config.example",$$slots:{default:[UN]},$$scope:{ctx:y}}}),Um=new x({props:{name:"from_pretrained",anchor:"transformers.AutoModelForMaskedLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L448"}}),ri=new $({props:{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.example",$$slots:{default:[EN]},$$scope:{ctx:y}}}),Em=new B({props:{title:"TFAutoModelForMaskedLM",local:"transformers.TFAutoModelForMaskedLM",headingTag:"h3"}}),Nm=new x({props:{name:"class transformers.TFAutoModelForMaskedLM",anchor:"transformers.TFAutoModelForMaskedLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/modeling_tf_auto.py#L612"}}),Xm=new x({props:{name:"from_config",anchor:"transformers.TFAutoModelForMaskedLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForMaskedLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/albert#transformers.TFAlbertForMaskedLM">TFAlbertForMaskedLM</a> (ALBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/bert#transformers.TFBertForMaskedLM">TFBertForMaskedLM</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/camembert#transformers.TFCamembertForMaskedLM">TFCamembertForMaskedLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/convbert#transformers.TFConvBertForMaskedLM">TFConvBertForMaskedLM</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/deberta#transformers.TFDebertaForMaskedLM">TFDebertaForMaskedLM</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/deberta-v2#transformers.TFDebertaV2ForMaskedLM">TFDebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/distilbert#transformers.TFDistilBertForMaskedLM">TFDistilBertForMaskedLM</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/electra#transformers.TFElectraForMaskedLM">TFElectraForMaskedLM</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.EsmConfig">EsmConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/esm#transformers.TFEsmForMaskedLM">TFEsmForMaskedLM</a> (ESM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/flaubert#transformers.TFFlaubertWithLMHeadModel">TFFlaubertWithLMHeadModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/funnel#transformers.TFFunnelForMaskedLM">TFFunnelForMaskedLM</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/layoutlm#transformers.TFLayoutLMForMaskedLM">TFLayoutLMForMaskedLM</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/longformer#transformers.TFLongformerForMaskedLM">TFLongformerForMaskedLM</a> (Longformer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mpnet#transformers.TFMPNetForMaskedLM">TFMPNetForMaskedLM</a> (MPNet model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/mobilebert#transformers.TFMobileBertForMaskedLM">TFMobileBertForMaskedLM</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/rembert#transformers.TFRemBertForMaskedLM">TFRemBertForMaskedLM</a> (RemBERT model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roformer#transformers.TFRoFormerForMaskedLM">TFRoFormerForMaskedLM</a> (RoFormer model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta#transformers.TFRobertaForMaskedLM">TFRobertaForMaskedLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForMaskedLM">TFRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/tapas#transformers.TFTapasForMaskedLM">TFTapasForMaskedLM</a> (TAPAS model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.37.0/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForMaskedLM">TFXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/models/auto/auto_factory.py#L417"}}),ti=new $({props:{anchor:"transformers.TFAutoModelForMaskedLM.from_config.example",$$slots:{default:[NN]},$$scope:{ctx:y}}}),qm=new x({props:{name:"from_pretrained",anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.37.0/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<co