import{s as pt,n as ot,o as ct}from"../chunks/scheduler.25b97de1.js";import{S as ft,i as dt,g as i,s as l,r as p,A as ht,h as r,f as a,c as n,j as it,u as o,x as c,k as rt,y as mt,a as s,v as f,d,t as h,w as m}from"../chunks/index.d9030fc9.js";import{C as y}from"../chunks/CodeBlock.e6cd0d95.js";import{H as g,E as ut}from"../chunks/EditOnGithub.91d95064.js";function gt(Ie){let u,ae,ee,se,w,le,_,Xe='<a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api/" rel="nofollow">Fully Sharded Data Parallel (FSDP)</a> is a data parallel method that shards a model’s parameters, gradients and optimizer states across the number of available GPUs (also called workers or <em>rank</em>). Unlike <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow">DistributedDataParallel (DDP)</a>, FSDP reduces memory-usage because a model is replicated on each GPU. This improves GPU memory-efficiency and allows you to train much larger models on fewer GPUs. FSDP is integrated with the Accelerate, a library for easily managing training in distributed environments, which means it is available for use from the <a href="/docs/transformers/v4.41.2/en/main_classes/trainer#transformers.Trainer">Trainer</a> class.',ne,T,Ge="Before you start, make sure Accelerate is installed and at least PyTorch 2.1.0 or newer.",ie,$,re,b,pe,M,ze='To start, run the <a href="https://huggingface.co/docs/accelerate/package_reference/cli#accelerate-config" rel="nofollow"><code>accelerate config</code></a> command to create a configuration file for your training environment. Accelerate uses this configuration file to automatically setup the correct training environment based on your selected training options in <code>accelerate config</code>.',oe,U,ce,j,Le='When you run <code>accelerate config</code>, you’ll be prompted with a series of options to configure your training environment. This section covers some of the most important FSDP options. To learn more about the other available FSDP options, take a look at the <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments.fsdp_config" rel="nofollow">fsdp_config</a> parameters.',fe,F,de,Z,Ee="FSDP offers a number of sharding strategies to select from:",he,J,Ye="<li><code>FULL_SHARD</code> - shards model parameters, gradients and optimizer states across workers; select <code>1</code> for this option</li> <li><code>SHARD_GRAD_OP</code>- shard gradients and optimizer states across workers; select <code>2</code> for this option</li> <li><code>NO_SHARD</code> - don’t shard anything (this is equivalent to DDP); select <code>3</code> for this option</li> <li><code>HYBRID_SHARD</code> - shard model parameters, gradients and optimizer states within each worker where each worker also has a full copy; select <code>4</code> for this option</li> <li><code>HYBRID_SHARD_ZERO2</code> - shard gradients and optimizer states within each worker where each worker also has a full copy; select <code>5</code> for this option</li>",me,v,Ae="This is enabled by the <code>fsdp_sharding_strategy</code> flag.",ue,B,ge,P,Ve="You could also offload parameters and gradients when they are not in use to the CPU to save even more GPU memory and help you fit large models where even FSDP may not be sufficient. This is enabled by setting <code>fsdp_offload_params: true</code> when running <code>accelerate config</code>.",ye,S,we,H,Qe="FSDP is applied by wrapping each layer in the network. The wrapping is usually applied in a nested way where the full weights are discarded after each forward pass to save memory for use in the next layer. The <em>auto wrapping</em> policy is the simplest way to implement this and you don’t need to change any code. You should select <code>fsdp_auto_wrap_policy: TRANSFORMER_BASED_WRAP</code> to wrap a Transformer layer and <code>fsdp_transformer_layer_cls_to_wrap</code> to specify which layer to wrap (for example <code>BertLayer</code>).",_e,C,qe="Otherwise, you can choose a size-based wrapping policy where FSDP is applied to a layer if it exceeds a certain number of parameters. This is enabled by setting <code>fsdp_wrap_policy: SIZE_BASED_WRAP</code> and <code>min_num_param</code> to the desired size threshold.",Te,k,$e,x,Oe='Intermediate checkpoints should be saved with <code>fsdp_state_dict_type: SHARDED_STATE_DICT</code> because saving the full state dict with CPU offloading on rank 0 takes a lot of time and often results in <code>NCCL Timeout</code> errors due to indefinite hanging during broadcasting. You can resume training with the sharded state dicts with the <a href="https://huggingface.co/docs/accelerate/v0.30.1/en/package_reference/accelerator#accelerate.Accelerator.load_state" rel="nofollow">load_state</a>` method.',be,N,Me,R,Ke="However, when training ends, you want to save the full state dict because sharded state dict is only compatible with FSDP.",Ue,W,je,D,Fe,I,et='<a href="https://pytorch.org/xla/release/2.1/index.html" rel="nofollow">PyTorch XLA</a> supports FSDP training for TPUs and it can be enabled by modifying the FSDP configuration file generated by <code>accelerate config</code>. In addition to the sharding strategies and wrapping options specified above, you can add the parameters shown below to the file.',Ze,X,Je,G,tt='The <a href="https://github.com/pytorch/xla/blob/2e6e183e0724818f137c8135b34ef273dea33318/torch_xla/distributed/fsdp/xla_fully_sharded_data_parallel.py#L128" rel="nofollow"><code>xla_fsdp_settings</code></a> allow you to configure additional XLA-specific parameters for FSDP.',ve,z,Be,L,at="An example FSDP configuration file may look like:",Pe,E,Se,Y,st='To launch training, run the <a href="https://huggingface.co/docs/accelerate/package_reference/cli#accelerate-launch" rel="nofollow"><code>accelerate launch</code></a> command and it’ll automatically use the configuration file you previously created with <code>accelerate config</code>.',He,A,Ce,V,ke,Q,xe,q,lt="FSDP can be a powerful tool for training really large models and you have access to more than one GPU or TPU. By sharding the model parameters, optimizer and gradient states, and even offloading them to the CPU when they’re inactive, FSDP can reduce the high cost of large-scale training. If you’re interested in learning more, the following may be helpful:",Ne,O,nt='<li>Follow along with the more in-depth Accelerate guide for <a href="https://huggingface.co/docs/accelerate/usage_guides/fsdp" rel="nofollow">FSDP</a>.</li> <li>Read the <a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api/" rel="nofollow">Introducing PyTorch Fully Sharded Data Parallel (FSDP) API</a> blog post.</li> <li>Read the <a href="https://pytorch.org/blog/scaling-pytorch-models-on-cloud-tpus-with-fsdp/" rel="nofollow">Scaling PyTorch models on Cloud TPUs with FSDP</a> blog post.</li>',Re,K,We,te,De;return w=new g({props:{title:"Fully Sharded Data Parallel",local:"fully-sharded-data-parallel",headingTag:"h1"}}),$=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGU=",highlighted:"pip install accelerate",wrap:!1}}),b=new g({props:{title:"FSDP configuration",local:"fsdp-configuration",headingTag:"h2"}}),U=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),F=new g({props:{title:"Sharding strategy",local:"sharding-strategy",headingTag:"h3"}}),B=new g({props:{title:"CPU offload",local:"cpu-offload",headingTag:"h3"}}),S=new g({props:{title:"Wrapping policy",local:"wrapping-policy",headingTag:"h3"}}),k=new g({props:{title:"Checkpointing",local:"checkpointing",headingTag:"h3"}}),N=new y({props:{code:"JTIzJTIwZGlyZWN0b3J5JTIwY29udGFpbmluZyUyMGNoZWNrcG9pbnRzJTBBYWNjZWxlcmF0b3IubG9hZF9zdGF0ZSglMjJja3B0JTIyKQ==",highlighted:`<span class="hljs-comment"># directory containing checkpoints</span>
accelerator.load_state(<span class="hljs-string">&quot;ckpt&quot;</span>)`,wrap:!1}}),W=new y({props:{code:"aWYlMjB0cmFpbmVyLmlzX2ZzZHBfZW5hYmxlZCUzQSUwQSUyMCUyMCUyMCUyMHRyYWluZXIuYWNjZWxlcmF0b3Iuc3RhdGUuZnNkcF9wbHVnaW4uc2V0X3N0YXRlX2RpY3RfdHlwZSglMjJGVUxMX1NUQVRFX0RJQ1QlMjIpJTBBJTBBdHJhaW5lci5zYXZlX21vZGVsKHNjcmlwdF9hcmdzLm91dHB1dF9kaXIp",highlighted:`<span class="hljs-keyword">if</span> trainer.is_fsdp_enabled:
    trainer.accelerator.state.fsdp_plugin.set_state_dict_type(<span class="hljs-string">&quot;FULL_STATE_DICT&quot;</span>)

trainer.save_model(script_args.output_dir)`,wrap:!1}}),D=new g({props:{title:"TPU",local:"tpu",headingTag:"h3"}}),X=new y({props:{code:"eGxhJTNBJTIwVHJ1ZSUyMCUyMyUyMG11c3QlMjBiZSUyMHNldCUyMHRvJTIwVHJ1ZSUyMHRvJTIwZW5hYmxlJTIwUHlUb3JjaCUyRlhMQSUwQXhsYV9mc2RwX3NldHRpbmdzJTNBJTIwJTIzJTIwWExBLXNwZWNpZmljJTIwRlNEUCUyMHBhcmFtZXRlcnMlMEF4bGFfZnNkcF9ncmFkX2NrcHQlM0ElMjBUcnVlJTIwJTIzJTIwdXNlJTIwZ3JhZGllbnQlMjBjaGVja3BvaW50aW5n",highlighted:`<span class="hljs-attr">xla:</span> <span class="hljs-literal">True</span> <span class="hljs-comment"># must be set to True to enable PyTorch/XLA</span>
<span class="hljs-attr">xla_fsdp_settings:</span> <span class="hljs-comment"># XLA-specific FSDP parameters</span>
<span class="hljs-attr">xla_fsdp_grad_ckpt:</span> <span class="hljs-literal">True</span> <span class="hljs-comment"># use gradient checkpointing</span>`,wrap:!1}}),z=new g({props:{title:"Launch training",local:"launch-training",headingTag:"h2"}}),E=new y({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWJ1ZyUzQSUyMGZhbHNlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMEZTRFAlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQWZzZHBfY29uZmlnJTNBJTBBJTIwJTIwZnNkcF9hdXRvX3dyYXBfcG9saWN5JTNBJTIwVFJBTlNGT1JNRVJfQkFTRURfV1JBUCUwQSUyMCUyMGZzZHBfYmFja3dhcmRfcHJlZmV0Y2hfcG9saWN5JTNBJTIwQkFDS1dBUkRfUFJFJTBBJTIwJTIwZnNkcF9jcHVfcmFtX2VmZmljaWVudF9sb2FkaW5nJTNBJTIwdHJ1ZSUwQSUyMCUyMGZzZHBfZm9yd2FyZF9wcmVmZXRjaCUzQSUyMGZhbHNlJTBBJTIwJTIwZnNkcF9vZmZsb2FkX3BhcmFtcyUzQSUyMHRydWUlMEElMjAlMjBmc2RwX3NoYXJkaW5nX3N0cmF0ZWd5JTNBJTIwMSUwQSUyMCUyMGZzZHBfc3RhdGVfZGljdF90eXBlJTNBJTIwU0hBUkRFRF9TVEFURV9ESUNUJTBBJTIwJTIwZnNkcF9zeW5jX21vZHVsZV9zdGF0ZXMlM0ElMjB0cnVlJTBBJTIwJTIwZnNkcF90cmFuc2Zvcm1lcl9sYXllcl9jbHNfdG9fd3JhcCUzQSUyMEJlcnRMYXllciUwQSUyMCUyMGZzZHBfdXNlX29yaWdfcGFyYW1zJTNBJTIwdHJ1ZSUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3RyYWluaW5nX2Z1bmN0aW9uJTNBJTIwbWFpbiUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGJmMTYlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDIlMEFyZHp2X2JhY2tlbmQlM0ElMjBzdGF0aWMlMEFzYW1lX25ldHdvcmslM0ElMjB0cnVlJTBBdHB1X2VudiUzQSUyMCU1QiU1RCUwQXRwdV91c2VfY2x1c3RlciUzQSUyMGZhbHNlJTBBdHB1X3VzZV9zdWRvJTNBJTIwZmFsc2UlMEF1c2VfY3B1JTNBJTIwZmFsc2U=",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">debug:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">FSDP</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">fsdp_config:</span>
  <span class="hljs-attr">fsdp_auto_wrap_policy:</span> <span class="hljs-string">TRANSFORMER_BASED_WRAP</span>
  <span class="hljs-attr">fsdp_backward_prefetch_policy:</span> <span class="hljs-string">BACKWARD_PRE</span>
  <span class="hljs-attr">fsdp_cpu_ram_efficient_loading:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_forward_prefetch:</span> <span class="hljs-literal">false</span>
  <span class="hljs-attr">fsdp_offload_params:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_sharding_strategy:</span> <span class="hljs-number">1</span>
  <span class="hljs-attr">fsdp_state_dict_type:</span> <span class="hljs-string">SHARDED_STATE_DICT</span>
  <span class="hljs-attr">fsdp_sync_module_states:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_transformer_layer_cls_to_wrap:</span> <span class="hljs-string">BertLayer</span>
  <span class="hljs-attr">fsdp_use_orig_params:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_env:</span> []
<span class="hljs-attr">tpu_use_cluster:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">tpu_use_sudo:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),A=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMG15LXRyYWluZXItc2NyaXB0LnB5",highlighted:"accelerate launch my-trainer-script.py",wrap:!1}}),V=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tZnNkcCUzRCUyMmZ1bGwlMjBzaGFyZCUyMiUyMC0tZnNkcF9jb25maWclM0QlMjJwYXRoJTJGdG8lMkZmc2RwX2NvbmZpZyUyRiUyMG15LXRyYWluZXItc2NyaXB0LnB5",highlighted:'accelerate launch --fsdp=<span class="hljs-string">&quot;full shard&quot;</span> --fsdp_config=<span class="hljs-string">&quot;path/to/fsdp_config/ my-trainer-script.py</span>',wrap:!1}}),Q=new g({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),K=new ut({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/fsdp.md"}}),{c(){u=i("meta"),ae=l(),ee=i("p"),se=l(),p(w.$$.fragment),le=l(),_=i("p"),_.innerHTML=Xe,ne=l(),T=i("p"),T.textContent=Ge,ie=l(),p($.$$.fragment),re=l(),p(b.$$.fragment),pe=l(),M=i("p"),M.innerHTML=ze,oe=l(),p(U.$$.fragment),ce=l(),j=i("p"),j.innerHTML=Le,fe=l(),p(F.$$.fragment),de=l(),Z=i("p"),Z.textContent=Ee,he=l(),J=i("ul"),J.innerHTML=Ye,me=l(),v=i("p"),v.innerHTML=Ae,ue=l(),p(B.$$.fragment),ge=l(),P=i("p"),P.innerHTML=Ve,ye=l(),p(S.$$.fragment),we=l(),H=i("p"),H.innerHTML=Qe,_e=l(),C=i("p"),C.innerHTML=qe,Te=l(),p(k.$$.fragment),$e=l(),x=i("p"),x.innerHTML=Oe,be=l(),p(N.$$.fragment),Me=l(),R=i("p"),R.textContent=Ke,Ue=l(),p(W.$$.fragment),je=l(),p(D.$$.fragment),Fe=l(),I=i("p"),I.innerHTML=et,Ze=l(),p(X.$$.fragment),Je=l(),G=i("p"),G.innerHTML=tt,ve=l(),p(z.$$.fragment),Be=l(),L=i("p"),L.textContent=at,Pe=l(),p(E.$$.fragment),Se=l(),Y=i("p"),Y.innerHTML=st,He=l(),p(A.$$.fragment),Ce=l(),p(V.$$.fragment),ke=l(),p(Q.$$.fragment),xe=l(),q=i("p"),q.textContent=lt,Ne=l(),O=i("ul"),O.innerHTML=nt,Re=l(),p(K.$$.fragment),We=l(),te=i("p"),this.h()},l(e){const t=ht("svelte-u9bgzb",document.head);u=r(t,"META",{name:!0,content:!0}),t.forEach(a),ae=n(e),ee=r(e,"P",{}),it(ee).forEach(a),se=n(e),o(w.$$.fragment,e),le=n(e),_=r(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-f6rvvy"&&(_.innerHTML=Xe),ne=n(e),T=r(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-4zh7j7"&&(T.textContent=Ge),ie=n(e),o($.$$.fragment,e),re=n(e),o(b.$$.fragment,e),pe=n(e),M=r(e,"P",{"data-svelte-h":!0}),c(M)!=="svelte-il7v8z"&&(M.innerHTML=ze),oe=n(e),o(U.$$.fragment,e),ce=n(e),j=r(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-60yrb1"&&(j.innerHTML=Le),fe=n(e),o(F.$$.fragment,e),de=n(e),Z=r(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-18pbstz"&&(Z.textContent=Ee),he=n(e),J=r(e,"UL",{"data-svelte-h":!0}),c(J)!=="svelte-11pbaor"&&(J.innerHTML=Ye),me=n(e),v=r(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1l7i7fk"&&(v.innerHTML=Ae),ue=n(e),o(B.$$.fragment,e),ge=n(e),P=r(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-ss15nf"&&(P.innerHTML=Ve),ye=n(e),o(S.$$.fragment,e),we=n(e),H=r(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1wisi5e"&&(H.innerHTML=Qe),_e=n(e),C=r(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-hh9gtt"&&(C.innerHTML=qe),Te=n(e),o(k.$$.fragment,e),$e=n(e),x=r(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-i6lehg"&&(x.innerHTML=Oe),be=n(e),o(N.$$.fragment,e),Me=n(e),R=r(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-5bvj2l"&&(R.textContent=Ke),Ue=n(e),o(W.$$.fragment,e),je=n(e),o(D.$$.fragment,e),Fe=n(e),I=r(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1worwgp"&&(I.innerHTML=et),Ze=n(e),o(X.$$.fragment,e),Je=n(e),G=r(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-n0lvzu"&&(G.innerHTML=tt),ve=n(e),o(z.$$.fragment,e),Be=n(e),L=r(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-69y5on"&&(L.textContent=at),Pe=n(e),o(E.$$.fragment,e),Se=n(e),Y=r(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-jgueof"&&(Y.innerHTML=st),He=n(e),o(A.$$.fragment,e),Ce=n(e),o(V.$$.fragment,e),ke=n(e),o(Q.$$.fragment,e),xe=n(e),q=r(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-hv24fk"&&(q.textContent=lt),Ne=n(e),O=r(e,"UL",{"data-svelte-h":!0}),c(O)!=="svelte-gtahwu"&&(O.innerHTML=nt),Re=n(e),o(K.$$.fragment,e),We=n(e),te=r(e,"P",{}),it(te).forEach(a),this.h()},h(){rt(u,"name","hf:doc:metadata"),rt(u,"content",yt)},m(e,t){mt(document.head,u),s(e,ae,t),s(e,ee,t),s(e,se,t),f(w,e,t),s(e,le,t),s(e,_,t),s(e,ne,t),s(e,T,t),s(e,ie,t),f($,e,t),s(e,re,t),f(b,e,t),s(e,pe,t),s(e,M,t),s(e,oe,t),f(U,e,t),s(e,ce,t),s(e,j,t),s(e,fe,t),f(F,e,t),s(e,de,t),s(e,Z,t),s(e,he,t),s(e,J,t),s(e,me,t),s(e,v,t),s(e,ue,t),f(B,e,t),s(e,ge,t),s(e,P,t),s(e,ye,t),f(S,e,t),s(e,we,t),s(e,H,t),s(e,_e,t),s(e,C,t),s(e,Te,t),f(k,e,t),s(e,$e,t),s(e,x,t),s(e,be,t),f(N,e,t),s(e,Me,t),s(e,R,t),s(e,Ue,t),f(W,e,t),s(e,je,t),f(D,e,t),s(e,Fe,t),s(e,I,t),s(e,Ze,t),f(X,e,t),s(e,Je,t),s(e,G,t),s(e,ve,t),f(z,e,t),s(e,Be,t),s(e,L,t),s(e,Pe,t),f(E,e,t),s(e,Se,t),s(e,Y,t),s(e,He,t),f(A,e,t),s(e,Ce,t),f(V,e,t),s(e,ke,t),f(Q,e,t),s(e,xe,t),s(e,q,t),s(e,Ne,t),s(e,O,t),s(e,Re,t),f(K,e,t),s(e,We,t),s(e,te,t),De=!0},p:ot,i(e){De||(d(w.$$.fragment,e),d($.$$.fragment,e),d(b.$$.fragment,e),d(U.$$.fragment,e),d(F.$$.fragment,e),d(B.$$.fragment,e),d(S.$$.fragment,e),d(k.$$.fragment,e),d(N.$$.fragment,e),d(W.$$.fragment,e),d(D.$$.fragment,e),d(X.$$.fragment,e),d(z.$$.fragment,e),d(E.$$.fragment,e),d(A.$$.fragment,e),d(V.$$.fragment,e),d(Q.$$.fragment,e),d(K.$$.fragment,e),De=!0)},o(e){h(w.$$.fragment,e),h($.$$.fragment,e),h(b.$$.fragment,e),h(U.$$.fragment,e),h(F.$$.fragment,e),h(B.$$.fragment,e),h(S.$$.fragment,e),h(k.$$.fragment,e),h(N.$$.fragment,e),h(W.$$.fragment,e),h(D.$$.fragment,e),h(X.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(V.$$.fragment,e),h(Q.$$.fragment,e),h(K.$$.fragment,e),De=!1},d(e){e&&(a(ae),a(ee),a(se),a(le),a(_),a(ne),a(T),a(ie),a(re),a(pe),a(M),a(oe),a(ce),a(j),a(fe),a(de),a(Z),a(he),a(J),a(me),a(v),a(ue),a(ge),a(P),a(ye),a(we),a(H),a(_e),a(C),a(Te),a($e),a(x),a(be),a(Me),a(R),a(Ue),a(je),a(Fe),a(I),a(Ze),a(Je),a(G),a(ve),a(Be),a(L),a(Pe),a(Se),a(Y),a(He),a(Ce),a(ke),a(xe),a(q),a(Ne),a(O),a(Re),a(We),a(te)),a(u),m(w,e),m($,e),m(b,e),m(U,e),m(F,e),m(B,e),m(S,e),m(k,e),m(N,e),m(W,e),m(D,e),m(X,e),m(z,e),m(E,e),m(A,e),m(V,e),m(Q,e),m(K,e)}}}const yt='{"title":"Fully Sharded Data Parallel","local":"fully-sharded-data-parallel","sections":[{"title":"FSDP configuration","local":"fsdp-configuration","sections":[{"title":"Sharding strategy","local":"sharding-strategy","sections":[],"depth":3},{"title":"CPU offload","local":"cpu-offload","sections":[],"depth":3},{"title":"Wrapping policy","local":"wrapping-policy","sections":[],"depth":3},{"title":"Checkpointing","local":"checkpointing","sections":[],"depth":3},{"title":"TPU","local":"tpu","sections":[],"depth":3}],"depth":2},{"title":"Launch training","local":"launch-training","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function wt(Ie){return ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mt extends ft{constructor(u){super(),dt(this,u,wt,gt,pt,{})}}export{Mt as component};
