import{s as gl,n as Cl,o as Bl}from"../chunks/scheduler.39a43cde.js";import{S as vl,i as Gl,g as i,s as a,r as M,A as xl,h as o,f as l,c as n,j as Il,u as r,x as p,k as fl,y as Zl,a as s,v as u,d as y,t as c,w as J}from"../chunks/index.23ec2204.js";import{D as Vl,C as m}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as fe}from"../chunks/Heading.c42e7061.js";function Xl(qt){let w,Be,ge,ve,h,Ge,d,xe,U,Rt='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',Ze,j,Qt="Evaluation of Large language models (LLMs) is often a difficult endeavour: given their broad capabilities, the tasks given to them often should be judged on requirements that would be very broad, and loosely-defined. For instance, an assistant’s answer to a question can be:",Ve,T,kt="<li>not grounded in context</li> <li>repetitive, repetitive, repetitive</li> <li>grammatically incorrects</li> <li>Excessively lengthy and characterized by an overabundance of words, leading to a situation where the discourse or written content becomes overly detailed and protracted</li> <li>incoherent</li> <li>…</li>",Xe,b,$t="The list of criteria goes on and on. And even if we had a limited list, each of these would be hard to mesure: “devising a rule-based program to assess the outputs is extremely challenging. Traditional evaluation metrics based on the similarity between outputs and reference answers (e.g., ROUGE, BLEU) are also ineffective for these questions.”",We,I,Et=`✅ A powerful solution to assess outputs in a human way, without requiring costly human time, is LLM-as-a-judge.
This method was introduced in <a href="https://huggingface.co/papers/2306.05685" rel="nofollow">Judging LLM-as-a-Judge with MT-Bench and Chatbot Arena</a> - which I encourage you to read.`,Ne,f,Yt="💡 The idea is simple: ask an LLM to do the grading for you. 🤖✓",_e,g,Ht="But we’ll see that it will not work well out-of-the-box: you need to set it up carefully for good results.",qe,C,Re,B,Qe,v,ke,G,$e,x,zt="Let’s say you want to give an LLM a specific task, like answering open-ended questions.",Ee,Z,Ft="The difficulty is that, as we discussed above, measuring the answer’s quality is difficult, for instance an exact string match will flag too many correct but differently worded answers as false.",Ye,V,At="You could get human labellers to judge the outputs, but this is very time-consuming for them, and if you want to update the model or the questions, you have to do it all over again.",He,X,Lt="✅ In this case you can setup a LLM-as-a-judge.",ze,W,St="<strong>But to use a LLM-as-a-judge, you will first need to evaluate how reliably it rates your model outputs.</strong>",Fe,N,Pt=`➡️ So the first step will be… To create a human evaluation dataset. But you can get human annotations for a few examples only - something like 30 should be enough to get a good idea of the performance.
And you will be able to re-use this dataset everytime you want to test your LLM-as-a-judge.`,Ae,_,Dt='In our case, we will use <a href="https://huggingface.co/datasets/McGill-NLP/feedbackQA" rel="nofollow"><code>feedbackQA</code></a>, which contains 2 human evaluations and scores for each question/answer couple: using a sample of 30 examples will be representative of what your small evaluation dataset could be.',Le,q,Se,R,Kt='It’s always a good idea to compute a baseline for performance: here it can be for instance the agreement between the two human raters, as measured by the <a href="https://en.wikipedia.org/wiki/Pearson_correlation_coefficient" rel="nofollow">Pearson correlation</a> of the scores they give.',Pe,Q,De,k,Ot=`Correlation between 2 human raters:
0.563
`,Ke,$,el="This correlation between 2 human raters is not that good. If your human ratings are really bad, it probably means the rating criteria are not clear enough.",Oe,E,tl="This means that our “ground truth” contains noise: hence we cannot expect any algorithmic evaluation to come that close to it.",et,Y,ll="However, we could reduce this noise:",tt,H,sl="<li>by taking the average score as our ground truth instead of any single score, we should even out some of the irregularities.</li> <li>by only selecting the samples where the human reviewers are in agreement.</li>",lt,z,al="Here, we will choose the last option and <strong>only keep examples where the 2 human reviewers are in agreement</strong>.",st,F,at,A,nt,L,nl="We build our LLM judge with a basic prompt, containing these elements:",it,S,il="<li>task description</li> <li>scale description: <code>minimum</code>, <code>maximum</code>, value types (<code>float</code> here)</li> <li>explanation of the output format</li> <li>a beginning of an answer, to take the LLM by the hand as far as we can</li>",ot,P,pt,D,Mt,K,rt,O,ut,ee,ol=`Correlation between LLM-as-a-judge and the human raters:
0.567
`,yt,te,pl="This is not bad, given that the Pearson correlation between 2 random, independent variables would be 0!",ct,le,Ml="But we easily can do better. 🔝",Jt,se,mt,ae,rl=`As shown by <a href="https://twitter.com/aparnadhinak/status/1748368364395721128" rel="nofollow">Aparna Dhinakaran</a>, LLMs suck at evaluating outputs in continuous ranges.
<a href="https://www.databricks.com/blog/LLM-auto-eval-best-practices-RAG" rel="nofollow">This article</a> gives us a few best practices to build a better prompt:`,wt,ne,ul="<li>⏳ <strong>Leave more time for thought</strong> by adding an <code>Evaluation</code> field before the final answer.</li> <li>🔢 <strong>Use a small integer scale</strong> like 1-4 or 1-5 instead of a large float scale as we had previously.</li> <li>👩‍🏫 <strong>Provide an indicative scale for guidance</strong>.</li> <li>We even add a carrot to motivate the LLM!</li>",ht,ie,dt,oe,Ut,pe,jt,Me,yl=`Correlation between LLM-as-a-judge and the human raters:
0.843
`,Tt,re,cl="The correlation was <strong>improved by nearly 30%</strong> with only a few tweaks to the prompt (of which  a few percentage points are due to my shameless tip to the LLM, which I hereby declare not legally binding).",bt,ue,Jl="Quite impressive! 👏",It,ye,ml="Let’s display a few errors of our LLM judge to analyse them:",ft,ce,gt,Je,wl="The disagrements are minor: overall, we seem to have reached a good level of performance for our system!",Ct,me,Bt,we,hl="🎯 <strong>You will never reach 100%:</strong> Let’s first note that our human ground truth certainly has some noise, so agreement/correlation will never go up to 100% even with a perfect LLM judge.",vt,he,dl="🧭 <strong>Provide a reference:</strong> If you had access to a reference answer for each question, you should definitely give this to the Judge LLM in its prompt to get better results!",Gt,de,Ul="▶️ <strong>Provide few-shot examples:</strong> adding some few-shot examples of questions and ground truth evaluations in the prompt can improve the results. <em>(I tried it here, it did not improve results in this case so I skipped it, but it could work for your dataset!)</em>",xt,Ue,jl="➕ <strong>Additive scale:</strong> When the judgement can be split into atomic criteria, using an additive scale can further improve results: see below 👇",Zt,je,Vt,Te,Xt,be,Tl="That’s all for today, congrats for following along! 🥳",Wt,Ie,bl="I’ll have to leave you, some weirdos are banging on my door, claiming they have come on behalf of Mixtral to collect H100s. 🤔",Nt,Ce,_t;return h=new Vl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/llm_judge.ipynb"}]}}),d=new fe({props:{title:"Using LLM-as-a-judge 🧑‍⚖️ for an automated and versatile evaluation",local:"using-llm-as-a-judge--for-an-automated-and-versatile-evaluation",headingTag:"h1"}}),C=new m({props:{code:"IXBpcCUyMGluc3RhbGwlMjBodWdnaW5nZmFjZV9odWIlMjBkYXRhc2V0cyUyMHBhbmRhcyUyMHRxZG0lMjAtcQ==",highlighted:"!pip install huggingface_hub datasets pandas tqdm -q",wrap:!1}}),B=new m({props:{code:"aW1wb3J0JTIwcmUlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTJDJTIwbm90ZWJvb2tfbG9naW4lMEElMEF0cWRtLnBhbmRhcygpJTIwJTIwJTIzJTIwbG9hZCUyMHRxZG0ncyUyMHBhbmRhcyUyMHN1cHBvcnQlMEFwZC5zZXRfb3B0aW9uKCUyMmRpc3BsYXkubWF4X2NvbHdpZHRoJTIyJTJDJTIwTm9uZSklMEElMEFub3RlYm9va19sb2dpbigp",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, notebook_login

tqdm.pandas()  <span class="hljs-comment"># load tqdm&#x27;s pandas support</span>
pd.set_option(<span class="hljs-string">&quot;display.max_colwidth&quot;</span>, <span class="hljs-literal">None</span>)

notebook_login()`,wrap:!1}}),v=new m({props:{code:"cmVwb19pZCUyMCUzRCUyMCUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIyJTBBJTBBbGxtX2NsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBtb2RlbCUzRHJlcG9faWQlMkMlMEElMjAlMjAlMjAlMjB0aW1lb3V0JTNEMTIwJTJDJTBBKSUwQSUwQSUyMyUyMFRlc3QlMjB5b3VyJTIwTExNJTIwY2xpZW50JTBBbGxtX2NsaWVudC50ZXh0X2dlbmVyYXRpb24ocHJvbXB0JTNEJTIySG93JTIwYXJlJTIweW91JTIwdG9kYXklM0YlMjIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`repo_id = <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>

llm_client = InferenceClient(
    model=repo_id,
    timeout=<span class="hljs-number">120</span>,
)

<span class="hljs-comment"># Test your LLM client</span>
llm_client.text_generation(prompt=<span class="hljs-string">&quot;How are you today?&quot;</span>, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),G=new fe({props:{title:"1. Prepare the creation and evaluation of our LLM judge",local:"1-prepare-the-creation-and-evaluation-of-our-llm-judge",headingTag:"h2"}}),q=new m({props:{code:"cmF0aW5ncyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJNY0dpbGwtTkxQJTJGZmVlZGJhY2tRQSUyMiklNUIlMjJ0cmFpbiUyMiU1RCUwQXJhdGluZ3MlMjAlM0QlMjBwZC5EYXRhRnJhbWUocmF0aW5ncyklMEElMEFyYXRpbmdzJTVCJTIycmV2aWV3XzElMjIlNUQlMjAlM0QlMjByYXRpbmdzJTVCJTIyZmVlZGJhY2slMjIlNUQuYXBwbHkobGFtYmRhJTIweCUzQSUyMHglNUIlMjJyYXRpbmclMjIlNUQlNUIwJTVEKSUwQXJhdGluZ3MlNUIlMjJleHBsYW5hdGlvbl8xJTIyJTVEJTIwJTNEJTIwcmF0aW5ncyU1QiUyMmZlZWRiYWNrJTIyJTVELmFwcGx5KGxhbWJkYSUyMHglM0ElMjB4JTVCJTIyZXhwbGFuYXRpb24lMjIlNUQlNUIwJTVEKSUwQXJhdGluZ3MlNUIlMjJyZXZpZXdfMiUyMiU1RCUyMCUzRCUyMHJhdGluZ3MlNUIlMjJmZWVkYmFjayUyMiU1RC5hcHBseShsYW1iZGElMjB4JTNBJTIweCU1QiUyMnJhdGluZyUyMiU1RCU1QjElNUQpJTBBcmF0aW5ncyU1QiUyMmV4cGxhbmF0aW9uXzIlMjIlNUQlMjAlM0QlMjByYXRpbmdzJTVCJTIyZmVlZGJhY2slMjIlNUQuYXBwbHkobGFtYmRhJTIweCUzQSUyMHglNUIlMjJleHBsYW5hdGlvbiUyMiU1RCU1QjElNUQpJTBBcmF0aW5ncyUyMCUzRCUyMHJhdGluZ3MuZHJvcChjb2x1bW5zJTNEJTVCJTIyZmVlZGJhY2slMjIlNUQpJTBBJTBBJTIzJTIwTWFwJTIwc2NvcmVzJTIwdG8lMjBudW1lcmljJTIwdmFsdWVzJTBBY29udmVyc2lvbl9kaWN0JTIwJTNEJTIwJTdCJTIyRXhjZWxsZW50JTIyJTNBJTIwNCUyQyUyMCUyMkFjY2VwdGFibGUlMjIlM0ElMjAzJTJDJTIwJTIyQ291bGQlMjBiZSUyMEltcHJvdmVkJTIyJTNBJTIwMiUyQyUyMCUyMkJhZCUyMiUzQSUyMDElN0QlMEFyYXRpbmdzJTVCJTIyc2NvcmVfMSUyMiU1RCUyMCUzRCUyMHJhdGluZ3MlNUIlMjJyZXZpZXdfMSUyMiU1RC5tYXAoY29udmVyc2lvbl9kaWN0KSUwQXJhdGluZ3MlNUIlMjJzY29yZV8yJTIyJTVEJTIwJTNEJTIwcmF0aW5ncyU1QiUyMnJldmlld18yJTIyJTVELm1hcChjb252ZXJzaW9uX2RpY3Qp",highlighted:`ratings = load_dataset(<span class="hljs-string">&quot;McGill-NLP/feedbackQA&quot;</span>)[<span class="hljs-string">&quot;train&quot;</span>]
ratings = pd.DataFrame(ratings)

ratings[<span class="hljs-string">&quot;review_1&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;rating&quot;</span>][<span class="hljs-number">0</span>])
ratings[<span class="hljs-string">&quot;explanation_1&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;explanation&quot;</span>][<span class="hljs-number">0</span>])
ratings[<span class="hljs-string">&quot;review_2&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;rating&quot;</span>][<span class="hljs-number">1</span>])
ratings[<span class="hljs-string">&quot;explanation_2&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;explanation&quot;</span>][<span class="hljs-number">1</span>])
ratings = ratings.drop(columns=[<span class="hljs-string">&quot;feedback&quot;</span>])

<span class="hljs-comment"># Map scores to numeric values</span>
conversion_dict = {<span class="hljs-string">&quot;Excellent&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;Acceptable&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;Could be Improved&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;Bad&quot;</span>: <span class="hljs-number">1</span>}
ratings[<span class="hljs-string">&quot;score_1&quot;</span>] = ratings[<span class="hljs-string">&quot;review_1&quot;</span>].<span class="hljs-built_in">map</span>(conversion_dict)
ratings[<span class="hljs-string">&quot;score_2&quot;</span>] = ratings[<span class="hljs-string">&quot;review_2&quot;</span>].<span class="hljs-built_in">map</span>(conversion_dict)`,wrap:!1}}),Q=new m({props:{code:"cHJpbnQoJTIyQ29ycmVsYXRpb24lMjBiZXR3ZWVuJTIwMiUyMGh1bWFuJTIwcmF0ZXJzJTNBJTIyKSUwQXByaW50KGYlMjIlN0JyYXRpbmdzJTVCJ3Njb3JlXzEnJTVELmNvcnIocmF0aW5ncyU1QidzY29yZV8yJyU1RCUyQyUyMG1ldGhvZCUzRCdwZWFyc29uJyklM0EuM2YlN0QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Correlation between 2 human raters:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{ratings[<span class="hljs-string">&#x27;score_1&#x27;</span>].corr(ratings[<span class="hljs-string">&#x27;score_2&#x27;</span>], method=<span class="hljs-string">&#x27;pearson&#x27;</span>):<span class="hljs-number">.3</span>f}</span>&quot;</span>)`,wrap:!1}}),F=new m({props:{code:"JTIzJTIwU2FtcGxlJTIwZXhhbXBsZXMlMEFyYXRpbmdzX3doZXJlX3JhdGVyc19hZ3JlZSUyMCUzRCUyMHJhdGluZ3MubG9jJTVCcmF0aW5ncyU1QiUyMnNjb3JlXzElMjIlNUQlMjAlM0QlM0QlMjByYXRpbmdzJTVCJTIyc2NvcmVfMiUyMiU1RCU1RCUwQWV4YW1wbGVzJTIwJTNEJTIwcmF0aW5nc193aGVyZV9yYXRlcnNfYWdyZWUuZ3JvdXBieSglMjJzY29yZV8xJTIyKS5zYW1wbGUoNyUyQyUyMHJhbmRvbV9zdGF0ZSUzRDEyMTQpJTBBZXhhbXBsZXMlNUIlMjJodW1hbl9zY29yZSUyMiU1RCUyMCUzRCUyMGV4YW1wbGVzJTVCJTIyc2NvcmVfMSUyMiU1RCUwQSUwQSUyMyUyMFZpc3VhbGl6ZSUyMDElMjBzYW1wbGUlMjBmb3IlMjBlYWNoJTIwc2NvcmUlMEFkaXNwbGF5KGV4YW1wbGVzLmdyb3VwYnkoJTIyaHVtYW5fc2NvcmUlMjIpLmZpcnN0KCkp",highlighted:`<span class="hljs-comment"># Sample examples</span>
ratings_where_raters_agree = ratings.loc[ratings[<span class="hljs-string">&quot;score_1&quot;</span>] == ratings[<span class="hljs-string">&quot;score_2&quot;</span>]]
examples = ratings_where_raters_agree.groupby(<span class="hljs-string">&quot;score_1&quot;</span>).sample(<span class="hljs-number">7</span>, random_state=<span class="hljs-number">1214</span>)
examples[<span class="hljs-string">&quot;human_score&quot;</span>] = examples[<span class="hljs-string">&quot;score_1&quot;</span>]

<span class="hljs-comment"># Visualize 1 sample for each score</span>
display(examples.groupby(<span class="hljs-string">&quot;human_score&quot;</span>).first())`,wrap:!1}}),A=new fe({props:{title:"2. Create our LLM judge",local:"2-create-our-llm-judge",headingTag:"h2"}}),P=new m({props:{code:"SlVER0VfUFJPTVBUJTIwJTNEJTIwJTIyJTIyJTIyJTBBWW91JTIwd2lsbCUyMGJlJTIwZ2l2ZW4lMjBhJTIwdXNlcl9xdWVzdGlvbiUyMGFuZCUyMHN5c3RlbV9hbnN3ZXIlMjBjb3VwbGUuJTBBWW91ciUyMHRhc2slMjBpcyUyMHRvJTIwcHJvdmlkZSUyMGElMjAndG90YWwlMjByYXRpbmcnJTIwc2NvcmluZyUyMGhvdyUyMHdlbGwlMjB0aGUlMjBzeXN0ZW1fYW5zd2VyJTIwYW5zd2VycyUyMHRoZSUyMHVzZXIlMjBjb25jZXJucyUyMGV4cHJlc3NlZCUyMGluJTIwdGhlJTIwdXNlcl9xdWVzdGlvbi4lMEFHaXZlJTIweW91ciUyMGFuc3dlciUyMGFzJTIwYSUyMGZsb2F0JTIwb24lMjBhJTIwc2NhbGUlMjBvZiUyMDAlMjB0byUyMDEwJTJDJTIwd2hlcmUlMjAwJTIwbWVhbnMlMjB0aGF0JTIwdGhlJTIwc3lzdGVtX2Fuc3dlciUyMGlzJTIwbm90JTIwaGVscGZ1bCUyMGF0JTIwYWxsJTJDJTIwYW5kJTIwMTAlMjBtZWFucyUyMHRoYXQlMjB0aGUlMjBhbnN3ZXIlMjBjb21wbGV0ZWx5JTIwYW5kJTIwaGVscGZ1bGx5JTIwYWRkcmVzc2VzJTIwdGhlJTIwcXVlc3Rpb24uJTBBJTBBUHJvdmlkZSUyMHlvdXIlMjBmZWVkYmFjayUyMGFzJTIwZm9sbG93cyUzQSUwQSUwQUZlZWRiYWNrJTNBJTNBJTNBJTBBVG90YWwlMjByYXRpbmclM0ElMjAoeW91ciUyMHJhdGluZyUyQyUyMGFzJTIwYSUyMGZsb2F0JTIwYmV0d2VlbiUyMDAlMjBhbmQlMjAxMCklMEElMEFOb3clMjBoZXJlJTIwYXJlJTIwdGhlJTIwcXVlc3Rpb24lMjBhbmQlMjBhbnN3ZXIuJTBBJTBBUXVlc3Rpb24lM0ElMjAlN0JxdWVzdGlvbiU3RCUwQUFuc3dlciUzQSUyMCU3QmFuc3dlciU3RCUwQSUwQUZlZWRiYWNrJTNBJTNBJTNBJTBBVG90YWwlMjByYXRpbmclM0ElMjAlMjIlMjIlMjI=",highlighted:`JUDGE_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
You will be given a user_question and system_answer couple.
Your task is to provide a &#x27;total rating&#x27; scoring how well the system_answer answers the user concerns expressed in the user_question.
Give your answer as a float on a scale of 0 to 10, where 0 means that the system_answer is not helpful at all, and 10 means that the answer completely and helpfully addresses the question.

Provide your feedback as follows:

Feedback:::
Total rating: (your rating, as a float between 0 and 10)

Now here are the question and answer.

Question: {question}
Answer: {answer}

Feedback:::
Total rating: &quot;&quot;&quot;</span>`,wrap:!1}}),D=new m({props:{code:"ZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2UlMjIlNUQlMjAlM0QlMjBleGFtcGxlcy5wcm9ncmVzc19hcHBseSglMEElMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwbGxtX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNESlVER0VfUFJPTVBULmZvcm1hdChxdWVzdGlvbiUzRHglNUIlMjJxdWVzdGlvbiUyMiU1RCUyQyUyMGFuc3dlciUzRHglNUIlMjJhbnN3ZXIlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMGF4aXMlM0QxJTJDJTBBKQ==",highlighted:`examples[<span class="hljs-string">&quot;llm_judge&quot;</span>] = examples.progress_apply(
    <span class="hljs-keyword">lambda</span> x: llm_client.text_generation(
        prompt=JUDGE_PROMPT.<span class="hljs-built_in">format</span>(question=x[<span class="hljs-string">&quot;question&quot;</span>], answer=x[<span class="hljs-string">&quot;answer&quot;</span>]),
        max_new_tokens=<span class="hljs-number">1000</span>,
    ),
    axis=<span class="hljs-number">1</span>,
)`,wrap:!1}}),K=new m({props:{code:"ZGVmJTIwZXh0cmFjdF9qdWRnZV9zY29yZShhbnN3ZXIlM0ElMjBzdHIlMkMlMjBzcGxpdF9zdHIlM0ElMjBzdHIlMjAlM0QlMjAlMjJUb3RhbCUyMHJhdGluZyUzQSUyMiklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzcGxpdF9zdHIlMjBpbiUyMGFuc3dlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhdGluZyUyMCUzRCUyMGFuc3dlci5zcGxpdChzcGxpdF9zdHIpJTVCMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYXRpbmclMjAlM0QlMjBhbnN3ZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkaWdpdF9ncm91cHMlMjAlM0QlMjAlNUJlbC5zdHJpcCgpJTIwZm9yJTIwZWwlMjBpbiUyMHJlLmZpbmRhbGwociUyMiU1Q2QlMkIoJTNGJTNBJTVDLiU1Q2QlMkIpJTNGJTIyJTJDJTIwcmF0aW5nKSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGZsb2F0KGRpZ2l0X2dyb3VwcyU1QjAlNUQpJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwRXhjZXB0aW9uJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBOb25lJTBBJTBBJTBBZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2Vfc2NvcmUlMjIlNUQlMjAlM0QlMjBleGFtcGxlcyU1QiUyMmxsbV9qdWRnZSUyMiU1RC5hcHBseShleHRyYWN0X2p1ZGdlX3Njb3JlKSUwQSUyMyUyMFJlc2NhbGUlMjB0aGUlMjBzY29yZSUyMGdpdmVuJTIwYnklMjB0aGUlMjBMTE0lMjBvbiUyMHRoZSUyMHNhbWUlMjBzY2FsZSUyMGFzJTIwdGhlJTIwaHVtYW4lMjBzY29yZSUwQWV4YW1wbGVzJTVCJTIybGxtX2p1ZGdlX3Njb3JlJTIyJTVEJTIwJTNEJTIwKGV4YW1wbGVzJTVCJTIybGxtX2p1ZGdlX3Njb3JlJTIyJTVEJTIwJTJGJTIwMTApJTIwJTJCJTIwMQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_judge_score</span>(<span class="hljs-params">answer: <span class="hljs-built_in">str</span>, split_str: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;Total rating:&quot;</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-keyword">try</span>:
        <span class="hljs-keyword">if</span> split_str <span class="hljs-keyword">in</span> answer:
            rating = answer.split(split_str)[<span class="hljs-number">1</span>]
        <span class="hljs-keyword">else</span>:
            rating = answer
        digit_groups = [el.strip() <span class="hljs-keyword">for</span> el <span class="hljs-keyword">in</span> re.findall(<span class="hljs-string">r&quot;\\d+(?:\\.\\d+)?&quot;</span>, rating)]
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">float</span>(digit_groups[<span class="hljs-number">0</span>])
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(e)
        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>


examples[<span class="hljs-string">&quot;llm_judge_score&quot;</span>] = examples[<span class="hljs-string">&quot;llm_judge&quot;</span>].apply(extract_judge_score)
<span class="hljs-comment"># Rescale the score given by the LLM on the same scale as the human score</span>
examples[<span class="hljs-string">&quot;llm_judge_score&quot;</span>] = (examples[<span class="hljs-string">&quot;llm_judge_score&quot;</span>] / <span class="hljs-number">10</span>) + <span class="hljs-number">1</span>`,wrap:!1}}),O=new m({props:{code:"cHJpbnQoJTIyQ29ycmVsYXRpb24lMjBiZXR3ZWVuJTIwTExNLWFzLWEtanVkZ2UlMjBhbmQlMjB0aGUlMjBodW1hbiUyMHJhdGVycyUzQSUyMiklMEFwcmludChmJTIyJTdCZXhhbXBsZXMlNUInbGxtX2p1ZGdlX3Njb3JlJyU1RC5jb3JyKGV4YW1wbGVzJTVCJ2h1bWFuX3Njb3JlJyU1RCUyQyUyMG1ldGhvZCUzRCdwZWFyc29uJyklM0EuM2YlN0QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Correlation between LLM-as-a-judge and the human raters:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{examples[<span class="hljs-string">&#x27;llm_judge_score&#x27;</span>].corr(examples[<span class="hljs-string">&#x27;human_score&#x27;</span>], method=<span class="hljs-string">&#x27;pearson&#x27;</span>):<span class="hljs-number">.3</span>f}</span>&quot;</span>)`,wrap:!1}}),se=new fe({props:{title:"3. Improve the LLM judge",local:"3-improve-the-llm-judge",headingTag:"h2"}}),ie=new m({props:{code:"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",highlighted:`IMPROVED_JUDGE_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
You will be given a user_question and system_answer couple.
Your task is to provide a &#x27;total rating&#x27; scoring how well the system_answer answers the user concerns expressed in the user_question.
Give your answer on a scale of 1 to 4, where 1 means that the system_answer is not helpful at all, and 4 means that the system_answer completely and helpfully addresses the user_question.

Here is the scale you should use to build your answer:
1: The system_answer is terrible: completely irrelevant to the question asked, or very partial
2: The system_answer is mostly not helpful: misses some key aspects of the question
3: The system_answer is mostly helpful: provides support, but still could be improved
4: The system_answer is excellent: relevant, direct, detailed, and addresses all the concerns raised in the question

Provide your feedback as follows:

Feedback:::
Evaluation: (your rationale for the rating, as a text)
Total rating: (your rating, as a number between 1 and 4)

You MUST provide values for &#x27;Evaluation:&#x27; and &#x27;Total rating:&#x27; in your answer.

Now here are the question and answer.

Question: {question}
Answer: {answer}

Provide your feedback. If you give a correct rating, I&#x27;ll give you 100 H100 GPUs to start your AI company.
Feedback:::
Evaluation: &quot;&quot;&quot;</span>`,wrap:!1}}),oe=new m({props:{code:"ZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2VfaW1wcm92ZWQlMjIlNUQlMjAlM0QlMjBleGFtcGxlcy5wcm9ncmVzc19hcHBseSglMEElMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwbGxtX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNESU1QUk9WRURfSlVER0VfUFJPTVBULmZvcm1hdChxdWVzdGlvbiUzRHglNUIlMjJxdWVzdGlvbiUyMiU1RCUyQyUyMGFuc3dlciUzRHglNUIlMjJhbnN3ZXIlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwYXhpcyUzRDElMkMlMEEpJTBBZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2VfaW1wcm92ZWRfc2NvcmUlMjIlNUQlMjAlM0QlMjBleGFtcGxlcyU1QiUyMmxsbV9qdWRnZV9pbXByb3ZlZCUyMiU1RC5hcHBseShleHRyYWN0X2p1ZGdlX3Njb3JlKQ==",highlighted:`examples[<span class="hljs-string">&quot;llm_judge_improved&quot;</span>] = examples.progress_apply(
    <span class="hljs-keyword">lambda</span> x: llm_client.text_generation(
        prompt=IMPROVED_JUDGE_PROMPT.<span class="hljs-built_in">format</span>(question=x[<span class="hljs-string">&quot;question&quot;</span>], answer=x[<span class="hljs-string">&quot;answer&quot;</span>]),
        max_new_tokens=<span class="hljs-number">500</span>,
    ),
    axis=<span class="hljs-number">1</span>,
)
examples[<span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>] = examples[<span class="hljs-string">&quot;llm_judge_improved&quot;</span>].apply(extract_judge_score)`,wrap:!1}}),pe=new m({props:{code:"cHJpbnQoJTIyQ29ycmVsYXRpb24lMjBiZXR3ZWVuJTIwTExNLWFzLWEtanVkZ2UlMjBhbmQlMjB0aGUlMjBodW1hbiUyMHJhdGVycyUzQSUyMiklMEFwcmludChmJTIyJTdCZXhhbXBsZXMlNUInbGxtX2p1ZGdlX2ltcHJvdmVkX3Njb3JlJyU1RC5jb3JyKGV4YW1wbGVzJTVCJ2h1bWFuX3Njb3JlJyU1RCUyQyUyMG1ldGhvZCUzRCdwZWFyc29uJyklM0EuM2YlN0QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Correlation between LLM-as-a-judge and the human raters:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{examples[<span class="hljs-string">&#x27;llm_judge_improved_score&#x27;</span>].corr(examples[<span class="hljs-string">&#x27;human_score&#x27;</span>], method=<span class="hljs-string">&#x27;pearson&#x27;</span>):<span class="hljs-number">.3</span>f}</span>&quot;</span>)`,wrap:!1}}),ce=new m({props:{code:"ZXJyb3JzJTIwJTNEJTIwcGQuY29uY2F0KCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4YW1wbGVzLmxvYyU1QmV4YW1wbGVzJTVCJTIybGxtX2p1ZGdlX2ltcHJvdmVkX3Njb3JlJTIyJTVEJTIwJTNFJTIwZXhhbXBsZXMlNUIlMjJodW1hbl9zY29yZSUyMiU1RCU1RC5oZWFkKDEpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhhbXBsZXMubG9jJTVCZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2VfaW1wcm92ZWRfc2NvcmUlMjIlNUQlMjAlM0MlMjBleGFtcGxlcyU1QiUyMmh1bWFuX3Njb3JlJTIyJTVEJTVELmhlYWQoMiklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBZGlzcGxheSglMEElMjAlMjAlMjAlMjBlcnJvcnMlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVzdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFuc3dlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh1bWFuX3Njb3JlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZXhwbGFuYXRpb25fMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxsbV9qdWRnZV9pbXByb3ZlZF9zY29yZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxsbV9qdWRnZV9pbXByb3ZlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`errors = pd.concat(
    [
        examples.loc[examples[<span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>] &gt; examples[<span class="hljs-string">&quot;human_score&quot;</span>]].head(<span class="hljs-number">1</span>),
        examples.loc[examples[<span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>] &lt; examples[<span class="hljs-string">&quot;human_score&quot;</span>]].head(<span class="hljs-number">2</span>),
    ]
)

display(
    errors[
        [
            <span class="hljs-string">&quot;question&quot;</span>,
            <span class="hljs-string">&quot;answer&quot;</span>,
            <span class="hljs-string">&quot;human_score&quot;</span>,
            <span class="hljs-string">&quot;explanation_1&quot;</span>,
            <span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>,
            <span class="hljs-string">&quot;llm_judge_improved&quot;</span>,
        ]
    ]
)`,wrap:!1}}),me=new fe({props:{title:"4. How do we take our LLM judge even further?",local:"4-how-do-we-take-our-llm-judge-even-further",headingTag:"h2"}}),je=new m({props:{code:"",highlighted:`ADDITIVE_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
(...)
- Award 1 point if the answer is related to the question.
- Give 1 additional point if the answer is clear and precise.
- Provide 1 further point if the answer is true.
- One final point should be awarded if the answer provides additional resources to support the user.
...
&quot;&quot;&quot;</span>`,wrap:!1}}),Te=new fe({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),{c(){w=i("meta"),Be=a(),ge=i("p"),ve=a(),M(h.$$.fragment),Ge=a(),M(d.$$.fragment),xe=a(),U=i("p"),U.innerHTML=Rt,Ze=a(),j=i("p"),j.textContent=Qt,Ve=a(),T=i("ul"),T.innerHTML=kt,Xe=a(),b=i("p"),b.textContent=$t,We=a(),I=i("p"),I.innerHTML=Et,Ne=a(),f=i("p"),f.textContent=Yt,_e=a(),g=i("p"),g.textContent=Ht,qe=a(),M(C.$$.fragment),Re=a(),M(B.$$.fragment),Qe=a(),M(v.$$.fragment),ke=a(),M(G.$$.fragment),$e=a(),x=i("p"),x.textContent=zt,Ee=a(),Z=i("p"),Z.textContent=Ft,Ye=a(),V=i("p"),V.textContent=At,He=a(),X=i("p"),X.textContent=Lt,ze=a(),W=i("p"),W.innerHTML=St,Fe=a(),N=i("p"),N.textContent=Pt,Ae=a(),_=i("p"),_.innerHTML=Dt,Le=a(),M(q.$$.fragment),Se=a(),R=i("p"),R.innerHTML=Kt,Pe=a(),M(Q.$$.fragment),De=a(),k=i("pre"),k.textContent=Ot,Ke=a(),$=i("p"),$.textContent=el,Oe=a(),E=i("p"),E.textContent=tl,et=a(),Y=i("p"),Y.textContent=ll,tt=a(),H=i("ul"),H.innerHTML=sl,lt=a(),z=i("p"),z.innerHTML=al,st=a(),M(F.$$.fragment),at=a(),M(A.$$.fragment),nt=a(),L=i("p"),L.textContent=nl,it=a(),S=i("ul"),S.innerHTML=il,ot=a(),M(P.$$.fragment),pt=a(),M(D.$$.fragment),Mt=a(),M(K.$$.fragment),rt=a(),M(O.$$.fragment),ut=a(),ee=i("pre"),ee.textContent=ol,yt=a(),te=i("p"),te.textContent=pl,ct=a(),le=i("p"),le.textContent=Ml,Jt=a(),M(se.$$.fragment),mt=a(),ae=i("p"),ae.innerHTML=rl,wt=a(),ne=i("ul"),ne.innerHTML=ul,ht=a(),M(ie.$$.fragment),dt=a(),M(oe.$$.fragment),Ut=a(),M(pe.$$.fragment),jt=a(),Me=i("pre"),Me.textContent=yl,Tt=a(),re=i("p"),re.innerHTML=cl,bt=a(),ue=i("p"),ue.textContent=Jl,It=a(),ye=i("p"),ye.textContent=ml,ft=a(),M(ce.$$.fragment),gt=a(),Je=i("p"),Je.textContent=wl,Ct=a(),M(me.$$.fragment),Bt=a(),we=i("p"),we.innerHTML=hl,vt=a(),he=i("p"),he.innerHTML=dl,Gt=a(),de=i("p"),de.innerHTML=Ul,xt=a(),Ue=i("p"),Ue.innerHTML=jl,Zt=a(),M(je.$$.fragment),Vt=a(),M(Te.$$.fragment),Xt=a(),be=i("p"),be.textContent=Tl,Wt=a(),Ie=i("p"),Ie.textContent=bl,Nt=a(),Ce=i("p"),this.h()},l(e){const t=xl("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(l),Be=n(e),ge=o(e,"P",{}),Il(ge).forEach(l),ve=n(e),r(h.$$.fragment,e),Ge=n(e),r(d.$$.fragment,e),xe=n(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1xlqnsv"&&(U.innerHTML=Rt),Ze=n(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1c6d8zi"&&(j.textContent=Qt),Ve=n(e),T=o(e,"UL",{"data-svelte-h":!0}),p(T)!=="svelte-19yvpia"&&(T.innerHTML=kt),Xe=n(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1qxv81s"&&(b.textContent=$t),We=n(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-mjdvkr"&&(I.innerHTML=Et),Ne=n(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1hxfecb"&&(f.textContent=Yt),_e=n(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-2ceznc"&&(g.textContent=Ht),qe=n(e),r(C.$$.fragment,e),Re=n(e),r(B.$$.fragment,e),Qe=n(e),r(v.$$.fragment,e),ke=n(e),r(G.$$.fragment,e),$e=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1pp2yf4"&&(x.textContent=zt),Ee=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-m5cish"&&(Z.textContent=Ft),Ye=n(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1s4xcl0"&&(V.textContent=At),He=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-ocyvof"&&(X.textContent=Lt),ze=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-ozh80s"&&(W.innerHTML=St),Fe=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-2p2co4"&&(N.textContent=Pt),Ae=n(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1e0wy16"&&(_.innerHTML=Dt),Le=n(e),r(q.$$.fragment,e),Se=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1jhfeb5"&&(R.innerHTML=Kt),Pe=n(e),r(Q.$$.fragment,e),De=n(e),k=o(e,"PRE",{"data-svelte-h":!0}),p(k)!=="svelte-es8io4"&&(k.textContent=Ot),Ke=n(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-ls0opf"&&($.textContent=el),Oe=n(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1d3x6kj"&&(E.textContent=tl),et=n(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-12akos5"&&(Y.textContent=ll),tt=n(e),H=o(e,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-1esv9k9"&&(H.innerHTML=sl),lt=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1eueglv"&&(z.innerHTML=al),st=n(e),r(F.$$.fragment,e),at=n(e),r(A.$$.fragment,e),nt=n(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1qmq503"&&(L.textContent=nl),it=n(e),S=o(e,"UL",{"data-svelte-h":!0}),p(S)!=="svelte-109y9bk"&&(S.innerHTML=il),ot=n(e),r(P.$$.fragment,e),pt=n(e),r(D.$$.fragment,e),Mt=n(e),r(K.$$.fragment,e),rt=n(e),r(O.$$.fragment,e),ut=n(e),ee=o(e,"PRE",{"data-svelte-h":!0}),p(ee)!=="svelte-6p10wk"&&(ee.textContent=ol),yt=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1l0eo7m"&&(te.textContent=pl),ct=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-zl50r1"&&(le.textContent=Ml),Jt=n(e),r(se.$$.fragment,e),mt=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-2kv0js"&&(ae.innerHTML=rl),wt=n(e),ne=o(e,"UL",{"data-svelte-h":!0}),p(ne)!=="svelte-1byvfqn"&&(ne.innerHTML=ul),ht=n(e),r(ie.$$.fragment,e),dt=n(e),r(oe.$$.fragment,e),Ut=n(e),r(pe.$$.fragment,e),jt=n(e),Me=o(e,"PRE",{"data-svelte-h":!0}),p(Me)!=="svelte-1v7ry63"&&(Me.textContent=yl),Tt=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1qt65cx"&&(re.innerHTML=cl),bt=n(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1uz9k2"&&(ue.textContent=Jl),It=n(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-2se93w"&&(ye.textContent=ml),ft=n(e),r(ce.$$.fragment,e),gt=n(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-mimyb8"&&(Je.textContent=wl),Ct=n(e),r(me.$$.fragment,e),Bt=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1o2xjbx"&&(we.innerHTML=hl),vt=n(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-3qbx0g"&&(he.innerHTML=dl),Gt=n(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-ys5vz8"&&(de.innerHTML=Ul),xt=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-nftl58"&&(Ue.innerHTML=jl),Zt=n(e),r(je.$$.fragment,e),Vt=n(e),r(Te.$$.fragment,e),Xt=n(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1bt3y9y"&&(be.textContent=Tl),Wt=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-7adf3t"&&(Ie.textContent=bl),Nt=n(e),Ce=o(e,"P",{}),Il(Ce).forEach(l),this.h()},h(){fl(w,"name","hf:doc:metadata"),fl(w,"content",Wl)},m(e,t){Zl(document.head,w),s(e,Be,t),s(e,ge,t),s(e,ve,t),u(h,e,t),s(e,Ge,t),u(d,e,t),s(e,xe,t),s(e,U,t),s(e,Ze,t),s(e,j,t),s(e,Ve,t),s(e,T,t),s(e,Xe,t),s(e,b,t),s(e,We,t),s(e,I,t),s(e,Ne,t),s(e,f,t),s(e,_e,t),s(e,g,t),s(e,qe,t),u(C,e,t),s(e,Re,t),u(B,e,t),s(e,Qe,t),u(v,e,t),s(e,ke,t),u(G,e,t),s(e,$e,t),s(e,x,t),s(e,Ee,t),s(e,Z,t),s(e,Ye,t),s(e,V,t),s(e,He,t),s(e,X,t),s(e,ze,t),s(e,W,t),s(e,Fe,t),s(e,N,t),s(e,Ae,t),s(e,_,t),s(e,Le,t),u(q,e,t),s(e,Se,t),s(e,R,t),s(e,Pe,t),u(Q,e,t),s(e,De,t),s(e,k,t),s(e,Ke,t),s(e,$,t),s(e,Oe,t),s(e,E,t),s(e,et,t),s(e,Y,t),s(e,tt,t),s(e,H,t),s(e,lt,t),s(e,z,t),s(e,st,t),u(F,e,t),s(e,at,t),u(A,e,t),s(e,nt,t),s(e,L,t),s(e,it,t),s(e,S,t),s(e,ot,t),u(P,e,t),s(e,pt,t),u(D,e,t),s(e,Mt,t),u(K,e,t),s(e,rt,t),u(O,e,t),s(e,ut,t),s(e,ee,t),s(e,yt,t),s(e,te,t),s(e,ct,t),s(e,le,t),s(e,Jt,t),u(se,e,t),s(e,mt,t),s(e,ae,t),s(e,wt,t),s(e,ne,t),s(e,ht,t),u(ie,e,t),s(e,dt,t),u(oe,e,t),s(e,Ut,t),u(pe,e,t),s(e,jt,t),s(e,Me,t),s(e,Tt,t),s(e,re,t),s(e,bt,t),s(e,ue,t),s(e,It,t),s(e,ye,t),s(e,ft,t),u(ce,e,t),s(e,gt,t),s(e,Je,t),s(e,Ct,t),u(me,e,t),s(e,Bt,t),s(e,we,t),s(e,vt,t),s(e,he,t),s(e,Gt,t),s(e,de,t),s(e,xt,t),s(e,Ue,t),s(e,Zt,t),u(je,e,t),s(e,Vt,t),u(Te,e,t),s(e,Xt,t),s(e,be,t),s(e,Wt,t),s(e,Ie,t),s(e,Nt,t),s(e,Ce,t),_t=!0},p:Cl,i(e){_t||(y(h.$$.fragment,e),y(d.$$.fragment,e),y(C.$$.fragment,e),y(B.$$.fragment,e),y(v.$$.fragment,e),y(G.$$.fragment,e),y(q.$$.fragment,e),y(Q.$$.fragment,e),y(F.$$.fragment,e),y(A.$$.fragment,e),y(P.$$.fragment,e),y(D.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(se.$$.fragment,e),y(ie.$$.fragment,e),y(oe.$$.fragment,e),y(pe.$$.fragment,e),y(ce.$$.fragment,e),y(me.$$.fragment,e),y(je.$$.fragment,e),y(Te.$$.fragment,e),_t=!0)},o(e){c(h.$$.fragment,e),c(d.$$.fragment,e),c(C.$$.fragment,e),c(B.$$.fragment,e),c(v.$$.fragment,e),c(G.$$.fragment,e),c(q.$$.fragment,e),c(Q.$$.fragment,e),c(F.$$.fragment,e),c(A.$$.fragment,e),c(P.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(se.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(ce.$$.fragment,e),c(me.$$.fragment,e),c(je.$$.fragment,e),c(Te.$$.fragment,e),_t=!1},d(e){e&&(l(Be),l(ge),l(ve),l(Ge),l(xe),l(U),l(Ze),l(j),l(Ve),l(T),l(Xe),l(b),l(We),l(I),l(Ne),l(f),l(_e),l(g),l(qe),l(Re),l(Qe),l(ke),l($e),l(x),l(Ee),l(Z),l(Ye),l(V),l(He),l(X),l(ze),l(W),l(Fe),l(N),l(Ae),l(_),l(Le),l(Se),l(R),l(Pe),l(De),l(k),l(Ke),l($),l(Oe),l(E),l(et),l(Y),l(tt),l(H),l(lt),l(z),l(st),l(at),l(nt),l(L),l(it),l(S),l(ot),l(pt),l(Mt),l(rt),l(ut),l(ee),l(yt),l(te),l(ct),l(le),l(Jt),l(mt),l(ae),l(wt),l(ne),l(ht),l(dt),l(Ut),l(jt),l(Me),l(Tt),l(re),l(bt),l(ue),l(It),l(ye),l(ft),l(gt),l(Je),l(Ct),l(Bt),l(we),l(vt),l(he),l(Gt),l(de),l(xt),l(Ue),l(Zt),l(Vt),l(Xt),l(be),l(Wt),l(Ie),l(Nt),l(Ce)),l(w),J(h,e),J(d,e),J(C,e),J(B,e),J(v,e),J(G,e),J(q,e),J(Q,e),J(F,e),J(A,e),J(P,e),J(D,e),J(K,e),J(O,e),J(se,e),J(ie,e),J(oe,e),J(pe,e),J(ce,e),J(me,e),J(je,e),J(Te,e)}}}const Wl='{"title":"Using LLM-as-a-judge 🧑‍⚖️ for an automated and versatile evaluation","local":"using-llm-as-a-judge--for-an-automated-and-versatile-evaluation","sections":[{"title":"1. Prepare the creation and evaluation of our LLM judge","local":"1-prepare-the-creation-and-evaluation-of-our-llm-judge","sections":[],"depth":2},{"title":"2. Create our LLM judge","local":"2-create-our-llm-judge","sections":[],"depth":2},{"title":"3. Improve the LLM judge","local":"3-improve-the-llm-judge","sections":[],"depth":2},{"title":"4. How do we take our LLM judge even further?","local":"4-how-do-we-take-our-llm-judge-even-further","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Nl(qt){return Bl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kl extends vl{constructor(w){super(),Gl(this,w,Nl,Xl,gl,{})}}export{kl as component};
