import{s as Ia,n as qa,o as Na}from"../chunks/scheduler.b108d059.js";import{S as Va,i as Ba,g as o,s as n,r as u,A as Ka,h as r,f as s,c as i,j as h,u as m,x as d,k as a,y as Qa,a as l,v as p,d as c,t as f,w as T}from"../chunks/index.008de539.js";import{C as Vr}from"../chunks/CodeBlock.3968c746.js";import{H as _}from"../chunks/Heading.88bfeb84.js";function Sa(Br){let $,Ks,Vs,Qs,y,Ss,M,Os,b,Kr="Helper module for <code>Tensor</code> processing.",Ws,v,Qr=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,Ys,C,Sr='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+transpose"><code>.transpose(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/tensor.transpose"><code>.transpose(tensor, axes)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <code>Array.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.dynamicTimeWarping"><code>.dynamicTimeWarping(matrix)</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒</li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..ONNXTensor"><code>~ONNXTensor</code></a> : <code>Object</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',Fs,Xs,Gs,x,Zs,H,el,L,Or='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',tl,w,Wr='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+transpose"><code>.transpose(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li></ul></li>',sl,ll,nl,A,il,U,ol,g,Yr="Create a new Tensor or copy an existing Tensor.",rl,z,Fr="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",dl,al,ul,J,ml,j,pl,R,Xr=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,cl,P,Gr='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',fl,Tl,hl,k,_l,E,$l,D,Zr="Index into a Tensor object.",yl,I,ed='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The data at the specified index.',Ml,q,td="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",bl,vl,Cl,N,xl,V,Hl,B,sd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',Ll,K,ld="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",wl,Al,Ul,Q,gl,S,zl,O,nd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Jl,W,id="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",jl,Rl,Pl,Y,kl,F,El,X,od=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,Dl,G,rd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',Il,Z,dd="<li><code>Error</code> If the tensor has more than one element.</li>",ql,Nl,Vl,ee,Bl,te,Kl,se,ad="Convert tensor data to a n-dimensional JS list",Ql,le,ud='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Sl,Ol,Wl,ne,Yl,ie,Fl,oe,md="Return a new Tensor with the sigmoid function applied to each element.",Xl,re,pd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the sigmoid function applied.',Gl,Zl,en,de,tn,ae,sn,ue,cd="Applies the sigmoid function to the tensor in place.",ln,me,fd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',nn,on,rn,pe,dn,ce,an,fe,Td="Return a transposed version of this Tensor, according to the provided dimensions.",un,Te,hd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The transposed tensor.',mn,he,_d="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to transpose.</p></td></tr></tbody>",pn,cn,fn,_e,Tn,$e,hn,ye,$d="Returns the sum of each row of the input tensor in the given dimension dim.",_n,Me,yd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',$n,be,Md="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",yn,Mn,bn,ve,vn,Ce,Cn,xe,bd="Returns the matrix norm or vector norm of a given tensor.",xn,He,vd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The norm of the tensor.',Hn,Le,Cd=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,Ln,wn,An,we,Un,Ae,gn,Ue,xd="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",zn,ge,Hd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - <code>this</code> for operation chaining.',Jn,ze,Ld="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",jn,Rn,Pn,Je,kn,je,En,Re,wd="Performs <code>L_p</code> normalization of inputs over specified dimension.",Dn,Pe,Ad='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',In,ke,Ud="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",qn,Nn,Vn,Ee,Bn,De,Kn,Ie,gd=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,Qn,qe,zd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',Sn,On,Wn,Ne,Yn,Ve,Fn,Be,Jd="Returns a tensor with all specified dimensions of input of size 1 removed.",Xn,Ke,jd=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,Gn,Qe,Rd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The squeezed tensor',Zn,Se,Pd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",ei,ti,si,Oe,li,We,ni,Ye,kd='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',ii,Fe,Ed='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',oi,ri,di,Xe,ai,Ge,ui,Ze,Dd="Returns a new tensor with a dimension of size one inserted at the specified position.",mi,et,Id="NOTE: The returned tensor shares the same underlying data with this tensor.",pi,tt,qd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The unsqueezed tensor',ci,st,Nd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",fi,Ti,hi,lt,_i,nt,$i,it,Vd='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',yi,ot,Bd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Mi,bi,vi,rt,Ci,dt,xi,at,Kd='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',Hi,ut,Qd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Li,wi,Ai,mt,Ui,pt,gi,ct,Sd=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,zi,ft,Od='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The flattened tensor.',Ji,Tt,Wd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",ji,Ri,Pi,ht,ki,_t,Ei,$t,Yd="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",Di,yt,Fd='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the same data but different shape',Ii,Mt,Xd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",qi,Ni,Vi,bt,Bi,vt,Ki,Ct,Gd="Transposes a tensor according to the provided axes.",Qi,xt,Zd='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The transposed tensor.',Si,Ht,ea="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to transpose.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to transpose the tensor along.</p></td></tr></tbody>",Oi,Wi,Yi,Lt,Fi,wt,Xi,At,ta="Interpolates an Tensor to the given size.",Gi,Ut,sa='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The interpolated tensor.',Zi,gt,la="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>",eo,to,so,zt,lo,Jt,no,jt,na="Perform mean pooling of the last hidden state followed by a normalization step.",io,Rt,ia='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns a new Tensor of shape [batchSize, embedDim].',oo,Pt,oa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>",ro,ao,uo,kt,mo,Et,po,Dt,ra="Concatenates an array of tensors along a specified dimension.",co,It,da='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The concatenated tensor.',fo,qt,aa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>",To,ho,_o,Nt,$o,Vt,yo,Bt,ua="Stack an array of tensors along a specified dimension.",Mo,Kt,ma='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The stacked tensor.',bo,Qt,pa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>",vo,Co,xo,St,Ho,Ot,Lo,Wt,ca="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",wo,Yt,fa='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Tensor&gt;</code> - A tuple of (std, mean) tensors.',Ao,Ft,Ta="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",Uo,go,zo,Xt,Jo,Gt,jo,Zt,ha="Returns the mean value of each row of the input tensor in the given dimension dim.",Ro,es,_a='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: A new tensor with means taken along the specified dimension.',Po,ts,$a="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",ko,Eo,Do,ss,Io,ls,qo,ns,ya=`Measures similarity between two temporal sequences (e.g., input audio and output tokens
to generate token-level timestamps).`,No,is,Ma='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Vo,os,ba="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>matrix</td><td><code>Tensor</code></td></tr></tbody>",Bo,Ko,Qo,rs,So,ds,Oo,as,va="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",Wo,us,Ca='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Yo,ms,xa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Fo,Xo,Go,ps,Zo,cs,er,fs,Ha="Returns a tensor filled with the scalar value 1, with the same size as input.",tr,Ts,La='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: The ones tensor.',sr,hs,wa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",lr,nr,ir,_s,or,$s,rr,ys,Aa='<strong>Kind</strong>: inner constant of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',dr,ar,ur,Ms,mr,bs,pr,vs,Ua="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",cr,Cs,ga='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',fr,xs,za="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array.&lt;T&gt;</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",Tr,Hs,Ja="<strong>Example</strong>",hr,Ls,_r,$r,yr,ws,Mr,As,br,Us,ja='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',vr,Cr,xr,gs,Hr,zs,Lr,Js,Ra='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',wr,Ar,Ur,js,gr,Rs,zr,Ps,Pa="This creates a nested array of a given type and depth (see examples).",Jr,ks,ka='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',jr,Es,Rr,Ds,Ea="<strong>Example</strong>",Pr,Is,kr,qs,Da="<strong>Example</strong>",Er,Ns,Dr,Ir,qr,Bs,Nr;return M=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),U=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),j=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),E=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),V=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),S=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),F=new _({props:{title:"tensor.item() ⇒ <code> number </code>",local:"tensoritem--code-number-code",headingTag:"h3"}}),te=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),ie=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ae=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ce=new _({props:{title:"tensor.transpose(...dims) ⇒ <code> Tensor </code>",local:"tensortransposedims--code-tensor-code",headingTag:"h3"}}),$e=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),Ce=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),Ae=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),je=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),De=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),Ve=new _({props:{title:"tensor.squeeze([dim]) ⇒",local:"tensorsqueezedim-",headingTag:"h3"}}),We=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),Ge=new _({props:{title:"tensor.unsqueeze(dim) ⇒",local:"tensorunsqueezedim-",headingTag:"h3"}}),nt=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),dt=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),pt=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒",local:"tensorflattenstartdim-enddim-",headingTag:"h3"}}),_t=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),vt=new _({props:{title:"utils/tensor.transpose(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensortransposetensor-axes--code-tensor-code",headingTag:"h2"}}),wt=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),Jt=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),Et=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),Vt=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),Ot=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),Gt=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒",local:"utilstensormeaninput-dim-keepdim-",headingTag:"h2"}}),ls=new _({props:{title:"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>",local:"utilstensordynamictimewarpingmatrix--code-array--array--number---code",headingTag:"h2"}}),ds=new _({props:{title:"utils/tensor.ones(size)",local:"utilstensoronessize",headingTag:"h2"}}),cs=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒",local:"utilstensoronesliketensor-",headingTag:"h2"}}),$s=new _({props:{title:"utils/tensor~ONNXTensor : <code> Object </code>",local:"utilstensoronnxtensor--code-object-code",headingTag:"h2"}}),bs=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),Ls=new Vr({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),As=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),zs=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),Rs=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),Es=new Vr({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),Is=new Vr({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),Ns=new Vr({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),{c(){$=o("meta"),Ks=n(),Vs=o("p"),Qs=n(),y=o("a"),Ss=n(),u(M.$$.fragment),Os=n(),b=o("p"),b.innerHTML=Kr,Ws=n(),v=o("p"),v.textContent=Qr,Ys=n(),C=o("ul"),C.innerHTML=Sr,Fs=n(),Xs=o("hr"),Gs=n(),x=o("a"),Zs=n(),u(H.$$.fragment),el=n(),L=o("p"),L.innerHTML=Or,tl=n(),w=o("ul"),w.innerHTML=Wr,sl=n(),ll=o("hr"),nl=n(),A=o("a"),il=n(),u(U.$$.fragment),ol=n(),g=o("p"),g.textContent=Yr,rl=n(),z=o("table"),z.innerHTML=Fr,dl=n(),al=o("hr"),ul=n(),J=o("a"),ml=n(),u(j.$$.fragment),pl=n(),R=o("p"),R.textContent=Xr,cl=n(),P=o("p"),P.innerHTML=Gr,fl=n(),Tl=o("hr"),hl=n(),k=o("a"),_l=n(),u(E.$$.fragment),$l=n(),D=o("p"),D.textContent=Zr,yl=n(),I=o("p"),I.innerHTML=ed,Ml=n(),q=o("table"),q.innerHTML=td,bl=n(),vl=o("hr"),Cl=n(),N=o("a"),xl=n(),u(V.$$.fragment),Hl=n(),B=o("p"),B.innerHTML=sd,Ll=n(),K=o("table"),K.innerHTML=ld,wl=n(),Al=o("hr"),Ul=n(),Q=o("a"),gl=n(),u(S.$$.fragment),zl=n(),O=o("p"),O.innerHTML=nd,Jl=n(),W=o("table"),W.innerHTML=id,jl=n(),Rl=o("hr"),Pl=n(),Y=o("a"),kl=n(),u(F.$$.fragment),El=n(),X=o("p"),X.innerHTML=od,Dl=n(),G=o("p"),G.innerHTML=rd,Il=n(),Z=o("ul"),Z.innerHTML=dd,ql=n(),Nl=o("hr"),Vl=n(),ee=o("a"),Bl=n(),u(te.$$.fragment),Kl=n(),se=o("p"),se.textContent=ad,Ql=n(),le=o("p"),le.innerHTML=ud,Sl=n(),Ol=o("hr"),Wl=n(),ne=o("a"),Yl=n(),u(ie.$$.fragment),Fl=n(),oe=o("p"),oe.textContent=md,Xl=n(),re=o("p"),re.innerHTML=pd,Gl=n(),Zl=o("hr"),en=n(),de=o("a"),tn=n(),u(ae.$$.fragment),sn=n(),ue=o("p"),ue.textContent=cd,ln=n(),me=o("p"),me.innerHTML=fd,nn=n(),on=o("hr"),rn=n(),pe=o("a"),dn=n(),u(ce.$$.fragment),an=n(),fe=o("p"),fe.textContent=Td,un=n(),Te=o("p"),Te.innerHTML=hd,mn=n(),he=o("table"),he.innerHTML=_d,pn=n(),cn=o("hr"),fn=n(),_e=o("a"),Tn=n(),u($e.$$.fragment),hn=n(),ye=o("p"),ye.textContent=$d,_n=n(),Me=o("p"),Me.innerHTML=yd,$n=n(),be=o("table"),be.innerHTML=Md,yn=n(),Mn=o("hr"),bn=n(),ve=o("a"),vn=n(),u(Ce.$$.fragment),Cn=n(),xe=o("p"),xe.textContent=bd,xn=n(),He=o("p"),He.innerHTML=vd,Hn=n(),Le=o("table"),Le.innerHTML=Cd,Ln=n(),wn=o("hr"),An=n(),we=o("a"),Un=n(),u(Ae.$$.fragment),gn=n(),Ue=o("p"),Ue.innerHTML=xd,zn=n(),ge=o("p"),ge.innerHTML=Hd,Jn=n(),ze=o("table"),ze.innerHTML=Ld,jn=n(),Rn=o("hr"),Pn=n(),Je=o("a"),kn=n(),u(je.$$.fragment),En=n(),Re=o("p"),Re.innerHTML=wd,Dn=n(),Pe=o("p"),Pe.innerHTML=Ad,In=n(),ke=o("table"),ke.innerHTML=Ud,qn=n(),Nn=o("hr"),Vn=n(),Ee=o("a"),Bn=n(),u(De.$$.fragment),Kn=n(),Ie=o("p"),Ie.textContent=gd,Qn=n(),qe=o("p"),qe.innerHTML=zd,Sn=n(),On=o("hr"),Wn=n(),Ne=o("a"),Yn=n(),u(Ve.$$.fragment),Fn=n(),Be=o("p"),Be.textContent=Jd,Xn=n(),Ke=o("p"),Ke.innerHTML=jd,Gn=n(),Qe=o("p"),Qe.innerHTML=Rd,Zn=n(),Se=o("table"),Se.innerHTML=Pd,ei=n(),ti=o("hr"),si=n(),Oe=o("a"),li=n(),u(We.$$.fragment),ni=n(),Ye=o("p"),Ye.innerHTML=kd,ii=n(),Fe=o("p"),Fe.innerHTML=Ed,oi=n(),ri=o("hr"),di=n(),Xe=o("a"),ai=n(),u(Ge.$$.fragment),ui=n(),Ze=o("p"),Ze.textContent=Dd,mi=n(),et=o("p"),et.textContent=Id,pi=n(),tt=o("p"),tt.innerHTML=qd,ci=n(),st=o("table"),st.innerHTML=Nd,fi=n(),Ti=o("hr"),hi=n(),lt=o("a"),_i=n(),u(nt.$$.fragment),$i=n(),it=o("p"),it.innerHTML=Vd,yi=n(),ot=o("p"),ot.innerHTML=Bd,Mi=n(),bi=o("hr"),vi=n(),rt=o("a"),Ci=n(),u(dt.$$.fragment),xi=n(),at=o("p"),at.innerHTML=Kd,Hi=n(),ut=o("p"),ut.innerHTML=Qd,Li=n(),wi=o("hr"),Ai=n(),mt=o("a"),Ui=n(),u(pt.$$.fragment),gi=n(),ct=o("p"),ct.innerHTML=Sd,zi=n(),ft=o("p"),ft.innerHTML=Od,Ji=n(),Tt=o("table"),Tt.innerHTML=Wd,ji=n(),Ri=o("hr"),Pi=n(),ht=o("a"),ki=n(),u(_t.$$.fragment),Ei=n(),$t=o("p"),$t.innerHTML=Yd,Di=n(),yt=o("p"),yt.innerHTML=Fd,Ii=n(),Mt=o("table"),Mt.innerHTML=Xd,qi=n(),Ni=o("hr"),Vi=n(),bt=o("a"),Bi=n(),u(vt.$$.fragment),Ki=n(),Ct=o("p"),Ct.textContent=Gd,Qi=n(),xt=o("p"),xt.innerHTML=Zd,Si=n(),Ht=o("table"),Ht.innerHTML=ea,Oi=n(),Wi=o("hr"),Yi=n(),Lt=o("a"),Fi=n(),u(wt.$$.fragment),Xi=n(),At=o("p"),At.textContent=ta,Gi=n(),Ut=o("p"),Ut.innerHTML=sa,Zi=n(),gt=o("table"),gt.innerHTML=la,eo=n(),to=o("hr"),so=n(),zt=o("a"),lo=n(),u(Jt.$$.fragment),no=n(),jt=o("p"),jt.textContent=na,io=n(),Rt=o("p"),Rt.innerHTML=ia,oo=n(),Pt=o("table"),Pt.innerHTML=oa,ro=n(),ao=o("hr"),uo=n(),kt=o("a"),mo=n(),u(Et.$$.fragment),po=n(),Dt=o("p"),Dt.textContent=ra,co=n(),It=o("p"),It.innerHTML=da,fo=n(),qt=o("table"),qt.innerHTML=aa,To=n(),ho=o("hr"),_o=n(),Nt=o("a"),$o=n(),u(Vt.$$.fragment),yo=n(),Bt=o("p"),Bt.textContent=ua,Mo=n(),Kt=o("p"),Kt.innerHTML=ma,bo=n(),Qt=o("table"),Qt.innerHTML=pa,vo=n(),Co=o("hr"),xo=n(),St=o("a"),Ho=n(),u(Ot.$$.fragment),Lo=n(),Wt=o("p"),Wt.innerHTML=ca,wo=n(),Yt=o("p"),Yt.innerHTML=fa,Ao=n(),Ft=o("table"),Ft.innerHTML=Ta,Uo=n(),go=o("hr"),zo=n(),Xt=o("a"),Jo=n(),u(Gt.$$.fragment),jo=n(),Zt=o("p"),Zt.textContent=ha,Ro=n(),es=o("p"),es.innerHTML=_a,Po=n(),ts=o("table"),ts.innerHTML=$a,ko=n(),Eo=o("hr"),Do=n(),ss=o("a"),Io=n(),u(ls.$$.fragment),qo=n(),ns=o("p"),ns.textContent=ya,No=n(),is=o("p"),is.innerHTML=Ma,Vo=n(),os=o("table"),os.innerHTML=ba,Bo=n(),Ko=o("hr"),Qo=n(),rs=o("a"),So=n(),u(ds.$$.fragment),Oo=n(),as=o("p"),as.textContent=va,Wo=n(),us=o("p"),us.innerHTML=Ca,Yo=n(),ms=o("table"),ms.innerHTML=xa,Fo=n(),Xo=o("hr"),Go=n(),ps=o("a"),Zo=n(),u(cs.$$.fragment),er=n(),fs=o("p"),fs.textContent=Ha,tr=n(),Ts=o("p"),Ts.innerHTML=La,sr=n(),hs=o("table"),hs.innerHTML=wa,lr=n(),nr=o("hr"),ir=n(),_s=o("a"),or=n(),u($s.$$.fragment),rr=n(),ys=o("p"),ys.innerHTML=Aa,dr=n(),ar=o("hr"),ur=n(),Ms=o("a"),mr=n(),u(bs.$$.fragment),pr=n(),vs=o("p"),vs.textContent=Ua,cr=n(),Cs=o("p"),Cs.innerHTML=ga,fr=n(),xs=o("table"),xs.innerHTML=za,Tr=n(),Hs=o("p"),Hs.innerHTML=Ja,hr=n(),u(Ls.$$.fragment),_r=n(),$r=o("hr"),yr=n(),ws=o("a"),Mr=n(),u(As.$$.fragment),br=n(),Us=o("p"),Us.innerHTML=ja,vr=n(),Cr=o("hr"),xr=n(),gs=o("a"),Hr=n(),u(zs.$$.fragment),Lr=n(),Js=o("p"),Js.innerHTML=Ra,wr=n(),Ar=o("hr"),Ur=n(),js=o("a"),gr=n(),u(Rs.$$.fragment),zr=n(),Ps=o("p"),Ps.textContent=Pa,Jr=n(),ks=o("p"),ks.innerHTML=ka,jr=n(),u(Es.$$.fragment),Rr=n(),Ds=o("p"),Ds.innerHTML=Ea,Pr=n(),u(Is.$$.fragment),kr=n(),qs=o("p"),qs.innerHTML=Da,Er=n(),u(Ns.$$.fragment),Dr=n(),Ir=o("hr"),qr=n(),Bs=o("p"),this.h()},l(e){const t=Ka("svelte-u9bgzb",document.head);$=r(t,"META",{name:!0,content:!0}),t.forEach(s),Ks=i(e),Vs=r(e,"P",{}),h(Vs).forEach(s),Qs=i(e),y=r(e,"A",{id:!0,class:!0}),h(y).forEach(s),Ss=i(e),m(M.$$.fragment,e),Os=i(e),b=r(e,"P",{"data-svelte-h":!0}),d(b)!=="svelte-uw4y1m"&&(b.innerHTML=Kr),Ws=i(e),v=r(e,"P",{"data-svelte-h":!0}),d(v)!=="svelte-il3kl8"&&(v.textContent=Qr),Ys=i(e),C=r(e,"UL",{"data-svelte-h":!0}),d(C)!=="svelte-4salf7"&&(C.innerHTML=Sr),Fs=i(e),Xs=r(e,"HR",{}),Gs=i(e),x=r(e,"A",{id:!0,class:!0}),h(x).forEach(s),Zs=i(e),m(H.$$.fragment,e),el=i(e),L=r(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1ugrfrw"&&(L.innerHTML=Or),tl=i(e),w=r(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-1mit4ax"&&(w.innerHTML=Wr),sl=i(e),ll=r(e,"HR",{}),nl=i(e),A=r(e,"A",{id:!0,class:!0}),h(A).forEach(s),il=i(e),m(U.$$.fragment,e),ol=i(e),g=r(e,"P",{"data-svelte-h":!0}),d(g)!=="svelte-55wecd"&&(g.textContent=Yr),rl=i(e),z=r(e,"TABLE",{"data-svelte-h":!0}),d(z)!=="svelte-ee7emz"&&(z.innerHTML=Fr),dl=i(e),al=r(e,"HR",{}),ul=i(e),J=r(e,"A",{id:!0,class:!0}),h(J).forEach(s),ml=i(e),m(j.$$.fragment,e),pl=i(e),R=r(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1adn56z"&&(R.textContent=Xr),cl=i(e),P=r(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-1gxgvk6"&&(P.innerHTML=Gr),fl=i(e),Tl=r(e,"HR",{}),hl=i(e),k=r(e,"A",{id:!0,class:!0}),h(k).forEach(s),_l=i(e),m(E.$$.fragment,e),$l=i(e),D=r(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-1u97xg1"&&(D.textContent=Zr),yl=i(e),I=r(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-1afa2dz"&&(I.innerHTML=ed),Ml=i(e),q=r(e,"TABLE",{"data-svelte-h":!0}),d(q)!=="svelte-1kq04ga"&&(q.innerHTML=td),bl=i(e),vl=r(e,"HR",{}),Cl=i(e),N=r(e,"A",{id:!0,class:!0}),h(N).forEach(s),xl=i(e),m(V.$$.fragment,e),Hl=i(e),B=r(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1cg22af"&&(B.innerHTML=sd),Ll=i(e),K=r(e,"TABLE",{"data-svelte-h":!0}),d(K)!=="svelte-1hful42"&&(K.innerHTML=ld),wl=i(e),Al=r(e,"HR",{}),Ul=i(e),Q=r(e,"A",{id:!0,class:!0}),h(Q).forEach(s),gl=i(e),m(S.$$.fragment,e),zl=i(e),O=r(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1mr58c3"&&(O.innerHTML=nd),Jl=i(e),W=r(e,"TABLE",{"data-svelte-h":!0}),d(W)!=="svelte-153ftfy"&&(W.innerHTML=id),jl=i(e),Rl=r(e,"HR",{}),Pl=i(e),Y=r(e,"A",{id:!0,class:!0}),h(Y).forEach(s),kl=i(e),m(F.$$.fragment,e),El=i(e),X=r(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-13nzfs3"&&(X.innerHTML=od),Dl=i(e),G=r(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-18jnqwq"&&(G.innerHTML=rd),Il=i(e),Z=r(e,"UL",{"data-svelte-h":!0}),d(Z)!=="svelte-5t2sg3"&&(Z.innerHTML=dd),ql=i(e),Nl=r(e,"HR",{}),Vl=i(e),ee=r(e,"A",{id:!0,class:!0}),h(ee).forEach(s),Bl=i(e),m(te.$$.fragment,e),Kl=i(e),se=r(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-87xdyr"&&(se.textContent=ad),Ql=i(e),le=r(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1mr58c3"&&(le.innerHTML=ud),Sl=i(e),Ol=r(e,"HR",{}),Wl=i(e),ne=r(e,"A",{id:!0,class:!0}),h(ne).forEach(s),Yl=i(e),m(ie.$$.fragment,e),Fl=i(e),oe=r(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-2wti2w"&&(oe.textContent=md),Xl=i(e),re=r(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-kpq7mo"&&(re.innerHTML=pd),Gl=i(e),Zl=r(e,"HR",{}),en=i(e),de=r(e,"A",{id:!0,class:!0}),h(de).forEach(s),tn=i(e),m(ae.$$.fragment,e),sn=i(e),ue=r(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1edu6c8"&&(ue.textContent=cd),ln=i(e),me=r(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1hc4oxa"&&(me.innerHTML=fd),nn=i(e),on=r(e,"HR",{}),rn=i(e),pe=r(e,"A",{id:!0,class:!0}),h(pe).forEach(s),dn=i(e),m(ce.$$.fragment,e),an=i(e),fe=r(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-lesh1u"&&(fe.textContent=Td),un=i(e),Te=r(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-rvzl1t"&&(Te.innerHTML=hd),mn=i(e),he=r(e,"TABLE",{"data-svelte-h":!0}),d(he)!=="svelte-onq75m"&&(he.innerHTML=_d),pn=i(e),cn=r(e,"HR",{}),fn=i(e),_e=r(e,"A",{id:!0,class:!0}),h(_e).forEach(s),Tn=i(e),m($e.$$.fragment,e),hn=i(e),ye=r(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-yjryb1"&&(ye.textContent=$d),_n=i(e),Me=r(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-xtr8tc"&&(Me.innerHTML=yd),$n=i(e),be=r(e,"TABLE",{"data-svelte-h":!0}),d(be)!=="svelte-6xvdso"&&(be.innerHTML=Md),yn=i(e),Mn=r(e,"HR",{}),bn=i(e),ve=r(e,"A",{id:!0,class:!0}),h(ve).forEach(s),vn=i(e),m(Ce.$$.fragment,e),Cn=i(e),xe=r(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1okfsqx"&&(xe.textContent=bd),xn=i(e),He=r(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-1t556pk"&&(He.innerHTML=vd),Hn=i(e),Le=r(e,"TABLE",{"data-svelte-h":!0}),d(Le)!=="svelte-13m2wni"&&(Le.innerHTML=Cd),Ln=i(e),wn=r(e,"HR",{}),An=i(e),we=r(e,"A",{id:!0,class:!0}),h(we).forEach(s),Un=i(e),m(Ae.$$.fragment,e),gn=i(e),Ue=r(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1htpbrk"&&(Ue.innerHTML=xd),zn=i(e),ge=r(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-1t0m8l6"&&(ge.innerHTML=Hd),Jn=i(e),ze=r(e,"TABLE",{"data-svelte-h":!0}),d(ze)!=="svelte-1qi99pl"&&(ze.innerHTML=Ld),jn=i(e),Rn=r(e,"HR",{}),Pn=i(e),Je=r(e,"A",{id:!0,class:!0}),h(Je).forEach(s),kn=i(e),m(je.$$.fragment,e),En=i(e),Re=r(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-1ztgqp"&&(Re.innerHTML=wd),Dn=i(e),Pe=r(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-mvb39p"&&(Pe.innerHTML=Ad),In=i(e),ke=r(e,"TABLE",{"data-svelte-h":!0}),d(ke)!=="svelte-1qi99pl"&&(ke.innerHTML=Ud),qn=i(e),Nn=r(e,"HR",{}),Vn=i(e),Ee=r(e,"A",{id:!0,class:!0}),h(Ee).forEach(s),Bn=i(e),m(De.$$.fragment,e),Kn=i(e),Ie=r(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1a7u185"&&(Ie.textContent=gd),Qn=i(e),qe=r(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1eu3doh"&&(qe.innerHTML=zd),Sn=i(e),On=r(e,"HR",{}),Wn=i(e),Ne=r(e,"A",{id:!0,class:!0}),h(Ne).forEach(s),Yn=i(e),m(Ve.$$.fragment,e),Fn=i(e),Be=r(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-qls17b"&&(Be.textContent=Jd),Xn=i(e),Ke=r(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-5nabmy"&&(Ke.innerHTML=jd),Gn=i(e),Qe=r(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1skbfxl"&&(Qe.innerHTML=Rd),Zn=i(e),Se=r(e,"TABLE",{"data-svelte-h":!0}),d(Se)!=="svelte-52pnzr"&&(Se.innerHTML=Pd),ei=i(e),ti=r(e,"HR",{}),si=i(e),Oe=r(e,"A",{id:!0,class:!0}),h(Oe).forEach(s),li=i(e),m(We.$$.fragment,e),ni=i(e),Ye=r(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-19w0pic"&&(Ye.innerHTML=kd),ii=i(e),Fe=r(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1mr58c3"&&(Fe.innerHTML=Ed),oi=i(e),ri=r(e,"HR",{}),di=i(e),Xe=r(e,"A",{id:!0,class:!0}),h(Xe).forEach(s),ai=i(e),m(Ge.$$.fragment,e),ui=i(e),Ze=r(e,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-18ws76n"&&(Ze.textContent=Dd),mi=i(e),et=r(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-1tnr5gm"&&(et.textContent=Id),pi=i(e),tt=r(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1aoa5jo"&&(tt.innerHTML=qd),ci=i(e),st=r(e,"TABLE",{"data-svelte-h":!0}),d(st)!=="svelte-1u9lyxp"&&(st.innerHTML=Nd),fi=i(e),Ti=r(e,"HR",{}),hi=i(e),lt=r(e,"A",{id:!0,class:!0}),h(lt).forEach(s),_i=i(e),m(nt.$$.fragment,e),$i=i(e),it=r(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1b9ygao"&&(it.innerHTML=Vd),yi=i(e),ot=r(e,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-1mr58c3"&&(ot.innerHTML=Bd),Mi=i(e),bi=r(e,"HR",{}),vi=i(e),rt=r(e,"A",{id:!0,class:!0}),h(rt).forEach(s),Ci=i(e),m(dt.$$.fragment,e),xi=i(e),at=r(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-1vkr5xo"&&(at.innerHTML=Kd),Hi=i(e),ut=r(e,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-1mr58c3"&&(ut.innerHTML=Qd),Li=i(e),wi=r(e,"HR",{}),Ai=i(e),mt=r(e,"A",{id:!0,class:!0}),h(mt).forEach(s),Ui=i(e),m(pt.$$.fragment,e),gi=i(e),ct=r(e,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-1gguudf"&&(ct.innerHTML=Sd),zi=i(e),ft=r(e,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-9ffe42"&&(ft.innerHTML=Od),Ji=i(e),Tt=r(e,"TABLE",{"data-svelte-h":!0}),d(Tt)!=="svelte-z6whez"&&(Tt.innerHTML=Wd),ji=i(e),Ri=r(e,"HR",{}),Pi=i(e),ht=r(e,"A",{id:!0,class:!0}),h(ht).forEach(s),ki=i(e),m(_t.$$.fragment,e),Ei=i(e),$t=r(e,"P",{"data-svelte-h":!0}),d($t)!=="svelte-d6gvut"&&($t.innerHTML=Yd),Di=i(e),yt=r(e,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-18n9ux4"&&(yt.innerHTML=Fd),Ii=i(e),Mt=r(e,"TABLE",{"data-svelte-h":!0}),d(Mt)!=="svelte-jj58dd"&&(Mt.innerHTML=Xd),qi=i(e),Ni=r(e,"HR",{}),Vi=i(e),bt=r(e,"A",{id:!0,class:!0}),h(bt).forEach(s),Bi=i(e),m(vt.$$.fragment,e),Ki=i(e),Ct=r(e,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-15z3tv8"&&(Ct.textContent=Gd),Qi=i(e),xt=r(e,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-sv4gxb"&&(xt.innerHTML=Zd),Si=i(e),Ht=r(e,"TABLE",{"data-svelte-h":!0}),d(Ht)!=="svelte-q8pfpb"&&(Ht.innerHTML=ea),Oi=i(e),Wi=r(e,"HR",{}),Yi=i(e),Lt=r(e,"A",{id:!0,class:!0}),h(Lt).forEach(s),Fi=i(e),m(wt.$$.fragment,e),Xi=i(e),At=r(e,"P",{"data-svelte-h":!0}),d(At)!=="svelte-fju8tm"&&(At.textContent=ta),Gi=i(e),Ut=r(e,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-13s6o0v"&&(Ut.innerHTML=sa),Zi=i(e),gt=r(e,"TABLE",{"data-svelte-h":!0}),d(gt)!=="svelte-8i278m"&&(gt.innerHTML=la),eo=i(e),to=r(e,"HR",{}),so=i(e),zt=r(e,"A",{id:!0,class:!0}),h(zt).forEach(s),lo=i(e),m(Jt.$$.fragment,e),no=i(e),jt=r(e,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-11ei68w"&&(jt.textContent=na),io=i(e),Rt=r(e,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-1p3llh"&&(Rt.innerHTML=ia),oo=i(e),Pt=r(e,"TABLE",{"data-svelte-h":!0}),d(Pt)!=="svelte-1xe0vb8"&&(Pt.innerHTML=oa),ro=i(e),ao=r(e,"HR",{}),uo=i(e),kt=r(e,"A",{id:!0,class:!0}),h(kt).forEach(s),mo=i(e),m(Et.$$.fragment,e),po=i(e),Dt=r(e,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-k6p1db"&&(Dt.textContent=ra),co=i(e),It=r(e,"P",{"data-svelte-h":!0}),d(It)!=="svelte-1o30xnd"&&(It.innerHTML=da),fo=i(e),qt=r(e,"TABLE",{"data-svelte-h":!0}),d(qt)!=="svelte-101obk2"&&(qt.innerHTML=aa),To=i(e),ho=r(e,"HR",{}),_o=i(e),Nt=r(e,"A",{id:!0,class:!0}),h(Nt).forEach(s),$o=i(e),m(Vt.$$.fragment,e),yo=i(e),Bt=r(e,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-8afo9v"&&(Bt.textContent=ua),Mo=i(e),Kt=r(e,"P",{"data-svelte-h":!0}),d(Kt)!=="svelte-1vvmhgz"&&(Kt.innerHTML=ma),bo=i(e),Qt=r(e,"TABLE",{"data-svelte-h":!0}),d(Qt)!=="svelte-wz2jkw"&&(Qt.innerHTML=pa),vo=i(e),Co=r(e,"HR",{}),xo=i(e),St=r(e,"A",{id:!0,class:!0}),h(St).forEach(s),Ho=i(e),m(Ot.$$.fragment,e),Lo=i(e),Wt=r(e,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-11plveb"&&(Wt.innerHTML=ca),wo=i(e),Yt=r(e,"P",{"data-svelte-h":!0}),d(Yt)!=="svelte-1wu8g4g"&&(Yt.innerHTML=fa),Ao=i(e),Ft=r(e,"TABLE",{"data-svelte-h":!0}),d(Ft)!=="svelte-1vsvca3"&&(Ft.innerHTML=Ta),Uo=i(e),go=r(e,"HR",{}),zo=i(e),Xt=r(e,"A",{id:!0,class:!0}),h(Xt).forEach(s),Jo=i(e),m(Gt.$$.fragment,e),jo=i(e),Zt=r(e,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-17f4oxi"&&(Zt.textContent=ha),Ro=i(e),es=r(e,"P",{"data-svelte-h":!0}),d(es)!=="svelte-1lh8r1a"&&(es.innerHTML=_a),Po=i(e),ts=r(e,"TABLE",{"data-svelte-h":!0}),d(ts)!=="svelte-m4z8c4"&&(ts.innerHTML=$a),ko=i(e),Eo=r(e,"HR",{}),Do=i(e),ss=r(e,"A",{id:!0,class:!0}),h(ss).forEach(s),Io=i(e),m(ls.$$.fragment,e),qo=i(e),ns=r(e,"P",{"data-svelte-h":!0}),d(ns)!=="svelte-kcewlk"&&(ns.textContent=ya),No=i(e),is=r(e,"P",{"data-svelte-h":!0}),d(is)!=="svelte-17f480h"&&(is.innerHTML=Ma),Vo=i(e),os=r(e,"TABLE",{"data-svelte-h":!0}),d(os)!=="svelte-1to7jw8"&&(os.innerHTML=ba),Bo=i(e),Ko=r(e,"HR",{}),Qo=i(e),rs=r(e,"A",{id:!0,class:!0}),h(rs).forEach(s),So=i(e),m(ds.$$.fragment,e),Oo=i(e),as=r(e,"P",{"data-svelte-h":!0}),d(as)!=="svelte-1ayje0f"&&(as.textContent=va),Wo=i(e),us=r(e,"P",{"data-svelte-h":!0}),d(us)!=="svelte-17f480h"&&(us.innerHTML=Ca),Yo=i(e),ms=r(e,"TABLE",{"data-svelte-h":!0}),d(ms)!=="svelte-gyxne1"&&(ms.innerHTML=xa),Fo=i(e),Xo=r(e,"HR",{}),Go=i(e),ps=r(e,"A",{id:!0,class:!0}),h(ps).forEach(s),Zo=i(e),m(cs.$$.fragment,e),er=i(e),fs=r(e,"P",{"data-svelte-h":!0}),d(fs)!=="svelte-1wvb8sq"&&(fs.textContent=Ha),tr=i(e),Ts=r(e,"P",{"data-svelte-h":!0}),d(Ts)!=="svelte-154yhp4"&&(Ts.innerHTML=La),sr=i(e),hs=r(e,"TABLE",{"data-svelte-h":!0}),d(hs)!=="svelte-1fk5fng"&&(hs.innerHTML=wa),lr=i(e),nr=r(e,"HR",{}),ir=i(e),_s=r(e,"A",{id:!0,class:!0}),h(_s).forEach(s),or=i(e),m($s.$$.fragment,e),rr=i(e),ys=r(e,"P",{"data-svelte-h":!0}),d(ys)!=="svelte-l5lzdu"&&(ys.innerHTML=Aa),dr=i(e),ar=r(e,"HR",{}),ur=i(e),Ms=r(e,"A",{id:!0,class:!0}),h(Ms).forEach(s),mr=i(e),m(bs.$$.fragment,e),pr=i(e),vs=r(e,"P",{"data-svelte-h":!0}),d(vs)!=="svelte-40isdg"&&(vs.textContent=Ua),cr=i(e),Cs=r(e,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-tlsa2h"&&(Cs.innerHTML=ga),fr=i(e),xs=r(e,"TABLE",{"data-svelte-h":!0}),d(xs)!=="svelte-1j7v21a"&&(xs.innerHTML=za),Tr=i(e),Hs=r(e,"P",{"data-svelte-h":!0}),d(Hs)!=="svelte-1aswmub"&&(Hs.innerHTML=Ja),hr=i(e),m(Ls.$$.fragment,e),_r=i(e),$r=r(e,"HR",{}),yr=i(e),ws=r(e,"A",{id:!0,class:!0}),h(ws).forEach(s),Mr=i(e),m(As.$$.fragment,e),br=i(e),Us=r(e,"P",{"data-svelte-h":!0}),d(Us)!=="svelte-kp31r8"&&(Us.innerHTML=ja),vr=i(e),Cr=r(e,"HR",{}),xr=i(e),gs=r(e,"A",{id:!0,class:!0}),h(gs).forEach(s),Hr=i(e),m(zs.$$.fragment,e),Lr=i(e),Js=r(e,"P",{"data-svelte-h":!0}),d(Js)!=="svelte-1fs9no9"&&(Js.innerHTML=Ra),wr=i(e),Ar=r(e,"HR",{}),Ur=i(e),js=r(e,"A",{id:!0,class:!0}),h(js).forEach(s),gr=i(e),m(Rs.$$.fragment,e),zr=i(e),Ps=r(e,"P",{"data-svelte-h":!0}),d(Ps)!=="svelte-2mif9c"&&(Ps.textContent=Pa),Jr=i(e),ks=r(e,"P",{"data-svelte-h":!0}),d(ks)!=="svelte-1jas2kw"&&(ks.innerHTML=ka),jr=i(e),m(Es.$$.fragment,e),Rr=i(e),Ds=r(e,"P",{"data-svelte-h":!0}),d(Ds)!=="svelte-1aswmub"&&(Ds.innerHTML=Ea),Pr=i(e),m(Is.$$.fragment,e),kr=i(e),qs=r(e,"P",{"data-svelte-h":!0}),d(qs)!=="svelte-1aswmub"&&(qs.innerHTML=Da),Er=i(e),m(Ns.$$.fragment,e),Dr=i(e),Ir=r(e,"HR",{}),qr=i(e),Bs=r(e,"P",{}),h(Bs).forEach(s),this.h()},h(){a($,"name","hf:doc:metadata"),a($,"content",Oa),a(y,"id","module_utils/tensor"),a(y,"class","group"),a(x,"id","module_utils/tensor.Tensor"),a(x,"class","group"),a(A,"id","new_module_utils/tensor.Tensor_new"),a(A,"class","group"),a(J,"id","module_utils/tensor.Tensor+Symbol.iterator"),a(J,"class","group"),a(k,"id","module_utils/tensor.Tensor+_getitem"),a(k,"class","group"),a(N,"id","module_utils/tensor.Tensor+indexOf"),a(N,"class","group"),a(Q,"id","module_utils/tensor.Tensor+_subarray"),a(Q,"class","group"),a(Y,"id","module_utils/tensor.Tensor+item"),a(Y,"class","group"),a(ee,"id","module_utils/tensor.Tensor+tolist"),a(ee,"class","group"),a(ne,"id","module_utils/tensor.Tensor+sigmoid"),a(ne,"class","group"),a(de,"id","module_utils/tensor.Tensor+sigmoid_"),a(de,"class","group"),a(pe,"id","module_utils/tensor.Tensor+transpose"),a(pe,"class","group"),a(_e,"id","module_utils/tensor.Tensor+sum"),a(_e,"class","group"),a(ve,"id","module_utils/tensor.Tensor+norm"),a(ve,"class","group"),a(we,"id","module_utils/tensor.Tensor+normalize_"),a(we,"class","group"),a(Je,"id","module_utils/tensor.Tensor+normalize"),a(Je,"class","group"),a(Ee,"id","module_utils/tensor.Tensor+stride"),a(Ee,"class","group"),a(Ne,"id","module_utils/tensor.Tensor+squeeze"),a(Ne,"class","group"),a(Oe,"id","module_utils/tensor.Tensor+squeeze_"),a(Oe,"class","group"),a(Xe,"id","module_utils/tensor.Tensor+unsqueeze"),a(Xe,"class","group"),a(lt,"id","module_utils/tensor.Tensor+unsqueeze_"),a(lt,"class","group"),a(rt,"id","module_utils/tensor.Tensor+flatten_"),a(rt,"class","group"),a(mt,"id","module_utils/tensor.Tensor+flatten"),a(mt,"class","group"),a(ht,"id","module_utils/tensor.Tensor+view"),a(ht,"class","group"),a(bt,"id","module_utils/tensor.transpose"),a(bt,"class","group"),a(Lt,"id","module_utils/tensor.interpolate"),a(Lt,"class","group"),a(zt,"id","module_utils/tensor.mean_pooling"),a(zt,"class","group"),a(kt,"id","module_utils/tensor.cat"),a(kt,"class","group"),a(Nt,"id","module_utils/tensor.stack"),a(Nt,"class","group"),a(St,"id","module_utils/tensor.std_mean"),a(St,"class","group"),a(Xt,"id","module_utils/tensor.mean"),a(Xt,"class","group"),a(ss,"id","module_utils/tensor.dynamicTimeWarping"),a(ss,"class","group"),a(rs,"id","module_utils/tensor.ones"),a(rs,"class","group"),a(ps,"id","module_utils/tensor.ones_like"),a(ps,"class","group"),a(_s,"id","module_utils/tensor..ONNXTensor"),a(_s,"class","group"),a(Ms,"id","module_utils/tensor..reshape"),a(Ms,"class","group"),a(ws,"id","module_utils/tensor..reshape..reshapedArray"),a(ws,"class","group"),a(gs,"id","module_utils/tensor..DataArray"),a(gs,"class","group"),a(js,"id","module_utils/tensor..NestArray"),a(js,"class","group")},m(e,t){Qa(document.head,$),l(e,Ks,t),l(e,Vs,t),l(e,Qs,t),l(e,y,t),l(e,Ss,t),p(M,e,t),l(e,Os,t),l(e,b,t),l(e,Ws,t),l(e,v,t),l(e,Ys,t),l(e,C,t),l(e,Fs,t),l(e,Xs,t),l(e,Gs,t),l(e,x,t),l(e,Zs,t),p(H,e,t),l(e,el,t),l(e,L,t),l(e,tl,t),l(e,w,t),l(e,sl,t),l(e,ll,t),l(e,nl,t),l(e,A,t),l(e,il,t),p(U,e,t),l(e,ol,t),l(e,g,t),l(e,rl,t),l(e,z,t),l(e,dl,t),l(e,al,t),l(e,ul,t),l(e,J,t),l(e,ml,t),p(j,e,t),l(e,pl,t),l(e,R,t),l(e,cl,t),l(e,P,t),l(e,fl,t),l(e,Tl,t),l(e,hl,t),l(e,k,t),l(e,_l,t),p(E,e,t),l(e,$l,t),l(e,D,t),l(e,yl,t),l(e,I,t),l(e,Ml,t),l(e,q,t),l(e,bl,t),l(e,vl,t),l(e,Cl,t),l(e,N,t),l(e,xl,t),p(V,e,t),l(e,Hl,t),l(e,B,t),l(e,Ll,t),l(e,K,t),l(e,wl,t),l(e,Al,t),l(e,Ul,t),l(e,Q,t),l(e,gl,t),p(S,e,t),l(e,zl,t),l(e,O,t),l(e,Jl,t),l(e,W,t),l(e,jl,t),l(e,Rl,t),l(e,Pl,t),l(e,Y,t),l(e,kl,t),p(F,e,t),l(e,El,t),l(e,X,t),l(e,Dl,t),l(e,G,t),l(e,Il,t),l(e,Z,t),l(e,ql,t),l(e,Nl,t),l(e,Vl,t),l(e,ee,t),l(e,Bl,t),p(te,e,t),l(e,Kl,t),l(e,se,t),l(e,Ql,t),l(e,le,t),l(e,Sl,t),l(e,Ol,t),l(e,Wl,t),l(e,ne,t),l(e,Yl,t),p(ie,e,t),l(e,Fl,t),l(e,oe,t),l(e,Xl,t),l(e,re,t),l(e,Gl,t),l(e,Zl,t),l(e,en,t),l(e,de,t),l(e,tn,t),p(ae,e,t),l(e,sn,t),l(e,ue,t),l(e,ln,t),l(e,me,t),l(e,nn,t),l(e,on,t),l(e,rn,t),l(e,pe,t),l(e,dn,t),p(ce,e,t),l(e,an,t),l(e,fe,t),l(e,un,t),l(e,Te,t),l(e,mn,t),l(e,he,t),l(e,pn,t),l(e,cn,t),l(e,fn,t),l(e,_e,t),l(e,Tn,t),p($e,e,t),l(e,hn,t),l(e,ye,t),l(e,_n,t),l(e,Me,t),l(e,$n,t),l(e,be,t),l(e,yn,t),l(e,Mn,t),l(e,bn,t),l(e,ve,t),l(e,vn,t),p(Ce,e,t),l(e,Cn,t),l(e,xe,t),l(e,xn,t),l(e,He,t),l(e,Hn,t),l(e,Le,t),l(e,Ln,t),l(e,wn,t),l(e,An,t),l(e,we,t),l(e,Un,t),p(Ae,e,t),l(e,gn,t),l(e,Ue,t),l(e,zn,t),l(e,ge,t),l(e,Jn,t),l(e,ze,t),l(e,jn,t),l(e,Rn,t),l(e,Pn,t),l(e,Je,t),l(e,kn,t),p(je,e,t),l(e,En,t),l(e,Re,t),l(e,Dn,t),l(e,Pe,t),l(e,In,t),l(e,ke,t),l(e,qn,t),l(e,Nn,t),l(e,Vn,t),l(e,Ee,t),l(e,Bn,t),p(De,e,t),l(e,Kn,t),l(e,Ie,t),l(e,Qn,t),l(e,qe,t),l(e,Sn,t),l(e,On,t),l(e,Wn,t),l(e,Ne,t),l(e,Yn,t),p(Ve,e,t),l(e,Fn,t),l(e,Be,t),l(e,Xn,t),l(e,Ke,t),l(e,Gn,t),l(e,Qe,t),l(e,Zn,t),l(e,Se,t),l(e,ei,t),l(e,ti,t),l(e,si,t),l(e,Oe,t),l(e,li,t),p(We,e,t),l(e,ni,t),l(e,Ye,t),l(e,ii,t),l(e,Fe,t),l(e,oi,t),l(e,ri,t),l(e,di,t),l(e,Xe,t),l(e,ai,t),p(Ge,e,t),l(e,ui,t),l(e,Ze,t),l(e,mi,t),l(e,et,t),l(e,pi,t),l(e,tt,t),l(e,ci,t),l(e,st,t),l(e,fi,t),l(e,Ti,t),l(e,hi,t),l(e,lt,t),l(e,_i,t),p(nt,e,t),l(e,$i,t),l(e,it,t),l(e,yi,t),l(e,ot,t),l(e,Mi,t),l(e,bi,t),l(e,vi,t),l(e,rt,t),l(e,Ci,t),p(dt,e,t),l(e,xi,t),l(e,at,t),l(e,Hi,t),l(e,ut,t),l(e,Li,t),l(e,wi,t),l(e,Ai,t),l(e,mt,t),l(e,Ui,t),p(pt,e,t),l(e,gi,t),l(e,ct,t),l(e,zi,t),l(e,ft,t),l(e,Ji,t),l(e,Tt,t),l(e,ji,t),l(e,Ri,t),l(e,Pi,t),l(e,ht,t),l(e,ki,t),p(_t,e,t),l(e,Ei,t),l(e,$t,t),l(e,Di,t),l(e,yt,t),l(e,Ii,t),l(e,Mt,t),l(e,qi,t),l(e,Ni,t),l(e,Vi,t),l(e,bt,t),l(e,Bi,t),p(vt,e,t),l(e,Ki,t),l(e,Ct,t),l(e,Qi,t),l(e,xt,t),l(e,Si,t),l(e,Ht,t),l(e,Oi,t),l(e,Wi,t),l(e,Yi,t),l(e,Lt,t),l(e,Fi,t),p(wt,e,t),l(e,Xi,t),l(e,At,t),l(e,Gi,t),l(e,Ut,t),l(e,Zi,t),l(e,gt,t),l(e,eo,t),l(e,to,t),l(e,so,t),l(e,zt,t),l(e,lo,t),p(Jt,e,t),l(e,no,t),l(e,jt,t),l(e,io,t),l(e,Rt,t),l(e,oo,t),l(e,Pt,t),l(e,ro,t),l(e,ao,t),l(e,uo,t),l(e,kt,t),l(e,mo,t),p(Et,e,t),l(e,po,t),l(e,Dt,t),l(e,co,t),l(e,It,t),l(e,fo,t),l(e,qt,t),l(e,To,t),l(e,ho,t),l(e,_o,t),l(e,Nt,t),l(e,$o,t),p(Vt,e,t),l(e,yo,t),l(e,Bt,t),l(e,Mo,t),l(e,Kt,t),l(e,bo,t),l(e,Qt,t),l(e,vo,t),l(e,Co,t),l(e,xo,t),l(e,St,t),l(e,Ho,t),p(Ot,e,t),l(e,Lo,t),l(e,Wt,t),l(e,wo,t),l(e,Yt,t),l(e,Ao,t),l(e,Ft,t),l(e,Uo,t),l(e,go,t),l(e,zo,t),l(e,Xt,t),l(e,Jo,t),p(Gt,e,t),l(e,jo,t),l(e,Zt,t),l(e,Ro,t),l(e,es,t),l(e,Po,t),l(e,ts,t),l(e,ko,t),l(e,Eo,t),l(e,Do,t),l(e,ss,t),l(e,Io,t),p(ls,e,t),l(e,qo,t),l(e,ns,t),l(e,No,t),l(e,is,t),l(e,Vo,t),l(e,os,t),l(e,Bo,t),l(e,Ko,t),l(e,Qo,t),l(e,rs,t),l(e,So,t),p(ds,e,t),l(e,Oo,t),l(e,as,t),l(e,Wo,t),l(e,us,t),l(e,Yo,t),l(e,ms,t),l(e,Fo,t),l(e,Xo,t),l(e,Go,t),l(e,ps,t),l(e,Zo,t),p(cs,e,t),l(e,er,t),l(e,fs,t),l(e,tr,t),l(e,Ts,t),l(e,sr,t),l(e,hs,t),l(e,lr,t),l(e,nr,t),l(e,ir,t),l(e,_s,t),l(e,or,t),p($s,e,t),l(e,rr,t),l(e,ys,t),l(e,dr,t),l(e,ar,t),l(e,ur,t),l(e,Ms,t),l(e,mr,t),p(bs,e,t),l(e,pr,t),l(e,vs,t),l(e,cr,t),l(e,Cs,t),l(e,fr,t),l(e,xs,t),l(e,Tr,t),l(e,Hs,t),l(e,hr,t),p(Ls,e,t),l(e,_r,t),l(e,$r,t),l(e,yr,t),l(e,ws,t),l(e,Mr,t),p(As,e,t),l(e,br,t),l(e,Us,t),l(e,vr,t),l(e,Cr,t),l(e,xr,t),l(e,gs,t),l(e,Hr,t),p(zs,e,t),l(e,Lr,t),l(e,Js,t),l(e,wr,t),l(e,Ar,t),l(e,Ur,t),l(e,js,t),l(e,gr,t),p(Rs,e,t),l(e,zr,t),l(e,Ps,t),l(e,Jr,t),l(e,ks,t),l(e,jr,t),p(Es,e,t),l(e,Rr,t),l(e,Ds,t),l(e,Pr,t),p(Is,e,t),l(e,kr,t),l(e,qs,t),l(e,Er,t),p(Ns,e,t),l(e,Dr,t),l(e,Ir,t),l(e,qr,t),l(e,Bs,t),Nr=!0},p:qa,i(e){Nr||(c(M.$$.fragment,e),c(H.$$.fragment,e),c(U.$$.fragment,e),c(j.$$.fragment,e),c(E.$$.fragment,e),c(V.$$.fragment,e),c(S.$$.fragment,e),c(F.$$.fragment,e),c(te.$$.fragment,e),c(ie.$$.fragment,e),c(ae.$$.fragment,e),c(ce.$$.fragment,e),c($e.$$.fragment,e),c(Ce.$$.fragment,e),c(Ae.$$.fragment,e),c(je.$$.fragment,e),c(De.$$.fragment,e),c(Ve.$$.fragment,e),c(We.$$.fragment,e),c(Ge.$$.fragment,e),c(nt.$$.fragment,e),c(dt.$$.fragment,e),c(pt.$$.fragment,e),c(_t.$$.fragment,e),c(vt.$$.fragment,e),c(wt.$$.fragment,e),c(Jt.$$.fragment,e),c(Et.$$.fragment,e),c(Vt.$$.fragment,e),c(Ot.$$.fragment,e),c(Gt.$$.fragment,e),c(ls.$$.fragment,e),c(ds.$$.fragment,e),c(cs.$$.fragment,e),c($s.$$.fragment,e),c(bs.$$.fragment,e),c(Ls.$$.fragment,e),c(As.$$.fragment,e),c(zs.$$.fragment,e),c(Rs.$$.fragment,e),c(Es.$$.fragment,e),c(Is.$$.fragment,e),c(Ns.$$.fragment,e),Nr=!0)},o(e){f(M.$$.fragment,e),f(H.$$.fragment,e),f(U.$$.fragment,e),f(j.$$.fragment,e),f(E.$$.fragment,e),f(V.$$.fragment,e),f(S.$$.fragment,e),f(F.$$.fragment,e),f(te.$$.fragment,e),f(ie.$$.fragment,e),f(ae.$$.fragment,e),f(ce.$$.fragment,e),f($e.$$.fragment,e),f(Ce.$$.fragment,e),f(Ae.$$.fragment,e),f(je.$$.fragment,e),f(De.$$.fragment,e),f(Ve.$$.fragment,e),f(We.$$.fragment,e),f(Ge.$$.fragment,e),f(nt.$$.fragment,e),f(dt.$$.fragment,e),f(pt.$$.fragment,e),f(_t.$$.fragment,e),f(vt.$$.fragment,e),f(wt.$$.fragment,e),f(Jt.$$.fragment,e),f(Et.$$.fragment,e),f(Vt.$$.fragment,e),f(Ot.$$.fragment,e),f(Gt.$$.fragment,e),f(ls.$$.fragment,e),f(ds.$$.fragment,e),f(cs.$$.fragment,e),f($s.$$.fragment,e),f(bs.$$.fragment,e),f(Ls.$$.fragment,e),f(As.$$.fragment,e),f(zs.$$.fragment,e),f(Rs.$$.fragment,e),f(Es.$$.fragment,e),f(Is.$$.fragment,e),f(Ns.$$.fragment,e),Nr=!1},d(e){e&&(s(Ks),s(Vs),s(Qs),s(y),s(Ss),s(Os),s(b),s(Ws),s(v),s(Ys),s(C),s(Fs),s(Xs),s(Gs),s(x),s(Zs),s(el),s(L),s(tl),s(w),s(sl),s(ll),s(nl),s(A),s(il),s(ol),s(g),s(rl),s(z),s(dl),s(al),s(ul),s(J),s(ml),s(pl),s(R),s(cl),s(P),s(fl),s(Tl),s(hl),s(k),s(_l),s($l),s(D),s(yl),s(I),s(Ml),s(q),s(bl),s(vl),s(Cl),s(N),s(xl),s(Hl),s(B),s(Ll),s(K),s(wl),s(Al),s(Ul),s(Q),s(gl),s(zl),s(O),s(Jl),s(W),s(jl),s(Rl),s(Pl),s(Y),s(kl),s(El),s(X),s(Dl),s(G),s(Il),s(Z),s(ql),s(Nl),s(Vl),s(ee),s(Bl),s(Kl),s(se),s(Ql),s(le),s(Sl),s(Ol),s(Wl),s(ne),s(Yl),s(Fl),s(oe),s(Xl),s(re),s(Gl),s(Zl),s(en),s(de),s(tn),s(sn),s(ue),s(ln),s(me),s(nn),s(on),s(rn),s(pe),s(dn),s(an),s(fe),s(un),s(Te),s(mn),s(he),s(pn),s(cn),s(fn),s(_e),s(Tn),s(hn),s(ye),s(_n),s(Me),s($n),s(be),s(yn),s(Mn),s(bn),s(ve),s(vn),s(Cn),s(xe),s(xn),s(He),s(Hn),s(Le),s(Ln),s(wn),s(An),s(we),s(Un),s(gn),s(Ue),s(zn),s(ge),s(Jn),s(ze),s(jn),s(Rn),s(Pn),s(Je),s(kn),s(En),s(Re),s(Dn),s(Pe),s(In),s(ke),s(qn),s(Nn),s(Vn),s(Ee),s(Bn),s(Kn),s(Ie),s(Qn),s(qe),s(Sn),s(On),s(Wn),s(Ne),s(Yn),s(Fn),s(Be),s(Xn),s(Ke),s(Gn),s(Qe),s(Zn),s(Se),s(ei),s(ti),s(si),s(Oe),s(li),s(ni),s(Ye),s(ii),s(Fe),s(oi),s(ri),s(di),s(Xe),s(ai),s(ui),s(Ze),s(mi),s(et),s(pi),s(tt),s(ci),s(st),s(fi),s(Ti),s(hi),s(lt),s(_i),s($i),s(it),s(yi),s(ot),s(Mi),s(bi),s(vi),s(rt),s(Ci),s(xi),s(at),s(Hi),s(ut),s(Li),s(wi),s(Ai),s(mt),s(Ui),s(gi),s(ct),s(zi),s(ft),s(Ji),s(Tt),s(ji),s(Ri),s(Pi),s(ht),s(ki),s(Ei),s($t),s(Di),s(yt),s(Ii),s(Mt),s(qi),s(Ni),s(Vi),s(bt),s(Bi),s(Ki),s(Ct),s(Qi),s(xt),s(Si),s(Ht),s(Oi),s(Wi),s(Yi),s(Lt),s(Fi),s(Xi),s(At),s(Gi),s(Ut),s(Zi),s(gt),s(eo),s(to),s(so),s(zt),s(lo),s(no),s(jt),s(io),s(Rt),s(oo),s(Pt),s(ro),s(ao),s(uo),s(kt),s(mo),s(po),s(Dt),s(co),s(It),s(fo),s(qt),s(To),s(ho),s(_o),s(Nt),s($o),s(yo),s(Bt),s(Mo),s(Kt),s(bo),s(Qt),s(vo),s(Co),s(xo),s(St),s(Ho),s(Lo),s(Wt),s(wo),s(Yt),s(Ao),s(Ft),s(Uo),s(go),s(zo),s(Xt),s(Jo),s(jo),s(Zt),s(Ro),s(es),s(Po),s(ts),s(ko),s(Eo),s(Do),s(ss),s(Io),s(qo),s(ns),s(No),s(is),s(Vo),s(os),s(Bo),s(Ko),s(Qo),s(rs),s(So),s(Oo),s(as),s(Wo),s(us),s(Yo),s(ms),s(Fo),s(Xo),s(Go),s(ps),s(Zo),s(er),s(fs),s(tr),s(Ts),s(sr),s(hs),s(lr),s(nr),s(ir),s(_s),s(or),s(rr),s(ys),s(dr),s(ar),s(ur),s(Ms),s(mr),s(pr),s(vs),s(cr),s(Cs),s(fr),s(xs),s(Tr),s(Hs),s(hr),s(_r),s($r),s(yr),s(ws),s(Mr),s(br),s(Us),s(vr),s(Cr),s(xr),s(gs),s(Hr),s(Lr),s(Js),s(wr),s(Ar),s(Ur),s(js),s(gr),s(zr),s(Ps),s(Jr),s(ks),s(jr),s(Rr),s(Ds),s(Pr),s(kr),s(qs),s(Er),s(Dr),s(Ir),s(qr),s(Bs)),s($),T(M,e),T(H,e),T(U,e),T(j,e),T(E,e),T(V,e),T(S,e),T(F,e),T(te,e),T(ie,e),T(ae,e),T(ce,e),T($e,e),T(Ce,e),T(Ae,e),T(je,e),T(De,e),T(Ve,e),T(We,e),T(Ge,e),T(nt,e),T(dt,e),T(pt,e),T(_t,e),T(vt,e),T(wt,e),T(Jt,e),T(Et,e),T(Vt,e),T(Ot,e),T(Gt,e),T(ls,e),T(ds,e),T(cs,e),T($s,e),T(bs,e),T(Ls,e),T(As,e),T(zs,e),T(Rs,e),T(Es,e),T(Is,e),T(Ns,e)}}}const Oa='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code>","local":"tensoritem--code-number-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.transpose(...dims) ⇒ <code> Tensor </code>","local":"tensortransposedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒","local":"tensorsqueezedim-","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒","local":"tensorunsqueezedim-","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒","local":"tensorflattenstartdim-enddim-","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.transpose(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensortransposetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒","local":"utilstensormeaninput-dim-keepdim-","sections":[],"depth":2},{"title":"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>","local":"utilstensordynamictimewarpingmatrix--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/tensor.ones(size)","local":"utilstensoronessize","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒","local":"utilstensoronesliketensor-","sections":[],"depth":2},{"title":"utils/tensor~ONNXTensor : <code> Object </code>","local":"utilstensoronnxtensor--code-object-code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function Wa(Br){return Na(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Za extends Va{constructor($){super(),Ba(this,$,Wa,Sa,Ia,{})}}export{Za as component};
