import{s as yJ,n as uJ,o as JJ}from"../chunks/scheduler.b108d059.js";import{S as hJ,i as wJ,g as a,s as i,r as c,A as jJ,h as p,f as l,c as n,j as u,u as r,x as o,k as d,y as UJ,a as s,v as M,d as T,t as m,w as y}from"../chunks/index.008de539.js";import{C as h}from"../chunks/CodeBlock.3968c746.js";import{H as J}from"../chunks/Heading.88bfeb84.js";function fJ(ST){let w,Qn,Zn,vn,j,Nn,U,An,f,LT="Pipelines provide a high-level, easy to use, API for running machine learning models.",_n,b,FT="<strong>Example:</strong> Instantiate pipeline using the <code>pipeline</code> function.",$n,x,Rn,C,DT='<li><a href="#module_pipelines">pipelines</a><ul><li><em>static</em><ul><li><a href="#module_pipelines.Pipeline">.Pipeline</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_pipelines.Pipeline_new"><code>new Pipeline(options)</code></a></li> <li><a href="#module_pipelines.Pipeline+dispose"><code>.dispose()</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li> <li><a href="#module_pipelines.Pipeline+_call"><code>._call(texts, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.TextClassificationPipeline">.TextClassificationPipeline</a><ul><li><a href="#module_pipelines.TextClassificationPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.TokenClassificationPipeline">.TokenClassificationPipeline</a><ul><li><a href="#module_pipelines.TokenClassificationPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.QuestionAnsweringPipeline">.QuestionAnsweringPipeline</a><ul><li><a href="#module_pipelines.QuestionAnsweringPipeline+_call"><code>._call(question, context, options)</code></a> ⇒ <code>QuestionAnsweringReturnType</code></li></ul></li> <li><a href="#module_pipelines.FillMaskPipeline">.FillMaskPipeline</a><ul><li><a href="#module_pipelines.FillMaskPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.Text2TextGenerationPipeline">.Text2TextGenerationPipeline</a><ul><li><a href="#module_pipelines.Text2TextGenerationPipeline+_call"><code>._call(texts, [options])</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.SummarizationPipeline">.SummarizationPipeline</a></li> <li><a href="#module_pipelines.TranslationPipeline">.TranslationPipeline</a></li> <li><a href="#module_pipelines.TextGenerationPipeline">.TextGenerationPipeline</a><ul><li><a href="#module_pipelines.TextGenerationPipeline+_call"><code>._call(texts, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline">.ZeroShotClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotClassificationPipeline_new"><code>new ZeroShotClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+_call"><code>._call(texts, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.FeatureExtractionPipeline">.FeatureExtractionPipeline</a><ul><li><a href="#module_pipelines.FeatureExtractionPipeline+_call"><code>._call(texts, options)</code></a> ⇒</li></ul></li> <li><a href="#module_pipelines.AudioClassificationPipeline">.AudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.AudioClassificationPipeline_new"><code>new AudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.AudioClassificationPipeline+_call"><code>._call(audio, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline">.AutomaticSpeechRecognitionPipeline</a><ul><li><a href="#new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"><code>new AutomaticSpeechRecognitionPipeline(options)</code></a></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline+_call"><code>._call(audio, [kwargs])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageToTextPipeline">.ImageToTextPipeline</a><ul><li><a href="#new_module_pipelines.ImageToTextPipeline_new"><code>new ImageToTextPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToTextPipeline+_call"><code>._call(images, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageClassificationPipeline">.ImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ImageClassificationPipeline_new"><code>new ImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageClassificationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageSegmentationPipeline">.ImageSegmentationPipeline</a><ul><li><a href="#new_module_pipelines.ImageSegmentationPipeline_new"><code>new ImageSegmentationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageSegmentationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;Array&gt;</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline">.ZeroShotImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotImageClassificationPipeline_new"><code>new ZeroShotImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ObjectDetectionPipeline">.ObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ObjectDetectionPipeline_new"><code>new ObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ObjectDetectionPipeline+_call"><code>._call(images, options)</code></a></li></ul></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline">.DocumentQuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.DocumentQuestionAnsweringPipeline_new"><code>new DocumentQuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline+_call"><code>._call(image, question, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.TextToAudioPipeline">.TextToAudioPipeline</a><ul><li><a href="#new_module_pipelines.TextToAudioPipeline_new"><code>new TextToAudioPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextToAudioPipeline+_call"><code>._call(text_inputs, options)</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_pipelines.pipeline"><code>.pipeline(task, [model], [options])</code></a> ⇒ <code>Promise.&lt;Pipeline&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_pipelines..QuestionAnsweringResult"><code>~QuestionAnsweringResult</code></a> : <code>object</code></li> <li><a href="#module_pipelines..QuestionAnsweringReturnType"><code>~QuestionAnsweringReturnType</code></a> : <code>Promise.&lt;(QuestionAnsweringResult|Array&lt;QuestionAnsweringResult&gt;)&gt;</code></li> <li><a href="#module_pipelines..ChunkCallback"><code>~ChunkCallback</code></a> : <code>function</code></li></ul></li></ul></li>',Vn,Yn,Pn,g,En,I,Hn,k,qT=`The Pipeline class is the class from which all pipelines inherit.
Refer to this class for methods shared across different pipelines.`,Wn,G,OT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',zn,Z,KT='<li><a href="#module_pipelines.Pipeline">.Pipeline</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_pipelines.Pipeline_new"><code>new Pipeline(options)</code></a></li> <li><a href="#module_pipelines.Pipeline+dispose"><code>.dispose()</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li> <li><a href="#module_pipelines.Pipeline+_call"><code>._call(texts, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',Xn,Sn,Ln,B,Fn,Q,Dn,v,em="Create a new Pipeline.",qn,N,tm="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><code></code></td><td><p>The tokenizer to use (if any).</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><code></code></td><td><p>The processor to use (if any).</p></td></tr></tbody>",On,Kn,ea,A,ta,_,la,$,lm="Disposes the model.",sa,R,sm='<strong>Kind</strong>: instance method of <a href="#module_pipelines.Pipeline"><code>Pipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;void&gt;</code> - A promise that resolves when the model has been disposed.',ia,na,aa,V,pa,Y,oa,P,im="Executes the task associated with the pipeline.",da,E,nm='<strong>Kind</strong>: instance method of <a href="#module_pipelines.Pipeline"><code>Pipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A promise that resolves to an array containing the inputs and outputs of the task.',ca,H,am="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td><p>The input texts to be processed.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",ra,Ma,Ta,W,ma,z,ya,X,pm="Text classification pipeline using any <code>ModelForSequenceClassification</code>.",ua,S,om="<strong>Example:</strong> Sentiment-analysis w/ <code>Xenova/distilbert-base-uncased-finetuned-sst-2-english</code>.",Ja,L,ha,F,dm="<strong>Example:</strong> Multilingual sentiment-analysis w/ <code>Xenova/bert-base-multilingual-uncased-sentiment</code> (and return top 5 classes).",wa,D,ja,q,cm="<strong>Example:</strong> Toxic comment classification w/ <code>Xenova/toxic-bert</code> (and return all classes).",Ua,O,fa,K,rm='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',ba,xa,Ca,ee,ga,te,Ia,le,Mm="Executes the text classification task.",ka,se,Tm='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextClassificationPipeline"><code>TextClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',Ga,ie,mm="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The input texts to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",Za,Ba,Qa,ne,va,ae,Na,pe,ym="Named Entity Recognition pipeline using any <code>ModelForTokenClassification</code>.",Aa,oe,um="<strong>Example:</strong> Perform named entity recognition with <code>Xenova/bert-base-NER</code>.",_a,de,$a,ce,Jm="<strong>Example:</strong> Perform named entity recognition with <code>Xenova/bert-base-NER</code> (and return all labels).",Ra,re,Va,Me,hm='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Ya,Pa,Ea,Te,Ha,me,Wa,ye,wm="Executes the token classification task.",za,ue,jm='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TokenClassificationPipeline"><code>TokenClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',Xa,Je,Um="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td><p>The input texts to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>An optional object containing the following properties:</p></td></tr></tbody>",Sa,La,Fa,he,Da,we,qa,je,fm="Question Answering pipeline using any <code>ModelForQuestionAnswering</code>.",Oa,Ue,bm="<strong>Example:</strong> Run question answering with <code>Xenova/distilbert-base-uncased-distilled-squad</code>.",Ka,fe,ep,be,xm='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',tp,lp,sp,xe,ip,Ce,np,ge,Cm="Executes the question answering task.",ap,Ie,gm=`<strong>Kind</strong>: instance method of <a href="#module_pipelines.QuestionAnsweringPipeline"><code>QuestionAnsweringPipeline</code></a><br/> <strong>Returns</strong>: <code>QuestionAnsweringReturnType</code> - A promise that resolves to an array or object
containing the predicted answers and scores.`,pp,ke,Im="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>question</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The question(s) to be answered.</p></td> </tr><tr><td>context</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The context(s) where the answer(s) can be found.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top answer predictions to be returned.</p></td></tr></tbody>",op,dp,cp,Ge,rp,Ze,Mp,Be,km="Masked language modeling prediction pipeline using any <code>ModelWithLMHead</code>.",Tp,Qe,Gm="<strong>Example:</strong> Perform masked language modelling (a.k.a. “fill-mask”) with <code>Xenova/bert-base-uncased</code>.",mp,ve,yp,Ne,Zm="<strong>Example:</strong> Perform masked language modelling (a.k.a. “fill-mask”) with <code>Xenova/bert-base-cased</code> (and return top result).",up,Ae,Jp,_e,Bm='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',hp,wp,jp,$e,Up,Re,fp,Ve,Qm="Fill the masked token in the text(s) given as inputs.",bp,Ye,vm='<strong>Kind</strong>: instance method of <a href="#module_pipelines.FillMaskPipeline"><code>FillMaskPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted tokens and scores.',xp,Pe,Nm="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The masked input texts.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",Cp,gp,Ip,Ee,kp,He,Gp,We,Am="Text2TextGenerationPipeline class for generating text using a model that performs text-to-text generation tasks.",Zp,ze,_m="<strong>Example:</strong> Text-to-text generation w/ <code>Xenova/LaMini-Flan-T5-783M</code>.",Bp,Xe,Qp,Se,$m='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',vp,Np,Ap,Le,_p,Fe,$p,De,Rm="Fill the masked token in the text(s) given as inputs.",Rp,qe,Vm=`<strong>Kind</strong>: instance method of <a href="#module_pipelines.Text2TextGenerationPipeline"><code>Text2TextGenerationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An array of objects containing the score, predicted token, predicted token string,
and the sequence with the predicted token filled in, or an array of such arrays (one for each input text).
If only one input text is given, the output will be an array of objects.<br/> <strong>Throws</strong>:`,Vp,Oe,Ym="<li><code>Error</code> When the mask token is not found in the input text.</li>",Yp,Ke,Pm="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The text or array of texts to be processed.</p></td> </tr><tr><td>[options]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Options for the fill-mask pipeline.</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top-k predictions to return.</p></td></tr></tbody>",Pp,Ep,Hp,et,Wp,tt,zp,lt,Em="A pipeline for summarization tasks, inheriting from Text2TextGenerationPipeline.",Xp,st,Hm="<strong>Example:</strong> Summarization w/ <code>Xenova/distilbart-cnn-6-6</code>.",Sp,it,Lp,nt,Wm='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Fp,Dp,qp,at,Op,pt,Kp,ot,zm="Translates text from one language to another.",eo,dt,Xm="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/nllb-200-distilled-600M</code>.",to,ct,Sm=`See <a href="https://github.com/facebookresearch/flores/blob/main/flores200/README.md#languages-in-flores-200" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,lo,rt,so,Mt,Lm="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/m2m100_418M</code>.",io,Tt,Fm=`See <a href="https://huggingface.co/facebook/m2m100_418M#languages-covered" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,no,mt,ao,yt,Dm="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/mbart-large-50-many-to-many-mmt</code>.",po,ut,qm=`See <a href="https://huggingface.co/facebook/mbart-large-50-many-to-many-mmt#languages-covered" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,oo,Jt,co,ht,Om='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',ro,Mo,To,wt,mo,jt,yo,Ut,Km=`Language generation pipeline using any <code>ModelWithLMHead</code> or <code>ModelForCausalLM</code>.
This pipeline predicts the words that will follow a specified text prompt.
NOTE: For the full list of generation parameters, see <a href="./utils/generation#module_utils/generation.GenerationConfig"><code>GenerationConfig</code></a>.`,uo,ft,ey="<strong>Example:</strong> Text generation with <code>Xenova/distilgpt2</code> (default settings).",Jo,bt,ho,xt,ty="<strong>Example:</strong> Text generation with <code>Xenova/distilgpt2</code> (custom settings).",wo,Ct,jo,gt,ly="<strong>Example:</strong> Run code generation with <code>Xenova/codegen-350M-mono</code>.",Uo,It,fo,kt,sy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',bo,xo,Co,Gt,go,Zt,Io,Bt,iy="Generates text based on an input prompt.",ko,Qt,ny='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextGenerationPipeline"><code>TextGenerationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - The generated text or texts.',Go,vt,ay="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The input prompt or prompts to generate text from.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Additional arguments for text generation.</p></td></tr></tbody>",Zo,Bo,Qo,Nt,vo,At,No,_t,py=`NLI-based zero-shot classification pipeline using a <code>ModelForSequenceClassification</code>
trained on NLI (natural language inference) tasks. Equivalent of <code>text-classification</code>
pipelines, but these models don’t require a hardcoded number of potential classes, they
can be chosen at runtime. It usually means it’s slower but it is <strong>much</strong> more flexible.`,Ao,$t,oy="<strong>Example:</strong> Zero shot classification with <code>Xenova/mobilebert-uncased-mnli</code>.",_o,Rt,$o,Vt,dy="<strong>Example:</strong> Zero shot classification with <code>Xenova/nli-deberta-v3-xsmall</code> (multi-label).",Ro,Yt,Vo,Pt,cy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Yo,Et,ry='<li><a href="#module_pipelines.ZeroShotClassificationPipeline">.ZeroShotClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotClassificationPipeline_new"><code>new ZeroShotClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+_call"><code>._call(texts, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',Po,Eo,Ho,Ht,Wo,Wt,zo,zt,My="Create a new ZeroShotClassificationPipeline.",Xo,Xt,Ty="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td></tr></tbody>",So,Lo,Fo,St,Do,Lt,qo,Ft,my='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotClassificationPipeline"><code>ZeroShotClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - The prediction(s), as a map (or list of maps) from label to score.',Oo,Dt,yy=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>Array.&lt;any&gt;</code></td><td></td><td></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td></td><td></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options:</p></td> </tr><tr><td>[options.hypothesis_template]</td><td><code>string</code></td><td><code>&quot;&quot;This example is {}.&quot;&quot;</code></td><td><p>The template used to turn each
candidate label into an NLI-style hypothesis. The candidate label will replace the &amp;#123;} placeholder.</p></td> </tr><tr><td>[options.multi_label]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not multiple candidate labels can be true.
If <code>false</code>, the scores are normalized such that the sum of the label likelihoods for each sequence
is 1. If <code>true</code>, the labels are considered independent and probabilities are normalized for each
candidate by doing a softmax of the entailment score vs. the contradiction score.</p></td></tr></tbody>`,Ko,ed,td,qt,ld,Ot,sd,Kt,uy=`Feature extraction pipeline using no model head. This pipeline extracts the hidden
states from the base transformer, which can be used as features in downstream tasks.`,id,el,Jy="<strong>Example:</strong> Run feature extraction with <code>bert-base-uncased</code> (without pooling/normalization).",nd,tl,ad,ll,hy="<strong>Example:</strong> Run feature extraction with <code>bert-base-uncased</code> (with pooling/normalization).",pd,sl,od,il,wy="<strong>Example:</strong> Calculating embeddings with <code>sentence-transformers</code> models.",dd,nl,cd,al,jy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',rd,Md,Td,pl,md,ol,yd,dl,Uy="Extract the features of the input(s).",ud,cl,fy='<strong>Kind</strong>: instance method of <a href="#module_pipelines.FeatureExtractionPipeline"><code>FeatureExtractionPipeline</code></a><br/> <strong>Returns</strong>: The features computed by the model.',Jd,rl,by="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The input texts</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options:</p></td> </tr><tr><td>[options.pooling]</td><td><code>string</code></td><td><code>&quot;&quot;none&quot;&quot;</code></td><td><p>The pooling method to use. Can be one of: &quot;none&quot;, &quot;mean&quot;.</p></td> </tr><tr><td>[options.normalize]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to normalize the embeddings in the last dimension.</p></td></tr></tbody>",hd,wd,jd,Ml,Ud,Tl,fd,ml,xy=`Audio classification pipeline using any <code>AutoModelForAudioClassification</code>.
This pipeline predicts the class of a raw waveform or an audio file.`,bd,yl,Cy="<strong>Example:</strong> Perform audio classification.",xd,ul,Cd,Jl,gy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',gd,hl,Iy='<li><a href="#module_pipelines.AudioClassificationPipeline">.AudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.AudioClassificationPipeline_new"><code>new AudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.AudioClassificationPipeline+_call"><code>._call(audio, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li>',Id,kd,Gd,wl,Zd,jl,Bd,Ul,ky="Create a new AudioClassificationPipeline.",Qd,fl,Gy="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",vd,Nd,Ad,bl,_d,xl,$d,Cl,Zy="Executes the audio classification task.",Rd,gl,By='<strong>Kind</strong>: instance method of <a href="#module_pipelines.AudioClassificationPipeline"><code>AudioClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',Vd,Il,Qy="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td></td><td><p>The input audio files to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",Yd,Pd,Ed,kl,Hd,Gl,Wd,Zl,vy="Pipeline that aims at extracting spoken text contained within some audio.",zd,Bl,Ny="<strong>Example:</strong> Transcribe English.",Xd,Ql,Sd,vl,Ay="<strong>Example:</strong> Transcribe English w/ timestamps.",Ld,Nl,Fd,Al,_y="<strong>Example:</strong> Transcribe English w/ word-level timestamps.",Dd,_l,qd,$l,$y="<strong>Example:</strong> Transcribe French.",Od,Rl,Kd,Vl,Ry="<strong>Example:</strong> Translate French to English.",ec,Yl,tc,Pl,Vy="<strong>Example:</strong> Transcribe/translate audio longer than 30 seconds.",lc,El,sc,Hl,Yy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',ic,Wl,Py='<li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline">.AutomaticSpeechRecognitionPipeline</a><ul><li><a href="#new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"><code>new AutomaticSpeechRecognitionPipeline(options)</code></a></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline+_call"><code>._call(audio, [kwargs])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',nc,ac,pc,zl,oc,Xl,dc,Sl,Ey="Create a new AutomaticSpeechRecognitionPipeline.",cc,Ll,Hy="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",rc,Mc,Tc,Fl,mc,Dl,yc,ql,Wy="Asynchronously processes audio and generates text transcription using the model.",uc,Ol,zy='<strong>Kind</strong>: instance method of <a href="#module_pipelines.AutomaticSpeechRecognitionPipeline"><code>AutomaticSpeechRecognitionPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - A Promise that resolves to an object containing the transcription text and optionally timestamps if <code>return_timestamps</code> is <code>true</code>.',Jc,Kl,Xy=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>Float32Array</code> | <code>Array&lt;Float32Array&gt;</code></td><td></td><td><p>The audio to be transcribed. Can be a single Float32Array or an array of Float32Arrays.</p></td> </tr><tr><td>[kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional arguments.</p></td> </tr><tr><td>[kwargs.return_timestamps]</td><td><code>boolean</code> | <code>&#39;word&#39;</code></td><td></td><td><p>Whether to return timestamps or not. Default is <code>false</code>.</p></td> </tr><tr><td>[kwargs.chunk_length_s]</td><td><code>number</code></td><td></td><td><p>The length of audio chunks to process in seconds. Default is 0 (no chunking).</p></td> </tr><tr><td>[kwargs.stride_length_s]</td><td><code>number</code></td><td></td><td><p>The length of overlap between consecutive audio chunks in seconds. If not provided, defaults to <code>chunk_length_s / 6</code>.</p></td> </tr><tr><td>[kwargs.chunk_callback]</td><td><code>ChunkCallback</code></td><td></td><td><p>Callback function to be called with each chunk processed.</p></td> </tr><tr><td>[kwargs.force_full_sequences]</td><td><code>boolean</code></td><td></td><td><p>Whether to force outputting full sequences or not. Default is <code>false</code>.</p></td> </tr><tr><td>[kwargs.language]</td><td><code>string</code></td><td></td><td><p>The source language. Default is <code>null</code>, meaning it should be auto-detected. Use this to potentially improve performance if the source language is known.</p></td> </tr><tr><td>[kwargs.task]</td><td><code>string</code></td><td></td><td><p>The task to perform. Default is <code>null</code>, meaning it should be auto-detected.</p></td> </tr><tr><td>[kwargs.forced_decoder_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td></td><td><p>A list of pairs of integers which indicates a mapping from generation indices to token indices
that will be forced before sampling. For example, [[1, 123]] means the second generated token will always be a token of index 123.</p></td></tr></tbody>`,hc,wc,jc,es,Uc,ts,fc,ls,Sy="Image To Text pipeline using a <code>AutoModelForVision2Seq</code>. This pipeline predicts a caption for a given image.",bc,ss,Ly="<strong>Example:</strong> Generate a caption for an image w/ <code>Xenova/vit-gpt2-image-captioning</code>.",xc,is,Cc,ns,Fy="<strong>Example:</strong> Optical Character Recognition (OCR) w/ <code>Xenova/trocr-small-handwritten</code>.",gc,as,Ic,ps,Dy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',kc,os,qy='<li><a href="#module_pipelines.ImageToTextPipeline">.ImageToTextPipeline</a><ul><li><a href="#new_module_pipelines.ImageToTextPipeline_new"><code>new ImageToTextPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToTextPipeline+_call"><code>._call(images, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',Gc,Zc,Bc,ds,Qc,cs,vc,rs,Oy="Create a new ImageToTextPipeline.",Nc,Ms,Ky="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",Ac,_c,$c,Ts,Rc,ms,Vc,ys,eu="Assign labels to the image(s) passed as inputs.",Yc,us,tu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageToTextPipeline"><code>ImageToTextPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - A Promise that resolves to an object (or array of objects) containing the generated text(s).',Pc,Js,lu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;any&gt;</code></td><td></td><td><p>The images to be captioned.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional generation arguments.</p></td></tr></tbody>",Ec,Hc,Wc,hs,zc,ws,Xc,js,su=`Image classification pipeline using any <code>AutoModelForImageClassification</code>.
This pipeline predicts the class of an image.`,Sc,Us,iu="<strong>Example:</strong> Classify an image.",Lc,fs,Fc,bs,nu="<strong>Example:</strong> Classify an image and return top <code>n</code> classes.",Dc,xs,qc,Cs,au="<strong>Example:</strong> Classify an image and return all classes.",Oc,gs,Kc,Is,pu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',er,ks,ou='<li><a href="#module_pipelines.ImageClassificationPipeline">.ImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ImageClassificationPipeline_new"><code>new ImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageClassificationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',tr,lr,sr,Gs,ir,Zs,nr,Bs,du="Create a new ImageClassificationPipeline.",ar,Qs,cu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",pr,or,dr,vs,cr,Ns,rr,As,ru="Classify the given images.",Mr,_s,Mu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageClassificationPipeline"><code>ImageClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - The top classification results for the images.',Tr,$s,Tu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>any</code></td><td></td><td><p>The images to classify.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options to use for classification.</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top results to return.</p></td></tr></tbody>",mr,yr,ur,Rs,Jr,Vs,hr,Ys,mu=`Image segmentation pipeline using any <code>AutoModelForXXXSegmentation</code>.
This pipeline predicts masks of objects and their classes.`,wr,Ps,yu="<strong>Example:</strong> Perform image segmentation with <code>Xenova/detr-resnet-50-panoptic</code>.",jr,Es,Ur,Hs,uu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',fr,Ws,Ju='<li><a href="#module_pipelines.ImageSegmentationPipeline">.ImageSegmentationPipeline</a><ul><li><a href="#new_module_pipelines.ImageSegmentationPipeline_new"><code>new ImageSegmentationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageSegmentationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;Array&gt;</code></li></ul></li>',br,xr,Cr,zs,gr,Xs,Ir,Ss,hu="Create a new ImageSegmentationPipeline.",kr,Ls,wu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",Gr,Zr,Br,Fs,Qr,Ds,vr,qs,ju="Segment the input images.",Nr,Os,Uu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageSegmentationPipeline"><code>ImageSegmentationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Array&gt;</code> - The annotated segments.',Ar,Ks,fu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array</code></td><td></td><td><p>The input images.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options to use for segmentation.</p></td> </tr><tr><td>[options.threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Probability threshold to filter out predicted masks.</p></td> </tr><tr><td>[options.mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[options.overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>Mask overlap threshold to eliminate small, disconnected segments.</p></td> </tr><tr><td>[options.subtask]</td><td><code>null</code> | <code>string</code></td><td><code></code></td><td><p>Segmentation task to be performed. One of [<code>panoptic</code>, <code>instance</code>, and <code>semantic</code>], depending on model capabilities. If not set, the pipeline will attempt to resolve (in that order).</p></td> </tr><tr><td>[options.label_ids_to_fuse]</td><td><code>Array</code></td><td><code></code></td><td><p>List of label ids to fuse. If not set, do not fuse any labels.</p></td> </tr><tr><td>[options.target_sizes]</td><td><code>Array</code></td><td><code></code></td><td><p>List of target sizes for the input images. If not set, use the original image sizes.</p></td></tr></tbody>",_r,$r,Rr,ei,Vr,ti,Yr,li,bu=`Zero shot image classification pipeline. This pipeline predicts the class of
an image when you provide an image and a set of <code>candidate_labels</code>.`,Pr,si,xu="<strong>Example:</strong> Zero shot image classification w/ <code>Xenova/clip-vit-base-patch32</code>.",Er,ii,Hr,ni,Cu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Wr,ai,gu='<li><a href="#module_pipelines.ZeroShotImageClassificationPipeline">.ZeroShotImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotImageClassificationPipeline_new"><code>new ZeroShotImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',zr,Xr,Sr,pi,Lr,oi,Fr,di,Iu="Create a new ZeroShotImageClassificationPipeline.",Dr,ci,ku="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",qr,Or,Kr,ri,eM,Mi,tM,Ti,Gu="Classify the input images with candidate labels using a zero-shot approach.",lM,mi,Zu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotImageClassificationPipeline"><code>ZeroShotImageClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An array of classifications for each input image or a single classification object if only one input image is provided.',sM,yi,Bu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array</code></td><td><p>The input images.</p></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td><p>The candidate labels.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>The options for the classification.</p></td> </tr><tr><td>[options.hypothesis_template]</td><td><code>string</code></td><td><p>The hypothesis template to use for zero-shot classification. Default: &quot;This is a photo of &amp;#123;}&quot;.</p></td></tr></tbody>",iM,nM,aM,ui,pM,Ji,oM,hi,Qu=`Object detection pipeline using any <code>AutoModelForObjectDetection</code>.
This pipeline predicts bounding boxes of objects and their classes.`,dM,wi,vu="<strong>Example:</strong> Run object-detection with <code>facebook/detr-resnet-50</code>.",cM,ji,rM,Ui,Nu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',MM,fi,Au='<li><a href="#module_pipelines.ObjectDetectionPipeline">.ObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ObjectDetectionPipeline_new"><code>new ObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ObjectDetectionPipeline+_call"><code>._call(images, options)</code></a></li></ul></li>',TM,mM,yM,bi,uM,xi,JM,Ci,_u="Create a new ObjectDetectionPipeline.",hM,gi,$u="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",wM,jM,UM,Ii,fM,ki,bM,Gi,Ru="Detect objects (bounding boxes & classes) in the image(s) passed as inputs.",xM,Zi,Vu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ObjectDetectionPipeline"><code>ObjectDetectionPipeline</code></a>',CM,Bi,Yu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;any&gt;</code></td><td></td><td><p>The input images.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the object detection.</p></td> </tr><tr><td>[options.threshold]</td><td><code>number</code></td><td><code>0.9</code></td><td><p>The threshold used to filter boxes by score.</p></td> </tr><tr><td>[options.percentage]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to return the boxes coordinates in percentage (true) or in pixels (false).</p></td></tr></tbody>",gM,IM,kM,Qi,GM,vi,ZM,Ni,Pu=`Document Question Answering pipeline using any <code>AutoModelForDocumentQuestionAnswering</code>.
The inputs/outputs are similar to the (extractive) question answering pipeline; however,
the pipeline takes an image (and optional OCR’d words/boxes) as input instead of text context.`,BM,Ai,Eu="<strong>Example:</strong> Answer questions about a document with <code>Xenova/donut-base-finetuned-docvqa</code>.",QM,_i,vM,$i,Hu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',NM,Ri,Wu='<li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline">.DocumentQuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.DocumentQuestionAnsweringPipeline_new"><code>new DocumentQuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline+_call"><code>._call(image, question, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',AM,_M,$M,Vi,RM,Yi,VM,Pi,zu="Create a new DocumentQuestionAnsweringPipeline.",YM,Ei,Xu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",PM,EM,HM,Hi,WM,Wi,zM,zi,Su="Answer the question given as input by using the document.",XM,Xi,Lu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.DocumentQuestionAnsweringPipeline"><code>DocumentQuestionAnsweringPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - A Promise that resolves to an object (or array of objects) containing the generated text(s).',SM,Si,Fu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>any</code></td><td></td><td><p>The image of the document to use.</p></td> </tr><tr><td>question</td><td><code>string</code></td><td></td><td><p>A question to ask of the document.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional generation arguments.</p></td></tr></tbody>",LM,FM,DM,Li,qM,Fi,OM,Di,Du=`Text-to-audio generation pipeline using any <code>AutoModelForTextToWaveform</code> or <code>AutoModelForTextToSpectrogram</code>.
This pipeline generates an audio file from an input text and optional other conditional inputs.`,KM,qi,qu="<strong>Example:</strong> Generate audio from text with <code>Xenova/speecht5_tts</code>.",eT,Oi,tT,Ki,Ou="You can then save the audio to a .wav file with the <code>wavefile</code> package:",lT,en,sT,tn,Ku='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',iT,ln,eJ='<li><a href="#module_pipelines.TextToAudioPipeline">.TextToAudioPipeline</a><ul><li><a href="#new_module_pipelines.TextToAudioPipeline_new"><code>new TextToAudioPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextToAudioPipeline+_call"><code>._call(text_inputs, options)</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',nT,aT,pT,sn,oT,nn,dT,an,tJ="Create a new TextToAudioPipeline.",cT,pn,lJ="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td> </tr><tr><td>[options.vocoder]</td><td><code>PreTrainedModel</code></td><td><p>The vocoder to use.</p></td></tr></tbody>",rT,MT,TT,on,mT,dn,yT,cn,sJ="Generates speech/audio from the inputs.",uT,rn,iJ='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextToAudioPipeline"><code>TextToAudioPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - An object containing the generated audio and sampling rate.',JT,Mn,nJ="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>text_inputs</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The text(s) to generate.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Parameters passed to the model generation/forward method.</p></td> </tr><tr><td>[options.vocoder]</td><td><code>PreTrainedModel</code></td><td><code></code></td><td><p>The vocoder to use (if the model uses one). If not provided, use the default HifiGan vocoder.</p></td> </tr><tr><td>[options.speaker_embeddings]</td><td><code>Tensor</code> | <code>Float32Array</code> | <code>string</code> | <code>URL</code></td><td><code></code></td><td></td></tr></tbody>",hT,wT,jT,Tn,UT,mn,fT,yn,aJ="Utility factory method to build a [<code>Pipeline</code>] object.",bT,un,pJ='<strong>Kind</strong>: static method of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Pipeline&gt;</code> - A Pipeline object for the specified task.<br/> <strong>Throws</strong>:',xT,Jn,oJ="<li><code>Error</code> If an unsupported pipeline is requested.</li>",CT,hn,dJ="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>task</td><td><code>string</code></td><td></td><td><p>The task defining which pipeline will be returned. Currently accepted tasks are:</p> <ul><li><code>&quot;audio-classification&quot;</code>: will return a <code>AudioClassificationPipeline</code>.</li> <li><code>&quot;automatic-speech-recognition&quot;</code>: will return a <code>AutomaticSpeechRecognitionPipeline</code>.</li> <li><code>&quot;document-question-answering&quot;</code>: will return a <code>DocumentQuestionAnsweringPipeline</code>.</li> <li><code>&quot;feature-extraction&quot;</code>: will return a <code>FeatureExtractionPipeline</code>.</li> <li><code>&quot;fill-mask&quot;</code>: will return a <code>FillMaskPipeline</code>.</li> <li><code>&quot;image-classification&quot;</code>: will return a <code>ImageClassificationPipeline</code>.</li> <li><code>&quot;image-segmentation&quot;</code>: will return a <code>ImageSegmentationPipeline</code>.</li> <li><code>&quot;image-to-text&quot;</code>: will return a <code>ImageToTextPipeline</code>.</li> <li><code>&quot;object-detection&quot;</code>: will return a <code>ObjectDetectionPipeline</code>.</li> <li><code>&quot;question-answering&quot;</code>: will return a <code>QuestionAnsweringPipeline</code>.</li> <li><code>&quot;summarization&quot;</code>: will return a <code>SummarizationPipeline</code>.</li> <li><code>&quot;text2text-generation&quot;</code>: will return a <code>Text2TextGenerationPipeline</code>.</li> <li><code>&quot;text-classification&quot;</code> (alias &quot;sentiment-analysis&quot; available): will return a <code>TextClassificationPipeline</code>.</li> <li><code>&quot;text-generation&quot;</code>: will return a <code>TextGenerationPipeline</code>.</li> <li><code>&quot;token-classification&quot;</code> (alias &quot;ner&quot; available): will return a <code>TokenClassificationPipeline</code>.</li> <li><code>&quot;translation&quot;</code>: will return a <code>TranslationPipeline</code>.</li> <li><code>&quot;translation_xx_to_yy&quot;</code>: will return a <code>TranslationPipeline</code>.</li> <li><code>&quot;zero-shot-classification&quot;</code>: will return a <code>ZeroShotClassificationPipeline</code>.</li> <li><code>&quot;zero-shot-image-classification&quot;</code>: will return a <code>ZeroShotImageClassificationPipeline</code>.</li></ul></td> </tr><tr><td>[model]</td><td><code>string</code></td><td><code>null</code></td><td><p>The name of the pre-trained model to use. If not specified, the default model for the task will be used.</p></td> </tr><tr><td>[options]</td><td><code>*</code></td><td></td><td><p>Optional parameters for the pipeline.</p></td></tr></tbody>",gT,IT,kT,wn,GT,jn,ZT,Un,cJ='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Properties</strong>',BT,fn,rJ="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>answer</td><td><code>string</code></td><td><p>The answer.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score.</p></td></tr></tbody>",QT,vT,NT,bn,AT,xn,_T,Cn,MJ='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',$T,RT,VT,gn,YT,In,PT,kn,TJ='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',ET,Gn,mJ="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>chunk</td><td><code>Chunk</code></td><td><p>The chunk to process.</p></td></tr></tbody>",HT,WT,zT,Bn,XT;return U=new J({props:{title:"pipelines",local:"pipelines",headingTag:"h1"}}),x=new h({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnc2VudGltZW50LWFuYWx5c2lzJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ0klMjBsb3ZlJTIwdHJhbnNmb3JtZXJzIScpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJ2xhYmVsJyUzQSUyMCdQT1NJVElWRSclMkMlMjAnc2NvcmUnJTNBJTIwMC45OTk4MTc2ODYlN0QlNUQ=",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.999817686}]</span>`,wrap:!1}}),I=new J({props:{title:"pipelines.Pipeline ⇐ <code> Callable </code>",local:"pipelinespipeline--code-callable-code",headingTag:"h2"}}),Q=new J({props:{title:"new Pipeline(options)",local:"new-pipelineoptions",headingTag:"h3"}}),_=new J({props:{title:"pipeline.dispose() ⇒ <code> Promise. < void > </code>",local:"pipelinedispose--code-promise--void--code",headingTag:"h3"}}),Y=new J({props:{title:"pipeline._call(texts, ...args) ⇒ <code> Promise. < any > </code>",local:"pipelinecalltexts-args--code-promise--any--code",headingTag:"h3"}}),z=new J({props:{title:"pipelines.TextClassificationPipeline",local:"pipelinestextclassificationpipeline",headingTag:"h2"}}),L=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnWGVub3ZhJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcignSSUyMGxvdmUlMjB0cmFuc2Zvcm1lcnMhJyklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjBsYWJlbCUzQSUyMCdQT1NJVElWRSclMkMlMjBzY29yZSUzQSUyMDAuOTk5Nzg4NzYxMTM4OTE2JTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{ label: &#x27;POSITIVE&#x27;, score: 0.999788761138916 }]</span>`,wrap:!1}}),D=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnWGVub3ZhJTJGYmVydC1iYXNlLW11bHRpbGluZ3VhbC11bmNhc2VkLXNlbnRpbWVudCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKCdMZSUyMG1laWxsZXVyJTIwZmlsbSUyMGRlJTIwdG91cyUyMGxlcyUyMHRlbXBzLiclMkMlMjAlN0IlMjB0b3BrJTNBJTIwNSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCc1JTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjk2MTA3NTk2MTU4OTgxMzIlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCc0JTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjAzMzIzMzUxNTkxODI1NDg1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnMyUyMHN0YXJzJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDM2MTU1MTgxMDA1NTk3MTE1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnMSUyMHN0YXInJTJDJTIwc2NvcmUlM0ElMjAwLjAwMTEzMjU5Njc0OTgxMjM2NDYlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCcyJTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMDk0MjM5NzEwNTk3MzIxMzklMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-multilingual-uncased-sentiment&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;Le meilleur film de tous les temps.&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-number">5</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;5 stars&#x27;, score: 0.9610759615898132 },</span>
<span class="hljs-comment">//   { label: &#x27;4 stars&#x27;, score: 0.03323351591825485 },</span>
<span class="hljs-comment">//   { label: &#x27;3 stars&#x27;, score: 0.0036155181005597115 },</span>
<span class="hljs-comment">//   { label: &#x27;1 star&#x27;, score: 0.0011325967498123646 },</span>
<span class="hljs-comment">//   { label: &#x27;2 stars&#x27;, score: 0.0009423971059732139 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),O=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RleHQtY2xhc3NpZmljYXRpb24nJTJDJTIwJ1hlbm92YSUyRnRveGljLWJlcnQnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcignSSUyMGhhdGUlMjB5b3UhJyUyQyUyMCU3QiUyMHRvcGslM0ElMjBudWxsJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RveGljJyUyQyUyMHNjb3JlJTNBJTIwMC45NTkzMTQwNDgyOTAyNTI3JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnaW5zdWx0JyUyQyUyMHNjb3JlJTNBJTIwMC4xNjE4NzMzNDA2MDY2ODk0NSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ29ic2NlbmUnJTJDJTIwc2NvcmUlM0ElMjAwLjAzNDUyNjgwNjMyNDcyMDM4JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnaWRlbnRpdHlfaGF0ZSclMkMlMjBzY29yZSUzQSUyMDAuMDIyMzI1MDU3NTM2MzYzNiUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RocmVhdCclMkMlMjBzY29yZSUzQSUyMDAuMDE5MTk3MDQxMTY4ODA4OTM3JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnc2V2ZXJlX3RveGljJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDU2NTEwOTk2MDczNDg0NDIlMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/toxic-bert&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I hate you!&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-literal">null</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;toxic&#x27;, score: 0.9593140482902527 },</span>
<span class="hljs-comment">//   { label: &#x27;insult&#x27;, score: 0.16187334060668945 },</span>
<span class="hljs-comment">//   { label: &#x27;obscene&#x27;, score: 0.03452680632472038 },</span>
<span class="hljs-comment">//   { label: &#x27;identity_hate&#x27;, score: 0.0223250575363636 },</span>
<span class="hljs-comment">//   { label: &#x27;threat&#x27;, score: 0.019197041168808937 },</span>
<span class="hljs-comment">//   { label: &#x27;severe_toxic&#x27;, score: 0.005651099607348442 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),te=new J({props:{title:"textClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"textclassificationpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),ae=new J({props:{title:"pipelines.TokenClassificationPipeline",local:"pipelinestokenclassificationpipeline",headingTag:"h2"}}),de=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3Rva2VuLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtTkVSJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ015JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwTG9uZG9uJyklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnQi1QRVInJTJDJTIwc2NvcmUlM0ElMjAwLjk5ODAyMDI5MTMyODQzMDIlMkMlMjBpbmRleCUzQSUyMDQlMkMlMjB3b3JkJTNBJTIwJ1NhcmFoJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5NDQ3NDA1MzM4Mjg3NCUyQyUyMGluZGV4JTNBJTIwOSUyQyUyMHdvcmQlM0ElMjAnTG9uZG9uJyUyMCU3RCUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-NER&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;My name is Sarah and I live in London&#x27;</span>);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { entity: &#x27;B-PER&#x27;, score: 0.9980202913284302, index: 4, word: &#x27;Sarah&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;B-LOC&#x27;, score: 0.9994474053382874, index: 9, word: &#x27;London&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),re=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3Rva2VuLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtTkVSJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ1NhcmFoJTIwbGl2ZXMlMjBpbiUyMHRoZSUyMFVuaXRlZCUyMFN0YXRlcyUyMG9mJTIwQW1lcmljYSclMkMlMjAlN0IlMjBpZ25vcmVfbGFiZWxzJTNBJTIwJTVCJTVEJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLVBFUiclMkMlMjBzY29yZSUzQSUyMDAuOTk2NjU4NzQyNDI3ODI1OSUyQyUyMGluZGV4JTNBJTIwMSUyQyUyMHdvcmQlM0ElMjAnU2FyYWgnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwZW50aXR5JTNBJTIwJ08nJTJDJTIwc2NvcmUlM0ElMjAwLjk5ODczODU4NjkwMjYxODQlMkMlMjBpbmRleCUzQSUyMDIlMkMlMjB3b3JkJTNBJTIwJ2xpdmVzJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdPJyUyQyUyMHNjb3JlJTNBJTIwMC45OTkwMDcyODQ2NDEyNjU5JTJDJTIwaW5kZXglM0ElMjAzJTJDJTIwd29yZCUzQSUyMCdpbiclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnTyclMkMlMjBzY29yZSUzQSUyMDAuOTk4ODI5ODQxNjEzNzY5NSUyQyUyMGluZGV4JTNBJTIwNCUyQyUyMHdvcmQlM0ElMjAndGhlJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5NTUxMDU3ODE1NTUxOCUyQyUyMGluZGV4JTNBJTIwNSUyQyUyMHdvcmQlM0ElMjAnVW5pdGVkJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdJLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5MDM5NTMwNzU0MDg5NCUyQyUyMGluZGV4JTNBJTIwNiUyQyUyMHdvcmQlM0ElMjAnU3RhdGVzJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdJLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk4NjcyNDg1MzUxNTYyNSUyQyUyMGluZGV4JTNBJTIwNyUyQyUyMHdvcmQlM0ElMjAnb2YnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwZW50aXR5JTNBJTIwJ0ktTE9DJyUyQyUyMHNjb3JlJTNBJTIwMC45OTc1Mjk0NDcwNzg3MDQ4JTJDJTIwaW5kZXglM0ElMjA4JTJDJTIwd29yZCUzQSUyMCdBbWVyaWNhJyUyMCU3RCUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-NER&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;Sarah lives in the United States of America&#x27;</span>, { <span class="hljs-attr">ignore_labels</span>: [] });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { entity: &#x27;B-PER&#x27;, score: 0.9966587424278259, index: 1, word: &#x27;Sarah&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9987385869026184, index: 2, word: &#x27;lives&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9990072846412659, index: 3, word: &#x27;in&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9988298416137695, index: 4, word: &#x27;the&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;B-LOC&#x27;, score: 0.9995510578155518, index: 5, word: &#x27;United&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9990395307540894, index: 6, word: &#x27;States&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9986724853515625, index: 7, word: &#x27;of&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9975294470787048, index: 8, word: &#x27;America&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),me=new J({props:{title:"tokenClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"tokenclassificationpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),we=new J({props:{title:"pipelines.QuestionAnsweringPipeline",local:"pipelinesquestionansweringpipeline",headingTag:"h2"}}),fe=new h({props:{code:"bGV0JTIwcXVlc3Rpb24lMjAlM0QlMjAnV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJyUzQiUwQWxldCUyMGNvbnRleHQlMjAlM0QlMjAnSmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQuJyUzQiUwQSUwQWxldCUyMGFuc3dlcmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgncXVlc3Rpb24tYW5zd2VyaW5nJyUyQyUyMCdYZW5vdmElMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1kaXN0aWxsZWQtc3F1YWQnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwYW5zd2VyZXIocXVlc3Rpb24lMkMlMjBjb250ZXh0KSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMmFuc3dlciUyMiUzQSUyMCUyMmElMjBuaWNlJTIwcHVwcGV0JTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyc2NvcmUlMjIlM0ElMjAwLjU3Njg5MTE1MDI1MjY3NDElMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> question = <span class="hljs-string">&#x27;Who was Jim Henson?&#x27;</span>;
<span class="hljs-keyword">let</span> context = <span class="hljs-string">&#x27;Jim Henson was a nice puppet.&#x27;</span>;

<span class="hljs-keyword">let</span> answerer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;question-answering&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-distilled-squad&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">answerer</span>(question, context);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;answer&quot;: &quot;a nice puppet&quot;,</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.5768911502526741</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Ce=new J({props:{title:"questionAnsweringPipeline._call(question, context, options) ⇒ <code> QuestionAnsweringReturnType </code>",local:"questionansweringpipelinecallquestion-context-options--code-questionansweringreturntype-code",headingTag:"h3"}}),Ze=new J({props:{title:"pipelines.FillMaskPipeline",local:"pipelinesfillmaskpipeline",headingTag:"h2"}}),ve=new h({props:{code:"bGV0JTIwdW5tYXNrZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmaWxsLW1hc2snJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS1jYXNlZCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB1bm1hc2tlcignVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwJTVCTUFTSyU1RC4nKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHRva2VuX3N0ciUzQSUyMCdzdXJ2aXZhbCclMkMlMjBzY29yZSUzQSUyMDAuMDYxMzc0MTk0OTIwMDYzMDIlMkMlMjB0b2tlbiUzQSUyMDgxMTUlMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBzdXJ2aXZhbC4nJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwdG9rZW5fc3RyJTNBJTIwJ2xvdmUnJTJDJTIwc2NvcmUlM0ElMjAwLjAzOTAyNDUwMjAzODk1NTY5JTJDJTIwdG9rZW4lM0ElMjAxNTY3JTJDJTIwc2VxdWVuY2UlM0ElMjAnVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwbG92ZS4nJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwdG9rZW5fc3RyJTNBJTIwJ2hhcHBpbmVzcyclMkMlMjBzY29yZSUzQSUyMDAuMDMyNTMxODM1MTM4Nzk3NzYlMkMlMjB0b2tlbiUzQSUyMDkyNjYlMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBoYXBwaW5lc3MuJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHRva2VuX3N0ciUzQSUyMCdmcmVlZG9tJyUyQyUyMHNjb3JlJTNBJTIwMC4wMTg3MzYzMDY1Nzc5MjA5MTQlMkMlMjB0b2tlbiUzQSUyMDQ0MzglMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBmcmVlZG9tLiclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjB0b2tlbl9zdHIlM0ElMjAnbGlmZSclMkMlMjBzY29yZSUzQSUyMDAuMDE4NTk3OTQ3NDMzNTkwODklMkMlMjB0b2tlbiUzQSUyMDEyOTclMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBsaWZlLiclMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> unmasker = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-cased&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">unmasker</span>(<span class="hljs-string">&#x27;The goal of life is [MASK].&#x27;</span>);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { token_str: &#x27;survival&#x27;, score: 0.06137419492006302, token: 8115, sequence: &#x27;The goal of life is survival.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;love&#x27;, score: 0.03902450203895569, token: 1567, sequence: &#x27;The goal of life is love.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;happiness&#x27;, score: 0.03253183513879776, token: 9266, sequence: &#x27;The goal of life is happiness.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;freedom&#x27;, score: 0.018736306577920914, token: 4438, sequence: &#x27;The goal of life is freedom.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;life&#x27;, score: 0.01859794743359089, token: 1297, sequence: &#x27;The goal of life is life.&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Ae=new h({props:{code:"bGV0JTIwdW5tYXNrZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmaWxsLW1hc2snJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS1jYXNlZCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB1bm1hc2tlcignVGhlJTIwTWlsa3klMjBXYXklMjBpcyUyMGElMjAlNUJNQVNLJTVEJTIwZ2FsYXh5LiclMkMlMjAlN0IlMjB0b3BrJTNBJTIwMSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjB0b2tlbl9zdHIlM0ElMjAnc3BpcmFsJyUyQyUyMHNjb3JlJTNBJTIwMC42Mjk5OTg3NDM1MzQwODgxJTJDJTIwdG9rZW4lM0ElMjAxNDA2MSUyQyUyMHNlcXVlbmNlJTNBJTIwJ1RoZSUyME1pbGt5JTIwV2F5JTIwaXMlMjBhJTIwc3BpcmFsJTIwZ2FsYXh5LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> unmasker = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-cased&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">unmasker</span>(<span class="hljs-string">&#x27;The Milky Way is a [MASK] galaxy.&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-number">1</span> });
<span class="hljs-comment">// [{ token_str: &#x27;spiral&#x27;, score: 0.6299987435340881, token: 14061, sequence: &#x27;The Milky Way is a spiral galaxy.&#x27; }]</span>`,wrap:!1}}),Re=new J({props:{title:"fillMaskPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"fillmaskpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),He=new J({props:{title:"pipelines.Text2TextGenerationPipeline",local:"pipelinestext2textgenerationpipeline",headingTag:"h2"}}),Xe=new h({props:{code:"bGV0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dDJ0ZXh0LWdlbmVyYXRpb24nJTJDJTIwJ1hlbm92YSUyRkxhTWluaS1GbGFuLVQ1LTc4M00nKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwZ2VuZXJhdG9yKCdob3clMjBjYW4lMjBJJTIwYmVjb21lJTIwbW9yZSUyMGhlYWx0aHklM0YnJTJDJTIwJTdCJTBBJTIwJTIwbWF4X25ld190b2tlbnMlM0ElMjAxMDAlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAlMjJUbyUyMGJlY29tZSUyMG1vcmUlMjBoZWFsdGh5JTJDJTIweW91JTIwY2FuJTNBJTIwMS4lMjBFYXQlMjBhJTIwYmFsYW5jZWQlMjBkaWV0JTIwd2l0aCUyMHBsZW50eSUyMG9mJTIwZnJ1aXRzJTJDJTIwdmVnZXRhYmxlcyUyQyUyMHdob2xlJTIwZ3JhaW5zJTJDJTIwbGVhbiUyMHByb3RlaW5zJTJDJTIwYW5kJTIwaGVhbHRoeSUyMGZhdHMuJTIwMi4lMjBTdGF5JTIwaHlkcmF0ZWQlMjBieSUyMGRyaW5raW5nJTIwcGxlbnR5JTIwb2YlMjB3YXRlci4lMjAzLiUyMEdldCUyMGVub3VnaCUyMHNsZWVwJTIwYW5kJTIwbWFuYWdlJTIwc3RyZXNzJTIwbGV2ZWxzLiUyMDQuJTIwQXZvaWQlMjBzbW9raW5nJTIwYW5kJTIwZXhjZXNzaXZlJTIwYWxjb2hvbCUyMGNvbnN1bXB0aW9uLiUyMDUuJTIwUmVndWxhcmx5JTIwZXhlcmNpc2UlMjBhbmQlMjBtYWludGFpbiUyMGElMjBoZWFsdGh5JTIwd2VpZ2h0LiUyMDYuJTIwUHJhY3RpY2UlMjBnb29kJTIwaHlnaWVuZSUyMGFuZCUyMHNhbml0YXRpb24uJTIwNy4lMjBTZWVrJTIwbWVkaWNhbCUyMGF0dGVudGlvbiUyMGlmJTIweW91JTIwZXhwZXJpZW5jZSUyMGFueSUyMGhlYWx0aCUyMGlzc3Vlcy4lMjIlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text2text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/LaMini-Flan-T5-783M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(<span class="hljs-string">&#x27;how can I become more healthy?&#x27;</span>, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">100</span>,
});
<span class="hljs-comment">// [{ generated_text: &quot;To become more healthy, you can: 1. Eat a balanced diet with plenty of fruits, vegetables, whole grains, lean proteins, and healthy fats. 2. Stay hydrated by drinking plenty of water. 3. Get enough sleep and manage stress levels. 4. Avoid smoking and excessive alcohol consumption. 5. Regularly exercise and maintain a healthy weight. 6. Practice good hygiene and sanitation. 7. Seek medical attention if you experience any health issues.&quot; }]</span>`,wrap:!1}}),Fe=new J({props:{title:"text2TextGenerationPipeline._call(texts, [options]) ⇒ <code> Promise. < any > </code>",local:"text2textgenerationpipelinecalltexts-options--code-promise--any--code",headingTag:"h3"}}),tt=new J({props:{title:"pipelines.SummarizationPipeline",local:"pipelinessummarizationpipeline",headingTag:"h2"}}),it=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdUaGUlMjB0b3dlciUyMGlzJTIwMzI0JTIwbWV0cmVzJTIwKDElMkMwNjMlMjBmdCklMjB0YWxsJTJDJTIwYWJvdXQlMjB0aGUlMjBzYW1lJTIwaGVpZ2h0JTIwYXMlMjBhbiUyMDgxLXN0b3JleSUyMGJ1aWxkaW5nJTJDJTIwJyUyMCUyQiUwQSUyMCUyMCdhbmQlMjB0aGUlMjB0YWxsZXN0JTIwc3RydWN0dXJlJTIwaW4lMjBQYXJpcy4lMjBJdHMlMjBiYXNlJTIwaXMlMjBzcXVhcmUlMkMlMjBtZWFzdXJpbmclMjAxMjUlMjBtZXRyZXMlMjAoNDEwJTIwZnQpJTIwb24lMjBlYWNoJTIwc2lkZS4lMjAnJTIwJTJCJTBBJTIwJTIwJ0R1cmluZyUyMGl0cyUyMGNvbnN0cnVjdGlvbiUyQyUyMHRoZSUyMEVpZmZlbCUyMFRvd2VyJTIwc3VycGFzc2VkJTIwdGhlJTIwV2FzaGluZ3RvbiUyME1vbnVtZW50JTIwdG8lMjBiZWNvbWUlMjB0aGUlMjB0YWxsZXN0JTIwJyUyMCUyQiUwQSUyMCUyMCdtYW4tbWFkZSUyMHN0cnVjdHVyZSUyMGluJTIwdGhlJTIwd29ybGQlMkMlMjBhJTIwdGl0bGUlMjBpdCUyMGhlbGQlMjBmb3IlMjA0MSUyMHllYXJzJTIwdW50aWwlMjB0aGUlMjBDaHJ5c2xlciUyMEJ1aWxkaW5nJTIwaW4lMjBOZXclMjAnJTIwJTJCJTBBJTIwJTIwJ1lvcmslMjBDaXR5JTIwd2FzJTIwZmluaXNoZWQlMjBpbiUyMDE5MzAuJTIwSXQlMjB3YXMlMjB0aGUlMjBmaXJzdCUyMHN0cnVjdHVyZSUyMHRvJTIwcmVhY2glMjBhJTIwaGVpZ2h0JTIwb2YlMjAzMDAlMjBtZXRyZXMuJTIwRHVlJTIwdG8lMjAnJTIwJTJCJTBBJTIwJTIwJ3RoZSUyMGFkZGl0aW9uJTIwb2YlMjBhJTIwYnJvYWRjYXN0aW5nJTIwYWVyaWFsJTIwYXQlMjB0aGUlMjB0b3AlMjBvZiUyMHRoZSUyMHRvd2VyJTIwaW4lMjAxOTU3JTJDJTIwaXQlMjBpcyUyMG5vdyUyMHRhbGxlciUyMHRoYW4lMjB0aGUlMjAnJTIwJTJCJTBBJTIwJTIwJ0NocnlzbGVyJTIwQnVpbGRpbmclMjBieSUyMDUuMiUyMG1ldHJlcyUyMCgxNyUyMGZ0KS4lMjBFeGNsdWRpbmclMjB0cmFuc21pdHRlcnMlMkMlMjB0aGUlMjBFaWZmZWwlMjBUb3dlciUyMGlzJTIwdGhlJTIwc2Vjb25kJTIwJyUyMCUyQiUwQSUyMCUyMCd0YWxsZXN0JTIwZnJlZS1zdGFuZGluZyUyMHN0cnVjdHVyZSUyMGluJTIwRnJhbmNlJTIwYWZ0ZXIlMjB0aGUlMjBNaWxsYXUlMjBWaWFkdWN0LiclM0IlMEElMEFsZXQlMjBnZW5lcmF0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdzdW1tYXJpemF0aW9uJyUyQyUyMCdYZW5vdmElMkZkaXN0aWxiYXJ0LWNubi02LTYnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwZ2VuZXJhdG9yKHRleHQlMkMlMjAlN0IlMEElMjAlMjBtYXhfbmV3X3Rva2VucyUzQSUyMDEwMCUyQyUwQSU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjBzdW1tYXJ5X3RleHQlM0ElMjAnJTIwVGhlJTIwRWlmZmVsJTIwVG93ZXIlMjBpcyUyMGFib3V0JTIwdGhlJTIwc2FtZSUyMGhlaWdodCUyMGFzJTIwYW4lMjA4MS1zdG9yZXklMjBidWlsZGluZyUyMGFuZCUyMHRoZSUyMHRhbGxlc3QlMjBzdHJ1Y3R1cmUlMjBpbiUyMFBhcmlzLiUyMEl0JTIwaXMlMjB0aGUlMjBzZWNvbmQlMjB0YWxsZXN0JTIwZnJlZS1zdGFuZGluZyUyMHN0cnVjdHVyZSUyMGluJTIwRnJhbmNlJTIwYWZ0ZXIlMjB0aGUlMjBNaWxsYXUlMjBWaWFkdWN0LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, &#x27;</span> +
  <span class="hljs-string">&#x27;and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. &#x27;</span> +
  <span class="hljs-string">&#x27;During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest &#x27;</span> +
  <span class="hljs-string">&#x27;man-made structure in the world, a title it held for 41 years until the Chrysler Building in New &#x27;</span> +
  <span class="hljs-string">&#x27;York City was finished in 1930. It was the first structure to reach a height of 300 metres. Due to &#x27;</span> +
  <span class="hljs-string">&#x27;the addition of a broadcasting aerial at the top of the tower in 1957, it is now taller than the &#x27;</span> +
  <span class="hljs-string">&#x27;Chrysler Building by 5.2 metres (17 ft). Excluding transmitters, the Eiffel Tower is the second &#x27;</span> +
  <span class="hljs-string">&#x27;tallest free-standing structure in France after the Millau Viaduct.&#x27;</span>;

<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;summarization&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbart-cnn-6-6&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">100</span>,
});
<span class="hljs-comment">// [{ summary_text: &#x27; The Eiffel Tower is about the same height as an 81-storey building and the tallest structure in Paris. It is the second tallest free-standing structure in France after the Millau Viaduct.&#x27; }]</span>`,wrap:!1}}),pt=new J({props:{title:"pipelines.TranslationPipeline",local:"pipelinestranslationpipeline",headingTag:"h2"}}),rt=new h({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZubGxiLTIwMC1kaXN0aWxsZWQtNjAwTScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKCclRTAlQTQlOUMlRTAlQTUlODAlRTAlQTQlQjUlRTAlQTQlQTglMjAlRTAlQTQlOEYlRTAlQTQlOTUlMjAlRTAlQTQlOUElRTAlQTUlODklRTAlQTQlOTUlRTAlQTQlQjIlRTAlQTUlODclRTAlQTQlOUYlMjAlRTAlQTQlQUMlRTAlQTUlODklRTAlQTQlOTUlRTAlQTUlOEQlRTAlQTQlQjglMjAlRTAlQTQlOTUlRTAlQTUlODAlMjAlRTAlQTQlQTQlRTAlQTQlQjAlRTAlQTQlQjklMjAlRTAlQTQlQjklRTAlQTUlODglRTAlQTUlQTQnJTJDJTIwJTdCJTBBJTIwJTIwc3JjX2xhbmclM0ElMjAnaGluX0RldmEnJTJDJTIwJTJGJTJGJTIwSGluZGklMEElMjAlMjB0Z3RfbGFuZyUzQSUyMCdmcmFfTGF0biclMkMlMjAlMkYlMkYlMjBGcmVuY2glMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwdHJhbnNsYXRpb25fdGV4dCUzQSUyMCdMYSUyMHZpZSUyMGVzdCUyMGNvbW1lJTIwdW5lJTIwYm8lQzMlQUV0ZSUyMCVDMyVBMCUyMGNob2NvbGF0LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nllb-200-distilled-600M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;जीवन एक चॉकलेट बॉक्स की तरह है।&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;hin_Deva&#x27;</span>, <span class="hljs-comment">// Hindi</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;fra_Latn&#x27;</span>, <span class="hljs-comment">// French</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;La vie est comme une boîte à chocolat.&#x27; }]</span>`,wrap:!1}}),mt=new h({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZtMm0xMDBfNDE4TScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKCclRTclOTQlOUYlRTYlQjQlQkIlRTUlQjAlQjElRTUlODMlOEYlRTQlQjglODAlRTclOUIlOTIlRTUlQjclQTclRTUlODUlOEIlRTUlOEElOUIlRTMlODAlODInJTJDJTIwJTdCJTBBJTIwJTIwc3JjX2xhbmclM0ElMjAnemgnJTJDJTIwJTJGJTJGJTIwQ2hpbmVzZSUwQSUyMCUyMHRndF9sYW5nJTNBJTIwJ2VuJyUyQyUyMCUyRiUyRiUyMEVuZ2xpc2glMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwdHJhbnNsYXRpb25fdGV4dCUzQSUyMCdMaWZlJTIwaXMlMjBsaWtlJTIwYSUyMGJveCUyMG9mJTIwY2hvY29sYXRlLiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/m2m100_418M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;生活就像一盒巧克力。&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;zh&#x27;</span>, <span class="hljs-comment">// Chinese</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-comment">// English</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;Life is like a box of chocolate.&#x27; }]</span>`,wrap:!1}}),Jt=new h({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zbGF0b3IoJyVFMCVBNCVCOCVFMCVBNCU4MiVFMCVBNCVBRiVFMCVBNSU4MSVFMCVBNCU5NSVFMCVBNSU4RCVFMCVBNCVBNCUyMCVFMCVBNCVCMCVFMCVBNCVCRSVFMCVBNCVCNyVFMCVBNSU4RCVFMCVBNCU5RiVFMCVBNSU4RCVFMCVBNCVCMCUyMCVFMCVBNCU5NSVFMCVBNSU4NyUyMCVFMCVBNCVBQSVFMCVBNSU4RCVFMCVBNCVCMCVFMCVBNCVBRSVFMCVBNSU4MSVFMCVBNCU5NiUyMCVFMCVBNCU5NSVFMCVBNCVCRSUyMCVFMCVBNCU5NSVFMCVBNCVCOSVFMCVBNCVBOCVFMCVBNCVCRSUyMCVFMCVBNCVCOSVFMCVBNSU4OCUyMCVFMCVBNCU5NSVFMCVBNCVCRiUyMCVFMCVBNCVCOCVFMCVBNSU4MCVFMCVBNCVCMCVFMCVBNCVCRiVFMCVBNCVBRiVFMCVBNCVCRSUyMCVFMCVBNCVBRSVFMCVBNSU4NyVFMCVBNCU4MiUyMCVFMCVBNCU5NSVFMCVBNSU4QiVFMCVBNCU4OCUyMCVFMCVBNCVCOCVFMCVBNSU4OCVFMCVBNCVBOCVFMCVBNSU4RCVFMCVBNCVBRiUyMCVFMCVBNCVCOCVFMCVBNCVBRSVFMCVBNCVCRSVFMCVBNCVBNyVFMCVBNCVCRSVFMCVBNCVBOCUyMCVFMCVBNCVBOCVFMCVBNCVCOSVFMCVBNSU4MCVFMCVBNCU4MiUyMCVFMCVBNCVCOSVFMCVBNSU4OCclMkMlMjAlN0IlMEElMjAlMjBzcmNfbGFuZyUzQSUyMCdoaV9JTiclMkMlMjAlMkYlMkYlMjBIaW5kaSUwQSUyMCUyMHRndF9sYW5nJTNBJTIwJ2ZyX1hYJyUyQyUyMCUyRiUyRiUyMEZyZW5jaCUwQSU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjB0cmFuc2xhdGlvbl90ZXh0JTNBJTIwJ0xlJTIwY2hlZiUyMGRlcyUyME5hdGlvbnMlMjBhZmZpcm1lJTIwcXUlMjAnaWwlMjBuJTIwJ3klMjBhJTIwbWlsaXRhcnklMjBzb2x1dGlvbiUyMGluJTIwU3lyaWEuJyUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/mbart-large-50-many-to-many-mmt&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;संयुक्त राष्ट्र के प्रमुख का कहना है कि सीरिया में कोई सैन्य समाधान नहीं है&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;hi_IN&#x27;</span>, <span class="hljs-comment">// Hindi</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;fr_XX&#x27;</span>, <span class="hljs-comment">// French</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;Le chef des Nations affirme qu &#x27;il n &#x27;y a military solution in Syria.&#x27; }]</span>`,wrap:!1}}),jt=new J({props:{title:"pipelines.TextGenerationPipeline",local:"pipelinestextgenerationpipeline",headingTag:"h2"}}),bt=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdJJTIwZW5qb3klMjB3YWxraW5nJTIwd2l0aCUyMG15JTIwY3V0ZSUyMGRvZyUyQyclM0IlMEFsZXQlMjBnZW5lcmF0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCd0ZXh0LWdlbmVyYXRpb24nJTJDJTIwJ1hlbm92YSUyRmRpc3RpbGdwdDInKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwZ2VuZXJhdG9yKHRleHQpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAlMjJJJTIwZW5qb3klMjB3YWxraW5nJTIwd2l0aCUyMG15JTIwY3V0ZSUyMGRvZyUyQyUyMGFuZCUyMEklMjBsb3ZlJTIwdG8lMjBwbGF5JTIwd2l0aCUyMHRoZSUyMG90aGVyJTIwZG9ncy4lMjIlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;I enjoy walking with my cute dog,&#x27;</span>;
<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilgpt2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text);
<span class="hljs-comment">// [{ generated_text: &quot;I enjoy walking with my cute dog, and I love to play with the other dogs.&quot; }]</span>`,wrap:!1}}),Ct=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwdGhlcmUlMjB3YXMnJTNCJTBBbGV0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC1nZW5lcmF0aW9uJyUyQyUyMCdYZW5vdmElMkZkaXN0aWxncHQyJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGdlbmVyYXRvcih0ZXh0JTJDJTIwJTdCJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAyJTJDJTBBJTIwJTIwbWF4X25ld190b2tlbnMlM0ElMjAxMCUyQyUwQSUyMCUyMHJlcGV0aXRpb25fcGVuYWx0eSUzQSUyMDEuNSUyQyUwQSUyMCUyMG5vX3JlcGVhdF9uZ3JhbV9zaXplJTNBJTIwMiUyQyUwQSUyMCUyMG51bV9iZWFtcyUzQSUyMDIlMkMlMEElMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzQSUyMDIlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIyZ2VuZXJhdGVkX3RleHQlMjIlM0ElMjAlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwdGhlcmUlMjB3YXMlMjBhbiUyMGFidW5kYW5jZSUyMG9mJTIwaW5mb3JtYXRpb24lMjBhYm91dCUyMHRoZSUyMGhpc3RvcnklMjBhbmQlMjBhY3Rpdml0aWVzJTIwdGhhdCUyMiUwQSUyRiUyRiUyMCU3RCUyQyUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMmdlbmVyYXRlZF90ZXh0JTIyJTNBJTIwJTIyT25jZSUyMHVwb24lMjBhJTIwdGltZSUyQyUyMHRoZXJlJTIwd2FzJTIwYW4lMjBhYnVuZGFuY2UlMjBvZiUyMGluZm9ybWF0aW9uJTIwYWJvdXQlMjB0aGUlMjBtb3N0JTIwaW1wb3J0YW50JTIwYW5kJTIwaW5mbHVlbnRpYWwlMjIlMEElMkYlMkYlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;Once upon a time, there was&#x27;</span>;
<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilgpt2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">10</span>,
  <span class="hljs-attr">repetition_penalty</span>: <span class="hljs-number">1.5</span>,
  <span class="hljs-attr">no_repeat_ngram_size</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">num_beams</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">num_return_sequences</span>: <span class="hljs-number">2</span>,
});
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   &quot;generated_text&quot;: &quot;Once upon a time, there was an abundance of information about the history and activities that&quot;</span>
<span class="hljs-comment">// }, {</span>
<span class="hljs-comment">//   &quot;generated_text&quot;: &quot;Once upon a time, there was an abundance of information about the most important and influential&quot;</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),It=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdkZWYlMjBmaWIobiklM0EnJTNCJTBBbGV0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC1nZW5lcmF0aW9uJyUyQyUyMCdYZW5vdmElMkZjb2RlZ2VuLTM1ME0tbW9ubycpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBnZW5lcmF0b3IodGV4dCUyQyUyMCU3QiUwQSUyMCUyMG1heF9uZXdfdG9rZW5zJTNBJTIwNDQlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTBBJTJGJTJGJTIwJTIwJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAnZGVmJTIwZmliKG4pJTNBJTVDbiclMjAlMkIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAnJTIwJTIwJTIwJTIwaWYlMjBuJTIwJTNEJTNEJTIwMCUzQSU1Q24nJTIwJTJCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMDAlNUNuJyUyMCUyQiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCclMjAlMjAlMjAlMjBlbGlmJTIwbiUyMCUzRCUzRCUyMDElM0ElNUNuJyUyMCUyQiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAxJTVDbiclMjAlMkIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAnJTIwJTIwJTIwJTIwZWxzZSUzQSU1Q24nJTIwJTJCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGZpYihuLTEpJTIwJTJCJTIwZmliKG4tMiklNUNuJyUwQSUyRiUyRiUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;def fib(n):&#x27;</span>;
<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/codegen-350M-mono&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">44</span>,
});
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   generated_text: &#x27;def fib(n):\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    if n == 0:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return 0\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    elif n == 1:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return 1\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    else:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return fib(n-1) + fib(n-2)\\n&#x27;</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),Zt=new J({props:{title:"textGenerationPipeline._call(texts, [generate_kwargs]) ⇒ <code> Promise. < any > </code>",local:"textgenerationpipelinecalltexts-generatekwargs--code-promise--any--code",headingTag:"h3"}}),At=new J({props:{title:"pipelines.ZeroShotClassificationPipeline",local:"pipelineszeroshotclassificationpipeline",headingTag:"h2"}}),Rt=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdMYXN0JTIwd2VlayUyMEklMjB1cGdyYWRlZCUyMG15JTIwaU9TJTIwdmVyc2lvbiUyMGFuZCUyMGV2ZXIlMjBzaW5jZSUyMHRoZW4lMjBteSUyMHBob25lJTIwaGFzJTIwYmVlbiUyMG92ZXJoZWF0aW5nJTIwd2hlbmV2ZXIlMjBJJTIwdXNlJTIweW91ciUyMGFwcC4nJTNCJTBBbGV0JTIwbGFiZWxzJTIwJTNEJTIwJTVCJTIwJ21vYmlsZSclMkMlMjAnYmlsbGluZyclMkMlMjAnd2Vic2l0ZSclMkMlMjAnYWNjb3VudCUyMGFjY2VzcyclMjAlNUQlM0IlMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZtb2JpbGViZXJ0LXVuY2FzZWQtbW5saScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHRleHQlMkMlMjBsYWJlbHMpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwc2VxdWVuY2UlM0ElMjAnTGFzdCUyMHdlZWslMjBJJTIwdXBncmFkZWQlMjBteSUyMGlPUyUyMHZlcnNpb24lMjBhbmQlMjBldmVyJTIwc2luY2UlMjB0aGVuJTIwbXklMjBwaG9uZSUyMGhhcyUyMGJlZW4lMjBvdmVyaGVhdGluZyUyMHdoZW5ldmVyJTIwSSUyMHVzZSUyMHlvdXIlMjBhcHAuJyUyQyUwQSUyRiUyRiUyMCUyMCUyMGxhYmVscyUzQSUyMCU1QiUyMCdtb2JpbGUnJTJDJTIwJ3dlYnNpdGUnJTJDJTIwJ2JpbGxpbmcnJTJDJTIwJ2FjY291bnQlMjBhY2Nlc3MnJTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwc2NvcmVzJTNBJTIwJTVCJTIwMC41NTYyMDkxMDQwNDgyMDE4JTJDJTIwMC4xODQzNjIxMzA3ODYwODUzJTJDJTIwMC4xMzk0MjY0NjYzOTMzNjM3NiUyQyUyMDAuMTIwMDAyMjk4NzcyMzQ5MjMlMjAlNUQlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;Last week I upgraded my iOS version and ever since then my phone has been overheating whenever I use your app.&#x27;</span>;
<span class="hljs-keyword">let</span> labels = [ <span class="hljs-string">&#x27;mobile&#x27;</span>, <span class="hljs-string">&#x27;billing&#x27;</span>, <span class="hljs-string">&#x27;website&#x27;</span>, <span class="hljs-string">&#x27;account access&#x27;</span> ];
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/mobilebert-uncased-mnli&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, labels);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   sequence: &#x27;Last week I upgraded my iOS version and ever since then my phone has been overheating whenever I use your app.&#x27;,</span>
<span class="hljs-comment">//   labels: [ &#x27;mobile&#x27;, &#x27;website&#x27;, &#x27;billing&#x27;, &#x27;account access&#x27; ],</span>
<span class="hljs-comment">//   scores: [ 0.5562091040482018, 0.1843621307860853, 0.13942646639336376, 0.12000229877234923 ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Yt=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdJJTIwaGF2ZSUyMGElMjBwcm9ibGVtJTIwd2l0aCUyMG15JTIwaXBob25lJTIwdGhhdCUyMG5lZWRzJTIwdG8lMjBiZSUyMHJlc29sdmVkJTIwYXNhcCEnJTNCJTBBbGV0JTIwbGFiZWxzJTIwJTNEJTIwJTVCJTIwJ3VyZ2VudCclMkMlMjAnbm90JTIwdXJnZW50JyUyQyUyMCdwaG9uZSclMkMlMjAndGFibGV0JyUyQyUyMCdjb21wdXRlciclMjAlNUQlM0IlMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZubGktZGViZXJ0YS12My14c21hbGwnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwJTdCJTIwbXVsdGlfbGFiZWwlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHNlcXVlbmNlJTNBJTIwJ0klMjBoYXZlJTIwYSUyMHByb2JsZW0lMjB3aXRoJTIwbXklMjBpcGhvbmUlMjB0aGF0JTIwbmVlZHMlMjB0byUyMGJlJTIwcmVzb2x2ZWQlMjBhc2FwISclMkMlMEElMkYlMkYlMjAlMjAlMjBsYWJlbHMlM0ElMjAlNUIlMjAndXJnZW50JyUyQyUyMCdwaG9uZSclMkMlMjAnY29tcHV0ZXInJTJDJTIwJ3RhYmxldCclMkMlMjAnbm90JTIwdXJnZW50JyUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMHNjb3JlcyUzQSUyMCU1QiUyMDAuOTk1ODg3MDk1NjM2MDI3NSUyQyUyMDAuOTkyMzk2MzQwMDY5NzAzNSUyQyUyMDAuMDAyMzMzNTM3OTQ2MTYwMjM1JTJDJTIwMC4wMDE1MTM0MTM4NTY3NTk4NzY1JTJDJTIwMC4wMDEwNjk5Mzg0MjA4Mzc3MTYzJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!&#x27;</span>;
<span class="hljs-keyword">let</span> labels = [ <span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span> ];
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nli-deberta-v3-xsmall&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, labels, { <span class="hljs-attr">multi_label</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   sequence: &#x27;I have a problem with my iphone that needs to be resolved asap!&#x27;,</span>
<span class="hljs-comment">//   labels: [ &#x27;urgent&#x27;, &#x27;phone&#x27;, &#x27;computer&#x27;, &#x27;tablet&#x27;, &#x27;not urgent&#x27; ],</span>
<span class="hljs-comment">//   scores: [ 0.9958870956360275, 0.9923963400697035, 0.002333537946160235, 0.0015134138567598765, 0.0010699384208377163 ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Wt=new J({props:{title:"new ZeroShotClassificationPipeline(options)",local:"new-zeroshotclassificationpipelineoptions",headingTag:"h3"}}),Lt=new J({props:{title:"zeroShotClassificationPipeline._call(texts, candidate_labels, options) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"zeroshotclassificationpipelinecalltexts-candidatelabels-options--code-promise--objectarray--object----code",headingTag:"h3"}}),Ot=new J({props:{title:"pipelines.FeatureExtractionPipeline",local:"pipelinesfeatureextractionpipeline",headingTag:"h2"}}),tl=new h({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMjAlN0IlMjByZXZpc2lvbiUzQSUyMCdkZWZhdWx0JyUyMCU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSUyMCU1QjAuMDU5Mzk5MjQ3MTY5NDk0NjMlMkMlMjAwLjAyMTY1NTkzNTc5NDExNTA2NyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwOCUyQyUyMDc2OCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-uncased&#x27;</span>, { <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;default&#x27;</span> });
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.05939924716949463, 0.021655935794115067, ...],</span>
<span class="hljs-comment">//   dims: [1, 8, 768]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),sl=new h({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMjAlN0IlMjByZXZpc2lvbiUzQSUyMCdkZWZhdWx0JyUyMCU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyUyQyUyMCU3QiUyMHBvb2xpbmclM0ElMjAnbWVhbiclMkMlMjBub3JtYWxpemUlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMFRlbnNvciUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCMC4wMzM3Mzc3ODk4Mzk1MDYxNSUyQyUyMC0wLjAxMDEwNjA3NzQxNzczMTI4NSUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwNzY4JTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-uncased&#x27;</span>, { <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;default&#x27;</span> });
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&#x27;mean&#x27;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.03373778983950615, -0.010106077417731285, ...],</span>
<span class="hljs-comment">//   dims: [1, 768]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),nl=new h({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZhbGwtTWluaUxNLUw2LXYyJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyUyQyUyMCU3QiUyMHBvb2xpbmclM0ElMjAnbWVhbiclMkMlMjBub3JtYWxpemUlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMFRlbnNvciUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCMC4wOTA5NDk4MjU5NDI1MTYzMyUyQyUyMC0wLjAxNDc3NDI0NjE0MTMxNDUwNyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwMzg0JTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/all-MiniLM-L6-v2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&#x27;mean&#x27;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.09094982594251633, -0.014774246141314507, ...],</span>
<span class="hljs-comment">//   dims: [1, 384]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),ol=new J({props:{title:"featureExtractionPipeline._call(texts, options) ⇒",local:"featureextractionpipelinecalltexts-options-",headingTag:"h3"}}),Tl=new J({props:{title:"pipelines.AudioClassificationPipeline",local:"pipelinesaudioclassificationpipeline",headingTag:"h2"}}),ul=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMGNsYXNzaWZpZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdhdWRpby1jbGFzc2lmaWNhdGlvbiclMkMlMjAnWGVub3ZhJTJGd2F2MnZlYzItbGFyZ2UteGxzci01My1nZW5kZXItcmVjb2duaXRpb24tbGlicmlzcGVlY2gnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnbWFsZSclMkMlMjBzY29yZSUzQSUyMDAuOTk4MTU0MjIyOTY1MjQwNSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ2ZlbWFsZSclMkMlMjBzY29yZSUzQSUyMDAuMDAxODQ1NzQ3ODE0NTEzNzQzJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;audio-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/wav2vec2-large-xlsr-53-gender-recognition-librispeech&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;male&#x27;, score: 0.9981542229652405 },</span>
<span class="hljs-comment">//   { label: &#x27;female&#x27;, score: 0.001845747814513743 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),jl=new J({props:{title:"new AudioClassificationPipeline(options)",local:"new-audioclassificationpipelineoptions",headingTag:"h3"}}),xl=new J({props:{title:"audioClassificationPipeline._call(audio, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"audioclassificationpipelinecallaudio-options--code-promise--array--object--object--code",headingTag:"h3"}}),Gl=new J({props:{title:"pipelines.AutomaticSpeechRecognitionPipeline",local:"pipelinesautomaticspeechrecognitionpipeline",headingTag:"h2"}}),Ql=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCklM0IlMEElMkYlMkYlMjAlN0IlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url);
<span class="hljs-comment">// { text: &quot; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&quot; }</span>`,wrap:!1}}),Nl=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMHJldHVybl90aW1lc3RhbXBzJTNBJTIwdHJ1ZSUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJTIyJTBBJTJGJTJGJTIwJTIwJTIwY2h1bmtzJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwdGltZXN0YW1wJTNBJTIwJTVCMCUyQyUyMDglNUQlMkMlMjAlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTIyJTIwJTdEJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwdGltZXN0YW1wJTNBJTIwJTVCOCUyQyUyMDExJTVEJTJDJTIwdGV4dCUzQSUyMCUyMiUyMGFzayUyMHdoYXQlMjB5b3UlMjBjYW4lMjBkbyUyMGZvciUyMHlvdXIlMjBjb3VudHJ5LiUyMiUyMCU3RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">return_timestamps</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   text: &quot; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&quot;</span>
<span class="hljs-comment">//   chunks: [</span>
<span class="hljs-comment">//     { timestamp: [0, 8],  text: &quot; And so my fellow Americans ask not what your country can do for you&quot; }</span>
<span class="hljs-comment">//     { timestamp: [8, 11], text: &quot; ask what you can do for your country.&quot; }</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),_l=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyUyQyUyMCU3QiUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNBJTIwJ291dHB1dF9hdHRlbnRpb25zJyUyQyUwQSU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMHJldHVybl90aW1lc3RhbXBzJTNBJTIwJ3dvcmQnJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjAlMjIlMjBBbmQlMjBzbyUyMG15JTIwZmVsbG93JTIwQW1lcmljYW5zJTIwYXNrJTIwbm90JTIwd2hhdCUyMHlvdXIlMjBjb3VudHJ5JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3UlMjBhc2slMjB3aGF0JTIweW91JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3VyJTIwY291bnRyeS4lMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJjaHVua3MlMjIlM0ElMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwQW5kJTIyJTJDJTIwJTIydGltZXN0YW1wJTIyJTNBJTIwJTVCMCUyQyUyMDAuNzglNUQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwc28lMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUIwLjc4JTJDJTIwMS4wNiU1RCUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnRleHQlMjIlM0ElMjAlMjIlMjBteSUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMCU1QjEuMDYlMkMlMjAxLjQ2JTVEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIydGV4dCUyMiUzQSUyMCUyMiUyMGZvciUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMCU1QjkuNzIlMkMlMjA5LjkyJTVEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIydGV4dCUyMiUzQSUyMCUyMiUyMHlvdXIlMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUI5LjkyJTJDJTIwMTAuMjIlNUQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwY291bnRyeS4lMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUIxMC4yMiUyQyUyMDEzLjUlNUQlMjAlN0QlMEElMkYlMkYlMjAlMjAlMjAlNUQlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>, {
    <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;output_attentions&#x27;</span>,
});
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">return_timestamps</span>: <span class="hljs-string">&#x27;word&#x27;</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;text&quot;: &quot; And so my fellow Americans ask not what your country can do for you ask what you can do for your country.&quot;,</span>
<span class="hljs-comment">//   &quot;chunks&quot;: [</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; And&quot;, &quot;timestamp&quot;: [0, 0.78] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; so&quot;, &quot;timestamp&quot;: [0.78, 1.06] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; my&quot;, &quot;timestamp&quot;: [1.06, 1.46] },</span>
<span class="hljs-comment">//     ...</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; for&quot;, &quot;timestamp&quot;: [9.72, 9.92] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; your&quot;, &quot;timestamp&quot;: [9.92, 10.22] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; country.&quot;, &quot;timestamp&quot;: [10.22, 13.5] }</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Rl=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmcmVuY2gtYXVkaW8ubXAzJyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci1zbWFsbCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwlMkMlMjAlN0IlMjBsYW5ndWFnZSUzQSUyMCdmcmVuY2gnJTJDJTIwdGFzayUzQSUyMCd0cmFuc2NyaWJlJyUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMjB0ZXh0JTNBJTIwJTIyJTIwSidhZG9yZSUyQyUyMGonYWltZSUyQyUyMGplJTIwbidhaW1lJTIwcGFzJTJDJTIwamUlMjBkJUMzJUE5dGVzdGUuJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/french-audio.mp3&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">language</span>: <span class="hljs-string">&#x27;french&#x27;</span>, <span class="hljs-attr">task</span>: <span class="hljs-string">&#x27;transcribe&#x27;</span> });
<span class="hljs-comment">// { text: &quot; J&#x27;adore, j&#x27;aime, je n&#x27;aime pas, je déteste.&quot; }</span>`,wrap:!1}}),Yl=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmcmVuY2gtYXVkaW8ubXAzJyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci1zbWFsbCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwlMkMlMjAlN0IlMjBsYW5ndWFnZSUzQSUyMCdmcmVuY2gnJTJDJTIwdGFzayUzQSUyMCd0cmFuc2xhdGUnJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAlMjIlMjBJJTIwbG92ZSUyQyUyMEklMjBsaWtlJTJDJTIwSSUyMGRvbid0JTIwbGlrZSUyQyUyMEklMjBoYXRlLiUyMiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/french-audio.mp3&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">language</span>: <span class="hljs-string">&#x27;french&#x27;</span>, <span class="hljs-attr">task</span>: <span class="hljs-string">&#x27;translate&#x27;</span> });
<span class="hljs-comment">// { text: &quot; I love, I like, I don&#x27;t like, I hate.&quot; }</span>`,wrap:!1}}),El=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0ZWRfNjAud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMGNodW5rX2xlbmd0aF9zJTNBJTIwMzAlMkMlMjBzdHJpZGVfbGVuZ3RoX3MlM0ElMjA1JTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAlMjIlMjBTbyUyMGluJTIwY29sbGVnZSUyQyUyMEklMjB3YXMlMjBhJTIwZ292ZXJubWVudCUyMG1ham9yJTJDJTIwd2hpY2glMjBtZWFucyUyMCU1Qi4uLiU1RCUyMFNvJTIwSSdkJTIwc3RhcnQlMjBvZmYlMjBsaWdodCUyMGFuZCUyMEknZCUyMGJ1bXAlMjBpdCUyMHVwJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/ted_60.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">chunk_length_s</span>: <span class="hljs-number">30</span>, <span class="hljs-attr">stride_length_s</span>: <span class="hljs-number">5</span> });
<span class="hljs-comment">// { text: &quot; So in college, I was a government major, which means [...] So I&#x27;d start off light and I&#x27;d bump it up&quot; }</span>`,wrap:!1}}),Xl=new J({props:{title:"new AutomaticSpeechRecognitionPipeline(options)",local:"new-automaticspeechrecognitionpipelineoptions",headingTag:"h3"}}),Dl=new J({props:{title:"automaticSpeechRecognitionPipeline._call(audio, [kwargs]) ⇒ <code> Promise. < Object > </code>",local:"automaticspeechrecognitionpipelinecallaudio-kwargs--code-promise--object--code",headingTag:"h3"}}),ts=new J({props:{title:"pipelines.ImageToTextPipeline",local:"pipelinesimagetotextpipeline",headingTag:"h2"}}),is=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEFsZXQlMjBjYXB0aW9uZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdpbWFnZS10by10ZXh0JyUyQyUyMCdYZW5vdmElMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNhcHRpb25lcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAnYSUyMGNhdCUyMGxheWluZyUyMG9uJTIwYSUyMGNvdWNoJTIwd2l0aCUyMGFub3RoZXIlMjBjYXQnJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> captioner = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-text&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-gpt2-image-captioning&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">captioner</span>(url);
<span class="hljs-comment">// [{ generated_text: &#x27;a cat laying on a couch with another cat&#x27; }]</span>`,wrap:!1}}),as=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZoYW5kd3JpdGluZy5qcGcnJTNCJTBBbGV0JTIwY2FwdGlvbmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnaW1hZ2UtdG8tdGV4dCclMkMlMjAnWGVub3ZhJTJGdHJvY3Itc21hbGwtaGFuZHdyaXR0ZW4nKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2FwdGlvbmVyKHVybCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjBnZW5lcmF0ZWRfdGV4dCUzQSUyMCdNci4lMjBCcm93biUyMGNvbW1lbnRlZCUyMGljaWx5LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/handwriting.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> captioner = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-text&#x27;</span>, <span class="hljs-string">&#x27;Xenova/trocr-small-handwritten&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">captioner</span>(url);
<span class="hljs-comment">// [{ generated_text: &#x27;Mr. Brown commented icily.&#x27; }]</span>`,wrap:!1}}),cs=new J({props:{title:"new ImageToTextPipeline(options)",local:"new-imagetotextpipelineoptions",headingTag:"h3"}}),ms=new J({props:{title:"imageToTextPipeline._call(images, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"imagetotextpipelinecallimages-generatekwargs--code-promise--objectarray--object----code",headingTag:"h3"}}),ws=new J({props:{title:"pipelines.ImageClassificationPipeline",local:"pipelinesimageclassificationpipeline",headingTag:"h2"}}),fs=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0JsYWJlbCUzQSUyMCd0aWdlciUyQyUyMFBhbnRoZXJhJTIwdGlncmlzJyUyQyUyMHNjb3JlJTNBJTIwMC42MzI2OTU3MzQ1MDA4ODUlN0QlMkMlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885},</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),xs=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjAzJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTJDJTIwUGFudGhlcmElMjB0aWdyaXMnJTJDJTIwc2NvcmUlM0ElMjAwLjYzMjY5NTczNDUwMDg4NSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zNjM0ODI1NjQ2ODc3Mjg5JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnbGlvbiUyQyUyMGtpbmclMjBvZiUyMGJlYXN0cyUyQyUyMFBhbnRoZXJhJTIwbGVvJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDA0NTA2MDMwODE4NDQ3NDcwNyUyMCU3RCUyQyUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">3</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885 },</span>
<span class="hljs-comment">//   { label: &#x27;tiger cat&#x27;, score: 0.3634825646877289 },</span>
<span class="hljs-comment">//   { label: &#x27;lion, king of beasts, Panthera leo&#x27;, score: 0.00045060308184474707 },</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),gs=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjAwJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ3RpZ2VyJTJDJTIwUGFudGhlcmElMjB0aWdyaXMnJTJDJTIwc2NvcmUlM0ElMjAwLjYzMjY5NTczNDUwMDg4NSU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zNjM0ODI1NjQ2ODc3Mjg5JTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCbGFiZWwlM0ElMjAnbGlvbiUyQyUyMGtpbmclMjBvZiUyMGJlYXN0cyUyQyUyMFBhbnRoZXJhJTIwbGVvJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDA0NTA2MDMwODE4NDQ3NDcwNyU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ2phZ3VhciUyQyUyMHBhbnRoZXIlMkMlMjBQYW50aGVyYSUyMG9uY2ElMkMlMjBGZWxpcyUyMG9uY2EnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMDM1NDY1NDk5OTY4MjY3OTc3JTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">0</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885},</span>
<span class="hljs-comment">//   {label: &#x27;tiger cat&#x27;, score: 0.3634825646877289},</span>
<span class="hljs-comment">//   {label: &#x27;lion, king of beasts, Panthera leo&#x27;, score: 0.00045060308184474707},</span>
<span class="hljs-comment">//   {label: &#x27;jaguar, panther, Panthera onca, Felis onca&#x27;, score: 0.00035465499968267977},</span>
<span class="hljs-comment">//   ...</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Zs=new J({props:{title:"new ImageClassificationPipeline(options)",local:"new-imageclassificationpipelineoptions",headingTag:"h3"}}),Ns=new J({props:{title:"imageClassificationPipeline._call(images, options) ⇒ <code> Promise. < any > </code>",local:"imageclassificationpipelinecallimages-options--code-promise--any--code",headingTag:"h3"}}),Vs=new J({props:{title:"pipelines.ImageSegmentationPipeline",local:"pipelinesimagesegmentationpipeline",headingTag:"h2"}}),Es=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEFsZXQlMjBzZWdtZW50ZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdpbWFnZS1zZWdtZW50YXRpb24nJTJDJTIwJ1hlbm92YSUyRmRldHItcmVzbmV0LTUwLXBhbm9wdGljJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHNlZ21lbnRlcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAncmVtb3RlJyUyQyUyMHNjb3JlJTNBJTIwMC45OTg0NjQ5NDE5Nzg0NTQ2JTJDJTIwbWFzayUzQSUyMFJhd0ltYWdlJTIwJTdCJTIwLi4uJTIwJTdEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC45OTk0MzE2MTAxMDc0MjE5JTJDJTIwbWFzayUzQSUyMFJhd0ltYWdlJTIwJTdCJTIwLi4uJTIwJTdEJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> segmenter = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-segmentation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/detr-resnet-50-panoptic&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">segmenter</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;remote&#x27;, score: 0.9984649419784546, mask: RawImage { ... } },</span>
<span class="hljs-comment">//   { label: &#x27;cat&#x27;, score: 0.9994316101074219, mask: RawImage { ... } }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Xs=new J({props:{title:"new ImageSegmentationPipeline(options)",local:"new-imagesegmentationpipelineoptions",headingTag:"h3"}}),Ds=new J({props:{title:"imageSegmentationPipeline._call(images, options) ⇒ <code> Promise. < Array > </code>",local:"imagesegmentationpipelinecallimages-options--code-promise--array--code",headingTag:"h3"}}),ti=new J({props:{title:"pipelines.ZeroShotImageClassificationPipeline",local:"pipelineszeroshotimageclassificationpipeline",headingTag:"h2"}}),ii=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3plcm8tc2hvdC1pbWFnZS1jbGFzc2lmaWNhdGlvbiclMkMlMjAnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDMyJyklM0IlMEFsZXQlMjB1cmwlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRnRpZ2VyLmpwZyclM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIodXJsJTJDJTIwJTVCJ3RpZ2VyJyUyQyUyMCdob3JzZSclMkMlMjAnZG9nJyU1RCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBzY29yZSUzQSUyMDAuOTk5MzkxNzk0MjA0NzExOSUyQyUyMGxhYmVsJTNBJTIwJ3RpZ2VyJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHNjb3JlJTNBJTIwMC4wMDAzNTE5Mjk0ODQxNjgwNjc2JTJDJTIwbGFiZWwlM0ElMjAnaG9yc2UnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwc2NvcmUlM0ElMjAwLjAwMDI1NjI2OTg3OTE3MzQ4NzQlMkMlMjBsYWJlbCUzQSUyMCdkb2cnJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/clip-vit-base-patch32&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, [<span class="hljs-string">&#x27;tiger&#x27;</span>, <span class="hljs-string">&#x27;horse&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { score: 0.9993917942047119, label: &#x27;tiger&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0003519294841680676, label: &#x27;horse&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0002562698791734874, label: &#x27;dog&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),oi=new J({props:{title:"new ZeroShotImageClassificationPipeline(options)",local:"new-zeroshotimageclassificationpipelineoptions",headingTag:"h3"}}),Mi=new J({props:{title:"zeroShotImageClassificationPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>",local:"zeroshotimageclassificationpipelinecallimages-candidatelabels-options--code-promise--any--code",headingTag:"h3"}}),Ji=new J({props:{title:"pipelines.ObjectDetectionPipeline",local:"pipelinesobjectdetectionpipeline",headingTag:"h2"}}),ji=new h({props:{code:"bGV0JTIwaW1nJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEElMEFsZXQlMjBkZXRlY3RvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ29iamVjdC1kZXRlY3Rpb24nJTJDJTIwJ1hlbm92YSUyRmRldHItcmVzbmV0LTUwJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGRldGVjdG9yKGltZyUyQyUyMCU3QiUyMHRocmVzaG9sZCUzQSUyMDAuOSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjJzY29yZSUyMiUzQSUyMDAuOTk3NjM3MDkzMDY3MTY5MiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTIycmVtb3RlJTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyYm94JTIyJTNBJTIwJTdCJTIwJTIyeG1pbiUyMiUzQSUyMDMxJTJDJTIwJTIyeW1pbiUyMiUzQSUyMDY4JTJDJTIwJTIyeG1heCUyMiUzQSUyMDE5MCUyQyUyMCUyMnltYXglMjIlM0ElMjAxMTglMjAlN0QlMEElMkYlMkYlMjAlN0QlMkMlMEElMkYlMkYlMjAuLi4lMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjJzY29yZSUyMiUzQSUyMDAuOTk4NDA5MjExNjM1NTg5NiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2F0JTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyYm94JTIyJTNBJTIwJTdCJTIwJTIyeG1pbiUyMiUzQSUyMDMzMSUyQyUyMCUyMnltaW4lMjIlM0ElMjAxOSUyQyUyMCUyMnhtYXglMjIlM0ElMjA2NDklMkMlMjAlMjJ5bWF4JTIyJTNBJTIwMzcxJTIwJTdEJTBBJTJGJTJGJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> img = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;

<span class="hljs-keyword">let</span> detector = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;object-detection&#x27;</span>, <span class="hljs-string">&#x27;Xenova/detr-resnet-50&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">detector</span>(img, { <span class="hljs-attr">threshold</span>: <span class="hljs-number">0.9</span> });
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.9976370930671692,</span>
<span class="hljs-comment">//   &quot;label&quot;: &quot;remote&quot;,</span>
<span class="hljs-comment">//   &quot;box&quot;: { &quot;xmin&quot;: 31, &quot;ymin&quot;: 68, &quot;xmax&quot;: 190, &quot;ymax&quot;: 118 }</span>
<span class="hljs-comment">// },</span>
<span class="hljs-comment">// ...</span>
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.9984092116355896,</span>
<span class="hljs-comment">//   &quot;label&quot;: &quot;cat&quot;,</span>
<span class="hljs-comment">//   &quot;box&quot;: { &quot;xmin&quot;: 331, &quot;ymin&quot;: 19, &quot;xmax&quot;: 649, &quot;ymax&quot;: 371 }</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),xi=new J({props:{title:"new ObjectDetectionPipeline(options)",local:"new-objectdetectionpipelineoptions",headingTag:"h3"}}),ki=new J({props:{title:"objectDetectionPipeline._call(images, options)",local:"objectdetectionpipelinecallimages-options",headingTag:"h3"}}),vi=new J({props:{title:"pipelines.DocumentQuestionAnsweringPipeline",local:"pipelinesdocumentquestionansweringpipeline",headingTag:"h2"}}),_i=new h({props:{code:"bGV0JTIwaW1hZ2UlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmludm9pY2UucG5nJyUzQiUwQWxldCUyMHF1ZXN0aW9uJTIwJTNEJTIwJ1doYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YnJTNCJTBBJTBBbGV0JTIwcWFfcGlwZWxpbmUlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdkb2N1bWVudC1xdWVzdGlvbi1hbnN3ZXJpbmcnJTJDJTIwJ1hlbm92YSUyRmRvbnV0LWJhc2UtZmluZXR1bmVkLWRvY3ZxYScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBxYV9waXBlbGluZShpbWFnZSUyQyUyMHF1ZXN0aW9uKSUzQiUwQSUyRiUyRiUyMCU1QiU3QiUyMGFuc3dlciUzQSUyMCd1cy0wMDEnJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> image = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/invoice.png&#x27;</span>;
<span class="hljs-keyword">let</span> question = <span class="hljs-string">&#x27;What is the invoice number?&#x27;</span>;

<span class="hljs-keyword">let</span> qa_pipeline = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;document-question-answering&#x27;</span>, <span class="hljs-string">&#x27;Xenova/donut-base-finetuned-docvqa&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">qa_pipeline</span>(image, question);
<span class="hljs-comment">// [{ answer: &#x27;us-001&#x27; }]</span>`,wrap:!1}}),Yi=new J({props:{title:"new DocumentQuestionAnsweringPipeline(options)",local:"new-documentquestionansweringpipelineoptions",headingTag:"h3"}}),Wi=new J({props:{title:"documentQuestionAnsweringPipeline._call(image, question, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"documentquestionansweringpipelinecallimage-question-generatekwargs--code-promise--objectarray--object----code",headingTag:"h3"}}),Fi=new J({props:{title:"pipelines.TextToAudioPipeline",local:"pipelinestexttoaudiopipeline",headingTag:"h2"}}),Oi=new h({props:{code:"bGV0JTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZzcGVha2VyX2VtYmVkZGluZ3MuYmluJyUzQiUwQWxldCUyMHN5bnRoZXNpemVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC10by1zcGVlY2gnJTJDJTIwJ1hlbm92YSUyRnNwZWVjaHQ1X3R0cyclMkMlMjAlN0IlMjBxdWFudGl6ZWQlM0ElMjBmYWxzZSUyMCU3RCklM0IlMEFsZXQlMjBvdXQlMjAlM0QlMjBhd2FpdCUyMHN5bnRoZXNpemVyKCdIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJyUyQyUyMCU3QiUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBhdWRpbyUzQSUyMEZsb2F0MzJBcnJheSgyNjExMiklMjAlNUItMC4wMDAwNTY1NzMzNzg5Njk5MTUyMSUyQyUyMDAuMDAwMjA1ODM4NzQ3MjA2MTQ0MDMlMkMlMjAuLi4lNUQlMkMlMEElMkYlMkYlMjAlMjAlMjBzYW1wbGluZ19yYXRlJTNBJTIwMTYwMDAlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> speaker_embeddings = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/speaker_embeddings.bin&#x27;</span>;
<span class="hljs-keyword">let</span> synthesizer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-to-speech&#x27;</span>, <span class="hljs-string">&#x27;Xenova/speecht5_tts&#x27;</span>, { <span class="hljs-attr">quantized</span>: <span class="hljs-literal">false</span> });
<span class="hljs-keyword">let</span> out = <span class="hljs-keyword">await</span> <span class="hljs-title function_">synthesizer</span>(<span class="hljs-string">&#x27;Hello, my dog is cute&#x27;</span>, { speaker_embeddings });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   audio: Float32Array(26112) [-0.00005657337896991521, 0.00020583874720614403, ...],</span>
<span class="hljs-comment">//   sampling_rate: 16000</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),en=new h({props:{code:"aW1wb3J0JTIwd2F2ZWZpbGUlMjBmcm9tJTIwJ3dhdmVmaWxlJyUzQiUwQWltcG9ydCUyMGZzJTIwZnJvbSUyMCdmcyclM0IlMEElMEFsZXQlMjB3YXYlMjAlM0QlMjBuZXclMjB3YXZlZmlsZS5XYXZlRmlsZSgpJTNCJTBBd2F2LmZyb21TY3JhdGNoKDElMkMlMjBvdXQuc2FtcGxpbmdfcmF0ZSUyQyUyMCczMmYnJTJDJTIwb3V0LmF1ZGlvKSUzQiUwQWZzLndyaXRlRmlsZVN5bmMoJ291dC53YXYnJTJDJTIwd2F2LnRvQnVmZmVyKCkpJTNC",highlighted:`<span class="hljs-keyword">import</span> wavefile <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;wavefile&#x27;</span>;
<span class="hljs-keyword">import</span> fs <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;fs&#x27;</span>;

<span class="hljs-keyword">let</span> wav = <span class="hljs-keyword">new</span> wavefile.<span class="hljs-title class_">WaveFile</span>();
wav.<span class="hljs-title function_">fromScratch</span>(<span class="hljs-number">1</span>, out.<span class="hljs-property">sampling_rate</span>, <span class="hljs-string">&#x27;32f&#x27;</span>, out.<span class="hljs-property">audio</span>);
fs.<span class="hljs-title function_">writeFileSync</span>(<span class="hljs-string">&#x27;out.wav&#x27;</span>, wav.<span class="hljs-title function_">toBuffer</span>());`,wrap:!1}}),nn=new J({props:{title:"new TextToAudioPipeline(options)",local:"new-texttoaudiopipelineoptions",headingTag:"h3"}}),dn=new J({props:{title:"textToAudioPipeline._call(text_inputs, options) ⇒ <code> Promise. < Object > </code>",local:"texttoaudiopipelinecalltextinputs-options--code-promise--object--code",headingTag:"h3"}}),mn=new J({props:{title:"pipelines.pipeline(task, [model], [options]) ⇒ <code> Promise. < Pipeline > </code>",local:"pipelinespipelinetask-model-options--code-promise--pipeline--code",headingTag:"h2"}}),jn=new J({props:{title:"pipelines~QuestionAnsweringResult : <code> object </code>",local:"pipelinesquestionansweringresult--code-object-code",headingTag:"h2"}}),xn=new J({props:{title:"pipelines~QuestionAnsweringReturnType : <code> Promise. < (QuestionAnsweringResult|Array < QuestionAnsweringResult > ) > </code>",local:"pipelinesquestionansweringreturntype--code-promise--questionansweringresultarray--questionansweringresult----code",headingTag:"h2"}}),In=new J({props:{title:"pipelines~ChunkCallback : <code> function </code>",local:"pipelineschunkcallback--code-function-code",headingTag:"h2"}}),{c(){w=a("meta"),Qn=i(),Zn=a("p"),vn=i(),j=a("a"),Nn=i(),c(U.$$.fragment),An=i(),f=a("p"),f.textContent=LT,_n=i(),b=a("p"),b.innerHTML=FT,$n=i(),c(x.$$.fragment),Rn=i(),C=a("ul"),C.innerHTML=DT,Vn=i(),Yn=a("hr"),Pn=i(),g=a("a"),En=i(),c(I.$$.fragment),Hn=i(),k=a("p"),k.textContent=qT,Wn=i(),G=a("p"),G.innerHTML=OT,zn=i(),Z=a("ul"),Z.innerHTML=KT,Xn=i(),Sn=a("hr"),Ln=i(),B=a("a"),Fn=i(),c(Q.$$.fragment),Dn=i(),v=a("p"),v.textContent=em,qn=i(),N=a("table"),N.innerHTML=tm,On=i(),Kn=a("hr"),ea=i(),A=a("a"),ta=i(),c(_.$$.fragment),la=i(),$=a("p"),$.textContent=lm,sa=i(),R=a("p"),R.innerHTML=sm,ia=i(),na=a("hr"),aa=i(),V=a("a"),pa=i(),c(Y.$$.fragment),oa=i(),P=a("p"),P.textContent=im,da=i(),E=a("p"),E.innerHTML=nm,ca=i(),H=a("table"),H.innerHTML=am,ra=i(),Ma=a("hr"),Ta=i(),W=a("a"),ma=i(),c(z.$$.fragment),ya=i(),X=a("p"),X.innerHTML=pm,ua=i(),S=a("p"),S.innerHTML=om,Ja=i(),c(L.$$.fragment),ha=i(),F=a("p"),F.innerHTML=dm,wa=i(),c(D.$$.fragment),ja=i(),q=a("p"),q.innerHTML=cm,Ua=i(),c(O.$$.fragment),fa=i(),K=a("p"),K.innerHTML=rm,ba=i(),xa=a("hr"),Ca=i(),ee=a("a"),ga=i(),c(te.$$.fragment),Ia=i(),le=a("p"),le.textContent=Mm,ka=i(),se=a("p"),se.innerHTML=Tm,Ga=i(),ie=a("table"),ie.innerHTML=mm,Za=i(),Ba=a("hr"),Qa=i(),ne=a("a"),va=i(),c(ae.$$.fragment),Na=i(),pe=a("p"),pe.innerHTML=ym,Aa=i(),oe=a("p"),oe.innerHTML=um,_a=i(),c(de.$$.fragment),$a=i(),ce=a("p"),ce.innerHTML=Jm,Ra=i(),c(re.$$.fragment),Va=i(),Me=a("p"),Me.innerHTML=hm,Ya=i(),Pa=a("hr"),Ea=i(),Te=a("a"),Ha=i(),c(me.$$.fragment),Wa=i(),ye=a("p"),ye.textContent=wm,za=i(),ue=a("p"),ue.innerHTML=jm,Xa=i(),Je=a("table"),Je.innerHTML=Um,Sa=i(),La=a("hr"),Fa=i(),he=a("a"),Da=i(),c(we.$$.fragment),qa=i(),je=a("p"),je.innerHTML=fm,Oa=i(),Ue=a("p"),Ue.innerHTML=bm,Ka=i(),c(fe.$$.fragment),ep=i(),be=a("p"),be.innerHTML=xm,tp=i(),lp=a("hr"),sp=i(),xe=a("a"),ip=i(),c(Ce.$$.fragment),np=i(),ge=a("p"),ge.textContent=Cm,ap=i(),Ie=a("p"),Ie.innerHTML=gm,pp=i(),ke=a("table"),ke.innerHTML=Im,op=i(),dp=a("hr"),cp=i(),Ge=a("a"),rp=i(),c(Ze.$$.fragment),Mp=i(),Be=a("p"),Be.innerHTML=km,Tp=i(),Qe=a("p"),Qe.innerHTML=Gm,mp=i(),c(ve.$$.fragment),yp=i(),Ne=a("p"),Ne.innerHTML=Zm,up=i(),c(Ae.$$.fragment),Jp=i(),_e=a("p"),_e.innerHTML=Bm,hp=i(),wp=a("hr"),jp=i(),$e=a("a"),Up=i(),c(Re.$$.fragment),fp=i(),Ve=a("p"),Ve.textContent=Qm,bp=i(),Ye=a("p"),Ye.innerHTML=vm,xp=i(),Pe=a("table"),Pe.innerHTML=Nm,Cp=i(),gp=a("hr"),Ip=i(),Ee=a("a"),kp=i(),c(He.$$.fragment),Gp=i(),We=a("p"),We.textContent=Am,Zp=i(),ze=a("p"),ze.innerHTML=_m,Bp=i(),c(Xe.$$.fragment),Qp=i(),Se=a("p"),Se.innerHTML=$m,vp=i(),Np=a("hr"),Ap=i(),Le=a("a"),_p=i(),c(Fe.$$.fragment),$p=i(),De=a("p"),De.textContent=Rm,Rp=i(),qe=a("p"),qe.innerHTML=Vm,Vp=i(),Oe=a("ul"),Oe.innerHTML=Ym,Yp=i(),Ke=a("table"),Ke.innerHTML=Pm,Pp=i(),Ep=a("hr"),Hp=i(),et=a("a"),Wp=i(),c(tt.$$.fragment),zp=i(),lt=a("p"),lt.textContent=Em,Xp=i(),st=a("p"),st.innerHTML=Hm,Sp=i(),c(it.$$.fragment),Lp=i(),nt=a("p"),nt.innerHTML=Wm,Fp=i(),Dp=a("hr"),qp=i(),at=a("a"),Op=i(),c(pt.$$.fragment),Kp=i(),ot=a("p"),ot.textContent=zm,eo=i(),dt=a("p"),dt.innerHTML=Xm,to=i(),ct=a("p"),ct.innerHTML=Sm,lo=i(),c(rt.$$.fragment),so=i(),Mt=a("p"),Mt.innerHTML=Lm,io=i(),Tt=a("p"),Tt.innerHTML=Fm,no=i(),c(mt.$$.fragment),ao=i(),yt=a("p"),yt.innerHTML=Dm,po=i(),ut=a("p"),ut.innerHTML=qm,oo=i(),c(Jt.$$.fragment),co=i(),ht=a("p"),ht.innerHTML=Om,ro=i(),Mo=a("hr"),To=i(),wt=a("a"),mo=i(),c(jt.$$.fragment),yo=i(),Ut=a("p"),Ut.innerHTML=Km,uo=i(),ft=a("p"),ft.innerHTML=ey,Jo=i(),c(bt.$$.fragment),ho=i(),xt=a("p"),xt.innerHTML=ty,wo=i(),c(Ct.$$.fragment),jo=i(),gt=a("p"),gt.innerHTML=ly,Uo=i(),c(It.$$.fragment),fo=i(),kt=a("p"),kt.innerHTML=sy,bo=i(),xo=a("hr"),Co=i(),Gt=a("a"),go=i(),c(Zt.$$.fragment),Io=i(),Bt=a("p"),Bt.textContent=iy,ko=i(),Qt=a("p"),Qt.innerHTML=ny,Go=i(),vt=a("table"),vt.innerHTML=ay,Zo=i(),Bo=a("hr"),Qo=i(),Nt=a("a"),vo=i(),c(At.$$.fragment),No=i(),_t=a("p"),_t.innerHTML=py,Ao=i(),$t=a("p"),$t.innerHTML=oy,_o=i(),c(Rt.$$.fragment),$o=i(),Vt=a("p"),Vt.innerHTML=dy,Ro=i(),c(Yt.$$.fragment),Vo=i(),Pt=a("p"),Pt.innerHTML=cy,Yo=i(),Et=a("ul"),Et.innerHTML=ry,Po=i(),Eo=a("hr"),Ho=i(),Ht=a("a"),Wo=i(),c(Wt.$$.fragment),zo=i(),zt=a("p"),zt.textContent=My,Xo=i(),Xt=a("table"),Xt.innerHTML=Ty,So=i(),Lo=a("hr"),Fo=i(),St=a("a"),Do=i(),c(Lt.$$.fragment),qo=i(),Ft=a("p"),Ft.innerHTML=my,Oo=i(),Dt=a("table"),Dt.innerHTML=yy,Ko=i(),ed=a("hr"),td=i(),qt=a("a"),ld=i(),c(Ot.$$.fragment),sd=i(),Kt=a("p"),Kt.textContent=uy,id=i(),el=a("p"),el.innerHTML=Jy,nd=i(),c(tl.$$.fragment),ad=i(),ll=a("p"),ll.innerHTML=hy,pd=i(),c(sl.$$.fragment),od=i(),il=a("p"),il.innerHTML=wy,dd=i(),c(nl.$$.fragment),cd=i(),al=a("p"),al.innerHTML=jy,rd=i(),Md=a("hr"),Td=i(),pl=a("a"),md=i(),c(ol.$$.fragment),yd=i(),dl=a("p"),dl.textContent=Uy,ud=i(),cl=a("p"),cl.innerHTML=fy,Jd=i(),rl=a("table"),rl.innerHTML=by,hd=i(),wd=a("hr"),jd=i(),Ml=a("a"),Ud=i(),c(Tl.$$.fragment),fd=i(),ml=a("p"),ml.innerHTML=xy,bd=i(),yl=a("p"),yl.innerHTML=Cy,xd=i(),c(ul.$$.fragment),Cd=i(),Jl=a("p"),Jl.innerHTML=gy,gd=i(),hl=a("ul"),hl.innerHTML=Iy,Id=i(),kd=a("hr"),Gd=i(),wl=a("a"),Zd=i(),c(jl.$$.fragment),Bd=i(),Ul=a("p"),Ul.textContent=ky,Qd=i(),fl=a("table"),fl.innerHTML=Gy,vd=i(),Nd=a("hr"),Ad=i(),bl=a("a"),_d=i(),c(xl.$$.fragment),$d=i(),Cl=a("p"),Cl.textContent=Zy,Rd=i(),gl=a("p"),gl.innerHTML=By,Vd=i(),Il=a("table"),Il.innerHTML=Qy,Yd=i(),Pd=a("hr"),Ed=i(),kl=a("a"),Hd=i(),c(Gl.$$.fragment),Wd=i(),Zl=a("p"),Zl.textContent=vy,zd=i(),Bl=a("p"),Bl.innerHTML=Ny,Xd=i(),c(Ql.$$.fragment),Sd=i(),vl=a("p"),vl.innerHTML=Ay,Ld=i(),c(Nl.$$.fragment),Fd=i(),Al=a("p"),Al.innerHTML=_y,Dd=i(),c(_l.$$.fragment),qd=i(),$l=a("p"),$l.innerHTML=$y,Od=i(),c(Rl.$$.fragment),Kd=i(),Vl=a("p"),Vl.innerHTML=Ry,ec=i(),c(Yl.$$.fragment),tc=i(),Pl=a("p"),Pl.innerHTML=Vy,lc=i(),c(El.$$.fragment),sc=i(),Hl=a("p"),Hl.innerHTML=Yy,ic=i(),Wl=a("ul"),Wl.innerHTML=Py,nc=i(),ac=a("hr"),pc=i(),zl=a("a"),oc=i(),c(Xl.$$.fragment),dc=i(),Sl=a("p"),Sl.textContent=Ey,cc=i(),Ll=a("table"),Ll.innerHTML=Hy,rc=i(),Mc=a("hr"),Tc=i(),Fl=a("a"),mc=i(),c(Dl.$$.fragment),yc=i(),ql=a("p"),ql.textContent=Wy,uc=i(),Ol=a("p"),Ol.innerHTML=zy,Jc=i(),Kl=a("table"),Kl.innerHTML=Xy,hc=i(),wc=a("hr"),jc=i(),es=a("a"),Uc=i(),c(ts.$$.fragment),fc=i(),ls=a("p"),ls.innerHTML=Sy,bc=i(),ss=a("p"),ss.innerHTML=Ly,xc=i(),c(is.$$.fragment),Cc=i(),ns=a("p"),ns.innerHTML=Fy,gc=i(),c(as.$$.fragment),Ic=i(),ps=a("p"),ps.innerHTML=Dy,kc=i(),os=a("ul"),os.innerHTML=qy,Gc=i(),Zc=a("hr"),Bc=i(),ds=a("a"),Qc=i(),c(cs.$$.fragment),vc=i(),rs=a("p"),rs.textContent=Oy,Nc=i(),Ms=a("table"),Ms.innerHTML=Ky,Ac=i(),_c=a("hr"),$c=i(),Ts=a("a"),Rc=i(),c(ms.$$.fragment),Vc=i(),ys=a("p"),ys.textContent=eu,Yc=i(),us=a("p"),us.innerHTML=tu,Pc=i(),Js=a("table"),Js.innerHTML=lu,Ec=i(),Hc=a("hr"),Wc=i(),hs=a("a"),zc=i(),c(ws.$$.fragment),Xc=i(),js=a("p"),js.innerHTML=su,Sc=i(),Us=a("p"),Us.innerHTML=iu,Lc=i(),c(fs.$$.fragment),Fc=i(),bs=a("p"),bs.innerHTML=nu,Dc=i(),c(xs.$$.fragment),qc=i(),Cs=a("p"),Cs.innerHTML=au,Oc=i(),c(gs.$$.fragment),Kc=i(),Is=a("p"),Is.innerHTML=pu,er=i(),ks=a("ul"),ks.innerHTML=ou,tr=i(),lr=a("hr"),sr=i(),Gs=a("a"),ir=i(),c(Zs.$$.fragment),nr=i(),Bs=a("p"),Bs.textContent=du,ar=i(),Qs=a("table"),Qs.innerHTML=cu,pr=i(),or=a("hr"),dr=i(),vs=a("a"),cr=i(),c(Ns.$$.fragment),rr=i(),As=a("p"),As.textContent=ru,Mr=i(),_s=a("p"),_s.innerHTML=Mu,Tr=i(),$s=a("table"),$s.innerHTML=Tu,mr=i(),yr=a("hr"),ur=i(),Rs=a("a"),Jr=i(),c(Vs.$$.fragment),hr=i(),Ys=a("p"),Ys.innerHTML=mu,wr=i(),Ps=a("p"),Ps.innerHTML=yu,jr=i(),c(Es.$$.fragment),Ur=i(),Hs=a("p"),Hs.innerHTML=uu,fr=i(),Ws=a("ul"),Ws.innerHTML=Ju,br=i(),xr=a("hr"),Cr=i(),zs=a("a"),gr=i(),c(Xs.$$.fragment),Ir=i(),Ss=a("p"),Ss.textContent=hu,kr=i(),Ls=a("table"),Ls.innerHTML=wu,Gr=i(),Zr=a("hr"),Br=i(),Fs=a("a"),Qr=i(),c(Ds.$$.fragment),vr=i(),qs=a("p"),qs.textContent=ju,Nr=i(),Os=a("p"),Os.innerHTML=Uu,Ar=i(),Ks=a("table"),Ks.innerHTML=fu,_r=i(),$r=a("hr"),Rr=i(),ei=a("a"),Vr=i(),c(ti.$$.fragment),Yr=i(),li=a("p"),li.innerHTML=bu,Pr=i(),si=a("p"),si.innerHTML=xu,Er=i(),c(ii.$$.fragment),Hr=i(),ni=a("p"),ni.innerHTML=Cu,Wr=i(),ai=a("ul"),ai.innerHTML=gu,zr=i(),Xr=a("hr"),Sr=i(),pi=a("a"),Lr=i(),c(oi.$$.fragment),Fr=i(),di=a("p"),di.textContent=Iu,Dr=i(),ci=a("table"),ci.innerHTML=ku,qr=i(),Or=a("hr"),Kr=i(),ri=a("a"),eM=i(),c(Mi.$$.fragment),tM=i(),Ti=a("p"),Ti.textContent=Gu,lM=i(),mi=a("p"),mi.innerHTML=Zu,sM=i(),yi=a("table"),yi.innerHTML=Bu,iM=i(),nM=a("hr"),aM=i(),ui=a("a"),pM=i(),c(Ji.$$.fragment),oM=i(),hi=a("p"),hi.innerHTML=Qu,dM=i(),wi=a("p"),wi.innerHTML=vu,cM=i(),c(ji.$$.fragment),rM=i(),Ui=a("p"),Ui.innerHTML=Nu,MM=i(),fi=a("ul"),fi.innerHTML=Au,TM=i(),mM=a("hr"),yM=i(),bi=a("a"),uM=i(),c(xi.$$.fragment),JM=i(),Ci=a("p"),Ci.textContent=_u,hM=i(),gi=a("table"),gi.innerHTML=$u,wM=i(),jM=a("hr"),UM=i(),Ii=a("a"),fM=i(),c(ki.$$.fragment),bM=i(),Gi=a("p"),Gi.textContent=Ru,xM=i(),Zi=a("p"),Zi.innerHTML=Vu,CM=i(),Bi=a("table"),Bi.innerHTML=Yu,gM=i(),IM=a("hr"),kM=i(),Qi=a("a"),GM=i(),c(vi.$$.fragment),ZM=i(),Ni=a("p"),Ni.innerHTML=Pu,BM=i(),Ai=a("p"),Ai.innerHTML=Eu,QM=i(),c(_i.$$.fragment),vM=i(),$i=a("p"),$i.innerHTML=Hu,NM=i(),Ri=a("ul"),Ri.innerHTML=Wu,AM=i(),_M=a("hr"),$M=i(),Vi=a("a"),RM=i(),c(Yi.$$.fragment),VM=i(),Pi=a("p"),Pi.textContent=zu,YM=i(),Ei=a("table"),Ei.innerHTML=Xu,PM=i(),EM=a("hr"),HM=i(),Hi=a("a"),WM=i(),c(Wi.$$.fragment),zM=i(),zi=a("p"),zi.textContent=Su,XM=i(),Xi=a("p"),Xi.innerHTML=Lu,SM=i(),Si=a("table"),Si.innerHTML=Fu,LM=i(),FM=a("hr"),DM=i(),Li=a("a"),qM=i(),c(Fi.$$.fragment),OM=i(),Di=a("p"),Di.innerHTML=Du,KM=i(),qi=a("p"),qi.innerHTML=qu,eT=i(),c(Oi.$$.fragment),tT=i(),Ki=a("p"),Ki.innerHTML=Ou,lT=i(),c(en.$$.fragment),sT=i(),tn=a("p"),tn.innerHTML=Ku,iT=i(),ln=a("ul"),ln.innerHTML=eJ,nT=i(),aT=a("hr"),pT=i(),sn=a("a"),oT=i(),c(nn.$$.fragment),dT=i(),an=a("p"),an.textContent=tJ,cT=i(),pn=a("table"),pn.innerHTML=lJ,rT=i(),MT=a("hr"),TT=i(),on=a("a"),mT=i(),c(dn.$$.fragment),yT=i(),cn=a("p"),cn.textContent=sJ,uT=i(),rn=a("p"),rn.innerHTML=iJ,JT=i(),Mn=a("table"),Mn.innerHTML=nJ,hT=i(),wT=a("hr"),jT=i(),Tn=a("a"),UT=i(),c(mn.$$.fragment),fT=i(),yn=a("p"),yn.innerHTML=aJ,bT=i(),un=a("p"),un.innerHTML=pJ,xT=i(),Jn=a("ul"),Jn.innerHTML=oJ,CT=i(),hn=a("table"),hn.innerHTML=dJ,gT=i(),IT=a("hr"),kT=i(),wn=a("a"),GT=i(),c(jn.$$.fragment),ZT=i(),Un=a("p"),Un.innerHTML=cJ,BT=i(),fn=a("table"),fn.innerHTML=rJ,QT=i(),vT=a("hr"),NT=i(),bn=a("a"),AT=i(),c(xn.$$.fragment),_T=i(),Cn=a("p"),Cn.innerHTML=MJ,$T=i(),RT=a("hr"),VT=i(),gn=a("a"),YT=i(),c(In.$$.fragment),PT=i(),kn=a("p"),kn.innerHTML=TJ,ET=i(),Gn=a("table"),Gn.innerHTML=mJ,HT=i(),WT=a("hr"),zT=i(),Bn=a("p"),this.h()},l(e){const t=jJ("svelte-u9bgzb",document.head);w=p(t,"META",{name:!0,content:!0}),t.forEach(l),Qn=n(e),Zn=p(e,"P",{}),u(Zn).forEach(l),vn=n(e),j=p(e,"A",{id:!0,class:!0}),u(j).forEach(l),Nn=n(e),r(U.$$.fragment,e),An=n(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1inm2t9"&&(f.textContent=LT),_n=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1pjech"&&(b.innerHTML=FT),$n=n(e),r(x.$$.fragment,e),Rn=n(e),C=p(e,"UL",{"data-svelte-h":!0}),o(C)!=="svelte-4mywo1"&&(C.innerHTML=DT),Vn=n(e),Yn=p(e,"HR",{}),Pn=n(e),g=p(e,"A",{id:!0,class:!0}),u(g).forEach(l),En=n(e),r(I.$$.fragment,e),Hn=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-16ix8v2"&&(k.textContent=qT),Wn=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1olpg2f"&&(G.innerHTML=OT),zn=n(e),Z=p(e,"UL",{"data-svelte-h":!0}),o(Z)!=="svelte-1wo4saj"&&(Z.innerHTML=KT),Xn=n(e),Sn=p(e,"HR",{}),Ln=n(e),B=p(e,"A",{id:!0,class:!0}),u(B).forEach(l),Fn=n(e),r(Q.$$.fragment,e),Dn=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-10jkwj"&&(v.textContent=em),qn=n(e),N=p(e,"TABLE",{"data-svelte-h":!0}),o(N)!=="svelte-13q0syp"&&(N.innerHTML=tm),On=n(e),Kn=p(e,"HR",{}),ea=n(e),A=p(e,"A",{id:!0,class:!0}),u(A).forEach(l),ta=n(e),r(_.$$.fragment,e),la=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1yhr8qe"&&($.textContent=lm),sa=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1yqombv"&&(R.innerHTML=sm),ia=n(e),na=p(e,"HR",{}),aa=n(e),V=p(e,"A",{id:!0,class:!0}),u(V).forEach(l),pa=n(e),r(Y.$$.fragment,e),oa=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-phuke9"&&(P.textContent=im),da=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1xajepz"&&(E.innerHTML=nm),ca=n(e),H=p(e,"TABLE",{"data-svelte-h":!0}),o(H)!=="svelte-1dl6le6"&&(H.innerHTML=am),ra=n(e),Ma=p(e,"HR",{}),Ta=n(e),W=p(e,"A",{id:!0,class:!0}),u(W).forEach(l),ma=n(e),r(z.$$.fragment,e),ya=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1aega0x"&&(X.innerHTML=pm),ua=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-twv4w2"&&(S.innerHTML=om),Ja=n(e),r(L.$$.fragment,e),ha=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-9l8wqs"&&(F.innerHTML=dm),wa=n(e),r(D.$$.fragment,e),ja=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-63pkoo"&&(q.innerHTML=cm),Ua=n(e),r(O.$$.fragment,e),fa=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-s10qq4"&&(K.innerHTML=rm),ba=n(e),xa=p(e,"HR",{}),Ca=n(e),ee=p(e,"A",{id:!0,class:!0}),u(ee).forEach(l),ga=n(e),r(te.$$.fragment,e),Ia=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-319swt"&&(le.textContent=Mm),ka=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1vshn55"&&(se.innerHTML=Tm),Ga=n(e),ie=p(e,"TABLE",{"data-svelte-h":!0}),o(ie)!=="svelte-mqkhxk"&&(ie.innerHTML=mm),Za=n(e),Ba=p(e,"HR",{}),Qa=n(e),ne=p(e,"A",{id:!0,class:!0}),u(ne).forEach(l),va=n(e),r(ae.$$.fragment,e),Na=n(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-199l8oj"&&(pe.innerHTML=ym),Aa=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-3ojewp"&&(oe.innerHTML=um),_a=n(e),r(de.$$.fragment,e),$a=n(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1ln7q61"&&(ce.innerHTML=Jm),Ra=n(e),r(re.$$.fragment,e),Va=n(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-s10qq4"&&(Me.innerHTML=hm),Ya=n(e),Pa=p(e,"HR",{}),Ea=n(e),Te=p(e,"A",{id:!0,class:!0}),u(Te).forEach(l),Ha=n(e),r(me.$$.fragment,e),Wa=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-qfvk6r"&&(ye.textContent=wm),za=n(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1tvkl0p"&&(ue.innerHTML=jm),Xa=n(e),Je=p(e,"TABLE",{"data-svelte-h":!0}),o(Je)!=="svelte-1p6smdx"&&(Je.innerHTML=Um),Sa=n(e),La=p(e,"HR",{}),Fa=n(e),he=p(e,"A",{id:!0,class:!0}),u(he).forEach(l),Da=n(e),r(we.$$.fragment,e),qa=n(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-14f3xkz"&&(je.innerHTML=fm),Oa=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-o2pgcr"&&(Ue.innerHTML=bm),Ka=n(e),r(fe.$$.fragment,e),ep=n(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-s10qq4"&&(be.innerHTML=xm),tp=n(e),lp=p(e,"HR",{}),sp=n(e),xe=p(e,"A",{id:!0,class:!0}),u(xe).forEach(l),ip=n(e),r(Ce.$$.fragment,e),np=n(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-v1s8i"&&(ge.textContent=Cm),ap=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1jet258"&&(Ie.innerHTML=gm),pp=n(e),ke=p(e,"TABLE",{"data-svelte-h":!0}),o(ke)!=="svelte-dmekw3"&&(ke.innerHTML=Im),op=n(e),dp=p(e,"HR",{}),cp=n(e),Ge=p(e,"A",{id:!0,class:!0}),u(Ge).forEach(l),rp=n(e),r(Ze.$$.fragment,e),Mp=n(e),Be=p(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-nzjx48"&&(Be.innerHTML=km),Tp=n(e),Qe=p(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1xict4f"&&(Qe.innerHTML=Gm),mp=n(e),r(ve.$$.fragment,e),yp=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1sz7ava"&&(Ne.innerHTML=Zm),up=n(e),r(Ae.$$.fragment,e),Jp=n(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-s10qq4"&&(_e.innerHTML=Bm),hp=n(e),wp=p(e,"HR",{}),jp=n(e),$e=p(e,"A",{id:!0,class:!0}),u($e).forEach(l),Up=n(e),r(Re.$$.fragment,e),fp=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1dgb1r"&&(Ve.textContent=Qm),bp=n(e),Ye=p(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-ht5bcu"&&(Ye.innerHTML=vm),xp=n(e),Pe=p(e,"TABLE",{"data-svelte-h":!0}),o(Pe)!=="svelte-dhvci0"&&(Pe.innerHTML=Nm),Cp=n(e),gp=p(e,"HR",{}),Ip=n(e),Ee=p(e,"A",{id:!0,class:!0}),u(Ee).forEach(l),kp=n(e),r(He.$$.fragment,e),Gp=n(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-e2spcq"&&(We.textContent=Am),Zp=n(e),ze=p(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-j4hwgn"&&(ze.innerHTML=_m),Bp=n(e),r(Xe.$$.fragment,e),Qp=n(e),Se=p(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-s10qq4"&&(Se.innerHTML=$m),vp=n(e),Np=p(e,"HR",{}),Ap=n(e),Le=p(e,"A",{id:!0,class:!0}),u(Le).forEach(l),_p=n(e),r(Fe.$$.fragment,e),$p=n(e),De=p(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-1dgb1r"&&(De.textContent=Rm),Rp=n(e),qe=p(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-k5n4xx"&&(qe.innerHTML=Vm),Vp=n(e),Oe=p(e,"UL",{"data-svelte-h":!0}),o(Oe)!=="svelte-wmzf9w"&&(Oe.innerHTML=Ym),Yp=n(e),Ke=p(e,"TABLE",{"data-svelte-h":!0}),o(Ke)!=="svelte-18cf78d"&&(Ke.innerHTML=Pm),Pp=n(e),Ep=p(e,"HR",{}),Hp=n(e),et=p(e,"A",{id:!0,class:!0}),u(et).forEach(l),Wp=n(e),r(tt.$$.fragment,e),zp=n(e),lt=p(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1axdht2"&&(lt.textContent=Em),Xp=n(e),st=p(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-1416cqx"&&(st.innerHTML=Hm),Sp=n(e),r(it.$$.fragment,e),Lp=n(e),nt=p(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-s10qq4"&&(nt.innerHTML=Wm),Fp=n(e),Dp=p(e,"HR",{}),qp=n(e),at=p(e,"A",{id:!0,class:!0}),u(at).forEach(l),Op=n(e),r(pt.$$.fragment,e),Kp=n(e),ot=p(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-3abd20"&&(ot.textContent=zm),eo=n(e),dt=p(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-1ut0vme"&&(dt.innerHTML=Xm),to=n(e),ct=p(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-dr1wsd"&&(ct.innerHTML=Sm),lo=n(e),r(rt.$$.fragment,e),so=n(e),Mt=p(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-mqh15a"&&(Mt.innerHTML=Lm),io=n(e),Tt=p(e,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-zf4dht"&&(Tt.innerHTML=Fm),no=n(e),r(mt.$$.fragment,e),ao=n(e),yt=p(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1877ohf"&&(yt.innerHTML=Dm),po=n(e),ut=p(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1ox1juk"&&(ut.innerHTML=qm),oo=n(e),r(Jt.$$.fragment,e),co=n(e),ht=p(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-s10qq4"&&(ht.innerHTML=Om),ro=n(e),Mo=p(e,"HR",{}),To=n(e),wt=p(e,"A",{id:!0,class:!0}),u(wt).forEach(l),mo=n(e),r(jt.$$.fragment,e),yo=n(e),Ut=p(e,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-1yek3op"&&(Ut.innerHTML=Km),uo=n(e),ft=p(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-11p32pq"&&(ft.innerHTML=ey),Jo=n(e),r(bt.$$.fragment,e),ho=n(e),xt=p(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-1uqom1e"&&(xt.innerHTML=ty),wo=n(e),r(Ct.$$.fragment,e),jo=n(e),gt=p(e,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1a7k67n"&&(gt.innerHTML=ly),Uo=n(e),r(It.$$.fragment,e),fo=n(e),kt=p(e,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-s10qq4"&&(kt.innerHTML=sy),bo=n(e),xo=p(e,"HR",{}),Co=n(e),Gt=p(e,"A",{id:!0,class:!0}),u(Gt).forEach(l),go=n(e),r(Zt.$$.fragment,e),Io=n(e),Bt=p(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-6m3xhk"&&(Bt.textContent=iy),ko=n(e),Qt=p(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-1f5btis"&&(Qt.innerHTML=ny),Go=n(e),vt=p(e,"TABLE",{"data-svelte-h":!0}),o(vt)!=="svelte-5kvkn6"&&(vt.innerHTML=ay),Zo=n(e),Bo=p(e,"HR",{}),Qo=n(e),Nt=p(e,"A",{id:!0,class:!0}),u(Nt).forEach(l),vo=n(e),r(At.$$.fragment,e),No=n(e),_t=p(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-104v5zf"&&(_t.innerHTML=py),Ao=n(e),$t=p(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-17n9q32"&&($t.innerHTML=oy),_o=n(e),r(Rt.$$.fragment,e),$o=n(e),Vt=p(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-v99qry"&&(Vt.innerHTML=dy),Ro=n(e),r(Yt.$$.fragment,e),Vo=n(e),Pt=p(e,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-s10qq4"&&(Pt.innerHTML=cy),Yo=n(e),Et=p(e,"UL",{"data-svelte-h":!0}),o(Et)!=="svelte-svwcak"&&(Et.innerHTML=ry),Po=n(e),Eo=p(e,"HR",{}),Ho=n(e),Ht=p(e,"A",{id:!0,class:!0}),u(Ht).forEach(l),Wo=n(e),r(Wt.$$.fragment,e),zo=n(e),zt=p(e,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-1n1xlcl"&&(zt.textContent=My),Xo=n(e),Xt=p(e,"TABLE",{"data-svelte-h":!0}),o(Xt)!=="svelte-1h8f"&&(Xt.innerHTML=Ty),So=n(e),Lo=p(e,"HR",{}),Fo=n(e),St=p(e,"A",{id:!0,class:!0}),u(St).forEach(l),Do=n(e),r(Lt.$$.fragment,e),qo=n(e),Ft=p(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-c8gx4u"&&(Ft.innerHTML=my),Oo=n(e),Dt=p(e,"TABLE",{"data-svelte-h":!0}),o(Dt)!=="svelte-y9oo3q"&&(Dt.innerHTML=yy),Ko=n(e),ed=p(e,"HR",{}),td=n(e),qt=p(e,"A",{id:!0,class:!0}),u(qt).forEach(l),ld=n(e),r(Ot.$$.fragment,e),sd=n(e),Kt=p(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-tzucv0"&&(Kt.textContent=uy),id=n(e),el=p(e,"P",{"data-svelte-h":!0}),o(el)!=="svelte-zrdgvs"&&(el.innerHTML=Jy),nd=n(e),r(tl.$$.fragment,e),ad=n(e),ll=p(e,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-et9i9m"&&(ll.innerHTML=hy),pd=n(e),r(sl.$$.fragment,e),od=n(e),il=p(e,"P",{"data-svelte-h":!0}),o(il)!=="svelte-162t9ct"&&(il.innerHTML=wy),dd=n(e),r(nl.$$.fragment,e),cd=n(e),al=p(e,"P",{"data-svelte-h":!0}),o(al)!=="svelte-s10qq4"&&(al.innerHTML=jy),rd=n(e),Md=p(e,"HR",{}),Td=n(e),pl=p(e,"A",{id:!0,class:!0}),u(pl).forEach(l),md=n(e),r(ol.$$.fragment,e),yd=n(e),dl=p(e,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-11eoigb"&&(dl.textContent=Uy),ud=n(e),cl=p(e,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-un4fzt"&&(cl.innerHTML=fy),Jd=n(e),rl=p(e,"TABLE",{"data-svelte-h":!0}),o(rl)!=="svelte-1qj38gf"&&(rl.innerHTML=by),hd=n(e),wd=p(e,"HR",{}),jd=n(e),Ml=p(e,"A",{id:!0,class:!0}),u(Ml).forEach(l),Ud=n(e),r(Tl.$$.fragment,e),fd=n(e),ml=p(e,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-9xhkxa"&&(ml.innerHTML=xy),bd=n(e),yl=p(e,"P",{"data-svelte-h":!0}),o(yl)!=="svelte-gobmso"&&(yl.innerHTML=Cy),xd=n(e),r(ul.$$.fragment,e),Cd=n(e),Jl=p(e,"P",{"data-svelte-h":!0}),o(Jl)!=="svelte-s10qq4"&&(Jl.innerHTML=gy),gd=n(e),hl=p(e,"UL",{"data-svelte-h":!0}),o(hl)!=="svelte-fjr04l"&&(hl.innerHTML=Iy),Id=n(e),kd=p(e,"HR",{}),Gd=n(e),wl=p(e,"A",{id:!0,class:!0}),u(wl).forEach(l),Zd=n(e),r(jl.$$.fragment,e),Bd=n(e),Ul=p(e,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-1enract"&&(Ul.textContent=ky),Qd=n(e),fl=p(e,"TABLE",{"data-svelte-h":!0}),o(fl)!=="svelte-dgeggs"&&(fl.innerHTML=Gy),vd=n(e),Nd=p(e,"HR",{}),Ad=n(e),bl=p(e,"A",{id:!0,class:!0}),u(bl).forEach(l),_d=n(e),r(xl.$$.fragment,e),$d=n(e),Cl=p(e,"P",{"data-svelte-h":!0}),o(Cl)!=="svelte-19qhuwa"&&(Cl.textContent=Zy),Rd=n(e),gl=p(e,"P",{"data-svelte-h":!0}),o(gl)!=="svelte-1gq3dbn"&&(gl.innerHTML=By),Vd=n(e),Il=p(e,"TABLE",{"data-svelte-h":!0}),o(Il)!=="svelte-17m2nm1"&&(Il.innerHTML=Qy),Yd=n(e),Pd=p(e,"HR",{}),Ed=n(e),kl=p(e,"A",{id:!0,class:!0}),u(kl).forEach(l),Hd=n(e),r(Gl.$$.fragment,e),Wd=n(e),Zl=p(e,"P",{"data-svelte-h":!0}),o(Zl)!=="svelte-vm8asa"&&(Zl.textContent=vy),zd=n(e),Bl=p(e,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-p9nqmy"&&(Bl.innerHTML=Ny),Xd=n(e),r(Ql.$$.fragment,e),Sd=n(e),vl=p(e,"P",{"data-svelte-h":!0}),o(vl)!=="svelte-1xb4yln"&&(vl.innerHTML=Ay),Ld=n(e),r(Nl.$$.fragment,e),Fd=n(e),Al=p(e,"P",{"data-svelte-h":!0}),o(Al)!=="svelte-aly754"&&(Al.innerHTML=_y),Dd=n(e),r(_l.$$.fragment,e),qd=n(e),$l=p(e,"P",{"data-svelte-h":!0}),o($l)!=="svelte-127z1r2"&&($l.innerHTML=$y),Od=n(e),r(Rl.$$.fragment,e),Kd=n(e),Vl=p(e,"P",{"data-svelte-h":!0}),o(Vl)!=="svelte-5ad2vc"&&(Vl.innerHTML=Ry),ec=n(e),r(Yl.$$.fragment,e),tc=n(e),Pl=p(e,"P",{"data-svelte-h":!0}),o(Pl)!=="svelte-1ybp4y9"&&(Pl.innerHTML=Vy),lc=n(e),r(El.$$.fragment,e),sc=n(e),Hl=p(e,"P",{"data-svelte-h":!0}),o(Hl)!=="svelte-s10qq4"&&(Hl.innerHTML=Yy),ic=n(e),Wl=p(e,"UL",{"data-svelte-h":!0}),o(Wl)!=="svelte-32csn1"&&(Wl.innerHTML=Py),nc=n(e),ac=p(e,"HR",{}),pc=n(e),zl=p(e,"A",{id:!0,class:!0}),u(zl).forEach(l),oc=n(e),r(Xl.$$.fragment,e),dc=n(e),Sl=p(e,"P",{"data-svelte-h":!0}),o(Sl)!=="svelte-1kkefov"&&(Sl.textContent=Ey),cc=n(e),Ll=p(e,"TABLE",{"data-svelte-h":!0}),o(Ll)!=="svelte-1a94q5m"&&(Ll.innerHTML=Hy),rc=n(e),Mc=p(e,"HR",{}),Tc=n(e),Fl=p(e,"A",{id:!0,class:!0}),u(Fl).forEach(l),mc=n(e),r(Dl.$$.fragment,e),yc=n(e),ql=p(e,"P",{"data-svelte-h":!0}),o(ql)!=="svelte-d8vj38"&&(ql.textContent=Wy),uc=n(e),Ol=p(e,"P",{"data-svelte-h":!0}),o(Ol)!=="svelte-hgdjqs"&&(Ol.innerHTML=zy),Jc=n(e),Kl=p(e,"TABLE",{"data-svelte-h":!0}),o(Kl)!=="svelte-1usuiaq"&&(Kl.innerHTML=Xy),hc=n(e),wc=p(e,"HR",{}),jc=n(e),es=p(e,"A",{id:!0,class:!0}),u(es).forEach(l),Uc=n(e),r(ts.$$.fragment,e),fc=n(e),ls=p(e,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-yuzbfo"&&(ls.innerHTML=Sy),bc=n(e),ss=p(e,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-gwolyd"&&(ss.innerHTML=Ly),xc=n(e),r(is.$$.fragment,e),Cc=n(e),ns=p(e,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-vvjehq"&&(ns.innerHTML=Fy),gc=n(e),r(as.$$.fragment,e),Ic=n(e),ps=p(e,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-s10qq4"&&(ps.innerHTML=Dy),kc=n(e),os=p(e,"UL",{"data-svelte-h":!0}),o(os)!=="svelte-3k2o01"&&(os.innerHTML=qy),Gc=n(e),Zc=p(e,"HR",{}),Bc=n(e),ds=p(e,"A",{id:!0,class:!0}),u(ds).forEach(l),Qc=n(e),r(cs.$$.fragment,e),vc=n(e),rs=p(e,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-10qze5e"&&(rs.textContent=Oy),Nc=n(e),Ms=p(e,"TABLE",{"data-svelte-h":!0}),o(Ms)!=="svelte-1a94q5m"&&(Ms.innerHTML=Ky),Ac=n(e),_c=p(e,"HR",{}),$c=n(e),Ts=p(e,"A",{id:!0,class:!0}),u(Ts).forEach(l),Rc=n(e),r(ms.$$.fragment,e),Vc=n(e),ys=p(e,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-ypfmt8"&&(ys.textContent=eu),Yc=n(e),us=p(e,"P",{"data-svelte-h":!0}),o(us)!=="svelte-sv0g8q"&&(us.innerHTML=tu),Pc=n(e),Js=p(e,"TABLE",{"data-svelte-h":!0}),o(Js)!=="svelte-1d2oy3p"&&(Js.innerHTML=lu),Ec=n(e),Hc=p(e,"HR",{}),Wc=n(e),hs=p(e,"A",{id:!0,class:!0}),u(hs).forEach(l),zc=n(e),r(ws.$$.fragment,e),Xc=n(e),js=p(e,"P",{"data-svelte-h":!0}),o(js)!=="svelte-w5osnc"&&(js.innerHTML=su),Sc=n(e),Us=p(e,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-1h4310j"&&(Us.innerHTML=iu),Lc=n(e),r(fs.$$.fragment,e),Fc=n(e),bs=p(e,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-xv6hak"&&(bs.innerHTML=nu),Dc=n(e),r(xs.$$.fragment,e),qc=n(e),Cs=p(e,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-1ids6l"&&(Cs.innerHTML=au),Oc=n(e),r(gs.$$.fragment,e),Kc=n(e),Is=p(e,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-s10qq4"&&(Is.innerHTML=pu),er=n(e),ks=p(e,"UL",{"data-svelte-h":!0}),o(ks)!=="svelte-z3581k"&&(ks.innerHTML=ou),tr=n(e),lr=p(e,"HR",{}),sr=n(e),Gs=p(e,"A",{id:!0,class:!0}),u(Gs).forEach(l),ir=n(e),r(Zs.$$.fragment,e),nr=n(e),Bs=p(e,"P",{"data-svelte-h":!0}),o(Bs)!=="svelte-71b02w"&&(Bs.textContent=du),ar=n(e),Qs=p(e,"TABLE",{"data-svelte-h":!0}),o(Qs)!=="svelte-dgeggs"&&(Qs.innerHTML=cu),pr=n(e),or=p(e,"HR",{}),dr=n(e),vs=p(e,"A",{id:!0,class:!0}),u(vs).forEach(l),cr=n(e),r(Ns.$$.fragment,e),rr=n(e),As=p(e,"P",{"data-svelte-h":!0}),o(As)!=="svelte-1rpepg8"&&(As.textContent=ru),Mr=n(e),_s=p(e,"P",{"data-svelte-h":!0}),o(_s)!=="svelte-zgzruq"&&(_s.innerHTML=Mu),Tr=n(e),$s=p(e,"TABLE",{"data-svelte-h":!0}),o($s)!=="svelte-17j2fmt"&&($s.innerHTML=Tu),mr=n(e),yr=p(e,"HR",{}),ur=n(e),Rs=p(e,"A",{id:!0,class:!0}),u(Rs).forEach(l),Jr=n(e),r(Vs.$$.fragment,e),hr=n(e),Ys=p(e,"P",{"data-svelte-h":!0}),o(Ys)!=="svelte-1rwi35s"&&(Ys.innerHTML=mu),wr=n(e),Ps=p(e,"P",{"data-svelte-h":!0}),o(Ps)!=="svelte-1tpbwb6"&&(Ps.innerHTML=yu),jr=n(e),r(Es.$$.fragment,e),Ur=n(e),Hs=p(e,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-s10qq4"&&(Hs.innerHTML=uu),fr=n(e),Ws=p(e,"UL",{"data-svelte-h":!0}),o(Ws)!=="svelte-1n3ebqn"&&(Ws.innerHTML=Ju),br=n(e),xr=p(e,"HR",{}),Cr=n(e),zs=p(e,"A",{id:!0,class:!0}),u(zs).forEach(l),gr=n(e),r(Xs.$$.fragment,e),Ir=n(e),Ss=p(e,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-1ctgtyq"&&(Ss.textContent=hu),kr=n(e),Ls=p(e,"TABLE",{"data-svelte-h":!0}),o(Ls)!=="svelte-dgeggs"&&(Ls.innerHTML=wu),Gr=n(e),Zr=p(e,"HR",{}),Br=n(e),Fs=p(e,"A",{id:!0,class:!0}),u(Fs).forEach(l),Qr=n(e),r(Ds.$$.fragment,e),vr=n(e),qs=p(e,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-1v51wpq"&&(qs.textContent=ju),Nr=n(e),Os=p(e,"P",{"data-svelte-h":!0}),o(Os)!=="svelte-7em0sw"&&(Os.innerHTML=Uu),Ar=n(e),Ks=p(e,"TABLE",{"data-svelte-h":!0}),o(Ks)!=="svelte-usc03t"&&(Ks.innerHTML=fu),_r=n(e),$r=p(e,"HR",{}),Rr=n(e),ei=p(e,"A",{id:!0,class:!0}),u(ei).forEach(l),Vr=n(e),r(ti.$$.fragment,e),Yr=n(e),li=p(e,"P",{"data-svelte-h":!0}),o(li)!=="svelte-20dgme"&&(li.innerHTML=bu),Pr=n(e),si=p(e,"P",{"data-svelte-h":!0}),o(si)!=="svelte-eob2i5"&&(si.innerHTML=xu),Er=n(e),r(ii.$$.fragment,e),Hr=n(e),ni=p(e,"P",{"data-svelte-h":!0}),o(ni)!=="svelte-s10qq4"&&(ni.innerHTML=Cu),Wr=n(e),ai=p(e,"UL",{"data-svelte-h":!0}),o(ai)!=="svelte-1psrxkl"&&(ai.innerHTML=gu),zr=n(e),Xr=p(e,"HR",{}),Sr=n(e),pi=p(e,"A",{id:!0,class:!0}),u(pi).forEach(l),Lr=n(e),r(oi.$$.fragment,e),Fr=n(e),di=p(e,"P",{"data-svelte-h":!0}),o(di)!=="svelte-3wys82"&&(di.textContent=Iu),Dr=n(e),ci=p(e,"TABLE",{"data-svelte-h":!0}),o(ci)!=="svelte-1a94q5m"&&(ci.innerHTML=ku),qr=n(e),Or=p(e,"HR",{}),Kr=n(e),ri=p(e,"A",{id:!0,class:!0}),u(ri).forEach(l),eM=n(e),r(Mi.$$.fragment,e),tM=n(e),Ti=p(e,"P",{"data-svelte-h":!0}),o(Ti)!=="svelte-g4x6jx"&&(Ti.textContent=Gu),lM=n(e),mi=p(e,"P",{"data-svelte-h":!0}),o(mi)!=="svelte-zhb55f"&&(mi.innerHTML=Zu),sM=n(e),yi=p(e,"TABLE",{"data-svelte-h":!0}),o(yi)!=="svelte-tncnks"&&(yi.innerHTML=Bu),iM=n(e),nM=p(e,"HR",{}),aM=n(e),ui=p(e,"A",{id:!0,class:!0}),u(ui).forEach(l),pM=n(e),r(Ji.$$.fragment,e),oM=n(e),hi=p(e,"P",{"data-svelte-h":!0}),o(hi)!=="svelte-11wm84h"&&(hi.innerHTML=Qu),dM=n(e),wi=p(e,"P",{"data-svelte-h":!0}),o(wi)!=="svelte-yzldbw"&&(wi.innerHTML=vu),cM=n(e),r(ji.$$.fragment,e),rM=n(e),Ui=p(e,"P",{"data-svelte-h":!0}),o(Ui)!=="svelte-s10qq4"&&(Ui.innerHTML=Nu),MM=n(e),fi=p(e,"UL",{"data-svelte-h":!0}),o(fi)!=="svelte-1kysuxh"&&(fi.innerHTML=Au),TM=n(e),mM=p(e,"HR",{}),yM=n(e),bi=p(e,"A",{id:!0,class:!0}),u(bi).forEach(l),uM=n(e),r(xi.$$.fragment,e),JM=n(e),Ci=p(e,"P",{"data-svelte-h":!0}),o(Ci)!=="svelte-1la8w69"&&(Ci.textContent=_u),hM=n(e),gi=p(e,"TABLE",{"data-svelte-h":!0}),o(gi)!=="svelte-dgeggs"&&(gi.innerHTML=$u),wM=n(e),jM=p(e,"HR",{}),UM=n(e),Ii=p(e,"A",{id:!0,class:!0}),u(Ii).forEach(l),fM=n(e),r(ki.$$.fragment,e),bM=n(e),Gi=p(e,"P",{"data-svelte-h":!0}),o(Gi)!=="svelte-1ws18e1"&&(Gi.textContent=Ru),xM=n(e),Zi=p(e,"P",{"data-svelte-h":!0}),o(Zi)!=="svelte-i9mudt"&&(Zi.innerHTML=Vu),CM=n(e),Bi=p(e,"TABLE",{"data-svelte-h":!0}),o(Bi)!=="svelte-th688q"&&(Bi.innerHTML=Yu),gM=n(e),IM=p(e,"HR",{}),kM=n(e),Qi=p(e,"A",{id:!0,class:!0}),u(Qi).forEach(l),GM=n(e),r(vi.$$.fragment,e),ZM=n(e),Ni=p(e,"P",{"data-svelte-h":!0}),o(Ni)!=="svelte-iv1c6p"&&(Ni.innerHTML=Pu),BM=n(e),Ai=p(e,"P",{"data-svelte-h":!0}),o(Ai)!=="svelte-1mtx2cy"&&(Ai.innerHTML=Eu),QM=n(e),r(_i.$$.fragment,e),vM=n(e),$i=p(e,"P",{"data-svelte-h":!0}),o($i)!=="svelte-s10qq4"&&($i.innerHTML=Hu),NM=n(e),Ri=p(e,"UL",{"data-svelte-h":!0}),o(Ri)!=="svelte-1x43yje"&&(Ri.innerHTML=Wu),AM=n(e),_M=p(e,"HR",{}),$M=n(e),Vi=p(e,"A",{id:!0,class:!0}),u(Vi).forEach(l),RM=n(e),r(Yi.$$.fragment,e),VM=n(e),Pi=p(e,"P",{"data-svelte-h":!0}),o(Pi)!=="svelte-at8fug"&&(Pi.textContent=zu),YM=n(e),Ei=p(e,"TABLE",{"data-svelte-h":!0}),o(Ei)!=="svelte-1a94q5m"&&(Ei.innerHTML=Xu),PM=n(e),EM=p(e,"HR",{}),HM=n(e),Hi=p(e,"A",{id:!0,class:!0}),u(Hi).forEach(l),WM=n(e),r(Wi.$$.fragment,e),zM=n(e),zi=p(e,"P",{"data-svelte-h":!0}),o(zi)!=="svelte-bu7lod"&&(zi.textContent=Su),XM=n(e),Xi=p(e,"P",{"data-svelte-h":!0}),o(Xi)!=="svelte-1or1fiw"&&(Xi.innerHTML=Lu),SM=n(e),Si=p(e,"TABLE",{"data-svelte-h":!0}),o(Si)!=="svelte-55abd5"&&(Si.innerHTML=Fu),LM=n(e),FM=p(e,"HR",{}),DM=n(e),Li=p(e,"A",{id:!0,class:!0}),u(Li).forEach(l),qM=n(e),r(Fi.$$.fragment,e),OM=n(e),Di=p(e,"P",{"data-svelte-h":!0}),o(Di)!=="svelte-1nzvfes"&&(Di.innerHTML=Du),KM=n(e),qi=p(e,"P",{"data-svelte-h":!0}),o(qi)!=="svelte-1qq0cp9"&&(qi.innerHTML=qu),eT=n(e),r(Oi.$$.fragment,e),tT=n(e),Ki=p(e,"P",{"data-svelte-h":!0}),o(Ki)!=="svelte-1mslt41"&&(Ki.innerHTML=Ou),lT=n(e),r(en.$$.fragment,e),sT=n(e),tn=p(e,"P",{"data-svelte-h":!0}),o(tn)!=="svelte-s10qq4"&&(tn.innerHTML=Ku),iT=n(e),ln=p(e,"UL",{"data-svelte-h":!0}),o(ln)!=="svelte-1p37gsh"&&(ln.innerHTML=eJ),nT=n(e),aT=p(e,"HR",{}),pT=n(e),sn=p(e,"A",{id:!0,class:!0}),u(sn).forEach(l),oT=n(e),r(nn.$$.fragment,e),dT=n(e),an=p(e,"P",{"data-svelte-h":!0}),o(an)!=="svelte-ipwl63"&&(an.textContent=tJ),cT=n(e),pn=p(e,"TABLE",{"data-svelte-h":!0}),o(pn)!=="svelte-11vehfm"&&(pn.innerHTML=lJ),rT=n(e),MT=p(e,"HR",{}),TT=n(e),on=p(e,"A",{id:!0,class:!0}),u(on).forEach(l),mT=n(e),r(dn.$$.fragment,e),yT=n(e),cn=p(e,"P",{"data-svelte-h":!0}),o(cn)!=="svelte-1a4c4hr"&&(cn.textContent=sJ),uT=n(e),rn=p(e,"P",{"data-svelte-h":!0}),o(rn)!=="svelte-70tp0b"&&(rn.innerHTML=iJ),JT=n(e),Mn=p(e,"TABLE",{"data-svelte-h":!0}),o(Mn)!=="svelte-1hspmv9"&&(Mn.innerHTML=nJ),hT=n(e),wT=p(e,"HR",{}),jT=n(e),Tn=p(e,"A",{id:!0,class:!0}),u(Tn).forEach(l),UT=n(e),r(mn.$$.fragment,e),fT=n(e),yn=p(e,"P",{"data-svelte-h":!0}),o(yn)!=="svelte-mcsd8f"&&(yn.innerHTML=aJ),bT=n(e),un=p(e,"P",{"data-svelte-h":!0}),o(un)!=="svelte-lb0vbj"&&(un.innerHTML=pJ),xT=n(e),Jn=p(e,"UL",{"data-svelte-h":!0}),o(Jn)!=="svelte-wk6owh"&&(Jn.innerHTML=oJ),CT=n(e),hn=p(e,"TABLE",{"data-svelte-h":!0}),o(hn)!=="svelte-1hm9kaq"&&(hn.innerHTML=dJ),gT=n(e),IT=p(e,"HR",{}),kT=n(e),wn=p(e,"A",{id:!0,class:!0}),u(wn).forEach(l),GT=n(e),r(jn.$$.fragment,e),ZT=n(e),Un=p(e,"P",{"data-svelte-h":!0}),o(Un)!=="svelte-ptv3i7"&&(Un.innerHTML=cJ),BT=n(e),fn=p(e,"TABLE",{"data-svelte-h":!0}),o(fn)!=="svelte-2eqjop"&&(fn.innerHTML=rJ),QT=n(e),vT=p(e,"HR",{}),NT=n(e),bn=p(e,"A",{id:!0,class:!0}),u(bn).forEach(l),AT=n(e),r(xn.$$.fragment,e),_T=n(e),Cn=p(e,"P",{"data-svelte-h":!0}),o(Cn)!=="svelte-1axcw5l"&&(Cn.innerHTML=MJ),$T=n(e),RT=p(e,"HR",{}),VT=n(e),gn=p(e,"A",{id:!0,class:!0}),u(gn).forEach(l),YT=n(e),r(In.$$.fragment,e),PT=n(e),kn=p(e,"P",{"data-svelte-h":!0}),o(kn)!=="svelte-1axcw5l"&&(kn.innerHTML=TJ),ET=n(e),Gn=p(e,"TABLE",{"data-svelte-h":!0}),o(Gn)!=="svelte-flnl7b"&&(Gn.innerHTML=mJ),HT=n(e),WT=p(e,"HR",{}),zT=n(e),Bn=p(e,"P",{}),u(Bn).forEach(l),this.h()},h(){d(w,"name","hf:doc:metadata"),d(w,"content",bJ),d(j,"id","module_pipelines"),d(j,"class","group"),d(g,"id","module_pipelines.Pipeline"),d(g,"class","group"),d(B,"id","new_module_pipelines.Pipeline_new"),d(B,"class","group"),d(A,"id","module_pipelines.Pipeline+dispose"),d(A,"class","group"),d(V,"id","module_pipelines.Pipeline+_call"),d(V,"class","group"),d(W,"id","module_pipelines.TextClassificationPipeline"),d(W,"class","group"),d(ee,"id","module_pipelines.TextClassificationPipeline+_call"),d(ee,"class","group"),d(ne,"id","module_pipelines.TokenClassificationPipeline"),d(ne,"class","group"),d(Te,"id","module_pipelines.TokenClassificationPipeline+_call"),d(Te,"class","group"),d(he,"id","module_pipelines.QuestionAnsweringPipeline"),d(he,"class","group"),d(xe,"id","module_pipelines.QuestionAnsweringPipeline+_call"),d(xe,"class","group"),d(Ge,"id","module_pipelines.FillMaskPipeline"),d(Ge,"class","group"),d($e,"id","module_pipelines.FillMaskPipeline+_call"),d($e,"class","group"),d(Ee,"id","module_pipelines.Text2TextGenerationPipeline"),d(Ee,"class","group"),d(Le,"id","module_pipelines.Text2TextGenerationPipeline+_call"),d(Le,"class","group"),d(et,"id","module_pipelines.SummarizationPipeline"),d(et,"class","group"),d(at,"id","module_pipelines.TranslationPipeline"),d(at,"class","group"),d(wt,"id","module_pipelines.TextGenerationPipeline"),d(wt,"class","group"),d(Gt,"id","module_pipelines.TextGenerationPipeline+_call"),d(Gt,"class","group"),d(Nt,"id","module_pipelines.ZeroShotClassificationPipeline"),d(Nt,"class","group"),d(Ht,"id","new_module_pipelines.ZeroShotClassificationPipeline_new"),d(Ht,"class","group"),d(St,"id","module_pipelines.ZeroShotClassificationPipeline+_call"),d(St,"class","group"),d(qt,"id","module_pipelines.FeatureExtractionPipeline"),d(qt,"class","group"),d(pl,"id","module_pipelines.FeatureExtractionPipeline+_call"),d(pl,"class","group"),d(Ml,"id","module_pipelines.AudioClassificationPipeline"),d(Ml,"class","group"),d(wl,"id","new_module_pipelines.AudioClassificationPipeline_new"),d(wl,"class","group"),d(bl,"id","module_pipelines.AudioClassificationPipeline+_call"),d(bl,"class","group"),d(kl,"id","module_pipelines.AutomaticSpeechRecognitionPipeline"),d(kl,"class","group"),d(zl,"id","new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"),d(zl,"class","group"),d(Fl,"id","module_pipelines.AutomaticSpeechRecognitionPipeline+_call"),d(Fl,"class","group"),d(es,"id","module_pipelines.ImageToTextPipeline"),d(es,"class","group"),d(ds,"id","new_module_pipelines.ImageToTextPipeline_new"),d(ds,"class","group"),d(Ts,"id","module_pipelines.ImageToTextPipeline+_call"),d(Ts,"class","group"),d(hs,"id","module_pipelines.ImageClassificationPipeline"),d(hs,"class","group"),d(Gs,"id","new_module_pipelines.ImageClassificationPipeline_new"),d(Gs,"class","group"),d(vs,"id","module_pipelines.ImageClassificationPipeline+_call"),d(vs,"class","group"),d(Rs,"id","module_pipelines.ImageSegmentationPipeline"),d(Rs,"class","group"),d(zs,"id","new_module_pipelines.ImageSegmentationPipeline_new"),d(zs,"class","group"),d(Fs,"id","module_pipelines.ImageSegmentationPipeline+_call"),d(Fs,"class","group"),d(ei,"id","module_pipelines.ZeroShotImageClassificationPipeline"),d(ei,"class","group"),d(pi,"id","new_module_pipelines.ZeroShotImageClassificationPipeline_new"),d(pi,"class","group"),d(ri,"id","module_pipelines.ZeroShotImageClassificationPipeline+_call"),d(ri,"class","group"),d(ui,"id","module_pipelines.ObjectDetectionPipeline"),d(ui,"class","group"),d(bi,"id","new_module_pipelines.ObjectDetectionPipeline_new"),d(bi,"class","group"),d(Ii,"id","module_pipelines.ObjectDetectionPipeline+_call"),d(Ii,"class","group"),d(Qi,"id","module_pipelines.DocumentQuestionAnsweringPipeline"),d(Qi,"class","group"),d(Vi,"id","new_module_pipelines.DocumentQuestionAnsweringPipeline_new"),d(Vi,"class","group"),d(Hi,"id","module_pipelines.DocumentQuestionAnsweringPipeline+_call"),d(Hi,"class","group"),d(Li,"id","module_pipelines.TextToAudioPipeline"),d(Li,"class","group"),d(sn,"id","new_module_pipelines.TextToAudioPipeline_new"),d(sn,"class","group"),d(on,"id","module_pipelines.TextToAudioPipeline+_call"),d(on,"class","group"),d(Tn,"id","module_pipelines.pipeline"),d(Tn,"class","group"),d(wn,"id","module_pipelines..QuestionAnsweringResult"),d(wn,"class","group"),d(bn,"id","module_pipelines..QuestionAnsweringReturnType"),d(bn,"class","group"),d(gn,"id","module_pipelines..ChunkCallback"),d(gn,"class","group")},m(e,t){UJ(document.head,w),s(e,Qn,t),s(e,Zn,t),s(e,vn,t),s(e,j,t),s(e,Nn,t),M(U,e,t),s(e,An,t),s(e,f,t),s(e,_n,t),s(e,b,t),s(e,$n,t),M(x,e,t),s(e,Rn,t),s(e,C,t),s(e,Vn,t),s(e,Yn,t),s(e,Pn,t),s(e,g,t),s(e,En,t),M(I,e,t),s(e,Hn,t),s(e,k,t),s(e,Wn,t),s(e,G,t),s(e,zn,t),s(e,Z,t),s(e,Xn,t),s(e,Sn,t),s(e,Ln,t),s(e,B,t),s(e,Fn,t),M(Q,e,t),s(e,Dn,t),s(e,v,t),s(e,qn,t),s(e,N,t),s(e,On,t),s(e,Kn,t),s(e,ea,t),s(e,A,t),s(e,ta,t),M(_,e,t),s(e,la,t),s(e,$,t),s(e,sa,t),s(e,R,t),s(e,ia,t),s(e,na,t),s(e,aa,t),s(e,V,t),s(e,pa,t),M(Y,e,t),s(e,oa,t),s(e,P,t),s(e,da,t),s(e,E,t),s(e,ca,t),s(e,H,t),s(e,ra,t),s(e,Ma,t),s(e,Ta,t),s(e,W,t),s(e,ma,t),M(z,e,t),s(e,ya,t),s(e,X,t),s(e,ua,t),s(e,S,t),s(e,Ja,t),M(L,e,t),s(e,ha,t),s(e,F,t),s(e,wa,t),M(D,e,t),s(e,ja,t),s(e,q,t),s(e,Ua,t),M(O,e,t),s(e,fa,t),s(e,K,t),s(e,ba,t),s(e,xa,t),s(e,Ca,t),s(e,ee,t),s(e,ga,t),M(te,e,t),s(e,Ia,t),s(e,le,t),s(e,ka,t),s(e,se,t),s(e,Ga,t),s(e,ie,t),s(e,Za,t),s(e,Ba,t),s(e,Qa,t),s(e,ne,t),s(e,va,t),M(ae,e,t),s(e,Na,t),s(e,pe,t),s(e,Aa,t),s(e,oe,t),s(e,_a,t),M(de,e,t),s(e,$a,t),s(e,ce,t),s(e,Ra,t),M(re,e,t),s(e,Va,t),s(e,Me,t),s(e,Ya,t),s(e,Pa,t),s(e,Ea,t),s(e,Te,t),s(e,Ha,t),M(me,e,t),s(e,Wa,t),s(e,ye,t),s(e,za,t),s(e,ue,t),s(e,Xa,t),s(e,Je,t),s(e,Sa,t),s(e,La,t),s(e,Fa,t),s(e,he,t),s(e,Da,t),M(we,e,t),s(e,qa,t),s(e,je,t),s(e,Oa,t),s(e,Ue,t),s(e,Ka,t),M(fe,e,t),s(e,ep,t),s(e,be,t),s(e,tp,t),s(e,lp,t),s(e,sp,t),s(e,xe,t),s(e,ip,t),M(Ce,e,t),s(e,np,t),s(e,ge,t),s(e,ap,t),s(e,Ie,t),s(e,pp,t),s(e,ke,t),s(e,op,t),s(e,dp,t),s(e,cp,t),s(e,Ge,t),s(e,rp,t),M(Ze,e,t),s(e,Mp,t),s(e,Be,t),s(e,Tp,t),s(e,Qe,t),s(e,mp,t),M(ve,e,t),s(e,yp,t),s(e,Ne,t),s(e,up,t),M(Ae,e,t),s(e,Jp,t),s(e,_e,t),s(e,hp,t),s(e,wp,t),s(e,jp,t),s(e,$e,t),s(e,Up,t),M(Re,e,t),s(e,fp,t),s(e,Ve,t),s(e,bp,t),s(e,Ye,t),s(e,xp,t),s(e,Pe,t),s(e,Cp,t),s(e,gp,t),s(e,Ip,t),s(e,Ee,t),s(e,kp,t),M(He,e,t),s(e,Gp,t),s(e,We,t),s(e,Zp,t),s(e,ze,t),s(e,Bp,t),M(Xe,e,t),s(e,Qp,t),s(e,Se,t),s(e,vp,t),s(e,Np,t),s(e,Ap,t),s(e,Le,t),s(e,_p,t),M(Fe,e,t),s(e,$p,t),s(e,De,t),s(e,Rp,t),s(e,qe,t),s(e,Vp,t),s(e,Oe,t),s(e,Yp,t),s(e,Ke,t),s(e,Pp,t),s(e,Ep,t),s(e,Hp,t),s(e,et,t),s(e,Wp,t),M(tt,e,t),s(e,zp,t),s(e,lt,t),s(e,Xp,t),s(e,st,t),s(e,Sp,t),M(it,e,t),s(e,Lp,t),s(e,nt,t),s(e,Fp,t),s(e,Dp,t),s(e,qp,t),s(e,at,t),s(e,Op,t),M(pt,e,t),s(e,Kp,t),s(e,ot,t),s(e,eo,t),s(e,dt,t),s(e,to,t),s(e,ct,t),s(e,lo,t),M(rt,e,t),s(e,so,t),s(e,Mt,t),s(e,io,t),s(e,Tt,t),s(e,no,t),M(mt,e,t),s(e,ao,t),s(e,yt,t),s(e,po,t),s(e,ut,t),s(e,oo,t),M(Jt,e,t),s(e,co,t),s(e,ht,t),s(e,ro,t),s(e,Mo,t),s(e,To,t),s(e,wt,t),s(e,mo,t),M(jt,e,t),s(e,yo,t),s(e,Ut,t),s(e,uo,t),s(e,ft,t),s(e,Jo,t),M(bt,e,t),s(e,ho,t),s(e,xt,t),s(e,wo,t),M(Ct,e,t),s(e,jo,t),s(e,gt,t),s(e,Uo,t),M(It,e,t),s(e,fo,t),s(e,kt,t),s(e,bo,t),s(e,xo,t),s(e,Co,t),s(e,Gt,t),s(e,go,t),M(Zt,e,t),s(e,Io,t),s(e,Bt,t),s(e,ko,t),s(e,Qt,t),s(e,Go,t),s(e,vt,t),s(e,Zo,t),s(e,Bo,t),s(e,Qo,t),s(e,Nt,t),s(e,vo,t),M(At,e,t),s(e,No,t),s(e,_t,t),s(e,Ao,t),s(e,$t,t),s(e,_o,t),M(Rt,e,t),s(e,$o,t),s(e,Vt,t),s(e,Ro,t),M(Yt,e,t),s(e,Vo,t),s(e,Pt,t),s(e,Yo,t),s(e,Et,t),s(e,Po,t),s(e,Eo,t),s(e,Ho,t),s(e,Ht,t),s(e,Wo,t),M(Wt,e,t),s(e,zo,t),s(e,zt,t),s(e,Xo,t),s(e,Xt,t),s(e,So,t),s(e,Lo,t),s(e,Fo,t),s(e,St,t),s(e,Do,t),M(Lt,e,t),s(e,qo,t),s(e,Ft,t),s(e,Oo,t),s(e,Dt,t),s(e,Ko,t),s(e,ed,t),s(e,td,t),s(e,qt,t),s(e,ld,t),M(Ot,e,t),s(e,sd,t),s(e,Kt,t),s(e,id,t),s(e,el,t),s(e,nd,t),M(tl,e,t),s(e,ad,t),s(e,ll,t),s(e,pd,t),M(sl,e,t),s(e,od,t),s(e,il,t),s(e,dd,t),M(nl,e,t),s(e,cd,t),s(e,al,t),s(e,rd,t),s(e,Md,t),s(e,Td,t),s(e,pl,t),s(e,md,t),M(ol,e,t),s(e,yd,t),s(e,dl,t),s(e,ud,t),s(e,cl,t),s(e,Jd,t),s(e,rl,t),s(e,hd,t),s(e,wd,t),s(e,jd,t),s(e,Ml,t),s(e,Ud,t),M(Tl,e,t),s(e,fd,t),s(e,ml,t),s(e,bd,t),s(e,yl,t),s(e,xd,t),M(ul,e,t),s(e,Cd,t),s(e,Jl,t),s(e,gd,t),s(e,hl,t),s(e,Id,t),s(e,kd,t),s(e,Gd,t),s(e,wl,t),s(e,Zd,t),M(jl,e,t),s(e,Bd,t),s(e,Ul,t),s(e,Qd,t),s(e,fl,t),s(e,vd,t),s(e,Nd,t),s(e,Ad,t),s(e,bl,t),s(e,_d,t),M(xl,e,t),s(e,$d,t),s(e,Cl,t),s(e,Rd,t),s(e,gl,t),s(e,Vd,t),s(e,Il,t),s(e,Yd,t),s(e,Pd,t),s(e,Ed,t),s(e,kl,t),s(e,Hd,t),M(Gl,e,t),s(e,Wd,t),s(e,Zl,t),s(e,zd,t),s(e,Bl,t),s(e,Xd,t),M(Ql,e,t),s(e,Sd,t),s(e,vl,t),s(e,Ld,t),M(Nl,e,t),s(e,Fd,t),s(e,Al,t),s(e,Dd,t),M(_l,e,t),s(e,qd,t),s(e,$l,t),s(e,Od,t),M(Rl,e,t),s(e,Kd,t),s(e,Vl,t),s(e,ec,t),M(Yl,e,t),s(e,tc,t),s(e,Pl,t),s(e,lc,t),M(El,e,t),s(e,sc,t),s(e,Hl,t),s(e,ic,t),s(e,Wl,t),s(e,nc,t),s(e,ac,t),s(e,pc,t),s(e,zl,t),s(e,oc,t),M(Xl,e,t),s(e,dc,t),s(e,Sl,t),s(e,cc,t),s(e,Ll,t),s(e,rc,t),s(e,Mc,t),s(e,Tc,t),s(e,Fl,t),s(e,mc,t),M(Dl,e,t),s(e,yc,t),s(e,ql,t),s(e,uc,t),s(e,Ol,t),s(e,Jc,t),s(e,Kl,t),s(e,hc,t),s(e,wc,t),s(e,jc,t),s(e,es,t),s(e,Uc,t),M(ts,e,t),s(e,fc,t),s(e,ls,t),s(e,bc,t),s(e,ss,t),s(e,xc,t),M(is,e,t),s(e,Cc,t),s(e,ns,t),s(e,gc,t),M(as,e,t),s(e,Ic,t),s(e,ps,t),s(e,kc,t),s(e,os,t),s(e,Gc,t),s(e,Zc,t),s(e,Bc,t),s(e,ds,t),s(e,Qc,t),M(cs,e,t),s(e,vc,t),s(e,rs,t),s(e,Nc,t),s(e,Ms,t),s(e,Ac,t),s(e,_c,t),s(e,$c,t),s(e,Ts,t),s(e,Rc,t),M(ms,e,t),s(e,Vc,t),s(e,ys,t),s(e,Yc,t),s(e,us,t),s(e,Pc,t),s(e,Js,t),s(e,Ec,t),s(e,Hc,t),s(e,Wc,t),s(e,hs,t),s(e,zc,t),M(ws,e,t),s(e,Xc,t),s(e,js,t),s(e,Sc,t),s(e,Us,t),s(e,Lc,t),M(fs,e,t),s(e,Fc,t),s(e,bs,t),s(e,Dc,t),M(xs,e,t),s(e,qc,t),s(e,Cs,t),s(e,Oc,t),M(gs,e,t),s(e,Kc,t),s(e,Is,t),s(e,er,t),s(e,ks,t),s(e,tr,t),s(e,lr,t),s(e,sr,t),s(e,Gs,t),s(e,ir,t),M(Zs,e,t),s(e,nr,t),s(e,Bs,t),s(e,ar,t),s(e,Qs,t),s(e,pr,t),s(e,or,t),s(e,dr,t),s(e,vs,t),s(e,cr,t),M(Ns,e,t),s(e,rr,t),s(e,As,t),s(e,Mr,t),s(e,_s,t),s(e,Tr,t),s(e,$s,t),s(e,mr,t),s(e,yr,t),s(e,ur,t),s(e,Rs,t),s(e,Jr,t),M(Vs,e,t),s(e,hr,t),s(e,Ys,t),s(e,wr,t),s(e,Ps,t),s(e,jr,t),M(Es,e,t),s(e,Ur,t),s(e,Hs,t),s(e,fr,t),s(e,Ws,t),s(e,br,t),s(e,xr,t),s(e,Cr,t),s(e,zs,t),s(e,gr,t),M(Xs,e,t),s(e,Ir,t),s(e,Ss,t),s(e,kr,t),s(e,Ls,t),s(e,Gr,t),s(e,Zr,t),s(e,Br,t),s(e,Fs,t),s(e,Qr,t),M(Ds,e,t),s(e,vr,t),s(e,qs,t),s(e,Nr,t),s(e,Os,t),s(e,Ar,t),s(e,Ks,t),s(e,_r,t),s(e,$r,t),s(e,Rr,t),s(e,ei,t),s(e,Vr,t),M(ti,e,t),s(e,Yr,t),s(e,li,t),s(e,Pr,t),s(e,si,t),s(e,Er,t),M(ii,e,t),s(e,Hr,t),s(e,ni,t),s(e,Wr,t),s(e,ai,t),s(e,zr,t),s(e,Xr,t),s(e,Sr,t),s(e,pi,t),s(e,Lr,t),M(oi,e,t),s(e,Fr,t),s(e,di,t),s(e,Dr,t),s(e,ci,t),s(e,qr,t),s(e,Or,t),s(e,Kr,t),s(e,ri,t),s(e,eM,t),M(Mi,e,t),s(e,tM,t),s(e,Ti,t),s(e,lM,t),s(e,mi,t),s(e,sM,t),s(e,yi,t),s(e,iM,t),s(e,nM,t),s(e,aM,t),s(e,ui,t),s(e,pM,t),M(Ji,e,t),s(e,oM,t),s(e,hi,t),s(e,dM,t),s(e,wi,t),s(e,cM,t),M(ji,e,t),s(e,rM,t),s(e,Ui,t),s(e,MM,t),s(e,fi,t),s(e,TM,t),s(e,mM,t),s(e,yM,t),s(e,bi,t),s(e,uM,t),M(xi,e,t),s(e,JM,t),s(e,Ci,t),s(e,hM,t),s(e,gi,t),s(e,wM,t),s(e,jM,t),s(e,UM,t),s(e,Ii,t),s(e,fM,t),M(ki,e,t),s(e,bM,t),s(e,Gi,t),s(e,xM,t),s(e,Zi,t),s(e,CM,t),s(e,Bi,t),s(e,gM,t),s(e,IM,t),s(e,kM,t),s(e,Qi,t),s(e,GM,t),M(vi,e,t),s(e,ZM,t),s(e,Ni,t),s(e,BM,t),s(e,Ai,t),s(e,QM,t),M(_i,e,t),s(e,vM,t),s(e,$i,t),s(e,NM,t),s(e,Ri,t),s(e,AM,t),s(e,_M,t),s(e,$M,t),s(e,Vi,t),s(e,RM,t),M(Yi,e,t),s(e,VM,t),s(e,Pi,t),s(e,YM,t),s(e,Ei,t),s(e,PM,t),s(e,EM,t),s(e,HM,t),s(e,Hi,t),s(e,WM,t),M(Wi,e,t),s(e,zM,t),s(e,zi,t),s(e,XM,t),s(e,Xi,t),s(e,SM,t),s(e,Si,t),s(e,LM,t),s(e,FM,t),s(e,DM,t),s(e,Li,t),s(e,qM,t),M(Fi,e,t),s(e,OM,t),s(e,Di,t),s(e,KM,t),s(e,qi,t),s(e,eT,t),M(Oi,e,t),s(e,tT,t),s(e,Ki,t),s(e,lT,t),M(en,e,t),s(e,sT,t),s(e,tn,t),s(e,iT,t),s(e,ln,t),s(e,nT,t),s(e,aT,t),s(e,pT,t),s(e,sn,t),s(e,oT,t),M(nn,e,t),s(e,dT,t),s(e,an,t),s(e,cT,t),s(e,pn,t),s(e,rT,t),s(e,MT,t),s(e,TT,t),s(e,on,t),s(e,mT,t),M(dn,e,t),s(e,yT,t),s(e,cn,t),s(e,uT,t),s(e,rn,t),s(e,JT,t),s(e,Mn,t),s(e,hT,t),s(e,wT,t),s(e,jT,t),s(e,Tn,t),s(e,UT,t),M(mn,e,t),s(e,fT,t),s(e,yn,t),s(e,bT,t),s(e,un,t),s(e,xT,t),s(e,Jn,t),s(e,CT,t),s(e,hn,t),s(e,gT,t),s(e,IT,t),s(e,kT,t),s(e,wn,t),s(e,GT,t),M(jn,e,t),s(e,ZT,t),s(e,Un,t),s(e,BT,t),s(e,fn,t),s(e,QT,t),s(e,vT,t),s(e,NT,t),s(e,bn,t),s(e,AT,t),M(xn,e,t),s(e,_T,t),s(e,Cn,t),s(e,$T,t),s(e,RT,t),s(e,VT,t),s(e,gn,t),s(e,YT,t),M(In,e,t),s(e,PT,t),s(e,kn,t),s(e,ET,t),s(e,Gn,t),s(e,HT,t),s(e,WT,t),s(e,zT,t),s(e,Bn,t),XT=!0},p:uJ,i(e){XT||(T(U.$$.fragment,e),T(x.$$.fragment,e),T(I.$$.fragment,e),T(Q.$$.fragment,e),T(_.$$.fragment,e),T(Y.$$.fragment,e),T(z.$$.fragment,e),T(L.$$.fragment,e),T(D.$$.fragment,e),T(O.$$.fragment,e),T(te.$$.fragment,e),T(ae.$$.fragment,e),T(de.$$.fragment,e),T(re.$$.fragment,e),T(me.$$.fragment,e),T(we.$$.fragment,e),T(fe.$$.fragment,e),T(Ce.$$.fragment,e),T(Ze.$$.fragment,e),T(ve.$$.fragment,e),T(Ae.$$.fragment,e),T(Re.$$.fragment,e),T(He.$$.fragment,e),T(Xe.$$.fragment,e),T(Fe.$$.fragment,e),T(tt.$$.fragment,e),T(it.$$.fragment,e),T(pt.$$.fragment,e),T(rt.$$.fragment,e),T(mt.$$.fragment,e),T(Jt.$$.fragment,e),T(jt.$$.fragment,e),T(bt.$$.fragment,e),T(Ct.$$.fragment,e),T(It.$$.fragment,e),T(Zt.$$.fragment,e),T(At.$$.fragment,e),T(Rt.$$.fragment,e),T(Yt.$$.fragment,e),T(Wt.$$.fragment,e),T(Lt.$$.fragment,e),T(Ot.$$.fragment,e),T(tl.$$.fragment,e),T(sl.$$.fragment,e),T(nl.$$.fragment,e),T(ol.$$.fragment,e),T(Tl.$$.fragment,e),T(ul.$$.fragment,e),T(jl.$$.fragment,e),T(xl.$$.fragment,e),T(Gl.$$.fragment,e),T(Ql.$$.fragment,e),T(Nl.$$.fragment,e),T(_l.$$.fragment,e),T(Rl.$$.fragment,e),T(Yl.$$.fragment,e),T(El.$$.fragment,e),T(Xl.$$.fragment,e),T(Dl.$$.fragment,e),T(ts.$$.fragment,e),T(is.$$.fragment,e),T(as.$$.fragment,e),T(cs.$$.fragment,e),T(ms.$$.fragment,e),T(ws.$$.fragment,e),T(fs.$$.fragment,e),T(xs.$$.fragment,e),T(gs.$$.fragment,e),T(Zs.$$.fragment,e),T(Ns.$$.fragment,e),T(Vs.$$.fragment,e),T(Es.$$.fragment,e),T(Xs.$$.fragment,e),T(Ds.$$.fragment,e),T(ti.$$.fragment,e),T(ii.$$.fragment,e),T(oi.$$.fragment,e),T(Mi.$$.fragment,e),T(Ji.$$.fragment,e),T(ji.$$.fragment,e),T(xi.$$.fragment,e),T(ki.$$.fragment,e),T(vi.$$.fragment,e),T(_i.$$.fragment,e),T(Yi.$$.fragment,e),T(Wi.$$.fragment,e),T(Fi.$$.fragment,e),T(Oi.$$.fragment,e),T(en.$$.fragment,e),T(nn.$$.fragment,e),T(dn.$$.fragment,e),T(mn.$$.fragment,e),T(jn.$$.fragment,e),T(xn.$$.fragment,e),T(In.$$.fragment,e),XT=!0)},o(e){m(U.$$.fragment,e),m(x.$$.fragment,e),m(I.$$.fragment,e),m(Q.$$.fragment,e),m(_.$$.fragment,e),m(Y.$$.fragment,e),m(z.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(de.$$.fragment,e),m(re.$$.fragment,e),m(me.$$.fragment,e),m(we.$$.fragment,e),m(fe.$$.fragment,e),m(Ce.$$.fragment,e),m(Ze.$$.fragment,e),m(ve.$$.fragment,e),m(Ae.$$.fragment,e),m(Re.$$.fragment,e),m(He.$$.fragment,e),m(Xe.$$.fragment,e),m(Fe.$$.fragment,e),m(tt.$$.fragment,e),m(it.$$.fragment,e),m(pt.$$.fragment,e),m(rt.$$.fragment,e),m(mt.$$.fragment,e),m(Jt.$$.fragment,e),m(jt.$$.fragment,e),m(bt.$$.fragment,e),m(Ct.$$.fragment,e),m(It.$$.fragment,e),m(Zt.$$.fragment,e),m(At.$$.fragment,e),m(Rt.$$.fragment,e),m(Yt.$$.fragment,e),m(Wt.$$.fragment,e),m(Lt.$$.fragment,e),m(Ot.$$.fragment,e),m(tl.$$.fragment,e),m(sl.$$.fragment,e),m(nl.$$.fragment,e),m(ol.$$.fragment,e),m(Tl.$$.fragment,e),m(ul.$$.fragment,e),m(jl.$$.fragment,e),m(xl.$$.fragment,e),m(Gl.$$.fragment,e),m(Ql.$$.fragment,e),m(Nl.$$.fragment,e),m(_l.$$.fragment,e),m(Rl.$$.fragment,e),m(Yl.$$.fragment,e),m(El.$$.fragment,e),m(Xl.$$.fragment,e),m(Dl.$$.fragment,e),m(ts.$$.fragment,e),m(is.$$.fragment,e),m(as.$$.fragment,e),m(cs.$$.fragment,e),m(ms.$$.fragment,e),m(ws.$$.fragment,e),m(fs.$$.fragment,e),m(xs.$$.fragment,e),m(gs.$$.fragment,e),m(Zs.$$.fragment,e),m(Ns.$$.fragment,e),m(Vs.$$.fragment,e),m(Es.$$.fragment,e),m(Xs.$$.fragment,e),m(Ds.$$.fragment,e),m(ti.$$.fragment,e),m(ii.$$.fragment,e),m(oi.$$.fragment,e),m(Mi.$$.fragment,e),m(Ji.$$.fragment,e),m(ji.$$.fragment,e),m(xi.$$.fragment,e),m(ki.$$.fragment,e),m(vi.$$.fragment,e),m(_i.$$.fragment,e),m(Yi.$$.fragment,e),m(Wi.$$.fragment,e),m(Fi.$$.fragment,e),m(Oi.$$.fragment,e),m(en.$$.fragment,e),m(nn.$$.fragment,e),m(dn.$$.fragment,e),m(mn.$$.fragment,e),m(jn.$$.fragment,e),m(xn.$$.fragment,e),m(In.$$.fragment,e),XT=!1},d(e){e&&(l(Qn),l(Zn),l(vn),l(j),l(Nn),l(An),l(f),l(_n),l(b),l($n),l(Rn),l(C),l(Vn),l(Yn),l(Pn),l(g),l(En),l(Hn),l(k),l(Wn),l(G),l(zn),l(Z),l(Xn),l(Sn),l(Ln),l(B),l(Fn),l(Dn),l(v),l(qn),l(N),l(On),l(Kn),l(ea),l(A),l(ta),l(la),l($),l(sa),l(R),l(ia),l(na),l(aa),l(V),l(pa),l(oa),l(P),l(da),l(E),l(ca),l(H),l(ra),l(Ma),l(Ta),l(W),l(ma),l(ya),l(X),l(ua),l(S),l(Ja),l(ha),l(F),l(wa),l(ja),l(q),l(Ua),l(fa),l(K),l(ba),l(xa),l(Ca),l(ee),l(ga),l(Ia),l(le),l(ka),l(se),l(Ga),l(ie),l(Za),l(Ba),l(Qa),l(ne),l(va),l(Na),l(pe),l(Aa),l(oe),l(_a),l($a),l(ce),l(Ra),l(Va),l(Me),l(Ya),l(Pa),l(Ea),l(Te),l(Ha),l(Wa),l(ye),l(za),l(ue),l(Xa),l(Je),l(Sa),l(La),l(Fa),l(he),l(Da),l(qa),l(je),l(Oa),l(Ue),l(Ka),l(ep),l(be),l(tp),l(lp),l(sp),l(xe),l(ip),l(np),l(ge),l(ap),l(Ie),l(pp),l(ke),l(op),l(dp),l(cp),l(Ge),l(rp),l(Mp),l(Be),l(Tp),l(Qe),l(mp),l(yp),l(Ne),l(up),l(Jp),l(_e),l(hp),l(wp),l(jp),l($e),l(Up),l(fp),l(Ve),l(bp),l(Ye),l(xp),l(Pe),l(Cp),l(gp),l(Ip),l(Ee),l(kp),l(Gp),l(We),l(Zp),l(ze),l(Bp),l(Qp),l(Se),l(vp),l(Np),l(Ap),l(Le),l(_p),l($p),l(De),l(Rp),l(qe),l(Vp),l(Oe),l(Yp),l(Ke),l(Pp),l(Ep),l(Hp),l(et),l(Wp),l(zp),l(lt),l(Xp),l(st),l(Sp),l(Lp),l(nt),l(Fp),l(Dp),l(qp),l(at),l(Op),l(Kp),l(ot),l(eo),l(dt),l(to),l(ct),l(lo),l(so),l(Mt),l(io),l(Tt),l(no),l(ao),l(yt),l(po),l(ut),l(oo),l(co),l(ht),l(ro),l(Mo),l(To),l(wt),l(mo),l(yo),l(Ut),l(uo),l(ft),l(Jo),l(ho),l(xt),l(wo),l(jo),l(gt),l(Uo),l(fo),l(kt),l(bo),l(xo),l(Co),l(Gt),l(go),l(Io),l(Bt),l(ko),l(Qt),l(Go),l(vt),l(Zo),l(Bo),l(Qo),l(Nt),l(vo),l(No),l(_t),l(Ao),l($t),l(_o),l($o),l(Vt),l(Ro),l(Vo),l(Pt),l(Yo),l(Et),l(Po),l(Eo),l(Ho),l(Ht),l(Wo),l(zo),l(zt),l(Xo),l(Xt),l(So),l(Lo),l(Fo),l(St),l(Do),l(qo),l(Ft),l(Oo),l(Dt),l(Ko),l(ed),l(td),l(qt),l(ld),l(sd),l(Kt),l(id),l(el),l(nd),l(ad),l(ll),l(pd),l(od),l(il),l(dd),l(cd),l(al),l(rd),l(Md),l(Td),l(pl),l(md),l(yd),l(dl),l(ud),l(cl),l(Jd),l(rl),l(hd),l(wd),l(jd),l(Ml),l(Ud),l(fd),l(ml),l(bd),l(yl),l(xd),l(Cd),l(Jl),l(gd),l(hl),l(Id),l(kd),l(Gd),l(wl),l(Zd),l(Bd),l(Ul),l(Qd),l(fl),l(vd),l(Nd),l(Ad),l(bl),l(_d),l($d),l(Cl),l(Rd),l(gl),l(Vd),l(Il),l(Yd),l(Pd),l(Ed),l(kl),l(Hd),l(Wd),l(Zl),l(zd),l(Bl),l(Xd),l(Sd),l(vl),l(Ld),l(Fd),l(Al),l(Dd),l(qd),l($l),l(Od),l(Kd),l(Vl),l(ec),l(tc),l(Pl),l(lc),l(sc),l(Hl),l(ic),l(Wl),l(nc),l(ac),l(pc),l(zl),l(oc),l(dc),l(Sl),l(cc),l(Ll),l(rc),l(Mc),l(Tc),l(Fl),l(mc),l(yc),l(ql),l(uc),l(Ol),l(Jc),l(Kl),l(hc),l(wc),l(jc),l(es),l(Uc),l(fc),l(ls),l(bc),l(ss),l(xc),l(Cc),l(ns),l(gc),l(Ic),l(ps),l(kc),l(os),l(Gc),l(Zc),l(Bc),l(ds),l(Qc),l(vc),l(rs),l(Nc),l(Ms),l(Ac),l(_c),l($c),l(Ts),l(Rc),l(Vc),l(ys),l(Yc),l(us),l(Pc),l(Js),l(Ec),l(Hc),l(Wc),l(hs),l(zc),l(Xc),l(js),l(Sc),l(Us),l(Lc),l(Fc),l(bs),l(Dc),l(qc),l(Cs),l(Oc),l(Kc),l(Is),l(er),l(ks),l(tr),l(lr),l(sr),l(Gs),l(ir),l(nr),l(Bs),l(ar),l(Qs),l(pr),l(or),l(dr),l(vs),l(cr),l(rr),l(As),l(Mr),l(_s),l(Tr),l($s),l(mr),l(yr),l(ur),l(Rs),l(Jr),l(hr),l(Ys),l(wr),l(Ps),l(jr),l(Ur),l(Hs),l(fr),l(Ws),l(br),l(xr),l(Cr),l(zs),l(gr),l(Ir),l(Ss),l(kr),l(Ls),l(Gr),l(Zr),l(Br),l(Fs),l(Qr),l(vr),l(qs),l(Nr),l(Os),l(Ar),l(Ks),l(_r),l($r),l(Rr),l(ei),l(Vr),l(Yr),l(li),l(Pr),l(si),l(Er),l(Hr),l(ni),l(Wr),l(ai),l(zr),l(Xr),l(Sr),l(pi),l(Lr),l(Fr),l(di),l(Dr),l(ci),l(qr),l(Or),l(Kr),l(ri),l(eM),l(tM),l(Ti),l(lM),l(mi),l(sM),l(yi),l(iM),l(nM),l(aM),l(ui),l(pM),l(oM),l(hi),l(dM),l(wi),l(cM),l(rM),l(Ui),l(MM),l(fi),l(TM),l(mM),l(yM),l(bi),l(uM),l(JM),l(Ci),l(hM),l(gi),l(wM),l(jM),l(UM),l(Ii),l(fM),l(bM),l(Gi),l(xM),l(Zi),l(CM),l(Bi),l(gM),l(IM),l(kM),l(Qi),l(GM),l(ZM),l(Ni),l(BM),l(Ai),l(QM),l(vM),l($i),l(NM),l(Ri),l(AM),l(_M),l($M),l(Vi),l(RM),l(VM),l(Pi),l(YM),l(Ei),l(PM),l(EM),l(HM),l(Hi),l(WM),l(zM),l(zi),l(XM),l(Xi),l(SM),l(Si),l(LM),l(FM),l(DM),l(Li),l(qM),l(OM),l(Di),l(KM),l(qi),l(eT),l(tT),l(Ki),l(lT),l(sT),l(tn),l(iT),l(ln),l(nT),l(aT),l(pT),l(sn),l(oT),l(dT),l(an),l(cT),l(pn),l(rT),l(MT),l(TT),l(on),l(mT),l(yT),l(cn),l(uT),l(rn),l(JT),l(Mn),l(hT),l(wT),l(jT),l(Tn),l(UT),l(fT),l(yn),l(bT),l(un),l(xT),l(Jn),l(CT),l(hn),l(gT),l(IT),l(kT),l(wn),l(GT),l(ZT),l(Un),l(BT),l(fn),l(QT),l(vT),l(NT),l(bn),l(AT),l(_T),l(Cn),l($T),l(RT),l(VT),l(gn),l(YT),l(PT),l(kn),l(ET),l(Gn),l(HT),l(WT),l(zT),l(Bn)),l(w),y(U,e),y(x,e),y(I,e),y(Q,e),y(_,e),y(Y,e),y(z,e),y(L,e),y(D,e),y(O,e),y(te,e),y(ae,e),y(de,e),y(re,e),y(me,e),y(we,e),y(fe,e),y(Ce,e),y(Ze,e),y(ve,e),y(Ae,e),y(Re,e),y(He,e),y(Xe,e),y(Fe,e),y(tt,e),y(it,e),y(pt,e),y(rt,e),y(mt,e),y(Jt,e),y(jt,e),y(bt,e),y(Ct,e),y(It,e),y(Zt,e),y(At,e),y(Rt,e),y(Yt,e),y(Wt,e),y(Lt,e),y(Ot,e),y(tl,e),y(sl,e),y(nl,e),y(ol,e),y(Tl,e),y(ul,e),y(jl,e),y(xl,e),y(Gl,e),y(Ql,e),y(Nl,e),y(_l,e),y(Rl,e),y(Yl,e),y(El,e),y(Xl,e),y(Dl,e),y(ts,e),y(is,e),y(as,e),y(cs,e),y(ms,e),y(ws,e),y(fs,e),y(xs,e),y(gs,e),y(Zs,e),y(Ns,e),y(Vs,e),y(Es,e),y(Xs,e),y(Ds,e),y(ti,e),y(ii,e),y(oi,e),y(Mi,e),y(Ji,e),y(ji,e),y(xi,e),y(ki,e),y(vi,e),y(_i,e),y(Yi,e),y(Wi,e),y(Fi,e),y(Oi,e),y(en,e),y(nn,e),y(dn,e),y(mn,e),y(jn,e),y(xn,e),y(In,e)}}}const bJ='{"title":"pipelines","local":"pipelines","sections":[{"title":"pipelines.Pipeline ⇐ <code> Callable </code>","local":"pipelinespipeline--code-callable-code","sections":[{"title":"new Pipeline(options)","local":"new-pipelineoptions","sections":[],"depth":3},{"title":"pipeline.dispose() ⇒ <code> Promise. < void > </code>","local":"pipelinedispose--code-promise--void--code","sections":[],"depth":3},{"title":"pipeline._call(texts, ...args) ⇒ <code> Promise. < any > </code>","local":"pipelinecalltexts-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TextClassificationPipeline","local":"pipelinestextclassificationpipeline","sections":[{"title":"textClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"textclassificationpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TokenClassificationPipeline","local":"pipelinestokenclassificationpipeline","sections":[{"title":"tokenClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"tokenclassificationpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.QuestionAnsweringPipeline","local":"pipelinesquestionansweringpipeline","sections":[{"title":"questionAnsweringPipeline._call(question, context, options) ⇒ <code> QuestionAnsweringReturnType </code>","local":"questionansweringpipelinecallquestion-context-options--code-questionansweringreturntype-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.FillMaskPipeline","local":"pipelinesfillmaskpipeline","sections":[{"title":"fillMaskPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"fillmaskpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.Text2TextGenerationPipeline","local":"pipelinestext2textgenerationpipeline","sections":[{"title":"text2TextGenerationPipeline._call(texts, [options]) ⇒ <code> Promise. < any > </code>","local":"text2textgenerationpipelinecalltexts-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.SummarizationPipeline","local":"pipelinessummarizationpipeline","sections":[],"depth":2},{"title":"pipelines.TranslationPipeline","local":"pipelinestranslationpipeline","sections":[],"depth":2},{"title":"pipelines.TextGenerationPipeline","local":"pipelinestextgenerationpipeline","sections":[{"title":"textGenerationPipeline._call(texts, [generate_kwargs]) ⇒ <code> Promise. < any > </code>","local":"textgenerationpipelinecalltexts-generatekwargs--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotClassificationPipeline","local":"pipelineszeroshotclassificationpipeline","sections":[{"title":"new ZeroShotClassificationPipeline(options)","local":"new-zeroshotclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotClassificationPipeline._call(texts, candidate_labels, options) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"zeroshotclassificationpipelinecalltexts-candidatelabels-options--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.FeatureExtractionPipeline","local":"pipelinesfeatureextractionpipeline","sections":[{"title":"featureExtractionPipeline._call(texts, options) ⇒","local":"featureextractionpipelinecalltexts-options-","sections":[],"depth":3}],"depth":2},{"title":"pipelines.AudioClassificationPipeline","local":"pipelinesaudioclassificationpipeline","sections":[{"title":"new AudioClassificationPipeline(options)","local":"new-audioclassificationpipelineoptions","sections":[],"depth":3},{"title":"audioClassificationPipeline._call(audio, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"audioclassificationpipelinecallaudio-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.AutomaticSpeechRecognitionPipeline","local":"pipelinesautomaticspeechrecognitionpipeline","sections":[{"title":"new AutomaticSpeechRecognitionPipeline(options)","local":"new-automaticspeechrecognitionpipelineoptions","sections":[],"depth":3},{"title":"automaticSpeechRecognitionPipeline._call(audio, [kwargs]) ⇒ <code> Promise. < Object > </code>","local":"automaticspeechrecognitionpipelinecallaudio-kwargs--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageToTextPipeline","local":"pipelinesimagetotextpipeline","sections":[{"title":"new ImageToTextPipeline(options)","local":"new-imagetotextpipelineoptions","sections":[],"depth":3},{"title":"imageToTextPipeline._call(images, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"imagetotextpipelinecallimages-generatekwargs--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageClassificationPipeline","local":"pipelinesimageclassificationpipeline","sections":[{"title":"new ImageClassificationPipeline(options)","local":"new-imageclassificationpipelineoptions","sections":[],"depth":3},{"title":"imageClassificationPipeline._call(images, options) ⇒ <code> Promise. < any > </code>","local":"imageclassificationpipelinecallimages-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageSegmentationPipeline","local":"pipelinesimagesegmentationpipeline","sections":[{"title":"new ImageSegmentationPipeline(options)","local":"new-imagesegmentationpipelineoptions","sections":[],"depth":3},{"title":"imageSegmentationPipeline._call(images, options) ⇒ <code> Promise. < Array > </code>","local":"imagesegmentationpipelinecallimages-options--code-promise--array--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotImageClassificationPipeline","local":"pipelineszeroshotimageclassificationpipeline","sections":[{"title":"new ZeroShotImageClassificationPipeline(options)","local":"new-zeroshotimageclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotImageClassificationPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>","local":"zeroshotimageclassificationpipelinecallimages-candidatelabels-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ObjectDetectionPipeline","local":"pipelinesobjectdetectionpipeline","sections":[{"title":"new ObjectDetectionPipeline(options)","local":"new-objectdetectionpipelineoptions","sections":[],"depth":3},{"title":"objectDetectionPipeline._call(images, options)","local":"objectdetectionpipelinecallimages-options","sections":[],"depth":3}],"depth":2},{"title":"pipelines.DocumentQuestionAnsweringPipeline","local":"pipelinesdocumentquestionansweringpipeline","sections":[{"title":"new DocumentQuestionAnsweringPipeline(options)","local":"new-documentquestionansweringpipelineoptions","sections":[],"depth":3},{"title":"documentQuestionAnsweringPipeline._call(image, question, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"documentquestionansweringpipelinecallimage-question-generatekwargs--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TextToAudioPipeline","local":"pipelinestexttoaudiopipeline","sections":[{"title":"new TextToAudioPipeline(options)","local":"new-texttoaudiopipelineoptions","sections":[],"depth":3},{"title":"textToAudioPipeline._call(text_inputs, options) ⇒ <code> Promise. < Object > </code>","local":"texttoaudiopipelinecalltextinputs-options--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.pipeline(task, [model], [options]) ⇒ <code> Promise. < Pipeline > </code>","local":"pipelinespipelinetask-model-options--code-promise--pipeline--code","sections":[],"depth":2},{"title":"pipelines~QuestionAnsweringResult : <code> object </code>","local":"pipelinesquestionansweringresult--code-object-code","sections":[],"depth":2},{"title":"pipelines~QuestionAnsweringReturnType : <code> Promise. < (QuestionAnsweringResult|Array < QuestionAnsweringResult > ) > </code>","local":"pipelinesquestionansweringreturntype--code-promise--questionansweringresultarray--questionansweringresult----code","sections":[],"depth":2},{"title":"pipelines~ChunkCallback : <code> function </code>","local":"pipelineschunkcallback--code-function-code","sections":[],"depth":2}],"depth":1}';function xJ(ST){return JJ(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class GJ extends hJ{constructor(w){super(),wJ(this,w,xJ,fJ,yJ,{})}}export{GJ as component};
