import{s as cn,f as pn,o as mn,n as k}from"../chunks/scheduler.9bc65507.js";import{S as hn,i as un,g as p,s as r,r as u,A as fn,h as m,f as s,c as l,j,u as f,x as M,k as $,y as c,a as i,v as g,d as _,t as w,w as b}from"../chunks/index.707bf1b6.js";import{T as Ae}from"../chunks/Tip.c2ecdbf4.js";import{D as W}from"../chunks/Docstring.17db21ae.js";import{C as Oe}from"../chunks/CodeBlock.54a9f38d.js";import{E as De}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{P as gn}from"../chunks/PipelineTag.44585822.js";import{H as D}from"../chunks/Heading.342b1fa6.js";function _n(v){let t,h="Example:",a,d,T;return d=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN3aW5Db25maWclMkMlMjBTd2luTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3dpbiUyMG1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3dpbkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBtaWNyb3NvZnQlMkZzd2luLXRpbnktcGF0Y2g0LXdpbmRvdzctMjI0JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBTd2luTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SwinConfig, SwinModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Swin microsoft/swin-tiny-patch4-window7-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SwinConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the microsoft/swin-tiny-patch4-window7-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwinModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=p("p"),t.textContent=h,a=r(),u(d.$$.fragment)},l(o){t=m(o,"P",{"data-svelte-h":!0}),M(t)!=="svelte-11lpom8"&&(t.textContent=h),a=l(o),f(d.$$.fragment,o)},m(o,y){i(o,t,y),i(o,a,y),g(d,o,y),T=!0},p:k,i(o){T||(_(d.$$.fragment,o),T=!0)},o(o){w(d.$$.fragment,o),T=!1},d(o){o&&(s(t),s(a)),b(d,o)}}}function wn(v){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=h},l(a){t=m(a,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(a,d){i(a,t,d)},p:k,d(a){a&&s(t)}}}function bn(v){let t,h="Example:",a,d,T;return d=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN3aW5Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3dpbi10aW55LXBhdGNoNC13aW5kb3c3LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFN3aW5Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3dpbi10aW55LXBhdGNoNC13aW5kb3c3LTIyNCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SwinModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwinModel.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">49</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){t=p("p"),t.textContent=h,a=r(),u(d.$$.fragment)},l(o){t=m(o,"P",{"data-svelte-h":!0}),M(t)!=="svelte-11lpom8"&&(t.textContent=h),a=l(o),f(d.$$.fragment,o)},m(o,y){i(o,t,y),i(o,a,y),g(d,o,y),T=!0},p:k,i(o){T||(_(d.$$.fragment,o),T=!0)},o(o){w(d.$$.fragment,o),T=!1},d(o){o&&(s(t),s(a)),b(d,o)}}}function Mn(v){let t,h=`Note that we provide a script to pre-train this model on custom data in our <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-pretraining" rel="nofollow">examples
directory</a>.`;return{c(){t=p("p"),t.innerHTML=h},l(a){t=m(a,"P",{"data-svelte-h":!0}),M(t)!=="svelte-7i3y9o"&&(t.innerHTML=h)},m(a,d){i(a,t,d)},p:k,d(a){a&&s(t)}}}function Tn(v){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=h},l(a){t=m(a,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(a,d){i(a,t,d)},p:k,d(a){a&&s(t)}}}function yn(v){let t,h="Examples:",a,d,T;return d=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN3aW5Gb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tYmFzZS1zaW1taW0td2luZG93Ni0xOTIlMjIpJTBBbW9kZWwlMjAlM0QlMjBTd2luRm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3dpbi1iYXNlLXNpbW1pbS13aW5kb3c2LTE5MiUyMiklMEElMEFudW1fcGF0Y2hlcyUyMCUzRCUyMChtb2RlbC5jb25maWcuaW1hZ2Vfc2l6ZSUyMCUyRiUyRiUyMG1vZGVsLmNvbmZpZy5wYXRjaF9zaXplKSUyMCoqJTIwMiUwQXBpeGVsX3ZhbHVlcyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnBpeGVsX3ZhbHVlcyUwQSUyMyUyMGNyZWF0ZSUyMHJhbmRvbSUyMGJvb2xlYW4lMjBtYXNrJTIwb2YlMjBzaGFwZSUyMChiYXRjaF9zaXplJTJDJTIwbnVtX3BhdGNoZXMpJTBBYm9vbF9tYXNrZWRfcG9zJTIwJTNEJTIwdG9yY2gucmFuZGludChsb3clM0QwJTJDJTIwaGlnaCUzRDIlMkMlMjBzaXplJTNEKDElMkMlMjBudW1fcGF0Y2hlcykpLmJvb2woKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChwaXhlbF92YWx1ZXMlMkMlMjBib29sX21hc2tlZF9wb3MlM0Rib29sX21hc2tlZF9wb3MpJTBBbG9zcyUyQyUyMHJlY29uc3RydWN0ZWRfcGl4ZWxfdmFsdWVzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5yZWNvbnN0cnVjdGlvbiUwQWxpc3QocmVjb25zdHJ1Y3RlZF9waXhlbF92YWx1ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SwinForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-base-simmim-window6-192&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwinForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-base-simmim-window6-192&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create random boolean mask of shape (batch_size, num_patches)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = torch.randint(low=<span class="hljs-number">0</span>, high=<span class="hljs-number">2</span>, size=(<span class="hljs-number">1</span>, num_patches)).<span class="hljs-built_in">bool</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, reconstructed_pixel_values = outputs.loss, outputs.reconstruction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(reconstructed_pixel_values.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">192</span>, <span class="hljs-number">192</span>]`,wrap:!1}}),{c(){t=p("p"),t.textContent=h,a=r(),u(d.$$.fragment)},l(o){t=m(o,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=h),a=l(o),f(d.$$.fragment,o)},m(o,y){i(o,t,y),i(o,a,y),g(d,o,y),T=!0},p:k,i(o){T||(_(d.$$.fragment,o),T=!0)},o(o){w(d.$$.fragment,o),T=!1},d(o){o&&(s(t),s(a)),b(d,o)}}}function vn(v){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=h},l(a){t=m(a,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(a,d){i(a,t,d)},p:k,d(a){a&&s(t)}}}function $n(v){let t,h="Example:",a,d,T;return d=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN3aW5Gb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZzd2luLXRpbnktcGF0Y2g0LXdpbmRvdzctMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3dpbkZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfbGFiZWwlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfbGFiZWwlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SwinForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwinForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`,wrap:!1}}),{c(){t=p("p"),t.textContent=h,a=r(),u(d.$$.fragment)},l(o){t=m(o,"P",{"data-svelte-h":!0}),M(t)!=="svelte-11lpom8"&&(t.textContent=h),a=l(o),f(d.$$.fragment,o)},m(o,y){i(o,t,y),i(o,a,y),g(d,o,y),T=!0},p:k,i(o){T||(_(d.$$.fragment,o),T=!0)},o(o){w(d.$$.fragment,o),T=!1},d(o){o&&(s(t),s(a)),b(d,o)}}}function Fn(v){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=h},l(a){t=m(a,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(a,d){i(a,t,d)},p:k,d(a){a&&s(t)}}}function jn(v){let t,h="Example:",a,d,T;return d=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGU3dpbk1vZGVsJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3dpbi10aW55LXBhdGNoNC13aW5kb3c3LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGU3dpbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZzd2luLXRpbnktcGF0Y2g0LXdpbmRvdzctMjI0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFSwinModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFSwinModel.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">49</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){t=p("p"),t.textContent=h,a=r(),u(d.$$.fragment)},l(o){t=m(o,"P",{"data-svelte-h":!0}),M(t)!=="svelte-11lpom8"&&(t.textContent=h),a=l(o),f(d.$$.fragment,o)},m(o,y){i(o,t,y),i(o,a,y),g(d,o,y),T=!0},p:k,i(o){T||(_(d.$$.fragment,o),T=!0)},o(o){w(d.$$.fragment,o),T=!1},d(o){o&&(s(t),s(a)),b(d,o)}}}function kn(v){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=h},l(a){t=m(a,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(a,d){i(a,t,d)},p:k,d(a){a&&s(t)}}}function Sn(v){let t,h="Examples:",a,d,T;return d=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGU3dpbkZvck1hc2tlZEltYWdlTW9kZWxpbmclMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3dpbi10aW55LXBhdGNoNC13aW5kb3c3LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGU3dpbkZvck1hc2tlZEltYWdlTW9kZWxpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjIpJTBBJTBBbnVtX3BhdGNoZXMlMjAlM0QlMjAobW9kZWwuY29uZmlnLmltYWdlX3NpemUlMjAlMkYlMkYlMjBtb2RlbC5jb25maWcucGF0Y2hfc2l6ZSklMjAqKiUyMDIlMEFwaXhlbF92YWx1ZXMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKS5waXhlbF92YWx1ZXMlMEElMjMlMjBjcmVhdGUlMjByYW5kb20lMjBib29sZWFuJTIwbWFzayUyMG9mJTIwc2hhcGUlMjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9wYXRjaGVzKSUwQWJvb2xfbWFza2VkX3BvcyUyMCUzRCUyMHRmLnJhbmRvbS51bmlmb3JtKCgxJTJDJTIwbnVtX3BhdGNoZXMpKSUyMCUzRSUzRCUyMDAuNSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChwaXhlbF92YWx1ZXMlMkMlMjBib29sX21hc2tlZF9wb3MlM0Rib29sX21hc2tlZF9wb3MpJTBBbG9zcyUyQyUyMHJlY29uc3RydWN0ZWRfcGl4ZWxfdmFsdWVzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5yZWNvbnN0cnVjdGlvbiUwQWxpc3QocmVjb25zdHJ1Y3RlZF9waXhlbF92YWx1ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFSwinForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFSwinForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create random boolean mask of shape (batch_size, num_patches)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = tf.random.uniform((<span class="hljs-number">1</span>, num_patches)) &gt;= <span class="hljs-number">0.5</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, reconstructed_pixel_values = outputs.loss, outputs.reconstruction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(reconstructed_pixel_values.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>]`,wrap:!1}}),{c(){t=p("p"),t.textContent=h,a=r(),u(d.$$.fragment)},l(o){t=m(o,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=h),a=l(o),f(d.$$.fragment,o)},m(o,y){i(o,t,y),i(o,a,y),g(d,o,y),T=!0},p:k,i(o){T||(_(d.$$.fragment,o),T=!0)},o(o){w(d.$$.fragment,o),T=!1},d(o){o&&(s(t),s(a)),b(d,o)}}}function Cn(v){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=h},l(a){t=m(a,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(a,d){i(a,t,d)},p:k,d(a){a&&s(t)}}}function xn(v){let t,h="Example:",a,d,T;return d=new Oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGU3dpbkZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURlN3aW5Gb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZzd2luLXRpbnktcGF0Y2g0LXdpbmRvdzctMjI0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfbGFiZWwlMjAlM0QlMjBpbnQodGYubWF0aC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSklMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfbGFiZWwlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFSwinForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFSwinForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`,wrap:!1}}),{c(){t=p("p"),t.textContent=h,a=r(),u(d.$$.fragment)},l(o){t=m(o,"P",{"data-svelte-h":!0}),M(t)!=="svelte-11lpom8"&&(t.textContent=h),a=l(o),f(d.$$.fragment,o)},m(o,y){i(o,t,y),i(o,a,y),g(d,o,y),T=!0},p:k,i(o){T||(_(d.$$.fragment,o),T=!0)},o(o){w(d.$$.fragment,o),T=!1},d(o){o&&(s(t),s(a)),b(d,o)}}}function In(v){let t,h,a,d,T,o,y,_t,ge,Wo=`The Swin Transformer was proposed in <a href="https://arxiv.org/abs/2103.14030" rel="nofollow">Swin Transformer: Hierarchical Vision Transformer using Shifted Windows</a>
by Ze Liu, Yutong Lin, Yue Cao, Han Hu, Yixuan Wei, Zheng Zhang, Stephen Lin, Baining Guo.`,wt,_e,Uo="The abstract from the paper is the following:",bt,we,Jo=`<em>This paper presents a new vision Transformer, called Swin Transformer, that capably serves as a general-purpose backbone
for computer vision. Challenges in adapting Transformer from language to vision arise from differences between the two domains,
such as large variations in the scale of visual entities and the high resolution of pixels in images compared to words in text.
To address these differences, we propose a hierarchical Transformer whose representation is computed with \\bold{S}hifted
\\bold{win}dows. The shifted windowing scheme brings greater efficiency by limiting self-attention computation to non-overlapping
local windows while also allowing for cross-window connection. This hierarchical architecture has the flexibility to model at
various scales and has linear computational complexity with respect to image size. These qualities of Swin Transformer make it
compatible with a broad range of vision tasks, including image classification (87.3 top-1 accuracy on ImageNet-1K) and dense
prediction tasks such as object detection (58.7 box AP and 51.1 mask AP on COCO test-dev) and semantic segmentation
(53.5 mIoU on ADE20K val). Its performance surpasses the previous state-of-the-art by a large margin of +2.7 box AP and
+2.6 mask AP on COCO, and +3.2 mIoU on ADE20K, demonstrating the potential of Transformer-based models as vision backbones.
The hierarchical design and the shifted window approach also prove beneficial for all-MLP architectures.</em>`,Mt,be,Zo="Tips:",Tt,Me,No='<li>One can use the <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> API to prepare images for the model.</li> <li>Swin pads the inputs supporting any input height and width (if divisible by <code>32</code>).</li> <li>Swin can be used as a <em>backbone</em>. When <code>output_hidden_states = True</code>, it will output both <code>hidden_states</code> and <code>reshaped_hidden_states</code>. The <code>reshaped_hidden_states</code> have a shape of <code>(batch, num_channels, height, width)</code> rather than <code>(batch_size, sequence_length, num_channels)</code>.</li>',yt,te,zo,vt,Te,Go='Swin Transformer architecture. Taken from the <a href="https://arxiv.org/abs/2102.03334">original paper</a>.',$t,ye,Bo='This model was contributed by <a href="https://huggingface.co/novice03" rel="nofollow">novice03</a>. The Tensorflow version of this model was contributed by <a href="https://huggingface.co/amyeroberts" rel="nofollow">amyeroberts</a>. The original code can be found <a href="https://github.com/microsoft/Swin-Transformer" rel="nofollow">here</a>.',Ft,ve,jt,$e,Ro="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Swin Transformer.",kt,Fe,St,je,Xo='<li><a href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinForImageClassification">SwinForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',Ct,ke,Vo="Besides that:",xt,Se,Ho='<li><a href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinForMaskedImageModeling">SwinForMaskedImageModeling</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-pretraining" rel="nofollow">example script</a>.</li>',It,Ce,Yo="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Wt,xe,Ut,S,Ie,qt,Ke,Lo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinModel">SwinModel</a>. It is used to instantiate a Swin
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the Swin
<a href="https://huggingface.co/microsoft/swin-tiny-patch4-window7-224" rel="nofollow">microsoft/swin-tiny-patch4-window7-224</a>
architecture.`,Qt,et,Eo=`Configuration objects inherit from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,At,oe,Jt,We,Zt,B,Ue,Dt,tt,Po=`The bare Swin Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ot,U,Je,Kt,ot,qo='The <a href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinModel">SwinModel</a> forward method, overrides the <code>__call__</code> special method.',eo,ne,to,se,Nt,Ze,zt,F,Ne,oo,nt,Qo='Swin Model with a decoder on top for masked image modeling, as proposed in <a href="https://arxiv.org/abs/2111.09886" rel="nofollow">SimMIM</a>.',no,ae,so,st,Ao=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ao,J,ze,ro,at,Do='The <a href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinForMaskedImageModeling">SwinForMaskedImageModeling</a> forward method, overrides the <code>__call__</code> special method.',lo,re,io,le,Gt,Ge,Bt,C,Be,co,rt,Oo=`Swin Model transformer with an image classification head on top (a linear layer on top of the final hidden state of
the [CLS] token) e.g. for ImageNet.`,po,lt,Ko=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,mo,Z,Re,ho,it,en='The <a href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinForImageClassification">SwinForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',uo,ie,fo,de,Rt,Xe,Xt,R,Ve,go,dt,tn=`The bare Swin Model transformer outputting raw hidden-states without any specific head on top.
This model is a Tensorflow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a> sub-class. Use it as a
regular Tensorflow Module and refer to the Tensorflow documentation for all matter related to general usage and
behavior.`,_o,N,He,wo,ct,on='The <a href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.TFSwinModel">TFSwinModel</a> forward method, overrides the <code>__call__</code> special method.',bo,ce,Mo,pe,Vt,Ye,Ht,X,Le,To,pt,nn=`Swin Model with a decoder on top for masked image modeling, as proposed in <a href="https://arxiv.org/abs/2111.09886" rel="nofollow">SimMIM</a>.
This model is a Tensorflow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a> sub-class. Use it as a
regular Tensorflow Module and refer to the Tensorflow documentation for all matter related to general usage and
behavior.`,yo,z,Ee,vo,mt,sn='The <a href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.TFSwinForMaskedImageModeling">TFSwinForMaskedImageModeling</a> forward method, overrides the <code>__call__</code> special method.',$o,me,Fo,he,Yt,Pe,Lt,x,qe,jo,ht,an=`Swin Model transformer with an image classification head on top (a linear layer on top of the final hidden state of
the [CLS] token) e.g. for ImageNet.`,ko,ut,rn=`This model is a Tensorflow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a> sub-class. Use it as a
regular Tensorflow Module and refer to the Tensorflow documentation for all matter related to general usage and
behavior.`,So,G,Qe,Co,ft,ln='The <a href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.TFSwinForImageClassification">TFSwinForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',xo,ue,Io,fe,Et,gt,Pt;return T=new D({props:{title:"Swin Transformer",local:"swin-transformer",headingTag:"h1"}}),y=new D({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ve=new D({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Fe=new gn({props:{pipeline:"image-classification"}}),xe=new D({props:{title:"SwinConfig",local:"transformers.SwinConfig",headingTag:"h2"}}),Ie=new W({props:{name:"class transformers.SwinConfig",anchor:"transformers.SwinConfig",parameters:[{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 4"},{name:"num_channels",val:" = 3"},{name:"embed_dim",val:" = 96"},{name:"depths",val:" = [2, 2, 6, 2]"},{name:"num_heads",val:" = [3, 6, 12, 24]"},{name:"window_size",val:" = 7"},{name:"mlp_ratio",val:" = 4.0"},{name:"qkv_bias",val:" = True"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"drop_path_rate",val:" = 0.1"},{name:"hidden_act",val:" = 'gelu'"},{name:"use_absolute_embeddings",val:" = False"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"encoder_stride",val:" = 32"},{name:"out_features",val:" = None"},{name:"out_indices",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SwinConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.SwinConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.SwinConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.SwinConfig.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
Dimensionality of patch embedding.`,name:"embed_dim"},{anchor:"transformers.SwinConfig.depths",description:`<strong>depths</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[2, 2, 6, 2]</code>) &#x2014;
Depth of each layer in the Transformer encoder.`,name:"depths"},{anchor:"transformers.SwinConfig.num_heads",description:`<strong>num_heads</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[3, 6, 12, 24]</code>) &#x2014;
Number of attention heads in each layer of the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.SwinConfig.window_size",description:`<strong>window_size</strong> (<code>int</code>, <em>optional</em>, defaults to 7) &#x2014;
Size of windows.`,name:"window_size"},{anchor:"transformers.SwinConfig.mlp_ratio",description:`<strong>mlp_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Ratio of MLP hidden dimensionality to embedding dimensionality.`,name:"mlp_ratio"},{anchor:"transformers.SwinConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not a learnable bias should be added to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.SwinConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings and encoder.`,name:"hidden_dropout_prob"},{anchor:"transformers.SwinConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.SwinConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Stochastic depth rate.`,name:"drop_path_rate"},{anchor:"transformers.SwinConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.SwinConfig.use_absolute_embeddings",description:`<strong>use_absolute_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add absolute position embeddings to the patch embeddings.`,name:"use_absolute_embeddings"},{anchor:"transformers.SwinConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.SwinConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.SwinConfig.encoder_stride",description:`<strong>encoder_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Factor to increase the spatial resolution by in the decoder head for masked image modeling.`,name:"encoder_stride"},{anchor:"transformers.SwinConfig.out_features",description:`<strong>out_features</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of features to output. Can be any of <code>&quot;stem&quot;</code>, <code>&quot;stage1&quot;</code>, <code>&quot;stage2&quot;</code>, etc.
(depending on how many stages the model has). If unset and <code>out_indices</code> is set, will default to the
corresponding stages. If unset and <code>out_indices</code> is unset, will default to the last stage.`,name:"out_features"},{anchor:"transformers.SwinConfig.out_indices",description:`<strong>out_indices</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of indices of features to output. Can be any of 0, 1, 2, etc. (depending on how
many stages the model has). If unset and <code>out_features</code> is set, will default to the corresponding stages.
If unset and <code>out_features</code> is unset, will default to the last stage.`,name:"out_indices"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/swin/configuration_swin.py#L38"}}),oe=new De({props:{anchor:"transformers.SwinConfig.example",$$slots:{default:[_n]},$$scope:{ctx:v}}}),We=new D({props:{title:"SwinModel",local:"transformers.SwinModel",headingTag:"h2"}}),Ue=new W({props:{name:"class transformers.SwinModel",anchor:"transformers.SwinModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"},{name:"use_mask_token",val:" = False"}],parametersDescription:[{anchor:"transformers.SwinModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.SwinModel.add_pooling_layer",description:`<strong>add_pooling_layer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to apply pooling layer.`,name:"add_pooling_layer"},{anchor:"transformers.SwinModel.use_mask_token",description:`<strong>use_mask_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create and apply mask tokens in the embedding layer.`,name:"use_mask_token"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/swin/modeling_swin.py#L941"}}),Je=new W({props:{name:"forward",anchor:"transformers.SwinModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SwinModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.35.2/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.SwinModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwinModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwinModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwinModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SwinModel.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/swin/modeling_swin.py#L968",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.swin.modeling_swin.SwinModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>, <em>optional</em>, returned when <code>add_pooling_layer=True</code> is passed) — Average pooling of the last layer hidden-state.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.swin.modeling_swin.SwinModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ne=new Ae({props:{$$slots:{default:[wn]},$$scope:{ctx:v}}}),se=new De({props:{anchor:"transformers.SwinModel.forward.example",$$slots:{default:[bn]},$$scope:{ctx:v}}}),Ze=new D({props:{title:"SwinForMaskedImageModeling",local:"transformers.SwinForMaskedImageModeling",headingTag:"h2"}}),Ne=new W({props:{name:"class transformers.SwinForMaskedImageModeling",anchor:"transformers.SwinForMaskedImageModeling",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SwinForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/swin/modeling_swin.py#L1050"}}),ae=new Ae({props:{$$slots:{default:[Mn]},$$scope:{ctx:v}}}),ze=new W({props:{name:"forward",anchor:"transformers.SwinForMaskedImageModeling.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SwinForMaskedImageModeling.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.35.2/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.SwinForMaskedImageModeling.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwinForMaskedImageModeling.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwinForMaskedImageModeling.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwinForMaskedImageModeling.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SwinForMaskedImageModeling.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/swin/modeling_swin.py#L1067",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.swin.modeling_swin.SwinMaskedImageModelingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>bool_masked_pos</code> is provided) — Masked image modeling (MLM) loss.</p>
</li>
<li>
<p><strong>reconstruction</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Reconstructed pixel values.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.swin.modeling_swin.SwinMaskedImageModelingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),re=new Ae({props:{$$slots:{default:[Tn]},$$scope:{ctx:v}}}),le=new De({props:{anchor:"transformers.SwinForMaskedImageModeling.forward.example",$$slots:{default:[yn]},$$scope:{ctx:v}}}),Ge=new D({props:{title:"SwinForImageClassification",local:"transformers.SwinForImageClassification",headingTag:"h2"}}),Be=new W({props:{name:"class transformers.SwinForImageClassification",anchor:"transformers.SwinForImageClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SwinForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/swin/modeling_swin.py#L1161"}}),Re=new W({props:{name:"forward",anchor:"transformers.SwinForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SwinForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.35.2/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.SwinForImageClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwinForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwinForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwinForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SwinForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/swin/modeling_swin.py#L1176",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.swin.modeling_swin.SwinImageClassifierOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.swin.modeling_swin.SwinImageClassifierOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ie=new Ae({props:{$$slots:{default:[vn]},$$scope:{ctx:v}}}),de=new De({props:{anchor:"transformers.SwinForImageClassification.forward.example",$$slots:{default:[$n]},$$scope:{ctx:v}}}),Xe=new D({props:{title:"TFSwinModel",local:"transformers.TFSwinModel",headingTag:"h2"}}),Ve=new W({props:{name:"class transformers.TFSwinModel",anchor:"transformers.TFSwinModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFSwinModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/swin/modeling_tf_swin.py#L1168"}}),He=new W({props:{name:"call",anchor:"transformers.TFSwinModel.call",parameters:[{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"bool_masked_pos",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFSwinModel.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.35.2/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.TFSwinModel.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFSwinModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFSwinModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFSwinModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFSwinModel.call.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_patches)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/swin/modeling_tf_swin.py#L1176",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.swin.modeling_tf_swin.TFSwinModelOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>, <em>optional</em>, returned when <code>add_pooling_layer=True</code> is passed) — Average pooling of the last layer hidden-state.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.swin.modeling_tf_swin.TFSwinModelOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),ce=new Ae({props:{$$slots:{default:[Fn]},$$scope:{ctx:v}}}),pe=new De({props:{anchor:"transformers.TFSwinModel.call.example",$$slots:{default:[jn]},$$scope:{ctx:v}}}),Ye=new D({props:{title:"TFSwinForMaskedImageModeling",local:"transformers.TFSwinForMaskedImageModeling",headingTag:"h2"}}),Le=new W({props:{name:"class transformers.TFSwinForMaskedImageModeling",anchor:"transformers.TFSwinForMaskedImageModeling",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFSwinForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/swin/modeling_tf_swin.py#L1271"}}),Ee=new W({props:{name:"call",anchor:"transformers.TFSwinForMaskedImageModeling.call",parameters:[{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"bool_masked_pos",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFSwinForMaskedImageModeling.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.35.2/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.TFSwinForMaskedImageModeling.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFSwinForMaskedImageModeling.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFSwinForMaskedImageModeling.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFSwinForMaskedImageModeling.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFSwinForMaskedImageModeling.call.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_patches)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/swin/modeling_tf_swin.py#L1279",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.swin.modeling_tf_swin.TFSwinMaskedImageModelingOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>bool_masked_pos</code> is provided) — Masked image modeling (MLM) loss.</p>
</li>
<li>
<p><strong>reconstruction</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Reconstructed pixel values.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.swin.modeling_tf_swin.TFSwinMaskedImageModelingOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),me=new Ae({props:{$$slots:{default:[kn]},$$scope:{ctx:v}}}),he=new De({props:{anchor:"transformers.TFSwinForMaskedImageModeling.call.example",$$slots:{default:[Sn]},$$scope:{ctx:v}}}),Pe=new D({props:{title:"TFSwinForImageClassification",local:"transformers.TFSwinForImageClassification",headingTag:"h2"}}),qe=new W({props:{name:"class transformers.TFSwinForImageClassification",anchor:"transformers.TFSwinForImageClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFSwinForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/swin/modeling_tf_swin.py#L1383"}}),Qe=new W({props:{name:"call",anchor:"transformers.TFSwinForImageClassification.call",parameters:[{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"labels",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFSwinForImageClassification.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.35.2/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.TFSwinForImageClassification.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFSwinForImageClassification.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFSwinForImageClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFSwinForImageClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFSwinForImageClassification.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/swin/modeling_tf_swin.py#L1397",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.swin.modeling_tf_swin.TFSwinImageClassifierOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.swin.modeling_tf_swin.TFSwinImageClassifierOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),ue=new Ae({props:{$$slots:{default:[Cn]},$$scope:{ctx:v}}}),fe=new De({props:{anchor:"transformers.TFSwinForImageClassification.call.example",$$slots:{default:[xn]},$$scope:{ctx:v}}}),{c(){t=p("meta"),h=r(),a=p("p"),d=r(),u(T.$$.fragment),o=r(),u(y.$$.fragment),_t=r(),ge=p("p"),ge.innerHTML=Wo,wt=r(),_e=p("p"),_e.textContent=Uo,bt=r(),we=p("p"),we.innerHTML=Jo,Mt=r(),be=p("p"),be.textContent=Zo,Tt=r(),Me=p("ul"),Me.innerHTML=No,yt=r(),te=p("img"),vt=r(),Te=p("small"),Te.innerHTML=Go,$t=r(),ye=p("p"),ye.innerHTML=Bo,Ft=r(),u(ve.$$.fragment),jt=r(),$e=p("p"),$e.textContent=Ro,kt=r(),u(Fe.$$.fragment),St=r(),je=p("ul"),je.innerHTML=Xo,Ct=r(),ke=p("p"),ke.textContent=Vo,xt=r(),Se=p("ul"),Se.innerHTML=Ho,It=r(),Ce=p("p"),Ce.textContent=Yo,Wt=r(),u(xe.$$.fragment),Ut=r(),S=p("div"),u(Ie.$$.fragment),qt=r(),Ke=p("p"),Ke.innerHTML=Lo,Qt=r(),et=p("p"),et.innerHTML=Eo,At=r(),u(oe.$$.fragment),Jt=r(),u(We.$$.fragment),Zt=r(),B=p("div"),u(Ue.$$.fragment),Dt=r(),tt=p("p"),tt.innerHTML=Po,Ot=r(),U=p("div"),u(Je.$$.fragment),Kt=r(),ot=p("p"),ot.innerHTML=qo,eo=r(),u(ne.$$.fragment),to=r(),u(se.$$.fragment),Nt=r(),u(Ze.$$.fragment),zt=r(),F=p("div"),u(Ne.$$.fragment),oo=r(),nt=p("p"),nt.innerHTML=Qo,no=r(),u(ae.$$.fragment),so=r(),st=p("p"),st.innerHTML=Ao,ao=r(),J=p("div"),u(ze.$$.fragment),ro=r(),at=p("p"),at.innerHTML=Do,lo=r(),u(re.$$.fragment),io=r(),u(le.$$.fragment),Gt=r(),u(Ge.$$.fragment),Bt=r(),C=p("div"),u(Be.$$.fragment),co=r(),rt=p("p"),rt.textContent=Oo,po=r(),lt=p("p"),lt.innerHTML=Ko,mo=r(),Z=p("div"),u(Re.$$.fragment),ho=r(),it=p("p"),it.innerHTML=en,uo=r(),u(ie.$$.fragment),fo=r(),u(de.$$.fragment),Rt=r(),u(Xe.$$.fragment),Xt=r(),R=p("div"),u(Ve.$$.fragment),go=r(),dt=p("p"),dt.innerHTML=tn,_o=r(),N=p("div"),u(He.$$.fragment),wo=r(),ct=p("p"),ct.innerHTML=on,bo=r(),u(ce.$$.fragment),Mo=r(),u(pe.$$.fragment),Vt=r(),u(Ye.$$.fragment),Ht=r(),X=p("div"),u(Le.$$.fragment),To=r(),pt=p("p"),pt.innerHTML=nn,yo=r(),z=p("div"),u(Ee.$$.fragment),vo=r(),mt=p("p"),mt.innerHTML=sn,$o=r(),u(me.$$.fragment),Fo=r(),u(he.$$.fragment),Yt=r(),u(Pe.$$.fragment),Lt=r(),x=p("div"),u(qe.$$.fragment),jo=r(),ht=p("p"),ht.textContent=an,ko=r(),ut=p("p"),ut.innerHTML=rn,So=r(),G=p("div"),u(Qe.$$.fragment),Co=r(),ft=p("p"),ft.innerHTML=ln,xo=r(),u(ue.$$.fragment),Io=r(),u(fe.$$.fragment),Et=r(),gt=p("p"),this.h()},l(e){const n=fn("svelte-u9bgzb",document.head);t=m(n,"META",{name:!0,content:!0}),n.forEach(s),h=l(e),a=m(e,"P",{}),j(a).forEach(s),d=l(e),f(T.$$.fragment,e),o=l(e),f(y.$$.fragment,e),_t=l(e),ge=m(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-fc0dli"&&(ge.innerHTML=Wo),wt=l(e),_e=m(e,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-vfdo9a"&&(_e.textContent=Uo),bt=l(e),we=m(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-1111d6o"&&(we.innerHTML=Jo),Mt=l(e),be=m(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-axv494"&&(be.textContent=Zo),Tt=l(e),Me=m(e,"UL",{"data-svelte-h":!0}),M(Me)!=="svelte-fot37m"&&(Me.innerHTML=No),yt=l(e),te=m(e,"IMG",{src:!0,alt:!0,width:!0}),vt=l(e),Te=m(e,"SMALL",{"data-svelte-h":!0}),M(Te)!=="svelte-56pw3c"&&(Te.innerHTML=Go),$t=l(e),ye=m(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-72q0kq"&&(ye.innerHTML=Bo),Ft=l(e),f(ve.$$.fragment,e),jt=l(e),$e=m(e,"P",{"data-svelte-h":!0}),M($e)!=="svelte-1pydsgt"&&($e.textContent=Ro),kt=l(e),f(Fe.$$.fragment,e),St=l(e),je=m(e,"UL",{"data-svelte-h":!0}),M(je)!=="svelte-kgcev"&&(je.innerHTML=Xo),Ct=l(e),ke=m(e,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-1k821ua"&&(ke.textContent=Vo),xt=l(e),Se=m(e,"UL",{"data-svelte-h":!0}),M(Se)!=="svelte-14eaprx"&&(Se.innerHTML=Ho),It=l(e),Ce=m(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-1xesile"&&(Ce.textContent=Yo),Wt=l(e),f(xe.$$.fragment,e),Ut=l(e),S=m(e,"DIV",{class:!0});var V=j(S);f(Ie.$$.fragment,V),qt=l(V),Ke=m(V,"P",{"data-svelte-h":!0}),M(Ke)!=="svelte-15ivipv"&&(Ke.innerHTML=Lo),Qt=l(V),et=m(V,"P",{"data-svelte-h":!0}),M(et)!=="svelte-1g275hz"&&(et.innerHTML=Eo),At=l(V),f(oe.$$.fragment,V),V.forEach(s),Jt=l(e),f(We.$$.fragment,e),Zt=l(e),B=m(e,"DIV",{class:!0});var O=j(B);f(Ue.$$.fragment,O),Dt=l(O),tt=m(O,"P",{"data-svelte-h":!0}),M(tt)!=="svelte-1s5nfel"&&(tt.innerHTML=Po),Ot=l(O),U=m(O,"DIV",{class:!0});var H=j(U);f(Je.$$.fragment,H),Kt=l(H),ot=m(H,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-dkij7p"&&(ot.innerHTML=qo),eo=l(H),f(ne.$$.fragment,H),to=l(H),f(se.$$.fragment,H),H.forEach(s),O.forEach(s),Nt=l(e),f(Ze.$$.fragment,e),zt=l(e),F=m(e,"DIV",{class:!0});var I=j(F);f(Ne.$$.fragment,I),oo=l(I),nt=m(I,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-12jqo2k"&&(nt.innerHTML=Qo),no=l(I),f(ae.$$.fragment,I),so=l(I),st=m(I,"P",{"data-svelte-h":!0}),M(st)!=="svelte-68lg8f"&&(st.innerHTML=Ao),ao=l(I),J=m(I,"DIV",{class:!0});var Y=j(J);f(ze.$$.fragment,Y),ro=l(Y),at=m(Y,"P",{"data-svelte-h":!0}),M(at)!=="svelte-1kgxiib"&&(at.innerHTML=Do),lo=l(Y),f(re.$$.fragment,Y),io=l(Y),f(le.$$.fragment,Y),Y.forEach(s),I.forEach(s),Gt=l(e),f(Ge.$$.fragment,e),Bt=l(e),C=m(e,"DIV",{class:!0});var L=j(C);f(Be.$$.fragment,L),co=l(L),rt=m(L,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-k64ai4"&&(rt.textContent=Oo),po=l(L),lt=m(L,"P",{"data-svelte-h":!0}),M(lt)!=="svelte-68lg8f"&&(lt.innerHTML=Ko),mo=l(L),Z=m(L,"DIV",{class:!0});var E=j(Z);f(Re.$$.fragment,E),ho=l(E),it=m(E,"P",{"data-svelte-h":!0}),M(it)!=="svelte-1b5ty5z"&&(it.innerHTML=en),uo=l(E),f(ie.$$.fragment,E),fo=l(E),f(de.$$.fragment,E),E.forEach(s),L.forEach(s),Rt=l(e),f(Xe.$$.fragment,e),Xt=l(e),R=m(e,"DIV",{class:!0});var K=j(R);f(Ve.$$.fragment,K),go=l(K),dt=m(K,"P",{"data-svelte-h":!0}),M(dt)!=="svelte-13r0xu7"&&(dt.innerHTML=tn),_o=l(K),N=m(K,"DIV",{class:!0});var P=j(N);f(He.$$.fragment,P),wo=l(P),ct=m(P,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-xyc2nd"&&(ct.innerHTML=on),bo=l(P),f(ce.$$.fragment,P),Mo=l(P),f(pe.$$.fragment,P),P.forEach(s),K.forEach(s),Vt=l(e),f(Ye.$$.fragment,e),Ht=l(e),X=m(e,"DIV",{class:!0});var ee=j(X);f(Le.$$.fragment,ee),To=l(ee),pt=m(ee,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-16awvh3"&&(pt.innerHTML=nn),yo=l(ee),z=m(ee,"DIV",{class:!0});var q=j(z);f(Ee.$$.fragment,q),vo=l(q),mt=m(q,"P",{"data-svelte-h":!0}),M(mt)!=="svelte-1jf5bib"&&(mt.innerHTML=sn),$o=l(q),f(me.$$.fragment,q),Fo=l(q),f(he.$$.fragment,q),q.forEach(s),ee.forEach(s),Yt=l(e),f(Pe.$$.fragment,e),Lt=l(e),x=m(e,"DIV",{class:!0});var Q=j(x);f(qe.$$.fragment,Q),jo=l(Q),ht=m(Q,"P",{"data-svelte-h":!0}),M(ht)!=="svelte-k64ai4"&&(ht.textContent=an),ko=l(Q),ut=m(Q,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-2m586h"&&(ut.innerHTML=rn),So=l(Q),G=m(Q,"DIV",{class:!0});var A=j(G);f(Qe.$$.fragment,A),Co=l(A),ft=m(A,"P",{"data-svelte-h":!0}),M(ft)!=="svelte-1phox5z"&&(ft.innerHTML=ln),xo=l(A),f(ue.$$.fragment,A),Io=l(A),f(fe.$$.fragment,A),A.forEach(s),Q.forEach(s),Et=l(e),gt=m(e,"P",{}),j(gt).forEach(s),this.h()},h(){$(t,"name","hf:doc:metadata"),$(t,"content",Wn),pn(te.src,zo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/swin_transformer_architecture.png")||$(te,"src",zo),$(te,"alt","drawing"),$(te,"width","600"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){c(document.head,t),i(e,h,n),i(e,a,n),i(e,d,n),g(T,e,n),i(e,o,n),g(y,e,n),i(e,_t,n),i(e,ge,n),i(e,wt,n),i(e,_e,n),i(e,bt,n),i(e,we,n),i(e,Mt,n),i(e,be,n),i(e,Tt,n),i(e,Me,n),i(e,yt,n),i(e,te,n),i(e,vt,n),i(e,Te,n),i(e,$t,n),i(e,ye,n),i(e,Ft,n),g(ve,e,n),i(e,jt,n),i(e,$e,n),i(e,kt,n),g(Fe,e,n),i(e,St,n),i(e,je,n),i(e,Ct,n),i(e,ke,n),i(e,xt,n),i(e,Se,n),i(e,It,n),i(e,Ce,n),i(e,Wt,n),g(xe,e,n),i(e,Ut,n),i(e,S,n),g(Ie,S,null),c(S,qt),c(S,Ke),c(S,Qt),c(S,et),c(S,At),g(oe,S,null),i(e,Jt,n),g(We,e,n),i(e,Zt,n),i(e,B,n),g(Ue,B,null),c(B,Dt),c(B,tt),c(B,Ot),c(B,U),g(Je,U,null),c(U,Kt),c(U,ot),c(U,eo),g(ne,U,null),c(U,to),g(se,U,null),i(e,Nt,n),g(Ze,e,n),i(e,zt,n),i(e,F,n),g(Ne,F,null),c(F,oo),c(F,nt),c(F,no),g(ae,F,null),c(F,so),c(F,st),c(F,ao),c(F,J),g(ze,J,null),c(J,ro),c(J,at),c(J,lo),g(re,J,null),c(J,io),g(le,J,null),i(e,Gt,n),g(Ge,e,n),i(e,Bt,n),i(e,C,n),g(Be,C,null),c(C,co),c(C,rt),c(C,po),c(C,lt),c(C,mo),c(C,Z),g(Re,Z,null),c(Z,ho),c(Z,it),c(Z,uo),g(ie,Z,null),c(Z,fo),g(de,Z,null),i(e,Rt,n),g(Xe,e,n),i(e,Xt,n),i(e,R,n),g(Ve,R,null),c(R,go),c(R,dt),c(R,_o),c(R,N),g(He,N,null),c(N,wo),c(N,ct),c(N,bo),g(ce,N,null),c(N,Mo),g(pe,N,null),i(e,Vt,n),g(Ye,e,n),i(e,Ht,n),i(e,X,n),g(Le,X,null),c(X,To),c(X,pt),c(X,yo),c(X,z),g(Ee,z,null),c(z,vo),c(z,mt),c(z,$o),g(me,z,null),c(z,Fo),g(he,z,null),i(e,Yt,n),g(Pe,e,n),i(e,Lt,n),i(e,x,n),g(qe,x,null),c(x,jo),c(x,ht),c(x,ko),c(x,ut),c(x,So),c(x,G),g(Qe,G,null),c(G,Co),c(G,ft),c(G,xo),g(ue,G,null),c(G,Io),g(fe,G,null),i(e,Et,n),i(e,gt,n),Pt=!0},p(e,[n]){const V={};n&2&&(V.$$scope={dirty:n,ctx:e}),oe.$set(V);const O={};n&2&&(O.$$scope={dirty:n,ctx:e}),ne.$set(O);const H={};n&2&&(H.$$scope={dirty:n,ctx:e}),se.$set(H);const I={};n&2&&(I.$$scope={dirty:n,ctx:e}),ae.$set(I);const Y={};n&2&&(Y.$$scope={dirty:n,ctx:e}),re.$set(Y);const L={};n&2&&(L.$$scope={dirty:n,ctx:e}),le.$set(L);const E={};n&2&&(E.$$scope={dirty:n,ctx:e}),ie.$set(E);const K={};n&2&&(K.$$scope={dirty:n,ctx:e}),de.$set(K);const P={};n&2&&(P.$$scope={dirty:n,ctx:e}),ce.$set(P);const ee={};n&2&&(ee.$$scope={dirty:n,ctx:e}),pe.$set(ee);const q={};n&2&&(q.$$scope={dirty:n,ctx:e}),me.$set(q);const Q={};n&2&&(Q.$$scope={dirty:n,ctx:e}),he.$set(Q);const A={};n&2&&(A.$$scope={dirty:n,ctx:e}),ue.$set(A);const dn={};n&2&&(dn.$$scope={dirty:n,ctx:e}),fe.$set(dn)},i(e){Pt||(_(T.$$.fragment,e),_(y.$$.fragment,e),_(ve.$$.fragment,e),_(Fe.$$.fragment,e),_(xe.$$.fragment,e),_(Ie.$$.fragment,e),_(oe.$$.fragment,e),_(We.$$.fragment,e),_(Ue.$$.fragment,e),_(Je.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(Ze.$$.fragment,e),_(Ne.$$.fragment,e),_(ae.$$.fragment,e),_(ze.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(Ge.$$.fragment,e),_(Be.$$.fragment,e),_(Re.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(Xe.$$.fragment,e),_(Ve.$$.fragment,e),_(He.$$.fragment,e),_(ce.$$.fragment,e),_(pe.$$.fragment,e),_(Ye.$$.fragment,e),_(Le.$$.fragment,e),_(Ee.$$.fragment,e),_(me.$$.fragment,e),_(he.$$.fragment,e),_(Pe.$$.fragment,e),_(qe.$$.fragment,e),_(Qe.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),Pt=!0)},o(e){w(T.$$.fragment,e),w(y.$$.fragment,e),w(ve.$$.fragment,e),w(Fe.$$.fragment,e),w(xe.$$.fragment,e),w(Ie.$$.fragment,e),w(oe.$$.fragment,e),w(We.$$.fragment,e),w(Ue.$$.fragment,e),w(Je.$$.fragment,e),w(ne.$$.fragment,e),w(se.$$.fragment,e),w(Ze.$$.fragment,e),w(Ne.$$.fragment,e),w(ae.$$.fragment,e),w(ze.$$.fragment,e),w(re.$$.fragment,e),w(le.$$.fragment,e),w(Ge.$$.fragment,e),w(Be.$$.fragment,e),w(Re.$$.fragment,e),w(ie.$$.fragment,e),w(de.$$.fragment,e),w(Xe.$$.fragment,e),w(Ve.$$.fragment,e),w(He.$$.fragment,e),w(ce.$$.fragment,e),w(pe.$$.fragment,e),w(Ye.$$.fragment,e),w(Le.$$.fragment,e),w(Ee.$$.fragment,e),w(me.$$.fragment,e),w(he.$$.fragment,e),w(Pe.$$.fragment,e),w(qe.$$.fragment,e),w(Qe.$$.fragment,e),w(ue.$$.fragment,e),w(fe.$$.fragment,e),Pt=!1},d(e){e&&(s(h),s(a),s(d),s(o),s(_t),s(ge),s(wt),s(_e),s(bt),s(we),s(Mt),s(be),s(Tt),s(Me),s(yt),s(te),s(vt),s(Te),s($t),s(ye),s(Ft),s(jt),s($e),s(kt),s(St),s(je),s(Ct),s(ke),s(xt),s(Se),s(It),s(Ce),s(Wt),s(Ut),s(S),s(Jt),s(Zt),s(B),s(Nt),s(zt),s(F),s(Gt),s(Bt),s(C),s(Rt),s(Xt),s(R),s(Vt),s(Ht),s(X),s(Yt),s(Lt),s(x),s(Et),s(gt)),s(t),b(T,e),b(y,e),b(ve,e),b(Fe,e),b(xe,e),b(Ie),b(oe),b(We,e),b(Ue),b(Je),b(ne),b(se),b(Ze,e),b(Ne),b(ae),b(ze),b(re),b(le),b(Ge,e),b(Be),b(Re),b(ie),b(de),b(Xe,e),b(Ve),b(He),b(ce),b(pe),b(Ye,e),b(Le),b(Ee),b(me),b(he),b(Pe,e),b(qe),b(Qe),b(ue),b(fe)}}}const Wn='{"title":"Swin Transformer","local":"swin-transformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"SwinConfig","local":"transformers.SwinConfig","sections":[],"depth":2},{"title":"SwinModel","local":"transformers.SwinModel","sections":[],"depth":2},{"title":"SwinForMaskedImageModeling","local":"transformers.SwinForMaskedImageModeling","sections":[],"depth":2},{"title":"SwinForImageClassification","local":"transformers.SwinForImageClassification","sections":[],"depth":2},{"title":"TFSwinModel","local":"transformers.TFSwinModel","sections":[],"depth":2},{"title":"TFSwinForMaskedImageModeling","local":"transformers.TFSwinForMaskedImageModeling","sections":[],"depth":2},{"title":"TFSwinForImageClassification","local":"transformers.TFSwinForImageClassification","sections":[],"depth":2}],"depth":1}';function Un(v){return mn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vn extends hn{constructor(t){super(),un(this,t,Un,In,cn,{})}}export{Vn as component};
