import{s as ss,n as ts,o as es}from"../chunks/scheduler.f7e1785c.js";import{S as Ms,i as as,g as n,s as M,r as i,A as ns,h as p,f as t,c as a,j as ls,u as y,x as j,k as vl,y as ps,a as e,v as c,d as o,t as u,w as m}from"../chunks/index.9f8f0838.js";import{C as U}from"../chunks/CodeBlock.b3510e34.js";import{H as js}from"../chunks/Heading.6643a2f7.js";function is(Bl){let J,P,L,K,d,O,T,El="本节中我们将会使用🤗 Datasets来获取音频数据集。🤗 Datasets是一个下载和准备数据集的开源工具，包含了音频在内的各种模态数据。该工具集为Hugging Face Hub上公开的机器学习数据集提供了易用的接口。此外，🤗 Datasets还提供了专门为音频数据集而设的多种特性，帮助研究者和机器学习实践者更轻松地使用这些数据集。",ll,w,Ql="首先，我们要确认已经安装了🤗 Datasets库：",sl,h,tl,A,Wl="🤗 Datasets的其中一个重磅功能是可以使用<code>load_dataset()</code>函数达到仅用一行代码下载和准备数据集。",el,C,_l='这里我们来加载和探索<a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>这一音频数据集。该数据集的内容是人们向某个网银系统提问的录音，包含了多种语言和方言。',Ml,b,ql="为了加载MINDS-14数据集，我们需要复制该数据集在Hugging Face Hub上的identifier（<code>PolyAI/minds14</code>），并向<code>load_dataset()</code>函数传入该参数。这里我们只选取该数据集的澳大利亚子集（<code>en-AU</code>）的训练分集：",al,f,nl,I,xl="<strong>输出：</strong>",pl,g,jl,G,Rl="该数据集包含了654个音频文件，每个都有对应的转录文字和其英语翻译，以及一个代表询问人目的的标签。“audio”列则包含了原始的音频数据。我们来仔细看看其中的一个样本：",il,$,yl,k,Fl="<strong>输出</strong>",cl,Z,ol,v,Yl="你可能注意到了”audio”列包含了好几个特征，它们分别是：",ul,B,Hl="<li><code>path</code>：音频文件的路径（这里为<code>*.wav</code>）。</li> <li><code>array</code>：解码后的音频文件，以1维NumPy数组表示。</li> <li><code>sampling_rate</code>：音频文件的采样率（该样本为8000赫兹）。</li>",ml,E,Nl="<code>intent_class</code>则是分类的具体类别。我们可以使用<code>int2str()</code>方法将该数字转换为有意义的字符串：",Ul,Q,Jl,W,Sl="<strong>输出：</strong>",rl,_,dl,q,Xl="在该样本的转录文字中，我们可以看到该音频的内容确实是某人在提一个关于账单的问题。",Tl,x,zl="如果你只是想用该子集训练一个音频分类器，你可能不需要使用所有的特征。举个例子，<code>lang_id</code>标签在该子集中全部为同样的值；<code>english_transcription</code>标签和<code>transcription</code>几乎完全含有相同的内容，因此我们也可以舍弃该标签。",wl,R,Vl="你可以使用🤗 Datasets的<code>remove_columns()</code>方法轻松地移除所有不相关的标签：",hl,F,Al,Y,Ll="<strong>输出：</strong>",Cl,H,bl,N,Dl="现在我们已经加载并检验了数据集的原始内容，让我们来听几个例子吧！我们可以使用<code>Gradio</code>中的<code>Blocks</code>功能和<code>Audio</code>功能从数据集中解码几个样本：",fl,S,Il,X,Pl="你也可以可视化你想要的样本。这里我们试着绘制第一个样本的波形图：",gl,z,Gl,r,Kl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',$l,V,Ol='动手试试吧！试着下载MINDS-14数据集中其他语言或方言的子集，聆听并可视化其中的一些样本，感受整个数据集的多样性。你可以在<a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">这里</a>找到语言和方言的全部列表（仅英文）。',kl,D,Zl;return d=new js({props:{title:"加载音频数据集",local:"加载音频数据集",headingTag:"h1"}}),h=new U({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]",wrap:!1}}),f=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`,wrap:!1}}),g=new U({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),$=new U({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`,wrap:!1}}),Z=new U({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`,wrap:!1}}),Q=new U({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),_=new U({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),F=new U({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`,wrap:!1}}),H=new U({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>',wrap:!1}}),S=new U({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),z=new U({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),{c(){J=n("meta"),P=M(),L=n("p"),K=M(),i(d.$$.fragment),O=M(),T=n("p"),T.textContent=El,ll=M(),w=n("p"),w.textContent=Ql,sl=M(),i(h.$$.fragment),tl=M(),A=n("p"),A.innerHTML=Wl,el=M(),C=n("p"),C.innerHTML=_l,Ml=M(),b=n("p"),b.innerHTML=ql,al=M(),i(f.$$.fragment),nl=M(),I=n("p"),I.innerHTML=xl,pl=M(),i(g.$$.fragment),jl=M(),G=n("p"),G.textContent=Rl,il=M(),i($.$$.fragment),yl=M(),k=n("p"),k.innerHTML=Fl,cl=M(),i(Z.$$.fragment),ol=M(),v=n("p"),v.textContent=Yl,ul=M(),B=n("ul"),B.innerHTML=Hl,ml=M(),E=n("p"),E.innerHTML=Nl,Ul=M(),i(Q.$$.fragment),Jl=M(),W=n("p"),W.innerHTML=Sl,rl=M(),i(_.$$.fragment),dl=M(),q=n("p"),q.textContent=Xl,Tl=M(),x=n("p"),x.innerHTML=zl,wl=M(),R=n("p"),R.innerHTML=Vl,hl=M(),i(F.$$.fragment),Al=M(),Y=n("p"),Y.innerHTML=Ll,Cl=M(),i(H.$$.fragment),bl=M(),N=n("p"),N.innerHTML=Dl,fl=M(),i(S.$$.fragment),Il=M(),X=n("p"),X.textContent=Pl,gl=M(),i(z.$$.fragment),Gl=M(),r=n("div"),r.innerHTML=Kl,$l=M(),V=n("p"),V.innerHTML=Ol,kl=M(),D=n("p"),this.h()},l(l){const s=ns("svelte-u9bgzb",document.head);J=p(s,"META",{name:!0,content:!0}),s.forEach(t),P=a(l),L=p(l,"P",{}),ls(L).forEach(t),K=a(l),y(d.$$.fragment,l),O=a(l),T=p(l,"P",{"data-svelte-h":!0}),j(T)!=="svelte-1y8bvn2"&&(T.textContent=El),ll=a(l),w=p(l,"P",{"data-svelte-h":!0}),j(w)!=="svelte-1h89fri"&&(w.textContent=Ql),sl=a(l),y(h.$$.fragment,l),tl=a(l),A=p(l,"P",{"data-svelte-h":!0}),j(A)!=="svelte-g669h9"&&(A.innerHTML=Wl),el=a(l),C=p(l,"P",{"data-svelte-h":!0}),j(C)!=="svelte-rjua1f"&&(C.innerHTML=_l),Ml=a(l),b=p(l,"P",{"data-svelte-h":!0}),j(b)!=="svelte-1ojkc6z"&&(b.innerHTML=ql),al=a(l),y(f.$$.fragment,l),nl=a(l),I=p(l,"P",{"data-svelte-h":!0}),j(I)!=="svelte-1yevus4"&&(I.innerHTML=xl),pl=a(l),y(g.$$.fragment,l),jl=a(l),G=p(l,"P",{"data-svelte-h":!0}),j(G)!=="svelte-1rccdlg"&&(G.textContent=Rl),il=a(l),y($.$$.fragment,l),yl=a(l),k=p(l,"P",{"data-svelte-h":!0}),j(k)!=="svelte-1n6w44y"&&(k.innerHTML=Fl),cl=a(l),y(Z.$$.fragment,l),ol=a(l),v=p(l,"P",{"data-svelte-h":!0}),j(v)!=="svelte-c9o52i"&&(v.textContent=Yl),ul=a(l),B=p(l,"UL",{"data-svelte-h":!0}),j(B)!=="svelte-8f05cg"&&(B.innerHTML=Hl),ml=a(l),E=p(l,"P",{"data-svelte-h":!0}),j(E)!=="svelte-utbio1"&&(E.innerHTML=Nl),Ul=a(l),y(Q.$$.fragment,l),Jl=a(l),W=p(l,"P",{"data-svelte-h":!0}),j(W)!=="svelte-1yevus4"&&(W.innerHTML=Sl),rl=a(l),y(_.$$.fragment,l),dl=a(l),q=p(l,"P",{"data-svelte-h":!0}),j(q)!=="svelte-13mvlt6"&&(q.textContent=Xl),Tl=a(l),x=p(l,"P",{"data-svelte-h":!0}),j(x)!=="svelte-1wbwj7h"&&(x.innerHTML=zl),wl=a(l),R=p(l,"P",{"data-svelte-h":!0}),j(R)!=="svelte-g2lrqn"&&(R.innerHTML=Vl),hl=a(l),y(F.$$.fragment,l),Al=a(l),Y=p(l,"P",{"data-svelte-h":!0}),j(Y)!=="svelte-1yevus4"&&(Y.innerHTML=Ll),Cl=a(l),y(H.$$.fragment,l),bl=a(l),N=p(l,"P",{"data-svelte-h":!0}),j(N)!=="svelte-1o3kj99"&&(N.innerHTML=Dl),fl=a(l),y(S.$$.fragment,l),Il=a(l),X=p(l,"P",{"data-svelte-h":!0}),j(X)!=="svelte-13xtlhz"&&(X.textContent=Pl),gl=a(l),y(z.$$.fragment,l),Gl=a(l),r=p(l,"DIV",{class:!0,"data-svelte-h":!0}),j(r)!=="svelte-1ym6zda"&&(r.innerHTML=Kl),$l=a(l),V=p(l,"P",{"data-svelte-h":!0}),j(V)!=="svelte-s7mtwg"&&(V.innerHTML=Ol),kl=a(l),D=p(l,"P",{}),ls(D).forEach(t),this.h()},h(){vl(J,"name","hf:doc:metadata"),vl(J,"content",ys),vl(r,"class","flex justify-center")},m(l,s){ps(document.head,J),e(l,P,s),e(l,L,s),e(l,K,s),c(d,l,s),e(l,O,s),e(l,T,s),e(l,ll,s),e(l,w,s),e(l,sl,s),c(h,l,s),e(l,tl,s),e(l,A,s),e(l,el,s),e(l,C,s),e(l,Ml,s),e(l,b,s),e(l,al,s),c(f,l,s),e(l,nl,s),e(l,I,s),e(l,pl,s),c(g,l,s),e(l,jl,s),e(l,G,s),e(l,il,s),c($,l,s),e(l,yl,s),e(l,k,s),e(l,cl,s),c(Z,l,s),e(l,ol,s),e(l,v,s),e(l,ul,s),e(l,B,s),e(l,ml,s),e(l,E,s),e(l,Ul,s),c(Q,l,s),e(l,Jl,s),e(l,W,s),e(l,rl,s),c(_,l,s),e(l,dl,s),e(l,q,s),e(l,Tl,s),e(l,x,s),e(l,wl,s),e(l,R,s),e(l,hl,s),c(F,l,s),e(l,Al,s),e(l,Y,s),e(l,Cl,s),c(H,l,s),e(l,bl,s),e(l,N,s),e(l,fl,s),c(S,l,s),e(l,Il,s),e(l,X,s),e(l,gl,s),c(z,l,s),e(l,Gl,s),e(l,r,s),e(l,$l,s),e(l,V,s),e(l,kl,s),e(l,D,s),Zl=!0},p:ts,i(l){Zl||(o(d.$$.fragment,l),o(h.$$.fragment,l),o(f.$$.fragment,l),o(g.$$.fragment,l),o($.$$.fragment,l),o(Z.$$.fragment,l),o(Q.$$.fragment,l),o(_.$$.fragment,l),o(F.$$.fragment,l),o(H.$$.fragment,l),o(S.$$.fragment,l),o(z.$$.fragment,l),Zl=!0)},o(l){u(d.$$.fragment,l),u(h.$$.fragment,l),u(f.$$.fragment,l),u(g.$$.fragment,l),u($.$$.fragment,l),u(Z.$$.fragment,l),u(Q.$$.fragment,l),u(_.$$.fragment,l),u(F.$$.fragment,l),u(H.$$.fragment,l),u(S.$$.fragment,l),u(z.$$.fragment,l),Zl=!1},d(l){l&&(t(P),t(L),t(K),t(O),t(T),t(ll),t(w),t(sl),t(tl),t(A),t(el),t(C),t(Ml),t(b),t(al),t(nl),t(I),t(pl),t(jl),t(G),t(il),t(yl),t(k),t(cl),t(ol),t(v),t(ul),t(B),t(ml),t(E),t(Ul),t(Jl),t(W),t(rl),t(dl),t(q),t(Tl),t(x),t(wl),t(R),t(hl),t(Al),t(Y),t(Cl),t(bl),t(N),t(fl),t(Il),t(X),t(gl),t(Gl),t(r),t($l),t(V),t(kl),t(D)),t(J),m(d,l),m(h,l),m(f,l),m(g,l),m($,l),m(Z,l),m(Q,l),m(_,l),m(F,l),m(H,l),m(S,l),m(z,l)}}}const ys='{"title":"加载音频数据集","local":"加载音频数据集","sections":[],"depth":1}';function cs(Bl){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Js extends Ms{constructor(J){super(),as(this,J,cs,is,ss,{})}}export{Js as component};
