import{s as bl,n as Il,o as fl}from"../chunks/scheduler.65852ee5.js";import{S as gl,i as Cl,g as o,s as n,r,A as Zl,h as i,f as l,c as a,j as Ul,u as p,x as M,k as hl,y as vl,a as s,v as y,d as c,t as u,w}from"../chunks/index.aa74147d.js";import{D as Bl,C as J}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as j,E as Gl}from"../chunks/EditOnGithub.4eda6a96.js";function Al(Rt){let m,Ce,fe,Ze,T,ve,d,Be,U,_t='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',Ge,h,Vt='This notebook demonstrates how you can use <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow"><strong>Transformers Agents</strong></a> to build awesome <strong>agents</strong>!',Ae,b,Et="What are <strong>agents</strong>? Agents are systems that are powered by an LLM and enable the LLM (with careful prompting and output parsing) to use specific <em>tools</em> to solve problems.",We,I,St='These <em>tools</em> are basically functions that the LLM couldn’t perform well by itself: for instance for a text-generation LLM like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">Llama-3-70B</a>, this could be an image generation tool, a web search tool, a calculator…',ke,f,Qt='What is <strong>Transformers Agents</strong>? it’s an extension of our <code>transformers</code> library that provides building blocks to build your own agents! Learn more about it in the <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow">documentation</a>.',Ne,g,Xt="Let’s see how to use it, and which use cases it can solve.",Re,C,$t="Run the line below to install required dependencies:",_e,Z,Ve,v,Ee,B,qt="For this use case, we want to show an agent that browses the web and is able to generate image.",Se,G,Ht="To build it, we simply need to have two tools ready: image generation and web search.",Qe,A,Ft="<li>For image generation, we load a tool from the Hub that uses the HF Inference API (Serverless) to generate images using Stable Diffusion.</li> <li>For the web search, we use a built-in tool.</li>",Xe,W,$e,k,xt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/agents_db5.png" alt="Image of an Aston Martin DB5"/>',qe,N,He,R,Yt="Quick definition: Retrieval-Augmented-Generation (RAG) is <strong><em>“using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”.</em></strong>",Fe,_,zt="This method has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.",xe,V,Lt="<li><p>Now let’s say we want to perform RAG, but with the additional constraint that some parameters must be dynamically generated. For example, depending on the user query we could want to restrict the search to specific subsets of the knowledge base, or we could want to adjust the number of documents retrieved. The difficulty is: <strong>how to dynamically adjust these parameters based on the user query?</strong></p></li> <li><p>A frequent failure case of RAG is when the retrieval based on the user query does not return any relevant supporting documents. <strong>Is there a way to iterate by re-calling the retriever with a modified query in case the previous results were not relevant?</strong></p></li>",Ye,E,Pt="🔧 Well, we can solve the points above in a simple way: we will <strong>give our agent control over the retriever’s parameters!</strong>",ze,S,Kt="➡️ Let’s show how to do this. We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many <code>huggingface</code> packages, stored as markdown.",Le,Q,Pe,X,Dt="Now we prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever. We are going to use LangChain, since it features excellent utilities for vector databases:",Ke,$,De,q,Ot="Now that we have the database ready, let’s build a RAG system that answers user queries based on it!",Oe,H,el="We want our system to select only from the most relevant sources of information, depending on the query.",et,F,tl="Our documentation pages come from the following sources:",tt,x,lt,Y,ll=`['datasets-server', 'datasets', 'optimum', 'gradio', 'blog', 'course', 'hub-docs', 'pytorch-image-models', 'peft', 'evaluate', 'diffusers', 'hf-endpoints-documentation', 'deep-rl-class', 'transformers']
`,st,z,sl="👉 Now let’s build a <code>RetrieverTool</code> that our agent can leverage to retrieve information from the knowledge base.",nt,L,nl='Since we need to add a vectordb as an attribute of the tool, we cannot simply use the <a href="https://huggingface.co/docs/transformers/main/en/agents#create-a-new-tool" rel="nofollow">simple tool constructor</a> with a <code>@tool</code> decorator: so we will follow the advanced setup highlighted in the <a href="https://huggingface.co/docs/transformers/main/en/agents_advanced#directly-define-a-tool-by-subclassing-tool-and-share-it-to-the-hub" rel="nofollow">advanced agents documentation</a>.',at,P,ot,K,it,D,al="To share your tool to the Hub, first copy-paste the code in the RetrieverTool definition cell to a new file named for instance <code>retriever.py</code>.",Mt,O,ol="When the tool is loaded from a separate file, you can then push it to the Hub using the code below (make sure to login with a <code>write</code> access token)",rt,ee,pt,te,yt,le,ct,se,il="What happened here? First, the agent launched the retriever with specific sources in mind (<code>[&#39;transformers&#39;, &#39;blog&#39;]</code>).",ut,ne,Ml=`But this retrieval did not yield enough results ⇒ no problem! The agent could iterate on previous results, so it just re-ran its retrieval with less restrictive search parameters.
Thus the research was successful!`,wt,ae,rl="Note that <strong>using an LLM agent</strong> that calls a retriever as a tool and can dynamically modify the query and other retrieval parameters <strong>is a more general formulation of RAG</strong>, which also covers many RAG improvement techniques like iterative query refinement.",Jt,oe,mt,ie,pl="Since the ReactCodeAgent has a built-in Python code interpreter, we can use it to debug our faulty Python script!",jt,Me,Tt,re,yl="As you can see, the agent tried the given code, gets an error, analyses the error, corrects the code and returns it after veryfing that it works!",dt,pe,cl="And the final code is the corrected code:",Ut,ye,ht,ce,ul=`my_list = [0, 1, 2]

for i in range(4):
    if i < len(my_list):
        print(my_list[i])
    else:
        print("Index out of range")
`,bt,ue,It,we,wl=`It’s really easy to set up your own LLM engine:
it only needs a <code>__call__</code> method with these criteria:`,ft,Je,Jl='<li>Takes as input a list of messages in <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#introduction" rel="nofollow">ChatML format</a> and outputs the answer.</li> <li>Accepts a <code>stop_sequences</code> arguments to pass sequences on which generation stops.</li> <li>Depending on which kind of message roles your LLM accepts, you may also need to convert some message roles.</li>',gt,me,Ct,je,Zt,Te,ml=`my_list = [0, 1, 2]  # Renamed the list to avoid using the built-in name

for i in range(len(my_list)):  # Changed the range to be within the length of the list
    print(my_list[i])  # Corrected the list access syntax
`,vt,de,Bt,Ue,jl="The use cases above should give you a glimpse into the possibilities of our Agents framework!",Gt,he,Tl='For more advanced usage, read the <a href="https://huggingface.co/docs/transformers/en/transformers_agents" rel="nofollow">documentation</a>, and <a href="https://github.com/aymeric-roucher/agent_reasoning_benchmark/blob/main/benchmark_gaia.ipynb" rel="nofollow">this experiment</a> that allowed us to build our own agent based on Llama-3-70B that beats many GPT-4 agents on the very difficult <a href="https://huggingface.co/spaces/gaia-benchmark/leaderboard" rel="nofollow">GAIA Leaderboard</a>!',At,be,dl="All feedback is welcome, it will help us improve the framework! 🚀",Wt,Ie,kt,ge,Nt;return T=new Bl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agents.ipynb"}]}}),d=new j({props:{title:"Build an agent with tool-calling superpowers 🦸 using Transformers Agents",local:"build-an-agent-with-tool-calling-superpowers--using-transformers-agents",headingTag:"h1"}}),Z=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJ0cmFuc2Zvcm1lcnMlNUJhZ2VudHMlNUQlMjIlMjBkYXRhc2V0cyUyMGxhbmdjaGFpbiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWNwdSUyMGR1Y2tkdWNrZ28tc2VhcmNoJTIwb3BlbmFpJTIwbGFuZ2NoYWluLWNvbW11bml0eSUyMC0tdXBncmFkZSUyMC1x",highlighted:'!pip install <span class="hljs-string">&quot;transformers[agents]&quot;</span> datasets langchain sentence-transformers faiss-cpu duckduckgo-search openai langchain-community --upgrade -q',wrap:!1}}),v=new j({props:{title:"1. 🏞️ Multimodal + 🌐 Web-browsing assistant",local:"1--multimodal---web-browsing-assistant",headingTag:"h2"}}),W=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUyQyUyMFJlYWN0Q29kZUFnZW50JTJDJTIwSGZBcGlFbmdpbmUlMEElMEElMjMlMjBJbXBvcnQlMjB0b29sJTIwZnJvbSUyMEh1YiUwQWltYWdlX2dlbmVyYXRpb25fdG9vbCUyMCUzRCUyMGxvYWRfdG9vbCglMjJtLXJpYyUyRnRleHQtdG8taW1hZ2UlMjIlMkMlMjBjYWNoZSUzREZhbHNlKSUwQSUwQSUyMyUyMEltcG9ydCUyMHRvb2wlMjBmcm9tJTIwTGFuZ0NoYWluJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMuc2VhcmNoJTIwaW1wb3J0JTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEElMEFsbG1fZW5naW5lJTIwJTNEJTIwSGZBcGlFbmdpbmUoJTIyUXdlbiUyRlF3ZW4yLjUtNzJCLUluc3RydWN0JTIyKSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBhZ2VudCUyMHdpdGglMjBib3RoJTIwdG9vbHMlMEFhZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KHRvb2xzJTNEJTVCaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTJDJTIwc2VhcmNoX3Rvb2wlNUQlMkMlMjBsbG1fZW5naW5lJTNEbGxtX2VuZ2luZSklMEElMEElMjMlMjBSdW4lMjBpdCElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIyR2VuZXJhdGUlMjBtZSUyMGElMjBwaG90byUyMG9mJTIwdGhlJTIwY2FyJTIwdGhhdCUyMEphbWVzJTIwYm9uZCUyMGRyb3ZlJTIwaW4lMjB0aGUlMjBsYXRlc3QlMjBtb3ZpZS4lMjIlMkMlMEEpJTBBcmVzdWx0",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool, ReactCodeAgent, HfApiEngine

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>, cache=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># Import tool from LangChain</span>
<span class="hljs-keyword">from</span> transformers.agents.search <span class="hljs-keyword">import</span> DuckDuckGoSearchTool

search_tool = DuckDuckGoSearchTool()

llm_engine = HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)
<span class="hljs-comment"># Initialize the agent with both tools</span>
agent = ReactCodeAgent(tools=[image_generation_tool, search_tool], llm_engine=llm_engine)

<span class="hljs-comment"># Run it!</span>
result = agent.run(
    <span class="hljs-string">&quot;Generate me a photo of the car that James bond drove in the latest movie.&quot;</span>,
)
result`,wrap:!1}}),N=new j({props:{title:"2. 📚💬 RAG with Iterative query refinement & Source selection",local:"2--rag-with-iterative-query-refinement--source-selection",headingTag:"h2"}}),Q=new J({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),$=new J({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTBBZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEElMEFzb3VyY2VfZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMGtub3dsZWRnZV9iYXNlJTBBJTVEJTBBJTBBZG9jc19wcm9jZXNzZWQlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUwMCkuc3BsaXRfZG9jdW1lbnRzKHNvdXJjZV9kb2NzKSU1QiUzQTEwMDAlNUQlMEElMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MobW9kZWxfbmFtZSUzRCUyMnRoZW5scGVyJTJGZ3RlLXNtYWxsJTIyKSUwQXZlY3RvcmRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTNEZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmclM0RlbWJlZGRpbmdfbW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

docs_processed = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">500</span>).split_documents(source_docs)[:<span class="hljs-number">1000</span>]

embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
vectordb = FAISS.from_documents(documents=docs_processed, embedding=embedding_model)`,wrap:!1}}),x=new J({props:{code:"YWxsX3NvdXJjZXMlMjAlM0QlMjBsaXN0KHNldCglNUJkb2MubWV0YWRhdGElNUIlMjJzb3VyY2UlMjIlNUQlMjBmb3IlMjBkb2MlMjBpbiUyMGRvY3NfcHJvY2Vzc2VkJTVEKSklMEFwcmludChhbGxfc291cmNlcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>all_sources = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>([doc.metadata[<span class="hljs-string">&quot;source&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed]))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(all_sources)`,wrap:!1}}),P=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = (
        <span class="hljs-string">&quot;Retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    )
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        },
        <span class="hljs-string">&quot;source&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>, <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;&quot;</span>},
        <span class="hljs-string">&quot;number_of_documents&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the number of documents to retrieve. Stay under 10 to avoid drowning in docs&quot;</span>,
        },
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, all_sources: <span class="hljs-built_in">str</span>, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb
        self.inputs[<span class="hljs-string">&quot;source&quot;</span>][<span class="hljs-string">&quot;description&quot;</span>] = (
            <span class="hljs-string">f&quot;The source of the documents to search, as a str representation of a list. Possible values in the list are: <span class="hljs-subst">{all_sources}</span>. If this argument is not provided, all sources will be searched.&quot;</span>.replace(
                <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&quot;\`&quot;</span>
            )
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span>, source: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>, number_of_documents=<span class="hljs-number">7</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>
        number_of_documents = <span class="hljs-built_in">int</span>(number_of_documents)

        <span class="hljs-keyword">if</span> source:
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(source, <span class="hljs-built_in">str</span>) <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;[&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">str</span>(source):  <span class="hljs-comment"># if the source is not representing a list</span>
                source = [source]
            source = json.loads(<span class="hljs-built_in">str</span>(source).replace(<span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>))

        docs = self.vectordb.similarity_search(
            query,
            <span class="hljs-built_in">filter</span>=({<span class="hljs-string">&quot;source&quot;</span>: source} <span class="hljs-keyword">if</span> source <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>),
            k=number_of_documents,
        )

        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(docs) == <span class="hljs-number">0</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No documents found with this filtering. Try removing the source filter.&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Retrieved documents:\\n\\n&quot;</span> + <span class="hljs-string">&quot;\\n===Document===\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs])`,wrap:!1}}),K=new j({props:{title:"Optional: Share your Retriever tool to Hub",local:"optional-share-your-retriever-tool-to-hub",headingTag:"h3"}}),ee=new J({props:{code:"c2hhcmVfdG9faHViJTIwJTNEJTIwVHJ1ZSUwQSUwQWlmJTIwc2hhcmVfdG9faHViJTNBJTBBJTIwJTIwJTIwJTIwZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTIwJTIwJTIwJTIwZnJvbSUyMHJldHJpZXZlciUyMGltcG9ydCUyMFJldHJpZXZlclRvb2wlMEElMEElMjAlMjAlMjAlMjBsb2dpbiglMjJ5b3VyX3Rva2VuJTIyKSUwQSUwQSUyMCUyMCUyMCUyMHRvb2wlMjAlM0QlMjBSZXRyaWV2ZXJUb29sKHZlY3RvcmRiJTJDJTIwYWxsX3NvdXJjZXMpJTBBJTBBJTIwJTIwJTIwJTIwdG9vbC5wdXNoX3RvX2h1YihyZXBvX2lkJTNEJTIybS1yaWMlMkZyZXRyaWV2ZXItdG9vbCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBMb2FkaW5nJTIwdGhlJTIwdG9vbCUwQSUyMCUyMCUyMCUyMGZyb20lMjB0cmFuc2Zvcm1lcnMuYWdlbnRzJTIwaW1wb3J0JTIwbG9hZF90b29sJTBBJTBBJTIwJTIwJTIwJTIwcmV0cmlldmVyX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZyZXRyaWV2ZXItdG9vbCUyMiUyQyUyMHZlY3RvcmRiJTNEdmVjdG9yZGIlMkMlMjBhbGxfc291cmNlcyUzRGFsbF9zb3VyY2VzKQ==",highlighted:`share_to_hub = <span class="hljs-literal">True</span>

<span class="hljs-keyword">if</span> share_to_hub:
    <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
    <span class="hljs-keyword">from</span> retriever <span class="hljs-keyword">import</span> RetrieverTool

    login(<span class="hljs-string">&quot;your_token&quot;</span>)

    tool = RetrieverTool(vectordb, all_sources)

    tool.push_to_hub(repo_id=<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>)

    <span class="hljs-comment"># Loading the tool</span>
    <span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> load_tool

    retriever_tool = load_tool(<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>, vectordb=vectordb, all_sources=all_sources)`,wrap:!1}}),te=new j({props:{title:"Run the agent!",local:"run-the-agent",headingTag:"h3"}}),le=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkFwaUVuZ2luZSUyQyUyMFJlYWN0SnNvbkFnZW50JTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmQXBpRW5naW5lKCUyMlF3ZW4lMkZRd2VuMi41LTcyQi1JbnN0cnVjdCUyMiklMEElMEFyZXRyaWV2ZXJfdG9vbCUyMCUzRCUyMFJldHJpZXZlclRvb2wodmVjdG9yZGIlM0R2ZWN0b3JkYiUyQyUyMGFsbF9zb3VyY2VzJTNEYWxsX3NvdXJjZXMpJTBBYWdlbnQlMjAlM0QlMjBSZWFjdEpzb25BZ2VudCh0b29scyUzRCU1QnJldHJpZXZlcl90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUlMkMlMjB2ZXJib3NlJTNEMCklMEElMEFhZ2VudF9vdXRwdXQlMjAlM0QlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwc2hvdyUyMG1lJTIwYSUyMExPUkElMjBmaW5ldHVuaW5nJTIwc2NyaXB0JTIyKSUwQSUwQXByaW50KCUyMkZpbmFsJTIwb3V0cHV0JTNBJTIyKSUwQXByaW50KGFnZW50X291dHB1dCk=",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfApiEngine, ReactJsonAgent

llm_engine = HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)

retriever_tool = RetrieverTool(vectordb=vectordb, all_sources=all_sources)
agent = ReactJsonAgent(tools=[retriever_tool], llm_engine=llm_engine, verbose=<span class="hljs-number">0</span>)

agent_output = agent.run(<span class="hljs-string">&quot;Please show me a LORA finetuning script&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),oe=new j({props:{title:"3. 💻 Debug Python code",local:"3--debug-python-code",headingTag:"h2"}}),Me=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWN0Q29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMGxsbV9lbmdpbmUlM0RIZkFwaUVuZ2luZSglMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIpKSUwQSUwQWNvZGUlMjAlM0QlMjAlMjIlMjIlMjIlMEFsaXN0JTNEJTVCMCUyQyUyMDElMkMlMjAyJTVEJTBBJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoNCklM0ElMEElMjAlMjAlMjAlMjBwcmludChsaXN0KGkpKSUwQSUyMiUyMiUyMiUwQSUwQWZpbmFsX2Fuc3dlciUyMCUzRCUyMGFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJJJTIwaGF2ZSUyMHNvbWUlMjBjb2RlJTIwdGhhdCUyMGNyZWF0ZXMlMjBhJTIwYnVnJTNBJTIwcGxlYXNlJTIwZGVidWclMjBpdCUyQyUyMHRoZW4lMjBydW4lMjBpdCUyMHRvJTIwbWFrZSUyMHN1cmUlMjBpdCUyMHdvcmtzJTIwYW5kJTIwcmV0dXJuJTIwdGhlJTIwZmluYWwlMjBjb2RlJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29kZSUzRGNvZGUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReactCodeAgent

agent = ReactCodeAgent(tools=[], llm_engine=HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>))

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it, then run it to make sure it works and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),ye=new J({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),ue=new j({props:{title:"4. Create your own LLM engine (OpenAI)",local:"4-create-your-own-llm-engine-openai",headingTag:"h2"}}),me=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI
<span class="hljs-keyword">from</span> transformers.agents.llm_engine <span class="hljs-keyword">import</span> MessageRole, get_clean_message_list

openai_role_conversions = {
    MessageRole.TOOL_RESPONSE: <span class="hljs-string">&quot;user&quot;</span>,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">OpenAIEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;gpt-4o-2024-05-13&quot;</span></span>):
        self.model_name = model_name
        self.client = OpenAI(
            api_key=os.getenv(<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        <span class="hljs-comment"># Get clean message list</span>
        messages = get_clean_message_list(messages, role_conversions=openai_role_conversions)

        <span class="hljs-comment"># Get LLM output</span>
        response = self.client.chat.completions.create(
            model=self.model_name,
            messages=messages,
            stop=stop_sequences,
        )
        <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content


openai_engine = OpenAIEngine()
agent = ReactCodeAgent(llm_engine=openai_engine, tools=[])

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),je=new J({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),de=new j({props:{title:"➡️ Conclusion",local:"-conclusion",headingTag:"h2"}}),Ie=new Gl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agents.md"}}),{c(){m=o("meta"),Ce=n(),fe=o("p"),Ze=n(),r(T.$$.fragment),ve=n(),r(d.$$.fragment),Be=n(),U=o("p"),U.innerHTML=_t,Ge=n(),h=o("p"),h.innerHTML=Vt,Ae=n(),b=o("p"),b.innerHTML=Et,We=n(),I=o("p"),I.innerHTML=St,ke=n(),f=o("p"),f.innerHTML=Qt,Ne=n(),g=o("p"),g.textContent=Xt,Re=n(),C=o("p"),C.textContent=$t,_e=n(),r(Z.$$.fragment),Ve=n(),r(v.$$.fragment),Ee=n(),B=o("p"),B.textContent=qt,Se=n(),G=o("p"),G.textContent=Ht,Qe=n(),A=o("ul"),A.innerHTML=Ft,Xe=n(),r(W.$$.fragment),$e=n(),k=o("p"),k.innerHTML=xt,qe=n(),r(N.$$.fragment),He=n(),R=o("p"),R.innerHTML=Yt,Fe=n(),_=o("p"),_.textContent=zt,xe=n(),V=o("ul"),V.innerHTML=Lt,Ye=n(),E=o("p"),E.innerHTML=Pt,ze=n(),S=o("p"),S.innerHTML=Kt,Le=n(),r(Q.$$.fragment),Pe=n(),X=o("p"),X.textContent=Dt,Ke=n(),r($.$$.fragment),De=n(),q=o("p"),q.textContent=Ot,Oe=n(),H=o("p"),H.textContent=el,et=n(),F=o("p"),F.textContent=tl,tt=n(),r(x.$$.fragment),lt=n(),Y=o("pre"),Y.textContent=ll,st=n(),z=o("p"),z.innerHTML=sl,nt=n(),L=o("p"),L.innerHTML=nl,at=n(),r(P.$$.fragment),ot=n(),r(K.$$.fragment),it=n(),D=o("p"),D.innerHTML=al,Mt=n(),O=o("p"),O.innerHTML=ol,rt=n(),r(ee.$$.fragment),pt=n(),r(te.$$.fragment),yt=n(),r(le.$$.fragment),ct=n(),se=o("p"),se.innerHTML=il,ut=n(),ne=o("p"),ne.textContent=Ml,wt=n(),ae=o("p"),ae.innerHTML=rl,Jt=n(),r(oe.$$.fragment),mt=n(),ie=o("p"),ie.textContent=pl,jt=n(),r(Me.$$.fragment),Tt=n(),re=o("p"),re.textContent=yl,dt=n(),pe=o("p"),pe.textContent=cl,Ut=n(),r(ye.$$.fragment),ht=n(),ce=o("pre"),ce.textContent=ul,bt=n(),r(ue.$$.fragment),It=n(),we=o("p"),we.innerHTML=wl,ft=n(),Je=o("ol"),Je.innerHTML=Jl,gt=n(),r(me.$$.fragment),Ct=n(),r(je.$$.fragment),Zt=n(),Te=o("pre"),Te.textContent=ml,vt=n(),r(de.$$.fragment),Bt=n(),Ue=o("p"),Ue.textContent=jl,Gt=n(),he=o("p"),he.innerHTML=Tl,At=n(),be=o("p"),be.textContent=dl,Wt=n(),r(Ie.$$.fragment),kt=n(),ge=o("p"),this.h()},l(e){const t=Zl("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(l),Ce=a(e),fe=i(e,"P",{}),Ul(fe).forEach(l),Ze=a(e),p(T.$$.fragment,e),ve=a(e),p(d.$$.fragment,e),Be=a(e),U=i(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1xlqnsv"&&(U.innerHTML=_t),Ge=a(e),h=i(e,"P",{"data-svelte-h":!0}),M(h)!=="svelte-qt5igr"&&(h.innerHTML=Vt),Ae=a(e),b=i(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1mh34dv"&&(b.innerHTML=Et),We=a(e),I=i(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-mmy9qo"&&(I.innerHTML=St),ke=a(e),f=i(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-176yg59"&&(f.innerHTML=Qt),Ne=a(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-fc6q9b"&&(g.textContent=Xt),Re=a(e),C=i(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-16cuoal"&&(C.textContent=$t),_e=a(e),p(Z.$$.fragment,e),Ve=a(e),p(v.$$.fragment,e),Ee=a(e),B=i(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1354tpb"&&(B.textContent=qt),Se=a(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1yb5yrl"&&(G.textContent=Ht),Qe=a(e),A=i(e,"UL",{"data-svelte-h":!0}),M(A)!=="svelte-3qoj8n"&&(A.innerHTML=Ft),Xe=a(e),p(W.$$.fragment,e),$e=a(e),k=i(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1hg95q8"&&(k.innerHTML=xt),qe=a(e),p(N.$$.fragment,e),He=a(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1wknlb6"&&(R.innerHTML=Yt),Fe=a(e),_=i(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-19h5931"&&(_.textContent=zt),xe=a(e),V=i(e,"UL",{"data-svelte-h":!0}),M(V)!=="svelte-5uub6"&&(V.innerHTML=Lt),Ye=a(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1kfx2et"&&(E.innerHTML=Pt),ze=a(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1qw64fs"&&(S.innerHTML=Kt),Le=a(e),p(Q.$$.fragment,e),Pe=a(e),X=i(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-jy4i2f"&&(X.textContent=Dt),Ke=a(e),p($.$$.fragment,e),De=a(e),q=i(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-5pp8py"&&(q.textContent=Ot),Oe=a(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1cx88lu"&&(H.textContent=el),et=a(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1vgfwws"&&(F.textContent=tl),tt=a(e),p(x.$$.fragment,e),lt=a(e),Y=i(e,"PRE",{"data-svelte-h":!0}),M(Y)!=="svelte-crsp42"&&(Y.textContent=ll),st=a(e),z=i(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1dsjmqj"&&(z.innerHTML=sl),nt=a(e),L=i(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-yb70ev"&&(L.innerHTML=nl),at=a(e),p(P.$$.fragment,e),ot=a(e),p(K.$$.fragment,e),it=a(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-19hckuz"&&(D.innerHTML=al),Mt=a(e),O=i(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1wpkyax"&&(O.innerHTML=ol),rt=a(e),p(ee.$$.fragment,e),pt=a(e),p(te.$$.fragment,e),yt=a(e),p(le.$$.fragment,e),ct=a(e),se=i(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-6d9ubm"&&(se.innerHTML=il),ut=a(e),ne=i(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-ud3g55"&&(ne.textContent=Ml),wt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-3qqlok"&&(ae.innerHTML=rl),Jt=a(e),p(oe.$$.fragment,e),mt=a(e),ie=i(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-5kn15r"&&(ie.textContent=pl),jt=a(e),p(Me.$$.fragment,e),Tt=a(e),re=i(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-168ebuv"&&(re.textContent=yl),dt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-vscncs"&&(pe.textContent=cl),Ut=a(e),p(ye.$$.fragment,e),ht=a(e),ce=i(e,"PRE",{"data-svelte-h":!0}),M(ce)!=="svelte-eeovy7"&&(ce.textContent=ul),bt=a(e),p(ue.$$.fragment,e),It=a(e),we=i(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-6gn5q5"&&(we.innerHTML=wl),ft=a(e),Je=i(e,"OL",{"data-svelte-h":!0}),M(Je)!=="svelte-1o7lqh"&&(Je.innerHTML=Jl),gt=a(e),p(me.$$.fragment,e),Ct=a(e),p(je.$$.fragment,e),Zt=a(e),Te=i(e,"PRE",{"data-svelte-h":!0}),M(Te)!=="svelte-tgqz6q"&&(Te.textContent=ml),vt=a(e),p(de.$$.fragment,e),Bt=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-hpfue3"&&(Ue.textContent=jl),Gt=a(e),he=i(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-1nxb7v"&&(he.innerHTML=Tl),At=a(e),be=i(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-1ctcozl"&&(be.textContent=dl),Wt=a(e),p(Ie.$$.fragment,e),kt=a(e),ge=i(e,"P",{}),Ul(ge).forEach(l),this.h()},h(){hl(m,"name","hf:doc:metadata"),hl(m,"content",Wl)},m(e,t){vl(document.head,m),s(e,Ce,t),s(e,fe,t),s(e,Ze,t),y(T,e,t),s(e,ve,t),y(d,e,t),s(e,Be,t),s(e,U,t),s(e,Ge,t),s(e,h,t),s(e,Ae,t),s(e,b,t),s(e,We,t),s(e,I,t),s(e,ke,t),s(e,f,t),s(e,Ne,t),s(e,g,t),s(e,Re,t),s(e,C,t),s(e,_e,t),y(Z,e,t),s(e,Ve,t),y(v,e,t),s(e,Ee,t),s(e,B,t),s(e,Se,t),s(e,G,t),s(e,Qe,t),s(e,A,t),s(e,Xe,t),y(W,e,t),s(e,$e,t),s(e,k,t),s(e,qe,t),y(N,e,t),s(e,He,t),s(e,R,t),s(e,Fe,t),s(e,_,t),s(e,xe,t),s(e,V,t),s(e,Ye,t),s(e,E,t),s(e,ze,t),s(e,S,t),s(e,Le,t),y(Q,e,t),s(e,Pe,t),s(e,X,t),s(e,Ke,t),y($,e,t),s(e,De,t),s(e,q,t),s(e,Oe,t),s(e,H,t),s(e,et,t),s(e,F,t),s(e,tt,t),y(x,e,t),s(e,lt,t),s(e,Y,t),s(e,st,t),s(e,z,t),s(e,nt,t),s(e,L,t),s(e,at,t),y(P,e,t),s(e,ot,t),y(K,e,t),s(e,it,t),s(e,D,t),s(e,Mt,t),s(e,O,t),s(e,rt,t),y(ee,e,t),s(e,pt,t),y(te,e,t),s(e,yt,t),y(le,e,t),s(e,ct,t),s(e,se,t),s(e,ut,t),s(e,ne,t),s(e,wt,t),s(e,ae,t),s(e,Jt,t),y(oe,e,t),s(e,mt,t),s(e,ie,t),s(e,jt,t),y(Me,e,t),s(e,Tt,t),s(e,re,t),s(e,dt,t),s(e,pe,t),s(e,Ut,t),y(ye,e,t),s(e,ht,t),s(e,ce,t),s(e,bt,t),y(ue,e,t),s(e,It,t),s(e,we,t),s(e,ft,t),s(e,Je,t),s(e,gt,t),y(me,e,t),s(e,Ct,t),y(je,e,t),s(e,Zt,t),s(e,Te,t),s(e,vt,t),y(de,e,t),s(e,Bt,t),s(e,Ue,t),s(e,Gt,t),s(e,he,t),s(e,At,t),s(e,be,t),s(e,Wt,t),y(Ie,e,t),s(e,kt,t),s(e,ge,t),Nt=!0},p:Il,i(e){Nt||(c(T.$$.fragment,e),c(d.$$.fragment,e),c(Z.$$.fragment,e),c(v.$$.fragment,e),c(W.$$.fragment,e),c(N.$$.fragment,e),c(Q.$$.fragment,e),c($.$$.fragment,e),c(x.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(oe.$$.fragment,e),c(Me.$$.fragment,e),c(ye.$$.fragment,e),c(ue.$$.fragment,e),c(me.$$.fragment,e),c(je.$$.fragment,e),c(de.$$.fragment,e),c(Ie.$$.fragment,e),Nt=!0)},o(e){u(T.$$.fragment,e),u(d.$$.fragment,e),u(Z.$$.fragment,e),u(v.$$.fragment,e),u(W.$$.fragment,e),u(N.$$.fragment,e),u(Q.$$.fragment,e),u($.$$.fragment,e),u(x.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(oe.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(ue.$$.fragment,e),u(me.$$.fragment,e),u(je.$$.fragment,e),u(de.$$.fragment,e),u(Ie.$$.fragment,e),Nt=!1},d(e){e&&(l(Ce),l(fe),l(Ze),l(ve),l(Be),l(U),l(Ge),l(h),l(Ae),l(b),l(We),l(I),l(ke),l(f),l(Ne),l(g),l(Re),l(C),l(_e),l(Ve),l(Ee),l(B),l(Se),l(G),l(Qe),l(A),l(Xe),l($e),l(k),l(qe),l(He),l(R),l(Fe),l(_),l(xe),l(V),l(Ye),l(E),l(ze),l(S),l(Le),l(Pe),l(X),l(Ke),l(De),l(q),l(Oe),l(H),l(et),l(F),l(tt),l(lt),l(Y),l(st),l(z),l(nt),l(L),l(at),l(ot),l(it),l(D),l(Mt),l(O),l(rt),l(pt),l(yt),l(ct),l(se),l(ut),l(ne),l(wt),l(ae),l(Jt),l(mt),l(ie),l(jt),l(Tt),l(re),l(dt),l(pe),l(Ut),l(ht),l(ce),l(bt),l(It),l(we),l(ft),l(Je),l(gt),l(Ct),l(Zt),l(Te),l(vt),l(Bt),l(Ue),l(Gt),l(he),l(At),l(be),l(Wt),l(kt),l(ge)),l(m),w(T,e),w(d,e),w(Z,e),w(v,e),w(W,e),w(N,e),w(Q,e),w($,e),w(x,e),w(P,e),w(K,e),w(ee,e),w(te,e),w(le,e),w(oe,e),w(Me,e),w(ye,e),w(ue,e),w(me,e),w(je,e),w(de,e),w(Ie,e)}}}const Wl='{"title":"Build an agent with tool-calling superpowers 🦸 using Transformers Agents","local":"build-an-agent-with-tool-calling-superpowers--using-transformers-agents","sections":[{"title":"1. 🏞️ Multimodal + 🌐 Web-browsing assistant","local":"1--multimodal---web-browsing-assistant","sections":[],"depth":2},{"title":"2. 📚💬 RAG with Iterative query refinement & Source selection","local":"2--rag-with-iterative-query-refinement--source-selection","sections":[{"title":"Optional: Share your Retriever tool to Hub","local":"optional-share-your-retriever-tool-to-hub","sections":[],"depth":3},{"title":"Run the agent!","local":"run-the-agent","sections":[],"depth":3}],"depth":2},{"title":"3. 💻 Debug Python code","local":"3--debug-python-code","sections":[],"depth":2},{"title":"4. Create your own LLM engine (OpenAI)","local":"4-create-your-own-llm-engine-openai","sections":[],"depth":2},{"title":"➡️ Conclusion","local":"-conclusion","sections":[],"depth":2}],"depth":1}';function kl(Rt){return fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class El extends gl{constructor(m){super(),Cl(this,m,kl,Al,bl,{})}}export{El as component};
