import{s as Qo,o as Xo,n as P}from"../chunks/scheduler.25b97de1.js";import{S as Yo,i as Ao,g as p,s as a,r as u,A as Oo,h as m,f as s,c as r,j as J,u as h,x as y,k as j,y as c,a as i,v as f,d as g,t as _,w as b}from"../chunks/index.d9030fc9.js";import{T as Ht}from"../chunks/Tip.baa67368.js";import{D as V}from"../chunks/Docstring.ffac8efa.js";import{C as Ne}from"../chunks/CodeBlock.e6cd0d95.js";import{E as st}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as S,E as Do}from"../chunks/EditOnGithub.91d95064.js";function Ko(v){let n,M="Example:",l,d,T;return d=new Ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpb0dwdE1vZGVsJTJDJTIwQmlvR3B0Q29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEJpb0dQVCUyMG1pY3Jvc29mdCUyRmJpb2dwdCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBCaW9HcHRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBtaWNyb3NvZnQlMkZiaW9ncHQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEJpb0dwdE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BioGptModel, BioGptConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BioGPT microsoft/biogpt style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = BioGptConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the microsoft/biogpt style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=p("p"),n.textContent=M,l=a(),u(d.$$.fragment)},l(t){n=m(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=M),l=r(t),h(d.$$.fragment,t)},m(t,k){i(t,n,k),i(t,l,k),f(d,t,k),T=!0},p:P,i(t){T||(g(d.$$.fragment,t),T=!0)},o(t){_(d.$$.fragment,t),T=!1},d(t){t&&(s(n),s(l)),b(d,t)}}}function en(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=M},l(l){n=m(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(l,d){i(l,n,d)},p:P,d(l){l&&s(n)}}}function tn(v){let n,M="Example:",l,d,T;return d=new Ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBCaW9HcHRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmlvZ3B0JTIyKSUwQW1vZGVsJTIwJTNEJTIwQmlvR3B0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJpb2dwdCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, BioGptModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptModel.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){n=p("p"),n.textContent=M,l=a(),u(d.$$.fragment)},l(t){n=m(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=M),l=r(t),h(d.$$.fragment,t)},m(t,k){i(t,n,k),i(t,l,k),f(d,t,k),T=!0},p:P,i(t){T||(g(d.$$.fragment,t),T=!0)},o(t){_(d.$$.fragment,t),T=!1},d(t){t&&(s(n),s(l)),b(d,t)}}}function on(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=M},l(l){n=m(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(l,d){i(l,n,d)},p:P,d(l){l&&s(n)}}}function nn(v){let n,M="Example:",l,d,T;return d=new Ne({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEJpb0dwdEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmlvZ3B0JTIyKSUwQW1vZGVsJTIwJTNEJTIwQmlvR3B0Rm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJpb2dwdCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, BioGptForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=p("p"),n.textContent=M,l=a(),u(d.$$.fragment)},l(t){n=m(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=M),l=r(t),h(d.$$.fragment,t)},m(t,k){i(t,n,k),i(t,l,k),f(d,t,k),T=!0},p:P,i(t){T||(g(d.$$.fragment,t),T=!0)},o(t){_(d.$$.fragment,t),T=!1},d(t){t&&(s(n),s(l)),b(d,t)}}}function sn(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=M},l(l){n=m(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(l,d){i(l,n,d)},p:P,d(l){l&&s(n)}}}function an(v){let n,M="Example:",l,d,T;return d=new Ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBCaW9HcHRGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiaW9ncHQlMjIpJTBBbW9kZWwlMjAlM0QlMjBCaW9HcHRGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiaW9ncHQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmdGYWNlJTIwaXMlMjBhJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBQYXJpcyUyMGFuZCUyME5ldyUyMFlvcmslMjIlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSklMEElMEElMjMlMjBOb3RlJTIwdGhhdCUyMHRva2VucyUyMGFyZSUyMGNsYXNzaWZpZWQlMjByYXRoZXIlMjB0aGVuJTIwaW5wdXQlMjB3b3JkcyUyMHdoaWNoJTIwbWVhbnMlMjB0aGF0JTBBJTIzJTIwdGhlcmUlMjBtaWdodCUyMGJlJTIwbW9yZSUyMHByZWRpY3RlZCUyMHRva2VuJTIwY2xhc3NlcyUyMHRoYW4lMjB3b3Jkcy4lMEElMjMlMjBNdWx0aXBsZSUyMHRva2VuJTIwY2xhc3NlcyUyMG1pZ2h0JTIwYWNjb3VudCUyMGZvciUyMHRoZSUyMHNhbWUlMjB3b3JkJTBBcHJlZGljdGVkX3Rva2Vuc19jbGFzc2VzJTIwJTNEJTIwJTVCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCdC5pdGVtKCklNUQlMjBmb3IlMjB0JTIwaW4lMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTVCMCU1RCU1RCUwQSUwQWxhYmVscyUyMCUzRCUyMHByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, BioGptForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptForTokenClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){n=p("p"),n.textContent=M,l=a(),u(d.$$.fragment)},l(t){n=m(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=M),l=r(t),h(d.$$.fragment,t)},m(t,k){i(t,n,k),i(t,l,k),f(d,t,k),T=!0},p:P,i(t){T||(g(d.$$.fragment,t),T=!0)},o(t){_(d.$$.fragment,t),T=!1},d(t){t&&(s(n),s(l)),b(d,t)}}}function rn(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=p("p"),n.innerHTML=M},l(l){n=m(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(l,d){i(l,n,d)},p:P,d(l){l&&s(n)}}}function dn(v){let n,M="Example of single-label classification:",l,d,T;return d=new Ne({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEJpb0dwdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiaW9ncHQlMjIpJTBBbW9kZWwlMjAlM0QlMjBCaW9HcHRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiaW9ncHQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkJTIwJTNEJTIwbG9naXRzLmFyZ21heCgpLml0ZW0oKSUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMEJpb0dwdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJpb2dwdCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, BioGptForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){n=p("p"),n.textContent=M,l=a(),u(d.$$.fragment)},l(t){n=m(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-ykxpe4"&&(n.textContent=M),l=r(t),h(d.$$.fragment,t)},m(t,k){i(t,n,k),i(t,l,k),f(d,t,k),T=!0},p:P,i(t){T||(g(d.$$.fragment,t),T=!0)},o(t){_(d.$$.fragment,t),T=!1},d(t){t&&(s(n),s(l)),b(d,t)}}}function ln(v){let n,M="Example of multi-label classification:",l,d,T;return d=new Ne({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEJpb0dwdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiaW9ncHQlMjIpJTBBbW9kZWwlMjAlM0QlMjBCaW9HcHRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiaW9ncHQlMjIlMkMlMjBwcm9ibGVtX3R5cGUlM0QlMjJtdWx0aV9sYWJlbF9jbGFzc2lmaWNhdGlvbiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWRzJTIwJTNEJTIwdG9yY2guYXJhbmdlKDAlMkMlMjBsb2dpdHMuc2hhcGUlNUItMSU1RCklNUJ0b3JjaC5zaWdtb2lkKGxvZ2l0cykuc3F1ZWV6ZShkaW0lM0QwKSUyMCUzRSUyMDAuNSU1RCUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMEJpb0dwdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm1pY3Jvc29mdCUyRmJpb2dwdCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, BioGptForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;microsoft/biogpt&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){n=p("p"),n.textContent=M,l=a(),u(d.$$.fragment)},l(t){n=m(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-1l8e32d"&&(n.textContent=M),l=r(t),h(d.$$.fragment,t)},m(t,k){i(t,n,k),i(t,l,k),f(d,t,k),T=!0},p:P,i(t){T||(g(d.$$.fragment,t),T=!0)},o(t){_(d.$$.fragment,t),T=!1},d(t){t&&(s(n),s(l)),b(d,t)}}}function cn(v){let n,M,l,d,T,t,k,it,ae,bo='The BioGPT model was proposed in <a href="https://academic.oup.com/bib/advance-article/doi/10.1093/bib/bbac409/6713511?guestAccessKey=a66d9b5d-4f83-4017-bb52-405815c907b9" rel="nofollow">BioGPT: generative pre-trained transformer for biomedical text generation and mining</a> by Renqian Luo, Liai Sun, Yingce Xia, Tao Qin, Sheng Zhang, Hoifung Poon and Tie-Yan Liu. BioGPT is a domain-specific generative pre-trained Transformer language model for biomedical text generation and mining. BioGPT follows the Transformer language model backbone, and is pre-trained on 15M PubMed abstracts from scratch.',dt,re,yo="The abstract from the paper is the following:",lt,ie,To="<em>Pre-trained language models have attracted increasing attention in the biomedical domain, inspired by their great success in the general natural language domain. Among the two main branches of pre-trained language models in the general language domain, i.e. BERT (and its variants) and GPT (and its variants), the first one has been extensively studied in the biomedical domain, such as BioBERT and PubMedBERT. While they have achieved great success on a variety of discriminative downstream biomedical tasks, the lack of generation ability constrains their application scope. In this paper, we propose BioGPT, a domain-specific generative Transformer language model pre-trained on large-scale biomedical literature. We evaluate BioGPT on six biomedical natural language processing tasks and demonstrate that our model outperforms previous models on most tasks. Especially, we get 44.98%, 38.42% and 40.76% F1 score on BC5CDR, KD-DTI and DDI end-to-end relation extraction tasks, respectively, and 78.2% accuracy on PubMedQA, creating a new record. Our case study on text generation further demonstrates the advantage of BioGPT on biomedical literature to generate fluent descriptions for biomedical terms.</em>",ct,de,Mo='This model was contributed by <a href="https://huggingface.co/kamalkraj" rel="nofollow">kamalkraj</a>. The original code can be found <a href="https://github.com/microsoft/BioGPT" rel="nofollow">here</a>.',pt,le,mt,ce,ko="<li>BioGPT is a model with absolute position embeddings so it’s usually advised to pad the inputs on the right rather than the left.</li> <li>BioGPT was trained with a causal language modeling (CLM) objective and is therefore powerful at predicting the next token in a sequence. Leveraging this feature allows BioGPT to generate syntactically coherent text as it can be observed in the run_generation.py example script.</li> <li>The model can take the <code>past_key_values</code> (for PyTorch) as input, which is the previously computed key/value attention pairs. Using this (past_key_values or past) value prevents the model from re-computing pre-computed values in the context of text generation. For PyTorch, see past_key_values argument of the BioGptForCausalLM.forward() method for more information on its usage.</li>",ut,pe,ht,me,vo=`PyTorch includes a native scaled dot-product attention (SDPA) operator as part of <code>torch.nn.functional</code>. This function
encompasses several implementations that can be applied depending on the inputs and the hardware in use. See the
<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">official documentation</a>
or the <a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">GPU Inference</a>
page for more information.`,ft,ue,wo=`SDPA is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available, but you may also set
<code>attn_implementation=&quot;sdpa&quot;</code> in <code>from_pretrained()</code> to explicitly request SDPA to be used.`,gt,he,_t,fe,$o=`On a local benchmark (NVIDIA GeForce RTX 2060-8GB, PyTorch 2.3.1, OS Ubuntu 20.04) with <code>float16</code> and <code>microsoft/biogpt</code> model with a CausalLM head,
we saw the following speedups during training.`,bt,ge,Co="For the best speedups, we recommend loading the model in half-precision (e.g. <code>torch.float16</code> or <code>torch.bfloat16</code>).",yt,_e,Bo="<thead><tr><th>num_training_steps</th> <th>batch_size</th> <th>seq_len</th> <th>is cuda</th> <th>Time per batch (eager - s)</th> <th>Time per batch (sdpa - s)</th> <th>Speedup (%)</th> <th>Eager peak mem (MB)</th> <th>sdpa peak mem (MB)</th> <th>Mem saving (%)</th></tr></thead> <tbody><tr><td>100</td> <td>1</td> <td>128</td> <td>False</td> <td>0.038</td> <td>0.031</td> <td>21.301</td> <td>1601.862</td> <td>1601.497</td> <td>0.023</td></tr> <tr><td>100</td> <td>1</td> <td>256</td> <td>False</td> <td>0.039</td> <td>0.034</td> <td>15.084</td> <td>1624.944</td> <td>1625.296</td> <td>-0.022</td></tr> <tr><td>100</td> <td>2</td> <td>128</td> <td>False</td> <td>0.039</td> <td>0.033</td> <td>16.820</td> <td>1624.567</td> <td>1625.296</td> <td>-0.045</td></tr> <tr><td>100</td> <td>2</td> <td>256</td> <td>False</td> <td>0.065</td> <td>0.059</td> <td>10.255</td> <td>1672.164</td> <td>1672.164</td> <td>0.000</td></tr> <tr><td>100</td> <td>4</td> <td>128</td> <td>False</td> <td>0.062</td> <td>0.058</td> <td>6.998</td> <td>1671.435</td> <td>1672.164</td> <td>-0.044</td></tr> <tr><td>100</td> <td>4</td> <td>256</td> <td>False</td> <td>0.113</td> <td>0.100</td> <td>13.316</td> <td>2350.179</td> <td>1848.435</td> <td>27.144</td></tr> <tr><td>100</td> <td>8</td> <td>128</td> <td>False</td> <td>0.107</td> <td>0.098</td> <td>9.883</td> <td>2098.521</td> <td>1848.435</td> <td>13.530</td></tr> <tr><td>100</td> <td>8</td> <td>256</td> <td>False</td> <td>0.222</td> <td>0.196</td> <td>13.413</td> <td>3989.980</td> <td>2986.492</td> <td>33.601</td></tr></tbody>",Tt,be,Go=`On a local benchmark (NVIDIA GeForce RTX 2060-8GB, PyTorch 2.3.1, OS Ubuntu 20.04) with <code>float16</code> and <code>microsoft/biogpt</code> model with a simple AutoModel head,
we saw the following speedups during inference.`,Mt,ye,xo="<thead><tr><th>num_batches</th> <th>batch_size</th> <th>seq_len</th> <th>is cuda</th> <th>is half</th> <th>use mask</th> <th>Per token latency eager (ms)</th> <th>Per token latency SDPA (ms)</th> <th>Speedup (%)</th> <th>Mem eager (MB)</th> <th>Mem BT (MB)</th> <th>Mem saved (%)</th></tr></thead> <tbody><tr><td>50</td> <td>1</td> <td>64</td> <td>True</td> <td>True</td> <td>True</td> <td>0.115</td> <td>0.098</td> <td>17.392</td> <td>716.998</td> <td>716.998</td> <td>0.000</td></tr> <tr><td>50</td> <td>1</td> <td>128</td> <td>True</td> <td>True</td> <td>True</td> <td>0.115</td> <td>0.093</td> <td>24.640</td> <td>730.916</td> <td>730.916</td> <td>0.000</td></tr> <tr><td>50</td> <td>2</td> <td>64</td> <td>True</td> <td>True</td> <td>True</td> <td>0.114</td> <td>0.096</td> <td>19.204</td> <td>730.900</td> <td>730.900</td> <td>0.000</td></tr> <tr><td>50</td> <td>2</td> <td>128</td> <td>True</td> <td>True</td> <td>True</td> <td>0.117</td> <td>0.095</td> <td>23.529</td> <td>759.262</td> <td>759.262</td> <td>0.000</td></tr> <tr><td>50</td> <td>4</td> <td>64</td> <td>True</td> <td>True</td> <td>True</td> <td>0.113</td> <td>0.096</td> <td>18.325</td> <td>759.229</td> <td>759.229</td> <td>0.000</td></tr> <tr><td>50</td> <td>4</td> <td>128</td> <td>True</td> <td>True</td> <td>True</td> <td>0.186</td> <td>0.178</td> <td>4.289</td> <td>816.478</td> <td>816.478</td> <td>0.000</td></tr></tbody>",kt,Te,vt,Me,Jo='<li><a href="../tasks/language_modeling">Causal language modeling task guide</a></li>',wt,ke,$t,B,ve,Nt,Re,jo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptModel">BioGptModel</a>. It is used to instantiate an
BioGPT model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the BioGPT
<a href="https://huggingface.co/microsoft/biogpt" rel="nofollow">microsoft/biogpt</a> architecture.`,Rt,Le,zo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Lt,Y,Ct,we,Bt,G,$e,Vt,Ve,Fo="Construct an FAIRSEQ Transformer tokenizer. Moses tokenization followed by Byte-Pair Encoding.",St,Se,Uo=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Et,Ee,Ce,Gt,Be,xt,W,Ge,Pt,Pe,Wo=`The bare BioGPT Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Qt,z,xe,Xt,Qe,qo='The <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptModel">BioGptModel</a> forward method, overrides the <code>__call__</code> special method.',Yt,A,At,O,Jt,Je,jt,q,je,Ot,Xe,Zo=`BioGPT Model with a <code>language modeling</code> head on top for CLM fine-tuning.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Dt,F,ze,Kt,Ye,Io='The <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptForCausalLM">BioGptForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',eo,D,to,K,zt,Fe,Ft,x,Ue,oo,Ae,Ho=`BioGPT Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g. for
Named-Entity-Recognition (NER) tasks.`,no,Oe,No=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,so,U,We,ao,De,Ro='The <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptForTokenClassification">BioGptForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',ro,ee,io,te,Ut,qe,Wt,w,Ze,lo,Ke,Lo="The BioGpt Model transformer with a sequence classification head on top (linear layer).",co,et,Vo=`<a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptForSequenceClassification">BioGptForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,po,tt,So=`Since it does classification on the last token, it is required to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,mo,ot,Eo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,uo,C,Ie,ho,nt,Po='The <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptForSequenceClassification">BioGptForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',fo,oe,go,ne,_o,se,qt,He,Zt,at,It;return T=new S({props:{title:"BioGPT",local:"biogpt",headingTag:"h1"}}),k=new S({props:{title:"Overview",local:"overview",headingTag:"h2"}}),le=new S({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),pe=new S({props:{title:"Using Scaled Dot Product Attention (SDPA)",local:"using-scaled-dot-product-attention-sdpa",headingTag:"h3"}}),he=new Ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpb0dwdEZvckNhdXNhbExNJTBBbW9kZWwlMjAlM0QlMjBCaW9HcHRGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmlvZ3B0JTIyJTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMnNkcGElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:`from transformers import BioGptForCausalLM
model = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">BioGptForCausalLM</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>, <span class="hljs-params">attn_implementation</span>=<span class="hljs-string">&quot;sdpa&quot;</span>, <span class="hljs-params">torch_dtype</span>=<span class="hljs-params">torch</span>.<span class="hljs-params">float16</span>)</span>`,wrap:!1}}),Te=new S({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ke=new S({props:{title:"BioGptConfig",local:"transformers.BioGptConfig",headingTag:"h2"}}),ve=new V({props:{name:"class transformers.BioGptConfig",anchor:"transformers.BioGptConfig",parameters:[{name:"vocab_size",val:" = 42384"},{name:"hidden_size",val:" = 1024"},{name:"num_hidden_layers",val:" = 24"},{name:"num_attention_heads",val:" = 16"},{name:"intermediate_size",val:" = 4096"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 1024"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"scale_embedding",val:" = True"},{name:"use_cache",val:" = True"},{name:"layerdrop",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BioGptConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 42384) &#x2014;
Vocabulary size of the BioGPT model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptModel">BioGptModel</a>.`,name:"vocab_size"},{anchor:"transformers.BioGptConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.BioGptConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.BioGptConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.BioGptConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.BioGptConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.BioGptConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.BioGptConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.BioGptConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.BioGptConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.BioGptConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.BioGptConfig.scale_embedding",description:`<strong>scale_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Scale embeddings by diving by sqrt(d_model).`,name:"scale_embedding"},{anchor:"transformers.BioGptConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.BioGptConfig.layerdrop",description:`<strong>layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Please refer to the paper about LayerDrop: <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a> for further details`,name:"layerdrop"},{anchor:"transformers.BioGptConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.BioGptConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.BioGptConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.BioGptConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
End of stream token id.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/configuration_biogpt.py#L24"}}),Y=new st({props:{anchor:"transformers.BioGptConfig.example",$$slots:{default:[Ko]},$$scope:{ctx:v}}}),we=new S({props:{title:"BioGptTokenizer",local:"transformers.BioGptTokenizer",headingTag:"h2"}}),$e=new V({props:{name:"class transformers.BioGptTokenizer",anchor:"transformers.BioGptTokenizer",parameters:[{name:"vocab_file",val:""},{name:"merges_file",val:""},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"pad_token",val:" = '<pad>'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BioGptTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.BioGptTokenizer.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Merges file.`,name:"merges_file"},{anchor:"transformers.BioGptTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.BioGptTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.BioGptTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.BioGptTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.BioGptTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/tokenization_biogpt.py#L46"}}),Ce=new V({props:{name:"save_vocabulary",anchor:"transformers.BioGptTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/tokenization_biogpt.py#L314"}}),Be=new S({props:{title:"BioGptModel",local:"transformers.BioGptModel",headingTag:"h2"}}),Ge=new V({props:{name:"class transformers.BioGptModel",anchor:"transformers.BioGptModel",parameters:[{name:"config",val:": BioGptConfig"}],parametersDescription:[{anchor:"transformers.BioGptModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig">~BioGptConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L541"}}),xe=new V({props:{name:"forward",anchor:"transformers.BioGptModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BioGptModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BioGptModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.BioGptModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BioGptModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.BioGptModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.BioGptModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BioGptModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BioGptModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig"
>BioGptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new Ht({props:{$$slots:{default:[en]},$$scope:{ctx:v}}}),O=new st({props:{anchor:"transformers.BioGptModel.forward.example",$$slots:{default:[tn]},$$scope:{ctx:v}}}),Je=new S({props:{title:"BioGptForCausalLM",local:"transformers.BioGptForCausalLM",headingTag:"h2"}}),je=new V({props:{name:"class transformers.BioGptForCausalLM",anchor:"transformers.BioGptForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.BioGptForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig">~BioGptConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L721"}}),ze=new V({props:{name:"forward",anchor:"transformers.BioGptForCausalLM.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BioGptForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BioGptForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.BioGptForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BioGptForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.BioGptForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.BioGptForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BioGptForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BioGptForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BioGptForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L742",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig"
>BioGptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new Ht({props:{$$slots:{default:[on]},$$scope:{ctx:v}}}),K=new st({props:{anchor:"transformers.BioGptForCausalLM.forward.example",$$slots:{default:[nn]},$$scope:{ctx:v}}}),Fe=new S({props:{title:"BioGptForTokenClassification",local:"transformers.BioGptForTokenClassification",headingTag:"h2"}}),Ue=new V({props:{name:"class transformers.BioGptForTokenClassification",anchor:"transformers.BioGptForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.BioGptForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig">~BioGptConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L846"}}),We=new V({props:{name:"forward",anchor:"transformers.BioGptForTokenClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BioGptForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>({0})</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BioGptForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.BioGptForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BioGptForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>({0}, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.BioGptForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.BioGptForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BioGptForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BioGptForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BioGptForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L868",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig"
>BioGptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ee=new Ht({props:{$$slots:{default:[sn]},$$scope:{ctx:v}}}),te=new st({props:{anchor:"transformers.BioGptForTokenClassification.forward.example",$$slots:{default:[an]},$$scope:{ctx:v}}}),qe=new S({props:{title:"BioGptForSequenceClassification",local:"transformers.BioGptForSequenceClassification",headingTag:"h2"}}),Ze=new V({props:{name:"class transformers.BioGptForSequenceClassification",anchor:"transformers.BioGptForSequenceClassification",parameters:[{name:"config",val:": BioGptConfig"}],parametersDescription:[{anchor:"transformers.BioGptForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig">~BioGptConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L938"}}),Ie=new V({props:{name:"forward",anchor:"transformers.BioGptForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BioGptForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>({0})</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BioGptForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.BioGptForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BioGptForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>({0}, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.BioGptForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.BioGptForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BioGptForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BioGptForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BioGptForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L963",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig"
>BioGptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),oe=new Ht({props:{$$slots:{default:[rn]},$$scope:{ctx:v}}}),ne=new st({props:{anchor:"transformers.BioGptForSequenceClassification.forward.example",$$slots:{default:[dn]},$$scope:{ctx:v}}}),se=new st({props:{anchor:"transformers.BioGptForSequenceClassification.forward.example-2",$$slots:{default:[ln]},$$scope:{ctx:v}}}),He=new Do({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/biogpt.md"}}),{c(){n=p("meta"),M=a(),l=p("p"),d=a(),u(T.$$.fragment),t=a(),u(k.$$.fragment),it=a(),ae=p("p"),ae.innerHTML=bo,dt=a(),re=p("p"),re.textContent=yo,lt=a(),ie=p("p"),ie.innerHTML=To,ct=a(),de=p("p"),de.innerHTML=Mo,pt=a(),u(le.$$.fragment),mt=a(),ce=p("ul"),ce.innerHTML=ko,ut=a(),u(pe.$$.fragment),ht=a(),me=p("p"),me.innerHTML=vo,ft=a(),ue=p("p"),ue.innerHTML=wo,gt=a(),u(he.$$.fragment),_t=a(),fe=p("p"),fe.innerHTML=$o,bt=a(),ge=p("p"),ge.innerHTML=Co,yt=a(),_e=p("table"),_e.innerHTML=Bo,Tt=a(),be=p("p"),be.innerHTML=Go,Mt=a(),ye=p("table"),ye.innerHTML=xo,kt=a(),u(Te.$$.fragment),vt=a(),Me=p("ul"),Me.innerHTML=Jo,wt=a(),u(ke.$$.fragment),$t=a(),B=p("div"),u(ve.$$.fragment),Nt=a(),Re=p("p"),Re.innerHTML=jo,Rt=a(),Le=p("p"),Le.innerHTML=zo,Lt=a(),u(Y.$$.fragment),Ct=a(),u(we.$$.fragment),Bt=a(),G=p("div"),u($e.$$.fragment),Vt=a(),Ve=p("p"),Ve.textContent=Fo,St=a(),Se=p("p"),Se.innerHTML=Uo,Et=a(),Ee=p("div"),u(Ce.$$.fragment),Gt=a(),u(Be.$$.fragment),xt=a(),W=p("div"),u(Ge.$$.fragment),Pt=a(),Pe=p("p"),Pe.innerHTML=Wo,Qt=a(),z=p("div"),u(xe.$$.fragment),Xt=a(),Qe=p("p"),Qe.innerHTML=qo,Yt=a(),u(A.$$.fragment),At=a(),u(O.$$.fragment),Jt=a(),u(Je.$$.fragment),jt=a(),q=p("div"),u(je.$$.fragment),Ot=a(),Xe=p("p"),Xe.innerHTML=Zo,Dt=a(),F=p("div"),u(ze.$$.fragment),Kt=a(),Ye=p("p"),Ye.innerHTML=Io,eo=a(),u(D.$$.fragment),to=a(),u(K.$$.fragment),zt=a(),u(Fe.$$.fragment),Ft=a(),x=p("div"),u(Ue.$$.fragment),oo=a(),Ae=p("p"),Ae.textContent=Ho,no=a(),Oe=p("p"),Oe.innerHTML=No,so=a(),U=p("div"),u(We.$$.fragment),ao=a(),De=p("p"),De.innerHTML=Ro,ro=a(),u(ee.$$.fragment),io=a(),u(te.$$.fragment),Ut=a(),u(qe.$$.fragment),Wt=a(),w=p("div"),u(Ze.$$.fragment),lo=a(),Ke=p("p"),Ke.textContent=Lo,co=a(),et=p("p"),et.innerHTML=Vo,po=a(),tt=p("p"),tt.innerHTML=So,mo=a(),ot=p("p"),ot.innerHTML=Eo,uo=a(),C=p("div"),u(Ie.$$.fragment),ho=a(),nt=p("p"),nt.innerHTML=Po,fo=a(),u(oe.$$.fragment),go=a(),u(ne.$$.fragment),_o=a(),u(se.$$.fragment),qt=a(),u(He.$$.fragment),Zt=a(),at=p("p"),this.h()},l(e){const o=Oo("svelte-u9bgzb",document.head);n=m(o,"META",{name:!0,content:!0}),o.forEach(s),M=r(e),l=m(e,"P",{}),J(l).forEach(s),d=r(e),h(T.$$.fragment,e),t=r(e),h(k.$$.fragment,e),it=r(e),ae=m(e,"P",{"data-svelte-h":!0}),y(ae)!=="svelte-sog51v"&&(ae.innerHTML=bo),dt=r(e),re=m(e,"P",{"data-svelte-h":!0}),y(re)!=="svelte-vfdo9a"&&(re.textContent=yo),lt=r(e),ie=m(e,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-ihk4bt"&&(ie.innerHTML=To),ct=r(e),de=m(e,"P",{"data-svelte-h":!0}),y(de)!=="svelte-fg0afc"&&(de.innerHTML=Mo),pt=r(e),h(le.$$.fragment,e),mt=r(e),ce=m(e,"UL",{"data-svelte-h":!0}),y(ce)!=="svelte-1gszp1d"&&(ce.innerHTML=ko),ut=r(e),h(pe.$$.fragment,e),ht=r(e),me=m(e,"P",{"data-svelte-h":!0}),y(me)!=="svelte-1cid2pe"&&(me.innerHTML=vo),ft=r(e),ue=m(e,"P",{"data-svelte-h":!0}),y(ue)!=="svelte-1x11lxg"&&(ue.innerHTML=wo),gt=r(e),h(he.$$.fragment,e),_t=r(e),fe=m(e,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-py1kac"&&(fe.innerHTML=$o),bt=r(e),ge=m(e,"P",{"data-svelte-h":!0}),y(ge)!=="svelte-djb2w0"&&(ge.innerHTML=Co),yt=r(e),_e=m(e,"TABLE",{"data-svelte-h":!0}),y(_e)!=="svelte-w87fz0"&&(_e.innerHTML=Bo),Tt=r(e),be=m(e,"P",{"data-svelte-h":!0}),y(be)!=="svelte-11n437x"&&(be.innerHTML=Go),Mt=r(e),ye=m(e,"TABLE",{"data-svelte-h":!0}),y(ye)!=="svelte-1f4dimm"&&(ye.innerHTML=xo),kt=r(e),h(Te.$$.fragment,e),vt=r(e),Me=m(e,"UL",{"data-svelte-h":!0}),y(Me)!=="svelte-162aebv"&&(Me.innerHTML=Jo),wt=r(e),h(ke.$$.fragment,e),$t=r(e),B=m(e,"DIV",{class:!0});var Z=J(B);h(ve.$$.fragment,Z),Nt=r(Z),Re=m(Z,"P",{"data-svelte-h":!0}),y(Re)!=="svelte-17rw8ci"&&(Re.innerHTML=jo),Rt=r(Z),Le=m(Z,"P",{"data-svelte-h":!0}),y(Le)!=="svelte-o55m63"&&(Le.innerHTML=zo),Lt=r(Z),h(Y.$$.fragment,Z),Z.forEach(s),Ct=r(e),h(we.$$.fragment,e),Bt=r(e),G=m(e,"DIV",{class:!0});var I=J(G);h($e.$$.fragment,I),Vt=r(I),Ve=m(I,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-rkichk"&&(Ve.textContent=Fo),St=r(I),Se=m(I,"P",{"data-svelte-h":!0}),y(Se)!=="svelte-1c3t5ty"&&(Se.innerHTML=Uo),Et=r(I),Ee=m(I,"DIV",{class:!0});var rt=J(Ee);h(Ce.$$.fragment,rt),rt.forEach(s),I.forEach(s),Gt=r(e),h(Be.$$.fragment,e),xt=r(e),W=m(e,"DIV",{class:!0});var Q=J(W);h(Ge.$$.fragment,Q),Pt=r(Q),Pe=m(Q,"P",{"data-svelte-h":!0}),y(Pe)!=="svelte-qardyf"&&(Pe.innerHTML=Wo),Qt=r(Q),z=m(Q,"DIV",{class:!0});var H=J(z);h(xe.$$.fragment,H),Xt=r(H),Qe=m(H,"P",{"data-svelte-h":!0}),y(Qe)!=="svelte-1nkwh4q"&&(Qe.innerHTML=qo),Yt=r(H),h(A.$$.fragment,H),At=r(H),h(O.$$.fragment,H),H.forEach(s),Q.forEach(s),Jt=r(e),h(Je.$$.fragment,e),jt=r(e),q=m(e,"DIV",{class:!0});var X=J(q);h(je.$$.fragment,X),Ot=r(X),Xe=m(X,"P",{"data-svelte-h":!0}),y(Xe)!=="svelte-f4sq5v"&&(Xe.innerHTML=Zo),Dt=r(X),F=m(X,"DIV",{class:!0});var N=J(F);h(ze.$$.fragment,N),Kt=r(N),Ye=m(N,"P",{"data-svelte-h":!0}),y(Ye)!=="svelte-7kyte"&&(Ye.innerHTML=Io),eo=r(N),h(D.$$.fragment,N),to=r(N),h(K.$$.fragment,N),N.forEach(s),X.forEach(s),zt=r(e),h(Fe.$$.fragment,e),Ft=r(e),x=m(e,"DIV",{class:!0});var R=J(x);h(Ue.$$.fragment,R),oo=r(R),Ae=m(R,"P",{"data-svelte-h":!0}),y(Ae)!=="svelte-18enhwc"&&(Ae.textContent=Ho),no=r(R),Oe=m(R,"P",{"data-svelte-h":!0}),y(Oe)!=="svelte-68lg8f"&&(Oe.innerHTML=No),so=r(R),U=m(R,"DIV",{class:!0});var L=J(U);h(We.$$.fragment,L),ao=r(L),De=m(L,"P",{"data-svelte-h":!0}),y(De)!=="svelte-14znva4"&&(De.innerHTML=Ro),ro=r(L),h(ee.$$.fragment,L),io=r(L),h(te.$$.fragment,L),L.forEach(s),R.forEach(s),Ut=r(e),h(qe.$$.fragment,e),Wt=r(e),w=m(e,"DIV",{class:!0});var $=J(w);h(Ze.$$.fragment,$),lo=r($),Ke=m($,"P",{"data-svelte-h":!0}),y(Ke)!=="svelte-1u6ikyr"&&(Ke.textContent=Lo),co=r($),et=m($,"P",{"data-svelte-h":!0}),y(et)!=="svelte-1xohaar"&&(et.innerHTML=Vo),po=r($),tt=m($,"P",{"data-svelte-h":!0}),y(tt)!=="svelte-wtyfap"&&(tt.innerHTML=So),mo=r($),ot=m($,"P",{"data-svelte-h":!0}),y(ot)!=="svelte-68lg8f"&&(ot.innerHTML=Eo),uo=r($),C=m($,"DIV",{class:!0});var E=J(C);h(Ie.$$.fragment,E),ho=r(E),nt=m(E,"P",{"data-svelte-h":!0}),y(nt)!=="svelte-1ntan9y"&&(nt.innerHTML=Po),fo=r(E),h(oe.$$.fragment,E),go=r(E),h(ne.$$.fragment,E),_o=r(E),h(se.$$.fragment,E),E.forEach(s),$.forEach(s),qt=r(e),h(He.$$.fragment,e),Zt=r(e),at=m(e,"P",{}),J(at).forEach(s),this.h()},h(){j(n,"name","hf:doc:metadata"),j(n,"content",pn),j(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){c(document.head,n),i(e,M,o),i(e,l,o),i(e,d,o),f(T,e,o),i(e,t,o),f(k,e,o),i(e,it,o),i(e,ae,o),i(e,dt,o),i(e,re,o),i(e,lt,o),i(e,ie,o),i(e,ct,o),i(e,de,o),i(e,pt,o),f(le,e,o),i(e,mt,o),i(e,ce,o),i(e,ut,o),f(pe,e,o),i(e,ht,o),i(e,me,o),i(e,ft,o),i(e,ue,o),i(e,gt,o),f(he,e,o),i(e,_t,o),i(e,fe,o),i(e,bt,o),i(e,ge,o),i(e,yt,o),i(e,_e,o),i(e,Tt,o),i(e,be,o),i(e,Mt,o),i(e,ye,o),i(e,kt,o),f(Te,e,o),i(e,vt,o),i(e,Me,o),i(e,wt,o),f(ke,e,o),i(e,$t,o),i(e,B,o),f(ve,B,null),c(B,Nt),c(B,Re),c(B,Rt),c(B,Le),c(B,Lt),f(Y,B,null),i(e,Ct,o),f(we,e,o),i(e,Bt,o),i(e,G,o),f($e,G,null),c(G,Vt),c(G,Ve),c(G,St),c(G,Se),c(G,Et),c(G,Ee),f(Ce,Ee,null),i(e,Gt,o),f(Be,e,o),i(e,xt,o),i(e,W,o),f(Ge,W,null),c(W,Pt),c(W,Pe),c(W,Qt),c(W,z),f(xe,z,null),c(z,Xt),c(z,Qe),c(z,Yt),f(A,z,null),c(z,At),f(O,z,null),i(e,Jt,o),f(Je,e,o),i(e,jt,o),i(e,q,o),f(je,q,null),c(q,Ot),c(q,Xe),c(q,Dt),c(q,F),f(ze,F,null),c(F,Kt),c(F,Ye),c(F,eo),f(D,F,null),c(F,to),f(K,F,null),i(e,zt,o),f(Fe,e,o),i(e,Ft,o),i(e,x,o),f(Ue,x,null),c(x,oo),c(x,Ae),c(x,no),c(x,Oe),c(x,so),c(x,U),f(We,U,null),c(U,ao),c(U,De),c(U,ro),f(ee,U,null),c(U,io),f(te,U,null),i(e,Ut,o),f(qe,e,o),i(e,Wt,o),i(e,w,o),f(Ze,w,null),c(w,lo),c(w,Ke),c(w,co),c(w,et),c(w,po),c(w,tt),c(w,mo),c(w,ot),c(w,uo),c(w,C),f(Ie,C,null),c(C,ho),c(C,nt),c(C,fo),f(oe,C,null),c(C,go),f(ne,C,null),c(C,_o),f(se,C,null),i(e,qt,o),f(He,e,o),i(e,Zt,o),i(e,at,o),It=!0},p(e,[o]){const Z={};o&2&&(Z.$$scope={dirty:o,ctx:e}),Y.$set(Z);const I={};o&2&&(I.$$scope={dirty:o,ctx:e}),A.$set(I);const rt={};o&2&&(rt.$$scope={dirty:o,ctx:e}),O.$set(rt);const Q={};o&2&&(Q.$$scope={dirty:o,ctx:e}),D.$set(Q);const H={};o&2&&(H.$$scope={dirty:o,ctx:e}),K.$set(H);const X={};o&2&&(X.$$scope={dirty:o,ctx:e}),ee.$set(X);const N={};o&2&&(N.$$scope={dirty:o,ctx:e}),te.$set(N);const R={};o&2&&(R.$$scope={dirty:o,ctx:e}),oe.$set(R);const L={};o&2&&(L.$$scope={dirty:o,ctx:e}),ne.$set(L);const $={};o&2&&($.$$scope={dirty:o,ctx:e}),se.$set($)},i(e){It||(g(T.$$.fragment,e),g(k.$$.fragment,e),g(le.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(Te.$$.fragment,e),g(ke.$$.fragment,e),g(ve.$$.fragment,e),g(Y.$$.fragment,e),g(we.$$.fragment,e),g($e.$$.fragment,e),g(Ce.$$.fragment,e),g(Be.$$.fragment,e),g(Ge.$$.fragment,e),g(xe.$$.fragment,e),g(A.$$.fragment,e),g(O.$$.fragment,e),g(Je.$$.fragment,e),g(je.$$.fragment,e),g(ze.$$.fragment,e),g(D.$$.fragment,e),g(K.$$.fragment,e),g(Fe.$$.fragment,e),g(Ue.$$.fragment,e),g(We.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(qe.$$.fragment,e),g(Ze.$$.fragment,e),g(Ie.$$.fragment,e),g(oe.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(He.$$.fragment,e),It=!0)},o(e){_(T.$$.fragment,e),_(k.$$.fragment,e),_(le.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(Te.$$.fragment,e),_(ke.$$.fragment,e),_(ve.$$.fragment,e),_(Y.$$.fragment,e),_(we.$$.fragment,e),_($e.$$.fragment,e),_(Ce.$$.fragment,e),_(Be.$$.fragment,e),_(Ge.$$.fragment,e),_(xe.$$.fragment,e),_(A.$$.fragment,e),_(O.$$.fragment,e),_(Je.$$.fragment,e),_(je.$$.fragment,e),_(ze.$$.fragment,e),_(D.$$.fragment,e),_(K.$$.fragment,e),_(Fe.$$.fragment,e),_(Ue.$$.fragment,e),_(We.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(qe.$$.fragment,e),_(Ze.$$.fragment,e),_(Ie.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(He.$$.fragment,e),It=!1},d(e){e&&(s(M),s(l),s(d),s(t),s(it),s(ae),s(dt),s(re),s(lt),s(ie),s(ct),s(de),s(pt),s(mt),s(ce),s(ut),s(ht),s(me),s(ft),s(ue),s(gt),s(_t),s(fe),s(bt),s(ge),s(yt),s(_e),s(Tt),s(be),s(Mt),s(ye),s(kt),s(vt),s(Me),s(wt),s($t),s(B),s(Ct),s(Bt),s(G),s(Gt),s(xt),s(W),s(Jt),s(jt),s(q),s(zt),s(Ft),s(x),s(Ut),s(Wt),s(w),s(qt),s(Zt),s(at)),s(n),b(T,e),b(k,e),b(le,e),b(pe,e),b(he,e),b(Te,e),b(ke,e),b(ve),b(Y),b(we,e),b($e),b(Ce),b(Be,e),b(Ge),b(xe),b(A),b(O),b(Je,e),b(je),b(ze),b(D),b(K),b(Fe,e),b(Ue),b(We),b(ee),b(te),b(qe,e),b(Ze),b(Ie),b(oe),b(ne),b(se),b(He,e)}}}const pn='{"title":"BioGPT","local":"biogpt","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Using Scaled Dot Product Attention (SDPA)","local":"using-scaled-dot-product-attention-sdpa","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"BioGptConfig","local":"transformers.BioGptConfig","sections":[],"depth":2},{"title":"BioGptTokenizer","local":"transformers.BioGptTokenizer","sections":[],"depth":2},{"title":"BioGptModel","local":"transformers.BioGptModel","sections":[],"depth":2},{"title":"BioGptForCausalLM","local":"transformers.BioGptForCausalLM","sections":[],"depth":2},{"title":"BioGptForTokenClassification","local":"transformers.BioGptForTokenClassification","sections":[],"depth":2},{"title":"BioGptForSequenceClassification","local":"transformers.BioGptForSequenceClassification","sections":[],"depth":2}],"depth":1}';function mn(v){return Xo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tn extends Yo{constructor(n){super(),Ao(this,n,mn,cn,Qo,{})}}export{Tn as component};
