import{s as yl,o as wl,n as Jl}from"../chunks/scheduler.9bc65507.js";import{S as fl,i as bl,g as p,s as t,r as o,A as Tl,h as i,f as n,c as e,j as ul,u as c,x as r,k as In,y as Ul,a as l,v as h,d as j,t as d,w as m}from"../chunks/index.707bf1b6.js";import{T as Cl}from"../chunks/Tip.c2ecdbf4.js";import{C as M}from"../chunks/CodeBlock.54a9f38d.js";import{D as Il}from"../chunks/DocNotebookDropdown.3e6b3817.js";import{H as T}from"../chunks/Heading.342b1fa6.js";function _l(Ds){let g,U="The task illustrated in this tutorial is supported by the following model architectures:",w,u,J='<a href="../model_doc/layoutlm">LayoutLM</a>, <a href="../model_doc/layoutlmv2">LayoutLMv2</a>, <a href="../model_doc/layoutlmv3">LayoutLMv3</a>';return{c(){g=p("p"),g.textContent=U,w=t(),u=p("p"),u.innerHTML=J},l(x){g=i(x,"P",{"data-svelte-h":!0}),r(g)!=="svelte-6l5sa6"&&(g.textContent=U),w=e(x),u=i(x,"P",{"data-svelte-h":!0}),r(u)!=="svelte-4nltzx"&&(u.innerHTML=J)},m(x,y){l(x,g,y),l(x,w,y),l(x,u,y)},p:Jl,d(x){x&&(n(g),n(w),n(u))}}}function kl(Ds){let g,U,w,u,J,x,y,Ks,C,_n=`Document Question Answering, also referred to as Document Visual Question Answering, is a task that involves providing
answers to questions posed about document images. The input to models supporting this task is typically a combination of an image and
a question, and the output is an answer expressed in natural language. These models utilize multiple modalities, including
text, the positions of words (bounding boxes), and the image itself.`,Os,I,kn="This guide illustrates how to:",sa,_,Zn='<li>Fine-tune <a href="../model_doc/layoutlmv2">LayoutLMv2</a> on the <a href="https://huggingface.co/datasets/nielsr/docvqa_1200_examples_donut" rel="nofollow">DocVQA dataset</a>.</li> <li>Use your fine-tuned model for inference.</li>',aa,f,na,k,vn=`LayoutLMv2 solves the document question-answering task by adding a question-answering head on top of the final hidden
states of the tokens, to predict the positions of the start and end tokens of the
answer. In other words, the problem is treated as extractive question answering: given the context, extract which piece
of information answers the question. The context comes from the output of an OCR engine, here it is Google’s Tesseract.`,la,Z,Rn="Before you begin, make sure you have all the necessary libraries installed. LayoutLMv2 depends on detectron2, torchvision and tesseract.",ta,v,ea,R,pa,X,ia,A,Xn="Once you have installed all of the dependencies, restart your runtime.",ra,$,An=`We encourage you to share your model with the community. Log in to your Hugging Face account to upload it to the 🤗 Hub.
When prompted, enter your token to log in:`,oa,G,ca,B,$n="Let’s define some global variables.",ha,W,ja,N,da,V,Gn=`In this guide we use a small sample of preprocessed DocVQA that you can find on 🤗 Hub. If you’d like to use the full
DocVQA dataset, you can register and download it on <a href="https://rrc.cvc.uab.es/?ch=17" rel="nofollow">DocVQA homepage</a>. If you do so, to
proceed with this guide check out <a href="https://huggingface.co/docs/datasets/loading#local-and-remote-files" rel="nofollow">how to load files into a 🤗 dataset</a>.`,ma,F,Ma,Q,Bn=`As you can see, the dataset is split into train and test sets already. Take a look at a random example to familiarize
yourself with the features.`,ga,E,xa,z,Wn="Here’s what the individual fields represent:",ua,q,Nn="<li><code>id</code>: the example’s id</li> <li><code>image</code>: a PIL.Image.Image object containing the document image</li> <li><code>query</code>: the question string - natural language asked question, in several languages</li> <li><code>answers</code>: a list of correct answers provided by human annotators</li> <li><code>words</code> and <code>bounding_boxes</code>: the results of OCR, which we will not use here</li> <li><code>answer</code>: an answer matched by a different model which we will not use here</li>",ya,Y,Vn=`Let’s leave only English questions, and drop the <code>answer</code> feature which appears to contain predictions by another model.
We’ll also take the first of the answers from the set provided by the annotators. Alternatively, you can randomly sample it.`,wa,H,Ja,S,Fn=`Note that the LayoutLMv2 checkpoint that we use in this guide has been trained with <code>max_position_embeddings = 512</code> (you can
find this information in the <a href="https://huggingface.co/microsoft/layoutlmv2-base-uncased/blob/main/config.json#L18" rel="nofollow">checkpoint’s <code>config.json</code> file</a>).
We can truncate the examples but to avoid the situation where the answer might be at the end of a large document and end up truncated,
here we’ll remove the few examples where the embedding is likely to end up longer than 512.
If most of the documents in your dataset are long, you can implement a sliding window strategy - check out <a href="https://github.com/huggingface/notebooks/blob/main/examples/question_answering.ipynb" rel="nofollow">this notebook</a> for details.`,fa,L,ba,P,Qn=`At this point let’s also remove the OCR features from this dataset. These are a result of OCR for fine-tuning a different
model. They would still require some processing if we wanted to use them, as they do not match the input requirements
of the model we use in this guide. Instead, we can use the <a href="/docs/transformers/v4.37.2/en/model_doc/layoutlmv2#transformers.LayoutLMv2Processor">LayoutLMv2Processor</a> on the original data for both OCR and
tokenization. This way we’ll get the inputs that match model’s expected input. If you want to process images manually,
check out the <a href="../model_doc/layoutlmv2"><code>LayoutLMv2</code> model documentation</a> to learn what input format the model expects.`,Ta,D,Ua,K,En="Finally, the data exploration won’t be complete if we don’t peek at an image example.",Ca,O,Ia,b,zn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/docvqa_example.jpg" alt="DocVQA Image Example"/>',_a,ss,ka,as,qn=`The Document Question Answering task is a multimodal task, and you need to make sure that the inputs from each modality
are preprocessed according to the model’s expectations. Let’s start by loading the <a href="/docs/transformers/v4.37.2/en/model_doc/layoutlmv2#transformers.LayoutLMv2Processor">LayoutLMv2Processor</a>, which internally combines an image processor that can handle image data and a tokenizer that can encode text data.`,Za,ns,va,ls,Ra,ts,Yn=`First, let’s prepare the document images for the model with the help of the <code>image_processor</code> from the processor.
By default, image processor resizes the images to 224x224, makes sure they have the correct order of color channels,
applies OCR with tesseract to get words and normalized bounding boxes. In this tutorial, all of these defaults are exactly what we need.
Write a function that applies the default image processing to a batch of images and returns the results of OCR.`,Xa,es,Aa,ps,Hn='To apply this preprocessing to the entire dataset in a fast way, use <a href="https://huggingface.co/docs/datasets/v2.16.1/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a>.',$a,is,Ga,rs,Ba,os,Sn=`Once we have applied OCR to the images, we need to encode the text part of the dataset to prepare it for the model.
This involves converting the words and boxes that we got in the previous step to token-level <code>input_ids</code>, <code>attention_mask</code>,
<code>token_type_ids</code> and <code>bbox</code>. For preprocessing text, we’ll need the <code>tokenizer</code> from the processor.`,Wa,cs,Na,hs,Ln=`On top of the preprocessing mentioned above, we also need to add the labels for the model. For <code>xxxForQuestionAnswering</code> models
in 🤗 Transformers, the labels consist of the <code>start_positions</code> and <code>end_positions</code>, indicating which token is at the
start and which token is at the end of the answer.`,Va,js,Pn="Let’s start with that. Define a helper function that can find a sublist (the answer split into words) in a larger list (the words list).",Fa,ds,Dn=`This function will take two lists as input, <code>words_list</code> and <code>answer_list</code>. It will then iterate over the <code>words_list</code> and check
if the current word in the <code>words_list</code> (words_list[i]) is equal to the first word of answer_list (answer_list[0]) and if
the sublist of <code>words_list</code> starting from the current word and of the same length as <code>answer_list</code> is equal <code>to answer_list</code>.
If this condition is true, it means that a match has been found, and the function will record the match, its starting index (idx),
and its ending index (idx + len(answer_list) - 1). If more than one match was found, the function will return only the first one.
If no match is found, the function returns (<code>None</code>, 0, and 0).`,Qa,ms,Ea,Ms,Kn="To illustrate how this function finds the position of the answer, let’s use it on an example:",za,gs,qa,xs,On="Once examples are encoded, however, they will look like this:",Ya,us,Ha,ys,sl="We’ll need to find the position of the answer in the encoded input.",Sa,ws,al=`<li><code>token_type_ids</code> tells us which tokens are part of the question, and which ones are part of the document’s words.</li> <li><code>tokenizer.cls_token_id</code> will help find the special token at the beginning of the input.</li> <li><code>word_ids</code> will help match the answer found in the original <code>words</code> to the same answer in the full encoded input and determine
the start/end position of the answer in the encoded input.</li>`,La,Js,nl="With that in mind, let’s create a function to encode a batch of examples in the dataset:",Pa,fs,Da,bs,ll="Now that we have this preprocessing function, we can encode the entire dataset:",Ka,Ts,Oa,Us,tl="Let’s check what the features of the encoded dataset look like:",sn,Cs,an,Is,nn,_s,el=`Evaluation for document question answering requires a significant amount of postprocessing. To avoid taking up too much
of your time, this guide skips the evaluation step. The <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer">Trainer</a> still calculates the evaluation loss during training so
you’re not completely in the dark about your model’s performance. Extractive question answering is typically evaluated using F1/exact match.
If you’d like to implement it yourself, check out the <a href="https://huggingface.co/course/chapter7/7?fw=pt#postprocessing" rel="nofollow">Question Answering chapter</a>
of the Hugging Face course for inspiration.`,ln,ks,tn,Zs,pl=`Congratulations! You’ve successfully navigated the toughest part of this guide and now you are ready to train your own model.
Training involves the following steps:`,en,vs,il='<li>Load the model with <a href="/docs/transformers/v4.37.2/en/model_doc/auto#transformers.AutoModelForDocumentQuestionAnswering">AutoModelForDocumentQuestionAnswering</a> using the same checkpoint as in the preprocessing.</li> <li>Define your training hyperparameters in <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>.</li> <li>Define a function to batch examples together, here the <a href="/docs/transformers/v4.37.2/en/main_classes/data_collator#transformers.DefaultDataCollator">DefaultDataCollator</a> will do just fine</li> <li>Pass the training arguments to <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer">Trainer</a> along with the model, dataset, and data collator.</li> <li>Call <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer.train">train()</a> to finetune your model.</li>',pn,Rs,rn,Xs,rl=`In the <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> use <code>output_dir</code> to specify where to save your model, and configure hyperparameters as you see fit.
If you wish to share your model with the community, set <code>push_to_hub</code> to <code>True</code> (you must be signed in to Hugging Face to upload your model).
In this case the <code>output_dir</code> will also be the name of the repo where your model checkpoint will be pushed.`,on,As,cn,$s,ol="Define a simple data collator to batch examples together.",hn,Gs,jn,Bs,cl='Finally, bring everything together, and call <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer.train">train()</a>:',dn,Ws,mn,Ns,hl="To add the final model to 🤗 Hub, create a model card and call <code>push_to_hub</code>:",Mn,Vs,gn,Fs,xn,Qs,jl=`Now that you have finetuned a LayoutLMv2 model, and uploaded it to the 🤗 Hub, you can use it for inference. The simplest
way to try out your finetuned model for inference is to use it in a <a href="/docs/transformers/v4.37.2/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a>.`,un,Es,dl="Let’s take an example:",yn,zs,wn,qs,ml=`Next, instantiate a pipeline for
document question answering with your model, and pass the image + question combination to it.`,Jn,Ys,fn,Hs,Ml="You can also manually replicate the results of the pipeline if you’d like:",bn,Ss,gl=`<li>Take an image and a question, prepare them for the model using the processor from your model.</li> <li>Forward the result or preprocessing through the model.</li> <li>The model returns <code>start_logits</code> and <code>end_logits</code>, which indicate which token is at the start of the answer and
which token is at the end of the answer. Both have shape (batch_size, sequence_length).</li> <li>Take an argmax on the last dimension of both the <code>start_logits</code> and <code>end_logits</code> to get the predicted <code>start_idx</code> and <code>end_idx</code>.</li> <li>Decode the answer with the tokenizer.</li>`,Tn,Ls,Un,Ps,Cn;return J=new T({props:{title:"Document Question Answering",local:"document-question-answering",headingTag:"h1"}}),y=new Il({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/document_question_answering.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/document_question_answering.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/document_question_answering.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/document_question_answering.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/document_question_answering.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/document_question_answering.ipynb"}]}}),f=new Cl({props:{$$slots:{default:[_l]},$$scope:{ctx:Ds}}}),v=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJzJTIwZGF0YXNldHM=",highlighted:"pip install -q transformers datasets",wrap:!1}}),R=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZmYWNlYm9va3Jlc2VhcmNoJTJGZGV0ZWN0cm9uMi5naXQnJTBBcGlwJTIwaW5zdGFsbCUyMHRvcmNodmlzaW9u",highlighted:`pip install <span class="hljs-string">&#x27;git+https://github.com/facebookresearch/detectron2.git&#x27;</span>
pip install torchvision`,wrap:!1}}),X=new M({props:{code:"c3VkbyUyMGFwdCUyMGluc3RhbGwlMjB0ZXNzZXJhY3Qtb2NyJTBBcGlwJTIwaW5zdGFsbCUyMC1xJTIwcHl0ZXNzZXJhY3Q=",highlighted:`sudo apt install tesseract-ocr
pip install -q pytesseract`,wrap:!1}}),G=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),W=new M({props:{code:"bW9kZWxfY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRmxheW91dGxtdjItYmFzZS11bmNhc2VkJTIyJTBBYmF0Y2hfc2l6ZSUyMCUzRCUyMDQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;microsoft/layoutlmv2-base-uncased&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-number">4</span>`,wrap:!1}}),N=new T({props:{title:"Load the data",local:"load-the-data",headingTag:"h2"}}),F=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJuaWVsc3IlMkZkb2N2cWFfMTIwMF9leGFtcGxlcyUyMiklMEFkYXRhc2V0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;nielsr/docvqa_1200_examples&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;id&#x27;</span>, <span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;query&#x27;</span>, <span class="hljs-string">&#x27;answers&#x27;</span>, <span class="hljs-string">&#x27;words&#x27;</span>, <span class="hljs-string">&#x27;bounding_boxes&#x27;</span>, <span class="hljs-string">&#x27;answer&#x27;</span>],
        num_rows: <span class="hljs-number">1000</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;id&#x27;</span>, <span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;query&#x27;</span>, <span class="hljs-string">&#x27;answers&#x27;</span>, <span class="hljs-string">&#x27;words&#x27;</span>, <span class="hljs-string">&#x27;bounding_boxes&#x27;</span>, <span class="hljs-string">&#x27;answer&#x27;</span>],
        num_rows: <span class="hljs-number">200</span>
    })
})`,wrap:!1}}),E=new M({props:{code:"ZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELmZlYXR1cmVz",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;train&quot;</span>].features',wrap:!1}}),H=new M({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwZXhhbXBsZSUzQSUyMCU3QiUyMnF1ZXN0aW9uJTIyJTNBJTIwZXhhbXBsZSU1QiUyMnF1ZXJ5JTIyJTVEJTVCJTIyZW4lMjIlNUQlN0QlMkMlMjByZW1vdmVfY29sdW1ucyUzRCU1QiUyMnF1ZXJ5JTIyJTVEKSUwQXVwZGF0ZWRfZGF0YXNldCUyMCUzRCUyMHVwZGF0ZWRfZGF0YXNldC5tYXAoJTBBJTIwJTIwJTIwJTIwbGFtYmRhJTIwZXhhbXBsZSUzQSUyMCU3QiUyMmFuc3dlciUyMiUzQSUyMGV4YW1wbGUlNUIlMjJhbnN3ZXJzJTIyJTVEJTVCMCU1RCU3RCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIyYW5zd2VyJTIyJTJDJTIwJTIyYW5zd2VycyUyMiU1RCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> example: {<span class="hljs-string">&quot;question&quot;</span>: example[<span class="hljs-string">&quot;query&quot;</span>][<span class="hljs-string">&quot;en&quot;</span>]}, remove_columns=[<span class="hljs-string">&quot;query&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = updated_dataset.<span class="hljs-built_in">map</span>(
<span class="hljs-meta">... </span>    <span class="hljs-keyword">lambda</span> example: {<span class="hljs-string">&quot;answer&quot;</span>: example[<span class="hljs-string">&quot;answers&quot;</span>][<span class="hljs-number">0</span>]}, remove_columns=[<span class="hljs-string">&quot;answer&quot;</span>, <span class="hljs-string">&quot;answers&quot;</span>]
<span class="hljs-meta">... </span>)`,wrap:!1}}),L=new M({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwdXBkYXRlZF9kYXRhc2V0LmZpbHRlcihsYW1iZGElMjB4JTNBJTIwbGVuKHglNUIlMjJ3b3JkcyUyMiU1RCklMjAlMkIlMjBsZW4oeCU1QiUyMnF1ZXN0aW9uJTIyJTVELnNwbGl0KCkpJTIwJTNDJTIwNTEyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = updated_dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">len</span>(x[<span class="hljs-string">&quot;words&quot;</span>]) + <span class="hljs-built_in">len</span>(x[<span class="hljs-string">&quot;question&quot;</span>].split()) &lt; <span class="hljs-number">512</span>)',wrap:!1}}),D=new M({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwdXBkYXRlZF9kYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCUyMndvcmRzJTIyKSUwQXVwZGF0ZWRfZGF0YXNldCUyMCUzRCUyMHVwZGF0ZWRfZGF0YXNldC5yZW1vdmVfY29sdW1ucyglMjJib3VuZGluZ19ib3hlcyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = updated_dataset.remove_columns(<span class="hljs-string">&quot;words&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = updated_dataset.remove_columns(<span class="hljs-string">&quot;bounding_boxes&quot;</span>)`,wrap:!1}}),O=new M({props:{code:"dXBkYXRlZF9kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlNUIxMSU1RCU1QiUyMmltYWdlJTIyJTVE",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">11</span>][<span class="hljs-string">&quot;image&quot;</span>]',wrap:!1}}),ss=new T({props:{title:"Preprocess the data",local:"preprocess-the-data",headingTag:"h2"}}),ns=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(model_checkpoint)`,wrap:!1}}),ls=new T({props:{title:"Preprocessing document images",local:"preprocessing-document-images",headingTag:"h3"}}),es=new M({props:{code:"aW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29yLmltYWdlX3Byb2Nlc3NvciUwQSUwQSUwQWRlZiUyMGdldF9vY3Jfd29yZHNfYW5kX2JveGVzKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QmltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSUyMGZvciUyMGltYWdlJTIwaW4lMjBleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwZW5jb2RlZF9pbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzKSUwQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIyaW1hZ2UlMjIlNUQlMjAlM0QlMjBlbmNvZGVkX2lucHV0cy5waXhlbF92YWx1ZXMlMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMndvcmRzJTIyJTVEJTIwJTNEJTIwZW5jb2RlZF9pbnB1dHMud29yZHMlMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMmJveGVzJTIyJTVEJTIwJTNEJTIwZW5jb2RlZF9pbnB1dHMuYm94ZXMlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBleGFtcGxlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = processor.image_processor


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_ocr_words_and_boxes</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    images = [image.convert(<span class="hljs-string">&quot;RGB&quot;</span>) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    encoded_inputs = image_processor(images)

<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;image&quot;</span>] = encoded_inputs.pixel_values
<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;words&quot;</span>] = encoded_inputs.words
<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;boxes&quot;</span>] = encoded_inputs.boxes

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),is=new M({props:{code:"ZGF0YXNldF93aXRoX29jciUyMCUzRCUyMHVwZGF0ZWRfZGF0YXNldC5tYXAoZ2V0X29jcl93b3Jkc19hbmRfYm94ZXMlMkMlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0QyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_with_ocr = updated_dataset.<span class="hljs-built_in">map</span>(get_ocr_words_and_boxes, batched=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">2</span>)',wrap:!1}}),rs=new T({props:{title:"Preprocessing text data",local:"preprocessing-text-data",headingTag:"h3"}}),cs=new M({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = processor.tokenizer',wrap:!1}}),ms=new M({props:{code:"ZGVmJTIwc3ViZmluZGVyKHdvcmRzX2xpc3QlMkMlMjBhbnN3ZXJfbGlzdCklM0ElMEElMjAlMjAlMjAlMjBtYXRjaGVzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwc3RhcnRfaW5kaWNlcyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGVuZF9pbmRpY2VzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaWR4JTJDJTIwaSUyMGluJTIwZW51bWVyYXRlKHJhbmdlKGxlbih3b3Jkc19saXN0KSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjB3b3Jkc19saXN0JTVCaSU1RCUyMCUzRCUzRCUyMGFuc3dlcl9saXN0JTVCMCU1RCUyMGFuZCUyMHdvcmRzX2xpc3QlNUJpJTIwJTNBJTIwaSUyMCUyQiUyMGxlbihhbnN3ZXJfbGlzdCklNUQlMjAlM0QlM0QlMjBhbnN3ZXJfbGlzdCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1hdGNoZXMuYXBwZW5kKGFuc3dlcl9saXN0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXJ0X2luZGljZXMuYXBwZW5kKGlkeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmRfaW5kaWNlcy5hcHBlbmQoaWR4JTIwJTJCJTIwbGVuKGFuc3dlcl9saXN0KSUyMC0lMjAxKSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF0Y2hlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMG1hdGNoZXMlNUIwJTVEJTJDJTIwc3RhcnRfaW5kaWNlcyU1QjAlNUQlMkMlMjBlbmRfaW5kaWNlcyU1QjAlNUQlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwTm9uZSUyQyUyMDAlMkMlMjAw",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">subfinder</span>(<span class="hljs-params">words_list, answer_list</span>):
<span class="hljs-meta">... </span>    matches = []
<span class="hljs-meta">... </span>    start_indices = []
<span class="hljs-meta">... </span>    end_indices = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> idx, i <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(<span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(words_list))):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> words_list[i] == answer_list[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> words_list[i : i + <span class="hljs-built_in">len</span>(answer_list)] == answer_list:
<span class="hljs-meta">... </span>            matches.append(answer_list)
<span class="hljs-meta">... </span>            start_indices.append(idx)
<span class="hljs-meta">... </span>            end_indices.append(idx + <span class="hljs-built_in">len</span>(answer_list) - <span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> matches:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> matches[<span class="hljs-number">0</span>], start_indices[<span class="hljs-number">0</span>], end_indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>`,wrap:!1}}),gs=new M({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXRfd2l0aF9vY3IlNUIlMjJ0cmFpbiUyMiU1RCU1QjElNUQlMEF3b3JkcyUyMCUzRCUyMCU1QndvcmQubG93ZXIoKSUyMGZvciUyMHdvcmQlMjBpbiUyMGV4YW1wbGUlNUIlMjJ3b3JkcyUyMiU1RCU1RCUwQW1hdGNoJTJDJTIwd29yZF9pZHhfc3RhcnQlMkMlMjB3b3JkX2lkeF9lbmQlMjAlM0QlMjBzdWJmaW5kZXIod29yZHMlMkMlMjBleGFtcGxlJTVCJTIyYW5zd2VyJTIyJTVELmxvd2VyKCkuc3BsaXQoKSklMEFwcmludCglMjJRdWVzdGlvbiUzQSUyMCUyMiUyQyUyMGV4YW1wbGUlNUIlMjJxdWVzdGlvbiUyMiU1RCklMEFwcmludCglMjJXb3JkcyUzQSUyMiUyQyUyMHdvcmRzKSUwQXByaW50KCUyMkFuc3dlciUzQSUyMCUyMiUyQyUyMGV4YW1wbGUlNUIlMjJhbnN3ZXIlMjIlNUQpJTBBcHJpbnQoJTIyc3RhcnRfaW5kZXglMjIlMkMlMjB3b3JkX2lkeF9zdGFydCklMEFwcmludCglMjJlbmRfaW5kZXglMjIlMkMlMjB3b3JkX2lkeF9lbmQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset_with_ocr[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>words = [word.lower() <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> example[<span class="hljs-string">&quot;words&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">match</span>, word_idx_start, word_idx_end = subfinder(words, example[<span class="hljs-string">&quot;answer&quot;</span>].lower().split())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Question: &quot;</span>, example[<span class="hljs-string">&quot;question&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Words:&quot;</span>, words)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Answer: &quot;</span>, example[<span class="hljs-string">&quot;answer&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;start_index&quot;</span>, word_idx_start)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;end_index&quot;</span>, word_idx_end)
Question:  Who <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span>  cc <span class="hljs-keyword">in</span> this letter?
Words: [<span class="hljs-string">&#x27;wie&#x27;</span>, <span class="hljs-string">&#x27;baw&#x27;</span>, <span class="hljs-string">&#x27;brown&#x27;</span>, <span class="hljs-string">&#x27;&amp;&#x27;</span>, <span class="hljs-string">&#x27;williamson&#x27;</span>, <span class="hljs-string">&#x27;tobacco&#x27;</span>, <span class="hljs-string">&#x27;corporation&#x27;</span>, <span class="hljs-string">&#x27;research&#x27;</span>, <span class="hljs-string">&#x27;&amp;&#x27;</span>, <span class="hljs-string">&#x27;development&#x27;</span>, <span class="hljs-string">&#x27;internal&#x27;</span>, <span class="hljs-string">&#x27;correspondence&#x27;</span>, <span class="hljs-string">&#x27;to:&#x27;</span>, <span class="hljs-string">&#x27;r.&#x27;</span>, <span class="hljs-string">&#x27;h.&#x27;</span>, <span class="hljs-string">&#x27;honeycutt&#x27;</span>, <span class="hljs-string">&#x27;ce:&#x27;</span>, <span class="hljs-string">&#x27;t.f.&#x27;</span>, <span class="hljs-string">&#x27;riehl&#x27;</span>, <span class="hljs-string">&#x27;from:&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;c.j.&#x27;</span>, <span class="hljs-string">&#x27;cook&#x27;</span>, <span class="hljs-string">&#x27;date:&#x27;</span>, <span class="hljs-string">&#x27;may&#x27;</span>, <span class="hljs-string">&#x27;8,&#x27;</span>, <span class="hljs-string">&#x27;1995&#x27;</span>, <span class="hljs-string">&#x27;subject:&#x27;</span>, <span class="hljs-string">&#x27;review&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;existing&#x27;</span>, <span class="hljs-string">&#x27;brainstorming&#x27;</span>, <span class="hljs-string">&#x27;ideas/483&#x27;</span>, <span class="hljs-string">&#x27;the&#x27;</span>, <span class="hljs-string">&#x27;major&#x27;</span>, <span class="hljs-string">&#x27;function&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;the&#x27;</span>, <span class="hljs-string">&#x27;product&#x27;</span>, <span class="hljs-string">&#x27;innovation&#x27;</span>, <span class="hljs-string">&#x27;graup&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-string">&#x27;develop&#x27;</span>, <span class="hljs-string">&#x27;marketable&#x27;</span>, <span class="hljs-string">&#x27;nove!&#x27;</span>, <span class="hljs-string">&#x27;products&#x27;</span>, <span class="hljs-string">&#x27;that&#x27;</span>, <span class="hljs-string">&#x27;would&#x27;</span>, <span class="hljs-string">&#x27;be&#x27;</span>, <span class="hljs-string">&#x27;profitable&#x27;</span>, <span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-string">&#x27;manufacture&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;sell.&#x27;</span>, <span class="hljs-string">&#x27;novel&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;defined&#x27;</span>, <span class="hljs-string">&#x27;as:&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;new&#x27;</span>, <span class="hljs-string">&#x27;kind,&#x27;</span>, <span class="hljs-string">&#x27;or&#x27;</span>, <span class="hljs-string">&#x27;different&#x27;</span>, <span class="hljs-string">&#x27;from&#x27;</span>, <span class="hljs-string">&#x27;anything&#x27;</span>, <span class="hljs-string">&#x27;seen&#x27;</span>, <span class="hljs-string">&#x27;or&#x27;</span>, <span class="hljs-string">&#x27;known&#x27;</span>, <span class="hljs-string">&#x27;before.&#x27;</span>, <span class="hljs-string">&#x27;innovation&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;defined&#x27;</span>, <span class="hljs-string">&#x27;as:&#x27;</span>, <span class="hljs-string">&#x27;something&#x27;</span>, <span class="hljs-string">&#x27;new&#x27;</span>, <span class="hljs-string">&#x27;or&#x27;</span>, <span class="hljs-string">&#x27;different&#x27;</span>, <span class="hljs-string">&#x27;introduced;&#x27;</span>, <span class="hljs-string">&#x27;act&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;innovating;&#x27;</span>, <span class="hljs-string">&#x27;introduction&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;new&#x27;</span>, <span class="hljs-string">&#x27;things&#x27;</span>, <span class="hljs-string">&#x27;or&#x27;</span>, <span class="hljs-string">&#x27;methods.&#x27;</span>, <span class="hljs-string">&#x27;the&#x27;</span>, <span class="hljs-string">&#x27;products&#x27;</span>, <span class="hljs-string">&#x27;may&#x27;</span>, <span class="hljs-string">&#x27;incorporate&#x27;</span>, <span class="hljs-string">&#x27;the&#x27;</span>, <span class="hljs-string">&#x27;latest&#x27;</span>, <span class="hljs-string">&#x27;technologies,&#x27;</span>, <span class="hljs-string">&#x27;materials&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;know-how&#x27;</span>, <span class="hljs-string">&#x27;available&#x27;</span>, <span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-string">&#x27;give&#x27;</span>, <span class="hljs-string">&#x27;then&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;unique&#x27;</span>, <span class="hljs-string">&#x27;taste&#x27;</span>, <span class="hljs-string">&#x27;or&#x27;</span>, <span class="hljs-string">&#x27;look.&#x27;</span>, <span class="hljs-string">&#x27;the&#x27;</span>, <span class="hljs-string">&#x27;first&#x27;</span>, <span class="hljs-string">&#x27;task&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;the&#x27;</span>, <span class="hljs-string">&#x27;product&#x27;</span>, <span class="hljs-string">&#x27;innovation&#x27;</span>, <span class="hljs-string">&#x27;group&#x27;</span>, <span class="hljs-string">&#x27;was&#x27;</span>, <span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-string">&#x27;assemble,&#x27;</span>, <span class="hljs-string">&#x27;review&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;categorize&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;list&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;existing&#x27;</span>, <span class="hljs-string">&#x27;brainstorming&#x27;</span>, <span class="hljs-string">&#x27;ideas.&#x27;</span>, <span class="hljs-string">&#x27;ideas&#x27;</span>, <span class="hljs-string">&#x27;were&#x27;</span>, <span class="hljs-string">&#x27;grouped&#x27;</span>, <span class="hljs-string">&#x27;into&#x27;</span>, <span class="hljs-string">&#x27;two&#x27;</span>, <span class="hljs-string">&#x27;major&#x27;</span>, <span class="hljs-string">&#x27;categories&#x27;</span>, <span class="hljs-string">&#x27;labeled&#x27;</span>, <span class="hljs-string">&#x27;appearance&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;taste/aroma.&#x27;</span>, <span class="hljs-string">&#x27;these&#x27;</span>, <span class="hljs-string">&#x27;categories&#x27;</span>, <span class="hljs-string">&#x27;are&#x27;</span>, <span class="hljs-string">&#x27;used&#x27;</span>, <span class="hljs-string">&#x27;for&#x27;</span>, <span class="hljs-string">&#x27;novel&#x27;</span>, <span class="hljs-string">&#x27;products&#x27;</span>, <span class="hljs-string">&#x27;that&#x27;</span>, <span class="hljs-string">&#x27;may&#x27;</span>, <span class="hljs-string">&#x27;differ&#x27;</span>, <span class="hljs-string">&#x27;from&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;visual&#x27;</span>, <span class="hljs-string">&#x27;and/or&#x27;</span>, <span class="hljs-string">&#x27;taste/aroma&#x27;</span>, <span class="hljs-string">&#x27;point&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;view&#x27;</span>, <span class="hljs-string">&#x27;compared&#x27;</span>, <span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-string">&#x27;canventional&#x27;</span>, <span class="hljs-string">&#x27;cigarettes.&#x27;</span>, <span class="hljs-string">&#x27;other&#x27;</span>, <span class="hljs-string">&#x27;categories&#x27;</span>, <span class="hljs-string">&#x27;include&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;combination&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;the&#x27;</span>, <span class="hljs-string">&#x27;above,&#x27;</span>, <span class="hljs-string">&#x27;filters,&#x27;</span>, <span class="hljs-string">&#x27;packaging&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;brand&#x27;</span>, <span class="hljs-string">&#x27;extensions.&#x27;</span>, <span class="hljs-string">&#x27;appearance&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;category&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;used&#x27;</span>, <span class="hljs-string">&#x27;for&#x27;</span>, <span class="hljs-string">&#x27;novel&#x27;</span>, <span class="hljs-string">&#x27;cigarette&#x27;</span>, <span class="hljs-string">&#x27;constructions&#x27;</span>, <span class="hljs-string">&#x27;that&#x27;</span>, <span class="hljs-string">&#x27;yield&#x27;</span>, <span class="hljs-string">&#x27;visually&#x27;</span>, <span class="hljs-string">&#x27;different&#x27;</span>, <span class="hljs-string">&#x27;products&#x27;</span>, <span class="hljs-string">&#x27;with&#x27;</span>, <span class="hljs-string">&#x27;minimal&#x27;</span>, <span class="hljs-string">&#x27;changes&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;smoke&#x27;</span>, <span class="hljs-string">&#x27;chemistry&#x27;</span>, <span class="hljs-string">&#x27;two&#x27;</span>, <span class="hljs-string">&#x27;cigarettes&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;cne.&#x27;</span>, <span class="hljs-string">&#x27;emulti-plug&#x27;</span>, <span class="hljs-string">&#x27;te&#x27;</span>, <span class="hljs-string">&#x27;build&#x27;</span>, <span class="hljs-string">&#x27;yaur&#x27;</span>, <span class="hljs-string">&#x27;awn&#x27;</span>, <span class="hljs-string">&#x27;cigarette.&#x27;</span>, <span class="hljs-string">&#x27;eswitchable&#x27;</span>, <span class="hljs-string">&#x27;menthol&#x27;</span>, <span class="hljs-string">&#x27;or&#x27;</span>, <span class="hljs-string">&#x27;non&#x27;</span>, <span class="hljs-string">&#x27;menthol&#x27;</span>, <span class="hljs-string">&#x27;cigarette.&#x27;</span>, <span class="hljs-string">&#x27;*cigarettes&#x27;</span>, <span class="hljs-string">&#x27;with&#x27;</span>, <span class="hljs-string">&#x27;interspaced&#x27;</span>, <span class="hljs-string">&#x27;perforations&#x27;</span>, <span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-string">&#x27;enable&#x27;</span>, <span class="hljs-string">&#x27;smoker&#x27;</span>, <span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-string">&#x27;separate&#x27;</span>, <span class="hljs-string">&#x27;unburned&#x27;</span>, <span class="hljs-string">&#x27;section&#x27;</span>, <span class="hljs-string">&#x27;for&#x27;</span>, <span class="hljs-string">&#x27;future&#x27;</span>, <span class="hljs-string">&#x27;smoking.&#x27;</span>, <span class="hljs-string">&#x27;«short&#x27;</span>, <span class="hljs-string">&#x27;cigarette,&#x27;</span>, <span class="hljs-string">&#x27;tobacco&#x27;</span>, <span class="hljs-string">&#x27;section&#x27;</span>, <span class="hljs-string">&#x27;30&#x27;</span>, <span class="hljs-string">&#x27;mm.&#x27;</span>, <span class="hljs-string">&#x27;«extremely&#x27;</span>, <span class="hljs-string">&#x27;fast&#x27;</span>, <span class="hljs-string">&#x27;buming&#x27;</span>, <span class="hljs-string">&#x27;cigarette.&#x27;</span>, <span class="hljs-string">&#x27;«novel&#x27;</span>, <span class="hljs-string">&#x27;cigarette&#x27;</span>, <span class="hljs-string">&#x27;constructions&#x27;</span>, <span class="hljs-string">&#x27;that&#x27;</span>, <span class="hljs-string">&#x27;permit&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;significant&#x27;</span>, <span class="hljs-string">&#x27;reduction&#x27;</span>, <span class="hljs-string">&#x27;iretobacco&#x27;</span>, <span class="hljs-string">&#x27;weight&#x27;</span>, <span class="hljs-string">&#x27;while&#x27;</span>, <span class="hljs-string">&#x27;maintaining&#x27;</span>, <span class="hljs-string">&#x27;smoking&#x27;</span>, <span class="hljs-string">&#x27;mechanics&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;visual&#x27;</span>, <span class="hljs-string">&#x27;characteristics.&#x27;</span>, <span class="hljs-string">&#x27;higher&#x27;</span>, <span class="hljs-string">&#x27;basis&#x27;</span>, <span class="hljs-string">&#x27;weight&#x27;</span>, <span class="hljs-string">&#x27;paper:&#x27;</span>, <span class="hljs-string">&#x27;potential&#x27;</span>, <span class="hljs-string">&#x27;reduction&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;tobacco&#x27;</span>, <span class="hljs-string">&#x27;weight.&#x27;</span>, <span class="hljs-string">&#x27;«more&#x27;</span>, <span class="hljs-string">&#x27;rigid&#x27;</span>, <span class="hljs-string">&#x27;tobacco&#x27;</span>, <span class="hljs-string">&#x27;column;&#x27;</span>, <span class="hljs-string">&#x27;stiffing&#x27;</span>, <span class="hljs-string">&#x27;agent&#x27;</span>, <span class="hljs-string">&#x27;for&#x27;</span>, <span class="hljs-string">&#x27;tobacco;&#x27;</span>, <span class="hljs-string">&#x27;e.g.&#x27;</span>, <span class="hljs-string">&#x27;starch&#x27;</span>, <span class="hljs-string">&#x27;*colored&#x27;</span>, <span class="hljs-string">&#x27;tow&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;cigarette&#x27;</span>, <span class="hljs-string">&#x27;papers;&#x27;</span>, <span class="hljs-string">&#x27;seasonal&#x27;</span>, <span class="hljs-string">&#x27;promotions,&#x27;</span>, <span class="hljs-string">&#x27;e.g.&#x27;</span>, <span class="hljs-string">&#x27;pastel&#x27;</span>, <span class="hljs-string">&#x27;colored&#x27;</span>, <span class="hljs-string">&#x27;cigarettes&#x27;</span>, <span class="hljs-string">&#x27;for&#x27;</span>, <span class="hljs-string">&#x27;easter&#x27;</span>, <span class="hljs-string">&#x27;or&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;an&#x27;</span>, <span class="hljs-string">&#x27;ebony&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;ivory&#x27;</span>, <span class="hljs-string">&#x27;brand&#x27;</span>, <span class="hljs-string">&#x27;containing&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;mixture&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;all&#x27;</span>, <span class="hljs-string">&#x27;black&#x27;</span>, <span class="hljs-string">&#x27;(black&#x27;</span>, <span class="hljs-string">&#x27;paper&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;tow)&#x27;</span>, <span class="hljs-string">&#x27;and&#x27;</span>, <span class="hljs-string">&#x27;ail&#x27;</span>, <span class="hljs-string">&#x27;white&#x27;</span>, <span class="hljs-string">&#x27;cigarettes.&#x27;</span>, <span class="hljs-string">&#x27;499150498&#x27;</span>]
Answer:  T.F. Riehl
start_index <span class="hljs-number">17</span>
end_index <span class="hljs-number">18</span>`,wrap:!1}}),us=new M({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIoZXhhbXBsZSU1QiUyMnF1ZXN0aW9uJTIyJTVEJTJDJTIwZXhhbXBsZSU1QiUyMndvcmRzJTIyJTVEJTJDJTIwZXhhbXBsZSU1QiUyMmJveGVzJTIyJTVEKSUwQXRva2VuaXplci5kZWNvZGUoZW5jb2RpbmclNUIlMjJpbnB1dF9pZHMlMjIlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(example[<span class="hljs-string">&quot;question&quot;</span>], example[<span class="hljs-string">&quot;words&quot;</span>], example[<span class="hljs-string">&quot;boxes&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(encoding[<span class="hljs-string">&quot;input_ids&quot;</span>])
[CLS] who <span class="hljs-keyword">is</span> <span class="hljs-keyword">in</span> cc <span class="hljs-keyword">in</span> this letter? [SEP] wie baw brown &amp; williamson tobacco corporation research &amp; development ...`,wrap:!1}}),fs=new M({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_dataset</span>(<span class="hljs-params">examples, max_length=<span class="hljs-number">512</span></span>):
<span class="hljs-meta">... </span>    questions = examples[<span class="hljs-string">&quot;question&quot;</span>]
<span class="hljs-meta">... </span>    words = examples[<span class="hljs-string">&quot;words&quot;</span>]
<span class="hljs-meta">... </span>    boxes = examples[<span class="hljs-string">&quot;boxes&quot;</span>]
<span class="hljs-meta">... </span>    answers = examples[<span class="hljs-string">&quot;answer&quot;</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># encode the batch of examples and initialize the start_positions and end_positions</span>
<span class="hljs-meta">... </span>    encoding = tokenizer(questions, words, boxes, max_length=max_length, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    start_positions = []
<span class="hljs-meta">... </span>    end_positions = []

<span class="hljs-meta">... </span>    <span class="hljs-comment"># loop through the examples in the batch</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(questions)):
<span class="hljs-meta">... </span>        cls_index = encoding[<span class="hljs-string">&quot;input_ids&quot;</span>][i].index(tokenizer.cls_token_id)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># find the position of the answer in example&#x27;s words</span>
<span class="hljs-meta">... </span>        words_example = [word.lower() <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> words[i]]
<span class="hljs-meta">... </span>        answer = answers[i]
<span class="hljs-meta">... </span>        <span class="hljs-keyword">match</span>, word_idx_start, word_idx_end = subfinder(words_example, answer.lower().split())

<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> <span class="hljs-keyword">match</span>:
<span class="hljs-meta">... </span>            <span class="hljs-comment"># if match is found, use \`token_type_ids\` to find where words start in the encoding</span>
<span class="hljs-meta">... </span>            token_type_ids = encoding[<span class="hljs-string">&quot;token_type_ids&quot;</span>][i]
<span class="hljs-meta">... </span>            token_start_index = <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>            <span class="hljs-keyword">while</span> token_type_ids[token_start_index] != <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                token_start_index += <span class="hljs-number">1</span>

<span class="hljs-meta">... </span>            token_end_index = <span class="hljs-built_in">len</span>(encoding[<span class="hljs-string">&quot;input_ids&quot;</span>][i]) - <span class="hljs-number">1</span>
<span class="hljs-meta">... </span>            <span class="hljs-keyword">while</span> token_type_ids[token_end_index] != <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                token_end_index -= <span class="hljs-number">1</span>

<span class="hljs-meta">... </span>            word_ids = encoding.word_ids(i)[token_start_index : token_end_index + <span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>            start_position = cls_index
<span class="hljs-meta">... </span>            end_position = cls_index

<span class="hljs-meta">... </span>            <span class="hljs-comment"># loop over word_ids and increase \`token_start_index\` until it matches the answer position in words</span>
<span class="hljs-meta">... </span>            <span class="hljs-comment"># once it matches, save the \`token_start_index\` as the \`start_position\` of the answer in the encoding</span>
<span class="hljs-meta">... </span>            <span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span> <span class="hljs-keyword">in</span> word_ids:
<span class="hljs-meta">... </span>                <span class="hljs-keyword">if</span> <span class="hljs-built_in">id</span> == word_idx_start:
<span class="hljs-meta">... </span>                    start_position = token_start_index
<span class="hljs-meta">... </span>                <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>                    token_start_index += <span class="hljs-number">1</span>

<span class="hljs-meta">... </span>            <span class="hljs-comment"># similarly loop over \`word_ids\` starting from the end to find the \`end_position\` of the answer</span>
<span class="hljs-meta">... </span>            <span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span> <span class="hljs-keyword">in</span> word_ids[::-<span class="hljs-number">1</span>]:
<span class="hljs-meta">... </span>                <span class="hljs-keyword">if</span> <span class="hljs-built_in">id</span> == word_idx_end:
<span class="hljs-meta">... </span>                    end_position = token_end_index
<span class="hljs-meta">... </span>                <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>                    token_end_index -= <span class="hljs-number">1</span>

<span class="hljs-meta">... </span>            start_positions.append(start_position)
<span class="hljs-meta">... </span>            end_positions.append(end_position)

<span class="hljs-meta">... </span>        <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>            start_positions.append(cls_index)
<span class="hljs-meta">... </span>            end_positions.append(cls_index)

<span class="hljs-meta">... </span>    encoding[<span class="hljs-string">&quot;image&quot;</span>] = examples[<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">... </span>    encoding[<span class="hljs-string">&quot;start_positions&quot;</span>] = start_positions
<span class="hljs-meta">... </span>    encoding[<span class="hljs-string">&quot;end_positions&quot;</span>] = end_positions

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> encoding`,wrap:!1}}),Ts=new M({props:{code:"ZW5jb2RlZF90cmFpbl9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldF93aXRoX29jciU1QiUyMnRyYWluJTIyJTVELm1hcCglMEElMjAlMjAlMjAlMjBlbmNvZGVfZGF0YXNldCUyQyUyMGJhdGNoZWQlM0RUcnVlJTJDJTIwYmF0Y2hfc2l6ZSUzRDIlMkMlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXRfd2l0aF9vY3IlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXMlMEEpJTBBZW5jb2RlZF90ZXN0X2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0X3dpdGhfb2NyJTVCJTIydGVzdCUyMiU1RC5tYXAoJTBBJTIwJTIwJTIwJTIwZW5jb2RlX2RhdGFzZXQlMkMlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0QyJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0RkYXRhc2V0X3dpdGhfb2NyJTVCJTIydGVzdCUyMiU1RC5jb2x1bW5fbmFtZXMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_train_dataset = dataset_with_ocr[<span class="hljs-string">&quot;train&quot;</span>].<span class="hljs-built_in">map</span>(
<span class="hljs-meta">... </span>    encode_dataset, batched=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">2</span>, remove_columns=dataset_with_ocr[<span class="hljs-string">&quot;train&quot;</span>].column_names
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_test_dataset = dataset_with_ocr[<span class="hljs-string">&quot;test&quot;</span>].<span class="hljs-built_in">map</span>(
<span class="hljs-meta">... </span>    encode_dataset, batched=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">2</span>, remove_columns=dataset_with_ocr[<span class="hljs-string">&quot;test&quot;</span>].column_names
<span class="hljs-meta">... </span>)`,wrap:!1}}),Cs=new M({props:{code:"ZW5jb2RlZF90cmFpbl9kYXRhc2V0LmZlYXR1cmVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_train_dataset.features
{<span class="hljs-string">&#x27;image&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=<span class="hljs-type">Sequence</span>(feature=<span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;uint8&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;int32&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;int8&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;attention_mask&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;int8&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;bbox&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=<span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;start_positions&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;end_positions&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),Is=new T({props:{title:"Evaluation",local:"evaluation",headingTag:"h2"}}),ks=new T({props:{title:"Train",local:"train",headingTag:"h2"}}),Rs=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmclMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NoZWNrcG9pbnQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(model_checkpoint)`,wrap:!1}}),As=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBJTIzJTIwUkVQTEFDRSUyMFRISVMlMjBXSVRIJTIwWU9VUiUyMFJFUE8lMjBJRCUwQXJlcG9faWQlMjAlM0QlMjAlMjJNYXJpYUslMkZsYXlvdXRsbXYyLWJhc2UtdW5jYXNlZF9maW5ldHVuZWRfZG9jdnFhJTIyJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QyMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNENWUtNSUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfdG90YWxfbGltaXQlM0QyJTJDJTBBJTIwJTIwJTIwJTIwcmVtb3ZlX3VudXNlZF9jb2x1bW5zJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># REPLACE THIS WITH YOUR REPO ID</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;MariaK/layoutlmv2-base-uncased_finetuned_docvqa&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=repo_id,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">5e-5</span>,
<span class="hljs-meta">... </span>    save_total_limit=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Gs=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator()`,wrap:!1}}),Ws=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGF0YV9jb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RlbmNvZGVkX3RyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RlbmNvZGVkX3Rlc3RfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    train_dataset=encoded_train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=encoded_test_dataset,
<span class="hljs-meta">... </span>    tokenizer=processor,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`,wrap:!1}}),Vs=new M({props:{code:"dHJhaW5lci5jcmVhdGVfbW9kZWxfY2FyZCgpJTBBdHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.create_model_card()
<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()`,wrap:!1}}),Fs=new T({props:{title:"Inference",local:"inference",headingTag:"h2"}}),zs=new M({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMiU1RCUwQXF1ZXN0aW9uJTIwJTNEJTIwZXhhbXBsZSU1QiUyMnF1ZXJ5JTIyJTVEJTVCJTIyZW4lMjIlNUQlMEFpbWFnZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJpbWFnZSUyMiU1RCUwQXByaW50KHF1ZXN0aW9uKSUwQXByaW50KGV4YW1wbGUlNUIlMjJhbnN3ZXJzJTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">2</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&quot;query&quot;</span>][<span class="hljs-string">&quot;en&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = example[<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(question)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(example[<span class="hljs-string">&quot;answers&quot;</span>])
<span class="hljs-string">&#x27;Who is ‘presiding’ TRRF GENERAL SESSION (PART 1)?&#x27;</span>
[<span class="hljs-string">&#x27;TRRF Vice President&#x27;</span>, <span class="hljs-string">&#x27;lee a. waller&#x27;</span>]`,wrap:!1}}),Ys=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcWFfcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZSglMjJkb2N1bWVudC1xdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRCUyMk1hcmlhSyUyRmxheW91dGxtdjItYmFzZS11bmNhc2VkX2ZpbmV0dW5lZF9kb2N2cWElMjIpJTBBcWFfcGlwZWxpbmUoaW1hZ2UlMkMlMjBxdWVzdGlvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>qa_pipeline = pipeline(<span class="hljs-string">&quot;document-question-answering&quot;</span>, model=<span class="hljs-string">&quot;MariaK/layoutlmv2-base-uncased_finetuned_docvqa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>qa_pipeline(image, question)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9949808120727539</span>,
  <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;Lee A. Waller&#x27;</span>,
  <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">55</span>,
  <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">57</span>}]`,wrap:!1}}),Ls=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGbGF5b3V0bG12Mi1iYXNlLXVuY2FzZWRfZmluZXR1bmVkX2RvY3ZxYSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMk1hcmlhSyUyRmxheW91dGxtdjItYmFzZS11bmNhc2VkX2ZpbmV0dW5lZF9kb2N2cWElMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGVuY29kaW5nJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSUyQyUyMHF1ZXN0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKiplbmNvZGluZyklMEElMjAlMjAlMjAlMjBzdGFydF9sb2dpdHMlMjAlM0QlMjBvdXRwdXRzLnN0YXJ0X2xvZ2l0cyUwQSUyMCUyMCUyMCUyMGVuZF9sb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmVuZF9sb2dpdHMlMEElMjAlMjAlMjAlMjBwcmVkaWN0ZWRfc3RhcnRfaWR4JTIwJTNEJTIwc3RhcnRfbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2VuZF9pZHglMjAlM0QlMjBlbmRfbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBJTBBcHJvY2Vzc29yLnRva2VuaXplci5kZWNvZGUoZW5jb2RpbmcuaW5wdXRfaWRzLnNxdWVlemUoKSU1QnByZWRpY3RlZF9zdGFydF9pZHglMjAlM0ElMjBwcmVkaWN0ZWRfZW5kX2lkeCUyMCUyQiUyMDElNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;MariaK/layoutlmv2-base-uncased_finetuned_docvqa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;MariaK/layoutlmv2-base-uncased_finetuned_docvqa&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    encoding = processor(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>), question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>    outputs = model(**encoding)
<span class="hljs-meta">... </span>    start_logits = outputs.start_logits
<span class="hljs-meta">... </span>    end_logits = outputs.end_logits
<span class="hljs-meta">... </span>    predicted_start_idx = start_logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">... </span>    predicted_end_idx = end_logits.argmax(-<span class="hljs-number">1</span>).item()

<span class="hljs-meta">&gt;&gt;&gt; </span>processor.tokenizer.decode(encoding.input_ids.squeeze()[predicted_start_idx : predicted_end_idx + <span class="hljs-number">1</span>])
<span class="hljs-string">&#x27;lee a. waller&#x27;</span>`,wrap:!1}}),{c(){g=p("meta"),U=t(),w=p("p"),u=t(),o(J.$$.fragment),x=t(),o(y.$$.fragment),Ks=t(),C=p("p"),C.textContent=_n,Os=t(),I=p("p"),I.textContent=kn,sa=t(),_=p("ul"),_.innerHTML=Zn,aa=t(),o(f.$$.fragment),na=t(),k=p("p"),k.textContent=vn,la=t(),Z=p("p"),Z.textContent=Rn,ta=t(),o(v.$$.fragment),ea=t(),o(R.$$.fragment),pa=t(),o(X.$$.fragment),ia=t(),A=p("p"),A.textContent=Xn,ra=t(),$=p("p"),$.textContent=An,oa=t(),o(G.$$.fragment),ca=t(),B=p("p"),B.textContent=$n,ha=t(),o(W.$$.fragment),ja=t(),o(N.$$.fragment),da=t(),V=p("p"),V.innerHTML=Gn,ma=t(),o(F.$$.fragment),Ma=t(),Q=p("p"),Q.textContent=Bn,ga=t(),o(E.$$.fragment),xa=t(),z=p("p"),z.textContent=Wn,ua=t(),q=p("ul"),q.innerHTML=Nn,ya=t(),Y=p("p"),Y.innerHTML=Vn,wa=t(),o(H.$$.fragment),Ja=t(),S=p("p"),S.innerHTML=Fn,fa=t(),o(L.$$.fragment),ba=t(),P=p("p"),P.innerHTML=Qn,Ta=t(),o(D.$$.fragment),Ua=t(),K=p("p"),K.textContent=En,Ca=t(),o(O.$$.fragment),Ia=t(),b=p("div"),b.innerHTML=zn,_a=t(),o(ss.$$.fragment),ka=t(),as=p("p"),as.innerHTML=qn,Za=t(),o(ns.$$.fragment),va=t(),o(ls.$$.fragment),Ra=t(),ts=p("p"),ts.innerHTML=Yn,Xa=t(),o(es.$$.fragment),Aa=t(),ps=p("p"),ps.innerHTML=Hn,$a=t(),o(is.$$.fragment),Ga=t(),o(rs.$$.fragment),Ba=t(),os=p("p"),os.innerHTML=Sn,Wa=t(),o(cs.$$.fragment),Na=t(),hs=p("p"),hs.innerHTML=Ln,Va=t(),js=p("p"),js.textContent=Pn,Fa=t(),ds=p("p"),ds.innerHTML=Dn,Qa=t(),o(ms.$$.fragment),Ea=t(),Ms=p("p"),Ms.textContent=Kn,za=t(),o(gs.$$.fragment),qa=t(),xs=p("p"),xs.textContent=On,Ya=t(),o(us.$$.fragment),Ha=t(),ys=p("p"),ys.textContent=sl,Sa=t(),ws=p("ul"),ws.innerHTML=al,La=t(),Js=p("p"),Js.textContent=nl,Pa=t(),o(fs.$$.fragment),Da=t(),bs=p("p"),bs.textContent=ll,Ka=t(),o(Ts.$$.fragment),Oa=t(),Us=p("p"),Us.textContent=tl,sn=t(),o(Cs.$$.fragment),an=t(),o(Is.$$.fragment),nn=t(),_s=p("p"),_s.innerHTML=el,ln=t(),o(ks.$$.fragment),tn=t(),Zs=p("p"),Zs.textContent=pl,en=t(),vs=p("ul"),vs.innerHTML=il,pn=t(),o(Rs.$$.fragment),rn=t(),Xs=p("p"),Xs.innerHTML=rl,on=t(),o(As.$$.fragment),cn=t(),$s=p("p"),$s.textContent=ol,hn=t(),o(Gs.$$.fragment),jn=t(),Bs=p("p"),Bs.innerHTML=cl,dn=t(),o(Ws.$$.fragment),mn=t(),Ns=p("p"),Ns.innerHTML=hl,Mn=t(),o(Vs.$$.fragment),gn=t(),o(Fs.$$.fragment),xn=t(),Qs=p("p"),Qs.innerHTML=jl,un=t(),Es=p("p"),Es.textContent=dl,yn=t(),o(zs.$$.fragment),wn=t(),qs=p("p"),qs.textContent=ml,Jn=t(),o(Ys.$$.fragment),fn=t(),Hs=p("p"),Hs.textContent=Ml,bn=t(),Ss=p("ol"),Ss.innerHTML=gl,Tn=t(),o(Ls.$$.fragment),Un=t(),Ps=p("p"),this.h()},l(s){const a=Tl("svelte-u9bgzb",document.head);g=i(a,"META",{name:!0,content:!0}),a.forEach(n),U=e(s),w=i(s,"P",{}),ul(w).forEach(n),u=e(s),c(J.$$.fragment,s),x=e(s),c(y.$$.fragment,s),Ks=e(s),C=i(s,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1c1m6de"&&(C.textContent=_n),Os=e(s),I=i(s,"P",{"data-svelte-h":!0}),r(I)!=="svelte-ku8orh"&&(I.textContent=kn),sa=e(s),_=i(s,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-1g8eree"&&(_.innerHTML=Zn),aa=e(s),c(f.$$.fragment,s),na=e(s),k=i(s,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1svbrv5"&&(k.textContent=vn),la=e(s),Z=i(s,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-17fjxql"&&(Z.textContent=Rn),ta=e(s),c(v.$$.fragment,s),ea=e(s),c(R.$$.fragment,s),pa=e(s),c(X.$$.fragment,s),ia=e(s),A=i(s,"P",{"data-svelte-h":!0}),r(A)!=="svelte-hsz112"&&(A.textContent=Xn),ra=e(s),$=i(s,"P",{"data-svelte-h":!0}),r($)!=="svelte-1yqpblu"&&($.textContent=An),oa=e(s),c(G.$$.fragment,s),ca=e(s),B=i(s,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1us2g34"&&(B.textContent=$n),ha=e(s),c(W.$$.fragment,s),ja=e(s),c(N.$$.fragment,s),da=e(s),V=i(s,"P",{"data-svelte-h":!0}),r(V)!=="svelte-xkaeyi"&&(V.innerHTML=Gn),ma=e(s),c(F.$$.fragment,s),Ma=e(s),Q=i(s,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-18ggx10"&&(Q.textContent=Bn),ga=e(s),c(E.$$.fragment,s),xa=e(s),z=i(s,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1fi388d"&&(z.textContent=Wn),ua=e(s),q=i(s,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-12b5dxa"&&(q.innerHTML=Nn),ya=e(s),Y=i(s,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1h0f0qo"&&(Y.innerHTML=Vn),wa=e(s),c(H.$$.fragment,s),Ja=e(s),S=i(s,"P",{"data-svelte-h":!0}),r(S)!=="svelte-x5p0j2"&&(S.innerHTML=Fn),fa=e(s),c(L.$$.fragment,s),ba=e(s),P=i(s,"P",{"data-svelte-h":!0}),r(P)!=="svelte-8r43x9"&&(P.innerHTML=Qn),Ta=e(s),c(D.$$.fragment,s),Ua=e(s),K=i(s,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1vy80t"&&(K.textContent=En),Ca=e(s),c(O.$$.fragment,s),Ia=e(s),b=i(s,"DIV",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-q63tj1"&&(b.innerHTML=zn),_a=e(s),c(ss.$$.fragment,s),ka=e(s),as=i(s,"P",{"data-svelte-h":!0}),r(as)!=="svelte-ldga7b"&&(as.innerHTML=qn),Za=e(s),c(ns.$$.fragment,s),va=e(s),c(ls.$$.fragment,s),Ra=e(s),ts=i(s,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-1u7369n"&&(ts.innerHTML=Yn),Xa=e(s),c(es.$$.fragment,s),Aa=e(s),ps=i(s,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-1n6jp0n"&&(ps.innerHTML=Hn),$a=e(s),c(is.$$.fragment,s),Ga=e(s),c(rs.$$.fragment,s),Ba=e(s),os=i(s,"P",{"data-svelte-h":!0}),r(os)!=="svelte-dfarfe"&&(os.innerHTML=Sn),Wa=e(s),c(cs.$$.fragment,s),Na=e(s),hs=i(s,"P",{"data-svelte-h":!0}),r(hs)!=="svelte-12sojfo"&&(hs.innerHTML=Ln),Va=e(s),js=i(s,"P",{"data-svelte-h":!0}),r(js)!=="svelte-1kkerbo"&&(js.textContent=Pn),Fa=e(s),ds=i(s,"P",{"data-svelte-h":!0}),r(ds)!=="svelte-1wppb4o"&&(ds.innerHTML=Dn),Qa=e(s),c(ms.$$.fragment,s),Ea=e(s),Ms=i(s,"P",{"data-svelte-h":!0}),r(Ms)!=="svelte-19pibjd"&&(Ms.textContent=Kn),za=e(s),c(gs.$$.fragment,s),qa=e(s),xs=i(s,"P",{"data-svelte-h":!0}),r(xs)!=="svelte-19lp6r8"&&(xs.textContent=On),Ya=e(s),c(us.$$.fragment,s),Ha=e(s),ys=i(s,"P",{"data-svelte-h":!0}),r(ys)!=="svelte-1tk94l"&&(ys.textContent=sl),Sa=e(s),ws=i(s,"UL",{"data-svelte-h":!0}),r(ws)!=="svelte-zfehno"&&(ws.innerHTML=al),La=e(s),Js=i(s,"P",{"data-svelte-h":!0}),r(Js)!=="svelte-701rvg"&&(Js.textContent=nl),Pa=e(s),c(fs.$$.fragment,s),Da=e(s),bs=i(s,"P",{"data-svelte-h":!0}),r(bs)!=="svelte-1ori799"&&(bs.textContent=ll),Ka=e(s),c(Ts.$$.fragment,s),Oa=e(s),Us=i(s,"P",{"data-svelte-h":!0}),r(Us)!=="svelte-upxsp"&&(Us.textContent=tl),sn=e(s),c(Cs.$$.fragment,s),an=e(s),c(Is.$$.fragment,s),nn=e(s),_s=i(s,"P",{"data-svelte-h":!0}),r(_s)!=="svelte-1w81x5o"&&(_s.innerHTML=el),ln=e(s),c(ks.$$.fragment,s),tn=e(s),Zs=i(s,"P",{"data-svelte-h":!0}),r(Zs)!=="svelte-10f6ay"&&(Zs.textContent=pl),en=e(s),vs=i(s,"UL",{"data-svelte-h":!0}),r(vs)!=="svelte-1g5kx5y"&&(vs.innerHTML=il),pn=e(s),c(Rs.$$.fragment,s),rn=e(s),Xs=i(s,"P",{"data-svelte-h":!0}),r(Xs)!=="svelte-gbj004"&&(Xs.innerHTML=rl),on=e(s),c(As.$$.fragment,s),cn=e(s),$s=i(s,"P",{"data-svelte-h":!0}),r($s)!=="svelte-1gq6t8w"&&($s.textContent=ol),hn=e(s),c(Gs.$$.fragment,s),jn=e(s),Bs=i(s,"P",{"data-svelte-h":!0}),r(Bs)!=="svelte-hv7of8"&&(Bs.innerHTML=cl),dn=e(s),c(Ws.$$.fragment,s),mn=e(s),Ns=i(s,"P",{"data-svelte-h":!0}),r(Ns)!=="svelte-gilssp"&&(Ns.innerHTML=hl),Mn=e(s),c(Vs.$$.fragment,s),gn=e(s),c(Fs.$$.fragment,s),xn=e(s),Qs=i(s,"P",{"data-svelte-h":!0}),r(Qs)!=="svelte-q7dhq3"&&(Qs.innerHTML=jl),un=e(s),Es=i(s,"P",{"data-svelte-h":!0}),r(Es)!=="svelte-1wtngfz"&&(Es.textContent=dl),yn=e(s),c(zs.$$.fragment,s),wn=e(s),qs=i(s,"P",{"data-svelte-h":!0}),r(qs)!=="svelte-mcchgg"&&(qs.textContent=ml),Jn=e(s),c(Ys.$$.fragment,s),fn=e(s),Hs=i(s,"P",{"data-svelte-h":!0}),r(Hs)!=="svelte-o6117l"&&(Hs.textContent=Ml),bn=e(s),Ss=i(s,"OL",{"data-svelte-h":!0}),r(Ss)!=="svelte-19rdijs"&&(Ss.innerHTML=gl),Tn=e(s),c(Ls.$$.fragment,s),Un=e(s),Ps=i(s,"P",{}),ul(Ps).forEach(n),this.h()},h(){In(g,"name","hf:doc:metadata"),In(g,"content",Zl),In(b,"class","flex justify-center")},m(s,a){Ul(document.head,g),l(s,U,a),l(s,w,a),l(s,u,a),h(J,s,a),l(s,x,a),h(y,s,a),l(s,Ks,a),l(s,C,a),l(s,Os,a),l(s,I,a),l(s,sa,a),l(s,_,a),l(s,aa,a),h(f,s,a),l(s,na,a),l(s,k,a),l(s,la,a),l(s,Z,a),l(s,ta,a),h(v,s,a),l(s,ea,a),h(R,s,a),l(s,pa,a),h(X,s,a),l(s,ia,a),l(s,A,a),l(s,ra,a),l(s,$,a),l(s,oa,a),h(G,s,a),l(s,ca,a),l(s,B,a),l(s,ha,a),h(W,s,a),l(s,ja,a),h(N,s,a),l(s,da,a),l(s,V,a),l(s,ma,a),h(F,s,a),l(s,Ma,a),l(s,Q,a),l(s,ga,a),h(E,s,a),l(s,xa,a),l(s,z,a),l(s,ua,a),l(s,q,a),l(s,ya,a),l(s,Y,a),l(s,wa,a),h(H,s,a),l(s,Ja,a),l(s,S,a),l(s,fa,a),h(L,s,a),l(s,ba,a),l(s,P,a),l(s,Ta,a),h(D,s,a),l(s,Ua,a),l(s,K,a),l(s,Ca,a),h(O,s,a),l(s,Ia,a),l(s,b,a),l(s,_a,a),h(ss,s,a),l(s,ka,a),l(s,as,a),l(s,Za,a),h(ns,s,a),l(s,va,a),h(ls,s,a),l(s,Ra,a),l(s,ts,a),l(s,Xa,a),h(es,s,a),l(s,Aa,a),l(s,ps,a),l(s,$a,a),h(is,s,a),l(s,Ga,a),h(rs,s,a),l(s,Ba,a),l(s,os,a),l(s,Wa,a),h(cs,s,a),l(s,Na,a),l(s,hs,a),l(s,Va,a),l(s,js,a),l(s,Fa,a),l(s,ds,a),l(s,Qa,a),h(ms,s,a),l(s,Ea,a),l(s,Ms,a),l(s,za,a),h(gs,s,a),l(s,qa,a),l(s,xs,a),l(s,Ya,a),h(us,s,a),l(s,Ha,a),l(s,ys,a),l(s,Sa,a),l(s,ws,a),l(s,La,a),l(s,Js,a),l(s,Pa,a),h(fs,s,a),l(s,Da,a),l(s,bs,a),l(s,Ka,a),h(Ts,s,a),l(s,Oa,a),l(s,Us,a),l(s,sn,a),h(Cs,s,a),l(s,an,a),h(Is,s,a),l(s,nn,a),l(s,_s,a),l(s,ln,a),h(ks,s,a),l(s,tn,a),l(s,Zs,a),l(s,en,a),l(s,vs,a),l(s,pn,a),h(Rs,s,a),l(s,rn,a),l(s,Xs,a),l(s,on,a),h(As,s,a),l(s,cn,a),l(s,$s,a),l(s,hn,a),h(Gs,s,a),l(s,jn,a),l(s,Bs,a),l(s,dn,a),h(Ws,s,a),l(s,mn,a),l(s,Ns,a),l(s,Mn,a),h(Vs,s,a),l(s,gn,a),h(Fs,s,a),l(s,xn,a),l(s,Qs,a),l(s,un,a),l(s,Es,a),l(s,yn,a),h(zs,s,a),l(s,wn,a),l(s,qs,a),l(s,Jn,a),h(Ys,s,a),l(s,fn,a),l(s,Hs,a),l(s,bn,a),l(s,Ss,a),l(s,Tn,a),h(Ls,s,a),l(s,Un,a),l(s,Ps,a),Cn=!0},p(s,[a]){const xl={};a&2&&(xl.$$scope={dirty:a,ctx:s}),f.$set(xl)},i(s){Cn||(j(J.$$.fragment,s),j(y.$$.fragment,s),j(f.$$.fragment,s),j(v.$$.fragment,s),j(R.$$.fragment,s),j(X.$$.fragment,s),j(G.$$.fragment,s),j(W.$$.fragment,s),j(N.$$.fragment,s),j(F.$$.fragment,s),j(E.$$.fragment,s),j(H.$$.fragment,s),j(L.$$.fragment,s),j(D.$$.fragment,s),j(O.$$.fragment,s),j(ss.$$.fragment,s),j(ns.$$.fragment,s),j(ls.$$.fragment,s),j(es.$$.fragment,s),j(is.$$.fragment,s),j(rs.$$.fragment,s),j(cs.$$.fragment,s),j(ms.$$.fragment,s),j(gs.$$.fragment,s),j(us.$$.fragment,s),j(fs.$$.fragment,s),j(Ts.$$.fragment,s),j(Cs.$$.fragment,s),j(Is.$$.fragment,s),j(ks.$$.fragment,s),j(Rs.$$.fragment,s),j(As.$$.fragment,s),j(Gs.$$.fragment,s),j(Ws.$$.fragment,s),j(Vs.$$.fragment,s),j(Fs.$$.fragment,s),j(zs.$$.fragment,s),j(Ys.$$.fragment,s),j(Ls.$$.fragment,s),Cn=!0)},o(s){d(J.$$.fragment,s),d(y.$$.fragment,s),d(f.$$.fragment,s),d(v.$$.fragment,s),d(R.$$.fragment,s),d(X.$$.fragment,s),d(G.$$.fragment,s),d(W.$$.fragment,s),d(N.$$.fragment,s),d(F.$$.fragment,s),d(E.$$.fragment,s),d(H.$$.fragment,s),d(L.$$.fragment,s),d(D.$$.fragment,s),d(O.$$.fragment,s),d(ss.$$.fragment,s),d(ns.$$.fragment,s),d(ls.$$.fragment,s),d(es.$$.fragment,s),d(is.$$.fragment,s),d(rs.$$.fragment,s),d(cs.$$.fragment,s),d(ms.$$.fragment,s),d(gs.$$.fragment,s),d(us.$$.fragment,s),d(fs.$$.fragment,s),d(Ts.$$.fragment,s),d(Cs.$$.fragment,s),d(Is.$$.fragment,s),d(ks.$$.fragment,s),d(Rs.$$.fragment,s),d(As.$$.fragment,s),d(Gs.$$.fragment,s),d(Ws.$$.fragment,s),d(Vs.$$.fragment,s),d(Fs.$$.fragment,s),d(zs.$$.fragment,s),d(Ys.$$.fragment,s),d(Ls.$$.fragment,s),Cn=!1},d(s){s&&(n(U),n(w),n(u),n(x),n(Ks),n(C),n(Os),n(I),n(sa),n(_),n(aa),n(na),n(k),n(la),n(Z),n(ta),n(ea),n(pa),n(ia),n(A),n(ra),n($),n(oa),n(ca),n(B),n(ha),n(ja),n(da),n(V),n(ma),n(Ma),n(Q),n(ga),n(xa),n(z),n(ua),n(q),n(ya),n(Y),n(wa),n(Ja),n(S),n(fa),n(ba),n(P),n(Ta),n(Ua),n(K),n(Ca),n(Ia),n(b),n(_a),n(ka),n(as),n(Za),n(va),n(Ra),n(ts),n(Xa),n(Aa),n(ps),n($a),n(Ga),n(Ba),n(os),n(Wa),n(Na),n(hs),n(Va),n(js),n(Fa),n(ds),n(Qa),n(Ea),n(Ms),n(za),n(qa),n(xs),n(Ya),n(Ha),n(ys),n(Sa),n(ws),n(La),n(Js),n(Pa),n(Da),n(bs),n(Ka),n(Oa),n(Us),n(sn),n(an),n(nn),n(_s),n(ln),n(tn),n(Zs),n(en),n(vs),n(pn),n(rn),n(Xs),n(on),n(cn),n($s),n(hn),n(jn),n(Bs),n(dn),n(mn),n(Ns),n(Mn),n(gn),n(xn),n(Qs),n(un),n(Es),n(yn),n(wn),n(qs),n(Jn),n(fn),n(Hs),n(bn),n(Ss),n(Tn),n(Un),n(Ps)),n(g),m(J,s),m(y,s),m(f,s),m(v,s),m(R,s),m(X,s),m(G,s),m(W,s),m(N,s),m(F,s),m(E,s),m(H,s),m(L,s),m(D,s),m(O,s),m(ss,s),m(ns,s),m(ls,s),m(es,s),m(is,s),m(rs,s),m(cs,s),m(ms,s),m(gs,s),m(us,s),m(fs,s),m(Ts,s),m(Cs,s),m(Is,s),m(ks,s),m(Rs,s),m(As,s),m(Gs,s),m(Ws,s),m(Vs,s),m(Fs,s),m(zs,s),m(Ys,s),m(Ls,s)}}}const Zl='{"title":"Document Question Answering","local":"document-question-answering","sections":[{"title":"Load the data","local":"load-the-data","sections":[],"depth":2},{"title":"Preprocess the data","local":"preprocess-the-data","sections":[{"title":"Preprocessing document images","local":"preprocessing-document-images","sections":[],"depth":3},{"title":"Preprocessing text data","local":"preprocessing-text-data","sections":[],"depth":3}],"depth":2},{"title":"Evaluation","local":"evaluation","sections":[],"depth":2},{"title":"Train","local":"train","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function vl(Ds){return wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wl extends fl{constructor(g){super(),bl(this,g,vl,kl,yl,{})}}export{Wl as component};
