import{s as ss,o as as,n as ns}from"../chunks/scheduler.182ea377.js";import{S as is,i as ps,g as s,s as i,p as m,A as os,h as a,f as t,c as p,j as w,q as h,m as o,k as r,v as c,a as n,r as M,d as f,t as d,u as y}from"../chunks/index.008d68e4.js";import{T as ls}from"../chunks/Tip.4f096367.js";import{I as Q}from"../chunks/IconCopyLink.96bbb92b.js";import{C as b}from"../chunks/CodeBlock.5ed6eb7b.js";function rs(Ke){let u,T='Support for <code>fuse_qkv_projections()</code> is limited and experimental. As such, it’s not available for many non-SD pipelines such as <a href="../using-diffusers/kandinsky.md">Kandinsky</a>. You can refer to <a href="https://github.com/huggingface/diffusers/pull/6179" rel="nofollow">this PR</a> to get an idea about how to support this kind of computation.';return{c(){u=s("p"),u.innerHTML=T},l(j){u=a(j,"P",{"data-svelte-h":!0}),o(u)!=="svelte-izvj6c"&&(u.innerHTML=T)},m(j,J){n(j,u,J)},p:ns,d(j){j&&t(u)}}}function cs(Ke){let u,T='Through experimentation, we found that certain linear layers in the UNet and the VAE don’t benefit from dynamic int8 quantization. You can check out the full code for filtering those layers <a href="https://github.com/huggingface/diffusion-fast/blob/0f169640b1db106fe6a479f78c1ed3bfaeba3386/utils/pipeline_utils.py#L16" rel="nofollow">here</a> (referred to as <code>dynamic_quant_filter_fn</code> below).';return{c(){u=s("p"),u.innerHTML=T},l(j){u=a(j,"P",{"data-svelte-h":!0}),o(u)!=="svelte-1xe2fym"&&(u.innerHTML=T)},m(j,J){n(j,u,J)},p:ns,d(j){j&&t(u)}}}function us(Ke){let u,T,j,J,pt,Y,Wl,Oe,Rl="Accelerate inference of text-to-image diffusion models",dt,L,Ql="Diffusion models are known to be slower than their counter parts, GANs, because of the iterative and sequential reverse diffusion process. Recent works try to address limitation with:",yt,z,Yl='<li>progressive timestep distillation (such as <a href="../using-diffusers/inference_with_lcm_lora.md">LCM LoRA</a>)</li> <li>model compression (such as <a href="https://huggingface.co/segmind/SSD-1B" rel="nofollow">SSD-1B</a>)</li> <li>reusing adjacent features of the denoiser (such as <a href="https://github.com/horseee/DeepCache" rel="nofollow">DeepCache</a>)</li>',wt,D,Ll='In this tutorial, we focus on leveraging the power of PyTorch 2 to accelerate the inference latency of text-to-image diffusion pipeline, instead. We will use <a href="../using-diffusers/sdxl.md">Stable Diffusion XL (SDXL)</a> as a case study, but the techniques we will discuss should extend to other text-to-image diffusion pipelines.',jt,U,k,ot,q,Sl,et,zl="Setup",bt,P,Dl="Make sure you’re on the latest version of <code>diffusers</code>:",Jt,K,Tt,O,ql="Then upgrade the other required libraries too:",Ut,ee,vt,te,Pl='To benefit from the fastest kernels, use PyTorch nightly. You can find the installation instructions <a href="https://pytorch.org/" rel="nofollow">here</a>.',Ct,le,Kl="To report the numbers shown below, we used an 80GB 400W A100 with its clock rate set to the maximum.",_t,ne,Ol='<em>This tutorial doesn’t present the benchmarking code and focuses on how to perform the optimizations, instead. For the full benchmarking code, refer to: <a href="https://github.com/huggingface/diffusion-fast" rel="nofollow">https://github.com/huggingface/diffusion-fast</a>.</em>',gt,v,x,rt,se,Xl,tt,en="Baseline",Zt,ae,tn='Let’s start with a baseline. Disable the use of a reduced precision and <a href="../optimization/torch2.0.md"><code>scaled_dot_product_attention</code></a>:',It,ie,kt,pe,ln="This takes 7.36 seconds:",xt,G,nn='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_0.png" width="500"/>',Gt,C,$,ct,oe,Vl,lt,sn="Running inference in bfloat16",$t,re,an="Enable the first optimization: use a reduced precision to run the inference.",At,ce,Bt,ue,pn="bfloat16 reduces the latency from 7.36 seconds to 4.63 seconds:",Wt,A,on='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_1.png" width="500"/>',St,me,rn="<strong>Why bfloat16?</strong>",Xt,he,cn="<li>Using a reduced numerical precision (such as float16, bfloat16) to run inference doesn’t affect the generation quality but significantly improves latency.</li> <li>The benefits of using the bfloat16 numerical precision as compared to float16 are hardware-dependent. Modern generations of GPUs tend to favor bfloat16.</li> <li>Furthermore, in our experiments, we bfloat16 to be much more resilient when used with quantization in comparison to float16.</li>",Vt,Me,un='We have a <a href="../optimization/fp16.md">dedicated guide</a> for running inference in a reduced precision.',Ft,_,B,ut,fe,Fl,nt,mn="Running attention efficiently",Ht,de,hn='Attention blocks are intensive to run. But with PyTorch’s <a href="../optimization/torch2.0.md"><code>scaled_dot_product_attention</code></a>, we can run them efficiently.',Nt,ye,Et,we,Mn="<code>scaled_dot_product_attention</code> improves the latency from 4.63 seconds to 3.31 seconds.",Rt,W,fn='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_2.png" width="500"/>',Qt,g,S,mt,je,Hl,st,dn="Use faster kernels with torch.compile",Yt,be,yn="Compile the UNet and the VAE to benefit from the faster kernels. First, configure a few compiler flags:",Lt,Je,zt,Te,wn='For the full list of compiler flags, refer to <a href="https://github.com/pytorch/pytorch/blob/main/torch/_inductor/config.py" rel="nofollow">this file</a>.',Dt,Ue,jn="It is also important to change the memory layout of the UNet and the VAE to “channels_last” when compiling them. This ensures maximum speed:",qt,ve,Pt,Ce,bn="Then, compile and perform inference:",Kt,_e,Ot,ge,Jn="<code>torch.compile</code> offers different backends and modes. As we’re aiming for maximum inference speed, we opt for the inductor backend using the “max-autotune”. “max-autotune” uses CUDA graphs and optimizes the compilation graph specifically for latency. Specifying fullgraph to be True ensures that there are no graph breaks in the underlying model, ensuring the fullest potential of <code>torch.compile</code>.",el,Ze,Tn="Using SDPA attention and compiling both the UNet and VAE reduces the latency from 3.31 seconds to 2.54 seconds.",tl,X,Un='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_3.png" width="500"/>',ll,Z,V,ht,Ie,Nl,at,vn="Combine the projection matrices of attention",nl,ke,Cn="Both the UNet and the VAE used in SDXL make use of Transformer-like blocks. A Transformer block consists of attention blocks and feed-forward blocks.",sl,xe,_n="In an attention block, the input is projected into three sub-spaces using three different projection matrices – Q, K, and V. In the naive implementation, these projections are performed separately on the input. But we can horizontally combine the projection matrices into a single matrix and perform the projection in one shot. This increases the size of the matmuls of the input projections and improves the impact of quantization (to be discussed next).",al,Ge,gn="Enabling this kind of computation in Diffusers just takes a single line of code:",il,$e,pl,Ae,Zn="It provides a minor boost from 2.54 seconds to 2.52 seconds.",ol,F,In='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_4.png" width="500"/>',rl,H,cl,I,N,Mt,Be,El,it,kn="Dynamic quantization",ul,We,xn='Aapply <a href="https://pytorch.org/tutorials/recipes/recipes/dynamic_quantization.html" rel="nofollow">dynamic int8 quantization</a> to both the UNet and the VAE. This is because quantization adds additional conversion overhead to the model that is hopefully made up for by faster matmuls (dynamic quantization). If the matmuls are too small, these techniques may degrade performance.',ml,E,hl,Se,Gn='You will leverage the ultra-lightweight pure PyTorch library <a href="https://github.com/pytorch-labs/ao" rel="nofollow">torchao</a> to use its user-friendly APIs for quantization.',Ml,Xe,$n="First, configure all the compiler tags:",fl,Ve,dl,Fe,An="Define the filtering functions:",yl,He,wl,Ne,Bn="Then apply all the optimizations discussed so far:",jl,Ee,bl,Re,Wn="Since this quantization support is limited to linear layers only, we also turn suitable pointwise convolution layers into linear layers to maximize the benefit.",Jl,Qe,Tl,Ye,Sn="Apply dynamic quantization:",Ul,Le,vl,ze,Xn="Finally, compile and perform inference:",Cl,De,_l,qe,Vn="Applying dynamic quantization improves the latency from 2.52 seconds to 2.43 seconds.",gl,R,Fn='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_5.png" width="500"/>',Zl;return Y=new Q({}),q=new Q({}),K=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZGlmZnVzZXJz",highlighted:"pip install -U diffusers"}}),ee=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMHBlZnQ=",highlighted:"pip install -U transformers accelerate peft"}}),se=new Q({}),ie=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwcGlwZWxpbmUlMjBpbiUyMGZ1bGwtcHJlY2lzaW9uJTIwYW5kJTIwcGxhY2UlMjBpdHMlMjBtb2RlbCUyMGNvbXBvbmVudHMlMjBvbiUyMENVREEuJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBSdW4lMjB0aGUlMjBhdHRlbnRpb24lMjBvcHMlMjB3aXRob3V0JTIwZWZmaWNpZW5jeS4lMEFwaXBlLnVuZXQuc2V0X2RlZmF1bHRfYXR0bl9wcm9jZXNzb3IoKSUwQXBpcGUudmFlLnNldF9kZWZhdWx0X2F0dG5fcHJvY2Vzc29yKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

<span class="hljs-comment"># Load the pipeline in full-precision and place its model components on CUDA.</span>
pipe = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Run the attention ops without efficiency.</span>
pipe.unet.set_default_attn_processor()
pipe.vae.set_default_attn_processor()

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`}}),oe=new Q({}),ce=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMDklMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMFJ1biUyMHRoZSUyMGF0dGVudGlvbiUyMG9wcyUyMHdpdGhvdXQlMjBlZmZpY2llbmN5LiUwQXBpcGUudW5ldC5zZXRfZGVmYXVsdF9hdHRuX3Byb2Nlc3NvcigpJTBBcGlwZS52YWUuc2V0X2RlZmF1bHRfYXR0bl9wcm9jZXNzb3IoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipe = StableDiffusionXLPipeline.from_pretrained(
	<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Run the attention ops without efficiency.</span>
pipe.unet.set_default_attn_processor()
pipe.vae.set_default_attn_processor()

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`}}),fe=new Q({}),ye=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMDklMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipe = StableDiffusionXLPipeline.from_pretrained(
	<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`}}),je=new Q({}),Je=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29udl8xeDFfYXNfbW0lMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb29yZGluYXRlX2Rlc2NlbnRfdHVuaW5nJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZXBpbG9ndWVfZnVzaW9uJTIwJTNEJTIwRmFsc2UlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF9jaGVja19hbGxfZGlyZWN0aW9ucyUyMCUzRCUyMFRydWU=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>`}}),ve=new b({props:{code:"cGlwZS51bmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQXBpcGUudmFlLnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KQ==",highlighted:`pipe.unet.to(memory_format=torch.channels_last)
pipe.vae.to(memory_format=torch.channels_last)`}}),_e=new b({props:{code:"JTIzJTIwQ29tcGlsZSUyMHRoZSUyMFVOZXQlMjBhbmQlMjBWQUUuJTBBcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEFwaXBlLnZhZS5kZWNvZGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGUudmFlLmRlY29kZSUyQyUyMG1vZGUlM0QlMjJtYXgtYXV0b3R1bmUlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEElMEElMjMlMjBGaXJzdCUyMGNhbGwlMjB0byUyMCU2MHBpcGUlNjAlMjB3aWxsJTIwYmUlMjBzbG93JTJDJTIwc3Vic2VxdWVudCUyMG9uZXMlMjB3aWxsJTIwYmUlMjBmYXN0ZXIuJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-comment"># Compile the UNet and VAE.</span>
pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipe.vae.decode = torch.<span class="hljs-built_in">compile</span>(pipe.vae.decode, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># First call to \`pipe\` will be slow, subsequent ones will be faster.</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`}}),Ie=new Q({}),$e=new b({props:{code:"cGlwZS5mdXNlX3Frdl9wcm9qZWN0aW9ucygp",highlighted:"pipe.fuse_qkv_projections()"}}),H=new ls({props:{warning:!0,$$slots:{default:[rs]},$$scope:{ctx:Ke}}}),Be=new Q({}),E=new ls({props:{$$slots:{default:[cs]},$$scope:{ctx:Ke}}}),Ve=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUyMCUwQSUwQSUyMyUyME5vdGljZSUyMHRoZSUyMHR3byUyMG5ldyUyMGZsYWdzJTIwYXQlMjB0aGUlMjBlbmQuJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb252XzF4MV9hc19tbSUyMCUzRCUyMFRydWUlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF90dW5pbmclMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5lcGlsb2d1ZV9mdXNpb24lMjAlM0QlMjBGYWxzZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29vcmRpbmF0ZV9kZXNjZW50X2NoZWNrX2FsbF9kaXJlY3Rpb25zJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZm9yY2VfZnVzZV9pbnRfbW1fd2l0aF9tdWwlMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy51c2VfbWl4ZWRfbW0lMjAlM0QlMjBUcnVl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch 

<span class="hljs-comment"># Notice the two new flags at the end.</span>
torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>
torch._inductor.config.force_fuse_int_mm_with_mul = <span class="hljs-literal">True</span>
torch._inductor.config.use_mixed_mm = <span class="hljs-literal">True</span>`}}),He=new b({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">dynamic_quant_filter_fn</span>(<span class="hljs-params">mod, *args</span>):
    <span class="hljs-keyword">return</span> (
        <span class="hljs-built_in">isinstance</span>(mod, torch.nn.Linear)
        <span class="hljs-keyword">and</span> mod.in_features &gt; <span class="hljs-number">16</span>
        <span class="hljs-keyword">and</span> (mod.in_features, mod.out_features)
        <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [
            (<span class="hljs-number">1280</span>, <span class="hljs-number">640</span>),
            (<span class="hljs-number">1920</span>, <span class="hljs-number">1280</span>),
            (<span class="hljs-number">1920</span>, <span class="hljs-number">640</span>),
            (<span class="hljs-number">2048</span>, <span class="hljs-number">1280</span>),
            (<span class="hljs-number">2048</span>, <span class="hljs-number">2560</span>),
            (<span class="hljs-number">2560</span>, <span class="hljs-number">1280</span>),
            (<span class="hljs-number">256</span>, <span class="hljs-number">128</span>),
            (<span class="hljs-number">2816</span>, <span class="hljs-number">1280</span>),
            (<span class="hljs-number">320</span>, <span class="hljs-number">640</span>),
            (<span class="hljs-number">512</span>, <span class="hljs-number">1536</span>),
            (<span class="hljs-number">512</span>, <span class="hljs-number">256</span>),
            (<span class="hljs-number">512</span>, <span class="hljs-number">512</span>),
            (<span class="hljs-number">640</span>, <span class="hljs-number">1280</span>),
            (<span class="hljs-number">640</span>, <span class="hljs-number">1920</span>),
            (<span class="hljs-number">640</span>, <span class="hljs-number">320</span>),
            (<span class="hljs-number">640</span>, <span class="hljs-number">5120</span>),
            (<span class="hljs-number">640</span>, <span class="hljs-number">640</span>),
            (<span class="hljs-number">960</span>, <span class="hljs-number">320</span>),
            (<span class="hljs-number">960</span>, <span class="hljs-number">640</span>),
        ]
    )


<span class="hljs-keyword">def</span> <span class="hljs-title function_">conv_filter_fn</span>(<span class="hljs-params">mod, *args</span>):
    <span class="hljs-keyword">return</span> (
        <span class="hljs-built_in">isinstance</span>(mod, torch.nn.Conv2d) <span class="hljs-keyword">and</span> mod.kernel_size == (<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) <span class="hljs-keyword">and</span> <span class="hljs-number">128</span> <span class="hljs-keyword">in</span> [mod.in_channels, mod.out_channels]
    )`}}),Ee=new b({props:{code:"JTIzJTIwU0RQQSUyMCUyQiUyMGJmbG9hdDE2LiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMDklMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMENvbWJpbmUlMjBhdHRlbnRpb24lMjBwcm9qZWN0aW9uJTIwbWF0cmljZXMuJTBBcGlwZS5mdXNlX3Frdl9wcm9qZWN0aW9ucygpJTBBJTBBJTIzJTIwQ2hhbmdlJTIwdGhlJTIwbWVtb3J5JTIwbGF5b3V0LiUwQXBpcGUudW5ldC50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEFwaXBlLnZhZS50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCk=",highlighted:`<span class="hljs-comment"># SDPA + bfloat16.</span>
pipe = StableDiffusionXLPipeline.from_pretrained(
	<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Combine attention projection matrices.</span>
pipe.fuse_qkv_projections()

<span class="hljs-comment"># Change the memory layout.</span>
pipe.unet.to(memory_format=torch.channels_last)
pipe.vae.to(memory_format=torch.channels_last)`}}),Qe=new b({props:{code:"ZnJvbSUyMHRvcmNoYW8lMjBpbXBvcnQlMjBzd2FwX2NvbnYyZF8xeDFfdG9fbGluZWFyJTBBJTBBc3dhcF9jb252MmRfMXgxX3RvX2xpbmVhcihwaXBlLnVuZXQlMkMlMjBjb252X2ZpbHRlcl9mbiklMEFzd2FwX2NvbnYyZF8xeDFfdG9fbGluZWFyKHBpcGUudmFlJTJDJTIwY29udl9maWx0ZXJfZm4p",highlighted:`<span class="hljs-keyword">from</span> torchao <span class="hljs-keyword">import</span> swap_conv2d_1x1_to_linear

swap_conv2d_1x1_to_linear(pipe.unet, conv_filter_fn)
swap_conv2d_1x1_to_linear(pipe.vae, conv_filter_fn)`}}),Le=new b({props:{code:"ZnJvbSUyMHRvcmNoYW8lMjBpbXBvcnQlMjBhcHBseV9keW5hbWljX3F1YW50JTBBJTBBYXBwbHlfZHluYW1pY19xdWFudChwaXBlLnVuZXQlMkMlMjBkeW5hbWljX3F1YW50X2ZpbHRlcl9mbiklMEFhcHBseV9keW5hbWljX3F1YW50KHBpcGUudmFlJTJDJTIwZHluYW1pY19xdWFudF9maWx0ZXJfZm4p",highlighted:`<span class="hljs-keyword">from</span> torchao <span class="hljs-keyword">import</span> apply_dynamic_quant

apply_dynamic_quant(pipe.unet, dynamic_quant_filter_fn)
apply_dynamic_quant(pipe.vae, dynamic_quant_filter_fn)`}}),De=new b({props:{code:"cGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEFwaXBlLnZhZS5kZWNvZGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGUudmFlLmRlY29kZSUyQyUyMG1vZGUlM0QlMjJtYXgtYXV0b3R1bmUlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwKS5pbWFnZXMlNUIwJTVE",highlighted:`pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipe.vae.decode = torch.<span class="hljs-built_in">compile</span>(pipe.vae.decode, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`}}),{c(){u=s("meta"),T=i(),j=s("h1"),J=s("a"),pt=s("span"),m(Y.$$.fragment),Wl=i(),Oe=s("span"),Oe.textContent=Rl,dt=i(),L=s("p"),L.textContent=Ql,yt=i(),z=s("ul"),z.innerHTML=Yl,wt=i(),D=s("p"),D.innerHTML=Ll,jt=i(),U=s("h2"),k=s("a"),ot=s("span"),m(q.$$.fragment),Sl=i(),et=s("span"),et.textContent=zl,bt=i(),P=s("p"),P.innerHTML=Dl,Jt=i(),m(K.$$.fragment),Tt=i(),O=s("p"),O.textContent=ql,Ut=i(),m(ee.$$.fragment),vt=i(),te=s("p"),te.innerHTML=Pl,Ct=i(),le=s("p"),le.textContent=Kl,_t=i(),ne=s("p"),ne.innerHTML=Ol,gt=i(),v=s("h2"),x=s("a"),rt=s("span"),m(se.$$.fragment),Xl=i(),tt=s("span"),tt.textContent=en,Zt=i(),ae=s("p"),ae.innerHTML=tn,It=i(),m(ie.$$.fragment),kt=i(),pe=s("p"),pe.textContent=ln,xt=i(),G=s("div"),G.innerHTML=nn,Gt=i(),C=s("h2"),$=s("a"),ct=s("span"),m(oe.$$.fragment),Vl=i(),lt=s("span"),lt.textContent=sn,$t=i(),re=s("p"),re.textContent=an,At=i(),m(ce.$$.fragment),Bt=i(),ue=s("p"),ue.textContent=pn,Wt=i(),A=s("div"),A.innerHTML=on,St=i(),me=s("p"),me.innerHTML=rn,Xt=i(),he=s("ul"),he.innerHTML=cn,Vt=i(),Me=s("p"),Me.innerHTML=un,Ft=i(),_=s("h2"),B=s("a"),ut=s("span"),m(fe.$$.fragment),Fl=i(),nt=s("span"),nt.textContent=mn,Ht=i(),de=s("p"),de.innerHTML=hn,Nt=i(),m(ye.$$.fragment),Et=i(),we=s("p"),we.innerHTML=Mn,Rt=i(),W=s("div"),W.innerHTML=fn,Qt=i(),g=s("h2"),S=s("a"),mt=s("span"),m(je.$$.fragment),Hl=i(),st=s("span"),st.textContent=dn,Yt=i(),be=s("p"),be.textContent=yn,Lt=i(),m(Je.$$.fragment),zt=i(),Te=s("p"),Te.innerHTML=wn,Dt=i(),Ue=s("p"),Ue.textContent=jn,qt=i(),m(ve.$$.fragment),Pt=i(),Ce=s("p"),Ce.textContent=bn,Kt=i(),m(_e.$$.fragment),Ot=i(),ge=s("p"),ge.innerHTML=Jn,el=i(),Ze=s("p"),Ze.textContent=Tn,tl=i(),X=s("div"),X.innerHTML=Un,ll=i(),Z=s("h2"),V=s("a"),ht=s("span"),m(Ie.$$.fragment),Nl=i(),at=s("span"),at.textContent=vn,nl=i(),ke=s("p"),ke.textContent=Cn,sl=i(),xe=s("p"),xe.textContent=_n,al=i(),Ge=s("p"),Ge.textContent=gn,il=i(),m($e.$$.fragment),pl=i(),Ae=s("p"),Ae.textContent=Zn,ol=i(),F=s("div"),F.innerHTML=In,rl=i(),m(H.$$.fragment),cl=i(),I=s("h2"),N=s("a"),Mt=s("span"),m(Be.$$.fragment),El=i(),it=s("span"),it.textContent=kn,ul=i(),We=s("p"),We.innerHTML=xn,ml=i(),m(E.$$.fragment),hl=i(),Se=s("p"),Se.innerHTML=Gn,Ml=i(),Xe=s("p"),Xe.textContent=$n,fl=i(),m(Ve.$$.fragment),dl=i(),Fe=s("p"),Fe.textContent=An,yl=i(),m(He.$$.fragment),wl=i(),Ne=s("p"),Ne.textContent=Bn,jl=i(),m(Ee.$$.fragment),bl=i(),Re=s("p"),Re.textContent=Wn,Jl=i(),m(Qe.$$.fragment),Tl=i(),Ye=s("p"),Ye.textContent=Sn,Ul=i(),m(Le.$$.fragment),vl=i(),ze=s("p"),ze.textContent=Xn,Cl=i(),m(De.$$.fragment),_l=i(),qe=s("p"),qe.textContent=Vn,gl=i(),R=s("div"),R.innerHTML=Fn,this.h()},l(e){const l=os("svelte-1phssyn",document.head);u=a(l,"META",{name:!0,content:!0}),l.forEach(t),T=p(e),j=a(e,"H1",{class:!0});var Pe=w(j);J=a(Pe,"A",{id:!0,class:!0,href:!0});var ft=w(J);pt=a(ft,"SPAN",{});var Hn=w(pt);h(Y.$$.fragment,Hn),Hn.forEach(t),ft.forEach(t),Wl=p(Pe),Oe=a(Pe,"SPAN",{"data-svelte-h":!0}),o(Oe)!=="svelte-dvdb0g"&&(Oe.textContent=Rl),Pe.forEach(t),dt=p(e),L=a(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-pkpiyo"&&(L.textContent=Ql),yt=p(e),z=a(e,"UL",{"data-svelte-h":!0}),o(z)!=="svelte-1n3ja6f"&&(z.innerHTML=Yl),wt=p(e),D=a(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1ahq65p"&&(D.innerHTML=Ll),jt=p(e),U=a(e,"H2",{class:!0});var Il=w(U);k=a(Il,"A",{id:!0,class:!0,href:!0});var Nn=w(k);ot=a(Nn,"SPAN",{});var En=w(ot);h(q.$$.fragment,En),En.forEach(t),Nn.forEach(t),Sl=p(Il),et=a(Il,"SPAN",{"data-svelte-h":!0}),o(et)!=="svelte-1bbncge"&&(et.textContent=zl),Il.forEach(t),bt=p(e),P=a(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-609t4e"&&(P.innerHTML=Dl),Jt=p(e),h(K.$$.fragment,e),Tt=p(e),O=a(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1s5viqc"&&(O.textContent=ql),Ut=p(e),h(ee.$$.fragment,e),vt=p(e),te=a(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-2y23yy"&&(te.innerHTML=Pl),Ct=p(e),le=a(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-zfizj4"&&(le.textContent=Kl),_t=p(e),ne=a(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-teht3n"&&(ne.innerHTML=Ol),gt=p(e),v=a(e,"H2",{class:!0});var kl=w(v);x=a(kl,"A",{id:!0,class:!0,href:!0});var Rn=w(x);rt=a(Rn,"SPAN",{});var Qn=w(rt);h(se.$$.fragment,Qn),Qn.forEach(t),Rn.forEach(t),Xl=p(kl),tt=a(kl,"SPAN",{"data-svelte-h":!0}),o(tt)!=="svelte-pq3mj4"&&(tt.textContent=en),kl.forEach(t),Zt=p(e),ae=a(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-zqipth"&&(ae.innerHTML=tn),It=p(e),h(ie.$$.fragment,e),kt=p(e),pe=a(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1x1lehr"&&(pe.textContent=ln),xt=p(e),G=a(e,"DIV",{align:!0,"data-svelte-h":!0}),o(G)!=="svelte-1do855s"&&(G.innerHTML=nn),Gt=p(e),C=a(e,"H2",{class:!0});var xl=w(C);$=a(xl,"A",{id:!0,class:!0,href:!0});var Yn=w($);ct=a(Yn,"SPAN",{});var Ln=w(ct);h(oe.$$.fragment,Ln),Ln.forEach(t),Yn.forEach(t),Vl=p(xl),lt=a(xl,"SPAN",{"data-svelte-h":!0}),o(lt)!=="svelte-upf0w9"&&(lt.textContent=sn),xl.forEach(t),$t=p(e),re=a(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-59kzwp"&&(re.textContent=an),At=p(e),h(ce.$$.fragment,e),Bt=p(e),ue=a(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1kdjw5n"&&(ue.textContent=pn),Wt=p(e),A=a(e,"DIV",{align:!0,"data-svelte-h":!0}),o(A)!=="svelte-lxnqqr"&&(A.innerHTML=on),St=p(e),me=a(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-17gxfqr"&&(me.innerHTML=rn),Xt=p(e),he=a(e,"UL",{"data-svelte-h":!0}),o(he)!=="svelte-eu6tje"&&(he.innerHTML=cn),Vt=p(e),Me=a(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-ezaz6j"&&(Me.innerHTML=un),Ft=p(e),_=a(e,"H2",{class:!0});var Gl=w(_);B=a(Gl,"A",{id:!0,class:!0,href:!0});var zn=w(B);ut=a(zn,"SPAN",{});var Dn=w(ut);h(fe.$$.fragment,Dn),Dn.forEach(t),zn.forEach(t),Fl=p(Gl),nt=a(Gl,"SPAN",{"data-svelte-h":!0}),o(nt)!=="svelte-bntvlu"&&(nt.textContent=mn),Gl.forEach(t),Ht=p(e),de=a(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-i6cij5"&&(de.innerHTML=hn),Nt=p(e),h(ye.$$.fragment,e),Et=p(e),we=a(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1ya4pwz"&&(we.innerHTML=Mn),Rt=p(e),W=a(e,"DIV",{align:!0,"data-svelte-h":!0}),o(W)!=="svelte-1vt8crq"&&(W.innerHTML=fn),Qt=p(e),g=a(e,"H2",{class:!0});var $l=w(g);S=a($l,"A",{id:!0,class:!0,href:!0});var qn=w(S);mt=a(qn,"SPAN",{});var Pn=w(mt);h(je.$$.fragment,Pn),Pn.forEach(t),qn.forEach(t),Hl=p($l),st=a($l,"SPAN",{"data-svelte-h":!0}),o(st)!=="svelte-1rdd1jk"&&(st.textContent=dn),$l.forEach(t),Yt=p(e),be=a(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-125vukj"&&(be.textContent=yn),Lt=p(e),h(Je.$$.fragment,e),zt=p(e),Te=a(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-wn8tu2"&&(Te.innerHTML=wn),Dt=p(e),Ue=a(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1xhp6zo"&&(Ue.textContent=jn),qt=p(e),h(ve.$$.fragment,e),Pt=p(e),Ce=a(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1huthp1"&&(Ce.textContent=bn),Kt=p(e),h(_e.$$.fragment,e),Ot=p(e),ge=a(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1r146mn"&&(ge.innerHTML=Jn),el=p(e),Ze=a(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-ax8e93"&&(Ze.textContent=Tn),tl=p(e),X=a(e,"DIV",{align:!0,"data-svelte-h":!0}),o(X)!=="svelte-h7n375"&&(X.innerHTML=Un),ll=p(e),Z=a(e,"H2",{class:!0});var Al=w(Z);V=a(Al,"A",{id:!0,class:!0,href:!0});var Kn=w(V);ht=a(Kn,"SPAN",{});var On=w(ht);h(Ie.$$.fragment,On),On.forEach(t),Kn.forEach(t),Nl=p(Al),at=a(Al,"SPAN",{"data-svelte-h":!0}),o(at)!=="svelte-56ftf5"&&(at.textContent=vn),Al.forEach(t),nl=p(e),ke=a(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-1ok923t"&&(ke.textContent=Cn),sl=p(e),xe=a(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1vgoh8g"&&(xe.textContent=_n),al=p(e),Ge=a(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1g4675p"&&(Ge.textContent=gn),il=p(e),h($e.$$.fragment,e),pl=p(e),Ae=a(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1ip60rj"&&(Ae.textContent=Zn),ol=p(e),F=a(e,"DIV",{align:!0,"data-svelte-h":!0}),o(F)!=="svelte-bdlltg"&&(F.innerHTML=In),rl=p(e),h(H.$$.fragment,e),cl=p(e),I=a(e,"H2",{class:!0});var Bl=w(I);N=a(Bl,"A",{id:!0,class:!0,href:!0});var es=w(N);Mt=a(es,"SPAN",{});var ts=w(Mt);h(Be.$$.fragment,ts),ts.forEach(t),es.forEach(t),El=p(Bl),it=a(Bl,"SPAN",{"data-svelte-h":!0}),o(it)!=="svelte-1fsz0t7"&&(it.textContent=kn),Bl.forEach(t),ul=p(e),We=a(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-k2whf5"&&(We.innerHTML=xn),ml=p(e),h(E.$$.fragment,e),hl=p(e),Se=a(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-mctow8"&&(Se.innerHTML=Gn),Ml=p(e),Xe=a(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-gvi9jq"&&(Xe.textContent=$n),fl=p(e),h(Ve.$$.fragment,e),dl=p(e),Fe=a(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-tgt4ub"&&(Fe.textContent=An),yl=p(e),h(He.$$.fragment,e),wl=p(e),Ne=a(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1848xq7"&&(Ne.textContent=Bn),jl=p(e),h(Ee.$$.fragment,e),bl=p(e),Re=a(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1nbn6cl"&&(Re.textContent=Wn),Jl=p(e),h(Qe.$$.fragment,e),Tl=p(e),Ye=a(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-13vdbpw"&&(Ye.textContent=Sn),Ul=p(e),h(Le.$$.fragment,e),vl=p(e),ze=a(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-145l8jb"&&(ze.textContent=Xn),Cl=p(e),h(De.$$.fragment,e),_l=p(e),qe=a(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-od9x3v"&&(qe.textContent=Vn),gl=p(e),R=a(e,"DIV",{align:!0,"data-svelte-h":!0}),o(R)!=="svelte-j96t4n"&&(R.innerHTML=Fn),this.h()},h(){r(u,"name","hf:doc:metadata"),r(u,"content",JSON.stringify(ms)),r(J,"id","accelerate-inference-of-texttoimage-diffusion-models"),r(J,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(J,"href","#accelerate-inference-of-texttoimage-diffusion-models"),r(j,"class","relative group"),r(k,"id","setup"),r(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(k,"href","#setup"),r(U,"class","relative group"),r(x,"id","baseline"),r(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(x,"href","#baseline"),r(v,"class","relative group"),r(G,"align","center"),r($,"id","running-inference-in-bfloat16"),r($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r($,"href","#running-inference-in-bfloat16"),r(C,"class","relative group"),r(A,"align","center"),r(B,"id","running-attention-efficiently"),r(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(B,"href","#running-attention-efficiently"),r(_,"class","relative group"),r(W,"align","center"),r(S,"id","use-faster-kernels-with-torchcompile"),r(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(S,"href","#use-faster-kernels-with-torchcompile"),r(g,"class","relative group"),r(X,"align","center"),r(V,"id","combine-the-projection-matrices-of-attention"),r(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(V,"href","#combine-the-projection-matrices-of-attention"),r(Z,"class","relative group"),r(F,"align","center"),r(N,"id","dynamic-quantization"),r(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(N,"href","#dynamic-quantization"),r(I,"class","relative group"),r(R,"align","center")},m(e,l){c(document.head,u),n(e,T,l),n(e,j,l),c(j,J),c(J,pt),M(Y,pt,null),c(j,Wl),c(j,Oe),n(e,dt,l),n(e,L,l),n(e,yt,l),n(e,z,l),n(e,wt,l),n(e,D,l),n(e,jt,l),n(e,U,l),c(U,k),c(k,ot),M(q,ot,null),c(U,Sl),c(U,et),n(e,bt,l),n(e,P,l),n(e,Jt,l),M(K,e,l),n(e,Tt,l),n(e,O,l),n(e,Ut,l),M(ee,e,l),n(e,vt,l),n(e,te,l),n(e,Ct,l),n(e,le,l),n(e,_t,l),n(e,ne,l),n(e,gt,l),n(e,v,l),c(v,x),c(x,rt),M(se,rt,null),c(v,Xl),c(v,tt),n(e,Zt,l),n(e,ae,l),n(e,It,l),M(ie,e,l),n(e,kt,l),n(e,pe,l),n(e,xt,l),n(e,G,l),n(e,Gt,l),n(e,C,l),c(C,$),c($,ct),M(oe,ct,null),c(C,Vl),c(C,lt),n(e,$t,l),n(e,re,l),n(e,At,l),M(ce,e,l),n(e,Bt,l),n(e,ue,l),n(e,Wt,l),n(e,A,l),n(e,St,l),n(e,me,l),n(e,Xt,l),n(e,he,l),n(e,Vt,l),n(e,Me,l),n(e,Ft,l),n(e,_,l),c(_,B),c(B,ut),M(fe,ut,null),c(_,Fl),c(_,nt),n(e,Ht,l),n(e,de,l),n(e,Nt,l),M(ye,e,l),n(e,Et,l),n(e,we,l),n(e,Rt,l),n(e,W,l),n(e,Qt,l),n(e,g,l),c(g,S),c(S,mt),M(je,mt,null),c(g,Hl),c(g,st),n(e,Yt,l),n(e,be,l),n(e,Lt,l),M(Je,e,l),n(e,zt,l),n(e,Te,l),n(e,Dt,l),n(e,Ue,l),n(e,qt,l),M(ve,e,l),n(e,Pt,l),n(e,Ce,l),n(e,Kt,l),M(_e,e,l),n(e,Ot,l),n(e,ge,l),n(e,el,l),n(e,Ze,l),n(e,tl,l),n(e,X,l),n(e,ll,l),n(e,Z,l),c(Z,V),c(V,ht),M(Ie,ht,null),c(Z,Nl),c(Z,at),n(e,nl,l),n(e,ke,l),n(e,sl,l),n(e,xe,l),n(e,al,l),n(e,Ge,l),n(e,il,l),M($e,e,l),n(e,pl,l),n(e,Ae,l),n(e,ol,l),n(e,F,l),n(e,rl,l),M(H,e,l),n(e,cl,l),n(e,I,l),c(I,N),c(N,Mt),M(Be,Mt,null),c(I,El),c(I,it),n(e,ul,l),n(e,We,l),n(e,ml,l),M(E,e,l),n(e,hl,l),n(e,Se,l),n(e,Ml,l),n(e,Xe,l),n(e,fl,l),M(Ve,e,l),n(e,dl,l),n(e,Fe,l),n(e,yl,l),M(He,e,l),n(e,wl,l),n(e,Ne,l),n(e,jl,l),M(Ee,e,l),n(e,bl,l),n(e,Re,l),n(e,Jl,l),M(Qe,e,l),n(e,Tl,l),n(e,Ye,l),n(e,Ul,l),M(Le,e,l),n(e,vl,l),n(e,ze,l),n(e,Cl,l),M(De,e,l),n(e,_l,l),n(e,qe,l),n(e,gl,l),n(e,R,l),Zl=!0},p(e,[l]){const Pe={};l&2&&(Pe.$$scope={dirty:l,ctx:e}),H.$set(Pe);const ft={};l&2&&(ft.$$scope={dirty:l,ctx:e}),E.$set(ft)},i(e){Zl||(f(Y.$$.fragment,e),f(q.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(se.$$.fragment,e),f(ie.$$.fragment,e),f(oe.$$.fragment,e),f(ce.$$.fragment,e),f(fe.$$.fragment,e),f(ye.$$.fragment,e),f(je.$$.fragment,e),f(Je.$$.fragment,e),f(ve.$$.fragment,e),f(_e.$$.fragment,e),f(Ie.$$.fragment,e),f($e.$$.fragment,e),f(H.$$.fragment,e),f(Be.$$.fragment,e),f(E.$$.fragment,e),f(Ve.$$.fragment,e),f(He.$$.fragment,e),f(Ee.$$.fragment,e),f(Qe.$$.fragment,e),f(Le.$$.fragment,e),f(De.$$.fragment,e),Zl=!0)},o(e){d(Y.$$.fragment,e),d(q.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(ce.$$.fragment,e),d(fe.$$.fragment,e),d(ye.$$.fragment,e),d(je.$$.fragment,e),d(Je.$$.fragment,e),d(ve.$$.fragment,e),d(_e.$$.fragment,e),d(Ie.$$.fragment,e),d($e.$$.fragment,e),d(H.$$.fragment,e),d(Be.$$.fragment,e),d(E.$$.fragment,e),d(Ve.$$.fragment,e),d(He.$$.fragment,e),d(Ee.$$.fragment,e),d(Qe.$$.fragment,e),d(Le.$$.fragment,e),d(De.$$.fragment,e),Zl=!1},d(e){e&&(t(T),t(j),t(dt),t(L),t(yt),t(z),t(wt),t(D),t(jt),t(U),t(bt),t(P),t(Jt),t(Tt),t(O),t(Ut),t(vt),t(te),t(Ct),t(le),t(_t),t(ne),t(gt),t(v),t(Zt),t(ae),t(It),t(kt),t(pe),t(xt),t(G),t(Gt),t(C),t($t),t(re),t(At),t(Bt),t(ue),t(Wt),t(A),t(St),t(me),t(Xt),t(he),t(Vt),t(Me),t(Ft),t(_),t(Ht),t(de),t(Nt),t(Et),t(we),t(Rt),t(W),t(Qt),t(g),t(Yt),t(be),t(Lt),t(zt),t(Te),t(Dt),t(Ue),t(qt),t(Pt),t(Ce),t(Kt),t(Ot),t(ge),t(el),t(Ze),t(tl),t(X),t(ll),t(Z),t(nl),t(ke),t(sl),t(xe),t(al),t(Ge),t(il),t(pl),t(Ae),t(ol),t(F),t(rl),t(cl),t(I),t(ul),t(We),t(ml),t(hl),t(Se),t(Ml),t(Xe),t(fl),t(dl),t(Fe),t(yl),t(wl),t(Ne),t(jl),t(bl),t(Re),t(Jl),t(Tl),t(Ye),t(Ul),t(vl),t(ze),t(Cl),t(_l),t(qe),t(gl),t(R)),t(u),y(Y),y(q),y(K,e),y(ee,e),y(se),y(ie,e),y(oe),y(ce,e),y(fe),y(ye,e),y(je),y(Je,e),y(ve,e),y(_e,e),y(Ie),y($e,e),y(H,e),y(Be),y(E,e),y(Ve,e),y(He,e),y(Ee,e),y(Qe,e),y(Le,e),y(De,e)}}}const ms={local:"accelerate-inference-of-texttoimage-diffusion-models",sections:[{local:"setup",title:"Setup"},{local:"baseline",title:"Baseline"},{local:"running-inference-in-bfloat16",title:"Running inference in bfloat16"},{local:"running-attention-efficiently",title:"Running attention efficiently"},{local:"use-faster-kernels-with-torchcompile",title:"Use faster kernels with torch.compile"},{local:"combine-the-projection-matrices-of-attention",title:"Combine the projection matrices of attention"},{local:"dynamic-quantization",title:"Dynamic quantization"}],title:"Accelerate inference of text-to-image diffusion models"};function hs(Ke){return as(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class js extends is{constructor(u){super(),ps(this,u,hs,us,ss,{})}}export{js as component};
