import{s as na,f as ta,n as aa,o as pa}from"../chunks/scheduler.39a43cde.js";import{S as Ma,i as ia,g as p,s as n,r as o,A as oa,h as M,f as t,c as a,j as sa,u as y,x as i,k as Ce,y as ya,a as s,v as r,d as c,t as m,w as J}from"../chunks/index.23ec2204.js";import{D as ra,C as T}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as U}from"../chunks/Heading.c42e7061.js";function ca(_s){let j,Re,fe,Ee,u,ge,d,Ne,w,As='<em>作者: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',ke,h,Vs="这个 notebook 主要讲述了你怎么构建一个高级的 RAG，用于回答一个关于特定知识库的问题（这里，是 HuggingFace 文档），使用 LangChain。",Ze,b,vs='对于 RAG 的介绍，你可以查看<a href="rag_zephyr_langch">这个教程</a>',Be,C,Ws="RAG 系统是复杂的，它有许多组块:这里画一个简单的 RAG 图表，其中用蓝色标注了所有系统增强的可能性。",Ge,f,Qs,_e,I,xs="<p>💡 可以看到，这个架构中有许多步骤可以调整：正确调整系统将带来显著的性能提升。</p>",Ae,R,zs="在这个 notebook 中，我们将研究许多这些蓝色标注的部分，看看如何调整你的 RAG 系统以获得最佳性能。",Ve,E,Xs="<strong>让我们深入研究模型架构吧！</strong> 首先，安装所需的模型依赖项。",ve,g,We,N,Qe,k,xe,Z,ze,B,Xe,G,Se,_,$e,A,Ss="<strong>检索器的作用类似于内部搜索引擎</strong>：给定用户查询，它从你的知识库中返回几个相关的片段。",He,V,$s="这些片段随后将被输入到阅读器模型中，以帮助其生成答案。",qe,v,Hs="所以 <strong>我们的目标在这里是，给定一个用户问题，从我们的知识库中找到最多的片段来回答这个问题。</strong>",Fe,W,qs="这是一个宽泛的目标，它留下了一些问题。我们应该检索多少片段？这个参数将被命名为<code>top_k</code>。",Ye,Q,Fs="这些片段应该有多长？这被称为 <code>chunk size</code> （片段大小）。没有一刀切的答案，但这里有一些要点：",Le,x,Ys='<li>🔀 你的 <code>chunk size</code> 允许从一段片段到另一段片段有所不同。</li> <li>由于你的检索中总会存在一些噪音，增加 <code>top_k</code> 可以提高你检索到的片段中包含相关元素的概率。🎯 射更多的箭增加了你命中目标的概率。</li> <li>同时，你检索到的文档的总长度不应过高：例如，对于大多数当前模型来说，16k 个 token 可能会因为<a href="https://huggingface.co/papers/2307.03172" rel="nofollow">中间丢失现象</a>而在信息中淹没你的阅读器模型。🎯 只给你的阅读器模型提供最相关的见解，而不是一堆书！</li>',Pe,z,Ls="<p>在这个 notebook 中，我们使用 Langchain 库，因为 <strong>它为向量数据库提供了大量的选项，并允许我们在整个处理过程中保留文档的元数据</strong>。</p>",De,X,Ke,S,Ps="<li>在这一部分，<strong>我们将知识库中的文档拆分成更小的片段</strong>，这些片段将是喂给阅读器 LLM 生成答案的片段。</li> <li>目标是准备一组<strong>语义上相关的片段</strong>。因此，它们的大小应该适配确切的想法：太小会截断想法，太大则会稀释它们。</li>",Oe,$,Ds='💡 <em>对于文本拆分存在许多选项：按单词拆分，按句子边界拆分，递归拆分以树状方式处理文档以保留结构信息… 要了解更多关于拆分的信息，我建议你阅读<a href="https://github.com/FullStackRetrieval-com/RetrievalTutorials/blob/main/5_Levels_Of_Text_Splitting.ipynb" rel="nofollow">这个很棒的 notebook</a>，这是由 Greg Kamradt 编写的。</em>',lt,H,Ks="<li><p><strong>递归拆分</strong>使用给定的一组分隔符逐步将文本分解为更小的部分，这些分隔符按从最重要到最不重要的顺序排序。如果第一次拆分没有给出正确大小或形状的片段，该方法会使用不同的分隔符在新的片段上重复自身。例如，使用分隔符列表<code>[&quot;\\n\\n&quot;, &quot;\\n&quot;, &quot;.&quot;, &quot;&quot;]</code>：</p> <ul><li>该方法首先在出现双行中断<code>&quot;\\n\\n&quot;</code>的任何地方拆分文档。</li> <li>结果文档将在简单的行中断<code>&quot;\\n&quot;</code>处再次拆分，然后在句子结尾<code>&quot;.&quot;</code>处拆分。</li> <li>最后，如果有些片段仍然太大，它们将在超过最大大小时拆分。</li></ul></li> <li><p>使用这种方法，整体结构得到了很好的保留，代价是片段大小会有轻微的变化。</p></li>",et,q,Os='<p><a href="https://huggingface.co/spaces/A-Roucher/chunk_visualizer" rel="nofollow">这个空间</a>让你可视化不同的拆分选项如何影响你得到的片段。</p>',tt,F,ln="🔬 让我们用片段大小做一些实验，从任意大小开始，看看拆分是如何工作的。我们使用 Langchain 的 <code>RecursiveCharacterTextSplitter</code> 实现递归拆分。",st,Y,en="<li>参数 <code>chunk_size</code> 控制单个片段的长度：这个长度默认计算为片段中的字符数。</li> <li>参数 <code>chunk_overlap</code> 允许相邻片段彼此有一些重叠。这减少了想法被两个相邻片段之间的拆分切割成两半的概率。我们武断地将这个设置为片段大小的1/10，你可以尝试不同的值！</li>",nt,L,at,P,tn="我们还必须记住，当我们嵌入文档时，我们将使用一个接受特定最大序列长度 <code>max_seq_length</code> 的嵌入模型。",pt,D,sn="因此，我们应该确保我们的片段大小低于这个限制，因为任何更长的片段在处理之前都会被截断，从而失去相关性。",Mt,K,it,O,nn=`Model's maximum sequence length: 512
`,ot,ll,an="👀 可以看到，<strong>片段长度与我们的 512 个 token 的限制不匹配</strong>，并且有些文档超出了限制，因此它们的一部分将在截断中丢失！",yt,el,pn="<li>因此，我们应该更改 <code>RecursiveCharacterTextSplitter</code> 类，以计算 token 数量而不是字符数量。</li> <li>然后，我们可以选择一个特定的片段大小，这里我们会选择低于 512 的阈值：<ul><li>较小的文档可能允许拆分更专注于特定想法的内容。</li> <li>但太小的片段会拆分句子，从而再次失去意义：适当的调整是一个平衡的问题。</li></ul></li>",rt,tl,ct,sl,Mn="➡️ 现在分块长度分布看起来好多了!",mt,nl,Jt,al,on='我们希望为我们知识库的所有片段计算嵌入向量：要了解更多关于句子嵌入的信息，我们建议阅读<a href="https://osanseviero.github.io/hackerllama/blog/posts/sentence_embeddings/" rel="nofollow">这个指南</a>。',Tt,pl,Ut,Ml,yn="一旦所有片段都被嵌入，我们就将它们存储到一个向量数据库中。当用户输入一个查询时，它会被之前使用的同一模型嵌入，并且相似性搜索会返回向量数据库中最接近的文档。",jt,il,rn="因此，技术挑战在于，给定一个查询向量，快速找到向量数据库中这个向量的最近邻。为此，我们需要选择两件事：一个距离度量，以及一个搜索算法，以便在成千上万的记录数据库中快速找到最近邻。",ut,ol,dt,yl,cn='最近邻搜索算法有很多选择：我们选择 Facebook 的 <a href="https://github.com/facebookresearch/faiss" rel="nofollow">FAISS</a>，因为 FAISS 对于大多数用例来说性能足够好，而且它广为人知，因此被广泛实现。',wt,rl,ht,cl,mn='关于距离度量，你可以在<a href="https://osanseviero.github.io/hackerllama/blog/posts/sentence_embeddings/#distance-between-embeddings" rel="nofollow">这里</a>找到一个很好的指南。简而言之：',bt,ml,Jn="<li><strong>余弦相似度</strong>计算两个向量之间的相似性，作为它们相对角度的余弦值：它允许我们比较向量的方向，而不考虑它们的幅度。使用它需要对所有向量进行归一化，将它们重新缩放到单位范数。</li> <li><strong>点积</strong>考虑幅度，有时会有不希望的效果，即增加向量的长度会使它与所有其他向量更相似。</li> <li><strong>欧氏距离</strong>是向量末端之间的距离。</li>",Ct,Jl,Tn='你可以尝试<a href="https://developers.google.com/machine-learning/clustering/similarity/check-your-understanding" rel="nofollow">这个小测</a>来检查你对这些概念的理解。但是一旦向量被归一化，<a href="https://platform.openai.com/docs/guides/embeddings/which-distance-function-should-i-use" rel="nofollow">选择特定的距离度量并不重要</a>。',ft,Tl,Un="我们的特定模型与余弦相似度配合得很好，所以我们选择这个距离度量，并在嵌入模型中以及 FAISS 索引的 <code>distance_strategy</code> 参数中设置它。使用余弦相似度，我们需要归一化我们的嵌入向量。",It,Ul,jn="🚨👇 下面的单元格需要在 A10G 上运行几分钟！",Rt,jl,Et,ul,un="👀 为了可视化搜索最接近的文档，我们使用 PaCMAP 将我们的嵌入向量从 384 维降至 2 维。",gt,dl,dn='💡 <em>我们选择 PaCMAP 而不是其他技术，如 t-SNE 或 UMAP，因为<a href="https://www.nature.com/articles/s42003-022-03628-x#Abs1" rel="nofollow">它效率高（保留局部和全局结构），对初始化参数鲁棒且速度快</a>。</em>',Nt,wl,kt,hl,Zt,bl,Bt,Cl,wn,Gt,fl,hn="➡️ 在上面的图表中，你可以看到知识库文档的空间表示。由于向量嵌入代表了文档的含义，它们在意义上的接近应该在它们的嵌入的接近程度上反映出来。",_t,Il,bn="用户查询的嵌入也被显示出来：我们想要找到意义最接近的 <code>k</code> 个文档，因此我们选择最接近的 <code>k</code> 个向量。",At,Rl,Cn="在 LangChain 向量数据库实现中，这个搜索操作是由方法 <code>vector_database.similarity_search(query)</code> 执行的。",Vt,El,fn="这里是结果：",vt,gl,Wt,Nl,In=`Starting retrieval for user_query='How to create a pipeline object?'...

==================================Top document==================================
\`\`\`

## Available Pipelines:
==================================Metadata==================================
&#123;'source': 'huggingface/diffusers/blob/main/docs/source/en/api/pipelines/deepfloyd_if.md', 'start_index': 16887}
`,Qt,kl,xt,Zl,Rn="在这一部分，<strong>LLM 阅读器读取检索到的上下文以形成其答案。</strong>",zt,Bl,En="实际上有多个可以调整的子步骤：",Xt,Gl,gn="<li>检索到的文档内容被聚合并放入“上下文”中，这其中有许多处理选项，如<em>提示压缩</em>。</li> <li>上下文和用户查询被聚合并形成一个提示(prompt)，然后交给 LLM 生成其答案。</li>",St,_l,$t,Al,Nn="在选择阅读器模型时，有几个方面很重要：",Ht,Vl,kn="<li>阅读器模型的 <code>max_seq_length</code> 必须适应我们的提示(prompt)，其中包括检索器调用输出的上下文：上下文包括 5 个每份 512 个 token 的文档，所以我们至少需要 4k 个 token 的上下文长度。</li> <li>阅读器模型</li>",qt,vl,Zn='在这个例子中，我们选择了 <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a>，这是一个小而强大的模型。',Ft,Wl,Bn='由于每周都会发布许多模型，你可能想要用最新最好的模型替换这个模型。跟踪开源 LLM 的最佳方式是查看 <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open-source LLM leaderboard</a>。',Yt,Ql,Gn="为了加速推理，我们将加载模型的量化版本：",Lt,xl,Pt,zl,Dt,Xl,Kt,Sl,_n="下面的 RAG 提示模板是我们将要提供给阅读器 LLM 的内容：需要将其格式化为阅读器 LLM 的聊天模板,这点非常重要。",Ot,$l,An="我们向其提供我们的上下文和用户的问题。",ls,Hl,es,ql,Vn=`<|system|>
Using the information contained in the context, 
give a comprehensive answer to the question.
Respond only to the question asked, response should be concise and relevant to the question.
Provide the number of the source document when relevant.
If the answer cannot be deduced from the context, do not give an answer.
<|user|>
Context:
&#123;context}
---
Now here is the question you need to answer.

Question: &#123;question}
<|assistant|>
`,ts,Fl,vn="让我们在之前检索的文档上测试我们的阅读器!",ss,Yl,ns,Ll,Wn=`To create a pipeline object, follow these steps:

1. Define the inputs and outputs of your pipeline. These could be strings, dictionaries, or any other format that best suits your use case.

2. Inherit the \`Pipeline\` class from the \`transformers\` module and implement the following methods:

   - \`preprocess\`: This method takes the raw inputs and returns a preprocessed dictionary that can be passed to the model.

   - \`_forward\`: This method performs the actual inference using the model and returns the output tensor.

   - \`postprocess\`: This method takes the output tensor and returns the final output in the desired format.

   - \`_sanitize_parameters\`: This method is used to sanitize the input parameters before passing them to the model.

3. Load the necessary components, such as the model and scheduler, into the pipeline object.

4. Instantiate the pipeline object and return it.

Here's an example implementation based on the given context:

\`\`\`python
from transformers import Pipeline
import torch
from diffusers import StableDiffusionPipeline

class MyPipeline(Pipeline):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.pipe = StableDiffusionPipeline.from_pretrained("my_model")

    def preprocess(self, inputs):
        # Preprocess the inputs as needed
        return &#123;"input_ids":...}

    def _forward(self, inputs):
        # Run the forward pass of the model
        return self.pipe(**inputs).images[0]

    def postprocess(self, outputs):
        # Postprocess the outputs as needed
        return outputs["sample"]

    def _sanitize_parameters(self, params):
        # Sanitize the input parameters
        return params

my_pipeline = MyPipeline()
result = my_pipeline("My input string")
print(result)
\`\`\`

Note that this implementation assumes that the model and scheduler are already loaded into memory. If they need to be loaded dynamically, you can modify the \`__init__\` method accordingly.
`,as,Pl,ps,Dl,Qn="对于 RAG 来说，通常更好的选择会最终检索出比你想要的更多的文档，然后在保留 <code>top_k</code> 之前，使用更强大的检索模型对结果进行重新排序。",Ms,Kl,xn='为此，<a href="https://arxiv.org/abs/2112.01488" rel="nofollow">Colbertv2</a>是一个很好的选择：它不是像我们传统的嵌入模型那样的双向编码器，而是一个交叉编码器，它计算查询 token 与每个文档 token 之间更细致的交互。',is,Ol,zn='由于有了 <a href="https://github.com/bclavie/RAGatouille" rel="nofollow">RAGatouille 库</a>，它的使用变得非常简单。',os,le,ys,ee,rs,te,cs,se,Xn="让我们看看我们的 RAG 流水线是怎么回答用户的询问的。",ms,ne,Js,ae,Sn=`=> Retrieving documents...
`,Ts,pe,Us,Me,$n=`==================================Answer==================================
To create a pipeline object, follow these steps:

1. Import the \`pipeline\` function from the \`transformers\` module:

   \`\`\`python
   from transformers import pipeline
   \`\`\`

2. Choose the task you want to perform, such as object detection, sentiment analysis, or image generation, and pass it as an argument to the \`pipeline\` function:

   - For object detection:

     \`\`\`python
     >>> object_detector = pipeline('object-detection')
     >>> object_detector(image)
     [&#123;'score': 0.9982201457023621,
       'label':'remote',
       'box': &#123;'xmin': 40, 'ymin': 70, 'xmax': 175, 'ymax': 117}},
     ...]
     \`\`\`

   - For sentiment analysis:

     \`\`\`python
     >>> classifier = pipeline("sentiment-analysis")
     >>> classifier("This is a great product!")
     &#123;'labels': ['POSITIVE'],'scores': tensor([0.9999], device='cpu', dtype=torch.float32)}
     \`\`\`

   - For image generation:

     \`\`\`python
     >>> image = pipeline(
    ... "stained glass of darth vader, backlight, centered composition, masterpiece, photorealistic, 8k"
    ... ).images[0]
     >>> image
     PILImage mode RGB size 7680x4320 at 0 DPI
     \`\`\`

Note that the exact syntax may vary depending on the specific pipeline being used. Refer to the documentation for more details on how to use each pipeline.

In general, the process involves importing the necessary modules, selecting the desired pipeline task, and passing it to the \`pipeline\` function along with any required arguments. The resulting pipeline object can then be used to perform the selected task on input data.
==================================Source docs==================================
Document 0------------------------------------------------------------
# Allocate a pipeline for object detection
>>> object_detector = pipeline('object-detection')
>>> object_detector(image)
[&#123;'score': 0.9982201457023621,
  'label': 'remote',
  'box': &#123;'xmin': 40, 'ymin': 70, 'xmax': 175, 'ymax': 117}},
 &#123;'score': 0.9960021376609802,
  'label': 'remote',
  'box': &#123;'xmin': 333, 'ymin': 72, 'xmax': 368, 'ymax': 187}},
 &#123;'score': 0.9954745173454285,
  'label': 'couch',
  'box': &#123;'xmin': 0, 'ymin': 1, 'xmax': 639, 'ymax': 473}},
 &#123;'score': 0.9988006353378296,
  'label': 'cat',
  'box': &#123;'xmin': 13, 'ymin': 52, 'xmax': 314, 'ymax': 470}},
 &#123;'score': 0.9986783862113953,
  'label': 'cat',
  'box': &#123;'xmin': 345, 'ymin': 23, 'xmax': 640, 'ymax': 368}}]
Document 1------------------------------------------------------------
# Allocate a pipeline for object detection
>>> object_detector = pipeline('object_detection')
>>> object_detector(image)
[&#123;'score': 0.9982201457023621,
  'label': 'remote',
  'box': &#123;'xmin': 40, 'ymin': 70, 'xmax': 175, 'ymax': 117}},
 &#123;'score': 0.9960021376609802,
  'label': 'remote',
  'box': &#123;'xmin': 333, 'ymin': 72, 'xmax': 368, 'ymax': 187}},
 &#123;'score': 0.9954745173454285,
  'label': 'couch',
  'box': &#123;'xmin': 0, 'ymin': 1, 'xmax': 639, 'ymax': 473}},
 &#123;'score': 0.9988006353378296,
  'label': 'cat',
  'box': &#123;'xmin': 13, 'ymin': 52, 'xmax': 314, 'ymax': 470}},
 &#123;'score': 0.9986783862113953,
  'label': 'cat',
  'box': &#123;'xmin': 345, 'ymin': 23, 'xmax': 640, 'ymax': 368}}]
Document 2------------------------------------------------------------
Start by creating an instance of [\`pipeline\`] and specifying a task you want to use it for. In this guide, you'll use the [\`pipeline\`] for sentiment analysis as an example:

\`\`\`py
>>> from transformers import pipeline

>>> classifier = pipeline("sentiment-analysis")
Document 3------------------------------------------------------------
\`\`\`

## Add the pipeline to 🤗 Transformers

If you want to contribute your pipeline to 🤗 Transformers, you will need to add a new module in the \`pipelines\` submodule
with the code of your pipeline, then add it to the list of tasks defined in \`pipelines/__init__.py\`.

Then you will need to add tests. Create a new file \`tests/test_pipelines_MY_PIPELINE.py\` with examples of the other tests.

The \`run_pipeline_test\` function will be very generic and run on small random models on every possible
architecture as defined by \`model_mapping\` and \`tf_model_mapping\`.

This is very important to test future compatibility, meaning if someone adds a new model for
\`XXXForQuestionAnswering\` then the pipeline test will attempt to run on it. Because the models are random it's
impossible to check for actual values, that's why there is a helper \`ANY\` that will simply attempt to match the
output of the pipeline TYPE.

You also *need* to implement 2 (ideally 4) tests.

- \`test_small_model_pt\` : Define 1 small model for this pipeline (doesn't matter if the results don't make sense)
  and test the pipeline outputs. The results should be the same as \`test_small_model_tf\`.
- \`test_small_model_tf\` : Define 1 small model for this pipeline (doesn't matter if the results don't make sense)
  and test the pipeline outputs. The results should be the same as \`test_small_model_pt\`.
- \`test_large_model_pt\` (\`optional\`): Tests the pipeline on a real pipeline where the results are supposed to
  make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
  sure there is no drift in future releases.
- \`test_large_model_tf\` (\`optional\`): Tests the pipeline on a real pipeline where the results are supposed to
  make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
  sure there is no drift in future releases.
Document 4------------------------------------------------------------
\`\`\`

2. Pass a prompt to the pipeline to generate an image:

\`\`\`py
image = pipeline(
	"stained glass of darth vader, backlight, centered composition, masterpiece, photorealistic, 8k"
).images[0]
image
`,js,ie,Hn="✅ 现在我们已经拥有了一个完整且性能出色的 RAG 系统。今天的教程就到这里！恭喜你坚持到了最后 🥳",us,oe,ds,ye,qn="这并不是旅程的终点！你可以尝试许多步骤来改进你的 RAG 系统。我们建议以迭代的方式进行：对系统进行小的更改，看看哪些可以提升性能。",ws,re,hs,ce,Fn="<li>💬 “你不能改进你没有衡量的模型性能”，甘地说过… 或者至少 Llama2 告诉我他这么说过。无论如何，你绝对应该从衡量性能开始：这意味着构建一个小的评估数据集，然后在评估数据集上监控你的 RAG 系统的性能。</li>",bs,me,Cs,Je,Yn="🛠️ <strong>你可以使用这些选项来调整结果：</strong>",fs,Te,Ln='<li><p>调整分块方法：</p> <ul><li>片段的大小</li> <li>方法：使用不同的分隔符进行拆分，使用<a href="https://python.langchain.com/docs/modules/data_connection/document_transformers/semantic-chunker" rel="nofollow">语义分块</a>…</li></ul></li> <li><p>更改嵌入模型</p></li>',Is,Ue,Pn="👷‍♀️ <strong>还可以考虑以下事项：</strong>",Rs,je,Dn="<li>尝试另一种分块方法，如语义分块</li> <li>更改使用的索引（这里使用的是 FAISS）</li> <li>查询扩展：以略微不同的方式重新构建用户查询以检索更多文档。</li>",Es,ue,gs,de,Kn="🛠️ <strong>这里你可以尝试以下选项来改善结果：</strong>",Ns,we,On="<li>调整提示</li> <li>开启/关闭重排序</li> <li>选择一个更强大的阅读器模型</li>",ks,he,la="💡 <strong>这里有许多选项可以考虑以进一步改善结果：</strong>",Zs,be,ea="<li>压缩检索到的上下文，只保留与回答查询最相关的部分。</li> <li>扩展 RAG 系统，使其更加用户友好：<ul><li>引用来源</li> <li>使其能够进行对话</li></ul></li>",Bs,Ie,Gs;return u=new ra({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/advanced_rag.ipynb"}]}}),d=new U({props:{title:"使用 LangChain 在 HuggingFace 文档上构建高级 RAG",local:"使用-langchain-在-huggingface-文档上构建高级-rag",headingTag:"h1"}}),g=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMGxhbmdjaGFpbiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWdwdSUyMG9wZW5weXhsJTIwcGFjbWFw",highlighted:"!pip install -q torch transformers transformers accelerate bitsandbytes langchain sentence-transformers faiss-gpu openpyxl pacmap",wrap:!1}}),N=new T({props:{code:"JTI1cmVsb2FkX2V4dCUyMGRvdGVudiUwQSUyNWRvdGVudg==",highlighted:`%reload_ext dotenv
%dotenv`,wrap:!1}}),k=new T({props:{code:"ZnJvbSUyMHRxZG0ubm90ZWJvb2slMjBpbXBvcnQlMjB0cWRtJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBPcHRpb25hbCUyQyUyMExpc3QlMkMlMjBUdXBsZSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMERhdGFzZXQlMEFpbXBvcnQlMjBtYXRwbG90bGliLnB5cGxvdCUyMGFzJTIwcGx0JTBBJTBBcGQuc2V0X29wdGlvbiglMjJkaXNwbGF5Lm1heF9jb2x3aWR0aCUyMiUyQyUyME5vbmUpJTIwJTIwJTIzJTIwdGhpcyUyMHdpbGwlMjBiZSUyMGhlbHBmdWwlMjB3aGVuJTIwdmlzdWFsaXppbmclMjByZXRyaWV2ZXIlMjBvdXRwdXRz",highlighted:`<span class="hljs-keyword">from</span> tqdm.notebook <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Tuple</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

pd.set_option(<span class="hljs-string">&quot;display.max_colwidth&quot;</span>, <span class="hljs-literal">None</span>)  <span class="hljs-comment"># this will be helpful when visualizing retriever outputs</span>`,wrap:!1}}),Z=new U({props:{title:"加载你的知识基础",local:"加载你的知识基础",headingTag:"h3"}}),B=new T({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFkcyUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

ds = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),G=new T({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTIwYXMlMjBMYW5nY2hhaW5Eb2N1bWVudCUwQSUwQVJBV19LTk9XTEVER0VfQkFTRSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMExhbmdjaGFpbkRvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMHRxZG0oZHMpJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document <span class="hljs-keyword">as</span> LangchainDocument

RAW_KNOWLEDGE_BASE = [
    LangchainDocument(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(ds)
]`,wrap:!1}}),_=new U({props:{title:"1. 检索器- 嵌入 🗂️",local:"1-检索器--嵌入-",headingTag:"h1"}}),X=new U({props:{title:"1.1 将文档拆分为片段(chuncks)",local:"11-将文档拆分为片段chuncks",headingTag:"h3"}}),L=new T({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBJTBBJTIzJTIwV2UlMjB1c2UlMjBhJTIwaGllcmFyY2hpY2FsJTIwbGlzdCUyMG9mJTIwc2VwYXJhdG9ycyUyMHNwZWNpZmljYWxseSUyMHRhaWxvcmVkJTIwZm9yJTIwc3BsaXR0aW5nJTIwTWFya2Rvd24lMjBkb2N1bWVudHMlMEElMjMlMjBUaGlzJTIwbGlzdCUyMGlzJTIwdGFrZW4lMjBmcm9tJTIwTGFuZ0NoYWluJ3MlMjBNYXJrZG93blRleHRTcGxpdHRlciUyMGNsYXNzLiUwQU1BUktET1dOX1NFUEFSQVRPUlMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjIlNUNuJTIzJTdCMSUyQzYlN0QlMjAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjIlNjAlNjAlNjAlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyJTVDbiU1QyU1QyolNUMlNUMqJTVDJTVDKiUyQiU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjIlNUNuLS0tJTJCJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMiU1Q25fX18lMkIlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyJTVDbiU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjIlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTJDJTBBJTVEJTBBJTBBdGV4dF9zcGxpdHRlciUyMCUzRCUyMFJlY3Vyc2l2ZUNoYXJhY3RlclRleHRTcGxpdHRlciglMEElMjAlMjAlMjAlMjBjaHVua19zaXplJTNEMTAwMCUyQyUyMCUyMCUyMyUyMHRoZSUyMG1heGltdW0lMjBudW1iZXIlMjBvZiUyMGNoYXJhY3RlcnMlMjBpbiUyMGElMjBjaHVuayUzQSUyMHdlJTIwc2VsZWN0ZWQlMjB0aGlzJTIwdmFsdWUlMjBhcmJpdHJhcmlseSUwQSUyMCUyMCUyMCUyMGNodW5rX292ZXJsYXAlM0QxMDAlMkMlMjAlMjAlMjMlMjB0aGUlMjBudW1iZXIlMjBvZiUyMGNoYXJhY3RlcnMlMjB0byUyMG92ZXJsYXAlMjBiZXR3ZWVuJTIwY2h1bmtzJTBBJTIwJTIwJTIwJTIwYWRkX3N0YXJ0X2luZGV4JTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMElmJTIwJTYwVHJ1ZSU2MCUyQyUyMGluY2x1ZGVzJTIwY2h1bmsncyUyMHN0YXJ0JTIwaW5kZXglMjBpbiUyMG1ldGFkYXRhJTBBJTIwJTIwJTIwJTIwc3RyaXBfd2hpdGVzcGFjZSUzRFRydWUlMkMlMjAlMjAlMjMlMjBJZiUyMCU2MFRydWUlNjAlMkMlMjBzdHJpcHMlMjB3aGl0ZXNwYWNlJTIwZnJvbSUyMHRoZSUyMHN0YXJ0JTIwYW5kJTIwZW5kJTIwb2YlMjBldmVyeSUyMGRvY3VtZW50JTBBJTIwJTIwJTIwJTIwc2VwYXJhdG9ycyUzRE1BUktET1dOX1NFUEFSQVRPUlMlMkMlMEEpJTBBJTBBZG9jc19wcm9jZXNzZWQlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjBkb2MlMjBpbiUyMFJBV19LTk9XTEVER0VfQkFTRSUzQSUwQSUyMCUyMCUyMCUyMGRvY3NfcHJvY2Vzc2VkJTIwJTJCJTNEJTIwdGV4dF9zcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoJTVCZG9jJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter

<span class="hljs-comment"># We use a hierarchical list of separators specifically tailored for splitting Markdown documents</span>
<span class="hljs-comment"># This list is taken from LangChain&#x27;s MarkdownTextSplitter class.</span>
MARKDOWN_SEPARATORS = [
    <span class="hljs-string">&quot;\\n#{1,6} &quot;</span>,
    <span class="hljs-string">&quot;\`\`\`\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n\\\\*\\\\*\\\\*+\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n---+\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n___+\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n&quot;</span>,
    <span class="hljs-string">&quot; &quot;</span>,
    <span class="hljs-string">&quot;&quot;</span>,
]

text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">1000</span>,  <span class="hljs-comment"># the maximum number of characters in a chunk: we selected this value arbitrarily</span>
    chunk_overlap=<span class="hljs-number">100</span>,  <span class="hljs-comment"># the number of characters to overlap between chunks</span>
    add_start_index=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># If \`True\`, includes chunk&#x27;s start index in metadata</span>
    strip_whitespace=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># If \`True\`, strips whitespace from the start and end of every document</span>
    separators=MARKDOWN_SEPARATORS,
)

docs_processed = []
<span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> RAW_KNOWLEDGE_BASE:
    docs_processed += text_splitter.split_documents([doc])`,wrap:!1}}),K=new T({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEElMjMlMjBUbyUyMGdldCUyMHRoZSUyMHZhbHVlJTIwb2YlMjB0aGUlMjBtYXglMjBzZXF1ZW5jZV9sZW5ndGglMkMlMjB3ZSUyMHdpbGwlMjBxdWVyeSUyMHRoZSUyMHVuZGVybHlpbmclMjAlNjBTZW50ZW5jZVRyYW5zZm9ybWVyJTYwJTIwb2JqZWN0JTIwdXNlZCUyMGluJTIwdGhlJTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyLiUwQXByaW50KGYlMjJNb2RlbCdzJTIwbWF4aW11bSUyMHNlcXVlbmNlJTIwbGVuZ3RoJTNBJTIwJTdCU2VudGVuY2VUcmFuc2Zvcm1lcigndGhlbmxwZXIlMkZndGUtc21hbGwnKS5tYXhfc2VxX2xlbmd0aCU3RCUyMiklMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnRoZW5scGVyJTJGZ3RlLXNtYWxsJTIyKSUwQWxlbmd0aHMlMjAlM0QlMjAlNUJsZW4odG9rZW5pemVyLmVuY29kZShkb2MucGFnZV9jb250ZW50KSklMjBmb3IlMjBkb2MlMjBpbiUyMHRxZG0oZG9jc19wcm9jZXNzZWQpJTVEJTBBJTBBJTIzJTIwUGxvdCUyMHRoZSUyMGRpc3RydWJ1dGlvbiUyMG9mJTIwZG9jdW1lbnQlMjBsZW5ndGhzJTJDJTIwY291bnRlZCUyMGFzJTIwdGhlJTIwbnVtYmVyJTIwb2YlMjB0b2tlbnMlMEFmaWclMjAlM0QlMjBwZC5TZXJpZXMobGVuZ3RocykuaGlzdCgpJTBBcGx0LnRpdGxlKCUyMkRpc3RyaWJ1dGlvbiUyMG9mJTIwZG9jdW1lbnQlMjBsZW5ndGhzJTIwaW4lMjB0aGUlMjBrbm93bGVkZ2UlMjBiYXNlJTIwKGluJTIwY291bnQlMjBvZiUyMHRva2VucyklMjIpJTBBcGx0LnNob3coKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To get the value of the max sequence_length, we will query the underlying \`SentenceTransformer\` object used in the RecursiveCharacterTextSplitter.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model&#x27;s maximum sequence length: <span class="hljs-subst">{SentenceTransformer(<span class="hljs-string">&#x27;thenlper/gte-small&#x27;</span>).max_seq_length}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>lengths = [<span class="hljs-built_in">len</span>(tokenizer.encode(doc.page_content)) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(docs_processed)]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Plot the distrubution of document lengths, counted as the number of tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig = pd.Series(lengths).hist()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.title(<span class="hljs-string">&quot;Distribution of document lengths in the knowledge base (in count of tokens)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),tl=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

EMBEDDING_MODEL_NAME = <span class="hljs-string">&quot;thenlper/gte-small&quot;</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">split_documents</span>(<span class="hljs-params">
    chunk_size: <span class="hljs-built_in">int</span>,
    knowledge_base: <span class="hljs-type">List</span>[LangchainDocument],
    tokenizer_name: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] = EMBEDDING_MODEL_NAME,
</span>) -&gt; <span class="hljs-type">List</span>[LangchainDocument]:
    <span class="hljs-string">&quot;&quot;&quot;
    Split documents into chunks of maximum size \`chunk_size\` tokens and return a list of documents.
    &quot;&quot;&quot;</span>
    text_splitter = RecursiveCharacterTextSplitter.from_huggingface_tokenizer(
        AutoTokenizer.from_pretrained(tokenizer_name),
        chunk_size=chunk_size,
        chunk_overlap=<span class="hljs-built_in">int</span>(chunk_size / <span class="hljs-number">10</span>),
        add_start_index=<span class="hljs-literal">True</span>,
        strip_whitespace=<span class="hljs-literal">True</span>,
        separators=MARKDOWN_SEPARATORS,
    )

    docs_processed = []
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base:
        docs_processed += text_splitter.split_documents([doc])

    <span class="hljs-comment"># Remove duplicates</span>
    unique_texts = {}
    docs_processed_unique = []
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed:
        <span class="hljs-keyword">if</span> doc.page_content <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> unique_texts:
            unique_texts[doc.page_content] = <span class="hljs-literal">True</span>
            docs_processed_unique.append(doc)

    <span class="hljs-keyword">return</span> docs_processed_unique


docs_processed = split_documents(
    <span class="hljs-number">512</span>,  <span class="hljs-comment"># We choose a chunk size adapted to our model</span>
    RAW_KNOWLEDGE_BASE,
    tokenizer_name=EMBEDDING_MODEL_NAME,
)

<span class="hljs-comment"># Let&#x27;s visualize the chunk sizes we would have in tokens from a common model</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(EMBEDDING_MODEL_NAME)
lengths = [<span class="hljs-built_in">len</span>(tokenizer.encode(doc.page_content)) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(docs_processed)]
fig = pd.Series(lengths).hist()
plt.title(<span class="hljs-string">&quot;Distribution of document lengths in the knowledge base (in count of tokens)&quot;</span>)
plt.show()`,wrap:!1}}),nl=new U({props:{title:"1.2 构建向量数据库",local:"12-构建向量数据库",headingTag:"h3"}}),pl=new U({props:{title:"检索的工作原理",local:"检索的工作原理",headingTag:"h4"}}),ol=new U({props:{title:"最近邻搜索算法",local:"最近邻搜索算法",headingTag:"h5"}}),rl=new U({props:{title:"距离度量",local:"距离度量",headingTag:"h5"}}),jl=new T({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEFmcm9tJTIwbGFuZ2NoYWluX2NvbW11bml0eS52ZWN0b3JzdG9yZXMudXRpbHMlMjBpbXBvcnQlMjBEaXN0YW5jZVN0cmF0ZWd5JTBBJTBBZW1iZWRkaW5nX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlM0RFTUJFRERJTkdfTU9ERUxfTkFNRSUyQyUwQSUyMCUyMCUyMCUyMG11bHRpX3Byb2Nlc3MlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfa3dhcmdzJTNEJTdCJTIyZGV2aWNlJTIyJTNBJTIwJTIyY3VkYSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGVuY29kZV9rd2FyZ3MlM0QlN0IlMjJub3JtYWxpemVfZW1iZWRkaW5ncyUyMiUzQSUyMFRydWUlN0QlMkMlMjAlMjAlMjMlMjBzZXQlMjBUcnVlJTIwZm9yJTIwY29zaW5lJTIwc2ltaWxhcml0eSUwQSklMEElMEFLTk9XTEVER0VfVkVDVE9SX0RBVEFCQVNFJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoJTBBJTIwJTIwJTIwJTIwZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmdfbW9kZWwlMkMlMjBkaXN0YW5jZV9zdHJhdGVneSUzRERpc3RhbmNlU3RyYXRlZ3kuQ09TSU5FJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings
<span class="hljs-keyword">from</span> langchain_community.vectorstores.utils <span class="hljs-keyword">import</span> DistanceStrategy

embedding_model = HuggingFaceEmbeddings(
    model_name=EMBEDDING_MODEL_NAME,
    multi_process=<span class="hljs-literal">True</span>,
    model_kwargs={<span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cuda&quot;</span>},
    encode_kwargs={<span class="hljs-string">&quot;normalize_embeddings&quot;</span>: <span class="hljs-literal">True</span>},  <span class="hljs-comment"># set True for cosine similarity</span>
)

KNOWLEDGE_VECTOR_DATABASE = FAISS.from_documents(
    docs_processed, embedding_model, distance_strategy=DistanceStrategy.COSINE
)`,wrap:!1}}),wl=new T({props:{code:"JTIzJTIwZW1iZWQlMjBhJTIwdXNlciUyMHF1ZXJ5JTIwaW4lMjB0aGUlMjBzYW1lJTIwc3BhY2UlMEF1c2VyX3F1ZXJ5JTIwJTNEJTIwJTIySG93JTIwdG8lMjBjcmVhdGUlMjBhJTIwcGlwZWxpbmUlMjBvYmplY3QlM0YlMjIlMEFxdWVyeV92ZWN0b3IlMjAlM0QlMjBlbWJlZGRpbmdfbW9kZWwuZW1iZWRfcXVlcnkodXNlcl9xdWVyeSk=",highlighted:`<span class="hljs-comment"># embed a user query in the same space</span>
user_query = <span class="hljs-string">&quot;How to create a pipeline object?&quot;</span>
query_vector = embedding_model.embed_query(user_query)`,wrap:!1}}),hl=new T({props:{code:"aW1wb3J0JTIwcGFjbWFwJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwcGxvdGx5LmV4cHJlc3MlMjBhcyUyMHB4JTBBJTBBZW1iZWRkaW5nX3Byb2plY3RvciUyMCUzRCUyMHBhY21hcC5QYUNNQVAobl9jb21wb25lbnRzJTNEMiUyQyUyMG5fbmVpZ2hib3JzJTNETm9uZSUyQyUyME1OX3JhdGlvJTNEMC41JTJDJTIwRlBfcmF0aW8lM0QyLjAlMkMlMjByYW5kb21fc3RhdGUlM0QxKSUwQSUwQWVtYmVkZGluZ3NfMmQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBsaXN0KEtOT1dMRURHRV9WRUNUT1JfREFUQUJBU0UuaW5kZXgucmVjb25zdHJ1Y3RfbihpZHglMkMlMjAxKSU1QjAlNUQpJTIwZm9yJTIwaWR4JTIwaW4lMjByYW5nZShsZW4oZG9jc19wcm9jZXNzZWQpKSUwQSU1RCUyMCUyQiUyMCU1QnF1ZXJ5X3ZlY3RvciU1RCUwQSUwQSUyMyUyMGZpdCUyMHRoZSUyMGRhdGElMjAoVGhlJTIwaW5kZXglMjBvZiUyMHRyYW5zZm9ybWVkJTIwZGF0YSUyMGNvcnJlc3BvbmRzJTIwdG8lMjB0aGUlMjBpbmRleCUyMG9mJTIwdGhlJTIwb3JpZ2luYWwlMjBkYXRhKSUwQWRvY3VtZW50c19wcm9qZWN0ZWQlMjAlM0QlMjBlbWJlZGRpbmdfcHJvamVjdG9yLmZpdF90cmFuc2Zvcm0obnAuYXJyYXkoZW1iZWRkaW5nc18yZCklMkMlMjBpbml0JTNEJTIycGNhJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> pacmap
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> plotly.express <span class="hljs-keyword">as</span> px

embedding_projector = pacmap.PaCMAP(n_components=<span class="hljs-number">2</span>, n_neighbors=<span class="hljs-literal">None</span>, MN_ratio=<span class="hljs-number">0.5</span>, FP_ratio=<span class="hljs-number">2.0</span>, random_state=<span class="hljs-number">1</span>)

embeddings_2d = [
    <span class="hljs-built_in">list</span>(KNOWLEDGE_VECTOR_DATABASE.index.reconstruct_n(idx, <span class="hljs-number">1</span>)[<span class="hljs-number">0</span>]) <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(docs_processed))
] + [query_vector]

<span class="hljs-comment"># fit the data (The index of transformed data corresponds to the index of the original data)</span>
documents_projected = embedding_projector.fit_transform(np.array(embeddings_2d), init=<span class="hljs-string">&quot;pca&quot;</span>)`,wrap:!1}}),bl=new T({props:{code:"ZGYlMjAlM0QlMjBwZC5EYXRhRnJhbWUuZnJvbV9kaWN0KCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnglMjIlM0ElMjBkb2N1bWVudHNfcHJvamVjdGVkJTVCaSUyQyUyMDAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ5JTIyJTNBJTIwZG9jdW1lbnRzX3Byb2plY3RlZCU1QmklMkMlMjAxJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc291cmNlJTIyJTNBJTIwZG9jc19wcm9jZXNzZWQlNUJpJTVELm1ldGFkYXRhJTVCJTIyc291cmNlJTIyJTVELnNwbGl0KCUyMiUyRiUyMiklNUIxJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZXh0cmFjdCUyMiUzQSUyMGRvY3NfcHJvY2Vzc2VkJTVCaSU1RC5wYWdlX2NvbnRlbnQlNUIlM0ExMDAlNUQlMjAlMkIlMjAlMjIuLi4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzeW1ib2wlMjIlM0ElMjAlMjJjaXJjbGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzaXplX2NvbCUyMiUzQSUyMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZG9jc19wcm9jZXNzZWQpKSUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCUyQiUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnglMjIlM0ElMjBkb2N1bWVudHNfcHJvamVjdGVkJTVCLTElMkMlMjAwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeSUyMiUzQSUyMGRvY3VtZW50c19wcm9qZWN0ZWQlNUItMSUyQyUyMDElNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzb3VyY2UlMjIlM0ElMjAlMjJVc2VyJTIwcXVlcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJleHRyYWN0JTIyJTNBJTIwdXNlcl9xdWVyeSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNpemVfY29sJTIyJTNBJTIwMTAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3ltYm9sJTIyJTNBJTIwJTIyc3RhciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBlbWJlZGRpbmclMEFmaWclMjAlM0QlMjBweC5zY2F0dGVyKCUwQSUyMCUyMCUyMCUyMGRmJTJDJTBBJTIwJTIwJTIwJTIweCUzRCUyMnglMjIlMkMlMEElMjAlMjAlMjAlMjB5JTNEJTIyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbG9yJTNEJTIyc291cmNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwaG92ZXJfZGF0YSUzRCUyMmV4dHJhY3QlMjIlMkMlMEElMjAlMjAlMjAlMjBzaXplJTNEJTIyc2l6ZV9jb2wlMjIlMkMlMEElMjAlMjAlMjAlMjBzeW1ib2wlM0QlMjJzeW1ib2wlMjIlMkMlMEElMjAlMjAlMjAlMjBjb2xvcl9kaXNjcmV0ZV9tYXAlM0QlN0IlMjJVc2VyJTIwcXVlcnklMjIlM0ElMjAlMjJibGFjayUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAwMCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDcwMCUyQyUwQSklMEFmaWcudXBkYXRlX3RyYWNlcyhtYXJrZXIlM0RkaWN0KG9wYWNpdHklM0QxJTJDJTIwbGluZSUzRGRpY3Qod2lkdGglM0QwJTJDJTIwY29sb3IlM0QlMjJEYXJrU2xhdGVHcmV5JTIyKSklMkMlMjBzZWxlY3RvciUzRGRpY3QobW9kZSUzRCUyMm1hcmtlcnMlMjIpKSUwQWZpZy51cGRhdGVfbGF5b3V0KCUwQSUyMCUyMCUyMCUyMGxlZ2VuZF90aXRsZV90ZXh0JTNEJTIyJTNDYiUzRUNodW5rJTIwc291cmNlJTNDJTJGYiUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyJTNDYiUzRTJEJTIwUHJvamVjdGlvbiUyMG9mJTIwQ2h1bmslMjBFbWJlZGRpbmdzJTIwdmlhJTIwUGFDTUFQJTNDJTJGYiUzRSUyMiUyQyUwQSklMEFmaWcuc2hvdygp",highlighted:`df = pd.DataFrame.from_dict(
    [
        {
            <span class="hljs-string">&quot;x&quot;</span>: documents_projected[i, <span class="hljs-number">0</span>],
            <span class="hljs-string">&quot;y&quot;</span>: documents_projected[i, <span class="hljs-number">1</span>],
            <span class="hljs-string">&quot;source&quot;</span>: docs_processed[i].metadata[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>],
            <span class="hljs-string">&quot;extract&quot;</span>: docs_processed[i].page_content[:<span class="hljs-number">100</span>] + <span class="hljs-string">&quot;...&quot;</span>,
            <span class="hljs-string">&quot;symbol&quot;</span>: <span class="hljs-string">&quot;circle&quot;</span>,
            <span class="hljs-string">&quot;size_col&quot;</span>: <span class="hljs-number">4</span>,
        }
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(docs_processed))
    ]
    + [
        {
            <span class="hljs-string">&quot;x&quot;</span>: documents_projected[-<span class="hljs-number">1</span>, <span class="hljs-number">0</span>],
            <span class="hljs-string">&quot;y&quot;</span>: documents_projected[-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
            <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;User query&quot;</span>,
            <span class="hljs-string">&quot;extract&quot;</span>: user_query,
            <span class="hljs-string">&quot;size_col&quot;</span>: <span class="hljs-number">100</span>,
            <span class="hljs-string">&quot;symbol&quot;</span>: <span class="hljs-string">&quot;star&quot;</span>,
        }
    ]
)

<span class="hljs-comment"># visualize the embedding</span>
fig = px.scatter(
    df,
    x=<span class="hljs-string">&quot;x&quot;</span>,
    y=<span class="hljs-string">&quot;y&quot;</span>,
    color=<span class="hljs-string">&quot;source&quot;</span>,
    hover_data=<span class="hljs-string">&quot;extract&quot;</span>,
    size=<span class="hljs-string">&quot;size_col&quot;</span>,
    symbol=<span class="hljs-string">&quot;symbol&quot;</span>,
    color_discrete_map={<span class="hljs-string">&quot;User query&quot;</span>: <span class="hljs-string">&quot;black&quot;</span>},
    width=<span class="hljs-number">1000</span>,
    height=<span class="hljs-number">700</span>,
)
fig.update_traces(marker=<span class="hljs-built_in">dict</span>(opacity=<span class="hljs-number">1</span>, line=<span class="hljs-built_in">dict</span>(width=<span class="hljs-number">0</span>, color=<span class="hljs-string">&quot;DarkSlateGrey&quot;</span>)), selector=<span class="hljs-built_in">dict</span>(mode=<span class="hljs-string">&quot;markers&quot;</span>))
fig.update_layout(
    legend_title_text=<span class="hljs-string">&quot;&lt;b&gt;Chunk source&lt;/b&gt;&quot;</span>,
    title=<span class="hljs-string">&quot;&lt;b&gt;2D Projection of Chunk Embeddings via PaCMAP&lt;/b&gt;&quot;</span>,
)
fig.show()`,wrap:!1}}),gl=new T({props:{code:"cHJpbnQoZiUyMiU1Q25TdGFydGluZyUyMHJldHJpZXZhbCUyMGZvciUyMCU3QnVzZXJfcXVlcnklM0QlN0QuLi4lMjIpJTBBcmV0cmlldmVkX2RvY3MlMjAlM0QlMjBLTk9XTEVER0VfVkVDVE9SX0RBVEFCQVNFLnNpbWlsYXJpdHlfc2VhcmNoKHF1ZXJ5JTNEdXNlcl9xdWVyeSUyQyUyMGslM0Q1KSUwQXByaW50KCUyMiU1Q24lM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0RUb3AlMjBkb2N1bWVudCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUyMiklMEFwcmludChyZXRyaWV2ZWRfZG9jcyU1QjAlNUQucGFnZV9jb250ZW50KSUwQXByaW50KCUyMiUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRE1ldGFkYXRhJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIyKSUwQXByaW50KHJldHJpZXZlZF9kb2NzJTVCMCU1RC5tZXRhZGF0YSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nStarting retrieval for <span class="hljs-subst">{user_query=}</span>...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>retrieved_docs = KNOWLEDGE_VECTOR_DATABASE.similarity_search(query=user_query, k=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n==================================Top document==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_docs[<span class="hljs-number">0</span>].page_content)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;==================================Metadata==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_docs[<span class="hljs-number">0</span>].metadata)`,wrap:!1}}),kl=new U({props:{title:"2. 阅读器- LLM 💬",local:"2-阅读器--llm-",headingTag:"h1"}}),_l=new U({props:{title:"2.1. 阅读器模型",local:"21-阅读器模型",headingTag:"h3"}}),xl=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBUkVBREVSX01PREVMX05BTUUlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoUkVBREVSX01PREVMX05BTUUlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChSRUFERVJfTU9ERUxfTkFNRSklMEElMEFSRUFERVJfTExNJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjIlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjElMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDUwMCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

READER_MODEL_NAME = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)
model = AutoModelForCausalLM.from_pretrained(READER_MODEL_NAME, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(READER_MODEL_NAME)

READER_LLM = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    do_sample=<span class="hljs-literal">True</span>,
    temperature=<span class="hljs-number">0.2</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">False</span>,
    max_new_tokens=<span class="hljs-number">500</span>,
)`,wrap:!1}}),zl=new T({props:{code:"UkVBREVSX0xMTSglMjJXaGF0JTIwaXMlMjA0JTJCNCUzRiUyMEFuc3dlciUzQSUyMik=",highlighted:'READER_LLM(<span class="hljs-string">&quot;What is 4+4? Answer:&quot;</span>)',wrap:!1}}),Xl=new U({props:{title:"2.2. 提示(Prompt)",local:"22-提示prompt",headingTag:"h3"}}),Hl=new T({props:{code:"cHJvbXB0X2luX2NoYXRfZm9ybWF0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIlMjIlMjJVc2luZyUyMHRoZSUyMGluZm9ybWF0aW9uJTIwY29udGFpbmVkJTIwaW4lMjB0aGUlMjBjb250ZXh0JTJDJTBBZ2l2ZSUyMGElMjBjb21wcmVoZW5zaXZlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjBxdWVzdGlvbi4lMEFSZXNwb25kJTIwb25seSUyMHRvJTIwdGhlJTIwcXVlc3Rpb24lMjBhc2tlZCUyQyUyMHJlc3BvbnNlJTIwc2hvdWxkJTIwYmUlMjBjb25jaXNlJTIwYW5kJTIwcmVsZXZhbnQlMjB0byUyMHRoZSUyMHF1ZXN0aW9uLiUwQVByb3ZpZGUlMjB0aGUlMjBudW1iZXIlMjBvZiUyMHRoZSUyMHNvdXJjZSUyMGRvY3VtZW50JTIwd2hlbiUyMHJlbGV2YW50LiUwQUlmJTIwdGhlJTIwYW5zd2VyJTIwY2Fubm90JTIwYmUlMjBkZWR1Y2VkJTIwZnJvbSUyMHRoZSUyMGNvbnRleHQlMkMlMjBkbyUyMG5vdCUyMGdpdmUlMjBhbiUyMGFuc3dlci4lMjIlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIlMjIlMjJDb250ZXh0JTNBJTBBJTdCY29udGV4dCU3RCUwQS0tLSUwQU5vdyUyMGhlcmUlMjBpcyUyMHRoZSUyMHF1ZXN0aW9uJTIweW91JTIwbmVlZCUyMHRvJTIwYW5zd2VyLiUwQSUwQVF1ZXN0aW9uJTNBJTIwJTdCcXVlc3Rpb24lN0QlMjIlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElNUQlMEFSQUdfUFJPTVBUX1RFTVBMQVRFJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2luX2NoYXRfZm9ybWF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMEEpJTBBcHJpbnQoUkFHX1BST01QVF9URU1QTEFURSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_in_chat_format = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;&quot;&quot;Using the information contained in the context,
<span class="hljs-meta">... </span>give a comprehensive answer to the question.
<span class="hljs-meta">... </span>Respond only to the question asked, response should be concise and relevant to the question.
<span class="hljs-meta">... </span>Provide the number of the source document when relevant.
<span class="hljs-meta">... </span>If the answer cannot be deduced from the context, do not give an answer.&quot;&quot;&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;&quot;&quot;Context:
<span class="hljs-meta">... </span>{context}
<span class="hljs-meta">... </span>---
<span class="hljs-meta">... </span>Now here is the question you need to answer.

<span class="hljs-meta">... </span>Question: {question}&quot;&quot;&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>RAG_PROMPT_TEMPLATE = tokenizer.apply_chat_template(
<span class="hljs-meta">... </span>    prompt_in_chat_format, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(RAG_PROMPT_TEMPLATE)`,wrap:!1}}),Yl=new T({props:{code:"cmV0cmlldmVkX2RvY3NfdGV4dCUyMCUzRCUyMCU1QmRvYy5wYWdlX2NvbnRlbnQlMjBmb3IlMjBkb2MlMjBpbiUyMHJldHJpZXZlZF9kb2NzJTVEJTIwJTIwJTIzJTIwd2UlMjBvbmx5JTIwbmVlZCUyMHRoZSUyMHRleHQlMjBvZiUyMHRoZSUyMGRvY3VtZW50cyUwQWNvbnRleHQlMjAlM0QlMjAlMjIlNUNuRXh0cmFjdGVkJTIwZG9jdW1lbnRzJTNBJTVDbiUyMiUwQWNvbnRleHQlMjAlMkIlM0QlMjAlMjIlMjIuam9pbiglNUJmJTIyRG9jdW1lbnQlMjAlN0JzdHIoaSklN0QlM0ElM0ElM0ElNUNuJTIyJTIwJTJCJTIwZG9jJTIwZm9yJTIwaSUyQyUyMGRvYyUyMGluJTIwZW51bWVyYXRlKHJldHJpZXZlZF9kb2NzX3RleHQpJTVEKSUwQSUwQWZpbmFsX3Byb21wdCUyMCUzRCUyMFJBR19QUk9NUFRfVEVNUExBVEUuZm9ybWF0KHF1ZXN0aW9uJTNEJTIySG93JTIwdG8lMjBjcmVhdGUlMjBhJTIwcGlwZWxpbmUlMjBvYmplY3QlM0YlMjIlMkMlMjBjb250ZXh0JTNEY29udGV4dCklMEElMEElMjMlMjBSZWRhY3QlMjBhbiUyMGFuc3dlciUwQWFuc3dlciUyMCUzRCUyMFJFQURFUl9MTE0oZmluYWxfcHJvbXB0KSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCUwQXByaW50KGFuc3dlcik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>retrieved_docs_text = [doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> retrieved_docs]  <span class="hljs-comment"># we only need the text of the documents</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = <span class="hljs-string">&quot;\\nExtracted documents:\\n&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context += <span class="hljs-string">&quot;&quot;</span>.join([<span class="hljs-string">f&quot;Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span>:::\\n&quot;</span> + doc <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(retrieved_docs_text)])

<span class="hljs-meta">&gt;&gt;&gt; </span>final_prompt = RAG_PROMPT_TEMPLATE.<span class="hljs-built_in">format</span>(question=<span class="hljs-string">&quot;How to create a pipeline object?&quot;</span>, context=context)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Redact an answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>answer = READER_LLM(final_prompt)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(answer)`,wrap:!1}}),Pl=new U({props:{title:"2.3. 重排序(rerank)",local:"23-重排序rerank",headingTag:"h3"}}),le=new T({props:{code:"ZnJvbSUyMHJhZ2F0b3VpbGxlJTIwaW1wb3J0JTIwUkFHUHJldHJhaW5lZE1vZGVsJTBBJTBBUkVSQU5LRVIlMjAlM0QlMjBSQUdQcmV0cmFpbmVkTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmNvbGJlcnQtaXIlMkZjb2xiZXJ0djIuMCUyMik=",highlighted:`<span class="hljs-keyword">from</span> ragatouille <span class="hljs-keyword">import</span> RAGPretrainedModel

RERANKER = RAGPretrainedModel.from_pretrained(<span class="hljs-string">&quot;colbert-ir/colbertv2.0&quot;</span>)`,wrap:!1}}),ee=new U({props:{title:"3. 集成所有组件",local:"3-集成所有组件",headingTag:"h1"}}),te=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">answer_with_rag</span>(<span class="hljs-params">
    question: <span class="hljs-built_in">str</span>,
    llm: Pipeline,
    knowledge_index: FAISS,
    reranker: <span class="hljs-type">Optional</span>[RAGPretrainedModel] = <span class="hljs-literal">None</span>,
    num_retrieved_docs: <span class="hljs-built_in">int</span> = <span class="hljs-number">30</span>,
    num_docs_final: <span class="hljs-built_in">int</span> = <span class="hljs-number">5</span>,
</span>) -&gt; <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">List</span>[LangchainDocument]]:
    <span class="hljs-comment"># Gather documents with retriever</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&gt; Retrieving documents...&quot;</span>)
    relevant_docs = knowledge_index.similarity_search(query=question, k=num_retrieved_docs)
    relevant_docs = [doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> relevant_docs]  <span class="hljs-comment"># keep only the text</span>

    <span class="hljs-comment"># Optionally rerank results</span>
    <span class="hljs-keyword">if</span> reranker:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&gt; Reranking documents...&quot;</span>)
        relevant_docs = reranker.rerank(question, relevant_docs, k=num_docs_final)
        relevant_docs = [doc[<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> relevant_docs]

    relevant_docs = relevant_docs[:num_docs_final]

    <span class="hljs-comment"># Build the final prompt</span>
    context = <span class="hljs-string">&quot;\\nExtracted documents:\\n&quot;</span>
    context += <span class="hljs-string">&quot;&quot;</span>.join([<span class="hljs-string">f&quot;Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span>:::\\n&quot;</span> + doc <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(relevant_docs)])

    final_prompt = RAG_PROMPT_TEMPLATE.<span class="hljs-built_in">format</span>(question=question, context=context)

    <span class="hljs-comment"># Redact an answer</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&gt; Generating answer...&quot;</span>)
    answer = llm(final_prompt)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]

    <span class="hljs-keyword">return</span> answer, relevant_docs`,wrap:!1}}),ne=new T({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJob3clMjB0byUyMGNyZWF0ZSUyMGElMjBwaXBlbGluZSUyMG9iamVjdCUzRiUyMiUwQSUwQWFuc3dlciUyQyUyMHJlbGV2YW50X2RvY3MlMjAlM0QlMjBhbnN3ZXJfd2l0aF9yYWcocXVlc3Rpb24lMkMlMjBSRUFERVJfTExNJTJDJTIwS05PV0xFREdFX1ZFQ1RPUl9EQVRBQkFTRSUyQyUyMHJlcmFua2VyJTNEUkVSQU5LRVIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;how to create a pipeline object?&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>answer, relevant_docs = answer_with_rag(question, READER_LLM, KNOWLEDGE_VECTOR_DATABASE, reranker=RERANKER)`,wrap:!1}}),pe=new T({props:{code:"cHJpbnQoJTIyJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEQW5zd2VyJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIyKSUwQXByaW50KGYlMjIlN0JhbnN3ZXIlN0QlMjIpJTBBcHJpbnQoJTIyJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEU291cmNlJTIwZG9jcyUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUyMiklMEFmb3IlMjBpJTJDJTIwZG9jJTIwaW4lMjBlbnVtZXJhdGUocmVsZXZhbnRfZG9jcyklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyRG9jdW1lbnQlMjAlN0JpJTdELS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGRvYyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;==================================Answer==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{answer}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;==================================Source docs==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(relevant_docs):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Document <span class="hljs-subst">{i}</span>------------------------------------------------------------&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(doc)`,wrap:!1}}),oe=new U({props:{title:"进一步探索 🗺️",local:"进一步探索-",headingTag:"h1"}}),re=new U({props:{title:"设置评估流水线",local:"设置评估流水线",headingTag:"h3"}}),me=new U({props:{title:"改进检索器",local:"改进检索器",headingTag:"h3"}}),ue=new U({props:{title:"改进阅读器",local:"改进阅读器",headingTag:"h3"}}),{c(){j=p("meta"),Re=n(),fe=p("p"),Ee=n(),o(u.$$.fragment),ge=n(),o(d.$$.fragment),Ne=n(),w=p("p"),w.innerHTML=As,ke=n(),h=p("p"),h.textContent=Vs,Ze=n(),b=p("p"),b.innerHTML=vs,Be=n(),C=p("p"),C.textContent=Ws,Ge=n(),f=p("img"),_e=n(),I=p("blockquote"),I.innerHTML=xs,Ae=n(),R=p("p"),R.textContent=zs,Ve=n(),E=p("p"),E.innerHTML=Xs,ve=n(),o(g.$$.fragment),We=n(),o(N.$$.fragment),Qe=n(),o(k.$$.fragment),xe=n(),o(Z.$$.fragment),ze=n(),o(B.$$.fragment),Xe=n(),o(G.$$.fragment),Se=n(),o(_.$$.fragment),$e=n(),A=p("p"),A.innerHTML=Ss,He=n(),V=p("p"),V.textContent=$s,qe=n(),v=p("p"),v.innerHTML=Hs,Fe=n(),W=p("p"),W.innerHTML=qs,Ye=n(),Q=p("p"),Q.innerHTML=Fs,Le=n(),x=p("ul"),x.innerHTML=Ys,Pe=n(),z=p("blockquote"),z.innerHTML=Ls,De=n(),o(X.$$.fragment),Ke=n(),S=p("ul"),S.innerHTML=Ps,Oe=n(),$=p("p"),$.innerHTML=Ds,lt=n(),H=p("ul"),H.innerHTML=Ks,et=n(),q=p("blockquote"),q.innerHTML=Os,tt=n(),F=p("p"),F.innerHTML=ln,st=n(),Y=p("ul"),Y.innerHTML=en,nt=n(),o(L.$$.fragment),at=n(),P=p("p"),P.innerHTML=tn,pt=n(),D=p("p"),D.textContent=sn,Mt=n(),o(K.$$.fragment),it=n(),O=p("pre"),O.textContent=nn,ot=n(),ll=p("p"),ll.innerHTML=an,yt=n(),el=p("ul"),el.innerHTML=pn,rt=n(),o(tl.$$.fragment),ct=n(),sl=p("p"),sl.textContent=Mn,mt=n(),o(nl.$$.fragment),Jt=n(),al=p("p"),al.innerHTML=on,Tt=n(),o(pl.$$.fragment),Ut=n(),Ml=p("p"),Ml.textContent=yn,jt=n(),il=p("p"),il.textContent=rn,ut=n(),o(ol.$$.fragment),dt=n(),yl=p("p"),yl.innerHTML=cn,wt=n(),o(rl.$$.fragment),ht=n(),cl=p("p"),cl.innerHTML=mn,bt=n(),ml=p("ul"),ml.innerHTML=Jn,Ct=n(),Jl=p("p"),Jl.innerHTML=Tn,ft=n(),Tl=p("p"),Tl.innerHTML=Un,It=n(),Ul=p("p"),Ul.textContent=jn,Rt=n(),o(jl.$$.fragment),Et=n(),ul=p("p"),ul.textContent=un,gt=n(),dl=p("p"),dl.innerHTML=dn,Nt=n(),o(wl.$$.fragment),kt=n(),o(hl.$$.fragment),Zt=n(),o(bl.$$.fragment),Bt=n(),Cl=p("img"),Gt=n(),fl=p("p"),fl.textContent=hn,_t=n(),Il=p("p"),Il.innerHTML=bn,At=n(),Rl=p("p"),Rl.innerHTML=Cn,Vt=n(),El=p("p"),El.textContent=fn,vt=n(),o(gl.$$.fragment),Wt=n(),Nl=p("pre"),Nl.textContent=In,Qt=n(),o(kl.$$.fragment),xt=n(),Zl=p("p"),Zl.innerHTML=Rn,zt=n(),Bl=p("p"),Bl.textContent=En,Xt=n(),Gl=p("ol"),Gl.innerHTML=gn,St=n(),o(_l.$$.fragment),$t=n(),Al=p("p"),Al.textContent=Nn,Ht=n(),Vl=p("ul"),Vl.innerHTML=kn,qt=n(),vl=p("p"),vl.innerHTML=Zn,Ft=n(),Wl=p("p"),Wl.innerHTML=Bn,Yt=n(),Ql=p("p"),Ql.textContent=Gn,Lt=n(),o(xl.$$.fragment),Pt=n(),o(zl.$$.fragment),Dt=n(),o(Xl.$$.fragment),Kt=n(),Sl=p("p"),Sl.textContent=_n,Ot=n(),$l=p("p"),$l.textContent=An,ls=n(),o(Hl.$$.fragment),es=n(),ql=p("pre"),ql.textContent=Vn,ts=n(),Fl=p("p"),Fl.textContent=vn,ss=n(),o(Yl.$$.fragment),ns=n(),Ll=p("pre"),Ll.textContent=Wn,as=n(),o(Pl.$$.fragment),ps=n(),Dl=p("p"),Dl.innerHTML=Qn,Ms=n(),Kl=p("p"),Kl.innerHTML=xn,is=n(),Ol=p("p"),Ol.innerHTML=zn,os=n(),o(le.$$.fragment),ys=n(),o(ee.$$.fragment),rs=n(),o(te.$$.fragment),cs=n(),se=p("p"),se.textContent=Xn,ms=n(),o(ne.$$.fragment),Js=n(),ae=p("pre"),ae.textContent=Sn,Ts=n(),o(pe.$$.fragment),Us=n(),Me=p("pre"),Me.textContent=$n,js=n(),ie=p("p"),ie.textContent=Hn,us=n(),o(oe.$$.fragment),ds=n(),ye=p("p"),ye.textContent=qn,ws=n(),o(re.$$.fragment),hs=n(),ce=p("ul"),ce.innerHTML=Fn,bs=n(),o(me.$$.fragment),Cs=n(),Je=p("p"),Je.innerHTML=Yn,fs=n(),Te=p("ul"),Te.innerHTML=Ln,Is=n(),Ue=p("p"),Ue.innerHTML=Pn,Rs=n(),je=p("ul"),je.innerHTML=Dn,Es=n(),o(ue.$$.fragment),gs=n(),de=p("p"),de.innerHTML=Kn,Ns=n(),we=p("ul"),we.innerHTML=On,ks=n(),he=p("p"),he.innerHTML=la,Zs=n(),be=p("ul"),be.innerHTML=ea,Bs=n(),Ie=p("p"),this.h()},l(l){const e=oa("svelte-u9bgzb",document.head);j=M(e,"META",{name:!0,content:!0}),e.forEach(t),Re=a(l),fe=M(l,"P",{}),sa(fe).forEach(t),Ee=a(l),y(u.$$.fragment,l),ge=a(l),y(d.$$.fragment,l),Ne=a(l),w=M(l,"P",{"data-svelte-h":!0}),i(w)!=="svelte-1ouqjzx"&&(w.innerHTML=As),ke=a(l),h=M(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-1y8o57u"&&(h.textContent=Vs),Ze=a(l),b=M(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-cgsx28"&&(b.innerHTML=vs),Be=a(l),C=M(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-45g62z"&&(C.textContent=Ws),Ge=a(l),f=M(l,"IMG",{src:!0,height:!0}),_e=a(l),I=M(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(I)!=="svelte-oiyp3w"&&(I.innerHTML=xs),Ae=a(l),R=M(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1c77kj2"&&(R.textContent=zs),Ve=a(l),E=M(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-16f9kjd"&&(E.innerHTML=Xs),ve=a(l),y(g.$$.fragment,l),We=a(l),y(N.$$.fragment,l),Qe=a(l),y(k.$$.fragment,l),xe=a(l),y(Z.$$.fragment,l),ze=a(l),y(B.$$.fragment,l),Xe=a(l),y(G.$$.fragment,l),Se=a(l),y(_.$$.fragment,l),$e=a(l),A=M(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-ql0xxw"&&(A.innerHTML=Ss),He=a(l),V=M(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-79k71u"&&(V.textContent=$s),qe=a(l),v=M(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-gfu2zq"&&(v.innerHTML=Hs),Fe=a(l),W=M(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-c8pzbv"&&(W.innerHTML=qs),Ye=a(l),Q=M(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1ylwvta"&&(Q.innerHTML=Fs),Le=a(l),x=M(l,"UL",{"data-svelte-h":!0}),i(x)!=="svelte-1ynnvg9"&&(x.innerHTML=Ys),Pe=a(l),z=M(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(z)!=="svelte-1jq112o"&&(z.innerHTML=Ls),De=a(l),y(X.$$.fragment,l),Ke=a(l),S=M(l,"UL",{"data-svelte-h":!0}),i(S)!=="svelte-18g8ey5"&&(S.innerHTML=Ps),Oe=a(l),$=M(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-uaz899"&&($.innerHTML=Ds),lt=a(l),H=M(l,"UL",{"data-svelte-h":!0}),i(H)!=="svelte-1j9j687"&&(H.innerHTML=Ks),et=a(l),q=M(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(q)!=="svelte-nls6mz"&&(q.innerHTML=Os),tt=a(l),F=M(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-164rw2z"&&(F.innerHTML=ln),st=a(l),Y=M(l,"UL",{"data-svelte-h":!0}),i(Y)!=="svelte-j32ek"&&(Y.innerHTML=en),nt=a(l),y(L.$$.fragment,l),at=a(l),P=M(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-y33335"&&(P.innerHTML=tn),pt=a(l),D=M(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1yay3kj"&&(D.textContent=sn),Mt=a(l),y(K.$$.fragment,l),it=a(l),O=M(l,"PRE",{"data-svelte-h":!0}),i(O)!=="svelte-h6hpdk"&&(O.textContent=nn),ot=a(l),ll=M(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-1k6h3dv"&&(ll.innerHTML=an),yt=a(l),el=M(l,"UL",{"data-svelte-h":!0}),i(el)!=="svelte-j2u3py"&&(el.innerHTML=pn),rt=a(l),y(tl.$$.fragment,l),ct=a(l),sl=M(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-1su99xg"&&(sl.textContent=Mn),mt=a(l),y(nl.$$.fragment,l),Jt=a(l),al=M(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-1q1eqv0"&&(al.innerHTML=on),Tt=a(l),y(pl.$$.fragment,l),Ut=a(l),Ml=M(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-120j1u7"&&(Ml.textContent=yn),jt=a(l),il=M(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-187cxhr"&&(il.textContent=rn),ut=a(l),y(ol.$$.fragment,l),dt=a(l),yl=M(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-mw3wdi"&&(yl.innerHTML=cn),wt=a(l),y(rl.$$.fragment,l),ht=a(l),cl=M(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-1pa51hd"&&(cl.innerHTML=mn),bt=a(l),ml=M(l,"UL",{"data-svelte-h":!0}),i(ml)!=="svelte-1wwyqqn"&&(ml.innerHTML=Jn),Ct=a(l),Jl=M(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-1jcvwk2"&&(Jl.innerHTML=Tn),ft=a(l),Tl=M(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-ibu9nm"&&(Tl.innerHTML=Un),It=a(l),Ul=M(l,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-fspy7m"&&(Ul.textContent=jn),Rt=a(l),y(jl.$$.fragment,l),Et=a(l),ul=M(l,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-1wro3yx"&&(ul.textContent=un),gt=a(l),dl=M(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-1krpkyx"&&(dl.innerHTML=dn),Nt=a(l),y(wl.$$.fragment,l),kt=a(l),y(hl.$$.fragment,l),Zt=a(l),y(bl.$$.fragment,l),Bt=a(l),Cl=M(l,"IMG",{src:!0,height:!0}),Gt=a(l),fl=M(l,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-1k4v1uw"&&(fl.textContent=hn),_t=a(l),Il=M(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-1nzosig"&&(Il.innerHTML=bn),At=a(l),Rl=M(l,"P",{"data-svelte-h":!0}),i(Rl)!=="svelte-1mlsch3"&&(Rl.innerHTML=Cn),Vt=a(l),El=M(l,"P",{"data-svelte-h":!0}),i(El)!=="svelte-1l1mro3"&&(El.textContent=fn),vt=a(l),y(gl.$$.fragment,l),Wt=a(l),Nl=M(l,"PRE",{"data-svelte-h":!0}),i(Nl)!=="svelte-1q4z1pg"&&(Nl.textContent=In),Qt=a(l),y(kl.$$.fragment,l),xt=a(l),Zl=M(l,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-1jbxnsj"&&(Zl.innerHTML=Rn),zt=a(l),Bl=M(l,"P",{"data-svelte-h":!0}),i(Bl)!=="svelte-15oxcnc"&&(Bl.textContent=En),Xt=a(l),Gl=M(l,"OL",{"data-svelte-h":!0}),i(Gl)!=="svelte-1x6zhcr"&&(Gl.innerHTML=gn),St=a(l),y(_l.$$.fragment,l),$t=a(l),Al=M(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-jar50q"&&(Al.textContent=Nn),Ht=a(l),Vl=M(l,"UL",{"data-svelte-h":!0}),i(Vl)!=="svelte-btzwg9"&&(Vl.innerHTML=kn),qt=a(l),vl=M(l,"P",{"data-svelte-h":!0}),i(vl)!=="svelte-1lm1kj0"&&(vl.innerHTML=Zn),Ft=a(l),Wl=M(l,"P",{"data-svelte-h":!0}),i(Wl)!=="svelte-me1why"&&(Wl.innerHTML=Bn),Yt=a(l),Ql=M(l,"P",{"data-svelte-h":!0}),i(Ql)!=="svelte-6joo08"&&(Ql.textContent=Gn),Lt=a(l),y(xl.$$.fragment,l),Pt=a(l),y(zl.$$.fragment,l),Dt=a(l),y(Xl.$$.fragment,l),Kt=a(l),Sl=M(l,"P",{"data-svelte-h":!0}),i(Sl)!=="svelte-npbw3t"&&(Sl.textContent=_n),Ot=a(l),$l=M(l,"P",{"data-svelte-h":!0}),i($l)!=="svelte-h6ikmf"&&($l.textContent=An),ls=a(l),y(Hl.$$.fragment,l),es=a(l),ql=M(l,"PRE",{"data-svelte-h":!0}),i(ql)!=="svelte-aa4a7a"&&(ql.textContent=Vn),ts=a(l),Fl=M(l,"P",{"data-svelte-h":!0}),i(Fl)!=="svelte-l9rg7w"&&(Fl.textContent=vn),ss=a(l),y(Yl.$$.fragment,l),ns=a(l),Ll=M(l,"PRE",{"data-svelte-h":!0}),i(Ll)!=="svelte-lv1631"&&(Ll.textContent=Wn),as=a(l),y(Pl.$$.fragment,l),ps=a(l),Dl=M(l,"P",{"data-svelte-h":!0}),i(Dl)!=="svelte-13uoub8"&&(Dl.innerHTML=Qn),Ms=a(l),Kl=M(l,"P",{"data-svelte-h":!0}),i(Kl)!=="svelte-vhdu58"&&(Kl.innerHTML=xn),is=a(l),Ol=M(l,"P",{"data-svelte-h":!0}),i(Ol)!=="svelte-1b58ltx"&&(Ol.innerHTML=zn),os=a(l),y(le.$$.fragment,l),ys=a(l),y(ee.$$.fragment,l),rs=a(l),y(te.$$.fragment,l),cs=a(l),se=M(l,"P",{"data-svelte-h":!0}),i(se)!=="svelte-352kfz"&&(se.textContent=Xn),ms=a(l),y(ne.$$.fragment,l),Js=a(l),ae=M(l,"PRE",{"data-svelte-h":!0}),i(ae)!=="svelte-drvpbm"&&(ae.textContent=Sn),Ts=a(l),y(pe.$$.fragment,l),Us=a(l),Me=M(l,"PRE",{"data-svelte-h":!0}),i(Me)!=="svelte-8jp8ub"&&(Me.textContent=$n),js=a(l),ie=M(l,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-wgk4la"&&(ie.textContent=Hn),us=a(l),y(oe.$$.fragment,l),ds=a(l),ye=M(l,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-1vytx7u"&&(ye.textContent=qn),ws=a(l),y(re.$$.fragment,l),hs=a(l),ce=M(l,"UL",{"data-svelte-h":!0}),i(ce)!=="svelte-1reib3"&&(ce.innerHTML=Fn),bs=a(l),y(me.$$.fragment,l),Cs=a(l),Je=M(l,"P",{"data-svelte-h":!0}),i(Je)!=="svelte-1dq1tqp"&&(Je.innerHTML=Yn),fs=a(l),Te=M(l,"UL",{"data-svelte-h":!0}),i(Te)!=="svelte-euuksf"&&(Te.innerHTML=Ln),Is=a(l),Ue=M(l,"P",{"data-svelte-h":!0}),i(Ue)!=="svelte-1ykhfl1"&&(Ue.innerHTML=Pn),Rs=a(l),je=M(l,"UL",{"data-svelte-h":!0}),i(je)!=="svelte-1csot73"&&(je.innerHTML=Dn),Es=a(l),y(ue.$$.fragment,l),gs=a(l),de=M(l,"P",{"data-svelte-h":!0}),i(de)!=="svelte-pzw0dh"&&(de.innerHTML=Kn),Ns=a(l),we=M(l,"UL",{"data-svelte-h":!0}),i(we)!=="svelte-1v6dvb"&&(we.innerHTML=On),ks=a(l),he=M(l,"P",{"data-svelte-h":!0}),i(he)!=="svelte-fpwmko"&&(he.innerHTML=la),Zs=a(l),be=M(l,"UL",{"data-svelte-h":!0}),i(be)!=="svelte-16c8sbr"&&(be.innerHTML=ea),Bs=a(l),Ie=M(l,"P",{}),sa(Ie).forEach(t),this.h()},h(){Ce(j,"name","hf:doc:metadata"),Ce(j,"content",ma),ta(f.src,Qs="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/RAG_workflow.png")||Ce(f,"src",Qs),Ce(f,"height","700"),ta(Cl.src,wn="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/PaCMAP_embeddings.png")||Ce(Cl,"src",wn),Ce(Cl,"height","700")},m(l,e){ya(document.head,j),s(l,Re,e),s(l,fe,e),s(l,Ee,e),r(u,l,e),s(l,ge,e),r(d,l,e),s(l,Ne,e),s(l,w,e),s(l,ke,e),s(l,h,e),s(l,Ze,e),s(l,b,e),s(l,Be,e),s(l,C,e),s(l,Ge,e),s(l,f,e),s(l,_e,e),s(l,I,e),s(l,Ae,e),s(l,R,e),s(l,Ve,e),s(l,E,e),s(l,ve,e),r(g,l,e),s(l,We,e),r(N,l,e),s(l,Qe,e),r(k,l,e),s(l,xe,e),r(Z,l,e),s(l,ze,e),r(B,l,e),s(l,Xe,e),r(G,l,e),s(l,Se,e),r(_,l,e),s(l,$e,e),s(l,A,e),s(l,He,e),s(l,V,e),s(l,qe,e),s(l,v,e),s(l,Fe,e),s(l,W,e),s(l,Ye,e),s(l,Q,e),s(l,Le,e),s(l,x,e),s(l,Pe,e),s(l,z,e),s(l,De,e),r(X,l,e),s(l,Ke,e),s(l,S,e),s(l,Oe,e),s(l,$,e),s(l,lt,e),s(l,H,e),s(l,et,e),s(l,q,e),s(l,tt,e),s(l,F,e),s(l,st,e),s(l,Y,e),s(l,nt,e),r(L,l,e),s(l,at,e),s(l,P,e),s(l,pt,e),s(l,D,e),s(l,Mt,e),r(K,l,e),s(l,it,e),s(l,O,e),s(l,ot,e),s(l,ll,e),s(l,yt,e),s(l,el,e),s(l,rt,e),r(tl,l,e),s(l,ct,e),s(l,sl,e),s(l,mt,e),r(nl,l,e),s(l,Jt,e),s(l,al,e),s(l,Tt,e),r(pl,l,e),s(l,Ut,e),s(l,Ml,e),s(l,jt,e),s(l,il,e),s(l,ut,e),r(ol,l,e),s(l,dt,e),s(l,yl,e),s(l,wt,e),r(rl,l,e),s(l,ht,e),s(l,cl,e),s(l,bt,e),s(l,ml,e),s(l,Ct,e),s(l,Jl,e),s(l,ft,e),s(l,Tl,e),s(l,It,e),s(l,Ul,e),s(l,Rt,e),r(jl,l,e),s(l,Et,e),s(l,ul,e),s(l,gt,e),s(l,dl,e),s(l,Nt,e),r(wl,l,e),s(l,kt,e),r(hl,l,e),s(l,Zt,e),r(bl,l,e),s(l,Bt,e),s(l,Cl,e),s(l,Gt,e),s(l,fl,e),s(l,_t,e),s(l,Il,e),s(l,At,e),s(l,Rl,e),s(l,Vt,e),s(l,El,e),s(l,vt,e),r(gl,l,e),s(l,Wt,e),s(l,Nl,e),s(l,Qt,e),r(kl,l,e),s(l,xt,e),s(l,Zl,e),s(l,zt,e),s(l,Bl,e),s(l,Xt,e),s(l,Gl,e),s(l,St,e),r(_l,l,e),s(l,$t,e),s(l,Al,e),s(l,Ht,e),s(l,Vl,e),s(l,qt,e),s(l,vl,e),s(l,Ft,e),s(l,Wl,e),s(l,Yt,e),s(l,Ql,e),s(l,Lt,e),r(xl,l,e),s(l,Pt,e),r(zl,l,e),s(l,Dt,e),r(Xl,l,e),s(l,Kt,e),s(l,Sl,e),s(l,Ot,e),s(l,$l,e),s(l,ls,e),r(Hl,l,e),s(l,es,e),s(l,ql,e),s(l,ts,e),s(l,Fl,e),s(l,ss,e),r(Yl,l,e),s(l,ns,e),s(l,Ll,e),s(l,as,e),r(Pl,l,e),s(l,ps,e),s(l,Dl,e),s(l,Ms,e),s(l,Kl,e),s(l,is,e),s(l,Ol,e),s(l,os,e),r(le,l,e),s(l,ys,e),r(ee,l,e),s(l,rs,e),r(te,l,e),s(l,cs,e),s(l,se,e),s(l,ms,e),r(ne,l,e),s(l,Js,e),s(l,ae,e),s(l,Ts,e),r(pe,l,e),s(l,Us,e),s(l,Me,e),s(l,js,e),s(l,ie,e),s(l,us,e),r(oe,l,e),s(l,ds,e),s(l,ye,e),s(l,ws,e),r(re,l,e),s(l,hs,e),s(l,ce,e),s(l,bs,e),r(me,l,e),s(l,Cs,e),s(l,Je,e),s(l,fs,e),s(l,Te,e),s(l,Is,e),s(l,Ue,e),s(l,Rs,e),s(l,je,e),s(l,Es,e),r(ue,l,e),s(l,gs,e),s(l,de,e),s(l,Ns,e),s(l,we,e),s(l,ks,e),s(l,he,e),s(l,Zs,e),s(l,be,e),s(l,Bs,e),s(l,Ie,e),Gs=!0},p:aa,i(l){Gs||(c(u.$$.fragment,l),c(d.$$.fragment,l),c(g.$$.fragment,l),c(N.$$.fragment,l),c(k.$$.fragment,l),c(Z.$$.fragment,l),c(B.$$.fragment,l),c(G.$$.fragment,l),c(_.$$.fragment,l),c(X.$$.fragment,l),c(L.$$.fragment,l),c(K.$$.fragment,l),c(tl.$$.fragment,l),c(nl.$$.fragment,l),c(pl.$$.fragment,l),c(ol.$$.fragment,l),c(rl.$$.fragment,l),c(jl.$$.fragment,l),c(wl.$$.fragment,l),c(hl.$$.fragment,l),c(bl.$$.fragment,l),c(gl.$$.fragment,l),c(kl.$$.fragment,l),c(_l.$$.fragment,l),c(xl.$$.fragment,l),c(zl.$$.fragment,l),c(Xl.$$.fragment,l),c(Hl.$$.fragment,l),c(Yl.$$.fragment,l),c(Pl.$$.fragment,l),c(le.$$.fragment,l),c(ee.$$.fragment,l),c(te.$$.fragment,l),c(ne.$$.fragment,l),c(pe.$$.fragment,l),c(oe.$$.fragment,l),c(re.$$.fragment,l),c(me.$$.fragment,l),c(ue.$$.fragment,l),Gs=!0)},o(l){m(u.$$.fragment,l),m(d.$$.fragment,l),m(g.$$.fragment,l),m(N.$$.fragment,l),m(k.$$.fragment,l),m(Z.$$.fragment,l),m(B.$$.fragment,l),m(G.$$.fragment,l),m(_.$$.fragment,l),m(X.$$.fragment,l),m(L.$$.fragment,l),m(K.$$.fragment,l),m(tl.$$.fragment,l),m(nl.$$.fragment,l),m(pl.$$.fragment,l),m(ol.$$.fragment,l),m(rl.$$.fragment,l),m(jl.$$.fragment,l),m(wl.$$.fragment,l),m(hl.$$.fragment,l),m(bl.$$.fragment,l),m(gl.$$.fragment,l),m(kl.$$.fragment,l),m(_l.$$.fragment,l),m(xl.$$.fragment,l),m(zl.$$.fragment,l),m(Xl.$$.fragment,l),m(Hl.$$.fragment,l),m(Yl.$$.fragment,l),m(Pl.$$.fragment,l),m(le.$$.fragment,l),m(ee.$$.fragment,l),m(te.$$.fragment,l),m(ne.$$.fragment,l),m(pe.$$.fragment,l),m(oe.$$.fragment,l),m(re.$$.fragment,l),m(me.$$.fragment,l),m(ue.$$.fragment,l),Gs=!1},d(l){l&&(t(Re),t(fe),t(Ee),t(ge),t(Ne),t(w),t(ke),t(h),t(Ze),t(b),t(Be),t(C),t(Ge),t(f),t(_e),t(I),t(Ae),t(R),t(Ve),t(E),t(ve),t(We),t(Qe),t(xe),t(ze),t(Xe),t(Se),t($e),t(A),t(He),t(V),t(qe),t(v),t(Fe),t(W),t(Ye),t(Q),t(Le),t(x),t(Pe),t(z),t(De),t(Ke),t(S),t(Oe),t($),t(lt),t(H),t(et),t(q),t(tt),t(F),t(st),t(Y),t(nt),t(at),t(P),t(pt),t(D),t(Mt),t(it),t(O),t(ot),t(ll),t(yt),t(el),t(rt),t(ct),t(sl),t(mt),t(Jt),t(al),t(Tt),t(Ut),t(Ml),t(jt),t(il),t(ut),t(dt),t(yl),t(wt),t(ht),t(cl),t(bt),t(ml),t(Ct),t(Jl),t(ft),t(Tl),t(It),t(Ul),t(Rt),t(Et),t(ul),t(gt),t(dl),t(Nt),t(kt),t(Zt),t(Bt),t(Cl),t(Gt),t(fl),t(_t),t(Il),t(At),t(Rl),t(Vt),t(El),t(vt),t(Wt),t(Nl),t(Qt),t(xt),t(Zl),t(zt),t(Bl),t(Xt),t(Gl),t(St),t($t),t(Al),t(Ht),t(Vl),t(qt),t(vl),t(Ft),t(Wl),t(Yt),t(Ql),t(Lt),t(Pt),t(Dt),t(Kt),t(Sl),t(Ot),t($l),t(ls),t(es),t(ql),t(ts),t(Fl),t(ss),t(ns),t(Ll),t(as),t(ps),t(Dl),t(Ms),t(Kl),t(is),t(Ol),t(os),t(ys),t(rs),t(cs),t(se),t(ms),t(Js),t(ae),t(Ts),t(Us),t(Me),t(js),t(ie),t(us),t(ds),t(ye),t(ws),t(hs),t(ce),t(bs),t(Cs),t(Je),t(fs),t(Te),t(Is),t(Ue),t(Rs),t(je),t(Es),t(gs),t(de),t(Ns),t(we),t(ks),t(he),t(Zs),t(be),t(Bs),t(Ie)),t(j),J(u,l),J(d,l),J(g,l),J(N,l),J(k,l),J(Z,l),J(B,l),J(G,l),J(_,l),J(X,l),J(L,l),J(K,l),J(tl,l),J(nl,l),J(pl,l),J(ol,l),J(rl,l),J(jl,l),J(wl,l),J(hl,l),J(bl,l),J(gl,l),J(kl,l),J(_l,l),J(xl,l),J(zl,l),J(Xl,l),J(Hl,l),J(Yl,l),J(Pl,l),J(le,l),J(ee,l),J(te,l),J(ne,l),J(pe,l),J(oe,l),J(re,l),J(me,l),J(ue,l)}}}const ma='{"title":"使用 LangChain 在 HuggingFace 文档上构建高级 RAG","local":"使用-langchain-在-huggingface-文档上构建高级-rag","sections":[{"title":"加载你的知识基础","local":"加载你的知识基础","sections":[],"depth":3}],"depth":1}';function Ja(_s){return pa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class da extends Ma{constructor(j){super(),ia(this,j,Ja,ca,na,{})}}export{da as component};
