import{s as ze,n as He,o as Be}from"../chunks/scheduler.7bc62968.js";import{S as Ee,i as Ge,g as l,s as n,r as p,A as ke,h as o,f as i,c as s,j as _e,u as m,x as r,k as je,y as Ne,a,v as c,d,t as f,w as g}from"../chunks/index.2f8492b0.js";import{C as Qe}from"../chunks/CodeBlock.4e96d6f7.js";import{H as h}from"../chunks/Heading.14fb2476.js";function We(he){let u,Z,W,R,y,q,w,S,M,ye="CLIP is a neural network adept at grasping visual concepts through natural language supervision. It operates by concurrently training a text encoder and an image encoder, focusing on a pretraining task that involves matching captions with corresponding images. This architecture allows CLIP to adapt to a variety of visual classification benchmarks seamlessly. It does so by simply receiving the names of the visual categories to be recognized, demonstrating “zero-shot” learning capabilities akin to those observed in GPT-2 and GPT-3 models.",Y,b,X,v,we="Given a batch of image-text pairs, CLIP computes the dense cosine similarity matrix between all possible (image, text) candidates within this batch. The core idea is to maximize the similarity between the correct pairs (shown in blue in the figure below) and minimize the similarity for incorrect pairs (shown in grey in the image). To do it, they optimize a symmetric cross-entropy loss over these similarity scores.",F,C,Me='<img src="https://images.openai.com/blob/fbc4f633-9ad4-4dc2-bd94-0b6f1feee22f/overview-a.svg" alt="CLIP contrastive pre-training"/> <em>Image taken from OpenAI</em>',A,$,be="Explaining in simple terms, we want to make the similarity between the image and its corresponding caption as high as we can, while the similarity between the image and the other captions should be small. We apply this logic to the caption too, so we want to maximize the similarity of the caption with its corresponding image, and minimize between all other images.",D,T,O,x,ve="CLIP’s design features independent encoders for images and text, allowing flexibility in their choice. Users can switch the standard image encoder, like a Vision Transformer, for alternatives like ResNet, or opt for different text encoders, enhancing adaptability and experimentation. Of course, if you switch one of the encoders, you will need to train your model again, as your embedding distribution will be different.",K,U,ee,I,Ce="CLIP, can be leveraged for a variety of applications. Here are some notable use cases:",te,J,$e="<li>Zero-shot image classification;</li> <li>Similarity search;</li> <li>Diffusion models conditioning.</li>",ie,L,ae,P,Te="For practical applications, one typically uses an image, and pre-defined classes as input. The provided Python example demonstrates how to use the transformers library for running CLIP. In this example, we want to zero-shot classify the image below between <code>dog</code> or <code>cat</code>.",ne,_,xe='<img src="http://images.cocodataset.org/val2017/000000039769.jpg" alt="A photo of cats"/>',se,j,le,z,Ue="After executing this code, we got the following probabilities:",oe,H,Ie="<li>“a photo of a cat”: 99.49%</li> <li>“a photo of a dog”: 0.51%</li>",re,B,pe,E,Je=`Despite CLIP’s proficiency in zero-shot classification, it is unlikely to outperform a specialized, fine-tuned model. Moreover, its generalization capabilities are somewhat limited, particularly in scenarios involving data or examples not encountered during training.
The paper also shows that CLIP’s effectiveness and biases are impacted by the choice of categories, as demonstrated in tests using the Fairface dataset. Notable disparities were found in gender and racial classifications, with gender accuracy over 96% and racial accuracy around 93%.`,me,G,ce,k,Le="In conclusion, the CLIP model from OpenAI has revolutionized the multimodal field. What sets CLIP apart is its proficiency in zero-shot learning, allowing it to classify images into categories it wasn’t explicitly trained on. This remarkable ability to generalize comes from its innovative training method, where it learns to match images with text captions.",de,N,fe,Q,Pe='<li><a href="https://arxiv.org/abs/2103.00020" rel="nofollow">CLIP paper</a></li> <li><a href="https://lilianweng.github.io/posts/2021-05-31-contrastive/#clip" rel="nofollow">CLIP by Lilian Weng</a></li>',ge,V,ue;return y=new h({props:{title:"Contrastive Language-Image Pre-training (CLIP)",local:"contrastive-language-image-pre-training-clip",headingTag:"h1"}}),w=new h({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),b=new h({props:{title:"Contrastive pre-training",local:"contrastive-pre-training",headingTag:"h2"}}),T=new h({props:{title:"Text Encoder and Image Encoder",local:"text-encoder-and-image-encoder",headingTag:"h2"}}),U=new h({props:{title:"Use cases",local:"use-cases",headingTag:"h2"}}),L=new h({props:{title:"Usage",local:"usage",headingTag:"h2"}}),j=new Qe({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFByb2Nlc3NvciUyQyUyMENMSVBNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZjbGlwLXZpdC1iYXNlLXBhdGNoMzIlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQ0xJUFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGY2xpcC12aXQtYmFzZS1wYXRjaDMyJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMiUyQyUyMCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGRvZyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlcyUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHNfcGVyX2ltYWdlJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHNfcGVyX2ltYWdlJTBBcHJvYnMlMjAlM0QlMjBsb2dpdHNfcGVyX2ltYWdlLnNvZnRtYXgoZGltJTNEMSk=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPProcessor, CLIPModel

model = CLIPModel.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch32&quot;</span>)
processor = CLIPProcessor.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch32&quot;</span>)

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

inputs = processor(
    text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>],
    images=image,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

outputs = model(**inputs)
logits_per_image = outputs.logits_per_image
probs = logits_per_image.softmax(dim=<span class="hljs-number">1</span>)`,wrap:!1}}),B=new h({props:{title:"Limitations",local:"limitations",headingTag:"h2"}}),G=new h({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),N=new h({props:{title:"References",local:"references",headingTag:"h2"}}),{c(){u=l("meta"),Z=n(),W=l("p"),R=n(),p(y.$$.fragment),q=n(),p(w.$$.fragment),S=n(),M=l("p"),M.textContent=ye,Y=n(),p(b.$$.fragment),X=n(),v=l("p"),v.textContent=we,F=n(),C=l("p"),C.innerHTML=Me,A=n(),$=l("p"),$.textContent=be,D=n(),p(T.$$.fragment),O=n(),x=l("p"),x.textContent=ve,K=n(),p(U.$$.fragment),ee=n(),I=l("p"),I.textContent=Ce,te=n(),J=l("ul"),J.innerHTML=$e,ie=n(),p(L.$$.fragment),ae=n(),P=l("p"),P.innerHTML=Te,ne=n(),_=l("p"),_.innerHTML=xe,se=n(),p(j.$$.fragment),le=n(),z=l("p"),z.textContent=Ue,oe=n(),H=l("ul"),H.innerHTML=Ie,re=n(),p(B.$$.fragment),pe=n(),E=l("p"),E.textContent=Je,me=n(),p(G.$$.fragment),ce=n(),k=l("p"),k.textContent=Le,de=n(),p(N.$$.fragment),fe=n(),Q=l("ul"),Q.innerHTML=Pe,ge=n(),V=l("p"),this.h()},l(e){const t=ke("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(i),Z=s(e),W=o(e,"P",{}),_e(W).forEach(i),R=s(e),m(y.$$.fragment,e),q=s(e),m(w.$$.fragment,e),S=s(e),M=o(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-ehzu06"&&(M.textContent=ye),Y=s(e),m(b.$$.fragment,e),X=s(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1k56xzf"&&(v.textContent=we),F=s(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1f2xlz1"&&(C.innerHTML=Me),A=s(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-hxbljq"&&($.textContent=be),D=s(e),m(T.$$.fragment,e),O=s(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1nn5dxn"&&(x.textContent=ve),K=s(e),m(U.$$.fragment,e),ee=s(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-qs9t2n"&&(I.textContent=Ce),te=s(e),J=o(e,"UL",{"data-svelte-h":!0}),r(J)!=="svelte-d3etr2"&&(J.innerHTML=$e),ie=s(e),m(L.$$.fragment,e),ae=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-147dtgw"&&(P.innerHTML=Te),ne=s(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-xhmj4j"&&(_.innerHTML=xe),se=s(e),m(j.$$.fragment,e),le=s(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-16udf98"&&(z.textContent=Ue),oe=s(e),H=o(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-1pnyu9z"&&(H.innerHTML=Ie),re=s(e),m(B.$$.fragment,e),pe=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1z1bz9"&&(E.textContent=Je),me=s(e),m(G.$$.fragment,e),ce=s(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1taci8q"&&(k.textContent=Le),de=s(e),m(N.$$.fragment,e),fe=s(e),Q=o(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-18pv8si"&&(Q.innerHTML=Pe),ge=s(e),V=o(e,"P",{}),_e(V).forEach(i),this.h()},h(){je(u,"name","hf:doc:metadata"),je(u,"content",Ve)},m(e,t){Ne(document.head,u),a(e,Z,t),a(e,W,t),a(e,R,t),c(y,e,t),a(e,q,t),c(w,e,t),a(e,S,t),a(e,M,t),a(e,Y,t),c(b,e,t),a(e,X,t),a(e,v,t),a(e,F,t),a(e,C,t),a(e,A,t),a(e,$,t),a(e,D,t),c(T,e,t),a(e,O,t),a(e,x,t),a(e,K,t),c(U,e,t),a(e,ee,t),a(e,I,t),a(e,te,t),a(e,J,t),a(e,ie,t),c(L,e,t),a(e,ae,t),a(e,P,t),a(e,ne,t),a(e,_,t),a(e,se,t),c(j,e,t),a(e,le,t),a(e,z,t),a(e,oe,t),a(e,H,t),a(e,re,t),c(B,e,t),a(e,pe,t),a(e,E,t),a(e,me,t),c(G,e,t),a(e,ce,t),a(e,k,t),a(e,de,t),c(N,e,t),a(e,fe,t),a(e,Q,t),a(e,ge,t),a(e,V,t),ue=!0},p:He,i(e){ue||(d(y.$$.fragment,e),d(w.$$.fragment,e),d(b.$$.fragment,e),d(T.$$.fragment,e),d(U.$$.fragment,e),d(L.$$.fragment,e),d(j.$$.fragment,e),d(B.$$.fragment,e),d(G.$$.fragment,e),d(N.$$.fragment,e),ue=!0)},o(e){f(y.$$.fragment,e),f(w.$$.fragment,e),f(b.$$.fragment,e),f(T.$$.fragment,e),f(U.$$.fragment,e),f(L.$$.fragment,e),f(j.$$.fragment,e),f(B.$$.fragment,e),f(G.$$.fragment,e),f(N.$$.fragment,e),ue=!1},d(e){e&&(i(Z),i(W),i(R),i(q),i(S),i(M),i(Y),i(X),i(v),i(F),i(C),i(A),i($),i(D),i(O),i(x),i(K),i(ee),i(I),i(te),i(J),i(ie),i(ae),i(P),i(ne),i(_),i(se),i(le),i(z),i(oe),i(H),i(re),i(pe),i(E),i(me),i(ce),i(k),i(de),i(fe),i(Q),i(ge),i(V)),i(u),g(y,e),g(w,e),g(b,e),g(T,e),g(U,e),g(L,e),g(j,e),g(B,e),g(G,e),g(N,e)}}}const Ve='{"title":"Contrastive Language-Image Pre-training (CLIP)","local":"contrastive-language-image-pre-training-clip","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"Contrastive pre-training","local":"contrastive-pre-training","sections":[],"depth":2},{"title":"Text Encoder and Image Encoder","local":"text-encoder-and-image-encoder","sections":[],"depth":2},{"title":"Use cases","local":"use-cases","sections":[],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"Limitations","local":"limitations","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function Ze(he){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xe extends Ee{constructor(u){super(),Ge(this,u,Ze,We,ze,{})}}export{Xe as component};
