import{s as Jt,n as Ut,o as It}from"../chunks/scheduler.d6170356.js";import{S as bt,i as kt,g as p,s as a,r as c,A as $t,h as i,f as t,c as n,j as ft,u as r,x as o,k as j,y as Ct,a as l,v as h,d as u,t as M,w as d}from"../chunks/index.fcd4cc08.js";import{C as m}from"../chunks/CodeBlock.7b16bdef.js";import{H as g,E as Bt}from"../chunks/EditOnGithub.da2b595c.js";function Rt(Ae){let T,Cs,ks,Bs,B,Rs,R,xe='In the following sections, you’ll learn the basics of creating a Docker Space, configuring it, and deploying your code to it. We’ll create a <strong>Text Generation</strong> Space with Docker that’ll be used to demo the <a href="https://huggingface.co/google/flan-t5-small" rel="nofollow">google/flan-t5-small</a> model, which can generate text given some input text, using FastAPI as the server.',vs,v,Ge='You can find a completed version of this hosted <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_t5" rel="nofollow">here</a>.',Zs,Z,Es,E,Qe='We’ll start by <a href="https://huggingface.co/new-space" rel="nofollow">creating a brand new Space</a> and choosing <strong>Docker</strong> as our SDK.',Vs,y,_e='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface.co_new-space_docker.jpg"/>',Hs,V,Xe='Hugging Face Spaces are Git repositories, meaning that you can work on your Space incrementally (and collaboratively) by pushing commits. Take a look at the <a href="./repositories-getting-started">Getting Started with Repositories</a> guide to learn about how you can create and edit files before continuing. If you prefer to work with a UI, you can also do the work directly in the browser.',Ss,H,We='Selecting <strong>Docker</strong> as the SDK when <a href="https://huggingface.co/new-space" rel="nofollow">creating a new Space</a> will initialize your Docker Space by setting the <code>sdk</code> property to <code>docker</code> in your <code>README.md</code> file’s YAML block.',Ls,S,As,L,Ne="You have the option to change the default application port of your Space by setting the <code>app_port</code> property in your <code>README.md</code> file’s YAML block. The default port is <code>7860</code>.",xs,A,Gs,x,Qs,G,Fe='For the <strong>Text Generation</strong> Space, we’ll be building a FastAPI app that showcases a text generation model called Flan T5. For the model inference, we’ll be using a <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">🤗 Transformers pipeline</a> to use the model. We need to start by installing a few dependencies. This can be done by creating a <strong>requirements.txt</strong> file in our repository, and adding the following dependencies to it:',_s,Q,Xs,_,qe="These dependencies will be installed in the Dockerfile we’ll create later.",Ws,X,Ns,W,Ye="Let’s kick off the process with a dummy FastAPI app to see that we can get an endpoint working. The first step is to create an app file, in this case, we’ll call it <code>main.py</code>.",Fs,N,qs,F,Ys,q,ze='The main step for a Docker Space is creating a Dockerfile. You can read more about Dockerfiles <a href="https://docs.docker.com/get-started/" rel="nofollow">here</a>. Although we’re using FastAPI in this tutorial, Dockerfiles give great flexibility to users allowing you to build a new generation of ML demos. Let’s write the Dockerfile for our application',zs,Y,Ds,z,De='When the changes are saved, the Space will rebuild and your demo should be up after a couple of seconds! <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_dummy" rel="nofollow">Here</a> is an example result at this point.',Ps,w,Pe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_dummy.jpg"/>',Os,D,Ks,P,Oe="<strong>Tip for power users (you can skip):</strong> If you’re developing locally, this is a good moment in which you can do <code>docker build</code> and <code>docker run</code> to debug locally, but it’s even easier to push the changes to the Hub and see how it looks like!",se,O,ee,K,Ke='If you have <a href="spaces-sdks-docker#secret-management">Secrets</a> you can use <code>docker buildx</code> and pass the secrets as build arguments',te,ss,le,es,st="and run with <code>docker run</code> passing the secrets as environment variables",ae,ts,ne,ls,pe,as,et="As mentioned before, the idea is to use a Flan T5 model for text generation. We’ll want to add some HTML and CSS for an input field, so let’s create a directory called static with <code>index.html</code>, <code>style.css</code>, and <code>script.js</code> files. At this moment, your file structure should look like this:",ie,ns,oe,ps,tt='Let’s go through all the steps to make this working. We’ll skip some of the details of the CSS and HTML. You can find the whole code in the Files and versions tab of the <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_t5" rel="nofollow">DockerTemplates/fastapi_t5</a> Space.',ce,is,lt="<li>Write the FastAPI endpoint to do inference</li>",re,os,at='We’ll use the <code>pipeline</code> from <code>transformers</code> to load the <a href="https://huggingface.co/google/flan-t5-small" rel="nofollow">google/flan-t5-small</a> model. We’ll set an endpoint called <code>infer_t5</code> that receives and input and outputs the result of the inference call',he,cs,ue,f,nt="<li>Write the <code>index.html</code> to have a simple form containing the code of the page.</li>",Me,rs,de,J,pt="<li>In the <code>app.py</code> file, mount the static files and show the html file in the root route</li>",me,hs,je,U,it="<li>In the <code>script.js</code> file, make it handle the request</li>",Te,us,ge,I,ot="<li>Grant permissions to the right directories</li>",ye,Ms,ct='As discussed in the <a href="./spaces-sdks-docker#permissions">Permissions Section</a>, the container runs with user ID 1000. That means that the Space might face permission issues. For example, <code>transformers</code> downloads and caches the models in the path under the <code>HUGGINGFACE_HUB_CACHE</code> path. The easiest way to solve this is to create a user with righ permissions and use it to run the container application. We can do this by adding the following lines to the <code>Dockerfile</code>.',we,ds,fe,ms,rt="The final <code>Dockerfile</code> should look like this:",Je,js,Ue,Ts,ht='Success! Your app should be working now! Check out <a href="https://huggingface.co/spaces/DockerTemplates/fastapi_t5" rel="nofollow">DockerTemplates/fastapi_t5</a> to see the final result.',Ie,b,ut='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5.jpg"/>',be,gs,Mt='What a journey! Please remember that Docker Spaces give you lots of freedom, so you’re not limited to use FastAPI. From a <a href="https://huggingface.co/spaces/DockerTemplates/test-docker-go" rel="nofollow">Go Endpoint</a> to a <a href="https://huggingface.co/spaces/DockerTemplates/shiny-with-python" rel="nofollow">Shiny App</a>, the limit is the moon! Check out <a href="./spaces-sdks-docker-examples">some official examples</a>. You can also upgrade your Space to a GPU if needed 😃',ke,ys,$e,ws,dt="You can debug your Space by checking the <strong>Build</strong> and <strong>Container</strong> logs. Click on the <strong>Open Logs</strong> button to open the modal.",Ce,k,mt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5_3.jpg"/>',Be,fs,jt="If everything went well, you will see <code>Pushing Image</code> and <code>Scheduling Space</code> on the <strong>Build</strong> tab",Re,$,Tt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5_1.jpg"/>',ve,Js,gt="On the <strong>Container</strong> tab, you will see the application status, in this case, <code>Uvicorn running on http://0.0.0.0:7860</code>",Ze,C,yt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/huggingface.co_spaces_docker_fastapi_t5_2.jpg"/>',Ee,Us,Ve,Is,wt='<li><a href="spaces-sdks-docker">Docker Spaces</a></li> <li><a href="spaces-sdks-docker-examples">List of Docker Spaces examples</a></li>',He,bs,Se,$s,Le;return B=new g({props:{title:"Your First Docker Space: Text Generation with T5",local:"your-first-docker-space-text-generation-with-t5",headingTag:"h1"}}),Z=new g({props:{title:"Create a new Docker Space",local:"create-a-new-docker-space",headingTag:"h2"}}),S=new m({props:{code:"c2RrJTNBJTIwZG9ja2Vy",highlighted:'<span class="hljs-attr">sdk:</span> <span class="hljs-string">docker</span>',wrap:!1}}),A=new m({props:{code:"YXBwX3BvcnQlM0ElMjA3ODYw",highlighted:'<span class="hljs-attr">app_port:</span> <span class="hljs-number">7860</span>',wrap:!1}}),x=new g({props:{title:"Add the dependencies",local:"add-the-dependencies",headingTag:"h2"}}),Q=new m({props:{code:"ZmFzdGFwaSUzRCUzRDAuNzQuKiUwQXJlcXVlc3RzJTNEJTNEMi4yNy4qJTBBc2VudGVuY2VwaWVjZSUzRCUzRDAuMS4qJTBBdG9yY2glM0QlM0QxLjExLiolMEF0cmFuc2Zvcm1lcnMlM0QlM0Q0LiolMEF1dmljb3JuJTVCc3RhbmRhcmQlNUQlM0QlM0QwLjE3Lio=",highlighted:`<span class="hljs-attribute">fastapi</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">0.74</span>.*
<span class="hljs-attribute">requests</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">2.27</span>.*
<span class="hljs-attribute">sentencepiece</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">0.1</span>.*
<span class="hljs-attribute">torch</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">1.11</span>.*
<span class="hljs-attribute">transformers</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">4</span>.*
uvicorn[standard]<span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-number">0.17</span>.*`,wrap:!1}}),X=new g({props:{title:"Create the app",local:"create-the-app",headingTag:"h2"}}),N=new m({props:{code:"ZnJvbSUyMGZhc3RhcGklMjBpbXBvcnQlMjBGYXN0QVBJJTBBJTBBYXBwJTIwJTNEJTIwRmFzdEFQSSgpJTBBJTBBJTQwYXBwLmdldCglMjIlMkYlMjIpJTBBZGVmJTIwcmVhZF9yb290KCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJIZWxsbyUyMiUzQSUyMCUyMldvcmxkISUyMiU3RA==",highlighted:`<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI

app = FastAPI()

<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_root</span>():
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;Hello&quot;</span>: <span class="hljs-string">&quot;World!&quot;</span>}`,wrap:!1}}),F=new g({props:{title:"Create the Dockerfile",local:"create-the-dockerfile",headingTag:"h2"}}),Y=new m({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuOSUwQSUwQVdPUktESVIlMjAlMkZjb2RlJTBBJTBBQ09QWSUyMC4lMkZyZXF1aXJlbWVudHMudHh0JTIwJTJGY29kZSUyRnJlcXVpcmVtZW50cy50eHQlMEElMEFSVU4lMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjAtciUyMCUyRmNvZGUlMkZyZXF1aXJlbWVudHMudHh0JTBBJTBBQ09QWSUyMC4lMjAuJTBBJTBBQ01EJTIwJTVCJTIydXZpY29ybiUyMiUyQyUyMCUyMm1haW4lM0FhcHAlMjIlMkMlMjAlMjItLWhvc3QlMjIlMkMlMjAlMjIwLjAuMC4wJTIyJTJDJTIwJTIyLS1wb3J0JTIyJTJDJTIwJTIyNzg2MCUyMiU1RCUwQQ==",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.9</span>

<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /code</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> ./requirements.txt /code/requirements.txt</span>

<span class="hljs-keyword">RUN</span><span class="language-bash"> pip install --no-cache-dir --upgrade -r /code/requirements.txt</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> . .</span>

<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;uvicorn&quot;</span>, <span class="hljs-string">&quot;main:app&quot;</span>, <span class="hljs-string">&quot;--host&quot;</span>, <span class="hljs-string">&quot;0.0.0.0&quot;</span>, <span class="hljs-string">&quot;--port&quot;</span>, <span class="hljs-string">&quot;7860&quot;</span>]</span>
`,wrap:!1}}),D=new g({props:{title:"Testing locally",local:"testing-locally",headingTag:"h3"}}),O=new m({props:{code:"ZG9ja2VyJTIwYnVpbGQlMjAtdCUyMGZhc3RhcGklMjAuJTBBZG9ja2VyJTIwcnVuJTIwJTIwLWl0JTIwLXAlMjA3ODYwJTNBNzg2MCUyMGZhc3RhcGk=",highlighted:`docker build -t fastapi .
docker run  -it -p 7860:7860 fastapi`,wrap:!1}}),ss=new m({props:{code:"ZXhwb3J0JTIwU0VDUkVUX0VYQU1QTEUlM0QlMjJteV9zZWNyZXRfdmFsdWUlMjIlMEFkb2NrZXIlMjBidWlsZHglMjBidWlsZCUyMC0tc2VjcmV0JTIwaWQlM0RTRUNSRVRfRVhBTVBMRSUyQ2VudiUzRFNFQ1JFVF9FWEFNUExFJTIwLXQlMjBmYXN0YXBpJTIwLg==",highlighted:`<span class="hljs-built_in">export</span> SECRET_EXAMPLE=<span class="hljs-string">&quot;my_secret_value&quot;</span>
docker buildx build --secret <span class="hljs-built_in">id</span>=SECRET_EXAMPLE,<span class="hljs-built_in">env</span>=SECRET_EXAMPLE -t fastapi .`,wrap:!1}}),ts=new m({props:{code:"ZXhwb3J0JTIwU0VDUkVUX0VYQU1QTEUlM0QlMjJteV9zZWNyZXRfdmFsdWUlMjIlMEFkb2NrZXIlMjBydW4lMjAtaXQlMjAtcCUyMDc4NjAlM0E3ODYwJTIwLWUlMjBTRUNSRVRfRVhBTVBMRSUzRCUyNFNFQ1JFVF9FWEFNUExFJTIwZmFzdGFwaQ==",highlighted:`<span class="hljs-built_in">export</span> SECRET_EXAMPLE=<span class="hljs-string">&quot;my_secret_value&quot;</span>
docker run -it -p 7860:7860 -e SECRET_EXAMPLE=<span class="hljs-variable">$SECRET_EXAMPLE</span> fastapi`,wrap:!1}}),ls=new g({props:{title:"Adding some ML to our app",local:"adding-some-ml-to-our-app",headingTag:"h2"}}),ns=new m({props:{code:"JTJGc3RhdGljJTBBJTJGc3RhdGljJTJGaW5kZXguaHRtbCUwQSUyRnN0YXRpYyUyRnNjcmlwdC5qcyUwQSUyRnN0YXRpYyUyRnN0eWxlLmNzcyUwQURvY2tlcmZpbGUlMEFtYWluLnB5JTBBUkVBRE1FLm1kJTBBcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`/static
/static/index.html
/static/script.js
/static/style.css
Dockerfile
main.py
README.md
requirements.txt`,wrap:!1}}),cs=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZV9mbGFuJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dDJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRmZsYW4tdDUtc21hbGwlMjIpJTBBJTBBJTQwYXBwLmdldCglMjIlMkZpbmZlcl90NSUyMiklMEFkZWYlMjB0NShpbnB1dCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjBwaXBlX2ZsYW4oaW5wdXQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyb3V0cHV0JTIyJTNBJTIwb3V0cHV0JTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEJTdE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe_flan = pipeline(<span class="hljs-string">&quot;text2text-generation&quot;</span>, model=<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/infer_t5&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">t5</span>(<span class="hljs-params"><span class="hljs-built_in">input</span></span>):
    output = pipe_flan(<span class="hljs-built_in">input</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;output&quot;</span>: output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]}`,wrap:!1}}),rs=new m({props:{code:"JTNDbWFpbiUzRSUwQSUyMCUyMCUzQ3NlY3Rpb24lMjBpZCUzRCUyMnRleHQtZ2VuJTIyJTNFJTBBJTIwJTIwJTIwJTIwJTNDaDIlM0VUZXh0JTIwZ2VuZXJhdGlvbiUyMHVzaW5nJTIwRmxhbiUyMFQ1JTNDJTJGaDIlM0UlMEElMjAlMjAlMjAlMjAlM0NwJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwTW9kZWwlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlM0NhJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaHJlZiUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVsJTNEJTIybm9yZWZlcnJlciUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldCUzRCUyMl9ibGFuayUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRWdvb2dsZSUyRmZsYW4tdDUtc21hbGwlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0MlMkZhJTNFJTBBJTIwJTIwJTIwJTIwJTNDJTJGcCUzRSUwQSUyMCUyMCUyMCUyMCUzQ2Zvcm0lMjBjbGFzcyUzRCUyMnRleHQtZ2VuLWZvcm0lMjIlM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0NsYWJlbCUyMGZvciUzRCUyMnRleHQtZ2VuLWlucHV0JTIyJTNFVGV4dCUyMHByb21wdCUzQyUyRmxhYmVsJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTNDaW5wdXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZCUzRCUyMnRleHQtZ2VuLWlucHV0JTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2YWx1ZSUzRCUyMkdlcm1hbiUzQSUyMFRoZXJlJTIwYXJlJTIwbWFueSUyMGR1Y2tzJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTNFJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTNDYnV0dG9uJTIwaWQlM0QlMjJ0ZXh0LWdlbi1zdWJtaXQlMjIlM0VTdWJtaXQlM0MlMkZidXR0b24lM0UlMEElMjAlMjAlMjAlMjAlMjAlMjAlM0NwJTIwY2xhc3MlM0QlMjJ0ZXh0LWdlbi1vdXRwdXQlMjIlM0UlM0MlMkZwJTNFJTBBJTIwJTIwJTIwJTIwJTNDJTJGZm9ybSUzRSUwQSUyMCUyMCUzQyUyRnNlY3Rpb24lM0UlMEElM0MlMkZtYWluJTNF",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">main</span>&gt;</span>
  <span class="hljs-tag">&lt;<span class="hljs-name">section</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;text-gen&quot;</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">h2</span>&gt;</span>Text generation using Flan T5<span class="hljs-tag">&lt;/<span class="hljs-name">h2</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">p</span>&gt;</span>
      Model:
      <span class="hljs-tag">&lt;<span class="hljs-name">a</span>
        <span class="hljs-attr">href</span>=<span class="hljs-string">&quot;https://huggingface.co/google/flan-t5-small&quot;</span>
        <span class="hljs-attr">rel</span>=<span class="hljs-string">&quot;noreferrer&quot;</span>
        <span class="hljs-attr">target</span>=<span class="hljs-string">&quot;_blank&quot;</span>
        &gt;</span>google/flan-t5-small
      <span class="hljs-tag">&lt;/<span class="hljs-name">a</span>&gt;</span>
    <span class="hljs-tag">&lt;/<span class="hljs-name">p</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">form</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;text-gen-form&quot;</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">label</span> <span class="hljs-attr">for</span>=<span class="hljs-string">&quot;text-gen-input&quot;</span>&gt;</span>Text prompt<span class="hljs-tag">&lt;/<span class="hljs-name">label</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">input</span>
        <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;text-gen-input&quot;</span>
        <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;text&quot;</span>
        <span class="hljs-attr">value</span>=<span class="hljs-string">&quot;German: There are many ducks&quot;</span>
      /&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">button</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;text-gen-submit&quot;</span>&gt;</span>Submit<span class="hljs-tag">&lt;/<span class="hljs-name">button</span>&gt;</span>
      <span class="hljs-tag">&lt;<span class="hljs-name">p</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;text-gen-output&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">p</span>&gt;</span>
    <span class="hljs-tag">&lt;/<span class="hljs-name">form</span>&gt;</span>
  <span class="hljs-tag">&lt;/<span class="hljs-name">section</span>&gt;</span>
<span class="hljs-tag">&lt;/<span class="hljs-name">main</span>&gt;</span>`,wrap:!1}}),hs=new m({props:{code:"YXBwLm1vdW50KCUyMiUyRiUyMiUyQyUyMFN0YXRpY0ZpbGVzKGRpcmVjdG9yeSUzRCUyMnN0YXRpYyUyMiUyQyUyMGh0bWwlM0RUcnVlKSUyQyUyMG5hbWUlM0QlMjJzdGF0aWMlMjIpJTBBJTBBJTQwYXBwLmdldCglMjIlMkYlMjIpJTBBZGVmJTIwaW5kZXgoKSUyMC0lM0UlMjBGaWxlUmVzcG9uc2UlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBGaWxlUmVzcG9uc2UocGF0aCUzRCUyMiUyRmFwcCUyRnN0YXRpYyUyRmluZGV4Lmh0bWwlMjIlMkMlMjBtZWRpYV90eXBlJTNEJTIydGV4dCUyRmh0bWwlMjIp",highlighted:`app.mount(<span class="hljs-string">&quot;/&quot;</span>, StaticFiles(directory=<span class="hljs-string">&quot;static&quot;</span>, html=<span class="hljs-literal">True</span>), name=<span class="hljs-string">&quot;static&quot;</span>)

<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/&quot;</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">index</span>() -&gt; FileResponse:
    <span class="hljs-keyword">return</span> FileResponse(path=<span class="hljs-string">&quot;/app/static/index.html&quot;</span>, media_type=<span class="hljs-string">&quot;text/html&quot;</span>)`,wrap:!1}}),us=new m({props:{code:"Y29uc3QlMjB0ZXh0R2VuRm9ybSUyMCUzRCUyMGRvY3VtZW50LnF1ZXJ5U2VsZWN0b3IoJTIyLnRleHQtZ2VuLWZvcm0lMjIpJTNCJTBBJTBBY29uc3QlMjB0cmFuc2xhdGVUZXh0JTIwJTNEJTIwYXN5bmMlMjAodGV4dCklMjAlM0QlM0UlMjAlN0IlMEElMjAlMjBjb25zdCUyMGluZmVyUmVzcG9uc2UlMjAlM0QlMjBhd2FpdCUyMGZldGNoKCU2MGluZmVyX3Q1JTNGaW5wdXQlM0QlMjQlN0J0ZXh0JTdEJTYwKSUzQiUwQSUyMCUyMGNvbnN0JTIwaW5mZXJKc29uJTIwJTNEJTIwYXdhaXQlMjBpbmZlclJlc3BvbnNlLmpzb24oKSUzQiUwQSUwQSUyMCUyMHJldHVybiUyMGluZmVySnNvbi5vdXRwdXQlM0IlMEElN0QlM0IlMEElMEF0ZXh0R2VuRm9ybS5hZGRFdmVudExpc3RlbmVyKCUyMnN1Ym1pdCUyMiUyQyUyMGFzeW5jJTIwKGV2ZW50KSUyMCUzRCUzRSUyMCU3QiUwQSUyMCUyMGV2ZW50LnByZXZlbnREZWZhdWx0KCklM0IlMEElMEElMjAlMjBjb25zdCUyMHRleHRHZW5JbnB1dCUyMCUzRCUyMGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKCUyMnRleHQtZ2VuLWlucHV0JTIyKSUzQiUwQSUyMCUyMGNvbnN0JTIwdGV4dEdlblBhcmFncmFwaCUyMCUzRCUyMGRvY3VtZW50LnF1ZXJ5U2VsZWN0b3IoJTIyLnRleHQtZ2VuLW91dHB1dCUyMiklM0IlMEElMEElMjAlMjB0ZXh0R2VuUGFyYWdyYXBoLnRleHRDb250ZW50JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdGVUZXh0KHRleHRHZW5JbnB1dC52YWx1ZSklM0IlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">const</span> textGenForm = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">querySelector</span>(<span class="hljs-string">&quot;.text-gen-form&quot;</span>);

<span class="hljs-keyword">const</span> <span class="hljs-title function_">translateText</span> = <span class="hljs-keyword">async</span> (<span class="hljs-params">text</span>) =&gt; {
  <span class="hljs-keyword">const</span> inferResponse = <span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">\`infer_t5?input=<span class="hljs-subst">\${text}</span>\`</span>);
  <span class="hljs-keyword">const</span> inferJson = <span class="hljs-keyword">await</span> inferResponse.<span class="hljs-title function_">json</span>();

  <span class="hljs-keyword">return</span> inferJson.<span class="hljs-property">output</span>;
};

textGenForm.<span class="hljs-title function_">addEventListener</span>(<span class="hljs-string">&quot;submit&quot;</span>, <span class="hljs-keyword">async</span> (event) =&gt; {
  event.<span class="hljs-title function_">preventDefault</span>();

  <span class="hljs-keyword">const</span> textGenInput = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&quot;text-gen-input&quot;</span>);
  <span class="hljs-keyword">const</span> textGenParagraph = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">querySelector</span>(<span class="hljs-string">&quot;.text-gen-output&quot;</span>);

  textGenParagraph.<span class="hljs-property">textContent</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translateText</span>(textGenInput.<span class="hljs-property">value</span>);
});`,wrap:!1}}),ds=new m({props:{code:"JTIzJTIwU2V0JTIwdXAlMjBhJTIwbmV3JTIwdXNlciUyMG5hbWVkJTIwJTIydXNlciUyMiUyMHdpdGglMjB1c2VyJTIwSUQlMjAxMDAwJTBBUlVOJTIwdXNlcmFkZCUyMC1tJTIwLXUlMjAxMDAwJTIwdXNlciUwQSUwQSUyMyUyMFN3aXRjaCUyMHRvJTIwdGhlJTIwJTIydXNlciUyMiUyMHVzZXIlMEFVU0VSJTIwdXNlciUwQSUwQSUyMyUyMFNldCUyMGhvbWUlMjB0byUyMHRoZSUyMHVzZXIncyUyMGhvbWUlMjBkaXJlY3RvcnklMEFFTlYlMjBIT01FJTNEJTJGaG9tZSUyRnVzZXIlMjAlNUMlMEElMDlQQVRIJTNEJTJGaG9tZSUyRnVzZXIlMkYubG9jYWwlMkZiaW4lM0ElMjRQQVRIJTBBJTBBJTIzJTIwU2V0JTIwdGhlJTIwd29ya2luZyUyMGRpcmVjdG9yeSUyMHRvJTIwdGhlJTIwdXNlcidzJTIwaG9tZSUyMGRpcmVjdG9yeSUwQVdPUktESVIlMjAlMjRIT01FJTJGYXBwJTBBJTBBJTIzJTIwQ29weSUyMHRoZSUyMGN1cnJlbnQlMjBkaXJlY3RvcnklMjBjb250ZW50cyUyMGludG8lMjB0aGUlMjBjb250YWluZXIlMjBhdCUyMCUyNEhPTUUlMkZhcHAlMjBzZXR0aW5nJTIwdGhlJTIwb3duZXIlMjB0byUyMHRoZSUyMHVzZXIlMEFDT1BZJTIwLS1jaG93biUzRHVzZXIlMjAuJTIwJTI0SE9NRSUyRmFwcA==",highlighted:`<span class="hljs-comment"># Set up a new user named &quot;user&quot; with user ID 1000</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> useradd -m -u 1000 user</span>

<span class="hljs-comment"># Switch to the &quot;user&quot; user</span>
<span class="hljs-keyword">USER</span> <span class="hljs-keyword">user</span>

<span class="hljs-comment"># Set home to the user&#x27;s home directory</span>
<span class="hljs-keyword">ENV</span> HOME=/home/<span class="hljs-keyword">user</span> \\
	PATH=/home/<span class="hljs-keyword">user</span>/.local/bin:$PATH

<span class="hljs-comment"># Set the working directory to the user&#x27;s home directory</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> <span class="hljs-variable">$HOME</span>/app</span>

<span class="hljs-comment"># Copy the current directory contents into the container at $HOME/app setting the owner to the user</span>
<span class="hljs-keyword">COPY</span><span class="language-bash"> --<span class="hljs-built_in">chown</span>=user . <span class="hljs-variable">$HOME</span>/app</span>`,wrap:!1}}),js=new m({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuOSUwQSUwQVdPUktESVIlMjAlMkZjb2RlJTBBJTBBQ09QWSUyMC4lMkZyZXF1aXJlbWVudHMudHh0JTIwJTJGY29kZSUyRnJlcXVpcmVtZW50cy50eHQlMEElMEFSVU4lMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjAtciUyMCUyRmNvZGUlMkZyZXF1aXJlbWVudHMudHh0JTBBJTBBUlVOJTIwdXNlcmFkZCUyMC1tJTIwLXUlMjAxMDAwJTIwdXNlciUwQSUwQVVTRVIlMjB1c2VyJTBBJTBBRU5WJTIwSE9NRSUzRCUyRmhvbWUlMkZ1c2VyJTIwJTVDJTBBJTA5UEFUSCUzRCUyRmhvbWUlMkZ1c2VyJTJGLmxvY2FsJTJGYmluJTNBJTI0UEFUSCUwQSUwQVdPUktESVIlMjAlMjRIT01FJTJGYXBwJTBBJTBBQ09QWSUyMC0tY2hvd24lM0R1c2VyJTIwLiUyMCUyNEhPTUUlMkZhcHAlMEElMEFDTUQlMjAlNUIlMjJ1dmljb3JuJTIyJTJDJTIwJTIybWFpbiUzQWFwcCUyMiUyQyUyMCUyMi0taG9zdCUyMiUyQyUyMCUyMjAuMC4wLjAlMjIlMkMlMjAlMjItLXBvcnQlMjIlMkMlMjAlMjI3ODYwJTIyJTVE",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.9</span>

<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /code</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> ./requirements.txt /code/requirements.txt</span>

<span class="hljs-keyword">RUN</span><span class="language-bash"> pip install --no-cache-dir --upgrade -r /code/requirements.txt</span>

<span class="hljs-keyword">RUN</span><span class="language-bash"> useradd -m -u 1000 user</span>

<span class="hljs-keyword">USER</span> <span class="hljs-keyword">user</span>

<span class="hljs-keyword">ENV</span> HOME=/home/<span class="hljs-keyword">user</span> \\
	PATH=/home/<span class="hljs-keyword">user</span>/.local/bin:$PATH

<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> <span class="hljs-variable">$HOME</span>/app</span>

<span class="hljs-keyword">COPY</span><span class="language-bash"> --<span class="hljs-built_in">chown</span>=user . <span class="hljs-variable">$HOME</span>/app</span>

<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;uvicorn&quot;</span>, <span class="hljs-string">&quot;main:app&quot;</span>, <span class="hljs-string">&quot;--host&quot;</span>, <span class="hljs-string">&quot;0.0.0.0&quot;</span>, <span class="hljs-string">&quot;--port&quot;</span>, <span class="hljs-string">&quot;7860&quot;</span>]</span>`,wrap:!1}}),ys=new g({props:{title:"Debugging",local:"debugging",headingTag:"h2"}}),Us=new g({props:{title:"Read More",local:"read-more",headingTag:"h2"}}),bs=new Bt({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/spaces-sdks-docker-first-demo.md"}}),{c(){T=p("meta"),Cs=a(),ks=p("p"),Bs=a(),c(B.$$.fragment),Rs=a(),R=p("p"),R.innerHTML=xe,vs=a(),v=p("p"),v.innerHTML=Ge,Zs=a(),c(Z.$$.fragment),Es=a(),E=p("p"),E.innerHTML=Qe,Vs=a(),y=p("div"),y.innerHTML=_e,Hs=a(),V=p("p"),V.innerHTML=Xe,Ss=a(),H=p("p"),H.innerHTML=We,Ls=a(),c(S.$$.fragment),As=a(),L=p("p"),L.innerHTML=Ne,xs=a(),c(A.$$.fragment),Gs=a(),c(x.$$.fragment),Qs=a(),G=p("p"),G.innerHTML=Fe,_s=a(),c(Q.$$.fragment),Xs=a(),_=p("p"),_.textContent=qe,Ws=a(),c(X.$$.fragment),Ns=a(),W=p("p"),W.innerHTML=Ye,Fs=a(),c(N.$$.fragment),qs=a(),c(F.$$.fragment),Ys=a(),q=p("p"),q.innerHTML=ze,zs=a(),c(Y.$$.fragment),Ds=a(),z=p("p"),z.innerHTML=De,Ps=a(),w=p("div"),w.innerHTML=Pe,Os=a(),c(D.$$.fragment),Ks=a(),P=p("p"),P.innerHTML=Oe,se=a(),c(O.$$.fragment),ee=a(),K=p("p"),K.innerHTML=Ke,te=a(),c(ss.$$.fragment),le=a(),es=p("p"),es.innerHTML=st,ae=a(),c(ts.$$.fragment),ne=a(),c(ls.$$.fragment),pe=a(),as=p("p"),as.innerHTML=et,ie=a(),c(ns.$$.fragment),oe=a(),ps=p("p"),ps.innerHTML=tt,ce=a(),is=p("ol"),is.innerHTML=lt,re=a(),os=p("p"),os.innerHTML=at,he=a(),c(cs.$$.fragment),ue=a(),f=p("ol"),f.innerHTML=nt,Me=a(),c(rs.$$.fragment),de=a(),J=p("ol"),J.innerHTML=pt,me=a(),c(hs.$$.fragment),je=a(),U=p("ol"),U.innerHTML=it,Te=a(),c(us.$$.fragment),ge=a(),I=p("ol"),I.innerHTML=ot,ye=a(),Ms=p("p"),Ms.innerHTML=ct,we=a(),c(ds.$$.fragment),fe=a(),ms=p("p"),ms.innerHTML=rt,Je=a(),c(js.$$.fragment),Ue=a(),Ts=p("p"),Ts.innerHTML=ht,Ie=a(),b=p("div"),b.innerHTML=ut,be=a(),gs=p("p"),gs.innerHTML=Mt,ke=a(),c(ys.$$.fragment),$e=a(),ws=p("p"),ws.innerHTML=dt,Ce=a(),k=p("div"),k.innerHTML=mt,Be=a(),fs=p("p"),fs.innerHTML=jt,Re=a(),$=p("div"),$.innerHTML=Tt,ve=a(),Js=p("p"),Js.innerHTML=gt,Ze=a(),C=p("div"),C.innerHTML=yt,Ee=a(),c(Us.$$.fragment),Ve=a(),Is=p("ul"),Is.innerHTML=wt,He=a(),c(bs.$$.fragment),Se=a(),$s=p("p"),this.h()},l(s){const e=$t("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(t),Cs=n(s),ks=i(s,"P",{}),ft(ks).forEach(t),Bs=n(s),r(B.$$.fragment,s),Rs=n(s),R=i(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-jw7cyg"&&(R.innerHTML=xe),vs=n(s),v=i(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1i4ovll"&&(v.innerHTML=Ge),Zs=n(s),r(Z.$$.fragment,s),Es=n(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-v1etaf"&&(E.innerHTML=Qe),Vs=n(s),y=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-1t9e90m"&&(y.innerHTML=_e),Hs=n(s),V=i(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1eepspk"&&(V.innerHTML=Xe),Ss=n(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1ebivvn"&&(H.innerHTML=We),Ls=n(s),r(S.$$.fragment,s),As=n(s),L=i(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-16g740l"&&(L.innerHTML=Ne),xs=n(s),r(A.$$.fragment,s),Gs=n(s),r(x.$$.fragment,s),Qs=n(s),G=i(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-saf9yg"&&(G.innerHTML=Fe),_s=n(s),r(Q.$$.fragment,s),Xs=n(s),_=i(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-nrg5eu"&&(_.textContent=qe),Ws=n(s),r(X.$$.fragment,s),Ns=n(s),W=i(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-o8f96i"&&(W.innerHTML=Ye),Fs=n(s),r(N.$$.fragment,s),qs=n(s),r(F.$$.fragment,s),Ys=n(s),q=i(s,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1jworwg"&&(q.innerHTML=ze),zs=n(s),r(Y.$$.fragment,s),Ds=n(s),z=i(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1qy8wh6"&&(z.innerHTML=De),Ps=n(s),w=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1gv7naz"&&(w.innerHTML=Pe),Os=n(s),r(D.$$.fragment,s),Ks=n(s),P=i(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1887xzo"&&(P.innerHTML=Oe),se=n(s),r(O.$$.fragment,s),ee=n(s),K=i(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1wqy5vs"&&(K.innerHTML=Ke),te=n(s),r(ss.$$.fragment,s),le=n(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-zs1fi1"&&(es.innerHTML=st),ae=n(s),r(ts.$$.fragment,s),ne=n(s),r(ls.$$.fragment,s),pe=n(s),as=i(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-1gdsumy"&&(as.innerHTML=et),ie=n(s),r(ns.$$.fragment,s),oe=n(s),ps=i(s,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-16tk1cq"&&(ps.innerHTML=tt),ce=n(s),is=i(s,"OL",{"data-svelte-h":!0}),o(is)!=="svelte-42bpu9"&&(is.innerHTML=lt),re=n(s),os=i(s,"P",{"data-svelte-h":!0}),o(os)!=="svelte-1s0pz1q"&&(os.innerHTML=at),he=n(s),r(cs.$$.fragment,s),ue=n(s),f=i(s,"OL",{start:!0,"data-svelte-h":!0}),o(f)!=="svelte-k9s0qn"&&(f.innerHTML=nt),Me=n(s),r(rs.$$.fragment,s),de=n(s),J=i(s,"OL",{start:!0,"data-svelte-h":!0}),o(J)!=="svelte-19p8yis"&&(J.innerHTML=pt),me=n(s),r(hs.$$.fragment,s),je=n(s),U=i(s,"OL",{start:!0,"data-svelte-h":!0}),o(U)!=="svelte-ztetn2"&&(U.innerHTML=it),Te=n(s),r(us.$$.fragment,s),ge=n(s),I=i(s,"OL",{start:!0,"data-svelte-h":!0}),o(I)!=="svelte-1dn7zpw"&&(I.innerHTML=ot),ye=n(s),Ms=i(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-1dto2my"&&(Ms.innerHTML=ct),we=n(s),r(ds.$$.fragment,s),fe=n(s),ms=i(s,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-hrrqd1"&&(ms.innerHTML=rt),Je=n(s),r(js.$$.fragment,s),Ue=n(s),Ts=i(s,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-cvojof"&&(Ts.innerHTML=ht),Ie=n(s),b=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-7ddsz3"&&(b.innerHTML=ut),be=n(s),gs=i(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-1m82b2h"&&(gs.innerHTML=Mt),ke=n(s),r(ys.$$.fragment,s),$e=n(s),ws=i(s,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-40o9jr"&&(ws.innerHTML=dt),Ce=n(s),k=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(k)!=="svelte-15efue1"&&(k.innerHTML=mt),Be=n(s),fs=i(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-86h2ue"&&(fs.innerHTML=jt),Re=n(s),$=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o($)!=="svelte-1kv7f9v"&&($.innerHTML=Tt),ve=n(s),Js=i(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-10fpzqt"&&(Js.innerHTML=gt),Ze=n(s),C=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-1wbh090"&&(C.innerHTML=yt),Ee=n(s),r(Us.$$.fragment,s),Ve=n(s),Is=i(s,"UL",{"data-svelte-h":!0}),o(Is)!=="svelte-bhfcx6"&&(Is.innerHTML=wt),He=n(s),r(bs.$$.fragment,s),Se=n(s),$s=i(s,"P",{}),ft($s).forEach(t),this.h()},h(){j(T,"name","hf:doc:metadata"),j(T,"content",vt),j(y,"class","flex justify-center"),j(w,"class","flex justify-center"),j(f,"start","2"),j(J,"start","3"),j(U,"start","4"),j(I,"start","5"),j(b,"class","flex justify-center"),j(k,"class","flex justify-center"),j($,"class","flex justify-center"),j(C,"class","flex justify-center")},m(s,e){Ct(document.head,T),l(s,Cs,e),l(s,ks,e),l(s,Bs,e),h(B,s,e),l(s,Rs,e),l(s,R,e),l(s,vs,e),l(s,v,e),l(s,Zs,e),h(Z,s,e),l(s,Es,e),l(s,E,e),l(s,Vs,e),l(s,y,e),l(s,Hs,e),l(s,V,e),l(s,Ss,e),l(s,H,e),l(s,Ls,e),h(S,s,e),l(s,As,e),l(s,L,e),l(s,xs,e),h(A,s,e),l(s,Gs,e),h(x,s,e),l(s,Qs,e),l(s,G,e),l(s,_s,e),h(Q,s,e),l(s,Xs,e),l(s,_,e),l(s,Ws,e),h(X,s,e),l(s,Ns,e),l(s,W,e),l(s,Fs,e),h(N,s,e),l(s,qs,e),h(F,s,e),l(s,Ys,e),l(s,q,e),l(s,zs,e),h(Y,s,e),l(s,Ds,e),l(s,z,e),l(s,Ps,e),l(s,w,e),l(s,Os,e),h(D,s,e),l(s,Ks,e),l(s,P,e),l(s,se,e),h(O,s,e),l(s,ee,e),l(s,K,e),l(s,te,e),h(ss,s,e),l(s,le,e),l(s,es,e),l(s,ae,e),h(ts,s,e),l(s,ne,e),h(ls,s,e),l(s,pe,e),l(s,as,e),l(s,ie,e),h(ns,s,e),l(s,oe,e),l(s,ps,e),l(s,ce,e),l(s,is,e),l(s,re,e),l(s,os,e),l(s,he,e),h(cs,s,e),l(s,ue,e),l(s,f,e),l(s,Me,e),h(rs,s,e),l(s,de,e),l(s,J,e),l(s,me,e),h(hs,s,e),l(s,je,e),l(s,U,e),l(s,Te,e),h(us,s,e),l(s,ge,e),l(s,I,e),l(s,ye,e),l(s,Ms,e),l(s,we,e),h(ds,s,e),l(s,fe,e),l(s,ms,e),l(s,Je,e),h(js,s,e),l(s,Ue,e),l(s,Ts,e),l(s,Ie,e),l(s,b,e),l(s,be,e),l(s,gs,e),l(s,ke,e),h(ys,s,e),l(s,$e,e),l(s,ws,e),l(s,Ce,e),l(s,k,e),l(s,Be,e),l(s,fs,e),l(s,Re,e),l(s,$,e),l(s,ve,e),l(s,Js,e),l(s,Ze,e),l(s,C,e),l(s,Ee,e),h(Us,s,e),l(s,Ve,e),l(s,Is,e),l(s,He,e),h(bs,s,e),l(s,Se,e),l(s,$s,e),Le=!0},p:Ut,i(s){Le||(u(B.$$.fragment,s),u(Z.$$.fragment,s),u(S.$$.fragment,s),u(A.$$.fragment,s),u(x.$$.fragment,s),u(Q.$$.fragment,s),u(X.$$.fragment,s),u(N.$$.fragment,s),u(F.$$.fragment,s),u(Y.$$.fragment,s),u(D.$$.fragment,s),u(O.$$.fragment,s),u(ss.$$.fragment,s),u(ts.$$.fragment,s),u(ls.$$.fragment,s),u(ns.$$.fragment,s),u(cs.$$.fragment,s),u(rs.$$.fragment,s),u(hs.$$.fragment,s),u(us.$$.fragment,s),u(ds.$$.fragment,s),u(js.$$.fragment,s),u(ys.$$.fragment,s),u(Us.$$.fragment,s),u(bs.$$.fragment,s),Le=!0)},o(s){M(B.$$.fragment,s),M(Z.$$.fragment,s),M(S.$$.fragment,s),M(A.$$.fragment,s),M(x.$$.fragment,s),M(Q.$$.fragment,s),M(X.$$.fragment,s),M(N.$$.fragment,s),M(F.$$.fragment,s),M(Y.$$.fragment,s),M(D.$$.fragment,s),M(O.$$.fragment,s),M(ss.$$.fragment,s),M(ts.$$.fragment,s),M(ls.$$.fragment,s),M(ns.$$.fragment,s),M(cs.$$.fragment,s),M(rs.$$.fragment,s),M(hs.$$.fragment,s),M(us.$$.fragment,s),M(ds.$$.fragment,s),M(js.$$.fragment,s),M(ys.$$.fragment,s),M(Us.$$.fragment,s),M(bs.$$.fragment,s),Le=!1},d(s){s&&(t(Cs),t(ks),t(Bs),t(Rs),t(R),t(vs),t(v),t(Zs),t(Es),t(E),t(Vs),t(y),t(Hs),t(V),t(Ss),t(H),t(Ls),t(As),t(L),t(xs),t(Gs),t(Qs),t(G),t(_s),t(Xs),t(_),t(Ws),t(Ns),t(W),t(Fs),t(qs),t(Ys),t(q),t(zs),t(Ds),t(z),t(Ps),t(w),t(Os),t(Ks),t(P),t(se),t(ee),t(K),t(te),t(le),t(es),t(ae),t(ne),t(pe),t(as),t(ie),t(oe),t(ps),t(ce),t(is),t(re),t(os),t(he),t(ue),t(f),t(Me),t(de),t(J),t(me),t(je),t(U),t(Te),t(ge),t(I),t(ye),t(Ms),t(we),t(fe),t(ms),t(Je),t(Ue),t(Ts),t(Ie),t(b),t(be),t(gs),t(ke),t($e),t(ws),t(Ce),t(k),t(Be),t(fs),t(Re),t($),t(ve),t(Js),t(Ze),t(C),t(Ee),t(Ve),t(Is),t(He),t(Se),t($s)),t(T),d(B,s),d(Z,s),d(S,s),d(A,s),d(x,s),d(Q,s),d(X,s),d(N,s),d(F,s),d(Y,s),d(D,s),d(O,s),d(ss,s),d(ts,s),d(ls,s),d(ns,s),d(cs,s),d(rs,s),d(hs,s),d(us,s),d(ds,s),d(js,s),d(ys,s),d(Us,s),d(bs,s)}}}const vt='{"title":"Your First Docker Space: Text Generation with T5","local":"your-first-docker-space-text-generation-with-t5","sections":[{"title":"Create a new Docker Space","local":"create-a-new-docker-space","sections":[],"depth":2},{"title":"Add the dependencies","local":"add-the-dependencies","sections":[],"depth":2},{"title":"Create the app","local":"create-the-app","sections":[],"depth":2},{"title":"Create the Dockerfile","local":"create-the-dockerfile","sections":[{"title":"Testing locally","local":"testing-locally","sections":[],"depth":3}],"depth":2},{"title":"Adding some ML to our app","local":"adding-some-ml-to-our-app","sections":[],"depth":2},{"title":"Debugging","local":"debugging","sections":[],"depth":2},{"title":"Read More","local":"read-more","sections":[],"depth":2}],"depth":1}';function Zt(Ae){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Lt extends bt{constructor(T){super(),kt(this,T,Zt,Rt,Jt,{})}}export{Lt as component};
