import{s as nd,n as rd,o as ud}from"../chunks/scheduler.b108d059.js";import{S as ad,i as pd,g as d,s as o,r as p,A as cd,h as n,f as l,c as s,j as a,u as c,x as r,k as u,y as fd,a as i,v as f,d as h,t as m,w as b}from"../chunks/index.008de539.js";import{H as _,E as hd}from"../chunks/EditOnGithub.d1c48e3d.js";function md(Wo){let T,jt,wt,Et,$,Ot,v,Ut,g,Yo='Utility functions to interact with the Hugging Face Hub (<a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>)',Bt,P,Vo='<li><a href="#module_utils/hub">utils/hub</a><ul><li><em>static</em><ul><li><a href="#module_utils/hub.getFile"><code>.getFile(urlOrPath)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response)&gt;</code></li> <li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options])</code></a> ⇒ <code>Promise</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li></ul></li> <li><a href="#module_utils/hub.getModelJSON"><code>.getModelJSON(modelPath, fileName, [fatal], [options])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+_CONTENT_TYPE_MAP"><code>._CONTENT_TYPE_MAP</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response)</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li> <li><a href="#module_utils/hub..isValidHttpUrl"><code>~isValidHttpUrl(string, [validHosts])</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/hub..handleError"><code>~handleError(status, remoteURL, fatal)</code></a> ⇒ <code>null</code></li> <li><a href="#module_utils/hub..tryCache"><code>~tryCache(cache, ...names)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code></li> <li><a href="#module_utils/hub..readResponse"><code>~readResponse(response, progress_callback)</code></a> ⇒ <code>Promise.&lt;Uint8Array&gt;</code></li> <li><a href="#module_utils/hub..pathJoin"><code>~pathJoin(...parts)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/hub..PretrainedOptions"><code>~PretrainedOptions</code></a> : <code>Object</code></li></ul></li></ul></li>',Kt,qt,Nt,R,kt,y,St,C,Go="Helper function to get a file, using either the Fetch API or FileSystem API.",It,H,Qo='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response)&gt;</code> - A promise that resolves to a FileResponse object (if the file is retrieved using the FileSystem API), or a Response object (if the file is retrieved using the Fetch API).',Jt,M,Xo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>urlOrPath</td><td><code>URL</code> | <code>string</code></td><td><p>The URL/path of the file to get.</p></td></tr></tbody>",zt,Dt,Wt,F,Yt,L,Vt,x,Zo=`Retrieves a file from either a remote URL using the Fetch API or from the local file system using the FileSystem API.
If the filesystem is available and <code>env.useCache = true</code>, the file will be downloaded and cached.`,Gt,w,es='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise</code> - A Promise that resolves with the file content as a buffer.<br/> <strong>Throws</strong>:',Qt,A,ts="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",Xt,j,ls="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>path_or_repo_id</td><td><code>string</code></td><td></td><td><p>This can be either:</p> <ul><li>a string, the <em>model id</em> of a model repo on huggingface.co.</li> <li>a path to a <em>directory</em> potentially containing the file.</li></ul></td> </tr><tr><td>filename</td><td><code>string</code></td><td></td><td><p>The name of the file to locate in <code>path_or_repo</code>.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",Zt,E,is='<li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options])</code></a> ⇒ <code>Promise</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li></ul></li>',el,tl,ll,O,il,U,ol,B,os='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',sl,dl,nl,K,rl,q,ul,N,ss='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',al,pl,cl,k,fl,S,hl,I,ds='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',ml,bl,_l,J,Tl,z,$l,D,ns="Fetches a JSON file from a given path and file name.",vl,W,rs='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - The JSON data parsed into a JavaScript object.<br/> <strong>Throws</strong>:',gl,Y,us="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",Pl,V,as="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>modelPath</td><td><code>string</code></td><td></td><td><p>The path to the directory containing the file.</p></td> </tr><tr><td>fileName</td><td><code>string</code></td><td></td><td><p>The name of the file to fetch.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",Rl,yl,Cl,G,Hl,Q,Ml,X,ps='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',Fl,Z,cs='<li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+_CONTENT_TYPE_MAP"><code>._CONTENT_TYPE_MAP</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',Ll,xl,wl,ee,Al,te,jl,le,fs="Creates a new <code>FileResponse</code> object.",El,ie,hs="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>filePath</td><td><code>string</code> | <code>URL</code></td></tr></tbody>",Ol,Ul,Bl,oe,Kl,se,ql,de,ms="Mapping from file extensions to MIME types.",Nl,ne,bs='<strong>Kind</strong>: instance property of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a>',kl,Sl,Il,re,Jl,ue,zl,ae,_s=`Updates the ‘content-type’ header property of the response based on the extension of
the file specified by the filePath property of the current object.`,Dl,pe,Ts='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a>',Wl,Yl,Vl,ce,Gl,fe,Ql,he,$s="Clone the current FileResponse object.",Xl,me,vs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>FileResponse</code> - A new FileResponse object with the same properties as the current object.',Zl,ei,ti,be,li,_e,ii,Te,gs=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with an ArrayBuffer containing the file’s contents.`,oi,$e,Ps='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ArrayBuffer&gt;</code> - A Promise that resolves with an ArrayBuffer containing the file’s contents.<br/> <strong>Throws</strong>:',si,ve,Rs="<li><code>Error</code> If the file cannot be read.</li>",di,ni,ri,ge,ui,Pe,ai,Re,ys=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a Blob containing the file’s contents.`,pi,ye,Cs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Blob&gt;</code> - A Promise that resolves with a Blob containing the file’s contents.<br/> <strong>Throws</strong>:',ci,Ce,Hs="<li><code>Error</code> If the file cannot be read.</li>",fi,hi,mi,He,bi,Me,_i,Fe,Ms=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a string containing the file’s contents.`,Ti,Le,Fs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;string&gt;</code> - A Promise that resolves with a string containing the file’s contents.<br/> <strong>Throws</strong>:',$i,xe,Ls="<li><code>Error</code> If the file cannot be read.</li>",vi,gi,Pi,we,Ri,Ae,yi,je,xs=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a parsed JavaScript object containing the file’s contents.`,Ci,Ee,ws='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - A Promise that resolves with a parsed JavaScript object containing the file’s contents.<br/> <strong>Throws</strong>:',Hi,Oe,As="<li><code>Error</code> If the file cannot be read.</li>",Mi,Fi,Li,Ue,xi,Be,wi,Ke,js='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',Ai,qe,Es='<li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response)</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li>',ji,Ei,Oi,Ne,Ui,ke,Bi,Se,Os="Instantiate a <code>FileCache</code> object.",Ki,Ie,Us="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td></tr></tbody>",qi,Ni,ki,Je,Si,ze,Ii,De,Bs="Checks whether the given request is in the cache.",Ji,We,Ks='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',zi,Ye,qs="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td></tr></tbody>",Di,Wi,Yi,Ve,Vi,Ge,Gi,Qe,Ns="Adds the given response to the cache.",Qi,Xe,ks='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',Xi,Ze,Ss="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td> </tr><tr><td>response</td><td><code>Response</code> | <code>FileResponse</code></td></tr></tbody>",Zi,eo,to,et,lo,tt,io,lt,Is="Determines whether the given string is a valid HTTP or HTTPS URL.",oo,it,Js='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - True if the string is a valid HTTP or HTTPS URL, false otherwise.',so,ot,zs="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>string</td><td><code>string</code> | <code>URL</code></td><td></td><td><p>The string to test for validity as an HTTP or HTTPS URL.</p></td> </tr><tr><td>[validHosts]</td><td><code>Array.&lt;string&gt;</code></td><td><code></code></td><td><p>A list of valid hostnames. If specified, the URL&#39;s hostname must be in this list.</p></td></tr></tbody>",no,ro,uo,st,ao,dt,po,nt,Ds="Helper method to handle fatal errors that occur while trying to load a file from the Hugging Face Hub.",co,rt,Ws='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>null</code> - Returns <code>null</code> if <code>fatal = true</code>.<br/> <strong>Throws</strong>:',fo,ut,Ys="<li><code>Error</code> If `fatal = false`.</li>",ho,at,Vs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>status</td><td><code>number</code></td><td><p>The HTTP status code of the error.</p></td> </tr><tr><td>remoteURL</td><td><code>string</code></td><td><p>The URL of the file that could not be loaded.</p></td> </tr><tr><td>fatal</td><td><code>boolean</code></td><td><p>Whether to raise an error if the file could not be loaded.</p></td></tr></tbody>",mo,bo,_o,pt,To,ct,$o,ft,Gs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code> - The item from the cache, or undefined if not found.',vo,ht,Qs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>cache</td><td><code>FileCache</code> | <code>Cache</code></td><td><p>The cache to search</p></td> </tr><tr><td>...names</td><td><code>Array.&lt;string&gt;</code></td><td><p>The names of the item to search for</p></td></tr></tbody>",go,Po,Ro,mt,yo,bt,Co,_t,Xs="Read and track progress when reading a Response object",Ho,Tt,Zs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Uint8Array&gt;</code> - A Promise that resolves with the Uint8Array buffer',Mo,$t,ed="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>response</td><td><code>any</code></td><td><p>The Response object to read</p></td> </tr><tr><td>progress_callback</td><td><code>function</code></td><td><p>The function to call with progress updates</p></td></tr></tbody>",Fo,Lo,xo,vt,wo,gt,Ao,Pt,td="Joins multiple parts of a path into a single path, while handling leading and trailing slashes.",jo,Rt,ld='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>string</code> - A string representing the joined path.',Eo,yt,id="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...parts</td><td><code>string</code></td><td><p>Multiple parts of a path.</p></td></tr></tbody>",Oo,Uo,Bo,Ct,Ko,Ht,qo,Mt,od="Options for loading a pretrained model.",No,Ft,sd='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Properties</strong>',ko,Lt,dd=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[quantized]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to load the 8-bit quantized version of the model (only applicable when loading model files).</p></td> </tr><tr><td>[progress_callback]</td><td><code>function</code></td><td><code></code></td><td><p>If specified, this function will be called during model construction, to provide the user with progress updates.</p></td> </tr><tr><td>[config]</td><td><code>Object</code></td><td><code></code></td><td><p>Configuration for the model to use instead of an automatically loaded configuration. Configuration can be automatically loaded when:</p> <ul><li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained model).</li> <li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a configuration JSON file named <em>config.json</em> is found in the directory.</li></ul></td> </tr><tr><td>[cache_dir]</td><td><code>string</code></td><td><code>null</code></td><td><p>Path to a directory in which a downloaded pretrained model configuration should be cached if the standard cache should not be used.</p></td> </tr><tr><td>[local_files_only]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to only look at local files (e.g., not try downloading the model).</p></td> </tr><tr><td>[revision]</td><td><code>string</code></td><td><code>&quot;&#39;main&#39;&quot;</code></td><td><p>The specific model version to use. It can be a branch name, a tag name, or a commit id,
since we use a git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier allowed by git.
NOTE: This setting is ignored for local requests.</p></td> </tr><tr><td>[model_file_name]</td><td><code>string</code></td><td><code>null</code></td><td><p>If specified, load the model with this name (excluding the .onnx suffix). Currently only valid for encoder- or decoder-only models.</p></td></tr></tbody>`,So,Io,Jo,xt,zo,At,Do;return v=new _({props:{title:"utils/hub",local:"utilshub",headingTag:"h1"}}),y=new _({props:{title:"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>",local:"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code",headingTag:"h2"}}),L=new _({props:{title:"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options]) ⇒ <code> Promise </code>",local:"utilshubgetmodelfilepathorrepoid-filename-fatal-options--code-promise-code",headingTag:"h2"}}),U=new _({props:{title:"getModelFile~cacheKey : <code> string </code>",local:"getmodelfilecachekey--code-string-code",headingTag:"h3"}}),q=new _({props:{title:"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>",local:"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code",headingTag:"h3"}}),S=new _({props:{title:"getModelFile~buffer : <code> Uint8Array </code>",local:"getmodelfilebuffer--code-uint8array-code",headingTag:"h3"}}),z=new _({props:{title:"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>",local:"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code",headingTag:"h2"}}),Q=new _({props:{title:"utils/hub~FileResponse",local:"utilshubfileresponse",headingTag:"h2"}}),te=new _({props:{title:"new FileResponse(filePath)",local:"new-fileresponsefilepath",headingTag:"h3"}}),se=new _({props:{title:"fileResponse._CONTENT_TYPE_MAP",local:"fileresponsecontenttypemap",headingTag:"h3"}}),ue=new _({props:{title:"fileResponse.updateContentType() ⇒ <code> void </code>",local:"fileresponseupdatecontenttype--code-void-code",headingTag:"h3"}}),fe=new _({props:{title:"fileResponse.clone() ⇒ <code> FileResponse </code>",local:"fileresponseclone--code-fileresponse-code",headingTag:"h3"}}),_e=new _({props:{title:"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>",local:"fileresponsearraybuffer--code-promise--arraybuffer--code",headingTag:"h3"}}),Pe=new _({props:{title:"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>",local:"fileresponseblob--code-promise--blob--code",headingTag:"h3"}}),Me=new _({props:{title:"fileResponse.text() ⇒ <code> Promise. < string > </code>",local:"fileresponsetext--code-promise--string--code",headingTag:"h3"}}),Ae=new _({props:{title:"fileResponse.json() ⇒ <code> Promise. < Object > </code>",local:"fileresponsejson--code-promise--object--code",headingTag:"h3"}}),Be=new _({props:{title:"utils/hub~FileCache",local:"utilshubfilecache",headingTag:"h2"}}),ke=new _({props:{title:"new FileCache(path)",local:"new-filecachepath",headingTag:"h3"}}),ze=new _({props:{title:"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>",local:"filecachematchrequest--code-promise--fileresponseundefined--code",headingTag:"h3"}}),Ge=new _({props:{title:"fileCache.put(request, response) ⇒ <code> Promise. < void > </code>",local:"filecacheputrequest-response--code-promise--void--code",headingTag:"h3"}}),tt=new _({props:{title:"utils/hub~isValidHttpUrl(string, [validHosts]) ⇒ <code> boolean </code>",local:"utilshubisvalidhttpurlstring-validhosts--code-boolean-code",headingTag:"h2"}}),dt=new _({props:{title:"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>",local:"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code",headingTag:"h2"}}),ct=new _({props:{title:"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>",local:"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code",headingTag:"h2"}}),bt=new _({props:{title:"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>",local:"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code",headingTag:"h2"}}),gt=new _({props:{title:"utils/hub~pathJoin(...parts) ⇒ <code> string </code>",local:"utilshubpathjoinparts--code-string-code",headingTag:"h2"}}),Ht=new _({props:{title:"utils/hub~PretrainedOptions : <code> Object </code>",local:"utilshubpretrainedoptions--code-object-code",headingTag:"h2"}}),xt=new hd({props:{source:"https://github.com/xenova/transformers.js/blob/main/docs/source/api/utils/hub.md"}}),{c(){T=d("meta"),jt=o(),wt=d("p"),Et=o(),$=d("a"),Ot=o(),p(v.$$.fragment),Ut=o(),g=d("p"),g.innerHTML=Yo,Bt=o(),P=d("ul"),P.innerHTML=Vo,Kt=o(),qt=d("hr"),Nt=o(),R=d("a"),kt=o(),p(y.$$.fragment),St=o(),C=d("p"),C.textContent=Go,It=o(),H=d("p"),H.innerHTML=Qo,Jt=o(),M=d("table"),M.innerHTML=Xo,zt=o(),Dt=d("hr"),Wt=o(),F=d("a"),Yt=o(),p(L.$$.fragment),Vt=o(),x=d("p"),x.innerHTML=Zo,Gt=o(),w=d("p"),w.innerHTML=es,Qt=o(),A=d("ul"),A.innerHTML=ts,Xt=o(),j=d("table"),j.innerHTML=ls,Zt=o(),E=d("ul"),E.innerHTML=is,el=o(),tl=d("hr"),ll=o(),O=d("a"),il=o(),p(U.$$.fragment),ol=o(),B=d("p"),B.innerHTML=os,sl=o(),dl=d("hr"),nl=o(),K=d("a"),rl=o(),p(q.$$.fragment),ul=o(),N=d("p"),N.innerHTML=ss,al=o(),pl=d("hr"),cl=o(),k=d("a"),fl=o(),p(S.$$.fragment),hl=o(),I=d("p"),I.innerHTML=ds,ml=o(),bl=d("hr"),_l=o(),J=d("a"),Tl=o(),p(z.$$.fragment),$l=o(),D=d("p"),D.textContent=ns,vl=o(),W=d("p"),W.innerHTML=rs,gl=o(),Y=d("ul"),Y.innerHTML=us,Pl=o(),V=d("table"),V.innerHTML=as,Rl=o(),yl=d("hr"),Cl=o(),G=d("a"),Hl=o(),p(Q.$$.fragment),Ml=o(),X=d("p"),X.innerHTML=ps,Fl=o(),Z=d("ul"),Z.innerHTML=cs,Ll=o(),xl=d("hr"),wl=o(),ee=d("a"),Al=o(),p(te.$$.fragment),jl=o(),le=d("p"),le.innerHTML=fs,El=o(),ie=d("table"),ie.innerHTML=hs,Ol=o(),Ul=d("hr"),Bl=o(),oe=d("a"),Kl=o(),p(se.$$.fragment),ql=o(),de=d("p"),de.textContent=ms,Nl=o(),ne=d("p"),ne.innerHTML=bs,kl=o(),Sl=d("hr"),Il=o(),re=d("a"),Jl=o(),p(ue.$$.fragment),zl=o(),ae=d("p"),ae.textContent=_s,Dl=o(),pe=d("p"),pe.innerHTML=Ts,Wl=o(),Yl=d("hr"),Vl=o(),ce=d("a"),Gl=o(),p(fe.$$.fragment),Ql=o(),he=d("p"),he.textContent=$s,Xl=o(),me=d("p"),me.innerHTML=vs,Zl=o(),ei=d("hr"),ti=o(),be=d("a"),li=o(),p(_e.$$.fragment),ii=o(),Te=d("p"),Te.textContent=gs,oi=o(),$e=d("p"),$e.innerHTML=Ps,si=o(),ve=d("ul"),ve.innerHTML=Rs,di=o(),ni=d("hr"),ri=o(),ge=d("a"),ui=o(),p(Pe.$$.fragment),ai=o(),Re=d("p"),Re.textContent=ys,pi=o(),ye=d("p"),ye.innerHTML=Cs,ci=o(),Ce=d("ul"),Ce.innerHTML=Hs,fi=o(),hi=d("hr"),mi=o(),He=d("a"),bi=o(),p(Me.$$.fragment),_i=o(),Fe=d("p"),Fe.textContent=Ms,Ti=o(),Le=d("p"),Le.innerHTML=Fs,$i=o(),xe=d("ul"),xe.innerHTML=Ls,vi=o(),gi=d("hr"),Pi=o(),we=d("a"),Ri=o(),p(Ae.$$.fragment),yi=o(),je=d("p"),je.textContent=xs,Ci=o(),Ee=d("p"),Ee.innerHTML=ws,Hi=o(),Oe=d("ul"),Oe.innerHTML=As,Mi=o(),Fi=d("hr"),Li=o(),Ue=d("a"),xi=o(),p(Be.$$.fragment),wi=o(),Ke=d("p"),Ke.innerHTML=js,Ai=o(),qe=d("ul"),qe.innerHTML=Es,ji=o(),Ei=d("hr"),Oi=o(),Ne=d("a"),Ui=o(),p(ke.$$.fragment),Bi=o(),Se=d("p"),Se.innerHTML=Os,Ki=o(),Ie=d("table"),Ie.innerHTML=Us,qi=o(),Ni=d("hr"),ki=o(),Je=d("a"),Si=o(),p(ze.$$.fragment),Ii=o(),De=d("p"),De.textContent=Bs,Ji=o(),We=d("p"),We.innerHTML=Ks,zi=o(),Ye=d("table"),Ye.innerHTML=qs,Di=o(),Wi=d("hr"),Yi=o(),Ve=d("a"),Vi=o(),p(Ge.$$.fragment),Gi=o(),Qe=d("p"),Qe.textContent=Ns,Qi=o(),Xe=d("p"),Xe.innerHTML=ks,Xi=o(),Ze=d("table"),Ze.innerHTML=Ss,Zi=o(),eo=d("hr"),to=o(),et=d("a"),lo=o(),p(tt.$$.fragment),io=o(),lt=d("p"),lt.textContent=Is,oo=o(),it=d("p"),it.innerHTML=Js,so=o(),ot=d("table"),ot.innerHTML=zs,no=o(),ro=d("hr"),uo=o(),st=d("a"),ao=o(),p(dt.$$.fragment),po=o(),nt=d("p"),nt.textContent=Ds,co=o(),rt=d("p"),rt.innerHTML=Ws,fo=o(),ut=d("ul"),ut.innerHTML=Ys,ho=o(),at=d("table"),at.innerHTML=Vs,mo=o(),bo=d("hr"),_o=o(),pt=d("a"),To=o(),p(ct.$$.fragment),$o=o(),ft=d("p"),ft.innerHTML=Gs,vo=o(),ht=d("table"),ht.innerHTML=Qs,go=o(),Po=d("hr"),Ro=o(),mt=d("a"),yo=o(),p(bt.$$.fragment),Co=o(),_t=d("p"),_t.textContent=Xs,Ho=o(),Tt=d("p"),Tt.innerHTML=Zs,Mo=o(),$t=d("table"),$t.innerHTML=ed,Fo=o(),Lo=d("hr"),xo=o(),vt=d("a"),wo=o(),p(gt.$$.fragment),Ao=o(),Pt=d("p"),Pt.textContent=td,jo=o(),Rt=d("p"),Rt.innerHTML=ld,Eo=o(),yt=d("table"),yt.innerHTML=id,Oo=o(),Uo=d("hr"),Bo=o(),Ct=d("a"),Ko=o(),p(Ht.$$.fragment),qo=o(),Mt=d("p"),Mt.textContent=od,No=o(),Ft=d("p"),Ft.innerHTML=sd,ko=o(),Lt=d("table"),Lt.innerHTML=dd,So=o(),Io=d("hr"),Jo=o(),p(xt.$$.fragment),zo=o(),At=d("p"),this.h()},l(e){const t=cd("svelte-u9bgzb",document.head);T=n(t,"META",{name:!0,content:!0}),t.forEach(l),jt=s(e),wt=n(e,"P",{}),a(wt).forEach(l),Et=s(e),$=n(e,"A",{id:!0,class:!0}),a($).forEach(l),Ot=s(e),c(v.$$.fragment,e),Ut=s(e),g=n(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1jxl61c"&&(g.innerHTML=Yo),Bt=s(e),P=n(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-10lc5q7"&&(P.innerHTML=Vo),Kt=s(e),qt=n(e,"HR",{}),Nt=s(e),R=n(e,"A",{id:!0,class:!0}),a(R).forEach(l),kt=s(e),c(y.$$.fragment,e),St=s(e),C=n(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-10mshiw"&&(C.textContent=Go),It=s(e),H=n(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1jj7eze"&&(H.innerHTML=Qo),Jt=s(e),M=n(e,"TABLE",{"data-svelte-h":!0}),r(M)!=="svelte-pbwhgs"&&(M.innerHTML=Xo),zt=s(e),Dt=n(e,"HR",{}),Wt=s(e),F=n(e,"A",{id:!0,class:!0}),a(F).forEach(l),Yt=s(e),c(L.$$.fragment,e),Vt=s(e),x=n(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1l3bjq3"&&(x.innerHTML=Zo),Gt=s(e),w=n(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1rwfklh"&&(w.innerHTML=es),Qt=s(e),A=n(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-jl6z4b"&&(A.innerHTML=ts),Xt=s(e),j=n(e,"TABLE",{"data-svelte-h":!0}),r(j)!=="svelte-1o6u9nv"&&(j.innerHTML=ls),Zt=s(e),E=n(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-xatn75"&&(E.innerHTML=is),el=s(e),tl=n(e,"HR",{}),ll=s(e),O=n(e,"A",{id:!0,class:!0}),a(O).forEach(l),il=s(e),c(U.$$.fragment,e),ol=s(e),B=n(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ys3w38"&&(B.innerHTML=os),sl=s(e),dl=n(e,"HR",{}),nl=s(e),K=n(e,"A",{id:!0,class:!0}),a(K).forEach(l),rl=s(e),c(q.$$.fragment,e),ul=s(e),N=n(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1ys3w38"&&(N.innerHTML=ss),al=s(e),pl=n(e,"HR",{}),cl=s(e),k=n(e,"A",{id:!0,class:!0}),a(k).forEach(l),fl=s(e),c(S.$$.fragment,e),hl=s(e),I=n(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1ys3w38"&&(I.innerHTML=ds),ml=s(e),bl=n(e,"HR",{}),_l=s(e),J=n(e,"A",{id:!0,class:!0}),a(J).forEach(l),Tl=s(e),c(z.$$.fragment,e),$l=s(e),D=n(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1en2wh4"&&(D.textContent=ns),vl=s(e),W=n(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1l5qo0i"&&(W.innerHTML=rs),gl=s(e),Y=n(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-jl6z4b"&&(Y.innerHTML=us),Pl=s(e),V=n(e,"TABLE",{"data-svelte-h":!0}),r(V)!=="svelte-1iel3tk"&&(V.innerHTML=as),Rl=s(e),yl=n(e,"HR",{}),Cl=s(e),G=n(e,"A",{id:!0,class:!0}),a(G).forEach(l),Hl=s(e),c(Q.$$.fragment,e),Ml=s(e),X=n(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-16uuos4"&&(X.innerHTML=ps),Fl=s(e),Z=n(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-165ijwb"&&(Z.innerHTML=cs),Ll=s(e),xl=n(e,"HR",{}),wl=s(e),ee=n(e,"A",{id:!0,class:!0}),a(ee).forEach(l),Al=s(e),c(te.$$.fragment,e),jl=s(e),le=n(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-zzl0lp"&&(le.innerHTML=fs),El=s(e),ie=n(e,"TABLE",{"data-svelte-h":!0}),r(ie)!=="svelte-1y2k5ta"&&(ie.innerHTML=hs),Ol=s(e),Ul=n(e,"HR",{}),Bl=s(e),oe=n(e,"A",{id:!0,class:!0}),a(oe).forEach(l),Kl=s(e),c(se.$$.fragment,e),ql=s(e),de=n(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-15u13r6"&&(de.textContent=ms),Nl=s(e),ne=n(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-g2qxul"&&(ne.innerHTML=bs),kl=s(e),Sl=n(e,"HR",{}),Il=s(e),re=n(e,"A",{id:!0,class:!0}),a(re).forEach(l),Jl=s(e),c(ue.$$.fragment,e),zl=s(e),ae=n(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1u1tjx3"&&(ae.textContent=_s),Dl=s(e),pe=n(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1sowe6d"&&(pe.innerHTML=Ts),Wl=s(e),Yl=n(e,"HR",{}),Vl=s(e),ce=n(e,"A",{id:!0,class:!0}),a(ce).forEach(l),Gl=s(e),c(fe.$$.fragment,e),Ql=s(e),he=n(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-d8j2xp"&&(he.textContent=$s),Xl=s(e),me=n(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-8jlahc"&&(me.innerHTML=vs),Zl=s(e),ei=n(e,"HR",{}),ti=s(e),be=n(e,"A",{id:!0,class:!0}),a(be).forEach(l),li=s(e),c(_e.$$.fragment,e),ii=s(e),Te=n(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1a8fecx"&&(Te.textContent=gs),oi=s(e),$e=n(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-v2f2ae"&&($e.innerHTML=Ps),si=s(e),ve=n(e,"UL",{"data-svelte-h":!0}),r(ve)!=="svelte-1f4f3jw"&&(ve.innerHTML=Rs),di=s(e),ni=n(e,"HR",{}),ri=s(e),ge=n(e,"A",{id:!0,class:!0}),a(ge).forEach(l),ui=s(e),c(Pe.$$.fragment,e),ai=s(e),Re=n(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-h3zv97"&&(Re.textContent=ys),pi=s(e),ye=n(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1e723py"&&(ye.innerHTML=Cs),ci=s(e),Ce=n(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-1f4f3jw"&&(Ce.innerHTML=Hs),fi=s(e),hi=n(e,"HR",{}),mi=s(e),He=n(e,"A",{id:!0,class:!0}),a(He).forEach(l),bi=s(e),c(Me.$$.fragment,e),_i=s(e),Fe=n(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-jd4zuh"&&(Fe.textContent=Ms),Ti=s(e),Le=n(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1ozy582"&&(Le.innerHTML=Fs),$i=s(e),xe=n(e,"UL",{"data-svelte-h":!0}),r(xe)!=="svelte-1f4f3jw"&&(xe.innerHTML=Ls),vi=s(e),gi=n(e,"HR",{}),Pi=s(e),we=n(e,"A",{id:!0,class:!0}),a(we).forEach(l),Ri=s(e),c(Ae.$$.fragment,e),yi=s(e),je=n(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-cd4397"&&(je.textContent=xs),Ci=s(e),Ee=n(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-j83voe"&&(Ee.innerHTML=ws),Hi=s(e),Oe=n(e,"UL",{"data-svelte-h":!0}),r(Oe)!=="svelte-1f4f3jw"&&(Oe.innerHTML=As),Mi=s(e),Fi=n(e,"HR",{}),Li=s(e),Ue=n(e,"A",{id:!0,class:!0}),a(Ue).forEach(l),xi=s(e),c(Be.$$.fragment,e),wi=s(e),Ke=n(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-16uuos4"&&(Ke.innerHTML=js),Ai=s(e),qe=n(e,"UL",{"data-svelte-h":!0}),r(qe)!=="svelte-136j1yr"&&(qe.innerHTML=Es),ji=s(e),Ei=n(e,"HR",{}),Oi=s(e),Ne=n(e,"A",{id:!0,class:!0}),a(Ne).forEach(l),Ui=s(e),c(ke.$$.fragment,e),Bi=s(e),Se=n(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-pake4r"&&(Se.innerHTML=Os),Ki=s(e),Ie=n(e,"TABLE",{"data-svelte-h":!0}),r(Ie)!=="svelte-f03x1m"&&(Ie.innerHTML=Us),qi=s(e),Ni=n(e,"HR",{}),ki=s(e),Je=n(e,"A",{id:!0,class:!0}),a(Je).forEach(l),Si=s(e),c(ze.$$.fragment,e),Ii=s(e),De=n(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-13oc2rp"&&(De.textContent=Bs),Ji=s(e),We=n(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1wxlxpn"&&(We.innerHTML=Ks),zi=s(e),Ye=n(e,"TABLE",{"data-svelte-h":!0}),r(Ye)!=="svelte-2kmk06"&&(Ye.innerHTML=qs),Di=s(e),Wi=n(e,"HR",{}),Yi=s(e),Ve=n(e,"A",{id:!0,class:!0}),a(Ve).forEach(l),Vi=s(e),c(Ge.$$.fragment,e),Gi=s(e),Qe=n(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-bwoz3v"&&(Qe.textContent=Ns),Qi=s(e),Xe=n(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1wxlxpn"&&(Xe.innerHTML=ks),Xi=s(e),Ze=n(e,"TABLE",{"data-svelte-h":!0}),r(Ze)!=="svelte-yj5tj6"&&(Ze.innerHTML=Ss),Zi=s(e),eo=n(e,"HR",{}),to=s(e),et=n(e,"A",{id:!0,class:!0}),a(et).forEach(l),lo=s(e),c(tt.$$.fragment,e),io=s(e),lt=n(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-19yu0hw"&&(lt.textContent=Is),oo=s(e),it=n(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1ifo88t"&&(it.innerHTML=Js),so=s(e),ot=n(e,"TABLE",{"data-svelte-h":!0}),r(ot)!=="svelte-msmjch"&&(ot.innerHTML=zs),no=s(e),ro=n(e,"HR",{}),uo=s(e),st=n(e,"A",{id:!0,class:!0}),a(st).forEach(l),ao=s(e),c(dt.$$.fragment,e),po=s(e),nt=n(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-112gzs0"&&(nt.textContent=Ds),co=s(e),rt=n(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-9i72aw"&&(rt.innerHTML=Ws),fo=s(e),ut=n(e,"UL",{"data-svelte-h":!0}),r(ut)!=="svelte-w7pu3"&&(ut.innerHTML=Ys),ho=s(e),at=n(e,"TABLE",{"data-svelte-h":!0}),r(at)!=="svelte-bpbhxc"&&(at.innerHTML=Vs),mo=s(e),bo=n(e,"HR",{}),_o=s(e),pt=n(e,"A",{id:!0,class:!0}),a(pt).forEach(l),To=s(e),c(ct.$$.fragment,e),$o=s(e),ft=n(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1h1o1yf"&&(ft.innerHTML=Gs),vo=s(e),ht=n(e,"TABLE",{"data-svelte-h":!0}),r(ht)!=="svelte-17sk6uf"&&(ht.innerHTML=Qs),go=s(e),Po=n(e,"HR",{}),Ro=s(e),mt=n(e,"A",{id:!0,class:!0}),a(mt).forEach(l),yo=s(e),c(bt.$$.fragment,e),Co=s(e),_t=n(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-1tqccie"&&(_t.textContent=Xs),Ho=s(e),Tt=n(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-dyyw29"&&(Tt.innerHTML=Zs),Mo=s(e),$t=n(e,"TABLE",{"data-svelte-h":!0}),r($t)!=="svelte-13fau3m"&&($t.innerHTML=ed),Fo=s(e),Lo=n(e,"HR",{}),xo=s(e),vt=n(e,"A",{id:!0,class:!0}),a(vt).forEach(l),wo=s(e),c(gt.$$.fragment,e),Ao=s(e),Pt=n(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-7vbcne"&&(Pt.textContent=td),jo=s(e),Rt=n(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-wjfx67"&&(Rt.innerHTML=ld),Eo=s(e),yt=n(e,"TABLE",{"data-svelte-h":!0}),r(yt)!=="svelte-61qi9d"&&(yt.innerHTML=id),Oo=s(e),Uo=n(e,"HR",{}),Bo=s(e),Ct=n(e,"A",{id:!0,class:!0}),a(Ct).forEach(l),Ko=s(e),c(Ht.$$.fragment,e),qo=s(e),Mt=n(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1oi15lr"&&(Mt.textContent=od),No=s(e),Ft=n(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-121rdz"&&(Ft.innerHTML=sd),ko=s(e),Lt=n(e,"TABLE",{"data-svelte-h":!0}),r(Lt)!=="svelte-1kbnzqd"&&(Lt.innerHTML=dd),So=s(e),Io=n(e,"HR",{}),Jo=s(e),c(xt.$$.fragment,e),zo=s(e),At=n(e,"P",{}),a(At).forEach(l),this.h()},h(){u(T,"name","hf:doc:metadata"),u(T,"content",bd),u($,"id","module_utils/hub"),u($,"class","group"),u(R,"id","module_utils/hub.getFile"),u(R,"class","group"),u(F,"id","module_utils/hub.getModelFile"),u(F,"class","group"),u(O,"id","module_utils/hub.getModelFile..cacheKey"),u(O,"class","group"),u(K,"id","module_utils/hub.getModelFile..response"),u(K,"class","group"),u(k,"id","module_utils/hub.getModelFile..buffer"),u(k,"class","group"),u(J,"id","module_utils/hub.getModelJSON"),u(J,"class","group"),u(G,"id","module_utils/hub..FileResponse"),u(G,"class","group"),u(ee,"id","new_module_utils/hub..FileResponse_new"),u(ee,"class","group"),u(oe,"id","module_utils/hub..FileResponse+_CONTENT_TYPE_MAP"),u(oe,"class","group"),u(re,"id","module_utils/hub..FileResponse+updateContentType"),u(re,"class","group"),u(ce,"id","module_utils/hub..FileResponse+clone"),u(ce,"class","group"),u(be,"id","module_utils/hub..FileResponse+arrayBuffer"),u(be,"class","group"),u(ge,"id","module_utils/hub..FileResponse+blob"),u(ge,"class","group"),u(He,"id","module_utils/hub..FileResponse+text"),u(He,"class","group"),u(we,"id","module_utils/hub..FileResponse+json"),u(we,"class","group"),u(Ue,"id","module_utils/hub..FileCache"),u(Ue,"class","group"),u(Ne,"id","new_module_utils/hub..FileCache_new"),u(Ne,"class","group"),u(Je,"id","module_utils/hub..FileCache+match"),u(Je,"class","group"),u(Ve,"id","module_utils/hub..FileCache+put"),u(Ve,"class","group"),u(et,"id","module_utils/hub..isValidHttpUrl"),u(et,"class","group"),u(st,"id","module_utils/hub..handleError"),u(st,"class","group"),u(pt,"id","module_utils/hub..tryCache"),u(pt,"class","group"),u(mt,"id","module_utils/hub..readResponse"),u(mt,"class","group"),u(vt,"id","module_utils/hub..pathJoin"),u(vt,"class","group"),u(Ct,"id","module_utils/hub..PretrainedOptions"),u(Ct,"class","group")},m(e,t){fd(document.head,T),i(e,jt,t),i(e,wt,t),i(e,Et,t),i(e,$,t),i(e,Ot,t),f(v,e,t),i(e,Ut,t),i(e,g,t),i(e,Bt,t),i(e,P,t),i(e,Kt,t),i(e,qt,t),i(e,Nt,t),i(e,R,t),i(e,kt,t),f(y,e,t),i(e,St,t),i(e,C,t),i(e,It,t),i(e,H,t),i(e,Jt,t),i(e,M,t),i(e,zt,t),i(e,Dt,t),i(e,Wt,t),i(e,F,t),i(e,Yt,t),f(L,e,t),i(e,Vt,t),i(e,x,t),i(e,Gt,t),i(e,w,t),i(e,Qt,t),i(e,A,t),i(e,Xt,t),i(e,j,t),i(e,Zt,t),i(e,E,t),i(e,el,t),i(e,tl,t),i(e,ll,t),i(e,O,t),i(e,il,t),f(U,e,t),i(e,ol,t),i(e,B,t),i(e,sl,t),i(e,dl,t),i(e,nl,t),i(e,K,t),i(e,rl,t),f(q,e,t),i(e,ul,t),i(e,N,t),i(e,al,t),i(e,pl,t),i(e,cl,t),i(e,k,t),i(e,fl,t),f(S,e,t),i(e,hl,t),i(e,I,t),i(e,ml,t),i(e,bl,t),i(e,_l,t),i(e,J,t),i(e,Tl,t),f(z,e,t),i(e,$l,t),i(e,D,t),i(e,vl,t),i(e,W,t),i(e,gl,t),i(e,Y,t),i(e,Pl,t),i(e,V,t),i(e,Rl,t),i(e,yl,t),i(e,Cl,t),i(e,G,t),i(e,Hl,t),f(Q,e,t),i(e,Ml,t),i(e,X,t),i(e,Fl,t),i(e,Z,t),i(e,Ll,t),i(e,xl,t),i(e,wl,t),i(e,ee,t),i(e,Al,t),f(te,e,t),i(e,jl,t),i(e,le,t),i(e,El,t),i(e,ie,t),i(e,Ol,t),i(e,Ul,t),i(e,Bl,t),i(e,oe,t),i(e,Kl,t),f(se,e,t),i(e,ql,t),i(e,de,t),i(e,Nl,t),i(e,ne,t),i(e,kl,t),i(e,Sl,t),i(e,Il,t),i(e,re,t),i(e,Jl,t),f(ue,e,t),i(e,zl,t),i(e,ae,t),i(e,Dl,t),i(e,pe,t),i(e,Wl,t),i(e,Yl,t),i(e,Vl,t),i(e,ce,t),i(e,Gl,t),f(fe,e,t),i(e,Ql,t),i(e,he,t),i(e,Xl,t),i(e,me,t),i(e,Zl,t),i(e,ei,t),i(e,ti,t),i(e,be,t),i(e,li,t),f(_e,e,t),i(e,ii,t),i(e,Te,t),i(e,oi,t),i(e,$e,t),i(e,si,t),i(e,ve,t),i(e,di,t),i(e,ni,t),i(e,ri,t),i(e,ge,t),i(e,ui,t),f(Pe,e,t),i(e,ai,t),i(e,Re,t),i(e,pi,t),i(e,ye,t),i(e,ci,t),i(e,Ce,t),i(e,fi,t),i(e,hi,t),i(e,mi,t),i(e,He,t),i(e,bi,t),f(Me,e,t),i(e,_i,t),i(e,Fe,t),i(e,Ti,t),i(e,Le,t),i(e,$i,t),i(e,xe,t),i(e,vi,t),i(e,gi,t),i(e,Pi,t),i(e,we,t),i(e,Ri,t),f(Ae,e,t),i(e,yi,t),i(e,je,t),i(e,Ci,t),i(e,Ee,t),i(e,Hi,t),i(e,Oe,t),i(e,Mi,t),i(e,Fi,t),i(e,Li,t),i(e,Ue,t),i(e,xi,t),f(Be,e,t),i(e,wi,t),i(e,Ke,t),i(e,Ai,t),i(e,qe,t),i(e,ji,t),i(e,Ei,t),i(e,Oi,t),i(e,Ne,t),i(e,Ui,t),f(ke,e,t),i(e,Bi,t),i(e,Se,t),i(e,Ki,t),i(e,Ie,t),i(e,qi,t),i(e,Ni,t),i(e,ki,t),i(e,Je,t),i(e,Si,t),f(ze,e,t),i(e,Ii,t),i(e,De,t),i(e,Ji,t),i(e,We,t),i(e,zi,t),i(e,Ye,t),i(e,Di,t),i(e,Wi,t),i(e,Yi,t),i(e,Ve,t),i(e,Vi,t),f(Ge,e,t),i(e,Gi,t),i(e,Qe,t),i(e,Qi,t),i(e,Xe,t),i(e,Xi,t),i(e,Ze,t),i(e,Zi,t),i(e,eo,t),i(e,to,t),i(e,et,t),i(e,lo,t),f(tt,e,t),i(e,io,t),i(e,lt,t),i(e,oo,t),i(e,it,t),i(e,so,t),i(e,ot,t),i(e,no,t),i(e,ro,t),i(e,uo,t),i(e,st,t),i(e,ao,t),f(dt,e,t),i(e,po,t),i(e,nt,t),i(e,co,t),i(e,rt,t),i(e,fo,t),i(e,ut,t),i(e,ho,t),i(e,at,t),i(e,mo,t),i(e,bo,t),i(e,_o,t),i(e,pt,t),i(e,To,t),f(ct,e,t),i(e,$o,t),i(e,ft,t),i(e,vo,t),i(e,ht,t),i(e,go,t),i(e,Po,t),i(e,Ro,t),i(e,mt,t),i(e,yo,t),f(bt,e,t),i(e,Co,t),i(e,_t,t),i(e,Ho,t),i(e,Tt,t),i(e,Mo,t),i(e,$t,t),i(e,Fo,t),i(e,Lo,t),i(e,xo,t),i(e,vt,t),i(e,wo,t),f(gt,e,t),i(e,Ao,t),i(e,Pt,t),i(e,jo,t),i(e,Rt,t),i(e,Eo,t),i(e,yt,t),i(e,Oo,t),i(e,Uo,t),i(e,Bo,t),i(e,Ct,t),i(e,Ko,t),f(Ht,e,t),i(e,qo,t),i(e,Mt,t),i(e,No,t),i(e,Ft,t),i(e,ko,t),i(e,Lt,t),i(e,So,t),i(e,Io,t),i(e,Jo,t),f(xt,e,t),i(e,zo,t),i(e,At,t),Do=!0},p:rd,i(e){Do||(h(v.$$.fragment,e),h(y.$$.fragment,e),h(L.$$.fragment,e),h(U.$$.fragment,e),h(q.$$.fragment,e),h(S.$$.fragment,e),h(z.$$.fragment,e),h(Q.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(_e.$$.fragment,e),h(Pe.$$.fragment,e),h(Me.$$.fragment,e),h(Ae.$$.fragment,e),h(Be.$$.fragment,e),h(ke.$$.fragment,e),h(ze.$$.fragment,e),h(Ge.$$.fragment,e),h(tt.$$.fragment,e),h(dt.$$.fragment,e),h(ct.$$.fragment,e),h(bt.$$.fragment,e),h(gt.$$.fragment,e),h(Ht.$$.fragment,e),h(xt.$$.fragment,e),Do=!0)},o(e){m(v.$$.fragment,e),m(y.$$.fragment,e),m(L.$$.fragment,e),m(U.$$.fragment,e),m(q.$$.fragment,e),m(S.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(ue.$$.fragment,e),m(fe.$$.fragment,e),m(_e.$$.fragment,e),m(Pe.$$.fragment,e),m(Me.$$.fragment,e),m(Ae.$$.fragment,e),m(Be.$$.fragment,e),m(ke.$$.fragment,e),m(ze.$$.fragment,e),m(Ge.$$.fragment,e),m(tt.$$.fragment,e),m(dt.$$.fragment,e),m(ct.$$.fragment,e),m(bt.$$.fragment,e),m(gt.$$.fragment,e),m(Ht.$$.fragment,e),m(xt.$$.fragment,e),Do=!1},d(e){e&&(l(jt),l(wt),l(Et),l($),l(Ot),l(Ut),l(g),l(Bt),l(P),l(Kt),l(qt),l(Nt),l(R),l(kt),l(St),l(C),l(It),l(H),l(Jt),l(M),l(zt),l(Dt),l(Wt),l(F),l(Yt),l(Vt),l(x),l(Gt),l(w),l(Qt),l(A),l(Xt),l(j),l(Zt),l(E),l(el),l(tl),l(ll),l(O),l(il),l(ol),l(B),l(sl),l(dl),l(nl),l(K),l(rl),l(ul),l(N),l(al),l(pl),l(cl),l(k),l(fl),l(hl),l(I),l(ml),l(bl),l(_l),l(J),l(Tl),l($l),l(D),l(vl),l(W),l(gl),l(Y),l(Pl),l(V),l(Rl),l(yl),l(Cl),l(G),l(Hl),l(Ml),l(X),l(Fl),l(Z),l(Ll),l(xl),l(wl),l(ee),l(Al),l(jl),l(le),l(El),l(ie),l(Ol),l(Ul),l(Bl),l(oe),l(Kl),l(ql),l(de),l(Nl),l(ne),l(kl),l(Sl),l(Il),l(re),l(Jl),l(zl),l(ae),l(Dl),l(pe),l(Wl),l(Yl),l(Vl),l(ce),l(Gl),l(Ql),l(he),l(Xl),l(me),l(Zl),l(ei),l(ti),l(be),l(li),l(ii),l(Te),l(oi),l($e),l(si),l(ve),l(di),l(ni),l(ri),l(ge),l(ui),l(ai),l(Re),l(pi),l(ye),l(ci),l(Ce),l(fi),l(hi),l(mi),l(He),l(bi),l(_i),l(Fe),l(Ti),l(Le),l($i),l(xe),l(vi),l(gi),l(Pi),l(we),l(Ri),l(yi),l(je),l(Ci),l(Ee),l(Hi),l(Oe),l(Mi),l(Fi),l(Li),l(Ue),l(xi),l(wi),l(Ke),l(Ai),l(qe),l(ji),l(Ei),l(Oi),l(Ne),l(Ui),l(Bi),l(Se),l(Ki),l(Ie),l(qi),l(Ni),l(ki),l(Je),l(Si),l(Ii),l(De),l(Ji),l(We),l(zi),l(Ye),l(Di),l(Wi),l(Yi),l(Ve),l(Vi),l(Gi),l(Qe),l(Qi),l(Xe),l(Xi),l(Ze),l(Zi),l(eo),l(to),l(et),l(lo),l(io),l(lt),l(oo),l(it),l(so),l(ot),l(no),l(ro),l(uo),l(st),l(ao),l(po),l(nt),l(co),l(rt),l(fo),l(ut),l(ho),l(at),l(mo),l(bo),l(_o),l(pt),l(To),l($o),l(ft),l(vo),l(ht),l(go),l(Po),l(Ro),l(mt),l(yo),l(Co),l(_t),l(Ho),l(Tt),l(Mo),l($t),l(Fo),l(Lo),l(xo),l(vt),l(wo),l(Ao),l(Pt),l(jo),l(Rt),l(Eo),l(yt),l(Oo),l(Uo),l(Bo),l(Ct),l(Ko),l(qo),l(Mt),l(No),l(Ft),l(ko),l(Lt),l(So),l(Io),l(Jo),l(zo),l(At)),l(T),b(v,e),b(y,e),b(L,e),b(U,e),b(q,e),b(S,e),b(z,e),b(Q,e),b(te,e),b(se,e),b(ue,e),b(fe,e),b(_e,e),b(Pe,e),b(Me,e),b(Ae,e),b(Be,e),b(ke,e),b(ze,e),b(Ge,e),b(tt,e),b(dt,e),b(ct,e),b(bt,e),b(gt,e),b(Ht,e),b(xt,e)}}}const bd='{"title":"utils/hub","local":"utilshub","sections":[{"title":"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>","local":"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code","sections":[],"depth":2},{"title":"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options]) ⇒ <code> Promise </code>","local":"utilshubgetmodelfilepathorrepoid-filename-fatal-options--code-promise-code","sections":[{"title":"getModelFile~cacheKey : <code> string </code>","local":"getmodelfilecachekey--code-string-code","sections":[],"depth":3},{"title":"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>","local":"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code","sections":[],"depth":3},{"title":"getModelFile~buffer : <code> Uint8Array </code>","local":"getmodelfilebuffer--code-uint8array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>","local":"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code","sections":[],"depth":2},{"title":"utils/hub~FileResponse","local":"utilshubfileresponse","sections":[{"title":"new FileResponse(filePath)","local":"new-fileresponsefilepath","sections":[],"depth":3},{"title":"fileResponse._CONTENT_TYPE_MAP","local":"fileresponsecontenttypemap","sections":[],"depth":3},{"title":"fileResponse.updateContentType() ⇒ <code> void </code>","local":"fileresponseupdatecontenttype--code-void-code","sections":[],"depth":3},{"title":"fileResponse.clone() ⇒ <code> FileResponse </code>","local":"fileresponseclone--code-fileresponse-code","sections":[],"depth":3},{"title":"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>","local":"fileresponsearraybuffer--code-promise--arraybuffer--code","sections":[],"depth":3},{"title":"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>","local":"fileresponseblob--code-promise--blob--code","sections":[],"depth":3},{"title":"fileResponse.text() ⇒ <code> Promise. < string > </code>","local":"fileresponsetext--code-promise--string--code","sections":[],"depth":3},{"title":"fileResponse.json() ⇒ <code> Promise. < Object > </code>","local":"fileresponsejson--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~FileCache","local":"utilshubfilecache","sections":[{"title":"new FileCache(path)","local":"new-filecachepath","sections":[],"depth":3},{"title":"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>","local":"filecachematchrequest--code-promise--fileresponseundefined--code","sections":[],"depth":3},{"title":"fileCache.put(request, response) ⇒ <code> Promise. < void > </code>","local":"filecacheputrequest-response--code-promise--void--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~isValidHttpUrl(string, [validHosts]) ⇒ <code> boolean </code>","local":"utilshubisvalidhttpurlstring-validhosts--code-boolean-code","sections":[],"depth":2},{"title":"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>","local":"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code","sections":[],"depth":2},{"title":"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>","local":"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code","sections":[],"depth":2},{"title":"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>","local":"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code","sections":[],"depth":2},{"title":"utils/hub~pathJoin(...parts) ⇒ <code> string </code>","local":"utilshubpathjoinparts--code-string-code","sections":[],"depth":2},{"title":"utils/hub~PretrainedOptions : <code> Object </code>","local":"utilshubpretrainedoptions--code-object-code","sections":[],"depth":2}],"depth":1}';function _d(Wo){return ud(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gd extends ad{constructor(T){super(),pd(this,T,_d,md,nd,{})}}export{gd as component};
