import{s as De,n as Ke,o as Oe}from"../chunks/scheduler.389d799c.js";import{S as et,i as tt,g as i,s as n,r as o,A as lt,h as p,f as l,c as a,j as qe,u,x as m,k as Pe,y as st,a as s,v as M,d,t as r,w as f}from"../chunks/index.8f81d18f.js";import{C as A}from"../chunks/CodeBlock.3845caa1.js";import{H as Q,E as nt}from"../chunks/EditOnGithub.33306dfe.js";function at(Ce){let h,D,q,K,c,O,w,_e='<a href="https://colab.research.google.com/drive/1QNfJNqJ6_D9nnf7QeGEW9R3YvWQRxIKY?usp=sharing" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',ee,y,Be='The goal of this hands-on is to build a text-to-splat pipeline, using <a href="https://huggingface.co/spaces/dylanebert/LGM-mini" rel="nofollow">LGM</a> (Large Gaussian Model) as an example.',te,b,xe="This consists of two parts of the generative 3D pipeline:",le,J,Ie="<li>Multi-view Diffusion</li> <li>ML-friendly 3D (Gaussian Splatting)</li>",se,g,ne,j,Re="Open the Colab notebook linked above. Click <code>Runtime</code> -&gt; <code>Change runtime type</code> and select <code>GPU</code> as the hardware accelerator.",ae,T,Xe="Then, start by installing the necessary dependencies:",ie,$,pe,Z,Ee="As before, if the notebook asks you to restart the session, do so, then rerun the code block.",me,U,oe,W,Se="Just like in the multi-view diffusion notebook, load the pretrained multi-view diffusion model:",ue,G,Me,k,Fe="This is because multi-view diffusion is the first step in the LGM pipeline.",de,v,He="Then, load the generative Gaussian Splatting model, the main contribution of LGM:",re,C,fe,_,he,B,Ve="As before, load the famous Cat Statue image:",ce,x,we,I,ye,R,ze="Finally, pass the image through both pipelines. The output will be a matrix of splat data, which can be saved with <code>splat_pipeline.save_ply()</code>.",be,X,Je,E,Ne='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/ml-for-3d-course/multi-view-cats.png" alt="Multi-view Cats"/>',ge,S,je,F,Le="This includes <code>files.download()</code> to download the file to your local machine when running the notebook in Colab. If you’re running the notebook locally, you can remove this line.",Te,H,Ye="Congratulations! You’ve run the LGM pipeline.",$e,V,Ze,z,Ae="Now, let’s create a Gradio demo to run the model end-to-end with an easy-to-use interface:",Ue,N,We,L,Qe="This will create a Gradio demo that takes an image as input and outputs a 3D splat.",Ge,Y,ke,P,ve;return c=new Q({props:{title:"Hands-on",local:"hands-on",headingTag:"h1"}}),g=new Q({props:{title:"Setup",local:"setup",headingTag:"h2"}}),$=new A({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtciUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZkeWxhbmViZXJ0JTJGTEdNLW1pbmklMkZyYXclMkZtYWluJTJGcmVxdWlyZW1lbnRzLnR4dCUwQSFwaXAlMjBpbnN0YWxsJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnNwYWNlcyUyRmR5bGFuZWJlcnQlMkZMR00tbWluaSUyRnJlc29sdmUlMkZtYWluJTJGd2hlZWwlMkZkaWZmX2dhdXNzaWFuX3Jhc3Rlcml6YXRpb24tMC4wLjAtY3AzMTAtY3AzMTAtbGludXhfeDg2XzY0LndobA==",highlighted:`!pip install -r https://huggingface.co/spaces/dylanebert/LGM-mini/raw/main/requirements.txt
!pip install https://huggingface.co/spaces/dylanebert/LGM-mini/resolve/main/wheel/diff_gaussian_rasterization-<span class="hljs-number">0.0</span><span class="hljs-number">.0</span>-cp310-cp310-linux_x86_64.whl`,wrap:!1}}),U=new Q({props:{title:"Load the Models",local:"load-the-models",headingTag:"h2"}}),G=new A({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFpbWFnZV9waXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJkeWxhbmViZXJ0JTJGbXVsdGktdmlldy1kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJkeWxhbmViZXJ0JTJGbXVsdGktdmlldy1kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

image_pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;dylanebert/multi-view-diffusion&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;dylanebert/multi-view-diffusion&quot;</span>,
    torch_dtype=torch.float16,
    trust_remote_code=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),C=new A({props:{code:"c3BsYXRfcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZHlsYW5lYmVydCUyRkxHTSUyMiUyQyUwQSUyMCUyMCUyMCUyMGN1c3RvbV9waXBlbGluZSUzRCUyMmR5bGFuZWJlcnQlMkZMR00lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIp",highlighted:`splat_pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;dylanebert/LGM&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;dylanebert/LGM&quot;</span>,
    torch_dtype=torch.float16,
    trust_remote_code=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),_=new Q({props:{title:"Load an Image",local:"load-an-image",headingTag:"h2"}}),x=new A({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBJTBBaW1hZ2VfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGZHlsYW5lYmVydCUyRjNkLWFyZW5hJTJGcmVzb2x2ZSUyRm1haW4lMkZpbnB1dHMlMkZpbWFnZXMlMkZhX2NhdF9zdGF0dWUuanBnJTIyJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQoaW1hZ2VfdXJsKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKSUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/dylanebert/3d-arena/resolve/main/inputs/images/a_cat_statue.jpg&quot;</span>
response = requests.get(image_url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content))
image`,wrap:!1}}),I=new Q({props:{title:"Run the Pipeline",local:"run-the-pipeline",headingTag:"h2"}}),X=new A({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGdvb2dsZS5jb2xhYiUyMGltcG9ydCUyMGZpbGVzJTBBJTBBaW5wdXRfaW1hZ2UlMjAlM0QlMjBucC5hcnJheShpbWFnZSUyQyUyMGR0eXBlJTNEbnAuZmxvYXQzMiklMjAlMkYlMjAyNTUuJTBBbXVsdGlfdmlld19pbWFnZXMlMjAlM0QlMjBpbWFnZV9waXBlbGluZSglMjIlMjIlMkMlMjBpbnB1dF9pbWFnZSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUyMGVsZXZhdGlvbiUzRDAp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> google.colab <span class="hljs-keyword">import</span> files

input_image = np.array(image, dtype=np.float32) / <span class="hljs-number">255.</span>
multi_view_images = image_pipeline(<span class="hljs-string">&quot;&quot;</span>, input_image, guidance_scale=<span class="hljs-number">5</span>, num_inference_steps=<span class="hljs-number">30</span>, elevation=<span class="hljs-number">0</span>)`,wrap:!1}}),S=new A({props:{code:"c3BsYXQlMjAlM0QlMjBzcGxhdF9waXBlbGluZShtdWx0aV92aWV3X2ltYWdlcyklMEElMEFvdXRwdXRfcGF0aCUyMCUzRCUyMCUyMiUyRnRtcCUyRm91dHB1dC5wbHklMjIlMEFzcGxhdF9waXBlbGluZS5zYXZlX3BseShzcGxhdCUyQyUyMG91dHB1dF9wYXRoKSUwQWZpbGVzLmRvd25sb2FkKG91dHB1dF9wYXRoKQ==",highlighted:`splat = splat_pipeline(multi_view_images)

output_path = <span class="hljs-string">&quot;/tmp/output.ply&quot;</span>
splat_pipeline.save_ply(splat, output_path)
files.download(output_path)`,wrap:!1}}),V=new Q({props:{title:"Gradio Demo",local:"gradio-demo",headingTag:"h2"}}),N=new A({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlZiUyMHJ1bihpbWFnZSklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9pbWFnZSUyMCUzRCUyMGltYWdlLmFzdHlwZSglMjJmbG9hdDMyJTIyKSUyMCUyRiUyMDI1NS4wJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTIwJTNEJTIwaW1hZ2VfcGlwZWxpbmUoJTIyJTIyJTJDJTIwaW5wdXRfaW1hZ2UlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDUlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzAlMkMlMjBlbGV2YXRpb24lM0QwKSUwQSUyMCUyMCUyMCUyMHNwbGF0JTIwJTNEJTIwc3BsYXRfcGlwZWxpbmUoaW1hZ2VzKSUwQSUyMCUyMCUyMCUyMG91dHB1dF9wYXRoJTIwJTNEJTIwJTIyJTJGdG1wJTJGb3V0cHV0LnBseSUyMiUwQSUyMCUyMCUyMCUyMHNwbGF0X3BpcGVsaW5lLnNhdmVfcGx5KHNwbGF0JTJDJTIwb3V0cHV0X3BhdGgpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwb3V0cHV0X3BhdGglMEElMEFkZW1vJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKGZuJTNEcnVuJTJDJTIwaW5wdXRzJTNEJTIyaW1hZ2UlMjIlMkMlMjBvdXRwdXRzJTNEZ3IuTW9kZWwzRCgpKSUwQWRlbW8ubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run</span>(<span class="hljs-params">image</span>):
    input_image = image.astype(<span class="hljs-string">&quot;float32&quot;</span>) / <span class="hljs-number">255.0</span>
    images = image_pipeline(<span class="hljs-string">&quot;&quot;</span>, input_image, guidance_scale=<span class="hljs-number">5</span>, num_inference_steps=<span class="hljs-number">30</span>, elevation=<span class="hljs-number">0</span>)
    splat = splat_pipeline(images)
    output_path = <span class="hljs-string">&quot;/tmp/output.ply&quot;</span>
    splat_pipeline.save_ply(splat, output_path)
    <span class="hljs-keyword">return</span> output_path

demo = gr.Interface(fn=run, inputs=<span class="hljs-string">&quot;image&quot;</span>, outputs=gr.Model3D())
demo.launch()`,wrap:!1}}),Y=new nt({props:{source:"https://github.com/huggingface/ml-for-3d-course/blob/main/units/en/unit3/hands-on.mdx"}}),{c(){h=i("meta"),D=n(),q=i("p"),K=n(),o(c.$$.fragment),O=n(),w=i("p"),w.innerHTML=_e,ee=n(),y=i("p"),y.innerHTML=Be,te=n(),b=i("p"),b.textContent=xe,le=n(),J=i("ol"),J.innerHTML=Ie,se=n(),o(g.$$.fragment),ne=n(),j=i("p"),j.innerHTML=Re,ae=n(),T=i("p"),T.textContent=Xe,ie=n(),o($.$$.fragment),pe=n(),Z=i("p"),Z.textContent=Ee,me=n(),o(U.$$.fragment),oe=n(),W=i("p"),W.textContent=Se,ue=n(),o(G.$$.fragment),Me=n(),k=i("p"),k.textContent=Fe,de=n(),v=i("p"),v.textContent=He,re=n(),o(C.$$.fragment),fe=n(),o(_.$$.fragment),he=n(),B=i("p"),B.textContent=Ve,ce=n(),o(x.$$.fragment),we=n(),o(I.$$.fragment),ye=n(),R=i("p"),R.innerHTML=ze,be=n(),o(X.$$.fragment),Je=n(),E=i("p"),E.innerHTML=Ne,ge=n(),o(S.$$.fragment),je=n(),F=i("p"),F.innerHTML=Le,Te=n(),H=i("p"),H.textContent=Ye,$e=n(),o(V.$$.fragment),Ze=n(),z=i("p"),z.textContent=Ae,Ue=n(),o(N.$$.fragment),We=n(),L=i("p"),L.textContent=Qe,Ge=n(),o(Y.$$.fragment),ke=n(),P=i("p"),this.h()},l(e){const t=lt("svelte-u9bgzb",document.head);h=p(t,"META",{name:!0,content:!0}),t.forEach(l),D=a(e),q=p(e,"P",{}),qe(q).forEach(l),K=a(e),u(c.$$.fragment,e),O=a(e),w=p(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1pwxv5o"&&(w.innerHTML=_e),ee=a(e),y=p(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-9djh52"&&(y.innerHTML=Be),te=a(e),b=p(e,"P",{"data-svelte-h":!0}),m(b)!=="svelte-178d5rc"&&(b.textContent=xe),le=a(e),J=p(e,"OL",{"data-svelte-h":!0}),m(J)!=="svelte-et3tho"&&(J.innerHTML=Ie),se=a(e),u(g.$$.fragment,e),ne=a(e),j=p(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-wcy6j2"&&(j.innerHTML=Re),ae=a(e),T=p(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-ssamfi"&&(T.textContent=Xe),ie=a(e),u($.$$.fragment,e),pe=a(e),Z=p(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-h67e47"&&(Z.textContent=Ee),me=a(e),u(U.$$.fragment,e),oe=a(e),W=p(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1wynurq"&&(W.textContent=Se),ue=a(e),u(G.$$.fragment,e),Me=a(e),k=p(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-a7of95"&&(k.textContent=Fe),de=a(e),v=p(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-gpglvz"&&(v.textContent=He),re=a(e),u(C.$$.fragment,e),fe=a(e),u(_.$$.fragment,e),he=a(e),B=p(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-baxprw"&&(B.textContent=Ve),ce=a(e),u(x.$$.fragment,e),we=a(e),u(I.$$.fragment,e),ye=a(e),R=p(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-9ymiby"&&(R.innerHTML=ze),be=a(e),u(X.$$.fragment,e),Je=a(e),E=p(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-v2rinw"&&(E.innerHTML=Ne),ge=a(e),u(S.$$.fragment,e),je=a(e),F=p(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1fatto7"&&(F.innerHTML=Le),Te=a(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-s7ejaf"&&(H.textContent=Ye),$e=a(e),u(V.$$.fragment,e),Ze=a(e),z=p(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1yjc2rc"&&(z.textContent=Ae),Ue=a(e),u(N.$$.fragment,e),We=a(e),L=p(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-dxedc"&&(L.textContent=Qe),Ge=a(e),u(Y.$$.fragment,e),ke=a(e),P=p(e,"P",{}),qe(P).forEach(l),this.h()},h(){Pe(h,"name","hf:doc:metadata"),Pe(h,"content",it)},m(e,t){st(document.head,h),s(e,D,t),s(e,q,t),s(e,K,t),M(c,e,t),s(e,O,t),s(e,w,t),s(e,ee,t),s(e,y,t),s(e,te,t),s(e,b,t),s(e,le,t),s(e,J,t),s(e,se,t),M(g,e,t),s(e,ne,t),s(e,j,t),s(e,ae,t),s(e,T,t),s(e,ie,t),M($,e,t),s(e,pe,t),s(e,Z,t),s(e,me,t),M(U,e,t),s(e,oe,t),s(e,W,t),s(e,ue,t),M(G,e,t),s(e,Me,t),s(e,k,t),s(e,de,t),s(e,v,t),s(e,re,t),M(C,e,t),s(e,fe,t),M(_,e,t),s(e,he,t),s(e,B,t),s(e,ce,t),M(x,e,t),s(e,we,t),M(I,e,t),s(e,ye,t),s(e,R,t),s(e,be,t),M(X,e,t),s(e,Je,t),s(e,E,t),s(e,ge,t),M(S,e,t),s(e,je,t),s(e,F,t),s(e,Te,t),s(e,H,t),s(e,$e,t),M(V,e,t),s(e,Ze,t),s(e,z,t),s(e,Ue,t),M(N,e,t),s(e,We,t),s(e,L,t),s(e,Ge,t),M(Y,e,t),s(e,ke,t),s(e,P,t),ve=!0},p:Ke,i(e){ve||(d(c.$$.fragment,e),d(g.$$.fragment,e),d($.$$.fragment,e),d(U.$$.fragment,e),d(G.$$.fragment,e),d(C.$$.fragment,e),d(_.$$.fragment,e),d(x.$$.fragment,e),d(I.$$.fragment,e),d(X.$$.fragment,e),d(S.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d(Y.$$.fragment,e),ve=!0)},o(e){r(c.$$.fragment,e),r(g.$$.fragment,e),r($.$$.fragment,e),r(U.$$.fragment,e),r(G.$$.fragment,e),r(C.$$.fragment,e),r(_.$$.fragment,e),r(x.$$.fragment,e),r(I.$$.fragment,e),r(X.$$.fragment,e),r(S.$$.fragment,e),r(V.$$.fragment,e),r(N.$$.fragment,e),r(Y.$$.fragment,e),ve=!1},d(e){e&&(l(D),l(q),l(K),l(O),l(w),l(ee),l(y),l(te),l(b),l(le),l(J),l(se),l(ne),l(j),l(ae),l(T),l(ie),l(pe),l(Z),l(me),l(oe),l(W),l(ue),l(Me),l(k),l(de),l(v),l(re),l(fe),l(he),l(B),l(ce),l(we),l(ye),l(R),l(be),l(Je),l(E),l(ge),l(je),l(F),l(Te),l(H),l($e),l(Ze),l(z),l(Ue),l(We),l(L),l(Ge),l(ke),l(P)),l(h),f(c,e),f(g,e),f($,e),f(U,e),f(G,e),f(C,e),f(_,e),f(x,e),f(I,e),f(X,e),f(S,e),f(V,e),f(N,e),f(Y,e)}}}const it='{"title":"Hands-on","local":"hands-on","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Load the Models","local":"load-the-models","sections":[],"depth":2},{"title":"Load an Image","local":"load-an-image","sections":[],"depth":2},{"title":"Run the Pipeline","local":"run-the-pipeline","sections":[],"depth":2},{"title":"Gradio Demo","local":"gradio-demo","sections":[],"depth":2}],"depth":1}';function pt(Ce){return Oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dt extends et{constructor(h){super(),tt(this,h,pt,at,De,{})}}export{dt as component};
