import{s as no,o as lo,n as er}from"../chunks/scheduler.9bc65507.js";import{S as io,i as co,g as n,s as a,r as p,A as mo,h as l,f as t,c as o,j as b,u as f,x as d,k as $,y as s,a as i,v as u,d as h,t as g,w as _}from"../chunks/index.707bf1b6.js";import{T as oa}from"../chunks/Tip.c2ecdbf4.js";import{D as M}from"../chunks/Docstring.17db21ae.js";import{C as rr}from"../chunks/CodeBlock.54a9f38d.js";import{E as na}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as pe}from"../chunks/Heading.342b1fa6.js";function po(j){let c,T=`This class method is simply calling the feature extractor
<a href="/docs/transformers/v4.37.0/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/v4.37.0/en/main_classes/image_processor#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=n("p"),c.innerHTML=T},l(v){c=l(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-lohi75"&&(c.innerHTML=T)},m(v,x){i(v,c,x)},p:er,d(v){v&&t(c)}}}function fo(j){let c,T="Examples:",v,x,C;return x=new rr({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMHByb2Nlc3NvciUyMHRvJTIweW91ciUyMG5hbWVzcGFjZSUyMHdpdGglMjB0aGUlMjBuYW1lJTIwJTIybXktZmluZXR1bmVkLWJlcnQlMjIuJTBBcHJvY2Vzc29yLnB1c2hfdG9faHViKCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyKSUwQSUwQSUyMyUyMFB1c2glMjB0aGUlMjBwcm9jZXNzb3IlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFwcm9jZXNzb3IucHVzaF90b19odWIoJTIyaHVnZ2luZ2ZhY2UlMkZteS1maW5ldHVuZWQtYmVydCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the processor to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the processor to an organization with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,v=a(),p(x.$$.fragment)},l(m){c=l(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=o(m),f(x.$$.fragment,m)},m(m,k){i(m,c,k),i(m,v,k),u(x,m,k),C=!0},p:er,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function uo(j){let c,T="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){c=n("p"),c.textContent=T},l(v){c=l(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-15rpg4"&&(c.textContent=T)},m(v,x){i(v,c,x)},p:er,d(v){v&&t(c)}}}function ho(j){let c,T=`This class method is simply calling <a href="/docs/transformers/v4.37.0/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.37.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=n("p"),c.innerHTML=T},l(v){c=l(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-1lyd3pm"&&(c.innerHTML=T)},m(v,x){i(v,c,x)},p:er,d(v){v&&t(c)}}}function go(j){let c,T="Examples:",v,x,C;return x=new rr({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMGFzJTIwdGZkcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBJTBBdHJhaW5pbmdfZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzREZhbHNlKSUwQWV2YWx1YXRpb25fZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow_datasets <span class="hljs-keyword">as</span> tfds

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>training_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>evaluation_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,v=a(),p(x.$$.fragment)},l(m){c=l(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=o(m),f(x.$$.fragment,m)},m(m,k){i(m,c,k),i(m,v,k),u(x,m,k),C=!0},p:er,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function _o(j){let c,T="Example:",v,x,C;return x=new rr({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwU3F1YWRWMlByb2Nlc3NvcigpJTBBZXhhbXBsZXMlMjAlM0QlMjBwcm9jZXNzb3IuZ2V0X2Rldl9leGFtcGxlcyhkYXRhX2RpciklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEYXJncy5tYXhfc2VxX2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGRvY19zdHJpZGUlM0RhcmdzLmRvY19zdHJpZGUlMkMlMEElMjAlMjAlMjAlMjBtYXhfcXVlcnlfbGVuZ3RoJTNEYXJncy5tYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`processor = SquadV2Processor()
examples = processor.get_dev_examples(data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=args.max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=args.max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,v=a(),p(x.$$.fragment)},l(m){c=l(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=T),v=o(m),f(x.$$.fragment,m)},m(m,k){i(m,c,k),i(m,v,k),u(x,m,k),C=!0},p:er,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function vo(j){let c,T,v,x,C,m,k,la="Processors can mean two different things in the Transformers library:",sr,fe,ia=`<li>the objects that pre-process inputs for multi-modal models such as <a href="../model_doc/wav2vec2">Wav2Vec2</a> (speech and text)
or <a href="../model_doc/clip">CLIP</a> (text and vision)</li> <li>deprecated objects that were used in older versions of the library to preprocess data for GLUE or SQUAD.</li>`,ar,ue,or,he,da=`Any multi-modal model will require an object to encode or decode the data that groups several modalities (among text,
vision and audio). This is handled by objects called processors, which group together two or more processing objects
such as tokenizers (for the text modality), image processors (for vision) and feature extractors (for audio).`,nr,ge,ca="Those processors inherit from the following base class that implements the saving and loading functionality:",lr,y,_e,ns,yt,ma="This is a mixin used to provide saving/loading functionality for all processor classes.",ls,N,ve,is,Mt,pa="Instantiates a type of <code>~processing_utils.ProcessingMixin</code> from a Python dictionary of parameters.",ds,Z,xe,cs,wt,fa="Instantiate a processor associated with a pretrained model.",ms,G,ps,W,be,fs,Tt,ua=`From a <code>pretrained_model_name_or_path</code>, resolve to a dictionary of parameters, to be used for instantiating a
processor of type <code>~processing_utils.ProcessingMixin</code> using <code>from_args_and_dict</code>.`,us,q,$e,hs,Ct,ha="Upload the processor files to the 🤗 Model Hub.",gs,R,_s,V,ye,vs,Pt,ga=`Register this class with a given auto class. This should only be used for custom feature extractors as the ones
in the library are already mapped with <code>AutoProcessor</code>.`,xs,Q,bs,z,Me,$s,kt,_a=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/v4.37.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor.from_pretrained">from_pretrained()</a> method.`,ys,A,Ms,Y,we,ws,It,va="Serializes this instance to a Python dictionary.",Ts,O,Te,Cs,Ut,xa="Save this instance to a JSON file.",Ps,K,Ce,ks,jt,ba="Serializes this instance to a JSON string.",ir,Pe,dr,ke,$a=`All processors follow the same architecture which is that of the
<a href="/docs/transformers/v4.37.0/en/main_classes/processors#transformers.DataProcessor">DataProcessor</a>. The processor returns a list of
<a href="/docs/transformers/v4.37.0/en/main_classes/processors#transformers.InputExample">InputExample</a>. These
<a href="/docs/transformers/v4.37.0/en/main_classes/processors#transformers.InputExample">InputExample</a> can be converted to
<a href="/docs/transformers/v4.37.0/en/main_classes/processors#transformers.InputFeatures">InputFeatures</a> in order to be fed to the model.`,cr,P,Ie,Is,Xt,ya="Base class for data converters for sequence classification data sets.",Us,ee,Ue,js,Lt,Ma='Gets a collection of <a href="/docs/transformers/v4.37.0/en/main_classes/processors#transformers.InputExample">InputExample</a> for the dev set.',Xs,te,je,Ls,Jt,wa="Gets an example from a dict with tensorflow tensors.",Js,re,Xe,Zs,Zt,Ta="Gets the list of labels for this data set.",qs,se,Le,Vs,qt,Ca='Gets a collection of <a href="/docs/transformers/v4.37.0/en/main_classes/processors#transformers.InputExample">InputExample</a> for the test set.',zs,ae,Je,Es,Vt,Pa='Gets a collection of <a href="/docs/transformers/v4.37.0/en/main_classes/processors#transformers.InputExample">InputExample</a> for the train set.',Hs,oe,Ze,Bs,zt,ka=`Some tensorflow_datasets datasets are not formatted the same way the GLUE datasets are. This method converts
examples to the correct format.`,mr,X,qe,Ss,Et,Ia="A single training/test example for simple sequence classification.",Fs,ne,Ve,Ds,Ht,Ua="Serializes this instance to a JSON string.",pr,L,ze,Ns,Bt,ja="A single set of features of data. Property names are the same names as the corresponding inputs to a model.",Gs,le,Ee,Ws,St,Xa="Serializes this instance to a JSON string.",fr,He,ur,Be,La=`<a href="https://gluebenchmark.com/" rel="nofollow">General Language Understanding Evaluation (GLUE)</a> is a benchmark that evaluates the
performance of models across a diverse set of existing NLU tasks. It was released together with the paper <a href="https://openreview.net/pdf?id=rJ4km2R5t7" rel="nofollow">GLUE: A
multi-task benchmark and analysis platform for natural language understanding</a>`,hr,Se,Ja=`This library hosts a total of 10 processors for the following tasks: MRPC, MNLI, MNLI (mismatched), CoLA, SST2, STSB,
QQP, QNLI, RTE and WNLI.`,gr,Fe,Za="Those processors are:",_r,De,qa="<li><code>~data.processors.utils.MrpcProcessor</code></li> <li><code>~data.processors.utils.MnliProcessor</code></li> <li><code>~data.processors.utils.MnliMismatchedProcessor</code></li> <li><code>~data.processors.utils.Sst2Processor</code></li> <li><code>~data.processors.utils.StsbProcessor</code></li> <li><code>~data.processors.utils.QqpProcessor</code></li> <li><code>~data.processors.utils.QnliProcessor</code></li> <li><code>~data.processors.utils.RteProcessor</code></li> <li><code>~data.processors.utils.WnliProcessor</code></li>",vr,Ne,Va=`Additionally, the following method can be used to load values from a data file and convert them to a list of
<a href="/docs/transformers/v4.37.0/en/main_classes/processors#transformers.InputExample">InputExample</a>.`,xr,B,Ge,Rs,Ft,za="Loads a data file into a list of <code>InputFeatures</code>",br,We,$r,Re,Ea=`<a href="https://www.nyu.edu/projects/bowman/xnli/" rel="nofollow">The Cross-Lingual NLI Corpus (XNLI)</a> is a benchmark that evaluates the
quality of cross-lingual text representations. XNLI is crowd-sourced dataset based on <a href="http://www.nyu.edu/projects/bowman/multinli/" rel="nofollow"><em>MultiNLI</em></a>: pairs of text are labeled with textual entailment annotations for 15
different languages (including both high-resource language such as English and low-resource languages such as Swahili).`,yr,Qe,Ha='It was released together with the paper <a href="https://arxiv.org/abs/1809.05053" rel="nofollow">XNLI: Evaluating Cross-lingual Sentence Representations</a>',Mr,Ae,Ba="This library hosts the processor to load the XNLI data:",wr,Ye,Sa="<li><code>~data.processors.utils.XnliProcessor</code></li>",Tr,Oe,Fa="Please note that since the gold labels are available on the test set, evaluation is performed on the test set.",Cr,Ke,Da='An example using these processors is given in the <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-classification/run_xnli.py" rel="nofollow">run_xnli.py</a> script.',Pr,et,kr,tt,Na=`<a href="https://rajpurkar.github.io/SQuAD-explorer//" rel="nofollow">The Stanford Question Answering Dataset (SQuAD)</a> is a benchmark that
evaluates the performance of models on question answering. Two versions are available, v1.1 and v2.0. The first version
(v1.1) was released together with the paper <a href="https://arxiv.org/abs/1606.05250" rel="nofollow">SQuAD: 100,000+ Questions for Machine Comprehension of Text</a>. The second version (v2.0) was released alongside the paper <a href="https://arxiv.org/abs/1806.03822" rel="nofollow">Know What You Don’t
Know: Unanswerable Questions for SQuAD</a>.`,Ir,rt,Ga="This library hosts a processor for each of the two versions:",Ur,st,jr,at,Wa="Those processors are:",Xr,ot,Ra="<li><code>~data.processors.utils.SquadV1Processor</code></li> <li><code>~data.processors.utils.SquadV2Processor</code></li>",Lr,nt,Qa="They both inherit from the abstract class <code>~data.processors.utils.SquadProcessor</code>",Jr,U,lt,Qs,Dt,Aa=`Processor for the SQuAD data set. overridden by SquadV1Processor and SquadV2Processor, used by the version 1.1 and
version 2.0 of SQuAD, respectively.`,As,ie,it,Ys,Nt,Ya="Returns the evaluation example from the data directory.",Os,E,dt,Ks,Gt,Oa="Creates a list of <code>SquadExample</code> using a TFDS dataset.",ea,de,ta,ce,ct,ra,Wt,Ka="Returns the training examples from the data directory.",Zr,mt,eo=`Additionally, the following method can be used to convert SQuAD examples into
<code>~data.processors.utils.SquadFeatures</code> that can be used as model inputs.`,qr,J,pt,sa,Rt,to=`Converts a list of examples into a list of features that can be directly given as input to a model. It is
model-dependant and takes advantage of many of the tokenizer’s features to create the model’s inputs.`,aa,me,Vr,ft,ro=`These processors as well as the aforementioned method can be used with files containing the data as well as with the
<em>tensorflow_datasets</em> package. Examples are given below.`,zr,ut,Er,ht,so="Here is an example using the processors as well as the conversion method using data files:",Hr,gt,Br,_t,ao="Using <em>tensorflow_datasets</em> is as easy as using a data file:",Sr,vt,Fr,xt,oo='Another example using these processors is given in the <a href="https://github.com/huggingface/transformers/tree/main/examples/legacy/question-answering/run_squad.py" rel="nofollow">run_squad.py</a> script.',Dr,tr,Nr;return C=new pe({props:{title:"Processors",local:"processors",headingTag:"h1"}}),ue=new pe({props:{title:"Multi-modal processors",local:"transformers.ProcessorMixin",headingTag:"h2"}}),_e=new M({props:{name:"class transformers.ProcessorMixin",anchor:"transformers.ProcessorMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/processing_utils.py#L56"}}),ve=new M({props:{name:"from_args_and_dict",anchor:"transformers.ProcessorMixin.from_args_and_dict",parameters:[{name:"args",val:""},{name:"processor_dict",val:": Dict"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_args_and_dict.processor_dict",description:`<strong>processor_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the processor object. Such a dictionary can be
retrieved from a pretrained checkpoint by leveraging the
<code>~processing_utils.ProcessingMixin.to_dict</code> method.`,name:"processor_dict"},{anchor:"transformers.ProcessorMixin.from_args_and_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the processor object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/processing_utils.py#L357",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processor object instantiated from those
parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~processing_utils.ProcessingMixin</code></p>
`}}),xe=new M({props:{name:"from_pretrained",anchor:"transformers.ProcessorMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/v4.37.0/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/v4.37.0/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/processing_utils.py#L398"}}),G=new oa({props:{$$slots:{default:[po]},$$scope:{ctx:j}}}),be=new M({props:{name:"get_processor_dict",anchor:"transformers.ProcessorMixin.get_processor_dict",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.get_processor_dict.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The identifier of the pre-trained checkpoint from which we want the dictionary of parameters.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.ProcessorMixin.get_processor_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/processing_utils.py#L256",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary(ies) that will be used to instantiate the processor object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Dict, Dict]</code></p>
`}}),$e=new M({props:{name:"push_to_hub",anchor:"transformers.ProcessorMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": Optional = None"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"revision",val:": str = None"},{name:"commit_description",val:": str = None"},{name:"tags",val:": Optional = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your processor to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.ProcessorMixin.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload processor&quot;</code>.`,name:"commit_message"},{anchor:"transformers.ProcessorMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.ProcessorMixin.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.ProcessorMixin.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.ProcessorMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.ProcessorMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.ProcessorMixin.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"transformers.ProcessorMixin.push_to_hub.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to push on the Hub.`,name:"tags"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/utils/hub.py#L755"}}),R=new na({props:{anchor:"transformers.ProcessorMixin.push_to_hub.example",$$slots:{default:[fo]},$$scope:{ctx:j}}}),ye=new M({props:{name:"register_for_auto_class",anchor:"transformers.ProcessorMixin.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoProcessor'"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoProcessor&quot;</code>) &#x2014;
The auto class to register this new feature extractor with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/processing_utils.py#L473"}}),Q=new oa({props:{warning:!0,$$slots:{default:[uo]},$$scope:{ctx:j}}}),Me=new M({props:{name:"save_pretrained",anchor:"transformers.ProcessorMixin.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.ProcessorMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.ProcessorMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.37.0/en/main_classes/configuration#transformers.PretrainedConfig.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/processing_utils.py#L167"}}),A=new oa({props:{$$slots:{default:[ho]},$$scope:{ctx:j}}}),we=new M({props:{name:"to_dict",anchor:"transformers.ProcessorMixin.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/processing_utils.py#L102",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this processor instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Te=new M({props:{name:"to_json_file",anchor:"transformers.ProcessorMixin.to_json_file",parameters:[{name:"json_file_path",val:": Union"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.to_json_file.json_file_path",description:`<strong>json_file_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file in which this processor instance&#x2019;s parameters will be saved.`,name:"json_file_path"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/processing_utils.py#L151"}}),Ce=new M({props:{name:"to_json_string",anchor:"transformers.ProcessorMixin.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/processing_utils.py#L140",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>String containing all the attributes that make up this feature_extractor instance in JSON format.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Pe=new pe({props:{title:"Deprecated processors",local:"transformers.DataProcessor",headingTag:"h2"}}),Ie=new M({props:{name:"class transformers.DataProcessor",anchor:"transformers.DataProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/utils.py#L80"}}),Ue=new M({props:{name:"get_dev_examples",anchor:"transformers.DataProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/utils.py#L97"}}),je=new M({props:{name:"get_example_from_tensor_dict",anchor:"transformers.DataProcessor.get_example_from_tensor_dict",parameters:[{name:"tensor_dict",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/utils.py#L83"}}),Xe=new M({props:{name:"get_labels",anchor:"transformers.DataProcessor.get_labels",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/utils.py#L105"}}),Le=new M({props:{name:"get_test_examples",anchor:"transformers.DataProcessor.get_test_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/utils.py#L101"}}),Je=new M({props:{name:"get_train_examples",anchor:"transformers.DataProcessor.get_train_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/utils.py#L93"}}),Ze=new M({props:{name:"tfds_map",anchor:"transformers.DataProcessor.tfds_map",parameters:[{name:"example",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/utils.py#L109"}}),qe=new M({props:{name:"class transformers.InputExample",anchor:"transformers.InputExample",parameters:[{name:"guid",val:": str"},{name:"text_a",val:": str"},{name:"text_b",val:": Optional = None"},{name:"label",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/utils.py#L29"}}),Ve=new M({props:{name:"to_json_string",anchor:"transformers.InputExample.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/utils.py#L49"}}),ze=new M({props:{name:"class transformers.InputFeatures",anchor:"transformers.InputFeatures",parameters:[{name:"input_ids",val:": List"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"label",val:": Union = None"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/utils.py#L54"}}),Ee=new M({props:{name:"to_json_string",anchor:"transformers.InputFeatures.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/utils.py#L75"}}),He=new pe({props:{title:"GLUE",local:"transformers.glue_convert_examples_to_features",headingTag:"h2"}}),Ge=new M({props:{name:"transformers.glue_convert_examples_to_features",anchor:"transformers.glue_convert_examples_to_features",parameters:[{name:"examples",val:": Union"},{name:"tokenizer",val:": PreTrainedTokenizer"},{name:"max_length",val:": Optional = None"},{name:"task",val:" = None"},{name:"label_list",val:" = None"},{name:"output_mode",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/glue.py#L41",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If the <code>examples</code> input is a <code>tf.data.Dataset</code>, will return a <code>tf.data.Dataset</code> containing the task-specific
features. If the input is a list of <code>InputExamples</code>, will return a list of task-specific <code>InputFeatures</code> which
can be fed to the model.</p>
`}}),We=new pe({props:{title:"XNLI",local:"xnli",headingTag:"h2"}}),et=new pe({props:{title:"SQuAD",local:"squad",headingTag:"h2"}}),st=new pe({props:{title:"Processors",local:"transformers.data.processors.squad.SquadProcessor",headingTag:"h3"}}),lt=new M({props:{name:"class transformers.data.processors.squad.SquadProcessor",anchor:"transformers.data.processors.squad.SquadProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/squad.py#L541"}}),it=new M({props:{name:"get_dev_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/squad.py#L629"}}),dt=new M({props:{name:"get_examples_from_dataset",anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset",parameters:[{name:"dataset",val:""},{name:"evaluate",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/squad.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of SquadExample</p>
`}}),de=new na({props:{anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset.example",$$slots:{default:[go]},$$scope:{ctx:j}}}),ct=new M({props:{name:"get_train_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_train_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/squad.py#L607"}}),pt=new M({props:{name:"transformers.squad_convert_examples_to_features",anchor:"transformers.squad_convert_examples_to_features",parameters:[{name:"examples",val:""},{name:"tokenizer",val:""},{name:"max_seq_length",val:""},{name:"doc_stride",val:""},{name:"max_query_length",val:""},{name:"is_training",val:""},{name:"padding_strategy",val:" = 'max_length'"},{name:"return_dataset",val:" = False"},{name:"threads",val:" = 1"},{name:"tqdm_enabled",val:" = True"}],source:"https://github.com/huggingface/transformers/blob/v4.37.0/src/transformers/data/processors/squad.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <code>SquadFeatures</code></p>
`}}),me=new na({props:{anchor:"transformers.squad_convert_examples_to_features.example",$$slots:{default:[_o]},$$scope:{ctx:j}}}),ut=new pe({props:{title:"Example usage",local:"example-usage",headingTag:"h3"}}),gt=new rr({props:{code:"JTIzJTIwTG9hZGluZyUyMGElMjBWMiUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjJQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjJfZGF0YV9kaXIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMGElMjBWMSUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjFQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjFfZGF0YV9kaXIpJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBzcXVhZF9jb252ZXJ0X2V4YW1wbGVzX3RvX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEZXhhbXBsZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwZG9jX3N0cmlkZSUzRGFyZ3MuZG9jX3N0cmlkZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9xdWVyeV9sZW5ndGglM0RtYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Loading a V2 processor</span>
processor = SquadV2Processor()
examples = processor.get_dev_examples(squad_v2_data_dir)

<span class="hljs-comment"># Loading a V1 processor</span>
processor = SquadV1Processor()
examples = processor.get_dev_examples(squad_v1_data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),vt=new rr({props:{code:"JTIzJTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMG9ubHklMjBoYW5kbGUlMjBTcXVhZCUyMFYxLiUwQXRmZHNfZXhhbXBsZXMlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBZXhhbXBsZXMlMjAlM0QlMjBTcXVhZFYxUHJvY2Vzc29yKCkuZ2V0X2V4YW1wbGVzX2Zyb21fZGF0YXNldCh0ZmRzX2V4YW1wbGVzJTJDJTIwZXZhbHVhdGUlM0RldmFsdWF0ZSklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBkb2Nfc3RyaWRlJTNEYXJncy5kb2Nfc3RyaWRlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3F1ZXJ5X2xlbmd0aCUzRG1heF9xdWVyeV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmluZyUzRG5vdCUyMGV2YWx1YXRlJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># tensorflow_datasets only handle Squad V1.</span>
tfds_examples = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)
examples = SquadV1Processor().get_examples_from_dataset(tfds_examples, evaluate=evaluate)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){c=n("meta"),T=a(),v=n("p"),x=a(),p(C.$$.fragment),m=a(),k=n("p"),k.textContent=la,sr=a(),fe=n("ul"),fe.innerHTML=ia,ar=a(),p(ue.$$.fragment),or=a(),he=n("p"),he.textContent=da,nr=a(),ge=n("p"),ge.textContent=ca,lr=a(),y=n("div"),p(_e.$$.fragment),ns=a(),yt=n("p"),yt.textContent=ma,ls=a(),N=n("div"),p(ve.$$.fragment),is=a(),Mt=n("p"),Mt.innerHTML=pa,ds=a(),Z=n("div"),p(xe.$$.fragment),cs=a(),wt=n("p"),wt.textContent=fa,ms=a(),p(G.$$.fragment),ps=a(),W=n("div"),p(be.$$.fragment),fs=a(),Tt=n("p"),Tt.innerHTML=ua,us=a(),q=n("div"),p($e.$$.fragment),hs=a(),Ct=n("p"),Ct.textContent=ha,gs=a(),p(R.$$.fragment),_s=a(),V=n("div"),p(ye.$$.fragment),vs=a(),Pt=n("p"),Pt.innerHTML=ga,xs=a(),p(Q.$$.fragment),bs=a(),z=n("div"),p(Me.$$.fragment),$s=a(),kt=n("p"),kt.innerHTML=_a,ys=a(),p(A.$$.fragment),Ms=a(),Y=n("div"),p(we.$$.fragment),ws=a(),It=n("p"),It.textContent=va,Ts=a(),O=n("div"),p(Te.$$.fragment),Cs=a(),Ut=n("p"),Ut.textContent=xa,Ps=a(),K=n("div"),p(Ce.$$.fragment),ks=a(),jt=n("p"),jt.textContent=ba,ir=a(),p(Pe.$$.fragment),dr=a(),ke=n("p"),ke.innerHTML=$a,cr=a(),P=n("div"),p(Ie.$$.fragment),Is=a(),Xt=n("p"),Xt.textContent=ya,Us=a(),ee=n("div"),p(Ue.$$.fragment),js=a(),Lt=n("p"),Lt.innerHTML=Ma,Xs=a(),te=n("div"),p(je.$$.fragment),Ls=a(),Jt=n("p"),Jt.textContent=wa,Js=a(),re=n("div"),p(Xe.$$.fragment),Zs=a(),Zt=n("p"),Zt.textContent=Ta,qs=a(),se=n("div"),p(Le.$$.fragment),Vs=a(),qt=n("p"),qt.innerHTML=Ca,zs=a(),ae=n("div"),p(Je.$$.fragment),Es=a(),Vt=n("p"),Vt.innerHTML=Pa,Hs=a(),oe=n("div"),p(Ze.$$.fragment),Bs=a(),zt=n("p"),zt.textContent=ka,mr=a(),X=n("div"),p(qe.$$.fragment),Ss=a(),Et=n("p"),Et.textContent=Ia,Fs=a(),ne=n("div"),p(Ve.$$.fragment),Ds=a(),Ht=n("p"),Ht.textContent=Ua,pr=a(),L=n("div"),p(ze.$$.fragment),Ns=a(),Bt=n("p"),Bt.textContent=ja,Gs=a(),le=n("div"),p(Ee.$$.fragment),Ws=a(),St=n("p"),St.textContent=Xa,fr=a(),p(He.$$.fragment),ur=a(),Be=n("p"),Be.innerHTML=La,hr=a(),Se=n("p"),Se.textContent=Ja,gr=a(),Fe=n("p"),Fe.textContent=Za,_r=a(),De=n("ul"),De.innerHTML=qa,vr=a(),Ne=n("p"),Ne.innerHTML=Va,xr=a(),B=n("div"),p(Ge.$$.fragment),Rs=a(),Ft=n("p"),Ft.innerHTML=za,br=a(),p(We.$$.fragment),$r=a(),Re=n("p"),Re.innerHTML=Ea,yr=a(),Qe=n("p"),Qe.innerHTML=Ha,Mr=a(),Ae=n("p"),Ae.textContent=Ba,wr=a(),Ye=n("ul"),Ye.innerHTML=Sa,Tr=a(),Oe=n("p"),Oe.textContent=Fa,Cr=a(),Ke=n("p"),Ke.innerHTML=Da,Pr=a(),p(et.$$.fragment),kr=a(),tt=n("p"),tt.innerHTML=Na,Ir=a(),rt=n("p"),rt.textContent=Ga,Ur=a(),p(st.$$.fragment),jr=a(),at=n("p"),at.textContent=Wa,Xr=a(),ot=n("ul"),ot.innerHTML=Ra,Lr=a(),nt=n("p"),nt.innerHTML=Qa,Jr=a(),U=n("div"),p(lt.$$.fragment),Qs=a(),Dt=n("p"),Dt.textContent=Aa,As=a(),ie=n("div"),p(it.$$.fragment),Ys=a(),Nt=n("p"),Nt.textContent=Ya,Os=a(),E=n("div"),p(dt.$$.fragment),Ks=a(),Gt=n("p"),Gt.innerHTML=Oa,ea=a(),p(de.$$.fragment),ta=a(),ce=n("div"),p(ct.$$.fragment),ra=a(),Wt=n("p"),Wt.textContent=Ka,Zr=a(),mt=n("p"),mt.innerHTML=eo,qr=a(),J=n("div"),p(pt.$$.fragment),sa=a(),Rt=n("p"),Rt.textContent=to,aa=a(),p(me.$$.fragment),Vr=a(),ft=n("p"),ft.innerHTML=ro,zr=a(),p(ut.$$.fragment),Er=a(),ht=n("p"),ht.textContent=so,Hr=a(),p(gt.$$.fragment),Br=a(),_t=n("p"),_t.innerHTML=ao,Sr=a(),p(vt.$$.fragment),Fr=a(),xt=n("p"),xt.innerHTML=oo,Dr=a(),tr=n("p"),this.h()},l(e){const r=mo("svelte-u9bgzb",document.head);c=l(r,"META",{name:!0,content:!0}),r.forEach(t),T=o(e),v=l(e,"P",{}),b(v).forEach(t),x=o(e),f(C.$$.fragment,e),m=o(e),k=l(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-8nvl5z"&&(k.textContent=la),sr=o(e),fe=l(e,"UL",{"data-svelte-h":!0}),d(fe)!=="svelte-1r5mt3j"&&(fe.innerHTML=ia),ar=o(e),f(ue.$$.fragment,e),or=o(e),he=l(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-16hpp4n"&&(he.textContent=da),nr=o(e),ge=l(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-x3ucqc"&&(ge.textContent=ca),lr=o(e),y=l(e,"DIV",{class:!0});var w=b(y);f(_e.$$.fragment,w),ns=o(w),yt=l(w,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-1s4wckx"&&(yt.textContent=ma),ls=o(w),N=l(w,"DIV",{class:!0});var bt=b(N);f(ve.$$.fragment,bt),is=o(bt),Mt=l(bt,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-1i2d3vx"&&(Mt.innerHTML=pa),bt.forEach(t),ds=o(w),Z=l(w,"DIV",{class:!0});var S=b(Z);f(xe.$$.fragment,S),cs=o(S),wt=l(S,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1cj8dcb"&&(wt.textContent=fa),ms=o(S),f(G.$$.fragment,S),S.forEach(t),ps=o(w),W=l(w,"DIV",{class:!0});var $t=b(W);f(be.$$.fragment,$t),fs=o($t),Tt=l($t,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-hsvutq"&&(Tt.innerHTML=ua),$t.forEach(t),us=o(w),q=l(w,"DIV",{class:!0});var F=b(q);f($e.$$.fragment,F),hs=o(F),Ct=l(F,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-1cwsjho"&&(Ct.textContent=ha),gs=o(F),f(R.$$.fragment,F),F.forEach(t),_s=o(w),V=l(w,"DIV",{class:!0});var D=b(V);f(ye.$$.fragment,D),vs=o(D),Pt=l(D,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-hhsvto"&&(Pt.innerHTML=ga),xs=o(D),f(Q.$$.fragment,D),D.forEach(t),bs=o(w),z=l(w,"DIV",{class:!0});var Qt=b(z);f(Me.$$.fragment,Qt),$s=o(Qt),kt=l(Qt,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-ta6iw"&&(kt.innerHTML=_a),ys=o(Qt),f(A.$$.fragment,Qt),Qt.forEach(t),Ms=o(w),Y=l(w,"DIV",{class:!0});var Gr=b(Y);f(we.$$.fragment,Gr),ws=o(Gr),It=l(Gr,"P",{"data-svelte-h":!0}),d(It)!=="svelte-1ww3wqq"&&(It.textContent=va),Gr.forEach(t),Ts=o(w),O=l(w,"DIV",{class:!0});var Wr=b(O);f(Te.$$.fragment,Wr),Cs=o(Wr),Ut=l(Wr,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1g70y32"&&(Ut.textContent=xa),Wr.forEach(t),Ps=o(w),K=l(w,"DIV",{class:!0});var Rr=b(K);f(Ce.$$.fragment,Rr),ks=o(Rr),jt=l(Rr,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-5ayq1f"&&(jt.textContent=ba),Rr.forEach(t),w.forEach(t),ir=o(e),f(Pe.$$.fragment,e),dr=o(e),ke=l(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-1wrjssn"&&(ke.innerHTML=$a),cr=o(e),P=l(e,"DIV",{class:!0});var I=b(P);f(Ie.$$.fragment,I),Is=o(I),Xt=l(I,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-1bsw04k"&&(Xt.textContent=ya),Us=o(I),ee=l(I,"DIV",{class:!0});var Qr=b(ee);f(Ue.$$.fragment,Qr),js=o(Qr),Lt=l(Qr,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1v5o80n"&&(Lt.innerHTML=Ma),Qr.forEach(t),Xs=o(I),te=l(I,"DIV",{class:!0});var Ar=b(te);f(je.$$.fragment,Ar),Ls=o(Ar),Jt=l(Ar,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-pplryq"&&(Jt.textContent=wa),Ar.forEach(t),Js=o(I),re=l(I,"DIV",{class:!0});var Yr=b(re);f(Xe.$$.fragment,Yr),Zs=o(Yr),Zt=l(Yr,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-3oqyjr"&&(Zt.textContent=Ta),Yr.forEach(t),qs=o(I),se=l(I,"DIV",{class:!0});var Or=b(se);f(Le.$$.fragment,Or),Vs=o(Or),qt=l(Or,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-p21oym"&&(qt.innerHTML=Ca),Or.forEach(t),zs=o(I),ae=l(I,"DIV",{class:!0});var Kr=b(ae);f(Je.$$.fragment,Kr),Es=o(Kr),Vt=l(Kr,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-derqnc"&&(Vt.innerHTML=Pa),Kr.forEach(t),Hs=o(I),oe=l(I,"DIV",{class:!0});var es=b(oe);f(Ze.$$.fragment,es),Bs=o(es),zt=l(es,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-1jevh15"&&(zt.textContent=ka),es.forEach(t),I.forEach(t),mr=o(e),X=l(e,"DIV",{class:!0});var At=b(X);f(qe.$$.fragment,At),Ss=o(At),Et=l(At,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-vkt0pi"&&(Et.textContent=Ia),Fs=o(At),ne=l(At,"DIV",{class:!0});var ts=b(ne);f(Ve.$$.fragment,ts),Ds=o(ts),Ht=l(ts,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-5ayq1f"&&(Ht.textContent=Ua),ts.forEach(t),At.forEach(t),pr=o(e),L=l(e,"DIV",{class:!0});var Yt=b(L);f(ze.$$.fragment,Yt),Ns=o(Yt),Bt=l(Yt,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-168wf64"&&(Bt.textContent=ja),Gs=o(Yt),le=l(Yt,"DIV",{class:!0});var rs=b(le);f(Ee.$$.fragment,rs),Ws=o(rs),St=l(rs,"P",{"data-svelte-h":!0}),d(St)!=="svelte-5ayq1f"&&(St.textContent=Xa),rs.forEach(t),Yt.forEach(t),fr=o(e),f(He.$$.fragment,e),ur=o(e),Be=l(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-pgkk87"&&(Be.innerHTML=La),hr=o(e),Se=l(e,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-1iz8kjk"&&(Se.textContent=Ja),gr=o(e),Fe=l(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-ejlsq2"&&(Fe.textContent=Za),_r=o(e),De=l(e,"UL",{"data-svelte-h":!0}),d(De)!=="svelte-my8qym"&&(De.innerHTML=qa),vr=o(e),Ne=l(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-ctpr69"&&(Ne.innerHTML=Va),xr=o(e),B=l(e,"DIV",{class:!0});var ss=b(B);f(Ge.$$.fragment,ss),Rs=o(ss),Ft=l(ss,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-5lvrve"&&(Ft.innerHTML=za),ss.forEach(t),br=o(e),f(We.$$.fragment,e),$r=o(e),Re=l(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-9mlx1z"&&(Re.innerHTML=Ea),yr=o(e),Qe=l(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1qabksm"&&(Qe.innerHTML=Ha),Mr=o(e),Ae=l(e,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-uho2qa"&&(Ae.textContent=Ba),wr=o(e),Ye=l(e,"UL",{"data-svelte-h":!0}),d(Ye)!=="svelte-1e2xq99"&&(Ye.innerHTML=Sa),Tr=o(e),Oe=l(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-sz5yy2"&&(Oe.textContent=Fa),Cr=o(e),Ke=l(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-1mss3di"&&(Ke.innerHTML=Da),Pr=o(e),f(et.$$.fragment,e),kr=o(e),tt=l(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1i4abtq"&&(tt.innerHTML=Na),Ir=o(e),rt=l(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-zxdzom"&&(rt.textContent=Ga),Ur=o(e),f(st.$$.fragment,e),jr=o(e),at=l(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-ejlsq2"&&(at.textContent=Wa),Xr=o(e),ot=l(e,"UL",{"data-svelte-h":!0}),d(ot)!=="svelte-1qiv3qf"&&(ot.innerHTML=Ra),Lr=o(e),nt=l(e,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-1r22nj6"&&(nt.innerHTML=Qa),Jr=o(e),U=l(e,"DIV",{class:!0});var H=b(U);f(lt.$$.fragment,H),Qs=o(H),Dt=l(H,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-173gxyd"&&(Dt.textContent=Aa),As=o(H),ie=l(H,"DIV",{class:!0});var as=b(ie);f(it.$$.fragment,as),Ys=o(as),Nt=l(as,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-wmaktk"&&(Nt.textContent=Ya),as.forEach(t),Os=o(H),E=l(H,"DIV",{class:!0});var Ot=b(E);f(dt.$$.fragment,Ot),Ks=o(Ot),Gt=l(Ot,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-11nqnea"&&(Gt.innerHTML=Oa),ea=o(Ot),f(de.$$.fragment,Ot),Ot.forEach(t),ta=o(H),ce=l(H,"DIV",{class:!0});var os=b(ce);f(ct.$$.fragment,os),ra=o(os),Wt=l(os,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-d5zv1x"&&(Wt.textContent=Ka),os.forEach(t),H.forEach(t),Zr=o(e),mt=l(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-12wzh89"&&(mt.innerHTML=eo),qr=o(e),J=l(e,"DIV",{class:!0});var Kt=b(J);f(pt.$$.fragment,Kt),sa=o(Kt),Rt=l(Kt,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-169nh0g"&&(Rt.textContent=to),aa=o(Kt),f(me.$$.fragment,Kt),Kt.forEach(t),Vr=o(e),ft=l(e,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-2mj9lk"&&(ft.innerHTML=ro),zr=o(e),f(ut.$$.fragment,e),Er=o(e),ht=l(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1q119ra"&&(ht.textContent=so),Hr=o(e),f(gt.$$.fragment,e),Br=o(e),_t=l(e,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-9ecb4t"&&(_t.innerHTML=ao),Sr=o(e),f(vt.$$.fragment,e),Fr=o(e),xt=l(e,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-8lr0dh"&&(xt.innerHTML=oo),Dr=o(e),tr=l(e,"P",{}),b(tr).forEach(t),this.h()},h(){$(c,"name","hf:doc:metadata"),$(c,"content",xo),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){s(document.head,c),i(e,T,r),i(e,v,r),i(e,x,r),u(C,e,r),i(e,m,r),i(e,k,r),i(e,sr,r),i(e,fe,r),i(e,ar,r),u(ue,e,r),i(e,or,r),i(e,he,r),i(e,nr,r),i(e,ge,r),i(e,lr,r),i(e,y,r),u(_e,y,null),s(y,ns),s(y,yt),s(y,ls),s(y,N),u(ve,N,null),s(N,is),s(N,Mt),s(y,ds),s(y,Z),u(xe,Z,null),s(Z,cs),s(Z,wt),s(Z,ms),u(G,Z,null),s(y,ps),s(y,W),u(be,W,null),s(W,fs),s(W,Tt),s(y,us),s(y,q),u($e,q,null),s(q,hs),s(q,Ct),s(q,gs),u(R,q,null),s(y,_s),s(y,V),u(ye,V,null),s(V,vs),s(V,Pt),s(V,xs),u(Q,V,null),s(y,bs),s(y,z),u(Me,z,null),s(z,$s),s(z,kt),s(z,ys),u(A,z,null),s(y,Ms),s(y,Y),u(we,Y,null),s(Y,ws),s(Y,It),s(y,Ts),s(y,O),u(Te,O,null),s(O,Cs),s(O,Ut),s(y,Ps),s(y,K),u(Ce,K,null),s(K,ks),s(K,jt),i(e,ir,r),u(Pe,e,r),i(e,dr,r),i(e,ke,r),i(e,cr,r),i(e,P,r),u(Ie,P,null),s(P,Is),s(P,Xt),s(P,Us),s(P,ee),u(Ue,ee,null),s(ee,js),s(ee,Lt),s(P,Xs),s(P,te),u(je,te,null),s(te,Ls),s(te,Jt),s(P,Js),s(P,re),u(Xe,re,null),s(re,Zs),s(re,Zt),s(P,qs),s(P,se),u(Le,se,null),s(se,Vs),s(se,qt),s(P,zs),s(P,ae),u(Je,ae,null),s(ae,Es),s(ae,Vt),s(P,Hs),s(P,oe),u(Ze,oe,null),s(oe,Bs),s(oe,zt),i(e,mr,r),i(e,X,r),u(qe,X,null),s(X,Ss),s(X,Et),s(X,Fs),s(X,ne),u(Ve,ne,null),s(ne,Ds),s(ne,Ht),i(e,pr,r),i(e,L,r),u(ze,L,null),s(L,Ns),s(L,Bt),s(L,Gs),s(L,le),u(Ee,le,null),s(le,Ws),s(le,St),i(e,fr,r),u(He,e,r),i(e,ur,r),i(e,Be,r),i(e,hr,r),i(e,Se,r),i(e,gr,r),i(e,Fe,r),i(e,_r,r),i(e,De,r),i(e,vr,r),i(e,Ne,r),i(e,xr,r),i(e,B,r),u(Ge,B,null),s(B,Rs),s(B,Ft),i(e,br,r),u(We,e,r),i(e,$r,r),i(e,Re,r),i(e,yr,r),i(e,Qe,r),i(e,Mr,r),i(e,Ae,r),i(e,wr,r),i(e,Ye,r),i(e,Tr,r),i(e,Oe,r),i(e,Cr,r),i(e,Ke,r),i(e,Pr,r),u(et,e,r),i(e,kr,r),i(e,tt,r),i(e,Ir,r),i(e,rt,r),i(e,Ur,r),u(st,e,r),i(e,jr,r),i(e,at,r),i(e,Xr,r),i(e,ot,r),i(e,Lr,r),i(e,nt,r),i(e,Jr,r),i(e,U,r),u(lt,U,null),s(U,Qs),s(U,Dt),s(U,As),s(U,ie),u(it,ie,null),s(ie,Ys),s(ie,Nt),s(U,Os),s(U,E),u(dt,E,null),s(E,Ks),s(E,Gt),s(E,ea),u(de,E,null),s(U,ta),s(U,ce),u(ct,ce,null),s(ce,ra),s(ce,Wt),i(e,Zr,r),i(e,mt,r),i(e,qr,r),i(e,J,r),u(pt,J,null),s(J,sa),s(J,Rt),s(J,aa),u(me,J,null),i(e,Vr,r),i(e,ft,r),i(e,zr,r),u(ut,e,r),i(e,Er,r),i(e,ht,r),i(e,Hr,r),u(gt,e,r),i(e,Br,r),i(e,_t,r),i(e,Sr,r),u(vt,e,r),i(e,Fr,r),i(e,xt,r),i(e,Dr,r),i(e,tr,r),Nr=!0},p(e,[r]){const w={};r&2&&(w.$$scope={dirty:r,ctx:e}),G.$set(w);const bt={};r&2&&(bt.$$scope={dirty:r,ctx:e}),R.$set(bt);const S={};r&2&&(S.$$scope={dirty:r,ctx:e}),Q.$set(S);const $t={};r&2&&($t.$$scope={dirty:r,ctx:e}),A.$set($t);const F={};r&2&&(F.$$scope={dirty:r,ctx:e}),de.$set(F);const D={};r&2&&(D.$$scope={dirty:r,ctx:e}),me.$set(D)},i(e){Nr||(h(C.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h(G.$$.fragment,e),h(be.$$.fragment,e),h($e.$$.fragment,e),h(R.$$.fragment,e),h(ye.$$.fragment,e),h(Q.$$.fragment,e),h(Me.$$.fragment,e),h(A.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h(Pe.$$.fragment,e),h(Ie.$$.fragment,e),h(Ue.$$.fragment,e),h(je.$$.fragment,e),h(Xe.$$.fragment,e),h(Le.$$.fragment,e),h(Je.$$.fragment,e),h(Ze.$$.fragment,e),h(qe.$$.fragment,e),h(Ve.$$.fragment,e),h(ze.$$.fragment,e),h(Ee.$$.fragment,e),h(He.$$.fragment,e),h(Ge.$$.fragment,e),h(We.$$.fragment,e),h(et.$$.fragment,e),h(st.$$.fragment,e),h(lt.$$.fragment,e),h(it.$$.fragment,e),h(dt.$$.fragment,e),h(de.$$.fragment,e),h(ct.$$.fragment,e),h(pt.$$.fragment,e),h(me.$$.fragment,e),h(ut.$$.fragment,e),h(gt.$$.fragment,e),h(vt.$$.fragment,e),Nr=!0)},o(e){g(C.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(xe.$$.fragment,e),g(G.$$.fragment,e),g(be.$$.fragment,e),g($e.$$.fragment,e),g(R.$$.fragment,e),g(ye.$$.fragment,e),g(Q.$$.fragment,e),g(Me.$$.fragment,e),g(A.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(Pe.$$.fragment,e),g(Ie.$$.fragment,e),g(Ue.$$.fragment,e),g(je.$$.fragment,e),g(Xe.$$.fragment,e),g(Le.$$.fragment,e),g(Je.$$.fragment,e),g(Ze.$$.fragment,e),g(qe.$$.fragment,e),g(Ve.$$.fragment,e),g(ze.$$.fragment,e),g(Ee.$$.fragment,e),g(He.$$.fragment,e),g(Ge.$$.fragment,e),g(We.$$.fragment,e),g(et.$$.fragment,e),g(st.$$.fragment,e),g(lt.$$.fragment,e),g(it.$$.fragment,e),g(dt.$$.fragment,e),g(de.$$.fragment,e),g(ct.$$.fragment,e),g(pt.$$.fragment,e),g(me.$$.fragment,e),g(ut.$$.fragment,e),g(gt.$$.fragment,e),g(vt.$$.fragment,e),Nr=!1},d(e){e&&(t(T),t(v),t(x),t(m),t(k),t(sr),t(fe),t(ar),t(or),t(he),t(nr),t(ge),t(lr),t(y),t(ir),t(dr),t(ke),t(cr),t(P),t(mr),t(X),t(pr),t(L),t(fr),t(ur),t(Be),t(hr),t(Se),t(gr),t(Fe),t(_r),t(De),t(vr),t(Ne),t(xr),t(B),t(br),t($r),t(Re),t(yr),t(Qe),t(Mr),t(Ae),t(wr),t(Ye),t(Tr),t(Oe),t(Cr),t(Ke),t(Pr),t(kr),t(tt),t(Ir),t(rt),t(Ur),t(jr),t(at),t(Xr),t(ot),t(Lr),t(nt),t(Jr),t(U),t(Zr),t(mt),t(qr),t(J),t(Vr),t(ft),t(zr),t(Er),t(ht),t(Hr),t(Br),t(_t),t(Sr),t(Fr),t(xt),t(Dr),t(tr)),t(c),_(C,e),_(ue,e),_(_e),_(ve),_(xe),_(G),_(be),_($e),_(R),_(ye),_(Q),_(Me),_(A),_(we),_(Te),_(Ce),_(Pe,e),_(Ie),_(Ue),_(je),_(Xe),_(Le),_(Je),_(Ze),_(qe),_(Ve),_(ze),_(Ee),_(He,e),_(Ge),_(We,e),_(et,e),_(st,e),_(lt),_(it),_(dt),_(de),_(ct),_(pt),_(me),_(ut,e),_(gt,e),_(vt,e)}}}const xo='{"title":"Processors","local":"processors","sections":[{"title":"Multi-modal processors","local":"transformers.ProcessorMixin","sections":[],"depth":2},{"title":"Deprecated processors","local":"transformers.DataProcessor","sections":[],"depth":2},{"title":"GLUE","local":"transformers.glue_convert_examples_to_features","sections":[],"depth":2},{"title":"XNLI","local":"xnli","sections":[],"depth":2},{"title":"SQuAD","local":"squad","sections":[{"title":"Processors","local":"transformers.data.processors.squad.SquadProcessor","sections":[],"depth":3},{"title":"Example usage","local":"example-usage","sections":[],"depth":3}],"depth":2}],"depth":1}';function bo(j){return lo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ko extends io{constructor(c){super(),co(this,c,bo,vo,no,{})}}export{ko as component};
