import{s as Ws,o as Fs,n as Jt}from"../chunks/scheduler.25b97de1.js";import{S as Vs,i as Is,g as l,s as o,r as p,A as Bs,h as i,f as s,c as n,j,u as m,x as _,k as J,y as a,a as r,v as h,d as f,t as u,w as g}from"../chunks/index.d9030fc9.js";import{T as Us}from"../chunks/Tip.baa67368.js";import{D as z}from"../chunks/Docstring.ffac8efa.js";import{C as jt}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Zs}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as B,E as Ls}from"../chunks/EditOnGithub.91d95064.js";function Gs(Z){let c,k="Example:",T,v,y;return v=new jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaDJUZXh0MkNvbmZpZyUyQyUyMFNwZWVjaDJUZXh0MkZvckNhdXNhbExNJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFNwZWVjaDJUZXh0MiUyMHMydF90cmFuc2Zvcm1lcl9zJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFNwZWVjaDJUZXh0MkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBzMnRfdHJhbnNmb3JtZXJfcyUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwU3BlZWNoMlRleHQyRm9yQ2F1c2FsTE0oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Speech2Text2Config, Speech2Text2ForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Speech2Text2 s2t_transformer_s style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Speech2Text2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the s2t_transformer_s style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Speech2Text2ForCausalLM(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=l("p"),c.textContent=k,T=o(),p(v.$$.fragment)},l(d){c=i(d,"P",{"data-svelte-h":!0}),_(c)!=="svelte-11lpom8"&&(c.textContent=k),T=n(d),m(v.$$.fragment,d)},m(d,w){r(d,c,w),r(d,T,w),h(v,d,w),y=!0},p:Jt,i(d){y||(f(v.$$.fragment,d),y=!0)},o(d){u(v.$$.fragment,d),y=!1},d(d){d&&(s(c),s(T)),g(v,d)}}}function Ns(Z){let c,k=`This class method is simply calling the feature extractor
<a href="/docs/transformers/v4.41.0/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/v4.41.0/en/internal/image_processing_utils#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=l("p"),c.innerHTML=k},l(T){c=i(T,"P",{"data-svelte-h":!0}),_(c)!=="svelte-g21k9l"&&(c.innerHTML=k)},m(T,v){r(T,c,v)},p:Jt,d(T){T&&s(c)}}}function Es(Z){let c,k=`This class method is simply calling <a href="/docs/transformers/v4.41.0/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.41.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=l("p"),c.innerHTML=k},l(T){c=i(T,"P",{"data-svelte-h":!0}),_(c)!=="svelte-cs18be"&&(c.innerHTML=k)},m(T,v){r(T,c,v)},p:Jt,d(T){T&&s(c)}}}function qs(Z){let c,k="Example:",T,v,y;return v=new jt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SpeechEncoderDecoderModel,
<span class="hljs-meta">... </span>    Speech2Text2ForCausalLM,
<span class="hljs-meta">... </span>    Wav2Vec2Model,
<span class="hljs-meta">... </span>    Speech2Text2Config,
<span class="hljs-meta">... </span>    Wav2Vec2Config,
<span class="hljs-meta">... </span>    Wav2Vec2FeatureExtractor,
<span class="hljs-meta">... </span>    Speech2Text2Tokenizer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = Wav2Vec2FeatureExtractor()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = Speech2Text2Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/s2t-wav2vec2-large-en-de&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder = Wav2Vec2Model(Wav2Vec2Config())
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = Speech2Text2ForCausalLM(Speech2Text2Config())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># init random speech2text model</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechEncoderDecoderModel(encoder=encoder, decoder=decoder)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = tokenizer.pad_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.decoder_start_token_id = tokenizer.bos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># pre-process inputs and labels</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = inputs.input_values
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(inputs=input_values, labels=decoder_input_ids).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># backprop loss</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()`,wrap:!1}}),{c(){c=l("p"),c.textContent=k,T=o(),p(v.$$.fragment)},l(d){c=i(d,"P",{"data-svelte-h":!0}),_(c)!=="svelte-11lpom8"&&(c.textContent=k),T=n(d),m(v.$$.fragment,d)},m(d,w){r(d,c,w),r(d,T,w),h(v,d,w),y=!0},p:Jt,i(d){y||(f(v.$$.fragment,d),y=!0)},o(d){u(v.$$.fragment,d),y=!1},d(d){d&&(s(c),s(T)),g(v,d)}}}function Hs(Z){let c,k,T,v,y,d,w,De,Q,ns=`The Speech2Text2 model is used together with <a href="wav2vec2">Wav2Vec2</a> for Speech Translation models proposed in
<a href="https://arxiv.org/abs/2104.06678" rel="nofollow">Large-Scale Self- and Semi-Supervised Learning for Speech Translation</a> by
Changhan Wang, Anne Wu, Juan Pino, Alexei Baevski, Michael Auli, Alexis Conneau.`,Ae,D,as=`Speech2Text2 is a <em>decoder-only</em> transformer model that can be used with any speech <em>encoder-only</em>, such as
<a href="wav2vec2">Wav2Vec2</a> or <a href="hubert">HuBERT</a> for Speech-to-Text tasks. Please refer to the
<a href="speech-encoder-decoder">SpeechEncoderDecoder</a> class on how to combine Speech2Text2 with any speech <em>encoder-only</em>
model.`,Oe,A,rs='This model was contributed by <a href="https://huggingface.co/patrickvonplaten" rel="nofollow">Patrick von Platen</a>.',Ke,O,ls='The original code can be found <a href="https://github.com/pytorch/fairseq/blob/1f7ef9ed1e1061f8c7f88f8b94c7186834398690/fairseq/models/wav2vec/wav2vec2_asr.py#L266" rel="nofollow">here</a>.',et,K,tt,ee,is=`<li>Speech2Text2 achieves state-of-the-art results on the CoVoST Speech Translation dataset. For more information, see
the <a href="https://huggingface.co/models?other=speech2text2" rel="nofollow">official models</a> .</li> <li>Speech2Text2 is always used within the <a href="speech-encoder-decoder">SpeechEncoderDecoder</a> framework.</li> <li>Speech2Text2’s tokenizer is based on <a href="https://github.com/glample/fastBPE" rel="nofollow">fastBPE</a>.</li>`,st,te,ot,se,cs=`Speech2Text2’s <a href="/docs/transformers/v4.41.0/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderModel">SpeechEncoderDecoderModel</a> model accepts raw waveform input values from speech and
makes use of <a href="/docs/transformers/v4.41.0/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> to translate the input speech
autoregressively to the target language.`,nt,oe,ds=`The <a href="/docs/transformers/v4.41.0/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> class is responsible for preprocessing the input speech and
<a href="/docs/transformers/v4.41.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a> decodes the generated target tokens to the target string. The
<a href="/docs/transformers/v4.41.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor">Speech2Text2Processor</a> wraps <a href="/docs/transformers/v4.41.0/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> and
<a href="/docs/transformers/v4.41.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a> into a single instance to both extract the input features and decode the
predicted token ids.`,at,ne,ps="<li>Step-by-step Speech Translation</li>",rt,ae,lt,re,ms="<li><p>Speech Translation via Pipelines</p> <p>The automatic speech recognition pipeline can also be used to translate speech in just a couple lines of code</p></li>",it,le,ct,ie,hs='See <a href="https://huggingface.co/models?filter=speech2text2" rel="nofollow">model hub</a> to look for Speech2Text2 checkpoints.',dt,ce,pt,de,fs='<li><a href="../tasks/language_modeling">Causal language modeling task guide</a></li>',mt,pe,ht,C,me,Ct,Se,us=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.41.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2ForCausalLM">Speech2Text2ForCausalLM</a>. It is used to
instantiate an Speech2Text2 model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the Speech2Text2
<a href="https://huggingface.co/facebook/s2t-wav2vec2-large-en-de" rel="nofollow">facebook/s2t-wav2vec2-large-en-de</a> architecture.`,St,ze,gs=`Configuration objects inherit from <a href="/docs/transformers/v4.41.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.41.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,zt,L,ft,he,ut,x,fe,Ut,Ue,_s="Constructs a Speech2Text2Tokenizer.",Zt,Ze,Ts=`This tokenizer inherits from <a href="/docs/transformers/v4.41.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains some of the main methods. Users should refer to
the superclass for more information regarding such methods.`,Wt,G,ue,Ft,We,vs="Convert a list of lists of token ids into a list of strings by calling decode.",Vt,W,ge,It,Fe,bs=`Converts a sequence of ids in a string, using the tokenizer and vocabulary with options to remove special
tokens and clean up tokenization spaces.`,Bt,Ve,ys="Similar to doing <code>self.convert_tokens_to_string(self.convert_ids_to_tokens(token_ids))</code>.",Lt,Ie,_e,gt,Te,_t,b,ve,Gt,Be,xs=`Constructs a Speech2Text2 processor which wraps a Speech2Text2 feature extractor and a Speech2Text2 tokenizer into
a single processor.`,Nt,Le,ks=`<a href="/docs/transformers/v4.41.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor">Speech2Text2Processor</a> offers all the functionalities of <a href="/docs/transformers/v4.41.0/en/model_doc/auto#transformers.AutoFeatureExtractor">AutoFeatureExtractor</a> and <a href="/docs/transformers/v4.41.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a>.
See the <a href="/docs/transformers/v4.41.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor.__call__"><strong>call</strong>()</a> and <a href="/docs/transformers/v4.41.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor.decode">decode()</a> for more information.`,Et,N,be,qt,Ge,Ms=`When used in normal mode, this method forwards all its arguments to AutoFeatureExtractor’s
<code>__call__()</code> and returns its output. If used in the context
<code>as_target_processor()</code> this method forwards all its arguments to
Speech2Text2Tokenizer’s <a href="/docs/transformers/v4.41.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__"><strong>call</strong>()</a>. Please refer to the doctsring of the above two
methods for more information.`,Ht,F,ye,Rt,Ne,ws="Instantiate a processor associated with a pretrained model.",Xt,E,Pt,V,xe,Yt,Ee,$s=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/v4.41.0/en/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,Qt,q,Dt,H,ke,At,qe,js=`This method forwards all its arguments to Speech2Text2Tokenizer’s <a href="/docs/transformers/v4.41.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,Ot,R,Me,Kt,He,Js=`This method forwards all its arguments to Speech2Text2Tokenizer’s <a href="/docs/transformers/v4.41.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer
to the docstring of this method for more information.`,Tt,we,vt,S,$e,es,Re,Cs=`The Speech2Text2 Decoder with a language modeling head. Can be used as the decoder part of <a href="/docs/transformers/v4.41.0/en/model_doc/encoder-decoder#transformers.EncoderDecoderModel">EncoderDecoderModel</a> and <code>SpeechEncoderDecoder</code>.
This model inherits from <a href="/docs/transformers/v4.41.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ts,Xe,Ss=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ss,X,je,os,P,bt,Je,yt,Qe,xt;return y=new B({props:{title:"Speech2Text2",local:"speech2text2",headingTag:"h1"}}),w=new B({props:{title:"Overview",local:"overview",headingTag:"h2"}}),K=new B({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),te=new B({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ae=new jt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwU3BlZWNoMlRleHQyUHJvY2Vzc29yJTJDJTIwU3BlZWNoRW5jb2RlckRlY29kZXJNb2RlbCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHNvdW5kZmlsZSUyMGFzJTIwc2YlMEElMEFtb2RlbCUyMCUzRCUyMFNwZWVjaEVuY29kZXJEZWNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGczJ0LXdhdjJ2ZWMyLWxhcmdlLWVuLWRlJTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaDJUZXh0MlByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZzMnQtd2F2MnZlYzItbGFyZ2UtZW4tZGUlMjIpJTBBJTBBJTBBZGVmJTIwbWFwX3RvX2FycmF5KGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMHNwZWVjaCUyQyUyMF8lMjAlM0QlMjBzZi5yZWFkKGJhdGNoJTVCJTIyZmlsZSUyMiU1RCklMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnNwZWVjaCUyMiU1RCUyMCUzRCUyMHNwZWVjaCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJhdGNoJTBBJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRzJTIwJTNEJTIwZHMubWFwKG1hcF90b19hcnJheSklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIlMjJzcGVlY2glMjIlNUQlNUIwJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0cyU1QiUyMmlucHV0X3ZhbHVlcyUyMiU1RCUyQyUyMGF0dGVudGlvbl9tYXNrJTNEaW5wdXRzJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlNUQpJTBBJTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Speech2Text2Processor, SpeechEncoderDecoderModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;facebook/s2t-wav2vec2-large-en-de&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Speech2Text2Processor.from_pretrained(<span class="hljs-string">&quot;facebook/s2t-wav2vec2-large-en-de&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], sampling_rate=<span class="hljs-number">16_000</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=inputs[<span class="hljs-string">&quot;input_values&quot;</span>], attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids)`,wrap:!1}}),le=new jt({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbGlicmlzcGVlY2hfZW4lMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWFzciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGczJ0LXdhdjJ2ZWMyLWxhcmdlLWVuLWRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0QlMjJmYWNlYm9vayUyRnMydC13YXYydmVjMi1sYXJnZS1lbi1kZSUyMiUyQyUwQSklMEElMEF0cmFuc2xhdGlvbl9kZSUyMCUzRCUyMGFzcihsaWJyaXNwZWVjaF9lbiU1QjAlNUQlNUIlMjJmaWxlJTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>librispeech_en = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>asr = pipeline(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;facebook/s2t-wav2vec2-large-en-de&quot;</span>,
<span class="hljs-meta">... </span>    feature_extractor=<span class="hljs-string">&quot;facebook/s2t-wav2vec2-large-en-de&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>translation_de = asr(librispeech_en[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;file&quot;</span>])`,wrap:!1}}),ce=new B({props:{title:"Resources",local:"resources",headingTag:"h2"}}),pe=new B({props:{title:"Speech2Text2Config",local:"transformers.Speech2Text2Config",headingTag:"h2"}}),me=new z({props:{name:"class transformers.Speech2Text2Config",anchor:"transformers.Speech2Text2Config",parameters:[{name:"vocab_size",val:" = 10000"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 2048"},{name:"decoder_attention_heads",val:" = 4"},{name:"decoder_layerdrop",val:" = 0.0"},{name:"use_cache",val:" = True"},{name:"activation_function",val:" = 'relu'"},{name:"d_model",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"decoder_start_token_id",val:" = 2"},{name:"scale_embedding",val:" = True"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"max_target_positions",val:" = 1024"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 50265) &#x2014;
Vocabulary size of the Speech2Text model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.41.0/en/model_doc/speech_to_text#transformers.Speech2TextModel">Speech2TextModel</a>`,name:"vocab_size"},{anchor:"transformers.Speech2Text2Config.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.Speech2Text2Config.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.Speech2Text2Config.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.Speech2Text2Config.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.Speech2Text2Config.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the pooler. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.Speech2Text2Config.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, and pooler.`,name:"dropout"},{anchor:"transformers.Speech2Text2Config.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Speech2Text2Config.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.Speech2Text2Config.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.
<a href="https://arxiv.org/abs/1909.11556%3E%60" rel="nofollow">https://arxiv.org/abs/1909.11556&gt;\`</a>__ for more details.`,name:"init_std"},{anchor:"transformers.Speech2Text2Config.decoder_layerdrop",description:`<strong>decoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"decoder_layerdrop"},{anchor:"transformers.Speech2Text2Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.Speech2Text2Config.max_target_positions",description:`<strong>max_target_positions</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_target_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/speech_to_text_2/configuration_speech_to_text_2.py#L24"}}),L=new Zs({props:{anchor:"transformers.Speech2Text2Config.example",$$slots:{default:[Gs]},$$scope:{ctx:Z}}}),he=new B({props:{title:"Speech2TextTokenizer",local:"transformers.Speech2Text2Tokenizer",headingTag:"h2"}}),fe=new z({props:{name:"class transformers.Speech2Text2Tokenizer",anchor:"transformers.Speech2Text2Tokenizer",parameters:[{name:"vocab_file",val:""},{name:"bos_token",val:" = '<s>'"},{name:"pad_token",val:" = '<pad>'"},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"do_lower_case",val:" = False"},{name:"merges_file",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Tokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.Speech2Text2Tokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sentence token.`,name:"bos_token"},{anchor:"transformers.Speech2Text2Tokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sentence token.`,name:"eos_token"},{anchor:"transformers.Speech2Text2Tokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.Speech2Text2Tokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.</p>
<p>**kwargs &#x2014;
Additional keyword arguments passed along to <a href="/docs/transformers/v4.41.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>`,name:"pad_token"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/speech_to_text_2/tokenization_speech_to_text_2.py#L55"}}),ue=new z({props:{name:"batch_decode",anchor:"transformers.Speech2Text2Tokenizer.batch_decode",parameters:[{name:"sequences",val:": Union"},{name:"skip_special_tokens",val:": bool = False"},{name:"clean_up_tokenization_spaces",val:": bool = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Tokenizer.batch_decode.sequences",description:`<strong>sequences</strong> (<code>Union[List[int], List[List[int]], np.ndarray, torch.Tensor, tf.Tensor]</code>) &#x2014;
List of tokenized input ids. Can be obtained using the <code>__call__</code> method.`,name:"sequences"},{anchor:"transformers.Speech2Text2Tokenizer.batch_decode.skip_special_tokens",description:`<strong>skip_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to remove special tokens in the decoding.`,name:"skip_special_tokens"},{anchor:"transformers.Speech2Text2Tokenizer.batch_decode.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to clean up the tokenization spaces. If <code>None</code>, will default to
<code>self.clean_up_tokenization_spaces</code>.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.Speech2Text2Tokenizer.batch_decode.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Will be passed to the underlying model specific decode method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/tokenization_utils_base.py#L3772",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The list of decoded sentences.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),ge=new z({props:{name:"decode",anchor:"transformers.Speech2Text2Tokenizer.decode",parameters:[{name:"token_ids",val:": Union"},{name:"skip_special_tokens",val:": bool = False"},{name:"clean_up_tokenization_spaces",val:": bool = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Tokenizer.decode.token_ids",description:`<strong>token_ids</strong> (<code>Union[int, List[int], np.ndarray, torch.Tensor, tf.Tensor]</code>) &#x2014;
List of tokenized input ids. Can be obtained using the <code>__call__</code> method.`,name:"token_ids"},{anchor:"transformers.Speech2Text2Tokenizer.decode.skip_special_tokens",description:`<strong>skip_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to remove special tokens in the decoding.`,name:"skip_special_tokens"},{anchor:"transformers.Speech2Text2Tokenizer.decode.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to clean up the tokenization spaces. If <code>None</code>, will default to
<code>self.clean_up_tokenization_spaces</code>.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.Speech2Text2Tokenizer.decode.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Will be passed to the underlying model specific decode method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/tokenization_utils_base.py#L3806",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The decoded sentence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),_e=new z({props:{name:"save_vocabulary",anchor:"transformers.Speech2Text2Tokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/speech_to_text_2/tokenization_speech_to_text_2.py#L220"}}),Te=new B({props:{title:"Speech2Text2Processor",local:"transformers.Speech2Text2Processor",headingTag:"h2"}}),ve=new z({props:{name:"class transformers.Speech2Text2Processor",anchor:"transformers.Speech2Text2Processor",parameters:[{name:"feature_extractor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Processor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>AutoFeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.41.0/en/model_doc/auto#transformers.AutoFeatureExtractor">AutoFeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.Speech2Text2Processor.tokenizer",description:`<strong>tokenizer</strong> (<code>Speech2Text2Tokenizer</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.41.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a>. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/speech_to_text_2/processing_speech_to_text_2.py#L24"}}),be=new z({props:{name:"__call__",anchor:"transformers.Speech2Text2Processor.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/speech_to_text_2/processing_speech_to_text_2.py#L47"}}),ye=new z({props:{name:"from_pretrained",anchor:"transformers.Speech2Text2Processor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Processor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/v4.41.0/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/v4.41.0/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/processing_utils.py#L406"}}),E=new Us({props:{$$slots:{default:[Ns]},$$scope:{ctx:Z}}}),xe=new z({props:{name:"save_pretrained",anchor:"transformers.Speech2Text2Processor.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Processor.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.Speech2Text2Processor.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.Speech2Text2Processor.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.41.0/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/processing_utils.py#L167"}}),q=new Us({props:{$$slots:{default:[Es]},$$scope:{ctx:Z}}}),ke=new z({props:{name:"batch_decode",anchor:"transformers.Speech2Text2Processor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/speech_to_text_2/processing_speech_to_text_2.py#L86"}}),Me=new z({props:{name:"decode",anchor:"transformers.Speech2Text2Processor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/speech_to_text_2/processing_speech_to_text_2.py#L93"}}),we=new B({props:{title:"Speech2Text2ForCausalLM",local:"transformers.Speech2Text2ForCausalLM",headingTag:"h2"}}),$e=new z({props:{name:"class transformers.Speech2Text2ForCausalLM",anchor:"transformers.Speech2Text2ForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2ForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Config">Speech2Text2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.41.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/speech_to_text_2/modeling_speech_to_text_2.py#L688"}}),je=new z({props:{name:"forward",anchor:"transformers.Speech2Text2ForCausalLM.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"cross_attn_head_mask",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Speech2Text2ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you
provide it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.41.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a>. See <a href="/docs/transformers/v4.41.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.41.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong>  (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention
if the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used
in the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:`,name:"encoder_attention_mask"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of
shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>. The two additional
tensors are only required when the model is used as a decoder in a Sequence to Sequence model.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the
cross-attention blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those
that don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of
all <code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding
(see <code>past_key_values</code>).</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"use_cache"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.41.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.41.0/src/transformers/models/speech_to_text_2/modeling_speech_to_text_2.py#L726",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.41.0/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.41.0/en/model_doc/speech_to_text_2#transformers.Speech2Text2Config"
>Speech2Text2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.41.0/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),P=new Zs({props:{anchor:"transformers.Speech2Text2ForCausalLM.forward.example",$$slots:{default:[qs]},$$scope:{ctx:Z}}}),Je=new Ls({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/speech_to_text_2.md"}}),{c(){c=l("meta"),k=o(),T=l("p"),v=o(),p(y.$$.fragment),d=o(),p(w.$$.fragment),De=o(),Q=l("p"),Q.innerHTML=ns,Ae=o(),D=l("p"),D.innerHTML=as,Oe=o(),A=l("p"),A.innerHTML=rs,Ke=o(),O=l("p"),O.innerHTML=ls,et=o(),p(K.$$.fragment),tt=o(),ee=l("ul"),ee.innerHTML=is,st=o(),p(te.$$.fragment),ot=o(),se=l("p"),se.innerHTML=cs,nt=o(),oe=l("p"),oe.innerHTML=ds,at=o(),ne=l("ul"),ne.innerHTML=ps,rt=o(),p(ae.$$.fragment),lt=o(),re=l("ul"),re.innerHTML=ms,it=o(),p(le.$$.fragment),ct=o(),ie=l("p"),ie.innerHTML=hs,dt=o(),p(ce.$$.fragment),pt=o(),de=l("ul"),de.innerHTML=fs,mt=o(),p(pe.$$.fragment),ht=o(),C=l("div"),p(me.$$.fragment),Ct=o(),Se=l("p"),Se.innerHTML=us,St=o(),ze=l("p"),ze.innerHTML=gs,zt=o(),p(L.$$.fragment),ft=o(),p(he.$$.fragment),ut=o(),x=l("div"),p(fe.$$.fragment),Ut=o(),Ue=l("p"),Ue.textContent=_s,Zt=o(),Ze=l("p"),Ze.innerHTML=Ts,Wt=o(),G=l("div"),p(ue.$$.fragment),Ft=o(),We=l("p"),We.textContent=vs,Vt=o(),W=l("div"),p(ge.$$.fragment),It=o(),Fe=l("p"),Fe.textContent=bs,Bt=o(),Ve=l("p"),Ve.innerHTML=ys,Lt=o(),Ie=l("div"),p(_e.$$.fragment),gt=o(),p(Te.$$.fragment),_t=o(),b=l("div"),p(ve.$$.fragment),Gt=o(),Be=l("p"),Be.textContent=xs,Nt=o(),Le=l("p"),Le.innerHTML=ks,Et=o(),N=l("div"),p(be.$$.fragment),qt=o(),Ge=l("p"),Ge.innerHTML=Ms,Ht=o(),F=l("div"),p(ye.$$.fragment),Rt=o(),Ne=l("p"),Ne.textContent=ws,Xt=o(),p(E.$$.fragment),Pt=o(),V=l("div"),p(xe.$$.fragment),Yt=o(),Ee=l("p"),Ee.innerHTML=$s,Qt=o(),p(q.$$.fragment),Dt=o(),H=l("div"),p(ke.$$.fragment),At=o(),qe=l("p"),qe.innerHTML=js,Ot=o(),R=l("div"),p(Me.$$.fragment),Kt=o(),He=l("p"),He.innerHTML=Js,Tt=o(),p(we.$$.fragment),vt=o(),S=l("div"),p($e.$$.fragment),es=o(),Re=l("p"),Re.innerHTML=Cs,ts=o(),Xe=l("p"),Xe.innerHTML=Ss,ss=o(),X=l("div"),p(je.$$.fragment),os=o(),p(P.$$.fragment),bt=o(),p(Je.$$.fragment),yt=o(),Qe=l("p"),this.h()},l(e){const t=Bs("svelte-u9bgzb",document.head);c=i(t,"META",{name:!0,content:!0}),t.forEach(s),k=n(e),T=i(e,"P",{}),j(T).forEach(s),v=n(e),m(y.$$.fragment,e),d=n(e),m(w.$$.fragment,e),De=n(e),Q=i(e,"P",{"data-svelte-h":!0}),_(Q)!=="svelte-1q6drml"&&(Q.innerHTML=ns),Ae=n(e),D=i(e,"P",{"data-svelte-h":!0}),_(D)!=="svelte-iqjgnk"&&(D.innerHTML=as),Oe=n(e),A=i(e,"P",{"data-svelte-h":!0}),_(A)!=="svelte-pps277"&&(A.innerHTML=rs),Ke=n(e),O=i(e,"P",{"data-svelte-h":!0}),_(O)!=="svelte-1u4lnwc"&&(O.innerHTML=ls),et=n(e),m(K.$$.fragment,e),tt=n(e),ee=i(e,"UL",{"data-svelte-h":!0}),_(ee)!=="svelte-1gpn7jr"&&(ee.innerHTML=is),st=n(e),m(te.$$.fragment,e),ot=n(e),se=i(e,"P",{"data-svelte-h":!0}),_(se)!=="svelte-eatt20"&&(se.innerHTML=cs),nt=n(e),oe=i(e,"P",{"data-svelte-h":!0}),_(oe)!=="svelte-1npqp1t"&&(oe.innerHTML=ds),at=n(e),ne=i(e,"UL",{"data-svelte-h":!0}),_(ne)!=="svelte-acy5fb"&&(ne.innerHTML=ps),rt=n(e),m(ae.$$.fragment,e),lt=n(e),re=i(e,"UL",{"data-svelte-h":!0}),_(re)!=="svelte-eepefx"&&(re.innerHTML=ms),it=n(e),m(le.$$.fragment,e),ct=n(e),ie=i(e,"P",{"data-svelte-h":!0}),_(ie)!=="svelte-1lbi5m8"&&(ie.innerHTML=hs),dt=n(e),m(ce.$$.fragment,e),pt=n(e),de=i(e,"UL",{"data-svelte-h":!0}),_(de)!=="svelte-162aebv"&&(de.innerHTML=fs),mt=n(e),m(pe.$$.fragment,e),ht=n(e),C=i(e,"DIV",{class:!0});var U=j(C);m(me.$$.fragment,U),Ct=n(U),Se=i(U,"P",{"data-svelte-h":!0}),_(Se)!=="svelte-189vdug"&&(Se.innerHTML=us),St=n(U),ze=i(U,"P",{"data-svelte-h":!0}),_(ze)!=="svelte-1j16s4x"&&(ze.innerHTML=gs),zt=n(U),m(L.$$.fragment,U),U.forEach(s),ft=n(e),m(he.$$.fragment,e),ut=n(e),x=i(e,"DIV",{class:!0});var $=j(x);m(fe.$$.fragment,$),Ut=n($),Ue=i($,"P",{"data-svelte-h":!0}),_(Ue)!=="svelte-16s7215"&&(Ue.textContent=_s),Zt=n($),Ze=i($,"P",{"data-svelte-h":!0}),_(Ze)!=="svelte-4nifmy"&&(Ze.innerHTML=Ts),Wt=n($),G=i($,"DIV",{class:!0});var Ce=j(G);m(ue.$$.fragment,Ce),Ft=n(Ce),We=i(Ce,"P",{"data-svelte-h":!0}),_(We)!=="svelte-1deng2j"&&(We.textContent=vs),Ce.forEach(s),Vt=n($),W=i($,"DIV",{class:!0});var I=j(W);m(ge.$$.fragment,I),It=n(I),Fe=i(I,"P",{"data-svelte-h":!0}),_(Fe)!=="svelte-vbfkpu"&&(Fe.textContent=bs),Bt=n(I),Ve=i(I,"P",{"data-svelte-h":!0}),_(Ve)!=="svelte-125uxon"&&(Ve.innerHTML=ys),I.forEach(s),Lt=n($),Ie=i($,"DIV",{class:!0});var zs=j(Ie);m(_e.$$.fragment,zs),zs.forEach(s),$.forEach(s),gt=n(e),m(Te.$$.fragment,e),_t=n(e),b=i(e,"DIV",{class:!0});var M=j(b);m(ve.$$.fragment,M),Gt=n(M),Be=i(M,"P",{"data-svelte-h":!0}),_(Be)!=="svelte-cccwan"&&(Be.textContent=xs),Nt=n(M),Le=i(M,"P",{"data-svelte-h":!0}),_(Le)!=="svelte-u72h1u"&&(Le.innerHTML=ks),Et=n(M),N=i(M,"DIV",{class:!0});var kt=j(N);m(be.$$.fragment,kt),qt=n(kt),Ge=i(kt,"P",{"data-svelte-h":!0}),_(Ge)!=="svelte-1vvtx29"&&(Ge.innerHTML=Ms),kt.forEach(s),Ht=n(M),F=i(M,"DIV",{class:!0});var Pe=j(F);m(ye.$$.fragment,Pe),Rt=n(Pe),Ne=i(Pe,"P",{"data-svelte-h":!0}),_(Ne)!=="svelte-1cj8dcb"&&(Ne.textContent=ws),Xt=n(Pe),m(E.$$.fragment,Pe),Pe.forEach(s),Pt=n(M),V=i(M,"DIV",{class:!0});var Ye=j(V);m(xe.$$.fragment,Ye),Yt=n(Ye),Ee=i(Ye,"P",{"data-svelte-h":!0}),_(Ee)!=="svelte-idvjuv"&&(Ee.innerHTML=$s),Qt=n(Ye),m(q.$$.fragment,Ye),Ye.forEach(s),Dt=n(M),H=i(M,"DIV",{class:!0});var Mt=j(H);m(ke.$$.fragment,Mt),At=n(Mt),qe=i(Mt,"P",{"data-svelte-h":!0}),_(qe)!=="svelte-1my48c"&&(qe.innerHTML=js),Mt.forEach(s),Ot=n(M),R=i(M,"DIV",{class:!0});var wt=j(R);m(Me.$$.fragment,wt),Kt=n(wt),He=i(wt,"P",{"data-svelte-h":!0}),_(He)!=="svelte-1gxt4wy"&&(He.innerHTML=Js),wt.forEach(s),M.forEach(s),Tt=n(e),m(we.$$.fragment,e),vt=n(e),S=i(e,"DIV",{class:!0});var Y=j(S);m($e.$$.fragment,Y),es=n(Y),Re=i(Y,"P",{"data-svelte-h":!0}),_(Re)!=="svelte-1oop69j"&&(Re.innerHTML=Cs),ts=n(Y),Xe=i(Y,"P",{"data-svelte-h":!0}),_(Xe)!=="svelte-hswkmf"&&(Xe.innerHTML=Ss),ss=n(Y),X=i(Y,"DIV",{class:!0});var $t=j(X);m(je.$$.fragment,$t),os=n($t),m(P.$$.fragment,$t),$t.forEach(s),Y.forEach(s),bt=n(e),m(Je.$$.fragment,e),yt=n(e),Qe=i(e,"P",{}),j(Qe).forEach(s),this.h()},h(){J(c,"name","hf:doc:metadata"),J(c,"content",Rs),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){a(document.head,c),r(e,k,t),r(e,T,t),r(e,v,t),h(y,e,t),r(e,d,t),h(w,e,t),r(e,De,t),r(e,Q,t),r(e,Ae,t),r(e,D,t),r(e,Oe,t),r(e,A,t),r(e,Ke,t),r(e,O,t),r(e,et,t),h(K,e,t),r(e,tt,t),r(e,ee,t),r(e,st,t),h(te,e,t),r(e,ot,t),r(e,se,t),r(e,nt,t),r(e,oe,t),r(e,at,t),r(e,ne,t),r(e,rt,t),h(ae,e,t),r(e,lt,t),r(e,re,t),r(e,it,t),h(le,e,t),r(e,ct,t),r(e,ie,t),r(e,dt,t),h(ce,e,t),r(e,pt,t),r(e,de,t),r(e,mt,t),h(pe,e,t),r(e,ht,t),r(e,C,t),h(me,C,null),a(C,Ct),a(C,Se),a(C,St),a(C,ze),a(C,zt),h(L,C,null),r(e,ft,t),h(he,e,t),r(e,ut,t),r(e,x,t),h(fe,x,null),a(x,Ut),a(x,Ue),a(x,Zt),a(x,Ze),a(x,Wt),a(x,G),h(ue,G,null),a(G,Ft),a(G,We),a(x,Vt),a(x,W),h(ge,W,null),a(W,It),a(W,Fe),a(W,Bt),a(W,Ve),a(x,Lt),a(x,Ie),h(_e,Ie,null),r(e,gt,t),h(Te,e,t),r(e,_t,t),r(e,b,t),h(ve,b,null),a(b,Gt),a(b,Be),a(b,Nt),a(b,Le),a(b,Et),a(b,N),h(be,N,null),a(N,qt),a(N,Ge),a(b,Ht),a(b,F),h(ye,F,null),a(F,Rt),a(F,Ne),a(F,Xt),h(E,F,null),a(b,Pt),a(b,V),h(xe,V,null),a(V,Yt),a(V,Ee),a(V,Qt),h(q,V,null),a(b,Dt),a(b,H),h(ke,H,null),a(H,At),a(H,qe),a(b,Ot),a(b,R),h(Me,R,null),a(R,Kt),a(R,He),r(e,Tt,t),h(we,e,t),r(e,vt,t),r(e,S,t),h($e,S,null),a(S,es),a(S,Re),a(S,ts),a(S,Xe),a(S,ss),a(S,X),h(je,X,null),a(X,os),h(P,X,null),r(e,bt,t),h(Je,e,t),r(e,yt,t),r(e,Qe,t),xt=!0},p(e,[t]){const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),L.$set(U);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),E.$set($);const Ce={};t&2&&(Ce.$$scope={dirty:t,ctx:e}),q.$set(Ce);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),P.$set(I)},i(e){xt||(f(y.$$.fragment,e),f(w.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(le.$$.fragment,e),f(ce.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(L.$$.fragment,e),f(he.$$.fragment,e),f(fe.$$.fragment,e),f(ue.$$.fragment,e),f(ge.$$.fragment,e),f(_e.$$.fragment,e),f(Te.$$.fragment,e),f(ve.$$.fragment,e),f(be.$$.fragment,e),f(ye.$$.fragment,e),f(E.$$.fragment,e),f(xe.$$.fragment,e),f(q.$$.fragment,e),f(ke.$$.fragment,e),f(Me.$$.fragment,e),f(we.$$.fragment,e),f($e.$$.fragment,e),f(je.$$.fragment,e),f(P.$$.fragment,e),f(Je.$$.fragment,e),xt=!0)},o(e){u(y.$$.fragment,e),u(w.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(le.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(L.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(ge.$$.fragment,e),u(_e.$$.fragment,e),u(Te.$$.fragment,e),u(ve.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(E.$$.fragment,e),u(xe.$$.fragment,e),u(q.$$.fragment,e),u(ke.$$.fragment,e),u(Me.$$.fragment,e),u(we.$$.fragment,e),u($e.$$.fragment,e),u(je.$$.fragment,e),u(P.$$.fragment,e),u(Je.$$.fragment,e),xt=!1},d(e){e&&(s(k),s(T),s(v),s(d),s(De),s(Q),s(Ae),s(D),s(Oe),s(A),s(Ke),s(O),s(et),s(tt),s(ee),s(st),s(ot),s(se),s(nt),s(oe),s(at),s(ne),s(rt),s(lt),s(re),s(it),s(ct),s(ie),s(dt),s(pt),s(de),s(mt),s(ht),s(C),s(ft),s(ut),s(x),s(gt),s(_t),s(b),s(Tt),s(vt),s(S),s(bt),s(yt),s(Qe)),s(c),g(y,e),g(w,e),g(K,e),g(te,e),g(ae,e),g(le,e),g(ce,e),g(pe,e),g(me),g(L),g(he,e),g(fe),g(ue),g(ge),g(_e),g(Te,e),g(ve),g(be),g(ye),g(E),g(xe),g(q),g(ke),g(Me),g(we,e),g($e),g(je),g(P),g(Je,e)}}}const Rs='{"title":"Speech2Text2","local":"speech2text2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Speech2Text2Config","local":"transformers.Speech2Text2Config","sections":[],"depth":2},{"title":"Speech2TextTokenizer","local":"transformers.Speech2Text2Tokenizer","sections":[],"depth":2},{"title":"Speech2Text2Processor","local":"transformers.Speech2Text2Processor","sections":[],"depth":2},{"title":"Speech2Text2ForCausalLM","local":"transformers.Speech2Text2ForCausalLM","sections":[],"depth":2}],"depth":1}';function Xs(Z){return Fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class eo extends Vs{constructor(c){super(),Is(this,c,Xs,Hs,Ws,{})}}export{eo as component};
