import{s as Ht,n as qt,o as It}from"../chunks/scheduler.9039eef2.js";import{S as Ot,i as Ut,g as n,s as a,r as m,A as Vt,h as i,f as t,c as l,j as f,u as p,x as u,k as v,y as r,a as d,v as c,d as g,t as h,w as b}from"../chunks/index.cdcc3d35.js";import{D as x}from"../chunks/Docstring.fff63cfc.js";import{H as ve}from"../chunks/Heading.96ce3702.js";function Nt(ut){let T,xe,ze,ye,H,Pe,q,ct="The <code>optimum.neuron.distributed</code> module provides a set of tools to perform distributed training and inference.",Te,I,we,O,gt="The main task in distributed training / inference is being able to shard things such as the model weights, the gradient, and/or the optimizer state. We built <code>Parallelizer</code> classes to handle the sharding.",Ce,U,Me,V,ht="The <code>Parallelizer</code> class is the base abstract class being derived for every model supporting model parallelism. It provides methods to parallelize the model and save and load sharded checkpoints.",Le,s,N,Re,re,bt="Base abstract class that handles model parallelism.",je,C,F,Xe,ae,_t=`Parallelizes the model by transforming regular layer into their parallel counterparts.
Each concrete class must implement it.`,Ge,P,S,Je,le,ft=`Parallelizes the model by transforming regular layer into their parallel counterparts using
<code>cls._parallelize()</code>.`,Ke,oe,vt=`It also makes sure that each parameter has loaded its weights or has been initialized if there is no pre-trained
weights associated to it.`,Qe,$,W,Ye,ne,zt="Creates an optimizer ready for a parallelized model from an existing optimizer.",Ze,ie,$t="There are two cases:",et,de,xt=`<li>The optimizer has been created via a lazy constructor from
<code>optimum.neuron.distributed.utils.make_optimizer_constructor_lazy</code>, it which case the exactly intended optimizer is
created for tensor parallelism.</li> <li>The optimizer was created with a regular constructor. In this case the optimizer for tensor parallelism
is created as close as possible to what was intended but that is not guaranteed.</li>`,tt,se,A,rt,me,B,De,R,ke,j,yt="Each model that supports parallelization in <code>optimum-neuron</code> has its own derived <code>Parallelizer</code> class. The factory class <code>ParallelizersManager</code> allows you to retrieve such model-specific <code>Parallelizer</code>s easily.",Ee,z,X,at,M,G,lt,pe,Pt="Provides the list of supported model types for parallelization.",ot,L,J,nt,ue,Tt="Returns <code>True</code> if the model can be parallelized, <code>False</code> otherwise.",it,D,K,dt,ce,wt="Returns the parallelizer class associated to the model.",He,Q,qe,Y,Ie,Z,Ct="Distributed training / inference is usually needed when the model is too big to fit in one device. Tools that allow for lazy loading of model weights and optimizer states are thus needed to avoid going out-of-memory before parallelization.",Oe,y,ee,st,ge,Mt="Context manager that makes the loading of a model lazy for model parallelism:",mt,he,Lt=`<li>Every <code>torch.nn.Linear</code> is put on the <code>torch.device(&quot;meta&quot;)</code> device, meaning that it takes no memory to
instantiate.</li> <li>Every <code>torch.nn.Embedding</code> is also put on the <code>torch.device(&quot;meta&quot;)</code> device.</li> <li>No state dict is actually loaded, instead a weight map is created and attached to the model. For more
information, read the <code>optimum.neuron.distributed.utils.from_pretrained_for_tp</code> docstring.</li>`,Ue,w,te,pt,be,Dt=`Transforms an optimizer constructor (optimizer class) to make it lazy by not initializing the parameters.
This makes the optimizer lightweight and usable to create a “real” optimizer once the model has been
parallelized.`,Ve,$e,Ne;return H=new ve({props:{title:"Optimum Neuron Distributed",local:"optimum-neuron-distributed",headingTag:"h1"}}),I=new ve({props:{title:"Parallelization",local:"parallelization",headingTag:"h2"}}),U=new ve({props:{title:"Base Parallelizer",local:"optimum.neuron.distributed.Parallelizer",headingTag:"h3"}}),N=new x({props:{name:"class optimum.neuron.distributed.Parallelizer",anchor:"optimum.neuron.distributed.Parallelizer",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.17/optimum/neuron/distributed/base.py#L97"}}),F=new x({props:{name:"_parallelize",anchor:"optimum.neuron.distributed.Parallelizer._parallelize",parameters:[{name:"model",val:": PreTrainedModel"},{name:"device",val:": Optional = None"},{name:"parallelize_embeddings",val:": bool = True"},{name:"sequence_parallel_enabled",val:": bool = False"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model to parallelize.`,name:"model"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
The device where the new parallel layers should be put.`,name:"device"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.parallelize_embeddings",description:`<strong>parallelize_embeddings</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not the embeddings should be parallelized.
This can be disabled in the case when the TP size does not divide the vocabulary size.`,name:"parallelize_embeddings"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.sequence_parallel_enabled",description:`<strong>sequence_parallel_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not sequence parallelism is enabled.`,name:"sequence_parallel_enabled"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.17/optimum/neuron/distributed/base.py#L131",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The parallelized model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PreTrainedModel</code></p>
`}}),S=new x({props:{name:"parallelize",anchor:"optimum.neuron.distributed.Parallelizer.parallelize",parameters:[{name:"model",val:": PreTrainedModel"},{name:"device",val:": Optional = None"},{name:"parallelize_embeddings",val:": bool = True"},{name:"sequence_parallel_enabled",val:": bool = False"},{name:"checkpoint_dir",val:": Union = None"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model to parallelize.`,name:"model"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
The device where the new parallel layers should be put.`,name:"device"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.parallelize_embeddings",description:`<strong>parallelize_embeddings</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not the embeddings should be parallelized.
This can be disabled in the case when the TP size does not divide the vocabulary size.`,name:"parallelize_embeddings"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.sequence_parallel_enabled",description:`<strong>sequence_parallel_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not sequence parallelism is enabled.`,name:"sequence_parallel_enabled"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.checkpoint_dir",description:`<strong>checkpoint_dir</strong> (<code>Optional[Union[str, Path]]</code>) &#x2014;
Path to a sharded checkpoint. If specified, the checkpoint weights will be loaded to the parallelized
model.`,name:"checkpoint_dir"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.17/optimum/neuron/distributed/base.py#L168",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The parallelized model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PreTrainedModel</code></p>
`}}),W=new x({props:{name:"optimizer_for_tp",anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_tp",parameters:[{name:"optimizer",val:": torch.optim.Optimizer"},{name:"orig_param_to_parallel_param_on_xla",val:": Mapping"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_tp.optimizer",description:`<strong>optimizer</strong> (<code>torch.optim.Optimizer</code>) &#x2014;
The original optimizer.`,name:"optimizer"},{anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_tp.orig_param_to_parallel_param_on_xla",description:`<strong>orig_param_to_parallel_param_on_xla</strong> (<code>Mapping[int, torch.nn.Parameter]</code>) &#x2014;
A mapping (e.g. dict-like) that maps the id of a parameter in <code>optimizer</code> to the id of its
parallelized counterpart on an XLA device.`,name:"orig_param_to_parallel_param_on_xla"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.17/optimum/neuron/distributed/base.py#L401",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The tensor parallelism ready optimizer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.optim.Optimizer</code></p>
`}}),A=new x({props:{name:"save_model_checkpoint",anchor:"optimum.neuron.distributed.Parallelizer.save_model_checkpoint",parameters:[{name:"model",val:": PreTrainedModel"},{name:"output_dir",val:": Union"},{name:"as_regular",val:": bool = False"},{name:"as_sharded",val:": bool = True"},{name:"optimizer",val:": Optional = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.17/optimum/neuron/distributed/base.py#L549"}}),B=new x({props:{name:"load_model_checkpoint",anchor:"optimum.neuron.distributed.Parallelizer.load_model_checkpoint",parameters:[{name:"model",val:": PreTrainedModel"},{name:"load_dir",val:": Union"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.17/optimum/neuron/distributed/base.py#L578"}}),R=new ve({props:{title:"Selecting Model-Specific Parallelizer Classes",local:"optimum.neuron.distributed.ParallelizersManager",headingTag:"h3"}}),X=new x({props:{name:"class optimum.neuron.distributed.ParallelizersManager",anchor:"optimum.neuron.distributed.ParallelizersManager",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.17/optimum/neuron/distributed/parallelizers_manager.py#L51"}}),G=new x({props:{name:"get_supported_model_types",anchor:"optimum.neuron.distributed.ParallelizersManager.get_supported_model_types",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.17/optimum/neuron/distributed/parallelizers_manager.py#L64"}}),J=new x({props:{name:"is_model_supported",anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported",parameters:[{name:"model_type_or_model",val:": Union"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.17/optimum/neuron/distributed/parallelizers_manager.py#L79"}}),K=new x({props:{name:"parallelizer_for_model",anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model",parameters:[{name:"model_type_or_model",val:": Union"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.17/optimum/neuron/distributed/parallelizers_manager.py#L91"}}),Q=new ve({props:{title:"Utils",local:"utils",headingTag:"h2"}}),Y=new ve({props:{title:"Lazy Loading",local:"optimum.neuron.distributed.lazy_load_for_parallelism",headingTag:"h3"}}),ee=new x({props:{name:"optimum.neuron.distributed.lazy_load_for_parallelism",anchor:"optimum.neuron.distributed.lazy_load_for_parallelism",parameters:[{name:"tensor_parallel_size",val:": int = 1"}],parametersDescription:[{anchor:"optimum.neuron.distributed.lazy_load_for_parallelism.tensor_parallel_size",description:`<strong>tensor_parallel_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The parallel size considered for tensor parallel size. If set to 1, no lazy loading is performed.`,name:"tensor_parallel_size"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.17/optimum/neuron/distributed/utils.py#L705"}}),te=new x({props:{name:"optimum.neuron.distributed.make_optimizer_constructor_lazy",anchor:"optimum.neuron.distributed.make_optimizer_constructor_lazy",parameters:[{name:"optimizer_cls",val:": Type"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.0.17/optimum/neuron/distributed/utils.py#L747"}}),{c(){T=n("meta"),xe=a(),ze=n("p"),ye=a(),m(H.$$.fragment),Pe=a(),q=n("p"),q.innerHTML=ct,Te=a(),m(I.$$.fragment),we=a(),O=n("p"),O.innerHTML=gt,Ce=a(),m(U.$$.fragment),Me=a(),V=n("p"),V.innerHTML=ht,Le=a(),s=n("div"),m(N.$$.fragment),Re=a(),re=n("p"),re.textContent=bt,je=a(),C=n("div"),m(F.$$.fragment),Xe=a(),ae=n("p"),ae.textContent=_t,Ge=a(),P=n("div"),m(S.$$.fragment),Je=a(),le=n("p"),le.innerHTML=ft,Ke=a(),oe=n("p"),oe.textContent=vt,Qe=a(),$=n("div"),m(W.$$.fragment),Ye=a(),ne=n("p"),ne.textContent=zt,Ze=a(),ie=n("p"),ie.textContent=$t,et=a(),de=n("ol"),de.innerHTML=xt,tt=a(),se=n("div"),m(A.$$.fragment),rt=a(),me=n("div"),m(B.$$.fragment),De=a(),m(R.$$.fragment),ke=a(),j=n("p"),j.innerHTML=yt,Ee=a(),z=n("div"),m(X.$$.fragment),at=a(),M=n("div"),m(G.$$.fragment),lt=a(),pe=n("p"),pe.textContent=Pt,ot=a(),L=n("div"),m(J.$$.fragment),nt=a(),ue=n("p"),ue.innerHTML=Tt,it=a(),D=n("div"),m(K.$$.fragment),dt=a(),ce=n("p"),ce.textContent=wt,He=a(),m(Q.$$.fragment),qe=a(),m(Y.$$.fragment),Ie=a(),Z=n("p"),Z.textContent=Ct,Oe=a(),y=n("div"),m(ee.$$.fragment),st=a(),ge=n("p"),ge.textContent=Mt,mt=a(),he=n("ul"),he.innerHTML=Lt,Ue=a(),w=n("div"),m(te.$$.fragment),pt=a(),be=n("p"),be.textContent=Dt,Ve=a(),$e=n("p"),this.h()},l(e){const o=Vt("svelte-u9bgzb",document.head);T=i(o,"META",{name:!0,content:!0}),o.forEach(t),xe=l(e),ze=i(e,"P",{}),f(ze).forEach(t),ye=l(e),p(H.$$.fragment,e),Pe=l(e),q=i(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-it0u39"&&(q.innerHTML=ct),Te=l(e),p(I.$$.fragment,e),we=l(e),O=i(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-5ss4zj"&&(O.innerHTML=gt),Ce=l(e),p(U.$$.fragment,e),Me=l(e),V=i(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-1bsvcro"&&(V.innerHTML=ht),Le=l(e),s=i(e,"DIV",{class:!0});var _=f(s);p(N.$$.fragment,_),Re=l(_),re=i(_,"P",{"data-svelte-h":!0}),u(re)!=="svelte-h4ipsc"&&(re.textContent=bt),je=l(_),C=i(_,"DIV",{class:!0});var Fe=f(C);p(F.$$.fragment,Fe),Xe=l(Fe),ae=i(Fe,"P",{"data-svelte-h":!0}),u(ae)!=="svelte-1e0iews"&&(ae.textContent=_t),Fe.forEach(t),Ge=l(_),P=i(_,"DIV",{class:!0});var _e=f(P);p(S.$$.fragment,_e),Je=l(_e),le=i(_e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-1ytdrar"&&(le.innerHTML=ft),Ke=l(_e),oe=i(_e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-3oskg6"&&(oe.textContent=vt),_e.forEach(t),Qe=l(_),$=i(_,"DIV",{class:!0});var k=f($);p(W.$$.fragment,k),Ye=l(k),ne=i(k,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-gytsrb"&&(ne.textContent=zt),Ze=l(k),ie=i(k,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-k6ubrx"&&(ie.textContent=$t),et=l(k),de=i(k,"OL",{"data-svelte-h":!0}),u(de)!=="svelte-ogaf4b"&&(de.innerHTML=xt),k.forEach(t),tt=l(_),se=i(_,"DIV",{class:!0});var kt=f(se);p(A.$$.fragment,kt),kt.forEach(t),rt=l(_),me=i(_,"DIV",{class:!0});var Et=f(me);p(B.$$.fragment,Et),Et.forEach(t),_.forEach(t),De=l(e),p(R.$$.fragment,e),ke=l(e),j=i(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-1x1mrd0"&&(j.innerHTML=yt),Ee=l(e),z=i(e,"DIV",{class:!0});var E=f(z);p(X.$$.fragment,E),at=l(E),M=i(E,"DIV",{class:!0});var Se=f(M);p(G.$$.fragment,Se),lt=l(Se),pe=i(Se,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-esrxt2"&&(pe.textContent=Pt),Se.forEach(t),ot=l(E),L=i(E,"DIV",{class:!0});var We=f(L);p(J.$$.fragment,We),nt=l(We),ue=i(We,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-1bapgxn"&&(ue.innerHTML=Tt),We.forEach(t),it=l(E),D=i(E,"DIV",{class:!0});var Ae=f(D);p(K.$$.fragment,Ae),dt=l(Ae),ce=i(Ae,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-3qe9b8"&&(ce.textContent=wt),Ae.forEach(t),E.forEach(t),He=l(e),p(Q.$$.fragment,e),qe=l(e),p(Y.$$.fragment,e),Ie=l(e),Z=i(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-4ddlue"&&(Z.textContent=Ct),Oe=l(e),y=i(e,"DIV",{class:!0});var fe=f(y);p(ee.$$.fragment,fe),st=l(fe),ge=i(fe,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-bh7x4"&&(ge.textContent=Mt),mt=l(fe),he=i(fe,"UL",{"data-svelte-h":!0}),u(he)!=="svelte-qnyb1e"&&(he.innerHTML=Lt),fe.forEach(t),Ue=l(e),w=i(e,"DIV",{class:!0});var Be=f(w);p(te.$$.fragment,Be),pt=l(Be),be=i(Be,"P",{"data-svelte-h":!0}),u(be)!=="svelte-1agud9l"&&(be.textContent=Dt),Be.forEach(t),Ve=l(e),$e=i(e,"P",{}),f($e).forEach(t),this.h()},h(){v(T,"name","hf:doc:metadata"),v(T,"content",Ft),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){r(document.head,T),d(e,xe,o),d(e,ze,o),d(e,ye,o),c(H,e,o),d(e,Pe,o),d(e,q,o),d(e,Te,o),c(I,e,o),d(e,we,o),d(e,O,o),d(e,Ce,o),c(U,e,o),d(e,Me,o),d(e,V,o),d(e,Le,o),d(e,s,o),c(N,s,null),r(s,Re),r(s,re),r(s,je),r(s,C),c(F,C,null),r(C,Xe),r(C,ae),r(s,Ge),r(s,P),c(S,P,null),r(P,Je),r(P,le),r(P,Ke),r(P,oe),r(s,Qe),r(s,$),c(W,$,null),r($,Ye),r($,ne),r($,Ze),r($,ie),r($,et),r($,de),r(s,tt),r(s,se),c(A,se,null),r(s,rt),r(s,me),c(B,me,null),d(e,De,o),c(R,e,o),d(e,ke,o),d(e,j,o),d(e,Ee,o),d(e,z,o),c(X,z,null),r(z,at),r(z,M),c(G,M,null),r(M,lt),r(M,pe),r(z,ot),r(z,L),c(J,L,null),r(L,nt),r(L,ue),r(z,it),r(z,D),c(K,D,null),r(D,dt),r(D,ce),d(e,He,o),c(Q,e,o),d(e,qe,o),c(Y,e,o),d(e,Ie,o),d(e,Z,o),d(e,Oe,o),d(e,y,o),c(ee,y,null),r(y,st),r(y,ge),r(y,mt),r(y,he),d(e,Ue,o),d(e,w,o),c(te,w,null),r(w,pt),r(w,be),d(e,Ve,o),d(e,$e,o),Ne=!0},p:qt,i(e){Ne||(g(H.$$.fragment,e),g(I.$$.fragment,e),g(U.$$.fragment,e),g(N.$$.fragment,e),g(F.$$.fragment,e),g(S.$$.fragment,e),g(W.$$.fragment,e),g(A.$$.fragment,e),g(B.$$.fragment,e),g(R.$$.fragment,e),g(X.$$.fragment,e),g(G.$$.fragment,e),g(J.$$.fragment,e),g(K.$$.fragment,e),g(Q.$$.fragment,e),g(Y.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),Ne=!0)},o(e){h(H.$$.fragment,e),h(I.$$.fragment,e),h(U.$$.fragment,e),h(N.$$.fragment,e),h(F.$$.fragment,e),h(S.$$.fragment,e),h(W.$$.fragment,e),h(A.$$.fragment,e),h(B.$$.fragment,e),h(R.$$.fragment,e),h(X.$$.fragment,e),h(G.$$.fragment,e),h(J.$$.fragment,e),h(K.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),Ne=!1},d(e){e&&(t(xe),t(ze),t(ye),t(Pe),t(q),t(Te),t(we),t(O),t(Ce),t(Me),t(V),t(Le),t(s),t(De),t(ke),t(j),t(Ee),t(z),t(He),t(qe),t(Ie),t(Z),t(Oe),t(y),t(Ue),t(w),t(Ve),t($e)),t(T),b(H,e),b(I,e),b(U,e),b(N),b(F),b(S),b(W),b(A),b(B),b(R,e),b(X),b(G),b(J),b(K),b(Q,e),b(Y,e),b(ee),b(te)}}}const Ft='{"title":"Optimum Neuron Distributed","local":"optimum-neuron-distributed","sections":[{"title":"Parallelization","local":"parallelization","sections":[{"title":"Base Parallelizer","local":"optimum.neuron.distributed.Parallelizer","sections":[],"depth":3},{"title":"Selecting Model-Specific Parallelizer Classes","local":"optimum.neuron.distributed.ParallelizersManager","sections":[],"depth":3}],"depth":2},{"title":"Utils","local":"utils","sections":[{"title":"Lazy Loading","local":"optimum.neuron.distributed.lazy_load_for_parallelism","sections":[],"depth":3}],"depth":2}],"depth":1}';function St(ut){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends Ot{constructor(T){super(),Ut(this,T,St,Nt,Ht,{})}}export{jt as component};
