import{s as hs,z as gs,o as us,n as Zo}from"../chunks/scheduler.18a86fab.js";import{S as fs,i as vs,g as i,s,r as d,A as _s,h as r,f as n,c as a,j as U,u as m,x as f,k as y,y as l,a as t,v as p,d as h,t as g,w as u}from"../chunks/index.98837b22.js";import{T as Vn}from"../chunks/Tip.77304350.js";import{D as I}from"../chunks/Docstring.6758ea23.js";import{C as ee}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as ps}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as j}from"../chunks/Heading.7e7e0c5b.js";import{E as Ms}from"../chunks/index.92f616ba.js";function ys(z){let c,T="<li>Llava-OneVision uses different number of patches for images and thus has to pad the inputs inside modeling code, aside from the padding done when processing the inputs. The default setting is “left-padding” if model is in <code>eval()</code> mode, otherwise “right-padding”.</li>";return{c(){c=i("ul"),c.innerHTML=T},l(_){c=r(_,"UL",{"data-svelte-h":!0}),f(c)!=="svelte-zcrbqx"&&(c.innerHTML=T)},m(_,M){t(_,c,M)},p:Zo,d(_){_&&n(c)}}}function Ts(z){let c,T='bitsandbytes is being refactored to support multiple backends beyond CUDA. Currently, ROCm (AMD GPU) and Intel CPU implementations are mature, with Intel XPU in progress and Apple Silicon support expected by Q4/Q1. For installation instructions and the latest backend updates, visit <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">this link</a>.',_,M,w='We value your feedback to help identify bugs before the full release! Check out <a href="https://huggingface.co/docs/bitsandbytes/main/en/non_cuda_backends" rel="nofollow">these docs</a> for more details and feedback links.';return{c(){c=i("p"),c.innerHTML=T,_=s(),M=i("p"),M.innerHTML=w},l(v){c=r(v,"P",{"data-svelte-h":!0}),f(c)!=="svelte-nz63kd"&&(c.innerHTML=T),_=a(v),M=r(v,"P",{"data-svelte-h":!0}),f(M)!=="svelte-aze40l"&&(M.innerHTML=w)},m(v,J){t(v,c,J),t(v,_,J),t(v,M,J)},p:Zo,d(v){v&&(n(c),n(_),n(M))}}}function bs(z){let c,T="Example:",_,M,w;return M=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwTGxhdmFPbmV2aXNpb25Db25maWclMkMlMjBTaWdsaXBWaXNpb25Db25maWclMkMlMjBRd2VuMkNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBDTElQLXZpc2lvbiUyMGNvbmZpZyUwQXZpc2lvbl9jb25maWclMjAlM0QlMjBTaWdsaXBWaXNpb25Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMbGFtYSUyMGNvbmZpZyUwQXRleHRfY29uZmlnJTIwJTNEJTIwUXdlbjJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMbGF2YS1OZXh0JTIwbGxhdmEtaGYlMkZsbGF2YS1vbmV2aXNpb24tcXdlbjItN2Itb3YtaGYlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Db25maWcodmlzaW9uX2NvbmZpZyUyQyUyMHRleHRfY29uZmlnKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBsbGF2YS1oZiUyRmxsYXZhLW9uZXZpc2lvbi1xd2VuMi03Yi1vdi1oZiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionForConditionalGeneration, LlavaOnevisionConfig, SiglipVisionConfig, Qwen2Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = SiglipVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = Qwen2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llava-Next llava-hf/llava-onevision-qwen2-7b-ov-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LlavaOnevisionConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the llava-hf/llava-onevision-qwen2-7b-ov-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaOnevisionForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=i("p"),c.textContent=T,_=s(),d(M.$$.fragment)},l(v){c=r(v,"P",{"data-svelte-h":!0}),f(c)!=="svelte-11lpom8"&&(c.textContent=T),_=a(v),m(M.$$.fragment,v)},m(v,J){t(v,c,J),t(v,_,J),p(M,v,J),w=!0},p:Zo,i(v){w||(h(M.$$.fragment,v),w=!0)},o(v){g(M.$$.fragment,v),w=!1},d(v){v&&(n(c),n(_)),u(M,v)}}}function ws(z){let c,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=T},l(_){c=r(_,"P",{"data-svelte-h":!0}),f(c)!=="svelte-fincs2"&&(c.innerHTML=T)},m(_,M){t(_,c,M)},p:Zo,d(_){_&&n(c)}}}function Js(z){let c,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=T},l(_){c=r(_,"P",{"data-svelte-h":!0}),f(c)!=="svelte-fincs2"&&(c.innerHTML=T)},m(_,M){t(_,c,M)},p:Zo,d(_){_&&n(c)}}}function Us(z){let c,T="Example:",_,M,w;return M=new ee({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBMbGF2YU9uZXZpc2lvblByb2Nlc3NvciUyQyUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGF2YU9uZXZpc2lvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybGxhdmEtaGYlMkZsbGF2YS1vbmV2aXNpb24tcXdlbjItN2Itb3YtaGYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRCUyMmZsb2F0MTYlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUzQTAlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmxsYXZhLWhmJTJGbGxhdmEtb25ldmlzaW9uLXF3ZW4yLTdiLW92LWhmJTIyKSUwQSUwQWNvbnZlcnNhdGlvbiUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElNUQlMEFwcm9tcHQlMjAlM0QlMjBwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShjb252ZXJzYXRpb24lMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlKSUwQSUwQWltYWdlX2ZpbGUlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBcmF3X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoaW1hZ2VfZmlsZSUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHByb21wdCUyQyUyMGltYWdlcyUzRHJhd19pbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJ3B0JykudG8oMCUyQyUyMHRvcmNoLmZsb2F0MTYpJTBBJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UpJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShvdXRwdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionProcessor, LlavaOnevisionForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaOnevisionForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>, torch_dtype=<span class="hljs-string">&quot;float16&quot;</span>, device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = LlavaOnevisionProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>conversation = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>      <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>          {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
<span class="hljs-meta">... </span>          {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
<span class="hljs-meta">... </span>        ],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_file = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>raw_image = Image.<span class="hljs-built_in">open</span>(requests.get(image_file, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, images=raw_image, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>).to(<span class="hljs-number">0</span>, torch.float16)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(output, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;user\\n\\nWhat is shown in this image?\\nassistant\\ncat&quot;</span>`,wrap:!1}}),{c(){c=i("p"),c.textContent=T,_=s(),d(M.$$.fragment)},l(v){c=r(v,"P",{"data-svelte-h":!0}),f(c)!=="svelte-11lpom8"&&(c.textContent=T),_=a(v),m(M.$$.fragment,v)},m(v,J){t(v,c,J),t(v,_,J),p(M,v,J),w=!0},p:Zo,i(v){w||(h(M.$$.fragment,v),w=!0)},o(v){g(M.$$.fragment,v),w=!1},d(v){v&&(n(c),n(_)),u(M,v)}}}function js(z){let c,T,_,M,w,v,J,wt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',No,oe,Fo,ne,Jt='The LLaVA-OneVision model was proposed in <a href="https://arxiv.org/abs/2408.03326" rel="nofollow">LLaVA-OneVision: Easy Visual Task Transfer</a> by &lt;Bo Li, Yuanhan Zhang, Dong Guo, Renrui Zhang, Feng Li, Hao Zhang, Kaichen Zhang, Yanwei Li, Ziwei Liu, Chunyuan Li',Wo,te,Ut="LLaVA-OneVision is a Vision-Language Model that can generate text conditioned on one or several images/videos. The model consists of SigLIP vision encoder and a Qwen2 language backbone. The images are processed with anyres-9 technique where the image is split into 9 patches to better process high resolution images and capture as much details as possible. However, videos are pooled to a total sequence length of 196 tokens each frame for more memory efficient computation. LLaVA-OneVision is available in three sizes: 0.5B, 7B and 72B and achieves remarkable performance on benchmark evaluations.",Oo,se,jt="The abstract from the paper is the following:",Ao,ae,It=`<em>We present LLaVA-OneVision, a family of open large multimodal models (LMMs)
developed by consolidating our insights into data, models, and visual representations in the LLaVA-NeXT blog series. Our experimental results demonstrate that
LLaVA-OneVision is the first single model that can simultaneously push the performance boundaries of open LMMs in three important computer vision scenarios:
single-image, multi-image, and video scenarios. Importantly, the design of LLaVAOneVision allows strong transfer learning across different modalities/scenarios,
yielding new emerging capabilities. In particular, strong video understanding and
cross-scenario capabilities are demonstrated through task transfer from images to
videos.</em>`,Xo,O,Ct,Vo,ie,Lt='LLaVA-OneVision architecture. Taken from the <a href="https://arxiv.org/abs/2408.03326">original paper.</a>',Ro,re,xt="Tips:",Qo,le,zt="<li>We advise users to use <code>padding_side=&quot;left&quot;</code> when computing batched generation as it leads to more accurate results. Simply make sure to call <code>processor.tokenizer.padding_side = &quot;left&quot;</code> before generating.</li>",Po,A,Eo,ce,Yo,de,kt="Each <strong>checkpoint</strong> is trained with a specific prompt format, depending on the underlying large language model backbone. To ensure correct formatting, use the processor’s <code>apply_chat_template</code> method.",Ho,me,$t="<strong>Important:</strong>",So,pe,qt="<li>You must construct a conversation history — passing a plain string won’t work.</li> <li>Each message should be a dictionary with <code>&quot;role&quot;</code> and <code>&quot;content&quot;</code> keys.</li> <li>The <code>&quot;content&quot;</code> should be a list of dictionaries for different modalities like <code>&quot;text&quot;</code> and <code>&quot;image&quot;</code>.</li>",Do,he,Zt=`Here’s an example of how to structure your input.
We will use <a href="https://huggingface.co/llava-hf/llava-onevision-qwen2-7b-si-hf" rel="nofollow">llava-onevision-qwen2-7b-si-hf</a> and a conversation history of text and image. Each content field has to be a list of dicts, as follows:`,Ko,ge,en,ue,Gt="🚀 <strong>Bonus:</strong> If you’re using <code>transformers&gt;=4.49.0</code>, you can also get a vectorized output from <code>apply_chat_template</code>. See the <strong>Usage Examples</strong> below for more details on how to use it.",on,fe,Bt=`This model was contributed by <a href="https://huggingface.co/RaushanTurganbay" rel="nofollow">RaushanTurganbay</a>.
The original code can be found <a href="https://github.com/LLaVA-VL/LLaVA-NeXT/tree/main" rel="nofollow">here</a>.`,nn,ve,tn,_e,sn,Me,Nt="Here’s how to load the model and perform inference in half-precision (<code>torch.float16</code>):",an,ye,rn,Te,ln,be,Ft="LLaVa-OneVision can perform inference with multiple images as input, where images either belong to the same prompt or different prompts (in batched inference). For that you have to use checkpoints with an “ov” suffix. Here is how you can do it:",cn,we,dn,Je,mn,Ue,Wt="LLaVa-OneVision also can perform inference with videos as input, where video frames are treated as multiple images. Here is how you can do it:",pn,je,hn,Ie,gn,Ce,un,Le,Ot="The model can be loaded in 8 or 4 bits, greatly reducing the memory requirements while maintaining the performance of the original model. First make sure to install bitsandbytes, <code>pip install bitsandbytes</code> and make sure to have access to a GPU/accelerator that is supported by the library.",fn,X,vn,xe,At="Simply change the snippet above with:",_n,ze,Mn,ke,yn,$e,Xt='First make sure to install flash-attn. Refer to the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">original repository of Flash Attention</a> regarding that package installation. Simply change the snippet above with:',Tn,qe,bn,Ze,wn,k,Ge,Rn,po,Vt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionForConditionalGeneration">LlavaOnevisionForConditionalGeneration</a>. It is used to instantiate an
Llava-NeXT model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/llava-hf/llava-onevision-qwen2-7b-ov-hf" rel="nofollow">llava-hf/llava-onevision-qwen2-7b-ov-hf</a>
model.`,Qn,ho,Rt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Pn,V,Jn,Be,Un,L,Ne,En,go,Qt="Constructs a LLaVa-Onevision processor which wraps a LLaVa-Onevision video processor, LLaVa-NeXT image processor and a LLaMa tokenizer into a single processor.",Yn,uo,Pt=`<a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextProcessor">LlavaNextProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionVideoProcessor">LlavaOnevisionVideoProcessor</a>, <a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionImageProcessor">LlavaOnevisionImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<code>__call__()</code>, <code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextProcessor.decode">decode()</a> for more information.`,Hn,R,Fe,Sn,fo,Et=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,Dn,Q,We,Kn,vo,Yt=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,jn,Oe,In,Z,Ae,et,_o,Ht='Constructs a LLaVa-Onevision image processor. Based on <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a> with incorporation of processing each video frame.',ot,Mo,Xe,Cn,Ve,Ln,G,Re,nt,yo,St="Constructs a fast Llava Onevision image processor.",tt,To,Qe,xn,Pe,zn,Ee,Ye,kn,He,$n,Se,De,qn,Ke,Zn,b,eo,st,bo,Dt="The Llava-Next model which consists of a vision backbone and a language model without language modeling head.",at,wo,Kt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,it,Jo,es=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,rt,N,oo,lt,Uo,os='The <a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionModel">LlavaOnevisionModel</a> forward method, overrides the <code>__call__</code> special method.',ct,P,dt,E,no,mt,jo,ns="Obtains image last hidden states from the vision tower and apply multimodal projection.",pt,Y,to,ht,Io,ts="Obtains video last hidden states from the vision tower, apply multimodal projection and pooling.",gt,H,so,ut,Co,ss="Reshape, unpad and then pack each image_feature into a single image_features tensor containing all visual vectors.",Gn,ao,Bn,x,io,ft,Lo,as="The LLAVA-NeXT model which consists of a vision backbone and a language model.",vt,xo,is=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,_t,zo,rs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Mt,q,ro,yt,ko,ls='The <a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionForConditionalGeneration">LlavaOnevisionForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Tt,S,bt,D,Nn,lo,Fn,Go,Wn;return w=new j({props:{title:"LLaVA-OneVision",local:"llava-onevision",headingTag:"h1"}}),oe=new j({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new Vn({props:{warning:!0,$$slots:{default:[ys]},$$scope:{ctx:z}}}),ce=new j({props:{title:"Formatting Prompts with Chat Templates",local:"formatting-prompts-with-chat-templates",headingTag:"h3"}}),ge=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJsbGF2YS1oZiUyRmxsYXZhLW9uZXZpc2lvbi1xd2VuMi03Yi1zaS1oZiUyMiklMEElMEFjb252ZXJzYXRpb24lMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJXaGF0JUUyJTgwJTk5cyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMlRoaXMlMjBpbWFnZSUyMHNob3dzJTIwYSUyMHJlZCUyMHN0b3AlMjBzaWduLiUyMiU3RCUyQyU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkRlc2NyaWJlJTIwdGhlJTIwaW1hZ2UlMjBpbiUyMG1vcmUlMjBkZXRhaWxzLiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSU1RCUwQSUwQXRleHRfcHJvbXB0JTIwJTNEJTIwcHJvY2Vzc29yLmFwcGx5X2NoYXRfdGVtcGxhdGUoY29udmVyc2F0aW9uJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMEElMjMlMjBOb3RlJTIwdGhhdCUyMHRoZSUyMHRlbXBsYXRlJTIwc2ltcGx5JTIwZm9ybWF0cyUyMHlvdXIlMjBwcm9tcHQlMkMlMjB5b3UlMjBzdGlsbCUyMGhhdmUlMjB0byUyMHRva2VuaXplJTIwaXQlMjBhbmQlMjBvYnRhaW4lMjBwaXhlbCUyMHZhbHVlcyUyMGZvciUyMHlvdXIlMjBpbWFnZXMlMEFwcmludCh0ZXh0X3Byb21wdCklMEEnJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTVDbiUzQ2ltYWdlJTNFV2hhdCUyMGlzJTIwc2hvd24lMjBpbiUyMHRoaXMlMjBpbWFnZSUzRiUzQyU3Q2ltX2VuZCU3QyUzRSU1Q24lM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCU1Q25QYWdlJTIwc2hvd2luZyUyMHRoZSUyMGxpc3QlMjBvZiUyMG9wdGlvbnMuJTNDJTdDaW1fZW5kJTdDJTNFJw==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-si-hf&quot;</span>)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What’s shown in this image?&quot;</span>},
        ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;This image shows a red stop sign.&quot;</span>},]
    },
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe the image in more details.&quot;</span>},
        ],
    },
]

text_prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Note that the template simply formats your prompt, you still have to tokenize it and obtain pixel values for your images</span>
<span class="hljs-built_in">print</span>(text_prompt)
<span class="hljs-string">&#x27;&lt;|im_start|&gt;user\\n&lt;image&gt;What is shown in this image?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\nPage showing the list of options.&lt;|im_end|&gt;&#x27;</span>`,wrap:!1}}),ve=new j({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),_e=new j({props:{title:"Single image inference",local:"single-image-inference",headingTag:"h3"}}),ye=new ee({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration
<span class="hljs-keyword">import</span> torch

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>) 
model = LlavaOnevisionForConditionalGeneration.from_pretrained(
    <span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>,
    torch_dtype=torch.float16,
    low_cpu_mem_usage=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>
)

<span class="hljs-comment"># prepare image and text prompt, using the appropriate prompt template</span>
url = <span class="hljs-string">&quot;https://github.com/haotian-liu/LLaVA/blob/1a91fc274d7c35a9b50b3cb29c4247ae5837ce39/images/llava_v1_5_radar.jpg?raw=true&quot;</span>
conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: url},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
        ],
    },
]
inputs = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>, tokenize=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = inputs.to(<span class="hljs-string">&quot;cuda:0&quot;</span>, torch.float16)

<span class="hljs-comment"># autoregressively complete prompt</span>
output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">100</span>)
<span class="hljs-built_in">print</span>(processor.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
<span class="hljs-string">&#x27;user\\n\\nWhat is shown in this image?\\nassistant\\nThe image shows a radar chart, also known as a spider chart or a star chart, which is used to compare multiple quantitative variables. Each axis represents a different variable, and the chart is filled with&#x27;</span>`,wrap:!1}}),Te=new j({props:{title:"Multi image inference",local:"multi-image-inference",headingTag:"h3"}}),we=new ee({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration

<span class="hljs-comment"># Load the model in half-precision</span>
model = LlavaOnevisionForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>)

<span class="hljs-comment"># Prepare a batch of two prompts, where the first one is a multi-turn conversation and the second is not</span>
conversation_1 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;There is a red stop sign in the image.&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What about this image? How many cats do you see?&quot;</span>},
            ],
    },
]

conversation_2 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://huggingface.co/microsoft/kosmos-2-patch14-224/resolve/main/snowman.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
]

inputs = processor.apply_chat_template(
    [conversation_1, conversation_2],
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    padding=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
).to(model.device, torch.float16)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">30</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;user\\n\\nWhat is shown in this image?\\nassistant\\nThere is a red stop sign in the image.\\nuser\\n\\nWhat about this image? How many cats do you see?\\nassistant\\ntwo&#x27;</span>, <span class="hljs-string">&#x27;user\\n\\nWhat is shown in this image?\\nassistant\\n&#x27;</span>]`,wrap:!1}}),Je=new j({props:{title:"Video inference",local:"video-inference",headingTag:"h3"}}),je=new ee({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration

<span class="hljs-comment"># Load the model in half-precision</span>
model = LlavaOnevisionForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>)

video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
conversation = [
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>: video_path},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Why is this video funny?&quot;</span>},
            ],
    },
]

inputs = processor.apply_chat_template(
    conversation,
    num_frames=<span class="hljs-number">8</span>
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
).to(model.device, torch.float16)

out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">60</span>)
processor.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;user\\n\\nWhy is this video funny?\\nassistant\\nThe video appears to be humorous because it shows a young child, who is wearing glasses and holding a book, seemingly reading with a serious and focused expression. The child&#x27;s glasses are a bit oversized for their face, which adds a comical touch, as it&#x27;s a common trope to see children wearing&quot;</span>]`,wrap:!1}}),Ie=new j({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),Ce=new j({props:{title:"Quantization using bitsandbytes",local:"quantization-using-bitsandbytes",headingTag:"h3"}}),X=new Vn({props:{$$slots:{default:[Ts]},$$scope:{ctx:z}}}),ze=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBJTIzJTIwc3BlY2lmeSUyMGhvdyUyMHRvJTIwcXVhbnRpemUlMjB0aGUlMjBtb2RlbCUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionForConditionalGeneration, BitsAndBytesConfig

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = LlavaOnevisionForConditionalGeneration.from_pretrained(model_id, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),ke=new j({props:{title:"Use Flash-Attention 2 to further speed-up generation",local:"use-flash-attention-2-to-further-speed-up-generation",headingTag:"h3"}}),qe=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGF2YU9uZXZpc2lvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB1c2VfZmxhc2hfYXR0ZW50aW9uXzIlM0RUcnVlJTBBKS50bygwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionForConditionalGeneration

model = LlavaOnevisionForConditionalGeneration.from_pretrained(
    model_id,
    torch_dtype=torch.float16,
    low_cpu_mem_usage=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),Ze=new j({props:{title:"LlavaOnevisionConfig",local:"transformers.LlavaOnevisionConfig",headingTag:"h2"}}),Ge=new I({props:{name:"class transformers.LlavaOnevisionConfig",anchor:"transformers.LlavaOnevisionConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"image_token_index",val:" = 151646"},{name:"video_token_index",val:" = 151647"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"vision_feature_select_strategy",val:" = 'full'"},{name:"vision_feature_layer",val:" = -1"},{name:"vision_aspect_ratio",val:" = 'anyres_max_9'"},{name:"image_grid_pinpoints",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"multimodal_projector_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionConfig.vision_config",description:`<strong>vision_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>SiglipVisionConfig</code>) &#x2014;
The config object or dictionary of the vision backbone.`,name:"vision_config"},{anchor:"transformers.LlavaOnevisionConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>Qwen2Config</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.LlavaOnevisionConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 151646) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.LlavaOnevisionConfig.video_token_index",description:`<strong>video_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 151647) &#x2014;
The video token index to encode the video prompt.`,name:"video_token_index"},{anchor:"transformers.LlavaOnevisionConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.LlavaOnevisionConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;full&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaOnevisionConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaOnevisionConfig.vision_aspect_ratio",description:`<strong>vision_aspect_ratio</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;anyres_max_9&quot;</code>) &#x2014;
Aspect ratio used when processong image features. The default value is &#x201C;anyres_max_9&#x201D;.`,name:"vision_aspect_ratio"},{anchor:"transformers.LlavaOnevisionConfig.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code>, <em>optional</em>) &#x2014;
A list of possible resolutions to use for processing high resolution images. Each item in the list should be a tuple or list
of the form <code>(height, width)</code>.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaOnevisionConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.LlavaOnevisionConfig.multimodal_projector_bias",description:`<strong>multimodal_projector_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the multimodal projector.`,name:"multimodal_projector_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/configuration_llava_onevision.py#L27"}}),V=new ps({props:{anchor:"transformers.LlavaOnevisionConfig.example",$$slots:{default:[bs]},$$scope:{ctx:z}}}),Be=new j({props:{title:"LlavaOnevisionProcessor",local:"transformers.LlavaOnevisionProcessor",headingTag:"h2"}}),Ne=new I({props:{name:"class transformers.LlavaOnevisionProcessor",anchor:"transformers.LlavaOnevisionProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"video_processor",val:" = None"},{name:"num_image_tokens",val:" = None"},{name:"vision_feature_select_strategy",val:" = None"},{name:"chat_template",val:" = None"},{name:"image_token",val:" = '<image>'"},{name:"video_token",val:" = '<video>'"},{name:"vision_aspect_ratio",val:" = 'anyres_max_9'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionImageProcessor">LlavaOnevisionImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.LlavaOnevisionProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.LlavaOnevisionProcessor.video_processor",description:`<strong>video_processor</strong> (<a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionVideoProcessor">LlavaOnevisionVideoProcessor</a>, <em>optional</em>) &#x2014;
The video processor is a required input.`,name:"video_processor"},{anchor:"transformers.LlavaOnevisionProcessor.num_image_tokens",description:`<strong>num_image_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of image tokens for one imagethat will be returned by vision tower.`,name:"num_image_tokens"},{anchor:"transformers.LlavaOnevisionProcessor.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Should be same as in model&#x2019;s config`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaOnevisionProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"},{anchor:"transformers.LlavaOnevisionProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
Special token used to denote image location.`,name:"image_token"},{anchor:"transformers.LlavaOnevisionProcessor.video_token",description:`<strong>video_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;video&gt;&quot;</code>) &#x2014;
Special token used to denote video location.`,name:"video_token"},{anchor:"transformers.LlavaOnevisionProcessor.vision_aspect_ratio",description:`<strong>vision_aspect_ratio</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;anyres_max_9&quot;</code>) &#x2014;
Aspect ratio used when processong image features. The default value is &#x201C;anyres_max_9&#x201D;.`,name:"vision_aspect_ratio"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/processing_llava_onevision.py#L47"}}),Fe=new I({props:{name:"batch_decode",anchor:"transformers.LlavaOnevisionProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/processing_llava_onevision.py#L280"}}),We=new I({props:{name:"decode",anchor:"transformers.LlavaOnevisionProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/processing_llava_onevision.py#L288"}}),Oe=new j({props:{title:"LlavaOnevisionImageProcessor",local:"transformers.LlavaOnevisionImageProcessor",headingTag:"h2"}}),Ae=new I({props:{name:"class transformers.LlavaOnevisionImageProcessor",anchor:"transformers.LlavaOnevisionImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"image_grid_pinpoints",val:": typing.Optional[typing.List] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = True"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaOnevisionImageProcessor.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>[[672, 336], [336, 672], [672, 672], [336, 1008], [1008, 336]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method. Not used for processing videos.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaOnevisionImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/image_processing_llava_onevision.py#L107"}}),Xe=new I({props:{name:"preprocess",anchor:"transformers.LlavaOnevisionImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"image_grid_pinpoints",val:": typing.Optional[typing.List] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>) &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. Both channels-first and channels-last formats are supported.`,name:"images"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>self.image_grid_pinpoints</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is
selected based on the original size of the image.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/image_processing_llava_onevision.py#L515"}}),Ve=new j({props:{title:"LlavaOnevisionImageProcessorFast",local:"transformers.LlavaOnevisionImageProcessorFast",headingTag:"h2"}}),Re=new I({props:{name:"class transformers.LlavaOnevisionImageProcessorFast",anchor:"transformers.LlavaOnevisionImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava_onevision.image_processing_llava_onevision_fast.LlavaOnevisionFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>{&apos;height&apos; -- 384, &apos;width&apos;: 384}</code>):
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>, defaults to <code>0.00392156862745098</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>, defaults to <code>None</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/image_processing_llava_onevision_fast.py#L69"}}),Qe=new I({props:{name:"preprocess",anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava_onevision.image_processing_llava_onevision_fast.LlavaOnevisionFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, list[&apos;PIL.Image.Image&apos;], list[numpy.ndarray], list[&apos;torch.Tensor&apos;]]</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/image_processing_llava_onevision_fast.py#L90",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><strong>data</strong> (<code>dict</code>) — Dictionary of lists/arrays/tensors returned by the <strong>call</strong> method (‘pixel_values’, etc.).</li>
<li><strong>tensor_type</strong> (<code>Union[None, str, TensorType]</code>, <em>optional</em>) — You can give a tensor_type here to convert the lists of integers in PyTorch/TensorFlow/Numpy Tensors at
initialization.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>&lt;class 'transformers.image_processing_base.BatchFeature'&gt;</code></p>
`}}),Pe=new j({props:{title:"LlavaOnevisionVideoProcessor",local:"transformers.LlavaOnevisionVideoProcessor",headingTag:"h2"}}),Ye=new I({props:{name:"class transformers.LlavaOnevisionVideoProcessor",anchor:"transformers.LlavaOnevisionVideoProcessor",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava_onevision.video_processing_llava_onevision.LlavaOnevisionFastVideoProcessorInitKwargs]"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/video_processing_llava_onevision.py#L36"}}),He=new j({props:{title:"LlavaOnevisionVideoProcessor",local:"transformers.LlavaOnevisionVideoProcessor",headingTag:"h2"}}),De=new I({props:{name:"class transformers.LlavaOnevisionVideoProcessor",anchor:"transformers.LlavaOnevisionVideoProcessor",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava_onevision.video_processing_llava_onevision.LlavaOnevisionFastVideoProcessorInitKwargs]"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/video_processing_llava_onevision.py#L36"}}),Ke=new j({props:{title:"LlavaOnevisionModel",local:"transformers.LlavaOnevisionModel",headingTag:"h2"}}),eo=new I({props:{name:"class transformers.LlavaOnevisionModel",anchor:"transformers.LlavaOnevisionModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionModel">LlavaOnevisionModel</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L325"}}),oo=new I({props:{name:"forward",anchor:"transformers.LlavaOnevisionModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"image_sizes",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values_videos",val:": FloatTensor = None"},{name:"image_sizes_videos",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"vision_aspect_ratio",val:": typing.Optional[str] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlavaOnevisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.LlavaOnevisionModel.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"},{anchor:"transformers.LlavaOnevisionModel.forward.pixel_values_videos",description:'<strong>pixel_values_videos</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, frames, num_channels, image_size, image_size)) -- The tensors corresponding to the input videos. Pixel values can be obtained using [LlavaNextVideoProcessor](/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoProcessor). See </code>LlavaNextVideoProcessor.<strong>call</strong>()` for details. <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses\n<a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoProcessor">LlavaNextVideoProcessor</a> for processing videos.',name:"pixel_values_videos"},{anchor:"transformers.LlavaOnevisionModel.forward.image_sizes_videos",description:`<strong>image_sizes_videos</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, frames, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the videos in the batch, being (height, width) for each frame in the video.`,name:"image_sizes_videos"},{anchor:"transformers.LlavaOnevisionModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.LlavaOnevisionModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlavaOnevisionModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlavaOnevisionModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlavaOnevisionModel.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int], NoneType]</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaOnevisionModel.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaOnevisionModel.forward.vision_aspect_ratio",description:`<strong>vision_aspect_ratio</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;anyres_max_9&quot;</code>) &#x2014;
Aspect ratio used when processong image features. The default value is &#x201C;anyres_max_9&#x201D;.`,name:"vision_aspect_ratio"},{anchor:"transformers.LlavaOnevisionModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlavaOnevisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlavaOnevisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlavaOnevisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlavaOnevisionModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L487",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.llava_onevision.modeling_llava_onevision.LlavaOnevisionModelOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionConfig"
>LlavaOnevisionConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size <code>(batch_size, num_images, sequence_length, hidden_size)</code>.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
<li>
<p><strong>video_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code>  of size <code>(batch_size * num_frames, num_videos, sequence_length, hidden_size)</code>.
video_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.llava_onevision.modeling_llava_onevision.LlavaOnevisionModelOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),P=new Vn({props:{$$slots:{default:[ws]},$$scope:{ctx:z}}}),no=new I({props:{name:"get_image_features",anchor:"transformers.LlavaOnevisionModel.get_image_features",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"image_sizes",val:": Tensor"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionModel.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor]</code> of shape <code>(batch_size, num_patches, channels, height, width)</code>) &#x2014;
The tensors corresponding to the input images.`,name:"pixel_values"},{anchor:"transformers.LlavaOnevisionModel.get_image_features.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.Tensor</code> of shape <code>(num_images, 2)</code>) &#x2014;
Actual image size of each images (H, W).`,name:"image_sizes"},{anchor:"transformers.LlavaOnevisionModel.get_image_features.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaOnevisionModel.get_image_features.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L418",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of image feature tensor, each contains all the visual feature of all patches
and are of shape <code>(num_patches, image_length, embed_dim)</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (List<code>torch.Tensor</code>)</p>
`}}),to=new I({props:{name:"get_video_features",anchor:"transformers.LlavaOnevisionModel.get_video_features",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int]]"},{name:"vision_feature_select_strategy",val:": str"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionModel.get_video_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor]</code> of shape <code>(batch_size, num_frames, channels, height, width)</code>) &#x2014;
The tensors corresponding to the input video.`,name:"pixel_values"},{anchor:"transformers.LlavaOnevisionModel.get_video_features.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]], *optional*, defaults to -2</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaOnevisionModel.get_video_features.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L626",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of video feature tensor, each contains all the visual feature of all patches
and are of shape <code>(num_videos, video_length, embed_dim)</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>video_features (List<code>torch.Tensor</code>)</p>
`}}),so=new I({props:{name:"pack_image_features",anchor:"transformers.LlavaOnevisionModel.pack_image_features",parameters:[{name:"image_features",val:""},{name:"image_sizes",val:""},{name:"image_newline",val:" = None"},{name:"vision_aspect_ratio",val:" = 'anyres_max_9'"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionModel.pack_image_features.image_features",description:`<strong>image_features</strong> (<code>List[torch.Tensor]</code> of length num_images, each of shape <code>(num_patches, image_length, embed_dim)</code>) &#x2014;
List of image feature tensor, each contains all the visual feature of all patches.`,name:"image_features"},{anchor:"transformers.LlavaOnevisionModel.pack_image_features.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.Tensor</code> of shape <code>(num_images, 2)</code>) &#x2014;
Actual image size of each images (H, W).`,name:"image_sizes"},{anchor:"transformers.LlavaOnevisionModel.pack_image_features.image_newline",description:`<strong>image_newline</strong> (<code>torch.Tensor</code> of shape <code>(embed_dim)</code>) &#x2014;
New line embedding vector.`,name:"image_newline"},{anchor:"transformers.LlavaOnevisionModel.pack_image_features.vision_aspect_ratio",description:`<strong>vision_aspect_ratio</strong> (<code>str</code>, <em>optional</em>, &#x201C;anyres_max_9&#x201D;) &#x2014;
Aspect ratio used when processong image features. The default value is &#x201C;anyres_max_9&#x201D;.`,name:"vision_aspect_ratio"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L352",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.Tensor</code> of shape <code>(all_feat_len, embed_dim)</code>)
feature_lens (<code>List[int]</code>)
token length of each image in image_features</p>
`}}),ao=new j({props:{title:"LlavaOnevisionForConditionalGeneration",local:"transformers.LlavaOnevisionForConditionalGeneration",headingTag:"h2"}}),io=new I({props:{name:"class transformers.LlavaOnevisionForConditionalGeneration",anchor:"transformers.LlavaOnevisionForConditionalGeneration",parameters:[{name:"config",val:": LlavaOnevisionConfig"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionConfig">LlavaOnevisionConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L690"}}),ro=new I({props:{name:"forward",anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"image_sizes",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values_videos",val:": FloatTensor = None"},{name:"image_sizes_videos",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"vision_aspect_ratio",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava_onevision.modeling_llava_onevision.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.pixel_values_videos",description:'<strong>pixel_values_videos</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, frames, num_channels, image_size, image_size)) -- The tensors corresponding to the input videos. Pixel values can be obtained using [LlavaNextVideoProcessor](/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoProcessor). See </code>LlavaNextVideoProcessor.<strong>call</strong>()` for details. <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses\n<a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoProcessor">LlavaNextVideoProcessor</a> for processing videos.',name:"pixel_values_videos"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.image_sizes_videos",description:`<strong>image_sizes_videos</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, frames, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the videos in the batch, being (height, width) for each frame in the video.`,name:"image_sizes_videos"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int], NoneType]</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.vision_aspect_ratio",description:`<strong>vision_aspect_ratio</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;anyres_max_9&quot;</code>) &#x2014;
Aspect ratio used when processong image features. The default value is &#x201C;anyres_max_9&#x201D;.`,name:"vision_aspect_ratio"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L736",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.llava_onevision.modeling_llava_onevision.LlavaOnevisionCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionConfig"
>LlavaOnevisionConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size (batch_size * num_patches, num_images, sequence_length, hidden_size)\`.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
<li>
<p><strong>video_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code>  of size <code>(batch_size * num_frames, num_videos, sequence_length, hidden_size)</code>.
video_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.llava_onevision.modeling_llava_onevision.LlavaOnevisionCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),S=new Vn({props:{$$slots:{default:[Js]},$$scope:{ctx:z}}}),D=new ps({props:{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.example",$$slots:{default:[Us]},$$scope:{ctx:z}}}),lo=new Ms({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/llava_onevision.md"}}),{c(){c=i("meta"),T=s(),_=i("p"),M=s(),d(w.$$.fragment),v=s(),J=i("div"),J.innerHTML=wt,No=s(),d(oe.$$.fragment),Fo=s(),ne=i("p"),ne.innerHTML=Jt,Wo=s(),te=i("p"),te.textContent=Ut,Oo=s(),se=i("p"),se.textContent=jt,Ao=s(),ae=i("p"),ae.innerHTML=It,Xo=s(),O=i("img"),Vo=s(),ie=i("small"),ie.innerHTML=Lt,Ro=s(),re=i("p"),re.textContent=xt,Qo=s(),le=i("ul"),le.innerHTML=zt,Po=s(),d(A.$$.fragment),Eo=s(),d(ce.$$.fragment),Yo=s(),de=i("p"),de.innerHTML=kt,Ho=s(),me=i("p"),me.innerHTML=$t,So=s(),pe=i("ul"),pe.innerHTML=qt,Do=s(),he=i("p"),he.innerHTML=Zt,Ko=s(),d(ge.$$.fragment),en=s(),ue=i("p"),ue.innerHTML=Gt,on=s(),fe=i("p"),fe.innerHTML=Bt,nn=s(),d(ve.$$.fragment),tn=s(),d(_e.$$.fragment),sn=s(),Me=i("p"),Me.innerHTML=Nt,an=s(),d(ye.$$.fragment),rn=s(),d(Te.$$.fragment),ln=s(),be=i("p"),be.textContent=Ft,cn=s(),d(we.$$.fragment),dn=s(),d(Je.$$.fragment),mn=s(),Ue=i("p"),Ue.textContent=Wt,pn=s(),d(je.$$.fragment),hn=s(),d(Ie.$$.fragment),gn=s(),d(Ce.$$.fragment),un=s(),Le=i("p"),Le.innerHTML=Ot,fn=s(),d(X.$$.fragment),vn=s(),xe=i("p"),xe.textContent=At,_n=s(),d(ze.$$.fragment),Mn=s(),d(ke.$$.fragment),yn=s(),$e=i("p"),$e.innerHTML=Xt,Tn=s(),d(qe.$$.fragment),bn=s(),d(Ze.$$.fragment),wn=s(),k=i("div"),d(Ge.$$.fragment),Rn=s(),po=i("p"),po.innerHTML=Vt,Qn=s(),ho=i("p"),ho.innerHTML=Rt,Pn=s(),d(V.$$.fragment),Jn=s(),d(Be.$$.fragment),Un=s(),L=i("div"),d(Ne.$$.fragment),En=s(),go=i("p"),go.textContent=Qt,Yn=s(),uo=i("p"),uo.innerHTML=Pt,Hn=s(),R=i("div"),d(Fe.$$.fragment),Sn=s(),fo=i("p"),fo.innerHTML=Et,Dn=s(),Q=i("div"),d(We.$$.fragment),Kn=s(),vo=i("p"),vo.innerHTML=Yt,jn=s(),d(Oe.$$.fragment),In=s(),Z=i("div"),d(Ae.$$.fragment),et=s(),_o=i("p"),_o.innerHTML=Ht,ot=s(),Mo=i("div"),d(Xe.$$.fragment),Cn=s(),d(Ve.$$.fragment),Ln=s(),G=i("div"),d(Re.$$.fragment),nt=s(),yo=i("p"),yo.textContent=St,tt=s(),To=i("div"),d(Qe.$$.fragment),xn=s(),d(Pe.$$.fragment),zn=s(),Ee=i("div"),d(Ye.$$.fragment),kn=s(),d(He.$$.fragment),$n=s(),Se=i("div"),d(De.$$.fragment),qn=s(),d(Ke.$$.fragment),Zn=s(),b=i("div"),d(eo.$$.fragment),st=s(),bo=i("p"),bo.textContent=Dt,at=s(),wo=i("p"),wo.innerHTML=Kt,it=s(),Jo=i("p"),Jo.innerHTML=es,rt=s(),N=i("div"),d(oo.$$.fragment),lt=s(),Uo=i("p"),Uo.innerHTML=os,ct=s(),d(P.$$.fragment),dt=s(),E=i("div"),d(no.$$.fragment),mt=s(),jo=i("p"),jo.textContent=ns,pt=s(),Y=i("div"),d(to.$$.fragment),ht=s(),Io=i("p"),Io.textContent=ts,gt=s(),H=i("div"),d(so.$$.fragment),ut=s(),Co=i("p"),Co.textContent=ss,Gn=s(),d(ao.$$.fragment),Bn=s(),x=i("div"),d(io.$$.fragment),ft=s(),Lo=i("p"),Lo.textContent=as,vt=s(),xo=i("p"),xo.innerHTML=is,_t=s(),zo=i("p"),zo.innerHTML=rs,Mt=s(),q=i("div"),d(ro.$$.fragment),yt=s(),ko=i("p"),ko.innerHTML=ls,Tt=s(),d(S.$$.fragment),bt=s(),d(D.$$.fragment),Nn=s(),d(lo.$$.fragment),Fn=s(),Go=i("p"),this.h()},l(e){const o=_s("svelte-u9bgzb",document.head);c=r(o,"META",{name:!0,content:!0}),o.forEach(n),T=a(e),_=r(e,"P",{}),U(_).forEach(n),M=a(e),m(w.$$.fragment,e),v=a(e),J=r(e,"DIV",{class:!0,"data-svelte-h":!0}),f(J)!=="svelte-b95w5j"&&(J.innerHTML=wt),No=a(e),m(oe.$$.fragment,e),Fo=a(e),ne=r(e,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-41eoyp"&&(ne.innerHTML=Jt),Wo=a(e),te=r(e,"P",{"data-svelte-h":!0}),f(te)!=="svelte-zyuhly"&&(te.textContent=Ut),Oo=a(e),se=r(e,"P",{"data-svelte-h":!0}),f(se)!=="svelte-vfdo9a"&&(se.textContent=jt),Ao=a(e),ae=r(e,"P",{"data-svelte-h":!0}),f(ae)!=="svelte-e9kp7g"&&(ae.innerHTML=It),Xo=a(e),O=r(e,"IMG",{src:!0,alt:!0,width:!0}),Vo=a(e),ie=r(e,"SMALL",{"data-svelte-h":!0}),f(ie)!=="svelte-m653qt"&&(ie.innerHTML=Lt),Ro=a(e),re=r(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-axv494"&&(re.textContent=xt),Qo=a(e),le=r(e,"UL",{"data-svelte-h":!0}),f(le)!=="svelte-b32abk"&&(le.innerHTML=zt),Po=a(e),m(A.$$.fragment,e),Eo=a(e),m(ce.$$.fragment,e),Yo=a(e),de=r(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-pavm2p"&&(de.innerHTML=kt),Ho=a(e),me=r(e,"P",{"data-svelte-h":!0}),f(me)!=="svelte-1uqcr0x"&&(me.innerHTML=$t),So=a(e),pe=r(e,"UL",{"data-svelte-h":!0}),f(pe)!=="svelte-imbcrg"&&(pe.innerHTML=qt),Do=a(e),he=r(e,"P",{"data-svelte-h":!0}),f(he)!=="svelte-1aenua7"&&(he.innerHTML=Zt),Ko=a(e),m(ge.$$.fragment,e),en=a(e),ue=r(e,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-hqx9qk"&&(ue.innerHTML=Gt),on=a(e),fe=r(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-18dym15"&&(fe.innerHTML=Bt),nn=a(e),m(ve.$$.fragment,e),tn=a(e),m(_e.$$.fragment,e),sn=a(e),Me=r(e,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-19yw9ck"&&(Me.innerHTML=Nt),an=a(e),m(ye.$$.fragment,e),rn=a(e),m(Te.$$.fragment,e),ln=a(e),be=r(e,"P",{"data-svelte-h":!0}),f(be)!=="svelte-1f25s48"&&(be.textContent=Ft),cn=a(e),m(we.$$.fragment,e),dn=a(e),m(Je.$$.fragment,e),mn=a(e),Ue=r(e,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-1delota"&&(Ue.textContent=Wt),pn=a(e),m(je.$$.fragment,e),hn=a(e),m(Ie.$$.fragment,e),gn=a(e),m(Ce.$$.fragment,e),un=a(e),Le=r(e,"P",{"data-svelte-h":!0}),f(Le)!=="svelte-tychdj"&&(Le.innerHTML=Ot),fn=a(e),m(X.$$.fragment,e),vn=a(e),xe=r(e,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-gwf9h7"&&(xe.textContent=At),_n=a(e),m(ze.$$.fragment,e),Mn=a(e),m(ke.$$.fragment,e),yn=a(e),$e=r(e,"P",{"data-svelte-h":!0}),f($e)!=="svelte-ujer0t"&&($e.innerHTML=Xt),Tn=a(e),m(qe.$$.fragment,e),bn=a(e),m(Ze.$$.fragment,e),wn=a(e),k=r(e,"DIV",{class:!0});var B=U(k);m(Ge.$$.fragment,B),Rn=a(B),po=r(B,"P",{"data-svelte-h":!0}),f(po)!=="svelte-1ksh786"&&(po.innerHTML=Vt),Qn=a(B),ho=r(B,"P",{"data-svelte-h":!0}),f(ho)!=="svelte-o55m63"&&(ho.innerHTML=Rt),Pn=a(B),m(V.$$.fragment,B),B.forEach(n),Jn=a(e),m(Be.$$.fragment,e),Un=a(e),L=r(e,"DIV",{class:!0});var $=U(L);m(Ne.$$.fragment,$),En=a($),go=r($,"P",{"data-svelte-h":!0}),f(go)!=="svelte-13282x9"&&(go.textContent=Qt),Yn=a($),uo=r($,"P",{"data-svelte-h":!0}),f(uo)!=="svelte-1ucuqux"&&(uo.innerHTML=Pt),Hn=a($),R=r($,"DIV",{class:!0});var co=U(R);m(Fe.$$.fragment,co),Sn=a(co),fo=r(co,"P",{"data-svelte-h":!0}),f(fo)!=="svelte-1o9eza"&&(fo.innerHTML=Et),co.forEach(n),Dn=a($),Q=r($,"DIV",{class:!0});var mo=U(Q);m(We.$$.fragment,mo),Kn=a(mo),vo=r(mo,"P",{"data-svelte-h":!0}),f(vo)!=="svelte-kk16qw"&&(vo.innerHTML=Yt),mo.forEach(n),$.forEach(n),jn=a(e),m(Oe.$$.fragment,e),In=a(e),Z=r(e,"DIV",{class:!0});var W=U(Z);m(Ae.$$.fragment,W),et=a(W),_o=r(W,"P",{"data-svelte-h":!0}),f(_o)!=="svelte-shdmuq"&&(_o.innerHTML=Ht),ot=a(W),Mo=r(W,"DIV",{class:!0});var Bo=U(Mo);m(Xe.$$.fragment,Bo),Bo.forEach(n),W.forEach(n),Cn=a(e),m(Ve.$$.fragment,e),Ln=a(e),G=r(e,"DIV",{class:!0});var $o=U(G);m(Re.$$.fragment,$o),nt=a($o),yo=r($o,"P",{"data-svelte-h":!0}),f(yo)!=="svelte-1i8bg28"&&(yo.textContent=St),tt=a($o),To=r($o,"DIV",{class:!0});var cs=U(To);m(Qe.$$.fragment,cs),cs.forEach(n),$o.forEach(n),xn=a(e),m(Pe.$$.fragment,e),zn=a(e),Ee=r(e,"DIV",{class:!0});var ds=U(Ee);m(Ye.$$.fragment,ds),ds.forEach(n),kn=a(e),m(He.$$.fragment,e),$n=a(e),Se=r(e,"DIV",{class:!0});var ms=U(Se);m(De.$$.fragment,ms),ms.forEach(n),qn=a(e),m(Ke.$$.fragment,e),Zn=a(e),b=r(e,"DIV",{class:!0});var C=U(b);m(eo.$$.fragment,C),st=a(C),bo=r(C,"P",{"data-svelte-h":!0}),f(bo)!=="svelte-yttze"&&(bo.textContent=Dt),at=a(C),wo=r(C,"P",{"data-svelte-h":!0}),f(wo)!=="svelte-6pahdo"&&(wo.innerHTML=Kt),it=a(C),Jo=r(C,"P",{"data-svelte-h":!0}),f(Jo)!=="svelte-hswkmf"&&(Jo.innerHTML=es),rt=a(C),N=r(C,"DIV",{class:!0});var qo=U(N);m(oo.$$.fragment,qo),lt=a(qo),Uo=r(qo,"P",{"data-svelte-h":!0}),f(Uo)!=="svelte-1derpum"&&(Uo.innerHTML=os),ct=a(qo),m(P.$$.fragment,qo),qo.forEach(n),dt=a(C),E=r(C,"DIV",{class:!0});var On=U(E);m(no.$$.fragment,On),mt=a(On),jo=r(On,"P",{"data-svelte-h":!0}),f(jo)!=="svelte-1vzo9k5"&&(jo.textContent=ns),On.forEach(n),pt=a(C),Y=r(C,"DIV",{class:!0});var An=U(Y);m(to.$$.fragment,An),ht=a(An),Io=r(An,"P",{"data-svelte-h":!0}),f(Io)!=="svelte-1ph15fp"&&(Io.textContent=ts),An.forEach(n),gt=a(C),H=r(C,"DIV",{class:!0});var Xn=U(H);m(so.$$.fragment,Xn),ut=a(Xn),Co=r(Xn,"P",{"data-svelte-h":!0}),f(Co)!=="svelte-1rwyyz6"&&(Co.textContent=ss),Xn.forEach(n),C.forEach(n),Gn=a(e),m(ao.$$.fragment,e),Bn=a(e),x=r(e,"DIV",{class:!0});var F=U(x);m(io.$$.fragment,F),ft=a(F),Lo=r(F,"P",{"data-svelte-h":!0}),f(Lo)!=="svelte-1sybkd5"&&(Lo.textContent=as),vt=a(F),xo=r(F,"P",{"data-svelte-h":!0}),f(xo)!=="svelte-6pahdo"&&(xo.innerHTML=is),_t=a(F),zo=r(F,"P",{"data-svelte-h":!0}),f(zo)!=="svelte-hswkmf"&&(zo.innerHTML=rs),Mt=a(F),q=r(F,"DIV",{class:!0});var K=U(q);m(ro.$$.fragment,K),yt=a(K),ko=r(K,"P",{"data-svelte-h":!0}),f(ko)!=="svelte-asuqaw"&&(ko.innerHTML=ls),Tt=a(K),m(S.$$.fragment,K),bt=a(K),m(D.$$.fragment,K),K.forEach(n),F.forEach(n),Nn=a(e),m(lo.$$.fragment,e),Fn=a(e),Go=r(e,"P",{}),U(Go).forEach(n),this.h()},h(){y(c,"name","hf:doc:metadata"),y(c,"content",Is),y(J,"class","flex flex-wrap space-x-1"),gs(O.src,Ct="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/llava-ov-acrhitecture.png")||y(O,"src",Ct),y(O,"alt","drawing"),y(O,"width","600"),y(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Mo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(To,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){l(document.head,c),t(e,T,o),t(e,_,o),t(e,M,o),p(w,e,o),t(e,v,o),t(e,J,o),t(e,No,o),p(oe,e,o),t(e,Fo,o),t(e,ne,o),t(e,Wo,o),t(e,te,o),t(e,Oo,o),t(e,se,o),t(e,Ao,o),t(e,ae,o),t(e,Xo,o),t(e,O,o),t(e,Vo,o),t(e,ie,o),t(e,Ro,o),t(e,re,o),t(e,Qo,o),t(e,le,o),t(e,Po,o),p(A,e,o),t(e,Eo,o),p(ce,e,o),t(e,Yo,o),t(e,de,o),t(e,Ho,o),t(e,me,o),t(e,So,o),t(e,pe,o),t(e,Do,o),t(e,he,o),t(e,Ko,o),p(ge,e,o),t(e,en,o),t(e,ue,o),t(e,on,o),t(e,fe,o),t(e,nn,o),p(ve,e,o),t(e,tn,o),p(_e,e,o),t(e,sn,o),t(e,Me,o),t(e,an,o),p(ye,e,o),t(e,rn,o),p(Te,e,o),t(e,ln,o),t(e,be,o),t(e,cn,o),p(we,e,o),t(e,dn,o),p(Je,e,o),t(e,mn,o),t(e,Ue,o),t(e,pn,o),p(je,e,o),t(e,hn,o),p(Ie,e,o),t(e,gn,o),p(Ce,e,o),t(e,un,o),t(e,Le,o),t(e,fn,o),p(X,e,o),t(e,vn,o),t(e,xe,o),t(e,_n,o),p(ze,e,o),t(e,Mn,o),p(ke,e,o),t(e,yn,o),t(e,$e,o),t(e,Tn,o),p(qe,e,o),t(e,bn,o),p(Ze,e,o),t(e,wn,o),t(e,k,o),p(Ge,k,null),l(k,Rn),l(k,po),l(k,Qn),l(k,ho),l(k,Pn),p(V,k,null),t(e,Jn,o),p(Be,e,o),t(e,Un,o),t(e,L,o),p(Ne,L,null),l(L,En),l(L,go),l(L,Yn),l(L,uo),l(L,Hn),l(L,R),p(Fe,R,null),l(R,Sn),l(R,fo),l(L,Dn),l(L,Q),p(We,Q,null),l(Q,Kn),l(Q,vo),t(e,jn,o),p(Oe,e,o),t(e,In,o),t(e,Z,o),p(Ae,Z,null),l(Z,et),l(Z,_o),l(Z,ot),l(Z,Mo),p(Xe,Mo,null),t(e,Cn,o),p(Ve,e,o),t(e,Ln,o),t(e,G,o),p(Re,G,null),l(G,nt),l(G,yo),l(G,tt),l(G,To),p(Qe,To,null),t(e,xn,o),p(Pe,e,o),t(e,zn,o),t(e,Ee,o),p(Ye,Ee,null),t(e,kn,o),p(He,e,o),t(e,$n,o),t(e,Se,o),p(De,Se,null),t(e,qn,o),p(Ke,e,o),t(e,Zn,o),t(e,b,o),p(eo,b,null),l(b,st),l(b,bo),l(b,at),l(b,wo),l(b,it),l(b,Jo),l(b,rt),l(b,N),p(oo,N,null),l(N,lt),l(N,Uo),l(N,ct),p(P,N,null),l(b,dt),l(b,E),p(no,E,null),l(E,mt),l(E,jo),l(b,pt),l(b,Y),p(to,Y,null),l(Y,ht),l(Y,Io),l(b,gt),l(b,H),p(so,H,null),l(H,ut),l(H,Co),t(e,Gn,o),p(ao,e,o),t(e,Bn,o),t(e,x,o),p(io,x,null),l(x,ft),l(x,Lo),l(x,vt),l(x,xo),l(x,_t),l(x,zo),l(x,Mt),l(x,q),p(ro,q,null),l(q,yt),l(q,ko),l(q,Tt),p(S,q,null),l(q,bt),p(D,q,null),t(e,Nn,o),p(lo,e,o),t(e,Fn,o),t(e,Go,o),Wn=!0},p(e,[o]){const B={};o&2&&(B.$$scope={dirty:o,ctx:e}),A.$set(B);const $={};o&2&&($.$$scope={dirty:o,ctx:e}),X.$set($);const co={};o&2&&(co.$$scope={dirty:o,ctx:e}),V.$set(co);const mo={};o&2&&(mo.$$scope={dirty:o,ctx:e}),P.$set(mo);const W={};o&2&&(W.$$scope={dirty:o,ctx:e}),S.$set(W);const Bo={};o&2&&(Bo.$$scope={dirty:o,ctx:e}),D.$set(Bo)},i(e){Wn||(h(w.$$.fragment,e),h(oe.$$.fragment,e),h(A.$$.fragment,e),h(ce.$$.fragment,e),h(ge.$$.fragment,e),h(ve.$$.fragment,e),h(_e.$$.fragment,e),h(ye.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),h(je.$$.fragment,e),h(Ie.$$.fragment,e),h(Ce.$$.fragment,e),h(X.$$.fragment,e),h(ze.$$.fragment,e),h(ke.$$.fragment,e),h(qe.$$.fragment,e),h(Ze.$$.fragment,e),h(Ge.$$.fragment,e),h(V.$$.fragment,e),h(Be.$$.fragment,e),h(Ne.$$.fragment,e),h(Fe.$$.fragment,e),h(We.$$.fragment,e),h(Oe.$$.fragment,e),h(Ae.$$.fragment,e),h(Xe.$$.fragment,e),h(Ve.$$.fragment,e),h(Re.$$.fragment,e),h(Qe.$$.fragment,e),h(Pe.$$.fragment,e),h(Ye.$$.fragment,e),h(He.$$.fragment,e),h(De.$$.fragment,e),h(Ke.$$.fragment,e),h(eo.$$.fragment,e),h(oo.$$.fragment,e),h(P.$$.fragment,e),h(no.$$.fragment,e),h(to.$$.fragment,e),h(so.$$.fragment,e),h(ao.$$.fragment,e),h(io.$$.fragment,e),h(ro.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(lo.$$.fragment,e),Wn=!0)},o(e){g(w.$$.fragment,e),g(oe.$$.fragment,e),g(A.$$.fragment,e),g(ce.$$.fragment,e),g(ge.$$.fragment,e),g(ve.$$.fragment,e),g(_e.$$.fragment,e),g(ye.$$.fragment,e),g(Te.$$.fragment,e),g(we.$$.fragment,e),g(Je.$$.fragment,e),g(je.$$.fragment,e),g(Ie.$$.fragment,e),g(Ce.$$.fragment,e),g(X.$$.fragment,e),g(ze.$$.fragment,e),g(ke.$$.fragment,e),g(qe.$$.fragment,e),g(Ze.$$.fragment,e),g(Ge.$$.fragment,e),g(V.$$.fragment,e),g(Be.$$.fragment,e),g(Ne.$$.fragment,e),g(Fe.$$.fragment,e),g(We.$$.fragment,e),g(Oe.$$.fragment,e),g(Ae.$$.fragment,e),g(Xe.$$.fragment,e),g(Ve.$$.fragment,e),g(Re.$$.fragment,e),g(Qe.$$.fragment,e),g(Pe.$$.fragment,e),g(Ye.$$.fragment,e),g(He.$$.fragment,e),g(De.$$.fragment,e),g(Ke.$$.fragment,e),g(eo.$$.fragment,e),g(oo.$$.fragment,e),g(P.$$.fragment,e),g(no.$$.fragment,e),g(to.$$.fragment,e),g(so.$$.fragment,e),g(ao.$$.fragment,e),g(io.$$.fragment,e),g(ro.$$.fragment,e),g(S.$$.fragment,e),g(D.$$.fragment,e),g(lo.$$.fragment,e),Wn=!1},d(e){e&&(n(T),n(_),n(M),n(v),n(J),n(No),n(Fo),n(ne),n(Wo),n(te),n(Oo),n(se),n(Ao),n(ae),n(Xo),n(O),n(Vo),n(ie),n(Ro),n(re),n(Qo),n(le),n(Po),n(Eo),n(Yo),n(de),n(Ho),n(me),n(So),n(pe),n(Do),n(he),n(Ko),n(en),n(ue),n(on),n(fe),n(nn),n(tn),n(sn),n(Me),n(an),n(rn),n(ln),n(be),n(cn),n(dn),n(mn),n(Ue),n(pn),n(hn),n(gn),n(un),n(Le),n(fn),n(vn),n(xe),n(_n),n(Mn),n(yn),n($e),n(Tn),n(bn),n(wn),n(k),n(Jn),n(Un),n(L),n(jn),n(In),n(Z),n(Cn),n(Ln),n(G),n(xn),n(zn),n(Ee),n(kn),n($n),n(Se),n(qn),n(Zn),n(b),n(Gn),n(Bn),n(x),n(Nn),n(Fn),n(Go)),n(c),u(w,e),u(oe,e),u(A,e),u(ce,e),u(ge,e),u(ve,e),u(_e,e),u(ye,e),u(Te,e),u(we,e),u(Je,e),u(je,e),u(Ie,e),u(Ce,e),u(X,e),u(ze,e),u(ke,e),u(qe,e),u(Ze,e),u(Ge),u(V),u(Be,e),u(Ne),u(Fe),u(We),u(Oe,e),u(Ae),u(Xe),u(Ve,e),u(Re),u(Qe),u(Pe,e),u(Ye),u(He,e),u(De),u(Ke,e),u(eo),u(oo),u(P),u(no),u(to),u(so),u(ao,e),u(io),u(ro),u(S),u(D),u(lo,e)}}}const Is='{"title":"LLaVA-OneVision","local":"llava-onevision","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Formatting Prompts with Chat Templates","local":"formatting-prompts-with-chat-templates","sections":[],"depth":3}],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single image inference","local":"single-image-inference","sections":[],"depth":3},{"title":"Multi image inference","local":"multi-image-inference","sections":[],"depth":3},{"title":"Video inference","local":"video-inference","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using bitsandbytes","local":"quantization-using-bitsandbytes","sections":[],"depth":3},{"title":"Use Flash-Attention 2 to further speed-up generation","local":"use-flash-attention-2-to-further-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"LlavaOnevisionConfig","local":"transformers.LlavaOnevisionConfig","sections":[],"depth":2},{"title":"LlavaOnevisionProcessor","local":"transformers.LlavaOnevisionProcessor","sections":[],"depth":2},{"title":"LlavaOnevisionImageProcessor","local":"transformers.LlavaOnevisionImageProcessor","sections":[],"depth":2},{"title":"LlavaOnevisionImageProcessorFast","local":"transformers.LlavaOnevisionImageProcessorFast","sections":[],"depth":2},{"title":"LlavaOnevisionVideoProcessor","local":"transformers.LlavaOnevisionVideoProcessor","sections":[],"depth":2},{"title":"LlavaOnevisionVideoProcessor","local":"transformers.LlavaOnevisionVideoProcessor","sections":[],"depth":2},{"title":"LlavaOnevisionModel","local":"transformers.LlavaOnevisionModel","sections":[],"depth":2},{"title":"LlavaOnevisionForConditionalGeneration","local":"transformers.LlavaOnevisionForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Cs(z){return us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bs extends fs{constructor(c){super(),vs(this,c,Cs,js,hs,{})}}export{Bs as component};
